use strict;
use warnings;
use Test::More;
use DOCSIS::ConfigFile qw(encode_docsis decode_docsis);

plan skip_all =>
  'http://sourceforge.net/projects/net-snmp/files/net-snmp/5.7.2/net-snmp-5.7.2.tar.gz/download'
  unless DOCSIS::ConfigFile::CAN_TRANSLATE_OID;

my $config = {
  NetworkAccess => 1,
  MaxCPE        => 2,
  DsServiceFlow => {
    MaxRateSustained => 27000000,
    QosParamSetType  => 7,
    TrafficPriority  => 4,
    DsServiceFlowRef => 101,
    MaxTrafficBurst  => 3044,
  },
  UsServiceFlow => {
    MaxRateSustained     => 11000000,
    MaxTrafficBurst      => 8000,
    MaxConcatenatedBurst => 8000,
    UsServiceFlowRef     => 1,
    SchedulingType       => 2,
    TrafficPriority      => 4,
    QosParamSetType      => 7,
  },
  DocsisTwoEnable     => 1,
  GlobalPrivacyEnable => 1,
  SnmpMibObject       => [
    {oid => 'docsDevNmAccessIp.1',             IPADDRESS => '10.0.0.1'},
    {oid => 'docsDevNmAccessIpMask.1',         IPADDRESS => '255.255.255.255'},
    {oid => 'docsDevNmAccessCommunity.1',      STRING    => 'public'},
    {oid => 'docsDevNmAccessControl.1',        INTEGER   => 3},
    {oid => 'docsDevNmAccessStatus.1',         INTEGER   => 4},
    {oid => 'docsDevNmAccessIp.10',            IPADDRESS => '10.0.0.1'},
    {oid => 'docsDevNmAccessIpMask.10',        IPADDRESS => '255.255.255.240'},
    {oid => 'docsDevNmAccessCommunity.10',     STRING    => 'public'},
    {oid => 'docsDevNmAccessControl.10',       INTEGER   => 3},
    {oid => 'docsDevNmAccessStatus.10',        INTEGER   => 4},
    {oid => 'docsDevNmAccessIp.20',            IPADDRESS => '10.0.1.1'},
    {oid => 'docsDevNmAccessIpMask.20',        IPADDRESS => '255.255.255.240'},
    {oid => 'docsDevNmAccessCommunity.20',     STRING    => 'public'},
    {oid => 'docsDevNmAccessControl.20',       INTEGER   => 3},
    {oid => 'docsDevNmAccessInterfaces.20',    STRING    => 0x4000},
    {oid => 'docsDevNmAccessStatus.20',        INTEGER   => 4},
    {oid => 'docsDevNmAccessIp.25',            IPADDRESS => '10.0.2.1'},
    {oid => 'docsDevNmAccessIpMask.25',        IPADDRESS => '255.255.255.240'},
    {oid => 'docsDevNmAccessCommunity.25',     STRING    => 'public'},
    {oid => 'docsDevNmAccessControl.25',       INTEGER   => 3},
    {oid => 'docsDevNmAccessInterfaces.25',    STRING    => 0x4000},
    {oid => 'docsDevNmAccessStatus.25',        INTEGER   => 4},
    {oid => 'docsDevFilterIpStatus.1',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.1',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.1',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.1',      INTEGER   => 3},
    {oid => 'docsDevFilterIpBroadcast.1',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.1',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.1',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.1',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.1',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.1',       INTEGER   => 6},
    {oid => 'docsDevFilterIpSourcePortLow.1',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.1', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.1',    INTEGER   => 135},
    {oid => 'docsDevFilterIpDestPortHigh.1',   INTEGER   => 139},
    {oid => 'docsDevFilterIpStatus.2',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.2',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.2',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.2',      INTEGER   => 3},
    {oid => 'docsDevFilterIpBroadcast.2',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.2',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.2',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.2',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.2',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.2',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.2',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.2', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.2',    INTEGER   => 135},
    {oid => 'docsDevFilterIpDestPortHigh.2',   INTEGER   => 139},
    {oid => 'docsDevFilterIpStatus.3',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.3',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.3',        INTEGER   => 1},
    {oid => 'docsDevFilterIpDirection.3',      INTEGER   => 1},
    {oid => 'docsDevFilterIpBroadcast.3',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.3',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.3',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.3',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.3',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.3',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.3',  INTEGER   => 67},
    {oid => 'docsDevFilterIpSourcePortHigh.3', INTEGER   => 67},
    {oid => 'docsDevFilterIpDestPortLow.3',    INTEGER   => 0},
    {oid => 'docsDevFilterIpDestPortHigh.3',   INTEGER   => 65535},
    {oid => 'docsDevFilterIpStatus.4',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.4',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.4',        INTEGER   => 1},
    {oid => 'docsDevFilterIpDirection.4',      INTEGER   => 2},
    {oid => 'docsDevFilterIpBroadcast.4',      INTEGER   => 1},
    {oid => 'docsDevFilterIpSaddr.4',          IPADDRESS => '10.0.1.1'},
    {oid => 'docsDevFilterIpSmask.4',          IPADDRESS => '255.255.255.255'},
    {oid => 'docsDevFilterIpDaddr.4',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.4',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.4',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.4',  INTEGER   => 67},
    {oid => 'docsDevFilterIpSourcePortHigh.4', INTEGER   => 67},
    {oid => 'docsDevFilterIpDestPortLow.4',    INTEGER   => 0},
    {oid => 'docsDevFilterIpDestPortHigh.4',   INTEGER   => 65535},
    {oid => 'docsDevFilterIpStatus.5',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.5',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.5',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.5',      INTEGER   => 1},
    {oid => 'docsDevFilterIpBroadcast.5',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.5',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.5',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.5',          IPADDRESS => '224.0.0.0'},
    {oid => 'docsDevFilterIpDmask.5',          IPADDRESS => '240.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.5',       INTEGER   => 256},
    {oid => 'docsDevFilterIpSourcePortLow.5',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.5', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.5',    INTEGER   => 0},
    {oid => 'docsDevFilterIpDestPortHigh.5',   INTEGER   => 65535},
    {oid => 'docsDevFilterIpStatus.6',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.6',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.6',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.6',      INTEGER   => 3},
    {oid => 'docsDevFilterIpBroadcast.6',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.6',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.6',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.6',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.6',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.6',       INTEGER   => 6},
    {oid => 'docsDevFilterIpSourcePortLow.6',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.6', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.6',    INTEGER   => 445},
    {oid => 'docsDevFilterIpDestPortHigh.6',   INTEGER   => 445},
    {oid => 'docsDevFilterIpStatus.7',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.7',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.7',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.7',      INTEGER   => 3},
    {oid => 'docsDevFilterIpBroadcast.7',      INTEGER   => 2},
    {oid => 'docsDevFilterIpSaddr.7',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpSmask.7',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDaddr.7',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpDmask.7',          IPADDRESS => '0.0.0.0'},
    {oid => 'docsDevFilterIpProtocol.7',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.7',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.7', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.7',    INTEGER   => 445},
    {oid => 'docsDevFilterIpDestPortHigh.7',   INTEGER   => 445},
    {oid => 'docsDevFilterIpStatus.8',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.8',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.8',        INTEGER   => 1},
    {oid => 'docsDevFilterIpDirection.8',      INTEGER   => 2},
    {oid => 'docsDevFilterIpBroadcast.8',      INTEGER   => 1},
    {oid => 'docsDevFilterIpProtocol.8',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.8',  INTEGER   => 67},
    {oid => 'docsDevFilterIpSourcePortHigh.8', INTEGER   => 67},
    {oid => 'docsDevFilterIpDestPortLow.8',    INTEGER   => 0},
    {oid => 'docsDevFilterIpDestPortHigh.8',   INTEGER   => 65535},
    {oid => 'docsDevFilterIpStatus.9',         INTEGER   => 4},
    {oid => 'docsDevFilterIpControl.9',        INTEGER   => 1},
    {oid => 'docsDevFilterIpIfIndex.9',        INTEGER   => 0},
    {oid => 'docsDevFilterIpDirection.9',      INTEGER   => 1},
    {oid => 'docsDevFilterIpBroadcast.9',      INTEGER   => 2},
    {oid => 'docsDevFilterIpProtocol.9',       INTEGER   => 17},
    {oid => 'docsDevFilterIpSourcePortLow.9',  INTEGER   => 0},
    {oid => 'docsDevFilterIpSourcePortHigh.9', INTEGER   => 65535},
    {oid => 'docsDevFilterIpDestPortLow.9',    INTEGER   => 1900},
    {oid => 'docsDevFilterIpDestPortHigh.9',   INTEGER   => 1900},
    {oid => 'enterprises.1166.1.19.3.1.25.0',  INTEGER   => 1},
    {oid => 'docsDevFilterIpDefault.0',        INTEGER   => 2},
  ],
  SwUpgradeFilename => 'CVC060424.p7b',
  SwUpgradeServer   => '1.2.3.4',
};

{
  my $bytes = encode_docsis $config;
  is length $bytes, 3252, 'encode_docsis';

  local $config->{CmtsMic}    = '0xc4b55d540f468a5cf72fb70039625a4c';
  local $config->{CmMic}      = '0xe2b0751ea83a833a792ab559b5abe643';
  local $config->{GenericTLV} = '';
  is_deeply decode_docsis($bytes), $config, 'decode_docsis';
}

done_testing;
