package WWW::Scraper::ISBN::Driver;

use 5.008;
use strict;
use warnings;
use Carp;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use WWW::Scraper::ISBN::Driver ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.13';


# Preloaded methods go here.
sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self = {};
	$self->{FOUND} = 0;
	$self->{VERBOSITY} = 0;
	$self->{BOOK} = undef;
	$self->{ERROR} = "";
	bless ($self, $class);
	return $self;
}

sub found {
	my $self = shift;
	if (@_) { $self->{FOUND} = shift };
	return $self->{FOUND};
}

sub verbosity {
        my $self = shift;
        if (@_) { $self->{VERBOSITY} = shift };
        return $self->{VERBOSITY};
}

sub book {
        my $self = shift;
        if (@_) { $self->{BOOK} = shift };
        return $self->{BOOK};
}        

sub error {
	my $self = shift;
	if (@_) { $self->{ERROR} = shift };
	return $self->{ERROR};
}

sub search {
	croak("Child class must overload 'search()' method.");
}

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

WWW::Scraper::ISBN::Driver - Driver class for WWW::Scraper::ISBN module.
  
=head1 SYNOPSIS

$driver = WWW::Scraper::ISBN->driver();
$driver->search($isbn);
if ($driver->found) { ... }
$driver->verbosity(1);
print $driver->book{'title'};
print $driver->error;

=head1 REQUIRES

Requires the following modules be installed:

Carp

=head1 DESCRIPTION

  This is a base class, all site-specific drivers should inherit its members and methods.  Driver 
subclasses named '$name' should be packaged as WWW::Scraper::ISBN::$name_Driver, e.g. 
WWW::Scraper::ISBN::LOC_Driver for LOC (Library of Congress) driver.  Each driver need only implement the 
search() method, though they may have as many other methods as they need to get their job done.  Only 
search() will be called by WWW::Scraper::ISBN->search().

=head2 STANDARD FIELDS

  It is important that the different drivers return at least a core set of information, though they may return 
additional information.  The following self-explanatory fields should exist in $driver->book:

author
title
isbn

Additional standard fields may be added in the future.  'volume' and 'edition' are common.  In some cases, there may be no 
information available for 'volume' or 'edition', and so these may be set to the empty string.  However, they must still 
be set in the hash! 

=head2 EXPIRATION

Due to the dynamic, ever-changing nature of the web, it is highly likely that the site from which many of these drivers glean 
their information will change.  Hopefully, driver maintainers will keep drivers up to date, but they will all expire, and may 
behave unexpectedly.  Keep this in mind if the driver continually returns weird results.

=head2 EXPORT

None by default.

=head1 METHODS

=head2 new()

Class constructor.  Creates new driver object and returns a reference to it.  Sets the following default 
values:
found = 0;
verbosity = 0;
book = undef;
error = "";

=head2 found() or found($bool)

if ($driver->found) { # ... }
$driver->found(1);

Accessor/Mutator method for handling the search status of this record.  This is 0 by default, and should 
only be set true if search was deemed successful and $driver->book contains appropriate information.

=head2 verbosity() or verbosity($level);

$driver->verbosity(3);
if ($driver->verbosity == 2) { print "blah blah blah"; }

Accessor/Mutator method for handling the verbosity level to be generated by this driver as it is going.  
This can be used to print useful information by the driver as it is running.

=head2 book() or book($hashref)

my $book = $driver->book;
print $book->{'title'}; 
print $book->{'author'};
$another_book = { 'title' => "Some book title",
                  'author' => "Author of some book"
                };
$driver->book( $another_book );

Accessor/Mutator method for handling the book information retrieved by the driver.  The driver should create an anonymous hash 
containing the standard fields.  WWW::Scraper::ISBN->search sets the WWW::Scraper::ISBN::Record->book() field to this value.

=head2 error() or error($error_string)

print $driver->error;
$driver->error("Invalid ISBN number, or some similar error.");

Accessor/Mutator method for handling any errors which occur during the search.  The search drivers may add errors to record
fields, which may be useful in gleaning information about failed searches.

=head2 search($isbn)

my $record = $driver->search("123456789X");

Searches for information on the given ISBN number.  Each driver must define its own search routine, doing whatever is necessary to 
retrieve the desired information.  If found, it should set $driver->found and $driver->book accordingly.

=head1 SEE ALSO

WWW::Scraper::ISBN
WWW::Scraper::ISBN::Record

No mailing list or website currently available.  Primary development done through CSX 
[http://csx.calvin.edu/].

=head1 AUTHOR

Andy Schamp, E<lt>ams5@calvin.edu<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2004 by Andy Schamp

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
