/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collection;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.StringBuilders;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;

public final class VerticalDatumTypes
implements CodeList.Filter {
    public static final VerticalDatumType ELLIPSOIDAL = VerticalDatumType.valueOf("ELLIPSOIDAL");
    public static final VerticalDatumType ORTHOMETRIC = VerticalDatumType.valueOf("ORTHOMETRIC");
    private static final VerticalDatumType[] TYPES = new VerticalDatumType[7];
    private static final short[] LEGACY_CODES = new short[Math.max(ELLIPSOIDAL.ordinal(), ORTHOMETRIC.ordinal()) + 1];
    private final StringBuilder datum;

    public static VerticalDatumType fromLegacy(int n) {
        return (n -= 2000) >= 0 && n < TYPES.length ? TYPES[n] : null;
    }

    public static int toLegacy(VerticalDatumType verticalDatumType) {
        int n;
        if (verticalDatumType != null && (n = verticalDatumType.ordinal()) >= 0 && n < LEGACY_CODES.length) {
            return LEGACY_CODES[n];
        }
        return 0;
    }

    public static VerticalDatumType guess(String string, Collection<? extends GenericName> collection, CoordinateSystemAxis coordinateSystemAxis) {
        VerticalDatumType verticalDatumType = VerticalDatumTypes.guess(string);
        if (verticalDatumType != null) {
            return verticalDatumType;
        }
        if (collection != null) {
            for (GenericName object : collection) {
                verticalDatumType = VerticalDatumTypes.guess(object.tip().toString());
                if (verticalDatumType == null) continue;
                return verticalDatumType;
            }
        }
        if (coordinateSystemAxis != null) {
            Unit<?> unit = coordinateSystemAxis.getUnit();
            if (Units.isLinear(unit)) {
                String string2 = coordinateSystemAxis.getAbbreviation();
                if (string2.length() == 1) {
                    AxisDirection axisDirection = AxisDirection.UP;
                    switch (string2.charAt(0)) {
                        case 'h': {
                            verticalDatumType = ELLIPSOIDAL;
                            break;
                        }
                        case 'H': {
                            verticalDatumType = VerticalDatumType.GEOIDAL;
                            break;
                        }
                        case 'D': {
                            verticalDatumType = VerticalDatumType.DEPTH;
                            axisDirection = AxisDirection.DOWN;
                            break;
                        }
                        default: {
                            return VerticalDatumType.OTHER_SURFACE;
                        }
                    }
                    if (axisDirection.equals(coordinateSystemAxis.getDirection())) {
                        return verticalDatumType;
                    }
                }
            } else if (Units.isPressure(unit)) {
                return VerticalDatumType.BAROMETRIC;
            }
        }
        return VerticalDatumType.OTHER_SURFACE;
    }

    private static VerticalDatumType guess(String string) {
        if (string != null) {
            int n;
            if (CharSequences.equalsFiltered("Mean Sea Level", string, Characters.Filter.LETTERS_AND_DIGITS, true)) {
                return VerticalDatumType.GEOIDAL;
            }
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (!Character.isLetter(n)) continue;
                return CodeList.valueOf(VerticalDatumType.class, new VerticalDatumTypes(string));
            }
        }
        return null;
    }

    private VerticalDatumTypes(String string) {
        int n;
        int n2 = string.length();
        this.datum = new StringBuilder(n2);
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            this.datum.appendCodePoint(Character.toUpperCase(n));
        }
        StringBuilders.toASCII(this.datum);
    }

    @Override
    public boolean accept(CodeList<?> codeList) {
        int n = this.datum.indexOf(codeList.name());
        return n == 0 || n >= 0 && Character.isWhitespace(this.datum.codePointBefore(n));
    }

    @Override
    public String codename() {
        return null;
    }

    static {
        block8: for (int n = 2000; n <= 2006; n = (int)((short)(n + 1))) {
            VerticalDatumType verticalDatumType;
            switch (n) {
                case 2000: {
                    verticalDatumType = VerticalDatumType.OTHER_SURFACE;
                    break;
                }
                case 2001: {
                    verticalDatumType = ORTHOMETRIC;
                    break;
                }
                case 2002: {
                    verticalDatumType = ELLIPSOIDAL;
                    break;
                }
                case 2003: {
                    verticalDatumType = VerticalDatumType.BAROMETRIC;
                    break;
                }
                case 2005: {
                    verticalDatumType = VerticalDatumType.GEOIDAL;
                    break;
                }
                case 2006: {
                    verticalDatumType = VerticalDatumType.DEPTH;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            VerticalDatumTypes.TYPES[n - 2000] = verticalDatumType;
            VerticalDatumTypes.LEGACY_CODES[verticalDatumType.ordinal()] = n;
        }
    }
}

