/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import org.gradle.api.Action;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.report.IncompatibleTypeReferenceReporter;

class PathBinderCreationListener
extends ModelBinding {
    private final Action<ModelBinding> bindAction;

    public PathBinderCreationListener(ModelRuleDescriptor descriptor, BindingPredicate predicate, boolean writable, Action<ModelBinding> bindAction) {
        super(descriptor, predicate, writable);
        this.bindAction = bindAction;
    }

    @Override
    public boolean canBindInState(ModelNode.State state) {
        return this.predicate.getReference().isUntyped() || state.isAtLeast(ModelNode.State.Discovered);
    }

    @Override
    public void doOnBind(ModelNodeInternal node) {
        if (!this.predicate.matches(node)) {
            throw new InvalidModelRuleException(this.referrer, (Throwable)((Object)new ModelRuleBindingException(IncompatibleTypeReferenceReporter.of(node, this.predicate.getReference().getType(), this.predicate.getReference().getDescription(), this.writable).asString())));
        }
        this.boundTo = node;
        this.bindAction.execute((Object)this);
    }
}

