# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :ivar start_time: Start time of the downtime.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the downtime.
    :vartype end_time: ~datetime.datetime
    :ivar events: List of Possible Cause of downtime.
    :vartype events: list[~azure.mgmt.web.v2016_03_01.models.DetectorAbnormalTimePeriod]
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2016_03_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "events": {"key": "events", "type": "[DetectorAbnormalTimePeriod]"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        events: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the downtime.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the downtime.
        :paramtype end_time: ~datetime.datetime
        :keyword events: List of Possible Cause of downtime.
        :paramtype events: list[~azure.mgmt.web.v2016_03_01.models.DetectorAbnormalTimePeriod]
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2016_03_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.events = events
        self.solutions = solutions


class AnalysisData(_serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :ivar source: Name of the Detector.
    :vartype source: str
    :ivar detector_definition: Detector Definition.
    :vartype detector_definition: ~azure.mgmt.web.v2016_03_01.models.DetectorDefinition
    :ivar metrics: Source Metrics.
    :vartype metrics: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSet]
    :ivar data: Additional Source Data.
    :vartype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
    :ivar detector_meta_data: Detector Meta Data.
    :vartype detector_meta_data: ~azure.mgmt.web.v2016_03_01.models.ResponseMetaData
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "detector_definition": {"key": "detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "metrics", "type": "[DiagnosticMetricSet]"},
        "data": {"key": "data", "type": "[[NameValuePair]]"},
        "detector_meta_data": {"key": "detectorMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        detector_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Name of the Detector.
        :paramtype source: str
        :keyword detector_definition: Detector Definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2016_03_01.models.DetectorDefinition
        :keyword metrics: Source Metrics.
        :paramtype metrics: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSet]
        :keyword data: Additional Source Data.
        :paramtype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
        :keyword detector_meta_data: Detector Meta Data.
        :paramtype detector_meta_data: ~azure.mgmt.web.v2016_03_01.models.ResponseMetaData
        """
        super().__init__(**kwargs)
        self.source = source
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.data = data
        self.detector_meta_data = detector_meta_data


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.kind = kind
        self.type: Optional[str] = None


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description: Optional[str] = None


class ApiDefinitionInfo(_serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class ApplicationStack(_serialization.Model):
    """Application stack.

    :ivar name: Application stack name.
    :vartype name: str
    :ivar display: Application stack display name.
    :vartype display: str
    :ivar dependency: Application stack dependency.
    :vartype dependency: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2016_03_01.models.StackMajorVersion]
    :ivar frameworks: List of frameworks associated with application stack.
    :vartype frameworks: list[~azure.mgmt.web.v2016_03_01.models.ApplicationStack]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "str"},
        "dependency": {"key": "dependency", "type": "str"},
        "major_versions": {"key": "majorVersions", "type": "[StackMajorVersion]"},
        "frameworks": {"key": "frameworks", "type": "[ApplicationStack]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional[str] = None,
        dependency: Optional[str] = None,
        major_versions: Optional[List["_models.StackMajorVersion"]] = None,
        frameworks: Optional[List["_models.ApplicationStack"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Application stack name.
        :paramtype name: str
        :keyword display: Application stack display name.
        :paramtype display: str
        :keyword dependency: Application stack dependency.
        :paramtype dependency: str
        :keyword major_versions: List of major versions available.
        :paramtype major_versions: list[~azure.mgmt.web.v2016_03_01.models.StackMajorVersion]
        :keyword frameworks: List of frameworks associated with application stack.
        :paramtype frameworks: list[~azure.mgmt.web.v2016_03_01.models.ApplicationStack]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.dependency = dependency
        self.major_versions = major_versions
        self.frameworks = frameworks


class ApplicationStackCollection(_serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.ApplicationStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationStack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ApplicationStack"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.ApplicationStack]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AppServiceEnvironment(_serialization.Model):
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the App Service Environment. Required.
    :vartype name: str
    :ivar location: Location of the App Service Environment, e.g. "West US". Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_03_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentStatus
    :ivar vnet_name: Name of the Virtual Network for the App Service Environment.
    :vartype vnet_name: str
    :ivar vnet_resource_group_name: Resource group of the Virtual Network.
    :vartype vnet_resource_group_name: str
    :ivar vnet_subnet_name: Subnet of the Virtual Network.
    :vartype vnet_subnet_name: str
    :ivar virtual_network: Description of the Virtual Network. Required.
    :vartype virtual_network: ~azure.mgmt.web.v2016_03_01.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", and
     "Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.web.v2016_03_01.models.InternalLoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar worker_pools: Description of worker pools with worker size IDs, VM sizes, and number of
     workers in each pool. Required.
    :vartype worker_pools: list[~azure.mgmt.web.v2016_03_01.models.WorkerPool]
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar database_edition: Edition of the metadata database for the App Service Environment, e.g.
     "Standard".
    :vartype database_edition: str
    :ivar database_service_objective: Service objective of the metadata database for the App
     Service Environment, e.g. "S0".
    :vartype database_service_objective: str
    :ivar upgrade_domains: Number of upgrade domains of the App Service Environment.
    :vartype upgrade_domains: int
    :ivar subscription_id: Subscription of the App Service Environment.
    :vartype subscription_id: str
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar last_action: Last deployment action on the App Service Environment.
    :vartype last_action: str
    :ivar last_action_result: Result of the last deployment action on the App Service Environment.
    :vartype last_action_result: str
    :ivar allowed_multi_sizes: List of comma separated strings describing which VM sizes are
     allowed for front-ends.
    :vartype allowed_multi_sizes: str
    :ivar allowed_worker_sizes: List of comma separated strings describing which VM sizes are
     allowed for workers.
    :vartype allowed_worker_sizes: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar vip_mappings: Description of IP SSL mapping for the App Service Environment.
    :vartype vip_mappings: list[~azure.mgmt.web.v2016_03_01.models.VirtualIPMapping]
    :ivar environment_capacities: Current total, used, and available worker capacities.
    :vartype environment_capacities: list[~azure.mgmt.web.v2016_03_01.models.StampCapacity]
    :ivar network_access_control_list: Access control list for controlling traffic to the App
     Service Environment.
    :vartype network_access_control_list:
     list[~azure.mgmt.web.v2016_03_01.models.NetworkAccessControlEntry]
    :ivar environment_is_healthy: True/false indicating whether the App Service Environment is
     healthy.
    :vartype environment_is_healthy: bool
    :ivar environment_status: Detailed message about with results of the last check of the App
     Service Environment.
    :vartype environment_status: str
    :ivar resource_group: Resource group of the App Service Environment.
    :vartype resource_group: str
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar default_front_end_scale_factor: Default Scale Factor for FrontEnds.
    :vartype default_front_end_scale_factor: int
    :ivar api_management_account_id: API Management Account associated with the App Service
     Environment.
    :vartype api_management_account_id: str
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar dynamic_cache_enabled: True/false indicating whether the App Service Environment is
     suspended. The environment can be suspended e.g. when the management endpoint is no longer
     available
     (most likely because NSG blocked the incoming traffic).
    :vartype dynamic_cache_enabled: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    """

    _validation = {
        "name": {"required": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "virtual_network": {"required": True},
        "worker_pools": {"required": True},
        "database_edition": {"readonly": True},
        "database_service_objective": {"readonly": True},
        "upgrade_domains": {"readonly": True},
        "subscription_id": {"readonly": True},
        "last_action": {"readonly": True},
        "last_action_result": {"readonly": True},
        "allowed_multi_sizes": {"readonly": True},
        "allowed_worker_sizes": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "vip_mappings": {"readonly": True},
        "environment_capacities": {"readonly": True},
        "environment_is_healthy": {"readonly": True},
        "environment_status": {"readonly": True},
        "resource_group": {"readonly": True},
        "default_front_end_scale_factor": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "vnet_resource_group_name": {"key": "vnetResourceGroupName", "type": "str"},
        "vnet_subnet_name": {"key": "vnetSubnetName", "type": "str"},
        "virtual_network": {"key": "virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "multiSize", "type": "str"},
        "multi_role_count": {"key": "multiRoleCount", "type": "int"},
        "worker_pools": {"key": "workerPools", "type": "[WorkerPool]"},
        "ipssl_address_count": {"key": "ipsslAddressCount", "type": "int"},
        "database_edition": {"key": "databaseEdition", "type": "str"},
        "database_service_objective": {"key": "databaseServiceObjective", "type": "str"},
        "upgrade_domains": {"key": "upgradeDomains", "type": "int"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "dns_suffix": {"key": "dnsSuffix", "type": "str"},
        "last_action": {"key": "lastAction", "type": "str"},
        "last_action_result": {"key": "lastActionResult", "type": "str"},
        "allowed_multi_sizes": {"key": "allowedMultiSizes", "type": "str"},
        "allowed_worker_sizes": {"key": "allowedWorkerSizes", "type": "str"},
        "maximum_number_of_machines": {"key": "maximumNumberOfMachines", "type": "int"},
        "vip_mappings": {"key": "vipMappings", "type": "[VirtualIPMapping]"},
        "environment_capacities": {"key": "environmentCapacities", "type": "[StampCapacity]"},
        "network_access_control_list": {"key": "networkAccessControlList", "type": "[NetworkAccessControlEntry]"},
        "environment_is_healthy": {"key": "environmentIsHealthy", "type": "bool"},
        "environment_status": {"key": "environmentStatus", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "front_end_scale_factor": {"key": "frontEndScaleFactor", "type": "int"},
        "default_front_end_scale_factor": {"key": "defaultFrontEndScaleFactor", "type": "int"},
        "api_management_account_id": {"key": "apiManagementAccountId", "type": "str"},
        "suspended": {"key": "suspended", "type": "bool"},
        "dynamic_cache_enabled": {"key": "dynamicCacheEnabled", "type": "bool"},
        "cluster_settings": {"key": "clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "userWhitelistedIpRanges", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        location: str,
        virtual_network: "_models.VirtualNetworkProfile",
        worker_pools: List["_models.WorkerPool"],
        vnet_name: Optional[str] = None,
        vnet_resource_group_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        internal_load_balancing_mode: Optional[Union[str, "_models.InternalLoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        multi_role_count: Optional[int] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        network_access_control_list: Optional[List["_models.NetworkAccessControlEntry"]] = None,
        front_end_scale_factor: Optional[int] = None,
        api_management_account_id: Optional[str] = None,
        suspended: Optional[bool] = None,
        dynamic_cache_enabled: Optional[bool] = None,
        cluster_settings: Optional[List["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the App Service Environment. Required.
        :paramtype name: str
        :keyword location: Location of the App Service Environment, e.g. "West US". Required.
        :paramtype location: str
        :keyword vnet_name: Name of the Virtual Network for the App Service Environment.
        :paramtype vnet_name: str
        :keyword vnet_resource_group_name: Resource group of the Virtual Network.
        :paramtype vnet_resource_group_name: str
        :keyword vnet_subnet_name: Subnet of the Virtual Network.
        :paramtype vnet_subnet_name: str
        :keyword virtual_network: Description of the Virtual Network. Required.
        :paramtype virtual_network: ~azure.mgmt.web.v2016_03_01.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", and
         "Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.web.v2016_03_01.models.InternalLoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword multi_role_count: Number of front-end instances.
        :paramtype multi_role_count: int
        :keyword worker_pools: Description of worker pools with worker size IDs, VM sizes, and number
         of workers in each pool. Required.
        :paramtype worker_pools: list[~azure.mgmt.web.v2016_03_01.models.WorkerPool]
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword network_access_control_list: Access control list for controlling traffic to the App
         Service Environment.
        :paramtype network_access_control_list:
         list[~azure.mgmt.web.v2016_03_01.models.NetworkAccessControlEntry]
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword api_management_account_id: API Management Account associated with the App Service
         Environment.
        :paramtype api_management_account_id: str
        :keyword suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
         otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
         management endpoint is no longer available
          (most likely because NSG blocked the incoming traffic).
        :paramtype suspended: bool
        :keyword dynamic_cache_enabled: True/false indicating whether the App Service Environment is
         suspended. The environment can be suspended e.g. when the management endpoint is no longer
         available
         (most likely because NSG blocked the incoming traffic).
        :paramtype dynamic_cache_enabled: bool
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added list of IP Ranges allowed on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional[Union[str, "_models.HostingEnvironmentStatus"]] = None
        self.vnet_name = vnet_name
        self.vnet_resource_group_name = vnet_resource_group_name
        self.vnet_subnet_name = vnet_subnet_name
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count = multi_role_count
        self.worker_pools = worker_pools
        self.ipssl_address_count = ipssl_address_count
        self.database_edition: Optional[str] = None
        self.database_service_objective: Optional[str] = None
        self.upgrade_domains: Optional[int] = None
        self.subscription_id: Optional[str] = None
        self.dns_suffix = dns_suffix
        self.last_action: Optional[str] = None
        self.last_action_result: Optional[str] = None
        self.allowed_multi_sizes: Optional[str] = None
        self.allowed_worker_sizes: Optional[str] = None
        self.maximum_number_of_machines: Optional[int] = None
        self.vip_mappings: Optional[List["_models.VirtualIPMapping"]] = None
        self.environment_capacities: Optional[List["_models.StampCapacity"]] = None
        self.network_access_control_list = network_access_control_list
        self.environment_is_healthy: Optional[bool] = None
        self.environment_status: Optional[str] = None
        self.resource_group: Optional[str] = None
        self.front_end_scale_factor = front_end_scale_factor
        self.default_front_end_scale_factor: Optional[int] = None
        self.api_management_account_id = api_management_account_id
        self.suspended = suspended
        self.dynamic_cache_enabled = dynamic_cache_enabled
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.kind = kind
        self.location = location
        self.type: Optional[str] = None
        self.tags = tags


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.web.v2016_03_01.models.SkuDescription
    :ivar name_properties_name: Name for the App Service plan.
    :vartype name_properties_name: str
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.web.v2016_03_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar admin_site_name: App Service plan administration site.
    :vartype admin_site_name: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2016_03_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "admin_site_name": {"key": "properties.adminSiteName", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.SkuDescription"] = None,
        name_properties_name: Optional[str] = None,
        worker_tier_name: Optional[str] = None,
        admin_site_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.web.v2016_03_01.models.SkuDescription
        :keyword name_properties_name: Name for the App Service plan.
        :paramtype name_properties_name: str
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword admin_site_name: App Service plan administration site.
        :paramtype admin_site_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.name_properties_name = name_properties_name
        self.worker_tier_name = worker_tier_name
        self.status: Optional[Union[str, "_models.StatusOptions"]] = None
        self.subscription: Optional[str] = None
        self.admin_site_name = admin_site_name
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers: Optional[int] = None
        self.geo_region: Optional[str] = None
        self.per_site_scaling = per_site_scaling
        self.number_of_sites: Optional[int] = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.resource_group: Optional[str] = None
        self.reserved = reserved
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class AppServicePlanCollection(_serialization.Model):
    """Collection of App Service plans.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServicePlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AppServicePlan"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.AppServicePlan]
        :keyword next_link: Link to next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AutoHealActions(_serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent", and
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.web.v2016_03_01.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.web.v2016_03_01.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "custom_action": {"key": "customAction", "type": "AutoHealCustomAction"},
        "min_process_execution_time": {"key": "minProcessExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         and "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.web.v2016_03_01.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.web.v2016_03_01.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(_serialization.Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(self, *, exe: Optional[str] = None, parameters: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(_serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.web.v2016_03_01.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.web.v2016_03_01.models.AutoHealActions
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "AutoHealTriggers"},
        "actions": {"key": "actions", "type": "AutoHealActions"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.web.v2016_03_01.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.web.v2016_03_01.models.AutoHealActions
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(_serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.web.v2016_03_01.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.web.v2016_03_01.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.web.v2016_03_01.models.SlowRequestsBasedTrigger
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "RequestsBasedTrigger"},
        "private_bytes_in_kb": {"key": "privateBytesInKB", "type": "int"},
        "status_codes": {"key": "statusCodes", "type": "[StatusCodesBasedTrigger]"},
        "slow_requests": {"key": "slowRequests", "type": "SlowRequestsBasedTrigger"},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[List["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.web.v2016_03_01.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes: list[~azure.mgmt.web.v2016_03_01.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.web.v2016_03_01.models.SlowRequestsBasedTrigger
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests


class BillingMeter(ProxyOnlyResource):
    """App Service billing entity that contains information about meter which the Azure billing system
    utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar meter_id: Meter GUID onboarded in Commerce.
    :vartype meter_id: str
    :ivar billing_location: Azure Location of billable resource.
    :vartype billing_location: str
    :ivar short_name: Short Name from App Service Azure pricing Page.
    :vartype short_name: str
    :ivar friendly_name: Friendly name of the meter.
    :vartype friendly_name: str
    :ivar resource_type: App Service resource type meter used for.
    :vartype resource_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "meter_id": {"key": "properties.meterId", "type": "str"},
        "billing_location": {"key": "properties.billingLocation", "type": "str"},
        "short_name": {"key": "properties.shortName", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        meter_id: Optional[str] = None,
        billing_location: Optional[str] = None,
        short_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword meter_id: Meter GUID onboarded in Commerce.
        :paramtype meter_id: str
        :keyword billing_location: Azure Location of billable resource.
        :paramtype billing_location: str
        :keyword short_name: Short Name from App Service Azure pricing Page.
        :paramtype short_name: str
        :keyword friendly_name: Friendly name of the meter.
        :paramtype friendly_name: str
        :keyword resource_type: App Service resource type meter used for.
        :paramtype resource_type: str
        """
        super().__init__(kind=kind, **kwargs)
        self.meter_id = meter_id
        self.billing_location = billing_location
        self.short_name = short_name
        self.friendly_name = friendly_name
        self.resource_type = resource_type


class BillingMeterCollection(_serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of Billing Meters. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BillingMeter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BillingMeter"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of Billing Meters. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.BillingMeter]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Capability(_serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar password: Certificate password.
    :vartype password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2016_03_01.models.KeyVaultSecretStatus
    :ivar geo_region: Region of the certificate.
    :vartype geo_region: str
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
        "geo_region": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "password": {"key": "properties.password", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.friendly_name: Optional[str] = None
        self.subject_name: Optional[str] = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name: Optional[str] = None
        self.self_link: Optional[str] = None
        self.issuer: Optional[str] = None
        self.issue_date: Optional[datetime.datetime] = None
        self.expiration_date: Optional[datetime.datetime] = None
        self.password = password
        self.thumbprint: Optional[str] = None
        self.valid: Optional[bool] = None
        self.cer_blob: Optional[bytes] = None
        self.public_key_hash: Optional[str] = None
        self.hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None
        self.geo_region: Optional[str] = None
        self.server_farm_id = server_farm_id


class CertificateCollection(_serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Certificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.Certificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar password: Certificate password.
    :vartype password: str
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2016_03_01.models.KeyVaultSecretStatus
    :ivar geo_region: Region of the certificate.
    :vartype geo_region: str
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
        "geo_region": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "password": {"key": "properties.password", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        host_names: Optional[List[str]] = None,
        pfx_blob: Optional[bytes] = None,
        password: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.friendly_name: Optional[str] = None
        self.subject_name: Optional[str] = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name: Optional[str] = None
        self.self_link: Optional[str] = None
        self.issuer: Optional[str] = None
        self.issue_date: Optional[datetime.datetime] = None
        self.expiration_date: Optional[datetime.datetime] = None
        self.password = password
        self.thumbprint: Optional[str] = None
        self.valid: Optional[bool] = None
        self.cer_blob: Optional[bytes] = None
        self.public_key_hash: Optional[str] = None
        self.hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None
        self.geo_region: Optional[str] = None
        self.server_farm_id = server_farm_id


class CloningInfo(_serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to server.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots. Required.
    :vartype source_web_app_id: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    :ivar ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
     :code:`<code>false</code>`.
    :vartype ignore_quotas: bool
    """

    _validation = {
        "source_web_app_id": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "overwrite": {"key": "overwrite", "type": "bool"},
        "clone_custom_host_names": {"key": "cloneCustomHostNames", "type": "bool"},
        "clone_source_control": {"key": "cloneSourceControl", "type": "bool"},
        "source_web_app_id": {"key": "sourceWebAppId", "type": "str"},
        "hosting_environment": {"key": "hostingEnvironment", "type": "str"},
        "app_settings_overrides": {"key": "appSettingsOverrides", "type": "{str}"},
        "configure_load_balancing": {"key": "configureLoadBalancing", "type": "bool"},
        "traffic_manager_profile_id": {"key": "trafficManagerProfileId", "type": "str"},
        "traffic_manager_profile_name": {"key": "trafficManagerProfileName", "type": "str"},
        "ignore_quotas": {"key": "ignoreQuotas", "type": "bool"},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[Dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        ignore_quotas: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots. Required.
        :paramtype source_web_app_id: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        :keyword ignore_quotas: :code:`<code>true</code>` if quotas should be ignored; otherwise,
         :code:`<code>false</code>`.
        :paramtype ignore_quotas: bool
        """
        super().__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name
        self.ignore_quotas = ignore_quotas


class ConnStringInfo(_serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.ConnectionStringType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class CorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
    }

    def __init__(self, *, allowed_origins: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins


class CsmMoveResourceEnvelope(_serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be
    moved to.

    :ivar target_resource_group:
    :vartype target_resource_group: str
    :ivar resources:
    :vartype resources: list[str]
    """

    _validation = {
        "target_resource_group": {"max_length": 90, "min_length": 1, "pattern": r" ^[-\w\._\(\)]+[^\.]$"},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "resources": {"key": "resources", "type": "[str]"},
    }

    def __init__(
        self, *, target_resource_group: Optional[str] = None, resources: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_group:
        :paramtype target_resource_group: str
        :keyword resources:
        :paramtype resources: list[str]
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class CsmOperationCollection(_serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmOperationDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmOperationDescription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.CsmOperationDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CsmOperationDescription(_serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2016_03_01.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2016_03_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "CsmOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "CsmOperationDescriptionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2016_03_01.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2016_03_01.models.CsmOperationDescriptionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(_serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2016_03_01.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2016_03_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(_serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmUsageQuota(_serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.web.v2016_03_01.models.LocalizableString
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "LocalizableString"},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: int
        :keyword limit: The resource limit.
        :paramtype limit: int
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.web.v2016_03_01.models.LocalizableString
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(_serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmUsageQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmUsageQuota"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.CsmUsageQuota]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DataSource(_serialization.Model):
    """Class representing data source used by the detectors.

    :ivar instructions: Instructions if any for the data source.
    :vartype instructions: list[str]
    :ivar data_source_uri: Datasource Uri Links.
    :vartype data_source_uri: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
    """

    _attribute_map = {
        "instructions": {"key": "instructions", "type": "[str]"},
        "data_source_uri": {"key": "dataSourceUri", "type": "[NameValuePair]"},
    }

    def __init__(
        self,
        *,
        instructions: Optional[List[str]] = None,
        data_source_uri: Optional[List["_models.NameValuePair"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instructions: Instructions if any for the data source.
        :paramtype instructions: list[str]
        :keyword data_source_uri: Datasource Uri Links.
        :paramtype data_source_uri: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
        """
        super().__init__(**kwargs)
        self.instructions = instructions
        self.data_source_uri = data_source_uri


class DataTableResponseColumn(_serialization.Model):
    """Column definition.

    :ivar column_name: Name of the column.
    :vartype column_name: str
    :ivar data_type: Data type which looks like 'String' or 'Int32'.
    :vartype data_type: str
    :ivar column_type: Column Type.
    :vartype column_type: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "column_type": {"key": "columnType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Name of the column.
        :paramtype column_name: str
        :keyword data_type: Data type which looks like 'String' or 'Int32'.
        :paramtype data_type: str
        :keyword column_type: Column Type.
        :paramtype column_type: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(_serialization.Model):
    """Data Table which defines columns and raw row values.

    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar columns: List of columns with data types.
    :vartype columns: list[~azure.mgmt.web.v2016_03_01.models.DataTableResponseColumn]
    :ivar rows: Raw row values.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "columns": {"key": "columns", "type": "[DataTableResponseColumn]"},
        "rows": {"key": "rows", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["_models.DataTableResponseColumn"]] = None,
        rows: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Name of the table.
        :paramtype table_name: str
        :keyword columns: List of columns with data types.
        :paramtype columns: list[~azure.mgmt.web.v2016_03_01.models.DataTableResponseColumn]
        :keyword rows: Raw row values.
        :paramtype rows: list[list[str]]
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultErrorResponse(_serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2016_03_01.models.DefaultErrorResponseError
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DefaultErrorResponseError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error: Optional["_models.DefaultErrorResponseError"] = None


class DefaultErrorResponseError(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.web.v2016_03_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[DefaultErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self, *, details: Optional[List["_models.DefaultErrorResponseErrorDetailsItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword details:
        :paramtype details:
         list[~azure.mgmt.web.v2016_03_01.models.DefaultErrorResponseErrorDetailsItem]
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details = details
        self.innererror: Optional[str] = None


class DefaultErrorResponseErrorDetailsItem(_serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None


class DeletedSite(_serialization.Model):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Numeric id for the deleted site.
    :vartype id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar name: Name of the deleted site.
    :vartype name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    """

    _validation = {
        "deleted_timestamp": {"readonly": True},
        "subscription": {"readonly": True},
        "resource_group": {"readonly": True},
        "name": {"readonly": True},
        "slot": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "deleted_timestamp": {"key": "deletedTimestamp", "type": "str"},
        "subscription": {"key": "subscription", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "slot": {"key": "slot", "type": "str"},
    }

    def __init__(self, *, id: Optional[int] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Numeric id for the deleted site.
        :paramtype id: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.deleted_timestamp: Optional[str] = None
        self.subscription: Optional[str] = None
        self.resource_group: Optional[str] = None
        self.name: Optional[str] = None
        self.slot: Optional[str] = None


class DeletedWebAppCollection(_serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedSite]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DeletedSite"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.DeletedSite]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentLocations(_serialization.Model):
    """List of available locations (regions or App Service Environments) for
    deployment of App Service resources.

    :ivar locations: Available regions.
    :vartype locations: list[~azure.mgmt.web.v2016_03_01.models.GeoRegion]
    :ivar hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :vartype hosting_environments: list[~azure.mgmt.web.v2016_03_01.models.AppServiceEnvironment]
    :ivar hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :vartype hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[GeoRegion]"},
        "hosting_environments": {"key": "hostingEnvironments", "type": "[AppServiceEnvironment]"},
        "hosting_environment_deployment_infos": {
            "key": "hostingEnvironmentDeploymentInfos",
            "type": "[HostingEnvironmentDeploymentInfo]",
        },
    }

    def __init__(
        self,
        *,
        locations: Optional[List["_models.GeoRegion"]] = None,
        hosting_environments: Optional[List["_models.AppServiceEnvironment"]] = None,
        hosting_environment_deployment_infos: Optional[List["_models.HostingEnvironmentDeploymentInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword locations: Available regions.
        :paramtype locations: list[~azure.mgmt.web.v2016_03_01.models.GeoRegion]
        :keyword hosting_environments: Available App Service Environments with full descriptions of the
         environments.
        :paramtype hosting_environments: list[~azure.mgmt.web.v2016_03_01.models.AppServiceEnvironment]
        :keyword hosting_environment_deployment_infos: Available App Service Environments with basic
         information.
        :paramtype hosting_environment_deployment_infos:
         list[~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentDeploymentInfo]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.hosting_environments = hosting_environments
        self.hosting_environment_deployment_infos = hosting_environment_deployment_infos


class DetectorAbnormalTimePeriod(_serialization.Model):
    """Class representing Abnormal Time Period detected.

    :ivar start_time: Start time of the correlated event.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the correlated event.
    :vartype end_time: ~datetime.datetime
    :ivar message: Message describing the event.
    :vartype message: str
    :ivar source: Represents the name of the Detector.
    :vartype source: str
    :ivar priority: Represents the rank of the Detector.
    :vartype priority: float
    :ivar meta_data: Downtime metadata.
    :vartype meta_data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
    :ivar type: Represents the type of the Detector. Known values are: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", and "Other".
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.IssueType
    :ivar solutions: List of proposed solutions.
    :vartype solutions: list[~azure.mgmt.web.v2016_03_01.models.Solution]
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "priority": {"key": "priority", "type": "float"},
        "meta_data": {"key": "metaData", "type": "[[NameValuePair]]"},
        "type": {"key": "type", "type": "str"},
        "solutions": {"key": "solutions", "type": "[Solution]"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        source: Optional[str] = None,
        priority: Optional[float] = None,
        meta_data: Optional[List[List["_models.NameValuePair"]]] = None,
        type: Optional[Union[str, "_models.IssueType"]] = None,
        solutions: Optional[List["_models.Solution"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the correlated event.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the correlated event.
        :paramtype end_time: ~datetime.datetime
        :keyword message: Message describing the event.
        :paramtype message: str
        :keyword source: Represents the name of the Detector.
        :paramtype source: str
        :keyword priority: Represents the rank of the Detector.
        :paramtype priority: float
        :keyword meta_data: Downtime metadata.
        :paramtype meta_data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
        :keyword type: Represents the type of the Detector. Known values are: "ServiceIncident",
         "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
         "PlatformIssue", and "Other".
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.IssueType
        :keyword solutions: List of proposed solutions.
        :paramtype solutions: list[~azure.mgmt.web.v2016_03_01.models.Solution]
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.message = message
        self.source = source
        self.priority = priority
        self.meta_data = meta_data
        self.type = type
        self.solutions = solutions


class DetectorDefinition(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "rank": {"readonly": True},
        "is_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "rank": {"key": "properties.rank", "type": "float"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.rank: Optional[float] = None
        self.is_enabled: Optional[bool] = None


class DetectorInfo(_serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar category: Support Category.
    :vartype category: str
    :ivar sub_category: Support Sub Category.
    :vartype sub_category: str
    :ivar support_topic_id: Support Topic Id.
    :vartype support_topic_id: str
    """

    _validation = {
        "description": {"readonly": True},
        "category": {"readonly": True},
        "sub_category": {"readonly": True},
        "support_topic_id": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "sub_category": {"key": "subCategory", "type": "str"},
        "support_topic_id": {"key": "supportTopicId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description: Optional[str] = None
        self.category: Optional[str] = None
        self.sub_category: Optional[str] = None
        self.support_topic_id: Optional[str] = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metadata: metadata for the detector.
    :vartype metadata: ~azure.mgmt.web.v2016_03_01.models.DetectorInfo
    :ivar dataset: Data Set.
    :vartype dataset: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticData]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DetectorInfo"},
        "dataset": {"key": "properties.dataset", "type": "[DiagnosticData]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.DetectorInfo"] = None,
        dataset: Optional[List["_models.DiagnosticData"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword metadata: metadata for the detector.
        :paramtype metadata: ~azure.mgmt.web.v2016_03_01.models.DetectorInfo
        :keyword dataset: Data Set.
        :paramtype dataset: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticData]
        """
        super().__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset


class DetectorResponseCollection(_serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.DetectorResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar abnormal_time_periods: List of time periods.
    :vartype abnormal_time_periods: list[~azure.mgmt.web.v2016_03_01.models.AbnormalTimePeriod]
    :ivar payload: Data by each detector.
    :vartype payload: list[~azure.mgmt.web.v2016_03_01.models.AnalysisData]
    :ivar non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :vartype non_correlated_detectors: list[~azure.mgmt.web.v2016_03_01.models.DetectorDefinition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[AbnormalTimePeriod]"},
        "payload": {"key": "properties.payload", "type": "[AnalysisData]"},
        "non_correlated_detectors": {"key": "properties.nonCorrelatedDetectors", "type": "[DetectorDefinition]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        abnormal_time_periods: Optional[List["_models.AbnormalTimePeriod"]] = None,
        payload: Optional[List["_models.AnalysisData"]] = None,
        non_correlated_detectors: Optional[List["_models.DetectorDefinition"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword abnormal_time_periods: List of time periods.
        :paramtype abnormal_time_periods: list[~azure.mgmt.web.v2016_03_01.models.AbnormalTimePeriod]
        :keyword payload: Data by each detector.
        :paramtype payload: list[~azure.mgmt.web.v2016_03_01.models.AnalysisData]
        :keyword non_correlated_detectors: Data by each detector for detectors that did not corelate.
        :paramtype non_correlated_detectors:
         list[~azure.mgmt.web.v2016_03_01.models.DetectorDefinition]
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.abnormal_time_periods = abnormal_time_periods
        self.payload = payload
        self.non_correlated_detectors = non_correlated_detectors


class DiagnosticAnalysisCollection(_serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnalysisDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AnalysisDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.AnalysisDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.description: Optional[str] = None


class DiagnosticCategoryCollection(_serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticCategory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DiagnosticCategory"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticCategory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticData(_serialization.Model):
    """Set of data with rendering instructions.

    :ivar table: Data in table form.
    :vartype table: ~azure.mgmt.web.v2016_03_01.models.DataTableResponseObject
    :ivar rendering_properties: Properties that describe how the table should be rendered.
    :vartype rendering_properties: ~azure.mgmt.web.v2016_03_01.models.Rendering
    """

    _attribute_map = {
        "table": {"key": "table", "type": "DataTableResponseObject"},
        "rendering_properties": {"key": "renderingProperties", "type": "Rendering"},
    }

    def __init__(
        self,
        *,
        table: Optional["_models.DataTableResponseObject"] = None,
        rendering_properties: Optional["_models.Rendering"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table: Data in table form.
        :paramtype table: ~azure.mgmt.web.v2016_03_01.models.DataTableResponseObject
        :keyword rendering_properties: Properties that describe how the table should be rendered.
        :paramtype rendering_properties: ~azure.mgmt.web.v2016_03_01.models.Rendering
        """
        super().__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticDetectorCollection(_serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.DetectorDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DetectorDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.DetectorDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticDetectorResponse(ProxyOnlyResource):
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar issue_detected: Flag representing Issue was detected.
    :vartype issue_detected: bool
    :ivar detector_definition: Detector's definition.
    :vartype detector_definition: ~azure.mgmt.web.v2016_03_01.models.DetectorDefinition
    :ivar metrics: Metrics provided by the detector.
    :vartype metrics: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSet]
    :ivar abnormal_time_periods: List of Correlated events found by the detector.
    :vartype abnormal_time_periods:
     list[~azure.mgmt.web.v2016_03_01.models.DetectorAbnormalTimePeriod]
    :ivar data: Additional Data that detector wants to send.
    :vartype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
    :ivar response_meta_data: Meta Data.
    :vartype response_meta_data: ~azure.mgmt.web.v2016_03_01.models.ResponseMetaData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "issue_detected": {"key": "properties.issueDetected", "type": "bool"},
        "detector_definition": {"key": "properties.detectorDefinition", "type": "DetectorDefinition"},
        "metrics": {"key": "properties.metrics", "type": "[DiagnosticMetricSet]"},
        "abnormal_time_periods": {"key": "properties.abnormalTimePeriods", "type": "[DetectorAbnormalTimePeriod]"},
        "data": {"key": "properties.data", "type": "[[NameValuePair]]"},
        "response_meta_data": {"key": "properties.responseMetaData", "type": "ResponseMetaData"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        issue_detected: Optional[bool] = None,
        detector_definition: Optional["_models.DetectorDefinition"] = None,
        metrics: Optional[List["_models.DiagnosticMetricSet"]] = None,
        abnormal_time_periods: Optional[List["_models.DetectorAbnormalTimePeriod"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        response_meta_data: Optional["_models.ResponseMetaData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword issue_detected: Flag representing Issue was detected.
        :paramtype issue_detected: bool
        :keyword detector_definition: Detector's definition.
        :paramtype detector_definition: ~azure.mgmt.web.v2016_03_01.models.DetectorDefinition
        :keyword metrics: Metrics provided by the detector.
        :paramtype metrics: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSet]
        :keyword abnormal_time_periods: List of Correlated events found by the detector.
        :paramtype abnormal_time_periods:
         list[~azure.mgmt.web.v2016_03_01.models.DetectorAbnormalTimePeriod]
        :keyword data: Additional Data that detector wants to send.
        :paramtype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
        :keyword response_meta_data: Meta Data.
        :paramtype response_meta_data: ~azure.mgmt.web.v2016_03_01.models.ResponseMetaData
        """
        super().__init__(kind=kind, **kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.issue_detected = issue_detected
        self.detector_definition = detector_definition
        self.metrics = metrics
        self.abnormal_time_periods = abnormal_time_periods
        self.data = data
        self.response_meta_data = response_meta_data


class DiagnosticMetricSample(_serialization.Model):
    """Class representing Diagnostic Metric.

    :ivar timestamp: Time at which metric is measured.
    :vartype timestamp: ~datetime.datetime
    :ivar role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :vartype role_instance: str
    :ivar total: Total value of the metric. If multiple measurements are made this will have sum of
     all.
    :vartype total: float
    :ivar maximum: Maximum of the metric sampled during the time period.
    :vartype maximum: float
    :ivar minimum: Minimum of the metric sampled during the time period.
    :vartype minimum: float
    :ivar is_aggregated: Whether the values are aggregates across all workers or not.
    :vartype is_aggregated: bool
    """

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "role_instance": {"key": "roleInstance", "type": "str"},
        "total": {"key": "total", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "is_aggregated": {"key": "isAggregated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        timestamp: Optional[datetime.datetime] = None,
        role_instance: Optional[str] = None,
        total: Optional[float] = None,
        maximum: Optional[float] = None,
        minimum: Optional[float] = None,
        is_aggregated: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timestamp: Time at which metric is measured.
        :paramtype timestamp: ~datetime.datetime
        :keyword role_instance: Role Instance. Null if this counter is not per instance
         This is returned and should be whichever instance name we desire to be returned
         i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
         where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
        :paramtype role_instance: str
        :keyword total: Total value of the metric. If multiple measurements are made this will have sum
         of all.
        :paramtype total: float
        :keyword maximum: Maximum of the metric sampled during the time period.
        :paramtype maximum: float
        :keyword minimum: Minimum of the metric sampled during the time period.
        :paramtype minimum: float
        :keyword is_aggregated: Whether the values are aggregates across all workers or not.
        :paramtype is_aggregated: bool
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.role_instance = role_instance
        self.total = total
        self.maximum = maximum
        self.minimum = minimum
        self.is_aggregated = is_aggregated


class DiagnosticMetricSet(_serialization.Model):
    """Class representing Diagnostic Metric information.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar unit: Metric's unit.
    :vartype unit: str
    :ivar start_time: Start time of the period.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the period.
    :vartype end_time: ~datetime.datetime
    :ivar time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :vartype time_grain: str
    :ivar values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :vartype values: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "values": {"key": "values", "type": "[DiagnosticMetricSample]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        unit: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        time_grain: Optional[str] = None,
        values: Optional[List["_models.DiagnosticMetricSample"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword unit: Metric's unit.
        :paramtype unit: str
        :keyword start_time: Start time of the period.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the period.
        :paramtype end_time: ~datetime.datetime
        :keyword time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
        :paramtype time_grain: str
        :keyword values: Collection of metric values for the selected period based on the
         {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
        :paramtype values: list[~azure.mgmt.web.v2016_03_01.models.DiagnosticMetricSample]
        """
        super().__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.start_time = start_time
        self.end_time = end_time
        self.time_grain = time_grain
        self.values = values


class Dimension(_serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
    where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.web.v2016_03_01.models.ErrorEntity]
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.web.v2016_03_01.models.ErrorEntity]
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.code = code
        self.message = message


class Experiments(_serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.web.v2016_03_01.models.RampUpRule]
    """

    _attribute_map = {
        "ramp_up_rules": {"key": "rampUpRules", "type": "[RampUpRule]"},
    }

    def __init__(self, *, ramp_up_rules: Optional[List["_models.RampUpRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.web.v2016_03_01.models.RampUpRule]
        """
        super().__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Region name.
    :vartype name_properties_name: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "description": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name: Optional[str] = None
        self.description: Optional[str] = None
        self.display_name: Optional[str] = None


class GeoRegionCollection(_serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GeoRegion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.GeoRegion"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.GeoRegion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class GlobalCsmSkuDescription(_serialization.Model):
    """A Global SKU Description.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service Tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Min, max, and default scale values of the SKU.
    :vartype capacity: ~azure.mgmt.web.v2016_03_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2016_03_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service Tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Min, max, and default scale values of the SKU.
        :paramtype capacity: ~azure.mgmt.web.v2016_03_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2016_03_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.locations = locations
        self.capabilities = capabilities


class HandlerMapping(_serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain
    extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
    extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "script_processor": {"key": "scriptProcessor", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentDeploymentInfo(_serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar location: Location of the App Service Environment.
    :vartype location: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the App Service Environment.
        :paramtype name: str
        :keyword location: Location of the App Service Environment.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.location = location


class HostingEnvironmentProfile(_serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class HostNameSslState(_serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.web.v2016_03_01.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard" and "Repository".
    :vartype host_type: str or ~azure.mgmt.web.v2016_03_01.models.HostType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ssl_state": {"key": "sslState", "type": "str"},
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "to_update": {"key": "toUpdate", "type": "bool"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.web.v2016_03_01.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard" and "Repository".
        :paramtype host_type: str or ~azure.mgmt.web.v2016_03_01.models.HostType
        """
        super().__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "relay_name": {"key": "properties.relayName", "type": "str"},
        "relay_arm_uri": {"key": "properties.relayArmUri", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
        "service_bus_suffix": {"key": "properties.serviceBusSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super().__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "send_key_name": {"readonly": True},
        "send_key_value": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.send_key_name: Optional[str] = None
        self.send_key_value: Optional[str] = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: String representation of the identity.
    :vartype id_properties_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, id_properties_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword id_properties_id: String representation of the identity.
        :paramtype id_properties_id: str
        """
        super().__init__(kind=kind, **kwargs)
        self.id_properties_id = id_properties_id


class IdentifierCollection(_serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Identifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Identifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.Identifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IpSecurityRestriction(_serialization.Model):
    """IP security restriction on an app.

    All required parameters must be populated in order to send to server.

    :ivar ip_address: IP address the security restriction is valid for. Required.
    :vartype ip_address: str
    :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :vartype subnet_mask: str
    """

    _validation = {
        "ip_address": {"required": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
    }

    def __init__(self, *, ip_address: str, subnet_mask: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: IP address the security restriction is valid for. Required.
        :paramtype ip_address: str
        :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :paramtype subnet_mask: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask


class LocalizableString(_serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. "SystemAssigned"
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. "SystemAssigned"
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.ManagedServiceIdentityType
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id: Optional[str] = None
        self.principal_id: Optional[str] = None


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(_serialization.Model):
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2016_03_01.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2016_03_01.models.MetricAvailability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supports_instance_level_aggregation": {"key": "supportsInstanceLevelAggregation", "type": "bool"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "category": {"key": "category", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2016_03_01.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2016_03_01.models.MetricAvailability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class NameIdentifier(_serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class NameValuePair(_serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class NetworkAccessControlEntry(_serialization.Model):
    """Network access control entry.

    :ivar action: Action object. Known values are: "Permit" and "Deny".
    :vartype action: str or ~azure.mgmt.web.v2016_03_01.models.AccessControlEntryAction
    :ivar description: Description of network access control entry.
    :vartype description: str
    :ivar order: Order of precedence.
    :vartype order: int
    :ivar remote_subnet: Remote subnet.
    :vartype remote_subnet: str
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "remote_subnet": {"key": "remoteSubnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "_models.AccessControlEntryAction"]] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        remote_subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Action object. Known values are: "Permit" and "Deny".
        :paramtype action: str or ~azure.mgmt.web.v2016_03_01.models.AccessControlEntryAction
        :keyword description: Description of network access control entry.
        :paramtype description: str
        :keyword order: Order of precedence.
        :paramtype order: int
        :keyword remote_subnet: Remote subnet.
        :paramtype remote_subnet: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.description = description
        self.order = order
        self.remote_subnet = remote_subnet


class Operation(_serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", and "Created".
    :vartype status: str or ~azure.mgmt.web.v2016_03_01.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.web.v2016_03_01.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorEntity]"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "geo_master_operation_id": {"key": "geoMasterOperationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[List["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", and "Created".
        :paramtype status: str or ~azure.mgmt.web.v2016_03_01.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.web.v2016_03_01.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class PremierAddOnOffer(ProxyOnlyResource):
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: Premier add on SKU.
    :vartype sku: str
    :ivar product: Premier add on offer Product.
    :vartype product: str
    :ivar vendor: Premier add on offer Vendor.
    :vartype vendor: str
    :ivar name_properties_name: Premier add on offer Name.
    :vartype name_properties_name: str
    :ivar promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :vartype promo_code_required: bool
    :ivar quota: Premier add on offer Quota.
    :vartype quota: int
    :ivar web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
     values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
    :vartype web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2016_03_01.models.AppServicePlanRestrictions
    :ivar privacy_policy_url: Privacy policy URL.
    :vartype privacy_policy_url: str
    :ivar legal_terms_url: Legal terms URL.
    :vartype legal_terms_url: str
    :ivar marketplace_publisher: Marketplace publisher.
    :vartype marketplace_publisher: str
    :ivar marketplace_offer: Marketplace offer.
    :vartype marketplace_offer: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
        "product": {"key": "properties.product", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "promo_code_required": {"key": "properties.promoCodeRequired", "type": "bool"},
        "quota": {"key": "properties.quota", "type": "int"},
        "web_hosting_plan_restrictions": {"key": "properties.webHostingPlanRestrictions", "type": "str"},
        "privacy_policy_url": {"key": "properties.privacyPolicyUrl", "type": "str"},
        "legal_terms_url": {"key": "properties.legalTermsUrl", "type": "str"},
        "marketplace_publisher": {"key": "properties.marketplacePublisher", "type": "str"},
        "marketplace_offer": {"key": "properties.marketplaceOffer", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        sku: Optional[str] = None,
        product: Optional[str] = None,
        vendor: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        promo_code_required: Optional[bool] = None,
        quota: Optional[int] = None,
        web_hosting_plan_restrictions: Optional[Union[str, "_models.AppServicePlanRestrictions"]] = None,
        privacy_policy_url: Optional[str] = None,
        legal_terms_url: Optional[str] = None,
        marketplace_publisher: Optional[str] = None,
        marketplace_offer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword sku: Premier add on SKU.
        :paramtype sku: str
        :keyword product: Premier add on offer Product.
        :paramtype product: str
        :keyword vendor: Premier add on offer Vendor.
        :paramtype vendor: str
        :keyword name_properties_name: Premier add on offer Name.
        :paramtype name_properties_name: str
        :keyword promo_code_required: :code:`<code>true</code>` if promotion code is required;
         otherwise, :code:`<code>false</code>`.
        :paramtype promo_code_required: bool
        :keyword quota: Premier add on offer Quota.
        :paramtype quota: int
        :keyword web_hosting_plan_restrictions: App Service plans this offer is restricted to. Known
         values are: "None", "Free", "Shared", "Basic", "Standard", and "Premium".
        :paramtype web_hosting_plan_restrictions: str or
         ~azure.mgmt.web.v2016_03_01.models.AppServicePlanRestrictions
        :keyword privacy_policy_url: Privacy policy URL.
        :paramtype privacy_policy_url: str
        :keyword legal_terms_url: Legal terms URL.
        :paramtype legal_terms_url: str
        :keyword marketplace_publisher: Marketplace publisher.
        :paramtype marketplace_publisher: str
        :keyword marketplace_offer: Marketplace offer.
        :paramtype marketplace_offer: str
        """
        super().__init__(kind=kind, **kwargs)
        self.sku = sku
        self.product = product
        self.vendor = vendor
        self.name_properties_name = name_properties_name
        self.promo_code_required = promo_code_required
        self.quota = quota
        self.web_hosting_plan_restrictions = web_hosting_plan_restrictions
        self.privacy_policy_url = privacy_policy_url
        self.legal_terms_url = legal_terms_url
        self.marketplace_publisher = marketplace_publisher
        self.marketplace_offer = marketplace_offer


class PremierAddOnOfferCollection(_serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PremierAddOnOffer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.PremierAddOnOffer"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.PremierAddOnOffer]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in the
     allowed list for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_push_enabled": {"key": "properties.isPushEnabled", "type": "bool"},
        "tag_whitelist_json": {"key": "properties.tagWhitelistJson", "type": "str"},
        "tags_requiring_auth": {"key": "properties.tagsRequiringAuth", "type": "str"},
        "dynamic_tags_json": {"key": "properties.dynamicTagsJson", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are in
         the allowed list for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super().__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class RampUpRule(_serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
    to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
     metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
     Custom decision algorithm can be provided in TiPCallback site extension which URL can be
     specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        "action_host_name": {"key": "actionHostName", "type": "str"},
        "reroute_percentage": {"key": "reroutePercentage", "type": "float"},
        "change_step": {"key": "changeStep", "type": "float"},
        "change_interval_in_minutes": {"key": "changeIntervalInMinutes", "type": "int"},
        "min_reroute_percentage": {"key": "minReroutePercentage", "type": "float"},
        "max_reroute_percentage": {"key": "maxReroutePercentage", "type": "float"},
        "change_decision_callback_url": {"key": "changeDecisionCallbackUrl", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches
         :code:`<code>MinReroutePercentage</code>` or :code:`<code>MaxReroutePercentage</code>`. Site
         metrics are checked every N minutes specified in :code:`<code>ChangeIntervalInMinutes</code>`.
         Custom decision algorithm can be provided in TiPCallback site extension which URL can be
         specified in :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class Recommendation(ProxyOnlyResource):
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar creation_time: Timestamp when this instance was created.
    :vartype creation_time: ~datetime.datetime
    :ivar recommendation_id: A GUID value that each recommendation object is associated with.
    :vartype recommendation_id: str
    :ivar resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :vartype resource_id: str
    :ivar resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
    :vartype resource_scope: str or ~azure.mgmt.web.v2016_03_01.models.ResourceScopeType
    :ivar rule_name: Unique name of the rule.
    :vartype rule_name: str
    :ivar display_name: UI friendly name of the rule (may not be unique).
    :vartype display_name: str
    :ivar message: Recommendation text.
    :vartype message: str
    :ivar level: Level indicating how critical this recommendation can impact. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2016_03_01.models.NotificationLevel
    :ivar channels: List of channels that this recommendation can apply. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2016_03_01.models.Channels
    :ivar tags: The list of category tags that this recommendation belongs to.
    :vartype tags: list[str]
    :ivar action_name: Name of action recommended by this object.
    :vartype action_name: str
    :ivar start_time: The beginning time in UTC of a range that the recommendation refers to.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time in UTC of a range that the recommendation refers to.
    :vartype end_time: ~datetime.datetime
    :ivar next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :vartype next_notification_time: ~datetime.datetime
    :ivar notification_expiration_time: Date and time in UTC when this notification expires.
    :vartype notification_expiration_time: ~datetime.datetime
    :ivar notified_time: Last timestamp in UTC this instance was actually notified. Null means that
     this recommendation hasn't been notified yet.
    :vartype notified_time: ~datetime.datetime
    :ivar score: A metric value measured by the rule.
    :vartype score: float
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "resource_id": {"key": "properties.resourceId", "type": "str"},
        "resource_scope": {"key": "properties.resourceScope", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "tags": {"key": "properties.tags", "type": "[str]"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "next_notification_time": {"key": "properties.nextNotificationTime", "type": "iso-8601"},
        "notification_expiration_time": {"key": "properties.notificationExpirationTime", "type": "iso-8601"},
        "notified_time": {"key": "properties.notifiedTime", "type": "iso-8601"},
        "score": {"key": "properties.score", "type": "float"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        creation_time: Optional[datetime.datetime] = None,
        recommendation_id: Optional[str] = None,
        resource_id: Optional[str] = None,
        resource_scope: Optional[Union[str, "_models.ResourceScopeType"]] = None,
        rule_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        tags: Optional[List[str]] = None,
        action_name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        next_notification_time: Optional[datetime.datetime] = None,
        notification_expiration_time: Optional[datetime.datetime] = None,
        notified_time: Optional[datetime.datetime] = None,
        score: Optional[float] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword creation_time: Timestamp when this instance was created.
        :paramtype creation_time: ~datetime.datetime
        :keyword recommendation_id: A GUID value that each recommendation object is associated with.
        :paramtype recommendation_id: str
        :keyword resource_id: Full ARM resource ID string that this recommendation object is associated
         with.
        :paramtype resource_id: str
        :keyword resource_scope: Name of a resource type this recommendation applies, e.g.
         Subscription, ServerFarm, Site. Known values are: "ServerFarm", "Subscription", and "WebSite".
        :paramtype resource_scope: str or ~azure.mgmt.web.v2016_03_01.models.ResourceScopeType
        :keyword rule_name: Unique name of the rule.
        :paramtype rule_name: str
        :keyword display_name: UI friendly name of the rule (may not be unique).
        :paramtype display_name: str
        :keyword message: Recommendation text.
        :paramtype message: str
        :keyword level: Level indicating how critical this recommendation can impact. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2016_03_01.models.NotificationLevel
        :keyword channels: List of channels that this recommendation can apply. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2016_03_01.models.Channels
        :keyword tags: The list of category tags that this recommendation belongs to.
        :paramtype tags: list[str]
        :keyword action_name: Name of action recommended by this object.
        :paramtype action_name: str
        :keyword start_time: The beginning time in UTC of a range that the recommendation refers to.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time in UTC of a range that the recommendation refers to.
        :paramtype end_time: ~datetime.datetime
        :keyword next_notification_time: When to notify this recommendation next in UTC. Null means
         that this will never be notified anymore.
        :paramtype next_notification_time: ~datetime.datetime
        :keyword notification_expiration_time: Date and time in UTC when this notification expires.
        :paramtype notification_expiration_time: ~datetime.datetime
        :keyword notified_time: Last timestamp in UTC this instance was actually notified. Null means
         that this recommendation hasn't been notified yet.
        :paramtype notified_time: ~datetime.datetime
        :keyword score: A metric value measured by the rule.
        :paramtype score: float
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.creation_time = creation_time
        self.recommendation_id = recommendation_id
        self.resource_id = resource_id
        self.resource_scope = resource_scope
        self.rule_name = rule_name
        self.display_name = display_name
        self.message = message
        self.level = level
        self.channels = channels
        self.tags = tags
        self.action_name = action_name
        self.start_time = start_time
        self.end_time = end_time
        self.next_notification_time = next_notification_time
        self.notification_expiration_time = notification_expiration_time
        self.notified_time = notified_time
        self.score = score
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class RecommendationCollection(_serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Recommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Recommendation"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.Recommendation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class RecommendationRule(ProxyOnlyResource):
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Unique name of the rule.
    :vartype name_properties_name: str
    :ivar display_name: UI friendly name of the rule.
    :vartype display_name: str
    :ivar message: Localized name of the rule (Good for UI).
    :vartype message: str
    :ivar recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :vartype recommendation_id: str
    :ivar description: Localized detailed description of the rule.
    :vartype description: str
    :ivar action_name: Name of action that is recommended by this rule in string.
    :vartype action_name: str
    :ivar level: Level of impact indicating how critical this rule is. Known values are:
     "Critical", "Warning", "Information", and "NonUrgentSuggestion".
    :vartype level: str or ~azure.mgmt.web.v2016_03_01.models.NotificationLevel
    :ivar channels: List of available channels that this rule applies. Known values are:
     "Notification", "Api", "Email", "Webhook", and "All".
    :vartype channels: str or ~azure.mgmt.web.v2016_03_01.models.Channels
    :ivar tags: An array of category tags that the rule contains.
    :vartype tags: list[str]
    :ivar is_dynamic: True if this is associated with a dynamically added rule.
    :vartype is_dynamic: bool
    :ivar extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :vartype extension_name: str
    :ivar blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :vartype blade_name: str
    :ivar forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :vartype forward_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
        "recommendation_id": {"key": "properties.recommendationId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "action_name": {"key": "properties.actionName", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "channels": {"key": "properties.channels", "type": "str"},
        "tags": {"key": "properties.tags", "type": "[str]"},
        "is_dynamic": {"key": "properties.isDynamic", "type": "bool"},
        "extension_name": {"key": "properties.extensionName", "type": "str"},
        "blade_name": {"key": "properties.bladeName", "type": "str"},
        "forward_link": {"key": "properties.forwardLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        recommendation_id: Optional[str] = None,
        description: Optional[str] = None,
        action_name: Optional[str] = None,
        level: Optional[Union[str, "_models.NotificationLevel"]] = None,
        channels: Optional[Union[str, "_models.Channels"]] = None,
        tags: Optional[List[str]] = None,
        is_dynamic: Optional[bool] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        forward_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Unique name of the rule.
        :paramtype name_properties_name: str
        :keyword display_name: UI friendly name of the rule.
        :paramtype display_name: str
        :keyword message: Localized name of the rule (Good for UI).
        :paramtype message: str
        :keyword recommendation_id: Recommendation ID of an associated recommendation object tied to
         the rule, if exists.
         If such an object doesn't exist, it is set to null.
        :paramtype recommendation_id: str
        :keyword description: Localized detailed description of the rule.
        :paramtype description: str
        :keyword action_name: Name of action that is recommended by this rule in string.
        :paramtype action_name: str
        :keyword level: Level of impact indicating how critical this rule is. Known values are:
         "Critical", "Warning", "Information", and "NonUrgentSuggestion".
        :paramtype level: str or ~azure.mgmt.web.v2016_03_01.models.NotificationLevel
        :keyword channels: List of available channels that this rule applies. Known values are:
         "Notification", "Api", "Email", "Webhook", and "All".
        :paramtype channels: str or ~azure.mgmt.web.v2016_03_01.models.Channels
        :keyword tags: An array of category tags that the rule contains.
        :paramtype tags: list[str]
        :keyword is_dynamic: True if this is associated with a dynamically added rule.
        :paramtype is_dynamic: bool
        :keyword extension_name: Extension name of the portal if exists. Applicable to dynamic rule
         only.
        :paramtype extension_name: str
        :keyword blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
        :paramtype blade_name: str
        :keyword forward_link: Forward link to an external document associated with the rule.
         Applicable to dynamic rule only.
        :paramtype forward_link: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.display_name = display_name
        self.message = message
        self.recommendation_id = recommendation_id
        self.description = description
        self.action_name = action_name
        self.level = level
        self.channels = channels
        self.tags = tags
        self.is_dynamic = is_dynamic
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.forward_link = forward_link


class Rendering(_serialization.Model):
    """Instructions for rendering the data.

    :ivar rendering_type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries", and
     "TimeSeriesPerInstance".
    :vartype rendering_type: str or ~azure.mgmt.web.v2016_03_01.models.RenderingType
    :ivar title: Title of data.
    :vartype title: str
    :ivar description: Description of the data that will help it be interpreted.
    :vartype description: str
    """

    _attribute_map = {
        "rendering_type": {"key": "renderingType", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        rendering_type: Optional[Union[str, "_models.RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rendering_type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries",
         and "TimeSeriesPerInstance".
        :paramtype rendering_type: str or ~azure.mgmt.web.v2016_03_01.models.RenderingType
        :keyword title: Title of data.
        :paramtype title: str
        :keyword description: Description of the data that will help it be interpreted.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.rendering_type = rendering_type
        self.title = title
        self.description = description


class RequestsBasedTrigger(_serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(self, *, count: Optional[int] = None, time_interval: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar category: The category that the resource matches in the RHC Policy File.
    :vartype category: str
    :ivar signal_availability: Is there a health signal for the resource.
    :vartype signal_availability: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "signal_availability": {"key": "properties.signalAvailability", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        category: Optional[str] = None,
        signal_availability: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword category: The category that the resource matches in the RHC Policy File.
        :paramtype category: str
        :keyword signal_availability: Is there a health signal for the resource.
        :paramtype signal_availability: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.category = category
        self.signal_availability = signal_availability


class ResourceHealthMetadataCollection(_serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceHealthMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceHealthMetadata"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceHealthMetadata]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceMetric(_serialization.Model):
    """Object representing a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of metric.
    :vartype name: ~azure.mgmt.web.v2016_03_01.models.ResourceMetricName
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar time_grain: Metric granularity. E.g PT1H, PT5M, P1D.
    :vartype time_grain: str
    :ivar start_time: Metric start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Metric end time.
    :vartype end_time: ~datetime.datetime
    :ivar resource_id: Metric resource Id.
    :vartype resource_id: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar metric_values: Metric values.
    :vartype metric_values: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricValue]
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricProperty]
    """

    _validation = {
        "name": {"readonly": True},
        "unit": {"readonly": True},
        "time_grain": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "resource_id": {"readonly": True},
        "id": {"readonly": True},
        "metric_values": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "ResourceMetricName"},
        "unit": {"key": "unit", "type": "str"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "metric_values": {"key": "metricValues", "type": "[ResourceMetricValue]"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional["_models.ResourceMetricName"] = None
        self.unit: Optional[str] = None
        self.time_grain: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None
        self.resource_id: Optional[str] = None
        self.id: Optional[str] = None
        self.metric_values: Optional[List["_models.ResourceMetricValue"]] = None
        self.properties: Optional[List["_models.ResourceMetricProperty"]] = None


class ResourceMetricAvailability(_serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        "time_grain": {"readonly": True},
        "retention": {"readonly": True},
    }

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "retention": {"key": "retention", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.time_grain: Optional[str] = None
        self.retention: Optional[str] = None


class ResourceMetricCollection(_serialization.Model):
    """Collection of metric responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetric]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetric]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetric"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetric]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the metric.
    :vartype name_properties_name: ~azure.mgmt.web.v2016_03_01.models.ResourceMetricName
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar id_properties_id: Resource ID.
    :vartype id_properties_id: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "unit": {"readonly": True},
        "primary_aggregation_type": {"readonly": True},
        "metric_availabilities": {"readonly": True},
        "resource_uri": {"readonly": True},
        "id_properties_id": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "ResourceMetricName"},
        "unit": {"key": "properties.unit", "type": "str"},
        "primary_aggregation_type": {"key": "properties.primaryAggregationType", "type": "str"},
        "metric_availabilities": {"key": "properties.metricAvailabilities", "type": "[ResourceMetricAvailability]"},
        "resource_uri": {"key": "properties.resourceUri", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "properties": {"key": "properties.properties", "type": "{str}"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name: Optional["_models.ResourceMetricName"] = None
        self.unit: Optional[str] = None
        self.primary_aggregation_type: Optional[str] = None
        self.metric_availabilities: Optional[List["_models.ResourceMetricAvailability"]] = None
        self.resource_uri: Optional[str] = None
        self.id_properties_id: Optional[str] = None
        self.properties: Optional[Dict[str, str]] = None


class ResourceMetricDefinitionCollection(_serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceMetricDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ResourceMetricDefinition"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricDefinition]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceMetricName(_serialization.Model):
    """Name of a metric for any resource .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: metric name value.
    :vartype value: str
    :ivar localized_value: Localized metric name value.
    :vartype localized_value: str
    """

    _validation = {
        "value": {"readonly": True},
        "localized_value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[str] = None
        self.localized_value: Optional[str] = None


class ResourceMetricProperty(_serialization.Model):
    """Resource metric property.

    :ivar key: Key for resource metric property.
    :vartype key: str
    :ivar value: Value of pair.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: Key for resource metric property.
        :paramtype key: str
        :keyword value: Value of pair.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class ResourceMetricValue(_serialization.Model):
    """Value of resource metric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Value timestamp.
    :vartype timestamp: str
    :ivar average: Value average.
    :vartype average: float
    :ivar minimum: Value minimum.
    :vartype minimum: float
    :ivar maximum: Value maximum.
    :vartype maximum: float
    :ivar total: Value total.
    :vartype total: float
    :ivar count: Value count.
    :vartype count: float
    :ivar properties: Resource metric properties collection.
    :vartype properties: list[~azure.mgmt.web.v2016_03_01.models.ResourceMetricProperty]
    """

    _validation = {
        "timestamp": {"readonly": True},
        "average": {"readonly": True},
        "minimum": {"readonly": True},
        "maximum": {"readonly": True},
        "total": {"readonly": True},
        "count": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "str"},
        "average": {"key": "average", "type": "float"},
        "minimum": {"key": "minimum", "type": "float"},
        "maximum": {"key": "maximum", "type": "float"},
        "total": {"key": "total", "type": "float"},
        "count": {"key": "count", "type": "float"},
        "properties": {"key": "properties", "type": "[ResourceMetricProperty]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp: Optional[str] = None
        self.average: Optional[float] = None
        self.minimum: Optional[float] = None
        self.maximum: Optional[float] = None
        self.total: Optional[float] = None
        self.count: Optional[float] = None
        self.properties: Optional[List["_models.ResourceMetricProperty"]] = None


class ResourceNameAvailability(_serialization.Model):
    """Information regarding availability of a resource name.

    :ivar name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure App
     Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.web.v2016_03_01.models.InAvailabilityReasonType
    :ivar message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.InAvailabilityReasonType"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: :code:`<code>true</code>` indicates name is valid and available.
         :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
        :paramtype name_available: bool
        :keyword reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
         App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
         already in use and is therefore unavailable. Known values are: "Invalid" and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.web.v2016_03_01.models.InAvailabilityReasonType
        :keyword message: If reason == invalid, provide the user with the reason why the given name is
         invalid, and provide the resource naming requirements so that the user can select a valid name.
         If reason == AlreadyExists, explain that resource name is already in use, and direct them to
         select a different name.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class ResourceNameAvailabilityRequest(_serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to server.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are: "Site", "Slot",
     "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
     "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.CheckNameResourceTypes
    :ivar is_fqdn: Is fully qualified domain name.
    :vartype is_fqdn: bool
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_fqdn": {"key": "isFqdn", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.CheckNameResourceTypes"],
        is_fqdn: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification. Required. Known values are: "Site", "Slot",
         "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites", "Microsoft.Web/sites/slots",
         "Microsoft.Web/hostingEnvironments", and "Microsoft.Web/publishingUsers".
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.CheckNameResourceTypes
        :keyword is_fqdn: Is fully qualified domain name.
        :paramtype is_fqdn: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.is_fqdn = is_fqdn


class ResponseMetaData(_serialization.Model):
    """ResponseMetaData.

    :ivar data_source: Source of the Data.
    :vartype data_source: ~azure.mgmt.web.v2016_03_01.models.DataSource
    """

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "DataSource"},
    }

    def __init__(self, *, data_source: Optional["_models.DataSource"] = None, **kwargs: Any) -> None:
        """
        :keyword data_source: Source of the Data.
        :paramtype data_source: ~azure.mgmt.web.v2016_03_01.models.DataSource
        """
        super().__init__(**kwargs)
        self.data_source = data_source


class ServiceSpecification(_serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2016_03_01.models.MetricSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self, *, metric_specifications: Optional[List["_models.MetricSpecification"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2016_03_01.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.web.v2016_03_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2016_03_01.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2016_03_01.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states: list[~azure.mgmt.web.v2016_03_01.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar site_config: Configuration of the app.
    :vartype site_config: ~azure.mgmt.web.v2016_03_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants. Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.web.v2016_03_01.models.CloningInfo
    :ivar snapshot_info: If specified during app creation, the app is created from a previous
     snapshot.
    :vartype snapshot_info: ~azure.mgmt.web.v2016_03_01.models.SnapshotRecoveryRequest
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2016_03_01.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "snapshot_info": {"key": "properties.snapshotInfo", "type": "SnapshotRecoveryRequest"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[List["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        site_config: Optional["_models.SiteConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        snapshot_info: Optional["_models.SnapshotRecoveryRequest"] = None,
        https_only: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.web.v2016_03_01.models.ManagedServiceIdentity
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states: list[~azure.mgmt.web.v2016_03_01.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword site_config: Configuration of the app.
        :paramtype site_config: ~azure.mgmt.web.v2016_03_01.models.SiteConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.web.v2016_03_01.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.web.v2016_03_01.models.CloningInfo
        :keyword snapshot_info: If specified during app creation, the app is created from a previous
         snapshot.
        :paramtype snapshot_info: ~azure.mgmt.web.v2016_03_01.models.SnapshotRecoveryRequest
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.state: Optional[str] = None
        self.host_names: Optional[List[str]] = None
        self.repository_site_name: Optional[str] = None
        self.usage_state: Optional[Union[str, "_models.UsageState"]] = None
        self.enabled = enabled
        self.enabled_host_names: Optional[List[str]] = None
        self.availability_state: Optional[Union[str, "_models.SiteAvailabilityState"]] = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.last_modified_time_utc: Optional[datetime.datetime] = None
        self.site_config = site_config
        self.traffic_manager_host_names: Optional[List[str]] = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot: Optional[str] = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_cert_enabled = client_cert_enabled
        self.host_names_disabled = host_names_disabled
        self.outbound_ip_addresses: Optional[str] = None
        self.possible_outbound_ip_addresses: Optional[str] = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till: Optional[datetime.datetime] = None
        self.max_number_of_workers: Optional[int] = None
        self.cloning_info = cloning_info
        self.snapshot_info = snapshot_info
        self.resource_group: Optional[str] = None
        self.is_default_container: Optional[bool] = None
        self.default_host_name: Optional[str] = None
        self.slot_swap_status: Optional["_models.SlotSwapStatus"] = None
        self.https_only = https_only


class SiteConfig(_serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings.
    :vartype app_settings: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
    :ivar connection_strings: Connection strings.
    :vartype connection_strings: list[~azure.mgmt.web.v2016_03_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2016_03_01.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.web.v2016_03_01.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", and "VSO".
    :vartype scm_type: str or ~azure.mgmt.web.v2016_03_01.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_03_01.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications: list[~azure.mgmt.web.v2016_03_01.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
    :vartype load_balancing: str or ~azure.mgmt.web.v2016_03_01.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.web.v2016_03_01.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.web.v2016_03_01.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.web.v2016_03_01.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.web.v2016_03_01.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.web.v2016_03_01.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.web.v2016_03_01.models.ApiDefinitionInfo
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar ip_security_restrictions: IP security restrictions.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.web.v2016_03_01.models.IpSecurityRestriction]
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", and "1.2".
    :vartype min_tls_version: str or ~azure.mgmt.web.v2016_03_01.models.SupportedTlsVersions
    """

    _validation = {
        "machine_key": {"readonly": True},
    }

    _attribute_map = {
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "default_documents": {"key": "defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "netFrameworkVersion", "type": "str"},
        "php_version": {"key": "phpVersion", "type": "str"},
        "python_version": {"key": "pythonVersion", "type": "str"},
        "node_version": {"key": "nodeVersion", "type": "str"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "httpLoggingEnabled", "type": "bool"},
        "logs_directory_size_limit": {"key": "logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "publishingUsername", "type": "str"},
        "app_settings": {"key": "appSettings", "type": "[NameValuePair]"},
        "connection_strings": {"key": "connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "documentRoot", "type": "str"},
        "scm_type": {"key": "scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "alwaysOn", "type": "bool"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "java_container": {"key": "javaContainer", "type": "str"},
        "java_container_version": {"key": "javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "loadBalancing", "type": "str"},
        "experiments": {"key": "experiments", "type": "Experiments"},
        "limits": {"key": "limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "tracingOptions", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "cors": {"key": "cors", "type": "CorsSettings"},
        "push": {"key": "push", "type": "PushSettings"},
        "api_definition": {"key": "apiDefinition", "type": "ApiDefinitionInfo"},
        "auto_swap_slot_name": {"key": "autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "localMySqlEnabled", "type": "bool"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "http20_enabled": {"key": "http20Enabled", "type": "bool"},
        "min_tls_version": {"key": "minTlsVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[List[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[List["_models.NameValuePair"]] = None,
        connection_strings: Optional[List["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[List["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[List["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestriction"]] = None,
        http20_enabled: bool = True,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings.
        :paramtype app_settings: list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]
        :keyword connection_strings: Connection strings.
        :paramtype connection_strings: list[~azure.mgmt.web.v2016_03_01.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.web.v2016_03_01.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", and "VSO".
        :paramtype scm_type: str or ~azure.mgmt.web.v2016_03_01.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or ~azure.mgmt.web.v2016_03_01.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications: list[~azure.mgmt.web.v2016_03_01.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", and "RequestHash".
        :paramtype load_balancing: str or ~azure.mgmt.web.v2016_03_01.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.web.v2016_03_01.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.web.v2016_03_01.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.web.v2016_03_01.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.web.v2016_03_01.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.web.v2016_03_01.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.web.v2016_03_01.models.ApiDefinitionInfo
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword ip_security_restrictions: IP security restrictions.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.web.v2016_03_01.models.IpSecurityRestriction]
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", and "1.2".
        :paramtype min_tls_version: str or ~azure.mgmt.web.v2016_03_01.models.SupportedTlsVersions
        """
        super().__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.linux_fx_version = linux_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.connection_strings = connection_strings
        self.machine_key: Optional["_models.SiteMachineKey"] = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.ip_security_restrictions = ip_security_restrictions
        self.http20_enabled = http20_enabled
        self.min_tls_version = min_tls_version


class SiteLimits(_serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: int
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: int
    """

    _attribute_map = {
        "max_percentage_cpu": {"key": "maxPercentageCpu", "type": "float"},
        "max_memory_in_mb": {"key": "maxMemoryInMb", "type": "int"},
        "max_disk_size_in_mb": {"key": "maxDiskSizeInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: int
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteMachineKey(_serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        "validation": {"key": "validation", "type": "str"},
        "validation_key": {"key": "validationKey", "type": "str"},
        "decryption": {"key": "decryption", "type": "str"},
        "decryption_key": {"key": "decryptionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super().__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SkuCapacity(_serialization.Model):
    """Description of the App Service plan scale options.

    :ivar minimum: Minimum number of workers for this App Service plan SKU.
    :vartype minimum: int
    :ivar maximum: Maximum number of workers for this App Service plan SKU.
    :vartype maximum: int
    :ivar default: Default number of workers for this App Service plan SKU.
    :vartype default: int
    :ivar scale_type: Available scale configurations for an App Service plan.
    :vartype scale_type: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Minimum number of workers for this App Service plan SKU.
        :paramtype minimum: int
        :keyword maximum: Maximum number of workers for this App Service plan SKU.
        :paramtype maximum: int
        :keyword default: Default number of workers for this App Service plan SKU.
        :paramtype default: int
        :keyword scale_type: Available scale configurations for an App Service plan.
        :paramtype scale_type: str
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(_serialization.Model):
    """Description of a SKU for a scalable resource.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Current number of instances assigned to the resource.
    :vartype capacity: int
    :ivar sku_capacity: Min, max, and default scale values of the SKU.
    :vartype sku_capacity: ~azure.mgmt.web.v2016_03_01.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.web.v2016_03_01.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "sku_capacity": {"key": "skuCapacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        capabilities: Optional[List["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Current number of instances assigned to the resource.
        :paramtype capacity: int
        :keyword sku_capacity: Min, max, and default scale values of the SKU.
        :paramtype sku_capacity: ~azure.mgmt.web.v2016_03_01.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.web.v2016_03_01.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SkuInfos(_serialization.Model):
    """Collection of SKU information.

    :ivar resource_type: Resource type that this SKU applies to.
    :vartype resource_type: str
    :ivar skus: List of SKUs the subscription is able to use.
    :vartype skus: list[~azure.mgmt.web.v2016_03_01.models.GlobalCsmSkuDescription]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "skus": {"key": "skus", "type": "[GlobalCsmSkuDescription]"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        skus: Optional[List["_models.GlobalCsmSkuDescription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Resource type that this SKU applies to.
        :paramtype resource_type: str
        :keyword skus: List of SKUs the subscription is able to use.
        :paramtype skus: list[~azure.mgmt.web.v2016_03_01.models.GlobalCsmSkuDescription]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.skus = skus


class SlotSwapStatus(_serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        "timestamp_utc": {"readonly": True},
        "source_slot_name": {"readonly": True},
        "destination_slot_name": {"readonly": True},
    }

    _attribute_map = {
        "timestamp_utc": {"key": "timestampUtc", "type": "iso-8601"},
        "source_slot_name": {"key": "sourceSlotName", "type": "str"},
        "destination_slot_name": {"key": "destinationSlotName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp_utc: Optional[datetime.datetime] = None
        self.source_slot_name: Optional[str] = None
        self.destination_slot_name: Optional[str] = None


class SlowRequestsBasedTrigger(_serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "time_taken": {"key": "timeTaken", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.time_taken = time_taken
        self.count = count
        self.time_interval = time_interval


class SnapshotRecoveryRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar snapshot_time: Point in time in which the app recovery should be attempted, formatted as
     a DateTime string.
    :vartype snapshot_time: str
    :ivar recovery_target: Specifies the web app that snapshot contents will be written to.
    :vartype recovery_target: ~azure.mgmt.web.v2016_03_01.models.SnapshotRecoveryTarget
    :ivar overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :vartype recover_configuration: bool
    :ivar ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :vartype ignore_conflicting_host_names: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "snapshot_time": {"key": "properties.snapshotTime", "type": "str"},
        "recovery_target": {"key": "properties.recoveryTarget", "type": "SnapshotRecoveryTarget"},
        "overwrite": {"key": "properties.overwrite", "type": "bool"},
        "recover_configuration": {"key": "properties.recoverConfiguration", "type": "bool"},
        "ignore_conflicting_host_names": {"key": "properties.ignoreConflictingHostNames", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        snapshot_time: Optional[str] = None,
        recovery_target: Optional["_models.SnapshotRecoveryTarget"] = None,
        overwrite: Optional[bool] = None,
        recover_configuration: Optional[bool] = None,
        ignore_conflicting_host_names: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword snapshot_time: Point in time in which the app recovery should be attempted, formatted
         as a DateTime string.
        :paramtype snapshot_time: str
        :keyword recovery_target: Specifies the web app that snapshot contents will be written to.
        :paramtype recovery_target: ~azure.mgmt.web.v2016_03_01.models.SnapshotRecoveryTarget
        :keyword overwrite: If :code:`<code>true</code>` the recovery operation can overwrite source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword recover_configuration: If true, site configuration, in addition to content, will be
         reverted.
        :paramtype recover_configuration: bool
        :keyword ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
         recovering to a target web app.
         This setting is only necessary when RecoverConfiguration is enabled.
        :paramtype ignore_conflicting_host_names: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.snapshot_time = snapshot_time
        self.recovery_target = recovery_target
        self.overwrite = overwrite
        self.recover_configuration = recover_configuration
        self.ignore_conflicting_host_names = ignore_conflicting_host_names


class SnapshotRecoveryTarget(_serialization.Model):
    """Specifies the web app that snapshot contents will be written to.

    :ivar location: Geographical location of the target web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :vartype location: str
    :ivar id: ARM resource ID of the target app.
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :vartype id: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Geographical location of the target web app, e.g. SouthEastAsia,
         SouthCentralUS.
        :paramtype location: str
        :keyword id: ARM resource ID of the target app.
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.id = id


class Solution(_serialization.Model):
    """Class Representing Solution for problems detected.

    :ivar id: Solution Id.
    :vartype id: float
    :ivar display_name: Display Name of the solution.
    :vartype display_name: str
    :ivar order: Order of the solution.
    :vartype order: float
    :ivar description: Description of the solution.
    :vartype description: str
    :ivar type: Type of Solution. Known values are: "QuickSolution", "DeepInvestigation", and
     "BestPractices".
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.SolutionType
    :ivar data: Solution Data.
    :vartype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
    :ivar metadata: Solution Metadata.
    :vartype metadata: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "float"},
        "display_name": {"key": "displayName", "type": "str"},
        "order": {"key": "order", "type": "float"},
        "description": {"key": "description", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data": {"key": "data", "type": "[[NameValuePair]]"},
        "metadata": {"key": "metadata", "type": "[[NameValuePair]]"},
    }

    def __init__(
        self,
        *,
        id: Optional[float] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        order: Optional[float] = None,
        description: Optional[str] = None,
        type: Optional[Union[str, "_models.SolutionType"]] = None,
        data: Optional[List[List["_models.NameValuePair"]]] = None,
        metadata: Optional[List[List["_models.NameValuePair"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Solution Id.
        :paramtype id: float
        :keyword display_name: Display Name of the solution.
        :paramtype display_name: str
        :keyword order: Order of the solution.
        :paramtype order: float
        :keyword description: Description of the solution.
        :paramtype description: str
        :keyword type: Type of Solution. Known values are: "QuickSolution", "DeepInvestigation", and
         "BestPractices".
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.SolutionType
        :keyword data: Solution Data.
        :paramtype data: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
        :keyword metadata: Solution Metadata.
        :paramtype metadata: list[list[~azure.mgmt.web.v2016_03_01.models.NameValuePair]]
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.order = order
        self.description = description
        self.type = type
        self.data = data
        self.metadata = metadata


class SourceControl(ProxyOnlyResource):
    """The source control OAuth token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name or source control type.
    :vartype name_properties_name: str
    :ivar token: OAuth access token.
    :vartype token: str
    :ivar token_secret: OAuth access token secret.
    :vartype token_secret: str
    :ivar refresh_token: OAuth refresh token.
    :vartype refresh_token: str
    :ivar expiration_time: OAuth token expiration.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "token": {"key": "properties.token", "type": "str"},
        "token_secret": {"key": "properties.tokenSecret", "type": "str"},
        "refresh_token": {"key": "properties.refreshToken", "type": "str"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        name_properties_name: Optional[str] = None,
        token: Optional[str] = None,
        token_secret: Optional[str] = None,
        refresh_token: Optional[str] = None,
        expiration_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword name_properties_name: Name or source control type.
        :paramtype name_properties_name: str
        :keyword token: OAuth access token.
        :paramtype token: str
        :keyword token_secret: OAuth access token secret.
        :paramtype token_secret: str
        :keyword refresh_token: OAuth refresh token.
        :paramtype refresh_token: str
        :keyword expiration_time: OAuth token expiration.
        :paramtype expiration_time: ~datetime.datetime
        """
        super().__init__(kind=kind, **kwargs)
        self.name_properties_name = name_properties_name
        self.token = token
        self.token_secret = token_secret
        self.refresh_token = refresh_token
        self.expiration_time = expiration_time


class SourceControlCollection(_serialization.Model):
    """Collection of source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SourceControl]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SourceControl"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.SourceControl]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class StackMajorVersion(_serialization.Model):
    """Application stack major version.

    :ivar display_version: Application stack major version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack major version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2016_03_01.models.StackMinorVersion]
    """

    _attribute_map = {
        "display_version": {"key": "displayVersion", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
        "minor_versions": {"key": "minorVersions", "type": "[StackMinorVersion]"},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        minor_versions: Optional[List["_models.StackMinorVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_version: Application stack major version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack major version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        :keyword minor_versions: Minor versions associated with the major version.
        :paramtype minor_versions: list[~azure.mgmt.web.v2016_03_01.models.StackMinorVersion]
        """
        super().__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default
        self.minor_versions = minor_versions


class StackMinorVersion(_serialization.Model):
    """Application stack minor version.

    :ivar display_version: Application stack minor version (display only).
    :vartype display_version: str
    :ivar runtime_version: Application stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    """

    _attribute_map = {
        "display_version": {"key": "displayVersion", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "is_default": {"key": "isDefault", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_version: Optional[str] = None,
        runtime_version: Optional[str] = None,
        is_default: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_version: Application stack minor version (display only).
        :paramtype display_version: str
        :keyword runtime_version: Application stack minor version (runtime only).
        :paramtype runtime_version: str
        :keyword is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
         :code:`<code>false</code>`.
        :paramtype is_default: bool
        """
        super().__init__(**kwargs)
        self.display_version = display_version
        self.runtime_version = runtime_version
        self.is_default = is_default


class StampCapacity(_serialization.Model):
    """Stamp capacity information.

    :ivar name: Name of the stamp.
    :vartype name: str
    :ivar available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :vartype available_capacity: int
    :ivar total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :vartype total_capacity: int
    :ivar unit: Name of the unit.
    :vartype unit: str
    :ivar compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
     "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_03_01.models.ComputeModeOptions
    :ivar worker_size: Size of the machines. Known values are: "Default", "Small", "Medium",
     "Large", "D1", "D2", and "D3".
    :vartype worker_size: str or ~azure.mgmt.web.v2016_03_01.models.WorkerSizeOptions
    :ivar worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :vartype worker_size_id: int
    :ivar exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :vartype exclude_from_capacity_allocation: bool
    :ivar is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :vartype is_applicable_for_all_compute_modes: bool
    :ivar site_mode: Shared or Dedicated.
    :vartype site_mode: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available_capacity": {"key": "availableCapacity", "type": "int"},
        "total_capacity": {"key": "totalCapacity", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "exclude_from_capacity_allocation": {"key": "excludeFromCapacityAllocation", "type": "bool"},
        "is_applicable_for_all_compute_modes": {"key": "isApplicableForAllComputeModes", "type": "bool"},
        "site_mode": {"key": "siteMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        available_capacity: Optional[int] = None,
        total_capacity: Optional[int] = None,
        unit: Optional[str] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[Union[str, "_models.WorkerSizeOptions"]] = None,
        worker_size_id: Optional[int] = None,
        exclude_from_capacity_allocation: Optional[bool] = None,
        is_applicable_for_all_compute_modes: Optional[bool] = None,
        site_mode: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the stamp.
        :paramtype name: str
        :keyword available_capacity: Available capacity (# of machines, bytes of storage etc...).
        :paramtype available_capacity: int
        :keyword total_capacity: Total capacity (# of machines, bytes of storage etc...).
        :paramtype total_capacity: int
        :keyword unit: Name of the unit.
        :paramtype unit: str
        :keyword compute_mode: Shared/dedicated workers. Known values are: "Shared", "Dedicated", and
         "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2016_03_01.models.ComputeModeOptions
        :keyword worker_size: Size of the machines. Known values are: "Default", "Small", "Medium",
         "Large", "D1", "D2", and "D3".
        :paramtype worker_size: str or ~azure.mgmt.web.v2016_03_01.models.WorkerSizeOptions
        :keyword worker_size_id: Size ID of machines:
         0 - Small
         1 - Medium
         2 - Large.
        :paramtype worker_size_id: int
        :keyword exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic
         apps.
         Basic apps are not used for capacity allocation.
        :paramtype exclude_from_capacity_allocation: bool
        :keyword is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is
         applicable for all apps; otherwise, :code:`<code>false</code>`.
        :paramtype is_applicable_for_all_compute_modes: bool
        :keyword site_mode: Shared or Dedicated.
        :paramtype site_mode: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.available_capacity = available_capacity
        self.total_capacity = total_capacity
        self.unit = unit
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_size_id = worker_size_id
        self.exclude_from_capacity_allocation = exclude_from_capacity_allocation
        self.is_applicable_for_all_compute_modes = is_applicable_for_all_compute_modes
        self.site_mode = site_mode


class StatusCodesBasedTrigger(_serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "int"},
        "sub_status": {"key": "subStatus", "type": "int"},
        "win32_status": {"key": "win32Status", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar user_name: Username.
    :vartype user_name: str
    :ivar publishing_user_name: Username used for publishing.
    :vartype publishing_user_name: str
    :ivar publishing_password: Password used for publishing.
    :vartype publishing_password: str
    :ivar publishing_password_hash: Password hash used for publishing.
    :vartype publishing_password_hash: str
    :ivar publishing_password_hash_salt: Password hash salt used for publishing.
    :vartype publishing_password_hash_salt: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_name": {"key": "properties.name", "type": "str"},
        "publishing_user_name": {"key": "properties.publishingUserName", "type": "str"},
        "publishing_password": {"key": "properties.publishingPassword", "type": "str"},
        "publishing_password_hash": {"key": "properties.publishingPasswordHash", "type": "str"},
        "publishing_password_hash_salt": {"key": "properties.publishingPasswordHashSalt", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        user_name: Optional[str] = None,
        publishing_user_name: Optional[str] = None,
        publishing_password: Optional[str] = None,
        publishing_password_hash: Optional[str] = None,
        publishing_password_hash_salt: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword user_name: Username.
        :paramtype user_name: str
        :keyword publishing_user_name: Username used for publishing.
        :paramtype publishing_user_name: str
        :keyword publishing_password: Password used for publishing.
        :paramtype publishing_password: str
        :keyword publishing_password_hash: Password hash used for publishing.
        :paramtype publishing_password_hash: str
        :keyword publishing_password_hash_salt: Password hash salt used for publishing.
        :paramtype publishing_password_hash_salt: str
        """
        super().__init__(kind=kind, **kwargs)
        self.user_name = user_name
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt


class ValidateRequest(_serialization.Model):
    """Resource validation request content.

    All required parameters must be populated in order to send to server.

    :ivar name: Resource name to verify. Required.
    :vartype name: str
    :ivar type: Resource type used for verification. Required. Known values are: "ServerFarm" and
     "Site".
    :vartype type: str or ~azure.mgmt.web.v2016_03_01.models.ValidateResourceTypes
    :ivar location: Expected location of the resource. Required.
    :vartype location: str
    :ivar server_farm_id: ARM resource ID of an App Service plan that would host the app.
    :vartype server_farm_id: str
    :ivar sku_name: Name of the target SKU for the App Service plan.
    :vartype sku_name: str
    :ivar need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux workers;
     otherwise, :code:`<code>false</code>`.
    :vartype need_linux_workers: bool
    :ivar is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances; otherwise,
     :code:`<code>false</code>`.
    :vartype is_spot: bool
    :ivar capacity: Target capacity of the App Service plan (number of VMs).
    :vartype capacity: int
    :ivar hosting_environment: Name of App Service Environment where app or App Service plan should
     be created.
    :vartype hosting_environment: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
        "location": {"required": True},
        "capacity": {"minimum": 1},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "sku_name": {"key": "properties.skuName", "type": "str"},
        "need_linux_workers": {"key": "properties.needLinuxWorkers", "type": "bool"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "capacity": {"key": "properties.capacity", "type": "int"},
        "hosting_environment": {"key": "properties.hostingEnvironment", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models.ValidateResourceTypes"],
        location: str,
        server_farm_id: Optional[str] = None,
        sku_name: Optional[str] = None,
        need_linux_workers: Optional[bool] = None,
        is_spot: Optional[bool] = None,
        capacity: Optional[int] = None,
        hosting_environment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name to verify. Required.
        :paramtype name: str
        :keyword type: Resource type used for verification. Required. Known values are: "ServerFarm"
         and "Site".
        :paramtype type: str or ~azure.mgmt.web.v2016_03_01.models.ValidateResourceTypes
        :keyword location: Expected location of the resource. Required.
        :paramtype location: str
        :keyword server_farm_id: ARM resource ID of an App Service plan that would host the app.
        :paramtype server_farm_id: str
        :keyword sku_name: Name of the target SKU for the App Service plan.
        :paramtype sku_name: str
        :keyword need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux
         workers; otherwise, :code:`<code>false</code>`.
        :paramtype need_linux_workers: bool
        :keyword is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances;
         otherwise, :code:`<code>false</code>`.
        :paramtype is_spot: bool
        :keyword capacity: Target capacity of the App Service plan (number of VMs).
        :paramtype capacity: int
        :keyword hosting_environment: Name of App Service Environment where app or App Service plan
         should be created.
        :paramtype hosting_environment: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.location = location
        self.server_farm_id = server_farm_id
        self.sku_name = sku_name
        self.need_linux_workers = need_linux_workers
        self.is_spot = is_spot
        self.capacity = capacity
        self.hosting_environment = hosting_environment


class ValidateResponse(_serialization.Model):
    """Describes the result of resource validation.

    :ivar status: Result of validation.
    :vartype status: str
    :ivar error: Error details for the case when validation fails.
    :vartype error: ~azure.mgmt.web.v2016_03_01.models.ValidateResponseError
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ValidateResponseError"},
    }

    def __init__(
        self, *, status: Optional[str] = None, error: Optional["_models.ValidateResponseError"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Result of validation.
        :paramtype status: str
        :keyword error: Error details for the case when validation fails.
        :paramtype error: ~azure.mgmt.web.v2016_03_01.models.ValidateResponseError
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class ValidateResponseError(_serialization.Model):
    """Error details for when validation fails.

    :ivar code: Validation error code.
    :vartype code: str
    :ivar message: Validation error message.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Validation error code.
        :paramtype code: str
        :keyword message: Validation error message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class VirtualApplication(_serialization.Model):
    """Virtual application in an app.

    :ivar virtual_path: Virtual path.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    :ivar preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype preload_enabled: bool
    :ivar virtual_directories: Virtual directories for virtual application.
    :vartype virtual_directories: list[~azure.mgmt.web.v2016_03_01.models.VirtualDirectory]
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
        "preload_enabled": {"key": "preloadEnabled", "type": "bool"},
        "virtual_directories": {"key": "virtualDirectories", "type": "[VirtualDirectory]"},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[List["_models.VirtualDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Virtual path.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        :keyword preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype preload_enabled: bool
        :keyword virtual_directories: Virtual directories for virtual application.
        :paramtype virtual_directories: list[~azure.mgmt.web.v2016_03_01.models.VirtualDirectory]
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(_serialization.Model):
    """Directory for virtual application.

    :ivar virtual_path: Path to virtual application.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, physical_path: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Path to virtual application.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VirtualIPMapping(_serialization.Model):
    """Virtual IP mapping.

    :ivar virtual_ip: Virtual IP address.
    :vartype virtual_ip: str
    :ivar internal_http_port: Internal HTTP port.
    :vartype internal_http_port: int
    :ivar internal_https_port: Internal HTTPS port.
    :vartype internal_https_port: int
    :ivar in_use: Is virtual IP mapping in use.
    :vartype in_use: bool
    """

    _attribute_map = {
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "internal_http_port": {"key": "internalHttpPort", "type": "int"},
        "internal_https_port": {"key": "internalHttpsPort", "type": "int"},
        "in_use": {"key": "inUse", "type": "bool"},
    }

    def __init__(
        self,
        *,
        virtual_ip: Optional[str] = None,
        internal_http_port: Optional[int] = None,
        internal_https_port: Optional[int] = None,
        in_use: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_ip: Virtual IP address.
        :paramtype virtual_ip: str
        :keyword internal_http_port: Internal HTTP port.
        :paramtype internal_http_port: int
        :keyword internal_https_port: Internal HTTPS port.
        :paramtype internal_https_port: int
        :keyword in_use: Is virtual IP mapping in use.
        :paramtype in_use: bool
        """
        super().__init__(**kwargs)
        self.virtual_ip = virtual_ip
        self.internal_http_port = internal_http_port
        self.internal_https_port = internal_https_port
        self.in_use = in_use


class VirtualNetworkProfile(_serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id of the Virtual Network.
    :vartype id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :ivar subnet: Subnet within the Virtual Network.
    :vartype subnet: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subnet: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource id of the Virtual Network.
        :paramtype id: str
        :keyword subnet: Subnet within the Virtual Network.
        :paramtype subnet: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.subnet = subnet


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access
    to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_name: The Virtual Network name.
    :vartype vnet_name: str
    :ivar vpn_package_uri: The URI where the VPN package can be downloaded.
    :vartype vpn_package_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vpn_package_uri": {"key": "properties.vpnPackageUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_name: The Virtual Network name.
        :paramtype vnet_name: str
        :keyword vpn_package_uri: The URI where the VPN package can be downloaded.
        :paramtype vpn_package_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_id: The Virtual Network's resource ID.
    :vartype vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :vartype cert_blob: bytes
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2016_03_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :ivar dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :vartype dns_servers: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "cert_thumbprint": {"readonly": True},
        "routes": {"readonly": True},
        "resync_required": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_id": {"key": "properties.vnetResourceId", "type": "str"},
        "cert_thumbprint": {"key": "properties.certThumbprint", "type": "str"},
        "cert_blob": {"key": "properties.certBlob", "type": "bytearray"},
        "routes": {"key": "properties.routes", "type": "[VnetRoute]"},
        "resync_required": {"key": "properties.resyncRequired", "type": "bool"},
        "dns_servers": {"key": "properties.dnsServers", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[bytes] = None,
        dns_servers: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_id: The Virtual Network's resource ID.
        :paramtype vnet_resource_id: str
        :keyword cert_blob: A certificate file (.cer) blob containing the public key of the private key
         used to authenticate a
         Point-To-Site VPN connection.
        :paramtype cert_blob: bytes
        :keyword dns_servers: DNS servers to be used by this Virtual Network. This should be a
         comma-separated list of IP addresses.
        :paramtype dns_servers: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint: Optional[str] = None
        self.cert_blob = cert_blob
        self.routes: Optional[List["_models.VnetRoute"]] = None
        self.resync_required: Optional[bool] = None
        self.dns_servers = dns_servers


class VnetParameters(ProxyOnlyResource):
    """The required set of inputs to validate a VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_group: The Resource Group of the VNET to be validated.
    :vartype vnet_resource_group: str
    :ivar vnet_name: The name of the VNET to be validated.
    :vartype vnet_name: str
    :ivar vnet_subnet_name: The subnet name to be validated.
    :vartype vnet_subnet_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_group": {"key": "properties.vnetResourceGroup", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vnet_subnet_name": {"key": "properties.vnetSubnetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_group: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_subnet_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_group: The Resource Group of the VNET to be validated.
        :paramtype vnet_resource_group: str
        :keyword vnet_name: The name of the VNET to be validated.
        :paramtype vnet_name: str
        :keyword vnet_subnet_name: The subnet name to be validated.
        :paramtype vnet_subnet_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_group = vnet_resource_group
        self.vnet_name = vnet_name
        self.vnet_subnet_name = vnet_subnet_name


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_route_name: The name of this route. This is only returned by the server and does not
     need to be set by the client.
    :vartype vnet_route_name: str
    :ivar start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :vartype start_address: str
    :ivar end_address: The ending address for this route. If the start address is specified in CIDR
     notation, this must be omitted.
    :vartype end_address: str
    :ivar route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only

     These values will be used for syncing an app's routes with those from a Virtual Network. Known
     values are: "DEFAULT", "INHERITED", and "STATIC".
    :vartype route_type: str or ~azure.mgmt.web.v2016_03_01.models.RouteType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_route_name": {"key": "properties.name", "type": "str"},
        "start_address": {"key": "properties.startAddress", "type": "str"},
        "end_address": {"key": "properties.endAddress", "type": "str"},
        "route_type": {"key": "properties.routeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_route_name: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_route_name: The name of this route. This is only returned by the server and does
         not need to be set by the client.
        :paramtype vnet_route_name: str
        :keyword start_address: The starting address for this route. This may also include a CIDR
         notation, in which case the end address must not be specified.
        :paramtype start_address: str
        :keyword end_address: The ending address for this route. If the start address is specified in
         CIDR notation, this must be omitted.
        :paramtype end_address: str
        :keyword route_type: The type of route this is:
         DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
         INHERITED - Routes inherited from the real Virtual Network routes
         STATIC - Static route set on the app only

         These values will be used for syncing an app's routes with those from a Virtual Network. Known
         values are: "DEFAULT", "INHERITED", and "STATIC".
        :paramtype route_type: str or ~azure.mgmt.web.v2016_03_01.models.RouteType
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_route_name = vnet_route_name
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class VnetValidationFailureDetails(ProxyOnlyResource):
    """A class that describes the reason for a validation failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar failed: A flag describing whether or not validation failed.
    :vartype failed: bool
    :ivar failed_tests: A list of tests that failed in the validation.
    :vartype failed_tests: list[~azure.mgmt.web.v2016_03_01.models.VnetValidationTestFailure]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "failed": {"key": "properties.failed", "type": "bool"},
        "failed_tests": {"key": "properties.failedTests", "type": "[VnetValidationTestFailure]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        failed: Optional[bool] = None,
        failed_tests: Optional[List["_models.VnetValidationTestFailure"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword failed: A flag describing whether or not validation failed.
        :paramtype failed: bool
        :keyword failed_tests: A list of tests that failed in the validation.
        :paramtype failed_tests: list[~azure.mgmt.web.v2016_03_01.models.VnetValidationTestFailure]
        """
        super().__init__(kind=kind, **kwargs)
        self.failed = failed
        self.failed_tests = failed_tests


class VnetValidationTestFailure(ProxyOnlyResource):
    """A class that describes a test that failed during NSG and UDR validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar test_name: The name of the test that failed.
    :vartype test_name: str
    :ivar details: The details of what caused the failure, e.g. the blocking rule name, etc.
    :vartype details: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "test_name": {"key": "properties.testName", "type": "str"},
        "details": {"key": "properties.details", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        test_name: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword test_name: The name of the test that failed.
        :paramtype test_name: str
        :keyword details: The details of what caused the failure, e.g. the blocking rule name, etc.
        :paramtype details: str
        """
        super().__init__(kind=kind, **kwargs)
        self.test_name = test_name
        self.details = details


class WebAppCollection(_serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2016_03_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Site]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Site"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2016_03_01.models.Site]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class WorkerPool(_serialization.Model):
    """Worker pool of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar worker_size_id: Worker size ID for referencing this worker pool.
    :vartype worker_size_id: int
    :ivar compute_mode: Shared or dedicated app hosting. Known values are: "Shared", "Dedicated",
     and "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2016_03_01.models.ComputeModeOptions
    :ivar worker_size: VM size of the worker pool instances.
    :vartype worker_size: str
    :ivar worker_count: Number of instances in the worker pool.
    :vartype worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        "instance_names": {"readonly": True},
    }

    _attribute_map = {
        "worker_size_id": {"key": "workerSizeId", "type": "int"},
        "compute_mode": {"key": "computeMode", "type": "str"},
        "worker_size": {"key": "workerSize", "type": "str"},
        "worker_count": {"key": "workerCount", "type": "int"},
        "instance_names": {"key": "instanceNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        worker_size_id: Optional[int] = None,
        compute_mode: Optional[Union[str, "_models.ComputeModeOptions"]] = None,
        worker_size: Optional[str] = None,
        worker_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword worker_size_id: Worker size ID for referencing this worker pool.
        :paramtype worker_size_id: int
        :keyword compute_mode: Shared or dedicated app hosting. Known values are: "Shared",
         "Dedicated", and "Dynamic".
        :paramtype compute_mode: str or ~azure.mgmt.web.v2016_03_01.models.ComputeModeOptions
        :keyword worker_size: VM size of the worker pool instances.
        :paramtype worker_size: str
        :keyword worker_count: Number of instances in the worker pool.
        :paramtype worker_count: int
        """
        super().__init__(**kwargs)
        self.worker_size_id = worker_size_id
        self.compute_mode = compute_mode
        self.worker_size = worker_size
        self.worker_count = worker_count
        self.instance_names: Optional[List[str]] = None
