/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.om.RuleParseException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class DefaultSheetErrorHandler
implements SheetErrorHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CSSStyleSheet<?> sheet;
    private LinkedList<String> unknownRules = null;
    private LinkedList<String> ignoredImports = null;
    private LinkedList<RuleParseException> ruleParseErrors = null;
    private LinkedList<String> emptyRules = null;
    private LinkedList<MediaQueryList> badMediaLists = null;
    private LinkedList<String> badAtRules = null;
    private LinkedList<String> badConditions = null;
    private List<CSSRule> ruleList = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;
    private boolean sacWarningMergedState = false;
    private boolean sacErrorMergedState = false;
    private boolean omWarningMergedState = false;
    private boolean omErrorMergedState = false;

    public DefaultSheetErrorHandler(CSSStyleSheet<? extends CSSRule> cSSStyleSheet) {
        this.sheet = cSSStyleSheet;
    }

    @Override
    public void badAtRule(DOMException dOMException, String string) {
        if (this.badAtRules == null) {
            this.badAtRules = new LinkedList();
        }
        this.badAtRules.add(string);
    }

    @Override
    public void badMediaList(MediaQueryList mediaQueryList) {
        if (this.badMediaLists == null) {
            this.badMediaLists = new LinkedList();
        }
        this.badMediaLists.add(mediaQueryList);
    }

    @Override
    public void emptyStyleRule(String string) {
        if (this.emptyRules == null) {
            this.emptyRules = new LinkedList();
        }
        this.emptyRules.add(string);
    }

    @Override
    public void handleSacError(CSSParseException cSSParseException) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
            this.ruleList = new LinkedList<CSSRule>();
        }
        this.sacErrors.add(cSSParseException);
        this.ruleList.add(null);
    }

    @Override
    public void handleSacWarning(CSSParseException cSSParseException) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(cSSParseException);
    }

    @Override
    public boolean hasOMErrors() {
        return this.omErrorMergedState || this.unknownRules != null || this.ignoredImports != null || this.ruleParseErrors != null || this.badMediaLists != null || this.badAtRules != null || this.badConditions != null;
    }

    @Override
    public boolean hasOMWarnings() {
        return this.omWarningMergedState || this.emptyRules != null;
    }

    @Override
    public boolean hasSacErrors() {
        return this.sacErrorMergedState || this.sacErrors != null;
    }

    @Override
    public boolean hasSacWarnings() {
        return this.sacWarningMergedState || this.sacWarnings != null;
    }

    @Override
    public void ignoredImport(String string) {
        if (this.ignoredImports == null) {
            this.ignoredImports = new LinkedList();
        }
        this.ignoredImports.add(string);
    }

    @Override
    public void ruleParseError(CSSRule cSSRule, CSSParseException cSSParseException) {
        if (this.ruleParseErrors == null) {
            this.ruleParseErrors = new LinkedList();
        }
        RuleParseException ruleParseException = new RuleParseException(cSSParseException, cSSRule);
        this.ruleParseErrors.add(ruleParseException);
    }

    @Override
    public void ruleParseWarning(CSSRule cSSRule, CSSParseException cSSParseException) {
    }

    @Override
    public void conditionalRuleError(BooleanCondition booleanCondition, String string) {
        if (this.badConditions == null) {
            this.badConditions = new LinkedList();
        }
        this.badConditions.add(string);
    }

    @Override
    public void fontFormatError(CSSFontFaceRule cSSFontFaceRule, Exception exception) {
    }

    @Override
    public void unknownRule(String string) {
        if (this.unknownRules == null) {
            this.unknownRules = new LinkedList();
        }
        this.unknownRules.add(string);
    }

    @Override
    public void mapError(CSSParseException cSSParseException, CSSRule cSSRule) {
        if (this.ruleList == null) {
            this.ruleList = new LinkedList<CSSRule>();
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(cSSParseException);
        this.ruleList.add(cSSRule);
    }

    public LinkedList<String> getBadAtRules() {
        return this.badAtRules;
    }

    @Deprecated
    public LinkedList<String> getBadInlineStyles() {
        return null;
    }

    public LinkedList<String> getConditionErrors() {
        return this.badConditions;
    }

    public LinkedList<MediaQueryList> getBadMediaLists() {
        return this.badMediaLists;
    }

    public LinkedList<String> getEmptyStyleRules() {
        return this.emptyRules;
    }

    public LinkedList<String> getIgnoredImports() {
        return this.ignoredImports;
    }

    public CSSRule getRuleAtError(int n) {
        return this.ruleList == null ? null : this.ruleList.get(n);
    }

    public LinkedList<RuleParseException> getRuleParseErrors() {
        return this.ruleParseErrors;
    }

    public List<CSSParseException> getSacErrors() {
        return this.sacErrors;
    }

    public List<CSSParseException> getSacWarnings() {
        return this.sacWarnings;
    }

    public LinkedList<String> getUnknownRules() {
        return this.unknownRules;
    }

    @Override
    public void mergeState(SheetErrorHandler sheetErrorHandler) {
        this.sacWarningMergedState = this.sacWarningMergedState || sheetErrorHandler.hasSacWarnings();
        this.sacErrorMergedState = this.sacErrorMergedState || sheetErrorHandler.hasSacErrors();
        this.omErrorMergedState = this.omErrorMergedState || sheetErrorHandler.hasOMErrors();
        this.omWarningMergedState = this.omWarningMergedState || sheetErrorHandler.hasOMWarnings();
    }

    @Override
    public void reset() {
        this.ruleList = null;
        this.sacErrors = null;
        this.sacWarnings = null;
        this.sacErrorMergedState = false;
        this.sacWarningMergedState = false;
        this.omErrorMergedState = false;
        this.unknownRules = null;
        this.ignoredImports = null;
        this.ruleParseErrors = null;
        this.emptyRules = null;
        this.badMediaLists = null;
        this.badAtRules = null;
        this.badConditions = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        if (this.hasSacErrors()) {
            stringBuilder.append("NSAC Errors:");
            if (this.sacErrors != null) {
                stringBuilder.append('\n');
                for (int i = 0; i < this.sacErrors.size(); ++i) {
                    CSSParseException cSSParseException = this.sacErrors.get(i);
                    CSSRule cSSRule = this.ruleList.get(i);
                    stringBuilder.append('[').append(cSSParseException.getLineNumber()).append(':').append(cSSParseException.getColumnNumber()).append("] ").append(cSSParseException.getMessage());
                    if (cSSRule != null) {
                        stringBuilder.append(" --> ").append(cSSRule.getCssText());
                    }
                    stringBuilder.append('\n');
                }
            } else {
                stringBuilder.append(" only merged.\n");
            }
        } else {
            stringBuilder.append("No NSAC errors.\n");
        }
        if (this.sacWarnings != null) {
            stringBuilder.append("NSAC Warnings:");
            Iterator<CSSParseException> iterator = this.sacWarnings.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(' ').append(iterator.next().getMessage());
            }
        } else {
            stringBuilder.append("No NSAC warnings.\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void sacMalfunction(String string) {
        String string2 = "unknown";
        Node node = this.sheet.getOwnerNode();
        if (node != null && node.getNodeType() == 1 && "style".equalsIgnoreCase(((CSSElement)node).getTagName())) {
            string2 = node.toString();
        } else {
            String string3 = this.sheet.getHref();
            if (string3 != null) {
                string2 = "at " + string3;
            }
        }
        string = "NSAC malfuntion in sheet " + string2 + ": " + string;
        throw new IllegalStateException(string);
    }
}

