/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.virtual.threads;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

class ContextPreservingExecutorService
implements ExecutorService {
    private final ExecutorService delegate;

    ContextPreservingExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
    }

    private static Runnable decorate(Runnable command) {
        Objects.requireNonNull(command);
        return new ContextPreservingRunnable(command);
    }

    private static <T> Callable<T> decorate(Callable<T> task) {
        Objects.requireNonNull(task);
        return new ContextPreservingCallable<T>(task);
    }

    private static <T> Collection<? extends Callable<T>> decorateAll(Collection<? extends Callable<T>> tasks) {
        Objects.requireNonNull(tasks);
        return tasks.stream().map(ContextPreservingExecutorService::decorate).collect(Collectors.toList());
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(ContextPreservingExecutorService.decorate(command));
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(ContextPreservingExecutorService.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.submit(Executors.callable(task, result));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(ContextPreservingExecutorService.decorate(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(ContextPreservingExecutorService.decorateAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(ContextPreservingExecutorService.decorateAll(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(ContextPreservingExecutorService.decorateAll(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(ContextPreservingExecutorService.decorateAll(tasks), timeout, unit);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static final class ContextPreservingRunnable
    implements Runnable {
        private final Runnable task;
        private final Context context;

        public ContextPreservingRunnable(Runnable task) {
            this.task = task;
            this.context = Vertx.currentContext();
        }

        @Override
        public void run() {
            if (this.context instanceof ContextInternal) {
                ContextInternal contextInternal = (ContextInternal)this.context;
                ContextInternal previousContext = contextInternal.beginDispatch();
                try {
                    this.task.run();
                }
                finally {
                    contextInternal.endDispatch(previousContext);
                }
            } else {
                this.task.run();
            }
        }
    }

    private static final class ContextPreservingCallable<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final Context context;

        public ContextPreservingCallable(Callable<T> task) {
            this.task = task;
            this.context = Vertx.currentContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            if (this.context instanceof ContextInternal) {
                ContextInternal contextInternal = (ContextInternal)this.context;
                ContextInternal previousContext = contextInternal.beginDispatch();
                try {
                    T t = this.task.call();
                    return t;
                }
                finally {
                    contextInternal.endDispatch(previousContext);
                }
            }
            return this.task.call();
        }
    }
}

