/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos.impl;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.KerberosJdkProvider;
import org.keycloak.federation.kerberos.CommonKerberosConfig;

public class KerberosServerSubjectAuthenticator {
    private static final Logger logger = Logger.getLogger(KerberosServerSubjectAuthenticator.class);
    private static final CallbackHandler NO_CALLBACK_HANDLER = new CallbackHandler(){

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            throw new UnsupportedCallbackException(callbacks[0]);
        }
    };
    private final CommonKerberosConfig config;
    private LoginContext loginContext;

    public KerberosServerSubjectAuthenticator(CommonKerberosConfig config) {
        this.config = config;
    }

    public Subject authenticateServerSubject() throws LoginException {
        Configuration config = this.createJaasConfiguration();
        this.loginContext = new LoginContext("does-not-matter", null, NO_CALLBACK_HANDLER, config);
        this.loginContext.login();
        return this.loginContext.getSubject();
    }

    public void logoutServerSubject() {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException le) {
                logger.error((Object)("Failed to logout kerberos server subject: " + this.config.getServerPrincipal()), (Throwable)le);
            }
        }
    }

    protected Configuration createJaasConfiguration() {
        return KerberosJdkProvider.getProvider().createJaasConfigurationForServer(this.config.getKeyTab(), this.config.getServerPrincipal(), this.config.isDebug());
    }
}

