/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class DiscriminatedEntityInitializer
extends AbstractInitializer<DiscriminatedEntityInitializerData>
implements EntityInitializer<DiscriminatedEntityInitializerData> {
    protected final InitializerParent<?> parent;
    private final NavigablePath navigablePath;
    private final boolean isPartOfKey;
    private final DomainResultAssembler<?> discriminatorValueAssembler;
    private final DomainResultAssembler<?> keyValueAssembler;
    private final DiscriminatedAssociationModelPart fetchedPart;
    private final boolean eager;
    private final boolean resultInitializer;
    private final boolean keyIsEager;
    private final boolean hasLazySubInitializer;

    public DiscriminatedEntityInitializer(InitializerParent<?> parent, DiscriminatedAssociationModelPart fetchedPart, NavigablePath fetchedNavigable, Fetch discriminatorFetch, Fetch keyFetch, boolean eager, boolean resultInitializer, AssemblerCreationState creationState) {
        super(creationState);
        this.parent = parent;
        this.fetchedPart = fetchedPart;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parent);
        this.discriminatorValueAssembler = discriminatorFetch.createAssembler(this, creationState);
        this.keyValueAssembler = keyFetch.createAssembler(this, creationState);
        this.eager = eager;
        this.resultInitializer = resultInitializer;
        Initializer<?> initializer = this.keyValueAssembler.getInitializer();
        if (initializer == null) {
            this.keyIsEager = false;
            this.hasLazySubInitializer = false;
        } else {
            this.keyIsEager = initializer.isEager();
            this.hasLazySubInitializer = !initializer.isEager() || initializer.hasLazySubInitializers();
        }
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new DiscriminatedEntityInitializerData(rowProcessingState);
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.fetchedPart;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(DiscriminatedEntityInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object discriminatorValue = this.discriminatorValueAssembler.assemble(rowProcessingState);
        if (discriminatorValue == null) {
            data.setState(Initializer.State.MISSING);
            data.concreteDescriptor = null;
            data.entityIdentifier = null;
            data.setInstance(null);
            assert (this.keyValueAssembler.assemble(rowProcessingState) == null);
        } else {
            data.setState(Initializer.State.KEY_RESOLVED);
            data.concreteDescriptor = this.fetchedPart.resolveDiscriminatorValue(discriminatorValue).getEntityPersister();
            data.entityIdentifier = this.keyValueAssembler.assemble(rowProcessingState);
        }
    }

    @Override
    public void resolveState(DiscriminatedEntityInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        this.discriminatorValueAssembler.resolveState(rowProcessingState);
        this.keyValueAssembler.resolveState(rowProcessingState);
    }

    @Override
    public void resolveFromPreviousRow(DiscriminatedEntityInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            if (data.getInstance() == null) {
                data.setState(Initializer.State.MISSING);
            } else {
                Initializer<?> initializer = this.keyValueAssembler.getInitializer();
                if (initializer != null) {
                    initializer.resolveFromPreviousRow(data.getRowProcessingState());
                }
                data.setState(Initializer.State.INITIALIZED);
            }
        }
    }

    @Override
    public void resolveInstance(DiscriminatedEntityInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
        EntityKey entityKey = new EntityKey(data.entityIdentifier, data.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
        if (holder != null) {
            Object instance = holder.getEntity();
            data.setInstance(instance);
            if (holder.getEntityInitializer() == null) {
                if (instance != null && Hibernate.isInitialized(instance)) {
                    return;
                }
            } else {
                if (holder.getEntityInitializer() != this) {
                    return;
                }
                if (instance == null) {
                    assert (holder.getProxy() == null) : "How to handle this case?";
                    return;
                }
            }
        }
        data.setInstance(session.internalLoad(data.concreteDescriptor.getEntityName(), data.entityIdentifier, this.eager, false));
    }

    @Override
    public void resolveInstance(Object instance, DiscriminatedEntityInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.entityIdentifier = null;
            data.concreteDescriptor = null;
            data.setInstance(null);
        } else {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
            if (lazyInitializer == null) {
                data.setState(Initializer.State.INITIALIZED);
                if (this.keyIsEager) {
                    SharedSessionContractImplementor session = rowProcessingState.getSession();
                    data.concreteDescriptor = session.getEntityPersister(null, instance);
                    data.entityIdentifier = data.concreteDescriptor.getIdentifier(instance, session);
                }
            } else if (lazyInitializer.isUninitialized()) {
                data.setState(this.eager ? Initializer.State.RESOLVED : Initializer.State.INITIALIZED);
                if (this.keyIsEager) {
                    Object discriminatorValue = this.discriminatorValueAssembler.assemble(rowProcessingState);
                    data.concreteDescriptor = this.fetchedPart.resolveDiscriminatorValue(discriminatorValue).getEntityPersister();
                    data.entityIdentifier = lazyInitializer.getInternalIdentifier();
                }
            } else {
                data.setState(Initializer.State.INITIALIZED);
                if (this.keyIsEager) {
                    data.concreteDescriptor = rowProcessingState.getSession().getEntityPersister(null, lazyInitializer.getImplementation());
                    data.entityIdentifier = lazyInitializer.getInternalIdentifier();
                }
            }
            data.setInstance(instance);
            if (this.keyIsEager) {
                Initializer<?> initializer = this.keyValueAssembler.getInitializer();
                assert (initializer != null);
                initializer.resolveInstance(data.entityIdentifier, rowProcessingState);
            } else if (rowProcessingState.needsResolveState()) {
                this.discriminatorValueAssembler.resolveState(rowProcessingState);
                this.keyValueAssembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    public void initializeInstance(DiscriminatedEntityInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        data.setInstance(data.getRowProcessingState().getSession().internalLoad(data.concreteDescriptor.getEntityName(), data.entityIdentifier, this.eager, false));
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, DiscriminatedEntityInitializerData data) {
        Object instance;
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object object = instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
            data.entityIdentifier = null;
            data.concreteDescriptor = null;
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            data.entityIdentifier = null;
            data.concreteDescriptor = null;
            if (this.eager) {
                Hibernate.initialize(instance);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer = this.keyValueAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        throw new UnsupportedOperationException("Discriminated association has no static entity type");
    }

    @Override
    public EntityPersister getConcreteDescriptor(DiscriminatedEntityInitializerData data) {
        return data.concreteDescriptor;
    }

    @Override
    public @Nullable Object getEntityIdentifier(DiscriminatedEntityInitializerData data) {
        return data.entityIdentifier;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEager() {
        return this.eager || this.keyIsEager;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializer;
    }

    @Override
    public boolean isResultInitializer() {
        return this.resultInitializer;
    }

    public String toString() {
        return "DiscriminatedEntityInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    public static class DiscriminatedEntityInitializerData
    extends InitializerData {
        protected EntityPersister concreteDescriptor;
        protected Object entityIdentifier;

        public DiscriminatedEntityInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }
    }
}

