/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.CardinalityExecutionMode;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CardinalityAggregation
extends MetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, CardinalityAggregation> {
    @Nullable
    private final CardinalityExecutionMode executionHint;
    @Nullable
    private final Integer precisionThreshold;
    @Nullable
    private final Boolean rehash;
    public static final JsonpDeserializer<CardinalityAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CardinalityAggregation::setupCardinalityAggregationDeserializer);

    private CardinalityAggregation(Builder builder) {
        super(builder);
        this.executionHint = builder.executionHint;
        this.precisionThreshold = builder.precisionThreshold;
        this.rehash = builder.rehash;
    }

    public static CardinalityAggregation of(Function<Builder, ObjectBuilder<CardinalityAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Cardinality;
    }

    @Nullable
    public final CardinalityExecutionMode executionHint() {
        return this.executionHint;
    }

    @Nullable
    public final Integer precisionThreshold() {
        return this.precisionThreshold;
    }

    @Nullable
    public final Boolean rehash() {
        return this.rehash;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
        if (this.precisionThreshold != null) {
            generator.writeKey("precision_threshold");
            generator.write(this.precisionThreshold.intValue());
        }
        if (this.rehash != null) {
            generator.writeKey("rehash");
            generator.write(this.rehash.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCardinalityAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CardinalityAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::executionHint, CardinalityExecutionMode._DESERIALIZER, "execution_hint");
        op.add(Builder::precisionThreshold, JsonpDeserializer.integerDeserializer(), "precision_threshold");
        op.add(Builder::rehash, JsonpDeserializer.booleanDeserializer(), "rehash");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.executionHint);
        result = 31 * result + Objects.hashCode(this.precisionThreshold);
        result = 31 * result + Objects.hashCode(this.rehash);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardinalityAggregation other = (CardinalityAggregation)o;
        return Objects.equals(this.executionHint, other.executionHint) && Objects.equals(this.precisionThreshold, other.precisionThreshold) && Objects.equals(this.rehash, other.rehash);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CardinalityAggregation> {
        @Nullable
        private CardinalityExecutionMode executionHint;
        @Nullable
        private Integer precisionThreshold;
        @Nullable
        private Boolean rehash;

        public Builder() {
        }

        private Builder(CardinalityAggregation o) {
            super(o);
            this.executionHint = o.executionHint;
            this.precisionThreshold = o.precisionThreshold;
            this.rehash = o.rehash;
        }

        private Builder(Builder o) {
            super(o);
            this.executionHint = o.executionHint;
            this.precisionThreshold = o.precisionThreshold;
            this.rehash = o.rehash;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder executionHint(@Nullable CardinalityExecutionMode value) {
            this.executionHint = value;
            return this;
        }

        @Nonnull
        public final Builder precisionThreshold(@Nullable Integer value) {
            this.precisionThreshold = value;
            return this;
        }

        @Nonnull
        public final Builder rehash(@Nullable Boolean value) {
            this.rehash = value;
            return this;
        }

        @Override
        @Nonnull
        public CardinalityAggregation build() {
            this._checkSingleUse();
            return new CardinalityAggregation(this);
        }
    }
}

