/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.io.Resource;
import com.nulabinc.zxcvbn.matchers.Keyboard;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class KeyboardLoader {
    private final String name;
    private final Resource resource;

    protected KeyboardLoader(String name, Resource resource) {
        this.name = name;
        this.resource = resource;
    }

    public Keyboard load() throws IOException {
        InputStream inputStream = this.resource.getInputStream();
        String layout = KeyboardLoader.loadAsString(inputStream);
        return new Keyboard(this.name, this.buildAdjacentGraphBuilder(layout));
    }

    protected abstract Keyboard.AdjacentGraphBuilder buildAdjacentGraphBuilder(String var1);

    private static String loadAsString(InputStream input) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        try {
            String str;
            StringBuilder sb = new StringBuilder(4096);
            while ((str = reader.readLine()) != null) {
                sb.append(str);
                sb.append('\n');
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        reader.close();
        return string;
    }
}

