/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public class FoundingFatherTest
extends FreeColTestCase {
    private static final GoodsType musketsType = FoundingFatherTest.spec().getGoodsType("model.goods.muskets");
    private static final UnitType servantType = FoundingFatherTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType colonistType = FoundingFatherTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType statesmanType = FoundingFatherTest.spec().getUnitType("model.unit.elderStatesman");

    public void testFeatures() {
        Game game = FoundingFatherTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        FoundingFather father1 = new FoundingFather("father1", FoundingFatherTest.spec());
        father1.setType(FoundingFather.FoundingFatherType.TRADE);
        Ability ability = new Ability("some.new.ability");
        FoundingFatherTest.spec().addAbility(ability);
        father1.addAbility(ability);
        dutch.addFather(father1);
        FoundingFatherTest.assertTrue((boolean)dutch.hasAbility("some.new.ability"));
        FoundingFather father2 = new FoundingFather("father2", FoundingFatherTest.spec());
        father2.setType(FoundingFather.FoundingFatherType.TRADE);
        Modifier modifier = new Modifier("some.new.modifier", 2.0f, Modifier.ModifierType.ADDITIVE, father2);
        father2.addModifier(modifier);
        FoundingFatherTest.spec().addModifier(modifier);
        dutch.addFather(father2);
        List<Modifier> modifiers = CollectionUtils.toList(dutch.getModifiers("some.new.modifier"));
        FoundingFatherTest.assertEquals((int)1, (int)modifiers.size());
        FoundingFatherTest.assertEquals((Object)Float.valueOf(2.0f), (Object)Float.valueOf(CollectionUtils.first(modifiers).getValue()));
        FoundingFatherTest.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(FeatureContainer.applyModifiers(2.0f, null, modifiers)));
        FoundingFather father3 = new FoundingFather("father3", FoundingFatherTest.spec());
        father3.setType(FoundingFather.FoundingFatherType.TRADE);
        father3.addModifier(new Modifier("some.new.modifier", 2.0f, Modifier.ModifierType.ADDITIVE, father3));
        dutch.addFather(father3);
        FoundingFatherTest.assertTrue((boolean)CollectionUtils.any(dutch.getModifiers("some.new.modifier")));
        FoundingFatherTest.assertEquals((Object)Float.valueOf(6.0f), (Object)Float.valueOf(dutch.apply(2.0f, null, "some.new.modifier")));
        FoundingFather father4 = new FoundingFather("father4", FoundingFatherTest.spec());
        father4.setType(FoundingFather.FoundingFatherType.TRADE);
        Ability ability2 = new Ability("some.new.ability", false);
        FoundingFatherTest.assertFalse((boolean)ability.equals(ability2));
        FoundingFatherTest.assertFalse((ability.hashCode() == ability2.hashCode() ? 1 : 0) != 0);
        father4.addAbility(ability2);
        dutch.addFather(father4);
        FoundingFatherTest.assertFalse((boolean)dutch.hasAbility("some.new.ability"));
    }

    public void testAddAllFathers() {
        Game game = FoundingFatherTest.getGame();
        game.changeMap(FoundingFatherTest.getTestMap(true));
        Colony colony = this.getStandardColony(4);
        Player player = colony.getOwner();
        for (FoundingFather father : FoundingFatherTest.spec().getFoundingFathers()) {
            player.addFather(father);
        }
    }

    public void testBellsRequired() {
        int[] expectedValues = new int[]{40, 161, 241, 321, 401};
        Game game = FoundingFatherTest.getGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        FoundingFatherTest.assertEquals((int)40, (int)FoundingFatherTest.spec().getInteger("model.option.foundingFatherFactor"));
        for (int index = 0; index < expectedValues.length; ++index) {
            FoundingFatherTest.assertEquals((int)index, (int)dutch.getFatherCount());
            FoundingFatherTest.assertEquals((int)expectedValues[index], (int)dutch.getTotalFoundingFatherCost());
            FoundingFather father = new FoundingFather("father" + index, FoundingFatherTest.spec());
            dutch.addFather(father);
        }
    }

    public void testAvailableTo() {
        Game game = FoundingFatherTest.getGame();
        for (FoundingFather father : FoundingFatherTest.spec().getFoundingFathers()) {
            for (Player player : game.getPlayerList(CollectionUtils.alwaysTrue())) {
                FoundingFatherTest.assertEquals((String)player.getNationId(), (boolean)player.isEuropean(), (boolean)father.isAvailableTo(player));
            }
        }
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player french = game.getPlayerByNationId("model.nation.french");
        FoundingFather newFather = new FoundingFather("father", FoundingFatherTest.spec());
        newFather.setType(FoundingFather.FoundingFatherType.TRADE);
        Scope dutchScope = new Scope();
        dutchScope.setMethodName("getNationId");
        dutchScope.setMethodValue("model.nation.dutch");
        FoundingFatherTest.assertTrue((boolean)dutchScope.appliesTo(dutch));
        Scope frenchScope = new Scope();
        frenchScope.setMethodName("getNationType");
        frenchScope.setMethodValue("model.nationType.cooperation");
        FoundingFatherTest.assertTrue((boolean)frenchScope.appliesTo(french));
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        scopes.add(dutchScope);
        scopes.add(frenchScope);
        newFather.copyScopes(scopes);
        for (Player player : game.getPlayerList(CollectionUtils.alwaysTrue())) {
            FoundingFatherTest.assertEquals((String)player.getNationId(), (player == french || player == dutch ? 1 : 0) != 0, (boolean)newFather.isAvailableTo(player));
        }
    }
}

