/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class CharsetValidator
extends StringValidator {
    CharsetValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        try {
            Charset.forName(model);
        }
        catch (IllegalCharsetNameException badName) {
            problems.append(LocalizationSupport.getMessage(CharsetValidator.class, "ILLEGAL_CHARSET_NAME", compName, model));
        }
        catch (UnsupportedCharsetException unsup) {
            problems.append(LocalizationSupport.getMessage(CharsetValidator.class, "UNSUPPORTED_CHARSET_NAME", compName, model));
        }
    }
}

