/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.text.BreakIterator;
import java.util.Objects;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleText;
import org.GNOME.Accessibility.AtkComponent;
import org.GNOME.Accessibility.AtkUtil;

public class AtkText {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleText> _acc_text;
    WeakReference<AccessibleEditableText> _acc_edt_text;

    public AtkText(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        this._acc_text = new WeakReference<AccessibleText>(accessibleContext.getAccessibleText());
        this._acc_edt_text = new WeakReference<AccessibleEditableText>(accessibleContext.getAccessibleEditableText());
    }

    public static AtkText createAtkText(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkText(accessibleContext), null);
    }

    public static int getRightStart(int n) {
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public static int getRightEnd(int n, int n2, int n3) {
        if (n2 < -1) {
            return n;
        }
        if (n2 > n3 || n2 == -1) {
            return n3;
        }
        return n2;
    }

    public String get_text(int n, int n2) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            int n3 = AtkText.getRightStart(n);
            int n4 = AtkText.getRightEnd(n, n2, accessibleText.getCharCount());
            if (accessibleText instanceof AccessibleExtendedText) {
                AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)accessibleText);
                return accessibleExtendedText.getTextRange(n3, n4);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n3; i <= n4 - 1; ++i) {
                String string = accessibleText.getAtIndex(1, i);
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }, null);
    }

    public char get_character_at_offset(int n) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return ' ';
        }
        return AtkUtil.invokeInSwing(() -> {
            String string = accessibleText.getAtIndex(1, n);
            if (string == null || string.length() == 0) {
                return Character.valueOf(' ');
            }
            return Character.valueOf(string.charAt(0));
        }, Character.valueOf(' ')).charValue();
    }

    public StringSequence get_text_at_offset(int n, int n2) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> this.private_get_text_at_offset(n, n2), null);
    }

    public StringSequence get_text_before_offset(int n, int n2) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            StringSequence stringSequence = this.private_get_text_at_offset(n, n2);
            if (stringSequence == null) {
                return null;
            }
            return this.private_get_text_at_offset(stringSequence.start_offset - 1, n2);
        }, null);
    }

    public StringSequence get_text_after_offset(int n, int n2) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            StringSequence stringSequence = this.private_get_text_at_offset(n, n2);
            if (stringSequence == null) {
                return null;
            }
            return this.private_get_text_at_offset(stringSequence.end_offset, n2);
        }, null);
    }

    public int get_caret_offset() {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleText.getCaretPosition(), 0);
    }

    public Rectangle get_character_extents(int n, int n2) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            Rectangle rectangle = accessibleText.getCharacterBounds(n);
            if (rectangle == null) {
                return null;
            }
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent == null) {
                return null;
            }
            Point point = AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n2);
            rectangle.x += point.x;
            rectangle.y += point.y;
            return rectangle;
        }, null);
    }

    public int get_character_count() {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> accessibleText.getCharCount(), 0);
    }

    public int get_offset_at_point(int n, int n2, int n3) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return -1;
        }
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return -1;
        }
        return AtkUtil.invokeInSwing(() -> {
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent == null) {
                return -1;
            }
            Point point = AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n3);
            return accessibleText.getIndexAtPoint(new Point(n - point.x, n2 - point.y));
        }, -1);
    }

    public Rectangle get_range_extents(int n, int n2, int n3) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleText instanceof AccessibleExtendedText) {
                int n4;
                AccessibleExtendedText accessibleExtendedText = (AccessibleExtendedText)((Object)accessibleText);
                int n5 = AtkText.getRightStart(n);
                Rectangle rectangle = accessibleExtendedText.getTextBounds(n5, n4 = AtkText.getRightEnd(n, n2, accessibleText.getCharCount()));
                if (rectangle == null) {
                    return null;
                }
                AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
                if (accessibleComponent == null) {
                    return null;
                }
                Point point = AtkComponent.getComponentOrigin(accessibleContext, accessibleComponent, n3);
                rectangle.x += point.x;
                rectangle.y += point.y;
                return rectangle;
            }
            return null;
        }, null);
    }

    public int get_n_selections() {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return 0;
        }
        return AtkUtil.invokeInSwing(() -> {
            String string = accessibleText.getSelectedText();
            if (string != null && string.length() > 0) {
                return 1;
            }
            return 0;
        }, 0);
    }

    public StringSequence get_selection() {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return null;
        }
        return AtkUtil.invokeInSwing(() -> {
            int n = accessibleText.getSelectionStart();
            int n2 = accessibleText.getSelectionEnd();
            String string = accessibleText.getSelectedText();
            if (string == null) {
                return null;
            }
            return new StringSequence(this, string, n, n2);
        }, null);
    }

    public boolean add_selection(int n, int n2) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return false;
        }
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleEditableText == null || this.get_n_selections() > 0) {
                return false;
            }
            int n3 = AtkText.getRightStart(n);
            int n4 = AtkText.getRightEnd(n, n2, accessibleText.getCharCount());
            return this.set_selection(0, n3, n4);
        }, false);
    }

    public boolean remove_selection(int n) {
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleEditableText == null || n > 0) {
                return false;
            }
            accessibleEditableText.selectText(0, 0);
            return true;
        }, false);
    }

    public boolean set_selection(int n, int n2, int n3) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return false;
        }
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleEditableText == null || n > 0) {
                return false;
            }
            int n4 = AtkText.getRightStart(n2);
            int n5 = AtkText.getRightEnd(n2, n3, accessibleText.getCharCount());
            accessibleEditableText.selectText(n4, n5);
            return true;
        }, false);
    }

    public boolean set_caret_offset(int n) {
        AccessibleText accessibleText = (AccessibleText)this._acc_text.get();
        if (accessibleText == null) {
            return false;
        }
        AccessibleEditableText accessibleEditableText = (AccessibleEditableText)this._acc_edt_text.get();
        if (accessibleEditableText == null) {
            return false;
        }
        return AtkUtil.invokeInSwing(() -> {
            if (accessibleEditableText != null) {
                int n2 = AtkText.getRightEnd(0, n, accessibleText.getCharCount());
                accessibleEditableText.selectText(n, n);
                return true;
            }
            return false;
        }, false);
    }

    private int getPartTypeFromBoundary(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: 
            case 4: {
                return 3;
            }
            case 5: 
            case 6: {
                return 4;
            }
        }
        return -1;
    }

    private int getNextWordStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        int n3 = breakIterator.next();
        while (n3 != -1) {
            for (int i = n2; i < n3; ++i) {
                if (!Character.isLetter(string.codePointAt(i))) continue;
                return n2;
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
        return -1;
    }

    private int getNextWordEnd(int n, String string) {
        int n2 = this.getNextWordStart(n, string);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n3 = breakIterator.following(n);
        if (n2 == n3) {
            return breakIterator.following(n2);
        }
        return n3;
    }

    private int getPreviousWordStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        int n3 = breakIterator.next();
        while (n2 != -1) {
            for (int i = n2; i < n3; ++i) {
                if (!Character.isLetter(string.codePointAt(i))) continue;
                return n2;
            }
            n3 = n2;
            n2 = breakIterator.preceding(n3);
        }
        return -1;
    }

    private int getPreviousWordEnd(int n, String string) {
        int n2 = this.getPreviousWordStart(n, string);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n3 = breakIterator.preceding(n);
        if (n2 == n3) {
            return breakIterator.preceding(n2);
        }
        return n3;
    }

    private int getNextSentenceStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.following(n);
        return n2;
    }

    private int getNextSentenceEnd(int n, String string) {
        int n2 = this.getNextSentenceStart(n, string);
        if (n2 == -1) {
            return string.length();
        }
        int n3 = n2;
        while (--n3 >= 0 && Character.isWhitespace(string.charAt(n3))) {
        }
        if (++n3 < n) {
            if ((n2 = this.getNextSentenceStart(n2, string)) == -1) {
                return string.length();
            }
            n3 = n2;
            while (--n3 >= 0 && Character.isWhitespace(string.charAt(n3))) {
            }
            ++n3;
        }
        return n3;
    }

    private int getPreviousSentenceStart(int n, String string) {
        BreakIterator breakIterator = BreakIterator.getSentenceInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.preceding(n);
        return n2;
    }

    private int getPreviousSentenceEnd(int n, String string) {
        int n2 = this.getPreviousSentenceStart(n, string);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.getNextSentenceEnd(n2, string);
        if (n < n3) {
            if ((n2 = this.getPreviousSentenceStart(n2, string)) == -1) {
                return 0;
            }
            n3 = this.getNextSentenceEnd(n2, string);
        }
        return n3;
    }

    private int getNextLineStart(int n, String string) {
        int n2 = string.length();
        while (n < n2) {
            if (string.charAt(n) == '\n') {
                return n + 1;
            }
            ++n;
        }
        return n;
    }

    private int getPreviousLineStart(int n, String string) {
        n -= 2;
        while (n >= 0) {
            if (string.charAt(n) == '\n') {
                return n + 1;
            }
            --n;
        }
        return 0;
    }

    private int getNextLineEnd(int n, String string) {
        int n2 = string.length();
        ++n;
        while (n < n2) {
            if (string.charAt(n) == '\n') {
                return n;
            }
            ++n;
        }
        return n;
    }

    private int getPreviousLineEnd(int n, String string) {
        --n;
        while (n >= 0) {
            if (string.charAt(n) == '\n') {
                return n;
            }
            --n;
        }
        return 0;
    }

    private StringSequence private_get_text_at_offset(int n, int n2) {
        int n3 = this.get_character_count();
        if (n < 0 || n > n3) {
            return null;
        }
        switch (n2) {
            case 0: {
                if (n == n3) {
                    return null;
                }
                String string = this.get_text(n, n + 1);
                return new StringSequence(this, string, n, n + 1);
            }
            case 1: {
                int n4;
                if (n == n3) {
                    return new StringSequence(this, "", n3, n3);
                }
                String string = this.get_text(0, n3);
                int n5 = this.getPreviousWordStart(n + 1, string);
                if (n5 == -1) {
                    n5 = 0;
                }
                if ((n4 = this.getNextWordStart(n, string)) == -1) {
                    n4 = string.length();
                }
                String string2 = this.get_text(n5, n4);
                return new StringSequence(this, string2, n5, n4);
            }
            case 2: {
                int n6;
                if (n == 0) {
                    return new StringSequence(this, "", 0, 0);
                }
                String string = this.get_text(0, n3);
                int n7 = this.getPreviousWordEnd(n, string);
                if (n7 == -1) {
                    n7 = 0;
                }
                if ((n6 = this.getNextWordEnd(n - 1, string)) == -1) {
                    n6 = string.length();
                }
                String string3 = this.get_text(n7, n6);
                return new StringSequence(this, string3, n7, n6);
            }
            case 3: {
                int n8;
                if (n == n3) {
                    return new StringSequence(this, "", n3, n3);
                }
                String string = this.get_text(0, n3);
                int n9 = this.getPreviousSentenceStart(n + 1, string);
                if (n9 == -1) {
                    n9 = 0;
                }
                if ((n8 = this.getNextSentenceStart(n, string)) == -1) {
                    n8 = string.length();
                }
                String string4 = this.get_text(n9, n8);
                return new StringSequence(this, string4, n9, n8);
            }
            case 4: {
                int n10;
                if (n == 0) {
                    return new StringSequence(this, "", 0, 0);
                }
                String string = this.get_text(0, n3);
                int n11 = this.getPreviousSentenceEnd(n, string);
                if (n11 == -1) {
                    n11 = 0;
                }
                if ((n10 = this.getNextSentenceEnd(n - 1, string)) == -1) {
                    n10 = string.length();
                }
                String string5 = this.get_text(n11, n10);
                return new StringSequence(this, string5, n11, n10);
            }
            case 5: {
                if (n == n3) {
                    return new StringSequence(this, "", n3, n3);
                }
                String string = this.get_text(0, n3);
                int n12 = this.getPreviousLineStart(n + 1, string);
                int n13 = this.getNextLineStart(n, string);
                String string6 = this.get_text(n12, n13);
                return new StringSequence(this, string6, n12, n13);
            }
            case 6: {
                String string = this.get_text(0, n3);
                int n14 = this.getPreviousLineEnd(n, string);
                int n15 = this.getNextLineEnd(n - 1, string);
                String string7 = this.get_text(n14, n15);
                return new StringSequence(this, string7, n14, n15);
            }
        }
        return null;
    }

    public class StringSequence {
        public String str;
        public int start_offset;
        public int end_offset;

        public StringSequence(AtkText atkText, String string, int n, int n2) {
            Objects.requireNonNull(atkText);
            this.str = string;
            this.start_offset = n;
            this.end_offset = n2;
        }
    }
}

