/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class JsonpObjectImpl
extends AbstractMap<String, JsonValue>
implements Wrapper,
JsonObject {
    OracleJsonObject wrapped;

    public JsonpObjectImpl(OracleJsonObject wrapped) {
        this.wrapped = wrapped;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public boolean getBoolean(String name) {
        return this.wrapped.getBoolean(name);
    }

    public boolean getBoolean(String name, boolean value) {
        return this.wrapped.getBoolean(name, value);
    }

    public int getInt(String name) {
        return this.wrapped.getInt(name);
    }

    public int getInt(String name, int value) {
        return this.wrapped.getInt(name, value);
    }

    public JsonArray getJsonArray(String name) {
        return ((OracleJsonValue)this.wrapped.get(name)).asJsonArray().wrap(JsonArray.class);
    }

    public JsonNumber getJsonNumber(String name) {
        return ((OracleJsonValue)this.wrapped.get(name)).wrap(JsonNumber.class);
    }

    public JsonObject getJsonObject(String name) {
        return ((OracleJsonValue)this.wrapped.get(name)).asJsonObject().wrap(JsonObject.class);
    }

    public JsonString getJsonString(String name) {
        return ((OracleJsonValue)this.wrapped.get(name)).wrap(JsonString.class);
    }

    public String getString(String name) {
        return ((JsonString)this.get(name)).getString();
    }

    public String getString(String name, String defaultValue) {
        JsonValue v = this.get(name);
        if (v == null || v.getValueType() != JsonValue.ValueType.STRING) {
            return defaultValue;
        }
        return ((JsonString)v).getString();
    }

    public boolean isNull(String name) {
        return this.wrapped.isNull(name);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.wrapped);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(OracleJsonObject.class);
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new AbstractSet<Map.Entry<String, JsonValue>>(){

            @Override
            public Iterator<Map.Entry<String, JsonValue>> iterator() {
                return new Iterator<Map.Entry<String, JsonValue>>(){
                    Iterator<Map.Entry<String, OracleJsonValue>> iter;
                    {
                        this.iter = JsonpObjectImpl.this.wrapped.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<String, JsonValue> next() {
                        final Map.Entry<String, OracleJsonValue> oentry = this.iter.next();
                        return new Map.Entry<String, JsonValue>(){

                            @Override
                            public String getKey() {
                                return (String)oentry.getKey();
                            }

                            @Override
                            public JsonValue getValue() {
                                return ((OracleJsonValue)oentry.getValue()).wrap(JsonValue.class);
                            }

                            @Override
                            public JsonValue setValue(JsonValue value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return JsonpObjectImpl.this.wrapped.size();
            }
        };
    }

    @Override
    public JsonValue get(Object name) {
        OracleJsonValue v = (OracleJsonValue)this.wrapped.get(name);
        if (v == null) {
            return null;
        }
        return v.wrap(JsonValue.class);
    }

    @Override
    public boolean containsKey(Object name) {
        return this.wrapped.containsKey(name);
    }
}

