/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDilateObjectMorphologyImageFilter_h
#define sitkDilateObjectMorphologyImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class DilateObjectMorphologyImageFilter
\brief dilation of an object in an image

Dilate an image using binary morphology. Pixel values matching the object value are considered the "foreground" and all other pixels are "background". This is useful in processing mask images containing only one object.

If a pixel's value is equal to the object value and the pixel is adjacent to a non-object valued pixel, then the kernel is centered on the object-value pixel and neighboring pixels covered by the kernel are assigned the object value. The structuring element is assumed to be composed of binary values (zero or one).

\see ObjectMorphologyImageFilter , ErodeObjectMorphologyImageFilter 


\see BinaryDilateImageFilter
\sa itk::simple::DilateObjectMorphology for the procedural interface
\sa itk::DilateObjectMorphologyImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DilateObjectMorphologyImageFilter : public ImageFilter {
    public:
      using Self = DilateObjectMorphologyImageFilter;

      /** Destructor */
      virtual ~DilateObjectMorphologyImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DilateObjectMorphologyImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set the radius of the kernel structuring element.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius ( std::vector<unsigned int> KernelRadius ) { this->m_KernelRadius = std::move(KernelRadius); return *this; }

      /** Set the values of the KernelRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius( unsigned int value ) { this->m_KernelRadius = std::vector<unsigned int>(3, value); return *this; }

      /**
       * Get the radius of the kernel structuring element.
       */
      std::vector<unsigned int> GetKernelRadius() const { return this->m_KernelRadius; }\

      /**
       * Set the kernel or structuring element used for the morphology.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType ( KernelEnum KernelType ) { this->m_KernelType = KernelType; return *this; }

      /**
       * Get the kernel or structuring element used for the morphology.
       */
      KernelEnum GetKernelType() const { return this->m_KernelType; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetObjectValue ( double ObjectValue ) { this->m_ObjectValue = ObjectValue; return *this; }

      /**
       */
      double GetObjectValue() const { return this->m_ObjectValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("DilateObjectMorphologyImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_KernelRadius{std::vector<uint32_t>(3, 1)};

      KernelEnum  m_KernelType{itk::simple::sitkBall};

      /* Value to assign to object pixels */
      double  m_ObjectValue{1};


    };

    /**\
     * \brief dilation of an object in an image
     *
     * This function directly calls the execute method of DilateObjectMorphologyImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::DilateObjectMorphologyImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image DilateObjectMorphology ( const Image& image1, std::vector<unsigned int> kernelRadius = std::vector<uint32_t>(3, 1), KernelEnum kernelType = itk::simple::sitkBall, double objectValue = 1 );

     /** @} */
}
#endif
