/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarPostDataParam;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPostDataParams {
    private List<HarPostDataParam> postDataParams = new ArrayList<HarPostDataParam>();

    public HarPostDataParams() {
    }

    public HarPostDataParams(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("[ missing after \"params\" element " + jp.getCurrentName(), jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            this.addPostDataParam(new HarPostDataParam(jp, warnings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarPostDataParams(HarDatabaseConfig config, long requestId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + HarPostDataParam.TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,name,value,filename,content_type,comment FROM " + tableName + " WHERE post_id=?");
            ps.setLong(1, requestId);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addPostDataParam(new HarPostDataParam(config, rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6)));
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeArrayFieldStart("params");
        for (HarPostDataParam param : this.postDataParams) {
            param.writeHar(g);
        }
        g.writeEndArray();
    }

    public void writeJDBC(HarDatabaseConfig config, long postId, PreparedStatement paramsPs, long logId) throws SQLException {
        for (HarPostDataParam param : this.postDataParams) {
            param.writeJDBC(config, postId, paramsPs, logId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId) throws SQLException {
        Connection c = config.getConnection();
        String postDataParamName = config.getTablePrefix() + HarPostDataParam.TABLE_NAME;
        if (!config.isCreatedTable(postDataParamName)) {
            return;
        }
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + postDataParamName + " WHERE post_id IN (SELECT id FROM " + config.getTablePrefix() + "post WHERE id IN(SELECT entry_id FROM " + config.getTablePrefix() + "entries WHERE log_id=?))");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, postDataParamName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            config.closeConnection(c);
        }
    }

    public void addPostDataParam(HarPostDataParam postDataParam) {
        this.postDataParams.add(postDataParam);
    }

    public List<HarPostDataParam> getPostDataParams() {
        return this.postDataParams;
    }

    public void setPostDataParams(List<HarPostDataParam> postDataParams) {
        this.postDataParams = postDataParams;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  \"params\": [");
        if (this.postDataParams != null) {
            boolean first = true;
            for (HarPostDataParam param : this.postDataParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param);
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

