use strict;
use warnings;

use TestRail::API;
use Test::More 'tests' => 145;
use Test::Fatal;
use Class::Inspector;
use Test::LWP::UserAgent;
use HTTP::Response;
use Capture::Tiny qw{capture};

my $tr = TestRail::API->new('http://hokum.bogus','bogus','bogus',undef,1);
$tr->{'browser'} = Test::LWP::UserAgent->new();
$tr->{'browser'}->map_response(qr/.*/, HTTP::Response->new('500', 'ERROR', ['Content-Type' => 'text/plain'], ''));

#No-arg functions
is( exception { capture { $tr->getCaseTypes()  } },undef,'getCaseTypes returns no error when no arguments are passed');
is( exception { capture { $tr->getPossibleTestStatuses()  } },undef,'getPossibleTestStatuses returns no error when no arguments are passed');
is( exception { capture { $tr->getPriorities()  } },undef,'getPriorities returns no error when no arguments are passed');
is( exception { capture { $tr->getProjects()  } },undef,'getProjects returns no error when no arguments are passed');
is( exception { capture { $tr->getTestResultFields()  } },undef,'getTestResultFields returns no error when no arguments are passed');
is( exception { capture { $tr->getUsers()  } },undef,'getUsers returns no error when no arguments are passed');

isnt( exception { capture { $tr->createCase()  } },undef,'createCase returns error when no arguments are passed');
isnt( exception { capture { $tr->createMilestone()  } },undef,'createMilestone returns error when no arguments are passed');
isnt( exception { capture { $tr->createPlan()  } },undef,'createPlan returns error when no arguments are passed');
isnt( exception { capture { $tr->createProject()  } },undef,'createProject returns error when no arguments are passed');
isnt( exception { capture { $tr->createRun()  } },undef,'createRun returns error when no arguments are passed');
isnt( exception { capture { $tr->createSection()  } },undef,'createSection returns error when no arguments are passed');
isnt( exception { capture { $tr->createTestResults()  } },undef,'createTestResults returns error when no arguments are passed');
isnt( exception { capture { $tr->createTestSuite()  } },undef,'createTestSuite returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteCase()  } },undef,'deleteCase returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteMilestone()  } },undef,'deleteMilestone returns error when no arguments are passed');
isnt( exception { capture { $tr->deletePlan()  } },undef,'deletePlan returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteProject()  } },undef,'deleteProject returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteRun()  } },undef,'deleteRun returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteSection()  } },undef,'deleteSection returns error when no arguments are passed');
isnt( exception { capture { $tr->deleteTestSuite()  } },undef,'deleteTestSuite returns error when no arguments are passed');
isnt( exception { capture { $tr->getCaseByID()  } },undef,'getCaseByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getCaseByName()  } },undef,'getCaseByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getCaseTypeByName()  } },undef,'getCaseTypeByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getCases()  } },undef,'getCases returns error when no arguments are passed');
isnt( exception { capture { $tr->getMilestoneByID()  } },undef,'getMilestoneByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getMilestoneByName()  } },undef,'getMilestoneByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getPlanByID()  } },undef,'getPlanByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getPlanByName()  } },undef,'getPlanByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getPriorityByName()  } },undef,'getPriorityByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getProjectByID()  } },undef,'getProjectByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getProjectByName()  } },undef,'getProjectByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getRunByID()  } },undef,'getRunByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getRunByName()  } },undef,'getRunByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getSectionByID()  } },undef,'getSectionByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getSectionByName()  } },undef,'getSectionByName returns error when no arguments are passed');
isnt( exception { capture { $tr->sectionNamesToIds()  } },undef,'sectionNamesToIds returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestByID()  } },undef,'getTestByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestByName()  } },undef,'getTestByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestResults()  } },undef,'getTestResults returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestResultFieldByName()  } },undef,'getTestResultFieldByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestSuiteByID()  } },undef,'getTestSuiteByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestSuiteByName()  } },undef,'getTestSuiteByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getUserByEmail()  } },0,'getUserByEmail returns error when no arguments are passed');
isnt( exception { capture { $tr->getUserByID()  } },0,'getUserByID returns error when no arguments are passed');
isnt( exception { capture { $tr->getUserByName()  } },0,'getUserByName returns error when no arguments are passed');
isnt( exception { capture { $tr->getTests()  } },undef,'getTests returns error when no arguments are passed');
isnt( exception { capture { $tr->getTestSuites()  } },undef,'getTestSuites returns error when no arguments are passed');
isnt( exception { capture { $tr->getSections()  } },undef,'getSections returns error when no arguments are passed');
isnt( exception { capture { $tr->getRuns()  } },undef,'getRuns returns error when no arguments are passed');
isnt( exception { capture { $tr->getRunsPaginated()  } },undef,'getRunsPaginated returns error when no arguments are passed');
isnt( exception { capture { $tr->getPlans()  } },undef,'getPlans returns error when no arguments are passed');
isnt( exception { capture { $tr->getPlansPaginated()  } },undef,'getPlansPaginated returns error when no arguments are passed');
isnt( exception { capture { $tr->getMilestones()  } },undef,'getMilestones returns error when no arguments are passed');
isnt( exception { capture { $tr->getConfigurationGroups()  } },undef,'getConfigurations returns error when no arguments are passed');
isnt( exception { capture { $tr->getConfigurations()  } },undef,'getConfigurationGroups returns error when no arguments are passed');
isnt( exception { capture { $tr->getChildRuns()  } },undef,'getChildRuns returns error when no arguments are passed');
isnt( exception { capture { $tr->getChildRunByName()  } },undef,'getChildRunByName returns error when no arguments are passed');
isnt( exception { capture { $tr->createRunInPlan()  } },undef,'createRunInPlan returns error when no arguments are passed');
isnt( exception { capture { $tr->translateConfigNamesToIds() } }, undef,'translateConfigNamesToIds returns error when no arguments are passed');
isnt( exception { capture { $tr->userNamesToIds() } }, undef,'userNamesToIds returns error when no arguments are passed');
isnt( exception { capture { $tr->statusNamesToIds() } }, undef,'statusNamesToIds returns error when no arguments are passed');
isnt( exception { capture { $tr->getRunSummary() } }, undef,'getRunSummary returns error when no arguments are passed');
isnt( exception { capture { $tr->getPlanSummary() } }, undef,'getPlanSummary returns error when no arguments are passed');
isnt( exception { capture { $tr->bulkAddResults() } }, undef,'bulkAddResults returns error when no arguments are passed');

#1-arg functions
is(exception { capture { $tr->deleteCase(1) } },            undef,'deleteCase returns no error when int arg passed');
is(exception { capture { $tr->deleteMilestone(1) } },       undef,'deleteMilestone returns no error when int arg passed');
is(exception { capture { $tr->deletePlan(1) } },            undef,'deletePlan returns no error when int arg passed');
is(exception { capture { $tr->deleteProject(1) } },         undef,'deleteProject returns no error when int arg passed');
is(exception { capture { $tr->deleteRun(1) } },             undef,'deleteRun returns no error when int arg passed');
is(exception { capture { $tr->deleteSection(1) } },         undef,'deleteSection returns no error when int arg passed');
is(exception { capture { $tr->deleteTestSuite(1) } },       undef,'deleteTestSuite returns no error when int arg passed');
is(exception { capture { $tr->getCaseByID(1) } },           undef,'getCaseByID returns no error when int arg passed');
is(exception { capture { $tr->getRuns(1) } },               undef,'getRuns returns no error when int arg passed');
is(exception { capture { $tr->getRunsPaginated(1) } },      undef,'getRunsPaginated returns no error when int arg passed');
is(exception { capture { $tr->getSectionByID(1) } },        undef,'getSectionByID returns no error when int arg passed');
is(exception { capture { $tr->getTestByID(1) } },           undef,'getTestByID returns no error when int arg passed');
is(exception { capture { $tr->getTestSuiteByID(1) } },      undef,'getTestSuiteByID returns no error when int arg passed');
is(exception { capture { $tr->getPlans(1) } },              undef,'getPlans returns no error when int arg passed');
is(exception { capture { $tr->getPlansPaginated(1) } },     undef,'getPlansPaginated returns no error when int arg passed');
is(exception { capture { $tr->getProjectByID(1) } },        undef,'getProjectByID returns no error when int arg passed');
is(exception { capture { $tr->getRunByID(1) } },            undef,'getRunByID returns no error when int arg passed');
is(exception { capture { $tr->getTestSuites(1) } },         undef,'getTestSuites returns no error when int arg passed');
is(exception { capture { $tr->getTests(1) } },              undef,'getTests returns no error when int arg passed');
is(exception { capture { $tr->getUserByID(1) } },           undef,'getUserByID returns no error when int arg passed');
is(exception { capture { $tr->getMilestones(1) } },         undef,'getMilestones returns no error when int arg passed');
is(exception { capture { $tr->getPlanByID(1) } },           undef,'getPlanByID returns no error when int arg passed');
is(exception { capture { $tr->getProjectByName('fake') } }, undef,'getProjectByName returns no error when string arg passed');
is(exception { capture { $tr->getUserByEmail('tickle') } }, undef,'getUserByEmail returns no error when string arg passed');
is(exception { capture { $tr->getUserByName('zap') } },     undef,'getUserByName returns no error when string arg passed');
is(exception { capture { $tr->getCaseTypeByName('zap') } }, undef,'getCaseTypeByName returns no error when string arg passed');
is(exception { capture { $tr->createProject('zippy') } },   undef,'createProject returns no error when string arg passed');
is(exception { capture { $tr->getTestResults(1) } },        undef,'getTestResults with 1 arg returns no error');
is(exception { capture { $tr->getMilestoneByID(1) } },      undef,'getMilestoneByID with 1 arg returns no error');
is(exception { capture { $tr->getConfigurationGroups(1) } },undef,'getConfigurationGroups with 1 arg returns no error');
is(exception { capture { $tr->getConfigurations(1) } },     undef,'getConfigurations with 1 arg returns no error');
is(exception { capture { $tr->getChildRuns({})  } },        undef,'getChildRuns returns no error when 1 argument passed');

isnt(exception { capture { $tr->createCase(1) } }, undef,'createCase with 1 arg returns error');
isnt(exception { capture { $tr->createMilestone(1) } }, undef,'createMilestone with 1 arg returns error');
isnt(exception { capture { $tr->createPlan(1) } }, undef,'createPlan with 1 arg returns error');
isnt(exception { capture { $tr->createRun(1) } }, undef,'createRun with 1 arg returns error');
isnt(exception { capture { $tr->createSection(1) } }, undef,'createSection with 1 arg returns error');
isnt(exception { capture { $tr->createTestResults(1) } }, undef,'createTestResults with 1 arg returns error');
isnt(exception { capture { $tr->createTestSuite(1) } }, undef,'createTestSuite with 1 arg returns error');
isnt(exception { capture { $tr->getCaseByName(1) } }, undef,'getCaseByName with 1 arg returns error');
isnt(exception { capture { $tr->getCases(1) } }, undef,'getCases with 1 arg returns error');
isnt(exception { capture { $tr->getMilestoneByName(1) } }, undef,'getMilestoneByName with 1 arg returns error');
isnt(exception { capture { $tr->getPlanByName(1) } }, undef,'getPlanByName with 1 arg returns error');
isnt(exception { capture { $tr->getRunByName(1) } }, undef,'getRunByName with 1 arg returns error');
isnt(exception { capture { $tr->getSectionByName(1) } }, undef,'getSectionByName with 1 arg returns error');
isnt(exception { capture { $tr->getSections(1) } }, undef,'getSections with 1 arg returns error');
isnt(exception { capture { $tr->sectionNamesToIds(1)  } },undef,'sectionNamesToIds returns error when 1 arguments are passed');
isnt(exception { capture { $tr->getTestByName(1) } }, undef,'getTestByName with 1 arg returns error');
isnt(exception { capture { $tr->getTestSuiteByName(1) } }, undef,'getTestSuiteByName with 1 arg returns error');
isnt(exception { capture { $tr->getChildRunByName({})  } },undef,'getChildRunByName returns error when 1 argument passed');
isnt( exception { capture { $tr->createRunInPlan(1)  } },undef,'createRunInPlan returns error when 1 argument passed');
isnt( exception { capture { $tr->translateConfigNamesToIds(1) } }, undef,'translateConfigNamesToIds returns error when 1 argument passed');
isnt( exception { capture { $tr->bulkAddResults(1) } }, undef,'bulkAddResults returns error when 1 argument is passed');

#2 arg functions
is(exception { capture { $tr->createMilestone(1,'whee') } }, undef,'createMilestone with 2 args returns no error');
is(exception { capture { $tr->createPlan(1,'whee') } }, undef,'createPlan with 2 args returns no error');
is(exception { capture { $tr->createTestResults(1,1) } }, undef,'createTestResults with 2 args returns no error');
is(exception { capture { $tr->createTestSuite(1,'zugzug') } }, undef,'createTestSuite with 2 args returns no error');
is(exception { capture { $tr->getMilestoneByName(1,'hug') } }, undef,'getMilestoneByName with 2 args returns no error');
is(exception { capture { $tr->getPlanByName(1,'nugs') } }, undef,'getPlanByName with 2 args returns no error');
is(exception { capture { $tr->getRunByName(1,'zoom') } }, undef,'getRunByName with 2 args returns no error');
is(exception { capture { $tr->getSections(1,1) } }, undef,'getSections with 2 args returns no error');
is(exception { capture { $tr->getTestByName(1,'poo') } }, undef,'getTestByName with 2 args returns no error');
is(exception { capture { $tr->getTestSuiteByName(1,'zap') } }, undef,'getTestSuiteByName with 2 args returns no error');
is(exception { capture { $tr->createCase(1,'whee') } }, undef,'createCase with 2 args returns no error');
is(exception { capture { $tr->getChildRunByName({},'whee') } },undef,'getChildRunByName returns no error when 2 arguments passed');
is(exception { capture { $tr->bulkAddResults(1,[]) } }, undef,'bulkAddResults returns no error when 2 arguments passed');
is(exception { capture { $tr->getCases(1,2) } }, undef,'getCases with 2 args returns error');

isnt(exception { capture { $tr->createRun(1,1) } }, undef,'createRun with 2 args returns error');
isnt(exception { capture { $tr->createSection(1,1) } }, undef,'createSection with 2 args returns error');
isnt(exception { capture { $tr->getCaseByName(1,1) } }, undef,'getCaseByName with 2 args returns error');
isnt(exception { capture { $tr->getSectionByName(1,1) } }, undef,'getSectionByName with 2 args returns error');
isnt(exception { capture { $tr->sectionNamesToIds(1,1)  } },undef,'sectionNamesToIds returns error when 2 arguments are passed');
isnt( exception { capture { $tr->createRunInPlan(1,1)  } },undef,'createRunInPlan returns error when 2 arguments passed');

#3 arg functions
is(exception { capture { $tr->createRun(1,1,'whee') } }, undef,'createRun with 3 args returns no error');
is(exception { capture { $tr->createSection(1,1,'whee') } }, undef,'createSection with 3 args returns no error');
is(exception { capture { $tr->getCases(1,2,{}) } }, undef,'getCases with 3 args returns no error');
is(exception { capture { $tr->getSectionByName(1,1,'zip') } }, undef,'getSectionByName with 3 args returns no error');
is(exception { capture { $tr->createRunInPlan(1,1,'nugs')  } },undef,'createRunInPlan with 3 args returns no error');
is(exception { capture { $tr->getCaseByName(1,1,'whee') } }, undef,'getCaseByName with 3 args returns no error');

#4 arg functions
is(exception { capture { $tr->getCaseByName(1,1,'hug', {}) } }, undef,'getCaseByName with 4 args returns no error');
