/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.io.InputStream;

public class NavChecker
implements ContentChecker,
DocumentValidator {
    static XMLValidator navValidator_30_RNC = new XMLValidator("schema/30/epub-nav-30.rnc");
    static XMLValidator navValidator_30_ISOSCH = new XMLValidator("schema/30/epub-nav-30.sch");
    static XMLValidator xhtmlValidator_30_ISOSCH = new XMLValidator("schema/30/epub-xhtml-30.sch");
    OCFPackage ocf;
    Report report;
    String path;
    XRefChecker xrefChecker;
    String properties;
    String mimeType;
    EPUBVersion version;
    GenericResourceProvider resourceProvider;

    public NavChecker(GenericResourceProvider resourceProvider, Report report, String path, String mimeType, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            report.error(path, 0, 0, Messages.NAV_NOT_SUPPORTED);
        }
        this.report = report;
        this.path = path;
        this.resourceProvider = resourceProvider;
        this.properties = "singleFileValidation";
        this.mimeType = mimeType;
        this.version = version;
    }

    public NavChecker(OCFPackage ocf, Report report, String path, String mimeType, String properties, XRefChecker xrefChecker, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            report.error(path, 0, 0, Messages.NAV_NOT_SUPPORTED);
        }
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.resourceProvider = ocf;
        this.properties = properties;
        this.mimeType = mimeType;
        this.version = version;
    }

    @Override
    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, String.format(Messages.MISSING_FILE, this.path));
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, 0, "Nav file " + this.path + " cannot be decrypted");
        } else {
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        int errors = this.report.getErrorCount();
        int warnings = this.report.getWarningCount();
        InputStream in = null;
        try {
            in = this.resourceProvider.getInputStream(this.path);
            XMLParser navParser = new XMLParser(in, this.path, "application/xhtml+xml", this.report, this.version);
            OPSHandler30 navHandler = new OPSHandler30(this.ocf, this.path, this.mimeType, this.properties, this.xrefChecker, navParser, this.report, this.version);
            navParser.addXMLHandler(navHandler);
            navParser.addValidator(navValidator_30_RNC);
            navParser.addValidator(xhtmlValidator_30_ISOSCH);
            navParser.addValidator(navValidator_30_ISOSCH);
            navParser.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return errors == this.report.getErrorCount() && warnings == this.report.getWarningCount();
    }
}

