/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.IntComplementSet;
import net.sf.saxon.expr.sort.IntEmptySet;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.expr.sort.IntUniversalSet;

public abstract class AbstractIntSet
implements IntSet {
    public boolean containsAll(IntSet other) {
        if (other == IntUniversalSet.getInstance() || other instanceof IntComplementSet) {
            return false;
        }
        IntIterator it = other.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public IntSet union(IntSet other) {
        if (other == IntUniversalSet.getInstance()) {
            return other;
        }
        if (this.isEmpty()) {
            return other.copy();
        }
        if (other.isEmpty()) {
            return this.copy();
        }
        if (other instanceof IntComplementSet) {
            return other.union(this);
        }
        IntHashSet n = new IntHashSet(this.size() + other.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            n.add(it.next());
        }
        it = other.iterator();
        while (it.hasNext()) {
            n.add(it.next());
        }
        return n;
    }

    public IntSet intersect(IntSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            return IntEmptySet.getInstance();
        }
        IntHashSet n = new IntHashSet(this.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.next();
            if (!other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }

    public IntSet except(IntSet other) {
        IntHashSet n = new IntHashSet(this.size());
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            int v = it.next();
            if (other.contains(v)) continue;
            n.add(v);
        }
        return n;
    }
}

