package Business::EDI::CodeList::PercentageTypeCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 5245;
my $usage       = 'B';

# 5245  Percentage type code qualifier                          [B]
# Desc: Code qualifying the type of percentage.
# Repr: an..3

my %code_hash = (
'1' => [ 'Allowance',
    '(5044) Allowance expressed as a percentage.' ],
'2' => [ 'Charge',
    '(5044) Charge expressed as a percentage.' ],
'3' => [ 'Monetary amount adjustment percentage',
    '[5044] Specification of any additional charges, dues or deductions, expressed as a percentage.' ],
'4' => [ "Reinsurer's share",
    'To indicate the share of the reinsurer in a treaty.' ],
'5' => [ 'Entry percentage',
    'To indicate the percentage used for the specified entry (e.g. commission %, deposits % ...).' ],
'6' => [ 'Quality/yield',
    '(5482) The percentage of specified material in the total product.' ],
'7' => [ 'Percentage of invoice',
    'Code specifying the percentage of invoice.' ],
'8' => [ 'Reduction/surcharge percentage',
    'Percentage to calculate a reduction/surcharge.' ],
'9' => [ 'Adjustment',
    'Code specifying the adjustment expressed as a percentage.' ],
'10' => [ 'Bureau share',
    'London insurance market bureau (bureau share in reinsurance treaty).' ],
'11' => [ 'Buffer stock requirement',
    'Anticipated additional consumption to safeguard against unforeseen shortages or demands.' ],
'12' => [ 'Discount',
    'Discount expressed as a percentage.' ],
'13' => [ 'Amount tolerance',
    'Tolerance of amount in percentage.' ],
'14' => [ 'Percentage of note',
    'Percentage of debit or credit note.' ],
'15' => [ 'Penalty percentage',
    'Code specifying the penalty percentage.' ],
'16' => [ 'Interest percentage',
    'Code specifying the interest percentage.' ],
'17' => [ 'Part of documentary credit amount',
    'Part of documentary credit amount in percentage subject to sight payment, deferred payment or acceptance when the documentary credit is available by mixed payment.' ],
'18' => [ 'Percentage credit note',
    'Percentage of a credit note.' ],
'19' => [ 'Percentage debit note',
    'Percentage of a debit note.' ],
'20' => [ 'Percentage of insurance',
    'Code specifying the percentage of insurance.' ],
'21' => [ 'Own risk percentage',
    'Percentage of total amount which is not covered by credit cover.' ],
'22' => [ 'Transferred VAT percentage',
    'VAT percentage rate for which accountability is being transferred from one party to another. VAT means: Value added tax.' ],
'23' => [ 'Part time employment',
    'The time a person is employed expressed as a percentage of the equivalent full time employment.' ],
'24' => [ 'Voluntary contribution',
    'Contribution to a superannuation scheme which is not compulsory, expressed as a percentage of salary.' ],
'25' => [ 'Attribute factor',
    'To indicate a mathematical factor, expressed as a percentage , used to multiply a specified attribute item.' ],
'26' => [ 'Additional contribution',
    'Contribution to a scheme in addition to the normal contribution, expressed as a percentage (in superannuation usually expressed as a percentage of salary).' ],
'27' => [ 'Benefits allocation',
    'Percentage of total benefits allocated to a person.' ],
'28' => [ 'Attribute classification',
    'To indicate the percentage of a specified attribute classification (e.g. percentage contributed before a defined year for superannuation purposes).' ],
'29' => [ 'Renegotiation trigger upper limit',
    'The percentage rise in a currency rate of exchange which would result in renegotiation of prices.' ],
'30' => [ 'Renegotiation trigger lower limit',
    'The percentage fall in a currency rate of exchange which would result in renegotiation of prices.' ],
'31' => [ 'Material reduction factor',
    'The percentage reduction in constituent material which occurs in the production process.' ],
'32' => [ 'Acceptable price difference',
    'The maximum percentage increase or decrease resulting from price recalculation which will not result in price renegotiation.' ],
'33' => [ "Share of buyer's total requirement",
    "The percentage of the buyer's total acquisition requirement for the referenced or similar item which will be ordered from the named supplier." ],
'34' => [ 'Price increase',
    'The percentage increase in price of the referenced item since the last notification.' ],
'35' => [ 'Share of tool cost paid by buyer',
    'The percentage of the cost of tooling which will be paid by the buyer.' ],
'36' => [ 'Volume capacity usage',
    'Percentage of the volume capacity used.' ],
'37' => [ 'Weight capacity usage',
    'Percentage of the weight capacity used.' ],
'38' => [ 'Loading length capacity usage',
    'Percentage of the loading length capacity used.' ],
'39' => [ 'Share of packaging cost paid by vendor',
    'The percentage of the cost of packaging which will be paid by the vendor.' ],
'40' => [ 'Reduction percentage',
    'Reduction from an amount/price expressed in a percentage.' ],
'41' => [ 'Surcharge percentage',
    'Additional amount expressed in a percentage.' ],
'42' => [ 'Local content',
    'To indicate the percentage of a products local (i.e. domestic) content.' ],
'43' => [ 'Chargeback',
    'Percentage amount charged back.' ],
'44' => [ 'Gross turnover commission',
    'Percentage of gross turnover used to calculate commission.' ],
'45' => [ 'Progress payment percentage',
    'Indicates the rate applying for a progress payment.' ],
'46' => [ 'Offset',
    'Indicates the figure agreed between parties to calculate an offset.' ],
'47' => [ 'Prepaid payment percentage',
    'A code to indicate the percentage of the prepayment.' ],
'48' => [ 'Percentage of work completed',
    'A code to indicate the percentage of work completed.' ],
'49' => [ 'Underwriting rating',
    'Table used for mortality or morbidity rating.' ],
'50' => [ 'Mortgage interest rate',
    'Rate of interest used in amortization of a mortgage.' ],
'51' => [ 'Maximum cost of living adjustment rate',
    'Maximum rate of the cost of living adjustment.' ],
'52' => [ 'Humidity',
    'The amount of moisture in the air.' ],
'53' => [ 'Minimum cost of living adjustment rate',
    'Minimum rate of a cost of living adjustment.' ],
'54' => [ 'Contractor cost share',
    'The cost share borne by the contractor.' ],
'55' => [ 'Government cost share',
    'The cost share borne by the Government.' ],
'56' => [ 'Progress payment liquidation percentage',
    'The percentage applied to the liquidation of progress payments.' ],
'57' => [ 'Fee percentage',
    'The percentage applied to determine the fee.' ],
'58' => [ 'Resource availability',
    'Percentage of resource availability.' ],
'59' => [ 'Resource efficiency',
    'Percentage of resource efficiency.' ],
'60' => [ 'Rework yield',
    'Percentage yield from rework effort.' ],
'61' => [ 'Gross profit margin',
    'Percentage calculated by dividing gross profit by net sales.' ],
'62' => [ 'Remaining work',
    'Percentage of remaining work.' ],
'63' => [ 'Actual work percent completed',
    'Percentage of actual work completed.' ],
'64' => [ 'Earned value',
    'Percentage representing earned value.' ],
'65' => [ 'Cost escalation',
    'Percentage of cost escalation.' ],
'66' => [ 'Loss',
    'To identify the percentage of the loss.' ],
'67' => [ 'Cost of living adjustment rate',
    'To specify a cost of living adjustment rate.' ],
'68' => [ 'Percentage of due amount',
    'The percentage of an amount due.' ],
'69' => [ 'Asset ownership',
    'Percent owned of an asset.' ],
'70' => [ 'Common stock reported',
    'Percentage of common stock reported.' ],
'71' => [ 'Preferred stock reported',
    'Percentage of preferred stock reported.' ],
'72' => [ 'Ordinary profit to sales',
    'The ratio of ordinary profit to sales expressed as a percentage.' ],
'73' => [ 'Invested capital ratio',
    'Ratio of invested capital to total capital.' ],
'74' => [ 'Equity to loan ratio',
    'Ratio of equity to outstanding loans expressed as a percentage.' ],
'75' => [ 'Equity to deposit ratio',
    'Ratio of equity to deposits expressed as a percentage.' ],
'76' => [ 'Loan to deposit ratio',
    'Ratio of outstanding loans to deposits expressed as a percentage.' ],
'77' => [ 'Percent of total',
    'Percentage of the total value.' ],
'78' => [ 'Participation',
    'Participation expressed as a percentage.' ],
'79' => [ 'Indebtedness',
    'Indebtedness expressed as a percentage.' ],
'80' => [ 'Liquid ratio',
    'Ratio of liquid assets to current liabilities.' ],
'81' => [ 'Net worth to total assets',
    'Ratio of net worth to total assets expressed as a percentage.' ],
'82' => [ 'Subcontracted',
    'Percentage of work that is subcontracted.' ],
'83' => [ 'Sales per employee',
    'Ratio of sales per employee expressed as a percentage.' ],
'84' => [ 'Sales to net working capital',
    'Ratio of sales to net working capital expressed as a percentage.' ],
'85' => [ 'Total liability to net worth',
    'Ratio of total liability to net worth expressed as a percentage.' ],
'86' => [ 'Assets to sales',
    'Ratio of assets to sales expressed as a percentage.' ],
'87' => [ 'Capital per employee',
    'Ratio of capital per employee expressed as a percentage.' ],
'88' => [ 'Costs per employee',
    'Ratio of costs per employee expressed as a percentage.' ],
'89' => [ 'Accounts payable to sales',
    'Ratio of accounts payable to sales expressed as a percentage.' ],
'90' => [ 'Current liabilities to net worth',
    'Ratio of current liabilities to net worth expressed as a percentage.' ],
'91' => [ 'Current liabilities to inventory',
    'Ratio of current liabilities to inventory value expressed as a percentage.' ],
'92' => [ 'Current ratio',
    'Ratio of current assets to current liabilities expressed as a percentage.' ],
'93' => [ 'Fixed assets to net worth',
    'Ratio of fixed assets to net worth expressed as a percentage.' ],
'94' => [ 'Inventory turnover',
    'Net annual sales divided by inventory.' ],
'95' => [ 'Quick ratio',
    'Ratio of cash and accounts receivable to current liabilities.' ],
'96' => [ 'Resources retained for project',
    'The percentage of resources that must be retained for a project.' ],
'97' => [ 'Return on assets',
    'Net profit after taxes divided by total assets.' ],
'98' => [ 'Return on sales ratio',
    'Net profit after taxes divided by net annual sales.' ],
'99' => [ 'Return on capital ratio',
    'Net profit after taxes divided by capital.' ],
'100' => [ "Shareholders' return ratio",
    'Net profit after taxes divided by net worth.' ],
'101' => [ 'Contracts obtained by bid',
    'Percentage of contracts obtained by bid.' ],
'102' => [ 'Contracts obtained by negotiation',
    'Percentage of contracts obtained by negotiation.' ],
'103' => [ 'Cost plus basis',
    'Percentage of business conducted on a cost plus basis.' ],
'104' => [ 'Lump sum payments',
    'Percentage of lump sum payments to total payments.' ],
'105' => [ 'Purchases on letter of credit',
    'Percentage of purchases on letter of credit to total purchases.' ],
'106' => [ 'Purchases on floor plan',
    'Percentage of purchases on floor plan basis to total purchases.' ],
'107' => [ 'Change in sales',
    'Percentage change in sales.' ],
'108' => [ 'Change in profit',
    'Percentage change in profit.' ],
'109' => [ 'Damage',
    'Damage expressed as a percentage.' ],
'110' => [ 'Interest on liabilities',
    'Paid finance cost divided by total liabilities.' ],
'111' => [ 'Risk margin',
    'Total assets divided by interest on liabilities.' ],
'112' => [ 'Liability ratio',
    'Ratio of liability to net worth expressed as a percentage.' ],
'113' => [ 'Interest cover',
    'Paid finance cost divided by total income.' ],
'114' => [ 'Change',
    'Change expressed as a percentage.' ],
'115' => [ 'Expense',
    'Expenses expressed as a percentage.' ],
'116' => [ 'Market share',
    'Share of the market business held by an entity.' ],
'117' => [ 'Owned by small shareholders',
    'Percentage of an entity that is owned by small shareholders.' ],
'118' => [ 'Paid in capital',
    'Percentage of capital paid in by shareholders.' ],
'119' => [ 'Previous participation',
    'Previous participation expressed as a percentage.' ],
'120' => [ 'Fixed fee',
    'Fixed fee expressed as a percentage.' ],
'121' => [ 'Asset turnover',
    'Net annual sales divided by total assets.' ],
'122' => [ 'Percentage of total payment',
    'A percentage based on a total payment.' ],
'123' => [ 'Territorial trade percent',
    'Territorial trade expressed as a percentage.' ],
'124' => [ 'Change in taxable income',
    'Change in the taxable income from one period to another.' ],
'125' => [ 'Sales by type of customer',
    'Percentage of sales by type of customer.' ],
'126' => [ 'Previous period percent of total',
    'The percent of the total from a preceding period.' ],
'127' => [ 'Minority interest return on equity',
    'The return on equity achieved by a minority interest in an entity.' ],
'128' => [ 'Change in ordinary income',
    'Change in ordinary income from one period to another.' ],
'129' => [ 'Net sales to fixed assets',
    'The ratio of net sales to fixed assets expressed as a percentage.' ],
'130' => [ 'Total liabilities to total assets',
    'The ratio of total liabilities to total assets expressed as a percentage.' ],
'131' => [ 'Profit percentage',
    'The percentage applied to determine the profit.' ],
'132' => [ 'Contractor above cost share',
    'The percentage of the cost over-run incurred by the contractor.' ],
'133' => [ 'Contractor below cost share',
    'The percentage of the cost under-run allocated to the contractor.' ],
'134' => [ 'Current liabilities to total liabilities',
    'Ratio calculated by dividing current liabilities by total liabilities expressed as a percentage.' ],
'135' => [ 'Current assets to total liabilities',
    'Ratio calculated by dividing current assets by total liabilities expressed as a percentage.' ],
'136' => [ 'Vessel experience factor',
    'The compilation of the total calculated volume vessel measurements, adjusted for on-board quantity or remaining on-board quantity, compared with the total calculated volume shore measurements expressed as a percentage.' ],
'137' => [ 'Vessel load ratio',
    'The total calculated volume by vessel measurement upon sailing, less on-board quantity, divided by the total calculated volume by shore measurement at loading expressed as a percentage.' ],
'138' => [ 'Vessel discharge ratio',
    'The total calculated volume by vessel measurement on arrival, less remaining on board, divided by the total calculated volume by shore measurement discharge expressed as a percentage.' ],
'139' => [ 'National average percentile',
    'Relative ranking for a corresponding class to the national average.' ],
'140' => [ 'Industry average percentile',
    'Relative ranking for a corresponding class to the industry average.' ],
'141' => [ 'Non-current assets to net worth',
    'The ratio of non-current assets to net worth expressed as a percentage.' ],
'142' => [ 'Non-current assets to total assets',
    'The ratio of non-current assets to total assets expressed as a percentage.' ],
'143' => [ 'Sales to current assets',
    'The ratio of sales to current assets expressed as a percentage.' ],
'144' => [ 'Working capital to sales',
    'The ratio of working capital to sales expressed as a percentage.' ],
'145' => [ 'Creditors to sales costs',
    'The ratio of creditors to sales costs expressed as a percentage.' ],
'146' => [ 'Concentration',
    'Concentration expressed as a percentage value.' ],
'147' => [ 'Percentage of months before an instalment',
    'The number of months before an instalment is made expressed as a percentage.' ],
'148' => [ 'Accounts receivable turnover',
    'Net annual sales divided by accounts receivable.' ],
'149' => [ 'Employee costs to value added ratio',
    'Ratio of employee costs to total income minus raw materials and sales costs expressed as a percentage.' ],
'150' => [ 'Interest payable to net sales ratio',
    'Ratio of interest payable divided by net sales expressed as a percentage.' ],
'151' => [ 'Inventory to cost of goods sold ratio',
    'Ratio of inventory divided by cost of goods sold expressed as a percentage.' ],
'152' => [ 'Liquid assets to sales ratio',
    'Ratio of liquid assets divided by net sales expressed as a percentage.' ],
'153' => [ 'Return on value added ratio',
    'Ratio of total income minus raw materials and services to net sales expressed as a percentage.' ],
'154' => [ 'Daily working capital need',
    'The value of working capital divided by net sales multiplied by 360.' ],
'155' => [ 'Financial expenses to net sales ratio',
    'The ratio of financial expenses to net sales expressed as a percentage.' ],
'156' => [ 'Inflation',
    'Percentage representing a general increase in prices and fall in the purchasing value of money.' ],
'157' => [ 'Probability of financial distress',
    'The probability of financial distress expressed as a percentage.' ],
'158' => [ 'Gearing',
    'Ratio of the total short and long term loans divided by shareholder equity expressed as a percentage.' ],
'159' => [ 'Nestable percentage',
    'Extent expressed as a percentage to which an item can be nested within an identical item.' ],
'160' => [ 'Data reliability percentage',
    'To identify the degree of the reliability of the data.' ],
'ZZZ' => [ 'Mutually defined',
    'As agreed by the trading partners.' ],
);
sub get_codes { return \%code_hash; }

1;
