package Locales::DB::Language::gl;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::gl::VERSION = '0.09';

$Locales::DB::Language::gl::cldr_version = '2.0';

%Locales::DB::Language::gl::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Idioma\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ e\ \{1\}",
            'end'    => "\{0\}\ e\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Rexión\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr' => {
            'content' => "non\:n",
            'draft'   => 'contributed'
        },
        'yesstr' => {
            'content' => "si\:s",
            'draft'   => 'contributed'
        }
    },
);

%Locales::DB::Language::gl::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Abkhazo',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'Afrikaans',
    'afa'    => "Lingua\ afro\-asiática",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Lingua\ algonquina",
    'alt'    => "Southern\ Altai",
    'am'     => 'Amárico',
    'an'     => 'Aragonés',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Lingua\ apache",
    'ar'     => 'Árabe',
    'arc'    => 'Arameo',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Lingua\ artificial",
    'arw'    => 'Arawak',
    'as'     => 'Assamés',
    'asa'    => 'Asu',
    'ast'    => 'Asturiano',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Lingua\ australiana",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'Aimará',
    'az'     => 'Acerbaixano',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Lingua\ báltica",
    'be'     => 'Bielorruso',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'Búlgaro',
    'bh'     => 'Bihariano',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'Bengalí',
    'bnt'    => 'Bantu',
    'bo'     => 'Tibetano',
    'br'     => 'Bretón',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'Bosnio',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'Catalán',
    'cad'    => 'Caddo',
    'cai'    => "Lingua\ india\ centroamericana",
    'car'    => 'Carib',
    'cau'    => "Lingua\ caucásica",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Lingua\ céltica",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'Checo',
    'csb'    => 'Kashubian',
    'cu'     => "Eslavo\ eclesiástico",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'Galés',
    'da'     => 'Dinamarqués',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'Alemán',
    'de_at'  => "Alemán\ de\ Austria",
    'de_ch'  => "Alto\ alemán\ suízo",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'Dzongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Ibibio',
    'egy'    => "Exipcio\ antigo",
    'eka'    => 'Ekajuk',
    'el'     => 'Grego',
    'elx'    => 'Elamite',
    'en'     => 'Inglés',
    'en_au'  => "Inglés\ australiano",
    'en_ca'  => "Inglés\ canadiano",
    'en_gb'  => "Inglés\ británico",
    'en_us'  => "Inglés\ americano",
    'enm'    => "Middle\ English",
    'eo'     => 'Esperanto',
    'es'     => 'Español',
    'es_419' => "Español\ latinoamericano",
    'es_es'  => 'Castelán',
    'et'     => 'Estoniano',
    'eu'     => 'Éuscaro',
    'ewo'    => 'Ewondo',
    'fa'     => 'Persa',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'Finés',
    'fil'    => 'Filipino',
    'fiu'    => "Lingua\ finno\-úgrica",
    'fj'     => 'Fixiano',
    'fo'     => 'Faroés',
    'fon'    => 'Fon',
    'fr'     => 'Francés',
    'fr_ca'  => "Francés\ canadiano",
    'fr_ch'  => "Francés\ suízo",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => 'Frisón',
    'ga'     => 'Irlandés',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Gaélico\ escocés",
    'gem'    => "Lingua\ xermánica",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Galego',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'Guaraní',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Grego\ antigo",
    'gsw'    => "Alemán\ suízo",
    'gu'     => 'Guxaratiano',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'Hausa',
    'hai'    => 'Haida',
    'haw'    => 'Hawaiano',
    'he'     => 'Hebreo',
    'hi'     => 'Hindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Croata',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Haitiano',
    'hu'     => 'Húngaro',
    'hup'    => 'Hupa',
    'hy'     => 'Armenio',
    'hz'     => 'Herero',
    'ia'     => 'Interlingua',
    'iba'    => 'Iban',
    'id'     => 'Indonesio',
    'ie'     => 'Interlingue',
    'ig'     => 'Ibo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Lingua\ índica",
    'ine'    => "Lingua\ indoeuropea",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'Islandés',
    'it'     => 'Italiano',
    'iu'     => 'Inuktitut',
    'ja'     => 'Xaponés',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'Xavanés',
    'ka'     => 'Xeorxiano',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Casaco',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'Cambodiano',
    'kmb'    => 'Kimbundu',
    'kn'     => 'Kannada',
    'ko'     => 'Coreano',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Cachemir',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Kurdo',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kyrgiz',
    'la'     => 'Latín',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Luxemburgués',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'Lingala',
    'lo'     => 'Laotiano',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Lituano',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'Letón',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malgaxe',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'Maorí',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Lingua\ miscelánea",
    'mk'     => 'Macedonio',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'Malabar',
    'mn'     => 'Mongol',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'Marathi',
    'ms'     => 'Malaio',
    'mt'     => 'Maltés',
    'mua'    => 'Mundang',
    'mul'    => "Varias\ linguas",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'Birmano',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "Lingua\ india\ norteamericana",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Noruegués\ Bokmal",
    'nd'     => "Ndebele\ do\ norte",
    'nds'    => "Low\ German",
    'ne'     => 'Nepalí',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'Holandés',
    'nl_be'  => 'Flamenco',
    'nmg'    => 'Kwasio',
    'nn'     => "Noruegués\ nynorsk",
    'no'     => 'Noruegués',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Northern\ Sotho",
    'nub'    => "Lingua\ nubia",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'Chewa',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'Occitano',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'Oriya',
    'os'     => 'Osetio',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'Punjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Lingua\ filipina",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'Polaco',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'Paxtún',
    'pt'     => 'Portugués',
    'pt_br'  => "Portugués\ brasileiro",
    'pt_pt'  => "Portugués\ ibérico",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'Romanche',
    'rn'     => 'Rundi',
    'ro'     => 'Romanés',
    'roa'    => "Lingua\ románica",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'Ruso',
    'rup'    => 'Aromanian',
    'rw'     => 'Ruandés',
    'rwk'    => 'Rwa',
    'sa'     => 'Sánscrito',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "Lingua\ india\ sudamericana",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'Sindhi',
    'se'     => "Sami\ do\ norte",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Lingua\ semita",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Sango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Lingua\ de\ signos",
    'sh'     => 'Serbocroata',
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'Cingalés',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'Eslovaco',
    'sl'     => 'Esloveno',
    'sla'    => "Lingua\ eslávica",
    'sm'     => 'Samoano',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'Somalí',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'Albanés',
    'sr'     => 'Serbio',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Swati',
    'ssa'    => "Lingua\ do\ Nilo\-Sáhara",
    'ssy'    => 'Saho',
    'st'     => 'Sesoto',
    'su'     => 'Sondanés',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'Sueco',
    'sw'     => 'Swahili',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'Tamil',
    'tai'    => "Tai\ Language",
    'te'     => 'Telugu',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetún',
    'tg'     => 'Taxico',
    'th'     => 'Tailandés',
    'ti'     => 'Tigriña',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Turcomano',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalo',
    'tlh'    => 'Clingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tongano',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => 'Turco',
    'trv'    => 'Taroko',
    'ts'     => 'Xitsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tártaro',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Lingua\ altaica",
    'tvl'    => 'Tuvalu',
    'tw'     => 'Twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitiano',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'Uigur',
    'uga'    => 'Ugaritic',
    'uk'     => 'Ucraíno',
    'umb'    => 'Umbundu',
    'und'    => "Lingua\ descoñecida\ ou\ non\ válida",
    'ur'     => 'Urdú',
    'uz'     => 'Uzbeco',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => 'Vietnamita',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wólof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'Yiddish',
    'yo'     => 'Ioruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => 'Chinés',
    'znd'    => 'Zande',
    'zu'     => 'Zulú',
    'zun'    => 'Zuni',
    'zxx'    => "Sen\ contido\ lingüístico",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::gl::name_to_code = (
    'abkhazo'                        => 'ab',
    'acerbaixano'                    => 'az',
    'achinese'                       => 'ace',
    'acoli'                          => 'ach',
    'adangme'                        => 'ada',
    'adyghe'                         => 'ady',
    'afar'                           => 'aa',
    'afrihili'                       => 'afh',
    'afrikaans'                      => 'af',
    'aghem'                          => 'agq',
    'aimará'                        => 'ay',
    'ainu'                           => 'ain',
    'akan'                           => 'ak',
    'akkadian'                       => 'akk',
    'albanés'                       => 'sq',
    'alemán'                        => 'de',
    'alemándeaustria'               => 'de_at',
    'alemánsuízo'                  => 'gsw',
    'aleut'                          => 'ale',
    'altoalemánsuízo'              => 'de_ch',
    'amárico'                       => 'am',
    'angika'                         => 'anp',
    'aragonés'                      => 'an',
    'arameo'                         => 'arc',
    'arapaho'                        => 'arp',
    'araucanian'                     => 'arn',
    'arawak'                         => 'arw',
    'armenio'                        => 'hy',
    'aromanian'                      => 'rup',
    'assamés'                       => 'as',
    'asturiano'                      => 'ast',
    'asu'                            => 'asa',
    'athapascanlanguage'             => 'ath',
    'atsam'                          => 'cch',
    'austronesianlanguage'           => 'map',
    'avaric'                         => 'av',
    'avestan'                        => 'ae',
    'awadhi'                         => 'awa',
    'bafia'                          => 'ksf',
    'balinese'                       => 'ban',
    'baluchi'                        => 'bal',
    'bambara'                        => 'bm',
    'bamilekelanguage'               => 'bai',
    'banda'                          => 'bad',
    'bantu'                          => 'bnt',
    'basaa'                          => 'bas',
    'bashkir'                        => 'ba',
    'batak'                          => 'btk',
    'beja'                           => 'bej',
    'bemba'                          => 'bem',
    'bena'                           => 'bez',
    'bengalí'                       => 'bn',
    'berber'                         => 'ber',
    'bhojpuri'                       => 'bho',
    'bielorruso'                     => 'be',
    'bihariano'                      => 'bh',
    'bikol'                          => 'bik',
    'bini'                           => 'bin',
    'birmano'                        => 'my',
    'bislama'                        => 'bi',
    'blin'                           => 'byn',
    'blissymbols'                    => 'zbl',
    'bodo'                           => 'brx',
    'bosnio'                         => 'bs',
    'braj'                           => 'bra',
    'bretón'                        => 'br',
    'buginese'                       => 'bug',
    'buriat'                         => 'bua',
    'búlgaro'                       => 'bg',
    'cachemir'                       => 'ks',
    'caddo'                          => 'cad',
    'cambodiano'                     => 'km',
    'cantonese'                      => 'yue',
    'carib'                          => 'car',
    'casaco'                         => 'kk',
    'castelán'                      => 'es_es',
    'catalán'                       => 'ca',
    'cayuga'                         => 'cay',
    'cebuano'                        => 'ceb',
    'centralmoroccotamazight'        => 'tzm',
    'chagatai'                       => 'chg',
    'chamiclanguage'                 => 'cmc',
    'chamorro'                       => 'ch',
    'chechen'                        => 'ce',
    'checo'                          => 'cs',
    'cherokee'                       => 'chr',
    'chewa'                          => 'ny',
    'cheyenne'                       => 'chy',
    'chibcha'                        => 'chb',
    'chiga'                          => 'cgg',
    'chinookjargon'                  => 'chn',
    'chinés'                        => 'zh',
    'chipewyan'                      => 'chp',
    'choctaw'                        => 'cho',
    'chuukese'                       => 'chk',
    'chuvash'                        => 'cv',
    'cingalés'                      => 'si',
    'classicalnewari'                => 'nwc',
    'classicalsyriac'                => 'syc',
    'clingon'                        => 'tlh',
    'colognian'                      => 'ksh',
    'comorian'                       => 'swb',
    'congoswahili'                   => 'swc',
    'coptic'                         => 'cop',
    'coreano'                        => 'ko',
    'cornish'                        => 'kw',
    'corsican'                       => 'co',
    'cree'                           => 'cr',
    'creek'                          => 'mus',
    'creoleorpidgin'                 => 'crp',
    'crimeanturkish'                 => 'crh',
    'croata'                         => 'hr',
    'cushiticlanguage'               => 'cus',
    'dakota'                         => 'dak',
    'dargwa'                         => 'dar',
    'dayak'                          => 'day',
    'delaware'                       => 'del',
    'dinamarqués'                   => 'da',
    'dinka'                          => 'din',
    'divehi'                         => 'dv',
    'dogri'                          => 'doi',
    'dogrib'                         => 'dgr',
    'dravidianlanguage'              => 'dra',
    'duala'                          => 'dua',
    'dyula'                          => 'dyu',
    'dzongkha'                       => 'dz',
    'easternfrisian'                 => 'frs',
    'ekajuk'                         => 'eka',
    'elamite'                        => 'elx',
    'embu'                           => 'ebu',
    'englishbasedcreoleorpidgin'     => 'cpe',
    'erzya'                          => 'myv',
    'eslavoeclesiástico'            => 'cu',
    'eslovaco'                       => 'sk',
    'esloveno'                       => 'sl',
    'español'                       => 'es',
    'españollatinoamericano'        => 'es_419',
    'esperanto'                      => 'eo',
    'estoniano'                      => 'et',
    'ewe'                            => 'ee',
    'ewondo'                         => 'ewo',
    'exipcioantigo'                  => 'egy',
    'fang'                           => 'fan',
    'fanti'                          => 'fat',
    'faroés'                        => 'fo',
    'filipino'                       => 'fil',
    'finés'                         => 'fi',
    'fixiano'                        => 'fj',
    'flamenco'                       => 'nl_be',
    'fon'                            => 'fon',
    'francés'                       => 'fr',
    'francéscanadiano'              => 'fr_ca',
    'francéssuízo'                 => 'fr_ch',
    'frenchbasedcreoleorpidgin'      => 'cpf',
    'frisón'                        => 'fy',
    'friulian'                       => 'fur',
    'fulah'                          => 'ff',
    'ga'                             => 'gaa',
    'galego'                         => 'gl',
    'galés'                         => 'cy',
    'ganda'                          => 'lg',
    'gayo'                           => 'gay',
    'gaélicoescocés'               => 'gd',
    'gbaya'                          => 'gba',
    'geez'                           => 'gez',
    'gilbertese'                     => 'gil',
    'gondi'                          => 'gon',
    'gorontalo'                      => 'gor',
    'gothic'                         => 'got',
    'grebo'                          => 'grb',
    'grego'                          => 'el',
    'gregoantigo'                    => 'grc',
    'guaraní'                       => 'gn',
    'gusii'                          => 'guz',
    'guxaratiano'                    => 'gu',
    "gwich\Ê\¼in"                  => 'gwi',
    'haida'                          => 'hai',
    'haitiano'                       => 'ht',
    'hausa'                          => 'ha',
    'hawaiano'                       => 'haw',
    'hebreo'                         => 'he',
    'herero'                         => 'hz',
    'hiligaynon'                     => 'hil',
    'himachali'                      => 'him',
    'hindi'                          => 'hi',
    'hirimotu'                       => 'ho',
    'hittite'                        => 'hit',
    'hmong'                          => 'hmn',
    'holandés'                      => 'nl',
    'hupa'                           => 'hup',
    'húngaro'                       => 'hu',
    'iban'                           => 'iba',
    'ibibio'                         => 'efi',
    'ibo'                            => 'ig',
    'ido'                            => 'io',
    'ijo'                            => 'ijo',
    'iloko'                          => 'ilo',
    'inarisami'                      => 'smn',
    'indonesio'                      => 'id',
    'inglés'                        => 'en',
    'inglésamericano'               => 'en_us',
    'inglésaustraliano'             => 'en_au',
    'inglésbritánico'              => 'en_gb',
    'ingléscanadiano'               => 'en_ca',
    'ingush'                         => 'inh',
    'interlingua'                    => 'ia',
    'interlingue'                    => 'ie',
    'inuktitut'                      => 'iu',
    'inupiaq'                        => 'ik',
    'ioruba'                         => 'yo',
    'iranianlanguage'                => 'ira',
    'irlandés'                      => 'ga',
    'iroquoianlanguage'              => 'iro',
    'islandés'                      => 'is',
    'italiano'                       => 'it',
    'jju'                            => 'kaj',
    'jolafonyi'                      => 'dyo',
    'judeoarabic'                    => 'jrb',
    'judeopersian'                   => 'jpr',
    'kabardian'                      => 'kbd',
    'kabuverdianu'                   => 'kea',
    'kabyle'                         => 'kab',
    'kachin'                         => 'kac',
    'kalaallisut'                    => 'kl',
    'kalenjin'                       => 'kln',
    'kalmyk'                         => 'xal',
    'kamba'                          => 'kam',
    'kannada'                        => 'kn',
    'kanuri'                         => 'kr',
    'karachaybalkar'                 => 'krc',
    'karakalpak'                     => 'kaa',
    'karelian'                       => 'krl',
    'karen'                          => 'kar',
    'kashubian'                      => 'csb',
    'kawi'                           => 'kaw',
    'khasi'                          => 'kha',
    'khoisanlanguage'                => 'khi',
    'khotanese'                      => 'kho',
    'kikuyu'                         => 'ki',
    'kimbundu'                       => 'kmb',
    'komi'                           => 'kv',
    'kongo'                          => 'kg',
    'konkani'                        => 'kok',
    'koro'                           => 'kfo',
    'kosraean'                       => 'kos',
    'koyraborosenni'                 => 'ses',
    'koyrachiini'                    => 'khq',
    'kpelle'                         => 'kpe',
    'kru'                            => 'kro',
    'kuanyama'                       => 'kj',
    'kumyk'                          => 'kum',
    'kurdo'                          => 'ku',
    'kurukh'                         => 'kru',
    'kutenai'                        => 'kut',
    'kwasio'                         => 'nmg',
    'kyrgiz'                         => 'ky',
    'ladino'                         => 'lad',
    'lahnda'                         => 'lah',
    'lamba'                          => 'lam',
    'langi'                          => 'lag',
    'laotiano'                       => 'lo',
    'latín'                         => 'la',
    'letón'                         => 'lv',
    'lezghian'                       => 'lez',
    'limburgish'                     => 'li',
    'lingala'                        => 'ln',
    'linguaafroasiática'            => 'afa',
    'linguaalgonquina'               => 'alg',
    'linguaaltaica'                  => 'tut',
    'linguaapache'                   => 'apa',
    'linguaartificial'               => 'art',
    'linguaaustraliana'              => 'aus',
    'linguabáltica'                 => 'bat',
    'linguacaucásica'               => 'cau',
    'linguacéltica'                 => 'cel',
    'linguadescoñecidaounonválida' => 'und',
    'linguadesignos'                 => 'sgn',
    'linguadonilosáhara'            => 'ssa',
    'linguaeslávica'                => 'sla',
    'linguafilipina'                 => 'phi',
    'linguafinnoúgrica'             => 'fiu',
    'linguaindiacentroamericana'     => 'cai',
    'linguaindianorteamericana'      => 'nai',
    'linguaindiasudamericana'        => 'sai',
    'linguaindoeuropea'              => 'ine',
    'linguamiscelánea'              => 'mis',
    'linguanubia'                    => 'nub',
    'linguarománica'                => 'roa',
    'linguasemita'                   => 'sem',
    'linguaxermánica'               => 'gem',
    'linguaíndica'                  => 'inc',
    'lituano'                        => 'lt',
    'lojban'                         => 'jbo',
    'lowersorbian'                   => 'dsb',
    'lowgerman'                      => 'nds',
    'lozi'                           => 'loz',
    'lubakatanga'                    => 'lu',
    'lubalulua'                      => 'lua',
    'luiseno'                        => 'lui',
    'lulesami'                       => 'smj',
    'lunda'                          => 'lun',
    'luo'                            => 'luo',
    'lushai'                         => 'lus',
    'luxemburgués'                  => 'lb',
    'luyia'                          => 'luy',
    'macedonio'                      => 'mk',
    'machame'                        => 'jmc',
    'madurese'                       => 'mad',
    'magahi'                         => 'mag',
    'maithili'                       => 'mai',
    'makasar'                        => 'mak',
    'makhuwameetto'                  => 'mgh',
    'makonde'                        => 'kde',
    'malabar'                        => 'ml',
    'malaio'                         => 'ms',
    'malgaxe'                        => 'mg',
    'maltés'                        => 'mt',
    'manchu'                         => 'mnc',
    'mandar'                         => 'mdr',
    'mandingo'                       => 'man',
    'manipuri'                       => 'mni',
    'manobolanguage'                 => 'mno',
    'manx'                           => 'gv',
    'maorí'                         => 'mi',
    'marathi'                        => 'mr',
    'mari'                           => 'chm',
    'marshallese'                    => 'mh',
    'marwari'                        => 'mwr',
    'masai'                          => 'mas',
    'mayanlanguage'                  => 'myn',
    'mende'                          => 'men',
    'meru'                           => 'mer',
    'micmac'                         => 'mic',
    'middledutch'                    => 'dum',
    'middleenglish'                  => 'enm',
    'middlefrench'                   => 'frm',
    'middlehighgerman'               => 'gmh',
    'middleirish'                    => 'mga',
    'minangkabau'                    => 'min',
    'mirandese'                      => 'mwl',
    'mohawk'                         => 'moh',
    'moksha'                         => 'mdf',
    'moldavian'                      => 'mo',
    'mongo'                          => 'lol',
    'mongol'                         => 'mn',
    'monkhmerlanguage'               => 'mkh',
    'morisyen'                       => 'mfe',
    'mossi'                          => 'mos',
    'mundalanguage'                  => 'mun',
    'mundang'                        => 'mua',
    'nahuatl'                        => 'nah',
    'nama'                           => 'naq',
    'nauru'                          => 'na',
    'navajo'                         => 'nv',
    'ndebeledonorte'                 => 'nd',
    'ndonga'                         => 'ng',
    'neapolitan'                     => 'nap',
    'nepalí'                        => 'ne',
    'newari'                         => 'new',
    'nias'                           => 'nia',
    'nigerkordofanianlanguage'       => 'nic',
    'niuean'                         => 'niu',
    'nogai'                          => 'nog',
    'northernfrisian'                => 'frr',
    'northernsotho'                  => 'nso',
    'noruegués'                     => 'no',
    'norueguésbokmal'               => 'nb',
    'norueguésnynorsk'              => 'nn',
    'nuer'                           => 'nus',
    'nyamwezi'                       => 'nym',
    'nyankole'                       => 'nyn',
    'nyasatonga'                     => 'tog',
    'nyoro'                          => 'nyo',
    'nzima'                          => 'nzi',
    "n\â\\ko"                   => 'nqo',
    'occitano'                       => 'oc',
    'ojibwa'                         => 'oj',
    'oldenglish'                     => 'ang',
    'oldfrench'                      => 'fro',
    'oldhighgerman'                  => 'goh',
    'oldirish'                       => 'sga',
    'oldnorse'                       => 'non',
    'oldpersian'                     => 'peo',
    "oldproven\Ã\§al"              => 'pro',
    'oriya'                          => 'or',
    'oromo'                          => 'om',
    'osage'                          => 'osa',
    'osetio'                         => 'os',
    'otomianlanguage'                => 'oto',
    'ottomanturkish'                 => 'ota',
    'pahlavi'                        => 'pal',
    'palauan'                        => 'pau',
    'pali'                           => 'pi',
    'pampanga'                       => 'pam',
    'pangasinan'                     => 'pag',
    'papiamento'                     => 'pap',
    'papuanlanguage'                 => 'paa',
    'paxtún'                        => 'ps',
    'persa'                          => 'fa',
    'phoenician'                     => 'phn',
    'pohnpeian'                      => 'pon',
    'polaco'                         => 'pl',
    'portuguesebasedcreoleorpidgin'  => 'cpp',
    'portugués'                     => 'pt',
    'portuguésbrasileiro'           => 'pt_br',
    'portuguésibérico'             => 'pt_pt',
    'prakritlanguage'                => 'pra',
    'punjabi'                        => 'pa',
    'quechua'                        => 'qu',
    'rajasthani'                     => 'raj',
    'rapanui'                        => 'rap',
    'rarotongan'                     => 'rar',
    'romanche'                       => 'rm',
    'romany'                         => 'rom',
    'romanés'                       => 'ro',
    'rombo'                          => 'rof',
    'ruandés'                       => 'rw',
    'rundi'                          => 'rn',
    'ruso'                           => 'ru',
    'rwa'                            => 'rwk',
    'saho'                           => 'ssy',
    'sakha'                          => 'sah',
    'salishanlanguage'               => 'sal',
    'samaritanaramaic'               => 'sam',
    'samburu'                        => 'saq',
    'samidonorte'                    => 'se',
    'samilanguage'                   => 'smi',
    'samoano'                        => 'sm',
    'sandawe'                        => 'sad',
    'sango'                          => 'sg',
    'sangu'                          => 'sbp',
    'santali'                        => 'sat',
    'sardinian'                      => 'sc',
    'sasak'                          => 'sas',
    'scots'                          => 'sco',
    'selkup'                         => 'sel',
    'sena'                           => 'seh',
    'sencontidolingüístico'        => 'zxx',
    'seneca'                         => 'see',
    'serbio'                         => 'sr',
    'serbocroata'                    => 'sh',
    'serer'                          => 'srr',
    'sesoto'                         => 'st',
    'shambala'                       => 'ksb',
    'shan'                           => 'shn',
    'shona'                          => 'sn',
    'sichuanyi'                      => 'ii',
    'sicilian'                       => 'scn',
    'sidamo'                         => 'sid',
    'siksika'                        => 'bla',
    'sindhi'                         => 'sd',
    'sinotibetanlanguage'            => 'sit',
    'siouanlanguage'                 => 'sio',
    'skoltsami'                      => 'sms',
    'slave'                          => 'den',
    'soga'                           => 'xog',
    'sogdien'                        => 'sog',
    'somalí'                        => 'so',
    'sondanés'                      => 'su',
    'songhai'                        => 'son',
    'soninke'                        => 'snk',
    'sorbianlanguage'                => 'wen',
    'southernaltai'                  => 'alt',
    'southernsami'                   => 'sma',
    'southndebele'                   => 'nr',
    'sranantongo'                    => 'srn',
    'sueco'                          => 'sv',
    'sukuma'                         => 'suk',
    'sumerian'                       => 'sux',
    'susu'                           => 'sus',
    'swahili'                        => 'sw',
    'swati'                          => 'ss',
    'syriac'                         => 'syr',
    'sánscrito'                     => 'sa',
    'tachelhit'                      => 'shi',
    'tagalo'                         => 'tl',
    'tahitiano'                      => 'ty',
    'tailandés'                     => 'th',
    'tailanguage'                    => 'tai',
    'taita'                          => 'dav',
    'tamashek'                       => 'tmh',
    'tamil'                          => 'ta',
    'taroko'                         => 'trv',
    'tasawaq'                        => 'twq',
    'taxico'                         => 'tg',
    'telugu'                         => 'te',
    'tereno'                         => 'ter',
    'teso'                           => 'teo',
    'tetún'                         => 'tet',
    'tibetano'                       => 'bo',
    'tigre'                          => 'tig',
    'tigriña'                       => 'ti',
    'timne'                          => 'tem',
    'tiv'                            => 'tiv',
    'tlingit'                        => 'tli',
    'tokelau'                        => 'tkl',
    'tokpisin'                       => 'tpi',
    'tongano'                        => 'to',
    'tsimshian'                      => 'tsi',
    'tswana'                         => 'tn',
    'tumbuka'                        => 'tum',
    'tupilanguage'                   => 'tup',
    'turco'                          => 'tr',
    'turcomano'                      => 'tk',
    'tuvalu'                         => 'tvl',
    'tuvinian'                       => 'tyv',
    'twi'                            => 'tw',
    'tyap'                           => 'kcg',
    'tártaro'                       => 'tt',
    'ucraíno'                       => 'uk',
    'udmurt'                         => 'udm',
    'ugaritic'                       => 'uga',
    'uigur'                          => 'ug',
    'umbundu'                        => 'umb',
    'uppersorbian'                   => 'hsb',
    'urdú'                          => 'ur',
    'uzbeco'                         => 'uz',
    'vai'                            => 'vai',
    'variaslinguas'                  => 'mul',
    'venda'                          => 've',
    'vietnamita'                     => 'vi',
    "volap\Ã\¼k"                   => 'vo',
    'votic'                          => 'vot',
    'vunjo'                          => 'vun',
    'wakashanlanguage'               => 'wak',
    'walamo'                         => 'wal',
    'walloon'                        => 'wa',
    'walser'                         => 'wae',
    'waray'                          => 'war',
    'washo'                          => 'was',
    'wólof'                         => 'wo',
    'xaponés'                       => 'ja',
    'xavanés'                       => 'jv',
    'xeorxiano'                      => 'ka',
    'xhosa'                          => 'xh',
    'xitsonga'                       => 'ts',
    'yangben'                        => 'yav',
    'yao'                            => 'yao',
    'yapese'                         => 'yap',
    'yiddish'                        => 'yi',
    'yupiklanguage'                  => 'ypk',
    'zande'                          => 'znd',
    'zapotec'                        => 'zap',
    'zarma'                          => 'dje',
    'zaza'                           => 'zza',
    'zenaga'                         => 'zen',
    'zhuang'                         => 'za',
    'zulú'                          => 'zu',
    'zuni'                           => 'zun',
    'Árabe'                         => 'ar',
    'Éuscaro'                       => 'eu',
);

1;
