#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/frobenius_number/;

my $usexs = Math::Prime::Util::prime_get_config->{'xs'};
my $extra = defined $ENV{EXTENDED_TESTING} && $ENV{EXTENDED_TESTING};

my @t1 = (
 [   -1, [1]],
 [   -1, [5,1]],
 [   43, [6,9,20]],
 [  481, [47, 74, 97, 126, 157, 188]],
 [ 1666, [83,87,93]],
 [ 1666, [83,87,93,166,170,174,176,180,186,249,253,257,259]],
 [   11, [5,8,9,12]],
 [   30, [7,11,13]],
 [  899, [53,71,91]],
 [27971, [322,654,765]],
 [71459, [123,1234,12345]],
 [ 3019, [151,157,251,711]],
 [ 3019, [151,157,251,711,912]],
 [  426, [101,109,113,119,121,131,139,149,151,161,163,167,169,187,191,214,219,238,276,324,345,346,349,387,421,427,444,453,463,525,530,555,579,580,625,711,719,737,752,787,814,834,856,878,899,915,937,978,989]],
 [ 3637, [200,230,528,863,905,976,1355,1725,1796,1808]],
 [   67, [10,18,26,33,35]],
 [   39, [20/4, 44/4]],
 [   3787,[1218,1017,882,11]],
 [    175,[43,40,38,37,34]],
 [    122,[4,73,63,111]],
 [    489,[10,195,218,272,287,324,341,353,499]],
 [   2053,[100,101,159]],
 [   3415,[133,172,199]],
 [   1972,[100,101,139]],
 [   2959,[110,151,201]],
 [   3059,[110,151,211]],
 [   4948,[137,251,256]],
 [   1027,[33,89,147]],
 [   4049,[100,239,543,609]],
 [    899,[100,101,110,111]],
 [    204,[30,31,43,55,67,98]],
);


my @t2 = (
 [   327473, [2000,3001,4567]],
 [  6753481, [4093, 8191, 16381, 32749, 65521]],
 [149389505, [12223,12224,36671]],
 [ 106857,[5123,5692,6055,6371,6899,7300]],
 [  51648,[5123,5692,6055,6371,6899,7300,8472,8619,9001,9544,9809,10012,11207]],
 [ 132833,[1854,2712,2266,7857]],
);

# from Aardal and Lentra (2005)
# https://www.researchgate.net/publication/2559108_Hard_Equality_Constrained_Integer_Knapsacks
my @t3 = (
[89643481,[12223,12224,36674,61119,85569]],
[89716838,[qw/12228 36679 36682 48908 61139 73365/]],
[58925134,[qw/12137 24269 36405 36407 48545 60683/]],
[104723595,[qw/13211 13212 39638 52844 66060 79268 92482/]],
[45094583,[qw/13429 26850 26855 40280 40281 53711 53714 67141/]],
[33367335,[qw/25067 49300 49717 62124 87608 88025 113673 119169/]],
[14215206,[qw/11948 23330 30635 44197 92754 123389 136951 140745/]],
[58424799,[qw/39559 61679 79625 99658 133404 137071 159757 173977/]],
[60575665,[qw/48709 55893 62177 65919 86271 87692 102881 109765/]],
[62442884,[qw/28637 48198 80330 91980 102221 135518 165564 176049/]],
[22382774,[qw/20601 40429 42207 45415 53725 61919 64470 69340 78539 95043/]],
[27267751,[qw/18902 26720 34538 34868 49201 49531 65167 66800 84069 137179/]],
[21733990,[qw/17035 45529 48317 48506 86120 100178 112464 115819 125128 129688/]],
[13385099,[qw/13719 20289 29067 60517 64354 65633 76969 102024 106036 119930/]],
[106925261,[qw/45276 70778 86911 92634 97839 125941 134269 141033 147279 153525/]],
[ 577134,[qw/11615 27638 32124 48384 53542 56230 73104 73884 112951 130204/]],
[ 944183,[qw/14770 32480 75923 86053 85747 91772 101240 115403 137390 147371/]],
[ 765260,[qw/15167 28569 36170 55419 70945 74926 95821 109046 121581 137695/]],
[ 680230,[qw/11828 14253 46209 52042 55987 72649 119704 129334 135589 138360/]],
[ 663281,[qw/13128 37469 39391 41928 53433 59283 81669 95339 110593 131989/]],
[1109710,[qw/35113 36869 46647 53560 81518 85287 102780 115459 146791 147097/]],
[ 752109,[qw/14054 22184 29952 64696 92752 97364 118723 119355 122370 140050/]],
[ 783879,[qw/20303 26239 33733 47223 55486 93776 119372 136158 136989 148851/]],
[ 677347,[qw/20212 30662 31420 49259 49701 62688 74254 77244 139477 142101/]],
[1037608,[qw/32663 41286 44549 45674 95772 111887 117611 117763 141840 149740/]],
);

# These will kill the RR algorithm
my @tx = (
 ["1375300010215404" ,[10000000000,10000008870,10000057783,10000072907]],
 ["38563214973583",[10**10,18543816066,27129592681,43226644830,78522678316]],
);

if (!$usexs && !$extra) {
  @t3 = grep { $_->[1]->[0] < 13000 } @t3;
}

plan tests => 3     # Simple tests
            + 3     # More complicated sets
            + 2;    # overflow

##### frobenius_number

is( frobenius_number(),  undef, "frobenius_number() = undef");
is( frobenius_number(4093),  undef, "frobenius_number(4093) = undef");

#is( frobenius_number(20,44), undef, "frobenius_number(20,44) = undef");
eval { frobenius_number(20,44); };
like($@, qr/coprime/, "Non-coprime set gives error");


is_deeply( [map { frobenius_number(@{$_->[1]}) } @t1],
           [map { $_->[0] } @t1], "frobenius_number simple tests");

is_deeply( [map { frobenius_number(@{$_->[1]}) } @t2],
           [map { $_->[0] } @t2], "frobenius_number bigger tests");

is_deeply( [map { frobenius_number(@{$_->[1]}) } @t3],
           [map { $_->[0] } @t3], "frobenius_number hard knapsack problems");

# Check for overflow
is( "".frobenius_number(12345,"1494268454735486"), "18445249805254826839", "frobenius_number(12345,1494268454735486) = 18445249805254826839" );
is( "".frobenius_number(12345,"14948739119699798"), "184527235693574294167", "frobenius_number(12345,14948739119699798) = 184527235693574294167" );
