package Net::Async::Spotify::API::Generated::Player;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::API::Base);

use Future::AsyncAwait;

=encoding utf8

=head1 NAME

Net::Async::Spotify::API::Generated::Player - Package representing Spotify Player API

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#reference-index
Check C<crawl-api-doc.pl> for more information.

=head1 METHODS

=cut

sub mapping { shift->{mapping} }

=head2 add_to_queue

add_to_queue - Add an item to queue

Add an item to the end of the user’s current playback queue.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If
not supplied, the user’s currently active device is the target.

=item uri

Type: string | Required: required
The uri of the item to add to the queue. Must be a track or an episode uri.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub add_to_queue {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{add_to_queue}{method} // 'POST';
    $request->{uri}    = $mapping->{add_to_queue}{uri} // 'https://api.spotify.com/v1/me/player/queue';
    $request->{param}  = $mapping->{add_to_queue}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
            'uri' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{add_to_queue}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_a_users_available_devices

get_a_users_available_devices - Get a User's Available Devices

Get information about a user’s available devices.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service:
see the Web API Authorization Guide
for details.  The access token must have been issued on behalf of a user.
The access token must have the user-read-playback-state scope authorized
in order to read information.

=back

and Response Objects being:

- device object


A successful request will return a 200 OK response code with a json payload that contains the device objects (see below).
When no available devices are found, the request will return a 200 OK response with an empty devices list.Try in our Web Console

=cut

async sub get_a_users_available_devices {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_a_users_available_devices}{method} // 'GET';
    $request->{uri}    = $mapping->{get_a_users_available_devices}{uri} // 'https://api.spotify.com/v1/me/player/devices';
    $request->{param}  = $mapping->{get_a_users_available_devices}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_a_users_available_devices}{response} // [
        'device object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_information_about_the_users_current_playback

get_information_about_the_users_current_playback - Get Information About The User's Current Playback

Get information about the user’s current playback state, including track or episode, progress, and active device.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.

=back

=head3 query_parameter

=over 4

=item additional_types

Type: string | Required: optional
A comma-separated list of item types that your client supports besides the default track type. Valid types are: track and episode. An unsupported type in the response is expected to be represented as null value in the item field.
Note: This parameter was introduced to allow existing clients to maintain their current behaviour and might be deprecated in the future. In addition to providing this parameter, make sure that your client properly handles cases of new

=item market

Type: string | Required: optional
An ISO 3166-1 alpha-2 country code
or the string from_token. Provide this parameter if you want to apply Track
Relinking.

=back

and Response Objects being:



A successful request will return a 200 OK response code with a json payload that contains information about the current playback. The information returned is for the last known state, which means an inactive device could be returned if it was the last one to execute playback.
When no available devices are found, the request will return a 200 OK response but with no data populated.Try in our Web Console

=cut

async sub get_information_about_the_users_current_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_information_about_the_users_current_playback}{method} // 'GET';
    $request->{uri}    = $mapping->{get_information_about_the_users_current_playback}{uri} // 'https://api.spotify.com/v1/me/player';
    $request->{param}  = $mapping->{get_information_about_the_users_current_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'additional_types' => {
                type     => 'string',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_information_about_the_users_current_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_recently_played

get_recently_played - Get Current User's Recently Played Tracks

Get tracks from the current user’s recently played tracks.
Note: Currently doesn’t support podcast episodes.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details. The access token must have been issued on behalf of a user.

=back

=head3 query_parameter

=over 4

=item after

Type: integer | Required: optional
A Unix timestamp in milliseconds. Returns all items
after (but not including) this cursor position. If after is specified, before
must not be specified.

=item before

Type: integer | Required: optional
A Unix timestamp in milliseconds. Returns all items
before (but not including) this cursor position. If before is specified,
after must not be specified.

=item limit

Type: integer | Required: optional
The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.

=back

and Response Objects being:

- history object


On success, the HTTP status code in the response header is 200 OK and the response body contains an array of play history objects (wrapped in a cursor-based paging object) in JSON format. The play history items each contain the context the track was played from (e.g. playlist, album), the date and time the track was played, and a track object (simplified). On error, the header status code is an error code and the response body contains an error object.If private session is enabled the response will be a 204 NO CONTENT with an empty payload.Try in our Web Console

=cut

async sub get_recently_played {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_recently_played}{method} // 'GET';
    $request->{uri}    = $mapping->{get_recently_played}{uri} // 'https://api.spotify.com/v1/me/player/recently-played';
    $request->{param}  = $mapping->{get_recently_played}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'after' => {
                type     => 'integer',
                required => 'optional',
            },
            'before' => {
                type     => 'integer',
                required => 'optional',
            },
            'limit' => {
                type     => 'integer',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{get_recently_played}{response} // [
        'history object',

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 get_the_users_currently_playing_track

get_the_users_currently_playing_track - Get the User's Currently Playing Track

Get the object currently being played on the user’s Spotify account.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service:
see the Web API Authorization Guide
for details. The access token must have been issued on behalf of a user. The
access token must have the user-read-currently-playing and/or user-read-playback-state
scope authorized in order to read information.

=back

=head3 query_parameter

=over 4

=item additional_types

Type: string | Required: optional
A comma-separated list of item types that your client supports besides the default track type. Valid types are: track and episode. An unsupported type in the response is expected to be represented as null value in the item field.
Note: This parameter was introduced to allow existing clients to maintain their current behaviour and might be deprecated in the future. In addition to providing this parameter, make sure that your client properly handles cases of new types in the future by checking against the currently_playing_type field.

=item market

Type: string | Required: required
An ISO 3166-1 alpha-2 country code
or the string from_token. Provide this parameter if you want to apply Track
Relinking.

=back

and Response Objects being:



A successful request will return a 200 OK response code with a json payload that contains information about the currently playing track or episode and its context (see below). The information returned is for the last known state, which means an inactive device could be returned if it was the last one to execute playback.When no available devices are found, the request will return a 200 OK response but with no data populated.When no track is currently playing, the request will return a 204 NO CONTENT response with no payload.If private session is enabled the response will be a 204 NO CONTENT with an empty payload.Try in our Web Console

=cut

async sub get_the_users_currently_playing_track {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{get_the_users_currently_playing_track}{method} // 'GET';
    $request->{uri}    = $mapping->{get_the_users_currently_playing_track}{uri} // 'https://api.spotify.com/v1/me/player/currently-playing';
    $request->{param}  = $mapping->{get_the_users_currently_playing_track}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'additional_types' => {
                type     => 'string',
                required => 'optional',
            },
            'market' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{get_the_users_currently_playing_track}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 pause_a_users_playback

pause_a_users_playback - Pause a User's Playback

Pause playback on the user’s account.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub pause_a_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{pause_a_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{pause_a_users_playback}{uri} // 'https://api.spotify.com/v1/me/player/pause';
    $request->{param}  = $mapping->{pause_a_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{pause_a_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 seek_to_position_in_currently_playing_track

seek_to_position_in_currently_playing_track - Seek To Position In Currently Playing Track

Seeks to the given position in the user’s currently playing track.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If
not supplied, the user’s currently active device is the target.

=item position_ms

Type: integer | Required: required
The position in milliseconds to seek to. Must be a
positive number. Passing in a position that is greater than the length of
the track will cause the player to start playing the next song.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub seek_to_position_in_currently_playing_track {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{seek_to_position_in_currently_playing_track}{method} // 'PUT';
    $request->{uri}    = $mapping->{seek_to_position_in_currently_playing_track}{uri} // 'https://api.spotify.com/v1/me/player/seek';
    $request->{param}  = $mapping->{seek_to_position_in_currently_playing_track}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
            'position_ms' => {
                type     => 'integer',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{seek_to_position_in_currently_playing_track}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 set_repeat_mode_on_users_playback

set_repeat_mode_on_users_playback - Set Repeat Mode On User’s Playback

Set the repeat mode for the user’s playback. Options are repeat-track,
repeat-context, and off.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If
not supplied, the user’s currently active device is the target.

=item state

Type: string | Required: required
track, context or off.
track will repeat the current track.
context will repeat the current context.
off will turn repeat off.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub set_repeat_mode_on_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{set_repeat_mode_on_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{set_repeat_mode_on_users_playback}{uri} // 'https://api.spotify.com/v1/me/player/repeat';
    $request->{param}  = $mapping->{set_repeat_mode_on_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
            'state' => {
                type     => 'string',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{set_repeat_mode_on_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 set_volume_for_users_playback

set_volume_for_users_playback - Set Volume For User's Playback

Set the volume for the user’s current playback device.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.

=item volume_percent

Type: integer | Required: required
The volume to set. Must be a value from 0 to 100 inclusive.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub set_volume_for_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{set_volume_for_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{set_volume_for_users_playback}{uri} // 'https://api.spotify.com/v1/me/player/volume';
    $request->{param}  = $mapping->{set_volume_for_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
            'volume_percent' => {
                type     => 'integer',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{set_volume_for_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 skip_users_playback_to_next_track

skip_users_playback_to_next_track - Skip User’s Playback To Next Track

Skips to next track in the user’s queue.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub skip_users_playback_to_next_track {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{skip_users_playback_to_next_track}{method} // 'POST';
    $request->{uri}    = $mapping->{skip_users_playback_to_next_track}{uri} // 'https://api.spotify.com/v1/me/player/next';
    $request->{param}  = $mapping->{skip_users_playback_to_next_track}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{skip_users_playback_to_next_track}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 skip_users_playback_to_previous_track

skip_users_playback_to_previous_track - Skip User’s Playback To Previous Track

Skips to previous track in the user’s queue.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If
not supplied, the user’s currently active device is the target.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub skip_users_playback_to_previous_track {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{skip_users_playback_to_previous_track}{method} // 'POST';
    $request->{uri}    = $mapping->{skip_users_playback_to_previous_track}{uri} // 'https://api.spotify.com/v1/me/player/previous';
    $request->{param}  = $mapping->{skip_users_playback_to_previous_track}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{skip_users_playback_to_previous_track}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 start_a_users_playback

start_a_users_playback - Start/Resume a User's Playback

Start a new context or resume current playback on the user’s active device.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 json_body_parameter

=over 4

=item context_uri

Type: string | Required: optional
string

=item offset

Type: object | Required: optional
object

=item position_ms

Type: integer | Required: optional
integer

=item uris

Type: array[string] | Required: optional
Array of URIs

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If not supplied, the user’s currently active device is the target.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub start_a_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{start_a_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{start_a_users_playback}{uri} // 'https://api.spotify.com/v1/me/player/play';
    $request->{param}  = $mapping->{start_a_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        json_body_parameter => {
            'context_uri' => {
                type     => 'string',
                required => 'optional',
            },
            'offset' => {
                type     => 'object',
                required => 'optional',
            },
            'position_ms' => {
                type     => 'integer',
                required => 'optional',
            },
            'uris' => {
                type     => 'array[string]',
                required => 'optional',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{start_a_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 toggle_shuffle_for_users_playback

toggle_shuffle_for_users_playback - Toggle Shuffle For User’s Playback

Toggle shuffle on or off for user’s playback.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 query_parameter

=over 4

=item device_id

Type: string | Required: optional
The id of the device this command is targeting. If
not supplied, the user’s currently active device is the target.

=item state

Type: boolean | Required: required
true : Shuffle user’s playback.
false : Do not shuffle user’s playback.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub toggle_shuffle_for_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{toggle_shuffle_for_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{toggle_shuffle_for_users_playback}{uri} // 'https://api.spotify.com/v1/me/player/shuffle';
    $request->{param}  = $mapping->{toggle_shuffle_for_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        query_parameter => {
            'device_id' => {
                type     => 'string',
                required => 'optional',
            },
            'state' => {
                type     => 'boolean',
                required => 'required',
            },
        },
    };
    my $response_objs = $mapping->{toggle_shuffle_for_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

=head2 transfer_a_users_playback

transfer_a_users_playback - Transfer a User's Playback

Transfer playback to a new device and determine if it should start playing.

with Request details being:

=head3 header

=over 4

=item Authorization

Type: string | Required: required
A valid access token from the Spotify Accounts service: see the Web API Authorization Guide for details.The access token must have been issued on behalf of a user.The access token must have the user-modify-playback-state scope authorized in order to control playback.

=back

=head3 json_body_parameter

=over 4

=item device_ids

Type: array[string] | Required: required
A JSON array containing the ID of the device on which playback should be started/transferred.For example:{device_ids:["74ASZWbe4lXaubB36ztrGX"]}Note: Although an array is accepted, only a single device_id is currently supported. Supplying more than one will return 400 Bad Request

=item play

Type: boolean | Required: optional
true: ensure playback happens on new device.false or not provided: keep the current playback state.

=back

and Response Objects being:



A completed request will return a 204 NO CONTENT response code, and then issue the command to the player. Due to the asynchronous nature of the issuance of the command, you should use the Get Information About The User’s Current Playback  endpoint to check that your issued command was handled correctly by the player.If the device is not found, the request will return 404 NOT FOUND response code.If the user making the request is non-premium, a 403 FORBIDDEN response code will be returned.Try in our Web Console

=cut

async sub transfer_a_users_playback {
    my ($self, %args) = @_;

    my $mapping = $self->mapping;
    my $request->{method} = $mapping->{transfer_a_users_playback}{method} // 'PUT';
    $request->{uri}    = $mapping->{transfer_a_users_playback}{uri} // 'https://api.spotify.com/v1/me/player';
    $request->{param}  = $mapping->{transfer_a_users_playback}{param} // {
        header => {
            'Authorization' => {
                type     => 'string',
                required => 'required',
            },
        },
        json_body_parameter => {
            'device_ids' => {
                type     => 'array[string]',
                required => 'required',
            },
            'play' => {
                type     => 'boolean',
                required => 'optional',
            },
        },
    };
    my $response_objs = $mapping->{transfer_a_users_playback}{response} // [

    ];

    await $self->call_api($request, $response_objs, %args);
}

1;
