use strict;
use warnings;
use utf8;
use open OUT => qw/:utf8 :std/;
use autodie;
use Encode;
use FindBin;

=head1 USAGE

useage:
    cat mecab-ipadic-2.7.0-20060707/*.csv | perl loucsv.pl > lou.csv

original:
    http://chasen.org/~taku/blog/archives/2007/01/_mecab.html

=cut

my $ja2kana = get_ja2kana();

my $pos_form_okuri_map = {
    '名詞-*'                => '',
    '感動詞-*'              => '',
    '接続詞-*'              => '',
    '連体詞-*'              => '',
    '動詞-仮定形'           => 'すれ',
    '動詞-仮定縮約１'       => 'すれ',
    '動詞-基本形'           => 'する',
    '動詞-体言接続'         => 'する',
    '動詞-体言接続特殊２'   => 'す',
    '動詞-文語基本形'       => 'する',
    '動詞-未然レル接続'     => 'せ',
   #'動詞-未然形'           => '',
   #'動詞-未然特殊'         => '',
    '動詞-命令ｅ'           => '',
    '動詞-命令ｒｏ'         => '',
    '動詞-命令ｙｏ'         => '',
   #'動詞-連用タ接続'       => '',
    '形容詞-ガル接続'       => '',
    '動詞-連用形'           => 'し',
    '形容詞-仮定形'         => 'なら',
    '形容詞-仮定縮約１'     => 'なら',
    '形容詞-仮定縮約２'     => 'なら',
    '形容詞-基本形'         => 'な',
    '形容詞-体言接続'       => 'な',
    '形容詞-文語基本形'     => '',
    '形容詞-未然ウ接続'     => 'だろ',
    '形容詞-未然ヌ接続'     => 'らしから',
    '形容詞-命令ｅ'         => 'であれ',
    '形容詞-連用ゴザイ接続' => '',
    '形容詞-連用タ接続'     => 'だっ',
    '形容詞-連用テ接続'     => 'に',
};

while (my $line = <>) {
    chomp $line;
    $line = decode('euc-jp', $line);

    my $lou = lou($line);
    next if not defined $lou;

    print $lou;
}

print <DATA>;

exit;

sub lou {
    my $feature = shift or return;

    # 表層形,左文脈ID,右文脈ID,コスト,品詞,品詞細分類1,品詞細分類2,品詞細分類3,活用型,活用形,原形,読み,発音
    my ($c, $d, $e, $cost, $pos, $f, $g, $h, $type, $form, $lemma, $i, $j) = split /,/, $feature;
    
    my $kana = $ja2kana->{$lemma};
    if (not defined $kana) {
        return;
    }
    
    my $pos_form = "$pos-$form";
    my $okuri = $pos_form_okuri_map->{$pos_form}; 
    if (not defined $okuri) {
        return;
    }

    $cost -= 1000;
    $cost = 1 if $cost <= 0;
    
    return join ",", $c, $d, $e, $cost, $pos, $f, $g, $h, $type, $form, $lemma, $i, $j, $kana, $okuri, "\n";
}

sub get_ja2kana {
    my $dic = {};
    open my $fh, '<:encoding(utf-8)', "$FindBin::Bin/ja2kana.csv";
    while (my $line = <$fh>) {
        chomp $line;
        next if $line =~ /^#/;
        
        my ($ja, $lou) = split /,/, $line;
        next if not $ja or not $lou;
        
        $lou =~ s/\s//g;
        
        next if $lou =~ /^[a-z]+$/i; 

        $dic->{$ja} = $lou; 
    }

    $dic;
}

__DATA__
ルー語,1,1,1200,その他,一般,*,*,*,*,*,*,*,ルー語,
元気,1,1,1200,その他,一般,*,*,*,*,*,*,*,ファイン,
一年,1,1,1200,その他,一般,*,*,*,*,*,*,*,ワンイヤー,
よいお年,1,1,1200,その他,一般,*,*,*,*,*,*,*,グッドイヤー,
良いお年,1,1,1200,その他,一般,*,*,*,*,*,*,*,グッドイヤー,
新年,1,1,1200,その他,一般,*,*,*,*,*,*,*,ニューイヤー,
お願いします,1,1,1200,その他,一般,*,*,*,*,*,*,*,プリーズ,
水臭い,1,1,1200,その他,一般,*,*,*,*,*,*,*,ウォーター臭い,
犬も歩けば棒に当たる,1,1,1200,その他,一般,*,*,*,*,*,*,*,犬もウォークすればポールにヒットする,
泣きっ面に蜂,1,1,1200,その他,一般,*,*,*,*,*,*,*,泣きっ面にビー,
やぶから棒,1,1,1200,その他,一般,*,*,*,*,*,*,*,やぶからスティック,
薮から棒,1,1,1200,その他,一般,*,*,*,*,*,*,*,薮からスティック,
藪から棒,1,1,1200,その他,一般,*,*,*,*,*,*,*,藪からスティック,
念には念を入れよ,1,1,1200,その他,一般,*,*,*,*,*,*,*,念には念をプットイン,
立て板に水,1,1,1200,その他,一般,*,*,*,*,*,*,*,立て板にウォーター,
青菜に塩,1,1,1200,その他,一般,*,*,*,*,*,*,*,青菜にソルト,
自己破産,1,1,1200,その他,一般,*,*,*,*,*,*,*,バイマイセルフ破産,
地球温暖化,1,1,1200,その他,一般,*,*,*,*,*,*,*,地球ホット化,
ちりも積もれば山となる,1,1,1200,その他,一般,*,*,*,*,*,*,*,トラッシュも積もればマウンテンとなる,
知らぬが仏,1,1,1200,その他,一般,*,*,*,*,*,*,*,ドントノウが仏,
論より証拠,1,1,1200,その他,一般,*,*,*,*,*,*,*,論よりエビデンス,
天下り問題,1,1,1200,その他,一般,*,*,*,*,*,*,*,ヘブン下りプロブレム,
負けるが勝ち,1,1,1200,その他,一般,*,*,*,*,*,*,*,ルーズするがウイン,
雨降って地固まる,1,1,1200,その他,一般,*,*,*,*,*,*,*,レイン降ってアース固まる,
石の上にも三年,1,1,1200,その他,一般,*,*,*,*,*,*,*,ストーンの上にもスリーイヤー,
石橋を叩いて渡る,1,1,1200,その他,一般,*,*,*,*,*,*,*,石橋をタップして渡る,
河童の川流れ,1,1,1200,その他,一般,*,*,*,*,*,*,*,河童のリバー流れ,
壁に耳あり、障子に目あり,1,1,1200,その他,一般,*,*,*,*,*,*,*,壁にイヤーあり、障子にアイズあり,
弘法も筆の誤まり,1,1,1200,その他,一般,*,*,*,*,*,*,*,弘法もペンシルの誤まり,
猿も木から落ちる,1,1,1200,その他,一般,*,*,*,*,*,*,*,猿もツリーからドロッピング,
転ばぬ先の杖,1,1,1200,その他,一般,*,*,*,*,*,*,*,転ばぬ先のステッキ,
触らぬ神に祟りなし,1,1,1200,その他,一般,*,*,*,*,*,*,*,触らぬヘブンに祟りなし,
重箱の隅を楊枝でほじくる,1,1,1200,その他,一般,*,*,*,*,*,*,*,重箱の隅をチョップスティックでほじくる,
雀の涙,1,1,1200,その他,一般,*,*,*,*,*,*,*,雀のティアー,
宝の持ち腐れ,1,1,1200,その他,一般,*,*,*,*,*,*,*,トレジャーの持ち腐れ,
出る杭は打たれる,1,1,1200,その他,一般,*,*,*,*,*,*,*,出るポールは打たれる,
年寄りの冷や水,1,1,1200,その他,一般,*,*,*,*,*,*,*,オールドの冷やウォーター,
長い物には巻かれろ,1,1,1200,その他,一般,*,*,*,*,*,*,*,長い物にはローリング,
二階から目薬,1,1,1200,その他,一般,*,*,*,*,*,*,*,二階からアイドラッグ,
似た者夫婦,1,1,1200,その他,一般,*,*,*,*,*,*,*,似た者マリードカップル,
猫に小判,1,1,1200,その他,一般,*,*,*,*,*,*,*,猫にマネー,
弁慶の泣き所,1,1,1200,その他,一般,*,*,*,*,*,*,*,弁慶のクライ所,
仏作って魂入れず,1,1,1200,その他,一般,*,*,*,*,*,*,*,仏作ってソウル入れず,
焼け石に水,1,1,1200,その他,一般,*,*,*,*,*,*,*,焼け石にウォーター,
良薬は口に苦し,1,1,1200,その他,一般,*,*,*,*,*,*,*,良薬はマウスにビター,
背に腹はかえられぬ,1,1,1200,その他,一般,*,*,*,*,*,*,*,背にストマックはかえられぬ,
憎まれっ子世に憚る,1,1,1200,その他,一般,*,*,*,*,*,*,*,バッドボーイ世に憚る,
骨折り損の草臥れ儲け,1,1,1200,その他,一般,*,*,*,*,*,*,*,骨折りロストの草臥れプロフィット,
身から出た錆,1,1,1200,その他,一般,*,*,*,*,*,*,*,ボディから出た錆,
安物買いの銭失い,1,1,1200,その他,一般,*,*,*,*,*,*,*,安物バイの銭ルーズ,
旅は道連れ、世は情け,1,1,1200,その他,一般,*,*,*,*,*,*,*,トラベルは道連れ、世はカインドネス,
糠に釘,1,1,1200,その他,一般,*,*,*,*,*,*,*,糠にスパイク,
酒は百薬の長,1,1,1200,その他,一般,*,*,*,*,*,*,*,酒はハンドレッドメディスンの長,
寝耳に水,1,1,1200,その他,一般,*,*,*,*,*,*,*,寝耳にウォーター,
頭隠して尻隠さず,1,1,1200,その他,一般,*,*,*,*,*,*,*,頭ハイドしてヒップ隠さず,
楽あれば苦あり,1,1,1200,その他,一般,*,*,*,*,*,*,*,ファニーあればディフィカルトあり,
火中の栗を拾う,1,1,1200,その他,一般,*,*,*,*,*,*,*,火中のマロンを拾う,
鬼に金棒,1,1,1200,その他,一般,*,*,*,*,*,*,*,デビルに金棒,
芸は身を助ける,1,1,1200,その他,一般,*,*,*,*,*,*,*,芸はボディをヘルプする,
匙を投げる,1,1,1200,その他,一般,*,*,*,*,*,*,*,スプーンを投げる,
死人に口なし,1,1,1200,その他,一般,*,*,*,*,*,*,*,死人にマウスなし,
能ある鷹は爪を隠す,1,1,1200,その他,一般,*,*,*,*,*,*,*,能あるホークはネイルを隠す,
仏の顔も三度,1,1,1200,その他,一般,*,*,*,*,*,*,*,仏のフェイスもスリータイムズ,
爪に火をともす,1,1,1200,その他,一般,*,*,*,*,*,*,*,ネイルにファイヤーをともす,
一寸先は闇,1,1,1200,その他,一般,*,*,*,*,*,*,*,一寸アフターはダーク,
焼け石に水,1,1,1200,その他,一般,*,*,*,*,*,*,*,焼けストーンにウォーター,
溺れるものは藁をも掴む,1,1,1200,その他,一般,*,*,*,*,*,*,*,溺れるものはストローをも掴む,
下流,1,1,1200,その他,一般,*,*,*,*,*,*,*,ローリバー,
幼児虐待,1,1,1200,その他,一般,*,*,*,*,*,*,*,幼児バイオレンス,
超うざい,1,1,1200,その他,一般,*,*,*,*,*,*,*,ベリーうざい,
改正,1,1,1200,その他,一般,*,*,*,*,*,*,*,リフォーム,
破綻,1,1,1200,その他,一般,*,*,*,*,*,*,*,メルトダウン,
不払い問題,1,1,1200,その他,一般,*,*,*,*,*,*,*,ノーペイ,
統合,1,1,1200,その他,一般,*,*,*,*,*,*,*,トゥギャザー,
風の噂,1,1,1200,その他,一般,*,*,*,*,*,*,*,ウィンドの噂,
殺してしまえ,1,1,1200,その他,一般,*,*,*,*,*,*,*,キルしてしまえ,
鳴かせてみせよう,1,1,1200,その他,一般,*,*,*,*,*,*,*,メイク・シングさせよう,
鳴くまで待とう,1,1,1200,その他,一般,*,*,*,*,*,*,*,ウェイトしよう,
渡りに船,1,1,1200,その他,一般,*,*,*,*,*,*,*,渡りにシップ,
赤子の手をひねる,1,1,1200,その他,一般,*,*,*,*,*,*,*,ベビーの手をひねる,
揚げ足をとる,1,1,1200,その他,一般,*,*,*,*,*,*,*,揚げフットをとる,
当たって砕けよ,1,1,1200,その他,一般,*,*,*,*,*,*,*,アタックして砕けよ,
水と油,1,1,1200,その他,一般,*,*,*,*,*,*,*,ウォーターとオイル,
残り物には福がある,1,1,1200,その他,一般,*,*,*,*,*,*,*,残り物にはハッピーがある,
言うは易し、行うは難し,1,1,1200,その他,一般,*,*,*,*,*,*,*,言うはイージー、行うはディフィカルト,
いざ鎌倉,1,1,1200,その他,一般,*,*,*,*,*,*,*,カモン鎌倉,
一富士二鷹三茄子,1,1,1200,その他,一般,*,*,*,*,*,*,*,ワン富士ツー鷹スリー茄子,
犬が西向きゃ尾は東,1,1,1200,その他,一般,*,*,*,*,*,*,*,ドッグが西向きゃテイルは東,
後ろ髪を引かれる,1,1,1200,その他,一般,*,*,*,*,*,*,*,後ろヘアーを引かれる,
後ろ指を指される,1,1,1200,その他,一般,*,*,*,*,*,*,*,後ろフィンガーを指される,
売り言葉に買い言葉,1,1,1200,その他,一般,*,*,*,*,*,*,*,セル言葉にバイ言葉,
絵に描いた餅,1,1,1200,その他,一般,*,*,*,*,*,*,*,ピクチャに描いたライスケーキ,
お茶を濁す,1,1,1200,その他,一般,*,*,*,*,*,*,*,ティーを濁す,
思い立ったが吉日,1,1,1200,その他,一般,*,*,*,*,*,*,*,思い立ったがラッキーデー,
親の心子知らず,1,1,1200,その他,一般,*,*,*,*,*,*,*,親の心子ドントノウ,
木を見て森を見ず,1,1,1200,その他,一般,*,*,*,*,*,*,*,木をルックして森をドントルック,
犬猿の仲,1,1,1200,その他,一般,*,*,*,*,*,*,*,ドッグモンキーの仲,
子の心親知らず,1,1,1200,その他,一般,*,*,*,*,*,*,*,子の心親ドントノウ,
案ずるより産むが易し,1,1,1200,その他,一般,*,*,*,*,*,*,*,ウォーリーより産むがイージー,
顔を洗って出直す,1,1,1200,その他,一般,*,*,*,*,*,*,*,フェイスを洗ってカムバック,
かわいい子には旅させよ,1,1,1200,その他,一般,*,*,*,*,*,*,*,ラブリーな子にはトリップさせよ,
後の祭り,1,1,1200,その他,一般,*,*,*,*,*,*,*,後のフェスティバル,
十人十色,1,1,1200,その他,一般,*,*,*,*,*,*,*,十人テンカラー,
覆水盆に返らず,1,1,1200,その他,一般,*,*,*,*,*,*,*,覆水ノーリターン,
ゆく年くる年,1,1,1200,その他,一般,*,*,*,*,*,*,*,ゴゥするイヤー、カムするイヤー,
目は口ほどに物を言う,1,1,1200,その他,一般,*,*,*,*,*,*,*,目はマウスほどに物をセイ,
急がば回れ,1,1,1200,その他,一般,*,*,*,*,*,*,*,急がばスピン,
果報は寝て待て,1,1,1200,その他,一般,*,*,*,*,*,*,*,ラッキーは寝てウェイト,
月とすっぽん,1,1,1200,その他,一般,*,*,*,*,*,*,*,ムーンとスッポン,
花より団子,1,1,1200,その他,一般,*,*,*,*,*,*,*,フラワーより団子,
下手な鉄砲も数打ちゃ当たる,1,1,1200,その他,一般,*,*,*,*,*,*,*,下手なピストルも数打ちゃヒットする,
鬼,1,1,1200,その他,一般,*,*,*,*,*,*,*,デビル,
井の中の蛙大海を知らず,1,1,1200,その他,一般,*,*,*,*,*,*,*,井の中のフロッグ大海をドントノウ,
雲泥の差,1,1,1200,その他,一般,*,*,*,*,*,*,*,雲泥のディファレンス,
蛙の子は蛙,1,1,1200,その他,一般,*,*,*,*,*,*,*,フロッグの子はフロッグ,
苦しい時の神頼み,1,1,1200,その他,一般,*,*,*,*,*,*,*,苦しい時のヘブン頼み,
弘法筆を選ばず,1,1,1200,その他,一般,*,*,*,*,*,*,*,弘法ペンシルを選ばず,
賽は投げられた,1,1,1200,その他,一般,*,*,*,*,*,*,*,ダイスは投げられた,
捨てる神あれば拾う神あり,1,1,1200,その他,一般,*,*,*,*,*,*,*,捨てるヘブンあれば拾うヘブンあり,
沈黙は金、雄弁は銀,1,1,1200,その他,一般,*,*,*,*,*,*,*,沈黙はゴールド、雄弁はシルバー,
爪の垢を煎じて飲む,1,1,1200,その他,一般,*,*,*,*,*,*,*,ネイルの垢を煎じてドリンク,
鉄は熱いうちに打て,1,1,1200,その他,一般,*,*,*,*,*,*,*,アイロンは熱いうちにヒット,
八方塞がり,1,1,1200,その他,一般,*,*,*,*,*,*,*,エイトウェイ塞がり,
鳩に豆鉄砲,1,1,1200,その他,一般,*,*,*,*,*,*,*,鳩に豆ピストル,
秋茄子は嫁に食わすな,1,1,1200,その他,一般,*,*,*,*,*,*,*,オータム茄子はワイフに食わすな,
後は野となれ山となれ,1,1,1200,その他,一般,*,*,*,*,*,*,*,後はフィールドとなれマウンテンとなれ,
一姫二太郎,1,1,1200,その他,一般,*,*,*,*,*,*,*,ワン姫ツー太郎,
嘘からでた真,1,1,1200,その他,一般,*,*,*,*,*,*,*,ライから出たトゥルー,
飼い犬に手をかまれる,1,1,1200,その他,一般,*,*,*,*,*,*,*,ペット犬にハンドをかまれる,
夫婦喧嘩は犬も食わない,1,1,1200,その他,一般,*,*,*,*,*,*,*,マリードカップル喧嘩は犬もドントイート,
馬子にも衣装,1,1,1200,その他,一般,*,*,*,*,*,*,*,馬子にもドレス,
虎の威を借る狐,1,1,1200,その他,一般,*,*,*,*,*,*,*,タイガーの威を借るフォックス,
雀百まで踊り忘れず,1,1,1200,その他,一般,*,*,*,*,*,*,*,スパロー百までダンス忘れず,
猫も杓子も,1,1,1200,その他,一般,*,*,*,*,*,*,*,猫もスプーンも,
豚に真珠,1,1,1200,その他,一般,*,*,*,*,*,*,*,豚にパール,
猫の手も借りたい,1,1,1200,その他,一般,*,*,*,*,*,*,*,猫のハンドもレンタルしたい,
立つ鳥跡を濁さず,1,1,1200,その他,一般,*,*,*,*,*,*,*,リービングバード跡を濁さず,
早起きは三文の徳,1,1,1200,その他,一般,*,*,*,*,*,*,*,早ウェイクアップは三文のプロフィット,
親の七光,1,1,1200,その他,一般,*,*,*,*,*,*,*,親のセブンライツ,
笑う門には福来たる,1,1,1200,その他,一般,*,*,*,*,*,*,*,笑うゲートには福カモン,
五十歩百歩,1,1,1200,その他,一般,*,*,*,*,*,*,*,五十フット百フット,
三歩進んで、二歩下がる,1,1,1200,その他,一般,*,*,*,*,*,*,*,スリーフット進んで、ツーフットバック,
詰めが甘い,1,1,1200,その他,一般,*,*,*,*,*,*,*,詰めがスウィート,
記憶にございません,1,1,1200,その他,一般,*,*,*,*,*,*,*,メモリーにございません,
同情するなら金をくれ,1,1,1200,その他,一般,*,*,*,*,*,*,*,同情するならマネーをくれ,
豚もおだてりゃ木に登る,1,1,1200,その他,一般,*,*,*,*,*,*,*,ピッグもおだてりゃツリーに登る,
耳にタコができる程聞いた,1,1,1200,その他,一般,*,*,*,*,*,*,*,イヤーにオクトパスができる程リッスンした,
豚に真珠,1,1,1200,その他,一般,*,*,*,*,*,*,*,ピッグにパール,
金は天下の回りもの,1,1,1200,その他,一般,*,*,*,*,*,*,*,マネーは天下のスピンもの,
木を見て森を見ず,1,1,1200,その他,一般,*,*,*,*,*,*,*,トゥリーを見てフォレスト見ず,
早起きは三文の徳,1,1,1200,その他,一般,*,*,*,*,*,*,*,早起きはスリーダラーゲット,
器用貧乏,1,1,1200,その他,一般,*,*,*,*,*,*,*,器用プア,
一人旅,1,1,1200,その他,一般,*,*,*,*,*,*,*,アローン旅,
他人の空似,1,1,1200,その他,一般,*,*,*,*,*,*,*,他人のスカイ似,
芋焼酎,1,1,1200,その他,一般,*,*,*,*,*,*,*,ポテト焼酎,
私事,1,1,1200,その他,一般,*,*,*,*,*,*,*,ミー事,
隠し子,1,1,1200,その他,一般,*,*,*,*,*,*,*,ハイド子,
一石二鳥,1,1,1200,その他,一般,*,*,*,*,*,*,*,一ストーン二バード,
紅白歌合戦,1,1,1200,その他,一般,*,*,*,*,*,*,*,レッドホワイト歌合戦,
山あり谷あり,1,1,1200,その他,一般,*,*,*,*,*,*,*,マウンテンありヴァレーあり,
うたた寝,1,1,1200,その他,一般,*,*,*,*,*,*,*,うたたスリープ,
うずらの卵,1,1,1200,その他,一般,*,*,*,*,*,*,*,うずらのエッグ,
虫の知らせ,1,1,1200,その他,一般,*,*,*,*,*,*,*,虫のインフォメーション,
果報は寝て待て,1,1,1200,その他,一般,*,*,*,*,*,*,*,果報はグッナイして待て,
犬も歩けば棒に当たる,1,1,1200,その他,一般,*,*,*,*,*,*,*,ドッグも歩けばスティックにヒット,
千の風になって,1,1,1200,その他,一般,*,*,*,*,*,*,*,サウザンドのウィンドになって,
鶴の一声,1,1,1200,その他,一般,*,*,*,*,*,*,*,鶴のワンボイス,
親馬鹿,1,1,1200,その他,一般,*,*,*,*,*,*,*,ペアレント馬鹿,
穴があったら入りたい,1,1,1200,その他,一般,*,*,*,*,*,*,*,ホールがあったら入りたい,
面目が丸潰れ,1,1,1200,その他,一般,*,*,*,*,*,*,*,フェイスが丸ブロークン,
火のないところに煙は立たぬ,1,1,1200,その他,一般,*,*,*,*,*,*,*,ファイヤーのないところにスモークは立たぬ,
危機一髪,1,1,1200,その他,一般,*,*,*,*,*,*,*,クライシス一髪,
汗と涙の結晶,1,1,1200,その他,一般,*,*,*,*,*,*,*,スウェットとティアーの結晶,
机上の空論,1,1,1200,その他,一般,*,*,*,*,*,*,*,空論オンザデスク,
天下り,1,1,1200,その他,一般,*,*,*,*,*,*,*,ヘブン下り,
