; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s
; RUN: llc -use-constant-int-for-scalable-splat < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <vscale x 16 x i8> @sdiv_i8(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: sdiv_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #4
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 16 x i8> %a, splat (i8 16)
  ret <vscale x 16 x i8> %out
}

define <vscale x 16 x i8> @sdiv_i8_neg(<vscale x 16 x i8> %a) #0 {
; CHECK-LABEL: sdiv_i8_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #6
; CHECK-NEXT:    subr z0.b, z0.b, #0 // =0x0
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 16 x i8> %a, splat (i8 -64)
  ret <vscale x 16 x i8> %out
}

define <vscale x 8 x i16> @sdiv_i16(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: sdiv_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #10
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 8 x i16> %a, splat (i16 1024)
  ret <vscale x 8 x i16> %out
}

define <vscale x 8 x i16> @sdiv_i16_neg(<vscale x 8 x i16> %a) #0 {
; CHECK-LABEL: sdiv_i16_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #12
; CHECK-NEXT:    subr z0.h, z0.h, #0 // =0x0
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 8 x i16> %a, splat (i16 -4096)
  ret <vscale x 8 x i16> %out
}

define <vscale x 4 x i32> @sdiv_i32(<vscale x 4 x i32> %a) #0 {
; CHECK-LABEL: sdiv_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #23
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 4 x i32> %a, splat (i32 8388608)
  ret <vscale x 4 x i32> %out
}

define <vscale x 4 x i32> @sdiv_i32_neg(<vscale x 4 x i32> %a) #0 {
; CHECK-LABEL: sdiv_i32_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #25
; CHECK-NEXT:    subr z0.s, z0.s, #0 // =0x0
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 4 x i32> %a, splat (i32 -33554432)
  ret <vscale x 4 x i32> %out
}

define <vscale x 2 x i64> @sdiv_i64(<vscale x 2 x i64> %a) #0 {
; CHECK-LABEL: sdiv_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #53
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 2 x i64> %a, splat (i64 9007199254740992)
  ret <vscale x 2 x i64> %out
}

define <vscale x 2 x i64> @sdiv_i64_neg(<vscale x 2 x i64> %a) #0 {
; CHECK-LABEL: sdiv_i64_neg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #55
; CHECK-NEXT:    subr z0.d, z0.d, #0 // =0x0
; CHECK-NEXT:    ret
  %out = sdiv <vscale x 2 x i64> %a, splat (i64 -36028797018963968)
  ret <vscale x 2 x i64> %out
}

attributes #0 = { "target-features"="+sve" }
