; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 %s | FileCheck --check-prefixes=CHECK,CHECK-NOFP16 %s
; RUN: opt -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 -mattr=+fullfp16 %s | FileCheck --check-prefixes=CHECK,CHECK-FP16 %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-linux-gnu"

define void @lrint() {
; CHECK-LABEL: 'lrint'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lrint.i64.f32(float poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lrint.v2i64.v2f32(<2 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lrint.v4i64.v4f32(<4 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lrint.v8i64.v8f32(<8 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lrint.v16i64.v16f32(<16 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %6 = call i64 @llvm.lrint.i64.f64(double poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %7 = call <2 x i64> @llvm.lrint.v2i64.v2f64(<2 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %8 = call <4 x i64> @llvm.lrint.v4i64.v4f64(<4 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %9 = call <8 x i64> @llvm.lrint.v8i64.v8f64(<8 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %10 = call <16 x i64> @llvm.lrint.v16i64.v16f64(<16 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lrint(float poison)
  call <2 x i64> @llvm.lrint(<2 x float> poison)
  call <4 x i64> @llvm.lrint(<4 x float> poison)
  call <8 x i64> @llvm.lrint(<8 x float> poison)
  call <16 x i64> @llvm.lrint(<16 x float> poison)
  call i64 @llvm.lrint(double poison)
  call <2 x i64> @llvm.lrint(<2 x double> poison)
  call <4 x i64> @llvm.lrint(<4 x double> poison)
  call <8 x i64> @llvm.lrint(<8 x double> poison)
  call <16 x i64> @llvm.lrint(<16 x double> poison)
  ret void
}

define void @lrint_fp16() {
; CHECK-LABEL: 'lrint_fp16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lrint.i64.f16(half poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lrint.v2i64.v2f16(<2 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lrint.v4i64.v4f16(<4 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lrint.v8i64.v8f16(<8 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lrint.v16i64.v16f16(<16 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lrint(half poison)
  call <2 x i64> @llvm.lrint(<2 x half> poison)
  call <4 x i64> @llvm.lrint(<4 x half> poison)
  call <8 x i64> @llvm.lrint(<8 x half> poison)
  call <16 x i64> @llvm.lrint(<16 x half> poison)
  ret void
}

define void @lrint_bf16() {
; CHECK-LABEL: 'lrint_bf16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lrint.i64.bf16(bfloat poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lrint.v2i64.v2bf16(<2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lrint.v4i64.v4bf16(<4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lrint.v8i64.v8bf16(<8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lrint.v16i64.v16bf16(<16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lrint(bfloat poison)
  call <2 x i64> @llvm.lrint(<2 x bfloat> poison)
  call <4 x i64> @llvm.lrint(<4 x bfloat> poison)
  call <8 x i64> @llvm.lrint(<8 x bfloat> poison)
  call <16 x i64> @llvm.lrint(<16 x bfloat> poison)
  ret void
}

define void @llrint() {
; CHECK-LABEL: 'llrint'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llrint.i64.f32(float poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llrint.v2i64.v2f32(<2 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llrint.v4i64.v4f32(<4 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llrint.v8i64.v8f32(<8 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llrint.v16i64.v16f32(<16 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %6 = call i64 @llvm.llrint.i64.f64(double poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %7 = call <2 x i64> @llvm.llrint.v2i64.v2f64(<2 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %8 = call <4 x i64> @llvm.llrint.v4i64.v4f64(<4 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %9 = call <8 x i64> @llvm.llrint.v8i64.v8f64(<8 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %10 = call <16 x i64> @llvm.llrint.v16i64.v16f64(<16 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llrint(float poison)
  call <2 x i64> @llvm.llrint(<2 x float> poison)
  call <4 x i64> @llvm.llrint(<4 x float> poison)
  call <8 x i64> @llvm.llrint(<8 x float> poison)
  call <16 x i64> @llvm.llrint(<16 x float> poison)
  call i64 @llvm.llrint(double poison)
  call <2 x i64> @llvm.llrint(<2 x double> poison)
  call <4 x i64> @llvm.llrint(<4 x double> poison)
  call <8 x i64> @llvm.llrint(<8 x double> poison)
  call <16 x i64> @llvm.llrint(<16 x double> poison)
  ret void
}

define void @llrint_fp16() {
; CHECK-LABEL: 'llrint_fp16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llrint.i64.f16(half poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llrint.v2i64.v2f16(<2 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llrint.v4i64.v4f16(<4 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llrint.v8i64.v8f16(<8 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llrint.v16i64.v16f16(<16 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llrint(half poison)
  call <2 x i64> @llvm.llrint(<2 x half> poison)
  call <4 x i64> @llvm.llrint(<4 x half> poison)
  call <8 x i64> @llvm.llrint(<8 x half> poison)
  call <16 x i64> @llvm.llrint(<16 x half> poison)
  ret void
}

define void @llrint_bf16() {
; CHECK-LABEL: 'llrint_bf16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llrint.i64.bf16(bfloat poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llrint.v2i64.v2bf16(<2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llrint.v4i64.v4bf16(<4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llrint.v8i64.v8bf16(<8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llrint.v16i64.v16bf16(<16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llrint(bfloat poison)
  call <2 x i64> @llvm.llrint(<2 x bfloat> poison)
  call <4 x i64> @llvm.llrint(<4 x bfloat> poison)
  call <8 x i64> @llvm.llrint(<8 x bfloat> poison)
  call <16 x i64> @llvm.llrint(<16 x bfloat> poison)
  ret void
}


define void @lround() {
; CHECK-LABEL: 'lround'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lround.i64.f32(float poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lround.v2i64.v2f32(<2 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lround.v4i64.v4f32(<4 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lround.v8i64.v8f32(<8 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lround.v16i64.v16f32(<16 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %6 = call i64 @llvm.lround.i64.f64(double poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %7 = call <2 x i64> @llvm.lround.v2i64.v2f64(<2 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %8 = call <4 x i64> @llvm.lround.v4i64.v4f64(<4 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %9 = call <8 x i64> @llvm.lround.v8i64.v8f64(<8 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %10 = call <16 x i64> @llvm.lround.v16i64.v16f64(<16 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lround(float poison)
  call <2 x i64> @llvm.lround(<2 x float> poison)
  call <4 x i64> @llvm.lround(<4 x float> poison)
  call <8 x i64> @llvm.lround(<8 x float> poison)
  call <16 x i64> @llvm.lround(<16 x float> poison)
  call i64 @llvm.lround(double poison)
  call <2 x i64> @llvm.lround(<2 x double> poison)
  call <4 x i64> @llvm.lround(<4 x double> poison)
  call <8 x i64> @llvm.lround(<8 x double> poison)
  call <16 x i64> @llvm.lround(<16 x double> poison)
  ret void
}

define void @lround_fp16() {
; CHECK-LABEL: 'lround_fp16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lround.i64.f16(half poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lround.v2i64.v2f16(<2 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lround.v4i64.v4f16(<4 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lround.v8i64.v8f16(<8 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lround.v16i64.v16f16(<16 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lround(half poison)
  call <2 x i64> @llvm.lround(<2 x half> poison)
  call <4 x i64> @llvm.lround(<4 x half> poison)
  call <8 x i64> @llvm.lround(<8 x half> poison)
  call <16 x i64> @llvm.lround(<16 x half> poison)
  ret void
}

define void @lround_bf16() {
; CHECK-LABEL: 'lround_bf16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.lround.i64.bf16(bfloat poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.lround.v2i64.v2bf16(<2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.lround.v4i64.v4bf16(<4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.lround.v8i64.v8bf16(<8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.lround.v16i64.v16bf16(<16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.lround(bfloat poison)
  call <2 x i64> @llvm.lround(<2 x bfloat> poison)
  call <4 x i64> @llvm.lround(<4 x bfloat> poison)
  call <8 x i64> @llvm.lround(<8 x bfloat> poison)
  call <16 x i64> @llvm.lround(<16 x bfloat> poison)
  ret void
}

define void @llround() {
; CHECK-LABEL: 'llround'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llround.i64.f32(float poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llround.v2i64.v2f32(<2 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llround.v4i64.v4f32(<4 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llround.v8i64.v8f32(<8 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llround.v16i64.v16f32(<16 x float> poison)
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %6 = call i64 @llvm.llround.i64.f64(double poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %7 = call <2 x i64> @llvm.llround.v2i64.v2f64(<2 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %8 = call <4 x i64> @llvm.llround.v4i64.v4f64(<4 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %9 = call <8 x i64> @llvm.llround.v8i64.v8f64(<8 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %10 = call <16 x i64> @llvm.llround.v16i64.v16f64(<16 x double> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llround(float poison)
  call <2 x i64> @llvm.llround(<2 x float> poison)
  call <4 x i64> @llvm.llround(<4 x float> poison)
  call <8 x i64> @llvm.llround(<8 x float> poison)
  call <16 x i64> @llvm.llround(<16 x float> poison)
  call i64 @llvm.llround(double poison)
  call <2 x i64> @llvm.llround(<2 x double> poison)
  call <4 x i64> @llvm.llround(<4 x double> poison)
  call <8 x i64> @llvm.llround(<8 x double> poison)
  call <16 x i64> @llvm.llround(<16 x double> poison)
  ret void
}

define void @llround_fp16() {
; CHECK-LABEL: 'llround_fp16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llround.i64.f16(half poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llround.v2i64.v2f16(<2 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llround.v4i64.v4f16(<4 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llround.v8i64.v8f16(<8 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llround.v16i64.v16f16(<16 x half> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llround(half poison)
  call <2 x i64> @llvm.llround(<2 x half> poison)
  call <4 x i64> @llvm.llround(<4 x half> poison)
  call <8 x i64> @llvm.llround(<8 x half> poison)
  call <16 x i64> @llvm.llround(<16 x half> poison)
  ret void
}

define void @llround_bf16() {
; CHECK-LABEL: 'llround_bf16'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %1 = call i64 @llvm.llround.i64.bf16(bfloat poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:4 Lat:6 SizeLat:6 for: %2 = call <2 x i64> @llvm.llround.v2i64.v2bf16(<2 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:8 Lat:12 SizeLat:12 for: %3 = call <4 x i64> @llvm.llround.v4i64.v4bf16(<4 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:16 Lat:24 SizeLat:24 for: %4 = call <8 x i64> @llvm.llround.v8i64.v8bf16(<8 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:32 Lat:48 SizeLat:48 for: %5 = call <16 x i64> @llvm.llround.v16i64.v16bf16(<16 x bfloat> poison)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  call i64 @llvm.llround(bfloat poison)
  call <2 x i64> @llvm.llround(<2 x bfloat> poison)
  call <4 x i64> @llvm.llround(<4 x bfloat> poison)
  call <8 x i64> @llvm.llround(<8 x bfloat> poison)
  call <16 x i64> @llvm.llround(<16 x bfloat> poison)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-FP16: {{.*}}
; CHECK-NOFP16: {{.*}}
