; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=newgvn -S < %s | FileCheck %s

; Check that the redundant load from %if.then is removed.
; Also, check that the debug location associated to load %0 still refers to
; line 3 and not line 6.

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"


define i32 @test_redundant_load(i32 %X, ptr %Y) !dbg !6 {
; CHECK-LABEL: define i32 @test_redundant_load(
; CHECK-SAME: i32 [[X:%.*]], ptr [[Y:%.*]]) !dbg [[DBG6:![0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[Y]], align 4, !dbg [[DBG8:![0-9]+]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], -1, !dbg [[DBG9:![0-9]+]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END:%.*]], !dbg [[DBG9]]
; CHECK:       if.then:
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP0]], !dbg [[DBG10:![0-9]+]]
; CHECK-NEXT:    call void @foo(), !dbg [[DBG11:![0-9]+]]
; CHECK-NEXT:    br label [[IF_END]], !dbg [[DBG12:![0-9]+]]
; CHECK:       if.end:
; CHECK-NEXT:    [[RESULT_0:%.*]] = phi i32 [ [[ADD]], [[IF_THEN]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RESULT_0]], !dbg [[DBG13:![0-9]+]]
;
entry:
  %0 = load i32, ptr %Y, align 4, !dbg !8
  %cmp = icmp sgt i32 %X, -1, !dbg !9
  br i1 %cmp, label %if.then, label %if.end, !dbg !9

if.then:                                          ; preds = %entry
  %1 = load i32, ptr %Y, align 4, !dbg !10
  %add = add nsw i32 %0, %1, !dbg !10
  call void @foo(), !dbg !11
  br label %if.end, !dbg !12

if.end:                                           ; preds = %if.then, %entry
  %Result.0 = phi i32 [ %add, %if.then ], [ %0, %entry ]
  ret i32 %Result.0, !dbg !13
}

declare void @foo()

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3, !4, !5}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, isOptimized: false, runtimeVersion: 0, emissionKind: LineTablesOnly, enums: !2)
!1 = !DIFile(filename: "test.cpp", directory: "")
!2 = !{}
!3 = !{i32 2, !"Dwarf Version", i32 4}
!4 = !{i32 2, !"Debug Info Version", i32 3}
!5 = !{i32 1, !"PIC Level", i32 2}
!6 = distinct !DISubprogram(name: "test_redundant_load", scope: !1, file: !1, line: 2, type: !7, isLocal: false, isDefinition: true, scopeLine: 2, flags: DIFlagPrototyped, isOptimized: false, unit: !0, retainedNodes: !2)
!7 = !DISubroutineType(types: !2)
!8 = !DILocation(line: 3, scope: !6)
!9 = !DILocation(line: 5, scope: !6)
!10 = !DILocation(line: 6, scope: !6)
!11 = !DILocation(line: 7, scope: !6)
!12 = !DILocation(line: 8, scope: !6)
!13 = !DILocation(line: 10, scope: !6)
;.
; CHECK: [[META0:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: [[META1:![0-9]+]], isOptimized: false, runtimeVersion: 0, emissionKind: LineTablesOnly, enums: [[META2:![0-9]+]])
; CHECK: [[META1]] = !DIFile(filename: "test.cpp", directory: "")
; CHECK: [[META2]] = !{}
; CHECK: [[DBG6]] = distinct !DISubprogram(name: "test_redundant_load", scope: [[META1]], file: [[META1]], line: 2, type: [[META7:![0-9]+]], scopeLine: 2, flags: DIFlagPrototyped, spFlags: DISPFlagDefinition, unit: [[META0]], retainedNodes: [[META2]])
; CHECK: [[META7]] = !DISubroutineType(types: [[META2]])
; CHECK: [[DBG8]] = !DILocation(line: 3, scope: [[DBG6]])
; CHECK: [[DBG9]] = !DILocation(line: 5, scope: [[DBG6]])
; CHECK: [[DBG10]] = !DILocation(line: 6, scope: [[DBG6]])
; CHECK: [[DBG11]] = !DILocation(line: 7, scope: [[DBG6]])
; CHECK: [[DBG12]] = !DILocation(line: 8, scope: [[DBG6]])
; CHECK: [[DBG13]] = !DILocation(line: 10, scope: [[DBG6]])
;.
