; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X86

declare <32 x bfloat> @llvm.x86.avx10.vminbf16512(<32 x bfloat>, <32 x bfloat>)

define <32 x bfloat> @test_int_x86_avx10_min_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_min_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5d,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <32 x bfloat> @llvm.x86.avx10.vminbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2)
  ret <32 x bfloat> %res0
}

define <32 x bfloat> @test_int_x86_avx10_maskz_min_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_min_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vminbf16 %zmm1, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x5d,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_min_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vminbf16 %zmm1, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x5d,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = call <32 x bfloat> @llvm.x86.avx10.vminbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2)
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %res1
}

declare <32 x bfloat> @llvm.x86.avx10.vmaxbf16512(<32 x bfloat>, <32 x bfloat>)

define <32 x bfloat> @test_int_x86_avx10_max_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_max_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5f,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res0 = call <32 x bfloat> @llvm.x86.avx10.vmaxbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2)
  ret <32 x bfloat> %res0
}

define <32 x bfloat> @test_int_x86_avx10_maskz_max_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk) {
; X64-LABEL: test_int_x86_avx10_maskz_max_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmaxbf16 %zmm1, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x5f,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_max_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmaxbf16 %zmm1, %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x5f,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = call <32 x bfloat> @llvm.x86.avx10.vmaxbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2)
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %res1
}

declare <32 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.512(<32 x bfloat>, <32 x bfloat>, i32)

define <32 x bfloat> @test_rsqrt_bf16_512(<32 x bfloat> %a0) {
; CHECK-LABEL: test_rsqrt_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrsqrtbf16 %zmm0, %zmm0 # encoding: [0x62,0xf6,0x7c,0x48,0x4e,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <32 x bfloat> @llvm.x86.avx10.mask.rsqrt.bf16.512(<32 x bfloat> %a0, <32 x bfloat> zeroinitializer, i32 -1)
  ret <32 x bfloat> %res
}

declare <32 x i1> @llvm.x86.avx10.fpclass.bf16.512(<32 x bfloat>, i32)

define i32 @test_int_x86_avx512_fpclass_bf16_512(<32 x bfloat> %x0) {
; CHECK-LABEL: test_int_x86_avx512_fpclass_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfpclassbf16 $6, %zmm0, %k1 # encoding: [0x62,0xf3,0x7f,0x48,0x66,0xc8,0x06]
; CHECK-NEXT:    # k1 = isPositiveZero(zmm0) | isNegativeZero(zmm0)
; CHECK-NEXT:    vfpclassbf16 $0, %zmm0, %k0 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x66,0xc0,0x00]
; CHECK-NEXT:    # k0 {%k1} = false
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = call <32 x i1> @llvm.x86.avx10.fpclass.bf16.512(<32 x bfloat> %x0, i32 0)
  %res1 = call <32 x i1> @llvm.x86.avx10.fpclass.bf16.512(<32 x bfloat> %x0, i32 6)
  %1 = and <32 x i1> %res1, %res
  %2 = bitcast <32 x i1> %1 to i32
  ret i32 %2
}

declare <32 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.512(<32 x bfloat>, <32 x bfloat>, i32)

define <32 x bfloat> @test_rcp_bf16_512(<32 x bfloat> %a0, <32 x bfloat> %a1, i32 %mask) {
; X64-LABEL: test_rcp_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrcpbf16 %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0x4c,0xc8]
; X64-NEXT:    vmovaps %zmm1, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_rcp_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrcpbf16 %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0x4c,0xc8]
; X86-NEXT:    vmovaps %zmm1, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <32 x bfloat> @llvm.x86.avx10.mask.rcp.bf16.512(<32 x bfloat> %a0, <32 x bfloat> %a1, i32 %mask)
  ret <32 x bfloat> %res
}

declare <32 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.512(<32 x bfloat>, i32, <32 x bfloat>, i32)

define <32 x bfloat>@test_int_x86_avx512_mask_reduce_bf16_512(<32 x bfloat> %x0, <32 x bfloat> %x2, i32 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_reduce_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vreducebf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x56,0xc8,0x08]
; X64-NEXT:    vreducebf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x56,0xc0,0x04]
; X64-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_reduce_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vreducebf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x56,0xc8,0x08]
; X86-NEXT:    vreducebf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x56,0xc0,0x04]
; X86-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <32 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.512(<32 x bfloat> %x0, i32 8, <32 x bfloat> %x2, i32 %x3)
  %res1 = call <32 x bfloat> @llvm.x86.avx10.mask.reduce.bf16.512(<32 x bfloat> %x0, i32 4, <32 x bfloat> %x2, i32 -1)
  %res2 = fadd <32 x bfloat> %res, %res1
  ret <32 x bfloat> %res2
}

declare <32 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.512(<32 x bfloat>, i32, <32 x bfloat>, i32)

define <32 x bfloat>@test_int_x86_avx512_mask_rndscale_bf16_512(<32 x bfloat> %x0, <32 x bfloat> %x2, i32 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_rndscale_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vrndscalebf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x08,0xc8,0x08]
; X64-NEXT:    vrndscalebf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x08,0xc0,0x04]
; X64-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_rndscale_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vrndscalebf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x08,0xc8,0x08]
; X86-NEXT:    vrndscalebf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x08,0xc0,0x04]
; X86-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <32 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.512(<32 x bfloat> %x0, i32 8, <32 x bfloat> %x2, i32 %x3)
  %res1 = call <32 x bfloat> @llvm.x86.avx10.mask.rndscale.bf16.512(<32 x bfloat> %x0, i32 4, <32 x bfloat> %x2, i32 -1)
  %res2 = fadd <32 x bfloat> %res, %res1
  ret <32 x bfloat> %res2
}

declare <32 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.512(<32 x bfloat>, <32 x bfloat>, i32)

define <32 x bfloat>@test_int_x86_avx512_mask_getexp_bf16_512(<32 x bfloat> %x0, <32 x bfloat> %x1, i32 %x2) {
; X64-LABEL: test_int_x86_avx512_mask_getexp_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetexpbf16 %zmm0, %zmm0 # encoding: [0x62,0xf6,0x7c,0x48,0x42,0xc0]
; X64-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf1,0xff,0x49,0x6f,0xc8]
; X64-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getexp_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetexpbf16 %zmm0, %zmm0 # encoding: [0x62,0xf6,0x7c,0x48,0x42,0xc0]
; X86-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf1,0xff,0x49,0x6f,0xc8]
; X86-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res1 = call <32 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.512(<32 x bfloat> %x0, <32 x bfloat> %x1, i32 %x2)
  %res2 = call <32 x bfloat> @llvm.x86.avx10.mask.getexp.bf16.512(<32 x bfloat> %x0, <32 x bfloat> zeroinitializer, i32 -1)
  %res3 = fadd <32 x bfloat> %res1, %res2
  ret <32 x bfloat> %res3
}

declare <32 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.512(<32 x bfloat>, i32, <32 x bfloat>, i32)

define <32 x bfloat>@test_int_x86_avx512_mask_getmant_bf16_512(<32 x bfloat> %x0, <32 x bfloat> %x2, i32 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_getmant_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vgetmantbf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x26,0xc8,0x08]
; X64-NEXT:    vgetmantbf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x26,0xc0,0x04]
; X64-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_getmant_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vgetmantbf16 $8, %zmm0, %zmm1 {%k1} # encoding: [0x62,0xf3,0x7f,0x49,0x26,0xc8,0x08]
; X86-NEXT:    vgetmantbf16 $4, %zmm0, %zmm0 # encoding: [0x62,0xf3,0x7f,0x48,0x26,0xc0,0x04]
; X86-NEXT:    vaddbf16 %zmm0, %zmm1, %zmm0 # encoding: [0x62,0xf5,0x75,0x48,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %res = call <32 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.512(<32 x bfloat> %x0, i32 8, <32 x bfloat> %x2, i32 %x3)
  %res1 = call <32 x bfloat> @llvm.x86.avx10.mask.getmant.bf16.512(<32 x bfloat> %x0, i32 4, <32 x bfloat> %x2, i32 -1)
  %res2 = fadd <32 x bfloat> %res, %res1
  ret <32 x bfloat> %res2
}

declare <32 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.512(<32 x bfloat>, <32 x bfloat>, <32 x bfloat>, i32)

define <32 x bfloat>@test_int_x86_avx512_mask_scalef_bf16_512(<32 x bfloat> %x0, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %x3) {
; X64-LABEL: test_int_x86_avx512_mask_scalef_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vscalefbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf6,0x7c,0x48,0x2c,0xc1]
; X64-NEXT:    vmovdqu16 %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x49,0x6f,0xd0]
; X64-NEXT:    vaddbf16 %zmm0, %zmm2, %zmm0 # encoding: [0x62,0xf5,0x6d,0x48,0x58,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx512_mask_scalef_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vscalefbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf6,0x7c,0x48,0x2c,0xc1]
; X86-NEXT:    vmovdqu16 %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf1,0xff,0x49,0x6f,0xd0]
; X86-NEXT:    vaddbf16 %zmm0, %zmm2, %zmm0 # encoding: [0x62,0xf5,0x6d,0x48,0x58,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %x3 to <32 x i1>
  %res1 = call <32 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.512(<32 x bfloat> %x0, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %x3)
  %res2 = call <32 x bfloat> @llvm.x86.avx10.mask.scalef.bf16.512(<32 x bfloat> %x0, <32 x bfloat> %x1, <32 x bfloat> zeroinitializer, i32 -1)
  %res3 = fadd <32 x bfloat> %res1, %res2
  ret <32 x bfloat> %res3
}
