# frozen_string_literal: true

class CreateIndexVulnerabilityProjectIdAndOnIdSync < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'index_vulnerabilities_on_project_id_and_id'
  COLUMN_NAMES = [:project_id, :id]

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerabilities, COLUMN_NAMES, name: INDEX_NAME # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
  end

  def down
    remove_concurrent_index_by_name :vulnerabilities, INDEX_NAME
  end
end
