=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class LdapConfigureAuthRequest
    # Use anonymous binds when performing LDAP group searches (if true the initial credentials will still be used for the initial connection test).
    attr_accessor :anonymous_group_search

    # LDAP DN for searching for the user DN (optional)
    attr_accessor :binddn

    # LDAP password for searching for the user DN (optional)
    attr_accessor :bindpass

    # If true, case sensitivity will be used when comparing usernames and groups for matching policies.
    attr_accessor :case_sensitive_names

    # CA certificate to use when verifying LDAP server certificate, must be x509 PEM encoded (optional)
    attr_accessor :certificate

    # Client certificate to provide to the LDAP server, must be x509 PEM encoded (optional)
    attr_accessor :client_tls_cert

    # Client certificate key to provide to the LDAP server, must be x509 PEM encoded (optional)
    attr_accessor :client_tls_key

    # Timeout, in seconds, when attempting to connect to the LDAP server before trying the next URL in the configuration.
    attr_accessor :connection_timeout

    # Denies an unauthenticated LDAP bind request if the user's password is empty; defaults to true
    attr_accessor :deny_null_bind

    # When aliases should be dereferenced on search operations. Accepted values are 'never', 'finding', 'searching', 'always'. Defaults to 'never'.
    attr_accessor :dereference_aliases

    # Use anonymous bind to discover the bind DN of a user (optional)
    attr_accessor :discoverdn

    # LDAP attribute to follow on objects returned by <groupfilter> in order to enumerate user group membership. Examples: \"cn\" or \"memberOf\", etc. Default: cn
    attr_accessor :groupattr

    # LDAP search base to use for group membership search (eg: ou=Groups,dc=example,dc=org)
    attr_accessor :groupdn

    # Go template for querying group membership of user (optional) The template can access the following context variables: UserDN, Username Example: (&(objectClass=group)(member:1.2.840.113556.1.4.1941:={{.UserDN}})) Default: (|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}}))
    attr_accessor :groupfilter

    # Skip LDAP server SSL Certificate verification - VERY insecure (optional)
    attr_accessor :insecure_tls

    # If set to a value greater than 0, the LDAP backend will use the LDAP server's paged search control to request pages of up to the given size. This can be used to avoid hitting the LDAP server's maximum result size limit. Otherwise, the LDAP backend will not use the paged search control.
    attr_accessor :max_page_size

    # Timeout, in seconds, for the connection when making requests against the server before returning back an error.
    attr_accessor :request_timeout

    # Issue a StartTLS command after establishing unencrypted connection (optional)
    attr_accessor :starttls

    # Maximum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
    attr_accessor :tls_max_version

    # Minimum TLS version to use. Accepted values are 'tls10', 'tls11', 'tls12' or 'tls13'. Defaults to 'tls12'
    attr_accessor :tls_min_version

    # Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
    attr_accessor :token_bound_cidrs

    # If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
    attr_accessor :token_explicit_max_ttl

    # The maximum lifetime of the generated token
    attr_accessor :token_max_ttl

    # If true, the 'default' policy will not automatically be added to generated tokens
    attr_accessor :token_no_default_policy

    # The maximum number of times a token may be used, a value of zero means unlimited
    attr_accessor :token_num_uses

    # If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. \"24h\").
    attr_accessor :token_period

    # Comma-separated list of policies. This will apply to all tokens generated by this auth method, in addition to any configured for specific users/groups.
    attr_accessor :token_policies

    # If true, CIDRs for the token will be strictly bound to the source IP address of the login request
    attr_accessor :token_strictly_bind_ip

    # The initial ttl of the token to generate
    attr_accessor :token_ttl

    # The type of token to generate, service or batch
    attr_accessor :token_type

    # Enables userPrincipalDomain login with [username]@UPNDomain (optional)
    attr_accessor :upndomain

    # LDAP URL to connect to (default: ldap://127.0.0.1). Multiple URLs can be specified by concatenating them with commas; they will be tried in-order.
    attr_accessor :url

    # In Vault 1.1.1 (prior to OpenBao's fork), a fix for handling group CN values of different cases unfortunately introduced a regression that could cause previously defined groups to not be found due to a change in the resulting name. If set true, the pre-1.1.1 behavior for matching group CNs will be used. This is only needed in some upgrade scenarios for backwards compatibility. It is enabled by default if the config is upgraded but disabled by default on new configurations.
    attr_accessor :use_pre111_group_cn_behavior

    # If true, use the Active Directory tokenGroups constructed attribute of the user to find the group memberships. This will find all security groups including nested ones.
    attr_accessor :use_token_groups

    # Attribute used for users (default: cn)
    attr_accessor :userattr

    # LDAP domain to use for users (eg: ou=People,dc=example,dc=org)
    attr_accessor :userdn

    # Go template for LDAP user search filer (optional) The template can access the following context variables: UserAttr, Username Default: ({{.UserAttr}}={{.Username}})
    attr_accessor :userfilter

    # If true, sets the alias name to the username
    attr_accessor :username_as_alias

    class EnumAttributeValidator
      attr_reader :datatype
      attr_reader :allowable_values

      def initialize(datatype, allowable_values)
        @allowable_values = allowable_values.map do |value|
          case datatype.to_s
          when /Integer/i
            value.to_i
          when /Float/i
            value.to_f
          else
            value
          end
        end
      end

      def valid?(value)
        !value || allowable_values.include?(value)
      end
    end

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'anonymous_group_search' => :'anonymous_group_search',
        :'binddn' => :'binddn',
        :'bindpass' => :'bindpass',
        :'case_sensitive_names' => :'case_sensitive_names',
        :'certificate' => :'certificate',
        :'client_tls_cert' => :'client_tls_cert',
        :'client_tls_key' => :'client_tls_key',
        :'connection_timeout' => :'connection_timeout',
        :'deny_null_bind' => :'deny_null_bind',
        :'dereference_aliases' => :'dereference_aliases',
        :'discoverdn' => :'discoverdn',
        :'groupattr' => :'groupattr',
        :'groupdn' => :'groupdn',
        :'groupfilter' => :'groupfilter',
        :'insecure_tls' => :'insecure_tls',
        :'max_page_size' => :'max_page_size',
        :'request_timeout' => :'request_timeout',
        :'starttls' => :'starttls',
        :'tls_max_version' => :'tls_max_version',
        :'tls_min_version' => :'tls_min_version',
        :'token_bound_cidrs' => :'token_bound_cidrs',
        :'token_explicit_max_ttl' => :'token_explicit_max_ttl',
        :'token_max_ttl' => :'token_max_ttl',
        :'token_no_default_policy' => :'token_no_default_policy',
        :'token_num_uses' => :'token_num_uses',
        :'token_period' => :'token_period',
        :'token_policies' => :'token_policies',
        :'token_strictly_bind_ip' => :'token_strictly_bind_ip',
        :'token_ttl' => :'token_ttl',
        :'token_type' => :'token_type',
        :'upndomain' => :'upndomain',
        :'url' => :'url',
        :'use_pre111_group_cn_behavior' => :'use_pre111_group_cn_behavior',
        :'use_token_groups' => :'use_token_groups',
        :'userattr' => :'userattr',
        :'userdn' => :'userdn',
        :'userfilter' => :'userfilter',
        :'username_as_alias' => :'username_as_alias'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'anonymous_group_search' => :'Boolean',
        :'binddn' => :'String',
        :'bindpass' => :'String',
        :'case_sensitive_names' => :'Boolean',
        :'certificate' => :'String',
        :'client_tls_cert' => :'String',
        :'client_tls_key' => :'String',
        :'connection_timeout' => :'Integer',
        :'deny_null_bind' => :'Boolean',
        :'dereference_aliases' => :'String',
        :'discoverdn' => :'Boolean',
        :'groupattr' => :'String',
        :'groupdn' => :'String',
        :'groupfilter' => :'String',
        :'insecure_tls' => :'Boolean',
        :'max_page_size' => :'Integer',
        :'request_timeout' => :'Integer',
        :'starttls' => :'Boolean',
        :'tls_max_version' => :'String',
        :'tls_min_version' => :'String',
        :'token_bound_cidrs' => :'Array<String>',
        :'token_explicit_max_ttl' => :'Integer',
        :'token_max_ttl' => :'Integer',
        :'token_no_default_policy' => :'Boolean',
        :'token_num_uses' => :'Integer',
        :'token_period' => :'Integer',
        :'token_policies' => :'Array<String>',
        :'token_strictly_bind_ip' => :'Boolean',
        :'token_ttl' => :'Integer',
        :'token_type' => :'String',
        :'upndomain' => :'String',
        :'url' => :'String',
        :'use_pre111_group_cn_behavior' => :'Boolean',
        :'use_token_groups' => :'Boolean',
        :'userattr' => :'String',
        :'userdn' => :'String',
        :'userfilter' => :'String',
        :'username_as_alias' => :'Boolean'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::LdapConfigureAuthRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::LdapConfigureAuthRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'anonymous_group_search')
        self.anonymous_group_search = attributes[:'anonymous_group_search']
      else
        self.anonymous_group_search = false
      end

      if attributes.key?(:'binddn')
        self.binddn = attributes[:'binddn']
      end

      if attributes.key?(:'bindpass')
        self.bindpass = attributes[:'bindpass']
      end

      if attributes.key?(:'case_sensitive_names')
        self.case_sensitive_names = attributes[:'case_sensitive_names']
      end

      if attributes.key?(:'certificate')
        self.certificate = attributes[:'certificate']
      end

      if attributes.key?(:'client_tls_cert')
        self.client_tls_cert = attributes[:'client_tls_cert']
      end

      if attributes.key?(:'client_tls_key')
        self.client_tls_key = attributes[:'client_tls_key']
      end

      if attributes.key?(:'connection_timeout')
        self.connection_timeout = attributes[:'connection_timeout']
      end

      if attributes.key?(:'deny_null_bind')
        self.deny_null_bind = attributes[:'deny_null_bind']
      else
        self.deny_null_bind = true
      end

      if attributes.key?(:'dereference_aliases')
        self.dereference_aliases = attributes[:'dereference_aliases']
      else
        self.dereference_aliases = 'never'
      end

      if attributes.key?(:'discoverdn')
        self.discoverdn = attributes[:'discoverdn']
      end

      if attributes.key?(:'groupattr')
        self.groupattr = attributes[:'groupattr']
      else
        self.groupattr = 'cn'
      end

      if attributes.key?(:'groupdn')
        self.groupdn = attributes[:'groupdn']
      end

      if attributes.key?(:'groupfilter')
        self.groupfilter = attributes[:'groupfilter']
      else
        self.groupfilter = '(|(memberUid={{.Username}})(member={{.UserDN}})(uniqueMember={{.UserDN}}))'
      end

      if attributes.key?(:'insecure_tls')
        self.insecure_tls = attributes[:'insecure_tls']
      end

      if attributes.key?(:'max_page_size')
        self.max_page_size = attributes[:'max_page_size']
      else
        self.max_page_size = 0
      end

      if attributes.key?(:'request_timeout')
        self.request_timeout = attributes[:'request_timeout']
      end

      if attributes.key?(:'starttls')
        self.starttls = attributes[:'starttls']
      end

      if attributes.key?(:'tls_max_version')
        self.tls_max_version = attributes[:'tls_max_version']
      else
        self.tls_max_version = 'tls12'
      end

      if attributes.key?(:'tls_min_version')
        self.tls_min_version = attributes[:'tls_min_version']
      else
        self.tls_min_version = 'tls12'
      end

      if attributes.key?(:'token_bound_cidrs')
        if (value = attributes[:'token_bound_cidrs']).is_a?(Array)
          self.token_bound_cidrs = value
        end
      end

      if attributes.key?(:'token_explicit_max_ttl')
        self.token_explicit_max_ttl = attributes[:'token_explicit_max_ttl']
      end

      if attributes.key?(:'token_max_ttl')
        self.token_max_ttl = attributes[:'token_max_ttl']
      end

      if attributes.key?(:'token_no_default_policy')
        self.token_no_default_policy = attributes[:'token_no_default_policy']
      end

      if attributes.key?(:'token_num_uses')
        self.token_num_uses = attributes[:'token_num_uses']
      end

      if attributes.key?(:'token_period')
        self.token_period = attributes[:'token_period']
      end

      if attributes.key?(:'token_policies')
        if (value = attributes[:'token_policies']).is_a?(Array)
          self.token_policies = value
        end
      end

      if attributes.key?(:'token_strictly_bind_ip')
        self.token_strictly_bind_ip = attributes[:'token_strictly_bind_ip']
      end

      if attributes.key?(:'token_ttl')
        self.token_ttl = attributes[:'token_ttl']
      end

      if attributes.key?(:'token_type')
        self.token_type = attributes[:'token_type']
      else
        self.token_type = 'default-service'
      end

      if attributes.key?(:'upndomain')
        self.upndomain = attributes[:'upndomain']
      end

      if attributes.key?(:'url')
        self.url = attributes[:'url']
      else
        self.url = 'ldap://127.0.0.1'
      end

      if attributes.key?(:'use_pre111_group_cn_behavior')
        self.use_pre111_group_cn_behavior = attributes[:'use_pre111_group_cn_behavior']
      end

      if attributes.key?(:'use_token_groups')
        self.use_token_groups = attributes[:'use_token_groups']
      else
        self.use_token_groups = false
      end

      if attributes.key?(:'userattr')
        self.userattr = attributes[:'userattr']
      else
        self.userattr = 'cn'
      end

      if attributes.key?(:'userdn')
        self.userdn = attributes[:'userdn']
      end

      if attributes.key?(:'userfilter')
        self.userfilter = attributes[:'userfilter']
      else
        self.userfilter = '({{.UserAttr}}={{.Username}})'
      end

      if attributes.key?(:'username_as_alias')
        self.username_as_alias = attributes[:'username_as_alias']
      else
        self.username_as_alias = false
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      dereference_aliases_validator = EnumAttributeValidator.new('String', ["never", "finding", "searching", "always"])
      return false unless dereference_aliases_validator.valid?(@dereference_aliases)
      tls_max_version_validator = EnumAttributeValidator.new('String', ["tls10", "tls11", "tls12", "tls13"])
      return false unless tls_max_version_validator.valid?(@tls_max_version)
      tls_min_version_validator = EnumAttributeValidator.new('String', ["tls10", "tls11", "tls12", "tls13"])
      return false unless tls_min_version_validator.valid?(@tls_min_version)
      true
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] dereference_aliases Object to be assigned
    def dereference_aliases=(dereference_aliases)
      validator = EnumAttributeValidator.new('String', ["never", "finding", "searching", "always"])
      unless validator.valid?(dereference_aliases)
        fail ArgumentError, "invalid value for \"dereference_aliases\", must be one of #{validator.allowable_values}."
      end
      @dereference_aliases = dereference_aliases
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] tls_max_version Object to be assigned
    def tls_max_version=(tls_max_version)
      validator = EnumAttributeValidator.new('String', ["tls10", "tls11", "tls12", "tls13"])
      unless validator.valid?(tls_max_version)
        fail ArgumentError, "invalid value for \"tls_max_version\", must be one of #{validator.allowable_values}."
      end
      @tls_max_version = tls_max_version
    end

    # Custom attribute writer method checking allowed values (enum).
    # @param [Object] tls_min_version Object to be assigned
    def tls_min_version=(tls_min_version)
      validator = EnumAttributeValidator.new('String', ["tls10", "tls11", "tls12", "tls13"])
      unless validator.valid?(tls_min_version)
        fail ArgumentError, "invalid value for \"tls_min_version\", must be one of #{validator.allowable_values}."
      end
      @tls_min_version = tls_min_version
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          anonymous_group_search == o.anonymous_group_search &&
          binddn == o.binddn &&
          bindpass == o.bindpass &&
          case_sensitive_names == o.case_sensitive_names &&
          certificate == o.certificate &&
          client_tls_cert == o.client_tls_cert &&
          client_tls_key == o.client_tls_key &&
          connection_timeout == o.connection_timeout &&
          deny_null_bind == o.deny_null_bind &&
          dereference_aliases == o.dereference_aliases &&
          discoverdn == o.discoverdn &&
          groupattr == o.groupattr &&
          groupdn == o.groupdn &&
          groupfilter == o.groupfilter &&
          insecure_tls == o.insecure_tls &&
          max_page_size == o.max_page_size &&
          request_timeout == o.request_timeout &&
          starttls == o.starttls &&
          tls_max_version == o.tls_max_version &&
          tls_min_version == o.tls_min_version &&
          token_bound_cidrs == o.token_bound_cidrs &&
          token_explicit_max_ttl == o.token_explicit_max_ttl &&
          token_max_ttl == o.token_max_ttl &&
          token_no_default_policy == o.token_no_default_policy &&
          token_num_uses == o.token_num_uses &&
          token_period == o.token_period &&
          token_policies == o.token_policies &&
          token_strictly_bind_ip == o.token_strictly_bind_ip &&
          token_ttl == o.token_ttl &&
          token_type == o.token_type &&
          upndomain == o.upndomain &&
          url == o.url &&
          use_pre111_group_cn_behavior == o.use_pre111_group_cn_behavior &&
          use_token_groups == o.use_token_groups &&
          userattr == o.userattr &&
          userdn == o.userdn &&
          userfilter == o.userfilter &&
          username_as_alias == o.username_as_alias
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [anonymous_group_search, binddn, bindpass, case_sensitive_names, certificate, client_tls_cert, client_tls_key, connection_timeout, deny_null_bind, dereference_aliases, discoverdn, groupattr, groupdn, groupfilter, insecure_tls, max_page_size, request_timeout, starttls, tls_max_version, tls_min_version, token_bound_cidrs, token_explicit_max_ttl, token_max_ttl, token_no_default_policy, token_num_uses, token_period, token_policies, token_strictly_bind_ip, token_ttl, token_type, upndomain, url, use_pre111_group_cn_behavior, use_token_groups, userattr, userdn, userfilter, username_as_alias].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
