/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var randu = require( '@stdlib/random/base/randu' );
var Float64Array = require( '@stdlib/array/float64' );
var ArrayBuffer = require( '@stdlib/array/buffer' );
var incrmmeanstdev = require( './../lib' );

var offset;
var acc;
var buf;
var out;
var ms;
var N;
var v;
var i;
var j;

// Define the number of accumulators:
N = 5;

// Create an array buffer for storing accumulator output:
buf = new ArrayBuffer( N*2*8 ); // 8 bytes per element

// Initialize accumulators:
acc = [];
for ( i = 0; i < N; i++ ) {
	// Compute the byte offset:
	offset = i * 2 * 8; // stride=2, bytes_per_element=8

	// Create a new view for storing accumulated values:
	out = new Float64Array( buf, offset, 2 );

	// Initialize an accumulator which will write results to the view:
	acc.push( incrmmeanstdev( out, 5 ) );
}

// Simulate data and update the moving sample means and standard deviations...
for ( i = 0; i < 100; i++ ) {
	for ( j = 0; j < N; j++ ) {
		v = randu() * 100.0 * (j+1);
		acc[ j ]( v );
	}
}

// Print the final results:
console.log( 'Mean\tStDev' );
for ( i = 0; i < N; i++ ) {
	ms = acc[ i ]();
	console.log( '%d\t%d', ms[ 0 ].toFixed( 3 ), ms[ 1 ].toFixed( 3 ) );
}
