# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

_Public Classes_

* [`apache`](#apache): Guides the basic setup and installation of Apache on your system.
* [`apache::dev`](#apachedev): Installs Apache development libraries.
* [`apache::mod::actions`](#apachemodactions): Installs Apache mod_actions
* [`apache::mod::alias`](#apachemodalias): Installs and configures `mod_alias`.
* [`apache::mod::auth_basic`](#apachemodauth_basic): Installs `mod_auth_basic`
* [`apache::mod::auth_cas`](#apachemodauth_cas): Installs and configures `mod_auth_cas`.
* [`apache::mod::auth_gssapi`](#apachemodauth_gssapi): Installs `mod_auth_gsappi`.
* [`apache::mod::auth_kerb`](#apachemodauth_kerb): Installs `mod_auth_kerb`
* [`apache::mod::auth_mellon`](#apachemodauth_mellon): Installs and configures `mod_auth_mellon`.
* [`apache::mod::authn_core`](#apachemodauthn_core): Installs `mod_authn_core`.
* [`apache::mod::authn_dbd`](#apachemodauthn_dbd): Installs `mod_authn_dbd`.
* [`apache::mod::authn_file`](#apachemodauthn_file): Installs `mod_authn_file`.
* [`apache::mod::authnz_ldap`](#apachemodauthnz_ldap): Installs `mod_authnz_ldap`.
* [`apache::mod::authnz_pam`](#apachemodauthnz_pam): Installs `mod_authnz_pam`.
* [`apache::mod::authz_default`](#apachemodauthz_default): Installs and configures `mod_authz_default`.
* [`apache::mod::authz_user`](#apachemodauthz_user): Installs `mod_authz_user`
* [`apache::mod::autoindex`](#apachemodautoindex): Installs `mod_autoindex`
* [`apache::mod::cache`](#apachemodcache): Installs `mod_cache`
* [`apache::mod::cgi`](#apachemodcgi): Installs `mod_cgi`.
* [`apache::mod::cgid`](#apachemodcgid): Installs `mod_cgid`.
* [`apache::mod::cluster`](#apachemodcluster): Installs `mod_cluster`.
* [`apache::mod::data`](#apachemoddata): Installs and configures `mod_data`.
* [`apache::mod::dav`](#apachemoddav): Installs `mod_dav`.
* [`apache::mod::dav_fs`](#apachemoddav_fs): Installs `mod_dav_fs`.
* [`apache::mod::dav_svn`](#apachemoddav_svn): Installs and configures `mod_dav_svn`.
* [`apache::mod::dbd`](#apachemoddbd): Installs `mod_dbd`.
* [`apache::mod::deflate`](#apachemoddeflate): Installs and configures `mod_deflate`.
* [`apache::mod::dev`](#apachemoddev): Installs `mod_dev`.
* [`apache::mod::dir`](#apachemoddir): Installs and configures `mod_dir`.
* [`apache::mod::disk_cache`](#apachemoddisk_cache): Installs and configures `mod_disk_cache`.
* [`apache::mod::dumpio`](#apachemoddumpio): Installs and configures `mod_dumpio`.
* [`apache::mod::env`](#apachemodenv): Installs `mod_env`.
* [`apache::mod::event`](#apachemodevent): Installs and configures `mod_event`.
* [`apache::mod::expires`](#apachemodexpires): Installs and configures `mod_expires`.
* [`apache::mod::ext_filter`](#apachemodext_filter): Installs and configures `mod_ext_filter`.
* [`apache::mod::fastcgi`](#apachemodfastcgi): Installs `mod_fastcgi`.
* [`apache::mod::fcgid`](#apachemodfcgid): Installs and configures `mod_fcgid`.
* [`apache::mod::filter`](#apachemodfilter): Installs `mod_filter`.
* [`apache::mod::geoip`](#apachemodgeoip): Installs and configures `mod_geoip`.
* [`apache::mod::headers`](#apachemodheaders): Installs and configures `mod_headers`.
* [`apache::mod::http2`](#apachemodhttp2): Installs and configures `mod_http2`.
* [`apache::mod::include`](#apachemodinclude): Installs `mod_include`.
* [`apache::mod::info`](#apachemodinfo): Installs and configures `mod_info`.
* [`apache::mod::intercept_form_submit`](#apachemodintercept_form_submit): Installs `mod_intercept_form_submit`.
* [`apache::mod::itk`](#apachemoditk): Installs MPM `mod_itk`.
* [`apache::mod::jk`](#apachemodjk): Installs `mod_jk`.
* [`apache::mod::ldap`](#apachemodldap): Installs and configures `mod_ldap`.
* [`apache::mod::lookup_identity`](#apachemodlookup_identity): Installs `mod_lookup_identity`
* [`apache::mod::macro`](#apachemodmacro): Installs `mod_macro`.
* [`apache::mod::mime`](#apachemodmime): Installs and configures `mod_mime`.
* [`apache::mod::mime_magic`](#apachemodmime_magic): Installs and configures `mod_mime_magic`.
* [`apache::mod::negotiation`](#apachemodnegotiation): Installs and configures `mod_negotiation`.
* [`apache::mod::nss`](#apachemodnss): Installs and configures `mod_nss`.
* [`apache::mod::pagespeed`](#apachemodpagespeed): Installs and configures `mod_pagespeed`.
* [`apache::mod::passenger`](#apachemodpassenger): Installs `mod_pasenger`.
* [`apache::mod::perl`](#apachemodperl): Installs `mod_perl`.
* [`apache::mod::peruser`](#apachemodperuser): Installs `mod_peruser`.
* [`apache::mod::php`](#apachemodphp): Installs `mod_php`.
* [`apache::mod::prefork`](#apachemodprefork): Installs and configures MPM `prefork`.
* [`apache::mod::proxy`](#apachemodproxy): Installs and configures `mod_proxy`.
* [`apache::mod::proxy_ajp`](#apachemodproxy_ajp): Installs `mod_proxy_ajp`.
* [`apache::mod::proxy_balancer`](#apachemodproxy_balancer): Installs and configures `mod_proxy_balancer`.
* [`apache::mod::proxy_connect`](#apachemodproxy_connect): Installs `mod_proxy_connect`.
* [`apache::mod::proxy_fcgi`](#apachemodproxy_fcgi): Installs `mod_proxy_fcgi`.
* [`apache::mod::proxy_html`](#apachemodproxy_html): Installs `mod_proxy_html`.
* [`apache::mod::proxy_http`](#apachemodproxy_http): Installs `mod_proxy_http`.
* [`apache::mod::proxy_wstunnel`](#apachemodproxy_wstunnel): Installs `mod_proxy_wstunnel`.
* [`apache::mod::python`](#apachemodpython): Installs and configures `mod_python`.
* [`apache::mod::remoteip`](#apachemodremoteip): Installs and configures `mod_remoteip`.
* [`apache::mod::reqtimeout`](#apachemodreqtimeout): Installs and configures `mod_reqtimeout`.
* [`apache::mod::rewrite`](#apachemodrewrite): Installs `mod_rewrite`.
* [`apache::mod::rpaf`](#apachemodrpaf): Installs and configures `mod_rpaf`.
* [`apache::mod::security`](#apachemodsecurity): Installs and configures `mod_security`.
* [`apache::mod::setenvif`](#apachemodsetenvif): Installs `mod_setenvif`.
* [`apache::mod::shib`](#apachemodshib): Installs and configures `mod_shib`.
* [`apache::mod::socache_shmcb`](#apachemodsocache_shmcb): Installs `mod_socache_shmcb`.
* [`apache::mod::speling`](#apachemodspeling): Installs `mod_spelling`.
* [`apache::mod::ssl`](#apachemodssl): Installs `mod_ssl`.
* [`apache::mod::status`](#apachemodstatus): Installs and configures `mod_status`.
* [`apache::mod::suexec`](#apachemodsuexec): Installs `mod_suexec`.
* [`apache::mod::suphp`](#apachemodsuphp): Installs `mod_suphp`.
* [`apache::mod::userdir`](#apachemoduserdir): Installs and configures `mod_userdir`.
* [`apache::mod::version`](#apachemodversion): Installs `mod_version`.
* [`apache::mod::vhost_alias`](#apachemodvhost_alias): Installs Apache `mod_vhost_alias`.
* [`apache::mod::worker`](#apachemodworker): Installs and manages the MPM `worker`.
* [`apache::mod::wsgi`](#apachemodwsgi): Installs and configures `mod_wsgi`.
* [`apache::mod::xsendfile`](#apachemodxsendfile): Installs `mod_xsendfile`.
* [`apache::mpm::disable_mpm_event`](#apachempmdisable_mpm_event): 
* [`apache::mpm::disable_mpm_prefork`](#apachempmdisable_mpm_prefork): 
* [`apache::mpm::disable_mpm_worker`](#apachempmdisable_mpm_worker): 
* [`apache::vhosts`](#apachevhosts): Creates `apache::vhost` defined types.

_Private Classes_

* `apache::confd::no_accf`: Manages the `no-accf.conf` file.
* `apache::default_confd_files`: Helper for setting up default conf.d files.
* `apache::default_mods`: Installs and congfigures default mods for Apache
* `apache::package`: Installs an Apache MPM.
* `apache::params`: This class manages Apache parameters
* `apache::php`: This class installs PHP for Apache.
* `apache::proxy`: This class enabled the proxy module for Apache.
* `apache::python`: This class installs Python for Apache
* `apache::service`: Installs and configures Apache service.
* `apache::ssl`: This class installs Apache SSL capabilities
* `apache::version`: Try to automatically detect the version by OS

**Defined types**

_Public Defined types_

* [`apache::balancer`](#apachebalancer): This type will create an apache balancer cluster file inside the conf.d
directory.
* [`apache::balancermember`](#apachebalancermember): Defines members of `mod_proxy_balancer`
* [`apache::custom_config`](#apachecustom_config): Adds a custom configuration file to the Apache server's `conf.d` directory.
* [`apache::fastcgi::server`](#apachefastcgiserver): Defines one or more external FastCGI servers to handle specific file types. Use this
defined type with `mod_fastcgi`.
* [`apache::listen`](#apachelisten): Adds `Listen` directives to `ports.conf` that define the
Apache server's or a virtual host's listening address and port.
* [`apache::mod`](#apachemod): Installs packages for an Apache module that doesn't have a corresponding
`apache::mod::<MODULE NAME>` class.
* [`apache::namevirtualhost`](#apachenamevirtualhost): Enables name-based virtual hosts
* [`apache::vhost`](#apachevhost): Allows specialised configurations for virtual hosts that possess requirements
outside of the defaults.
* [`apache::vhost::custom`](#apachevhostcustom): A wrapper around the `apache::custom_config` defined type.
* [`apache::vhost::fragment`](#apachevhostfragment): Define a fragment within a vhost

_Private Defined types_

* `apache::default_mods::load`: Helper used by `apache::default_mods`
* `apache::mpm`: Enables the use of Apache MPMs.
* `apache::peruser::multiplexer`: Checks if an Apache module has a class.
* `apache::peruser::processor`: Enables the `Peruser` module for FreeBSD only.
* `apache::security::rule_link`: Links the activated_rules from `apache::mod::security` to the respective CRS rules on disk.

**Resource types**

* [`a2mod`](#a2mod): Manage Apache 2 modules

**Functions**

* [`apache::apache_pw_hash`](#apacheapache_pw_hash): Hashes a password in a format suitable for htpasswd files read by apache.
* [`apache::bool2httpd`](#apachebool2httpd): Transform a supposed boolean to On or Off. Passes all other values through.
* [`apache::validate_apache_log_level`](#apachevalidate_apache_log_level): Perform simple validation of a string against the list of known log levels.
* [`apache_pw_hash`](#apache_pw_hash): Hashes a password in a format suitable for htpasswd files read by apache.
* [`bool2httpd`](#bool2httpd): Transform a supposed boolean to On or Off. Pass all other values through.
* [`validate_apache_log_level`](#validate_apache_log_level): Perform simple validation of a string against the list of known log levels.

**Tasks**

* [`init`](#init): Allows you to perform apache service functions

## Classes

### apache

When this class is declared with the default options, Puppet:
- Installs the appropriate Apache software package and [required Apache modules](#default_mods) for your operating system.
- Places the required configuration files in a directory, with the [default location](#conf_dir) determined by your operating system.
- Configures the server with a default virtual host and standard port (`80`) and address (`\*`) bindings.
- Creates a document root directory determined by your operating system, typically `/var/www`.
- Starts the Apache service.

If an ldaps:// URL is specified, the mode becomes SSL and the setting of LDAPTrustedMode is ignored.

#### Examples

##### 

```puppet
class { 'apache': }
```

#### Parameters

The following parameters are available in the `apache` class.

##### `allow_encoded_slashes`

Data type: `Optional[Enum['on', 'off', 'nodecode']]`

Sets the server default for the `AllowEncodedSlashes` declaration, which modifies the
responses to URLs containing '\' and '/' characters. If not specified, this parameter omits
the declaration from the server's configuration and uses Apache's default setting of 'off'.

Default value: `undef`

##### `apache_version`

Data type: `Any`

Configures module template behavior, package names, and default Apache modules by defining
the version of Apache to use. We do not recommend manually configuring this parameter
without reason.

Default value: $::apache::version::default

##### `conf_dir`

Data type: `Any`

Sets the directory where the Apache server's main configuration file is located.

Default value: $::apache::params::conf_dir

##### `conf_template`

Data type: `Any`

Defines the template used for the main Apache configuration file. Modifying this
parameter is potentially risky, as the apache module is designed to use a minimal
configuration file customized by `conf.d` entries.

Default value: $::apache::params::conf_template

##### `confd_dir`

Data type: `Any`

Sets the location of the Apache server's custom configuration directory.

Default value: $::apache::params::confd_dir

##### `default_charset`

Data type: `Any`

Used as the `AddDefaultCharset` directive in the main configuration file.

Default value: `undef`

##### `default_confd_files`

Data type: `Boolean`

Determines whether Puppet generates a default set of includable Apache configuration files
in the directory defined by the `confd_dir` parameter. These configuration files
correspond to what is typically installed with the Apache package on the server's
operating system.

Default value: `true`

##### `default_mods`

Data type: `Any`

Determines whether to configure and enable a set of default Apache modules depending on
your operating system.<br />
If `false`, Puppet includes only the Apache modules required to make the HTTP daemon work
on your operating system, and you can declare any other modules separately using the
`apache::mod::<MODULE NAME>` class or `apache::mod` defined type.<br />
If `true`, Puppet installs additional modules, depending on the operating system and
the values of `apache_version` and `mpm_module` parameters. Because these lists of
modules can change frequently, consult the Puppet module's code for up-to-date lists.<br />
If this parameter contains an array, Puppet instead enables all passed Apache modules.

Default value: `true`

##### `default_ssl_ca`

Data type: `Any`

Sets the default certificate authority for the Apache server.<br />
Although the default value results in a functioning Apache server, you **must** update
this parameter with your certificate authority information before deploying this server in
a production environment.

Default value: `undef`

##### `default_ssl_cert`

Data type: `Any`

Sets the SSL encryption certificate location.<br />
Although the default value results in a functioning Apache server, you **must** update this
parameter with your certificate location before deploying this server in a production environment.

Default value: $::apache::params::default_ssl_cert

##### `default_ssl_chain`

Data type: `Any`

Sets the default SSL chain location.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with your SSL chain before deploying this server in a production environment.

Default value: `undef`

##### `default_ssl_crl`

Data type: `Any`

Sets the path of the default certificate revocation list (CRL) file to use.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with the CRL file path before deploying this server in a production
environment. You can use this parameter with or in place of the `default_ssl_crl_path`.

Default value: `undef`

##### `default_ssl_crl_path`

Data type: `Any`

Sets the server's certificate revocation list path, which contains your CRLs.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with the CRL file path before deploying this server in a production environment.

Default value: `undef`

##### `default_ssl_crl_check`

Data type: `Any`

Sets the default certificate revocation check level via the `SSLCARevocationCheck` directive.
This parameter applies only to Apache 2.4 or higher and is ignored on older versions.<br />
Although this default value results in a functioning Apache server, you **must** specify
this parameter when using certificate revocation lists in a production environment.

Default value: `undef`

##### `default_ssl_key`

Data type: `Any`

Sets the SSL certificate key file location.
Although the default values result in a functioning Apache server, you **must** update
this parameter with your SSL key's location before deploying this server in a production
environment.

Default value: $::apache::params::default_ssl_key

##### `default_ssl_vhost`

Data type: `Boolean`

Configures a default SSL virtual host.
If `true`, Puppet automatically configures the following virtual host using the
`apache::vhost` defined type:
```puppet
apache::vhost { 'default-ssl':
  port            => 443,
  ssl             => true,
  docroot         => $docroot,
  scriptalias     => $scriptalias,
  serveradmin     => $serveradmin,
  access_log_file => "ssl_${access_log_file}",
}
```
**Note**: SSL virtual hosts only respond to HTTPS queries.

Default value: `false`

##### `default_type`

Data type: `Any`

_Apache 2.2 only_. Sets the MIME `content-type` sent if the server cannot otherwise
determine an appropriate `content-type`. This directive is deprecated in Apache 2.4 and
newer, and is only for backwards compatibility in configuration files.

Default value: 'none'

##### `default_vhost`

Data type: `Boolean`

Configures a default virtual host when the class is declared.<br />
To configure customized virtual hosts, set this parameter's
value to `false`.<br />
> **Note**: Apache will not start without at least one virtual host. If you set this
to `false` you must configure a virtual host elsewhere.

Default value: `true`

##### `dev_packages`

Data type: `Any`

Configures a specific dev package to use.<br />
For example, using httpd 2.4 from the IUS yum repo:<br />
``` puppet
include ::apache::dev
class { 'apache':
  apache_name  => 'httpd24u',
  dev_packages => 'httpd24u-devel',
}
```

Default value: $::apache::params::dev_packages

##### `docroot`

Data type: `Any`

Sets the default `DocumentRoot` location.

Default value: $::apache::params::docroot

##### `error_documents`

Data type: `Any`

Determines whether to enable [custom error documents](https://httpd.apache.org/docs/current/custom-error.html) on the Apache server.

Default value: `false`

##### `group`

Data type: `Any`

Sets the group ID that owns any Apache processes spawned to answer requests.<br />
By default, Puppet attempts to manage this group as a resource under the `apache`
class, determining the group based on the operating system as detected by the
`apache::params` class. To prevent the group resource from being created and use a group
created by another Puppet module, set the `manage_group` parameter's value to `false`.<br />
> **Note**: Modifying this parameter only changes the group ID that Apache uses to spawn
child processes to access resources. It does not change the user that owns the parent server
process.

Default value: $::apache::params::group

##### `httpd_dir`

Data type: `Any`

Sets the Apache server's base configuration directory. This is useful for specially
repackaged Apache server builds but might have unintended consequences when combined
with the default distribution packages.

Default value: $::apache::params::httpd_dir

##### `http_protocol_options`

Data type: `Any`

Specifies the strictness of HTTP protocol checks.<br />
Valid options: any sequence of the following alternative values: `Strict` or `Unsafe`,
`RegisteredMethods` or `LenientMethods`, and `Allow0.9` or `Require1.0`.

Default value: $::apache::params::http_protocol_options

##### `keepalive`

Data type: `Any`

Determines whether to enable persistent HTTP connections with the `KeepAlive` directive.
If you set this to `On`, use the `keepalive_timeout` and `max_keepalive_requests` parameters
to set relevant options.<br />

Default value: $::apache::params::keepalive

##### `keepalive_timeout`

Data type: `Any`

Sets the `KeepAliveTimeout` directive, which determines the amount of time the Apache
server waits for subsequent requests on a persistent HTTP connection. This parameter is
only relevant if the `keepalive` parameter is enabled.

Default value: $::apache::params::keepalive_timeout

##### `max_keepalive_requests`

Data type: `Any`

Limits the number of requests allowed per connection when the `keepalive` parameter is enabled.

Default value: $::apache::params::max_keepalive_requests

##### `hostname_lookups`

Data type: `Enum['Off', 'On', 'Double', 'off', 'on', 'double']`

This directive enables DNS lookups so that host names can be logged and passed to
CGIs/SSIs in REMOTE_HOST.<br />
> **Note**: If enabled, it impacts performance significantly.

Default value: $::apache::params::hostname_lookups

##### `ldap_trusted_mode`

Data type: `Any`

The following modes are supported:

  NONE - no encryption
  SSL - ldaps:// encryption on default port 636
  TLS - STARTTLS encryption on default port 389
Not all LDAP toolkits support all the above modes. An error message will be logged at
runtime if a mode is not supported, and the connection to the LDAP server will fail.

Default value: `undef`

##### `ldap_verify_server_cert`

Data type: `Any`

Specifies whether to force the verification of a server certificate when establishing an SSL
connection to the LDAP server.
On|Off

Default value: `undef`

##### `lib_path`

Data type: `Any`

Specifies the location whereApache module files are stored.<br />
> **Note**: Do not configure this parameter manually without special reason.

Default value: $::apache::params::lib_path

##### `log_level`

Data type: `Any`

Changes the error log's verbosity. Valid options are: `alert`, `crit`, `debug`, `emerg`, `error`,
`info`, `notice` and `warn`.

Default value: $::apache::params::log_level

##### `log_formats`

Data type: `Any`

Define additional `LogFormat` directives. Values: A hash, such as:
``` puppet
$log_formats = { vhost_common => '%v %h %l %u %t \"%r\" %>s %b' }
```
  There are a number of predefined `LogFormats` in the `httpd.conf` that Puppet creates:
``` httpd
  LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
  LogFormat "%h %l %u %t \"%r\" %>s %b" common
  LogFormat "%{Referer}i -> %U" referer
  LogFormat "%{User-agent}i" agent
  LogFormat "%{X-Forwarded-For}i %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"" forwarded
```
If your `log_formats` parameter contains one of those, it will be overwritten with **your** definition.

Default value: {}

##### `logroot`

Data type: `Any`

Changes the directory of Apache log files for the virtual host.

Default value: $::apache::params::logroot

##### `logroot_mode`

Data type: `Any`

Overrides the default `logroot` directory's mode.<br />
> **Note**: Do _not_ grant write access to the directory where the logs are stored
without being aware of the consequences. See the [Apache documentation](https://httpd.apache.org/docs/current/logs.html#security)
for details.

Default value: $::apache::params::logroot_mode

##### `manage_group`

Data type: `Boolean`

When `false`, stops Puppet from creating the group resource.<br />
If you have a group created from another Puppet module that you want to use to run Apache,
set this to `false`. Without this parameter, attempting to use a previously established
group results in a duplicate resource error.

Default value: `true`

##### `supplementary_groups`

Data type: `Any`

A list of groups to which the user belongs. These groups are in addition to the primary group.<br />
Notice: This option only has an effect when `manage_user` is set to true.

Default value: []

##### `manage_user`

Data type: `Boolean`

When `false`, stops Puppet from creating the user resource.<br />
This is for instances when you have a user, created from another Puppet module, you want
to use to run Apache. Without this parameter, attempting to use a previously established
user would result in a duplicate resource error.

Default value: `true`

##### `mod_dir`

Data type: `Any`

Sets where Puppet places configuration files for your Apache modules.

Default value: $::apache::params::mod_dir

##### `mod_libs`

Data type: `Any`

Allows the user to override default module library names.
```puppet
include apache::params
class { 'apache':
  mod_libs => merge($::apache::params::mod_libs, {
    'wsgi' => 'mod_wsgi_python3.so',
  })
}
```

Default value: $::apache::params::mod_libs

##### `mod_packages`

Data type: `Any`

Allows the user to override default module package names.
```puppet
include apache::params
class { 'apache':
  mod_packages => merge($::apache::params::mod_packages, {
    'auth_kerb' => 'httpd24-mod_auth_kerb',
  })
}
```

Default value: $::apache::params::mod_packages

##### `mpm_module`

Data type: `Any`

Determines which [multi-processing module](https://httpd.apache.org/docs/current/mpm.html) (MPM) is loaded and configured for the
HTTPD process. Valid values are: `event`, `itk`, `peruser`, `prefork`, `worker` or `false`.<br />
You must set this to `false` to explicitly declare the following classes with custom parameters:
- `apache::mod::event`
- `apache::mod::itk`
- `apache::mod::peruser`
- `apache::mod::prefork`
- `apache::mod::worker`

Default value: $::apache::params::mpm_module

##### `package_ensure`

Data type: `Any`

Controls the `package` resource's `ensure` attribute. Valid values are: `absent`, `installed`
(or equivalent `present`), or a version string.

Default value: 'installed'

##### `pidfile`

Data type: `Any`

Allows settting a custom location for the pid file. Useful if using a custom-built Apache rpm.

Default value: $::apache::params::pidfile

##### `ports_file`

Data type: `Any`

Sets the path to the file containing Apache ports configuration.

Default value: $::apache::params::ports_file

##### `protocols`

Data type: `Array[Enum['h2', 'h2c', 'http/1.1']]`

Sets the [Protocols](https://httpd.apache.org/docs/current/en/mod/core.html#protocols)
directive, which lists available protocols for the server.

Default value: []

##### `protocols_honor_order`

Data type: `Optional[Boolean]`

Sets the [ProtocolsHonorOrder](https://httpd.apache.org/docs/current/en/mod/core.html#protocolshonororder)
directive which determines whether the order of Protocols sets precedence during negotiation.

Default value: `undef`

##### `purge_configs`

Data type: `Any`

Removes all other Apache configs and virtual hosts.<br />
Setting this to `false` is a stopgap measure to allow the apache module to coexist with
existing or unmanaged configurations. We recommend moving your configuration to resources
within this module. For virtual host configurations, see `purge_vhost_dir`.

Default value: `true`

##### `purge_vhost_dir`

Data type: `Any`

If the `vhost_dir` parameter's value differs from the `confd_dir` parameter's, this parameter
determines whether Puppet removes any configurations inside `vhost_dir` that are _not_ managed
by Puppet.<br />
Setting `purge_vhost_dir` to `false` is a stopgap measure to allow the apache module to
coexist with existing or otherwise unmanaged configurations within `vhost_dir`.

Default value: `undef`

##### `rewrite_lock`

Data type: `Optional[Stdlib::Absolutepath]`

Allows setting a custom location for a rewrite lock - considered best practice if using
a RewriteMap of type prg in the `rewrites` parameter of your virtual host. This parameter
only applies to Apache version 2.2 or lower and is ignored on newer versions.

Default value: `undef`

##### `sendfile`

Data type: `Enum['On', 'Off', 'on', 'off']`

Forces Apache to use the Linux kernel's `sendfile` support to serve static files, via the
`EnableSendfile` directive.

Default value: 'On'

##### `serveradmin`

Data type: `Any`

Sets the Apache server administrator's contact information via Apache's `ServerAdmin` directive.

Default value: 'root@localhost'

##### `servername`

Data type: `Any`

Sets the Apache server name via Apache's `ServerName` directive.
Setting to `false` will not set ServerName at all.

Default value: $::apache::params::servername

##### `server_root`

Data type: `Any`

Sets the Apache server's root directory via Apache's `ServerRoot` directive.

Default value: $::apache::params::server_root

##### `server_signature`

Data type: `Any`

Configures a trailing footer line to display at the bottom of server-generated documents,
such as error documents and output of certain Apache modules, via Apache's `ServerSignature`
directive. Valid values are: `On` or `Off`.

Default value: 'On'

##### `server_tokens`

Data type: `Any`

Controls how much information Apache sends to the browser about itself and the operating
system, via Apache's `ServerTokens` directive.

Default value: 'Prod'

##### `service_enable`

Data type: `Boolean`

Determines whether Puppet enables the Apache HTTPD service when the system is booted.

Default value: `true`

##### `service_ensure`

Data type: `Any`

Determines whether Puppet should make sure the service is running.
Valid values are: `true` (or `running`) or `false` (or `stopped`).<br />
The `false` or `stopped` values set the 'httpd' service resource's `ensure` parameter
to `false`, which is useful when you want to let the service be managed by another
application, such as Pacemaker.<br />

Default value: 'running'

##### `service_name`

Data type: `Any`

Sets the name of the Apache service.

Default value: $::apache::params::service_name

##### `service_manage`

Data type: `Boolean`

Determines whether Puppet manages the HTTPD service's state.

Default value: `true`

##### `service_restart`

Data type: `Any`

Determines whether Puppet should use a specific command to restart the HTTPD service.
Values: a command to restart the Apache service.

Default value: `undef`

##### `timeout`

Data type: `Any`

Sets Apache's `TimeOut` directive, which defines the number of seconds Apache waits for
certain events before failing a request.

Default value: '60'

##### `trace_enable`

Data type: `Any`

Controls how Apache handles `TRACE` requests (per RFC 2616) via the `TraceEnable` directive.

Default value: 'On'

##### `use_canonical_name`

Data type: `Optional[Enum['On', 'on', 'Off', 'off', 'DNS', 'dns']]`

Controls Apache's `UseCanonicalName` directive which controls how Apache handles
self-referential URLs. If not specified, this parameter omits the declaration from the
server's configuration and uses Apache's default setting of 'off'.

Default value: `undef`

##### `use_systemd`

Data type: `Any`

Controls whether the systemd module should be installed on Centos 7 servers, this is
especially useful if using custom-built RPMs.

Default value: $::apache::params::use_systemd

##### `file_mode`

Data type: `Any`

Sets the desired permissions mode for config files.
Valid values are: a string, with permissions mode in symbolic or numeric notation.

Default value: $::apache::params::file_mode

##### `root_directory_options`

Data type: `Any`

Array of the desired options for the `/` directory in httpd.conf.

Default value: $::apache::params::root_directory_options

##### `root_directory_secured`

Data type: `Boolean`

Sets the default access policy for the `/` directory in httpd.conf. A value of `false`
allows access to all resources that are missing a more specific access policy. A value of
`true` denies access to all resources by default. If `true`, more specific rules must be
used to allow access to these resources (for example, in a directory block using the
`directories` parameter).

Default value: `false`

##### `vhost_dir`

Data type: `Any`

Changes your virtual host configuration files' location.

Default value: $::apache::params::vhost_dir

##### `vhost_include_pattern`

Data type: `Any`

Defines the pattern for files included from the `vhost_dir`.
If set to a value like `[^.#]\*.conf[^~]` to make sure that files accidentally created in
this directory (such as files created by version control systems or editor backups) are
*not* included in your server configuration.<br />
Some operating systems use a value of `*.conf`. By default, this module creates configuration
files ending in `.conf`.

Default value: $::apache::params::vhost_include_pattern

##### `user`

Data type: `Any`

Changes the user that Apache uses to answer requests. Apache's parent process continues
to run as root, but child processes access resources as the user defined by this parameter.
To prevent Puppet from managing the user, set the `manage_user` parameter to `false`.

Default value: $::apache::params::user

##### `apache_name`

Data type: `Any`

The name of the Apache package to install. If you are using a non-standard Apache package
you might need to override the default setting.<br />
For CentOS/RHEL Software Collections (SCL), you can also use `apache::version::scl_httpd_version`.

Default value: $::apache::params::apache_name

##### `error_log`

Data type: `Any`

The name of the error log file for the main server instance. If the string starts with
`/`, `|`, or `syslog`: the full path is set. Otherwise, the filename  is prefixed with
`$logroot`.

Default value: $::apache::params::error_log

##### `scriptalias`

Data type: `Any`

Directory to use for global script alias

Default value: $::apache::params::scriptalias

##### `access_log_file`

Data type: `Any`

The name of the access log file for the main server instance.

Default value: $::apache::params::access_log_file

##### `limitreqfields`

Data type: `Any`

The `limitreqfields` parameter sets the maximum number of request header fields in
an HTTP request. This directive gives the server administrator greater control over
abnormal client request behavior, which may be useful for avoiding some forms of
denial-of-service attacks. The value should be increased if normal clients see an error
response from the server that indicates too many fields were sent in the request.

Default value: '100'

##### `limitreqfieldsize`

Data type: `Any`

The `limitreqfieldsize` parameter sets the maximum ammount of _bytes_ that will
be allowed within a request header.

Default value: '8190'

##### `ip`

Data type: `Any`

Specifies the ip address

Default value: `undef`

##### `purge_vdir`

Data type: `Any`

Removes all other Apache configs and virtual hosts.<br />
> **Note**: This parameter is deprecated in favor of the `purge_config` parameter.<br />

Default value: `false`

##### `conf_enabled`

Data type: `Any`

Whether the additional config files in `/etc/apache2/conf-enabled` should be managed.

Default value: $::apache::params::conf_enabled

##### `vhost_enable_dir`

Data type: `Any`

Set's whether the vhost definitions will be stored in sites-availible and if
they will be symlinked to and from sites-enabled.

Default value: $::apache::params::vhost_enable_dir

##### `mod_enable_dir`

Data type: `Any`

Set's whether the mods-enabled directory should be managed.

Default value: $::apache::params::mod_enable_dir

##### `ssl_file`

Data type: `Any`

This parameter allows you to set an ssl.conf file to be managed in order to implement
an SSL Certificate.

Default value: `undef`

##### `file_e_tag`

Data type: `Any`

Sets the server default for the `FileETag` declaration, which modifies the response header
field for static files.

Default value: `undef`

##### `use_optional_includes`

Data type: `Boolean`

Specifies whether Apache uses the `IncludeOptional` directive instead of `Include` for
`additional_includes` in Apache 2.4 or newer.

Default value: $::apache::params::use_optional_includes

##### `mime_types_additional`

Data type: `Any`

Specifies any idditional Internet media (mime) types that you wish to be configured.

Default value: $::apache::params::mime_types_additional

### apache::dev

The libraries installed depends on the `dev_packages` parameter of the `apache::params`
class, based on your operating system:
- **Debian** : `libaprutil1-dev`, `libapr1-dev`; `apache2-dev` on Ubuntu 13.10 and Debian 8; `apache2-prefork-dev` on other versions.
- **FreeBSD**: `undef`; on FreeBSD, you must declare the `apache::package` or `apache` classes before declaring `apache::dev`.
- **Gentoo**: `undef`.
- **Red Hat**: `httpd-devel`.

### apache::mod::actions

Installs Apache mod_actions

* **See also**
https://httpd.apache.org/docs/current/mod/mod_actions.html
for additional documentation.

### apache::mod::alias

Installs and configures `mod_alias`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_alias.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::alias` class.

##### `apache_version`

Data type: `Any`

The version of Apache, if not set will be retrieved from the init class.

Default value: `undef`

##### `icons_options`

Data type: `Any`

Disables directory listings for the icons directory, via Apache [Options](https://httpd.apache.org/docs/current/mod/core.html#options)
directive.

Default value: 'Indexes MultiViews'

##### `icons_path`

Data type: `Any`

Sets the local path for an /icons/ Alias. Default depends on operating system:
- Debian: /usr/share/apache2/icons
- FreeBSD: /usr/local/www/apache24/icons
- Gentoo: /var/www/icons
- Red Hat: /var/www/icons, except on Apache 2.4, where it's /usr/share/httpd/icons

Default value: $::apache::params::alias_icons_path

### apache::mod::auth_basic

Installs `mod_auth_basic`

* **See also**
https://httpd.apache.org/docs/current/mod/mod_auth_basic.html
for additional documentation.

### apache::mod::auth_cas

Installs and configures `mod_auth_cas`.

* **Note** The auth_cas module isn't available on RH/CentOS without providing dependency packages provided by EPEL.

* **See also**
https://github.com/apereo/mod_auth_cas
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::auth_cas` class.

##### `cas_login_url`

Data type: `String`

Sets the URL to which the module redirects users when they attempt to access a
CAS-protected resource and don't have an active session.

##### `cas_validate_url`

Data type: `String`

Sets the URL to use when validating a client-presented ticket in an HTTP query string.

##### `cas_cookie_path`

Data type: `String`

Sets the location where information on the current session should be stored. This should
be writable by the web server only.

Default value: $::apache::params::cas_cookie_path

##### `cas_cookie_path_mode`

Data type: `Any`

The mode of cas_cookie_path.

Default value: '0750'

##### `cas_version`

Data type: `Any`

The version of the CAS protocol to adhere to.

Default value: 2

##### `cas_debug`

Data type: `Any`

Whether to enable or disable debug mode.

Default value: 'Off'

##### `cas_validate_server`

Data type: `Any`

Whether to validate the presented certificate. This has been deprecated and
removed from Version 1.1-RC1 onward.

Default value: `undef`

##### `cas_validatedepth`

The maximum depth for chained certificate validation.

##### `cas_proxy_validate_url`

Data type: `Any`

The URL to use when performing a proxy validation.

Default value: `undef`

##### `cas_root_proxied_as`

Data type: `Any`

Sets the URL end users see when access to this Apache server is proxied per vhost.
This URL should not include a trailing slash.

Default value: `undef`

##### `cas_cookie_entropy`

Data type: `Any`

When creating a local session, this many random bytes are used to create a unique
session identifier.

Default value: `undef`

##### `cas_timeout`

Data type: `Any`

The hard limit, in seconds, for a mod_auth_cas session.

Default value: `undef`

##### `cas_idle_timeout`

Data type: `Any`

The limit, in seconds, of how long a mod_auth_cas session can be idle.

Default value: `undef`

##### `cas_cache_clean_interval`

Data type: `Any`

The minimum amount of time that must pass inbetween cache cleanings.

Default value: `undef`

##### `cas_cookie_domain`

Data type: `Any`

The value for the 'Domain=' parameter in the Set-Cookie header.

Default value: `undef`

##### `cas_cookie_http_only`

Data type: `Any`

Setting this flag prevents the mod_auth_cas cookies from being accessed by
client side Javascript.

Default value: `undef`

##### `cas_authoritative`

Data type: `Any`

Determines whether an optional authorization directive is authoritative and thus binding.

Default value: `undef`

##### `cas_validate_saml`

Data type: `Any`

Parse response from CAS server for SAML.

Default value: `undef`

##### `cas_sso_enabled`

Data type: `Any`

Enables experimental support for single sign out (may mangle POST data).

Default value: `undef`

##### `cas_attribute_prefix`

Data type: `Any`

Adds a header with the value of this header being the attribute values when SAML
validation is enabled.

Default value: `undef`

##### `cas_attribute_delimiter`

Data type: `Any`

Sets the delimiter between attribute values in the header created by `cas_attribute_prefix`.

Default value: `undef`

##### `cas_scrub_request_headers`

Data type: `Any`

Remove inbound request headers that may have special meaning within mod_auth_cas.

Default value: `undef`

##### `suppress_warning`

Data type: `Any`

Suppress warning about being on RedHat (mod_auth_cas package is now available in epel-testing repo).

Default value: `false`

##### `cas_validate_depth`

Data type: `Any`



Default value: `undef`

##### `cas_certificate_path`

Data type: `Any`



Default value: `undef`

### apache::mod::auth_gssapi

Installs `mod_auth_gsappi`.

* **See also**
https://github.com/modauthgssapi/mod_auth_gssapi
for additional documentation.

### apache::mod::auth_kerb

Installs `mod_auth_kerb`

* **See also**
http://modauthkerb.sourceforge.net
for additional documentation.

### apache::mod::auth_mellon

Installs and configures `mod_auth_mellon`.

* **See also**
https://github.com/Uninett/mod_auth_mellon
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::auth_mellon` class.

##### `mellon_cache_size`

Data type: `Any`

Maximum number of sessions which can be active at once.

Default value: $::apache::params::mellon_cache_size

##### `mellon_lock_file`

Data type: `Any`

Full path to a file used for synchronizing access to the session data.

Default value: $::apache::params::mellon_lock_file

##### `mellon_post_directory`

Data type: `Any`

Full path of a directory where POST requests are saved during authentication.

Default value: $::apache::params::mellon_post_directory

##### `mellon_cache_entry_size`

Data type: `Any`

Maximum size for a single session entry in bytes.

Default value: `undef`

##### `mellon_post_ttl`

Data type: `Any`

Delay in seconds before a saved POST request can be flushed.

Default value: `undef`

##### `mellon_post_size`

Data type: `Any`

Maximum size for saved POST requests.

Default value: `undef`

##### `mellon_post_count`

Data type: `Any`

Maximum amount of saved POST requests.

Default value: `undef`

### apache::mod::authn_core

Installs `mod_authn_core`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_authn_core.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authn_core` class.

##### `apache_version`

Data type: `Any`

The version of apache being run.

Default value: $::apache::apache_version

### apache::mod::authn_dbd

Installs `mod_authn_dbd`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_authn_dbd.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authn_dbd` class.

##### `authn_dbd_params`

Data type: `Any`

The params needed for the mod to function.

##### `authn_dbd_dbdriver`

Data type: `Any`

Selects an apr_dbd driver by name.

Default value: 'mysql'

##### `authn_dbd_query`

Data type: `Any`



Default value: `undef`

##### `authn_dbd_min`

Data type: `Any`

Set the minimum number of connections per process.

Default value: '4'

##### `authn_dbd_max`

Data type: `Any`

Set the maximum number of connections per process.

Default value: '20'

##### `authn_dbd_keep`

Data type: `Any`

Set the maximum number of connections per process to be sustained.

Default value: '8'

##### `authn_dbd_exptime`

Data type: `Any`

Set the time to keep idle connections alive when the number of
connections specified in DBDKeep has been exceeded.

Default value: '300'

##### `authn_dbd_alias`

Data type: `Any`

Sets an alias for `AuthnProvider.

Default value: `undef`

### apache::mod::authn_file

Installs `mod_authn_file`.

* **See also**
https://httpd.apache.org/docs/2.4/mod/mod_authn_file.html
for additional documentation.

### apache::mod::authnz_ldap

Installs `mod_authnz_ldap`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_authnz_ldap.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authnz_ldap` class.

##### `verify_server_cert`

Data type: `Boolean`

Whether to force te verification of a server cert or not.

Default value: `true`

##### `package_name`

Data type: `Any`

The name of the ldap package.

Default value: `undef`

### apache::mod::authnz_pam

Installs `mod_authnz_pam`.

* **See also**
https://www.adelton.com/apache/mod_authnz_pam
for additional documentation.

### apache::mod::authz_default

Installs and configures `mod_authz_default`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_authz_default.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authz_default` class.

##### `apache_version`

Data type: `Any`

Version of Apache to install module on.

Default value: $::apache::apache_version

### apache::mod::authz_user

Installs `mod_authz_user`

* **See also**
https://httpd.apache.org/docs/current/mod/mod_authz_user.html
for additional documentation.

### apache::mod::autoindex

Installs `mod_autoindex`

* **See also**
https://httpd.apache.org/docs/current/mod/mod_autoindex.html
for additional documentation.

### apache::mod::cache

Installs `mod_cache`

* **See also**
https://httpd.apache.org/docs/current/mod/mod_cache.html
for additional documentation.

### apache::mod::cgi

Installs `mod_cgi`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_cgi.html
for additional documentation.

### apache::mod::cgid

Installs `mod_cgid`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_cgid.html

### apache::mod::cluster

Installs `mod_cluster`.

* **Note** There is no official package available for mod_cluster, so you must make it available outside of the apache module.
Binaries can be found [here](https://modcluster.io/).

* **See also**
https://modcluster.io/
for additional documentation.

#### Examples

##### 

```puppet
class { '::apache::mod::cluster':
  ip                      => '172.17.0.1',
  allowed_network         => '172.17.0.',
  balancer_name           => 'mycluster',
  version                 => '1.3.1'
}
```

#### Parameters

The following parameters are available in the `apache::mod::cluster` class.

##### `allowed_network`

Data type: `Any`

Balanced members network.

##### `balancer_name`

Data type: `Any`

Name of balancer.

##### `ip`

Data type: `Any`

Specifies the IP address to listen to.

##### `version`

Data type: `Any`

Specifies the mod_cluster version. Version 1.3.0 or greater is required for httpd 2.4.

##### `enable_mcpm_receive`

Data type: `Any`

Whether MCPM should be enabled.

Default value: `true`

##### `port`

Data type: `Any`

mod_cluster listen port.

Default value: '6666'

##### `keep_alive_timeout`

Data type: `Any`

Specifies how long Apache should wait for a request, in seconds.

Default value: 60

##### `manager_allowed_network`

Data type: `Any`

Whether to allow the network to access the mod_cluster_manager.

Default value: '127.0.0.1'

##### `max_keep_alive_requests`

Data type: `Any`

Maximum number of requests kept alive.

Default value: 0

##### `server_advertise`

Data type: `Any`

Whether the server should advertise.

Default value: `true`

##### `advertise_frequency`

Data type: `Any`

Sets the interval between advertise messages in seconds.

Default value: `undef`

### apache::mod::data

Installs and configures `mod_data`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_data.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::data` class.

##### `apache_version`

Data type: `Any`

Version of Apache to install module on.

Default value: `undef`

### apache::mod::dav

Installs `mod_dav`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dav.html
for additional documentation.

### apache::mod::dav_fs

Installs `mod_dav_fs`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dav_fs.html
for additional documentation.

### apache::mod::dav_svn

Installs and configures `mod_dav_svn`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dav_svn.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::dav_svn` class.

##### `authz_svn_enabled`

Data type: `Any`

Specifies whether to install Apache mod_authz_svn

Default value: `false`

### apache::mod::dbd

Installs `mod_dbd`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dbd.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::dbd` class.

##### `apache_version`

Used to verify that the Apache version you have requested is compatible with the module.

### apache::mod::deflate

Installs and configures `mod_deflate`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_deflate.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::deflate` class.

##### `types`

Data type: `Any`

An array of MIME types to be deflated. See https://www.iana.org/assignments/media-types/media-types.xhtml.

Default value: [
    'text/html text/plain text/xml',
    'text/css',
    'application/x-javascript application/javascript application/ecmascript',
    'application/rss+xml',
    'application/json',
  ]

##### `notes`

Data type: `Any`

A Hash where the key represents the type and the value represents the note name.

Default value: {
    'Input'  => 'instream',
    'Output' => 'outstream',
    'Ratio'  => 'ratio',
  }

### apache::mod::dev

Installs `mod_dev`.

* **Note** This module is deprecated. Please use `apache::dev`.

### apache::mod::dir

Installs and configures `mod_dir`.

* **TODO** This sets the global DirectoryIndex directive, so it may be necessary to consider being able to modify the apache::vhost to declare
DirectoryIndex statements in a vhost configuration

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dir.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::dir` class.

##### `types`

Specifies the text-based content types to compress.

##### `indexes`

Data type: `Array[String]`

Provides a string for the DirectoryIndex directive

Default value: ['index.html','index.html.var','index.cgi','index.pl','index.php','index.xhtml']

##### `dir`

Data type: `Any`



Default value: 'public_html'

### apache::mod::disk_cache

Installs and configures `mod_disk_cache`.

* **Note** Apache 2.2, mod_disk_cache installed. On Apache 2.4, mod_cache_disk installed.

* **See also**
https://httpd.apache.org/docs/2.2/mod/mod_disk_cache.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::disk_cache` class.

##### `cache_root`

Data type: `Any`

Defines the name of the directory on the disk to contain cache files.
Default depends on the Apache version and operating system:
- Debian: /var/cache/apache2/mod_cache_disk
- FreeBSD: /var/cache/mod_cache_disk
- Red Hat, Apache 2.4: /var/cache/httpd/proxy
- Red Hat, Apache 2.2: /var/cache/mod_proxy

Default value: `undef`

##### `cache_ignore_headers`

Data type: `Any`

Specifies HTTP header(s) that should not be stored in the cache.

Default value: `undef`

### apache::mod::dumpio

Installs and configures `mod_dumpio`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_dumpio.html
for additional documentation.

#### Examples

##### 

```puppet
class{'apache':
  default_mods => false,
  log_level    => 'dumpio:trace7',
}
class{'apache::mod::dumpio':
  dump_io_input  => 'On',
  dump_io_output => 'Off',
}
```

#### Parameters

The following parameters are available in the `apache::mod::dumpio` class.

##### `dump_io_input`

Data type: `Enum['Off', 'On', 'off', 'on']`

Dump all input data to the error log

Default value: 'Off'

##### `dump_io_output`

Data type: `Enum['Off', 'On', 'off', 'on']`

Dump all output data to the error log

Default value: 'Off'

### apache::mod::env

Installs `mod_env`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_env.html
for additional documentation.

### apache::mod::event

Installs and configures `mod_event`.

* **Note** You cannot include apache::mod::event with apache::mod::itk, apache::mod::peruser, apache::mod::prefork, or
apache::mod::worker on the same server.

* **See also**
https://httpd.apache.org/docs/current/mod/event.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::event` class.

##### `startservers`

Data type: `Any`

Sets the number of child server processes created at startup, via the module's `StartServers` directive. Setting this to `false`
removes the parameter.

Default value: '2'

##### `maxclients`

Data type: `Any`

Apache 2.3.12 or older alias for the `MaxRequestWorkers` directive.

Default value: '150'

##### `maxrequestworkers`

Data type: `Any`

Sets the maximum number of connections Apache can simultaneously process, via the module's `MaxRequestWorkers` directive. Setting
these to `false` removes the parameters.

Default value: `undef`

##### `minsparethreads`

Data type: `Any`

Sets the minimum number of idle threads, via the `MinSpareThreads` directive. Setting this to `false` removes the parameters.

Default value: '25'

##### `maxsparethreads`

Data type: `Any`

Sets the maximum number of idle threads, via the `MaxSpareThreads` directive. Setting this to `false` removes the parameters.

Default value: '75'

##### `threadsperchild`

Data type: `Any`

Number of threads created by each child process.

Default value: '25'

##### `maxrequestsperchild`

Data type: `Any`

Apache 2.3.8 or older alias for the `MaxConnectionsPerChild` directive.

Default value: '0'

##### `maxconnectionsperchild`

Data type: `Any`

Limit on the number of connections that an individual child server will handle during its life.

Default value: `undef`

##### `serverlimit`

Data type: `Any`

Limits the configurable number of processes via the `ServerLimit` directive. Setting this to `false` removes the parameter.

Default value: '25'

##### `apache_version`

Data type: `Any`

Version of Apache to install module on.

Default value: `undef`

##### `threadlimit`

Data type: `Any`

Limits the number of event threads via the module's `ThreadLimit` directive. Setting this to `false` removes the parameter.

Default value: '64'

##### `listenbacklog`

Data type: `Any`

Sets the maximum length of the pending connections queue via the module's `ListenBackLog` directive. Setting this to `false` removes
the parameter.

Default value: '511'

### apache::mod::expires

Installs and configures `mod_expires`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_expires.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::expires` class.

##### `expires_active`

Data type: `Any`

Enables generation of Expires headers.

Default value: `true`

##### `expires_default`

Data type: `Any`

Specifies the default algorithm for calculating expiration time using ExpiresByType syntax or interval syntax.

Default value: `undef`

##### `expires_by_type`

Data type: `Any`

Describes a set of [MIME content-types](https://www.iana.org/assignments/media-types/media-types.xhtml) and their expiration
times. This should be used as an array of Hashes, with each Hash's key a valid MIME content-type (i.e. 'text/json') and its
value following valid interval syntax.

Default value: `undef`

### apache::mod::ext_filter

Installs and configures `mod_ext_filter`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_ext_filter.html
for additional documentation.

#### Examples

##### 

```puppet
class { 'apache::mod::ext_filter':
  ext_filter_define => {
    'slowdown'       => 'mode=output cmd=/bin/cat preservescontentlength',
    'puppetdb-strip' => 'mode=output outtype=application/json cmd="pdb-resource-filter"',
  },
}
```

#### Parameters

The following parameters are available in the `apache::mod::ext_filter` class.

##### `ext_filter_define`

Data type: `Optional[Hash]`

Hash of filter names and their parameters.

Default value: `undef`

### apache::mod::fastcgi

Installs `mod_fastcgi`.

* **See also**
https://github.com/FastCGI-Archives/mod_fastcgi
for additional documentation.

### apache::mod::fcgid

loaded first; Puppet will not automatically enable it if you set the fcgiwrapper parameter in apache::vhost.
  include apache::mod::fcgid

  apache::vhost { 'example.org':
    docroot     => '/var/www/html',
    directories => {
      path        => '/var/www/html',
      fcgiwrapper => {
        command => '/usr/local/bin/fcgiwrapper',
      }
    },
  }

* **See also**
https://httpd.apache.org/docs/current/mod/mod_fcgid.html
for additional documentation.

#### Examples

##### The class does not individually parameterize all available options. Instead, configure mod_fcgid using the options hash.

```puppet
class { 'apache::mod::fcgid':
  options => {
    'FcgidIPCDir'  => '/var/run/fcgidsock',
    'SharememPath' => '/var/run/fcgid_shm',
    'AddHandler'   => 'fcgid-script .fcgi',
  },
}
```

##### If you include apache::mod::fcgid, you can set the [FcgidWrapper][] per directory, per virtual host. The module must be

```puppet

```

#### Parameters

The following parameters are available in the `apache::mod::fcgid` class.

##### `expires_active`

Enables generation of Expires headers.

##### `expires_default`

Default algorithm for calculating expiration time.

##### `expires_by_type`

Value of the Expires header configured by MIME type.

##### `options`

Data type: `Any`



Default value: {}

### apache::mod::filter

Installs `mod_filter`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_filter.html
for additional documentation.

### apache::mod::geoip

Installs and configures `mod_geoip`.

* **See also**
https://dev.maxmind.com/geoip/legacy/mod_geoip2
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::geoip` class.

##### `enable`

Data type: `Any`

Toggles whether to enable geoip.

Default value: `false`

##### `db_file`

Data type: `Any`

Path to database for GeoIP to use.

Default value: '/usr/share/GeoIP/GeoIP.dat'

##### `flag`

Data type: `Any`

Caching directive to use. Values: 'CheckCache', 'IndexCache', 'MemoryCache', 'Standard'.

Default value: 'Standard'

##### `output`

Data type: `Any`

Output variable locations. Values: 'All', 'Env', 'Request', 'Notes'.

Default value: 'All'

##### `enable_utf8`

Data type: `Any`

Changes the output from ISO88591 (Latin1) to UTF8.

Default value: `undef`

##### `scan_proxy_headers`

Data type: `Any`

Enables the GeoIPScanProxyHeaders option.

Default value: `undef`

##### `scan_proxy_headers_field`

Specifies the header mod_geoip uses to determine the client's IP address.

##### `use_last_xforwarededfor_ip`

Data type: `Any`

Determines whether to use the first or last IP address for the client's IP in a comma-separated list of IP addresses is found.

Default value: `undef`

##### `scan_proxy_header_field`

Data type: `Any`



Default value: `undef`

### apache::mod::headers

Installs and configures `mod_headers`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_headers.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::headers` class.

##### `apache_version`

Version of Apache to install module on.

### apache::mod::http2

Installs and configures `mod_http2`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_http2.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::http2` class.

##### `h2_copy_files`

Data type: `Optional[Boolean]`

Determine file handling in responses.

Default value: `undef`

##### `h2_direct`

Data type: `Optional[Boolean]`

H2 Direct Protocol Switch.

Default value: `undef`

##### `h2_early_hints`

Data type: `Optional[Boolean]`

Determine sending of 103 status codes.

Default value: `undef`

##### `h2_max_session_streams`

Data type: `Optional[Integer]`

Sets maximum number of active streams per HTTP/2 session.

Default value: `undef`

##### `h2_max_worker_idle_seconds`

Data type: `Optional[Integer]`

Sets maximum number of seconds h2 workers remain idle until shut down.

Default value: `undef`

##### `h2_max_workers`

Data type: `Optional[Integer]`

Sets maximum number of worker threads to use per child process.

Default value: `undef`

##### `h2_min_workers`

Data type: `Optional[Integer]`

Sets minimal number of worker threads to use per child process.

Default value: `undef`

##### `h2_modern_tls_only`

Data type: `Optional[Boolean]`

Toggles the security checks on HTTP/2 connections in TLS mode

Default value: `undef`

##### `h2_push`

Data type: `Optional[Boolean]`

Toggles the usage of the HTTP/2 server push protocol feature.

Default value: `undef`

##### `h2_push_diary_size`

Data type: `Optional[Integer]`

Sets maximum number of HTTP/2 server pushes that are remembered per HTTP/2 connection.

Default value: `undef`

##### `h2_priority`

Require HTTP/2 connections to be "modern TLS" only

##### `h2_push_resource`

Data type: `Array[String]`

When added to a directory/location, HTTP/2 PUSHes will be attempted for all paths added
via this directive

Default value: []

##### `h2_serialize_headers`

Data type: `Optional[Boolean]`

Toggles if HTTP/2 requests shall be serialized in HTTP/1.1 format for processing by httpd
core or if received binary data shall be passed into the request_recs directly.

Default value: `undef`

##### `h2_stream_max_mem_size`

Data type: `Optional[Integer]`

Sets the maximum number of outgoing data bytes buffered in memory for an active streams.

Default value: `undef`

##### `h2_tls_cool_down_secs`

Data type: `Optional[Integer]`

Sets the number of seconds of idle time on a TLS connection before the TLS write size falls
back to small (~1300 bytes) length.

Default value: `undef`

##### `h2_tls_warm_up_size`

Data type: `Optional[Integer]`

Sets the number of bytes to be sent in small TLS records (~1300 bytes) until doing maximum
sized writes (16k) on https: HTTP/2 connections.

Default value: `undef`

##### `h2_upgrade`

Data type: `Optional[Boolean]`

Toggles the usage of the HTTP/1.1 Upgrade method for switching to HTTP/2.

Default value: `undef`

##### `h2_window_size`

Data type: `Optional[Integer]`

Sets the size of the window that is used for flow control from client to server and limits
the amount of data the server has to buffer.

Default value: `undef`

##### `apache_version`

Data type: `Optional[String]`

Version of Apache to install module on.

Default value: `undef`

##### `h2_push_priority`

Data type: `Array[String]`



Default value: []

### apache::mod::include

Installs `mod_include`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_include.html
for additional documentation.

### apache::mod::info

Installs and configures `mod_info`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_info.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::info` class.

##### `allow_from`

Data type: `Any`

Whitelist of IPv4 or IPv6 addresses or ranges that can access the info path.

Default value: ['127.0.0.1','::1']

##### `apache_version`

Data type: `Any`

Version of Apache to install module on.

Default value: `undef`

##### `restrict_access`

Data type: `Any`

Toggles whether to restrict access to info path. If `false`, the `allow_from` whitelist is ignored and any IP address can
access the info path.

Default value: `true`

##### `info_path`

Data type: `Any`

Path on server to file containing server configuration information.

Default value: '/server-info'

### apache::mod::intercept_form_submit

Installs `mod_intercept_form_submit`.

* **See also**
https://www.adelton.com/apache/mod_intercept_form_submit
for additional documentation.

### apache::mod::itk

Installs MPM `mod_itk`.

* **See also**
http://mpm-itk.sesse.net
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::itk` class.

##### `startservers`

Data type: `Any`

Number of child server processes created on startup.

Default value: '8'

##### `minspareservers`

Data type: `Any`

Minimum number of idle child server processes.

Default value: '5'

##### `maxspareservers`

Data type: `Any`

Maximum number of idle child server processes.

Default value: '20'

##### `serverlimit`

Data type: `Any`

Maximum configured value for `MaxRequestWorkers` for the lifetime of the Apache httpd process.

Default value: '256'

##### `maxclients`

Data type: `Any`

Limit on the number of simultaneous requests that will be served.

Default value: '256'

##### `maxrequestsperchild`

Data type: `Any`

Limit on the number of connections that an individual child server process will handle.

Default value: '4000'

##### `enablecapabilities`

Data type: `Any`

Drop most root capabilities in the parent process, and instead run as the user given by the User/Group directives with some extra
capabilities (in particular setuid). Somewhat more secure, but can cause problems when serving from filesystems that do not honor
capabilities, such as NFS.

Default value: `undef`

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

### apache::mod::jk

Installs `mod_jk`.

* **Note** shm_file and log_file
Depending on how these files are specified, the class creates their final path differently:

Relative path: prepends supplied path with logroot (see below)
Absolute path or pipe: uses supplied path as-is

```
shm_file => 'shm_file'
# Ends up in
$shm_path = '/var/log/httpd/shm_file'

shm_file => '/run/shm_file'
# Ends up in
$shm_path = '/run/shm_file'

shm_file => '"|rotatelogs /var/log/httpd/mod_jk.log.%Y%m%d 86400 -180"'
# Ends up in
$shm_path = '"|rotatelogs /var/log/httpd/mod_jk.log.%Y%m%d 86400 -180"'
```

* **See also**
https://tomcat.apache.org/connectors-doc/reference/apache.html
for additional documentation.

#### Examples

##### 

```puppet
class { '::apache::mod::jk':
  ip                   => '192.168.2.15',
  workers_file         => 'conf/workers.properties',
  mount_file           => 'conf/uriworkermap.properties',
  shm_file             => 'run/jk.shm',
  shm_size             => '50M',
  workers_file_content => {
    <Content>
  },
}
```

#### Parameters

The following parameters are available in the `apache::mod::jk` class.

##### `ip`

Data type: `Optional[String]`

IP for binding to mod_jk. Useful when the binding address is not the primary network interface IP.

Default value: `undef`

##### `port`

Data type: `Integer`

Port for binding to mod_jk. Useful when something else, like a reverse proxy or cache, is receiving requests at port 80, then
needs to forward them to Apache at a different port.

Default value: 80

##### `add_listen`

Data type: `Boolean`

Defines if a Listen directive according to parameters ip and port (see below), so that Apache listens to the IP/port combination
and redirect to mod_jk. Useful when another Listen directive, like Listen *:<Port> or Listen <Port>, can conflict with the one
necessary for mod_jk binding.

Default value: `true`

##### `workers_file`

Data type: `Any`

The name of a worker file for the Tomcat servlet containers.

Default value: `undef`

##### `worker_property`

Data type: `Any`

Enables setting worker properties inside Apache configuration file.

Default value: {}

##### `logroot`

Data type: `Any`

The base directory for shm_file and log_file is determined by the logroot parameter. If unspecified, defaults to
apache::params::logroot. The default logroot is sane enough therefore it is not recommended to override it.

Default value: `undef`

##### `shm_file`

Data type: `Any`

Shared memory file name.

Default value: 'jk-runtime-status'

##### `shm_size`

Data type: `Any`

Size of the shared memory file name.

Default value: `undef`

##### `mount_file`

Data type: `Any`

File containing multiple mappings from a context to a Tomcat worker.

Default value: `undef`

##### `mount_file_reload`

Data type: `Any`

This directive configures the reload check interval in seconds.

Default value: `undef`

##### `mount`

Data type: `Any`

A mount point from a context to a Tomcat worker.

Default value: {}

##### `un_mount`

Data type: `Any`

An exclusion mount point from a context to a Tomcat worker.

Default value: {}

##### `auto_alias`

Data type: `Any`

Automatically Alias webapp context directories into the Apache document space

Default value: `undef`

##### `mount_copy`

Data type: `Any`

If this directive is set to "On" in some virtual server, the mounts from the global server will be copied
to this virtual server, more precisely all mounts defined by JkMount or JkUnMount.

Default value: `undef`

##### `worker_indicator`

Data type: `Any`

Name of the Apache environment variable that can be used to set worker names in combination with SetHandler
jakarta-servlet.

Default value: `undef`

##### `watchdog_interval`

Data type: `Any`

This directive configures the watchdog thread interval in seconds.

Default value: `undef`

##### `log_file`

Data type: `Any`

Full or server relative path to the mod_jk log file.

Default value: 'mod_jk.log'

##### `log_level`

Data type: `Any`

The mod_jk log level, can be debug, info, warn error or trace.

Default value: `undef`

##### `log_stamp_format`

Data type: `Any`

The mod_jk date log format, using an extended strftime syntax.

Default value: `undef`

##### `request_log_format`

Data type: `Any`

Request log format string.

Default value: `undef`

##### `extract_ssl`

Data type: `Any`

Turns on SSL processing and information gathering by mod_jk.

Default value: `undef`

##### `https_indicator`

Data type: `Any`

Name of the Apache environment variable that contains SSL indication.

Default value: `undef`

##### `sslprotocol_indicator`

Data type: `Any`

Name of the Apache environment variable that contains the SSL protocol name.

Default value: `undef`

##### `certs_indicator`

Data type: `Any`

Name of the Apache environment variable that contains SSL client certificates.

Default value: `undef`

##### `cipher_indicator`

Data type: `Any`

Name of the Apache environment variable that contains SSL client cipher.

Default value: `undef`

##### `certchain_prefix`

Data type: `Any`

Name of the Apache environment (prefix) that contains SSL client chain certificates.

Default value: `undef`

##### `session_indicator`

Data type: `Any`

Name of the Apache environment variable that contains SSL session.

Default value: `undef`

##### `keysize_indicator`

Data type: `Any`

Name of the Apache environment variable that contains SSL key size in use.

Default value: `undef`

##### `local_name_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded local name.

Default value: `undef`

##### `ignore_cl_indicator`

Data type: `Any`

Name of the Apache environment variable which forces to ignore an existing Content-Length request header.

Default value: `undef`

##### `local_addr_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded local IP address.

Default value: `undef`

##### `local_port_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded local port.

Default value: `undef`

##### `remote_host_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) host name.

Default value: `undef`

##### `remote_addr_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) IP address.

Default value: `undef`

##### `remote_port_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) IP address.

Default value: `undef`

##### `remote_user_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded user name.

Default value: `undef`

##### `auth_type_indicator`

Data type: `Any`

Name of the Apache environment variable which can be used to overwrite the forwarded authentication type.

Default value: `undef`

##### `options`

Data type: `Any`

Set one of more options to configure the mod_jk module.

Default value: []

##### `env_var`

Data type: `Any`

Adds a name and an optional default value of environment variable that should be sent to servlet-engine as a request attribute.

Default value: {}

##### `strip_session`

Data type: `Any`

If this directive is set to On in some virtual server, the session IDs ;jsessionid=... will be removed for URLs which are not
forwarded but instead are handled by the local server.

Default value: `undef`

##### `workers_file_content`

Data type: `Any`

Each directive has the format worker.<Worker name>.<Property>=<Value>. This maps as a hash of hashes, where the outer hash specifies
workers, and each inner hash specifies each worker properties and values. Plus, there are two global directives, 'worker.list' and
'worker.maintain' For example, the workers file below should be parameterized as follows:

Worker file:
```
worker.list = status
worker.list = some_name,other_name

worker.maintain = 60

# Optional comment
worker.some_name.type=ajp13
worker.some_name.socket_keepalive=true

# I just like comments
worker.other_name.type=ajp12 (why would you?)
worker.other_name.socket_keepalive=false
```

Puppet file:
```
$workers_file_content = {
  worker_lists    => ['status', 'some_name,other_name'],
  worker_maintain => '60',
  some_name       => {
    comment          => 'Optional comment',
    type             => 'ajp13',
    socket_keepalive => 'true',
  },
  other_name      => {
    comment          => 'I just like comments',
    type             => 'ajp12',
    socket_keepalive => 'false',
  },
}
```

Default value: {}

##### `mount_file_content`

Data type: `Any`

Each directive has the format <URI> = <Worker name>. This maps as a hash of hashes, where the outer hash specifies workers, and
each inner hash contains two items:
- uri_list—an array with URIs to be mapped to the worker
- comment—an optional string with a comment for the worker. For example, the mount file below should be parameterized as Figure 2:

Worker file:
```
# Worker 1
/context_1/ = worker_1
/context_1/* = worker_1

# Worker 2
/ = worker_2
/context_2/ = worker_2
/context_2/* = worker_2
```

Puppet file:
```
$mount_file_content = {
  worker_1 => {
    uri_list => ['/context_1/', '/context_1/*'],
    comment  => 'Worker 1',
  },
  worker_2 => {
    uri_list => ['/context_2/', '/context_2/*'],
    comment  => 'Worker 2',
  },
},
```

Default value: {}

##### `location_list`

Data type: `Any`



Default value: []

### apache::mod::ldap

Installs and configures `mod_ldap`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_ldap.html
for additional documentation.

#### Examples

##### 

```puppet
class { 'apache::mod::ldap':
  ldap_trusted_global_cert_file => '/etc/pki/tls/certs/ldap-trust.crt',
  ldap_trusted_global_cert_type => 'CA_DER',
  ldap_trusted_mode             => 'TLS',
  ldap_shared_cache_size        => '500000',
  ldap_cache_entries            => '1024',
  ldap_cache_ttl                => '600',
  ldap_opcache_entries          => '1024',
  ldap_opcache_ttl              => '600',
}
```

#### Parameters

The following parameters are available in the `apache::mod::ldap` class.

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

##### `package_name`

Data type: `Any`

Specifies the custom package name.

Default value: `undef`

##### `ldap_trusted_global_cert_file`

Data type: `Any`

Sets the file or database containing global trusted Certificate Authority or global client certificates.

Default value: `undef`

##### `ldap_trusted_global_cert_type`

Data type: `Optional[String]`

Sets the the certificate parameter of the global trusted Certificate Authority or global client certificates.

Default value: 'CA_BASE64'

##### `ldap_shared_cache_size`

Data type: `Any`

Size in bytes of the shared-memory cache

Default value: `undef`

##### `ldap_cache_entries`

Data type: `Any`

Maximum number of entries in the primary LDAP cache

Default value: `undef`

##### `ldap_cache_ttl`

Data type: `Any`

Time that cached items remain valid (in seconds).

Default value: `undef`

##### `ldap_opcache_entries`

Data type: `Any`

Number of entries used to cache LDAP compare operations

Default value: `undef`

##### `ldap_opcache_ttl`

Data type: `Any`

Time that entries in the operation cache remain valid (in seconds).

Default value: `undef`

##### `ldap_trusted_mode`

Data type: `Any`

Specifies the SSL/TLS mode to be used when connecting to an LDAP server.

Default value: `undef`

##### `ldap_path`

Data type: `String`

The server location of the ldap status page.

Default value: '/ldap-status'

### apache::mod::lookup_identity

Installs `mod_lookup_identity`

* **See also**
https://www.adelton.com/apache/mod_lookup_identity
for additional documentation.

### apache::mod::macro

Installs `mod_macro`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_macro.html
for additional documentation.

### apache::mod::mime

Installs and configures `mod_mime`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_mime.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::mime` class.

##### `mime_support_package`

Data type: `Any`

Name of the MIME package to be installed.

Default value: $::apache::params::mime_support_package

##### `mime_types_config`

Data type: `Any`

The location of the mime.types file.

Default value: $::apache::params::mime_types_config

##### `mime_types_additional`

Data type: `Any`

List of additional MIME types to include.

Default value: `undef`

### apache::mod::mime_magic

Installs and configures `mod_mime_magic`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_mime_magic.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::mime_magic` class.

##### `magic_file`

Data type: `Any`

Enable MIME-type determination based on file contents using the specified magic file.

Default value: `undef`

### apache::mod::negotiation

Installs and configures `mod_negotiation`.

* **See also**
[https://httpd.apache.org/docs/current/mod/mod_negotiation.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::negotiation` class.

##### `force_language_priority`

Data type: `Variant[Array[String], String]`

Action to take if a single acceptable document is not found.

Default value: 'Prefer Fallback'

##### `language_priority`

Data type: `Variant[Array[String], String]`

The precedence of language variants for cases where the client does not express a preference.

Default value: [ 'en', 'ca', 'cs', 'da', 'de', 'el', 'eo', 'es', 'et',
                        'fr', 'he', 'hr', 'it', 'ja', 'ko', 'ltz', 'nl', 'nn',
                        'no', 'pl', 'pt', 'pt-BR', 'ru', 'sv', 'zh-CN',
                        'zh-TW' ]

### apache::mod::nss

Installs and configures `mod_nss`.

* **See also**
https://pagure.io/mod_nss
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::nss` class.

##### `transfer_log`

Data type: `Any`

Path to `access.log`.

Default value: "${::apache::params::logroot}/access.log"

##### `error_Log`

Path to `error.log`

##### `passwd_file`

Data type: `Any`

Path to file containing token passwords used for NSSPassPhraseDialog.

Default value: `undef`

##### `port`

Data type: `Any`

Sets the SSL port that should be used by mod_nss.

Default value: 8443

##### `error_log`

Data type: `Any`



Default value: "${::apache::params::logroot}/error.log"

### apache::mod::pagespeed

Although this apache module requires the mod-pagespeed-stable package, Puppet does not manage the software repositories required to
automatically install the package. If you declare this class when the package is either not installed or not available to your
package manager, your Puppet run will fail.

* **TODO** Add docs

* **Note** Verify that your system is compatible with the latest Google Pagespeed requirements.

* **See also**
https://developers.google.com/speed/pagespeed/module/
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::pagespeed` class.

##### `inherit_vhost_config`

Data type: `Any`



Default value: 'on'

##### `filter_xhtml`

Data type: `Any`



Default value: `false`

##### `cache_path`

Data type: `Any`



Default value: '/var/cache/mod_pagespeed/'

##### `log_dir`

Data type: `Any`



Default value: '/var/log/pagespeed'

##### `memcache_servers`

Data type: `Any`



Default value: []

##### `rewrite_level`

Data type: `Any`



Default value: 'CoreFilters'

##### `disable_filters`

Data type: `Any`



Default value: []

##### `enable_filters`

Data type: `Any`



Default value: []

##### `forbid_filters`

Data type: `Any`



Default value: []

##### `rewrite_deadline_per_flush_ms`

Data type: `Any`



Default value: 10

##### `additional_domains`

Data type: `Any`



Default value: `undef`

##### `file_cache_size_kb`

Data type: `Any`



Default value: 102400

##### `file_cache_clean_interval_ms`

Data type: `Any`



Default value: 3600000

##### `lru_cache_per_process`

Data type: `Any`



Default value: 1024

##### `lru_cache_byte_limit`

Data type: `Any`



Default value: 16384

##### `css_flatten_max_bytes`

Data type: `Any`



Default value: 2048

##### `css_inline_max_bytes`

Data type: `Any`



Default value: 2048

##### `css_image_inline_max_bytes`

Data type: `Any`



Default value: 2048

##### `image_inline_max_bytes`

Data type: `Any`



Default value: 2048

##### `js_inline_max_bytes`

Data type: `Any`



Default value: 2048

##### `css_outline_min_bytes`

Data type: `Any`



Default value: 3000

##### `js_outline_min_bytes`

Data type: `Any`



Default value: 3000

##### `inode_limit`

Data type: `Any`



Default value: 500000

##### `image_max_rewrites_at_once`

Data type: `Any`



Default value: 8

##### `num_rewrite_threads`

Data type: `Any`



Default value: 4

##### `num_expensive_rewrite_threads`

Data type: `Any`



Default value: 4

##### `collect_statistics`

Data type: `Any`



Default value: 'on'

##### `statistics_logging`

Data type: `Any`



Default value: 'on'

##### `allow_view_stats`

Data type: `Any`



Default value: []

##### `allow_pagespeed_console`

Data type: `Any`



Default value: []

##### `allow_pagespeed_message`

Data type: `Any`



Default value: []

##### `message_buffer_size`

Data type: `Any`



Default value: 100000

##### `additional_configuration`

Data type: `Any`



Default value: {}

##### `apache_version`

Data type: `Any`



Default value: `undef`

##### `package_ensure`

Data type: `Any`



Default value: `undef`

### apache::mod::passenger

The current set of server configurations settings were taken directly from the Passenger Reference. To enable deprecation warnings
and removal failure messages, set the passenger_installed_version to the version number installed on the server.

Change Log:
  - As of 08/13/2017 there are 84 available/deprecated/removed settings.
  - Around 08/20/2017 UnionStation was discontinued options were removed.
  - As of 08/20/2017 there are 77 available/deprecated/removed settings.

* **Note** In Passenger source code you can strip out what are all the available options by looking in
  - src/apache2_module/Configuration.cpp
  - src/apache2_module/ConfigurationCommands.cpp
There are also several undocumented settings.

* **See also**
https://www.phusionpassenger.com/library/config/apache/reference/
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::passenger` class.

##### `manage_repo`

Data type: `Any`

Toggle whether to manage yum repo if on a RedHat node.

Default value: `true`

##### `mod_id`

Data type: `Any`

Specifies the package id.

Default value: `undef`

##### `mod_lib`

Data type: `Any`

Defines the module's shared object name. Do not configure manually without special reason.

Default value: `undef`

##### `mod_lib_path`

Data type: `Any`

Specifies a path to the module's libraries. Do not manually set this parameter without special reason. The `path` parameter overrides
this value.

Default value: `undef`

##### `mod_package`

Data type: `Any`

Name of the module package to install.

Default value: `undef`

##### `mod_package_ensure`

Data type: `Any`

Determines whether Puppet ensures the module should be installed.

Default value: `undef`

##### `mod_path`

Data type: `Any`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

##### `passenger_allow_encoded_slashes`

Data type: `Any`

Toggle whether URLs with encoded slashes (%2f) can be used (by default Apache does not support this).

Default value: `undef`

##### `passenger_app_env`

Data type: `Any`

This option sets, for the current application, the value of the following environment variables:
- RAILS_ENV
- RACK_ENV
- WSGI_ENV
- NODE_ENV
- PASSENGER_APP_ENV

Default value: `undef`

##### `passenger_app_group_name`

Data type: `Any`

Sets the name of the application group that the current application should belong to.

Default value: `undef`

##### `passenger_app_root`

Data type: `Any`

Path to the application root which allows access independent from the DocumentRoot.

Default value: `undef`

##### `passenger_app_type`

Data type: `Any`

Specifies the type of the application. If you set this option, then you must also set PassengerAppRoot, otherwise Passenger will
not properly recognize your application.

Default value: `undef`

##### `passenger_base_uri`

Data type: `Any`

Used to specify that the given URI is an distinct application that should be served by Passenger.

Default value: `undef`

##### `passenger_buffer_response`

Data type: `Any`

Toggle whether application-generated responses are buffered by Apache. Buffering will happen in memory.

Default value: `undef`

##### `passenger_buffer_upload`

Data type: `Any`

Toggle whether HTTP client request bodies are buffered before they are sent to the application.

Default value: `undef`

##### `passenger_concurrency_model`

Data type: `Any`

Specifies the I/O concurrency model that should be used for Ruby application processes.

Default value: `undef`

##### `passenger_conf_file`

Data type: `Any`



Default value: $::apache::params::passenger_conf_file

##### `passenger_conf_package_file`

Data type: `Any`



Default value: $::apache::params::passenger_conf_package_file

##### `passenger_data_buffer_dir`

Data type: `Any`

Specifies the directory in which to store data buffers.

Default value: `undef`

##### `passenger_debug_log_file`

Data type: `Any`



Default value: `undef`

##### `passenger_debugger`

Data type: `Any`

Turns support for Ruby application debugging on or off.

Default value: `undef`

##### `passenger_default_group`

Data type: `Any`

Allows you to specify the group that applications must run as, if user switching fails or is disabled.

Default value: `undef`

##### `passenger_default_ruby`

Data type: `Any`

File path to desired ruby interpreter to use by default.

Default value: $::apache::params::passenger_default_ruby

##### `passenger_default_user`

Data type: `Any`

Allows you to specify the user that applications must run as, if user switching fails or is disabled.

Default value: `undef`

##### `passenger_disable_security_update_check`

Data type: `Any`

Allows disabling the Passenger security update check, a daily check with https://securitycheck.phusionpassenger.com for important
security updates that might be available.

Default value: `undef`

##### `passenger_enabled`

Data type: `Any`

Toggles whether Passenger should be enabled for that particular context.

Default value: `undef`

##### `passenger_error_override`

Data type: `Any`

Toggles whether Apache will intercept and handle responses with HTTP status codes of 400 and higher.

Default value: `undef`

##### `passenger_file_descriptor_log_file`

Data type: `Any`

Log file descriptor debug tracing messages to the given file.

Default value: `undef`

##### `passenger_fly_with`

Data type: `Any`

Enables the Flying Passenger mode, and configures Apache to connect to the Flying Passenger daemon that's listening on the
given socket filename.

Default value: `undef`

##### `passenger_force_max_concurrent_requests_per_process`

Data type: `Any`

Use this option to tell Passenger how many concurrent requests the application can handle per process.

Default value: `undef`

##### `passenger_friendly_error_pages`

Data type: `Any`

Toggles whether Passenger should display friendly error pages whenever an application fails to start.

Default value: `undef`

##### `passenger_group`

Data type: `Any`

Allows you to override that behavior and explicitly set a group to run the web application as, regardless of the ownership of the
startup file.

Default value: `undef`

##### `passenger_high_performance`

Data type: `Any`

Toggles whether to enable PassengerHighPerformance which will make Passenger will be a little faster, in return for reduced
compatibility with other Apache modules.

Default value: `undef`

##### `passenger_installed_version`

Data type: `Any`



Default value: `undef`

##### `passenger_instance_registry_dir`

Data type: `Any`

Specifies the directory that Passenger should use for registering its current instance.

Default value: `undef`

##### `passenger_load_shell_envvars`

Data type: `Any`

Enables or disables the loading of shell environment variables before spawning the application.

Default value: `undef`

##### `passenger_log_file`

Data type: `Optional[Stdlib::Absolutepath]`

File path to log file. By default Passenger log messages are written to the Apache global error log.

Default value: `undef`

##### `passenger_log_level`

Data type: `Any`

Specifies how much information Passenger should log to its log file. A higher log level value means that more
information will be logged.

Default value: `undef`

##### `passenger_lve_min_uid`

Data type: `Any`

When using Passenger on a LVE-enabled kernel, a security check (enter) is run for spawning application processes. This options
tells the check to only allow processes with UIDs equal to, or higher than, the specified value.

Default value: `undef`

##### `passenger_max_instances`

Data type: `Any`

The maximum number of application processes that may simultaneously exist for an application.

Default value: `undef`

##### `passenger_max_instances_per_app`

Data type: `Any`

The maximum number of application processes that may simultaneously exist for a single application.

Default value: `undef`

##### `passenger_max_pool_size`

Data type: `Any`

The maximum number of application processes that may simultaneously exist.

Default value: `undef`

##### `passenger_max_preloader_idle_time`

Data type: `Any`

Set the preloader's idle timeout, in seconds. A value of 0 means that it should never idle timeout.

Default value: `undef`

##### `passenger_max_request_queue_size`

Data type: `Any`

Specifies the maximum size for the queue of all incoming requests.

Default value: `undef`

##### `passenger_max_request_time`

Data type: `Any`

The maximum amount of time, in seconds, that an application process may take to process a request.

Default value: `undef`

##### `passenger_max_requests`

Data type: `Any`

The maximum number of requests an application process will process.

Default value: `undef`

##### `passenger_memory_limit`

Data type: `Any`

The maximum amount of memory that an application process may use, in megabytes.

Default value: `undef`

##### `passenger_meteor_app_settings`

Data type: `Any`

When using a Meteor application in non-bundled mode, use this option to specify a JSON file with settings for the application.

Default value: `undef`

##### `passenger_min_instances`

Data type: `Any`

Specifies the minimum number of application processes that should exist for a given application.

Default value: `undef`

##### `passenger_nodejs`

Data type: `Any`

Specifies the Node.js command to use for serving Node.js web applications.

Default value: `undef`

##### `passenger_pool_idle_time`

Data type: `Any`

The maximum number of seconds that an application process may be idle.

Default value: `undef`

##### `passenger_pre_start`

Data type: `Optional[Variant[String,Array[String]]]`

URL of the web application you want to pre-start.

Default value: `undef`

##### `passenger_python`

Data type: `Any`

Specifies the Python interpreter to use for serving Python web applications.

Default value: `undef`

##### `passenger_resist_deployment_errors`

Data type: `Any`

Enables or disables resistance against deployment errors.

Default value: `undef`

##### `passenger_resolve_symlinks_in_document_root`

Data type: `Any`

This option is no longer available in version 5.2.0. Switch to PassengerAppRoot if you are setting the application root via a
document root containing symlinks.

Default value: `undef`

##### `passenger_response_buffer_high_watermark`

Data type: `Any`

Configures the maximum size of the real-time disk-backed response buffering system.

Default value: `undef`

##### `passenger_restart_dir`

Data type: `Any`

Path to directory containing restart.txt file. Can be either absolute or relative.

Default value: `undef`

##### `passenger_rolling_restarts`

Data type: `Any`

Enables or disables support for zero-downtime application restarts through restart.txt.

Default value: `undef`

##### `passenger_root`

Data type: `Any`

Refers to the location to the Passenger root directory, or to a location configuration file.

Default value: $::apache::params::passenger_root

##### `passenger_ruby`

Data type: `Any`

Specifies the Ruby interpreter to use for serving Ruby web applications.

Default value: $::apache::params::passenger_ruby

##### `passenger_security_update_check_proxy`

Data type: `Any`

Allows use of an intermediate proxy for the Passenger security update check.

Default value: `undef`

##### `passenger_show_version_in_header`

Data type: `Any`

Toggle whether Passenger will output its version number in the X-Powered-By header in all Passenger-served requests:

Default value: `undef`

##### `passenger_socket_backlog`

Data type: `Any`

This option can be raised if Apache manages to overflow the backlog queue.

Default value: `undef`

##### `passenger_spawn_method`

Data type: `Optional[Enum['smart', 'direct', 'smart-lv2', 'conservative']]`

Controls whether Passenger spawns applications directly, or using a prefork copy-on-write mechanism.

Default value: `undef`

##### `passenger_start_timeout`

Data type: `Any`

Specifies a timeout for the startup of application processes.

Default value: `undef`

##### `passenger_startup_file`

Data type: `Any`

Specifies the startup file that Passenger should use when loading the application.

Default value: `undef`

##### `passenger_stat_throttle_rate`

Data type: `Any`

Setting this option to a value of x means that certain filesystem checks will be performed at most once every x seconds.

Default value: `undef`

##### `passenger_sticky_sessions`

Data type: `Any`

Toggles whether all requests that a client sends will be routed to the same originating application process, whenever possible.

Default value: `undef`

##### `passenger_sticky_sessions_cookie_name`

Data type: `Any`

Sets the name of the sticky sessions cookie.

Default value: `undef`

##### `passenger_thread_count`

Data type: `Any`

Specifies the number of threads that Passenger should spawn per Ruby application process.

Default value: `undef`

##### `passenger_use_global_queue`

Data type: `Any`

N/A.

Default value: `undef`

##### `passenger_user`

Data type: `Any`

Allows you to override that behavior and explicitly set a user to run the web application as, regardless of the ownership of the
startup file.

Default value: `undef`

##### `passenger_user_switching`

Data type: `Any`

Toggles whether to attempt to enable user account sandboxing, also known as user switching.

Default value: `undef`

##### `rack_auto_detect`

Data type: `Any`

This option has been removed in version 4.0.0 as part of an optimization. You should use PassengerEnabled instead.

Default value: `undef`

##### `rack_autodetect`

Data type: `Any`

This option has been removed in version 4.0.0 as part of an optimization. You should use PassengerEnabled instead.

Default value: `undef`

##### `rack_base_uri`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerBaseURI.

Default value: `undef`

##### `rack_env`

Data type: `Any`

Alias for PassengerAppEnv.

Default value: `undef`

##### `rails_allow_mod_rewrite`

Data type: `Any`

This option doesn't do anything anymore since version 4.0.0.

Default value: `undef`

##### `rails_app_spawner_idle_time`

Data type: `Any`

This option has been removed in version 4.0.0, and replaced with PassengerMaxPreloaderIdleTime.

Default value: `undef`

##### `rails_auto_detect`

Data type: `Any`

This option has been removed in version 4.0.0 as part of an optimization. You should use PassengerEnabled instead.

Default value: `undef`

##### `rails_autodetect`

Data type: `Any`

This option has been removed in version 4.0.0 as part of an optimization. You should use PassengerEnabled instead.

Default value: `undef`

##### `rails_base_uri`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerBaseURI.

Default value: `undef`

##### `rails_default_user`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerDefaultUser

Default value: `undef`

##### `rails_env`

Data type: `Any`

Alias for PassengerAppEnv.

Default value: `undef`

##### `rails_framework_spawner_idle_time`

Data type: `Any`

This option is no longer available in version 4.0.0. There is no alternative because framework spawning has been removed
altogether. You should use smart spawning instead.

Default value: `undef`

##### `rails_ruby`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerRuby.

Default value: `undef`

##### `rails_spawn_method`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerSpawnMethod.

Default value: `undef`

##### `rails_user_switching`

Data type: `Any`

Deprecated in 3.0.0 in favor of PassengerUserSwitching.

Default value: `undef`

##### `wsgi_auto_detect`

Data type: `Any`

This option has been removed in version 4.0.0 as part of an optimization. You should use PassengerEnabled instead.

Default value: `undef`

### apache::mod::perl

Installs `mod_perl`.

* **See also**
https://perl.apache.org
for additional documentation.

### apache::mod::peruser

Installs `mod_peruser`.

* **TODO** Add docs

#### Parameters

The following parameters are available in the `apache::mod::peruser` class.

##### `minspareprocessors`

Data type: `Any`



Default value: '2'

##### `minprocessors`

Data type: `Any`



Default value: '2'

##### `maxprocessors`

Data type: `Any`



Default value: '10'

##### `maxclients`

Data type: `Any`



Default value: '150'

##### `maxrequestsperchild`

Data type: `Any`



Default value: '1000'

##### `idletimeout`

Data type: `Any`



Default value: '120'

##### `expiretimeout`

Data type: `Any`



Default value: '120'

##### `keepalive`

Data type: `Any`



Default value: 'Off'

### apache::mod::php

Installs `mod_php`.

* **TODO** Add docs

#### Parameters

The following parameters are available in the `apache::mod::php` class.

##### `package_name`

Data type: `Any`



Default value: `undef`

##### `package_ensure`

Data type: `Any`



Default value: 'present'

##### `path`

Data type: `Any`



Default value: `undef`

##### `extensions`

Data type: `Array`



Default value: ['.php']

##### `content`

Data type: `Any`



Default value: `undef`

##### `template`

Data type: `Any`



Default value: 'apache/mod/php.conf.erb'

##### `source`

Data type: `Any`



Default value: `undef`

##### `root_group`

Data type: `Any`



Default value: $::apache::params::root_group

##### `php_version`

Data type: `Any`



Default value: $::apache::params::php_version

##### `libphp_prefix`

Data type: `Any`



Default value: 'libphp'

### apache::mod::prefork

Installs and configures MPM `prefork`.

* **See also**
https://httpd.apache.org/docs/current/mod/prefork.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::prefork` class.

##### `startservers`

Data type: `Any`

Number of child server processes created at startup.

Default value: '8'

##### `minspareservers`

Data type: `Any`

Minimum number of idle child server processes.

Default value: '5'

##### `maxspareservers`

Data type: `Any`

Maximum number of idle child server processes.

Default value: '20'

##### `serverlimit`

Data type: `Any`

Upper limit on configurable number of processes.

Default value: '256'

##### `maxclients`

Data type: `Any`

Old alias for MaxRequestWorkers.

Default value: '256'

##### `maxrequestworkers`

Data type: `Any`

Maximum number of connections that will be processed simultaneously.

Default value: `undef`

##### `maxrequestsperchild`

Data type: `Any`

Old alias for MaxConnectionsPerChild.

Default value: '4000'

##### `maxconnectionsperchild`

Data type: `Any`

Limit on the number of connections that an individual child server will handle during its life.

Default value: `undef`

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

##### `listenbacklog`

Data type: `Any`

Maximum length of the queue of pending connections.

Default value: '511'

### apache::mod::proxy

Installs and configures `mod_proxy`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::proxy` class.

##### `proxy_requests`

Data type: `Any`

Enables forward (standard) proxy requests.

Default value: 'Off'

##### `allow_from`

Data type: `Any`

List of IPs allowed to access proxy.

Default value: `undef`

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

##### `package_name`

Data type: `Any`

Name of the proxy package to install.

Default value: `undef`

##### `proxy_via`

Data type: `Any`

Set local IP address for outgoing proxy connections.

Default value: 'On'

##### `proxy_timeout`

Data type: `Any`

Network timeout for proxied requests.

Default value: `undef`

### apache::mod::proxy_ajp

Installs `mod_proxy_ajp`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_ajp.html
for additional documentation.

### apache::mod::proxy_balancer

Installs and configures `mod_proxy_balancer`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_balancer.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::proxy_balancer` class.

##### `manager`

Data type: `Boolean`

Toggle whether to enable balancer manager support.

Default value: `false`

##### `maanger_path`

Server relative path to balancer manager.

##### `allow_from`

Data type: `Array`

List of IPs from which the balancer manager can be accessed.

Default value: ['127.0.0.1','::1']

##### `apache_version`

Data type: `Any`

Version of Apache to install module on.

Default value: $::apache::apache_version

##### `manager_path`

Data type: `Stdlib::Absolutepath`



Default value: '/balancer-manager'

### apache::mod::proxy_connect

Installs `mod_proxy_connect`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_connect.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::proxy_connect` class.

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

### apache::mod::proxy_fcgi

Installs `mod_proxy_fcgi`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_fcgi.html
for additional documentation.

### apache::mod::proxy_html

Installs `mod_proxy_html`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_html.html
for additional documentation.

### apache::mod::proxy_http

Installs `mod_proxy_http`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_http.html
for additional documentation.

### apache::mod::proxy_wstunnel

Installs `mod_proxy_wstunnel`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_proxy_wstunnel.html
for additional documentation.

### apache::mod::python

Installs and configures `mod_python`.

* **See also**
https://github.com/grisha/mod_python
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::python` class.

##### `loadfile_name`

Data type: `Optional[String]`

Sets the name of the configuration file that is used to load the python module.

Default value: `undef`

### apache::mod::remoteip

Installs and configures `mod_remoteip`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_remoteip.html
https://httpd.apache.org/docs/current/mod/mod_remoteip.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::remoteip` class.

##### `header`

Data type: `String`

The header field in which `mod_remoteip` will look for the useragent IP.

Default value: 'X-Forwarded-For'

##### `internal_proxy`

Data type: `Optional[Array[Variant[Stdlib::Host,Stdlib::IP::Address]]]`

A list of IP addresses, IP blocks or hostname that are trusted to set a
valid value inside specified header. Unlike the `$trusted_proxy_ips`
parameter, any IP address (including private addresses) presented by these
proxies will trusted by `mod_remoteip`.

Default value: `undef`

##### `proxy_ips`

Data type: `Optional[Array[Variant[Stdlib::Host,Stdlib::IP::Address]]]`

*Deprecated*: use `$internal_proxy` instead.

Default value: `undef`

##### `internal_proxy_list`

Data type: `Optional[Stdlib::Absolutepath]`

The path to a file containing a list of IP addresses, IP blocks or hostname
that are trusted to set a valid value inside the specified header. See
`$internal_proxy` for details.

Default value: `undef`

##### `proxies_header`

Data type: `Optional[String]`

A header into which `mod_remoteip` will collect a list of all of the
intermediate client IP addresses trusted to resolve the useragent IP of the
request (e.g. `X-Forwarded-By`).

Default value: `undef`

##### `proxy_protocol`

Data type: `Boolean`

Wether or not to enable the PROXY protocol header handling. If enabled
upstream clients must set the header every time they open a connection.

Default value: `false`

##### `proxy_protocol_exceptions`

Data type: `Optional[Array[Stdlib::Host]]`

A list of IP address or IP blocks that are not required to use the PROXY
protocol.

Default value: `undef`

##### `trusted_proxy`

Data type: `Optional[Array[Stdlib::Host]]`

A list of IP addresses, IP blocks or hostname that are trusted to set a
valid value inside the specified header. Unlike the `$proxy_ips` parameter,
any private IP presented by these proxies will be disgarded by
`mod_remoteip`.

Default value: `undef`

##### `trusted_proxy_ips`

Data type: `Optional[Array[Stdlib::Host]]`

*Deprecated*: use `$trusted_proxy` instead.

Default value: `undef`

##### `trusted_proxy_list`

Data type: `Optional[Stdlib::Absolutepath]`

The path to a file containing a list of IP addresses, IP blocks or hostname
that are trusted to set a valid value inside the specified header. See
`$trusted_proxy` for details.

Default value: `undef`

##### `apache_version`

Data type: `Optional[String]`

A version string used to validate that your apache version supports
`mod_remoteip`. If not specified, `$::apache::apache_version` is used.

Default value: `undef`

### apache::mod::reqtimeout

Installs and configures `mod_reqtimeout`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_reqtimeout.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::reqtimeout` class.

##### `timeouts`

Data type: `Any`

List of timeouts and data rates for receiving requests.

Default value: ['header=20-40,minrate=500', 'body=10,minrate=500']

### apache::mod::rewrite

Installs `mod_rewrite`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_rewrite.html
for additional documentation.

### apache::mod::rpaf

Installs and configures `mod_rpaf`.

* **See also**
https://github.com/gnif/mod_rpaf
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::rpaf` class.

##### `sethostname`

Data type: `Any`

Toggles whether to update vhost name so ServerName and ServerAlias work.

Default value: `true`

##### `proxy_ips`

Data type: `Any`

List of IPs & bitmasked subnets to adjust requests for

Default value: [ '127.0.0.1' ]

##### `header`

Data type: `Any`

Header to use for the real IP address.

Default value: 'X-Forwarded-For'

##### `template`

Data type: `Any`

Path to template to use for configuring mod_rpaf.

Default value: 'apache/mod/rpaf.conf.erb'

### apache::mod::security

Installs and configures `mod_security`.

* **See also**
https://github.com/SpiderLabs/ModSecurity/wiki
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::security` class.

##### `version`

Data type: `Any`

Manage mod_security or mod_security2

Default value: $::apache::params::modsec_version

##### `logroot`

Data type: `Any`

Configures the location of audit and debug logs.

Default value: $::apache::params::logroot

##### `crs_package`

Data type: `Any`

Name of package that installs CRS rules.

Default value: $::apache::params::modsec_crs_package

##### `activated_rules`

Data type: `Any`

An array of rules from the modsec_crs_path or absolute to activate via symlinks.

Default value: $::apache::params::modsec_default_rules

##### `modsec_dir`

Data type: `Any`

Defines the path where Puppet installs the modsec configuration and activated rules links.

Default value: $::apache::params::modsec_dir

##### `modsec_secruleengine`

Data type: `Any`

Configures the rules engine.

Default value: $::apache::params::modsec_secruleengine

##### `audit_log_relevant_status`

Data type: `Any`

Configures which response status code is to be considered relevant for the purpose of audit logging.

Default value: '^(?:5|4(?!04))'

##### `audit_log_parts`

Data type: `Any`

Defines which parts of each transaction are going to be recorded in the audit log. Each part is assigned a single letter; when a
letter appears in the list then the equivalent part will be recorded.

Default value: $::apache::params::modsec_audit_log_parts

##### `secpcrematchlimit`

Data type: `Any`

Sets the match limit in the PCRE library.

Default value: $::apache::params::secpcrematchlimit

##### `secpcrematchlimitrecursion`

Data type: `Any`

Sets the match limit recursion in the PCRE library.

Default value: $::apache::params::secpcrematchlimitrecursion

##### `allowed_methods`

Data type: `Any`

A space-separated list of allowed HTTP methods.

Default value: 'GET HEAD POST OPTIONS'

##### `content_types`

Data type: `Any`

A list of one or more allowed MIME types.

Default value: 'application/x-www-form-urlencoded|multipart/form-data|text/xml|application/xml|application/x-amf'

##### `restricted_extensions`

Data type: `Any`

A space-sparated list of prohibited file extensions.

Default value: '.asa/ .asax/ .ascx/ .axd/ .backup/ .bak/ .bat/ .cdx/ .cer/ .cfg/ .cmd/ .com/ .config/ .conf/ .cs/ .csproj/ .csr/ .dat/ .db/ .dbf/ .dll/ .dos/ .htr/ .htw/ .ida/ .idc/ .idq/ .inc/ .ini/ .key/ .licx/ .lnk/ .log/ .mdb/ .old/ .pass/ .pdb/ .pol/ .printer/ .pwd/ .resources/ .resx/ .sql/ .sys/ .vb/ .vbs/ .vbproj/ .vsdisco/ .webinfo/ .xsd/ .xsx/'

##### `restricted_headers`

Data type: `Any`

A list of restricted headers separated by slashes and spaces.

Default value: '/Proxy-Connection/ /Lock-Token/ /Content-Range/ /Translate/ /via/ /if/'

##### `secdefaultaction`

Data type: `Any`

Defines the default list of actions, which will be inherited by the rules in the same configuration context.

Default value: 'deny'

##### `anomaly_score_blocking`

Data type: `Any`

Activates or deactivates the Collaborative Detection Blocking of the OWASP ModSecurity Core Rule Set.

Default value: 'off'

##### `inbound_anomaly_threshold`

Data type: `Any`

Sets the scoring threshold level of the inbound blocking rules for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule Set.

Default value: '5'

##### `outbound_anomaly_threshold`

Data type: `Any`

Sets the scoring threshold level of the outbound blocking rules for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule Set.

Default value: '4'

##### `critical_anomaly_score`

Data type: `Any`

Sets the Anomaly Score for rules assigned with a critical severity.

Default value: '5'

##### `error_anomaly_score`

Data type: `Any`

Sets the Anomaly Score for rules assigned with a error severity.

Default value: '4'

##### `warning_anomaly_score`

Data type: `Any`

Sets the Anomaly Score for rules assigned with a warning severity.

Default value: '3'

##### `notice_anomaly_score`

Data type: `Any`

Sets the Anomaly Score for rules assigned with a notice severity.

Default value: '2'

##### `secrequestmaxnumargs`

Data type: `Any`

Sets the maximum number of arguments in the request.

Default value: '255'

##### `secrequestbodylimit`

Data type: `Any`

Sets the maximum request body size ModSecurity will accept for buffering.

Default value: '13107200'

##### `secrequestbodynofileslimit`

Data type: `Any`

Configures the maximum request body size ModSecurity will accept for buffering, excluding the size of any files being transported
in the request.

Default value: '131072'

##### `secrequestbodyinmemorylimit`

Data type: `Any`

Configures the maximum request body size that ModSecurity will store in memory.

Default value: '131072'

##### `manage_security_crs`

Data type: `Any`

Toggles whether to manage ModSecurity Core Rule Set

Default value: `true`

### apache::mod::setenvif

Installs `mod_setenvif`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_setenvif.html
for additional documentation.

### apache::mod::shib

This class installs and configures only the Apache components of a web application that consumes Shibboleth SSO identities. You
can manage the Shibboleth configuration manually, with Puppet, or using a [Shibboleth Puppet Module](https://github.com/aethylred/puppet-shibboleth).

* **Note** The Shibboleth module isn't available on RH/CentOS without providing dependency packages provided by Shibboleth's repositories.
See the [Shibboleth Service Provider Installation Guide](http://wiki.aaf.edu.au/tech-info/sp-install-guide).

* **See also**
https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPApacheConfig
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::shib` class.

##### `suppress_warning`

Data type: `Any`

Toggles whether to trigger warning on RedHat nodes.

Default value: `false`

##### `mod_full_path`

Data type: `Any`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

##### `package_name`

Data type: `Any`

Name of the Shibboleth package to be installed.

Default value: `undef`

##### `mod_lib`

Data type: `Any`

Specifies a path to the module's libraries. Do not manually set this parameter without special reason. The `path` parameter
overrides this value.

Default value: `undef`

### apache::mod::socache_shmcb

Installs `mod_socache_shmcb`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_socache_shmcb.html
for additional documentation.

### apache::mod::speling

Installs `mod_spelling`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_speling.html
for additional documentation.

### apache::mod::ssl

On most operating systems, the ssl.conf is placed in the module configuration directory. On Red Hat based operating systems, this
file is placed in /etc/httpd/conf.d, the same location in which the RPM stores the configuration.

To use SSL with a virtual host, you must either set the default_ssl_vhost parameter in ::apache to true or the ssl parameter in
apache::vhost to true.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_ssl.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::ssl` class.

##### `ssl_compression`

Data type: `Boolean`

Enable compression on the SSL level.

Default value: `false`

##### `ssl_cryptodevice`

Data type: `Any`

Enable use of a cryptographic hardware accelerator.

Default value: 'builtin'

##### `ssl_options`

Data type: `Any`

Configure various SSL engine run-time options.

Default value: [ 'StdEnvVars' ]

##### `ssl_openssl_conf_cmd`

Data type: `Any`

Configure OpenSSL parameters through its SSL_CONF API.

Default value: `undef`

##### `ssl_cert`

Data type: `Optional[String]`

Path to server PEM-encoded X.509 certificate data file.

Default value: `undef`

##### `ssl_key`

Data type: `Optional[String]`

Path to server PEM-encoded private key file

Default value: `undef`

##### `ssl_ca`

Data type: `Any`

File of concatenated PEM-encoded CA Certificates for Client Auth.

Default value: `undef`

##### `ssl_cipher`

Data type: `Any`

Cipher Suite available for negotiation in SSL handshake.

Default value: 'HIGH:MEDIUM:!aNULL:!MD5:!RC4:!3DES'

##### `ssl_honorcipherorder`

Data type: `Variant[Boolean, Enum['on', 'off']]`

Option to prefer the server's cipher preference order.

Default value: `true`

##### `ssl_protocol`

Data type: `Any`

Configure usable SSL/TLS protocol versions.
Default based on the OS:
- RedHat 8: [ 'all' ].
- Other Platforms: [ 'all', '-SSLv2', '-SSLv3' ].

Default value: $::apache::params::ssl_protocol

##### `ssl_proxy_protocol`

Data type: `Array`

Configure usable SSL protocol flavors for proxy usage.

Default value: []

##### `ssl_pass_phrase_dialog`

Data type: `Any`

Type of pass phrase dialog for encrypted private keys.

Default value: 'builtin'

##### `ssl_random_seed_bytes`

Data type: `Any`

Pseudo Random Number Generator (PRNG) seeding source.

Default value: '512'

##### `ssl_sessioncache`

Data type: `String`

Configures the storage type of the global/inter-process SSL Session Cache

Default value: $::apache::params::ssl_sessioncache

##### `ssl_sessioncachetimeout`

Data type: `Any`

Number of seconds before an SSL session expires in the Session Cache.

Default value: '300'

##### `ssl_stapling`

Data type: `Boolean`

Enable stapling of OCSP responses in the TLS handshake.

Default value: `false`

##### `ssl_stapling_return_errors`

Data type: `Optional[Boolean]`

Pass stapling related OCSP errors on to client.

Default value: `undef`

##### `ssl_mutex`

Data type: `Any`

Configures mutex mechanism and lock file directory for all or specified mutexes.
Default based on the OS and/or Apache version:
- RedHat/FreeBSD/Suse/Gentoo: 'default'.
- Debian/Ubuntu + Apache >= 2.4: 'default'.
- Debian/Ubuntu + Apache < 2.4: 'file:${APACHE_RUN_DIR}/ssl_mutex'.
- Ubuntu 10.04: 'file:/var/run/apache2/ssl_mutex'.

Default value: `undef`

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

##### `package_name`

Data type: `Any`

Name of ssl package to install.

Default value: `undef`

##### `ssl_sessiontickets`

Data type: `Optional[Boolean]`



Default value: `undef`

##### `stapling_cache`

Data type: `Optional[String]`



Default value: `undef`

### apache::mod::status

Installs and configures `mod_status`.

* **See also**
http://httpd.apache.org/docs/current/mod/mod_status.html
for additional documentation.

#### Examples

##### 

```puppet
# Simple usage allowing access from localhost and a private subnet
class { 'apache::mod::status':
  $allow_from => ['127.0.0.1', '10.10.10.10/24'],
}
```

#### Parameters

The following parameters are available in the `apache::mod::status` class.

##### `allow_from`

Data type: `Optional[Array]`

Array of hosts, ip addresses, partial network numbers or networks, in CIDR notation specifying what hosts can view the special
/server-status URL.  Defaults to ['127.0.0.1', '::1'].
> Creates Apache < 2.4 directive "Allow from".

Default value: `undef`

##### `requires`

Data type: `Optional[Variant[String, Array, Hash]]`

A Variant type that can be:
- String with:
  - '' or 'unmanaged' - Host auth control done elsewhere
  - 'ip <List of IPs>' - Allowed IPs/ranges
  - 'host <List of names>' - Allowed names/domains
  - 'all [granted|denied]'
- Array of strings with ip or host as above
- Hash with following keys:
  - 'requires' - Value => Array as above
  - 'enforce' - Value => String 'Any', 'All' or 'None'
    This encloses "Require" directives in "<Require(Any|All|None)>" block
    Optional - If unspecified, "Require" directives follow current flow
> Creates Apache >= 2.4 directives "Require"

Default value: `undef`

##### `extended_status`

Data type: `Enum['On', 'Off', 'on', 'off']`

Determines whether to track extended status information for each request, via the ExtendedStatus directive.

Default value: 'On'

##### `status_path`

Data type: `Any`

Path assigned to the Location directive which defines the URL to access the server status.

Default value: '/server-status'

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

### apache::mod::suexec

Installs `mod_suexec`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_suexec.html
for additional documentation.

### apache::mod::suphp

Installs `mod_suphp`.

* **See also**
https://www.suphp.org/DocumentationView.html?file=apache/INSTALL
for additional documentation.

### apache::mod::userdir

Installs and configures `mod_userdir`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_userdir.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::userdir` class.

##### `home`

Data type: `Any`

*Deprecated* Path to system home directory.

Default value: `undef`

##### `dir`

Data type: `Any`

*Deprecated* Path from user's home directory to public directory.

Default value: `undef`

##### `disable_root`

Data type: `Any`

Toggles whether to allow use of root directory.

Default value: `true`

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

##### `path`

Data type: `Any`

Path to directory or pattern from which to find user-specific directories.

Default value: '/home/*/public_html'

##### `overrides`

Data type: `Any`

Array of directives that are allowed in .htaccess files.

Default value: [ 'FileInfo', 'AuthConfig', 'Limit', 'Indexes' ]

##### `options`

Data type: `Any`

Configures what features are available in a particular directory.

Default value: [ 'MultiViews', 'Indexes', 'SymLinksIfOwnerMatch', 'IncludesNoExec' ]

##### `unmanaged_path`

Data type: `Any`

Toggles whether to manage path in userdir.conf

Default value: `false`

##### `custom_fragment`

Data type: `Any`

Custom configuration to be added to userdir.conf

Default value: `undef`

### apache::mod::version

Installs `mod_version`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_version.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::version` class.

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: $::apache::apache_version

### apache::mod::vhost_alias

Installs Apache `mod_vhost_alias`.

* **See also**
https://httpd.apache.org/docs/current/mod/mod_vhost_alias.html
for additional documentation.

### apache::mod::worker

Installs and manages the MPM `worker`.

* **See also**
https://httpd.apache.org/docs/current/mod/worker.html
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::worker` class.

##### `startservers`

Data type: `Any`

The number of child server processes created on startup

Default value: '2'

##### `maxclients`

Data type: `Any`

The max number of simultaneous requests that will be served.
This is the old name and is still supported. The new name is
MaxRequestWorkers as of 2.3.13.

Default value: '150'

##### `minsparethreads`

Data type: `Any`

Minimum number of idle threads to handle request spikes.

Default value: '25'

##### `maxsparethreads`

Data type: `Any`

Maximum number of idle threads.

Default value: '75'

##### `threadsperchild`

Data type: `Any`

The number of threads created by each child process.

Default value: '25'

##### `maxrequestsperchild`

Data type: `Any`

Limit on the number of connectiojns an individual child server
process will handle. This is the old name and is still supported. The new
name is MaxConnectionsPerChild as of 2.3.9+.

Default value: '0'

##### `serverlimit`

Data type: `Any`

With worker, use this directive only if your MaxRequestWorkers
and ThreadsPerChild settings require more than 16 server processes
(default). Do not set the value of this directive any higher than the
number of server processes required by what you may want for
MaxRequestWorkers and ThreadsPerChild.

Default value: '25'

##### `threadlimit`

Data type: `Any`

This directive sets the maximum configured value for
ThreadsPerChild for the lifetime of the Apache httpd process.

Default value: '64'

##### `listenbacklog`

Data type: `Any`

Maximum length of the queue of pending connections.

Default value: '511'

##### `apache_version`

Data type: `Any`

Used to verify that the Apache version you have requested is compatible with the module.

Default value: `undef`

### apache::mod::wsgi

Installs and configures `mod_wsgi`.

* **See also**
https://github.com/GrahamDumpleton/mod_wsgi
for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::wsgi` class.

##### `wsgi_restrict_embedded`

Data type: `Any`

Enable restrictions on use of embedded mode.

Default value: `undef`

##### `wsgi_socket_prefix`

Data type: `Any`

Configure directory to use for daemon sockets.

Default value: $::apache::params::wsgi_socket_prefix

##### `wsgi_python_path`

Data type: `Any`

Additional directories to search for Python modules.

Default value: `undef`

##### `wsgi_python_home`

Data type: `Any`

Absolute path to Python prefix/exec_prefix directories.

Default value: `undef`

##### `wsgi_python_optimize`

Data type: `Any`

Enables basic Python optimisation features.

Default value: `undef`

##### `wsgi_application_group`

Data type: `Any`

Sets which application group WSGI application belongs to.

Default value: `undef`

##### `package_name`

Data type: `Any`

Names of package that installs mod_wsgi.

Default value: `undef`

##### `mod_path`

Data type: `Any`

Defines the path to the mod_wsgi shared object (.so) file.

Default value: `undef`

### apache::mod::xsendfile

Installs `mod_xsendfile`.

* **See also**
https://tn123.org/mod_xsendfile/
for additional documentation.

### apache::mpm::disable_mpm_event

The apache::mpm::disable_mpm_event class.

### apache::mpm::disable_mpm_prefork

The apache::mpm::disable_mpm_prefork class.

### apache::mpm::disable_mpm_worker

The apache::mpm::disable_mpm_worker class.

### apache::vhosts

host parameters or Configuring virtual hosts in the README section.

* **Note** See the `apache::vhost` defined type's reference for a list of all virtual

#### Examples

##### To create a [name-based virtual host](https://httpd.apache.org/docs/current/vhosts/name-based.html) `custom_vhost_1`

```puppet
class { 'apache::vhosts':
  vhosts => {
    'custom_vhost_1' => {
      'docroot' => '/var/www/custom_vhost_1',
      'port'    => '81',
    },
  },
}
```

#### Parameters

The following parameters are available in the `apache::vhosts` class.

##### `vhosts`

Data type: `Any`

A hash, where the key represents the name and the value represents a hash of
`apache::vhost` defined type's parameters.

Default value: {}

## Defined types

### apache::balancer

Each balancer cluster needs one or more balancer members (that can
be declared with the apache::balancermember defined resource type). Using
storeconfigs, you can export the apache::balancermember resources on all
balancer members, and then collect them on a single apache load balancer
server.

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and uses
storeconfigs on the Puppet Master to export/collect resources from all
balancer members.

#### Examples

##### 

```puppet
apache::balancer { 'puppet00': }
```

#### Parameters

The following parameters are available in the `apache::balancer` defined type.

##### `name`

The namevar of the defined resource type is the balancer clusters name.<br />
This name is also used in the name of the conf.d file

##### `proxy_set`

Data type: `Any`

Configures key-value pairs to be used as a ProxySet lines in the configuration.

Default value: {}

##### `target`

Data type: `Any`

The path to the file the balancer definition will be written in.

Default value: `undef`

##### `collect_exported`

Data type: `Any`

Determines whether to use exported resources.<br />
If you statically declare all of your backend servers, set this parameter to false to rely
on existing, declared balancer member resources. Also, use apache::balancermember with array
arguments.<br />
To dynamically declare backend servers via exported resources collected on a central node,
set this parameter to true to collect the balancer member resources exported by the balancer
member nodes.<br />
If you don't use exported resources, a single Puppet run configures all balancer members. If
you use exported resources, Puppet has to run on the balanced nodes first, then run on the
balancer.

Default value: `true`

##### `options`

Data type: `Any`

Specifies an array of [options](https://httpd.apache.org/docs/current/mod/mod_proxy.html#balancermember)
after the balancer URL, and accepts any key-value pairs available to `ProxyPass`.

Default value: []

### apache::balancermember

Sets up a balancer member inside a listening service configuration block in
the load balancer's `apache.cfg`.

This type will setup a balancer member inside a listening service
configuration block in /etc/apache/apache.cfg on the load balancer.
Currently it only has the ability to specify the instance name, url and an
array of options. More features can be added as needed. The best way to
implement this is to export this resource for all apache balancer member
servers, and then collect them on the main apache load balancer.

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and
uses storeconfigs on the Puppet Master to export/collect resources
from all balancer members.

#### Examples

##### 

```puppet
@@apache::balancermember { 'apache':
  balancer_cluster => 'puppet00',
  url              => "ajp://${::fqdn}:8009"
  options          => ['ping=5', 'disablereuse=on', 'retry=5', 'ttl=120'],
}
```

#### Parameters

The following parameters are available in the `apache::balancermember` defined type.

##### `name`

The title of the resource is arbitrary and only utilized in the concat
fragment name.

##### `balancer_cluster`

Data type: `Any`

The apache service's instance name (or, the title of the apache::balancer
resource). This must match up with a declared apache::balancer resource.

##### `url`

Data type: `Any`

The url used to contact the balancer member server.

Default value: "http://${::fqdn}/"

##### `options`

Data type: `Any`

Specifies an array of [options](https://httpd.apache.org/docs/current/mod/mod_proxy.html#balancermember)
after the URL, and accepts any key-value pairs available to `ProxyPass`.

Default value: []

### apache::custom_config

If the file is invalid and this defined type's `verify_config` parameter's value is
`true`, Puppet throws an error during a Puppet run.

#### Parameters

The following parameters are available in the `apache::custom_config` defined type.

##### `ensure`

Data type: `Enum['absent', 'present']`

Specifies whether the configuration file should be present.

Default value: 'present'

##### `confdir`

Data type: `Any`

Sets the directory in which Puppet places configuration files.

Default value: $::apache::confd_dir

##### `content`

Data type: `Any`

Sets the configuration file's content. The `content` and `source` parameters are exclusive
of each other.

Default value: `undef`

##### `filename`

Data type: `Any`

Sets the name of the file under `confdir` in which Puppet stores the configuration.

Default value: `undef`

##### `priority`

Data type: `Any`

Sets the configuration file's priority by prefixing its filename with this parameter's
numeric value, as Apache processes configuration files in alphanumeric order.<br />
To omit the priority prefix in the configuration file's name, set this parameter to `false`.

Default value: '25'

##### `source`

Data type: `Any`

Points to the configuration file's source. The `content` and `source` parameters are
exclusive of each other.

Default value: `undef`

##### `verify_command`

Data type: `Any`

Specifies the command Puppet uses to verify the configuration file. Use a fully qualified
command.<br />
This parameter is used only if the `verify_config` parameter's value is `true`. If the
`verify_command` fails, the Puppet run deletes the configuration file and raises an error,
but does not notify the Apache service.

Default value: $::apache::params::verify_command

##### `verify_config`

Data type: `Boolean`

Specifies whether to validate the configuration file before notifying the Apache service.

Default value: `true`

##### `owner`

Data type: `Any`

File owner of configuration file

Default value: `undef`

##### `group`

Data type: `Any`

File group of configuration file

Default value: `undef`

##### `file_mode`

Data type: `Any`

File mode of configuration file

Default value: `undef`

##### `show_diff`

Data type: `Boolean`

show_diff property for configuration file resource

Default value: `true`

### apache::fastcgi::server

Defines one or more external FastCGI servers to handle specific file types. Use this
defined type with `mod_fastcgi`.

#### Parameters

The following parameters are available in the `apache::fastcgi::server` defined type.

##### `host`

Data type: `Any`

Determines the FastCGI's hostname or IP address and TCP port number (1-65535).

Default value: '127.0.0.1:9000'

##### `timeout`

Data type: `Any`

Sets the number of seconds a [FastCGI](http://www.fastcgi.com/) application can be inactive before aborting the
request and logging the event at the error LogLevel. The inactivity timer applies only as
long as a connection is pending with the FastCGI application. If a request is queued to an
application, but the application doesn't respond by writing and flushing within this period,
the request is aborted. If communication is complete with the application but incomplete with
the client (the response is buffered), the timeout does not apply.

Default value: 15

##### `flush`

Data type: `Any`

Forces `mod_fastcgi` to write to the client as data is received from the
application. By default, `mod_fastcgi` buffers data in order to free the application
as quickly as possible.

Default value: `false`

##### `faux_path`

Data type: `Any`

Apache has FastCGI handle URIs that resolve to this filename. The path set in this
parameter does not have to exist in the local filesystem.

Default value: "/var/www/${name}.fcgi"

##### `fcgi_alias`

Data type: `Any`

Internally links actions with the FastCGI server. This alias must be unique.

Default value: "/${name}.fcgi"

##### `file_type`

Data type: `Any`

Sets the MIME `content-type` of the file to be processed by the FastCGI server.

Default value: 'application/x-httpd-php'

##### `pass_header`

Data type: `Any`



Default value: `undef`

### apache::listen

The `apache::vhost` class uses this defined type, and titles take the form
`<PORT>`, `<IPV4>:<PORT>`, or `<IPV6>:<PORT>`.

### apache::mod

Checks for or places the module's default configuration files in the Apache server's
`module` and `enable` directories. The default locations depend on your operating system.

#### Parameters

The following parameters are available in the `apache::mod` defined type.

##### `package`

Data type: `Any`

**Required**.<br />
Names the package Puppet uses to install the Apache module.

Default value: `undef`

##### `package_ensure`

Data type: `Any`

Determines whether Puppet ensures the Apache module should be installed.

Default value: 'present'

##### `lib`

Data type: `Any`

Defines the module's shared object name. Do not configure manually without special reason.

Default value: `undef`

##### `lib_path`

Data type: `Any`

Specifies a path to the module's libraries. Do not manually set this parameter
without special reason. The `path` parameter overrides this value.

Default value: $::apache::lib_path

##### `loadfile_name`

Data type: `Any`

Sets the filename for the module's `LoadFile` directive, which can also set
the module load order as Apache processes them in alphanumeric order.

Default value: `undef`

##### `id`

Data type: `Any`

Specifies the package id

Default value: `undef`

##### `loadfiles`

Data type: `Any`

Specifies an array of `LoadFile` directives.

Default value: `undef`

##### `path`

Data type: `Any`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

### apache::namevirtualhost

Adds all related directives to the `ports.conf` file in the Apache HTTPD configuration
directory. Titles can take the forms `\*`, `\*:\<PORT\>`, `\_default\_:\<PORT\>`,
`\<IP\>`, or `\<IP\>:\<PORT\>`.

### apache::vhost

The apache module allows a lot of flexibility in the setup and configuration of virtual hosts.
This flexibility is due, in part, to `vhost` being a defined resource type, which allows Apache
to evaluate it multiple times with different parameters.<br />
The `apache::vhost` defined type allows you to have specialized configurations for virtual hosts
that have requirements outside the defaults. You can set up a default virtual host within
the base `::apache` class, as well as set a customized virtual host as the default.
Customized virtual hosts have a lower numeric `priority` than the base class's, causing
Apache to process the customized virtual host first.<br />
The `apache::vhost` defined type uses `concat::fragment` to build the configuration file. To
inject custom fragments for pieces of the configuration that the defined type doesn't
inherently support, add a custom fragment.<br />
For the custom fragment's `order` parameter, the `apache::vhost` defined type uses multiples
of 10, so any `order` that isn't a multiple of 10 should work.<br />
> **Note:** When creating an `apache::vhost`, it cannot be named `default` or `default-ssl`,
because vhosts with these titles are always managed by the module. This means that you cannot
override `Apache::Vhost['default']`  or `Apache::Vhost['default-ssl]` resources. An optional
workaround is to create a vhost named something else, such as `my default`, and ensure that the
`default` and `default_ssl` vhosts are set to `false`:

#### Examples

##### 

```puppet
class { 'apache':
  default_vhost     => false,
  default_ssl_vhost => false,
}
```

#### Parameters

The following parameters are available in the `apache::vhost` defined type.

##### `apache_version`

Data type: `Any`

Apache's version number as a string, such as '2.2' or '2.4'.

Default value: $::apache::apache_version

##### `access_log`

Data type: `Boolean`

Determines whether to configure `*_access.log` directives (`*_file`,`*_pipe`, or `*_syslog`).

Default value: `true`

##### `access_log_env_var`

Data type: `Any`

Specifies that only requests with particular environment variables be logged.

Default value: `false`

##### `access_log_file`

Data type: `Any`

Sets the filename of the `*_access.log` placed in `logroot`. Given a virtual host ---for
instance, example.com--- it defaults to 'example.com_ssl.log' for
[SSL-encrypted](https://httpd.apache.org/docs/current/ssl/index.html) virtual hosts and
`example.com_access.log` for unencrypted virtual hosts.

Default value: `false`

##### `access_log_format`

Data type: `Any`

Specifies the use of either a `LogFormat` nickname or a custom-formatted string for the
access log.

Default value: `false`

##### `access_log_pipe`

Data type: `Any`

Specifies a pipe where Apache sends access log messages.

Default value: `false`

##### `access_log_syslog`

Data type: `Any`

Sends all access log messages to syslog.

Default value: `false`

##### `access_logs`

Data type: `Optional[Array]`

Allows you to give a hash that specifies the state of each of the `access_log_*`
directives shown above, i.e. `access_log_pipe` and `access_log_syslog`.

Default value: `undef`

##### `add_default_charset`

Data type: `Any`

Sets a default media charset value for the `AddDefaultCharset` directive, which is
added to `text/plain` and `text/html` responses.

Default value: `undef`

##### `add_listen`

Data type: `Any`

Determines whether the virtual host creates a `Listen` statement.<br />
Setting `add_listen` to `false` prevents the virtual host from creating a `Listen`
statement. This is important when combining virtual hosts that aren't passed an `ip`
parameter with those that are.

Default value: `true`

##### `use_optional_includes`

Data type: `Any`

Specifies whether Apache uses the `IncludeOptional` directive instead of `Include` for
`additional_includes` in Apache 2.4 or newer.

Default value: $::apache::use_optional_includes

##### `additional_includes`

Data type: `Any`

Specifies paths to additional static, virtual host-specific Apache configuration files.
You can use this parameter to implement a unique, custom configuration not supported by
this module.

Default value: []

##### `aliases`

Data type: `Any`

Passes a list of [hashes][hash] to the virtual host to create `Alias`, `AliasMatch`,
`ScriptAlias` or `ScriptAliasMatch` directives as per the `mod_alias` documentation.<br />
For example:
``` puppet
aliases => [
  { aliasmatch       => '^/image/(.*)\.jpg$',
    path             => '/files/jpg.images/$1.jpg',
  },
  { alias            => '/image',
    path             => '/ftp/pub/image',
  },
  { scriptaliasmatch => '^/cgi-bin(.*)',
    path             => '/usr/local/share/cgi-bin$1',
  },
  { scriptalias      => '/nagios/cgi-bin/',
    path             => '/usr/lib/nagios/cgi-bin/',
  },
  { alias            => '/nagios',
    path             => '/usr/share/nagios/html',
  },
],
```
For the `alias`, `aliasmatch`, `scriptalias` and `scriptaliasmatch` keys to work, each needs
a corresponding context, such as `<Directory /path/to/directory>` or
`<Location /some/location/here>`. Puppet creates the directives in the order specified in
the `aliases` parameter. As described in the `mod_alias` documentation, add more specific
`alias`, `aliasmatch`, `scriptalias` or `scriptaliasmatch` parameters before the more
general ones to avoid shadowing.<BR />
> **Note**: Use the `aliases` parameter instead of the `scriptaliases` parameter because
you can precisely control the order of various alias directives. Defining `ScriptAliases`
using the `scriptaliases` parameter means *all* `ScriptAlias` directives will come after
*all* `Alias` directives, which can lead to `Alias` directives shadowing `ScriptAlias`
directives. This often causes problems; for example, this could cause problems with Nagios.<BR />
If `apache::mod::passenger` is loaded and `PassengerHighPerformance` is `true`, the `Alias`
directive might not be able to honor the `PassengerEnabled => off` statement. See
[this article](http://www.conandalton.net/2010/06/passengerenabled-off-not-working.html) for details.

Default value: `undef`

##### `allow_encoded_slashes`

Data type: `Optional[Enum['on', 'off', 'nodecode']]`

Sets the `AllowEncodedSlashes` declaration for the virtual host, overriding the server
default. This modifies the virtual host responses to URLs with `\` and `/` characters. The
default setting omits the declaration from the server configuration and selects the
Apache default setting of `Off`.

Default value: `undef`

##### `block`

Data type: `Any`

Specifies the list of things to which Apache blocks access. Valid options are: `scm` (which
blocks web access to `.svn`), `.git`, and `.bzr` directories.

Default value: []

##### `cas_attribute_prefix`

Data type: `Any`

Adds a header with the value of this header being the attribute values when SAML
validation is enabled.

Default value: `undef`

##### `cas_attribute_delimiter`

Data type: `Any`

Sets the delimiter between attribute values in the header created by `cas_attribute_prefix`.

Default value: `undef`

##### `cas_login_url`

Data type: `Any`

Sets the URL to which the module redirects users when they attempt to access a
CAS-protected resource and don't have an active session.

Default value: `undef`

##### `cas_root_proxied_as`

Data type: `Any`

Sets the URL end users see when access to this Apache server is proxied per vhost.
This URL should not include a trailing slash.

Default value: `undef`

##### `cas_scrub_request_headers`

Data type: `Any`

Remove inbound request headers that may have special meaning within mod_auth_cas.

Default value: `undef`

##### `cas_sso_enabled`

Data type: `Any`

Enables experimental support for single sign out (may mangle POST data).

Default value: `undef`

##### `cas_validate_saml`

Data type: `Any`

Parse response from CAS server for SAML.

Default value: `undef`

##### `cas_validate_url`

Data type: `Any`

Sets the URL to use when validating a client-presented ticket in an HTTP query string.

Default value: `undef`

##### `comment`

Data type: `Optional[Variant[String,Array[String]]]`

Adds comments to the header of the configuration file. Pass as string or an array of strings.
For example:
``` puppet
comment => "Account number: 123B",
```
Or:
``` puppet
comment => [
  "Customer: X",
  "Frontend domain: x.example.org",
]
```

Default value: `undef`

##### `custom_fragment`

Data type: `Optional[String]`

Passes a string of custom configuration directives to place at the end of the virtual
host configuration.

Default value: `undef`

##### `default_vhost`

Data type: `Boolean`

Sets a given `apache::vhost` defined type as the default to serve requests that do not
match any other `apache::vhost` defined types.

Default value: `false`

##### `directoryindex`

Data type: `Any`

Sets the list of resources to look for when a client requests an index of the directory
by specifying a '/' at the end of the directory name. See the `DirectoryIndex` directive
documentation for details.

Default value: ''

##### `docroot`

Data type: `Variant[Boolean,String]`

**Required**.<br />
Sets the `DocumentRoot` location, from which Apache serves files.<br />
If `docroot` and `manage_docroot` are both set to `false`, no `DocumentRoot` will be set
and the accompanying `<Directory /path/to/directory>` block will not be created.

##### `docroot_group`

Data type: `Any`

Sets group access to the `docroot` directory.

Default value: $::apache::params::root_group

##### `docroot_owner`

Data type: `Any`

Sets individual user access to the `docroot` directory.

Default value: 'root'

##### `docroot_mode`

Data type: `Any`

Sets access permissions for the `docroot` directory, in numeric notation.

Default value: `undef`

##### `manage_docroot`

Data type: `Any`

Determines whether Puppet manages the `docroot` directory.

Default value: `true`

##### `error_log`

Data type: `Boolean`

Specifies whether `*_error.log` directives should be configured.

Default value: `true`

##### `error_log_file`

Data type: `Any`

Points the virtual host's error logs to a `*_error.log` file. If this parameter is
undefined, Puppet checks for values in `error_log_pipe`, then `error_log_syslog`.<br />
If none of these parameters is set, given a virtual host `example.com`, Puppet defaults
to `$logroot/example.com_error_ssl.log` for SSL virtual hosts and
`$logroot/example.com_error.log` for non-SSL virtual hosts.

Default value: `undef`

##### `error_log_pipe`

Data type: `Any`

Specifies a pipe to send error log messages to.<br />
This parameter has no effect if the `error_log_file` parameter has a value. If neither
this parameter nor `error_log_file` has a value, Puppet then checks `error_log_syslog`.

Default value: `undef`

##### `error_log_syslog`

Data type: `Any`

Determines whether to send all error log messages to syslog.
This parameter has no effect if either of the `error_log_file` or `error_log_pipe`
parameters has a value. If none of these parameters has a value, given a virtual host
`example.com`, Puppet defaults to `$logroot/example.com_error_ssl.log` for SSL virtual
hosts and `$logroot/example.com_error.log` for non-SSL virtual hosts.

Default value: `undef`

##### `error_documents`

Data type: `Any`

A list of hashes which can be used to override the
[ErrorDocument](https://httpd.apache.org/docs/current/mod/core.html#errordocument)
settings for this virtual host.<br />
For example:
``` puppet
apache::vhost { 'sample.example.net':
  error_documents => [
    { 'error_code' => '503', 'document' => '/service-unavail' },
    { 'error_code' => '407', 'document' => 'https://example.com/proxy/login' },
  ],
}
```

Default value: []

##### `ensure`

Data type: `Enum['absent', 'present']`

Specifies if the virtual host is present or absent.<br />

Default value: 'present'

##### `fallbackresource`

Data type: `Optional[Variant[Stdlib::Absolutepath, Enum['disabled']]]`

Sets the [FallbackResource](https://httpd.apache.org/docs/current/mod/mod_dir.html#fallbackresource)
directive, which specifies an action to take for any URL that doesn't map to anything in
your filesystem and would otherwise return 'HTTP 404 (Not Found)'. Values must either begin
with a `/` or be `disabled`.

Default value: `undef`

##### `fastcgi_server`

Data type: `Any`

Specify an external FastCGI server to manage a connection to.

Default value: `undef`

##### `fastcgi_socket`

Data type: `Any`

Specify the socket that will be used to communicate with an external FastCGI server.

Default value: `undef`

##### `fastcgi_idle_timeout`

Data type: `Any`

If using fastcgi, this option sets the timeout for the server to respond.

Default value: `undef`

##### `fastcgi_dir`

Data type: `Any`

Specify an internal FastCGI directory that is to be managed.

Default value: `undef`

##### `filters`

Data type: `Any`

[Filters](https://httpd.apache.org/docs/current/mod/mod_filter.html) enable smart,
context-sensitive configuration of output content filters.
``` puppet
apache::vhost { "$::fqdn":
  filters => [
    'FilterDeclare   COMPRESS',
    'FilterProvider  COMPRESS DEFLATE resp=Content-Type $text/html',
    'FilterChain     COMPRESS',
    'FilterProtocol  COMPRESS DEFLATE change=yes;byteranges=no',
  ],
}
```

Default value: `undef`

##### `h2_copy_files`

Data type: `Optional[Boolean]`

Sets the [H2CopyFiles](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2copyfiles)
directive which influences how the requestion process pass files to the main connection.

Default value: `undef`

##### `h2_direct`

Data type: `Optional[Boolean]`

Sets the [H2Direct](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2direct)
directive which toggles the usage of the HTTP/2 Direct Mode.

Default value: `undef`

##### `h2_early_hints`

Data type: `Optional[Boolean]`

Sets the [H2EarlyHints](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2earlyhints)
directive which controls if HTTP status 103 interim responses are forwarded to
the client or not.

Default value: `undef`

##### `h2_max_session_streams`

Data type: `Optional[Integer]`

Sets the [H2MaxSessionStreams](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2maxsessionstreams)
directive which sets the maximum number of active streams per HTTP/2 session
that the server allows.

Default value: `undef`

##### `h2_modern_tls_only`

Data type: `Optional[Boolean]`

Sets the [H2ModernTLSOnly](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2moderntlsonly)
directive which toggles the security checks on HTTP/2 connections in TLS mode.

Default value: `undef`

##### `h2_push`

Data type: `Optional[Boolean]`

Sets the [H2Push](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2push)
directive which toggles the usage of the HTTP/2 server push protocol feature.

Default value: `undef`

##### `h2_push_diary_size`

Data type: `Optional[Integer]`

Sets the [H2PushDiarySize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushdiarysize)
directive which toggles the maximum number of HTTP/2 server pushes that are
remembered per HTTP/2 connection.

Default value: `undef`

##### `h2_push_priority`

Data type: `Array[String]`

Sets the [H2PushPriority](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushpriority)
directive which defines the priority handling of pushed responses based on the
content-type of the response.

Default value: []

##### `h2_push_resource`

Data type: `Array[String]`

Sets the [H2PushResource](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushresource)
directive which declares resources for early pushing to the client.

Default value: []

##### `h2_serialize_headers`

Data type: `Optional[Boolean]`

Sets the [H2SerializeHeaders](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2serializeheaders)
directive which toggles if HTTP/2 requests are serialized in HTTP/1.1
format for processing by httpd core.

Default value: `undef`

##### `h2_stream_max_mem_size`

Data type: `Optional[Integer]`

Sets the [H2StreamMaxMemSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2streammaxmemsize)
directive which sets the maximum number of outgoing data bytes buffered in
memory for an active stream.

Default value: `undef`

##### `h2_tls_cool_down_secs`

Data type: `Optional[Integer]`

Sets the [H2TLSCoolDownSecs](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2tlscooldownsecs)
directive which sets the number of seconds of idle time on a TLS connection
before the TLS write size falls back to a small (~1300 bytes) length.

Default value: `undef`

##### `h2_tls_warm_up_size`

Data type: `Optional[Integer]`

Sets the [H2TLSWarmUpSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2tlswarmupsize)
directive which sets the number of bytes to be sent in small TLS records (~1300
bytes) until doing maximum sized writes (16k) on https: HTTP/2 connections.

Default value: `undef`

##### `h2_upgrade`

Data type: `Optional[Boolean]`

Sets the [H2Upgrade](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2upgrade)
directive which toggles the usage of the HTTP/1.1 Upgrade method for switching
to HTTP/2.

Default value: `undef`

##### `h2_window_size`

Data type: `Optional[Integer]`

Sets the [H2WindowSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2windowsize)
directive which sets the size of the window that is used for flow control from
client to server and limits the amount of data the server has to buffer.

Default value: `undef`

##### `headers`

Data type: `Any`

Adds lines to replace, merge, or remove response headers. See
[Apache's mod_headers documentation](https://httpd.apache.org/docs/current/mod/mod_headers.html#header) for more information.

Default value: `undef`

##### `ip`

Data type: `Any`

Sets the IP address the virtual host listens on. By default, uses Apache's default behavior
of listening on all IPs.

Default value: `undef`

##### `ip_based`

Data type: `Boolean`

Enables an [IP-based](https://httpd.apache.org/docs/current/vhosts/ip-based.html) virtual
host. This parameter inhibits the creation of a NameVirtualHost directive, since those are
used to funnel requests to name-based virtual hosts.

Default value: `false`

##### `itk`

Data type: `Optional[Hash]`

Configures [ITK](http://mpm-itk.sesse.net/) in a hash.<br />
Usage typically looks something like:
``` puppet
apache::vhost { 'sample.example.net':
  docroot => '/path/to/directory',
  itk     => {
    user  => 'someuser',
    group => 'somegroup',
  },
}
```
Valid values are: a hash, which can include the keys:
* `user` + `group`
* `assignuseridexpr`
* `assigngroupidexpr`
* `maxclientvhost`
* `nice`
* `limituidrange` (Linux 3.5.0 or newer)
* `limitgidrange` (Linux 3.5.0 or newer)

Default value: `undef`

##### `action`

Data type: `Any`

Specifies whether you wish to configure mod_actions action directive which will
activate cgi-script when triggered by a request.

Default value: `undef`

##### `jk_mounts`

Data type: `Any`

Sets up a virtual host with `JkMount` and `JkUnMount` directives to handle the paths
for URL mapping between Tomcat and Apache.<br />
The parameter must be an array of hashes where each hash must contain the `worker`
and either the `mount` or `unmount` keys.<br />
Usage typically looks like:
``` puppet
apache::vhost { 'sample.example.net':
  jk_mounts => [
    { mount   => '/*',     worker => 'tcnode1', },
    { unmount => '/*.jpg', worker => 'tcnode1', },
  ],
}
```

Default value: `undef`

##### `http_protocol_options`

Data type: `Optional[Pattern[/^((Strict|Unsafe)?\s*(\b(Registered|Lenient)Methods)?\s*(\b(Allow0\.9|Require1\.0))?)$/]]`

Specifies the strictness of HTTP protocol checks.

Default value: `undef`

##### `keepalive`

Data type: `Optional[Enum['on', 'off']]`

Determines whether to enable persistent HTTP connections with the `KeepAlive` directive
for the virtual host. By default, the global, server-wide `KeepAlive` setting is in effect.<br />
Use the `keepalive_timeout` and `max_keepalive_requests` parameters to set relevant options
for the virtual host.

Default value: `undef`

##### `keepalive_timeout`

Data type: `Any`

Sets the `KeepAliveTimeout` directive for the virtual host, which determines the amount
of time to wait for subsequent requests on a persistent HTTP connection. By default, the
global, server-wide `KeepAlive` setting is in effect.<br />
This parameter is only relevant if either the global, server-wide `keepalive` parameter or
the per-vhost `keepalive` parameter is enabled.

Default value: `undef`

##### `max_keepalive_requests`

Data type: `Any`

Limits the number of requests allowed per connection to the virtual host. By default,
the global, server-wide `KeepAlive` setting is in effect.<br />
This parameter is only relevant if either the global, server-wide `keepalive` parameter or
the per-vhost `keepalive` parameter is enabled.

Default value: `undef`

##### `auth_kerb`

Data type: `Boolean`

Enable `mod_auth_kerb` parameters for a virtual host.<br />
Usage typically looks like:
``` puppet
apache::vhost { 'sample.example.net':
  auth_kerb              => `true`,
  krb_method_negotiate   => 'on',
  krb_auth_realms        => ['EXAMPLE.ORG'],
  krb_local_user_mapping => 'on',
  directories            => {
    path         => '/var/www/html',
    auth_name    => 'Kerberos Login',
    auth_type    => 'Kerberos',
    auth_require => 'valid-user',
  },
}
```

Default value: `false`

##### `krb_method_negotiate`

Data type: `Any`

Determines whether to use the Negotiate method.

Default value: 'on'

##### `krb_method_k5passwd`

Data type: `Any`

Determines whether to use password-based authentication for Kerberos v5.

Default value: 'on'

##### `krb_authoritative`

Data type: `Any`

If set to `off`, authentication controls can be passed on to another module.

Default value: 'on'

##### `krb_auth_realms`

Data type: `Any`

Specifies an array of Kerberos realms to use for authentication.

Default value: []

##### `krb_5keytab`

Data type: `Any`

Specifies the Kerberos v5 keytab file's location.

Default value: `undef`

##### `krb_local_user_mapping`

Data type: `Any`

Strips @REALM from usernames for further use.

Default value: `undef`

##### `krb_verify_kdc`

Data type: `Any`

This option can be used to disable the verification tickets against local keytab to prevent
KDC spoofing attacks.

Default value: 'on'

##### `krb_servicename`

Data type: `Any`

Specifies the service name that will be used by Apache for authentication. Corresponding
key of this name must be stored in the keytab.

Default value: 'HTTP'

##### `krb_save_credentials`

Data type: `Any`

This option enables credential saving functionality.

Default value: 'off'

##### `logroot`

Data type: `Any`

Specifies the location of the virtual host's logfiles.

Default value: $::apache::logroot

##### `logroot_ensure`

Data type: `Enum['directory', 'absent']`

Determines whether or not to remove the logroot directory for a virtual host.

Default value: 'directory'

##### `logroot_mode`

Data type: `Any`

Overrides the mode the logroot directory is set to. Do *not* grant write access to the
directory the logs are stored in without being aware of the consequences; for more
information, see [Apache's log security documentation](https://httpd.apache.org/docs/2.4/logs.html#security).

Default value: `undef`

##### `logroot_owner`

Data type: `Any`

Sets individual user access to the logroot directory.

Default value: `undef`

##### `logroot_group`

Data type: `Any`

Sets group access to the `logroot` directory.

Default value: `undef`

##### `log_level`

Data type: `Any`

Specifies the verbosity of the error log.

Default value: `undef`

##### `modsec_body_limit`

Data type: `Any`

Configures the maximum request body size (in bytes) ModSecurity accepts for buffering.

Default value: `undef`

##### `modsec_disable_vhost`

Data type: `Any`

Disables `mod_security` on a virtual host. Only valid if `apache::mod::security` is included.

Default value: `undef`

##### `modsec_disable_ids`

Data type: `Optional[Variant[Hash, Array]]`

Removes `mod_security` IDs from the virtual host.<br />
Also takes a hash allowing removal of an ID from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_ids => [ 90015, 90016 ],
}
```

``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_ids => { '/location1' => [ 90015, 90016 ] },
}
```

Default value: `undef`

##### `modsec_disable_ips`

Data type: `Any`

Specifies an array of IP addresses to exclude from `mod_security` rule matching.

Default value: `undef`

##### `modsec_disable_msgs`

Data type: `Optional[Variant[Hash, Array]]`

Array of mod_security Msgs to remove from the virtual host. Also takes a hash allowing
removal of an Msg from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_msgs => ['Blind SQL Injection Attack', 'Session Fixation Attack'],
}
```
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_msgs => { '/location1' => ['Blind SQL Injection Attack', 'Session Fixation Attack'] },
}
```

Default value: `undef`

##### `modsec_disable_tags`

Data type: `Optional[Variant[Hash, Array]]`

Array of mod_security Tags to remove from the virtual host. Also takes a hash allowing
removal of an Tag from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_tags => ['WEB_ATTACK/SQL_INJECTION', 'WEB_ATTACK/XSS'],
}
```
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_tags => { '/location1' => ['WEB_ATTACK/SQL_INJECTION', 'WEB_ATTACK/XSS'] },
}
```

Default value: `undef`

##### `modsec_audit_log_file`

Data type: `Any`

If set, it is relative to `logroot`.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### `modsec_audit_log_pipe`

Data type: `Any`

If `modsec_audit_log_pipe` is set, it should start with a pipe. Example
`|/path/to/mlogc /path/to/mlogc.conf`.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### `modsec_audit_log`

Data type: `Any`

If `modsec_audit_log` is `true`, given a virtual host ---for instance, example.com--- it
defaults to `example.com\_security\_ssl.log` for SSL-encrypted virtual hosts
and `example.com\_security.log` for unencrypted virtual hosts.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).<br />
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### `no_proxy_uris`

Data type: `Any`

Specifies URLs you do not want to proxy. This parameter is meant to be used in combination
with [`proxy_dest`](#proxy_dest).

Default value: []

##### `no_proxy_uris_match`

Data type: `Any`

This directive is equivalent to `no_proxy_uris`, but takes regular expressions.

Default value: []

##### `proxy_preserve_host`

Data type: `Any`

Sets the [ProxyPreserveHost Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypreservehost).<br />
Setting this parameter to `true` enables the `Host:` line from an incoming request to be
proxied to the host instead of hostname. Setting it to `false` sets this directive to 'Off'.

Default value: `false`

##### `proxy_add_headers`

Data type: `Any`

Sets the [ProxyAddHeaders Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyaddheaders).<br />
This parameter controlls whether proxy-related HTTP headers (X-Forwarded-For,
X-Forwarded-Host and X-Forwarded-Server) get sent to the backend server.

Default value: `undef`

##### `proxy_error_override`

Data type: `Any`

Sets the [ProxyErrorOverride Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyerroroverride).
This directive controls whether Apache should override error pages for proxied content.

Default value: `false`

##### `options`

Data type: `Any`

Sets the `Options` for the specified virtual host. For example:
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  options => ['Indexes','FollowSymLinks','MultiViews'],
}
```
> **Note**: If you use the `directories` parameter of `apache::vhost`, 'Options',
'Override', and 'DirectoryIndex' are ignored because they are parameters within `directories`.

Default value: ['Indexes','FollowSymLinks','MultiViews']

##### `override`

Data type: `Any`

Sets the overrides for the specified virtual host. Accepts an array of
[AllowOverride](https://httpd.apache.org/docs/current/mod/core.html#allowoverride) arguments.

Default value: ['None']

##### `passenger_enabled`

Data type: `Optional[Boolean]`

Sets the value for the [PassengerEnabled](http://www.modrails.com/documentation/Users%20guide%20Apache.html#PassengerEnabled)
directive to `on` or `off`. Requires `apache::mod::passenger` to be included.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path              => '/path/to/directory',
      passenger_enabled => 'on',
    },
  ],
}
```
> **Note:** There is an [issue](http://www.conandalton.net/2010/06/passengerenabled-off-not-working.html)
using the PassengerEnabled directive with the PassengerHighPerformance directive.

Default value: `undef`

##### `passenger_base_uri`

Data type: `Optional[String]`

Sets [PassengerBaseURI](https://www.phusionpassenger.com/library/config/apache/reference/#passengerbase_rui),
 to specify that the given URI is a distinct application served by Passenger.

Default value: `undef`

##### `passenger_ruby`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerRuby](https://www.phusionpassenger.com/library/config/apache/reference/#passengerruby),
specifying the Ruby interpreter to use when serving the relevant web applications.

Default value: `undef`

##### `passenger_python`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerPython](https://www.phusionpassenger.com/library/config/apache/reference/#passengerpython),
specifying the Python interpreter to use when serving the relevant web applications.

Default value: `undef`

##### `passenger_nodejs`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the [`PassengerNodejs`](https://www.phusionpassenger.com/library/config/apache/reference/#passengernodejs),
specifying Node.js command to use when serving the relevant web applications.

Default value: `undef`

##### `passenger_meteor_app_settings`

Data type: `Optional[String]`

Sets [PassengerMeteorAppSettings](https://www.phusionpassenger.com/library/config/apache/reference/#passengermeteorappsettings),
specifying a JSON file with settings for the application when using a Meteor
application in non-bundled mode.

Default value: `undef`

##### `passenger_app_env`

Data type: `Optional[String]`

Sets [PassengerAppEnv](https://www.phusionpassenger.com/library/config/apache/reference/#passengerappenv),
the environment for the Passenger application. If not specified, defaults to the global
setting or 'production'.

Default value: `undef`

##### `passenger_app_root`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerRoot](https://www.phusionpassenger.com/library/config/apache/reference/#passengerapproot),
the location of the Passenger application root if different from the DocumentRoot.

Default value: `undef`

##### `passenger_app_group_name`

Data type: `Optional[String]`

Sets [PassengerAppGroupName](https://www.phusionpassenger.com/library/config/apache/reference/#passengerappgroupname),
 the name of the application group that the current application should belong to.

Default value: `undef`

##### `passenger_app_type`

Data type: `Optional[Enum['meteor', 'node', 'rack', 'wsgi']]`

Sets [PassengerAppType](https://www.phusionpassenger.com/library/config/apache/reference/#passengerapptype),
 to force Passenger to recognize the application as a specific type.

Default value: `undef`

##### `passenger_startup_file`

Data type: `Optional[String]`

Sets the [PassengerStartupFile](https://www.phusionpassenger.com/library/config/apache/reference/#passengerstartupfile)
path. This path is relative to the application root.

Default value: `undef`

##### `passenger_restart_dir`

Data type: `Optional[String]`

Sets the [PassengerRestartDir](https://www.phusionpassenger.com/library/config/apache/reference/#passengerrestartdir)
 to customize the directory in which `restart.txt` is searched for.

Default value: `undef`

##### `passenger_spawn_method`

Data type: `Optional[Enum['direct', 'smart']]`

Sets [PassengerSpawnMethod](https://www.phusionpassenger.com/library/config/apache/reference/#passengerspawnmethod),
whether Passenger spawns applications directly, or using a prefork copy-on-write mechanism.

Default value: `undef`

##### `passenger_load_shell_envvars`

Data type: `Optional[Boolean]`

Sets [PassengerLoadShellEnvvars](https://www.phusionpassenger.com/library/config/apache/reference/#passengerloadshellenvvars),
to enable or disable the loading of shell environment variables before spawning the application.

Default value: `undef`

##### `passenger_rolling_restarts`

Data type: `Optional[Boolean]`

Sets [PassengerRollingRestarts](https://www.phusionpassenger.com/library/config/apache/reference/#passengerrollingrestarts),
to enable or disable support for zero-downtime application restarts through `restart.txt`.

Default value: `undef`

##### `passenger_resist_deployment_errors`

Data type: `Optional[Boolean]`

Sets [PassengerResistDeploymentErrors](https://www.phusionpassenger.com/library/config/apache/reference/#passengerresistdeploymenterrors),
to enable or disable resistance against deployment errors.

Default value: `undef`

##### `passenger_user`

Data type: `Optional[String]`

Sets [PassengerUser](https://www.phusionpassenger.com/library/config/apache/reference/#passengeruser),
the running user for sandboxing applications.

Default value: `undef`

##### `passenger_group`

Data type: `Optional[String]`

Sets [PassengerGroup](https://www.phusionpassenger.com/library/config/apache/reference/#passengergroup),
the running group for sandboxing applications.

Default value: `undef`

##### `passenger_friendly_error_pages`

Data type: `Optional[Boolean]`

Sets [PassengerFriendlyErrorPages](https://www.phusionpassenger.com/library/config/apache/reference/#passengerfriendlyerrorpages),
which can display friendly error pages whenever an application fails to start. This
friendly error page presents the startup error message, some suggestions for solving
the problem, a backtrace and a dump of the environment variables.

Default value: `undef`

##### `passenger_min_instances`

Data type: `Optional[Integer]`

Sets [PassengerMinInstances](https://www.phusionpassenger.com/library/config/apache/reference/#passengermininstances),
the minimum number of application processes to run.

Default value: `undef`

##### `passenger_max_instances`

Data type: `Optional[Integer]`

Sets [PassengerMaxInstances](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxinstances),
the maximum number of application processes to run.

Default value: `undef`

##### `passenger_max_preloader_idle_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxPreloaderIdleTime](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxpreloaderidletime),
the maximum amount of time the preloader waits before shutting down an idle process.

Default value: `undef`

##### `passenger_force_max_concurrent_requests_per_process`

Data type: `Optional[Integer]`

Sets [PassengerForceMaxConcurrentRequestsPerProcess](https://www.phusionpassenger.com/library/config/apache/reference/#passengerforcemaxconcurrentrequestsperprocess),
the maximum amount of concurrent requests the application can handle per process.

Default value: `undef`

##### `passenger_start_timeout`

Data type: `Optional[Integer]`

Sets [PassengerStartTimeout](https://www.phusionpassenger.com/library/config/apache/reference/#passengerstarttimeout),
the timeout for the application startup.

Default value: `undef`

##### `passenger_concurrency_model`

Data type: `Optional[Enum['process', 'thread']]`

Sets [PassengerConcurrencyModel](https://www.phusionpassenger.com/library/config/apache/reference/#passengerconcurrencyodel),
to specify the I/O concurrency model that should be used for Ruby application processes.
Passenger supports two concurrency models:<br />
* `process` – single-threaded, multi-processed I/O concurrency.
* `thread` – multi-threaded, multi-processed I/O concurrency.

Default value: `undef`

##### `passenger_thread_count`

Data type: `Optional[Integer]`

Sets [PassengerThreadCount](https://www.phusionpassenger.com/library/config/apache/reference/#passengerthreadcount),
the number of threads that Passenger should spawn per Ruby application process.<br />
This option only has effect if PassengerConcurrencyModel is `thread`.

Default value: `undef`

##### `passenger_max_requests`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequests](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxrequests),
the maximum number of requests an application process will process.

Default value: `undef`

##### `passenger_max_request_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestTime](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxrequesttime),
the maximum amount of time, in seconds, that an application process may take to
process a request.

Default value: `undef`

##### `passenger_memory_limit`

Data type: `Optional[Integer]`

Sets [PassengerMemoryLimit](https://www.phusionpassenger.com/library/config/apache/reference/#passengermemorylimit),
the maximum amount of memory that an application process may use, in megabytes.

Default value: `undef`

##### `passenger_stat_throttle_rate`

Data type: `Optional[Integer]`

Sets [PassengerStatThrottleRate](https://www.phusionpassenger.com/library/config/apache/reference/#passengerstatthrottlerate),
to set a limit, in seconds, on how often Passenger will perform it's filesystem checks.

Default value: `undef`

##### `passenger_pre_start`

Data type: `Optional[Variant[String,Array[String]]]`

Sets [PassengerPreStart](https://www.phusionpassenger.com/library/config/apache/reference/#passengerprestart),
the URL of the application if pre-starting is required.

Default value: `undef`

##### `passenger_high_performance`

Data type: `Optional[Boolean]`

Sets [PassengerHighPerformance](https://www.phusionpassenger.com/library/config/apache/reference/#passengerhighperformance),
to enhance performance in return for reduced compatibility.

Default value: `undef`

##### `passenger_buffer_upload`

Data type: `Optional[Boolean]`

Sets [PassengerBufferUpload](https://www.phusionpassenger.com/library/config/apache/reference/#passengerbufferupload),
to buffer HTTP client request bodies before they are sent to the application.

Default value: `undef`

##### `passenger_buffer_response`

Data type: `Optional[Boolean]`

Sets [PassengerBufferResponse](https://www.phusionpassenger.com/library/config/apache/reference/#passengerbufferresponse),
to buffer Happlication-generated responses.

Default value: `undef`

##### `passenger_error_override`

Data type: `Optional[Boolean]`

Sets [PassengerErrorOverride](https://www.phusionpassenger.com/library/config/apache/reference/#passengererroroverride),
to specify whether Apache will intercept and handle response with HTTP status codes of
400 and higher.

Default value: `undef`

##### `passenger_max_request_queue_size`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestQueueSize](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxrequestqueuesize),
to specify the maximum amount of requests that are allowed to queue whenever the maximum
concurrent request limit is reached. If the queue is already at this specified limit, then
Passenger immediately sends a "503 Service Unavailable" error to any incoming requests.<br />
A value of 0 means that the queue size is unbounded.

Default value: `undef`

##### `passenger_max_request_queue_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestQueueTime](https://www.phusionpassenger.com/library/config/apache/reference/#passengermaxrequestqueuetime),
to specify the maximum amount of time that requests are allowed to stay in the queue
whenever the maximum concurrent request limit is reached. If a request reaches this specified
limit, then Passenger immeaditly sends a "504 Gateway Timeout" error for that request.<br />
A value of 0 means that the queue time is unbounded.

Default value: `undef`

##### `passenger_sticky_sessions`

Data type: `Optional[Boolean]`

Sets [PassengerStickySessions](https://www.phusionpassenger.com/library/config/apache/reference/#passengerstickysessions),
to specify that, whenever possible, all requests sent by a client will be routed to the same
originating application process.

Default value: `undef`

##### `passenger_sticky_sessions_cookie_name`

Data type: `Optional[String]`

Sets [PassengerStickySessionsCookieName](https://www.phusionpassenger.com/library/config/apache/reference/#passengerstickysessionscookiename),
to specify the name of the sticky sessions cookie.

Default value: `undef`

##### `passenger_allow_encoded_slashes`

Data type: `Optional[Boolean]`

Sets [PassengerAllowEncodedSlashes](https://www.phusionpassenger.com/library/config/apache/reference/#passengerallowencodedslashes),
to allow URLs with encoded slashes. Please note that this feature will not work properly
unless Apache's `AllowEncodedSlashes` is also enabled.

Default value: `undef`

##### `passenger_debugger`

Data type: `Optional[Boolean]`

Sets [PassengerDebugger](https://www.phusionpassenger.com/library/config/apache/reference/#passengerdebugger),
to turn support for Ruby application debugging on or off.

Default value: `undef`

##### `passenger_lve_min_uid`

Data type: `Optional[Integer]`

Sets [PassengerLveMinUid](https://www.phusionpassenger.com/library/config/apache/reference/#passengerlveminuid),
to only allow the spawning of application processes with UIDs equal to, or higher than, this
specified value on LVE-enabled kernels.

Default value: `undef`

##### `php_values`

Data type: `Any`

Allows per-virtual host setting [`php_value`s](http://php.net/manual/en/configuration.changes.php).
These flags or values can be overwritten by a user or an application.
Within a vhost declaration:
``` puppet
  php_values    => [ 'include_path ".:/usr/local/example-app/include"' ],
```

Default value: {}

##### `php_flags`

Data type: `Any`

Allows per-virtual host setting [`php_flags\``](http://php.net/manual/en/configuration.changes.php).
These flags or values can be overwritten by a user or an application.

Default value: {}

##### `php_admin_values`

Data type: `Any`

Allows per-virtual host setting [`php_admin_value`](http://php.net/manual/en/configuration.changes.php).
These flags or values cannot be overwritten by a user or an application.

Default value: {}

##### `php_admin_flags`

Data type: `Any`

Allows per-virtual host setting [`php_admin_flag`](http://php.net/manual/en/configuration.changes.php).
These flags or values cannot be overwritten by a user or an application.

Default value: {}

##### `port`

Data type: `Any`

Sets the port the host is configured on. The module's defaults ensure the host listens
on port 80 for non-SSL virtual hosts and port 443 for SSL virtual hosts. The host only
listens on the port set in this parameter.

Default value: `undef`

##### `priority`

Data type: `Any`

Sets the relative load-order for Apache HTTPD VirtualHost configuration files.<br />
If nothing matches the priority, the first name-based virtual host is used. Likewise,
passing a higher priority causes the alphabetically first name-based virtual host to be
used if no other names match.<br />
> **Note:** You should not need to use this parameter. However, if you do use it, be
aware that the `default_vhost` parameter for `apache::vhost` passes a priority of '15'.<br />
To omit the priority prefix in file names, pass a priority of `false`.

Default value: `undef`

##### `protocols`

Data type: `Array[Enum['h2', 'h2c', 'http/1.1']]`

Sets the [Protocols](https://httpd.apache.org/docs/current/en/mod/core.html#protocols)
directive, which lists available protocols for the virutal host.

Default value: []

##### `protocols_honor_order`

Data type: `Optional[Boolean]`

Sets the [ProtocolsHonorOrder](https://httpd.apache.org/docs/current/en/mod/core.html#protocolshonororder)
directive which determines wether the order of Protocols sets precedence during negotiation.

Default value: `undef`

##### `proxy_dest`

Data type: `Any`

Specifies the destination address of a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) configuration.

Default value: `undef`

##### `proxy_pass`

Data type: `Any`

Specifies an array of `path => URI` values for a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass)
configuration. Optionally, parameters can be added as an array.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  proxy_pass => [
    { 'path' => '/a', 'url' => 'http://backend-a/' },
    { 'path' => '/b', 'url' => 'http://backend-b/' },
    { 'path' => '/c', 'url' => 'http://backend-a/c', 'params' => {'max'=>20, 'ttl'=>120, 'retry'=>300}},
    { 'path' => '/l', 'url' => 'http://backend-xy',
      'reverse_urls' => ['http://backend-x', 'http://backend-y'] },
    { 'path' => '/d', 'url' => 'http://backend-a/d',
      'params' => { 'retry' => '0', 'timeout' => '5' }, },
    { 'path' => '/e', 'url' => 'http://backend-a/e',
      'keywords' => ['nocanon', 'interpolate'] },
    { 'path' => '/f', 'url' => 'http://backend-f/',
      'setenv' => ['proxy-nokeepalive 1','force-proxy-request-1.0 1']},
    { 'path' => '/g', 'url' => 'http://backend-g/',
      'reverse_cookies' => [{'path' => '/g', 'url' => 'http://backend-g/',}, {'domain' => 'http://backend-g', 'url' => 'http:://backend-g',},], },
    { 'path' => '/h', 'url' => 'http://backend-h/h',
      'no_proxy_uris' => ['/h/admin', '/h/server-status'] },
  ],
}
```
* `reverse_urls`. *Optional.* This setting is useful when used with `mod_proxy_balancer`. Values: an array or string.
* `reverse_cookies`. *Optional.* Sets `ProxyPassReverseCookiePath` and `ProxyPassReverseCookieDomain`.
* `params`. *Optional.* Allows for ProxyPass key-value parameters, such as connection settings.
* `setenv`. *Optional.* Sets [environment variables](https://httpd.apache.org/docs/current/mod/mod_proxy.html#envsettings) for the proxy directive. Values: array.

Default value: `undef`

##### `proxy_dest_match`

Data type: `Any`

This directive is equivalent to `proxy_dest`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### `proxy_dest_reverse_match`

Data type: `Any`

Allows you to pass a ProxyPassReverse if `proxy_dest_match` is specified. See
[ProxyPassReverse](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreverse)
for details.

Default value: `undef`

##### `proxy_pass_match`

Data type: `Any`

This directive is equivalent to `proxy_pass`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### `redirect_dest`

Data type: `Any`

Specifies the address to redirect to.

Default value: `undef`

##### `redirect_source`

Data type: `Any`

Specifies the source URIs that redirect to the destination specified in `redirect_dest`.
If more than one item for redirect is supplied, the source and destination must be the same
length, and the items are order-dependent.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  redirect_source => ['/images','/downloads'],
  redirect_dest   => ['http://img.example.com/','http://downloads.example.com/'],
}
```

Default value: '/'

##### `redirect_status`

Data type: `Any`

Specifies the status to append to the redirect.
``` puppet
  apache::vhost { 'site.name.fdqn':
  …
  redirect_status => ['temp','permanent'],
}
```

Default value: `undef`

##### `redirectmatch_regexp`

Data type: `Any`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_status
and redirectmatch_dest.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  redirectmatch_status => ['404','404'],
  redirectmatch_regexp => ['\.git(/.*|$)/','\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1','http://www.example.com/$2'],
}
```

Default value: `undef`

##### `redirectmatch_status`

Data type: `Any`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_regexp
and redirectmatch_dest.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  redirectmatch_status => ['404','404'],
  redirectmatch_regexp => ['\.git(/.*|$)/','\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1','http://www.example.com/$2'],
}
```

Default value: `undef`

##### `redirectmatch_dest`

Data type: `Any`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_status
and redirectmatch_regexp.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  redirectmatch_status => ['404','404'],
  redirectmatch_regexp => ['\.git(/.*|$)/','\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1','http://www.example.com/$2'],
}
```

Default value: `undef`

##### `request_headers`

Data type: `Any`

Modifies collected [request headers](https://httpd.apache.org/docs/current/mod/mod_headers.html#requestheader)
in various ways, including adding additional request headers, removing request headers,
and so on.
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  request_headers => [
    'append MirrorID "mirror 12"',
    'unset MirrorID',
  ],
}
```

Default value: `undef`

##### `rewrites`

Data type: `Optional[Array]`

Creates URL rewrite rules. Expects an array of hashes.<br />
Valid Hash keys include `comment`, `rewrite_base`, `rewrite_cond`, `rewrite_rule`
or `rewrite_map`.<br />
For example, you can specify that anyone trying to access index.html is served welcome.html
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  rewrites => [ { rewrite_rule => ['^index\.html$ welcome.html'] } ]
}
```
The parameter allows rewrite conditions that, when `true`, execute the associated rule.
For instance, if you wanted to rewrite URLs only if the visitor is using IE
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  rewrites => [
    {
      comment      => 'redirect IE',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^MSIE'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
  ],
}
```
You can also apply multiple conditions. For instance, rewrite index.html to welcome.html
only when the browser is Lynx or Mozilla (version 1 or 2)
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  rewrites => [
    {
      comment      => 'Lynx or Mozilla v1/2',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^Lynx/ [OR]', '%{HTTP_USER_AGENT} ^Mozilla/[12]'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
  ],
}
```
Multiple rewrites and conditions are also possible
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  rewrites => [
    {
      comment      => 'Lynx or Mozilla v1/2',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^Lynx/ [OR]', '%{HTTP_USER_AGENT} ^Mozilla/[12]'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
    {
      comment      => 'Internet Explorer',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^MSIE'],
      rewrite_rule => ['^index\.html$ /index.IE.html [L]'],
    },
    {
      rewrite_base => /apps/,
      rewrite_rule => ['^index\.cgi$ index.php', '^index\.html$ index.php', '^index\.asp$ index.html'],
    },
    { comment      => 'Rewrite to lower case',
      rewrite_cond => ['%{REQUEST_URI} [A-Z]'],
      rewrite_map  => ['lc int:tolower'],
      rewrite_rule => ['(.*) ${lc:$1} [R=301,L]'],
    },
  ],
}
```
Refer to the [`mod_rewrite` documentation](https://httpd.apache.org/docs/2.4/mod/mod_rewrite.html)
for more details on what is possible with rewrite rules and conditions.<br />
> **Note**: If you include rewrites in your directories, also include `apache::mod::rewrite`
and consider setting the rewrites using the `rewrites` parameter in `apache::vhost` rather
than setting the rewrites in the virtual host's directories.

Default value: `undef`

##### `rewrite_base`

Data type: `Any`

The parameter [`rewrite_base`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewritebase)
specifies the URL prefix to be used for per-directory (htaccess) RewriteRule directives
that substitue a relative path.

Default value: `undef`

##### `rewrite_rule`

Data type: `Any`

The parameter [`rewrite_rile`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewriterule)
allows the user to define the rules that will be used by the rewrite engine.

Default value: `undef`

##### `rewrite_cond`

Data type: `Any`

The parameter [`rewrite_cond`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewritecond)
defines a rule condition, that when satisfied will implement that rule within the
rewrite engine.

Default value: `undef`

##### `rewrite_inherit`

Data type: `Any`

Determines whether the virtual host inherits global rewrite rules.<br />
Rewrite rules may be specified globally (in `$conf_file` or `$confd_dir`) or
inside the virtual host `.conf` file. By default, virtual hosts do not inherit
global settings. To activate inheritance, specify the `rewrites` parameter and set
`rewrite_inherit` parameter to `true`:
``` puppet
apache::vhost { 'site.name.fdqn':
  …
  rewrites => [
    <rules>,
  ],
  rewrite_inherit => `true`,
}
```
> **Note**: The `rewrites` parameter is **required** for this to have effect<br />
Apache activates global `Rewrite` rules inheritance if the virtual host files contains
the following directives:
``` ApacheConf
RewriteEngine On
RewriteOptions Inherit
```
Refer to the official [`mod_rewrite`](https://httpd.apache.org/docs/2.2/mod/mod_rewrite.html)
documentation, section "Rewriting in Virtual Hosts".

Default value: `false`

##### `scriptalias`

Data type: `Any`

Defines a directory of CGI scripts to be aliased to the path '/cgi-bin', such as
'/usr/scripts'.

Default value: `undef`

##### `scriptaliases`

Data type: `Any`

> **Note**: This parameter is deprecated in favor of the `aliases` parameter.<br />
Passes an array of hashes to the virtual host to create either ScriptAlias or
ScriptAliasMatch statements per the `mod_alias` documentation.
``` puppet
scriptaliases => [
  {
    alias => '/myscript',
    path  => '/usr/share/myscript',
  },
  {
    aliasmatch => '^/foo(.*)',
    path       => '/usr/share/fooscripts$1',
  },
  {
    aliasmatch => '^/bar/(.*)',
    path       => '/usr/share/bar/wrapper.sh/$1',
  },
  {
    alias => '/neatscript',
    path  => '/usr/share/neatscript',
  },
]
```
The ScriptAlias and ScriptAliasMatch directives are created in the order specified.
As with [Alias and AliasMatch](#aliases) directives, specify more specific aliases
before more general ones to avoid shadowing.

Default value: []

##### `serveradmin`

Data type: `Any`

Specifies the email address Apache displays when it renders one of its error pages.

Default value: `undef`

##### `serveraliases`

Data type: `Any`

Sets the [ServerAliases](https://httpd.apache.org/docs/current/mod/core.html#serveralias)
of the site.

Default value: []

##### `servername`

Data type: `Any`

Sets the servername corresponding to the hostname you connect to the virtual host at.

Default value: $name

##### `setenv`

Data type: `Any`

Used by HTTPD to set environment variables for virtual hosts.<br />
Example:
``` puppet
apache::vhost { 'setenv.example.com':
  setenv => ['SPECIAL_PATH /foo/bin'],
}
```

Default value: []

##### `setenvif`

Data type: `Any`

Used by HTTPD to conditionally set environment variables for virtual hosts.

Default value: []

##### `setenvifnocase`

Data type: `Any`

Used by HTTPD to conditionally set environment variables for virtual hosts (caseless matching).

Default value: []

##### `suexec_user_group`

Data type: `Optional[Pattern[/^[\w-]+ [\w-]+$/]]`

Allows the spcification of user and group execution privileges for CGI programs through
inclusion of the `mod_suexec` module.

Default value: `undef`

##### `suphp_addhandler`

Data type: `Any`

Sets up a virtual host with [suPHP](http://suphp.org/DocumentationView.html?file=apache/CONFIG)
working together with suphp_configpath and suphp_engine.<br />
An example virtual host configuration with suPHP:
``` puppet
apache::vhost { 'suphp.example.com':
  port             => '80',
  docroot          => '/home/appuser/myphpapp',
  suphp_addhandler => 'x-httpd-php',
  suphp_engine     => 'on',
  suphp_configpath => '/etc/php5/apache2',
  directories      => { path => '/home/appuser/myphpapp',
    'suphp'        => { user => 'myappuser', group => 'myappgroup' },
  }
}
```

Default value: $::apache::params::suphp_addhandler

##### `suphp_configpath`

Data type: `Any`

Sets up a virtual host with [suPHP](http://suphp.org/DocumentationView.html?file=apache/CONFIG)
working together with suphp_addhandler and suphp_engine.<br />
An example virtual host configuration with suPHP:
``` puppet
apache::vhost { 'suphp.example.com':
  port             => '80',
  docroot          => '/home/appuser/myphpapp',
  suphp_addhandler => 'x-httpd-php',
  suphp_engine     => 'on',
  suphp_configpath => '/etc/php5/apache2',
  directories      => { path => '/home/appuser/myphpapp',
    'suphp'        => { user => 'myappuser', group => 'myappgroup' },
  }
}
```

Default value: $::apache::params::suphp_configpath

##### `suphp_engine`

Data type: `Enum['on', 'off']`

Sets up a virtual host with [suPHP](http://suphp.org/DocumentationView.html?file=apache/CONFIG)
working together with suphp_configpath and suphp_addhandler.<br />
An example virtual host configuration with suPHP:
``` puppet
apache::vhost { 'suphp.example.com':
  port             => '80',
  docroot          => '/home/appuser/myphpapp',
  suphp_addhandler => 'x-httpd-php',
  suphp_engine     => 'on',
  suphp_configpath => '/etc/php5/apache2',
  directories      => { path => '/home/appuser/myphpapp',
    'suphp'        => { user => 'myappuser', group => 'myappgroup' },
  }
}
```

Default value: $::apache::params::suphp_engine

##### `vhost_name`

Data type: `Any`

Enables name-based virtual hosting. If no IP is passed to the virtual host, but the
virtual host is assigned a port, then the virtual host name is `vhost_name:port`.
If the virtual host has no assigned IP or port, the virtual host name is set to the
title of the resource.

Default value: '*'

##### `virtual_docroot`

Data type: `Any`

Sets up a virtual host with a wildcard alias subdomain mapped to a directory with the
same name. For example, `http://example.com` would map to `/var/www/example.com`.
``` puppet
apache::vhost { 'subdomain.loc':
  vhost_name      => '*',
  port            => '80',
  virtual_docroot => '/var/www/%-2+',
  docroot         => '/var/www',
  serveraliases   => ['*.loc',],
}
```

Default value: `false`

##### `wsgi_daemon_process`

Data type: `Optional[Variant[String,Hash]]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process_options, wsgi_process_group,
wsgi_script_aliases and wsgi_pass_authorization.<br />
A hash that sets the name of the WSGI daemon, accepting
[certain keys](http://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIDaemonProcess.html).<br />
An example virtual host configuration with WSGI:
``` puppet
apache::vhost { 'wsgi.example.com':
  port                        => '80',
  docroot                     => '/var/www/pythonapp',
  wsgi_daemon_process         => 'wsgi',
  wsgi_daemon_process_options =>
    { processes    => '2',
      threads      => '15',
      display-name => '%{GROUP}',
    },
  wsgi_process_group          => 'wsgi',
  wsgi_script_aliases         => { '/' => '/var/www/demo.wsgi' },
  wsgi_chunked_request        => 'On',
}
```

Default value: `undef`

##### `wsgi_daemon_process_options`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_process_group,
wsgi_script_aliases and wsgi_pass_authorization.<br />
Sets the group ID that the virtual host runs under.

Default value: `undef`

##### `wsgi_application_group`

Data type: `Any`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIApplicationGroup directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIApplicationGroup.html),
thus allowing you to specify which application group the WSGI application belongs to,
with all WSGI applications within the same group executing within the context of the
same Python sub interpreter.

Default value: `undef`

##### `wsgi_import_script`

Data type: `Any`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIImportScript directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIImportScript.html),
which can be used in order to specify a script file to be loaded upon a process starting.

Default value: `undef`

##### `wsgi_import_script_options`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIImportScript directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIImportScript.html),
which can be used in order to specify a script file to be loaded upon a process starting.<br />
Specifies the process and aplication groups of the script.

Default value: `undef`

##### `wsgi_chunked_request`

Data type: `Any`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIChunkedRequest directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIChunkedRequest.html),
allowing you to enable support for chunked request content.<br />
WSGI is technically incapable of supporting chunked request content without all chunked
request content having first been read in and buffered.

Default value: `undef`

##### `wsgi_process_group`

Data type: `Any`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options,
wsgi_script_aliases and wsgi_pass_authorization.<br />
Requires a hash of web paths to filesystem `.wsgi paths/`.

Default value: `undef`

##### `wsgi_script_aliases`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
Uses the WSGI application to handle authorization instead of Apache when set to `On`.<br />
For more information, see mod_wsgi's [WSGIPassAuthorization documentation](https://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIPassAuthorization.html).

Default value: `undef`

##### `wsgi_script_aliases_match`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
Uses the WSGI application to handle authorization instead of Apache when set to `On`.<br />
This directive is similar to `wsgi_script_aliases`, but makes use of regular expressions
in place of simple prefix matching.<br />
For more information, see mod_wsgi's [WSGIPassAuthorization documentation](https://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIPassAuthorization.html).

Default value: `undef`

##### `wsgi_pass_authorization`

Data type: `Optional[Enum['on', 'off', 'On', 'Off']]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group and
wsgi_script_aliases.<br />
Enables support for chunked requests.

Default value: `undef`

##### `directories`

Data type: `Optional[Variant[Hash, Array[Variant[Array,Hash]]]]`

The `directories` parameter within the `apache::vhost` class passes an array of hashes
to the virtual host to create [Directory](https://httpd.apache.org/docs/current/mod/core.html#directory),
[File](https://httpd.apache.org/docs/current/mod/core.html#files), and
[Location](https://httpd.apache.org/docs/current/mod/core.html#location) directive blocks.
These blocks take the form, `< Directory /path/to/directory>...< /Directory>`.<br />
The `path` key sets the path for the directory, files, and location blocks. Its value
must be a path for the `directory`, `files`, and `location` providers, or a regex for
the `directorymatch`, `filesmatch`, or `locationmatch` providers. Each hash passed to
`directories` **must** contain `path` as one of the keys.<br />
The `provider` key is optional. If missing, this key defaults to `directory`.
 Values: `directory`, `files`, `proxy`, `location`, `directorymatch`, `filesmatch`,
`proxymatch` or `locationmatch`. If you set `provider` to `directorymatch`, it
uses the keyword `DirectoryMatch` in the Apache config file.<br />
An example use of `directories`:
``` puppet
apache::vhost { 'files.example.net':
  docroot     => '/var/www/files',
  directories => [
    { 'path'     => '/var/www/files',
      'provider' => 'files',
      'deny'     => 'from all',
    },
  ],
}
```
> **Note:** At least one directory should match the `docroot` parameter. After you
start declaring directories, `apache::vhost` assumes that all required Directory blocks
will be declared. If not defined, a single default Directory block is created that matches
the `docroot` parameter.<br />
Available handlers, represented as keys, should be placed within the `directory`,
`files`, or `location` hashes. This looks like
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [ { path => '/path/to/directory', handler => value } ],
}
```
Any handlers you do not set in these hashes are considered `undefined` within Puppet and
are not added to the virtual host, resulting in the module using their default values.

Default value: `undef`

##### `custom_fragment`

Pass a string of custom configuration directives to be placed at the end of the directory
configuration.
``` puppet
apache::vhost { 'monitor':
  …
  directories => [
    {
      path => '/path/to/directory',
      custom_fragment => '
<Location /balancer-manager>
  SetHandler balancer-manager
  Order allow,deny
  Allow from all
</Location>
<Location /server-status>
  SetHandler server-status
  Order allow,deny
  Allow from all
</Location>
ProxyStatus On',
    },
  ]
}
```

Default value: `undef`

##### `error_documents`

An array of hashes used to override the [ErrorDocument](https://httpd.apache.org/docs/current/mod/core.html#errordocument)
settings for the directory.
``` puppet
apache::vhost { 'sample.example.net':
  directories => [
    { path            => '/srv/www',
      error_documents => [
        { 'error_code' => '503',
          'document'   => '/service-unavail',
        },
      ],
    },
  ],
}
```

Default value: []

##### `h2_copy_files`

Sets the [H2CopyFiles](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2copyfiles) directive.<br />
Note that you must declare `class {'apache::mod::http2': }` before using this directive.

Default value: `undef`

##### `h2_push_resource`

Sets the [H2PushResource](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushresource) directive.<br />
Note that you must declare `class {'apache::mod::http2': }` before using this directive.

Default value: []

##### `headers`

Adds lines for [Header](https://httpd.apache.org/docs/current/mod/mod_headers.html#header) directives.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => {
    path    => '/path/to/directory',
    headers => 'Set X-Robots-Tag "noindex, noarchive, nosnippet"',
  },
}
```

Default value: `undef`

##### `options`

Lists the [Options](https://httpd.apache.org/docs/current/mod/core.html#options) for the
given Directory block.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path    => '/path/to/directory',
      options => ['Indexes','FollowSymLinks','MultiViews'],
    },
  ],
}
```

Default value: ['Indexes','FollowSymLinks','MultiViews']

##### `shib_compat_valid_user`

Data type: `Optional[String]`

Default is Off, matching the behavior prior to this command's existence. Addresses a conflict
when using Shibboleth in conjunction with other auth/auth modules by restoring `standard`
Apache behavior when processing the `valid-user` and `user` Require rules. See the
[`mod_shib`documentation](https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPApacheConfig#NativeSPApacheConfig-Server/VirtualHostOptions),
and [NativeSPhtaccess](https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPhtaccess)
topic for more details. This key is disabled if `apache::mod::shib` is not defined.

Default value: `undef`

##### `ssl_options`

Data type: `Any`

String or list of [SSLOptions](https://httpd.apache.org/docs/current/mod/mod_ssl.html#ssloptions),
which configure SSL engine run-time options. This handler takes precedence over SSLOptions
set in the parent block of the virtual host.
``` puppet
apache::vhost { 'secure.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path        => '/path/to/directory',
      ssl_options => '+ExportCertData',
    },
    { path        => '/path/to/different/dir',
      ssl_options => ['-StdEnvVars', '+ExportCertData'],
    },
  ],
}
```

Default value: `undef`

##### `additional_includes`

Specifies paths to additional static, specific Apache configuration files in virtual
host directories.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path  => '/path/to/different/dir',
      additional_includes => ['/custom/path/includes', '/custom/path/another_includes',],
    },
  ],
}
```

Default value: []

##### `ssl`

Data type: `Boolean`

Enables SSL for the virtual host. SSL virtual hosts only respond to HTTPS queries.

Default value: `false`

##### `ssl_ca`

Data type: `Any`

Specifies the SSL certificate authority to be used to verify client certificates used
for authentication. You must also set `ssl_verify_client` to use this.

Default value: $::apache::default_ssl_ca

##### `ssl_cert`

Data type: `Any`

Specifies the SSL certification.

Default value: $::apache::default_ssl_cert

##### `ssl_protocol`

Data type: `Any`

Specifies [SSLProtocol](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslprotocol).
Expects an array or space separated string of accepted protocols.

Default value: `undef`

##### `ssl_cipher`

Data type: `Any`

Specifies [SSLCipherSuite](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslciphersuite).

Default value: `undef`

##### `ssl_honorcipherorder`

Data type: `Any`

Sets [SSLHonorCipherOrder](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslhonorcipherorder),
to cause Apache to use the server's preferred order of ciphers rather than the client's
preferred order.

Default value: `undef`

##### `ssl_certs_dir`

Data type: `Any`

Specifies the location of the SSL certification directory to verify client certs. Will not
be used unless `ssl_verify_client` is also set (see below).

Default value: $::apache::params::ssl_certs_dir

##### `ssl_chain`

Data type: `Any`

Specifies the SSL chain. This default works out of the box, but it must be updated in
the base `apache` class with your specific certificate information before being used in
production.

Default value: $::apache::default_ssl_chain

##### `ssl_crl`

Data type: `Any`

Specifies the certificate revocation list to use. (This default works out of the box but
must be updated in the base `apache` class with your specific certificate information
before being used in production.)

Default value: $::apache::default_ssl_crl

##### `ssl_crl_path`

Data type: `Any`

Specifies the location of the certificate revocation list to verify certificates for
client authentication with. (This default works out of the box but must be updated in
the base `apache` class with your specific certificate information before being used in
production.)

Default value: $::apache::default_ssl_crl_path

##### `ssl_crl_check`

Data type: `Any`

Sets the certificate revocation check level via the [SSLCARevocationCheck directive](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslcarevocationcheck)
for ssl client authentication. The default works out of the box but must be specified when
using CRLs in production. Only applicable to Apache 2.4 or higher; the value is ignored on
older versions.

Default value: $::apache::default_ssl_crl_check

##### `ssl_key`

Data type: `Any`

Specifies the SSL key.<br />
Defaults are based on your operating system. Default work out of the box but must be
updated in the base `apache` class with your specific certificate information before
being used in production.

Default value: $::apache::default_ssl_key

##### `ssl_verify_client`

Data type: `Any`

Sets the [SSLVerifyClient](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslverifyclient)
directive, which sets the certificate verification level for client authentication.
``` puppet
apache::vhost { 'sample.example.net':
  …
  ssl_verify_client => 'optional',
}
```

Default value: `undef`

##### `ssl_verify_depth`

Data type: `Any`

Sets the [SSLVerifyDepth](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslverifydepth)
directive, which specifies the maximum depth of CA certificates in client certificate
verification. You must set `ssl_verify_client` for it to take effect.
``` puppet
apache::vhost { 'sample.example.net':
  …
  ssl_verify_client => 'require',
  ssl_verify_depth => 1,
}
```

Default value: `undef`

##### `ssl_proxy_protocol`

Data type: `Any`

Sets the [SSLProxyProtocol](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyprotocol)
directive, which controls which SSL protocol flavors `mod_ssl` should use when establishing
its server environment for proxy. It connects to servers using only one of the provided
protocols.

Default value: `undef`

##### `ssl_proxy_verify`

Data type: `Optional[Enum['none', 'optional', 'require', 'optional_no_ca']]`

Sets the [SSLProxyVerify](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyverify)
directive, which configures certificate verification of the remote server when a proxy is
configured to forward requests to a remote SSL server.

Default value: `undef`

##### `ssl_proxy_verify_depth`

Data type: `Optional[Integer[0]]`

Sets the [SSLProxyVerifyDepth](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyverifydepth)
directive, which configures how deeply mod_ssl should verify before deciding that the
remote server does not have a valid certificate.<br />
A depth of 0 means that only self-signed remote server certificates are accepted,
the default depth of 1 means the remote server certificate can be self-signed or
signed by a CA that is directly known to the server.

Default value: `undef`

##### `ssl_proxy_cipher_suite`

Data type: `Any`

Sets the [SSLProxyCipherSuite](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyciphersuite)
directive, which controls cipher suites supported for ssl proxy traffic.

Default value: `undef`

##### `ssl_proxy_ca_cert`

Data type: `Any`

Sets the [SSLProxyCACertificateFile](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycacertificatefile)
directive, which specifies an all-in-one file where you can assemble the Certificates
of Certification Authorities (CA) whose remote servers you deal with. These are used
for Remote Server Authentication. This file should be a concatenation of the PEM-encoded
certificate files in order of preference.

Default value: `undef`

##### `ssl_proxy_machine_cert`

Data type: `Any`

Sets the [SSLProxyMachineCertificateFile](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxymachinecertificatefile)
directive, which specifies an all-in-one file where you keep the certs and keys used
for this server to authenticate itself to remote servers. This file should be a
concatenation of the PEM-encoded certificate files in order of preference.
``` puppet
apache::vhost { 'sample.example.net':
  …
  ssl_proxy_machine_cert => '/etc/httpd/ssl/client_certificate.pem',
}
```

Default value: `undef`

##### `ssl_proxy_check_peer_cn`

Data type: `Optional[Enum['on', 'off']]`

Sets the [SSLProxyCheckPeerCN](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeercn)
directive, which specifies whether the remote server certificate's CN field is compared
against the hostname of the request URL.

Default value: `undef`

##### `ssl_proxy_check_peer_name`

Data type: `Optional[Enum['on', 'off']]`

Sets the [SSLProxyCheckPeerName](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeername)
directive, which specifies whether the remote server certificate's CN field is compared
against the hostname of the request URL.

Default value: `undef`

##### `ssl_proxy_check_peer_expire`

Data type: `Optional[Enum['on', 'off']]`

Sets the [SSLProxyCheckPeerExpire](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeerexpire)
directive, which specifies whether the remote server certificate is checked for expiration
or not.

Default value: `undef`

##### `ssl_options`

Sets the [SSLOptions](https://httpd.apache.org/docs/current/mod/mod_ssl.html#ssloptions)
directive, which configures various SSL engine run-time options. This is the global
setting for the given virtual host and can be a string or an array.<br />
A string:
``` puppet
apache::vhost { 'sample.example.net':
  …
  ssl_options => '+ExportCertData',
}
```
An array:
``` puppet
apache::vhost { 'sample.example.net':
  …
  ssl_options => ['+StrictRequire', '+ExportCertData'],
}
```

Default value: `undef`

##### `ssl_openssl_conf_cmd`

Data type: `Any`

Sets the [SSLOpenSSLConfCmd](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslopensslconfcmd)
directive, which provides direct configuration of OpenSSL parameters.

Default value: `undef`

##### `ssl_proxyengine`

Data type: `Boolean`

Specifies whether or not to use [SSLProxyEngine](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyengine).

Default value: `false`

##### `ssl_stapling`

Data type: `Optional[Boolean]`

Specifies whether or not to use [SSLUseStapling](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslusestapling).
By default, uses what is set globally.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### `ssl_stapling_timeout`

Data type: `Any`

Can be used to set the [SSLStaplingResponderTimeout](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslstaplingrespondertimeout) directive.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### `ssl_stapling_return_errors`

Data type: `Any`

Can be used to set the [SSLStaplingReturnResponderErrors](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslstaplingreturnrespondererrors) directive.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### `use_canonical_name`

Data type: `Optional[Enum['On', 'on', 'Off', 'off', 'DNS', 'dns']]`

Specifies whether to use the [`UseCanonicalName directive`](https://httpd.apache.org/docs/2.4/mod/core.html#usecanonicalname),
which allows you to configure how the server determines it's own name and port.

Default value: `undef`

##### `define`

Data type: `Hash`

this lets you define configuration variables inside a vhost using [`Define`](https://httpd.apache.org/docs/2.4/mod/core.html#define),
these can then be used to replace configuration values. All Defines are Undefined at the end of the VirtualHost.

Default value: {}

##### `proxy_requests`

Data type: `Boolean`



Default value: `false`

### apache::vhost::custom

The `apache::vhost::custom` defined type is a thin wrapper around the `apache::custom_config` defined type, and simply overrides some of its default settings specific to the virtual host directory in Apache.

#### Parameters

The following parameters are available in the `apache::vhost::custom` defined type.

##### `content`

Data type: `Any`

Sets the configuration file's content.

##### `ensure`

Data type: `Any`

Specifies if the virtual host file is present or absent.

Default value: 'present'

##### `priority`

Data type: `Any`

Sets the relative load order for Apache HTTPD VirtualHost configuration files.

Default value: '25'

##### `verify_config`

Data type: `Any`

Specifies whether to validate the configuration file before notifying the Apache service.

Default value: `true`

### apache::vhost::fragment

Define a fragment within a vhost

#### Examples

##### With a vhost without priority

```puppet
include apache
apache::vhost { 'myvhost':
}
apache::vhost::fragment { 'myfragment':
  vhost   => 'myvhost',
  content => '# Foo',
}
```

##### With a vhost with priority

```puppet
include apache
apache::vhost { 'myvhost':
  priority => '42',
}
apache::vhost::fragment { 'myfragment':
  vhost    => 'myvhost',
  priority => '42',
  content  => '# Foo',
}
```

##### With a vhost with default vhost

```puppet
include apache
apache::vhost { 'myvhost':
  default_vhost => true,
}
apache::vhost::fragment { 'myfragment':
  vhost    => 'myvhost',
  priority => '10', # default_vhost implies priority 10
  content  => '# Foo',
}
```

##### Adding a fragment to the built in default vhost

```puppet
include apache
apache::vhost::fragment { 'myfragment':
  vhost    => 'default',
  priority => '15',
  content  => '# Foo',
}
```

#### Parameters

The following parameters are available in the `apache::vhost::fragment` defined type.

##### `vhost`

Data type: `String[1]`

The title of the vhost resource to append to

##### `priority`

Data type: `Any`

Set the priority to match the one `apache::vhost` sets. This must match the
one `apache::vhost` sets or else the concat fragment won't be found.

Default value: `undef`

##### `content`

Data type: `Optional[String]`

The content to put in the fragment. Only when it's non-empty the actual
fragment will be created.

Default value: `undef`

##### `order`

Data type: `Integer[0]`

The order to insert the fragment at

Default value: 900

## Resource types

### a2mod

Manage Apache 2 modules

#### Properties

The following properties are available in the `a2mod` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

#### Parameters

The following parameters are available in the `a2mod` type.

##### `name`

namevar

The name of the module to be managed

##### `lib`

The name of the .so library to be loaded

##### `identifier`

Module identifier string used by LoadModule. Default: module-name_module

## Functions

### apache::apache_pw_hash

Type: Ruby 4.x API

Currently uses SHA-hashes, because although this format is considered insecure, its the
most secure format supported by the most platforms.

#### `apache::apache_pw_hash(String[1] $password)`

Currently uses SHA-hashes, because although this format is considered insecure, its the
most secure format supported by the most platforms.

Returns: `String` Return's the hash of the input that was given.

##### `password`

Data type: `String[1]`

The input that is to be hashed.

### apache::bool2httpd

Type: Ruby 4.x API

Transform a supposed boolean to On or Off. Passes all other values through.

#### Examples

##### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

bool2httpd($trace_enable) # returns 'Off'
bool2httpd($server_signature) # returns 'mail'
bool2httpd(undef) # returns 'Off'
```

#### `apache::bool2httpd(Any $arg)`

The apache::bool2httpd function.

Returns: `Any` Will return either `On` or `Off` if given a boolean value. Return's a string of any
other given value.

##### Examples

###### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

bool2httpd($trace_enable) # returns 'Off'
bool2httpd($server_signature) # returns 'mail'
bool2httpd(undef) # returns 'Off'
```

##### `arg`

Data type: `Any`

The value to be converted into a string.

### apache::validate_apache_log_level

Type: Ruby 4.x API

As per http://httpd.apache.org/docs/current/mod/core.html#loglevel
    * validate_apache_loglevel('info')

Modules maybe specified with their own levels like these:
    * validate_apache_loglevel('warn ssl:info')
    * validate_apache_loglevel('warn mod_ssl.c:info')
    * validate_apache_loglevel('warn ssl_module:info')

Expected to be used from the main or vhost.
Might be used from directory too later as apache supports that

#### `apache::validate_apache_log_level(String $log_level)`

As per http://httpd.apache.org/docs/current/mod/core.html#loglevel
    * validate_apache_loglevel('info')

Modules maybe specified with their own levels like these:
    * validate_apache_loglevel('warn ssl:info')
    * validate_apache_loglevel('warn mod_ssl.c:info')
    * validate_apache_loglevel('warn ssl_module:info')

Expected to be used from the main or vhost.
Might be used from directory too later as apache supports that

Returns: `Any` Return's an error if the validation fails.

##### `log_level`

Data type: `String`

The string that is to be validated.

### apache_pw_hash

Type: Ruby 3.x API

Currently uses SHA-hashes, because although this format is considered insecure, its the
most secure format supported by the most platforms.

#### `apache_pw_hash(Any $password)`

Currently uses SHA-hashes, because although this format is considered insecure, its the
most secure format supported by the most platforms.

Returns: `Any` Return's the hash of the input that was given.

##### `password`

Data type: `Any`

The input that is to be hashed.

### bool2httpd

Type: Ruby 3.x API

Transform a supposed boolean to On or Off. Pass all other values through.

#### Examples

##### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

bool2httpd($trace_enable) # returns 'Off'
bool2httpd($server_signature) # returns 'mail'
bool2httpd(undef) # returns 'Off'
```

#### `bool2httpd(Any $arg)`

The bool2httpd function.

Returns: `Any` Will return either `On` or `Off` if given a boolean value. Return's a string of any
other given value.

##### Examples

###### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

bool2httpd($trace_enable) # returns 'Off'
bool2httpd($server_signature) # returns 'mail'
bool2httpd(undef) # returns 'Off'
```

##### `arg`

Data type: `Any`

The value to be converted into a string.

### validate_apache_log_level

Type: Ruby 3.x API

As per http://httpd.apache.org/docs/current/mod/core.html#loglevel
    * validate_apache_loglevel('info')
Modules maybe specified with their own levels like these:
    * validate_apache_loglevel('warn ssl:info')
    * validate_apache_loglevel('warn mod_ssl.c:info')
    * validate_apache_loglevel('warn ssl_module:info')
Expected to be used from the main or vhost.
Might be used from directory too later as apaceh supports that

#### `validate_apache_log_level(Any $log_level)`

As per http://httpd.apache.org/docs/current/mod/core.html#loglevel
    * validate_apache_loglevel('info')
Modules maybe specified with their own levels like these:
    * validate_apache_loglevel('warn ssl:info')
    * validate_apache_loglevel('warn mod_ssl.c:info')
    * validate_apache_loglevel('warn ssl_module:info')
Expected to be used from the main or vhost.
Might be used from directory too later as apaceh supports that

Returns: `Any` Return's an error if the validation fails.

##### `log_level`

Data type: `Any`

The string that is to be validated.

## Tasks

### init

Allows you to perform apache service functions

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[reload]`

Action to perform 

##### `service_name`

Data type: `Optional[String[1]]`

The name of the apache service 

