sphinx-mdinclude
================

[![Generated by attribution][attribution-badge]][attribution-url]


v0.6.2
------

Maintenance release

- Fix minimum docutils dependency requirement (#80)

```text
$ git shortlog -s v0.6.1...v0.6.2
     2	Amethyst Reese
     1	Emil van der Westhuizen
```


v0.6.1
------

Bugfix release

- Fix rendering of codespans within link text (#68)
- Added explicit dependency on Sphinx (#70)

```text
$ git shortlog -s v0.6.0...v0.6.1
     2	Amethyst Reese
     1	Peter Sobot
     5	dependabot[bot]
```


v0.6.0
------

Feature release

- Added support for mistune v3, dropped support for mistune v2 (#22, #46)
- Added strict type annotations and type checking (#62)
- Cleaned up legacy implementation from m2r (#58)

Many thanks to Julian Gilbey for the help upgrading to mistune v3!

```text
$ git shortlog -s v0.5.4...v0.6.0
     3	Amethyst Reese
     1	Julian Gilbey
     3	dependabot[bot]
```


v0.5.4
------

Maintenance release

- Better testing of sphinx extension and docutils directive (#48)
- Support fixes for docutils v0.21 (#55)
- Add support for Python 3.11 and 3.12 (#25, #39)
- Drop support for Python 3.7 (#25)

```text
$ git shortlog -s v0.5.3...v0.5.4
     8	Amethyst Reese
    16	dependabot[bot]
```


v0.5.3
------

Bugfix release

- Fix deprecation warnings from docutils (#11)
- Fix dependency ranges and validate compatibility
- Pin to mistune `2.x` in preparation for breaking changes in `3.0` (#15)
- Package migrated to the Omnilib Project

```text
$ git shortlog -s v0.5.2...v0.5.3
     5	Amethyst Reese
     2	Patrick Hoefler
     3	Samuel Giffard
```


v0.5.2
------

Maintenance release

- Add support for docutils `0.19` (#8)
- Enable building docs without installing package (#6)

```text
$ git shortlog -s v0.5.1...v0.5.2
     6	Amethyst Reese
```


v0.5.1
------

Bugfix release

- Fix autolinks (#3, #2)

```text
$ git shortlog -s v0.5.0...v0.5.1
     3	Amethyst Reese
     2	Tim Hatch
```


v0.5.0
------

Feature release

- Support for mistune 2.0 with major refactoring of codebase
- Removal of sphinx configuration options with better defaults

```text
$ git shortlog -s v0.5.0b1...v0.5.0
     3	Amethyst Reese
```


v0.5.0b1
--------

Feature release

- Support for mistune 2.0 with major refactoring of codebase
- Removal of sphinx configuration options with better defaults

```text
$ git shortlog -s v0.4.0...v0.5.0b1
     7	Amethyst Reese
```


v0.4.0
------

Feature release

- Forked project from m2r2
- Renamed package to `sphinx-mdinclude`
- Removes CLI to focus on Sphinx extension
- Remove mermaid extension support
- Overhauled documentation with less boilerplate
- Move tests into `sphinx_mdinclude` namespace
- Pin dependencies to mistune<1.0 and docutils<0.18
- Build using flit instead of setuptools
- Formatted with latest black and µsort

```text
$ git shortlog -s v0.4.0b1...v0.4.0
     4	Amethyst Reese
     1	dependabot[bot]
```


v0.4.0b1
--------

Beta release

* Forked project from m2r2
* Renamed package to `sphinx-mdinclude`
* Removes CLI to focus on Sphinx extension
* Overhauled documentation with less boilerplate
* Move tests into `sphinx_mdinclude` namespace
* Pin dependencies to mistune<1.0 and docutils<0.18
* Build using flit instead of setuptools
* Formatted with latest black and µsort

```text
$ git shortlog -s v0.2.7...v0.4.0b1
    18	Amethyst Reese
    10	CrossNox
     1	Ezequiel Rosas
     1	illes
     1	kalvdans
```


v0.3.1
------

* Fix argparse for python3.10

```text
$ git shortlog -s v0.3.0...v0.3.1
     1	Bas Nijholt
    13	CrossNox
     1	Daniel Caballero
     1	illes
     1	kalvdans
```


v0.3.0
------

* Add support for mermaid code
* Change bump for bump2version

```text
$ git shortlog -s v0.2.8...v0.3.0
     1	CrossNox
```


v0.2.8
------

* Fix bug that made multiple inline mathematical expressions fail to render

```text
$ git shortlog -s v0.2.5...v0.2.8
     1	CrossNox
```


v0.2.7
------

* Add official python3.9 support
* Fix classifiers

```text
$ git shortlog -s v0.2.6...v0.2.7
     2	CrossNox
```


v0.2.6
------

* Fix error for Sphinx3.3.0

```text
$ git shortlog -s v0.2.5...v0.2.6
     1	Bas Nijholt
     1	CrossNox
     1	Daniel Caballero
```


v0.2.5
------

* Update repo name in every reference

```text
$ git shortlog -s v0.2.4...v0.2.5
     1	CrossNox
```


v0.2.4
------

* Central versioning
* Add bump

```text
$ git shortlog -s v0.2.3...v0.2.4
     4	CrossNox
```


v0.2.3
------

* Fix https://github.com/miyakogi/m2r/issues/51
* Change `tox` for `nox`
* Add `pre-commit` hooks and fix styling

```text
$ git shortlog -s v0.2.1...v0.2.3
     9	CrossNox
```


v0.2.1
------

* Add `--disable-inline-math` and `m2r_disable_inline_math` sphinx option

```text
$ git shortlog -s v0.2.0...v0.2.1
     3	Morgan Willcock
     1	kyluca
     9	miyakogi
```


v0.2.0
------

* Add `start-line` and `end-line` option to `mdinclude` directive
* Add `anonymous_references` option ([#26](https://github.com/miyakogi/m2r/pull/26))

```text
$ git shortlog -s v0.1.15...v0.2.0
     3	Jake VanderPlas
    11	miyakogi
```


v0.1.15
-------

* Support Sphinx's doc/ref directives for relative links ([#16](https://github.com/miyakogi/m2r/pull/16))

```text
$ git shortlog -s v0.1.14...v0.1.15
     9	Ryan Lane
     7	miyakogi
```


v0.1.14
-------

* Implement markdown link with title

```text
$ git shortlog -s v0.1.13...v0.1.14
    11	miyakogi
```


v0.1.13
-------

* Catch up sphinx updates

```text
$ git shortlog -s v0.1.12...v0.1.13
     8	miyakogi
```


v0.1.12
-------

* Support multi byte characters for heading

```text
$ git shortlog -s v0.1.11...v0.1.12
     6	miyakogi
```


v0.1.11
-------

* Add metadata for sphinx
* Add `convert(src)` function, which is shortcut of `m2r.M2R()(src)`

```text
$ git shortlog -s v0.1.10...v0.1.11
    13	miyakogi
```


v0.1.10
-------

* Include CHANGES and test files in source distribution

```text
$ git shortlog -s v0.1.9...v0.1.10
     4	miyakogi
```


v0.1.9
------

* Print help when input_file is not specified on command-line

```text
$ git shortlog -s v0.1.8...v0.1.9
     5	miyakogi
```


v0.1.8
------

* Update metadata on setup.py

```text
$ git shortlog -s v0.1.7...v0.1.8
     6	miyakogi
```


v0.1.7
------

* Fix undefined name error (PR #5).

```text
$ git shortlog -s v0.1.6...v0.1.7
     1	Kai Fricke
     1	cclauss
     9	miyakogi
```


v0.1.6
------

* Drop python 3.3 support
* Improve image_link regex (PR #3)

```text
$ git shortlog -s v0.1.5...v0.1.6
     1	John W. O'Brien
     1	Nikola Forró
     6	miyakogi
```


v0.1.5
------

* Support multiple backticks in inline code, like: ```backticks (``) in code```

```text
$ git shortlog -s v0.1.4...v0.1.5
     6	miyakogi
```


v0.1.4
------

* Support indented directives/reST-comments
* Support role-name after backticks (`` `text`:role: style``)

```text
$ git shortlog -s v0.1.3...v0.1.4
     6	miyakogi
```


v0.1.3
------

* Remove extra escaped-spaces ('\ ')
    * before and after normal spaces
    * at the beginning of lines
    * before dots

```text
$ git shortlog -s v0.1.2...v0.1.3
     4	miyakogi
```


v0.1.2
------

* Add reST's `::` marker support
* Add options to disable emphasis by underscore (`_` or `__`)

```text
$ git shortlog -s v0.1.1...v0.1.2
     9	miyakogi
```


v0.1.1
------

* Fix Bug: when code or link is placed at the end of line, spaces to the next word is disappeared

```text
$ git shortlog -s v0.1...v0.1.1
     6	miyakogi
```


v0.1
----

First public release.

```text
$ git shortlog -s v0.1
    40	miyakogi
```

[attribution-badge]:
    https://img.shields.io/badge/generated%20by-attribution-informational
[attribution-url]: https://attribution.omnilib.dev
