/* Copyright (C) 2022-2025 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.filter;

import org.gprofng.analyzer.AnEnvironment;
import org.gprofng.mpmt.AnLocale;
import java.util.Formatter;
import javax.swing.border.LineBorder;

/**
 * @author thp
 */
public class KeywordsPanel extends javax.swing.JPanel {
  public KeywordsPanel(Filters filter) {
    initComponents();
    scrollPane.setBorder(new LineBorder(AnEnvironment.SPLIT_PANE_BORDER_COLOR, 1));

    String text = computeKeywords(filter);
    textArea.setText(text);
    textArea.setCaretPosition(0);
    textArea.setBackground(AnEnvironment.DEFAULT_TEXT_PANE_RO_BACKGROUND);
    textArea.setBorder(null);
    textArea.getAccessibleContext().setAccessibleDescription(AnLocale.getString("Keywords"));
    textArea.getAccessibleContext().setAccessibleName(AnLocale.getString("Keywords"));
  }

  private String computeKeywords(Filters filter) {
    String empty = "";

    Object[] obj = filter.getFilterKeywords();
    if (obj == null) {
      return empty; // weird
    }
    String[] kwCategory = (String[]) (obj[0]);
    String[] kwCategoryI18N = (String[]) (obj[1]);
    String[] kwDataType = (String[]) (obj[2]);
    String[] kwKeyword = (String[]) (obj[3]);
    String[] kwFormula = (String[]) (obj[4]);
    String[] kwDescrip = (String[]) (obj[5]);
    Object[] kwEnumDescs = (Object[]) (obj[6]);

    String sectionFormat = "------ %s ------\n";
    String categoryFormat = "%s\n";
    String keywordFormat = "   %-20s  %s\n";

    String previousCategory = empty;

    StringBuilder stringBuffer = new StringBuilder();

    for (int i = 0; i < kwKeyword.length; i++) {
      if (kwKeyword[i] == null) {
        stringBuffer.append(new Formatter().format(sectionFormat, kwCategoryI18N[i]));
        continue;
      }
      String cat = kwCategoryI18N[i];
      if (previousCategory.compareTo(cat) != 0) {
        stringBuffer.append(new Formatter().format(categoryFormat, cat));
      }
      previousCategory = cat;

      String[] enumDescs = (String[]) kwEnumDescs[i];

      String keyword = kwKeyword[i];
      if (kwDescrip[i] != null) {
        stringBuffer.append(new Formatter().format(keywordFormat, keyword, kwDescrip[i]));
        keyword = empty;
      }
      if (kwFormula[i] != null) {
        stringBuffer.append(new Formatter().format(keywordFormat, keyword, kwFormula[i]));
        keyword = empty;
      }
      int numEnums = enumDescs != null ? enumDescs.length : 0;
      for (int jj = 0; jj < numEnums; jj++) {
        stringBuffer.append(new Formatter().format(keywordFormat, keyword, enumDescs[jj]));
        keyword = empty;
      }
    }
    return stringBuffer.toString();
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    scrollPane = new javax.swing.JScrollPane();
    textArea = new javax.swing.JTextArea();

    setLayout(new java.awt.BorderLayout());

    textArea.setColumns(20);
    textArea.setEditable(false);
    textArea.setFont(new java.awt.Font("Monospaced", 0, 12));
    textArea.setRows(10);
    textArea.setWrapStyleWord(true);
    scrollPane.setViewportView(textArea);

    add(scrollPane, java.awt.BorderLayout.CENTER);
  } // </editor-fold>//GEN-END:initComponents
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JScrollPane scrollPane;
  private javax.swing.JTextArea textArea;
  // End of variables declaration//GEN-END:variables
}
