/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Nic Eigel
 * @author Sebastian Javier Marchano (sebasjm)
 */

/**
 * Imports.
 */
import { Fragment, h, VNode } from "preact";

export function ListPage(data: any): VNode {
  return (
    <Fragment>
      <div class="columns is-fullwidth">
        <div class="column is-fullwidth">
          <div class="card">
            <div class="card-content">
              <table class="table is-striped is-fullwidth">
                <tbody>
                  <tr>
                    <th>Finding</th>
                    <td class="has-text-right">
                      <b>Count</b>
                    </td>
                    <td class="has-text-right">
                      <b>Time difference (s)</b>
                    </td>
                    <td class="has-text-right">
                      <b>Diagnostic</b>
                    </td>
                  </tr>
                  {data["data"]["data"][0].map((x: any) => {
                    const key = Object.keys(x.data)[0];
                    let value = Object.values(x.data)[0];
                    console.log(value);
                    if (!!value) value = 0;
                    const paramName =
                      key[0].toUpperCase() +
                      key
                        .split("_")
                        .join(" ")
                        .split("-")
                        .join(" ")
                        .slice(1, key.length);
                    return (
                      <tr class="is-link">
                        <td>{paramName}</td>
                        <td className="has-text-right">
                          <p
                            class={value == 0 ? "text-success" : "text-danger"}
                          >
                            {String(value)}
                          </p>
                        </td>
                        <td className="has-text-right">
                          {
                            //TODO
                          }
                        </td>
                        <td>
                          {
                            //TODO
                          }
                        </td>
                      </tr>
                    );
                  })}
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </Fragment>
  );
}
