/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.annotations.GwtCompatible;

@GwtCompatible
public class LinearTranslation {
    private final double m;
    private final double b;
    private static final double EQUALITY_TOLERANCE = 1.0E-6;

    public LinearTranslation(double in1, double out1, double in2, double out2) {
        if (Math.abs(in1 - in2) < 1.0E-6) {
            throw new IllegalArgumentException("in1 and in2 are approximately equal");
        }
        double divisor = in1 - in2;
        this.m = (out1 - out2) / divisor;
        this.b = (in1 * out2 - in2 * out1) / divisor;
    }

    public double translate(double in) {
        return this.m * in + this.b;
    }
}

