/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.Benchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.caliper.worker.LatencyMeasureWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LatencyMeasureInstrument
extends Instrument {
    @Override
    public ShortDuration estimateRuntimePerTrial() {
        return ShortDuration.valueOf((String)this.options.get((Object)"maxTotalRuntime"));
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return method.getName().startsWith("latency") && Util.isPublic(method);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        Preconditions.checkArgument((boolean)this.isBenchmarkMethod(method));
        if (Util.isStatic(method)) {
            throw new InvalidBenchmarkException("LatencyMeasure methods must not be static: " + method.getName(), new Object[0]);
        }
        String methodName = method.getName();
        String shortName = methodName.substring("latency".length());
        return new BenchmarkMethod(benchmarkClass, method, shortName);
    }

    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod benchmarkMethod) throws UserCodeException {
        Method m = benchmarkMethod.method();
        try {
            m.invoke((Object)benchmark, 1);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public Map<String, String> workerOptions() {
        return new ImmutableMap.Builder().put((Object)"warmupNanos", (Object)this.toNanosString("warmup")).put((Object)"timingIntervalNanos", (Object)this.toNanosString("timingInterval")).put((Object)"reportedIntervals", this.options.get((Object)"reportedIntervals")).put((Object)"shortCircuitTolerance", this.options.get((Object)"shortCircuitTolerance")).put((Object)"maxTotalRuntimeNanos", (Object)this.toNanosString("maxTotalRuntime")).put((Object)"gcBeforeEach", this.options.get((Object)"gcBeforeEach")).build();
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return LatencyMeasureWorker.class;
    }

    private String toNanosString(String optionName) {
        return String.valueOf(ShortDuration.valueOf((String)this.options.get((Object)optionName)).to(TimeUnit.NANOSECONDS));
    }

    public boolean equals(Object object) {
        return object instanceof LatencyMeasureInstrument;
    }

    public int hashCode() {
        return 1609079866;
    }

    public String toString() {
        return "latency";
    }
}

