//  Copyright John Maddock 2015.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<typename table_type<T>::type, 4>, 6630> ellint_rf_xyy = {{
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.9640767714989779208405422148051165793035e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.7167064915262036620081126218518400181051e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0781788635270506076644910749852369925505e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1688263305271348755217081146704596612451e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.6402628509810036182835792415181870664789e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.2170032813654970557725141765886461932153e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1786389078487272251285772927802473330869e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0549376645734696120954360509647835950222e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0425368297759740697412847538705985562186e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.9562399742102856143089411463484396652737e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3980121253550848455436022016469058470638e-33), SC_(7.9640767714989779208405422148051165793035e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748920219122801086678261655e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3980121253550848455436022016469058470638e-33), SC_(7.7167064915262036620081126218518400181051e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904962861304900984077341569e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3980121253550848455436022016469058470638e-33), SC_(6.0781788635270506076644910749852369925505e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843644313608265353987699237974e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3980121253550848455436022016469058470638e-33), SC_(5.1688263305271348755217081146704596612451e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558978920138789084041651535e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(3.6402628509810036182835792415181870664789e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851886783159789435632079168e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(3.2170032813654970557725141765886461932153e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560897924938722512627210649e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(3.1786389078487272251285772927802473330869e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940325269242027702246176635e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(3.0549376645734696120954360509647835950222e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279833007216218384472069507762e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(3.0425368297759740697412847538705985562186e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342347762714330798603552138e-01) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3980121253550848455436022016469058470638e-33), SC_(2.9562399742102856143089411463484396652737e+00) }}, 
      {{ SC_(1.3980121253550848455436022016469058470638e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231243858851368634653634305e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.9418262092450297824712005140196305920371e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.6951644169363874802357131775007120525284e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0613136928271229872523499938415540485506e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1545430751115738496707891887621240749320e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.6302918585405582244625738590745497455076e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.2082188193376169239181794694485110875117e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1699618032140133581338072062373944686885e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0466064931516205284714435388815864504626e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0342403180548913423770639085280233577199e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.9481845570909789757591615324723489892180e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7494794261211793309535608228238390754549e-33), SC_(7.9418262092450297824712005140196305920371e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748902749676487504518567139e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.7494794261211793309535608228238390754549e-33), SC_(7.6951644169363874802357131775007120525284e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904946486647901164195272841e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7494794261211793309535608228238390754549e-33), SC_(6.0613136928271229872523499938415540485506e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843644303571849600660134700272e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7494794261211793309535608228238390754549e-33), SC_(5.1545430751115738496707891887621240749320e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558971721480382533409217070e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(3.6302918585405582244625738590745497455076e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851883275043873743212517738e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(3.2082188193376169239181794694485110875117e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560895202065000064728799334e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(3.1699618032140133581338072062373944686885e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940322612515636156208553583e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(3.0466064931516205284714435388815864504626e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279833004767102685640244787652e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(3.0342403180548913423770639085280233577199e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342345333934078342986144538e-01) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7494794261211793309535608228238390754549e-33), SC_(2.9481845570909789757591615324723489892180e+00) }}, 
      {{ SC_(1.7494794261211793309535608228238390754549e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231241569179606006545748908e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.8216781061903460352758157130997501927618e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.5788419901909841507831221235941178465381e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.9702455101824265920114190282230060246336e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0774166625724619395275668452518735427312e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5764507100060067675346286419905179404907e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1607846719682208235017901988684126050540e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1231073619657753345673556795056447121958e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0016200145568629070390528242936945644322e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9894409941599562730915046312472481416113e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.9046870905931522220141407385236790140264e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.8726742677921440789517852801186900989207e-33), SC_(7.8216781061903460352758157130997501927618e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748765701595678210166466935e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.8726742677921440789517852801186900989207e-33), SC_(7.5788419901909841507831221235941178465381e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904818027206459620855494089e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.9702455101824265920114190282230060246336e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843644224836010324042181745181e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.8726742677921440789517852801186900989207e-33), SC_(5.0774166625724619395275668452518735427312e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558915247892078110509658043e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(3.5764507100060067675346286419905179404907e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851855753819395759116118230e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(3.1607846719682208235017901988684126050540e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560873841077865777858742346e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(3.1231073619657753345673556795056447121958e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940301770455352098655921335e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(3.0016200145568629070390528242936945644322e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832985553751547896599108580e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.9894409941599562730915046312472481416113e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342326280114836930407585575e-01) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.8726742677921440789517852801186900989207e-33), SC_(2.9046870905931522220141407385236790140264e+00) }}, 
      {{ SC_(5.8726742677921440789517852801186900989207e-33), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231223606668652957812067502e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.7566628788847445004367411052265521872540e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.5158969346860336538278360689834090944995e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.9209661753912797506150181488779609673881e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0356815779976041371461183054216976164243e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5473158803967925772108936244683098706921e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1351168353993398726692039751369547061464e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0977532192820187039460738803893200008630e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.9772766744861040735129887797199604190622e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9651989283086059374029150345130976815752e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8811494932472592959984620617886623363428e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1309113765786506096540062665750175659960e-32), SC_(7.7566628788847445004367411052265521872540e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748648717234688471802019527e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1309113765786506096540062665750175659960e-32), SC_(7.5158969346860336538278360689834090944995e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904708374115505000876203845e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1309113765786506096540062665750175659960e-32), SC_(5.9209661753912797506150181488779609673881e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843644157627029429351454564420e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1309113765786506096540062665750175659960e-32), SC_(5.0356815779976041371461183054216976164243e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558867041987978047895903266e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(3.5473158803967925772108936244683098706921e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851832261678242084740137475e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(3.1351168353993398726692039751369547061464e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560855607320667150228818004e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(3.0977532192820187039460738803893200008630e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940283979654564213972873696e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.9772766744861040735129887797199604190622e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832969153218304033977662841e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.9651989283086059374029150345130976815752e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342310015758158544399515731e-01) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1309113765786506096540062665750175659960e-32), SC_(2.8811494932472592959984620617886623363428e+00) }}, 
      {{ SC_(1.1309113765786506096540062665750175659960e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231208273853678790922435356e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.7362598611879249459249619594613934675306e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.4961435763634035184659463264612570273866e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.9055013807347110734450941788832139512407e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0225843128729812510142874241459982480869e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5381728154757628498535525739802949285749e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1270617789847508326200404942988517152727e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0897966059884463945897529260841214977177e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.9696372703211570615045012711305560635904e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9575913059242733437188998383739668479723e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8737629465090386276901043637441910134934e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3891181146915726390794029968681816070943e-32), SC_(7.7362598611879249459249619594613934675306e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748603371824015765484242942e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3891181146915726390794029968681816070943e-32), SC_(7.4961435763634035184659463264612570273866e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904665870447503557345168894e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3891181146915726390794029968681816070943e-32), SC_(5.9055013807347110734450941788832139512407e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843644131575522939256124844829e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3891181146915726390794029968681816070943e-32), SC_(5.0225843128729812510142874241459982480869e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558848356443177250285490171e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(3.5381728154757628498535525739802949285749e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851823155668009759823479280e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(3.1270617789847508326200404942988517152727e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560848539562196847418467313e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(3.0897966059884463945897529260841214977177e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940277083594602885441694525e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.9696372703211570615045012711305560635904e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832962796053047905786329827e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.9575913059242733437188998383739668479723e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342303711377584345422396717e-01) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3891181146915726390794029968681816070943e-32), SC_(2.8737629465090386276901043637441910134934e+00) }}, 
      {{ SC_(1.3891181146915726390794029968681816070943e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231202330556763802375624486e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.6121365527210100129721954920164938049715e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.3759725200632602738598860200615223550294e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.8114201273604128196365138828035742610655e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.9429061053012676930488372642029769611135e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.4825502852996062857361357216144524319320e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0780582312290533825530501547021481411043e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0413919444395824672483942748813836070081e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.9231623746091877712427386637148291448958e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9113097570895871228188590496821489632961e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8288263281657448891124658331700624679110e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.8536338069604874547155326932387107373984e-32), SC_(7.6121365527210100129721954920164938049715e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544748199988246980493099010683e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.8536338069604874547155326932387107373984e-32), SC_(7.3759725200632602738598860200615223550294e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589904287766436950141204534842e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.8536338069604874547155326932387107373984e-32), SC_(5.8114201273604128196365138828035742610655e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843643899826604598164788691617e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.8536338069604874547155326932387107373984e-32), SC_(4.9429061053012676930488372642029769611135e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558682133626164912384893617e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(3.4825502852996062857361357216144524319320e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851742150447734051803807507e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(3.0780582312290533825530501547021481411043e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560785666216226951113883216e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(3.0413919444395824672483942748813836070081e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940215737643747382836637437e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.9231623746091877712427386637148291448958e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832906244000198931211701381e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.9113097570895871228188590496821489632961e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342247628886560777175017411e-01) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.8536338069604874547155326932387107373984e-32), SC_(2.8288263281657448891124658331700624679110e+00) }}, 
      {{ SC_(4.8536338069604874547155326932387107373984e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231149460192742734944279586e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.5462027107431669213900964519535950533943e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.3121380998059554482119872532804881383464e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.7614445138380594033420323112083641881842e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.9005813363920385254328017599030721126217e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.4530038031735673790239005812571919563230e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0520277280626068960313046219578154882008e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0156795674092484141573158906724751180232e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8984750820478031267578740549283070620896e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8867251696736835893385588863553226797379e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8049561628482040615435311663235703519180e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.4336713037670874919513419574389437932846e-32), SC_(7.5462027107431669213900964519535950533943e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544747858089819183734268676037e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.4336713037670874919513419574389437932846e-32), SC_(7.3121380998059554482119872532804881383464e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589903967294374844949764767215e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.4336713037670874919513419574389437932846e-32), SC_(5.7614445138380594033420323112083641881842e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843643703401674741661981257110e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.4336713037670874919513419574389437932846e-32), SC_(4.9005813363920385254328017599030721126217e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558541247077887074933272431e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(3.4530038031735673790239005812571919563230e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851673492329178142008702517e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(3.0520277280626068960313046219578154882008e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560732376247667944643551986e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(3.0156795674092484141573158906724751180232e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940163742259345901434331017e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.8984750820478031267578740549283070620896e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832858311810941625526146100e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.8867251696736835893385588863553226797379e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342200094686857334167947743e-01) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.4336713037670874919513419574389437932846e-32), SC_(2.8049561628482040615435311663235703519180e+00) }}, 
      {{ SC_(9.4336713037670874919513419574389437932846e-32), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231104648516301418979003225e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.5219967113934973666681922716627907405963e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.2887028518531043720943083744364388398154e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.7430971882138686605463265960581929794261e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.8850428314610502682796806931825460377439e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.4421565340675404187473441487029557281639e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0424712647378954887940014237697229244270e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0062398963237400281366145245018640901540e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8894117456827420060355896652452180374181e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8776995389937478543232921738472960817608e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7961928147886890899648324766163450801022e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2040325324738106751721983353783124694865e-31), SC_(7.5219967113934973666681922716627907405963e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544747701188099339417356229343e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2040325324738106751721983353783124694865e-31), SC_(7.2887028518531043720943083744364388398154e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589903820225498189425252469213e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2040325324738106751721983353783124694865e-31), SC_(5.7430971882138686605463265960581929794261e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843643613259671125590454549246e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2040325324738106751721983353783124694865e-31), SC_(4.8850428314610502682796806931825460377439e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558476592373651749876210206e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(3.4421565340675404187473441487029557281639e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851641984208616964691652612e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(3.0424712647378954887940014237697229244270e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560707920774821114096407066e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(3.0062398963237400281366145245018640901540e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940139880888326645348012384e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.8894117456827420060355896652452180374181e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832836315094025321974202340e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.8776995389937478543232921738472960817608e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342178280612622026643187527e-01) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2040325324738106751721983353783124694865e-31), SC_(2.7961928147886890899648324766163450801022e+00) }}, 
      {{ SC_(1.2040325324738106751721983353783124694865e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957231084083844073885010948935e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.4244215744668223039482914386211985256710e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.1942346378009858512468212452857346308955e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.6691385474588384400987956644639113291302e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.8224066343606941256531840831989234319065e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3984308546187585698738272220630035657163e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0039488635772016825990886997345450747887e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.9681882883150902978985789692642027808834e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8528771546477544346412872382270567670292e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8413169407493026750919106706938854068380e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7608674859521848186951473507962554068633e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.2192605509133527499735325052444797920840e-31), SC_(7.4244215744668223039482914386211985256710e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544746833406783788130036796881e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.2192605509133527499735325052444797920840e-31), SC_(7.1942346378009858512468212452857346308955e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589903006827000152479195851792e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.2192605509133527499735325052444797920840e-31), SC_(5.6691385474588384400987956644639113291302e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843643114708434325895430563855e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2192605509133527499735325052444797920840e-31), SC_(4.8224066343606941256531840831989234319065e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068558119004551455918351213439e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.3984308546187585698738272220630035657163e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851467721247457222058405558e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(3.0039488635772016825990886997345450747887e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560572664115936121805417279e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.9681882883150902978985789692642027808834e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324940007910047251779905540670e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.8528771546477544346412872382270567670292e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832714657154505097234255446e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.8413169407493026750919106706938854068380e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590342057632820767154516860060e-01) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.2192605509133527499735325052444797920840e-31), SC_(2.7608674859521848186951473507962554068633e+00) }}, 
      {{ SC_(3.2192605509133527499735325052444797920840e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957230970346159508046705296414e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.3776172865668014162985903006132848885878e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.1489206610323055410351501428102455799783e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.6336624864086353275511978049942955720263e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.7923616588230162399244661425402375013731e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3774567688628478627414844691079194750380e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.9854706568196736346204418580807908667481e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.9499359089447806559503690295341242707014e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8353524493696457469581760095497892584032e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8238651425103367518078147517048041323453e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7439228327023603122539545904206517694226e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1598089430474145704786096554063029578715e-31), SC_(7.3776172865668014162985903006132848885878e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544746239121348647581800498133e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1598089430474145704786096554063029578715e-31), SC_(7.1489206610323055410351501428102455799783e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589902449784722696361677837538e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1598089430474145704786096554063029578715e-31), SC_(5.6336624864086353275511978049942955720263e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843642773284007005583389670322e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1598089430474145704786096554063029578715e-31), SC_(4.7923616588230162399244661425402375013731e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068557874116547178473078362420e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(3.3774567688628478627414844691079194750380e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851348380190158809383016661e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.9854706568196736346204418580807908667481e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560480035868541719716819818e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.9499359089447806559503690295341242707014e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324939917532036906839143925296e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.8353524493696457469581760095497892584032e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832631341761294368166488895e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.8238651425103367518078147517048041323453e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590341975009210191177058036487e-01) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.1598089430474145704786096554063029578715e-31), SC_(2.7439228327023603122539545904206517694226e+00) }}, 
      {{ SC_(5.1598089430474145704786096554063029578715e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957230892454819659196503763805e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.3262645964241258123114107326477817629293e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.0992031092322406114898750965316120061106e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.5947388908935135113150520682922604591274e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.7593969372482232547342405645398418062580e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3544444386859644774296890391832161955387e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.9651967531115646848486807649115976307388e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.9299097783438350703849357449289711214392e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8161247076313075911326041925732831300877e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8047173928573031697737314630967356899205e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7253315119718310322335505020121677918584e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.6580669655578129845734803403304892059082e-31), SC_(7.3262645964241258123114107326477817629293e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544745403722599108353367711316e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.6580669655578129845734803403304892059082e-31), SC_(7.0992031092322406114898750965316120061106e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589901666739413976539400903115e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.6580669655578129845734803403304892059082e-31), SC_(5.5947388908935135113150520682922604591274e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843642293336960048122362460375e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.6580669655578129845734803403304892059082e-31), SC_(4.7593969372482232547342405645398418062580e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068557529872652824656151067569e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(3.3544444386859644774296890391832161955387e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189851180620113702947764523407e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.9651967531115646848486807649115976307388e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335560349826515477239671437474e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.9299097783438350703849357449289711214392e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324939790485886414944867843234e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.8161247076313075911326041925732831300877e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832514223670912174218020086e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.8047173928573031697737314630967356899205e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590341858863572293684792413786e-01) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.6580669655578129845734803403304892059082e-31), SC_(2.7253315119718310322335505020121677918584e+00) }}, 
      {{ SC_(8.6580669655578129845734803403304892059082e-31), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957230782961427995853060343264e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.2234251194070623849581606600618180507569e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.9996381787197017131968793952279643696880e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.5167900590937101035425889914454842494881e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.6933814136730022991539467640027097853929e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3083596864800040067304547467063986656847e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.9245960046669653653198978481128245242931e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8898052231208328769145487688298789650549e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7776190149578364446467378185586018877372e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7663718932369198177725778760367858636996e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6881003231933631779684153972582189713406e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4410831025899022881322276426055071978088e-30), SC_(7.2234251194070623849581606600618180507569e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544742915632489919056159286870e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4410831025899022881322276426055071978088e-30), SC_(6.9996381787197017131968793952279643696880e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589899334574937135432516744482e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4410831025899022881322276426055071978088e-30), SC_(5.5167900590937101035425889914454842494881e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843640863898023099611463960540e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4410831025899022881322276426055071978088e-30), SC_(4.6933814136730022991539467640027097853929e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068556504601991164038558148372e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(3.3083596864800040067304547467063986656847e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189850680975857379974478363662e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.9245960046669653653198978481128245242931e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335559962020568122925474631778e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.8898052231208328769145487688298789650549e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324939412100988635523792161097e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.7776190149578364446467378185586018877372e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279832165407776169933592283668e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.7663718932369198177725778760367858636996e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590341512943958411545211186505e-01) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4410831025899022881322276426055071978088e-30), SC_(2.6881003231933631779684153972582189713406e+00) }}, 
      {{ SC_(2.4410831025899022881322276426055071978088e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957230456854374364978518250504e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.1735823354991942055776054290713571694698e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.9513824557203035418363983694782977816866e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.4790109212376927773078642929586714906540e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.6613859429494535682049661409501312372756e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.2860239802679992973936202800688047122537e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.9049182078721984265398847973259360195583e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8703679142421656179897622090037911875738e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7589566201770057243900867070348876805715e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7477871385604555538877907432237007941852e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6700556369430595546609001707129897831774e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.0342289035474833635882447965222031649226e-30), SC_(7.1735823354991942055776054290713571694698e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544741158983857833623391295057e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.0342289035474833635882447965222031649226e-30), SC_(6.9513824557203035418363983694782977816866e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589897688013374549565627342476e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.0342289035474833635882447965222031649226e-30), SC_(5.4790109212376927773078642929586714906540e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843639854681377783485150867954e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.0342289035474833635882447965222031649226e-30), SC_(4.6613859429494535682049661409501312372756e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068555780737409784271087170238e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(3.2860239802679992973936202800688047122537e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189850328215562984898006660608e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.9049182078721984265398847973259360195583e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335559688220682653133631202549e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.8703679142421656179897622090037911875738e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324939144952580050521069626293e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.7589566201770057243900867070348876805715e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279831919135761307792297264740e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.7477871385604555538877907432237007941852e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590341268716784205391845364142e-01) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.0342289035474833635882447965222031649226e-30), SC_(2.6700556369430595546609001707129897831774e+00) }}, 
      {{ SC_(4.0342289035474833635882447965222031649226e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957230226615321704324628304600e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.1120639555092283382446349290278216415650e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.8918229032351365383985965598382262814804e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.4323820779809481600083753473642579297515e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.6218955820264477860679068557368592805403e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.2584561689548467359675981609060276763773e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.8806309172019293413491862640834099532651e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8463774454154147815469699485809972255005e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7359225878931736786154457883064897275520e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7248489334569773383450461964930528386488e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6477840104705532008162525327190671524887e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.4997427315795683999931409064612184484767e-30), SC_(7.1120639555092283382446349290278216415650e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544738284563962121626608080466e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.4997427315795683999931409064612184484767e-30), SC_(6.8918229032351365383985965598382262814804e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589894993729937005938573503252e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.4997427315795683999931409064612184484767e-30), SC_(5.4323820779809481600083753473642579297515e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843638203291138782457463695939e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.4997427315795683999931409064612184484767e-30), SC_(4.6218955820264477860679068557368592805403e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068554596271309668896767099775e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(3.2584561689548467359675981609060276763773e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189849750990732642665296158553e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.8806309172019293413491862640834099532651e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335559240199476896284170632105e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.8463774454154147815469699485809972255005e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324938707815245515435930744614e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.7359225878931736786154457883064897275520e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279831516158656867482042445316e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.7248489334569773383450461964930528386488e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590340869085670851616998341088e-01) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.4997427315795683999931409064612184484767e-30), SC_(2.6477840104705532008162525327190671524887e+00) }}, 
      {{ SC_(7.4997427315795683999931409064612184484767e-30), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957229849873096964710544714182e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.0171358460729497141752540812690962981963e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.7999174317775021616904395142075022608674e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3604297941873028404234035864175777349244e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.5609585855712634374457414122888428227687e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.2159166838500622291240553540868779248597e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.8431535553625235352304638635488795851459e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8093581050071515727124846550693687924084e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7003791106794526531860040109602190134421e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6894533257590836501691763184040708705077e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6134169904766774444624838712119323892681e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9524385645124032915396812389852876697084e-29), SC_(7.0171358460729497141752540812690962981963e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544731669408810579701758591981e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9524385645124032915396812389852876697084e-29), SC_(6.7999174317775021616904395142075022608674e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589888793138649640802380927191e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9524385645124032915396812389852876697084e-29), SC_(5.3604297941873028404234035864175777349244e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843634402801633741732195307020e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9524385645124032915396812389852876697084e-29), SC_(4.5609585855712634374457414122888428227687e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068551870355365483522482742602e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(3.2159166838500622291240553540868779248597e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189848422572495720287757756690e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.8431535553625235352304638635488795851459e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335558209128897513055567895378e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.8093581050071515727124846550693687924084e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324937701792675606668283600220e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.7003791106794526531860040109602190134421e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279830588752026970266990630925e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.6894533257590836501691763184040708705077e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590339949379464335873633815144e-01) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9524385645124032915396812389852876697084e-29), SC_(2.6134169904766774444624838712119323892681e+00) }}, 
      {{ SC_(1.9524385645124032915396812389852876697084e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957228982843101622884627588902e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.9232304039231180240275541276403686430663e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.7090020645120122191472654134948292276798e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.2892526574734621639285811091209378341254e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.5006780677205632698677905152450704715394e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1738354796491880864271049529286869008571e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.8060799398124212391218983284645379840301e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7727375765906808130428462083145123980106e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.6652185458781761652144607995540594399135e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6544390374648050033402473983595539574030e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5794202088377959644963259706187203671103e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.0307396633271274021036423836193003824470e-29), SC_(6.9232304039231180240275541276403686430663e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544721140244186955104900391408e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.0307396633271274021036423836193003824470e-29), SC_(6.7090020645120122191472654134948292276798e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589878923824184164939897422051e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0307396633271274021036423836193003824470e-29), SC_(5.2892526574734621639285811091209378341254e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843628353664654754315638486457e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0307396633271274021036423836193003824470e-29), SC_(4.5006780677205632698677905152450704715394e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068547531588236219617293072259e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(3.1738354796491880864271049529286869008571e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189846308164899048786643468744e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.8060799398124212391218983284645379840301e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335556568001573935237946337108e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.7727375765906808130428462083145123980106e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324936100533595359354295380355e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.6652185458781761652144607995540594399135e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279829112623825056122693235996e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.6544390374648050033402473983595539574030e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590338485507819312345079312987e-01) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.0307396633271274021036423836193003824470e-29), SC_(2.5794202088377959644963259706187203671103e+00) }}, 
      {{ SC_(5.0307396633271274021036423836193003824470e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957227602814765863192518462625e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.8562369923611044289493955969165473820892e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.6441418127833587817673427544360895363474e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.2384739261825986036677723497716636768925e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.4576731315944997638752232802615567506085e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1438141798446873550532866808669595807097e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7796311214289563169047254591232348121919e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7466119966918225572167546836702653672987e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.6401345237538100067370636351151915061580e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6294593709774585220811535440388462656905e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5551664453500152279784228727558189978480e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.8828830280863654554637712926778439923276e-29), SC_(6.8562369923611044289493955969165473820892e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544709924518928184108180009729e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.8828830280863654554637712926778439923276e-29), SC_(6.6441418127833587817673427544360895363474e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589868410975017685978349488182e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.8828830280863654554637712926778439923276e-29), SC_(5.2384739261825986036677723497716636768925e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843621910089990077878889945481e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.8828830280863654554637712926778439923276e-29), SC_(4.4576731315944997638752232802615567506085e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068542909909136015863515927966e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(3.1438141798446873550532866808669595807097e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189844055886058606244340981699e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.7796311214289563169047254591232348121919e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335554819863536981012249936668e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.7466119966918225572167546836702653672987e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324934394863434986853954647469e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.6401345237538100067370636351151915061580e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279827540243778661383422437447e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.6294593709774585220811535440388462656905e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590336926183526115272206656638e-01) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.8828830280863654554637712926778439923276e-29), SC_(2.5551664453500152279784228727558189978480e+00) }}, 
      {{ SC_(9.8828830280863654554637712926778439923276e-29), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957226132800836318278502695562e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.7855116533475127804238821780041038692580e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.5756684631649469840624130187406218043518e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1848665205961251990817204737860202912843e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.4122725673321731026175469450032419312648e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1121205168889420885758234206958460942951e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7517089481425889356299501898915254421717e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7190310681767396520426308008641191243230e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.6136531739134898698137252179949204851819e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6030881899975398892516310549792318130759e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5295616044405339226347775452600189841053e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0159108358364658025376430240459520615557e-28), SC_(6.7855116533475127804238821780041038692580e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544693162902191384338648024551e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0159108358364658025376430240459520615557e-28), SC_(6.5756684631649469840624130187406218043518e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589852699788761362294634324437e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0159108358364658025376430240459520615557e-28), SC_(5.1848665205961251990817204737860202912843e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843612280331195853049687013074e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0159108358364658025376430240459520615557e-28), SC_(4.4122725673321731026175469450032419312648e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068536002927021995920695108478e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(3.1121205168889420885758234206958460942951e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189840689912495873083176081759e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.7517089481425889356299501898915254421717e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335552207315609638229510749613e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.7190310681767396520426308008641191243230e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324931845782671333010969652754e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.6136531739134898698137252179949204851819e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279825190361707357142959300919e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.6030881899975398892516310549792318130759e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590334595812946601399654402932e-01) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0159108358364658025376430240459520615557e-28), SC_(2.5295616044405339226347775452600189841053e+00) }}, 
      {{ SC_(2.0159108358364658025376430240459520615557e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957223935902328527187972631482e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.7183228724051840421651556932847555346253e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.5106190628783703330805479878990647442624e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1339397059484930108642283785498511792321e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.3691422181613706519963228515315128086615e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.0820116675388620702756423495583185452788e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7251829984541618512852497036834929737029e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6928292996163965431024496211122986707182e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5884960005680709905387525455146053471430e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5780356766160239069567914544885834262319e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5052371109715141869979941201745479672414e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.9680608719690755813060883143357162268402e-28), SC_(6.7183228724051840421651556932847555346253e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544670634126497565061938066258e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.9680608719690755813060883143357162268402e-28), SC_(6.5106190628783703330805479878990647442624e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589831582864504561066512911491e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.9680608719690755813060883143357162268402e-28), SC_(5.1339397059484930108642283785498511792321e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843599337267333500614882046008e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.9680608719690755813060883143357162268402e-28), SC_(4.3691422181613706519963228515315128086615e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068526719463904363135584161250e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(3.0820116675388620702756423495583185452788e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189836165810520694562914406726e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.7251829984541618512852497036834929737029e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335548695869955637701141184149e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.6928292996163965431024496211122986707182e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324928419641288222525010031194e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5884960005680709905387525455146053471430e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279822031957185726949493282592e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5780356766160239069567914544885834262319e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590331463633223503434210964065e-01) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.9680608719690755813060883143357162268402e-28), SC_(2.5052371109715141869979941201745479672414e+00) }}, 
      {{ SC_(3.9680608719690755813060883143357162268402e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957220983118329150204385693137e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.6494109399194875067599451434637981904753e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.4439013784984243407090753336810671344829e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0817068009383314440785264130065600014634e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.3249057300385391020272074145926331932171e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.0511306340607331785698927665988470409058e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6979767531791227226906069309020483911304e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6659555495540750745076274609366816367039e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5626936358459230297950357773261251937603e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5523406560109335624813683878925917034186e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4802887813817177003192096814096062721864e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.9474558416608700456074110588635447509500e-28), SC_(6.6494109399194875067599451434637981904753e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544638066805804943969001998107e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.9474558416608700456074110588635447509500e-28), SC_(6.4439013784984243407090753336810671344829e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589801056498861810670730894630e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.9474558416608700456074110588635447509500e-28), SC_(5.0817068009383314440785264130065600014634e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843580626933612793796657865217e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.9474558416608700456074110588635447509500e-28), SC_(4.3249057300385391020272074145926331932171e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068513299403950860520741274001e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(3.0511306340607331785698927665988470409058e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189829625824421397502452622272e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.6979767531791227226906069309020483911304e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335543619767362991268486320389e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.6659555495540750745076274609366816367039e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324923466853499020489490532559e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.5626936358459230297950357773261251937603e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279817466206506200462580742669e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.5523406560109335624813683878925917034186e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590326935792789766857777378701e-01) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.9474558416608700456074110588635447509500e-28), SC_(2.4802887813817177003192096814096062721864e+00) }}, 
      {{ SC_(7.9474558416608700456074110588635447509500e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957216714610144298725407935776e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.6332742315535315723521812461217465866746e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.4282784845110217442941358269463187900275e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0694757238976374746665275826419182666230e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.3145471276568634741761731508604597162355e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.0438994011914573175699452517130410643472e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6916060241935860521793340208948179964660e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6596626790480087774055038792063327998463e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5566516454437564287794591465021610311576e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5463238017593475495750916988159628209985e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4744467754433142768335778479541586018778e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.3511217333788972162109341828680044038835e-28), SC_(6.6332742315535315723521812461217465866746e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544628662791710119208650098903e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.3511217333788972162109341828680044038835e-28), SC_(6.4282784845110217442941358269463187900275e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589792241823086740180653524391e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.3511217333788972162109341828680044038835e-28), SC_(5.0694757238976374746665275826419182666230e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843575224209707776083979402584e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.3511217333788972162109341828680044038835e-28), SC_(4.3145471276568634741761731508604597162355e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068509424279124128115669731096e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(3.0438994011914573175699452517130410643472e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189827737363223185320466977854e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.6916060241935860521793340208948179964660e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335542154011528221622063354896e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.6596626790480087774055038792063327998463e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324922036705571964123386673344e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.5566516454437564287794591465021610311576e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279816147817924315950301840941e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.5463238017593475495750916988159628209985e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590325628351024450751906473622e-01) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.3511217333788972162109341828680044038835e-28), SC_(2.4744467754433142768335778479541586018778e+00) }}, 
      {{ SC_(9.3511217333788972162109341828680044038835e-28), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957215482052160389624304844875e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.5248822184454229792614895004438242439716e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.3233378180835525531811125177675282327302e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.9873182582698790316185291711709547389537e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.2449672765699435072774447426019149871090e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.9953264289235841314994562183899445225294e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6488131494605121383000833697627842504832e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6173927881314568633727921801790627992547e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5160669432840286871751659891833359965131e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5059079418381624945331680429306057292303e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4352053905280977136767949855836296071262e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7882427361992658143258966170331945402566e-27), SC_(6.5248822184454229792614895004438242439716e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544541156813774053048858970492e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7882427361992658143258966170331945402566e-27), SC_(6.3233378180835525531811125177675282327302e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589710219740164578333785401941e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.7882427361992658143258966170331945402566e-27), SC_(4.9873182582698790316185291711709547389537e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843524950929163958749417943538e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7882427361992658143258966170331945402566e-27), SC_(4.2449672765699435072774447426019149871090e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068473365572260411168054824929e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.9953264289235841314994562183899445225294e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189810164905092267131868006215e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.6488131494605121383000833697627842504832e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335528514899927187454696063826e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.6173927881314568633727921801790627992547e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324908728931711950840362917212e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.5160669432840286871751659891833359965131e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279803879984104177702965187059e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.5059079418381624945331680429306057292303e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590313462379226151912126744821e-01) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7882427361992658143258966170331945402566e-27), SC_(2.4352053905280977136767949855836296071262e+00) }}, 
      {{ SC_(2.7882427361992658143258966170331945402566e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957204012886902095516404093457e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.4429539223841222529282472177863040464249e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.2440182285547118233222384894217626162572e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.9252193916229083664507455004131846414300e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.1923752222636474964507675356902389497528e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.9586124613679620324817402621385757796102e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6164680789159817508146670498799024893953e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5854430158356318324733244678721793869216e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4853909239099301166668291513411738621216e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4753595421706301375174056806643589848969e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4055447198845628481084456243080940236046e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.4429539223841222529282472177863040464249e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544434879146367456250172270034e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.2440182285547118233222384894217626162572e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589610602367107314253389182037e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.3673277743463290223091457894565066834118e-27), SC_(4.9252193916229083664507455004131846414300e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843463893077859468153958387474e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.3673277743463290223091457894565066834118e-27), SC_(4.1923752222636474964507675356902389497528e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068429571589888441027768306245e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.9586124613679620324817402621385757796102e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189788822821902035715736021161e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.6164680789159817508146670498799024893953e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335511949940587892562167176473e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.5854430158356318324733244678721793869216e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324892566388334056879322221775e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.4853909239099301166668291513411738621216e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279788980467599275122871512051e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.4753595421706301375174056806643589848969e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590298686576075853763311361268e-01) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.3673277743463290223091457894565066834118e-27), SC_(2.4055447198845628481084456243080940236046e+00) }}, 
      {{ SC_(6.3673277743463290223091457894565066834118e-27), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957190083368490875089452716099e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3736554798589777424979811674270921595223e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.1769263411319630061622557238458286970280e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.8726935251262850719554841823427750022581e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.1478906225852019117729974028476739212330e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.9275582237866061233928328275639300551645e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5891092405187475761291441761980041054349e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5584185375347885544932008955803281040707e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4594438400854891178921507926993786434827e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4495204045299342196087114385715619760526e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3804564612649729393316116875486577654409e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2802620846058105842978295818115658417924e-26), SC_(6.3736554798589777424979811674270921595223e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544303553971640908111707954976e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2802620846058105842978295818115658417924e-26), SC_(6.1769263411319630061622557238458286970280e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589487507184066696408109551889e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2802620846058105842978295818115658417924e-26), SC_(4.8726935251262850719554841823427750022581e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843388445119820335222300537866e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2802620846058105842978295818115658417924e-26), SC_(4.1478906225852019117729974028476739212330e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068375456247245783638110191850e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.9275582237866061233928328275639300551645e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189762450839223276711259090266e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.5891092405187475761291441761980041054349e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335491480953709883139783441951e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.5584185375347885544932008955803281040707e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324872594658760741077615686521e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.4594438400854891178921507926993786434827e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279770569434913907991828758774e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.4495204045299342196087114385715619760526e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590280428413492982182148816346e-01) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2802620846058105842978295818115658417924e-26), SC_(2.3804564612649729393316116875486577654409e+00) }}, 
      {{ SC_(1.2802620846058105842978295818115658417924e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957172870942928205505850872730e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3060915166411266702004927070411097438125e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.1115137048753539583647739183672576496242e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.8214823350526274723506066717219672702175e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.1045194334658392391678915517984869131323e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8972812465667524546975787199815069397960e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5624351698788027474265997658071310790177e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5320704582509391357418852034736440963436e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4341461890381523307714054359434998096227e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4243279978679299559194404013112597850072e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3559961397799862470921887887489434574993e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5295786350139981648664921989981478850189e-26), SC_(6.3060915166411266702004927070411097438125e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544122835105673955151309471645e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5295786350139981648664921989981478850189e-26), SC_(6.1115137048753539583647739183672576496242e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589318113753359934241169160002e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5295786350139981648664921989981478850189e-26), SC_(4.8214823350526274723506066717219672702175e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843284619867390665094802479137e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5295786350139981648664921989981478850189e-26), SC_(4.1045194334658392391678915517984869131323e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068300987179344995511924106392e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.8972812465667524546975787199815069397960e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189726159893386506931193829136e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5624351698788027474265997658071310790177e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335463313223464796090391306715e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.5320704582509391357418852034736440963436e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324845111212975089426198544288e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.4341461890381523307714054359434998096227e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279745233691366578361135820067e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.4243279978679299559194404013112597850072e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590255303037162911337497514751e-01) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5295786350139981648664921989981478850189e-26), SC_(2.3559961397799862470921887887489434574993e+00) }}, 
      {{ SC_(2.5295786350139981648664921989981478850189e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957149184623570905338512365596e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.2936019381542185254059633836268724640538e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0994218112733125846744029053408894168195e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.8120156586267554098048832982671512623801e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.0965020252976680548495774756925593610185e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8916843770919052149751817652875083697693e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5575043179430047877711382428943166358499e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5271998676502389892205374868042619476124e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4294697760031240977480520211017116135047e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4196710398492789987460422500801986666450e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3514745118225393848061680240451845200629e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.8689244097271181025975906229169039426616e-26), SC_(6.2936019381542185254059633836268724640538e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176544082151729254682326758223286e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8689244097271181025975906229169039426616e-26), SC_(6.0994218112733125846744029053408894168195e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342589279979955499253640262319545e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.8689244097271181025975906229169039426616e-26), SC_(4.8120156586267554098048832982671512623801e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843261246757982183573951197430e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8689244097271181025975906229169039426616e-26), SC_(4.0965020252976680548495774756925593610185e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068284222725314201762048668893e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.8916843770919052149751817652875083697693e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189717990086641710613016947650e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.5575043179430047877711382428943166358499e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335456972112555838895932235105e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.5271998676502389892205374868042619476124e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324838924147976569495015029769e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.4294697760031240977480520211017116135047e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279739530116446034836712055265e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.4196710398492789987460422500801986666450e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590249646820046658037025283013e-01) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8689244097271181025975906229169039426616e-26), SC_(2.3514745118225393848061680240451845200629e+00) }}, 
      {{ SC_(2.8689244097271181025975906229169039426616e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957143852366524890166139473584e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1959172409458569292079067944502245615956e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0048475254854223625918934801836759065439e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.7379739748981820072778893029612310640824e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.0337954984020973261727120716035640455065e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8479096011426393995243426123664057269614e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5189386626782908267074517085729844962105e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4891055341581990992427221487083517492841e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3928941628367701775243418613040577137378e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3832475901355179750114839555944150929657e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3161095186504277219033889369344320119036e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.6792108552998581016945261284770797094792e-26), SC_(6.1959172409458569292079067944502245615956e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176543657954536897862303838560987e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.6792108552998581016945261284770797094792e-26), SC_(6.0048475254854223625918934801836759065439e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342588882366694011446065131153547e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.6792108552998581016945261284770797094792e-26), SC_(4.7379739748981820072778893029612310640824e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876843017540156899050140738362833e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.6792108552998581016945261284770797094792e-26), SC_(4.0337954984020973261727120716035640455065e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561068109423213642185040387522785e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.8479096011426393995243426123664057269614e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189632805193246316539973748874e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.5189386626782908267074517085729844962105e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335390854654253420204392745026e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.4891055341581990992427221487083517492841e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324774412894676117691023061471e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.3928941628367701775243418613040577137378e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279680060114675355625148899552e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.3832475901355179750114839555944150929657e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590190670608353996543751480507e-01) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.6792108552998581016945261284770797094792e-26), SC_(2.3161095186504277219033889369344320119036e+00) }}, 
      {{ SC_(7.6792108552998581016945261284770797094792e-26), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957088254019806229018780248310e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1081903413052147380976753185939343091942e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.9199139676713180005889854571394009381567e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.6714799636220255130030036036985676775175e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.9774811590123030577297619729334360745067e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8085971449827801579097514608811180328459e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4843043190638892925782781767957683347072e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4548944666456995172996534279036587850335e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3600470001056865743209988627731617536899e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3505370795957813703803356217519337811765e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2843495675479097699289740338737653764652e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8591977352242616487743079115958899226631e-25), SC_(6.1081903413052147380976753185939343091942e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176543051315692981349873697274779e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8591977352242616487743079115958899226631e-25), SC_(5.9199139676713180005889854571394009381567e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342588313745181137446855255253977e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8591977352242616487743079115958899226631e-25), SC_(4.6714799636220255130030036036985676775175e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876842669018541481245321511952681e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8591977352242616487743079115958899226631e-25), SC_(3.9774811590123030577297619729334360745067e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561067859444723476490206248228195e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.8085971449827801579097514608811180328459e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189510983393904783128697823964e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.4843043190638892925782781767957683347072e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335296300943880109140981242596e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.4548944666456995172996534279036587850335e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324682156197020105587152238119e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.3600470001056865743209988627731617536899e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279595012844745449686266151055e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.3505370795957813703803356217519337811765e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590106329501141485833349906413e-01) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8591977352242616487743079115958899226631e-25), SC_(2.2843495675479097699289740338737653764652e+00) }}, 
      {{ SC_(1.8591977352242616487743079115958899226631e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898957008743553012031163359485005e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0393000988678821826305220806057125766039e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.8532172826995838464464255441186045981611e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.6192634989320667895774038532749014660378e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.9332585943354151546600809353364153934510e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7777258313178317966769717775247666424366e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4571066369615044845167006522029630020377e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4280291751030791795309820595409352191501e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3342527566844300753249946129658187109045e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3248501465049942062735479219947135967415e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2594090904512285433021737156641376472895e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.7228919776082830648394626760138917268353e-25), SC_(6.0393000988678821826305220806057125766039e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176542346632626024983610119346975e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.7228919776082830648394626760138917268353e-25), SC_(5.8532172826995838464464255441186045981611e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342587653223759458480552350154040e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.7228919776082830648394626760138917268353e-25), SC_(4.6192634989320667895774038532749014660378e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876842264169291691021121146268086e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.7228919776082830648394626760138917268353e-25), SC_(3.9332585943354151546600809353364153934510e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561067569065017512046478331026446e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.7777258313178317966769717775247666424366e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189369472905344720479240107227e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.4571066369615044845167006522029630020377e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335186465579253934948780966346e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.4280291751030791795309820595409352191501e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324574989085478441769707879944e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.3342527566844300753249946129658187109045e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279496220339762498159403504796e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.3248501465049942062735479219947135967415e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789590008357288024863932530955247e-01) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.7228919776082830648394626760138917268353e-25), SC_(2.2594090904512285433021737156641376472895e+00) }}, 
      {{ SC_(3.7228919776082830648394626760138917268353e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898956916382702470484730408004073e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0030588247166020449002776824286174479487e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.8181299791929803521936560374455467680866e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.5917938436501756536425127514480681898483e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.9099943114206652929986920070243675279431e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7614852767435129678326124840327736856607e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4427986795719142808985366439268807301385e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4138960793045579834296767228648719507549e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3206831100366484830270689427413534510410e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3113369528898658435412409663664275970144e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2462885869380238095368848670921243284719e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3643882618567678488066742377790444354368e-25), SC_(6.0030588247166020449002776824286174479487e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176541865225212161585777877085696e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3643882618567678488066742377790444354368e-25), SC_(5.8181299791929803521936560374455467680866e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342587201985572644583786107184057e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3643882618567678488066742377790444354368e-25), SC_(4.5917938436501756536425127514480681898483e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876841987594701658877228367255880e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3643882618567678488066742377790444354368e-25), SC_(3.9099943114206652929986920070243675279431e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561067370690812366834877284063578e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.7614852767435129678326124840327736856607e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189272799377163482520663160176e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.4427986795719142808985366439268807301385e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881335111431054777834000205404560e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.4138960793045579834296767228648719507549e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324501777390125360936879169335e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.3206831100366484830270689427413534510410e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279428729794632263321930863310e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.3113369528898658435412409663664275970144e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789589941427128980942398206428226e-01) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3643882618567678488066742377790444354368e-25), SC_(2.2462885869380238095368848670921243284719e+00) }}, 
      {{ SC_(5.3643882618567678488066742377790444354368e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898956853285971065437142851138086e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.9469279492656279843854568846867681757381e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.7637863858960510039969438093104631603467e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.5492485459083588346192654915621986898456e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.8739623396612528997766202122221227689059e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7363317310303957806852216720947118804881e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4206383611780157760226537587458731017771e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3920065884248490403061646376927110502285e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2996662952657072186587636124052751844704e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2904075731834717309052645036282116797825e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2259674098878027813594951967324476190042e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.4454615474045197976285755041988786463725e-25), SC_(5.9469279492656279843854568846867681757381e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176540922380032489802470976098262e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.4454615474045197976285755041988786463725e-25), SC_(5.7637863858960510039969438093104631603467e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342586318227373104178978174788201e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.4454615474045197976285755041988786463725e-25), SC_(4.5492485459083588346192654915621986898456e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876841445918334569307974334632171e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.4454615474045197976285755041988786463725e-25), SC_(3.8739623396612528997766202122221227689059e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561066982171322001319624632904547e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.7363317310303957806852216720947118804881e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029189083462513162856282461604976e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.4206383611780157760226537587458731017771e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881334964474573273930097612863383e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.3920065884248490403061646376927110502285e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324358390952626829531184460437e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.2996662952657072186587636124052751844704e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279296548333946405701623176083e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.2904075731834717309052645036282116797825e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789589810343194641834334490609250e-01) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.4454615474045197976285755041988786463725e-25), SC_(2.2259674098878027813594951967324476190042e+00) }}, 
      {{ SC_(9.4454615474045197976285755041988786463725e-25), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898956729709874509563893942813969e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.8908481273107212973215234349514053452685e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.7094922204835859730043540087311934208057e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.5067419449831067995413141772900952192193e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.8379631405624081398232149098265899841438e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7112010635716586941039278666231225678334e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3984981985668105732857806917075898632744e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3701370069983165420644763597127527875545e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2786685962107001219666251090327021658077e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2694972296669810917084983597550997063624e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2056647158404617635868218326199039092142e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.6622742888463273191629024333782773358015e-24), SC_(5.8908481273107212973215234349514053452685e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176539672586747015883015852879952e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6622742888463273191629024333782773358015e-24), SC_(5.7094922204835859730043540087311934208057e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342585146757138560881680758002043e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6622742888463273191629024333782773358015e-24), SC_(4.5067419449831067995413141772900952192193e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876840727896435444649343236760051e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6622742888463273191629024333782773358015e-24), SC_(3.8379631405624081398232149098265899841438e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561066467167309885970944880395756e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.7112010635716586941039278666231225678334e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029188832486057618948927941702740e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.3984981985668105732857806917075898632744e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881334769675652093257318630442662e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.3701370069983165420644763597127527875545e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718324168324321670427018731614873e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.2786685962107001219666251090327021658077e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043279121334517732340967903710284e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.2694972296669810917084983597550997063624e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789589636584210131184438048221158e-01) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6622742888463273191629024333782773358015e-24), SC_(2.2056647158404617635868218326199039092142e+00) }}, 
      {{ SC_(1.6622742888463273191629024333782773358015e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898956565902943053033723627264676e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.7876379591940427620014353176680130970004e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.6095684021718736988726688694175602232668e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4285121419161236890963935494930077831085e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.7717096600494860582564641731845735620107e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.6649501960958988372834745322416134106587e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3577511022748410487302185881461343206796e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3298878924863486644563178418274654597457e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2400241074447886950938072667369191945557e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2310135113796823865139234140366889494648e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.1682993249957389635671685957977076919661e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.7042126583826492571881501298937085578378e-24), SC_(5.7876379591940427620014353176680130970004e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176536209126482461682436609516835e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.7042126583826492571881501298937085578378e-24), SC_(5.6095684021718736988726688694175602232668e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342581900347787825581954584432877e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.4285121419161236890963935494930077831085e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876838738095125418322519078391667e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.7042126583826492571881501298937085578378e-24), SC_(3.7717096600494860582564641731845735620107e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561065039974547067402118293034335e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.6649501960958988372834745322416134106587e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029188136973454680416203978042173e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.3577511022748410487302185881461343206796e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881334229843720741885777014473165e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.3298878924863486644563178418274654597457e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718323641606638365190974777172846e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.2400241074447886950938072667369191945557e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043278635777348149475467488115402e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.2310135113796823865139234140366889494648e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789589155058708708930568515224238e-01) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.7042126583826492571881501298937085578378e-24), SC_(2.1682993249957389635671685957977076919661e+00) }}, 
      {{ SC_(4.7042126583826492571881501298937085578378e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898956111956834722663382146421695e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.7432068048765714609679086484214502364699e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.5665519952382122663717581764206891788741e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.3948348355448648275283683040537317557169e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.7431880650317222976077628772437827201727e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.6450395664783861767499302061899783255999e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3402098022617389734691267840921042725405e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3125609696583465010895495876067455360019e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2233879632042627447758402296255142132047e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2144465775481237017769106418694323607021e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.1522138222100282072862480392804998365199e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.3616720556278283564328024996187890133248e-24), SC_(5.7432068048765714609679086484214502364699e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176534065910007972666972959224768e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.3616720556278283564328024996187890133248e-24), SC_(5.5665519952382122663717581764206891788741e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342579891444127333695233641500701e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.3616720556278283564328024996187890133248e-24), SC_(4.3948348355448648275283683040537317557169e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876837506790411963672096660055949e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.3616720556278283564328024996187890133248e-24), SC_(3.7431880650317222976077628772437827201727e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561064156816431223331608421735061e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.6450395664783861767499302061899783255999e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029187706584781223338115752473676e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.3402098022617389734691267840921042725405e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881333895791472310342584843844749e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.3125609696583465010895495876067455360019e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718323315669589853989094295436306e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.2233879632042627447758402296255142132047e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043278335310749526509507784938332e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.2144465775481237017769106418694323607021e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789588857086938079208154506601916e-01) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.3616720556278283564328024996187890133248e-24), SC_(2.1522138222100282072862480392804998365199e+00) }}, 
      {{ SC_(7.3616720556278283564328024996187890133248e-24), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898955831051409630630391135662140e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.6205109624620920072333738806517839045197e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.4477629525620411157376631736270337247208e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.3018355529705810505637232248920053006945e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.6644261876628718506365405949309973835459e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5900567169114376358533585571571965249180e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2917698142575027434225725077539411164476e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.2647129804379441516228063654843451775692e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1774475467672879545665453767656819180122e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.1686972844245657345118504012078203800786e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.1077939923570557627060322324015059369762e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5354544851880595018243965945098708503203e-23), SC_(5.6205109624620920072333738806517839045197e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176524922875588387449113101879850e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5354544851880595018243965945098708503203e-23), SC_(5.4477629525620411157376631736270337247208e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342571321392743286042252299854006e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5354544851880595018243965945098708503203e-23), SC_(4.3018355529705810505637232248920053006945e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876832254002599757864340647249136e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5354544851880595018243965945098708503203e-23), SC_(3.6644261876628718506365405949309973835459e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561060389233852788349270105976439e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.5900567169114376358533585571571965249180e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029185870532052972052862715429957e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.2917698142575027434225725077539411164476e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881332470713211805439457814035112e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.2647129804379441516228063654843451775692e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718321925211048391325789793976744e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.1774475467672879545665453767656819180122e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043277053510014114925728269654869e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.1686972844245657345118504012078203800786e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789587585929223792503210928567234e-01) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5354544851880595018243965945098708503203e-23), SC_(2.1077939923570557627060322324015059369762e+00) }}, 
      {{ SC_(2.5354544851880595018243965945098708503203e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898954632699306221316080893424723e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.5671734146239341731732795056869165987881e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3961237435904293465247771724524261171028e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2614075027155151697531766111875000131882e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.6301873306705307503521423227045695485130e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5661549260166121020200801475101204077095e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2707122940790452526938521905547457254098e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.2439128101650050941575748036481841636889e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1574766242715240125364802986345191109697e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.1488094458269335682764274174143830769396e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0884840894856757265545954148008592673762e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.3404174612542203037430892437393593896733e-23), SC_(5.5671734146239341731732795056869165987881e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176518808638926969696375465998773e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.3404174612542203037430892437393593896733e-23), SC_(5.3961237435904293465247771724524261171028e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342565590327983173691746693356450e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.2614075027155151697531766111875000131882e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876828741297042481968034731049125e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.3404174612542203037430892437393593896733e-23), SC_(3.6301873306705307503521423227045695485130e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561057869732069371020679715870115e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.5661549260166121020200801475101204077095e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029184642705448783996367978643540e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.2707122940790452526938521905547457254098e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881331517718249092941300537695558e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.2439128101650050941575748036481841636889e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718320995367388152618423534840406e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.1574766242715240125364802986345191109697e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043276196329269798724602380318088e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.1488094458269335682764274174143830769396e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789586735865804749692798254824361e-01) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.3404174612542203037430892437393593896733e-23), SC_(2.0884840894856757265545954148008592673762e+00) }}, 
      {{ SC_(4.3404174612542203037430892437393593896733e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898953831323304807605247307732575e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.4895832905744170600656592661164173978873e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3210041928738533802481534820862203430683e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2025968231565537900946990155973166905663e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5803800697628801519302482360940906245449e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5313849938449574743280034228290360063631e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2400799221563738943731647672933874249457e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.2136548051171269882648449353374193059330e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1284249258595271588348749344004073095575e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.1198786095509712116406346477199846529917e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0603939762371126604320492439653342239961e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.4878661342759511104190386438428025939196e-23), SC_(5.4895832905744170600656592661164173978873e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176506396391645515770233854836350e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.4878661342759511104190386438428025939196e-23), SC_(5.3210041928738533802481534820862203430683e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342553955941398594236256383184809e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.4878661342759511104190386438428025939196e-23), SC_(4.2025968231565537900946990155973166905663e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876821610305486498657753249677202e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.4878661342759511104190386438428025939196e-23), SC_(3.5803800697628801519302482360940906245449e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561052755000518466865447630069454e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.5313849938449574743280034228290360063631e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029182150147788053483026692816489e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.2400799221563738943731647672933874249457e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881329583084411672930793773030861e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.2136548051171269882648449353374193059330e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718319107732008120726387512884074e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.1284249258595271588348749344004073095575e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043274456203731234564199285262483e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.1198786095509712116406346477199846529917e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789585010188840254206271005259064e-01) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.4878661342759511104190386438428025939196e-23), SC_(2.0603939762371126604320492439653342239961e+00) }}, 
      {{ SC_(9.4878661342759511104190386438428025939196e-23), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898952204484560121535440972468676e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.4161509994200709739708778474503507769804e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.2499100840916210114008254499252976419212e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.1469376397583867782783731795456186197752e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5332418375538824001822022908289271658140e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4984782829210728548132885057497281855668e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2110890514582129380614451957264878011276e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1850182400433624634801094720453502986753e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1009300248982071501748289208468634163404e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0924980940693954721544722880993337382472e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0338091318397685771275001628136570144131e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9888655119526487934053853251590432416052e-22), SC_(5.4161509994200709739708778474503507769804e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176489220802511705783749027050947e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9888655119526487934053853251590432416052e-22), SC_(5.2499100840916210114008254499252976419212e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342537856725900427980079677687386e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9888655119526487934053853251590432416052e-22), SC_(4.1469376397583867782783731795456186197752e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876811742714364198226131346453863e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9888655119526487934053853251590432416052e-22), SC_(3.5332418375538824001822022908289271658140e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561045677432238034485489554619604e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.4984782829210728548132885057497281855668e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029178701042617788878950936365877e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.2110890514582129380614451957264878011276e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881326906012712854541243035894805e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.1850182400433624634801094720453502986753e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718316495694962231603376023825290e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.1009300248982071501748289208468634163404e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043272048285115537374802504011967e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.0924980940693954721544722880993337382472e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789582622263604171995235237332926e-01) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9888655119526487934053853251590432416052e-22), SC_(2.0338091318397685771275001628136570144131e+00) }}, 
      {{ SC_(1.9888655119526487934053853251590432416052e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898949953327841107232972052086342e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3431889574370806549052477628283683771512e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1792712511181313044388296228116170312982e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.0916348892654155566720532174483443825126e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.4864054713807525077002026935699620257275e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4657823015454665973097682957840089145651e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1822838338659047944668305706669605229191e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1565650591563735989540176050038747329338e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0736111970811445284412935149304982707346e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0652929192249440953120250182093988144841e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0073945327235120247577435977606727202650e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.1493861471394310727732518591110572048208e-22), SC_(5.3431889574370806549052477628283683771512e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176464543720579510540485489223310e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.1493861471394310727732518591110572048208e-22), SC_(5.1792712511181313044388296228116170312982e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342514726127188661413165648796004e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.0916348892654155566720532174483443825126e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876797565421655258553112412574295e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.1493861471394310727732518591110572048208e-22), SC_(3.4864054713807525077002026935699620257275e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561035508713658638836029329975733e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.4657823015454665973097682957840089145651e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029173745529871392899261539681785e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.1822838338659047944668305706669605229191e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881323059721494806847976057052545e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.1565650591563735989540176050038747329338e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718312742842487173477954555766176e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.0736111970811445284412935149304982707346e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043268588700439707492476963949203e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.0652929192249440953120250182093988144841e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789579191404479647334337756813012e-01) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.1493861471394310727732518591110572048208e-22), SC_(2.0073945327235120247577435977606727202650e+00) }}, 
      {{ SC_(4.1493861471394310727732518591110572048208e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898946718971315424342350674008796e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3006888169586235229530892793063113268147e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1381243719599592024393698219604612212025e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.0594212258190952705550369573802414727215e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.4591234479099382367206493366516866213294e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4467370039663741914361750658175102464134e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1655048929136898708165456930664374410325e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1399911783837124573333912785756019164945e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0576980731008340406994167068881578926734e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0494459977133487544355396264039615172170e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9920081188758191233346205859288495354620e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3682587603765391777064795220987536428225e-22), SC_(5.3006888169586235229530892793063113268147e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176445386742272592592984560969162e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.3682587603765391777064795220987536428225e-22), SC_(5.1381243719599592024393698219604612212025e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342496769693807887607687134247308e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.3682587603765391777064795220987536428225e-22), SC_(4.0594212258190952705550369573802414727215e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876786559497631407137087565153076e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.3682587603765391777064795220987536428225e-22), SC_(3.4591234479099382367206493366516866213294e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561027614671657643314623828295283e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.4467370039663741914361750658175102464134e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029169898533275794654326184524538e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.1655048929136898708165456930664374410325e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881320073820745732694405598288213e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.1399911783837124573333912785756019164945e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718309829478838612118839303467863e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.0576980731008340406994167068881578926734e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043265903002480443352380668905662e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(2.0494459977133487544355396264039615172170e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789576528006351648529409800666824e-01) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.9920081188758191233346205859288495354620e+00) }}, 
      {{ SC_(6.3682587603765391777064795220987536428225e-22), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898944208119425818354071610739694e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.2223596820025698978388721231765020943981e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.0622893414325990208903355818521702872992e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.0000504010851221897512701578411618873535e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.4088417953256874960144306274638713889359e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4116359038863142486394041026216980587618e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1345807614762445720793123459856905957437e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1094449794965494931192309212430617272893e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0283696703757190182168855620148932066571e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0202396082815554604572628337464787906771e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9636504599787494793700149328671981350567e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4024669571251856037905211219835033276127e-21), SC_(5.2223596820025698978388721231765020943981e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176397294675050763212982182755057e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4024669571251856037905211219835033276127e-21), SC_(5.0622893414325990208903355818521702872992e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342451691498939300245250003910737e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4024669571251856037905211219835033276127e-21), SC_(4.0000504010851221897512701578411618873535e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876758930002545399194099268767578e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4024669571251856037905211219835033276127e-21), SC_(3.4088417953256874960144306274638713889359e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373561007797308371958145593381168328e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.4116359038863142486394041026216980587618e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029160240954929468463411044031337e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.1345807614762445720793123459856905957437e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881312577954892475439812118683832e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.1094449794965494931192309212430617272893e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718302515711594960846672332617145e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.0283696703757190182168855620148932066571e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043259160771804740510367519549686e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(2.0202396082815554604572628337464787906771e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789569841757625033238742560044114e-01) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.9636504599787494793700149328671981350567e+00) }}, 
      {{ SC_(1.4024669571251856037905211219835033276127e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898937904825872701592027987201180e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1454153884488314492432094136818078800029e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.9877950571049644539443587016895091509868e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.9417292391136363076297774670311460393608e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3594491109946233281868909168898251742526e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3771553833222281230691403398674884520657e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1042033616932371457522999027274364827406e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0794388305017545510823862548724896395734e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9995597871820695172918803375178616503037e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9915495812137788255519039725725190251189e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9357941580816700202876524764893025534051e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0458090701845262557668142034197900080983e-21), SC_(5.1454153884488314492432094136818078800029e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176327447563140243510389432717527e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0458090701845262557668142034197900080983e-21), SC_(4.9877950571049644539443587016895091509868e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342386221622022016521511759058420e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.9417292391136363076297774670311460393608e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876718801961752223201091024643845e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0458090701845262557668142034197900080983e-21), SC_(3.3594491109946233281868909168898251742526e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560979015314351940285905616768887e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.3771553833222281230691403398674884520657e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029146214650914905131274831024491e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.1042033616932371457522999027274364827406e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881301691240900639970160313144261e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(2.0794388305017545510823862548724896395734e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718291893470783395536722661723043e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9995597871820695172918803375178616503037e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043249368609235359968841595373578e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9915495812137788255519039725725190251189e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789560130901135610939824920818788e-01) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9357941580816700202876524764893025534051e+00) }}, 
      {{ SC_(3.0458090701845262557668142034197900080983e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898928750159092004872255506746148e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1313665447183708079084973042990055112794e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.9741935473503714474420528761583394201690e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.9310806925759511881870337857090716708922e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3504307670532307078474139022379860163582e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3708597709671486116757350616336558980044e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0986569160404332384257952792865026514184e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0739601695288472092854624601147800523946e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9942995459323694471243934588607379859734e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9863112238479219452536704222817450033499e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9307080260998709699646708863964581694818e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5091263406486883653093633225750203052939e-21), SC_(5.1313665447183708079084973042990055112794e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176311504843719861245839133800195e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5091263406486883653093633225750203052939e-21), SC_(4.9741935473503714474420528761583394201690e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342371278013766366851504595882840e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.9310806925759511881870337857090716708922e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876709642669724868360815569002444e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5091263406486883653093633225750203052939e-21), SC_(3.3504307670532307078474139022379860163582e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560972445776364332908927805139456e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.3708597709671486116757350616336558980044e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029143013123703643236641550769029e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.0986569160404332384257952792865026514184e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881299206330331903930134962949963e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(2.0739601695288472092854624601147800523946e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718289468926657765560013568641111e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9942995459323694471243934588607379859734e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043247133531848585116041348806730e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9863112238479219452536704222817450033499e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789557914381996764905610717769342e-01) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9307080260998709699646708863964581694818e+00) }}, 
      {{ SC_(3.5091263406486883653093633225750203052939e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898926660591178888674829561142406e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.0354761717007285771428377850684729977156e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.8813564520709111621314904928396548166130e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.8583990456600260578555001261965024234860e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2888760668136276035524341937858264801213e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3278890732581167696220804064695999320738e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0607996551317443335105211427365755171088e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0365655729051962318809518647975358944338e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9583957729761028537453205558481062170337e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9505568193254609306435076551766011713304e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8959926358294092230792709889769448089237e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.2244855466440840911323921502695810659134e-21), SC_(5.0354761717007285771428377850684729977156e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194176166583074015798154223210383416e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.2244855466440840911323921502695810659134e-21), SC_(4.8813564520709111621314904928396548166130e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342235438318099094686038106390048e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.2244855466440840911323921502695810659134e-21), SC_(3.8583990456600260578555001261965024234860e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876626383297541123451286122489295e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.2244855466440840911323921502695810659134e-21), SC_(3.2888760668136276035524341937858264801213e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560912727666410825812924324733706e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.3278890732581167696220804064695999320738e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029113910749323257059736707736861e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.0607996551317443335105211427365755171088e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881276618111366038830723756457431e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(2.0365655729051962318809518647975358944338e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718267429447937213232207406556814e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.9583957729761028537453205558481062170337e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043226816334902615906868164106069e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.9505568193254609306435076551766011713304e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789537765882376612034027481654547e-01) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.8959926358294092230792709889769448089237e+00) }}, 
      {{ SC_(9.2244855466440840911323921502695810659134e-21), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898907666097711249486018929465707e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.9363184506933845130150045283779526320457e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.7853560455320891652994467073800568172688e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.7832408599064089022604916114811756844576e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2252239649292570592620880544075228147406e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.2834542012179468156735082723338726734197e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0216524540399792289390697651923585807041e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9978968008220179702424739806400236358291e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9212686225659829356202117277913903040575e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9135841268971018357431652272669640034241e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8600943608016732600634284027533706081789e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5060373697831631136892266593918510153571e-20), SC_(4.9363184506933845130150045283779526320457e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194175921437529021480545666073144011e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5060373697831631136892266593918510153571e-20), SC_(4.7853560455320891652994467073800568172688e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725342005655751309900816807357255863e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5060373697831631136892266593918510153571e-20), SC_(3.7832408599064089022604916114811756844576e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876485544110912194907864060259455e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5060373697831631136892266593918510153571e-20), SC_(3.2252239649292570592620880544075228147406e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560811710209609416289331594019776e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.2834542012179468156735082723338726734197e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029064682000304128826481452522978e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(2.0216524540399792289390697651923585807041e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881238408522425761954395565047506e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9978968008220179702424739806400236358291e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718230148092393292665367779939577e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9212686225659829356202117277913903040575e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043192448342238053711495203838555e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9135841268971018357431652272669640034241e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789503683253311742695718647068836e-01) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.8600943608016732600634284027533706081789e+00) }}, 
      {{ SC_(2.5060373697831631136892266593918510153571e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898875535552641520534449406314134e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.9094668457112632933791620356874448558726e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.7593594315688399046511798424386320556594e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.7628882550408780813946870866425021520149e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2079871720832994210504887675768588996246e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.2714213749354087511819608433181268868409e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0110515127396654879866051875307242616696e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9874254166214444533701922504489775511457e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9112147047591133802045649058064974927038e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9035720358352446039878943832787214884359e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8503732186577052673215231869043213330486e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.2849267904344328986699199160459450297367e-20), SC_(4.9094668457112632933791620356874448558726e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194175831117188226470655717860975694e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.2849267904344328986699199160459450297367e-20), SC_(4.7593594315688399046511798424386320556594e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725341920995678284131745672127673469e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.7628882550408780813946870866425021520149e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876433653943648692048597200856788e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2849267904344328986699199160459450297367e-20), SC_(3.2079871720832994210504887675768588996246e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560774491784429373278225838208560e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.2714213749354087511819608433181268868409e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638029046544377658547736915919452988e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(2.0110515127396654879866051875307242616696e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881224330750403305758745343361879e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9874254166214444533701922504489775511457e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718216412314579618084325969740003e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9112147047591133802045649058064974927038e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043179785950963509463750652584115e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9035720358352446039878943832787214884359e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789491126000140260844988891780171e-01) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.8503732186577052673215231869043213330486e+00) }}, 
      {{ SC_(3.2849267904344328986699199160459450297367e-20), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898863697516666935742065768362993e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.7943258265081256449208612222011635423749e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.6478846564277609087659257817475512398756e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6756152719467095399136410341303534817401e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.1340749460767581168997972350595909152173e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.2198240166773741747428328532694215211952e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9655941485842087966693148786670341323156e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9425235997607965628128163891196366561750e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8681030045818495015522610764050612412314e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8606396908233004651442902548391188821627e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8086884770930829036996162909223959978583e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0484196316561675708982576474270764776975e-19), SC_(4.7943258265081256449208612222011635423749e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194175269840712522739750838488451052e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0484196316561675708982576474270764776975e-19), SC_(4.6478846564277609087659257817475512398756e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725341394893728241572928477255845616e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0484196316561675708982576474270764776975e-19), SC_(3.6756152719467095399136410341303534817401e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190876111193577034055545740964037228e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0484196316561675708982576474270764776975e-19), SC_(3.1340749460767581168997972350595909152173e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560543205826774477049616360649825e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(2.2198240166773741747428328532694215211952e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638028933831993862235941871677575152e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.9655941485842087966693148786670341323156e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881136847441581637975236973799989e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.9425235997607965628128163891196366561750e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718131054255757324445943635730688e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8681030045818495015522610764050612412314e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043101098223635257452003950080477e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8606396908233004651442902548391188821627e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789413091631107939522483514989039e-01) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.8086884770930829036996162909223959978583e+00) }}, 
      {{ SC_(1.0484196316561675708982576474270764776975e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898790132569361673187563795443358e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.7394439618913182930656848526707564494947e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.5947503037893831671935392808115997016516e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6340166820086716028132027934746568810019e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0988447491470150511490065033440923258775e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1952301816557610115956020306965154517021e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9439269363024132113237996734484762793147e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9211211886040295746799395452663343034148e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8475538509535089450483094941448160581189e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8401760266753338571221404852144156671355e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7888194820210480983373927470358812954921e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8229333961140025508894553507577285245134e-19), SC_(4.7394439618913182930656848526707564494947e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194174863636496980715891982104215085e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8229333961140025508894553507577285245134e-19), SC_(4.5947503037893831671935392808115997016516e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725341014145845222810824779723329802e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8229333961140025508894553507577285245134e-19), SC_(3.6340166820086716028132027934746568810019e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190875877824166529051594567042986405e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8229333961140025508894553507577285245134e-19), SC_(3.0988447491470150511490065033440923258775e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560375820705424812412637401654268e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(2.1952301816557610115956020306965154517021e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638028852260348826845065384077717479e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.9439269363024132113237996734484762793147e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513881073534457032990293205315007257e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.9211211886040295746799395452663343034148e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124718069279346553376843971913495874e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8475538509535089450483094941448160581189e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532043044150733518470943200476385198e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8401760266753338571221404852144156671355e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789356616986203021389702023090178e-01) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.7888194820210480983373927470358812954921e+00) }}, 
      {{ SC_(1.8229333961140025508894553507577285245134e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898736892512089028980929299146324e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.6708286129672249790232740601712659018171e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.5283197593537339203510184598929194980036e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5820085772681006745595248113223671153511e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0547986462699174116220690334325916501016e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1644820541427468378204638654655763903875e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9168377814184060961677549677519204129877e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8943630979379784461011080336924110164167e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8218625345933941972222133458013237118324e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8145915924440635709126285106649142650408e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7639785251920913788323915901247080664371e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.6401757896136402713757954097140157045942e-19), SC_(4.6708286129672249790232740601712659018171e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194174169153132864982302095772664719e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.6401757896136402713757954097140157045942e-19), SC_(4.5283197593537339203510184598929194980036e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725340363184923199034785434911305776e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.5820085772681006745595248113223671153511e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190875478834773780707154105158906105e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.6401757896136402713757954097140157045942e-19), SC_(3.0547986462699174116220690334325916501016e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373560089644004809989361109374891982e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(2.1644820541427468378204638654655763903875e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638028712798107189586532827800153224e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.9168377814184060961677549677519204129877e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513880965288868187882095165011416001e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8943630979379784461011080336924110164167e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124717963663390042941983211108781290e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8218625345933941972222133458013237118324e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532042946788168084337239199674426314e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8145915924440635709126285106649142650408e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789260062839590963356082572075530e-01) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.7639785251920913788323915901247080664371e+00) }}, 
      {{ SC_(3.6401757896136402713757954097140157045942e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898645868508233946506674233752215e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.6201619400405605516306924773688334132778e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.4792663810639176388846470799914533612401e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5436049595099033903517449927138108389436e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0222742982463150746725448141849969454020e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1417771441738022024125385634092627784402e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8968347154588332723873360130632241493398e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8746044951008981465775473518639090262999e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8028916549945246589425171857197747073299e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7956996363214829714532847231716283455922e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7456355646945721636002046674679147108742e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0660607797570928288862987520779768146895e-19), SC_(4.6201619400405605516306924773688334132778e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194173478095103704422419809154056385e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0660607797570928288862987520779768146895e-19), SC_(4.4792663810639176388846470799914533612401e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725339715434674483054540220470706295e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0660607797570928288862987520779768146895e-19), SC_(3.5436049595099033903517449927138108389436e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190875081813278869346604293679821324e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.0660607797570928288862987520779768146895e-19), SC_(3.0222742982463150746725448141849969454020e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373559804878786604592867154724786426e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(2.1417771441738022024125385634092627784402e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638028574023722041012020149402853714e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8968347154588332723873360130632241493398e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513880857577168872588455234584034850e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8746044951008981465775473518639090262999e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124717858568353174229862068652753692e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8028916549945246589425171857197747073299e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532042849905814867847187391103980549e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.7956996363214829714532847231716283455922e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979789163984917908473707592738853712e-01) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.7456355646945721636002046674679147108742e+00) }}, 
      {{ SC_(6.0660607797570928288862987520779768146895e-19), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898555293453505760555569999415475e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.5287252035864469563741596458183518923703e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.3907411126026961956578379260983706531115e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.4742990178917633408290200315174644969891e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.9635785113159104196844448195256075458048e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1008022241894233910642507675904973699403e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8607357382659346914304970420570338990438e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8389466937108088898097160854127205082686e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7686554358392766530932823596893080656922e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7616058481703768685360234499643762428368e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7125325336898028034389624030041543232816e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5245964393311865802196902741627582145156e-18), SC_(4.5287252035864469563741596458183518923703e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194171683041353746955703385677283279e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.5245964393311865802196902741627582145156e-18), SC_(4.3907411126026961956578379260983706531115e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725338032874796827695372342047204285e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5245964393311865802196902741627582145156e-18), SC_(3.4742990178917633408290200315174644969891e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190874050532412142381397193047342924e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.9635785113159104196844448195256075458048e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373559065188556196605302934418922861e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(2.1008022241894233910642507675904973699403e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638028213551127901394514954592767580e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8607357382659346914304970420570338990438e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513880577791273009997901581472268162e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8389466937108088898097160854127205082686e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124717585579353576638614365487178550e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.7686554358392766530932823596893080656922e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532042598249623754750521593057146234e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.7616058481703768685360234499643762428368e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979788914418273231163287371253943250e-01) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.7125325336898028034389624030041543232816e+00) }}, 
      {{ SC_(1.5245964393311865802196902741627582145156e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898320020748766135262460132808374e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.4609243744155507630809963412547863494706e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.3250991525218147750657378943241595769544e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.4229082914681693178120481114312305379988e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.9200552713464172776178835343581920442786e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0704191018483697976151734225193663027889e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8339681535859186596627668138511771407749e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8125062432484015430079893734701087904239e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7432690962079707842446613484922601851309e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7363251218904979787751292989905903008326e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6879864591334391402213360878974262336393e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0195417624247973304059400323495765405823e-18), SC_(4.4609243744155507630809963412547863494706e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194169702767258790682280845697382141e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0195417624247973304059400323495765405823e-18), SC_(4.3250991525218147750657378943241595769544e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725336176702111732050095452471042015e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.0195417624247973304059400323495765405823e-18), SC_(3.4229082914681693178120481114312305379988e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190872912840136841035449787922098307e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.9200552713464172776178835343581920442786e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373558249174327273232413352809428043e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(2.0704191018483697976151734225193663027889e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638027815883626194466165322103167637e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8339681535859186596627668138511771407749e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513880269136024233154355125293402023e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8125062432484015430079893734701087904239e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124717284422330187658565385265947575e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.7432690962079707842446613484922601851309e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532042320626607644495202038242118980e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.7363251218904979787751292989905903008326e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979788639100410756204700237827831620e-01) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.6879864591334391402213360878974262336393e+00) }}, 
      {{ SC_(3.0195417624247973304059400323495765405823e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247898060471728297176608850372299105e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.3920125065054665342993373830330290250128e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2583815306613072182407061996572759966040e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3706754354041292994169551548416153212626e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8758188246764691947173152990895525423009e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0395380973080688491218589959079541394336e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8067619338051572827297169557557012544103e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7856325183687850523076545502152121027134e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7174667556645599563164016115696871218208e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7106301253635553359896777307945835571249e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6630381529220852711187666356724219535683e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0477044011936223152393898860879062340246e-18), SC_(4.3920125065054665342993373830330290250128e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194166861821734656075286643148242946e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0477044011936223152393898860879062340246e-18), SC_(4.2583815306613072182407061996572759966040e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725333513795246866017419864195438148e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0477044011936223152393898860879062340246e-18), SC_(3.3706754354041292994169551548416153212626e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190871280681343398592436279612163717e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.8758188246764691947173152990895525423009e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373557078502056523962976654704786627e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(2.0395380973080688491218589959079541394336e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638027245380930600696200973689324658e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8067619338051572827297169557557012544103e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513879826332298300528315311027682525e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.7856325183687850523076545502152121027134e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124716852375726165848645983799296048e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.7174667556645599563164016115696871218208e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532041922342417027564806193322328835e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.7106301253635553359896777307945835571249e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979788244123245121254262518254187562e-01) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.6630381529220852711187666356724219535683e+00) }}, 
      {{ SC_(6.0477044011936223152393898860879062340246e-18), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247897688116896224872230200450319233e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.3398297847280150412654758604847308634846e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2078603765439535859282320305721658546074e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3311227040924794006192062083663360227007e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8423212826854012885258607082747058469439e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0161538107257147486108270575552038947835e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7861603358440038155081562960126329472994e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7652826983588765527144321340230869409703e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6979282291579111235772412354445478639192e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6911728838824864553471252792464192005392e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6441463341203599085601844418000547557015e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0233193632958864486594274811892546495073e-17), SC_(4.3398297847280150412654758604847308634846e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194163949203287580065252438671105472e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0233193632958864486594274811892546495073e-17), SC_(4.2078603765439535859282320305721658546074e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725330783707115424992820297988225663e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0233193632958864486594274811892546495073e-17), SC_(3.3311227040924794006192062083663360227007e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190869607345557754514974605444257119e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.8423212826854012885258607082747058469439e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373555878295427225298030431788589341e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(2.0161538107257147486108270575552038947835e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638026660485281815595270210363877552e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.7861603358440038155081562960126329472994e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513879372357278432459504796225972783e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.7652826983588765527144321340230869409703e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124716409429214747398227560784172048e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6979282291579111235772412354445478639192e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532041514010095594459944168061156948e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6911728838824864553471252792464192005392e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979787839181380100140697434005243867e-01) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.6441463341203599085601844418000547557015e+00) }}, 
      {{ SC_(1.0233193632958864486594274811892546495073e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247897306368093336576188767328111758e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2767732092283516335624081241756572740851e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.1468116067515814533437412564689938012473e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.2833279608667886925066853550904590104804e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8018435112379634499068374490397327783460e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9878966983682076889343726563409173890303e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7612657697308862617836358313913406347508e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7406923757740965551787268506999334415657e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6743182576989090278426533850529722567787e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6676611356509797316131764931604760331330e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6213178315428706548592673899042082065908e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9321026667662503885011804349858266505180e-17), SC_(4.2767732092283516335624081241756572740851e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194159237561728717020667631947261809e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9321026667662503885011804349858266505180e-17), SC_(4.1468116067515814533437412564689938012473e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725326367338499586105904969723165973e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9321026667662503885011804349858266505180e-17), SC_(3.2833279608667886925066853550904590104804e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190866900448456946761039021357912652e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9321026667662503885011804349858266505180e-17), SC_(2.8018435112379634499068374490397327783460e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373553936762906851886554131357547761e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9878966983682076889343726563409173890303e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638025714319933711183380449961304289e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.7612657697308862617836358313913406347508e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513878637977678236616089110992102304e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.7406923757740965551787268506999334415657e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124715692890049093233579603646692167e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6743182576989090278426533850529722567787e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532040853465101180286679287104835982e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6676611356509797316131764931604760331330e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979787184121009101852103039178780096e-01) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.6213178315428706548592673899042082065908e+00) }}, 
      {{ SC_(1.9321026667662503885011804349858266505180e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247896688826332284186782667224568427e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2058973797922962263933912546979588898816e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.0781925585270505225709868569237225983719e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.2296064886497920447564622718705800035557e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7563463429834718646089229852797236734730e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9561355971676387740913043425355982257906e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7332841832311984860008513423313823590773e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7130527601513650046389527869868848350257e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6477805604507084628463014653686495954369e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6412338416821113595711388414695505534577e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5956585082741765544800343810231321309949e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.9470861839323539803359164324092489550821e-17), SC_(4.2058973797922962263933912546979588898816e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194151807596980173058141935207554658e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.9470861839323539803359164324092489550821e-17), SC_(4.0781925585270505225709868569237225983719e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725319403000758096475197792555143507e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.9470861839323539803359164324092489550821e-17), SC_(3.2296064886497920447564622718705800035557e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190862631840629289762653404128603743e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.9470861839323539803359164324092489550821e-17), SC_(2.7563463429834718646089229852797236734730e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373550875087266464357871120451637805e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.9561355971676387740913043425355982257906e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638024222276216728928804500546354450e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.7332841832311984860008513423313823590773e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513877479906871082820270645580741508e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.7130527601513650046389527869868848350257e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124714562952494037157500975920037018e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6477805604507084628463014653686495954369e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532039811826860349369861507069496296e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.6412338416821113595711388414695505534577e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979786151131677178492951492066975306e-01) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.5956585082741765544800343810231321309949e+00) }}, 
      {{ SC_(3.9470861839323539803359164324092489550821e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247895715001507229595287541215969906e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.1220500373191945926835913955564541247664e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.9970150275910438302946303562141740680764e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1660530499813722103794457461931725473646e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7025223993549541364806909444794409142613e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9185616604549884988231792883018162857803e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7001814783338007468512304220484926003845e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6803546127662267133077125185082125421433e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6163860017228297026347920760952838863576e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6099698919593895919259236762849440145731e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5653030812850746441637960645622796341413e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.1897463183816027049166663687174150254577e-17), SC_(4.1220500373191945926835913955564541247664e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194138799425228479458013446155443501e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.1897463183816027049166663687174150254577e-17), SC_(3.9970150275910438302946303562141740680764e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725307210035576372569736056448076985e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.1897463183816027049166663687174150254577e-17), SC_(3.1660530499813722103794457461931725473646e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190855158482995319923201088004814401e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.1897463183816027049166663687174150254577e-17), SC_(2.7025223993549541364806909444794409142613e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373545514792307127076319852881966245e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.9185616604549884988231792883018162857803e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638021610048353331740522548330592266e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.7001814783338007468512304220484926003845e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513875452389315174305169778748952931e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6803546127662267133077125185082125421433e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124712584689838754429107407431433899e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6163860017228297026347920760952838863576e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532037988156142480494453023872549569e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.6099698919593895919259236762849440145731e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979784342603223961184479685706325937e-01) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.5653030812850746441637960645622796341413e+00) }}, 
      {{ SC_(9.1897463183816027049166663687174150254577e-17), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247894010056596233455059517909219027e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.0873884880689085065787673041633728719446e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.9634571484315741016253039827360474434997e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1397807725369540806077776400228002660475e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.6802721858371794538422257253029956172318e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9030290172074047991901629542233691350152e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6864971920788496953564782403998349244017e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6668375660411421276227505906367232890165e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6034078439012331527043112679388844361841e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5970457264329720128956391504701125759350e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5527544888483643690295130437178026248512e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3032517747881629428807759296660151449032e-16), SC_(4.0873884880689085065787673041633728719446e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194131595177493042671334252845958878e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3032517747881629428807759296660151449032e-16), SC_(3.9634571484315741016253039827360474434997e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725300457269432314301406268578407668e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3032517747881629428807759296660151449032e-16), SC_(3.1397807725369540806077776400228002660475e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190851019552417773396294611628902303e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3032517747881629428807759296660151449032e-16), SC_(2.6802721858371794538422257253029956172318e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373542546128180431983374748579497970e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.9030290172074047991901629542233691350152e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638020163331855666891828797084560406e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6864971920788496953564782403998349244017e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513874329499869477775493334500173996e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6668375660411421276227505906367232890165e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124711489078977103584634553418292072e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.6034078439012331527043112679388844361841e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532036978162125123365292727284450081e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.5970457264329720128956391504701125759350e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979783340995367853009620435937921733e-01) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.5527544888483643690295130437178026248512e+00) }}, 
      {{ SC_(1.3032517747881629428807759296660151449032e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247893065815871647520798626072528499e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.0188447849959411195427719080367990149236e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.8970959685473186835598518495052407403067e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.0878269729188959952474843223715241778702e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.6362720744266981338255228327330168503129e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8723129958601500572816894134976883632240e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6594363227838307466093262652862343058376e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6401074152779018782943030621494847526556e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5777433535538987513390403247404201586793e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5714880066117399566090794514178949969390e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5279394701152229411958815795003095539404e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.6005563194954166295058683999741333536804e-16), SC_(4.0188447849959411195427719080367990149236e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194113049018319288211238329183645343e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6005563194954166295058683999741333536804e-16), SC_(3.8970959685473186835598518495052407403067e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725283073375877560507093024776828252e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6005563194954166295058683999741333536804e-16), SC_(3.0878269729188959952474843223715241778702e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190840364551626829699519181777362489e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.6005563194954166295058683999741333536804e-16), SC_(2.6362720744266981338255228327330168503129e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373534903787235328806830233645447124e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8723129958601500572816894134976883632240e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638016438996512768782365260930536870e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6594363227838307466093262652862343058376e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513871438804383698522725517742801612e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6401074152779018782943030621494847526556e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124708668607750752493333312929819709e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.5777433535538987513390403247404201586793e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532034378097481281330931017021729945e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.5714880066117399566090794514178949969390e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979780762519526500999949089615079446e-01) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.5279394701152229411958815795003095539404e+00) }}, 
      {{ SC_(2.6005563194954166295058683999741333536804e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247890635022341080918026767764217431e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.9395758260933004703430830329411421826328e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.8203510393249230218551540214822574648922e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.0277437935438954720390542155570446277765e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5853871226843606650039421952742199171641e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8367907388960609851308877280049973739209e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6281411513844527369373516562177898321215e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6091947110130467839429828191947985153446e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5480630570511788021632586344858058476073e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5419311873661009430909035038596732951956e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4992415648090034221101263965961584170753e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.7816541979623537611532313462703314144164e-16), SC_(3.9395758260933004703430830329411421826328e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194081869283426733226182861074469465e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.7816541979623537611532313462703314144164e-16), SC_(3.8203510393249230218551540214822574648922e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725253847637685976749678615621317834e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.7816541979623537611532313462703314144164e-16), SC_(3.0277437935438954720390542155570446277765e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190822451403303915076754869869165306e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.7816541979623537611532313462703314144164e-16), SC_(2.5853871226843606650039421952742199171641e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373522055511613280974327508125196101e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8367907388960609851308877280049973739209e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967638010177657564864056527217677940401e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6281411513844527369373516562177898321215e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513866578977712060154626240812616364e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6091947110130467839429828191947985153446e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124703926841847020595069963427735705e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.5480630570511788021632586344858058476073e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532030006878317313322212533452597381e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.5419311873661009430909035038596732951956e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979776427595378259028744876833808673e-01) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.4992415648090034221101263965961584170753e+00) }}, 
      {{ SC_(5.7816541979623537611532313462703314144164e-16), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247886548381153183238639745823351062e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.8439834166293653153686462064422924427011e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.7278024200410688922505763516625902373291e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.9552879928847198642569856056457387977663e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5240236935458449353722524171958798085743e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7939535655585768233677467829351999143146e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5904015256839602941109124388841657939428e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5719163119444660484960076336618286159192e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5122708491607772759561180985649786230462e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5062878837716781443984349184174910195495e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4646340469007798498715036931063132615324e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5152733329692157082657644195933244191110e-15), SC_(3.8439834166293653153686462064422924427011e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169194023274846100275466976055298074540e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.5152733329692157082657644195933244191110e-15), SC_(3.7278024200410688922505763516625902373291e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725198925243673291651446901139874172e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.9552879928847198642569856056457387977663e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190788788164945853239886561271729231e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.5152733329692157082657644195933244191110e-15), SC_(2.5240236935458449353722524171958798085743e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373497910422367292255737792938663773e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.7939535655585768233677467829351999143146e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637998411052282733636468799175892580e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5904015256839602941109124388841657939428e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513857446160806387049639053767926333e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5719163119444660484960076336618286159192e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124695015890338848796868717380183981e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5122708491607772759561180985649786230462e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532021792275826455224183883896002750e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.5062878837716781443984349184174910195495e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979768281200203302495806412746554415e-01) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.4646340469007798498715036931063132615324e+00) }}, 
      {{ SC_(1.5152733329692157082657644195933244191110e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247878868571099378399076917647808671e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.7700444081523159197591680618674050919071e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.6562177284934643846442532427457202352283e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.8992447349608636833283517648376457685760e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4765601853792754877717008910112325717445e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7608197828629116118655210270480331926740e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5612106043520510893898218236372452634542e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5430821411122879635424129597894948198367e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4845862204600104375562588772732142158930e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4787184298642278608303239164310369960885e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4378657545820139151205085221468085286929e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.7700444081523159197591680618674050919071e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193954068144256344506182700633636044e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1926103267695439547058100515641854144633e-15), SC_(3.6562177284934643846442532427457202352283e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725134055643058717395388509640693737e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.8992447349608636833283517648376457685760e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190749028047615604067200053185733394e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.1926103267695439547058100515641854144633e-15), SC_(2.4765601853792754877717008910112325717445e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373469392322839192520618917892407073e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.7608197828629116118655210270480331926740e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637984513351700476483181349655823992e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.5612106043520510893898218236372452634542e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513846659264176599009652871621466590e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.5430821411122879635424129597894948198367e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124684491042004887293070571647585263e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.4845862204600104375562588772732142158930e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532012089894967623548915343783078119e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.4787184298642278608303239164310369960885e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979758659379950580405344799328150808e-01) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.4378657545820139151205085221468085286929e+00) }}, 
      {{ SC_(3.1926103267695439547058100515641854144633e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247869797840999766876197597869460057e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.7563320143230155522948435114879895201188e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.6429419556251491531547891015336001198032e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.8888512060245443323695879894033795735984e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4677578179969453007538120423507289518073e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7546749415033138961871085962756879987150e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5557969882137239129216425163101601341297e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5377346863068197646699817907790208760314e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4794519545348634725018679176058183090650e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4736055237349139044458902220796056305166e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4329014282545018417738426549337015127171e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.7563320143230155522948435114879895201188e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193938150300748587814801826882562348e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.6658061297861060934266674848913680762053e-15), SC_(3.6429419556251491531547891015336001198032e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176725119135351763333251900572447553903e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.8888512060245443323695879894033795735984e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190739883047071345819270490922170277e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.6658061297861060934266674848913680762053e-15), SC_(2.4677578179969453007538120423507289518073e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373462833035459795545259048971280810e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.7546749415033138961871085962756879987150e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637981316819897873679414165549726601e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.5557969882137239129216425163101601341297e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513844178230862446147231611990314254e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.5377346863068197646699817907790208760314e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124682070280942685258456599660328150e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.4794519545348634725018679176058183090650e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670532009858305015001026908409632288008e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.4736055237349139044458902220796056305166e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979756446319289033381882223981546416e-01) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.4329014282545018417738426549337015127171e+00) }}, 
      {{ SC_(3.6658061297861060934266674848913680762053e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247867711533479106789338277082249503e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.6633852206341868577010194416591996476428e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5529547121713922890790784173797686046958e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.8184006922944966547199379718396256479919e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4080926832842513390003914668792318206540e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7130233298874993196540791242031729417002e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5191018444931264825022939064679611277293e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5014880043086592457291303271153911299390e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4446503318839359188888182784079314726903e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4389486843042789273309153135570536034023e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3992517081026975039958917728168792916076e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.3546521982672270478786913372459821403027e-15), SC_(3.6633852206341868577010194416591996476428e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193795719959249651649189851083616504e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.3546521982672270478786913372459821403027e-15), SC_(3.5529547121713922890790784173797686046958e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176724985630949370275682161109727757817e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.8184006922944966547199379718396256479919e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190658055031117562802602585745216347e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.3546521982672270478786913372459821403027e-15), SC_(2.4080926832842513390003914668792318206540e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373404141571187102021886225783762177e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.7130233298874993196540791242031729417002e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637952714759724970612541469066544238e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.5191018444931264825022939064679611277293e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513821978337807006306302923851911695e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.5014880043086592457291303271153911299390e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124660409694448854659148084634090192e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.4446503318839359188888182784079314726903e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531989890391639740618664503917464484e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.4389486843042789273309153135570536034023e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979736644203074776637064099292093681e-01) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.3992517081026975039958917728168792916076e+00) }}, 
      {{ SC_(9.3546521982672270478786913372459821403027e-15), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247849043584288452977526982204151036e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5976470622881468392631573491895808817123e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.4893097447173108589706043326692853518012e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.7685734003208695342697246123061976740620e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3658935291465404531882832223239010533528e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6835645381304117168602077533606326261123e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4931485966972827052027869746223666281564e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4758519384892093345595403594210824444294e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4200363082072828462781093947446117605039e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4144370609567142045366839473801821561788e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3754523865355122772043589984711903260388e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8146163011881905058331199143140111118555e-14), SC_(3.5976470622881468392631573491895808817123e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193646144413901377628918654049610094e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8146163011881905058331199143140111118555e-14), SC_(3.4893097447173108589706043326692853518012e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176724845429124453391153690376818755429e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.7685734003208695342697246123061976740620e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190572122005777001656165039936634916e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8146163011881905058331199143140111118555e-14), SC_(2.3658935291465404531882832223239010533528e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373342505772804396999330389343697288e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6835645381304117168602077533606326261123e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637922677839707009827872562638833562e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.4931485966972827052027869746223666281564e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513798664757998645669678456137308003e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.4758519384892093345595403594210824444294e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124637662476221862444403559693539670e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.4200363082072828462781093947446117605039e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531968920761694784435795575021914902e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.4144370609567142045366839473801821561788e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979715848687722535123708360435687850e-01) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.3754523865355122772043589984711903260388e+00) }}, 
      {{ SC_(1.8146163011881905058331199143140111118555e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247829439132933994848146046258625269e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.4908990099054643170389185973591939623879e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3859606931068366767000857393577566752947e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6876620011044599424402943314409616249806e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.2973689822207648225322720274927350447998e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6357282627503974324269057783178979887005e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4510047532292615304687432009047263821409e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4342231468431863799827902643059969377909e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3800671463857263518713716338642719581869e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3746341805760825857495829152212345017421e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3368061681252993866630313026990454618883e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3217629955581990941482217749580740928650e-14), SC_(3.4908990099054643170389185973591939623879e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193268224190296129722139362422149847e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3217629955581990941482217749580740928650e-14), SC_(3.3859606931068366767000857393577566752947e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176724491192708772564079084819367791908e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.6876620011044599424402943314409616249806e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190355002099977729207956338711418708e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3217629955581990941482217749580740928650e-14), SC_(2.2973689822207648225322720274927350447998e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373186775671157189535554004026198314e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6357282627503974324269057783178979887005e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637846786024410816410940241799764886e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.4510047532292615304687432009047263821409e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513739760253354990388402013565597538e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.4342231468431863799827902643059969377909e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124580188950798856914424365279222740e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.3800671463857263518713716338642719581869e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531915938522367007554390555327488460e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.3746341805760825857495829152212345017421e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979663306369414349366888630830832280e-01) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.3368061681252993866630313026990454618883e+00) }}, 
      {{ SC_(5.3217629955581990941482217749580740928650e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247779906178058448347450658812979338e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.4798814507569889361511591318220476572908e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3752939477785448015039600329542215467063e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6793110653566399661643613631133361622118e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.2902965042502000508672160772246505747379e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6307910392444108205493781547073891772134e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4466550505621958888732888164359242906531e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4299266031217570713974752144149258705269e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3759418944991127530666421459923545155841e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3705260907413265321329710165890694691949e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3328174583765443015590677250435519288393e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.9467947059743675453091782401315867900848e-14), SC_(3.4798814507569889361511591318220476572908e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169193216364315913514412987917544969662e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.9467947059743675453091782401315867900848e-14), SC_(3.3752939477785448015039600329542215467063e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176724442582830598658841048968664449225e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.6793110653566399661643613631133361622118e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190325207951943893769471326090398172e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.9467947059743675453091782401315867900848e-14), SC_(2.2902965042502000508672160772246505747379e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008373165405701905040881941521360252376e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6307910392444108205493781547073891772134e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637836371815805274954222102099751273e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.4466550505621958888732888164359242906531e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513731677118206260424423460729641696e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.4299266031217570713974752144149258705269e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124572302180910600317188546678460545e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.3759418944991127530666421459923545155841e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531908668066504455455984750889284843e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.3705260907413265321329710165890694691949e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979656096281448405725287967870924266e-01) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.3328174583765443015590677250435519288393e+00) }}, 
      {{ SC_(5.9467947059743675453091782401315867900848e-14), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247773109048174744761917944693858903e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.4017994326610841092221691109646830255092e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.2996981655799667862075297276875127056164e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6201275468121304036727081750659979846347e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.2401734828587558242756456271419083831465e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5958006779545123424189718151436593695577e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4158284801953256771131727445663420284640e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3994767729837523254146430343850990048803e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3467060185559998915540878579545089359333e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3414118431576029781432722010699347780107e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3045492637079719515947232976976245764841e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3063909762994763141819021257106214761734e-13), SC_(3.4017994326610841092221691109646830255092e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169192753403664435268797549635098785727e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3063909762994763141819021257106214761734e-13), SC_(3.2996981655799667862075297276875127056164e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176724008635368322989562897649548540142e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.6201275468121304036727081750659979846347e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625190059231251918637935924534327659725e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3063909762994763141819021257106214761734e-13), SC_(2.2401734828587558242756456271419083831465e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008372974632872679903494745671033954062e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.5958006779545123424189718151436593695577e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637743402657814271476411464551283172e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.4158284801953256771131727445663420284640e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513659517792617024794496355315905226e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3994767729837523254146430343850990048803e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124501895836614914650251875578690310e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3467060185559998915540878579545089359333e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531843763647323949639834301239056526e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3414118431576029781432722010699347780107e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979591730775277722035741255878525527e-01) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.3045492637079719515947232976976245764841e+00) }}, 
      {{ SC_(1.3063909762994763141819021257106214761734e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247712430078981086690268474227854282e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.3376219033053713767226872506008162902110e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.2375641346016899439956068065680301690956e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5714831586240652564929201766751224218590e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.1989761399212883089410856076969160048816e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5670412402041792664114896539906370195318e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3904913645200379264834675609896072617416e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3744493093600777254413275469044047054818e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3226763337151876295102397404079492286115e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3174821276541048102659376061056477060061e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2813149398852051028099970887468424914076e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4945887369676178479949157917872071266174e-13), SC_(3.3376219033053713767226872506008162902110e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169192209968273544465138096178894873695e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4945887369676178479949157917872071266174e-13), SC_(3.2375641346016899439956068065680301690956e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176723499256421464390662175324209773891e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.5714831586240652564929201766751224218590e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625189747020801898551094457842421084954e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4945887369676178479949157917872071266174e-13), SC_(2.1989761399212883089410856076969160048816e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008372750698704259747934561766542804788e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.5670412402041792664114896539906370195318e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637634273012210542744121492966750577e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.3904913645200379264834675609896072617416e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513574815276046457371560482890923568e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.3744493093600777254413275469044047054818e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124419251015632632795882804397141390e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.3226763337151876295102397404079492286115e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531767577130879826616944248033901275e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.3174821276541048102659376061056477060061e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979516176849111717097012050445269677e-01) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.2813149398852051028099970887468424914076e+00) }}, 
      {{ SC_(2.4945887369676178479949157917872071266174e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247641203506970474608856232553478053e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.2095730486305696360713006587530229096764e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1135925267356592180298663804088769493087e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4744264745109327698775454932561522924973e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.1167780149428489346923890556594863653625e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5096595818263600781442276491516845425281e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3399380216981037907713474801341199888163e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3245137932284950009393939731818011724178e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2747316145439584535817113647116215099679e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2697368701834767748177198221360371013950e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2349571479209928975521437449060985678539e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.0679720676778430288322851993143558502197e-13), SC_(3.2095730486305696360713006587530229096764e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169190427104670261792014780537280874544e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.0679720676778430288322851993143558502197e-13), SC_(3.1135925267356592180298663804088769493087e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176721828122736544519592932741125189394e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.4744264745109327698775454932561522924973e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625188722743271136820374787438854982740e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.0679720676778430288322851993143558502197e-13), SC_(2.1167780149428489346923890556594863653625e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008372016031624671241600900162198901966e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.5096595818263600781442276491516845425281e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637276248330097316177058405763713584e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.3399380216981037907713474801341199888163e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513296929358333623623830459366267530e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.3245137932284950009393939731818011724178e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155124148115837329591189348407851290871e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2747316145439584535817113647116215099679e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531517629892753865387320751410830811e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2697368701834767748177198221360371013950e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979268304967591518913884890854544638e-01) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.2349571479209928975521437449060985678539e+00) }}, 
      {{ SC_(9.0679720676778430288322851993143558502197e-13), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247407528497185709703786006424865072e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1496766946522893685991542656525370696838e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0556033527843692899062987534031975859756e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4290270718972729392436999650987672242455e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0783288776775112137906727477234485393634e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4828186379476475915381830403208788824012e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3162911025269879317258035065739657580907e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3011558697398200865148579886215874088853e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2523049096885081690514281205457649510141e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2474034658784660839139200740957636859460e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2132727468836491577977128793155770689074e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.6584251333329191879784048069268465042114e-12), SC_(3.1496766946522893685991542656525370696838e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169189105946019965177102677351238973714e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6584251333329191879784048069268465042114e-12), SC_(3.0556033527843692899062987534031975859756e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176720589759505501004005508589156694709e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.4290270718972729392436999650987672242455e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625187963721011767853121193309239127998e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6584251333329191879784048069268465042114e-12), SC_(2.0783288776775112137906727477234485393634e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008371471619921948099752460446171806474e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.4828186379476475915381830403208788824012e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967637010940632416934592103635036459741e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.3162911025269879317258035065739657580907e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305513091007037296846490532462209039758e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.3011558697398200865148579886215874088853e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155123947196029217266528663301041728408e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2523049096885081690514281205457649510141e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531332411023211715662852832879623580e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2474034658784660839139200740957636859460e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621979084624003402963298310073273782942e-01) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.2132727468836491577977128793155770689074e+00) }}, 
      {{ SC_(1.6584251333329191879784048069268465042114e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284247234367867194376173320320154300294e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0809909720936195978145694719705491662212e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9891046755047934833272110103894951096128e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3769656263311073846254106438836642097025e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0342376000049865974497289166484342413736e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4520389743785506012607919371559974069168e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2891741643216273564776071569353551989646e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2743703353002379226395455846771103745438e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2265872436655302419439585414454287237486e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2217927916053431023015388468318070884779e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1884063125420389289683379397990403321157e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.3140226673999961803929181769490242004395e-12), SC_(3.0809909720936195978145694719705491662212e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169187008693087059849954649715250317581e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.9891046755047934833272110103894951096128e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176718623938876075288280830278954730930e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.3769656263311073846254106438836642097025e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625186758822787489569742000776597521213e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3140226673999961803929181769490242004395e-12), SC_(2.0342376000049865974497289166484342413736e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008370607401915045906831659989084692998e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.4520389743785506012607919371559974069168e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967636589781986174305123086260384001112e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2891741643216273564776071569353551989646e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305512764118796424125170552519768604776e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2743703353002379226395455846771103745438e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155123628248950811573436341744650227286e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2265872436655302419439585414454287237486e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670531038388159137919989760628196148290e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.2217927916053431023015388468318070884779e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621978793042463620118234203083651263151e-01) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.1884063125420389289683379397990403321157e+00) }}, 
      {{ SC_(3.3140226673999961803929181769490242004395e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284246959486670769292430735774521459000e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0193938631536884214906051573742686286606e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9294689009047251685219653311897609732558e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3302771092033767384939818579214710711633e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9946967007769513402240426342299730878340e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4244358827988930662281469852962298213620e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2648557916739797383840685442128044625395e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2503491643577384498242644624224186703645e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2035237332781037763683716186579379565120e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1988252310343557676319750209876074537001e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1661061836647301738723719964791649125302e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1657502020695531541605305392295122146606e-12), SC_(3.0193938631536884214906051573742686286606e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169184399576837137437210700059975811327e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.9294689009047251685219653311897609732558e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176716178332769812833918807328211430824e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.1657502020695531541605305392295122146606e-12), SC_(2.3302771092033767384939818579214710711633e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625185259852573223892381410120795659110e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.9946967007769513402240426342299730878340e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008369532259589430574000169695153263796e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.4244358827988930662281469852962298213620e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967636065833747297979749168082530615949e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2648557916739797383840685442128044625395e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305512357448955156445448711746819259193e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2503491643577384498242644624224186703645e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155123231458422286211774281317851623056e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.2035237332781037763683716186579379565120e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670530672604943453882913121639283096750e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.1988252310343557676319750209876074537001e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621978430296411122475244583208848469728e-01) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.1661061836647301738723719964791649125302e+00) }}, 
      {{ SC_(6.1657502020695531541605305392295122146606e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284246617516911008259411422272832238853e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.9912654273842828280365662694149462555548e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9022361121543188467990555127519686895595e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3089567099541586928038627886623453119711e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9766402746988080486192948174091869653635e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4118308790592950818171192765515538805804e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2537507610189911254389762867794925702284e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2393798514209624850192790670692124344398e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1929917378368380891050262784599630941385e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1883370512574166056012597735807217228680e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1559227878273169132428772620794966824142e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.9912654273842828280365662694149462555548e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169182910595491060738940531701127361759e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.9022361121543188467990555127519686895595e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176714782664067434412667099981556536713e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.1867811141389523754696710966527462005615e-12), SC_(2.3089567099541586928038627886623453119711e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625184404413964439424638957712543411740e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.9766402746988080486192948174091869653635e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008368918692846190622144684196126203729e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.4118308790592950818171192765515538805804e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967635766824753790347422246379694366982e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.2537507610189911254389762867794925702284e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305512125368890835713871508904843006341e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.2393798514209624850192790670692124344398e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155123005016325751496224949655639481128e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.1929917378368380891050262784599630941385e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670530463858230790628904229015985040115e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.1883370512574166056012597735807217228680e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621978223282959540278376931570478404108e-01) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.1559227878273169132428772620794966824142e+00) }}, 
      {{ SC_(8.1867811141389523754696710966527462005615e-12), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284246422360161701528548515011044814543e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.9068701439786061864586275988682782093215e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8205280874579118881655614746347190480230e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.2449879506632742518974041889291018592236e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9224645925295668817851067723011758231440e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3740113973200149606328817853004720449041e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2204317305175418719458236572080697172196e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2064680222081182815469943196290786858122e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1613920162105826458146382756662128736357e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1568687921639079515436692865041617289801e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1253689886477793612110061340914386827852e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.9068701439786061864586275988682782093215e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169176938801716499043608044903595651875e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.8205280874579118881655614746347190480230e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176709185115267683279768632364998274659e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9166314368934678213918232358992099761963e-11), SC_(2.2449879506632742518974041889291018592236e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625180973542693257155425559912245165763e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9224645925295668817851067723011758231440e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008366457886702007759170761551263602908e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.3740113973200149606328817853004720449041e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967634567601982010116773379912542203134e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.2204317305175418719458236572080697172196e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305511194575140696355404770040128050197e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.2064680222081182815469943196290786858122e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155122096834534522784495674662634727538e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.1613920162105826458146382756662128736357e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670529626646567450719201439886580549399e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.1568687921639079515436692865041617289801e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621977393022813158106987205341965412203e-01) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.1253689886477793612110061340914386827852e+00) }}, 
      {{ SC_(1.9166314368934678213918232358992099761963e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284245639653190116177618041920971884473e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.8091280822350332513996386800267589306774e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7258982636982430734176234144683184497623e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1709027865642215950521805347480812546068e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8597212417410697577366419049307965349492e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3302109149929240560105445239811215053286e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1818434278883320707815383081258657592870e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1683513181314222448135282214108124615687e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1247949243156101020487725173665639619761e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1204239530782661237336690710642701655514e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0899832276736981463550197085267803095290e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.8091280822350332513996386800267589306774e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169165966452345606553425560214455917909e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.7258982636982430734176234144683184497623e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176698900389324083490475516336469062420e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1331883188510118998237885534763336181641e-11), SC_(2.1709027865642215950521805347480812546068e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625174669787780465214357121390468781434e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8597212417410697577366419049307965349492e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008361936492921272149509571788390257532e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.3302109149929240560105445239811215053286e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967632364194330570381677592505723274231e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.1818434278883320707815383081258657592870e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305509484369003371984705049514045252927e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.1683513181314222448135282214108124615687e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155120428174771864332550299176902518004e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.1247949243156101020487725173665639619761e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670528088384686951891945129311132646563e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.1204239530782661237336690710642701655514e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621975867533392339112412167218558977198e-01) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.0899832276736981463550197085267803095290e+00) }}, 
      {{ SC_(5.1331883188510118998237885534763336181641e-11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284244201536211197730663515943576026969e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7303865791187319060994528048128687351511e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6496639953642504781808533724183188634218e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1112194007652151604909636366777295677446e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8091748785523592795960714206700906114593e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2949250231855258399357719524779575126533e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1507564946112367512920676552601219686104e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1376443070518989747057374330684437822022e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0953121205549188973066426419916785930291e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0910638049567815569499792990513591248699e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0614762782768499222007492123526016316113e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.7303865791187319060994528048128687351511e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169152225500583727492830329821510099597e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.6496639953642504781808533724183188634218e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176686020565441360519342758809054558101e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1351786177726808091392740607261657714844e-10), SC_(2.1112194007652151604909636366777295677446e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625166775433549236216249299060599938905e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8091748785523592795960714206700906114593e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008356274234684840615523579934316687778e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.2949250231855258399357719524779575126533e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967629604809483154927204644547171954354e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1507564946112367512920676552601219686104e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305507342633158729568415182983467231864e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.1376443070518989747057374330684437822022e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155118338468528231923596676059913687378e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.0953121205549188973066426419916785930291e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670526161979090771744295649360627186189e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.0910638049567815569499792990513591248699e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621973957123078651776200767730599471477e-01) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.0614762782768499222007492123526016316113e+00) }}, 
      {{ SC_(1.1351786177726808091392740607261657714844e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284242400544673374346744450295072127691e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.6882823641053799639516455168392619553791e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6089004348746185881849712176115091863946e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0793058353773885524033727817407080878438e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7821470106599432384536230586780384337606e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2760571489789864379420836009587598656235e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1341338639649236361739699052084431153131e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1212248262727092207795792007003406433676e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0795472410486784494142427614356362871496e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0753645111861628533039344063048923416498e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0462332021440730501793532533969465691972e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.6882823641053799639516455168392619553791e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169142309144292828062093688747157258207e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.6089004348746185881849712176115091863946e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176676725654244052000907280357178166244e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7352735914855088594777043908834457397461e-10), SC_(2.0793058353773885524033727817407080878438e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625161078357513915113779408493510573257e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.7821470106599432384536230586780384337606e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008352187982882001649623218126669625500e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.2760571489789864379420836009587598656235e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967627613458526897454062681518168813598e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.1341338639649236361739699052084431153131e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305505797017678802538229227547566963437e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.1212248262727092207795792007003406433676e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155116830400975769534656032430960502503e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.0795472410486784494142427614356362871496e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670524771759856069861284076358058303201e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.0753645111861628533039344063048923416498e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621972578447075321432694902899304794365e-01) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.0462332021440730501793532533969465691972e+00) }}, 
      {{ SC_(1.7352735914855088594777043908834457397461e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284241100832343095884439689267934633621e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.6557556574383083184927316865189327481938e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5774094220547942083932413308540171348606e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0546516961242507687844124614471488380229e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7612672120338561646261083745158988413134e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2614811781511885287474001707403919990741e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1212924078088144080467685455239978834624e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1085403091816172119396002590115454772454e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0673684221063990925629533022776073506123e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0632363590947788817053048880029001726724e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0344574911866225242753236386298568350213e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.6557556574383083184927316865189327481938e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169133070485553770938152838795043759117e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.5774094220547942083932413308540171348606e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176668065969969330871460048573155106416e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4085067273915683472296223044395446777344e-10), SC_(2.0546516961242507687844124614471488380229e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625155770626587842542163301201127481789e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.7612672120338561646261083745158988413134e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008348380990165161535826663806341163567e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.2614811781511885287474001707403919990741e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967625758198482517243654429018067162234e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.1212924078088144080467685455239978834624e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305504357031045202011467887940051158501e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.1085403091816172119396002590115454772454e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155115425396203069536746800063708171070e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.0673684221063990925629533022776073506123e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670523476549519046078646979374121413026e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.0632363590947788817053048880029001726724e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621971293991092800154869268161468065413e-01) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.0344574911866225242753236386298568350213e+00) }}, 
      {{ SC_(2.4085067273915683472296223044395446777344e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284239889943571647998113671424203898870e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5398463390539230527631749182391729504292e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4651908114046005100987285652294731141971e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9667963683294410635639512527150854352191e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6868617933824989943600844977197630379737e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2095395272214699225995668107604943329884e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0755317211983939381575248494497742711657e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0633388768554162762765476883388794931080e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0239690513396646548679013383301313736997e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0200175402730186950243915908175138769615e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.9249460067096735763137174215053803937893e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.5398463390539230527631749182391729504292e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169084586850648474881122225344330126352e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.4651908114046005100987285652294731141971e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176622620736719287990110299128295384989e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.9667963683294410635639512527150854352191e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625127916125413514678570968508490120994e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6868617933824989943600844977197630379737e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008328402224720600704484778160980678212e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.2095395272214699225995668107604943329884e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967616021951414440158513247327188722547e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.0755317211983939381575248494497742711657e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305496800102629669907238439887507120764e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.0633388768554162762765476883388794931080e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155108052049562157096050394719895104053e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.0239690513396646548679013383301313736997e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670516679394582240976443435705104743719e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.0200175402730186950243915908175138769615e+00) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621964553274080120581055334323263556009e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.7467654513441175367916002869606018066406e-10), SC_(9.9249460067096735763137174215053803937893e-01) }}, 
      {{ SC_(7.7467654513441175367916002869606018066406e-10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284233535300940607959582734590644649106e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4854836016946269055826918157962567737755e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4125590563159831607090479153408402505673e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9255912592182833398073012253718010213558e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6519648386835504699667491323991221588897e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1851783251418805911165349208310670800839e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0540694589507252524323948717002727475229e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0421389109804453630811766289019522502811e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0036142720350365826164094697274115409551e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.9974744180425921822441297426124308476407e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.7281354630675934518091761156357700711364e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.4854836016946269055826918157962567737755e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169050047749808164332553843317648156655e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.4125590563159831607090479153408402505673e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176590246149681049081752538415856724633e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.9255912592182833398073012253718010213558e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625108072931066057909321354564964450612e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6519648386835504699667491323991221588897e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008314169599471754327769932317403742855e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.1851783251418805911165349208310670800839e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967609085965080029335091696177605931582e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.0540694589507252524323948717002727475229e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305491416635977821491052703882657135895e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.0421389109804453630811766289019522502811e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155102799364317495040408584316693992792e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.0036142720350365826164094697274115409551e+00) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670511837181269197057954235428703970525e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(9.9974744180425921822441297426124308476407e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621959751266456519508314554165172550315e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3399348297582491795765236020088195800781e-09), SC_(9.7281354630675934518091761156357700711364e-01) }}, 
      {{ SC_(1.3399348297582491795765236020088195800781e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284229008328010480601527595767162947765e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4410397957794566316924100725933925604383e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.3695304006264559263293185541047127218775e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8919043633550133488433645168373695441824e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6234351222405892738598705054127699604004e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1652620260384615657133127603863143719629e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0365231641098646127348982510815664216433e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0248070543678346244114679876444164142411e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.8697339070668948682383561039720945216040e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.8317579059230237712174509108304534378275e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.5672346322646967488745056914310059157249e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.4410397957794566316924100725933925604383e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169013865394449340546387832719527590345e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.3695304006264559263293185541047127218775e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176556331285404909775933657156106045176e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8919043633550133488433645168373695441824e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625087285650033967375261177175697524845e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6234351222405892738598705054127699604004e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008299259818728246036528724952170914501e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.1652620260384615657133127603863143719629e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967601819976565595579501729207726191879e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.0365231641098646127348982510815664216433e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305485777032493451471303028753944401813e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.0248070543678346244114679876444164142411e+00) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155097296764538593263723745745119180093e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(9.8697339070668948682383561039720945216040e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670506764582812548806851604599739712776e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(9.8317579059230237712174509108304534378275e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621954720786592923420404475841142948445e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0971455683138628955930471420288085937500e-09), SC_(9.5672346322646967488745056914310059157249e-01) }}, 
      {{ SC_(2.0971455683138628955930471420288085937500e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284224265968430115656274119628401648646e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.3519669118451170415252830999662237373562e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.2832937164512977325606541839772210852695e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8243901416443652585866245531462246879937e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.5662567580092388482141536289083481895362e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1253464030869707192814049578984972863808e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0013574294796479934526821161592525505463e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.9007109011910758394242430834684854529585e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.5362225748341223617732373276842826263294e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.4996340620021704033500706644446296437584e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.2447622260262692307343343778668919138301e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.3519669118451170415252830999662237373562e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1168911707262214745482765833507064990449e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.2832937164512977325606541839772210852695e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176460575225326750042602091804766094713e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8243901416443652585866245531462246879937e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3625028594263091987193141219107837424340e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.5662567580092388482141536289083481895362e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008257163102688533014798329440444569923e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.1253464030869707192814049578984972863808e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967581304947867456013807239398011006328e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.0013574294796479934526821161592525505463e+00) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305469853987627504971718851638224072444e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(9.9007109011910758394242430834684854529585e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155081760540100744361693936680534148232e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(9.5362225748341223617732373276842826263294e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670492442437284747440487572769958201560e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(9.4996340620021704033500706644446296437584e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621940517559999816133079015192946365530e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.1467061723542428808286786079406738281250e-09), SC_(9.2447622260262692307343343778668919138301e-01) }}, 
      {{ SC_(5.1467061723542428808286786079406738281250e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284210876229572452447235724330064576658e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.2963344915891584884444872810933758775392e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.2294327068598789014204576411128429763828e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7822226559656352752022791992582039669491e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.5305447584583219999567115874963795442976e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1004162266379623594172400933084380488787e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.7939389980070281970045495082452919914519e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.6837598294360019958316883269412259028125e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.3279207685173478640220478448164678989256e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.2921988418957075251597257695473269487233e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.0433550226847696813678034665568352979148e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.2963344915891584884444872810933758775392e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1168820298298776412582413042508749382188e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.2294327068598789014204576411128429763828e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176374894681462768180283368730377397874e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.7822226559656352752022791992582039669491e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3624976078338278115055850320203835207849e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.5305447584583219999567115874963795442976e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008219495736911898204750340348237235046e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.1004162266379623594172400933084380488787e+00) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967562948450971651843579546056382475497e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.7939389980070281970045495082452919914519e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305455606313526069201715473182416077732e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.6837598294360019958316883269412259028125e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155067858985931703941741098398371730179e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.3279207685173478640220478448164678989256e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670479627219122561365914104941910180345e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.2921988418957075251597257695473269487233e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621927808748375426498253196455782590142e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.0167588950862409546971321105957031250000e-09), SC_(9.0433550226847696813678034665568352979148e-01) }}, 
      {{ SC_(9.0167588950862409546971321105957031250000e-09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284198895312289106831301997910037009848e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.1900957058120512427159065938563767010679e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1265767060850144665641521573960408663478e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7016972633294571324666923336571624043567e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4623471236921803922869181290169838416008e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0528081651791678911487641224012703988085e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.3745111318937996102269509711202003321016e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.2694579098053920791655170398168782913541e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.9301359706580839150977227639193970098714e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.8960689256057761167895749010721316493280e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.6587365448712040277427121842298898689810e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.1900957058120512427159065938563767010679e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1168555550839161134726644787798914167017e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.1265767060850144665641521573960408663478e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176126738311944290265719663661737457915e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.7016972633294571324666923336571624043567e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3624823976130808122011738790430727323864e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.4623471236921803922869181290169838416008e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008110399327081017033197952779196879079e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.0528081651791678911487641224012703988085e+00) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967509782179891275882470798910208849991e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(9.3745111318937996102269509711202003321016e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305414340473029090628249397916257922119e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(9.2694579098053920791655170398168782913541e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155027595617192724512948769075300582649e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(8.9301359706580839150977227639193970098714e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670442510220465475577847832837321894906e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(8.8960689256057761167895749010721316493280e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621890999936509392792104656010107422127e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6308249800877092638984322547912597656250e-08), SC_(8.6587365448712040277427121842298898689810e-01) }}, 
      {{ SC_(2.6308249800877092638984322547912597656250e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284164194711582905128816860838336270812e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.1727677265342090697638524189382807860202e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1098004728336691493631854220609129761400e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6885632433247550171400743578344386752974e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4512238112728930195724898803084626233093e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0450430961464964118154868353367590757058e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.3061007359329935057154923144496014667553e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.2018835766252078081119561856688823457612e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.8652556474142941378260417465884668202181e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.8314585202964471283014860636809522192327e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.5960037021343280086661364502355237417317e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.1727677265342090697638524189382807860202e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1168497276525252544217937518486658832240e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.1098004728336691493631854220609129761400e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0176072115887676623796914191116662318995e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6885632433247550171400743578344386752974e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3624790496379101422228588539565482715896e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.4512238112728930195724898803084626233093e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0008086385697082491296756896229771689850e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.0450430961464964118154868353367590757058e+00) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967498079518660742705317956641845354405e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(9.3061007359329935057154923144496014667553e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305405257261602460013528827923671689903e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(9.2018835766252078081119561856688823457612e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2155018733063827485158315615670169382201e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(8.8652556474142941378260417465884668202181e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670434340227316664324379512350904470085e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(8.8314585202964471283014860636809522192327e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621882897779610093933829893957164277696e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.1328681870945729315280914306640625000000e-08), SC_(8.5960037021343280086661364502355237417317e-01) }}, 
      {{ SC_(3.1328681870945729315280914306640625000000e-08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284156556601681530201245869459931663648e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0509008324270152255063189406507223771519e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9918139834787199962884019844548821085550e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5961922745437409287857856061572044378789e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3729940578679165786847892545744141420588e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.9043171652783271911726162143624652706385e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.8249735122029342642663200435564513626672e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.7266363446320293615940473217168106412723e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.4089552655103078623522508671216452570902e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.3770564590232533470294881801906873818915e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.1548064535558017037744557178811842578736e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.0509008324270152255063189406507223771519e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1167906265961658691194726753790473522197e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.9918139834787199962884019844548821085550e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0175518141863749963802255963285461970855e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.5961922745437409287857856061572044378789e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3624450946950310840829913503208833778105e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.3729940578679165786847892545744141420588e+00) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0007842840322662763696770160174834682284e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(9.9043171652783271911726162143624652706385e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967379390956911010174159734080670928009e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(8.8249735122029342642663200435564513626672e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305313135071910752996505456330701705846e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(8.7266363446320293615940473217168106412723e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154928848783350265199686867765611318854e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(8.4089552655103078623522508671216452570902e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670351479880095754643592312995360605215e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(8.3770564590232533470294881801906873818915e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621800725426639623288266835512425635666e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0700225061555102001875638961791992187500e-07), SC_(8.1548064535558017037744557178811842578736e-01) }}, 
      {{ SC_(1.0700225061555102001875638961791992187500e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284079090607696764402184183219201635760e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0366314481560256274680728668461459212453e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9779989554548194141465831865145747974657e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5853765655783997183529807354299547704032e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3638341425938937179653302599074800399169e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.8403727463647198030602710135269369273669e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.7686383655962263186388834741237788563577e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.6709896857645250344586325248815471250227e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.3555270917313138476376333754014728571249e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.3238505594478536405745729813336356475488e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.1031467043927640938577289852808366342828e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.0366314481560256274680728668461459212453e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1167810244021395609117473016044711768768e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.9779989554548194141465831865145747974657e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0175428137200606163370686359762171840950e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.5853765655783997183529807354299547704032e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3624395779730694519940796704902898262764e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.3638341425938937179653302599074800399169e+00) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0007803270933306570060713962263386270016e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(9.8403727463647198030602710135269369273669e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967360107245713615864352973741419502800e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(8.7686383655962263186388834741237788563577e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305298167662660456745682044830005432572e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(8.6709896857645250344586325248815471250227e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154914244972996906711747893286779651895e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(8.3555270917313138476376333754014728571249e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670338017266813218789669437045061531075e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(8.3238505594478536405745729813336356475488e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621787374593647456475912560031906488236e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2355337730696192011237144470214843750000e-07), SC_(8.1031467043927640938577289852808366342828e-01) }}, 
      {{ SC_(1.2355337730696192011237144470214843750000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1284066504429795949648243908810749009956e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9544146463296474960076081216127496871942e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8984000462475104435917703335339580068589e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5230590196191835142642946883528260497108e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3110568863553852669442609253856819672439e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.4719401899486150237919418251040525123118e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.4440486287819521899915429422357222867887e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.3503668517745570309897619988986070407525e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.0476866418968029453685302876187016301553e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.0172908007815545024070137841087197233083e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.8054954971757428380527094947944257306429e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.9544146463296474960076081216127496871942e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1167099835178666212583997944707803570259e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8984000462475104435917703335339580068589e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0174762245911670542743496172483326251853e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.5230590196191835142642946883528260497108e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3623987627351064008212479619060733729283e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.3110568863553852669442609253856819672439e+00) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0007510517367727166976411964784524605507e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(9.4719401899486150237919418251040525123118e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3967217436099484400769400743255594777761e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(8.4440486287819521899915429422357222867887e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305187430624186437142417718561911603196e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(8.3503668517745570309897619988986070407525e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154806198020381448587374463644150392932e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(8.0476866418968029453685302876187016301553e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670238413463003128582685912240368506040e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(8.0172908007815545024070137841087197233083e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621688597796879412965699269555787943236e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8297245080466382205486297607421875000000e-07), SC_(7.8054954971757428380527094947944257306429e-01) }}, 
      {{ SC_(2.8297245080466382205486297607421875000000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1283973384939249205651849383975468910433e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8686421477052399799818485877456352512581e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8153586579590310559986001224510661613557e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4580463739240618513889187705580676839409e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2559971266401172992330805718123604211195e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.0875737064016521843922668706645742293266e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.1054210725212685728896268110011878298909e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.0158777583814438895926714117575259461862e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.7265327433989591127469545634337113210209e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.6974729806044209823930118626387353258670e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.4949715042457621333711203036904444517227e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8686421477052399799818485877456352512581e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1165967503171447586435214736609555527673e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8153586579590310559986001224510661613557e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0173700868680004799310097902357511622650e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.4580463739240618513889187705580676839409e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3623337055266199167618480612360722049084e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.2559971266401172992330805718123604211195e+00) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0007043880594316625975852435668371885918e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(9.0875737064016521843922668706645742293266e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3966990021125566119431058367080405055484e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(8.1054210725212685728896268110011878298909e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2305010917297285189029313882036988547245e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(8.0158777583814438895926714117575259461862e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154633972592983413401370035267075902415e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(7.7265327433989591127469545634337113210209e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1670079646124168606861456769035152529606e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(7.6974729806044209823930118626387353258670e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621531148680043537951175968611758861031e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.7173527895647566765546798706054687500000e-07), SC_(7.4949715042457621333711203036904444517227e-01) }}, 
      {{ SC_(6.7173527895647566765546798706054687500000e-07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1283824953388370837508330635317502851855e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7943229005132438234424166272275759862422e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.7434058336347344577672190194788469028156e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4017149005735330029707142882194999073398e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2082895239361081805912162312602877705507e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.7545318577853844641954355687757561645716e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.8120106086472193217244682944951188850312e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.7260531463386343902285566346915400847790e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.4482626709910426139431741018281233464720e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.4203605793130791080188215661072300833164e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.2259119208360271946582825569539184620457e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.7943229005132438234424166272275759862422e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1164501835810122224652056234893364218800e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.7434058336347344577672190194788469028156e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0172327039229067862020227361835813548941e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.4017149005735330029707142882194999073398e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3622494947124407803612615283000276045808e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.2082895239361081805912162312602877705507e+00) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0006439853270693346465178273678142343640e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(8.7545318577853844641954355687757561645716e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3966695643134593127880327249777419764541e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(7.8120106086472193217244682944951188850312e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2304782427841955907292697002120398720384e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(7.7260531463386343902285566346915400847790e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154411033541762971051630543340548717883e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(7.4482626709910426139431741018281233464720e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1669874127711382315598670115020767759947e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(7.4203605793130791080188215661072300833164e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621327336623935524856544794077437593164e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4207498679752461612224578857421875000000e-06), SC_(7.2259119208360271946582825569539184620457e-01) }}, 
      {{ SC_(1.4207498679752461612224578857421875000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1283632814023627663482984626029153476675e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7276916337119994967937764730546406342577e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6788961931166447256820809657113015154077e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3512106498942139006075651340493700112625e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1655170434839909057341120665169506859320e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.4559415686582826042262406975656114036035e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.5489520264976136083207180592378666346584e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.4662094768183147236591022868690784642145e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.1987782793818909865113823902197524297010e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.1719141033005100290993886036026009788332e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.9846852373808617271239611253214689713203e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.7276916337119994967937764730546406342577e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1162629841480137839344438916484810441619e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6788961931166447256820809657113015154077e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0170572335653284281049342581134322970466e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.3512106498942139006075651340493700112625e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3621419346949010015758941187390779496278e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.1655170434839909057341120665169506859320e+00) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0005668334954908271154402694922992092808e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(8.4559415686582826042262406975656114036035e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3966319627317718229666182209976051478279e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(7.5489520264976136083207180592378666346584e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2304490570919243092758564921197604795141e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(7.4662094768183147236591022868690784642145e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2154126266147005095719142746665738738585e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(7.1987782793818909865113823902197524297010e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1669611611732722902624717263794964441908e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(7.1719141033005100290993886036026009788332e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1621067000181769976520713298155142465202e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7808937375084497034549713134765625000000e-06), SC_(6.9846852373808617271239611253214689713203e-01) }}, 
      {{ SC_(2.7808937375084497034549713134765625000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1283387387177005266233847687815666849265e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.6597689976303602260661092451096729215786e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6131363000636527292718018545963333742258e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2997275733709852934658358397399156013250e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1219155832268024979870614781208070031836e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.1515642205201641046657381421382496872889e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.2807950279113974658890990278177723275348e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.2013296994462798124452552474105745449574e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.9444585543973649742743661944593800724943e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.9186524098977554435438797803019504362151e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.7387832643873065394043594460699754949762e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6597689976303602260661092451096729215786e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1159951355899071611062359235554877874467e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6131363000636527292718018545963333742258e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0168061657547856402313647065963108810823e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.2997275733709852934658358397399156013250e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3619880290391995852426316625519379657551e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.1219155832268024979870614781208070031836e+00) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0004564360477525038785419126057665723358e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(8.1515642205201641046657381421382496872889e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3965781563153377356539976746319699084055e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(7.2807950279113974658890990278177723275348e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2304072930881593164846044084053392589600e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(7.2013296994462798124452552474105745449574e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2153718770694283065020998213397278325922e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.9444585543973649742743661944593800724943e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1669235956481529856853190393508621148677e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.9186524098977554435438797803019504362151e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1620694463700288798972170162403038374192e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.5144737416412681341171264648437500000000e-06), SC_(6.7387832643873065394043594460699754949762e-01) }}, 
      {{ SC_(5.5144737416412681341171264648437500000000e-06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1283036185356662711157954576466344683556e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5881584831630236662907062370713624682957e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.5438059509257315786607296367542373040229e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2454491849438332274749743858647807578483e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0759467412524513698609228330070601211186e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.8306603464542204393017995497882021441598e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.9980781151563147395146194176958245345261e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.9220679474280231007416809225263099368467e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.6763302221167692863866019089094840012232e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.6516395559803322738933426868791727693242e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.4795297336732544914091385571805206106366e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.5881584831630236662907062370713624682957e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1155936512034211900741084485271829600458e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.5438059509257315786607296367542373040229e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0164298312441069091383997835999922441616e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.2454491849438332274749743858647807578483e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3617573215074761508782890334151495939699e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.0759467412524513698609228330070601211186e+00) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0002909430668075410031628264512904209017e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(7.8306603464542204393017995497882021441598e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3964974928420538314304489174345366687296e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.9980781151563147395146194176958245345261e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2303446820198809749638776826892397128621e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.9220679474280231007416809225263099368467e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2153107867621309293838511254729896145549e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.6763302221167692863866019089094840012232e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1668672784815620759281898680905538344878e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.6516395559803322738933426868791727693242e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1620135967374632858230100229178598002803e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1349249689374119043350219726562500000000e-05), SC_(6.4795297336732544914091385571805206106366e-01) }}, 
      {{ SC_(1.1349249689374119043350219726562500000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1282509671849204651795677642492836886909e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5093286499550142715910474914511459335576e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4674861445008516645976683181185508220134e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1856987368105406225467536267740478920649e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0253435451881199975853189539183017181685e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.4774043335415448190081327934785333825505e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.6868588729406745194615011260092287225077e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.6146521977992327819061258012119583167552e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.3811703080491141278366266445294294017270e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.3577075772955561965572422504212958987831e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.1941393351197094297578636233614802880708e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.5093286499550142715910474914511459335576e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1149475011678006557167370842871422958076e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.4674861445008516645976683181185508220134e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0158241494902448681020847451498470368719e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.1856987368105406225467536267740478920649e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3613859829316826488330392982829959375336e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.0253435451881199975853189539183017181685e+00) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0000245586758323926138520670596674048883e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(7.4774043335415448190081327934785333825505e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3963676431190903105892646302634406301005e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.6868588729406745194615011260092287225077e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2302438903057011749365476508147431510717e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.6146521977992327819061258012119583167552e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2152124429822200337599013112959392403928e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.3811703080491141278366266445294294017270e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1667766179658683884956011120916063941562e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.3577075772955561965572422504212958987831e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1619236888094061746407833381979762443931e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5120738428086042404174804687500000000000e-05), SC_(6.1941393351197094297578636233614802880708e-01) }}, 
      {{ SC_(2.5120738428086042404174804687500000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1281662075379914972073281792332392469242e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4320369415785523921910434591824503457796e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3926554660538002594124950898203783655511e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1271140217793290282754927754161623770452e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.7572758021151236225108440293565513837472e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.1310397179736113238617401608376556734052e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.3817108935630617786713270812068910624729e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.3132335064615994885322693682733526234310e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0917683474836531087304993875496151931209e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0695095958694314160256813917993004295080e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.9143162935763884499182614078854940933642e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.4320369415785523921910434591824503457796e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1140094099264884021145540520867356292698e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.3926554660538002594124950898203783655511e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0149447932145975149359083789122587369140e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.1271140217793290282754927754161623770452e+00) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3608467856692939452262421818645197524441e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.4747768444940447807312011718750000000000e-05), SC_(9.7572758021151236225108440293565513837472e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9996377305960761859662289143073215799743e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(7.1310397179736113238617401608376556734052e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3961790598964960061856888327170050116416e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.3817108935630617786713270812068910624729e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2300975036832302701409287320575723298424e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.3132335064615994885322693682733526234310e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2150696112277184162879280168413572179356e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.0917683474836531087304993875496151931209e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1666449438845450455521651559968534655103e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(6.0695095958694314160256813917993004295080e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1617931076483139704175232152128496245581e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.4747768444940447807312011718750000000000e-05), SC_(5.9143162935763884499182614078854940933642e-01) }}, 
      {{ SC_(5.4747768444940447807312011718750000000000e-05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1280431028394552388436949327045082203223e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3680610163764320449542888714756250263717e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3307165546050311328772511632188960534098e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0786220888531178676323192191290692029868e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.3465923387384889669895457401691888998876e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.8443447264290870849946898270024830549546e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.1291318773825801963278903150253489167328e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.0637413113068075458254917741927792055759e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.8522226902752404399467670552121120911730e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.8309605014119798450001359266991410779777e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.6826993409516735266760973443364013910279e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.3680610163764320449542888714756250263717e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1129040240731144020635955226807825956050e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.3307165546050311328772511632188960534098e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0139085901617780089107715532912324437901e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.0786220888531178676323192191290692029868e+00) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3602113062350373575897213964154513517722e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0433135321363806724548339843750000000000e-04), SC_(9.3465923387384889669895457401691888998876e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9991817854603127088042532587076448696741e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.8443447264290870849946898270024830549546e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3959567464264981033628027869320202695188e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.1291318773825801963278903150253489167328e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2299249267019649659950628981860145284513e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(6.0637413113068075458254917741927792055759e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2149012244658888461495573604054194746797e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(5.8522226902752404399467670552121120911730e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1664897091371237023019443862096146307015e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(5.8309605014119798450001359266991410779777e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1616391611849847536384195095294821570851e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0433135321363806724548339843750000000000e-04), SC_(5.6826993409516735266760973443364013910279e-01) }}, 
      {{ SC_(1.0433135321363806724548339843750000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1278979693523120350157736635290933324545e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2877193078625345568464516430503329286155e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2529328737269174372909085954956303607807e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0177249341429287427196120723312830725392e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.8308462686320509670915117057122357144414e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.4843049692590067000128466451171908133991e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.8119356687174777095584440026364209133597e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.7504216013560863807212995933521962134889e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.5513940698919754503119837158925811631426e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.5313833877350723002093309726554178199433e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3918277745607557398127361968747359103738e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.2877193078625345568464516430503329286155e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1109044825440899540192880024948638826685e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.2529328737269174372909085954956303607807e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0120341206737945069730069056470055560513e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.0177249341429287427196120723312830725392e+00) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3590614404060195398605048674094389486096e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3448176216334104537963867187500000000000e-04), SC_(8.8308462686320509670915117057122357144414e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9983566595645279395674788361902074606189e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(6.4843049692590067000128466451171908133991e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3955543288266058507031206109916704153741e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(5.8119356687174777095584440026364209133597e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2296125183996373218628427317183089929828e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(5.7504216013560863807212995933521962134889e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2145963997174681775455934120506593678794e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(5.5513940698919754503119837158925811631426e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1662086876474741519821837072265382339870e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(5.5313833877350723002093309726554178199433e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1613604713417224804529760003661960884403e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3448176216334104537963867187500000000000e-04), SC_(5.3918277745607557398127361968747359103738e-01) }}, 
      {{ SC_(2.3448176216334104537963867187500000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1276352301664967223758702078176437084262e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2279309807720593755646406987253252983035e+00) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1950480644939733377332737800871988903244e+00) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.7240620301018705935356772532588902641556e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.4470340182950920200496117806626798219948e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.2163657279509044266210253380845044520653e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.5758799573085480061572482267400680731606e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.5172507290911387336936928340660964507887e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3275189086062564241156408349990650670763e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3084395825104435985210424140656662086383e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.1753625345929642986865615583144476004750e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.2279309807720593755646406987253252983035e+00) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1087961098040120765501585592158268080534e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.1950480644939733377332737800871988903244e+00) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0100575251850584352490549707095359862029e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2839022353291511535644531250000000000000e-04), SC_(9.7240620301018705935356772532588902641556e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3578485125606484334074581220238380583460e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.2839022353291511535644531250000000000000e-04), SC_(8.4470340182950920200496117806626798219948e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9974861170089104965888129378639034238328e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(6.2163657279509044266210253380845044520653e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3951296273011473576076916900601617370041e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(5.5758799573085480061572482267400680731606e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2292827817939121776921290329221519543199e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(5.5172507290911387336936928340660964507887e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2142746647712225357316997305696932394686e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(5.3275189086062564241156408349990650670763e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1659120689322524675318963459221274899890e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(5.3084395825104435985210424140656662086383e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1610663129367385190391221122228538419494e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.2839022353291511535644531250000000000000e-04), SC_(5.1753625345929642986865615583144476004750e-01) }}, 
      {{ SC_(4.2839022353291511535644531250000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1273579028548032384393090686789532566042e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1562256290301815557082351612695089429497e+00) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1256254223785039406482235841977524144794e+00) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.1805334193602441659910989531811874141988e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.9867060922435756502759386126850865297215e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.8950070320377232694962094974151597680513e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.2927606918061090793535260553099629043057e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.2375914021084040835928322350751236952594e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.0590084292468894974272715592662315642959e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.0410461299669274755314686699059482144580e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.9157391897233842760663951161214631285899e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.1562256290301815557082351612695089429497e+00) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1052759076807807444041275222336413546340e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.1256254223785039406482235841977524144794e+00) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0067571085378341925658931884633801646247e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.8258343748748302459716796875000000000000e-04), SC_(9.1805334193602441659910989531811874141988e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3558222803763137085253648161749243294014e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.8258343748748302459716796875000000000000e-04), SC_(7.9867060922435756502759386126850865297215e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9960314733240730463143911600134067564276e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(5.8950070320377232694962094974151597680513e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3944196599430544379901119274534230002589e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(5.2927606918061090793535260553099629043057e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2287315002011429238129122132705011345177e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(5.2375914021084040835928322350751236952594e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2137367552277826046552043827965300649541e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(5.0590084292468894974272715592662315642959e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1654161340440608074269359203153456714283e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(5.0410461299669274755314686699059482144580e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1605744898778145081898933418100740358842e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.8258343748748302459716796875000000000000e-04), SC_(4.9157391897233842760663951161214631285899e-01) }}, 
      {{ SC_(8.8258343748748302459716796875000000000000e-04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1268942095874457700564481363528004354637e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1220097519609190562142341020031353085397e+00) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0924986582118680298744430969776033808259e+00) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.9211687109894428005699222467423047249690e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.7670411321337761771869034986956203648891e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.7416546983792283939773345035430907135053e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1576557287511599896039535195210982605833e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1041374865501609078635224254661063263489e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.9308746399043846702808470680089369797448e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.9134453761964419822506580499871166922067e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.7918462682541854024299824665944950424623e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.1220097519609190562142341020031353085397e+00) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1030961938674975386473089158927677509983e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.0924986582118680298744430969776033808259e+00) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0047133396606319365405707399667670241403e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2461179867386817932128906250000000000000e-03), SC_(8.9211687109894428005699222467423047249690e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3545669500205502239089674054792051454709e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2461179867386817932128906250000000000000e-03), SC_(7.7670411321337761771869034986956203648891e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9951300282568609059840945228124013002163e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(5.7416546983792283939773345035430907135053e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3939794990636798386075264026108665985678e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(5.1576557287511599896039535195210982605833e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2283896789850257002557474141837816577263e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(5.1041374865501609078635224254661063263489e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2134032216813989466635578767328080778299e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.9308746399043846702808470680089369797448e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1651086162606978918728491436435541212246e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.9134453761964419822506580499871166922067e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1602695206681942578575595466471752321283e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2461179867386817932128906250000000000000e-03), SC_(4.7918462682541854024299824665944950424623e-01) }}, 
      {{ SC_(1.2461179867386817932128906250000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1266066760122464855810404731758433574009e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0244760293085278125062104127092481400153e+00) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.9806861893399016883389865457704471444700e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.1817912295488519802957212118953310917864e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.1408202098852918903948799471794235131629e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3044618867246456591033318793532212250054e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.7724812442781455040492772775731528410659e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.7236697503360343291718452723743868276078e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.5655733948541484942419838649582011371031e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.5496637016115214776684260145293993067765e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.4386348563615033702542994625160068628249e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.0244760293085278125062104127092481400153e+00) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0943951437271862573371729036318087467358e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3315904438495635986328125000000000000000e-03), SC_(9.9806861893399016883389865457704471444700e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9965538430876564721504686514410506681014e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3315904438495635986328125000000000000000e-03), SC_(8.1817912295488519802957212118953310917864e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3495506623220820136348472989360604103547e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3315904438495635986328125000000000000000e-03), SC_(7.1408202098852918903948799471794235131629e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9915260586467247391081422416118856062163e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(5.3044618867246456591033318793532212250054e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3922182636567640190576338786604736548867e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.7724812442781455040492772775731528410659e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2270216182610065076745088192613213390035e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.7236697503360343291718452723743868276078e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2120683025135720776110631635020549499996e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.5655733948541484942419838649582011371031e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1638777383666488351159082123961993883247e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.5496637016115214776684260145293993067765e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1590488355059863183818599838568618412670e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3315904438495635986328125000000000000000e-03), SC_(4.4386348563615033702542994625160068628249e-01) }}, 
      {{ SC_(3.3315904438495635986328125000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1254557254927014876206146368386271707174e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.5728398149780321043031592236247448736637e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.3301338231643351936239008054218728526178e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.6723517604457693397604556124497369369614e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.7093212211151128239675498699737638061446e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.0031882258950527948557761701808645360631e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.5070489017509914461964963604174119598451e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.4614805098589659171297453740304677081637e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.3138344552890439078868952353805122136146e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.2989718131148336056036908645783986372744e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.1952263848970527834945644248913381451501e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.5613389015197753906250000000000000000000e-03), SC_(9.5728398149780321043031592236247448736637e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0854227250769901693960446636007933334236e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.5613389015197753906250000000000000000000e-03), SC_(9.3301338231643351936239008054218728526178e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9881380011226478889977798509186613384881e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.5613389015197753906250000000000000000000e-03), SC_(7.6723517604457693397604556124497369369614e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3443691756818466609716383781895855688195e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.7093212211151128239675498699737638061446e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9878003712270516780235343660605855346017e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(5.0031882258950527948557761701808645360631e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3903950611727484150461179115633831879209e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.5070489017509914461964963604174119598451e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2256048909460538009964511370438838792122e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.4614805098589659171297453740304677081637e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2106858486222276328800375268093572231012e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.3138344552890439078868952353805122136146e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1626028905678905914423439707851615376654e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.2989718131148336056036908645783986372744e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1577845306381359982484922480354563451064e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.5613389015197753906250000000000000000000e-03), SC_(4.1952263848970527834945644248913381451501e-01) }}, 
      {{ SC_(6.5613389015197753906250000000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1242635559046527012461695014856777777247e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.3970761486705510272136830827839023173851e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.1599567572796088738144533522074925636507e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.5390742282649140293613535176010674041167e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.5964284998488598225750325199305066261525e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.9243607151628722511162011702286911909281e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.4375980690022336563627032609476851133986e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.3928781458664199113276408060271292060930e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.2479661476393484017498652521589374057828e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.2333774416257109556756057428337246828669e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.1315375561558756349639636889567487776969e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.8345164656639099121093750000000000000000e-03), SC_(9.3970761486705510272136830827839023173851e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0825419292649951480368305656459818788940e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.8345164656639099121093750000000000000000e-03), SC_(9.1599567572796088738144533522074925636507e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9854355051264251557552832694186898315044e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.8345164656639099121093750000000000000000e-03), SC_(7.5390742282649140293613535176010674041167e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3427036575392526605002605799545363100926e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.8345164656639099121093750000000000000000e-03), SC_(6.5964284998488598225750325199305066261525e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9866021459149047405004630169460105878120e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.9243607151628722511162011702286911909281e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3898081603797428431085246333472910470460e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.4375980690022336563627032609476851133986e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2251487218330637805468951939065473941784e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.3928781458664199113276408060271292060930e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2102407049457014558338148416120014024488e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.2479661476393484017498652521589374057828e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1621923652518477931451390789937165776573e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.2333774416257109556756057428337246828669e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1573773973357270596190145913462927874998e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.8345164656639099121093750000000000000000e-03), SC_(4.1315375561558756349639636889567487776969e-01) }}, 
      {{ SC_(7.8345164656639099121093750000000000000000e-03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1238796319549586400376104598910065635508e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.2146433628894467990447021445163245571136e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.0150502741195126704970269341420851588850e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.6421468281916956890063586765403347455124e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.8365753738794292437257644336220184887121e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.3936829694201793013140076035408497483788e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.9700232548767505615850093080926345964451e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.9310137284650111310066879280379990632311e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.8045030058221129973167901325361170082095e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.7917580333470061339883277227213283762771e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.7027436215812016160072859094552362384952e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5860905647277832031250000000000000000000e-02), SC_(8.2146433628894467990447021445163245571136e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0551456315002743397148463744977103489625e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.5860905647277832031250000000000000000000e-02), SC_(8.0150502741195126704970269341420851588850e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9597250985136417122812402779390762151735e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5860905647277832031250000000000000000000e-02), SC_(6.6421468281916956890063586765403347455124e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3268187393072801630579683920953237894286e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5860905647277832031250000000000000000000e-02), SC_(5.8365753738794292437257644336220184887121e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9751580563861403539192498474028222959726e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(4.3936829694201793013140076035408497483788e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3841895537638871154245048438971693277342e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(3.9700232548767505615850093080926345964451e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2207788131228315576745248432235872171370e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(3.9310137284650111310066879280379990632311e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2059761639222740781921317075914866720849e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(3.8045030058221129973167901325361170082095e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1582587257225836601203665312177309023244e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(3.7917580333470061339883277227213283762771e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1534761856613222042575565642501017925923e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5860905647277832031250000000000000000000e-02), SC_(3.7027436215812016160072859094552362384952e-01) }}, 
      {{ SC_(2.5860905647277832031250000000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1202003281695570777926487474719114218871e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.4973265570381023043178978912064232335919e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.3204126396047800131143718677745515637737e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0975509706290936311159326881252796332860e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3750380278055427469627623548695918137695e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.0711781325908126351037441233693568314235e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.6858327631124330891430228953399514819425e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.6502910394291756856737927142192498277384e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5349556814802025839554877094275220487609e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5233304903297082622197728205894495891839e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.4421058310133170429217613320333774204927e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3459495306015014648437500000000000000000e-02), SC_(7.4973265570381023043178978912064232335919e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0290388421584476583727134249192395666020e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3459495306015014648437500000000000000000e-02), SC_(7.3204126396047800131143718677745515637737e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9352085003386335483806763696982410075546e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3459495306015014648437500000000000000000e-02), SC_(6.0975509706290936311159326881252796332860e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3116040743839680773773253862699466111616e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3459495306015014648437500000000000000000e-02), SC_(5.3750380278055427469627623548695918137695e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9641697067351568970359876586595696749270e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(4.0711781325908126351037441233693568314235e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3787721623930780538599023145040114234185e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(3.6858327631124330891430228953399514819425e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2165605290020988763517503837770538569258e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(3.6502910394291756856737927142192498277384e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2018591602841744825709246103995417352553e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(3.5349556814802025839554877094275220487609e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1544598928518900072871266078747029552783e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(3.5233304903297082622197728205894495891839e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1497085417835549675829816290636882677550e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3459495306015014648437500000000000000000e-02), SC_(3.4421058310133170429217613320333774204927e-01) }}, 
      {{ SC_(5.3459495306015014648437500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1166461573839839155531585055706679452116e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.1948551189035305790809340480648855021941e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.0274708281498266329072285066063894747791e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.8677226975081721333797381093010311588027e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1801942052941778356037339853595945561768e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.9349606003070938301094582555375173411628e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5657841087445389356790507317152208517408e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5317060621339344690842601353527044649976e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.4210878254177722530064492382031675093525e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.4099353160243258235307346692261612018956e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3319989742945085080385853072796944883192e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.1948551189035305790809340480648855021941e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0150474731144895758571780087774320640954e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.2663217782974243164062500000000000000000e-02), SC_(7.0274708281498266329072285066063894747791e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.9220628166136628791932134733633388419723e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.2663217782974243164062500000000000000000e-02), SC_(5.8677226975081721333797381093010311588027e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3034189239223374724733351333287403220555e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.2663217782974243164062500000000000000000e-02), SC_(5.1801942052941778356037339853595945561768e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9582472353298672621415592278263415060297e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.9349606003070938301094582555375173411628e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3758431287759861317594963219858456687333e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.5657841087445389356790507317152208517408e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2142778281934569350923753626546539292358e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.5317060621339344690842601353527044649976e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1996310904893546171578008198691127813273e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.4210878254177722530064492382031675093525e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1524034881510856053828543113438149235333e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.4099353160243258235307346692261612018956e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1476689682774048317360791928055675417933e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.2663217782974243164062500000000000000000e-02), SC_(3.3319989742945085080385853072796944883192e-01) }}, 
      {{ SC_(7.2663217782974243164062500000000000000000e-02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1147218025041625323853218478069516278875e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1755623350594485454583898829266693712432e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0400453006998020372965287738199096875376e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0918311576835460168396264504405074578540e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.5218981475984539707835041438564265025701e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.4742157755067281171592804084384447272014e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1596194271899023072609819554698830071511e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1304840805410605415364569004224062921683e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0357971597014317685527464084525741464279e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0262412265615385096795403285742012354084e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.9594126733929816665313854663184839504034e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(6.1755623350594485454583898829266693712432e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.9501479110934689263767352505748770642685e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(6.0400453006998020372965287738199096875376e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8610266115548017430431549643588652865597e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(5.0918311576835460168396264504405074578540e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.2651660842307033299716456686185456842015e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0549511909484863281250000000000000000000e-01), SC_(4.5218981475984539707835041438564265025701e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9304670235565087133774212646434240571656e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(3.4742157755067281171592804084384447272014e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3620178483043615994925160066673954053397e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(3.1596194271899023072609819554698830071511e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2034844375040911116239542712691047915052e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(3.1304840805410605415364569004224062921683e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1890943410667660464269621087252575740034e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(3.0357971597014317685527464084525741464279e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1426735757320773333080063307468296560601e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(3.0262412265615385096795403285742012354084e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1380181970625217197104587321209522887968e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0549511909484863281250000000000000000000e-01), SC_(2.9594126733929816665313854663184839504034e-01) }}, 
      {{ SC_(2.0549511909484863281250000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1056129604525337217969298114515662506712e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.8754660903507187243101983641064325939282e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.7492243866197212988621887051743180231211e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.8627843217262856312009625323319180994829e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.3273390925221089968027526959548690926713e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3378072386299046051578190686063056842794e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.0393198111526208198963934273647458584214e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0116441057352156797505838553071416763589e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.9216628229577072958573633486053567125367e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9125785478121138103558140773691953747300e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.8490318217223624080039050513179800126029e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(5.8754660903507187243101983641064325939282e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.9244306885916867296394301264047706614644e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(5.7492243866197212988621887051743180231211e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8368134053542741189244125036550897474538e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(4.8627843217262856312009625323319180994829e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.2498774163933817372360866415804768706195e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7974939346313476562500000000000000000000e-01), SC_(4.3273390925221089968027526959548690926713e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9193170504941427880376472821723565306527e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(3.3378072386299046051578190686063056842794e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3564287280925710582136732330421915113370e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(3.0393198111526208198963934273647458584214e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1991121875296406286476358970127710791774e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(3.0116441057352156797505838553071416763589e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1848252689595066939529058631706273093575e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.9216628229577072958573633486053567125367e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1387290649672576847314448093987462498950e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.9125785478121138103558140773691953747300e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1341055375625202351151450237488496782979e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.7974939346313476562500000000000000000000e-01), SC_(2.8490318217223624080039050513179800126029e-01) }}, 
      {{ SC_(2.7974939346313476562500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1019184833303689839122881809156983145270e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.9567710062590616840952549388319468358661e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.8584206993337617264344409846557147974498e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.1586658553684302460974067474630713502714e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.7281238254301310362554318040495798254992e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.9164976216583867558721934549976998291443e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.6675051538687421189333456805025405126376e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.6443184440174449939266144264390978678218e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.5688135814665165643673284821786287735401e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.5611807029088459209592100503654710803052e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.5077348270389105830311742592330994767118e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.9567710062590616840952549388319468358661e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.8200499555633245674775316217477599531414e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.8584206993337617264344409846557147974498e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7383821024520298651928850049223166913019e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.1586658553684302460974067474630713502714e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1870580813220685716900802884526462617160e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.2801637649536132812500000000000000000000e-01), SC_(3.7281238254301310362554318040495798254992e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8732218037130803763335834884065922734356e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.9164976216583867558721934549976998291443e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3330765494670190310010154463614800820404e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.6675051538687421189333456805025405126376e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1807893786485769927347218628101642753761e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.6443184440174449939266144264390978678218e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1669299569227693694521566307874173388972e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5688135814665165643673284821786287735401e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1221796596305195246464044364249976029423e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5611807029088459209592100503654710803052e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1176883106753627014725000301053933020554e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.2801637649536132812500000000000000000000e-01), SC_(2.5077348270389105830311742592330994767118e-01) }}, 
      {{ SC_(7.2801637649536132812500000000000000000000e-01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0864071577537327291505505233596065377574e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2817381859672321299898618526948284489850e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2031506205368932028607467616546980322874e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6369619462798098146299340017559464294041e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.2824420685028416397122306572700380305339e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.6012658550325564988343709802633981500586e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3888888543145910564915043768850886680502e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3690296151685703329402610263228600754884e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3042627268041839969883391667005767481526e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2977070428277789191671438061462773981007e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2517608586488576054366060805775175212272e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4983639717102050781250000000000000000000e+00), SC_(4.2817381859672321299898618526948284489850e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7112738651511656770864801614328493728173e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4983639717102050781250000000000000000000e+00), SC_(4.2031506205368932028607467616546980322874e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6355446241359255069478830364427397960717e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4983639717102050781250000000000000000000e+00), SC_(3.6369619462798098146299340017559464294041e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1202751892187014303087389225312438669900e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4983639717102050781250000000000000000000e+00), SC_(3.2824420685028416397122306572700380305339e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8237222189632740520401911019698192858731e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.6012658550325564988343709802633981500586e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3075537933621672672088971174553402193135e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.3888888543145910564915043768850886680502e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1606623382656845203364379599937165981949e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.3690296151685703329402610263228600754884e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1472634652595017061772011808097330984824e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.3042627268041839969883391667005767481526e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1039652238501671423184335866120487226205e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.2977070428277789191671438061462773981007e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0996166526563812077198265755822828528334e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4983639717102050781250000000000000000000e+00), SC_(2.2517608586488576054366060805775175212272e-01) }}, 
      {{ SC_(1.4983639717102050781250000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0693149079350120138014943910735402382203e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5093494068036442267182574145680262727689e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.4521621828969587046906716630765818937094e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.0326046590434837770463981719982975267118e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.7631034386784991678020223460575295249067e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.2304282703429949439403624614065204682233e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0603126291460470971416763287850776934072e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0443061463832926432938185245621186506415e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9919860591811304158831378824975847422187e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9866801420937945203852912814121803501565e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9494409135431957137009691670846092393567e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.5093494068036442267182574145680262727689e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5409787941577614892081623629551438692696e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.4521621828969587046906716630765818937094e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4740224223278515907232142657517560666569e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5478343963623046875000000000000000000000e+00), SC_(3.0326046590434837770463981719982975267118e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0129879977847938681022980284173605867835e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.7631034386784991678020223460575295249067e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7431321171699196291089854919939323237471e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.2304282703429949439403624614065204682233e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2649958786266194788522476116501608933973e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.0603126291460470971416763287850776934072e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1268674022166308950797591719508764242660e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(2.0443061463832926432938185245621186506415e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1142207683849439244291006391239714099911e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9919860591811304158831378824975847422187e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0732989654028721176928634937848630360383e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9866801420937945203852912814121803501565e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0691844596088038390070702007392810343500e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9494409135431957137009691670846092393567e-01) }}, 
      {{ SC_(3.5478343963623046875000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0404902851110500852682529484954938858155e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.8468049952198837530269086243006834315248e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.8064621447133838877399830857898501370404e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.5046106273108738822649399438602065129891e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3052313975026051776000347165283104066088e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8984197217942318669470360814751000687986e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7649132263213961184957797316115570175230e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7522615171495304765575785925041141565264e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7107990923351857033875959709089691338561e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7065850340853660184297779388150466517612e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6769609983859655506935094222806235753031e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.8468049952198837530269086243006834315248e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.3429339986613357981640187238689869034238e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.8064621447133838877399830857898501370404e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.2853970798623936391536646281218479231388e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.5046106273108738822649399438602065129891e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8839643722304043170198546400587173595635e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.8389759063720703125000000000000000000000e+00), SC_(2.3052313975026051776000347165283104066088e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6444747475381599016551936691166069080808e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8984197217942318669470360814751000687986e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2111676054345098808818944700148872924982e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.7649132263213961184957797316115570175230e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0837056112506704554386174745079101209222e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.7522615171495304765575785925041141565264e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0719819038258051348923941390100608664237e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.7107990923351857033875959709089691338561e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0339838823597191836275924972558265445926e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.7065850340853660184297779388150466517612e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0301580336419362630368624956264964968105e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.6769609983859655506935094222806235753031e-01) }}, 
      {{ SC_(7.8389759063720703125000000000000000000000e+00), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0034497634724180365396128276481345173066e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4797506743512802652036735034125796045361e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4479308359449033263476303001738777021405e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.2067750295137605635109523520770209048414e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0445273281128237839054816783436767467408e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7062512651752366307970167141601896954097e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.5931424310834889081777766221310018595509e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.5823704105485807696156912648060101177227e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.5470036360624039191403572007642088547057e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.5434035835936840560928061416389426261168e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.5180671252936167550095527467453579870568e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.4797506743512802652036735034125796045361e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.2065802550046414143098380328061463124209e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.4479308359449033263476303001738777021405e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1550539154351554420092950464365455423061e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.2067750295137605635109523520770209048414e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7924406368386432546322374277378061597153e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2590034484863281250000000000000000000000e+01), SC_(2.0445273281128237839054816783436767467408e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.5733448580089400144066835741287310455376e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.7062512651752366307970167141601896954097e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1711519344062892096181229599162306053422e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.5931424310834889081777766221310018595509e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0513192638004164301808343361743093592521e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.5823704105485807696156912648060101177227e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0402607015470614083103507284271662380686e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.5470036360624039191403572007642088547057e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0043754647502274147355657862627687123544e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.5434035835936840560928061416389426261168e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0007586805054422492028869614447784840958e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.5180671252936167550095527467453579870568e-01) }}, 
      {{ SC_(1.2590034484863281250000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.7549111082586362303668832176511384571556e-02) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0980155381105345976815511574343743862521e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0742997584817048186572397625436879478905e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8918395957110581856711867739009790608694e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7663777234214943831274307562645651231269e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4978322410345918681629733035368574723911e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4059496579464162329601339380806553769942e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3971447824404306541686523397034181179467e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3681702035072606836381235830212611021732e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3652151242689722420009931572524411343821e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3443880887893990618815370847382955111474e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.0980155381105345976815511574343743862521e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0397190922785071462924097023579078249591e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.0742997584817048186572397625436879478905e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9950377718808163368251309413708110156084e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8918395957110581856711867739009790608694e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6774247772728894289938352712227059203414e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.7663777234214943831274307562645651231269e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4826161975169538423170700222817497691516e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.4978322410345918681629733035368574723911e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1186123376201846353028445260380753301191e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.4059496579464162329601339380806553769942e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0084110034336384527507791881604614241250e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.3971447824404306541686523397034181179467e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.9819823081082470614578593526488724587891e-02) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.3681702035072606836381235830212611021732e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.6500653139944428122021768895211535092113e-02) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.3652151242689722420009931572524411343821e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.6165686527460824168283584335292456346979e-02) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.3443880887893990618815370847382955111474e-01) }}, 
      {{ SC_(2.1446166992187500000000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.3823300788156640963146088381345419735850e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.6908736271268580401745093529861386038705e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.4655816924952287275134340931498907627873e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6587648060710742397539387429332650197502e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.4532082033276177155453447653658653396222e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4261577615193745704045073619448839911508e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.3551838433443537382868135572834436311525e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4655816924952287275134340931498907627873e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4532082033276177155453447653658653396222e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3551838433443537382868135572834436311525e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2848076977554807436049845934777086620431e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1257061017548975014440749324840541142658e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0685395512434517157959079171777106126452e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0629867653561548175336263453984013214455e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0446211323080212772808207745513254085311e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0427400250689622873380323328420026367460e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0294399902459438422903256776990114762150e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.2848076977554807436049845934777086620431e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2792687215020246173284108732888002004170e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.1257061017548975014440749324840541142658e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.9459180249291620756912561054273081755316e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.0685395512434517157959079171777106126452e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.0540952826085856250960011675571792847258e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.0629867653561548175336263453984013214455e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.9706698901511289742545892679665822065020e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.0446211323080212772808207745513254085311e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.6985966549986743717625718072827182097063e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.0427400250689622873380323328420026367460e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.6710587849806595164986298909586290193831e-02) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.0294399902459438422903256776990114762150e-01) }}, 
      {{ SC_(6.0056228637695312500000000000000000000000e+01), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.4780714384760036526667437592197797670314e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5091977815279454086034094248645275618264e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.2003143624638919570401286861650375332039e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4827497460217574714649770901156516246803e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.1917790192379026012794567474061988431311e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2894811633657446565821254498205578194585e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.1232001519048738861389531971731791169138e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1657429648555419588183083201213050964411e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0729090657884265969718331564110927932788e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2003143624638919570401286861650375332039e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1917790192379026012794567474061988431311e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1232001519048738861389531971731791169138e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0729090657884265969718331564110927932788e-01) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.5595329290781831877058545587074507142229e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.1282488738488873441819517177210378372766e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.0860455878740248101443792470473885743760e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.9460675203059778595083216437506853043139e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.9316962080409728037260283608306954879489e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.8299061852667215538402438418987902166808e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(9.5595329290781831877058545587074507142229e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.2148458212976554660982866624662923704898e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(9.1282488738488873441819517177210378372766e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.4358146004942296911296376339675790210759e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(9.0860455878740248101443792470473885743760e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.3625682157996545809889011351838801460775e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(8.9460675203059778595083216437506853043139e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.1232347975243518092804594186878855493694e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(8.9316962080409728037260283608306954879489e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.0989713371437757014724759035156400539092e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0145712280273437500000000000000000000000e+02), SC_(8.8299061852667215538402438418987902166808e-02) }}, 
      {{ SC_(1.0145712280273437500000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.9287257238354309551731951277489600720477e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2326263204803271992904276746696643397643e-01) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.3144647216796875000000000000000000000000e+02), SC_(8.5907924968167424613517938485748988946582e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2136967063718304892986237483057481880380e-01) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.3144647216796875000000000000000000000000e+02), SC_(8.5454718373785846708688125955673070083203e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0737675217260939291886406285263798090797e-01) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.3144647216796875000000000000000000000000e+02), SC_(8.1739971364622885096914933677966996233246e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.8248578088519278570068879780296008670653e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3144647216796875000000000000000000000000e+02), SC_(7.8931567741290165702196712493389239181570e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.9746773985022819127430507312716647349703e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(7.2117006511840780684275535440822744486590e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.3685872627670609055238626415786434546614e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.9501749305974221457562594599861077792157e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.3111506334050166107979661814732656782570e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.9242822126214931850554547274261088079848e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.1229126575063491014806253263135016039505e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.8380158033087710320329021097947403176150e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.1037804447857444875025928660537249794825e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.8291252921219102201565800393549239768520e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.9692816482900973369073990026582929070767e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.7659750501762162337704361790532857871062e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.5907924968167424613517938485748988946582e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.5454718373785846708688125955673070083203e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.1739971364622885096914933677966996233246e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.8931567741290165702196712493389239181570e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.2117006511840780684275535440822744486590e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.9501749305974221457562594599861077792157e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.9242822126214931850554547274261088079848e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.8380158033087710320329021097947403176150e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.8291252921219102201565800393549239768520e-02) }}, 
      {{ SC_(2.3144647216796875000000000000000000000000e+02), SC_(2.3144647216796875000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.7659750501762162337704361790532857871062e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1365721591089776220549096934230962051304e-01) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1329577636718750000000000000000000000000e+02), SC_(7.5560771713935111786123223781631225084164e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1199560261717459085935291130755541564905e-01) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1329577636718750000000000000000000000000e+02), SC_(7.5206333138453615924285685887863269477527e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.9669893497104146315345104106112163974497e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1329577636718750000000000000000000000000e+02), SC_(7.2282264204940346427069172345154655877238e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.1582509825701152812699233592212607948784e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.1329577636718750000000000000000000000000e+02), SC_(7.0049362387056375289291813887868093302303e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.5048895968138512357568529985042415689021e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.4552180023973989613367843641781829150440e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.9583928832318681765726576810426945544300e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.2413007508935015264250467477458898007339e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.9064625669601796187959473213044354877228e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.2200332158889979432708832500281970972659e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.7360921215378316412734187006177393580453e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.1490619297199923603058959206642639771900e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.7187604355947968177713636792313661077588e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.1417377108125895224346031974295960855932e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.5968372147698148784817539403427263843256e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.0896592797319766385576511468394700335023e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.5560771713935111786123223781631225084164e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.5206333138453615924285685887863269477527e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.2282264204940346427069172345154655877238e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.0049362387056375289291813887868093302303e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.4552180023973989613367843641781829150440e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.2413007508935015264250467477458898007339e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.2200332158889979432708832500281970972659e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.1490619297199923603058959206642639771900e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.1417377108125895224346031974295960855932e-02) }}, 
      {{ SC_(3.1329577636718750000000000000000000000000e+02), SC_(3.1329577636718750000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.0896592797319766385576511468394700335023e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.8425463731749627886741069741055973073275e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.2110009765625000000000000000000000000000e+02), SC_(6.0553924497220119908533182116980774638258e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.7100472630716769814159512253067668633043e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.2110009765625000000000000000000000000000e+02), SC_(6.0322683267095034436780232288141269158525e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.7222823448288035865737959959268087716407e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.8396239193746721819158718424859845231007e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.0687115334744394685420320871031770218669e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.6902561340106914882905212218927455820540e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.7153543574627135532019850029466859016964e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.3141373968796972434552598616875858281594e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.2618595507491319076666465984720633080734e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.1645335028060691283896392893946815230424e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.2185838512759700804423361277195436402121e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.1495604064775214396675274281200512308304e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0763734811548187291879223221732696949453e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.0994636759010754790276200463094516109941e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0618861424183123398433436076033330825462e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.0942822761963734162128517522253241573083e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.9598637498319566811135850397338662481529e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.0573785528282339303430157545803437633117e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.0553924497220119908533182116980774638258e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.0322683267095034436780232288141269158525e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.8396239193746721819158718424859845231007e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.6902561340106914882905212218927455820540e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3141373968796972434552598616875858281594e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1645335028060691283896392893946815230424e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1495604064775214396675274281200512308304e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.0994636759010754790276200463094516109941e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.0942822761963734162128517522253241573083e-02) }}, 
      {{ SC_(5.2110009765625000000000000000000000000000e+02), SC_(5.2110009765625000000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.0573785528282339303430157545803437633117e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.7025249174985022153971827432443516028234e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.4521569339239138997125187926844890343542e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.6281786345570454952984235528696676799335e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.4444340317287518981063795147104659654001e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.0694970540123878859588866330949989351382e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.3789221669031933948964536278686578059946e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.6946880385690403469868008337070264387299e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.3266542409274070951063077617420928559796e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.9010151034780054223322132771466819920754e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.1890994909236626328387542910722804002273e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.6283454793880729366299027192802261376858e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.1319296093057013666623683348548351639899e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.6021156862141275896736535425923757194346e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.1261284327033684975158069229379971413750e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.5156470748630939007993685842603697099791e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.1066127491636232092767835652863599720704e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.5068142852598149328233193878590709536788e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.1045849148587653359160416848103671357968e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.4444833277886458038477201894739189819532e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7932973632812500000000000000000000000000e+03), SC_(3.0900909181530348089085561272581132255195e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.4521569339239138997125187926844890343542e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.4444340317287518981063795147104659654001e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3789221669031933948964536278686578059946e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3266542409274070951063077617420928559796e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1890994909236626328387542910722804002273e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1319296093057013666623683348548351639899e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1261284327033684975158069229379971413750e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.1066127491636232092767835652863599720704e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.1045849148587653359160416848103671357968e-02) }}, 
      {{ SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.7932973632812500000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.0900909181530348089085561272581132255195e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.2348682341726048872185506396578357787832e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.4450702449513590996032513408043258339547e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1827022440766491657275901285178339433646e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.4411551522279745568614504667800295242687e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.7896579566279449406575288078552346773387e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.4076977692209404084077103299973662728650e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.5247237373224593920573289339647509652790e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.3806859010585683961079372135315956095619e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.9591433928607435522945150365466433763103e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.3082305052269091717723551062352628149184e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.7629821701676908729573167586366392663762e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.2775266284395728732877126148315825441362e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.7440520296642846484529073260277983549679e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.2743914659816693175879355918034022241178e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.6815674233263342235671693096783061820368e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.2638179359067962381038778430607753853775e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.6751775599502952507604651399862698476035e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.2627169107961744073121314065408047968729e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.6300476286761219302676786188411036765874e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.2548343946177274204315121974085701728389e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4450702449513590996032513408043258339547e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4411551522279745568614504667800295242687e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4076977692209404084077103299973662728650e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3806859010585683961079372135315956095619e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.3082305052269091717723551062352628149184e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2775266284395728732877126148315825441362e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.2743914659816693175879355918034022241178e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2638179359067962381038778430607753853775e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2627169107961744073121314065408047968729e-02) }}, 
      {{ SC_(3.7299111328125000000000000000000000000000e+03), SC_(3.7299111328125000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2548343946177274204315121974085701728389e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.6797506365173102479600526500997476607164e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.0978721467293419039840757736093010780606e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.6351605984837440570792775293807711212992e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.0949795507817497054248698336531038721798e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2989222716198766188952358692889662850313e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.0701957431317009363032471197876596346742e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.0719428810488191279784912346878587409417e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.0501023737790304512142015760156937620763e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5861203944749508420579610192831380819761e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9958339710537707820285830600729964315227e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.4170942245385209432128683608135741999821e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9726742262508845045241070920819044058423e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.4007652698321845264731676029087370970849e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9703039435391970847456286183875337882756e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.3468433355726947799309816911153470755722e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9623025762364204341014577222985383706351e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.3413270548594323206576617280426302605761e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9614687314449340530117909596024894317379e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3023558059125651951134755328873407851878e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9554953922288752667562331865433616379252e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0978721467293419039840757736093010780606e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0949795507817497054248698336531038721798e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0701957431317009363032471197876596346742e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0501023737790304512142015760156937620763e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9958339710537707820285830600729964315227e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9726742262508845045241070920819044058423e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9703039435391970847456286183875337882756e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9623025762364204341014577222985383706351e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9614687314449340530117909596024894317379e-02) }}, 
      {{ SC_(5.1408691406250000000000000000000000000000e+03), SC_(5.1408691406250000000000000000000000000000e+03), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9554953922288752667562331865433616379252e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1800010633036558086496679579012530373229e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2534142452070780857910718005263437290819e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1536396817685973877509737559547877455287e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2523725641452696738498690662612617936587e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.9545168947478160529196068783466843804307e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2433896805459210062151728711603994464725e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8196759298443016199858768557298605524868e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2360303604522034171339233239494610536963e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.5294193831028125790887553824908701531531e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2158065741269507590082758655375017943986e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4277294910668829509465104679763988664777e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2070189655119779400865094728854904947808e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4178818292213451130129483405301762788533e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2061142396750735083467994641157520060232e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3853304490671898931640786527980394816535e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2030527684332139111766898568197582442706e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3819975510577049890978159124562002777041e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2027330670934513472375234427689931284252e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3584358371012458054338191585433815478667e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2004392174438868692965498590155843765847e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2534142452070780857910718005263437290819e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2523725641452696738498690662612617936587e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2433896805459210062151728711603994464725e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2360303604522034171339233239494610536963e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2158065741269507590082758655375017943986e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2070189655119779400865094728854904947808e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2061142396750735083467994641157520060232e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2030527684332139111766898568197582442706e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2027330670934513472375234427689931284252e-02) }}, 
      {{ SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.4916328125000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2004392174438868692965498590155843765847e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.6320881526499254460283925417289263844970e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.8008435267416782089137700897733980769397e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.6115557924978384736917777061270920158896e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.7944563878341305074420856723590712814175e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4563937735272458249577842472870940399372e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.7392601100025880618609512238385092486226e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.3512348181617128445511027630159884787304e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.6938833876329257172981846931068161840021e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1245208390465010285448477093518886323539e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.5684576291359541514351598481171479128718e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0449385709367751998204925064559839183580e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.5136241880496478204100297978219040519461e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0372265034687226378759741028922967527236e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.5079673275853165283194456838158188236649e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0117270800719912361495952148350902290474e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.4888093327216830317906672974376086420119e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0091155802959264473638982620367402265892e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.4868072949738844651387576075756011660404e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9906502211165032982250973973260672821638e-02) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4673601562500000000000000000000000000000e+04), SC_(9.4724348478592283704275294853952854219434e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.8008435267416782089137700897733980769397e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.7944563878341305074420856723590712814175e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.7392601100025880618609512238385092486226e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.6938833876329257172981846931068161840021e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.5684576291359541514351598481171479128718e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.5136241880496478204100297978219040519461e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.5079673275853165283194456838158188236649e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.4888093327216830317906672974376086420119e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.4868072949738844651387576075756011660404e-03) }}, 
      {{ SC_(2.4673601562500000000000000000000000000000e+04), SC_(2.4673601562500000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.4724348478592283704275294853952854219434e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8270376856619688012344279775885417239028e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1519178325347003823159288019637789979863e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8142226236627222982538815092150738232021e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1493917536380219749833129851503009675723e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7173327343484257482620140635979256547465e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1274993177383416490440643542759765800898e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6516070246305596973100133924058891607377e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1094172763501848958230598903852492617238e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5096619432051217816571182829469339228835e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0590381974526566092493465969169644723369e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4597254631763537903866934998448101489921e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0368284368370879777709666281296445921515e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4548824258265080293428851554734543089533e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0345307357562001680454369284400642994089e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4388639764001689355098013648876043602289e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0267401761762376592337437593024003543361e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4372229915473538089591683057542981182322e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0259252513234903200686134405567572872343e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4256173537684261815121807365751395753172e-02) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.0200705293414166528568101144002860151327e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1519178325347003823159288019637789979863e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.1493917536380219749833129851503009675723e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.1274993177383416490440643542759765800898e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1094172763501848958230598903852492617238e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.0590381974526566092493465969169644723369e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.0368284368370879777709666281296445921515e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.0345307357562001680454369284400642994089e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.0267401761762376592337437593024003543361e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.0259252513234903200686134405567572872343e-03) }}, 
      {{ SC_(6.3572343750000000000000000000000000000000e+04), SC_(6.3572343750000000000000000000000000000000e+04), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.0200705293414166528568101144002860151327e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4643855247870445472423414481896999897245e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.6625881962998695708867483013956757618038e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4546970298239506341818983190601863718809e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.6611349083348286160135746076404689085243e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3814345768778229714167760324192057478320e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.6485250392781009712714012421464960624768e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3317220602852489515268264911608786601663e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.6380898321353586076069395988829248688479e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2242989944623235719759003130591440010492e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.6089198392451402225403675132533345158250e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1864796078226797443101580320084025657103e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.5960151850848305199436537473063711922383e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1828107509532405512103253312626418469535e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.5946785663761630763038515488303760904015e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1706745735991859901781008778864760924106e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.5901444446344014650046650174118503974760e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1694311810776247119132551833954080174518e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.5896699605844459341187153212611357277750e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1606367940456023007326922608453483127203e-02) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.5862599991656764858822971476767654574810e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.6625881962998695708867483013956757618038e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.6611349083348286160135746076404689085243e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.6485250392781009712714012421464960624768e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.6380898321353586076069395988829248688479e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.6089198392451402225403675132533345158250e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.5960151850848305199436537473063711922383e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.5946785663761630763038515488303760904015e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.5901444446344014650046650174118503974760e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.5896699605844459341187153212611357277750e-03) }}, 
      {{ SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.1135068750000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.5862599991656764858822971476767654574810e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1946532433659387140003901725670575147686e-02) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.6234697963266043715476722370476238362159e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1871375264751399916213675025195387581330e-02) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.6225911473692459630868121175594409575762e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1303000381993359013252621501998073547282e-02) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.6149610032182062421153832143717953942174e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0917261045494291464054702589734199686311e-02) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.6086381910800662915311395161840478882863e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0083441911112741048814928947525677696693e-02) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5909226817362103049508398961803758035440e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.7897583646782857004327606039644413406326e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5830661068364111852053809215391352493908e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.7612635434618571316027545713459274033785e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5822516723283590610821505439219630804682e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.6669994397126969448195203643811651305507e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5794879723132100110286847426769483613827e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.6573411952936268967681697058571323957916e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5791986735904536475188411101297991218243e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.5890263005279856489005894949862101264536e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8516100000000000000000000000000000000000e+05), SC_(3.5771191062645537542574792951647891261376e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.6234697963266043715476722370476238362159e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.6225911473692459630868121175594409575762e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.6149610032182062421153832143717953942174e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.6086381910800662915311395161840478882863e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5909226817362103049508398961803758035440e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5830661068364111852053809215391352493908e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5822516723283590610821505439219630804682e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5794879723132100110286847426769483613827e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5791986735904536475188411101297991218243e-03) }}, 
      {{ SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.8516100000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.5771191062645537542574792951647891261376e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.0005594026800349606877846463945371047244e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2209707515814560863320415319286657784092e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.9546091015813090702109415310382490530567e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2206401658877340122581735258756466343821e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.6070774589269094181481220774424574361147e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2177661640532529596781077419842341015022e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.3711748376590796680112439467970093494743e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2153802170254780649559677469573209904256e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.8610605566120829706529202734088729107053e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2086740208017847758066711773293713815692e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.6813051644739610852959741841696059586147e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2056899110114706181293058211856421844357e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.6638612210482927562740365513287798797498e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2053802172731600500980842801176357091632e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.6061504193486609982655190085799152837203e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2043288091122990197955281700793765013945e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.6002370240323218644700747231392872181062e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2042187056034085090772920749041590927193e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.5584081717446882091207500571890726205927e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.2034270016646720054476078153201929797546e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.2209707515814560863320415319286657784092e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.2206401658877340122581735258756466343821e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.2177661640532529596781077419842341015022e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.2153802170254780649559677469573209904256e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.2086740208017847758066711773293713815692e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.2056899110114706181293058211856421844357e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.2053802172731600500980842801176357091632e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.2043288091122990197955281700793765013945e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.2042187056034085090772920749041590927193e-03) }}, 
      {{ SC_(4.9568887500000000000000000000000000000000e+05), SC_(4.9568887500000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.2034270016646720054476078153201929797546e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.7576565465770330294968588471187480179826e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8117515852864788194591237320730483482098e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.7202012798288555175869526703775053477857e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8115315055127129923096578627986770262389e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.4369132865263428951535044083680976250907e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8096175791812660303808434856339895047628e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.2446110177779811368820593415599008220815e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8080278170727488041638505591198665579130e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.8287438059584596447557899774321563580845e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8035553160371244320134575362939044225896e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.6821834866981581244187737155893212916286e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8015631843785212586754026078666019662086e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.6679603055114506109702287237649163617548e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8013563696647182510489094562877383996490e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.6209041354273699789209903112684409342331e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8006541377231024079182857343775721042117e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.6160824059155367192242644197644326753540e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8005805912609358750407642844624122117846e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.5819751382597393631641195864549447253921e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8000517037280181614575488881237596682791e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.8117515852864788194591237320730483482098e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.8115315055127129923096578627986770262389e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.8096175791812660303808434856339895047628e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.8080278170727488041638505591198665579130e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.8035553160371244320134575362939044225896e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.8015631843785212586754026078666019662086e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.8013563696647182510489094562877383996490e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8006541377231024079182857343775721042117e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8005805912609358750407642844624122117846e-03) }}, 
      {{ SC_(7.4614825000000000000000000000000000000000e+05), SC_(7.4614825000000000000000000000000000000000e+05), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.8000517037280181614575488881237596682791e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.4257609046449114067654181073861679454893e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0934524309467062961101798208156817168177e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.4031863048409686756395069760573803374948e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0933722065685501746129491499111680905829e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2324412778235894297451653655126412534122e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0926741328082079376280388009581436931595e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.1165291611651800318455962944277062766334e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0920937447802867431346733227018608683050e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.8658326015266171079217676190719676529919e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0904582595462852176410077571073628500290e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.7774684739625162544141395971840762780767e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0897285147077051502568166499718111267887e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.7688925489161376421189242432898537597849e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0896527107518469112958247756020398232685e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.7405191614427507811085712668426294465235e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0893952580495536476899679123631463538524e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.7376117497867875754155561215170225029304e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0893682887609392557217928855212510404756e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.7170453767458328213139633433365330078569e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.0891743156317586249811721236217419175631e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0934524309467062961101798208156817168177e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0933722065685501746129491499111680905829e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0926741328082079376280388009581436931595e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.0920937447802867431346733227018608683050e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.0904582595462852176410077571073628500290e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.0897285147077051502568166499718111267887e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.0896527107518469112958247756020398232685e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.0893952580495536476899679123631463538524e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.0893682887609392557217928855212510404756e-03) }}, 
      {{ SC_(2.0544660000000000000000000000000000000000e+06), SC_(2.0544660000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.0891743156317586249811721236217419175631e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.6152879354973043311048166357601371657477e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.6115383462285896937974879546502646341360e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5975172145798171723802486050745531676793e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.6110406403856638998455964691910770405146e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.4631058175764489348908093323765794966599e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.6067090376322432880140622606630056014055e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3718579429566080477534644133216081789886e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.6031065817710572173116729311022510053296e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1745001832619374830108957679957622573629e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5929497752546924805093231220289952795226e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1049340505739109293448440636454110110367e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5884152966382796323446578611616032903998e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.0981824169314657760980710034678847746291e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5879441762645667055170360706785663485799e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.0758445539173494270699339226314019978187e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5863439842789009574517298183379568951944e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.0735555887409548177627891217135319126829e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5861763458147839143013607982938467690734e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.0573639014245901355081451722363437126144e-03) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3155060000000000000000000000000000000000e+06), SC_(8.5849705640677469083413432552548168941298e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.6115383462285896937974879546502646341360e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.6110406403856638998455964691910770405146e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.6067090376322432880140622606630056014055e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.6031065817710572173116729311022510053296e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.5929497752546924805093231220289952795226e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.5884152966382796323446578611616032903998e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.5879441762645667055170360706785663485799e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.5863439842789009574517298183379568951944e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.5861763458147839143013607982938467690734e-04) }}, 
      {{ SC_(3.3155060000000000000000000000000000000000e+06), SC_(3.3155060000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.5849705640677469083413432552548168941298e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.7159275202591367660914031436666820322176e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1584025537860501195557558031431630441685e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7032251908045786791478079651549903096981e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1581479540451395207185965056962784694331e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.6071487286371236649590030810370610843512e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1559317009017491372455036302630491421522e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.5419245423792351116966368119142153811255e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1540879174639347405223849459878800736772e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4008494699381531732762757530906705380313e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1488866156350448886046883510366699283008e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.3511207056382408487960382226575850084784e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1465631175273604158903152158426201029302e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.3462942996661785787872503126878344170130e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1463216629404523522097618871066655288802e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.3303259957224009935054057425152072958494e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1455014769789784926319500045296155852416e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.3286897132984557038798103152907331552119e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1454155469008200128129292794389333017190e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.3171149348560403199762256873646969666327e-03) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1447974386365517328530879297528888632066e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.1584025537860501195557558031431630441685e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.1581479540451395207185965056962784694331e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.1559317009017491372455036302630491421522e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1540879174639347405223849459878800736772e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.1488866156350448886046883510366699283008e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(6.1465631175273604158903152158426201029302e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(6.1463216629404523522097618871066655288802e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(6.1455014769789784926319500045296155852416e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(6.1454155469008200128129292794389333017190e-04) }}, 
      {{ SC_(6.4894920000000000000000000000000000000000e+06), SC_(6.4894920000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(6.1447974386365517328530879297528888632066e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.2845164536430267077063754078387504403133e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0345796236292434842038817378456667339835e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.2741344310586759346616757027422486422728e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0344094474062257935090043733778275278173e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1956078754006182584723097033369938178655e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0329279547937449821151183075283662950978e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.1422977063173355041507916905470005569040e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0316952631672222328793087152930912297939e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0269907703344615752725519120296133391993e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0282169526909955702733784392519747246438e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9863447608919151012024683816743372507957e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0266627131656300141523575365421931620678e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9823998606911725630358320601714468994329e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0265011836989713845166762733162438568806e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9693480196560132628948200149458983147527e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0259524704274263096084800425569716202460e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9680105868764310676534482632024246217969e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0258949803746661080785970563456746472211e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9585498068879160673223447332065083971986e-03) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.7144880000000000000000000000000000000000e+06), SC_(5.0254814349562333601920041290455557126968e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.0345796236292434842038817378456667339835e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.0344094474062257935090043733778275278173e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0329279547937449821151183075283662950978e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0316952631672222328793087152930912297939e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.0282169526909955702733784392519747246438e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.0266627131656300141523575365421931620678e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.0265011836989713845166762733162438568806e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.0259524704274263096084800425569716202460e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.0258949803746661080785970563456746472211e-04) }}, 
      {{ SC_(9.7144880000000000000000000000000000000000e+06), SC_(9.7144880000000000000000000000000000000000e+06), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.0254814349562333601920041290455557126968e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7064818464605077438577028396214939314451e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5912951950097746220978767997271568934634e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6990782098682952209556716186173324384165e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5912085906611336289771277579841300203736e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6430791596485000618780753813078728139416e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5904545571004992230504337838140123795987e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6050623126287432714993438194235540856515e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5898270359115258177887394816020124851257e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.5228332387855292807635032578327338405509e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5880557611256953155122491972748734563261e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4938469093164257439929184150660685470910e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5872640094731182122725290890254060617450e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4910336267565437468359670698093962063391e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5871817141609934344581104303500104026340e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4817257641311494451967721807937449248283e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5869021442327174022081484838487557366455e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4807719782219343040326852510922323309065e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5868728517502551241202899601481668367839e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4740250441025106457848300496248389265409e-03) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9102944000000000000000000000000000000000e+07), SC_(3.5866621340367354333661248512006118770365e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5912951950097746220978767997271568934634e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5912085906611336289771277579841300203736e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5904545571004992230504337838140123795987e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5898270359115258177887394816020124851257e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5880557611256953155122491972748734563261e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5872640094731182122725290890254060617450e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5871817141609934344581104303500104026340e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5869021442327174022081484838487557366455e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5868728517502551241202899601481668367839e-04) }}, 
      {{ SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9102944000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.5866621340367354333661248512006118770365e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.0435398706313944615222922177356839350220e-03) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0421796631810503465259279524426683242990e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.0393311221339478148990130909789160041430e-03) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0421516543367207979621251419480954251524e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.0074972629697639098824346990540637238938e-03) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0419077608226920252046486416004437822831e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.8588569964284986906368239406388856567791e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0417047464172530435891338916835540255083e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.3914034232777061433212197208721257967567e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0411315034425131109883646518537664955059e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.2266211851394163341784956166405203108133e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0408751691677860349880710376640351461406e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.2106281062778258247513357456260686923521e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0408485221240789461119303534302013151824e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.1577142580529585755736334145561871417980e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0407579931339851671306057828900719018145e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.1522921163862513757206283855304352788557e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0407485073491000092401365304809358876054e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.1139366843001959201215993229363331403892e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.0406802682034304657235461762335003461016e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.0421796631810503465259279524426683242990e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.0421516543367207979621251419480954251524e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.0419077608226920252046486416004437822831e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0417047464172530435891338916835540255083e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0411315034425131109883646518537664955059e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.0408751691677860349880710376640351461406e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.0408485221240789461119303534302013151824e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.0407579931339851671306057828900719018145e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.0407485073491000092401365304809358876054e-04) }}, 
      {{ SC_(5.9113888000000000000000000000000000000000e+07), SC_(5.9113888000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.0406802682034304657235461762335003461016e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.2872768091360530043980857089280287243862e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7879516499467486093992688299583365699539e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.2504306233135805882490187674054563577009e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7879301800333743535122942578571316595297e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.9717357731988562313042585353153474692276e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7877432219565678207167383181109301908729e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.7825336474611557762800388148867854579150e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7875875947834271527552867755186075855151e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.3732930863636009529563667043464570017690e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7871481314362840420686904625439112010498e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.2290313757925013972248783063152493049934e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7869516064920084694434159683545880770367e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.2150299279699836468075061307410385751865e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7869311764493173102813196225295902481037e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.1687054755610495916601341843402336976035e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7868617680960656603071379441906071930404e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.1639585559493372044762008128146501564114e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7868544953135327614444265293403963924381e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.1303795410719122178421314730928857929871e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.7868021758299929519213804266809179284426e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7879516499467486093992688299583365699539e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.7879301800333743535122942578571316595297e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.7877432219565678207167383181109301908729e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.7875875947834271527552867755186075855151e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.7871481314362840420686904625439112010498e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.7869516064920084694434159683545880770367e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.7869311764493173102813196225295902481037e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.7868617680960656603071379441906071930404e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.7868544953135327614444265293403963924381e-04) }}, 
      {{ SC_(7.7127808000000000000000000000000000000000e+07), SC_(7.7127808000000000000000000000000000000000e+07), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.7868021758299929519213804266809179284426e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.6437652781772519126692154093941763388608e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2221554098643274454268622757981802982656e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.6185819258290687629918014002271173373299e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2221453776427572551685575381499935555603e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.4281016067004766986439608318744566066711e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2220580139833389930525359323376709586497e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.2987870260929653957344803664502887566300e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2219852855059203078685965152253242216583e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(6.0190816513945599160706623340671255076842e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2217798865895374881130889226933885831027e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.9204822866186093461327022915578429862322e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2216880208726845190073827119911842120485e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.9109126305770623189182112235691543697142e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2216784703832217184854761856255081920806e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.8792509603080204326054861714158414347334e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2216460232289468478859551493344247977726e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.8760065517978894935198101809791517671079e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2216426232772682723826898335359686881340e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.8530560753581765106582969034838233043326e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2216181641339875587717661225508254322696e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.2221554098643274454268622757981802982656e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.2221453776427572551685575381499935555603e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.2220580139833389930525359323376709586497e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.2219852855059203078685965152253242216583e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2217798865895374881130889226933885831027e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2216880208726845190073827119911842120485e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2216784703832217184854761856255081920806e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2216460232289468478859551493344247977726e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2216426232772682723826898335359686881340e-04) }}, 
      {{ SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.6510873600000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2216181641339875587717661225508254322696e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.8410972229171361065973959425784315524874e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5480820816873515437886006761403907573466e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.8234846235765110157245896402823107411939e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5480330024092139518396683080832222505682e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.6902674850266302582791868645572062790029e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5476055923878666648960537710895096151803e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.5998280922759581774338120249982434334696e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5472497649183663519138798749263372914853e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.4042089878266250110881180383877347463855e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5462447563397292715939309195205662092197e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.3352509331696441793860967595070482064340e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5457952205706545671748210768207500685385e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.3285581404226654997048421089884598860001e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5457484847603671809054101559432867629612e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.3064147080801530203367021400589398846993e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5455897009228573306204520171699952962057e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.3041456442620482572631175024415193285749e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5455730626919329639106845042082425960604e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.2880946133025802163259055329030647052140e-04) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.3755980800000000000000000000000000000000e+08), SC_(8.5454533667809445729029043925523249130780e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.5480820816873515437886006761403907573466e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.5480330024092139518396683080832222505682e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.5476055923878666648960537710895096151803e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.5472497649183663519138798749263372914853e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.5462447563397292715939309195205662092197e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.5457952205706545671748210768207500685385e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.5457484847603671809054101559432867629612e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.5455897009228573306204520171699952962057e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.5455730626919329639106845042082425960604e-05) }}, 
      {{ SC_(3.3755980800000000000000000000000000000000e+08), SC_(3.3755980800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.5454533667809445729029043925523249130780e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.0230761623802426517032972087092751761894e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0388662204038335065570063087922577520683e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.0126947453512560167737674749367951596644e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0388491657751743311639467509251855177994e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.9341723871709562964009459167685682538491e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0387006402618560112667555662127304862941e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.8808645612251902167344781705848044257751e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0385769840363124369205798287827922445519e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.7655604457927987440028042450149810057822e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0382276979409002033002674699731947807010e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.7249143505338617577207415093160375142374e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0380714503940204031838482687327141904208e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.7209694022363517500454494677752042594425e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0380552057013458205733738487690937736037e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.7079173463296550109700310608269764373645e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0380000140606411706056864794215297299865e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.7065798865293333601338687434398225597907e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0379942307213454500985588013012468007058e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.6971188876457160703545553333562809914572e-04) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.7159372800000000000000000000000000000000e+08), SC_(5.0379526248763413143891293917273462865166e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.0388662204038335065570063087922577520683e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.0388491657751743311639467509251855177994e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.0387006402618560112667555662127304862941e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.0385769840363124369205798287827922445519e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.0382276979409002033002674699731947807010e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.0380714503940204031838482687327141904208e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.0380552057013458205733738487690937736037e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.0380000140606411706056864794215297299865e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.0379942307213454500985588013012468007058e-05) }}, 
      {{ SC_(9.7159372800000000000000000000000000000000e+08), SC_(9.7159372800000000000000000000000000000000e+08), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.0379526248763413143891293917273462865166e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.1994365274169270357009053054434098941916e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5330115212115032714395713357492812234919e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1921577983710972308070923551660591869482e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5330031367822616703757236599959991541049e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1371033691816044959990369234196563418158e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5329301175000168181688787755204261698978e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.0997276179537602712599881212901257809875e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5328693234421737872996201886536462040752e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.0188843560566717157784590717636115609141e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5326975953000309489392858078518297309492e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9903861229858939756681051486318560616972e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5326207726215702770852210695767036723783e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9876201976592589410357098600648350343631e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5326127854462410715785184317411587757547e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9784689970848125877129933755699025869428e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5325856487300312377233735861308824723648e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9775312625764526051089781585544161386898e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5325828051556176006369088188810590687726e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9708978629589291182958798741117056329373e-04) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9764551680000000000000000000000000000000e+09), SC_(3.5325623481634782301928103980709146284869e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.5330115212115032714395713357492812234919e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.5330031367822616703757236599959991541049e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.5329301175000168181688787755204261698978e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.5328693234421737872996201886536462040752e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.5326975953000309489392858078518297309492e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.5326207726215702770852210695767036723783e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.5326127854462410715785184317411587757547e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.5325856487300312377233735861308824723648e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.5325828051556176006369088188810590687726e-05) }}, 
      {{ SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9764551680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.5325623481634782301928103980709146284869e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.5552661723420707640860824617925232354192e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4036347228763177853445587338580702056478e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.5503143052896860608432128881294455240328e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4036308420391241501275793440063129546608e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.5128596593843034023180825848231201272961e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4035970438504714318128373183753460211744e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4874321760848105031440872832193828143788e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4035689038898599634553424282646282671629e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4324328575253744383493369493951808459095e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034894134141348413243562336481573442327e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4130449267677868064921555513335466281332e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034538523197109734847771012715765876943e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4111632111280269597935712631092750005999e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034501550340846440068319991899064180175e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4049374618740806413375172615921631585690e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034375933235916217536743070128955086048e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4042995018647770040145877953924454288081e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034362770155384777689492669006154565772e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3997866640690226151846196355299371595460e-04) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.4034268073236603538564651972113601789296e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.4036347228763177853445587338580702056478e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.4036308420391241501275793440063129546608e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.4035970438504714318128373183753460211744e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.4035689038898599634553424282646282671629e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.4034894134141348413243562336481573442327e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.4034538523197109734847771012715765876943e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.4034501550340846440068319991899064180175e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.4034375933235916217536743070128955086048e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.4034362770155384777689492669006154565772e-05) }}, 
      {{ SC_(4.2703175680000000000000000000000000000000e+09), SC_(4.2703175680000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.4034268073236603538564651972113601789296e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4005313086153743886370395431733150791094e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1400472823618401620442050370727539996173e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3961224969971484976473758384798272436498e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1400442060071180733086481315891081237578e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3627753822939464706602588814568003585547e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1400174139948343230320726453127075984987e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3401364495946968651052222312531235322861e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1399951072136517627529925937994508035403e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2911687293428727815393364238158408109082e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1399320940696690164626745195361649247725e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.2739070102347804310424155584523225160874e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1399039041405868377829917461084326854232e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.2722316562496720539951417484040591562922e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1399009732282629814213245794477818163989e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.2666886647180682389764440418073242344045e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1398910152997973602628163170194501474898e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.2661206677116516260864631696529026193926e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1398899718342854424313899167346858036881e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.2621027381758297413002485815732911154399e-04) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.1398824650026906339308016990141404629978e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.1400472823618401620442050370727539996173e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.1400442060071180733086481315891081237578e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(4.4206802368164062500000000000000000000000e+01), SC_(2.1400174139948343230320726453127075984987e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(6.1633407592773437500000000000000000000000e+01), SC_(2.1399951072136517627529925937994508035403e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.1399320940696690164626745195361649247725e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.1399039041405868377829917461084326854232e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.1399009732282629814213245794477818163989e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.1398910152997973602628163170194501474898e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.1398899718342854424313899167346858036881e-05) }}, 
      {{ SC_(5.3871001600000000000000000000000000000000e+09), SC_(5.3871001600000000000000000000000000000000e+09), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.1398824650026906339308016990141404629978e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(9.9605844881589091824439107877655835769711e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4682053067144232603754862802128730583159e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(9.9303377174849575064550088563231588976002e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4682038587220333728993910345657265634758e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(9.7015589386192914105586666193094656058825e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681912480697825490363281331786637894230e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(9.5462439287113107633320672615225550346346e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681807484642681377335217776916421754229e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(9.2102995500430086994531506577892805604009e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681510882741860110133241866659712065350e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(9.0918750510784818184447609830402709732264e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681378190988553223979561166994019319411e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(9.0803812387804405123861622676627561958590e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681364394923856538949473027344760377720e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(9.0423533919950768076775348423470742871568e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681317521960552198034633444313915186180e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(9.0384566327925377531045206347786506966139e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681312610254448093765798608429501241223e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(9.0108915157432107404285208141609591053673e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.4681277274723757384762822136202090215804e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.4682053067144232603754862802128730583159e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.4682038587220333728993910345657265634758e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.4681912480697825490363281331786637894230e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.4681807484642681377335217776916421754229e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.4681510882741860110133241866659712065350e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.4681378190988553223979561166994019319411e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.4681364394923856538949473027344760377720e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.4681317521960552198034633444313915186180e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.4681312610254448093765798608429501241223e-05) }}, 
      {{ SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.1445641216000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.4681277274723757384762822136202090215804e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(6.3196275170740709794370771451342997742211e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8971175273994938994555055575991654307601e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(6.3012986160517171979180855510710101023025e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8971122100652328243639683722118814026231e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(6.1626635314425016997199269475555017214230e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8970659008678607709983103000628814753233e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.0685459309140317807488237369959017279860e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8970273436215970285686658565213302033887e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.8649707619711738703957694266839026246506e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8969184223428605436117205328013667798423e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.7932080253513505391381907327650397524091e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8968696931849274696436299711495422619934e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.7862430186208326665298298861243598694675e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8968646267519416566551954756687351779314e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.7631989490828660609967656087732021903419e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8968474132052054631026601768616045805601e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.7608375955501839526962024661125670184064e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8968456094355785301818037223231094581200e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.7441337184776801909086850504584320849016e-05) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.1169175552000000000000000000000000000000e+10), SC_(8.8968326328362889750768872950404566119243e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.8971175273994938994555055575991654307601e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.8971122100652328243639683722118814026231e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.8970659008678607709983103000628814753233e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.8970273436215970285686658565213302033887e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.8969184223428605436117205328013667798423e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.8968696931849274696436299711495422619934e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.8968646267519416566551954756687351779314e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.8968474132052054631026601768616045805601e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.8968456094355785301818037223231094581200e-06) }}, 
      {{ SC_(3.1169175552000000000000000000000000000000e+10), SC_(3.1169175552000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.8968326328362889750768872950404566119243e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3645139800052660397895300822921537808927e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4326699710527608220180942514708643256508e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3492020247947740454626254965977810021270e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4326662600979495940773250715383968672529e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.2333863408545274776393407101831726657094e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4326339409822337675838297295766004825735e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.1547605418850527946414431709465979972260e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4326070318888335404407987809984296814876e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.9846939414869644682747067703419742224016e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4325310154973030525501847895408090599608e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.9247433847978475979729116954435808240773e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4324970071922270166004427305937394284187e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.9189248214150087141956374205288577824041e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4324934713008329042805143453911944863126e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.8996738164281966321788596755614267151112e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4324814578659592762311009914983935502664e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.8977011427827148745522327253249633276161e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4324801990040479216408807098895117800638e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.8837467316203422330634175642757366111796e-05) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.4661866496000000000000000000000000000000e+10), SC_(7.4324711425525747195981389430251022104011e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(7.4326699710527608220180942514708643256508e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(7.4326662600979495940773250715383968672529e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(7.4326339409822337675838297295766004825735e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(7.4326070318888335404407987809984296814876e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(7.4325310154973030525501847895408090599608e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(7.4324970071922270166004427305937394284187e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(7.4324934713008329042805143453911944863126e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(7.4324814578659592762311009914983935502664e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(7.4324801990040479216408807098895117800638e-06) }}, 
      {{ SC_(4.4661866496000000000000000000000000000000e+10), SC_(4.4661866496000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(7.4324711425525747195981389430251022104011e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.9891955320172856462169602298826107599721e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3733845636496441326569491443502050985948e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.9781259327672956415468338740408370124479e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3733826241364355824484107522620491842100e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.8943983361555264055977162566473289824225e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3733657326734917170530497569225580492582e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.8375567326113240378352180973650384375096e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3733516686998346781812999763590608235121e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(3.7146090686440565191803419281486210549593e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3733119387255713316050081905748779547952e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(3.6712685131311193601210519225392066107408e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3732941641917557106917964785692308877494e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(3.6670620506107805996380306958056487712900e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3732923161452410988798290905458264736152e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(3.6531447611194764407565737160391577689957e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3732860372752624972579789053499123110565e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(3.6517186397177806055375170434615853642614e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3732853793256277848266912892053954395540e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(3.6416304609338274623907941453979312022535e-05) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(8.5454389248000000000000000000000000000000e+10), SC_(5.3732806459297632803159371961644386842839e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3733845636496441326569491443502050985948e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(2.7095397949218750000000000000000000000000e+01), SC_(5.3733826241364355824484107522620491842100e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(4.4206802368164062500000000000000000000000e+01), SC_(5.3733657326734917170530497569225580492582e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(6.1633407592773437500000000000000000000000e+01), SC_(5.3733516686998346781812999763590608235121e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.2647183227539062500000000000000000000000e+02), SC_(5.3733119387255713316050081905748779547952e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6294470214843750000000000000000000000000e+02), SC_(5.3732941641917557106917964785692308877494e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.6700170898437500000000000000000000000000e+02), SC_(5.3732923161452410988798290905458264736152e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8115838623046875000000000000000000000000e+02), SC_(5.3732860372752624972579789053499123110565e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.8267517089843750000000000000000000000000e+02), SC_(5.3732853793256277848266912892053954395540e-06) }}, 
      {{ SC_(8.5454389248000000000000000000000000000000e+10), SC_(8.5454389248000000000000000000000000000000e+10), SC_(1.9377355957031250000000000000000000000000e+02), SC_(5.3732806459297632803159371961644386842839e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(3.1899393162269823016954257179485910129197e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2086327132618254605882256778093464857559e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.7095397949218750000000000000000000000000e+01), SC_(3.1812692189726875370263702981728986411657e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2086315234467348260888232076773752458323e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.4206802368164062500000000000000000000000e+01), SC_(3.1156908371925443966778817304814086530659e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2086211611886899388502127702108686635553e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(6.1633407592773437500000000000000000000000e+01), SC_(3.0711705054039181743853539309875046347240e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2086125334724779375546536423305154904905e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.2647183227539062500000000000000000000000e+02), SC_(2.9748735950459393718223900212200031045683e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085881605698335259494084352715005312011e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.6294470214843750000000000000000000000000e+02), SC_(2.9409277561126793824023803389965718517787e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085772565048279439146685142557711613177e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.6700170898437500000000000000000000000000e+02), SC_(2.9376331075410385596844799573054153206608e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085761227907617074320871505600219849418e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.8115838623046875000000000000000000000000e+02), SC_(2.9267325996348257372063288426570340858431e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085722709147198388539476894810232960003e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.8267517089843750000000000000000000000000e+02), SC_(2.9256156114720783963249716026808728453558e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085718672845573634323994067570782514367e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.9377355957031250000000000000000000000000e+02), SC_(2.9177141969958960299496759812961014722592e-05) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.2085689635032439097758493875444377071514e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(4.2086327132618254605882256778093464857559e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(4.2086315234467348260888232076773752458323e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(4.4206802368164062500000000000000000000000e+01), SC_(4.2086211611886899388502127702108686635553e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(6.1633407592773437500000000000000000000000e+01), SC_(4.2086125334724779375546536423305154904905e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.2647183227539062500000000000000000000000e+02), SC_(4.2085881605698335259494084352715005312011e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6294470214843750000000000000000000000000e+02), SC_(4.2085772565048279439146685142557711613177e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.6700170898437500000000000000000000000000e+02), SC_(4.2085761227907617074320871505600219849418e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8115838623046875000000000000000000000000e+02), SC_(4.2085722709147198388539476894810232960003e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.8267517089843750000000000000000000000000e+02), SC_(4.2085718672845573634323994067570782514367e-06) }}, 
      {{ SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.3929971712000000000000000000000000000000e+11), SC_(1.9377355957031250000000000000000000000000e+02), SC_(4.2085689635032439097758493875444377071514e-06) }}, 
      {{ SC_(5.3031193804800000000000000000000000000000e+11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(2.5397361755371093750000000000000000000000e+01), SC_(1.7266897922078632640170677484220555485267e-05) }}, 
      {{ SC_(5.3031193804800000000000000000000000000000e+11), SC_(2.5397361755371093750000000000000000000000e+01), SC_(5.3031193804800000000000000000000000000000e+11), SC_(2.1570105129580744526656408927638324321000e-06) }}, 
      {{ SC_(5.3031193804800000000000000000000000000000e+11), SC_(2.7095397949218750000000000000000000000000e+01), SC_(2.70953979492187500000000000000000000000