// Copyright 2014 Google Inc. All Rights Reserved.
//
// Created by postproc-cld2 4.0 on 2014-02-02 09:39:20
// From command line:
//  --cld2 --cc --just_read_raw --delta_octa
//  --wrt=cld2_generated_quadchrome0122_2.bin --standard --minchars=5
//  --mincount=2 --max_items_per_langscript=300 --flatmap --rr_alloc
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224
//  --v25 --kentries=16 --tablename=DeltaOctaChrome0122
//  --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn nd-Latn=>nr-Latn
//  blu-Latn=>hmn-Latn nn-Latn=>no-Latn  --include=af-Latn ar-Arab be-Cyrl
//  bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn    da-Latn de-Latn el-Grek
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn    ga-Latn gd-Latn
//  hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr    ja-Hani
//  ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn
//  pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn
//  sl-Latn sr-Cyrl    sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl
//  vi-Latn yi-Hebr    zh-Hani zh-TW zhT-Hani    sq-Latn az-Latn eu-Latn
//  bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab    bh-Deva mr-Deva
//  ne-Deva lg-Latn rw-Latn gd-Latn    ut-Latn ut-Deva    ceb-Latn blu-Latn
//  hmn-Latn jw-Latn    so-Latn ig-Latn ha-Latn yo-Latn zu-Latn --ko_english
//  --force_to_lang_soft --nosoft_cram2 --nomsidlevel --shapeflatprob
//  --langpriorpercent=10 --skipnuc --noshapeforcetop --noshapeeventop
//  --noshapesteep2 --spread=15 --nodoubleclose --langcounts --writebin
//  --list_items=120 /hdb1/cld2/probs/p90_raw_octagrams_2014.utf8
//
// CLD2_pslangs
//
// See compact_lang_det.cc for usage
//
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDeltaOctaChrome0122BuildDate = 20140202;    // yyyymmdd


// Of 22890 offered items into 16384 table entries:
// 15078 filled (65%), 4 merged (0%), 7808 dropped (34%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 71 languages in range ENGLISH..HMONG:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY
//     WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC
//     CATALAN BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE
//     VIETNAMESE SLOVAK AZERBAIJANI PERSIAN BOSNIAN ZULU YIDDISH
//     SOMALI MONGOLIAN AFRIKAANS YORUBA HAUSA HAITIAN_CREOLE
//     KINYARWANDA GANDA IGBO CEBUANO HMONG

// TopLanguage  TokenCount
//  ENGLISH 187
//  DANISH 199
//  DUTCH 198
//  FINNISH 214
//  FRENCH 189
//  GERMAN 189
//  HEBREW 199
//  ITALIAN 198
//  Japanese 200
//  Korean 193
//  NORWEGIAN 204
//  POLISH 199
//  PORTUGUESE 220
//  RUSSIAN 205
//  SPANISH 187
//  SWEDISH 188
//  Chinese 196
//  CZECH 381
//  ICELANDIC 195
//  LATVIAN 203
//  LITHUANIAN 201
//  ROMANIAN 376
//  HUNGARIAN 201
//  ESTONIAN 193
//  Unknown 5
//  BULGARIAN 187
//  CROATIAN 357
//  SERBIAN 405
//  IRISH 201
//  GALICIAN 195
//  TAGALOG 191
//  TURKISH 200
//  UKRAINIAN 208
//  HINDI 398
//  MACEDONIAN 200
//  BENGALI 203
//  INDONESIAN 384
//  MALAY 349
//  WELSH 212
//  NEPALI 192
//  ALBANIAN 188
//  BELARUSIAN 198
//  JAVANESE 193
//  URDU 190
//  BIHARI 292
//  ARABIC 186
//  CATALAN 195
//  BASQUE 196
//  SCOTS_GAELIC 190
//  SWAHILI 197
//  SLOVENIAN 207
//  MARATHI 199
//  MALTESE 196
//  VIETNAMESE 195
//  SLOVAK 349
//  AZERBAIJANI 189
//  PERSIAN 188
//  BOSNIAN 192
//  ZULU 204
//  YIDDISH 197
//  SOMALI 195
//  MONGOLIAN 4
//  AFRIKAANS 200
//  YORUBA 205
//  HAUSA 195
//  HAITIAN_CREOLE 192
//  KINYARWANDA 194
//  GANDA 194
//  IGBO 183
//  CEBUANO 188
//  HMONG 189



// Recognized language-script combinations [73]:
static const char* const kDeltaOctaChrome0122RecognizedLangScripts =
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "ha-Latn hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn ig-Latn "
  "is-Latn it-Latn iw-Hebr ja-Hani jw-Latn ko-Hani lg-Latn lt-Latn "
  "lv-Latn mk-Cyrl mn-Latn mr-Deva ms-Latn mt-Latn ne-Deva nl-Latn "
  "no-Latn pl-Latn pt-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn sk-Latn "
  "sl-Latn so-Latn sq-Latn sr-Cyrl sr-Latn sv-Latn sw-Latn tl-Latn "
  "tr-Latn uk-Cyrl un-Latn ur-Arab vi-Latn yi-Hebr yo-Latn zh-Hani "
  "zu-Latn ";

static const uint32 kDeltaOctaChrome0122Size = 4096;    // Bucket count
static const uint32 kDeltaOctaChrome0122KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDeltaOctaChrome0122[kDeltaOctaChrome0122Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x1682b002,0x53576003,0x9df80004,0x527fe005}},	// [000] _उमराव_, _þremur_, _געעפנט_, _vatni_,
   {{0x67c95006,0x63dd7007,0x00000000,0x00000000}},	//   _zastosow, _abawon_, --, --,
   {{0x3a4ba008,0xc3877009,0x29edc00a,0x9e1ac00b}},	//   _בלילה_, _siaran_, _finitura_, _kecelaka,
   {{0x627ef00c,0x5292500d,0x2249700e,0x23f8500f}},	//   _ikinci_, _intara_, _agamba_, _palun_,
   {{0x72d9f010,0x9b7dd011,0xb2ca4012,0xf2da5013}},	//   _kuten_, _prenumer, _galleri_, _meteen_,
   {{0x7e716014,0x83eb9015,0x94f30016,0x00000000}},	//   _karaoké_, _nesta_, _shembull_, --,
   {{0xc1833017,0xee040004,0xc1758018,0x52b15019}},	//   _плате_, _ערנסטע_, _מועצת_, _mostrará_,
   {{0xb290001a,0x0200201b,0x00000000,0x00000000}},	//   _asiat_, _zikir_, --, --,
   {{0xf2b1d01c,0x8a3e501d,0x2387401e,0x82d9801f}},	//   _bendova_, _haritası_, _cierto_, _ogres_,
   {{0x2d5dc020,0xd10aa021,0x72902022,0x53f82023}},	//   _북마크하기_, _gruodžio_, _cikar_, _pakub_,
   {{0xf2919024,0xf6d2c025,0xdb615026,0x0364b027}},	//   _insan_, _ताहिक_, _सनसनी_, _podrazum,
   {{0x53866028,0x3061e029,0x625ad02a,0x47bb502b}},	//   _exora_, _विकसक_, _faller_, _objektyv,
   {{0xbc67202c,0xd292502d,0x6b9a202e,0xf248902f}},	//   _другие_, _antara_, _ekonomic, _esame_,
   {{0xbceb3030,0xeccea031,0x39fe0032,0xe2484033}},	//   _मदनमोहन_, _县级以上地方人民, _novament, _gamme_,
   {{0xf1c92034,0x6e059035,0xd3ebe036,0x3d370037}},	//   _доста_, _kendaraa, _detto_, _شکلات_,
   {{0x627ef038,0xe3a7e039,0x53ebe03a,0x0d69203b}},	//   _nyingi_, _مجموعی_, _letto_, _kulturës_,
   {{0xf27ed03c,0x8849b03d,0xb3eb903e,0xcc7d703f}},	// [010] _ocena_, _コメント記入欄を, _besta_, _versija_,
   {{0x32d9f040,0x6219e041,0xaf3a5042,0x8ceba043}},	//   _guten_, _podnikán, _hellenic_, _pestsawg_,
   {{0xd3eb9044,0x841a6045,0x437b1046,0x48739025}},	//   _desta_, _правилам, _gyfaill_, _बेंगलुरु_,
   {{0xa200c03e,0x92019047,0x5f914048,0x9e72c049}},	//   _undir_, _ansin_, _phẩm_, _डार्क_,
   {{0xba53b04a,0x32da904b,0x0e59804c,0x2e42a04d}},	//   _menerima_, _amplify_, _pembinaa, _カタログ情報を_,
   {{0x03ea604e,0xe25a6023,0x0ad2004f,0xa7125050}},	//   _multe_, _mulle_, _gratuite, _construç,
   {{0xf2918051,0xb2495052,0x5dd4e053,0x6394e054}},	//   _kiran_, _iqembu_, _verkocht_, _naiste_,
   {{0x02018055,0x52240056,0x5c09c057,0x85e3604d}},	//   _jirin_, _olika_, _sempena_, _広告掲載について_,
   {{0x43eb903e,0x00000000,0x00000000,0x00000000}},	//   _besti_, --, --, --,
   {{0xa25b9049,0x32245058,0x00000000,0x00000000}},	//   _jesli_, _kelke_, --, --,
   {{0x15011059,0xfa647054,0xa99c802c,0x52d7105a}},	//   _espesyal_, _lääne_, _последст, _murongo_,
   {{0x62d9f05b,0x54b8205c,0xc98cb05d,0x13f8305e}},	//   _zuten_, _लेटेस्ट_, _abahinda_, _kumuha_,
   {{0xb25a605f,0xdb76d060,0xa247b061,0x0845c062}},	//   _julle_, _àyọkà_, _bendruom, _главна_,
   {{0x73ea6063,0x63258041,0xf3219064,0xde482065}},	//   _ngota_, _tiscali_, _risya_, _البطولات_,
   {{0xa8c4e054,0x5d54c066,0x32feb02d,0x553c0067}},	//   _arvestad, _आवागमन_, _matahari_, _तब्बल_,
   {{0xd2935068,0x6201c03a,0x92912069,0x115d9018}},	//   _가능합니다_, _invia_, _hnyav_, _situatio,
   {{0xccf0e06a,0x9ec0002e,0x04cbf06b,0x394e706c}},	// [020] _ملاحظہ_, _nebezpeč, _चदरिया_, _abayọri_,
   {{0x527ff06d,0x4291200c,0xe2c6406e,0xc200503b}},	//   _jaunu_, _siyah_, _abalaye_, _cilit_,
   {{0xc80a706f,0xe60be070,0x995be070,0x78e62071}},	//   _президен, _معاہدے_, _معاہدہ_, _ефтин_,
   {{0xeebc1072,0x10485073,0xfc6c1040,0xdb7c1056}},	//   _aktuelle_, _naturaln, _aktuell_, _aktuella_,
   {{0xf2919074,0x22f29075,0x9fd60076,0x00000000}},	//   _kisan_, _lleihau_, _pojemnoś, --,
   {{0xa27ee077,0xf30ac078,0x03eaf015,0x00000000}},	//   _nainen_, _abanidij, _manter_, --,
   {{0x267a9079,0x04ddd07a,0xa822907b,0xcf53d07c}},	//   _अभिप्राय_, _французы_, _অতঃপর_, _домашни_,
   {{0xf8a7d07d,0x9320007e,0x4f94607f,0xf2d87035}},	//   _फोटोफिचर_, _abiye_, _апелулуй_, _panen_,
   {{0xce352080,0x53ba1081,0xa230b065,0xd006406c}},	//   _skladova, _виноград, _الآراء_, _adékúnlé_,
   {{0xc6e80082,0x2291900c,0xd2901083,0xc2fce084}},	//   _контроль_, _nisan_, _wahai_, _tengok_,
   {{0x83eb9062,0x19ba3085,0x8290303c,0x0cd72065}},	//   _vesti_, _privacid, _ramach_, _لعلاج_,
   {{0x049ea07b,0x6a6cc086,0x325ab087,0x2e559088}},	//   _সোশ্যাল_, _abaminis, _çelik_, _katangia,
   {{0x2201c089,0x0b6ca08a,0xe2a6908b,0x00000000}},	//   _envia_, _pantalla_, _životné_, --,
   {{0xc3f9f08c,0xe248f08d,0x637fe08e,0xf94b708f}},	//   _mutum_, _ehhovisi_, _domača_, _総合ポイント_,
   {{0x72d9f090,0x225ae033,0x425ad091,0x142b7092}},	//   _lutem_, _taille_, _ddolen_, _podarilo_,
   {{0x83947093,0x117db094,0x2efe9020,0xa2005095}},	//   _mense_, _זיווג_, _이용하시기_, _bilis_,
   {{0x22a69096,0xea977097,0x8d30c098,0x891d004d}},	// [030] _životní_, _veličinu_, _vlastnic, _ご利用ガイド_,
   {{0x97a6b099,0xd8b2c031,0x248fd08b,0x0c764060}},	//   _protivni, _查看详细资料_, _zatvoriť_, _aforiti_,
   {{0x427f709a,0x1b59709b,0x2b61e003,0xa2a7f09c}},	//   _cuando_, _tentunya_, _regluger, _akuba_,
   {{0xf8a4109d,0xef1f204d,0x15d5909e,0xa2905074}},	//   _प्रश्नोत, _お気に入りに登録, _batangiy, _tilas_,
   {{0x32cad09f,0x82018060,0x232120a0,0xf25a90a1}},	//   _reeds_, _ririn_, _ysbyty_, _atali_,
   {{0x617510a2,0x5e6770a3,0x2bd1e0a4,0x15e8c0a5}},	//   _pročitaj_, _autorizē, _विषयक_, _rahatsız_,
   {{0xd39490a6,0xb3eb90a7,0x82ca703d,0x529170a8}},	//   _edasi_, _mestu_, _hunde_, _praksis_,
   {{0xe22490a9,0x9b5530aa,0xf2d990ab,0xb296c0ac}},	//   _svaku_, _firmalar, _museu_, _strateji_,
   {{0xe3f8d0ad,0x729020a4,0x07b9e03b,0x9ce9e04d}},	//   _budur_, _pakai_, _komuniki, _インタビュ_,
   {{0x82d800ae,0x9ae1d0af,0xd698102c,0x232630b0}},	//   _remonts_, _modelars, _контроля_, _bynciau_,
   {{0x307af0b1,0x37253004,0x340c60b2,0xef4af0b3}},	//   _besplatn, _אנטשולדי, _ngoặt_, _besplata,
   {{0x3e5d40b4,0xb2d9a0b5,0x588880b6,0xcf5a70b7}},	//   _treballa, _srpen_, _тексту_, _абсолвир,
   {{0x47876049,0xd29030b8,0xa28cc065,0x75a9301b}},	//   _सर्विस_, _wajah_, _الثمن_, _diusahak,
   {{0x262d102b,0xc2d8f0b9,0xdd2b30ba,0xf38700bb}},	//   _лінгвіст, _erger_, _acontece_, _tubrog_,
   {{0xb8b740bc,0x72905056,0x42c5c0bd,0x93870076}},	//   _kostumer_, _bilar_, _deklare_, _dobrym_,
   {{0xdc1650a2,0xf29150be,0x920250bc,0x57ec202c}},	//   _sigurnos, _theatr_, _altima_, _устанавл,
   {{0xd25ad0bf,0xa3cef02c,0x5db4b084,0xcd910037}},	// [040] _atele_, _voivat_, _meriwaya, _ملاحظه_,
   {{0x23ebe0c0,0xb943f0c1,0x526e001c,0xe05af070}},	//   _sette_, _počasie_, _tipove_, _آرکائیو_,
   {{0xaf2120c2,0x1108d0c3,0x4c16b076,0xa27eb0a2}},	//   _esperien, _абеба_, _ofertę_, _jednim_,
   {{0xa9e700c4,0xdb0c7089,0x8ae1f011,0x73f96058}},	//   _ospraved, _possible, _kostnade, _liguri_,
   {{0xb291e0c5,0x4c6aa0c6,0x22419006,0x22b61018}},	//   _antaa_, _गुल्मी_, _मनाली_, _בסטנדרט_,
   {{0x620070bd,0x43ce7007,0xa50160c7,0xf1d280c8}},	//   _minis_, _abanirẹ_, _materjal_, _neznámý_,
   {{0x7b5db0c9,0x5291500c,0xe2d990ca,0xe17bf0cb}},	//   _navijačk, _sigara_, _muset_, _پھانسی_,
   {{0x571200cc,0x6e46d091,0x5d2e4031,0xf7e730cd}},	//   _החרדית_, _stratega, _承担一切因您的行, _रिचर्ड_,
   {{0x23948029,0xf2d80048,0x839600ce,0x0c0730cf}},	//   _langsung_, _phien_, _besser_, _partiyas,
   {{0x6c569072,0x23ea009f,0xd6882082,0x921390d0}},	//   _lettere_, _buite_, _контролю_, _mosha_,
   {{0xb239f07f,0x5201a060,0x127ef0d1,0xc89700d2}},	//   _termeni_, _pipin_, _seinem_, _verkeerd,
   {{0x129030d3,0x425b70d4,0x39ca30d5,0xa17c30d6}},	//   _cumann_, _ingliz_, _जबर्दस्त_, _रस्सा_,
   {{0x03eb903e,0x386b30d7,0x220200d8,0x327ed0d9}},	//   _bestu_, _aconsegu, _musisi_, _ocene_,
   {{0xf248d089,0x90279004,0xb29070da,0xc2d98029}},	//   _premi_, _טעקעס_, _dinas_, _surel_,
   {{0x86e710db,0x995e10dc,0x84862017,0x7842802c}},	//   _circunci, _transmet, _stručnja, _teollisu,
   {{0x0ab0c0dd,0x7486c0de,0x4c7630df,0x129110e0}},	//   _संस्कृति_, _निशानी_, _दुल्हन_, _nicaea_,
   {{0xc7f41055,0x69aaa0e1,0xb7b1301c,0x82d570e2}},	// [050] _islaamig, _दिग्विजय_, _izostavi, _seromba_,
   {{0xb387f0e3,0xda5f2060,0x7b5520e4,0xf7cad0e5}},	//   _nzuri_, _àròko_, _अप्लिकेश, _vanskeli,
   {{0x5d47d06a,0x5d85d020,0x9e9e30e6,0xbb661008}},	//   _دراصل_, _카테고리의_, _erstellt_, _הסטטוס_,
   {{0xe341707e,0x6b051049,0xdea3b056,0x205e0018}},	//   _diferan_, _अनुभाग_, _intresse_, _וורדפרס_,
   {{0xe6a220e7,0x53a3a0e8,0x32da70e9,0x03f99084}},	//   _институц, _hoppa_, _noregi_, _kusut_,
   {{0x6a7ae04d,0xfc8b80ea,0x00000000,0x00000000}},	//   _エグザイル_, _저작권정책_, --, --,
   {{0xe2a710eb,0x5e96c070,0xf9cda033,0xcc1970ec}},	//   _часова_, _برسوں_, _interdit, _निश्चिन्,
   {{0x23eae0ed,0x43f8f037,0x0200f078,0xe3f960ee}},	//   _contoh_, _gugur_, _adiitu_, _siguri_,
   {{0x389b2047,0x2c6050e8,0xefaf50ef,0x3b0a308f}},	//   _مراسيل_, _platser_, _csillago, _下記のボタンを押,
   {{0xbb62a0ca,0x9d5f9030,0x829020a9,0x171da0f0}},	//   _भयानक_, _टर्निंग_, _takav_, _actuació,
   {{0x8212b0c2,0xa29040f1,0x7b6c6091,0x1c6220f2}},	//   _anche_, _ramai_, _pharetra_, _liputan_,
   {{0x025b70f3,0x13076057,0x12b3708d,0x4213204f}},	//   _avalia_, _bimbang_, _ubudala_, _fiches_,
   {{0xa2905037,0x220ec045,0x727ef0f4,0xa02d604d}},	//   _salah_, _хабар_, _ikindi_, _コミュニティ_,
   {{0x63f8a01d,0xf36f20f5,0x820020f6,0xb3a260f7}},	//   _kabul_, _hangtot_, _dakit_, _loopt_,
   {{0x02003055,0x881b706c,0x00000000,0x00000000}},	//   _kamida_, _ajialàrà_, --, --,
   {{0x8290200c,0x740f60f8,0xec6a8076,0x522400f9}},	//   _fakat_, _horretan_, _systemy_, _klike_,
   {{0x43f450fa,0x93eaf0fb,0xa8db9031,0xe2001024}},	// [060] _akutte_, _baitku_, _胶南市城建局_, _sahil_,
   {{0xb2d02008,0xcae1507b,0x6fb2b018,0x79c89070}},	//   _המגזין_, _হেফাজত_, _ויטמינים_, _automata_,
   {{0x12d800bb,0x00000000,0x00000000,0x00000000}},	//   _thiel_, --, --, --,
   {{0x598ae0a2,0x234fc0fc,0xc47ef07b,0x4af36056}},	//   _sviđa_, _estekak_, _এইচএসসি_, _konstate,
   {{0xbe1590fd,0xfaa9f0fe,0x00000000,0x00000000}},	//   _активног, _মুন্সীগঞ, --, --,
   {{0xf5a5e0ff,0x46948069,0x42084047,0x6dbbe0a2}},	//   _niektorý, _cawmseej_, _جوالات_, _podršku_,
   {{0xab9e003c,0xd4ecb03d,0xcbf540b4,0x4291d0a0}},	//   _गुरुवार_, _ファッション_, _espectac, _enwau_,
   {{0x92cf00f9,0x00000000,0x00000000,0x00000000}},	//   _volonte_, --, --, --,
   {{0xe3ebe056,0x5883c033,0x346ed100,0x7378d101}},	//   _detta_, _您现在的位置_, _храме_, _kimanin_,
   {{0x8291e0bd,0x427f0037,0xca8150ad,0x33788102}},	//   _antan_, _nyanyi_, _assosias, _gunakan_,
   {{0x74862103,0x62909104,0x02020105,0x22494106}},	//   _परमाणु_, _pakati_, _musiqi_, _vremea_,
   {{0x4eafb03d,0x5202503f,0xfe523067,0x183cb107}},	//   _知的財産本部_, _notika_, _dikataka, _прочитав_,
   {{0xf2d51108,0xd38c2071,0xe20070e9,0x6200a035}},	//   _sellest_, _лутер_, _vinir_, _bibit_,
   {{0x0c766109,0xf379210a,0x89cff10b,0xe3f980a4}},	//   _første_, _jabatan_, _stretnut, _buruk_,
   {{0xf201410c,0xb157010d,0x524f80e7,0x92d830c4}},	//   _breith_, _उपलब्धता_, _оставите_, _odmenu_,
   {{0x26ce310e,0xa25950c2,0x92ea710f,0xac770076}},	//   _detaljni, _particol, _petikan_, _damskie_,
   {{0x22360110,0x9bccb021,0xd5ab00cb,0xefd05061}},	// [070] _ujiji_, _studijų_, _گھنٹوں_, _maždaug_,
   {{0xd2caf0a6,0x03f880aa,0x7f5f30b9,0x00000000}},	//   _kuidas_, _hukuka_, _hospitaa, --,
   {{0xb3f98037,0x421c5084,0x4347d0c4,0x5f28e084}},	//   _buruh_, _tauhid_, _balenia_, _cintaila,
   {{0x42d9f081,0x89787111,0x1e5d8112,0xfed9603c}},	//   _etter_, _velikost, _traballa, _kulinarn,
   {{0xd7c2d08a,0xb2cac0ce,0xd290b113,0x2291e0bd}},	//   _বাইরে_, _melden_, _licas_, _mitan_,
   {{0x5d7f808d,0x42b600d4,0xf64060fe,0xe9cf2068}},	//   _ngamunye_, _muscat_, _টিপস্_, _momentee,
   {{0xc2a6c114,0xaf91f115,0x337950aa,0x0291e116}},	//   _member_, _condenar_, _antalya_, _xitaa_,
   {{0xa3ea0117,0x89c9f07f,0x03f98037,0x537d40f9}},	//   _muita_, _germania_, _guruh_, _etranje_,
   {{0x960bc118,0x02902119,0xa1c3c106,0x59a34047}},	//   _вчера_, _arkay_, _полония_, _limistéa,
   {{0x53fa703b,0xf3874038,0x72904046,0x2200411a}},	//   _forumi_, _sheria_, _camau_, _mamit_,
   {{0xa584f020,0xf2ca003a,0x6481611b,0xdf7b4065}},	//   _브라우저입니다_, _guida_, _दरवाजा_, _مفاتيح_,
   {{0xf2cae11c,0x334ed11d,0x62018110,0x6d3ef04d}},	//   _tindak_, _posebej_, _miria_, _初めての方は_,
   {{0xcc618045,0x0851811e,0x637f8113,0xaa9770b3}},	//   _sverige_, _sveriges_, _hahaaaa_, _veličina_,
   {{0x63ebe03e,0x9d56011f,0x23003038,0x00000000}},	//   _setti_, _लैंगिक_, _kijamii_, --,
   {{0x299910b7,0x048910b7,0x568130d5,0xdb775120}},	//   _интерн_, _интерв_, _जिहाद_, _explicac,
   {{0xa2d98121,0xa3ea605e,0xdd2600c3,0xcd7f50a4}},	//   _arren_, _multo_, _europene_, _विश्रांत,
   {{0x22902122,0x622670b6,0x3eb800cd,0x0394010c}},	// [080] _zakaj_, _verkar_, _असाधारण_, _coise_,
   {{0x92004123,0x3e70d06b,0x53eaf003,0x23ea7124}},	//   _damit_, _गिद्ध_, _vantar_, _runta_,
   {{0x8e33507b,0x48c7b125,0x5f5db106,0xd3eb8126}},	//   _উচ্চশিক্, _मणिपुर_, _raspunde_, _kerti_,
   {{0x222490a2,0x027ec0bd,0x9e83c0d3,0xd200905d}},	//   _svaki_, _anonse_, _عائشة_, _wakiri_,
   {{0x4290a08c,0x83ea7127,0x3e0f2128,0x8b1fc055}},	//   _dibar_, _xunta_, _comentea, _ramadaan_,
   {{0x0d5fd129,0x59c1712a,0x92b400ce,0xb2240081}},	//   _विक्रमाद, _filefact, _klick_, _klikk_,
   {{0xa248905d,0xc200b08c,0x019760c5,0x8344a0cc}},	//   _maama_, _hadisi_, _телефоны_, _מאַטעריא,
   {{0x4386611e,0x42c850cb,0xfa43912b,0x8f80212c}},	//   _gjort_, _mindenki_, _konkrétn, _prochain,
   {{0x77e7912d,0x4f4a404f,0x130ff12e,0x63b06044}},	//   _स्वर्ण_, _personna, _bolesť_, _elevado_,
   {{0x0a35012f,0xbba31086,0x4e1c70a9,0x00000000}},	//   _straitéi, _imihango_, _prekršaj, --,
   {{0x71862130,0x526c5131,0x2096d132,0x6f6f303f}},	//   _економск, _selon_, _چالاکی_, _komandas_,
   {{0xf6de503b,0x91d8c133,0xf7e3d01a,0x00000000}},	//   _futbolli, _ainglibh_, _позиции_, --,
   {{0x1f9c604d,0x1631a134,0xe3870090,0x34622135}},	//   _このブログをリン, _economai, _librin_, _stredisk,
   {{0x225a908d,0x8b61c025,0xf75d9008,0x02b400ce}},	//   _ngale_, _समझने_, _גבינת_, _blick_,
   {{0x7200b136,0xda00a065,0x556ff137,0x19040138}},	//   _raditi_, _النغمات_, _posvetio_, _comataid,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x62249139,0x3b25b13a,0x4f65b099,0x05bc513b}},	// [090] _kwake_, _priprema_, _pripreme_, _国家外汇管理局_,
   {{0x1200c03b,0x23207074,0xdc77303c,0x00000000}},	//   _midis_, _sanyi_, _konsole_, --,
   {{0x551140db,0xbc53b13c,0x93ea613d,0x6e959008}},	//   _cobrando_, _реализов, _grote_, _עוררו_,
   {{0x427f413e,0x81c3c0c5,0xd2cae0f5,0xb0429076}},	//   _svensk_, _помощи_, _xvideo_, _pomiędzy_,
   {{0x02b4e13f,0x1ce050c3,0x8c339018,0xf7c1b0fe}},	//   _vincom_, _унижений_, _גאליס_, _অপহরণ_,
   {{0xa37d40ff,0x93800092,0xe2903140,0xb2905141}},	//   _zdravie_, _vopred_, _sajam_, _walau_,
   {{0xf239f142,0xe2904143,0xc200505e,0x0200c038}},	//   _termini_, _samal_, _galit_, _halisi_,
   {{0x5ec3a093,0x9c02c034,0x69c40054,0x1559c021}},	//   _christus_, _пълен_, _moderaat, _знакам_,
   {{0x48d480ca,0x800ee144,0x2ff2407b,0xb2a77046}},	//   _चर्चित_, _potvrden, _থাকছে_, _arabeg_,
   {{0x5018c140,0x295410cc,0x52c20074,0x935f304f}},	//   _preporuč, _גרופּע_, _italiya_, _origine_,
   {{0x22360145,0xc27a804d,0xfc66a146,0xffd31147}},	//   _dvije_, _氏名又は名称_, _hurtigt_, _relihiyo,
   {{0xc413c034,0x425ad0d7,0x82cae148,0x526c4149}},	//   _човека_, _taller_, _leiden_, _nemoc_,
   {{0xa25a914a,0x0290414b,0x62027016,0xbc1a1002}},	//   _suala_, _tamam_, _arriti_, _energias,
   {{0x2060508f,0x9a27f14c,0x00000000,0x00000000}},	//   _このカテゴリから_, _बाईबिल_, --, --,
   {{0x7e3ff088,0x6a65c13b,0x4ad8e072,0xb2fd00bc}},	//   _pananamp, _有难题就提问_, _umiddelb, _bhagat_,
   {{0xf3940117,0x8c5d20f6,0x6e03f14d,0x00000000}},	//   _olisi_, _bertako_, _формату_, --,
   {{0xe27e014e,0x22907100,0x6af7b0d4,0xe8caa061}},	// [0a0] _aming_, _manau_, _konsumat, _статусе_,
   {{0x72330011,0x728e30a9,0x9638714f,0xeaf7b128}},	//   _exempel_, _svakako_, _mwenyeki, _consumat,
   {{0x9290b150,0xb201e151,0x92005152,0xd6bad153}},	//   _indawo_, _sitio_, _kalim_, _javascri,
   {{0xc39f311c,0xe2fc7154,0x5b89006e,0x12fc00e9}},	//   _اصناف_, _lengo_, _aisinipo_, _leigu_,
   {{0xf0cce07b,0x0395709f,0x88d52008,0x38751155}},	//   _হাদীস_, _laaste_, _לאנדרואי, _ahikọrọ_,
   {{0x1940d156,0x827f4134,0x6318d157,0x85759158}},	//   _počinje_, _brenin_, _pabcuam_, _agologaà,
   {{0xa248603b,0xf992e011,0xd0a9e03a,0x42a6914f}},	//   _akoma_, _verklige, _пропуска, _ajabu_,
   {{0xce627114,0xb3dc0159,0x135f115a,0xba709147}},	//   _practice_, _afiwe_, _jongste_, _magagawa_,
   {{0xda7b000b,0xa907b15b,0x7942512c,0x00000000}},	//   _औरंगाबाद_, _redakteu, _quartier_, --,
   {{0xd68c615c,0xf39400d3,0x9a5f8019,0xf230115d}},	//   _सलवार_, _toisc_, _pregunta_, _khampha_,
   {{0xa15520a2,0xe683b143,0x32249074,0xa6b40024}},	//   _mogućnos, _सोनार_, _alaka_, _abdullay,
   {{0xfecc515e,0x225a615b,0x2b7480ea,0xb2fc515f}},	//   _papildus_, _bulle_, _개인정보보호_, _papildu_,
   {{0xd291f160,0x72da505a,0x111c10c5,0x827f700e}},	//   _anuas_, _gutera_, _основани, _mpanga_,
   {{0x0a83507b,0x4c23103d,0x9d2310c0,0x00000000}},	//   _স্বেচ্ছা, _mulighed_, _mulighet_, --,
   {{0x123c6068,0x53e73161,0x42e30162,0xc2fcb163}},	//   _감사합니다_, _måtte_, _संदीप_, _odraziti_,
   {{0x12907105,0xefe9e0a4,0xd2fc2052,0x58c6e164}},	//   _manat_, _बाजारात_, _comitis_, _innehold,
   {{0x425a00dc,0x3f47707b,0xd413206a,0x22639165}},	// [0b0] _prill_, _একান্ত_, _والدہ_, _definiti_,
   {{0x6c51912a,0x368c7166,0x6f38d167,0x52dc214d}},	//   _taktika_, _तलवार_, _देखिन्छ_, _партнера_,
   {{0x1c7af168,0x72e8711d,0xfbd8c0c5,0x0b0af169}},	//   _vlasnik_, _higiena_, _сначала_, _vlasnika_,
   {{0xa26c1164,0xdc80c062,0x5aea8034,0xb290c160}},	//   _behov_, _девет_, _trattame, _ualach_,
   {{0x125bf091,0x739490c3,0xf838112d,0xeb54616a}},	//   _teulu_, _clasa_, _कुरुक्षे, _लालीगुरा,
   {{0x9067416b,0x31588113,0x7447e16c,0x00000000}},	//   _झांसी_, _javouhey_, _анексязэ_, --,
   {{0x42dab008,0x62da6076,0x9d6a108b,0x49cbf11d}},	//   _october_, _strefa_, _atomique_, _namestit,
   {{0x4c7120de,0x0a81616d,0x53209104,0xf318e147}},	//   _बाल्टी_, _impormas, _abaye_, _salitang_,
   {{0x966d316e,0x820020ca,0xca0f716f,0x8200d0c3}},	//   _الجسم_, _komise_, _zapadnoe, _cheie_,
   {{0xee73603c,0x337e4170,0xed60b13b,0x13dcb00b}},	//   _पार्क_, _corgoň_, _香港紫金碳雕加盟, _jadwal_,
   {{0x8d8e4171,0x027e0150,0x425a607c,0x6c5c607b}},	//   _encontra, _emine_, _sulle_, _সমগ্র_,
   {{0x52f3a172,0xc79e2173,0x37dd3122,0x43eaf037}},	//   _ukristu_, _трэба_, _obravnav, _banter_,
   {{0x02d8e0b4,0x62fc7174,0xd0dda004,0x6dda9140}},	//   _manera_, _tengo_, _חשובע_, _naglašav,
   {{0x5e68c175,0x2c748176,0xc3552177,0x8394e08f}},	//   _menciona, _रोल्पा_, _calendr_, _uanset_,
   {{0xe7d0c15d,0x62b67178,0x4f445179,0x9200a00c}},	//   _congdong, _tercer_, _энциклоп, _tabii_,
   {{0xca830056,0xb2e3003b,0xfed3003b,0x7489017a}},	//   _familjen_, _familje_, _familjes_, _присъеди,
   {{0x8a176054,0xa2902099,0xee6ac081,0x7a920004}},	// [0c0] _हार्डकोर_, _iskaz_, _фонду_, _אַדרעס_,
   {{0x2f198175,0x62904100,0xa3bc3065,0x2c28403f}},	//   _располаг, _namai_, _ولكنه_, _plastmas,
   {{0x327f7175,0xc2d9f0ca,0xb248917b,0x9301215d}},	//   _quando_, _autem_, _shami_, _qmobile_,
   {{0xd201e124,0x54866026,0x8e68317c,0x7290e102}},	//   _intii_, _दोबारा_, _अनुभूति_, _sifat_,
   {{0x95f9501a,0x77573173,0x22ef4134,0x00000000}},	//   _напряжен, _негры_, _diffyg_, --,
   {{0x03f4017d,0x6201f17e,0x9316f007,0x937a0087}},	//   _gister_, _vizita_, _adabori_, _buradan_,
   {{0x725a417f,0xba08e0c5,0xb2468035,0x7c75f180}},	//   _jumla_, _salasana_, _चिखली_, _स्प्रे_,
   {{0x36313181,0x42905037,0xaad0211c,0xd6ab3182}},	//   _お問い合わせ_, _malah_, _برزیل_, _езеро_,
   {{0x285f0183,0x52240184,0x949c90a7,0x023b90a2}},	//   _empresas_, _aliko_, _naročilu_, _ostvaril,
   {{0x8ad710d4,0x5da78185,0x7cf710d4,0x52eb7153}},	//   _letterat, _हॉटशॉट्स_, _letterar, _medical_,
   {{0x7290b0bb,0x90b15044,0xa473213b,0x56915044}},	//   _ascas_, _gráfico_, _网站或个人未经本, _gráfica_,
   {{0x3c59f185,0x4cd2b186,0x0290e187,0x9d9b0042}},	//   _listrik_, _पोटेन्शि, _janari_, _taylorma,
   {{0x839540ff,0xb290e0e6,0xe3f45188,0xb7b65011}},	//   _presne_, _danach_, _nyttig_, _utrustni,
   {{0xe6975072,0x02018035,0xd3a23189,0xf3f9803f}},	//   _offentli, _kirim_, _tampak_, _kurus_,
   {{0xcb765089,0xd379018a,0x4dbbf18b,0x4da2018c}},	//   _declarac, _gagasan_, _argentín, _prensipa,
   {{0x0300500e,0xe30e4174,0x43ea715b,0x62161018}},	//   _kulaani_, _estamos_, _punte_, _אספנות_,
   {{0x92d800f5,0xa290c037,0x801f50f8,0xb04c318d}},	// [0d0] _chieu_, _wadah_, _handiago, _politisk_,
   {{0x524850e1,0x42025120,0x5e923050,0x725a018e}},	//   _filmy_, _antiga_, _потреба_, _quill_,
   {{0x5f453105,0xef2bc07b,0x930f518f,0x09ec4190}},	//   _formalaş, _কল্পনা_, _fasahar_, _kabineta_,
   {{0x8108a065,0x224890dc,0x00000000,0x00000000}},	//   _مذكرات_, _dhamo_, --, --,
   {{0x02d80191,0x42da610b,0x1810812f,0x99e2c065}},	//   _okien_, _streda_, _ardchaig, _شاهين_,
   {{0x9292012b,0xd3001074,0x5291801c,0x625a606e}},	//   _strany_, _makamai_, _biram_, _agolo_,
   {{0xd2d5202e,0x5b552011,0x82fc7192,0xc2910088}},	//   _kontakty_, _kontakta_, _penge_, _maaari_,
   {{0x825a6074,0x6db3a173,0x2061c02a,0x29d510b7}},	//   _kulla_, _negalite_, _стати_, _аджитатэ_,
   {{0x12919193,0x9e4ac194,0x36832195,0x1c35307b}},	//   _nisam_, _статей_, _послуги_, _সহায়তা_,
   {{0x36f78196,0x17ada0d4,0xf486c017,0x95258197}},	//   _परिवहन_, _direttiv, _смена_, _जोड़्न_,
   {{0xdf1c90b7,0x18c5312f,0x92e90088,0x00000000}},	//   _формулат, _spreagad, _pagitan_, --,
   {{0xa2d80048,0xd9801098,0xd31be190,0x00000000}},	//   _thieu_, _भूकम्प_, _vasarā_, --,
   {{0x32b2802c,0x5387f0e3,0xd700f0d3,0xe39520aa}},	//   _voidaan_, _uhuru_, _struchtú, _neyse_,
   {{0x1b07d045,0x62631065,0xd3f47198,0xf3a35199}},	//   _тиждень_, _تهنئة_, _unutar_, _riepas_,
   {{0xe7dec113,0x620110bd,0xb2da602e,0x1c6b400f}},	//   _epiphani, _vizit_, _hotely_, _कुर्मी_,
   {{0x93e5d19a,0x1bd27143,0x53ea905a,0x4dd2d01a}},	//   _către_, _बांये_, _itatu_, _стиле_,
   {{0xf92d7020,0xa18800a3,0x6e38e095,0xd0f9204d}},	// [0e0] _자바스크립트를_, _festivāl, _karapata, _クショップ_,
   {{0x13877065,0x234c7008,0xe27eb0a2,0x7c85e069}},	//   _tharla_, _several_, _jednoj_, _nujtxeeg_,
   {{0xf6527030,0xc25a903a,0xae30c19b,0xf378403c}},	//   _बाँधे_, _quale_, _langgana, _badania_,
   {{0x22fcd19c,0x02d88158,0x42e8e19d,0x8290c05d}},	//   _seega_, _kekere_, _pilihan_, _balaga_,
   {{0x6290719e,0xe3e5519f,0x1c6731a0,0xd2f76158}},	//   _kanak_, _mətni_, _kultuur_, _akiidah_,
   {{0xd290214e,0xf3f8f133,0xea8cd057,0x9c673013}},	//   _lakas_, _dhiubh_, _sayyidat, _cultuur_,
   {{0xc2de5105,0x7324f160,0x50062070,0x73eaf1a1}},	//   _dilində_, _nascadh_, _ٹریفک_, _hantar_,
   {{0x899d519b,0xeaf350a2,0xc8b47004,0x00000000}},	//   _ويرايش_, _ugostite, _באָריס_, --,
   {{0xa33a51a2,0xe3f8d0bb,0xd3ea917b,0xb290a18f}},	//   _وردپرس_, _rieux_, _atatu_, _dabam_,
   {{0x2a75c0d5,0x2248d1a3,0x085981a4,0xb9b7702a}},	//   _उन्नाव_, _czemu_, _upozorav, _класифік,
   {{0x92d801a5,0x3ceed01a,0xf2da60fc,0x7771f0ca}},	//   _thiet_, _среди_, _berean_, _ब्रह्माण,
   {{0x72ca70de,0x5b7bd060,0x63f890d8,0x00000000}},	//   _kunda_, _adesanya_, _sekutu_, --,
   {{0xb2b6a0b9,0x2c2431a6,0x69ead1a7,0x5d1b61a8}},	//   _verdere_, _फ्रेवुअर, _vergange, _porodice_,
   {{0x92ca71a9,0x65b85031,0x397e21aa,0x05d0b19b}},	//   _munda_, _构成犯罪的_, _групе_, _پیشخوان_,
   {{0xc73f00c5,0x727eb1ab,0xb26c20a2,0xb0e41094}},	//   _оставить_, _niente_, _nekoj_, _באריכות_,
   {{0xc2caf1ac,0xf6e7603d,0xa212b033,0x96213134}},	//   _bandar_, _人が役に立つと評, _fiche_, _ewropeai,
   {{0xf3a381ad,0xb39491ae,0x00000000,0x00000000}},	// [0f0] _corpo_, _clase_, --, --,
   {{0x0387718d,0x726c205f,0x4ca431af,0x737841b0}},	//   _starte_, _gekom_, _интервен, _zadania_,
   {{0xd20110f4,0xc2902084,0x89b8e06f,0x82d880b9}},	//   _kabiri_, _zakat_, _татуиров, _sekere_,
   {{0xca0f81b1,0xd513c07b,0x2c12403b,0x0b22403b}},	//   _hahahaaa_, _নোয়াখাল, _kompani_, _kompania_,
   {{0x43806077,0x7c27b0cc,0xa24a01b2,0x2b077003}},	//   _suurin_, _נאַציאָנ, _kasmas_, _samskipt,
   {{0x33ead1b3,0x07ed61b4,0x2b6fa03b,0x629031b5}},	//   _frete_, _kapanlag, _momentin_, _samada_,
   {{0x2927e060,0x127f71b6,0xb20011b7,0x2476b070}},	//   _ọpọlọpọ_, _slanje_, _zahir_, _hirtelen_,
   {{0xff3021b8,0x00000000,0x00000000,0x00000000}},	//   _редакции_, --, --, --,
   {{0xce481171,0x3f9b11b9,0xa3eb71ba,0x73a35173}},	//   _capacida, _हस्तकला_, _reatha_, _liepos_,
   {{0xb18621bb,0xf341b15d,0xb2aad19b,0x9140c090}},	//   _пальма_, _pokezoo_, _پروتئین_, _pretendo,
   {{0xd1c371a4,0xa6abf035,0xfb354004,0x13487004}},	//   _postupak_, _सणासुदीच, _האלבערשט, _מערדער_,
   {{0x01e6b0cd,0xf34fa03b,0xb2b9e164,0x2eb58020}},	//   _टिहरी_, _komenti_, _endelig_, _gebracht_,
   {{0x3ff011bc,0xb3173043,0x022200ef,0x3f9ec1bd}},	//   _мерки_, _concile_, _استفتائا, _محظوظ_,
   {{0xb2d83033,0x489e401a,0x8290205e,0x00000000}},	//   _samedi_, _закладки_, _wakas_, --,
   {{0xd290c093,0x727ee1be,0x4642b04e,0x92919102}},	//   _nadat_, _tannin_, _местоиме, _kisah_,
   {{0x2c6ad0e1,0x1051301a,0xa2ca71bf,0x0a86803c}},	//   _किन्तु_, _истории_, _fundi_, _europejs,
   {{0x690a5055,0x12908154,0xe3ead18c,0x3a8cb0d1}},	// [100] _shabakad, _jakaya_, _arete_, _springen_,
   {{0xac754024,0xf3f8d0bd,0x302b9082,0xb2cad02a}},	//   _deputat_, _abouti_, _школах_, _brede_,
   {{0x825b71c0,0xe3dcd1b2,0x62cae1bf,0x480730fe}},	//   _italya_, _brower_, _mendon_, _সাইবার_,
   {{0xf2cad0b9,0xb6d240b0,0x1212d064,0xce7341c1}},	//   _vrede_, _morgannw, _zhohir_, _तटस्थ_,
   {{0xe3f471c2,0x827e6069,0xc5d99071,0x2400a065}},	//   _nostra_, _hmong_, _инверс_, _الهجرة_,
   {{0x13ead0f9,0x4e7141c3,0x125a919e,0x69ae5006}},	//   _trete_, _अगस्ट_, _kuala_, _handlowe,
   {{0xc29550ec,0x0291c039,0x22aad065,0x00000000}},	//   _probleem, _divat_, _مسألة_, --,
   {{0xc3ea60ca,0xa2ca91c4,0xe3ea90e6,0x62e971c5}},	//   _proto_, _stadt_, _statt_, _dirinya_,
   {{0x027ee076,0xa29021c6,0x569da054,0xa081d132}},	//   _opinia_, _zakar_, _direktii, _مضطرب_,
   {{0xf29f7037,0xbf282089,0x1638e0c5,0xf27e61c7}},	//   _sarjana_, _expressa, _perintei, _omong_,
   {{0x4f5f50b2,0x94b631c8,0x6e6d302b,0xfa151073}},	//   _uppppppp, _खिचडी_, _паміж_, _redakcja_,
   {{0x717721c9,0x65be2175,0x927e61ca,0xc26c5149}},	//   _место_, _друго_, _imong_, _celou_,
   {{0x63f431cb,0xf2fc910c,0x39c491cc,0x1e6f1150}},	//   _posté_, _beaga_, _pemerint, _ongcwele_,
   {{0xa3442027,0x0fac612f,0xa550703a,0xec90a0a6}},	//   _prodaju_, _مغامرات_, _società_, _क्षोभ_,
   {{0x78a3e04d,0xb7c61035,0x62c9416e,0x2386d078}},	//   _メロディアス_, _हळूहळू_, _míonna_, _akoran_,
   {{0x6290c136,0xa236d1cd,0x82ca7054,0x6129a1ce}},	//   _nadam_, _projet_, _tundi_, _hangsúly,
   {{0x3eb721cf,0x825a60b5,0x0291507f,0x7cd370fe}},	// [110] _consulte_, _stoly_, _legate_, _ঝুঁকি_,
   {{0x23f981d0,0x05df41d1,0x336e9073,0x929021d2}},	//   _marun_, _telenotí, _पक्षियों_, _yakar_,
   {{0xc26c40a2,0xfc18f013,0x8bdc91d3,0xde461004}},	//   _nemoj_, _verander, _सैंया_, _עיפריל_,
   {{0xff3ca0d6,0x6290202b,0xde71b029,0x11214163}},	//   _perusaha, _vakar_, _टुर्स_, _grožđa_,
   {{0xeff79004,0x12247104,0x5c6911d4,0xc2498179}},	//   _מעניו_, _sonke_, _cerrado_, _varma_,
   {{0xf8433020,0xb20200e2,0xa6261020,0x913ac1d5}},	//   _되었습니다_, _kusini_, _미디어다음_, _abịdịị_,
   {{0x929081d6,0xf20040a4,0x4bb12171,0xe2e861d7}},	//   _makana_, _kamis_, _conjunto_, _airfon_,
   {{0x701d10ae,0xf290c0ae,0x125b10f9,0x00000000}},	//   _nacionāl, _gadam_, _biblik_, --,
   {{0x6070807b,0xb2d98068,0x6ccc2070,0xd70d4175}},	//   _একুশে_, _jaren_, _سیدنا_, _experiên,
   {{0x13ea71a9,0x02902084,0x6dc2004a,0xd2ca70f8}},	//   _muntu_, _pakar_, _meningka, _mundu_,
   {{0x8386e051,0xdda24077,0xa2fd300a,0x8c6161d8}},	//   _shirin_, _kirosana, _pilastri_, _gestuur_,
   {{0x19bf004d,0x23e86175,0x98b8606c,0xd212c119}},	//   _に選ばれた回答_, _decoraçã, _agadagod, _indha_,
   {{0x929040f6,0x63eb9006,0xcecb8119,0x9d265099}},	//   _hamar_, _testy_, _komishan, _istočne_,
   {{0x3c6160b9,0x56341008,0xb2cae1d9,0x00000000}},	//   _bestuur_, _אנימציה_, _landes_, --,
   {{0x92d98074,0x91f9d0c3,0x625a6045,0xeae2f1aa}},	//   _haren_, _министра, _fullt_, _umetnost,
   {{0x02d8c175,0x2c2cf070,0x9bda6004,0x2062c067}},	//   _menores_, _bruttó_, _פֿענצטער_, _फारसे_,
   {{0xd7b611da,0x9956a072,0x0ccf8031,0x7c01e0cb}},	// [120] _trasferi, _millione, _如要投诉或提出意, _sokszor_,
   {{0x63f471db,0x52905147,0x42d471dc,0x1379f08d}},	//   _vostra_, _balat_, _gerddi_, _umlando_,
   {{0x1ab6a031,0x8541807b,0x17aa80bb,0xaf26c19e}},	//   _添加到搜藏_, _সাংস্কৃত, _kastosli, _penterna,
   {{0x411b60cb,0x82d8b034,0xc66790c5,0x2200c044}},	//   _سرپرستی_, _vedere_, _наверх_, _galiza_,
   {{0x8290503b,0x82d981dd,0x13eae03b,0x60b590a4}},	//   _falas_, _garen_, _tenton_, _गुरुजी_,
   {{0x51660094,0x51001008,0x0e4ca185,0x76d2d1de}},	//   _חילוקי_, _רמקולים_, _pelayana, _तारिख_,
   {{0x6c4b102d,0x6d874007,0x13949008,0x3ae5400d}},	//   _tentang_, _kerekere_, _flash_, _itsembab,
   {{0x52904101,0xa290518e,0xe2eb2082,0x3da47098}},	//   _damar_, _halas_, _abonner_, _nesouhla,
   {{0x01192017,0x52925099,0xad84d1df,0xb200917f}},	//   _технике_, _litara_, _genesise_, _majina_,
   {{0xa2254159,0xbf2c6017,0x00000000,0x00000000}},	//   _akekoo_, _bijeljin, --, --,
   {{0x82d98013,0xf23b71e0,0x82005173,0x82d59031}},	//   _waren_, _nollaig_, _dalis_, _凡本网注明_,
   {{0x37eaa0a4,0x2edc5120,0xf61f41e1,0x99d221e2}},	//   _व्यक्ती_, _racistes_, _exposici, _erregist,
   {{0x1b1831e3,0x774ed0c3,0x12010124,0x02d6f1e4}},	//   _linganis, _граве_, _nabiga_, _achlais_,
   {{0x5200c124,0x82d840aa,0x529040de,0x8d35c0cb}},	//   _kaliya_, _ahmet_, _samas_, _انٹیلی_,
   {{0x7e4de020,0x025a903a,0x1b9a2163,0xced6d1e5}},	//   _대학보고서_, _quali_, _ispisano_, _regierun,
   {{0xe2fe6089,0x8b7451e6,0x5200d0b9,0x15015147}},	//   _visites_, _регламен, _koning_, _materyal_,
   {{0x429050fb,0xd2cae0e6,0xc291e102,0xb93a2035}},	// [130] _balas_, _beiden_, _hitam_, _अमेरिकेच,
   {{0x739471e7,0x4affa1e8,0x735ca1af,0x622461be}},	//   _konsa_, _zabranje, _партнери_, _oloko_,
   {{0x73eae1e7,0x143ec01a,0xe2d8d0c2,0x00000000}},	//   _tenten_, _равно_, _genere_, --,
   {{0x36d710ab,0x75ea3003,0x729051ad,0xd200b0c0}},	//   _descobri, _heiminum_, _falar_, _fleire_,
   {{0x42904051,0x82005091,0x72908154,0xe27e9035}},	//   _samar_, _talis_, _makala_, _emang_,
   {{0x1c76416b,0x4a93d04e,0x4290f05e,0x1307710c}},	//   _बॉम्बे_, _фонетик_, _dagat_, _aghaigh_,
   {{0xa7c520cc,0x699880a9,0xbbcfd0a4,0xdc49d04d}},	//   _אנטיסעמי, _lakše_, _श्रीराम_, _みんなへの一言_,
   {{0x82908154,0x73f981b5,0x2ae320db,0x2200c12a}},	//   _nakala_, _darul_, _populare, _eloise_,
   {{0x925ac0e8,0x62a6c037,0x63eaf04f,0xbb40e136}},	//   _mellan_, _kembar_, _faites_, _trgovačk,
   {{0x22d9f1e9,0x8638c01a,0xe20270bc,0x19cd30f1}},	//   _gazeta_, _направле, _bisita_, _seumpama_,
   {{0x41351006,0x0455112a,0x742921c6,0x4201e057}},	//   _produkty_, _produkto_, _tempatan_, _intip_,
   {{0xac3201ea,0x5263c025,0xc200b122,0x00000000}},	//   _kombinir, _आरुषि_, _bodite_, --,
   {{0xb291e076,0xe8557126,0xf3b110b5,0x56053004}},	//   _witam_, _rendkívü, _personál, _אוישוויץ_,
   {{0x8ff97030,0x22cae0e6,0x22a771eb,0xa201e12f}},	//   _विलायती_, _senden_, _ансамбля_, _titim_,
   {{0x63a5a1bb,0x93eae0f9,0x1db940b5,0x82d9f1c4}},	//   _garantij, _kontni_, _interiér_, _gutes_,
   {{0x6c1241ec,0x33eae0d1,0xcf358003,0xc26c70b5}},	//   _kompeni_, _seiten_, _meistara, _jenom_,
   {{0xedbd11ed,0xeae640c2,0xe5ebf0b7,0x6394f1ad}},	// [140] _दुर्योधन, _strument, _докторат, _coisas_,
   {{0x281921b8,0x2db7d1ee,0xfff810a2,0xaa19d175}},	//   _компания_, _activida, _ovogodiš, _намалува,
   {{0x18b6b033,0x92fca1ef,0x67eee04d,0xbc3ba1f0}},	//   _partager_, _medidas_, _ブログトップ_, _उत्साहित_,
   {{0x222b41f1,0x7daa7105,0x52905056,0x00000000}},	//   _zoradiť_, _sistemlə, _talar_, --,
   {{0xc394d122,0x7f5751f2,0x5be5b100,0x9c5b5054}},	//   _prosim_, _जिनगी_, _kalendor, _albumid_,
   {{0xd882d07b,0x743c20fe,0x7771c1f3,0x00000000}},	//   _বাড়ছে_, _তামিম_, _व्याभिचा, --,
   {{0xc3e361f4,0xf290c101,0x0ea6b065,0xc2d81056}},	//   _सत्येन्द, _kadai_, _مانشستر_, _nyhet_,
   {{0x8e177031,0x536f21b2,0x03869072,0x030cf0ae}},	//   _中华人民共和国商, _mongkut_, _svare_, _nevarat_,
   {{0xa387f00d,0x0a90112d,0xa4769062,0x1290c154}},	//   _ukuri_, _मधुमेह_, _процеса_, _madai_,
   {{0x42018060,0x1681612d,0x329261f5,0x00000000}},	//   _iiris_, _ज्ञात_, _kirara_, --,
   {{0xbbe53061,0xd2d9f037,0x629031d4,0x43662025}},	//   _aksesuar, _muter_, _humano_, _मुहैया_,
   {{0x926c7011,0x833010ca,0x030e51f6,0x6a09202c}},	//   _genom_, _व्याख्या_, _trebala_, _говорить_,
   {{0x5d8f516d,0xf6645054,0x72bf3039,0xd2cad05d}},	//   _kailanga, _miljardi, _لمحات_, _gudda_,
   {{0x29e23173,0x737b8084,0x13959195,0x4200c099}},	//   _istorija_, _semalam_, _desse_, _volite_,
   {{0x729070a2,0x03eb9033,0x68a3201a,0x06c8a0ea}},	//   _danas_, _juste_, _гораздо_, _반송비용은_,
   {{0xec078187,0x02ade118,0xc30c2183,0xebe40056}},	//   _oneshot_, _всъщност_, _semanas_, _underbar,
   {{0x700d808e,0xff9a31f7,0x024981f8,0x32917105}},	// [150] _življenj, _भक्तिमय_, _varme_, _rabitə_,
   {{0xeae531f9,0x26af3021,0x00000000,0x00000000}},	//   _siguient, _ісуса_, --, --,
   {{0x538d1185,0xa28d1114,0x8290c119,0x62d84047}},	//   _properti_, _property_, _kalana_, _rannóg_,
   {{0x62ca91ec,0x1bd12021,0xae729049,0x7fa731fa}},	//   _agadi_, _klientų_, _युद्घ_, _aumentar_,
   {{0x729070aa,0xa85d91fb,0x443100fe,0x1290c1fc}},	//   _sanat_, _רשעים_, _টিকিট_, _dalana_,
   {{0xf20180f9,0x03738099,0xb7b6b07b,0x00000000}},	//   _diris_, _zadatke_, _বিকেলে_, --,
   {{0x6d5a612f,0x49a980b7,0xde17c1fd,0x00000000}},	//   _leathnú_, _арэтацим, _nimenoma, --,
   {{0xc37ca0a2,0x553ce1ac,0x82fcd1b2,0xc477a0c5}},	//   _pitanje_, _sekirany, _langid_, _проекта_,
   {{0xd06c8031,0x83ea0047,0x2ee3d0d5,0xf461d068}},	//   _第二十四条_, _frith_, _पृथ्वीरा, _medewerk,
   {{0x62b521fe,0x1fe7b01a,0xdc6970f9,0xd291919e}},	//   _prodeje_, _править_, _zantray_, _risau_,
   {{0x1b5511ff,0x1200c09c,0xf4ad60e6,0x925ae109}},	//   _kinderen_, _balina_, _vollstän, _spille_,
   {{0xec1930f8,0x00000000,0x00000000,0x00000000}},	//   _gainditu_, --, --, --,
   {{0xc29070ee,0xa2b4e19e,0x52918178,0x675380da}},	//   _janar_, _kancil_, _mirar_, _पारिभाषि,
   {{0x114631f4,0x8378e067,0x121bb0ca,0x423c9043}},	//   _नालंदा_, _silakan_, _austráli, _vammeej_,
   {{0x925a2200,0xe3167185,0xdd8da041,0xee516173}},	//   _dakle_, _pribadi_, _televize_, _patarima,
   {{0xbc651201,0x01f97020,0xae9510d7,0xe5751202}},	//   _contact_, _스크랩하기_, _contacte_, _contacto_,
   {{0x2290805a,0xe3ea203b,0x23f911e3,0x03b85086}},	// [160] _bakaba_, _fakte_, _sicula_, _yabwiye_,
   {{0xc4fdb203,0xfbc8c1a6,0xd2a65204,0xd25a9205}},	//   _позволяв, _कालीकोट_, _seljaci_, _ugali_,
   {{0x8d19801a,0x32fe616e,0x12d9a0a0,0xca9730ce}},	//   _различны, _airgid_, _capel_, _zumindes,
   {{0x23875116,0x87899100,0x629071d7,0x8b1fc1b7}},	//   _weerar_, _землях_, _sanas_, _bilangan_,
   {{0x85a7907b,0xf387f086,0xc7df112d,0x3290702d}},	//   _বুঝলাম_, _nkuru_, _छुटकारा_, _panas_,
   {{0x837c7013,0x120180f9,0x81775104,0x2e3bc02a}},	//   _locatie_, _viris_, _kulandel, _основног,
   {{0xd320917f,0xe2018206,0xd2240163,0xd7cae0c5}},	//   _mbaya_, _muziki_, _sliku_, _opiskeli,
   {{0xa1c640c4,0x2a143173,0xb200a16d,0xa29120d8}},	//   _otvorená_, _negalima_, _labis_, _hayam_,
   {{0x83ea0002,0xf2908119,0x1f865065,0x00000000}},	//   _eriti_, _arkaan_, _لاجهزة_, --,
   {{0x0b5ed207,0x22ca919f,0x42907051,0xf2d990e6}},	//   _храна_, _orada_, _ranar_, _essen_,
   {{0xa3eb7208,0xa2ca9163,0xea5390c9,0x52907051}},	//   _beatha_, _grada_, _kolegama_, _sanar_,
   {{0x5752d008,0x4fa9303d,0xb2907051,0x4344b09c}},	//   _קייטרינג_, _インテリア_, _yanar_, _mirembe_,
   {{0x42ca9209,0x83ea920a,0x00000000,0x00000000}},	//   _arada_, _arata_, --, --,
   {{0x22a6320b,0x4cf50144,0xfdf5002e,0x438cd117}},	//   _timbul_, _ostatnýc, _ostatníc, _нужен_,
   {{0xf636a041,0x82a8807b,0x3200c0fa,0x9e7d613b}},	//   _त्यहाँ_, _উবুন্টু_, _talina_, _arrivée_,
   {{0x62d9f1ee,0x9f1e315b,0xea5be05e,0x00000000}},	//   _usted_, _handelin, _pangarap_, --,
   {{0x9290b154,0x5ba670cd,0x522670e9,0xffa0a0b7}},	// [170] _badala_, _व्यतीत_, _merkir_, _аменажар,
   {{0xc68e1008,0x92e990aa,0x0f69119e,0x4290a074}},	//   _שוקולד_, _haziran_, _sepatutn, _gabas_,
   {{0xc4e3e07b,0x4310e20c,0xb7b5f1c4,0x22ba720d}},	//   _পোশাক_, _detaily_, _startsei, _kendini_,
   {{0xf29190ae,0x73ead144,0x65278136,0xd2da5128}},	//   _visas_, _preto_, _napravio_, _cateva_,
   {{0x996e71a7,0x8f24002d,0x8d6b4090,0x00000000}},	//   _donnerst, _sederhan, _martesë_, --,
   {{0xa2d6c061,0xc344912c,0x8ff691d5,0x33ea01ea}},	//   _stilius_, _vitesse_, _divaịsị_, _priti_,
   {{0x8c683036,0x42eab115,0xe2d9e148,0x1290a0ae}},	//   _доставка_, _prensas_, _laten_, _dabas_,
   {{0xa168b0c3,0x0395420e,0x919b4056,0x581b60ea}},	//   _програму, _nyeste_, _speciell, _포카고수가될려면_,
   {{0x8cf2c047,0xe2e820e8,0xb7ff9008,0xb706d0ea}},	//   _فاطمة_, _sociala_, _ומידע_, _오스트리아_,
   {{0x22d870c6,0x1394e179,0x00000000,0x00000000}},	//   _oknem_, _toista_, --, --,
   {{0x5201820f,0xc386c09f,0x4290a119,0xfdf8b020}},	//   _mirip_, _storie_, _habar_, _빌라연립다세대_,
   {{0x09a41017,0xb2fce1a1,0xfac81210,0xc37a714e}},	//   _април_, _kongsi_, _dozvolje, _katawan_,
   {{0x92cae090,0x43ea01be,0x92fc7154,0xec7e9088}},	//   _vendin_, _esite_, _mengi_, _apostol_,
   {{0xf2bb91b2,0x92247052,0x62d9e211,0x72b470ca}},	//   _sagesse_, _konke_, _daten_, _konce_,
   {{0x18597171,0xd34a90a2,0x3e2f01e1,0xb2da606c}},	//   _retratos_, _između_, _células_, _aarewa_,
   {{0x42cad080,0xf386d03a,0xa47ac045,0xd1704132}},	//   _vtedy_, _avere_, _промисло, _مشتقات_,
   {{0xf4d770cc,0x3290a212,0xd290c0fa,0xcc73e0ad}},	// [180] _אנציקלאפ, _gabar_, _balala_, _pensiya_,
   {{0x827a413d,0x7fc231bd,0x1e57d070,0x51f88028}},	//   _persoonl, _ناموس_, _کرپشن_, _huzaifah_,
   {{0x5c6e3031,0xe2919011,0x98bed09f,0xb03ff178}},	//   _我来说两句_, _visar_, _ingestuu, _seguimen,
   {{0x42d9e0f8,0x326cf078,0x72905213,0x42786086}},	//   _baten_, _jehofa_, _eblas_, _ubundi_,
   {{0xd6b75025,0x549c90a7,0xdc520214,0xeb0ea142}},	//   _obserwow, _naročila_, _amatala_, _epistola_,
   {{0x0290a215,0xf2366122,0xd394e077,0x512d2175}},	//   _dabar_, _svojo_, _poista_, _расте_,
   {{0xb291a1bf,0x02d9e147,0x9dff504a,0x6da1b008}},	//   _sipas_, _mateo_, _kandunga, _principa,
   {{0xbb4690eb,0xf47370e7,0x229180f6,0xf3f1b0bc}},	//   _privatna_, _partizan_, _garai_, _layering_,
   {{0x0d86f04d,0x6b7d3185,0x628d60a0,0x02d8c060}},	//   _明日の日経平均を, _terutama_, _archebu_, _aileto_,
   {{0x93a39060,0xf15390c5,0xaaf5e018,0xf1696102}},	//   _egypti_, _модель_, _attribut, _perintah_,
   {{0xb3f4002e,0x5e5251c5,0x6a604143,0x36201054}},	//   _postup_, _sedangka, _koolitus, _planeeri,
   {{0xedb9707f,0xf580d03c,0x425a00f6,0xe290a11c}},	//   _califica, _matematy, _saila_, _babar_,
   {{0xd2259216,0xa2fe5217,0x243930ea,0x00000000}},	//   _adabaghị_, _inrikes_, _인천광역시_, --,
   {{0xe317a134,0xb2e681c4,0x1a82c0c3,0x8856b049}},	//   _merched_, _bringen_, _алуминиу_, _मातृभूमि_,
   {{0xd217d218,0x42d8d075,0xa3802060,0x69cf10c4}},	//   _прогноз_, _teledu_, _aburú_, _nabehnut,
   {{0xe25bf1be,0xe8311065,0x52ab1057,0x7224106a}},	//   _afulu_, _الظروف_, _gendang_, _leginkáb,
   {{0x237901a5,0xbbf451a3,0xdecdc190,0x92fdc098}},	// [190] _megafun_, _akceptac, _ministrs_, _ministr_,
   {{0x53eb9219,0xc52de02c,0x226d8205,0xe290b1e7}},	//   _cesty_, _позволяе, _meron_, _frekans_,
   {{0xc2d9e20d,0xd06e1008,0x729260b4,0xff2a8170}},	//   _zaten_, _מוצקין_, _usuari_, _rastisla,
   {{0x3290221a,0x31b02070,0xa772f035,0x85292062}},	//   _lakay_, _پچھلا_, _प्राण्या, _наступил,
   {{0xa25a503a,0xfd86b178,0x68361008,0x0a93d182}},	//   _dalle_, _setembre_, _מסמכים_, _музиката_,
   {{0x163f01f1,0x704dc02a,0xb37a6084,0x7200c102}},	//   _komentár_, _проти_, _lawatan_, _gadis_,
   {{0xc3940047,0xa202604a,0xc3bb21ee,0x2ba920f6}},	//   _poist_, _sering_, _través_, _merkatar,
   {{0x2317021b,0x3c5c10b9,0x3291b18e,0x3af2221c}},	//   _amazwi_, _bestaan_, _movado_, _imoralit,
   {{0x9290c02e,0xf53b1031,0x22c1d1ea,0xf2fc621d}},	//   _zadat_, _内容读取中_, _okolica_, _stoga_,
   {{0x01b641da,0xcd448100,0xd38720ac,0x5290f0ff}},	//   _permessi_, _венесуэл, _idarə_, _oznamy_,
   {{0x5290c18e,0x9bf6b0cd,0x494e921e,0xc2e8e051}},	//   _talaba_, _बर्खास्त_, _učlanjen, _dalilin_,
   {{0x2709c036,0x00000000,0x00000000,0x00000000}},	//   _религия_, --, --, --,
   {{0xe04410cc,0xc25a005d,0x22c5a10c,0x29e76018}},	//   _פרידמאן_, _mailo_, _bremner_, _performe,
   {{0xf291c190,0x0d787048,0xec7ea0d4,0x5387404f}},	//   _divas_, _quăng_, _kunsill_, _guerre_,
   {{0x7907c0d3,0x5225f0f8,0x7c1d20f6,0x32919175}},	//   _تعتبر_, _eduki_, _uztailar, _essas_,
   {{0x1eb14153,0x63f1421f,0x730e604d,0x557740f8}},	//   _importan, _importaz, _悩みを聞いて_, _instalaz,
   {{0x5cdae0ff,0x92a691e3,0x42cad220,0x7586f18d}},	// [1a0] _katalóg_, _ndaba_, _valdes_, _overrask,
   {{0xf39540e8,0x83869206,0x49e81018,0x0200a024}},	//   _flesta_, _idara_, _העירייה_, _sabiq_,
   {{0x9fe08185,0xb26c41cf,0x6248d154,0x00000000}},	//   _संयुक्ता_, _temos_, _maombi_, --,
   {{0x99ecc031,0x9f5bf136,0xe2df908e,0x937a61a1}},	//   _魔兽野怪介绍_, _ponašanj, _nogomet_, _jawatan_,
   {{0x95f2e031,0x36839117,0xd9695171,0xde1ac189}},	//   _获取免费代码_, _войдите_, _similare, _diberika,
   {{0x8aca409d,0x330d21c6,0x3c9e0018,0x62da7221}},	//   _warmińsk, _pelayar_, _כוסיות_, _musela_,
   {{0x9290a0ef,0xcfffd16c,0xa2c1c01c,0xe087913b}},	//   _abban_, _аджария_, _stolova_, _并自负法律责任_,
   {{0x08abd068,0x43ea6011,0x1e916008,0xb2905070}},	//   _자기소개서_, _trots_, _abstract_, _ablak_,
   {{0xe9e3700a,0x23fa615e,0x12637142,0x9241f049}},	//   _limitata_, _datums_, _limitati_, _बहाली_,
   {{0x3987307b,0x6290a095,0x6178813c,0x00000000}},	//   _সমিতির_, _sabay_, _контроле_, --,
   {{0x2290c1d7,0xac4b102d,0x8225f1ff,0xd23440bb}},	//   _eadar_, _penting_, _leuke_, _khammee_,
   {{0x8bd6a020,0x02927100,0x027f7045,0x59e3e1e6}},	//   _광고제휴문의_, _visada_, _spania_, _редагува,
   {{0x92cbf035,0xbd295113,0x1c91005e,0xa25a0075}},	//   _studi_, _antipope_, _magulang_, _naill_,
   {{0x0f391098,0xf3fa61be,0x2291f222,0x32da001d}},	//   _milionů_, _burula_, _nhuan_, _liseli_,
   {{0x43c05223,0xf3ea9033,0x5a2ab07b,0x7290c224}},	//   _प्रस्तुत_, _santé_, _গুলিতে_, _zadar_,
   {{0x437b90b7,0x83cf5225,0xdff9a0a4,0x34efd0ea}},	//   _контрибу, _elever_, _स्मारके_, _관련사이트_,
   {{0x32ca71e7,0x93eb9211,0x14ba416a,0xa3011022}},	// [1b0] _mande_, _erste_, _प्रेषित_, _bayanai_,
   {{0x0201e0c3,0x368e213b,0x00000000,0x00000000}},	//   _citit_, _查看该会员企业网, --, --,
   {{0x0225903e,0x73ff021f,0x968240de,0x00000000}},	//   _elska_, _sproporz, _भुलाई_, --,
   {{0x314540d5,0x2c1db0fc,0x161180c1,0x99482076}},	//   _अहिंसा_, _ullamcor, _klientom_, _सांसदों_,
   {{0xc22ac175,0x37cf901a,0x2291a0bd,0x7c627101}},	//   _добар_, _varsinki, _espas_, _mutumin_,
   {{0x5ef3100f,0x01dcb02c,0x67ccb020,0x42fd4165}},	//   _अधिका_, _картинки_, _노튼주니어_, _separati_,
   {{0x73a41210,0x3da900a4,0x73f13166,0x7f641061}},	//   _finansij, _fasilita, _श्रीदेवी_, _finansin,
   {{0x5291e226,0xf30e5061,0x00000000,0x00000000}},	//   _zitat_, _paramos_, --, --,
   {{0x22d91052,0xd38ba02c,0x87e0c035,0x834aa19b}},	//   _uncedo_, _станет_, _सावरकर_, _پروجکشن_,
   {{0xced16020,0xb2b47221,0x02b4913f,0x1e396056}},	//   _상품가치가_, _konci_, _hoach_, _relatera,
   {{0xf843e044,0xbc53e227,0xe291d19e,0x5699c0a4}},	//   _últimos_, _último_, _diwar_, _नागरिकां,
   {{0x1b7be1b4,0xa2903117,0x661530b4,0x00000000}},	//   _pangeran_, _samaan_, _ampliaci, --,
   {{0xfc4460d7,0xfa0170e9,0x4c177100,0x00000000}},	//   _serveis_, _allavega_, _buhalter, --,
   {{0x5f02d228,0x9d85e05d,0xc5bbc116,0xe2ca709f}},	//   _सिद्दीकी_, _makerere_, _bakaarah, _hande_,
   {{0x23f8c0a9,0x336be1c5,0x1efe6061,0xdbffb01b}},	//   _odluke_, _lengkap_, _elektros_, _pengajar,
   {{0xe291e024,0x43ea7121,0x573ad100,0xf291119b}},	//   _sitat_, _puntu_, _мозгу_, _wacana_,
   {{0xd291e03f,0xc290e121,0x726c51b3,0xe290c19e}},	// [1c0] _citas_, _nafar_, _pelos_, _qadar_,
   {{0x7201e10c,0x9561d229,0x73ea3210,0x626c7044}},	//   _litir_, _mielestä, _sajta_, _nenos_,
   {{0xcb865099,0xad265099,0x72e37153,0xa1ec101c}},	//   _dovoljno_, _dovoljne_, _believe_, _najgorih_,
   {{0x3ea18068,0xa2eca203,0x2b3580c5,0x04b300cb}},	//   _부동산써브_, _notizie_, _tavallis, _jellegű_,
   {{0x73eb9152,0x82cad130,0xc290f039,0xcc820008}},	//   _gusto_, _sreda_, _magas_, _מקרקעין_,
   {{0xa6b641a2,0xc25a012f,0xf202018c,0x620150b9}},	//   _ماهواره_, _gaile_, _depite_, _poging_,
   {{0x526c7183,0xc2f4c113,0x541d70b9,0xaa029037}},	//   _menos_, _hopital_, _verstaan_, _serangga_,
   {{0x72f0d037,0xf3a4222a,0x42cb8188,0xce542008}},	//   _istilah_, _financij, _burde_, _financia,
   {{0xeeb4e120,0xe290322b,0x1b5b7165,0x92db722c}},	//   _diverses_, _komast_, _komunita_, _komunity_,
   {{0xe2cfc1a6,0x2a240117,0xa290d1a7,0x1ad300b5}},	//   _kancelář, _интеллек, _monate_, _dostanet,
   {{0xe57521ef,0x0010e160,0x42d9f039,0x9c07b0b0}},	//   _contrato_, _margaíoc, _isten_, _cyrsiau_,
   {{0xba7b222d,0x5290122e,0xf290319e,0x59787054}},	//   _prošle_, _nchai_, _kilang_, _valimist,
   {{0xbcdca008,0x45a90041,0x5b607038,0x02637142}},	//   _סמארטפון_, _formulář_, _septemba_, _nominati_,
   {{0x50d1012f,0x8317b130,0x3eac30a2,0x00000000}},	//   _الأغاني_, _тренера_, _donošenj, --,
   {{0x627e922f,0x8408012f,0xf0ce20bc,0xc2b4b18c}},	//   _umano_, _اونلاين_, _ribonucl, _cheche_,
   {{0xd24941ae,0x20f52167,0x438740bd,0x33eaf0de}},	//   _tiempo_, _अप्रिल_, _amerik_, _viitsi_,
   {{0xef1a9030,0x1d3d3098,0xfa0000c4,0xc26cb0b0}},	// [1d0] _ओरिजनल_, _politice_, _dražba_, _ofcom_,
   {{0x5be16191,0x6609e16f,0x70d9e193,0x23565100}},	//   _navigáci, _zaboravi, _zaboravl, _adresas_,
   {{0x7a8901be,0x2e70d0a4,0x8a01205e,0x8c69d057}},	//   _karibian_, _व्यक्तीम, _mahalaga_, _jibrail_,
   {{0xfb7e603b,0x629030a4,0x33eaf01f,0x91c6913b}},	//   _profilin_, _bilang_, _saites_, _保持共产党员先进,
   {{0x22fcd0a6,0x623ab1be,0xc857b017,0x929251e7}},	//   _keegi_, _abamuru_, _културно, _estati_,
   {{0x73940179,0x537a5230,0xcc43a025,0x32b4004f}},	//   _voisi_, _izjavio_, _पनडुब्बी_, _voici_,
   {{0x827e908d,0xd975b0dc,0x1ae84093,0xc9c84068}},	//   _amane_, _kuriozit, _verdiens, _verdiene,
   {{0xa3ea0190,0x6951f143,0xd2925142,0x93f400ab}},	//   _saite_, _kvalitee, _istati_, _pistes_,
   {{0x6c87b118,0x03ea90ed,0x5459c0db,0xf9840231}},	//   _времето_, _suatu_, _objetivo_, _medijima_,
   {{0x03dc1157,0xd29080de,0x00000000,0x00000000}},	//   _nthwv_, _sakala_, --, --,
   {{0xb26cd043,0x22d8d1b1,0x2c5b5113,0x720031c0}},	//   _proofs_, _nkees_, _nomtswv_, _ailing_,
   {{0x2290f195,0x72919232,0x73ac1039,0x53445008}},	//   _dagar_, _yasal_, _tippek_, _license_,
   {{0x2291e00c,0xf7c2f07b,0x22e090a2,0x5290f233}},	//   _kitap_, _মিসরে_, _poznato_, _vagas_,
   {{0xc65b9088,0x754d70e8,0x23ea7089,0xa7e3102a}},	//   _halimbaw, _verksamh, _punts_, _чотири_,
   {{0xf291d037,0xbc6821ae,0xb2903234,0x92ab913b}},	//   _sawah_, _febrero_, _संयोजन_, _并不代表本站及其,
   {{0x9f5bb235,0xb9d73054,0x00000000,0x00000000}},	//   _mahadsan, _kustutad, --, --,
   {{0xf3f8b057,0xdc530122,0x6145c0e1,0x93874082}},	// [1e0] _tudung_, _obstaja_, _हुकूमत_, _sterke_,
   {{0x04721102,0xb2b46236,0x86360004,0xcb8fc06f}},	//   _disebabk, _blocs_, _ייִוואָ_, _смолян_,
   {{0xf548c025,0x1365713a,0x627f4036,0xe3a290e6}},	//   _चाहेंगे_, _drugima_, _eventi_, _knapp_,
   {{0xad19a1b2,0xa37950a4,0x02ea0237,0x5012f144}},	//   _crosswor, _matanya_, _barisan_, _predpiso,
   {{0x03ea9047,0xb83b8025,0x930fe0c2,0x10f67006}},	//   _brath_, _अरबपति_, _bambino_, _आक्रोश_,
   {{0xd89990b7,0x170ba008,0x730c61d7,0x00000000}},	//   _универ_, _ההבדל_, _adabroc_, --,
   {{0x9c67c034,0x52ea011c,0x120180de,0x42d901ab}},	//   _телефона_, _warisan_, _parim_, _libero_,
   {{0x2dd2d01a,0x2f383238,0xdc1da040,0x12018024}},	//   _стали_, _दायित्व_, _aktualis, _fiziki_,
   {{0xc26450c0,0x255830c2,0x32fc4098,0x7290122e}},	//   _skulle_, _понякога_, _designu_, _nphau_,
   {{0x837950f1,0xff37b198,0x798680cd,0x2c37a203}},	//   _katanya_, _pristupa, _ताजमहल_, _димитър_,
   {{0xd7c2f07b,0xd368a0d2,0xc2cad134,0x5740512c}},	//   _মিশরে_, _vergeet_, _credu_, _accompag,
   {{0xc5ce40ca,0xe200b239,0x6290c0a2,0x1e4070c8}},	//   _प्रदर्शन, _kleine_, _dolaze_, _usnadnit_,
   {{0x525a9080,0xaf399004,0x033f9018,0x475db23a}},	//   _hrali_, _סקרין_, _במתחם_, _कुख्यात_,
   {{0x729180a4,0x32eb10f9,0x02919142,0x00000000}},	//   _jarak_, _difisil_, _qasam_, --,
   {{0xe9a9c23b,0x11f5d1bb,0x72916074,0xb3dc900d}},	//   _विद्यालय_, _субота_, _magana_, _ntawe_,
   {{0x5fe9b0a6,0x134c323c,0x0927c025,0x00000000}},	//   _मुहावरा_, _मासूम_, _आंकड़े_, --,
   {{0x32008074,0xca15b116,0x3e7a804d,0x6359e0d7}},	// [1f0] _hakika_, _islaamka_, _アイコンの説明_, _situació_,
   {{0xc25a9165,0x00000000,0x00000000,0x00000000}},	//   _orali_, --, --, --,
   {{0x7e4f310c,0x8291a089,0x4650c0ea,0xa2d87076}},	//   _cheangla, _espai_, _전자상거래_, _rynek_,
   {{0x21037126,0xc593a173,0x729180ed,0x00000000}},	//   _munkahel, _ліпеня_, _marah_, --,
   {{0xc864023d,0x00e1f076,0xe608a0c8,0x00000000}},	//   _fernánde, _ewentual, _zdravím_, --,
   {{0x9fd68045,0x92b4e203,0x83ac0021,0x4ecc502a}},	//   _кваліфік, _clicca_, _grupę_, _основном,
   {{0x47ad4175,0xc2ca0074,0xaf2c023e,0xd2009113}},	//   _природни_, _maida_, _hantarka, _npaim_,
   {{0xb2e8223f,0xf3ea0179,0x00000000,0x00000000}},	//   _içinde_, _laita_, --, --,
   {{0xd91b80cc,0xd39491a4,0x329120a4,0x3d89f0c3}},	//   _בפֿרט_, _vlast_, _layar_, _техниче_,
   {{0x2f63f0ea,0xefeeb024,0x88682018,0xd20101ea}},	//   _참고하시기_, _partlayı, _מתאימים_, _dobite_,
   {{0x4b2d3240,0xe96b50e6,0x00000000,0x00000000}},	//   _sambutan_, _meinunge, --, --,
   {{0x925a50e6,0xd29070e9,0x8f4ae061,0xc3007082}},	//   _hallo_, _sambandi_, _laisvala, _samband_,
   {{0x4291f183,0x43ea01dd,0x14fdc1a2,0xc25a518f}},	//   _estas_, _baita_, _مجددا_, _kallo_,
   {{0x824980e1,0x1b02807a,0x1f0721c9,0xf200b0a1}},	//   _firmy_, _розуму_, _disponív, _hadija_,
   {{0xd57fc0ef,0xb200b241,0x00000000,0x00000000}},	//   _مصاحف_, _radila_, --, --,
   {{0x7201919d,0x2ebc0242,0x22c3f017,0xf1c950de}},	//   _kasih_, _opportun, _користи_, _पद्मविभू,
   {{0x42ca0154,0xcff4d02b,0x8dd4d070,0x443e102f}},	// [200] _faida_, _techniko, _technika, _фауны_,
   {{0xc27e900d,0xc2ca71df,0x225b5045,0x0b7c113b}},	//   _imana_, _zanda_, _spelar_, _如果您没能找到需,
   {{0x3ddcc1bd,0xf3a9505e,0x9291a187,0x00000000}},	//   _ملحوظ_, _madaling_, _mapak_, --,
   {{0x12911209,0x2225700e,0xbb0d818e,0x1deb5233}},	//   _yazar_, _abakol_, _kissimme, _municípi,
   {{0xd3f47090,0x4c53e243,0x9290f119,0xb4b15175}},	//   _pastaj_, _राकेश_, _tagay_, _descriçã,
   {{0x99fca09c,0x82927244,0xa387f086,0x450a81d7}},	//   _palament, _disana_, _ijuru_, _agallamh,
   {{0xf4a900f8,0x73f0a035,0x4393a094,0x3201919e}},	//   _pasahitz, _ग्रॅम_, _ברוגז_, _tasik_,
   {{0x626e11c0,0xdc664024,0xd5b27098,0x00000000}},	//   _riport_, _tutulub_, _pronájmu_, --,
   {{0x230c4245,0x6200c246,0x00000000,0x00000000}},	//   _impamvu_, _halima_, --, --,
   {{0x52ca7074,0xa51e10ac,0x3b7e1076,0x7d8b1154}},	//   _sanda_, _ekologiy, _ekologic, _halmasha,
   {{0xb386603e,0x1643b02b,0x3202505d,0x00000000}},	//   _hvort_, _susitiki, _mitima_, --,
   {{0xf8852108,0xf3eb90c5,0x9236c143,0x0c48004d}},	//   _श्रीवास्, _musta_, _hiljem_, _エレクトロニクス_,
   {{0x3dd22045,0x7201e247,0x4517b029,0x03ea9100}},	//   _доступ_, _matiu_, _समृद्ध_, _esate_,
   {{0xe25a4109,0x46052140,0x5682219b,0x5f02f098}},	//   _gamle_, _prodajem_, _همانطور_, _लुम्विनी_,
   {{0x5200c07a,0x93eb9248,0x32ff4122,0x13b9c061}},	//   _galima_, _gusta_, _maribor_, _ліній_,
   {{0x88409070,0xf291f1e4,0xdf4eb18c,0x62d9614f}},	//   _سیکرٹری_, _astar_, _respekte_, _wageni_,
   {{0xd166303c,0x5291c105,0x331531ce,0xb37a119e}},	// [210] _प्रतिबंध_, _davam_, _تواضع_, _pasaran_,
   {{0x00a610cc,0x920260f9,0xfd8750d7,0x42fc31b2}},	//   _עסקנים_, _merite_, _desembre_, _melikas_,
   {{0xa3ee109d,0x5e227025,0xd2919173,0xe407e036}},	//   _zakończo, _आमतौर_, _pasak_, _градове_,
   {{0x63ac7187,0x239470d1,0xa35be00d,0x42afb044}},	//   _turpis_, _sonst_, _kangura_, _módulo_,
   {{0x0291a19e,0x00000000,0x00000000,0x00000000}},	//   _tapak_, --, --, --,
   {{0x720090e0,0xb1660094,0xd047f025,0xc2f0d10f}},	//   _ncaim_, _איסורים_, _मुसलिम_, _fatimah_,
   {{0x13eb9037,0xe8b59020,0x02369249,0xbe07208b}},	//   _gusti_, _전체평가보기_, _miljö_, _dospelýc,
   {{0x02ab10b9,0xa2e0e105,0x1d97a065,0xa2d94124}},	//   _leiding_, _cənubi_, _القهوة_, _sheega_,
   {{0xb8345008,0x3290112c,0x82c21088,0x1561a24a}},	//   _מהתגובות_, _achat_, _bibliya_, _proviamo_,
   {{0xe9a5f10b,0xcd23618c,0x6bef2172,0x374ab219}},	//   _diskusia_, _konsantr, _racecour, _upozorni,
   {{0x1593a24b,0x8c90b12d,0xe2fd804a,0x9492e102}},	//   _prilikom_, _क्रोम_, _pergi_, _tinggalk,
   {{0xe2ca919c,0x9394724c,0x73949076,0x89ea612f}},	//   _saada_, _innse_, _klasy_, _مراهقات_,
   {{0x42fd80ad,0xd9de10d4,0xdb6e21fd,0x7c6c10ea}},	//   _vergi_, _multimid, _kartalla_, _actueel_,
   {{0x33ebf05d,0x94730084,0x6f207244,0x820250d4}},	//   _butto_, _pastikan_, _mendukun, _antika_,
   {{0xbce621b1,0xa37a21c6,0x52916116,0x82b400c2}},	//   _cwjvuamc, _paparan_, _lagama_, _unico_,
   {{0x6291f0f5,0x42d9d24d,0x1e62217e,0xe00350ea}},	//   _lazada_, _skynyrd_, _imobilia, _인기검색어_,
   {{0x4fe87035,0xf394d24e,0xc32af0a2,0x325a2147}},	// [220] _वाचायला_, _pulsuz_, _prikuplj, _bakla_,
   {{0x15144115,0x5df5312e,0xe980504e,0x3880504e}},	//   _resumido_, _pridajte_, _articole, _articolu,
   {{0x0c57424f,0x4e9741bf,0xa26e60ec,0x11e7b1af}},	//   _postime_, _postimet_, _parool_, _наградат,
   {{0x59a3f034,0xfc0450e9,0x23967068,0xa1b72017}},	//   _лекарств, _vinstri_, _cursus_, _високим_,
   {{0x721c717f,0x5feda018,0x416910a0,0xb2ca50fd}},	//   _rushwa_, _מסביב_, _pennaeth_, _valde_,
   {{0xe2ca017f,0x803400cc,0x6e16509d,0x66264128}},	//   _dhidi_, _קאמאנס_, _जागरूकता_, _sistemul_,
   {{0xb25a5054,0x877f50ea,0xb2e83133,0xc291e250}},	//   _talle_, _서울대학교_, _fàilte_, _tatau_,
   {{0x3200e241,0xca02f1cc,0x00000000,0x00000000}},	//   _danima_, _tetangga_, --, --,
   {{0x13dc0184,0x6d30e038,0x7161d185,0x9201a099}},	//   _ariwe_, _hatimaye_, _pengelol, _ispit_,
   {{0x32ca7251,0x62925006,0xf3797141,0x6b5280fd}},	//   _cando_, _latach_, _rasanya_, _почуття_,
   {{0x47fae04d,0x995ce122,0xb37f8252,0x5da2d19b}},	//   _コメントありがと, _nadomest, _inkasta_, _پاشنه_,
   {{0xc38af208,0x22f0f1d6,0xd2da5086,0x620261d6}},	//   _mòran_, _achapụ_, _gatera_, _birila_,
   {{0x138690ca,0x22aba18e,0x69c4b0cb,0x0da0808f}},	//   _tvaru_, _beading_, _گنجائش_, _アルファグランデ,
   {{0xa357f048,0x8290e086,0x12925038,0xe2b491e8}},	//   _xenforo_, _kanama_, _hatari_, _inace_,
   {{0xa201f0a2,0x4a05f175,0x12da5122,0x214b5076}},	//   _obzira_, _embalage, _katera_, _stronach_,
   {{0x3fe91253,0x56b970b9,0x00000000,0x00000000}},	//   _फ्रान्स_, _benaderi, --, --,
   {{0x327e0254,0x4231704c,0xa855d04d,0x910740a9}},	// [230] _seinn_, _bermula_, _ああっ名無しさま, _pronađi_,
   {{0x937a60f1,0xa25a504f,0x3c64a041,0x00000000}},	//   _kawasan_, _salle_, _situace_, --,
   {{0x22494077,0xa386d1ec,0x54901025,0x5b6c70d5}},	//   _hieman_, _edere_, _चम्मच_, _वासना_,
   {{0xe3f461a8,0x1453112b,0x94d6c14c,0x00000000}},	//   _ujutru_, _službou_, _बुढिया_, --,
   {{0x7493f020,0xd7e270bb,0x9f3dd23a,0xeb0de13b}},	//   _블로거뉴스_, _cinplaim_, _क्षितिज_, _违反本法规定_,
   {{0x814dc017,0x23949255,0x4ecda0dc,0x82cad0aa}},	//   _избори_, _vlasy_, _komision, _kredi_,
   {{0x82da5256,0x8224911c,0x93ea3070,0x00000000}},	//   _batera_, _anake_, _fajta_, --,
   {{0xfe9ba257,0x03cf418c,0xec743037,0x00000000}},	//   _seguinte_, _preval_, _pelukis_, --,
   {{0x0675c13b,0x00000000,0x00000000,0x00000000}},	//   _经典艺术片_, --, --, --,
   {{0x46d61258,0x722b91cd,0xa2e20202,0xbe1b9178}},	//   _discussi, _exemple_, _calidad_, _exemples_,
   {{0x23ead090,0x641211bd,0x2291e035,0x00000000}},	//   _rreth_, _محققین_, _batam_, --,
   {{0x1db8e070,0x9be5b259,0x81cc212d,0x47e8c003}},	//   _valamint_, _randamac, _धरोहर_, _alvarleg,
   {{0xdc6f7221,0x3c76325a,0xeb2200ed,0xb30cb149}},	//   _heureka_, _मुद्रा_, _walaupun_, _poradit_,
   {{0x5a57101a,0x438060bd,0x44769179,0xd3fa501f}},	//   _цитата_, _sourit_, _процесс_, _satura_,
   {{0x9089c13c,0x143ec175,0xc39601b2,0x6b17c1b8}},	//   _режима_, _разни_, _lossis_, _раздел_,
   {{0x829d8080,0x8c59d093,0x6378109e,0x5c6210b3}},	//   _všade_, _vertrek_, _rubanda_, _izgubio_,
   {{0xa272a25b,0x0ebca006,0x43ead075,0x327e025c}},	// [240] _tűnik_, _publiczn, _treth_, _reino_,
   {{0xada8d0b4,0x776e8153,0x925a4056,0x9b67f1d7}},	//   _activita, _universi, _gamla_, _innealan_,
   {{0x2b81b1f1,0xb201e0f1,0xd307810c,0x7c6ea25d}},	//   _sledovať_, _yatim_, _agbaidh_, _styrkja_,
   {{0x82aa315d,0xe292725e,0x00000000,0x00000000}},	//   _vneconom, _rurali_, --, --,
   {{0x46658025,0x00000000,0x00000000,0x00000000}},	//   _आईएसआई_, --, --, --,
   {{0x76e40038,0x92fdf038,0x3afdf164,0x959db024}},	//   _kimataif, _ndugu_, _prosjekt, _lisenziy,
   {{0x4dc3a02e,0x9394425f,0x5215a16a,0xf3869011}},	//   _podobné_, _komst_, _oddělení_, _svart_,
   {{0x6641407b,0x01e19002,0xb2d5100f,0x6dbb804d}},	//   _যথেষ্ট_, _मदारी_, _millest_, _アニメ感想_,
   {{0x8c00b178,0x9290f083,0x0379b022,0x931c008e}},	//   _passant_, _pahala_, _bayanin_, _pohištvo_,
   {{0x038691be,0x23a8e205,0x22027206,0x07b2d260}},	//   _gwara_, _malaking_, _hariri_, _штаба_,
   {{0x6bcf51b0,0xa2ca711a,0xe0b6d030,0x22cad122}},	//   _श्रीनगर_, _tande_, _नेचुरल_, _uredi_,
   {{0xf2fc906e,0x99c290de,0x9a51f0a4,0x9ed60169}},	//   _agaga_, _kindlast, _व्यंगचित, _kažem_,
   {{0xfbdff191,0xb27e0143,0xc291f0a9,0xe01fa02b}},	//   _aplikáci, _teine_, _brzaka_, _investuo,
   {{0x82ca518b,0x82918261,0xa290c055,0x13ead0e7}},	//   _halda_, _barat_, _salaan_, _preti_,
   {{0x42018246,0xfea280e9,0x13ac70ae,0x22918246}},	//   _maris_, _landsins_, _grupas_, _maras_,
   {{0x227e9152,0xe2018056,0x4202503a,0xed5b712f}},	//   _ilang_, _varit_, _ultimo_, _aistriú_,
   {{0x450fb0f1,0xb278e00d,0x1154f0a2,0x13f96088}},	// [250] _komersil_, _miliyoni_, _budućnos, _siguro_,
   {{0xe2018037,0x9d72c262,0xb4b9f263,0x41b9f089}},	//   _garis_, _राष्ट्रध, _मंगेशकर_, _direcció_,
   {{0x520271ec,0x2c30707b,0xd200c19e,0xe68c5166}},	//   _kariri_, _ভাইয়ের_, _talian_, _संभाल_,
   {{0xb968a1c4,0x029101e2,0x9127c036,0x23478264}},	//   _informie, _zabala_, _наложи_, _começa_,
   {{0x021391df,0x72ea0083,0x3dab5003,0x00000000}},	//   _cishe_, _kiriman_, _menninga, --,
   {{0xd3ea7058,0xb15c212b,0x426df265,0xa291a069}},	//   _sante_, _oficiáln, _मनीषा_, _ntxawm_,
   {{0x52dc50a8,0x489b404d,0xfd6b403b,0xc6fa60ea}},	//   _søndag_, _レストラン_, _partisë_, _실시간환전게임_,
   {{0xc18ac12f,0xa27e0211,0x525ad078,0x52c2702e}},	//   _وكذلك_, _seine_, _isele_, _kvalita_,
   {{0x625a5034,0x6e6da0a9,0xbc98022b,0xb2480122}},	//   _dalla_, _proizvođ, _spurning_, _njimi_,
   {{0xbb617266,0x69d310a4,0xf2024044,0x122500a2}},	//   _bystrica_, _pokoknya_, _ética_, _ovakav_,
   {{0x1c483162,0x73ebf048,0x0ff5f04d,0x00000000}},	//   _अभिनंदन_, _btttt_, _ランキング一覧_, --,
   {{0x56820166,0xa201900c,0x72fd40f2,0x00000000}},	//   _विराट_, _basit_, _adegan_, --,
   {{0x2291e05e,0x229190a3,0x00000000,0x00000000}},	//   _tatak_, _masas_, --, --,
   {{0x41bd8077,0x66e40008,0x7cb2407b,0xf95ed013}},	//   _развития_, _בנתניה_, _আইনগত_, _inclusie,
   {{0x03d7103d,0xe1b2b04d,0xe98400a9,0x42d221df}},	//   _参考になった_, _名無しさん_, _godinama_, _empeleni_,
   {{0x92366098,0x526c2099,0xa3805177,0xc2918037}},	//   _svoji_, _mukom_, _catrin_, _waras_,
   {{0x118d60a8,0x62a6a119,0x7291e00c,0x32d8f165}},	// [260] _forbehol, _eebbe_, _yatak_, _rekords_,
   {{0xf2761008,0x1394d038,0x3201e0aa,0xaf69b122}},	//   _תיאטרון_, _agosti_, _fatih_, _porodniš,
   {{0x96b00008,0x32925174,0xf4682018,0xbd2f20fe}},	//   _סמסונג_, _estaba_, _התהליך_, _তৎকালীন_,
   {{0x0291a220,0xf291814b,0x11389037,0xbc77120e}},	//   _lapas_, _karar_, _ابراهیم_, _venstre_,
   {{0x2a10709e,0x4225b0e0,0x00000000,0x00000000}},	//   _kambanda_, _xavkom_, --, --,
   {{0xe7937077,0xe5dfc065,0xaa719074,0x5d392054}},	//   _moottori, _بحاجة_, _larabawa_, _mobiilne_,
   {{0xfeaa805a,0x53b9b222,0x00000000,0x00000000}},	//   _baturage_, _pdaviet_, --, --,
   {{0xe3ebf0fa,0xb236011a,0x63ea90de,0x927e0267}},	//   _kutta_, _blije_, _saate_, _owino_,
   {{0xc278b0b6,0xc22400d4,0xd396512b,0xd341c178}},	//   _закарпат, _unika_, _zkuste_, _adreça_,
   {{0x03ebf01a,0x59997020,0x83ebf0b2,0xf9d0314d}},	//   _mutta_, _미디어로그_, _stttt_, _желим_,
   {{0x1291a268,0xe29180aa,0x7306400f,0x92019018}},	//   _mapas_, _zarar_, _सुचित्रा_, _basis_,
   {{0xe730e0c4,0xc27e0267,0x5b38a1a2,0x62ca7221}},	//   _novostav, _bwino_, _زولبیا_, _bundy_,
   {{0x529181ac,0x5841d163,0x0501d163,0xc47bd0ea}},	//   _paras_, _početku_, _početka_, _제휴사이트_,
   {{0xe2b4c221,0xb2e80249,0x22cae134,0x127ee057}},	//   _plocha_, _länder_, _beidio_, _zainal_,
   {{0x2a868060,0x32fe4269,0x22d5d089,0x2f5d31e8}},	//   _nítorí_, _haridus_, _benefici_, _opravdan,
   {{0x83ebf03e,0x3f212034,0xfc5e30b9,0x1477c215}},	//   _stutt_, _acquista, _kasteel_, _пакетах_,
   {{0xa316d063,0x22ab70b6,0x83a291e7,0x7290b17a}},	// [270] _ndezi_, _melding_, _chape_, _andare_,
   {{0xa2ca705e,0xa27ee031,0x646db26a,0x1c8fd16f}},	//   _handa_, _bonnes_, _aprendiz, _opadanju_,
   {{0x625aa26b,0x83fa607a,0x0f86f16a,0xd345403c}},	//   _table_, _forumo_, _डडेलधुरा_, _terenie_,
   {{0x569c2077,0x93eaf1df,0x77d8108d,0x2e7791d3}},	//   _достаточ, _faiths_, _quarterf, _कुच्छ_,
   {{0x1f19e1b3,0x8639402e,0xb6a0f037,0x53fa409c}},	//   _permitir_, _materiál_, _الزامی_, _dawudi_,
   {{0x9d0a126c,0x07b61072,0xf1dbe159,0x00000000}},	//   _segretar, _levering, _akọsilẹ_, --,
   {{0xb2918124,0x6386d26d,0x734290d5,0x9753a0cd}},	//   _warar_, _hvert_, _सरपंच_, _युधिष्ठि,
   {{0x6867e021,0x1d5ac218,0x9c52801a,0x3eb4f216}},	//   _органам_, _кожен_, _hintaan_, _alakụba_,
   {{0xa291816d,0x5f48b0b9,0x9303c0ce,0x86f1f26e}},	//   _harap_, _kunstena, _gekauft_, _portuguê,
   {{0xe348c0c7,0x72e8026f,0x8c70f113,0x63ea7119}},	//   _offerti_, _händer_, _kajsiab_, _aanta_,
   {{0x734630b9,0xd34040eb,0xf9bdf13b,0x835421bb}},	//   _kinders_, _nedelja_, _中国气象局_, _numeris_,
   {{0x53eb8061,0xb683513b,0x3200200d,0x620180d4}},	//   _kurti_, _福星上战场_, _komine_, _parir_,
   {{0x3e260008,0x93ea7119,0x5dfb904e,0x00000000}},	//   _משפחתי_, _danta_, _diferite_, --,
   {{0x924bb0de,0x14a2c01a,0x00000000,0x00000000}},	//   _जानेला_, _ткани_, --, --,
   {{0x325bf0a6,0xa2b5c0a2,0xe59fb05e,0xda0010da}},	//   _juuli_, _novca_, _pangunah, _kayaknya_,
   {{0x436ef231,0x270e2018,0xbc59f122,0x00000000}},	//   _njegovu_, _בוודאי_, _lastnik_, --,
   {{0x4ab47270,0xb29ee053,0x437b2271,0x927e0089}},	// [280] _खिचड़ी_, _miljoen_, _impacto_, _feina_,
   {{0x42d9812e,0x94b280c2,0xffa541c6,0x83958036}},	//   _okrem_, _organizz, _disember_, _forse_,
   {{0x426d90a4,0x0dd620f6,0x00000000,0x00000000}},	//   _besok_, _deskriba, --, --,
   {{0x218c60de,0x637861e7,0x00000000,0x00000000}},	//   _सर्वर_, _ouganda_, --, --,
   {{0x03ced043,0x4394e08d,0x226c60b9,0xa291c105}},	//   _clovis_, _elisha_, _brood_, _banklar_,
   {{0x227f00c9,0x5386d22b,0xd00a817a,0xc6f640da}},	//   _hranom_, _hvers_, _списание_, _पुरवठा_,
   {{0xa2b5718c,0x63bff0c2,0x956ff0c2,0x125bc158}},	//   _chache_, _servizi_, _servizio_, _agalú_,
   {{0xa2d980ca,0x42139272,0x02fc724a,0x52fc0081}},	//   _okres_, _kisha_, _tunga_, _origo_,
   {{0xcb7bd076,0x8097d175,0x827e722b,0x6b993122}},	//   _दर्शकों_, _промена_, _renna_, _socialno_,
   {{0xa3410126,0x3386d1be,0xd3896024,0xa3cf2222}},	//   _بنياد_, _meere_, _məruz_, _jzcviw_,
   {{0x49118084,0x3302d084,0x0c754248,0x00000000}},	//   _assalamu, _jikalau_, _algunas_, --,
   {{0xeebb21b2,0x32cac119,0x714d61ea,0xfacde273}},	//   _excommun, _cadde_, _obvestil, _посещени,
   {{0x1760111c,0x5386d274,0x448101a3,0x639540b3}},	//   _دلخواه_, _tvorba_, _मिलाकर_, _umesto_,
   {{0xcb0f2242,0x627851be,0x012a2215,0x93bc51bd}},	//   _corporat, _agunye_, _эстрадны, _حقانیت_,
   {{0x9489f13b,0xd30c9275,0x1b2f812c,0xa200d147}},	//   _新用户注册_, _setakat_, _considér, _sining_,
   {{0xfff791fb,0xa2139119,0xefaa703e,0x2a31c07b}},	//   _תענית_, _bisha_, _nemendur_, _পিডিএফ_,
   {{0x191e1004,0x730c325c,0x00000000,0x00000000}},	// [290] _זונטיק_, _relatos_, --, --,
   {{0xe331713b,0x2300b107,0x00000000,0x00000000}},	//   _国家粮食局_, _имигрант, --, --,
   {{0x3b1d2065,0xd37fc156,0x3c6a8122,0x52d9d134}},	//   _النجم_, _zemalja_, _forumov_, _hywel_,
   {{0x785be15e,0xd2b5f1a6,0x00000000,0x00000000}},	//   _nedrīkst_, _kluci_, --, --,
   {{0x58635276,0xd3ead0d1,0x0317e163,0x8290c124}},	//   _dicampur_, _montag_, _potiskuj, _kulamo_,
   {{0x12f1e09d,0x225bf23f,0x022490a2,0x468530e7}},	//   _pomocą_, _mutlu_, _onako_, _русије_,
   {{0x6579304d,0x00000000,0x00000000,0x00000000}},	//   _酢酸ビニル共重合, --, --, --,
   {{0xadc5a018,0xa8e7f1ab,0x7863c050,0x4e96c0cb}},	//   _christia, _затвори_, _позади_, _قرضوں_,
   {{0x8c67f0c5,0x3cdd107b,0x02ca6134,0xc377c19b}},	//   _minulla_, _হালকা_, _chodi_, _قرائت_,
   {{0x5efee277,0x04fd1065,0xfb27300c,0xc24a7080}},	//   _nóvember_, _بجودة_, _cumartes, _desmod_,
   {{0x12e971da,0xcfb8604d,0x4ed0e098,0x00000000}},	//   _tariffa_, _産学連携組織_, _policejn, --,
   {{0x63f8c278,0xb2c3a1e2,0xe5acd100,0xd2b6d0ad}},	//   _deluje_, _mailako_, _племя_, _müdiri_,
   {{0x6f502048,0x62fc7036,0xbdbcf144,0xe2d8e15b}},	//   _sohanews_, _lungo_, _intenzív, _meneer_,
   {{0xd201807f,0x22026074,0x7a49e13b,0x00000000}},	//   _scrie_, _jarida_, _个国家中排名第_, --,
   {{0x32fd4039,0x00000000,0x00000000,0x00000000}},	//   _idegen_, --, --, --,
   {{0x3559e071,0x1ebba1aa,0x00000000,0x00000000}},	//   _проблеме, _sportske_, --, --,
   {{0x3dd6005c,0x05f421ab,0x49233025,0x0758416a}},	// [2a0] _केजरीवाल_, _случва_, _सुरजन_, _समर्थित_,
   {{0xecd73037,0x99df507b,0x79f95098,0x0dbbb092}},	//   _اعلام_, _চারুকলা_, _firemní_, _objektív,
   {{0xc155d025,0xf46e803d,0x62d8c279,0x00000000}},	//   _इसीलिए_, _frederik, _lyder_, --,
   {{0xa2786147,0xa291d095,0xc3ea91d7,0x00000000}},	//   _ngunit_, _bawat_, _chath_, --,
   {{0xca5a6119,0x00000000,0x00000000,0x00000000}},	//   _hargeisa_, --, --, --,
   {{0x230e727a,0x2c692099,0x4c52e003,0x3b97c017}},	//   _arabera_, _zapravo_, _boltinn_, _семинара_,
   {{0x72ca90b9,0x4290d038,0x00000000,0x00000000}},	//   _skade_, _mkoani_, --, --,
   {{0x01a3a07b,0x3c9c603c,0xc81c6105,0x9b7d327b}},	//   _তাপমাত্র, _मुल्यांक, _çalanşik_, _wasukuma_,
   {{0x67cc61f8,0x84ead031,0xa56ad031,0x429181ee}},	//   _personli, _第二十二条_, _第二十五条_, _obras_,
   {{0xd5d53017,0x2387427c,0xb24a61c4,0x034101da}},	//   _туризма_, _ndersa_, _firmen_, _koperta_,
   {{0x02a690a1,0x4386906c,0xc68e40cf,0xdd368034}},	//   _alaba_, _alara_, _teleradi, _opinione_,
   {{0x5977f26d,0x521391c0,0xa2da00bd,0xf292627d}},	//   _menneske, _tishi_, _lapolis_, _oprava_,
   {{0x1255a1ce,0xc1b03070,0x0c6e1206,0x72d1f057}},	//   _problémá, _پچھلے_, _gharama_, _tentulah_,
   {{0xe2fc9211,0xcf25b0c2,0x2f1160c2,0x4248f150}},	//   _frage_, _selezion, _contatta, _ibhokisi_,
   {{0x53993249,0x8e0d011c,0xc2781185,0x13a8d1eb}},	//   _måste_, _فیلتر_, _pengirim, _армянска,
   {{0xefd710c8,0xc2b720de,0xb6dc406b,0xcef11069}},	//   _protože_, _क्रिएटिव_, _बैरिन_, _loojceeb_,
   {{0xdda47255,0xe378108d,0x022ac100,0x038750d1}},	// [2b0] _reagovat_, _cabanga_, _домам_, _zuerst_,
   {{0xbc6af076,0xd257327e,0xe3ce5109,0x327e0123}},	//   _dostawy_, _føler_, _selve_, _meint_,
   {{0x33a22131,0xa212d1b1,0x8200c038,0x8e1c1120}},	//   _compte_, _ehehe_, _kuliko_, _valencia,
   {{0xa291c03f,0xc201c1d6,0x43860077,0x038d121f}},	//   _savas_, _savis_, _koira_, _proposti_,
   {{0xa306520b,0x6b3c904d,0xa36e30f5,0xb3e920de}},	//   _menarik_, _解決済みの質問_, _songoku_, _वेबसाइटन_,
   {{0xd291e1c0,0x499401dd,0xe2fc7147,0x00000000}},	//   _gatas_, _emakumee, _tungo_, --,
   {{0xc48531f4,0x5c64304f,0x4200c02d,0x22e29035}},	//   _देहाती_, _contenu_, _kalian_, _तिकीट_,
   {{0xaa162136,0xb3062241,0x52926275,0xd3f83104}},	//   _podataka_, _podatak_, _korang_, _amaziko_,
   {{0x1936e061,0x62fcf0c0,0x5386f236,0xeffab026}},	//   _struktūr, _ganger_, _negre_, _मुहावरे_,
   {{0x02d960de,0x212851d5,0x00000000,0x00000000}},	//   _sageli_, _bụrụ_, --, --,
   {{0xb43ec01a,0x22a07084,0x5ee3627d,0x94861025}},	//   _давно_, _serbuk_, _spokojen, _मोटापा_,
   {{0xd26e60ae,0xe290c055,0x00000000,0x00000000}},	//   _autors_, _galaan_, --, --,
   {{0x03ac71c2,0x38ff00ea,0xd3ea917f,0x92ca918f}},	//   _respon_, _프로그램의_, _chati_, _chadi_,
   {{0xe7cd307b,0x786380bb,0xf89990b7,0xf200b0f4}},	//   _তাঁরা_, _haistias_, _универс_, _radiyo_,
   {{0xe8aae11c,0x65dd40ea,0x9bede035,0x20e3a144}},	//   _آکادمی_, _처갓집양념통닭_, _diperkir, _skontrol,
   {{0x62aa312f,0xbdc3927f,0x22fc7206,0x9e539185}},	//   _وسهلا_, _peringka, _bunge_, _perangka,
   {{0x8291e088,0xd200c18e,0x5200c038,0xc25ac05e}},	// [2c0] _batas_, _dalian_, _malipo_, _madla_,
   {{0x82cac056,0x48fdb0e9,0x82ca9136,0xf0e2d045}},	//   _ladda_, _skipulag, _ikada_, _sannsynl,
   {{0x72018171,0x8fae0122,0xe1481170,0x00000000}},	//   _abrir_, _odgovoro, _kartónov, --,
   {{0xf34391a6,0x19f0a02c,0x52d740f7,0x9f207035}},	//   _युकून_, _kunnolla_, _beslist_, _pendukun,
   {{0x7e0370eb,0xf70a209d,0xdaf60280,0xcc1520de}},	//   _uključen_, _zdecydow, _emprende, _विक्रान्,
   {{0x73ea6153,0xdb5bf097,0xd373004f,0xee9bf241}},	//   _photo_, _pretraga_, _domaine_, _pretrage_,
   {{0x5eae0004,0xc27e706a,0xc2da60c3,0x59d37281}},	//   _אוצרות_, _benne_, _cerere_, _kononnya_,
   {{0x4f1171e1,0xe3f43087,0x6f5100ea,0x864ca0df}},	//   _rendemen, _kartı_, _등록하시면_, _मर्डर_,
   {{0x624a704f,0xedb4b084,0xcb84004d,0x7394d0ea}},	//   _permet_, _diriwaya, _ザ操作端末監視シ, _moest_,
   {{0x98065282,0xa3c87153,0x723880b2,0xdd7a9178}},	//   _décembre_, _server_, _teamobi_, _diumenge_,
   {{0xc032116a,0x225a905e,0x925a003e,0xc2fe6073}},	//   _रौतहट_, _akala_, _skila_, _drugie_,
   {{0x52dc6194,0x7f0fd0c1,0x920031ae,0xb2e39058}},	//   _måndag_, _opatrova, _camino_, _latitid_,
   {{0xacd2003c,0x0632a187,0x338ce13c,0x4db17061}},	//   _विशेषाधि, _nabigazi, _музеј_, _marijamp,
   {{0x46b2f045,0x238cd107,0xdc1e2033,0x62da5119}},	//   _редактор, _музеи_, _compris_, _siteka_,
   {{0x6fcc6128,0xf2d8c0d4,0x00000000,0x00000000}},	//   _mobilier_, _mument_, --, --,
   {{0x73aa1283,0x358a1032,0xc56cc003,0x4c4e3065}},	//   _maraming_, _проблеми, _framleið, _بمعنى_,
   {{0xe29251e3,0x8e9050bc,0x13a22284,0x364920ea}},	// [2d0] _altare_, _cordless_, _compre_, _촛불문화제_,
   {{0xeecb40a9,0x52baa046,0xf0db5065,0xbee2020f}},	//   _priznaje_, _garedig_, _طرابلس_, _दुर्दैवा,
   {{0x8200c05d,0x4eff8069,0xebca1175,0xf37a50a2}},	//   _waliyo_, _gaojmoob_, _продавни, _objavio_,
   {{0xa429c20b,0x2c91405c,0xca662130,0x62ca41a2}},	//   _pimpinan_, _कंडोम_, _вируса_, _evolusi_,
   {{0x93ce01e7,0x29c870f6,0x3e24d035,0x327ec0af}},	//   _swivi_, _animalia_, _पृथ्वीतल, _redna_,
   {{0xd386d1d5,0xb34340a4,0xc25a40fd,0xc3b33017}},	//   _nwere_, _dikenal_, _оригінал, _турци_,
   {{0x02d8809f,0x62e800d1,0x6c77f031,0x8291e18f}},	//   _beheer_, _männer_, _presque_, _satar_,
   {{0x2e71d0d5,0xf757c017,0x79c4a0c7,0x1aae60f9}},	//   _लॉन्च_, _jedinstv, _rilevant, _eleksyon_,
   {{0xfc35e07b,0xe292515a,0xea1280a7,0x5e397285}},	//   _ইলিয়াস_, _betaal_, _zdravlje, _pelabura,
   {{0x62b400d7,0x2b59d036,0x5fcff0ea,0x00000000}},	//   _inici_, _distanza_, _마이페이지_, --,
   {{0xe292617f,0x8c80f070,0xff1e10e8,0xa8450089}},	//   _baraza_, _سالگرہ_, _landstin, _últimes_,
   {{0x56230091,0x07868218,0xa2924154,0x824c60ef}},	//   _naturiol_, _ansvarli, _hawana_, _normális_,
   {{0xfa4ba008,0xa2f04024,0x726d9120,0xc7170286}},	//   _פלילי_, _colibri_, _mesos_, _stoličky_,
   {{0x82018008,0xa2a05287,0x82910036,0xe394008d}},	//   _april_, _futbal_, _sabato_, _mnisi_,
   {{0x32da50f5,0xa386d075,0xc08cc13c,0xcd9390fe}},	//   _aptech_, _clerc_, _славе_, _যোগাযো,
   {{0x76df3136,0x5a1f3241,0xcf63c288,0x00000000}},	//   _najbolji, _najbolje, _समस्याएं_, --,
   {{0x0b630091,0xe099a008,0xbce800d5,0xcea4d194}},	// [2e0] _materion_, _לחסוך_, _अनामिका_, _будучи_,
   {{0x1f1500e8,0x9815d0c3,0x98cec0cb,0x00000000}},	//   _fortfara, _буката_, _ديکھيے_, --,
   {{0x9b630046,0xc3ec600a,0x00000000,0x00000000}},	//   _faterion_, _espressi_, --, --,
   {{0x7b09d04d,0xf6be2081,0x0f31a18c,0x22da60b9}},	//   _サインイン_, _показник, _konfidan, _bereid_,
   {{0x6a7c6158,0x62bc2018,0x42f050a1,0x3e0d2020}},	//   _ìjápọ̀_, _מליסינג_, _kilindi_, _landscha,
   {{0x6c26a098,0x52da401f,0x00000000,0x00000000}},	//   _titulů_, _metodes_, --, --,
   {{0x74a31020,0xa305a0bd,0x43f8f246,0xe2d440af}},	//   _대구광역시_, _almanak_, _uygur_, _podobna_,
   {{0xc2245056,0x8201415d,0x00000000,0x00000000}},	//   _vilka_, _pleiku_, --, --,
   {{0x43b26289,0x2fb29071,0xe212b013,0xc39571ea}},	//   _porque_, _музикант_, _nacht_, _glasba_,
   {{0x1249f28a,0xe5324082,0x803bd107,0x32b520cb}},	//   _nyuma_, _централь, _станал_, _vicces_,
   {{0xf236c035,0xbf3880ac,0x72fcf005,0xf5016044}},	//   _produksi_, _resursla, _langar_, _forestal_,
   {{0x0f63c1a3,0xb26d8011,0x023fc0ea,0xb3eaf0ed}},	//   _समस्याओं_, _beror_, _사용합니다_, _mantap_,
   {{0x22be61bd,0x5c76d025,0xd29241c0,0x00000000}},	//   _majdnem_, _छेड़छाड़_, _mawala_, --,
   {{0x5547c07b,0xec4a7134,0x56e8a13b,0xe60cf216}},	//   _ষড়যন্ত্র_, _pentref_, _国家工商行政管理, _ayọcha_,
   {{0xa85ef233,0x00000000,0x00000000,0x00000000}},	//   _forneced, --, --, --,
   {{0x6f5d812d,0xcb55c025,0xe25a910c,0x2c18f045}},	//   _महंगा_, _एप्लीकेश, _chall_, _arranger,
   {{0x22e760bd,0xf39581ab,0xd27f40d4,0x22b4004e}},	// [2f0] _trennen_, _corso_, _emenda_, _unici_,
   {{0xff58e031,0xc201e068,0x32918116,0x00000000}},	//   _notammen, _actie_, _haray_, --,
   {{0x95ae01da,0x127e70e9,0x73ebf05d,0x555d8052}},	//   _preparaz, _kenna_, _lutti_, _uvavanyo_,
   {{0xb014804d,0x43f8906e,0x0e52216c,0x7292708e}},	//   _このブログの更新, _kukuru_, _адолесче, _hkrati_,
   {{0x82918119,0x5b0b504d,0xc2fe4008,0x6c6b223a}},	//   _maray_, _アプワイザ_, _various_, _टोक्यो_,
   {{0xfc530024,0x62d61118,0x87b39004,0x43a2e09f}},	//   _dostuna_, _negozio_, _שאנסן_, _klippe_,
   {{0xb1c3d0c5,0xe386012f,0x00000000,0x00000000}},	//   _говорит_, _boird_, --, --,
   {{0xb386d056,0x72016005,0x229181c0,0xa7e14143}},	//   _flera_, _daginn_, _garay_, _परार्थ_,
   {{0x2c763026,0xef516020,0xc73b2031,0x0af7c034}},	//   _मंत्री_, _클릭하시면_, _第二十九条_, _галерия_,
   {{0x2effc0cb,0x5be281aa,0xc31a401a,0xfa5c80fe}},	//   _مماثل_, _херцегов, _правообл, _হাঙ্গরিক,
   {{0x527ed1f8,0x56f6a035,0x00000000,0x00000000}},	//   _kroner_, _सुरवात_, --, --,
   {{0x9386d24b,0xc26c4147,0xc66730ca,0x425af047}},	//   _utorak_, _lumot_, _राजस्व_, _eagla_,
   {{0xa27e7056,0xc711e076,0x9d37f050,0xb2c1c00f}},	//   _denna_, _भद्दी_, _личност_, _millega_,
   {{0x22a5f021,0x9292620b,0x8ecbe11c,0x8ceab025}},	//   _станісла, _asrama_, _درگیری_, _पाठमाला_,
   {{0x827e0134,0xa303014e,0x12fcd09a,0xc27e70a1}},	//   _meini_, _malapit_, _luego_, _fenna_,
   {{0x33436175,0x6349f01a,0xb26d9056,0x926e60b5}},	//   _governo_, _resepti_, _resor_, _motory_,
   {{0x8226703e,0x890b10ea,0xe0e9d04d,0xcfb92271}},	// [300] _virkar_, _감사드립니다_, _とりあえず_, _métodos_,
   {{0x425db215,0x826c003e,0x468c628b,0x00000000}},	//   _sprendim, _arion_, _दुबार_, --,
   {{0x326c31be,0xec66b1c4,0x172b003b,0x486f00bf}},	//   _timoti_, _besteht_, _ekspertë, _abẹlẹ_,
   {{0xa26c20b3,0x00000000,0x00000000,0x00000000}},	//   _rukom_, --, --, --,
   {{0xd692e28c,0xa24a71ac,0x6f6c6131,0xcc7c528d}},	//   _navegaci, _permit_, _vacances_, _guardar_,
   {{0xf6a2601c,0xc01d003d,0x1290f063,0x8c0580c7}},	//   _pogledaj_, _もっと見る_, _achaba_, _massimi_,
   {{0x79f56076,0x4291503c,0x1c19b1eb,0x00000000}},	//   _tagów_, _badań_, _tekstą_, --,
   {{0x834010f6,0xcc0470a2,0x5c774024,0x96d3428e}},	//   _taberna_, _rođen_, _tutulur_, _मौखिक_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa2d9513e,0x326e6165,0x3686c0b9,0x00000000}},	//   _offert_, _deroga_, _hinderni, --,
   {{0xc3811088,0x12d450a7,0xd2cb8051,0x8471a0cd}},	//   _kanyang_, _ljudje_, _yarda_, _मशीनी_,
   {{0xcd9d700f,0x326fa052,0x7a0b0037,0xf2ebd213}},	//   _tunnista, _abaningi_, _surakart, _aibidil_,
   {{0x07534082,0xa27f00f9,0xbb35a1bc,0x96372021}},	//   _barnehag, _blanch_, _máquina_, _сарказм_,
   {{0xe5e80105,0x221d21aa,0xb2247061,0xb9774077}},	//   _silahlı_, _датум_, _tinka_, _valitett,
   {{0x53f470c2,0xc245a28f,0xd8ff40b3,0x00000000}},	//   _nostro_, _adultgui_, _raspolag, --,
   {{0xb2f180e2,0x00000000,0x00000000,0x00000000}},	//   _misingi_, --, --, --,
   {{0xf3415040,0x8b8c3290,0x525b41ab,0x02480104}},	// [310] _anderen_, _राजमा_, _quella_, _ndima_,
   {{0x01660008,0xb3eb80d8,0xa20c90aa,0x5291612f}},	//   _איתותים_, _sarta_, _herhangi_, _tagann_,
   {{0x625b8120,0x8b187070,0xc035f0c4,0xb035f11d}},	//   _parla_, _ingatlan_, _svetovej_, _svetovan,
   {{0xcc1670de,0x5394d122,0xcb7d30b5,0x9291508d}},	//   _मृत्युन्, _prosti_, _finanční_, _angase_,
   {{0x427e7039,0x3bd76186,0xc25b80e9,0x438691b2}},	//   _venni_, _जटायू_, _varla_, _xmary_,
   {{0xbdbf80cc,0x642e7291,0x81a4c006,0x500b904d}},	//   _פּרעזידע, _प्रतिभाग, _dokonać_, _質問投稿日時_,
   {{0x7567e0cc,0x227e7039,0x493f00ac,0xe0e1007b}},	//   _באַציִונ, _tenni_, _olimpiya_, _হেফাজতের_,
   {{0xe2cae039,0x320101e8,0x72fd60f7,0x00000000}},	//   _minden_, _dobije_, _leggen_, --,
   {{0x429110fb,0x190a7175,0x124a6008,0x0f81f1a3}},	//   _bacaan_, _последен_, _normal_, _धक्के_,
   {{0xa3eb9292,0x27c71293,0xd2915052,0xcc52c19c}},	//   _casta_, _начини_, _ungase_, _वारेन_,
   {{0x53949206,0x327f4148,0xb8542294,0x00000000}},	//   _siasa_, _dienst_, _קרדיטים_, --,
   {{0xa3658245,0xf9aac0c3,0x9fd780c1,0x2341c03b}},	//   _tangazo_, _ловим_, _pretože_, _komento_,
   {{0x127b71a6,0x0639303d,0xb2ea1074,0x0397c192}},	//   _komentář, _ブログ内検索_, _tarihin_, _medarbej,
   {{0x130da26b,0x025a9045,0xe764c00b,0xb9183071}},	//   _מייפל_, _skall_, _पौष्टिक_, _депута_,
   {{0xdc173099,0x28713293,0xd795d071,0xe290805d}},	//   _ukupnom_, _останат_, _лумина_, _kakano_,
   {{0x55da61e6,0x42000119,0xa27f7052,0x00000000}},	//   _проблемн, _amiin_, _amanga_, --,
   {{0xfeac106c,0x938ff00d,0x0249418c,0xf2bc604f}},	// [320] _aaarére_, _hanyuma_, _chemen_, _médias_,
   {{0x0f4680ac,0x3c7de059,0x12804078,0x800f3018}},	//   _konfrans_, _proseso_, _ajakaye_, _קוקסינלי,
   {{0x6e68c276,0xb39e10a2,0xf3fa11e9,0x12cad247}},	//   _pencerna, _stvaranj, _popull_, _chedo_,
   {{0x7200d02b,0x839d80f6,0xab0d80f6,0x0248d061}},	//   _toliau_, _proposam, _proposat, _tuomet_,
   {{0xc2cae02c,0x82e180de,0xcd033065,0xd3eae0e6}},	//   _niiden_, _चौबीस_, _أدناه_, _hinten_,
   {{0xc030c1e8,0xecf741dd,0x9fbff215,0xda749132}},	//   _prethodn, _sistemar, _асфальта_, _وضوابط_,
   {{0xb51e41e3,0xe320b202,0xc14ec047,0x957c200c}},	//   _enhliziy, _precios_, _dealramh_, _bankası_,
   {{0x9b5c4295,0xb2d90011,0x43940172,0x6cd34098}},	//   _političk, _arbete_, _azise_, _kvalitě_,
   {{0xc27f021b,0x62b47296,0x13eb8116,0xe2fc50d1}},	//   _abantu_, _cinco_, _karto_, _richtig_,
   {{0x53ebe211,0x32925037,0x3c60f0f7,0x52025099}},	//   _hatte_, _istana_, _minuten_, _istina_,
   {{0x1519f175,0xedbce00d,0xb26cf297,0x597a61e6}},	//   _рецепта_, _athanase_, _tugon_, _продемон,
   {{0x12494211,0x726de11d,0x025a6122,0xce43114e}},	//   _themen_, _letos_, _okoli_, _kalagaya,
   {{0x6e53218a,0xd2a6608d,0x7b83e030,0x00000000}},	//   _sumbanga, _hlobo_, _दुसमन_, --,
   {{0xb33c207a,0xd2da70af,0x9c922078,0x1d28c02a}},	//   _слёзы_, _besede_, _adahunṣe_, _андрій_,
   {{0x5f25b1b3,0x4a6a21de,0x93ced24a,0xc29590c8}},	//   _selecion, _प्रशस्त_, _reeve_, _स्लोली_,
   {{0x83ead036,0x101fa1c9,0xc1dcd0a2,0x530ca075}},	//   _mentre_, _endereço_, _istovrem, _geraint_,
   {{0xd2918297,0x19f9e054,0xfc7ca1c0,0x1f2bb065}},	// [330] _siyang_, _tavalise, _seksyon_, _انتهاء_,
   {{0xbe19f09b,0x030de084,0x4399c27e,0xee96d132}},	//   _menemuka, _sekadar_, _læste_, _خرطوم_,
   {{0x82cae016,0xdf4db0cc,0x2212b154,0x5236c298}},	//   _vendet_, _מיזרח_, _machi_, _biljke_,
   {{0xf386d299,0xd26dc1c4,0x22903055,0xa2243155}},	//   _flere_, _bevor_, _samayn_, _dimkpa_,
   {{0xfdbca14e,0xe40490a4,0x1b114232,0x3f80b192}},	//   _pilipina, _जोरदार_, _kampanya_, _placerin,
   {{0x2aeb30f6,0xcf91f074,0x02926101,0x00000000}},	//   _horregat, _rundunar_, _laraba_, --,
   {{0x5c05a0b5,0x5ea6a082,0xa2fc7104,0xc3ea60e3}},	//   _rubriky_, _fortsatt_, _zungu_, _vyote_,
   {{0x53ebf033,0xbd8d500d,0xd097e1ab,0x5690709f}},	//   _haute_, _demokara, _франция_, _landbouw,
   {{0x02f7c179,0xdc7510d2,0xcdd041b2,0x6be2b032}},	//   _никогда_, _ernstig_, _motherna, _величест,
   {{0xf35f3047,0xef41c098,0x4fd2b0a6,0xf3bfc071}},	//   _taighde_, _prosince_, _सारगर्भि, _аменда_,
   {{0xb63361a4,0x22d4c1a4,0xa2240106,0x54d6e098}},	//   _stanovni, _priliku_, _антирусе, _बिनिमय_,
   {{0x5340a0c2,0xd1ad70a5,0x00000000,0x00000000}},	//   _diventa_, _kazandır, --, --,
   {{0xc2267225,0x426d8099,0xb0b180b5,0xcc3af098}},	//   _virker_, _otrov_, _optimáln, _समायोजन_,
   {{0x0151307f,0xfb5c41a4,0x427e71c4,0xf4df013b}},	//   _струс_, _političa, _kennt_, _法定代表人_,
   {{0xa2cb4247,0xf2fce185,0xf519018c,0x026321b8}},	//   _midday_, _pengen_, _eternulo_, _вложения_,
   {{0x7c5e6080,0x5c7c729a,0xcdae612b,0x12a60004}},	//   _portál_, _glasova_, _portálu_, _פיעסעס_,
   {{0x150bf097,0xc0480047,0xa6f80047,0xb2f7d0ca}},	// [340] _postavio_, _موضوعي_, _موضوعك_, _उजुरी_,
   {{0xe5b1910b,0x10951024,0x8c0d71fd,0xf301e074}},	//   _technoló, _hadisələ, _tampere_, _matakai_,
   {{0xc77f5031,0x127e022f,0x7bfd51bb,0x38a3b065}},	//   _请输入上图中的验, _ating_, _balandži, _بينهما_,
   {{0xd3eb81a3,0x22ecb008,0xdf1e0004,0x7e579182}},	//   _warto_, _למכשירים_, _רוסישער_, _металург_,
   {{0x7305c037,0x96d6204d,0x9292114f,0xe248e008}},	//   _اوراق_, _に示すように_, _mapato_, _animal_,
   {{0xabf511a6,0x03eb91a4,0xd26cc25b,0x7349e084}},	//   _produktů_, _zasto_, _komoly_, _bererti_,
   {{0xdb43c0cb,0x246140f8,0x32926135,0x328c117f}},	//   _اُردو_, _baldintz, _sprava_, _uhakika_,
   {{0xf3eb812c,0x827e022b,0xef4e007f,0xd3cec156}},	//   _carte_, _beint_, _persoane_, _jedva_,
   {{0x01013017,0x38ab7031,0x6bfb7031,0x49db7031}},	//   _свети_, _第二十一条_, _第二十三条_, _第二十七条_,
   {{0xaad7129b,0xe2eb1034,0x8490e1d3,0xef4251da}},	//   _litterat, _periodo_, _गनीमत_, _trasport_,
   {{0x828d4036,0x2dafd0a2,0x8225501f,0x00000000}},	//   _appartam, _smatraju_, _liekas_, --,
   {{0xd25ad0c4,0x1386d1cf,0x1a0801a7,0x6e7161d5}},	//   _biely_, _acordo_, _verbesse, _bọros_,
   {{0x39d0a143,0xc386615a,0xdfe82025,0x6a02a116}},	//   _investee, _moord_, _रिलायंस_, _magalada_,
   {{0x42fba0c2,0x5291f08d,0x0b6d3099,0x7b6e7065}},	//   _потребит, _bazama_, _razmiric, _postála_,
   {{0x325b6111,0xfdd0c0f3,0xab61418d,0x00000000}},	//   _anglii_, _острови_, _billiger, --,
   {{0xd386609f,0x026d8006,0xf26891e3,0x00000000}},	//   _noord_, _stron_, _okuningi_, --,
   {{0xe2075271,0x025b8100,0x803301c9,0x632470cb}},	// [350] _democrát, _varle_, _postagen, _nézni_,
   {{0xc905800b,0xe3eae070,0xa178c0bd,0xaf602221}},	//   _sekaligu, _mintha_, _rechèch_, _divadeln,
   {{0xc2cb829c,0x7ad630ca,0x0d0a1108,0x22da5086}},	//   _tarde_, _कच्ची_, _तत्वाधान_, _intego_,
   {{0xb2b47047,0xc2eb5087,0x9049f0b9,0x97e6c267}},	//   _rince_, _orjinal_, _weerstan, _abapolii,
   {{0x8c00d11c,0x02ec0030,0x1a8cc194,0x326d613a}},	//   _دخالت_, _भाषीय_, _retnings, _dogodi_,
   {{0xeb42c175,0x539661df,0x0c0bd092,0x7989e27e}},	//   _екипи_, _omusha_, _najbližš, _forholde,
   {{0xcc77405a,0x06d2b041,0x5db42065,0x30443025}},	//   _cyumweru_, _धादिङ_, _موقوف_, _ग़ालिब_,
   {{0x8290c17d,0xa26c7099,0x5be0e29d,0x00000000}},	//   _eiland_, _punom_, _entender, --,
   {{0xac5c2008,0xa283f0c4,0xf380013b,0x5425414d}},	//   _ספונטני_, _funkcia_, _常州组织工作_, _dezinfik,
   {{0x427ee13e,0x627f709e,0x03656034,0x3e3b2100}},	//   _kvinna_, _imanza_, _съвремен, _remontas_,
   {{0x927f711a,0x538691d4,0x690cc02c,0xc2cbf136}},	//   _chante_, _claro_, _покупате, _grudi_,
   {{0x3321f247,0xad59a12f,0xd9dd81a4,0x2d70a24d}},	//   _abuyi_, _sainmhín, _zemljama_, _achmhasa,
   {{0x8532e03d,0xf27ed11e,0xb4a40018,0xd2df829e}},	//   _この回答へのお礼_, _kronor_, _באשדוד_, _misirdə_,
   {{0xfa8a9229,0xd202529f,0x0ebd0204,0x03ea614f}},	//   _августа_, _artigo_, _apsolutn, _nyota_,
   {{0xe291e0bd,0x53eac048,0xdb6e3017,0x83e5d0d3}},	//   _batay_, _tamtay_, _лиценцом_, _shocrú_,
   {{0x73f4618d,0x855320b7,0x00000000,0x00000000}},	//   _morten_, _андрееск, --, --,
   {{0xfb0ae2a0,0xe255d035,0xe08ae2a1,0x0759316a}},	// [360] _conselle, _यथादृश्य_, _concello, _मुस्लीम_,
   {{0x2d86504a,0xd2d8e202,0x9349e0c5,0x00000000}},	//   _permaina, _quiere_, _hotelli_, --,
   {{0x626de03d,0xe5374076,0x00000000,0x00000000}},	//   _netop_, _कस्बे_, --, --,
   {{0xe31a1147,0x4aea6081,0x16039045,0x4394d0c3}},	//   _sariling_, _fortelle, _поверх_, _piesa_,
   {{0xf26d00a9,0x82caf076,0xae0061ff,0xea54204d}},	//   _subota_, _nigdy_, _donderda, _検索オプション_,
   {{0xd2ce5054,0xf27f408d,0xd300c03a,0x2a09a286}},	//   _reklaam_, _kwenza_, _infatti_, _nezamest,
   {{0x437801c0,0x53f94105,0x02d462a2,0xae3b10ed}},	//   _subasta_, _ordusu_, _jorden_, _peratura,
   {{0x8394d15e,0x42926056,0xdd055143,0x5ba53013}},	//   _tiesa_, _totalt_, _populaar, _praktisc,
   {{0xd75c0004,0xb2b511bf,0x5a4a30c6,0xb2fcd1ef}},	//   _ספינקא_, _vendeve_, _परिषदको_, _grego_,
   {{0x101a20a2,0xf63eb0a5,0x00000000,0x00000000}},	//   _životinj, _hamileli, --, --,
   {{0xac4d7242,0xe8dce084,0xb49e60d4,0x7ae2e082}},	//   _privacy_, _bergantu, _apparenz, _fortsett,
   {{0xe24800a9,0x0c7e018f,0x02027160,0x00000000}},	//   _svima_, _harshen_, _scrios_, --,
   {{0xe386c081,0x00f2b263,0x4249412c,0x00000000}},	//   _aldri_, _सजावट_, _chemin_, --,
   {{0x9c499071,0x00000000,0x00000000,0x00000000}},	//   _реколта_, --, --, --,
   {{0xdc5bf0a2,0xad3e1008,0x99817175,0xb2cbf2a3}},	//   _postovi_, _שוטרים_, _equipame, _poslovi_,
   {{0x225ac0dc,0x22d051be,0xa075409d,0x2458f190}},	//   _fillon_, _achorom_, _उन्मुक्त_, _ikdienā_,
   {{0xa22a815b,0xd84381cd,0xff9451e6,0x00000000}},	// [370] _niemand_, _communau, _величезн, --,
   {{0x71541008,0x92ddc02a,0x228e1018,0x3ee0c1ab}},	//   _בניגוד_, _трохи_, _בודפשט_, _тегло_,
   {{0xe33d3132,0xe7e3c036,0x2afe80a4,0xfc60f1c7}},	//   _حیران_, _полиция_, _aparteme, _monumen_,
   {{0x8394e179,0xf2fc705d,0xdf3ab0d4,0x52fcf0fa}},	//   _toisen_, _kungi_, _sfortuna, _mugga_,
   {{0xd35bf17c,0xa96f106e,0xa2fc500c,0xf9667163}},	//   _उद्देश्य_, _abanigbe, _izinsiz_, _natoplje,
   {{0x72d9a1e7,0xbf79f170,0x1ad6a01c,0x5476b0f7}},	//   _revele_, _ježiš_, _čekajući_, _gisteren_,
   {{0x43cff150,0x42f12122,0xf104919b,0x00000000}},	//   _emuva_, _očitno_, _ارزانتری, --,
   {{0x9dafd020,0x53954092,0xf5d07190,0x0ad2f0d1}},	//   _가맹점가입안내_, _miesta_, _komentēt_, _gestalte,
   {{0x6201102e,0x4ceb3166,0x43fa602d,0xe87ba1ab}},	//   _mobilu_, _मुहम्मद_, _burung_, _известна_,
   {{0xb1e3c166,0xc26c4241,0x62cae1b5,0x79685049}},	//   _उतारा_, _samog_, _pandai_, _jednocze,
   {{0x32b491a4,0xdaf720c3,0xdfb59215,0x3394b2a4}},	//   _znaci_, _материй_, _блогеры_, _pjesme_,
   {{0x8033d175,0x53f470f7,0xce98c173,0x6386820b}},	//   _помогне_, _kosten_, _маршрута, _mahram_,
   {{0xc25b40ff,0x43a0b044,0x92c5c036,0x52d9a258}},	//   _nielen_, _máximo_, _чувствит, _types_,
   {{0x250b91b3,0xd233c03d,0xa27e7126,0xb3ebf071}},	//   _saturado_, _ショッピング_, _lenni_, _cauta_,
   {{0xc2b4d191,0xe224d100,0xdc1c0008,0x2c62b20e}},	//   _nieco_, _nieko_, _מפתחים_, _forrige_,
   {{0x1f697276,0x9758e0d6,0x00000000,0x00000000}},	//   _sembaran, _चमत्कार_, --, --,
   {{0xe1fd60d3,0xb2911118,0x626ab198,0xfc124038}},	// [380] _ballstái, _locale_, _učiniti_, _kampeni_,
   {{0x9047c017,0x52f0d058,0x83ea904a,0xba6e4092}},	//   _законом_, _viginti_, _nyata_, _profesia_,
   {{0xb3947206,0x09c7c061,0xe20da2a5,0x7cd94007}},	//   _jinsi_, _тамаша_, _ויקהל_, _akikanju_,
   {{0xe27f70cb,0x3afa221d,0x15268175,0xd486500f}},	//   _tegnap_, _razumije, _стабилно, _मुनादी_,
   {{0x327ee10c,0x23a37064,0x42bf1037,0x66828098}},	//   _bainne_, _suapan_, _اموال_, _तामाङ_,
   {{0xe25e201f,0xf3949047,0xb9b8a17a,0xa081f082}},	//   _ventspil, _miasa_, _ситуация, _інноваці,
   {{0xc3d12286,0xa3fb6011,0x631650ad,0x7b1fc19d}},	//   _história_, _människo, _halbuki_, _kematian_,
   {{0x03eb91ee,0x22d5a29e,0x739e10a2,0xe2a07100}},	//   _hasta_, _millət_, _otvaranj, _klubas_,
   {{0x33eb92a6,0x8ab42030,0x43dc42a7,0xb2d8e208}},	//   _kasta_, _चौकड़ी_, _kamwe_, _aineol_,
   {{0x12cac056,0xb30a10e8,0x818d1106,0x0ac980cd}},	//   _bilden_, _fotboll_, _алеӂе_, _रूपरेखा_,
   {{0x0386024c,0x1416a031,0x43947024,0x02b4707f}},	//   _toirt_, _依法追究刑事责任_, _cinsi_, _cinci_,
   {{0x4394902d,0xf0fe10cc,0x42d9a26d,0x3906b01a}},	//   _biasa_, _צוטאגס_, _typer_, _альтерна,
   {{0x73c70047,0x1a4350ea,0x00000000,0x00000000}},	//   _corparái, _찾아오시는길_, --, --,
   {{0x7b0350c5,0x6290c27b,0x9a968190,0xfc0c0053}},	//   _prosentt, _nalabo_, _novembrī_, _webshop_,
   {{0x162420a8,0xc200e0db,0x62da517b,0xeda2d070}},	//   _økonomis, _único_, _inteko_, _فائنل_,
   {{0xc7b52214,0x00000000,0x00000000,0x00000000}},	//   _blastosi, --, --, --,
   {{0x7d76d06a,0xef6f2035,0x8fd0b0c9,0xf3305068}},	// [390] _فرانس_, _कलादालन_, _postiže_, _makkelij,
   {{0xb27e80ca,0x00000000,0x00000000,0x00000000}},	//   _denně_, --, --, --,
   {{0x84873238,0x22e85122,0xc39570a4,0x573e8045}},	//   _स्टाइल_, _naslednj, _alasan_, _востаннє_,
   {{0x89e3c04e,0x14d4d1f4,0x226d80c5,0x12eb9099}},	//   _повара_, _कोचिंग_, _euron_, _velikom_,
   {{0x00f1112f,0xf4173123,0x00000000,0x00000000}},	//   _الطعام_, _menschen_, --, --,
   {{0x8d0f211c,0xb146f089,0x1cfdc017,0x916f3065}},	//   _بارسلونا_, _ingresso, _прича_, _نماذج_,
   {{0x7387019d,0x0ce4f098,0xb290f24d,0x737a2147}},	//   _syarat_, _podobně_, _triall_, _basahin_,
   {{0xf27f714f,0xfd81003b,0x33a01018,0xea0a6065}},	//   _mwanza_, _realizua, _מצליחה_, _معاينة_,
   {{0xa2e9e2a8,0xc7601020,0x9e75311f,0x8248000d}},	//   _peligro_, _크리에이티브_, _दिग्दर्श, _ndimi_,
   {{0xcceec017,0x28c351e6,0x3200a0a2,0x93d94006}},	//   _америке_, _генераль, _knjigu_, _tematów_,
   {{0x70723022,0x12139074,0x86aed088,0x2c4a3006}},	//   _sakamako, _dashi_, _nagustuh, _भावनाओं_,
   {{0x8a636062,0xd184124d,0xa106e133,0xd2026147}},	//   _интереса, _sheasamh_, _mechthil, _narito_,
   {{0x027f705f,0x00000000,0x00000000,0x00000000}},	//   _maande_, --, --, --,
   {{0xd27f72a7,0x1f628073,0x637902a9,0x00000000}},	//   _kwanza_, _संस्थाएं_, _basanga_, --,
   {{0x9bc7d0b6,0xb9e7d0c5,0x2e976084,0x7c5c104f}},	//   _продаж_, _продам_, _permohon, _gestion_,
   {{0x7200b2aa,0x3209d025,0x43dd905a,0xb2f312ab}},	//   _ridire_, _परिजनों_, _ruswa_, _bonitet_,
   {{0x4a3b21bc,0x3395403a,0x03957057,0x1a8fd051}},	// [3a0] _студии_, _questi_, _ulasan_, _ministan_,
   {{0x6197817a,0x637fd03e,0xeeb43190,0x437e600a}},	//   _групата_, _einasta_, _rezerves_, _professj,
   {{0xf20802ac,0xb3017186,0xc8caa2ad,0x8c0550e1}},	//   _informác, _स्निग्धा_, _статуса_, _choroby_,
   {{0xb2cbb0ac,0x9290b194,0xe4d7c173,0x2753e017}},	//   _haqda_, _vidare_, _балконы_, _рехабили,
   {{0x08fdd08a,0x73f9011c,0xf7beb031,0xc29092ae}},	//   _ফলাফল_, _gabung_, _违者本网将依法追, _omaan_,
   {{0xec527184,0x29cd32af,0x128f11df,0x825a922b}},	//   _amatora_, _ढाँचा_, _nochris_, _skalt_,
   {{0xe27f70f4,0xdfa112b0,0x93b1128c,0x14f8c13b}},	//   _mwanya_, _servizos_, _servizo_, _第四十二条_,
   {{0xcf0b0271,0xc3e5a03f,0x9c7250ff,0xd2a652b1}},	//   _promover_, _oktobrī_, _popradu_, _volba_,
   {{0xf2e8122e,0x637081be,0x3c537241,0xf542c0b7}},	//   _jacinta_, _anyanwụ_, _nastupa_, _бэрбэтес,
   {{0x50b5f025,0x5f628049,0x526df0de,0x00000000}},	//   _चाकुओं_, _संस्थाओं_, _autod_, --,
   {{0x62d462b2,0xb77b812f,0x668d6108,0x96cfb21f}},	//   _soudan_, _tromchúi, _बनवास_, _sigurtà_,
   {{0xb201807f,0xb25a9090,0x73431035,0x00000000}},	//   _scris_, _fjale_, _तिथून_, --,
   {{0x5e529020,0xd2fc9181,0x15ed70be,0xe2b4d0ca}},	//   _써브를시작페이지, _fragt_, _gorchymy, _dnech_,
   {{0x8a715136,0xb2f151a4,0x6b190141,0xa794125e}},	//   _članova_, _članovi_, _pasangan_, _mistoqsi,
   {{0x93947194,0x174c3065,0xefc00031,0xdf211036}},	//   _minst_, _العفو_, _提问者对于答案的, _dipenden,
   {{0x72cae0f7,0x8394d0c3,0x2c4cb041,0xc26c2051}},	//   _vinden_, _piese_, _partneři_, _makon_,
   {{0x32fc70e5,0x32cff031,0x426e60c2,0x348590de}},	// [3b0] _mange_, _只显示最新_, _parole_, _दिवाना_,
   {{0x62dab2b3,0x97280045,0xa5d62008,0x5224b0dc}},	//   _oktobar_, _продукці, _היועצים_, _dicka_,
   {{0x525bf1c9,0x62bb10c4,0xac77316d,0x884d22b4}},	//   _paulo_, _balenie_, _mensahe_, _destinos_,
   {{0xc37a7013,0x727ef01a,0x26ce6076,0x00000000}},	//   _betalen_, _kunnes_, _zapaleni, --,
   {{0xa3781116,0x2956a01a,0x00000000,0x00000000}},	//   _gacanta_, _sellaine, --, --,
   {{0xb9403070,0x080b90ca,0x32fc9232,0xab0ae004}},	//   _اپريل_, _समुद्री_, _irtibat_, _צוואנציג_,
   {{0x54dac229,0x7245812b,0x2d363126,0x6387f031}},	//   _можно_, _rámci_, _افروز_, _heure_,
   {{0x17a200fc,0x59d20153,0x468120ca,0xb477c061}},	//   _interesg, _interest, _ज्यान_, _манера_,
   {{0x286d72b5,0x02025112,0x2ebd7090,0x62a7c107}},	//   _personas_, _estivo_, _personat_, _мадона_,
   {{0x734c40ff,0xebf51061,0xa84440bf,0xd6ec2065}},	//   _francúzs, _produktų_, _ahàmù_, _وتصميم_,
   {{0xd26c201c,0xb9d7a0de,0xdc72c061,0x1503716f}},	//   _nakon_, _प्रयास_, _sportas_, _zastupao_,
   {{0x327e016e,0x23f4611a,0x42fc705d,0x6464d173}},	//   _duine_, _mouton_, _nange_, _дзень_,
   {{0x2280b0f9,0x2fc4c1f4,0x8fa0a19b,0x04852111}},	//   _diskite_, _अधकचरा_, _رجیستری_, _हैरानी_,
   {{0x02cbf0f8,0x7defd0ea,0xf394a22e,0x00000000}},	//   _gaude_, _하이파이브_, _tibsi_, --,
   {{0xc9b14255,0xbe714144,0xef2400a2,0x16db31da}},	//   _ostatní_, _ostatné_, _došao_, _densità_,
   {{0xcc93c047,0x517e01b8,0xf975d0de,0x00000000}},	//   _ساعات_, _поколени, _एसोसियेश, --,
   {{0xe2da600c,0xc250e12c,0xe8d0e12c,0x2458213b}},	// [3c0] _derece_, _directem, _directeu, _国家文物局_,
   {{0xf84c2020,0x950a416f,0xafcbc045,0xc72c02b6}},	//   _있었습니다_, _protivio_, _свободи_, _hemmelig,
   {{0xf604807b,0x44ce4017,0x60e4d23a,0x37b61143}},	//   _সাবস্ক্র, _написани_, _आईसीसी_, _unustasi,
   {{0x99fa41bf,0x03806054,0xedd9b173,0xedbfc2b7}},	//   _pershend, _suurem_, _схемах_, _marufuku_,
   {{0xbe0200f9,0x5b1c00ea,0x1c5321d7,0xee7c6196}},	//   _enteresa, _적극적으로_, _chatain_, _पॉर्न_,
   {{0xc61a7031,0xd19b528d,0x48d740cb,0xa2026051}},	//   _评论内容只代表网, _mercadol, _ناگزیر_, _yarima_,
   {{0x161fc116,0x5290b143,0x0493e045,0xd395000a}},	//   _muslimii, _endale_, _стратегі, _prassi_,
   {{0xcb9090cc,0xb4e800cc,0x222541ff,0x5fbd7078}},	//   _סטודענטן_, _טערמין_, _boeken_, _abaniṣer,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x927ed2b8,0x92786086,0x794e408f,0x4ae630fe}},	//   _kwenu_, _umunsi_, _質問した人からの, _সমবায়_,
   {{0xfbf1f108,0xd6d07176,0x8fe142b9,0x3248d154}},	//   _postitus, _जैविक_, _maskiner_, _chombo_,
   {{0xa1ff7215,0x6c381144,0xf35f10b5,0xffa15089}},	//   _papildom, _generáci, _objekty_, _intentar_,
   {{0xbcd32020,0xf291513b,0xff6092ba,0x435691cb}},	//   _부담하셔야_, _enfant_, _יאָאַכים_, _revenir_,
   {{0xd2365122,0xbb89d2bb,0x8ae6b01b,0x1a179018}},	//   _voljo_, _noviembr, _parlimen_, _calculat,
   {{0x1301f091,0x72017047,0x2e4e41e4,0x00000000}},	//   _paratoi_, _cnaipe_, _afragana, --,
   {{0xe38661d6,0x7f060031,0xd00b307b,0xc2331271}},	//   _dooro_, _采煤工作面_, _চাঁপাইনব, _formado_,
   {{0x8152113b,0x7294f267,0x2a2a6211,0x00000000}},	// [3d0] _已经本网协议授权, _ababazzi_, _maschine, --,
   {{0xf3c32047,0x52da52bc,0x326c20dc,0x3b8b0106}},	//   _عُمان_, _hotell_, _takon_, _асочиаци,
   {{0x32c381e8,0x23cf80a6,0x8bf7c0c3,0xdd5ac100}},	//   _ukoliko_, _terve_, _билете_, _болей_,
   {{0x72fc61a3,0x6950f104,0x427e60f7,0xa253a02b}},	//   _drogi_, _abalande, _stond_, _klientam,
   {{0xe33cc034,0x1a739198,0x226c22bd,0x1fd39018}},	//   _близо_, _obično_, _sakon_, _פנסיה_,
   {{0x88db1134,0xd6015008,0x9f4a22be,0x364cb2bf}},	//   _gwleidyd, _commerci, _रामधारी_, _मण्डल_,
   {{0x09b732c0,0x72fce2c1,0x127e91c7,0x00000000}},	//   _polasaí_, _stigla_, _etang_, --,
   {{0x0e553234,0xa68c615c,0x73ced1f5,0xd2da6153}},	//   _महत्वपूर, _दुलार_, _leevi_, _reports_,
   {{0x67a8207f,0x0c70a026,0x1201f2b2,0xe2947170}},	//   _februari, _मुर्गा_, _muziko_, _funkcii_,
   {{0x93fac034,0xc3a290bf,0x726dc0eb,0xaf83c0cd}},	//   _вторник_, _ipapo_, _prvog_, _लश्कर_,
   {{0x658ed105,0xdc7102c2,0x00000000,0x00000000}},	//   _akademiy, _मान्छे_, --, --,
   {{0x525a01b1,0xa292705d,0x330cc057,0x83eb7089}},	//   _exile_, _masaka_, _isyarat_, _teatre_,
   {{0x199900a9,0x726d1136,0x79f2c1d7,0x9ec5c050}},	//   _traži_, _guzom_, _acarsaid, _славни_,
   {{0x89e5508d,0xeae2f0a9,0xb41fe01c,0x888fe29e}},	//   _indodana_, _pretpost, _psiholoz, _psixolog,
   {{0xbef08061,0xed8860d8,0x1a6700ea,0x5c6bc26d}},	//   _elektrin, _penerbit_, _드리겠습니다_, _akkurat_,
   {{0x020801ef,0xf2a69206,0xac615016,0x521c61b2}},	//   _informát, _klabu_, _situata_, _nathis_,
   {{0x626ca205,0x437d4093,0xb224028f,0xeb564119}},	// [3e0] _lubos_, _japanse_, _chike_, _khatarta_,
   {{0x126d8248,0xce1b6276,0xfbf130cb,0xb2fa005d}},	//   _otros_, _singkata, _بھگدڑ_, _abahaya_,
   {{0x729b713f,0x406da008,0xacbec061,0xba34d04d}},	//   _linkhay_, _הסיבה_, _самец_, _をご覧ください_,
   {{0x03fc11da,0x2d03803e,0x6c2be2ad,0xec6c1008}},	//   _naturali_, _bolungar, _ставили_, _natural_,
   {{0x63eae2c3,0x738d606a,0xe27c213f,0x82e06193}},	//   _lantai_, _kulturál, _lênin_, _jednako_,
   {{0x00e1a018,0xdaecd018,0x00000000,0x00000000}},	//   _לדאוג_, _accessib, --, --,
   {{0x125af159,0x22da7056,0xa395406c,0xa3ebe267}},	//   _lailai_, _adress_, _elesin_, _batta_,
   {{0x5faa5031,0x73cf01c9,0xf13ba018,0xfdebe14d}},	//   _字母不区分大小写_, _gravar_, _ללחוץ_, _стварно_,
   {{0x87d0d07a,0x726cb2a3,0x33545070,0x414581fb}},	//   _снегу_, _radova_, _بہتیرن_, _בושות_,
   {{0x32cbf03f,0xaf945159,0x00000000,0x00000000}},	//   _nauda_, _adéye_, --, --,
   {{0x77fd0047,0x4b2ad13c,0xb051d05e,0x62d8d21b}},	//   _اتفاقية_, _сцене_, _panginoo, _kunene_,
   {{0x52fc91b2,0x43e58076,0xcff79018,0xb26c503b}},	//   _iragi_, _wątek_, _בעתיד_, _kalon_,
   {{0x74d690ca,0xfb2b21ce,0x7f8a6004,0x00000000}},	//   _मिडिया_, _paradics, _פֿעסטיוו, --,
   {{0x62d85039,0x8373a0af,0x6076112f,0x00000000}},	//   _meleg_, _domače_, _seapáini, --,
   {{0x23869056,0x62bbd0b9,0x5dd2d01a,0x25042133}},	//   _klart_, _bekende_, _стало_, _ciallach,
   {{0x02fd7047,0xc3f1a03c,0x5b26c229,0x3631e0f8}},	//   _leagan_, _मध्यस्थत, _одном_, _aplikazi,
   {{0xee5180a4,0x803731ab,0xc30eb056,0x219c1018}},	// [3f0] _काव्यप्र, _ristoran, _betalar_, _ולפגוש_,
   {{0x13875049,0x665d4025,0x6202611c,0x36839002}},	//   _oferty_, _समाधि_, _miring_, _दालान_,
   {{0x32b1e101,0x0292718f,0x32926119,0x32fca1bc}},	//   _bindiga_, _fasaha_, _yaraan_, _pedidos_,
   {{0x0c835065,0x022501e7,0xcf5bd057,0x6379509e}},	//   _بصراحة_, _shakur_, _bahagian, _batanga_,
   {{0x62fd710c,0xa3ebf022,0x1b26c13c,0xe3dc01d2}},	//   _beagan_, _bauta_, _одбор_, _kaiwa_,
   {{0x427e912f,0x87aa90fe,0x8394208d,0x00000000}},	//   _seans_, _খোমেনী_, _unksz_, --,
   {{0x11cc303b,0x6f1fa2c4,0x0ff31006,0x7212d1b2}},	//   _policisë_, _vurderin, _कलाकारों_, _neohom_,
   {{0x3aa1c09d,0xeeefc0eb,0x00000000,0x00000000}},	//   _licytuje, _одобри_, --, --,
   {{0x726c50a0,0xa378614e,0x23dd9069,0x1019b0cb}},	//   _galon_, _maganda_, _ntsws_, _پروٹیز_,
   {{0xcf33c08a,0x43b9a2c5,0xb9572179,0x6417f0fc}},	//   _presenta, _serveru_, _edelline, _horrekin_,
   {{0xa2926088,0x62b63106,0x9a4f4052,0x00000000}},	//   _paraan_, _антериор_, _haleluya_, --,
   {{0x84b3a11c,0xe394700d,0x240e72c6,0x4c8e7062}},	//   _تمرینات_, _minsi_, _zadržana_, _zadržava_,
   {{0xc26c5116,0x32ca718b,0x785e104d,0x2da11054}},	//   _kaloo_, _myndi_, _産学連携本部_, _fotograa,
   {{0xf30a5230,0x206d8140,0x0224c247,0x00000000}},	//   _najnovij, _propisan, _chokwa_, --,
   {{0xe48741f4,0x526d8229,0x08dd903d,0xb201a0b3}},	//   _नाजायज_, _euroa_, _ベストアンサ_, _novine_,
   {{0x69bce0c2,0xe540912f,0xd1868170,0x43806269}},	//   _коментир, _النجاح_, _otvoriť_, _suurim_,

   {{0x534550a9,0x53a1d02c,0x147d92c7,0x00000000}},	// [400] _spadaju_, _kaupunki_, _नमुना_, --,
   {{0xd48520de,0xc2fc7051,0x910310a2,0xb98310a2}},	//   _संपादक_, _zanga_, _građana_, _građani_,
   {{0x1097e077,0x03eb9006,0x2677203d,0xac5280f9}},	//   _времени_, _listy_, _高等専門学校_, _haitian_,
   {{0x039501f1,0xa0ce70eb,0x0830f028,0x127e0008}},	//   _časti_, _sadržaja_, _termaktu, _bring_,
   {{0xa72c12c8,0x05b8f13b,0xd3795074,0x00000000}},	//   _miloševi, _元以下罚款_, _kudaden_, --,
   {{0xa145219c,0xf9836143,0xfd165008,0x1200d131}},	//   _materjal, _konkreet, _insuranc, _milieu_,
   {{0xc27e60f5,0x2224017f,0xf378605d,0x11bc1117}},	//   _huong_, _usiku_, _baganda_, _täynnä_,
   {{0xd2cb4068,0x5d00c0fe,0xf4a68196,0x00000000}},	//   _bieden_, _পরাজিত_, _सौराष्ट्, --,
   {{0x4394d0ff,0x1a897185,0x7a5d219d,0xf00ed0a2}},	//   _miest_, _jaringan_, _diterima_, _ostvaren,
   {{0x7c69f2b2,0x3948f06f,0x03c87054,0xeb739099}},	//   _burundi_, _комплект_, _tervis_, _uslugama_,
   {{0xa2b581ab,0x175d00da,0x5236d1c6,0x427ef099}},	//   _circa_, _कार्ड्स_, _projek_, _skinem_,
   {{0x6e4242af,0x49c192c9,0xd25ae0c5,0xa2fc724a}},	//   _संस्थाहर, _साँचो_, _meille_, _xanga_,
   {{0x6c5a5083,0x4f859018,0x227e616d,0x72d301a1}},	//   _menteri_, _מורשה_, _nuong_, _mestilah_,
   {{0x434d525a,0x00000000,0x00000000,0x00000000}},	//   _महसूस_, --, --, --,
   {{0x742a601a,0x620140c4,0x253b919d,0xd06db067}},	//   _правильн, _vidiet_, _menyatak, _फारसा_,
   {{0x627e614e,0x7b19719e,0xc189705e,0x72926037}},	//   _buong_, _barangan_, _barangay_, _pirang_,
   {{0x72d820c3,0xb7bbb008,0x8226d065,0x13788105}},	// [410] _camere_, _בפועל_, _مراكز_, _kazanda_,
   {{0x12d94116,0x6c4b1102,0xe394d03f,0xe2bbe137}},	//   _sheego_, _bintang_, _viesu_, _nijedne_,
   {{0xc2d85039,0xc394017f,0x00000000,0x00000000}},	//   _veled_, _raisi_, --, --,
   {{0xf26df0c5,0x2c621024,0xd3940077,0xb22401a2}},	//   _auton_, _forumun_, _saisi_, _saiki_,
   {{0xae38f0e6,0x64872290,0x52025008,0xb27e60b2}},	//   _veransta, _निभावत_, _entire_, _guong_,
   {{0x225a3156,0x1121b06e,0x00000000,0x00000000}},	//   _zemlju_, _akilápá_, --, --,
   {{0xe225504d,0xc27e0089,0xc92c30bf,0x4d5ab1c1}},	//   _でご注文いただく, _quina_, _aimuṣiṣẹ_, _फर्निचर_,
   {{0x93a92008,0x427ee25d,0x32ee92ca,0x22026119}},	//   _private_, _seinna_, _agafe_, _arrimo_,
   {{0xc27e6048,0x608c0065,0x73fe113b,0x5290f241}},	//   _xuong_, _بيقولوا_, _日一周时政要闻_, _nemaš_,
   {{0xa59c9031,0xde9b1042,0xb7aa60b9,0x927f012c}},	//   _修改删除记录_, _bindings_, _letterli, _grands_,
   {{0x585c9077,0x598e1175,0x00000000,0x00000000}},	//   _maalisku, _нации_, --, --,
   {{0x23eaf2b4,0x90b2d1f9,0x459ef03d,0xaae3e175}},	//   _editar_, _পল্লী_, _クレジットカ_, _интереси,
   {{0xf22b41f1,0x5313109a,0x72d80036,0xe27e92cb}},	//   _upraviť_, _cambiar_, _красавиц, _saknar_,
   {{0x32365136,0x7f16515b,0xbcaba2cc,0xa46161dd}},	//   _bolji_, _maatskap, _menyadar, _hondartz,
   {{0xb2001158,0x24f8520d,0x1ee7b13f,0x32ebb1a1}},	//   _lehin_, _otomobil_, _vnsharin, _fizikal_,
   {{0x5ac05054,0x4290a163,0x62efe1b4,0xd3797142}},	//   _pakkumis, _izjavu_, _menimpa_, _ukrajna_,
   {{0x63dc2172,0x00000000,0x00000000,0x00000000}},	// [420] _bakwa_, --, --, --,
   {{0x73f46146,0xc9c4b128,0x0b2f40c5,0x5b643024}},	//   _nettet_, _rezervat, _varastos, _fondunun_,
   {{0xb24a52cd,0x8e95a004,0xa575b050,0x00000000}},	//   _resolusi_, _צופרי_, _utilizaç, --,
   {{0x52fce1c5,0xcea1f2ce,0xfde7f1bc,0x6829e208}},	//   _tinggi_, _posljedn, _личните_, _thàinig_,
   {{0x32cb7072,0x41b3d17a,0x53f871d9,0xb2fc50de}},	//   _stadig_, _доволен_, _genug_, _valge_,
   {{0xa27e91b1,0x405782cf,0x33807002,0xd7af70a0}},	//   _muang_, _inostran, _korras_, _gynullei,
   {{0x217d82d0,0x5ae53128,0x2c7d60e9,0x00000000}},	//   _דיעות_, _sigurant, _pressan_, --,
   {{0xd341e049,0x13c1302c,0xf365905e,0x00000000}},	//   _allegro_, _сведения_, _pangako_, --,
   {{0x876131aa,0x922410b5,0xc30df02b,0x9d1bd13b}},	//   _двери_, _regionál, _nekilnoj, _peinture_,
   {{0x32d8715e,0xf27e00b3,0x244240ea,0xf27e70a1}},	//   _tvnet_, _brine_, _사회복지과_, _munne_,
   {{0xa9803190,0x675ce1c6,0xfee03190,0xdba03061}},	//   _konkursa_, _kakitang, _konkurss_, _konkurso_,
   {{0x44303268,0x12001187,0x13203236,0xd3aac2d1}},	//   _concurso_, _behin_, _concurs_, _dozvole_,
   {{0xec68d056,0x9c361177,0xcad730f8,0x91c6b1ea}},	//   _augusti_, _grantiau_, _bistarat, _postopek_,
   {{0x3d88204d,0xeeed5269,0x00000000,0x00000000}},	//   _質問者のみ_, _salvesta, --, --,
   {{0x026d90c4,0xa57cc04d,0xad1372d2,0x058071a1}},	//   _kusov_, _ジに対するお問い, _kunstner, _televisy,
   {{0x59b96032,0x927f4206,0x52d870c5,0xb246c02b}},	//   _растител, _kwenda_, _menee_, _аднак_,
   {{0x92fc71df,0x9c7d6077,0xad60714c,0x9290c1e2}},	// [430] _yango_, _viestin_, _इन्स्टाल_, _halako_,
   {{0xf201e039,0xf3648147,0x4cec1017,0xa27ed0d2}},	//   _akció_, _tingnan_, _компаниј, _weens_,
   {{0xfbf8308a,0x1f71c031,0xfc91e23b,0x1b8a125c}},	//   _নেটওয়ার্, _concours_, _अवरोध_, _fronteir,
   {{0x8d3c3096,0x3c6541be,0x00000000,0x00000000}},	//   _velikost_, _buruzie_, --, --,
   {{0x803dc0ea,0x626ff12e,0xe7e1f108,0x674de08f}},	//   _mogelijk_, _tvrdošín_, _अर्धांगि, _マンスナイプ_,
   {{0x026c207e,0x801db24a,0x16973055,0xd387726b}},	//   _lemond_, _tradisyo, _bartamah, _charge_,
   {{0x227f700d,0x259b31dd,0xae1ce085,0x0d127004}},	//   _ibanze_, _horrelak, _pergunta, _אַביסל_,
   {{0xd27e7045,0x6d22b006,0xab08504d,0x0aaae0de}},	//   _kunne_, _zagranic, _アルバイト_, _पहिलहीं_,
   {{0xa2ad112f,0x627872d3,0x214c31a5,0x05b350b7}},	//   _مليار_, _barnet_, _cinephil, _бэрбэтеш,
   {{0x7200c2d4,0x826d8002,0x93878002,0x6366f175}},	//   _online_, _eurot_, _korra_, _реалност_,
   {{0xbdc5e18c,0x5290500c,0x4b68413f,0x68e2f0c3}},	//   _elektora, _emlak_, _enlefzin_, _депутаци,
   {{0x85845144,0xc0f0707b,0x748602d5,0xc9d8517f}},	//   _fotogalé, _নিখোঁজ_, _ड्रामा_, _kutekele,
   {{0x6303f20d,0xf2ebc0fd,0xe30da0b2,0xf17360c4}},	//   _teknoloj, _kvinner_, _pokézoo_, _pomníky_,
   {{0x32e5e2c6,0xc6d380c3,0xd67271b2,0x00000000}},	//   _hronika_, _пенализа, _waldensi, --,
   {{0x3c6a82d6,0xb2f45047,0x3200211d,0x3d98e179}},	//   _चिन्ता_, _chuntas_, _cekin_, _начинающ,
   {{0xe343b12f,0x02a06193,0x9f239271,0x78c391d4}},	//   _بتوقيت_, _ljubav_, _conectan, _conectad,
   {{0xabfa52d7,0x6af91119,0x5e73c13b,0x36c6425a}},	// [440] _vietcomb, _carruurt, _构建社会主义和谐, _अज्ञानता_,
   {{0x9b5a725a,0x00000000,0x00000000,0x00000000}},	//   _मिर्जापु, --, --, --,
   {{0x237b9147,0x3271b0b0,0xd3484035,0x00000000}},	//   _malalim_, _mabinogi_, _seleksi_, --,
   {{0xd2fc7181,0x02a0a0ea,0x00000000,0x00000000}},	//   _gange_, _궁금합니다_, --, --,
   {{0xe27e90f5,0xfe70b108,0xa4b5b006,0x02ee90dc}},	//   _quang_, _कुम्भ_, _poradnik, _stafi_,
   {{0x7e2631bb,0x2277d03c,0x85f63221,0xcefdc065}},	//   _сайтам_, _maksymal, _veteriná, _الرغم_,
   {{0x82fc70a1,0xd2da6060,0x89d9303e,0x4394203f}},	//   _bange_, _kereke_, _seinasta_, _maksu_,
   {{0x468c10cb,0xae56b12c,0x89727017,0x52b4d03c}},	//   _mindenki, _dimanche_, _редакциј, _niech_,
   {{0x5f4e004f,0x869790fd,0x8349e1d6,0x0c7390cf}},	//   _personne_, _видань_, _adreesi_, _kadrlar_,
   {{0xde1dd07b,0xd2fc705d,0xf27e90ed,0x32f30185}},	//   _দাপ্তরিক_, _wange_, _ruang_, _kalimat_,
   {{0x2d7dc00b,0xf3a3f076,0x5c60526c,0x952480ea}},	//   _bermanfa, _grupy_, _sigurta_, _롯데캐슬비치_,
   {{0xec5b80b5,0x33ce90fa,0x81652017,0x73e2d02a}},	//   _dostali_, _agava_, _одсто_, _відразу_,
   {{0x69fe60f8,0x052c5223,0x6e169036,0x905e603b}},	//   _ekonomia_, _प्राथमिक, _значение_, _ekonomik_,
   {{0x9b73e106,0x02fc705d,0x72eb2046,0x709260fe}},	//   _ротару_, _zange_, _digidol_, _ইউসুফ_,
   {{0xb60de025,0x16d5c055,0x2588d033,0xf2fc71f5}},	//   _बांदा_, _saraakii, _activité, _yange_,
   {{0xdf0120de,0xa477a0c5,0xdf7f4136,0x322582b6}},	//   _अंग्रेजी_, _проекты_, _aktivnoš, _virke_,
   {{0x8381b140,0xec55b294,0x00000000,0x00000000}},	// [450] _verziju_, _instead_, --, --,
   {{0x13ead230,0xb2f520d3,0x22902037,0x4200203e}},	//   _protiv_, _laistigh_, _tekan_, _tekin_,
   {{0xa2c94091,0x62a0a0ea,0x061f200e,0x1c3040fe}},	//   _pellach_, _제공합니다_, _abaneesi, _পেঁয়াজ_,
   {{0x4e452102,0x029020a4,0x220020f6,0x0ad232d8}},	//   _pelangga, _rekan_, _rekin_, _šampiona_,
   {{0xc2137084,0x5601503d,0x40760190,0x3200201a}},	//   _arahan_, _kommerci, _aksesuār, _sekin_,
   {{0xeceb8291,0x0e964033,0x1486a2d9,0xb2efc144}},	//   _अधिकतर_, _gratuite_, _ल्याउन_, _komisia_,
   {{0x628611fb,0x5f46311a,0xd2d76136,0x00000000}},	//   _לשונות_, _aristide_, _odvojio_, --,
   {{0x13946153,0x0367c07b,0xc2fa01f5,0x1349e142}},	//   _those_, _দুঃখিত_, _swahaba_, _stretti_,
   {{0x794f702e,0xef77a19b,0x2d57c017,0x735431e1}},	//   _samostat, _کیبورد_, _назван_, _galegas_,
   {{0xa3be61c7,0xb17f2175,0x4db5404a,0x1ba960a4}},	//   _privasi_, _ученицит, _meningga, _karyawan_,
   {{0x8b8b816c,0x9c27a0c3,0xa2b44170,0x11455059}},	//   _timisoar, _примиря_, _ramci_, _espesyal,
   {{0x8a69f034,0xeb4210b5,0x63797099,0x7bd1607f}},	//   _финансов, _doporuču, _boravka_, _conducer,
   {{0xa3eb9041,0x02d55080,0xd7c0613b,0x00000000}},	//   _byste_, _levoča_, _抗震救灾特别专题_, --,
   {{0x740012ae,0x1ec3f0ca,0x52d94055,0x4256d07b}},	//   _песни_, _राजकुमार, _sheeko_, _ডিগ্রী_,
   {{0xd431e006,0xd2904101,0xa301e0e1,0x9e51e1a3}},	//   _ostatnio_, _neman_, _ostatni_, _ostatnie_,
   {{0x202ed100,0x8212b24c,0xbc27a175,0xf5d2e03b}},	//   _назву_, _eadhon_, _примери_, _studentë,
   {{0x9303014e,0xac765100,0xaeec4031,0x751cf166}},	// [460] _salamat_, _forumas_, _编译或摘编自其它, _प्रणब_,
   {{0x52e96252,0x7a896252,0x49f96252,0x00000000}},	//   _arrinta_, _arrintan_, _arrintaa_, --,
   {{0x52926252,0xa2b470ef,0x00000000,0x00000000}},	//   _karaan_, _sincs_, --, --,
   {{0x41ecd076,0x22fce19b,0xf2d90218,0x00000000}},	//   _हाथरस_, _nangis_, _arbeid_, --,
   {{0x129020a2,0xa3cf0171,0x434c2286,0x00000000}},	//   _rekao_, _suaves_, _cestovné_, --,
   {{0x99fa30ae,0x02d8e208,0x2e389043,0xe2005134}},	//   _starptau, _juneau_, _irenaeus_, _melin_,
   {{0xa13f30f5,0x85aa5037,0xdd2f013b,0xf87b8094}},	//   _kemulato, _pengaruh, _arrière_, _קלונימוס_,
   {{0x04363274,0x56ae807b,0x6ac80004,0x00000000}},	//   _praktick, _বেসামরিক_, _בערלין_, --,
   {{0xf87cc045,0x3c493236,0x00000000,0x00000000}},	//   _поставле, _circulac, --, --,
   {{0xb349c0d4,0xc2ac402a,0x868cc002,0x4c0fb24c}},	//   _livelli_, _контроль, _नादान_, _uaigneac,
   {{0x239590a6,0xad73a017,0x3b8091c7,0x225a9007}},	//   _sisse_, _познато_, _دورتموند_, _ajala_,
   {{0xbb343229,0x5394b0b9,0xe3d5b02b,0xa290505e}},	//   _интересн, _meeste_, _platinti_, _kelan_,
   {{0xfb1c209a,0x5db792da,0x72d551c0,0xee96d19b}},	//   _respuest, _заводы_, _istorya_, _برروی_,
   {{0x1d032037,0x52b1d2db,0x82d89046,0x8aa5c124}},	//   _خدمات_, _टेबुल_, _adael_, _gurigiis,
   {{0x4401a215,0xb55dc117,0x3c7622dc,0x1952618d}},	//   _аспекты_, _вполне_, _मुल्ये_, _billigst,
   {{0x427e905e,0x39e4a03d,0xe2b182dd,0x52c53222}},	//   _ngang_, _ありがとうござい, _pridala_, _ionline_,
   {{0x484ed227,0x324bd0e1,0xfc124154,0x929042de}},	// [470] _publicid, _ट्रेलर_, _kampuni_, _zeman_,
   {{0x71a41004,0x54e2107b,0xa2fe725d,0x7c76805c}},	//   _שניאור_, _নওগাঁ_, _margar_, _नवग्रह_,
   {{0xd17db008,0xed732210,0x00000000,0x00000000}},	//   _ריהוט_, _posmatra, --, --,
   {{0x9387e282,0x4224d1df,0x7c14313b,0xc26cc0bd}},	//   _votre_, _bheka_, _没有相关文章_, _padon_,
   {{0x71f3c0c3,0xc2d912df,0x18c40025,0x42005124}},	//   _войник_, _emberi_, _ओलंपिक_, _celin_,
   {{0x329040a4,0xe9c2f08e,0xe2fc704e,0x3713b04d}},	//   _teman_, _vrednost, _langa_, _アビシニアン_,
   {{0x0305a0d8,0xe15790de,0x73162043,0x935b8113}},	//   _dimasak_, _मल्लाह_, _xubntiag_, _zeemzeeg_,
   {{0x92fc725d,0xe9c9b136,0x72005075,0x00000000}},	//   _ganga_, _odgovara_, _felin_, --,
   {{0x82005119,0x60361184,0x4b8931ae,0x93eb427b}},	//   _gelin_, _guverino, _diciembr, _lwethu_,
   {{0x727e615a,0xaf0a5208,0xe387c0b5,0x903c0018}},	//   _grond_, _mhàin_, _stará_, _selectio,
   {{0xd62130a8,0x6290c037,0x80e0c117,0xe59ee144}},	//   _befolkni, _melati_, _вновь_, _manipulá,
   {{0xcb444062,0xdb3130cb,0xbefd50ea,0x8c25418d}},	//   _интересо, _جنگجو_, _확인하시기_, _kombiner,
   {{0x4290c239,0x98a7a175,0xff21e013,0x727f7267}},	//   _omdat_, _правец_, _rotterda, _abange_,
   {{0x52bb108f,0x89eba13b,0x4f619082,0xd96f726e}},	//   _seneste_, _由县级以上人民政, _століття_, _acontece,
   {{0xa29270a2,0x620050a0,0xa288712c,0x6c18e11e}},	//   _moraju_, _delio_, _fichier_, _garanter,
   {{0xde435153,0x2f4350e6,0x0248d0a2,0xb3485185}},	//   _password_, _passwort_, _svemu_, _koneksi_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [480] --, --, --, --,
   {{0x779d9181,0x9c5e304f,0xe4ec30fe,0x00000000}},	//   _トラックバック_, _portail_, _যাকাত_, --,
   {{0x97b59070,0x7c54a134,0x00000000,0x00000000}},	//   _amelynek_, _gostwng_, --, --,
   {{0x727e6195,0xe36ab031,0x14d77008,0x7b7b8102}},	//   _trong_, _文化东路街道办事, _אנציקלופ, _biasanya_,
   {{0x62fc9119,0xaa7b2098,0x00000000,0x00000000}},	//   _kaaga_, _opište_, --, --,
   {{0x0c5371c5,0x35a9510b,0x125ad0dc,0x92d800b9}},	//   _pertama_, _formulár_, _sjell_, _kliek_,
   {{0xbc71e002,0xec6a5143,0x286860de,0x7290e119}},	//   _पिज्जा_, _गुड्डू_, _ekspress_, _zenawi_,
   {{0x3785d2e0,0x0f60d0b5,0x4b23d055,0x42b4d1ec}},	//   _प्राकृति, _displeje_, _isbahays, _theca_,
   {{0x77e72017,0x86d72062,0x32f73065,0x367f6187}},	//   _архива_, _архиве_, _indiach_, _venenati,
   {{0x33086078,0xcefd2025,0x2301e0d8,0x027ed1df}},	//   _adebayo_, _पेशकश_, _piranti_, _ngena_,
   {{0xa740c031,0x91e730a4,0x5f18d082,0x42247051}},	//   _科学技术部_, _चेहर्_, _публічно, _yanki_,
   {{0x69ec811c,0x69f7b0b5,0x83dd00f1,0x82da70c3}},	//   _فدراسیون_, _dodavate, _piawai_, _curent_,
   {{0x6947e175,0xd1e370a6,0x00000000,0x00000000}},	//   _предлог_, _पीआरओ_, --, --,
   {{0x15ae40a4,0xb3f89122,0x66e2f0c6,0x00000000}},	//   _पाहता_, _nakupu_, _životníh, --,
   {{0x427e61fd,0x920070d7,0xb38a22cb,0x5686510c}},	//   _huono_, _tenia_, _körde_, _acadamai,
   {{0x8d9841a3,0xd236316f,0x5162d076,0x730c2268}},	//   _momencie_, _reljef_, _zabronio, _romanos_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [490] --, --, --, --,
   {{0xf9b6c07b,0x1f2e3202,0xe224714b,0xfee500a4}},	//   _শতাধিক_, _comunida, _sanki_, _राष्ट्रा,
   {{0xc3a91008,0xbde91153,0xff991153,0x5f1610b9}},	//   _provide_, _provided_, _provides_, _predikan,
   {{0x72fcd054,0x32fae1a3,0xdae7f056,0xcf27f056}},	//   _isegi_, _informuj, _intresse, _intressa,
   {{0x72903084,0xd98e1010,0x48eec065,0x77840263}},	//   _semasa_, _наших_, _تصنيف_, _प्रासंगि,
   {{0x233d12e1,0xa25ad2e2,0x9ad68195,0x72ad9140}},	//   _دیدار_, _heller_, _сайтах_, _nekadašn,
   {{0x4f051026,0xb7bbf0a2,0x9ccc1062,0xbc75710c}},	//   _प्रेमचंद_, _međutim_, _служи_, _adhradh_,
   {{0xc58020f3,0x41c30241,0x81e6c070,0xaf2202e3}},	//   _informaç, _sastanak_, _تباہی_, _realizar_,
   {{0x03f471c4,0xe27ee0bd,0x3290e06e,0xf84fd0a0}},	//   _ersten_, _mennen_, _abiamo_, _ymholiad,
   {{0xe2cab161,0x89eed27b,0x0e5f612f,0x72480074}},	//   _fredag_, _bacteriu, _المؤمنين_, _ilimi_,
   {{0x12d841a7,0xb27ee040,0x727f717f,0xd3f8c07c}},	//   _immer_, _meinen_, _uwanja_, _salute_,
   {{0xb29d60b9,0x9395925e,0x33868204,0x12d8c0bd}},	//   _verkoop_, _fissi_, _sakrij_, _malere_,
   {{0x283240ea,0x23eae134,0x9313c07b,0x00000000}},	//   _잊으셨나요_, _menter_, _হলিউড_, --,
   {{0x3e7352e4,0xa7c0d07b,0x20ec12c0,0xd27ef1b2}},	//   _दोस्त_, _আবারো_, _speisial, _bannor_,
   {{0x83948095,0x9f4c303d,0x770b9047,0x03c5811c}},	//   _hanggang_, _ガイドライン_, _custaimé, _جادویی_,
   {{0x48c53171,0x4f3a109f,0x826a10ac,0x7f24023c}},	//   _reservad, _amerikaa, _amerikal, _गुलजार_,
   {{0xf21ee0fe,0x3d306229,0x00000000,0x00000000}},	// [4a0] _ক্রমানুস, _lappeenr, --, --,
   {{0xfae5f008,0xad0fa008,0x261c7229,0xf50cd1a3}},	//   _characte, _עמותת_, _mielenki, _automaty,
   {{0xb3fd6031,0xd2307007,0x72493078,0x6e57312e}},	//   _国家发展和改革委, _abameta_, _abamì_, _nenašiel_,
   {{0x7d1360dc,0x19805013,0x4fdca16a,0x739421c0}},	//   _konsider, _artikele, _velikono, _laksi_,
   {{0x23eae077,0x9ecb917f,0xbeb14090,0x43008160}},	//   _tuntuu_, _kulingan, _evropian, _tapaidh_,
   {{0x7340128c,0x23031090,0x02cae192,0x42d8c267}},	//   _licenza_, _allahut_, _fundet_, _muleke_,
   {{0xc27ee0f7,0x75eb30ea,0xb9489098,0x00000000}},	//   _kennen_, _공정거래위원회_, _हालसम्म_, --,
   {{0x027e915d,0x573eb17e,0x2249411a,0x93eac069}},	//   _trang_, _спидомет, _premye_, _lwmtus_,
   {{0xa3949124,0x927ee1e5,0x59f5705c,0x127e90da}},	//   _taasi_, _keinen_, _डेस्कटॉप_, _urang_,
   {{0xdc1c30c4,0x9395903e,0xc8fe1134,0xb045c068}},	//   _nitrians, _vissi_, _dadansod, _overigen,
   {{0xc2cae192,0x32489038,0xf39401aa,0x0394c065}},	//   _kender_, _alama_, _upisa_, _diosca_,
   {{0xa516411c,0xf37961e4,0xeb42127d,0x1316d0dc}},	//   _بازنگری_, _furasta_, _doporuče, _poezi_,
   {{0x53b811fe,0xae88b047,0xb26c7091,0xcc5c62c7}},	//   _provozu_, _أوباما_, _hynod_, _निषेध_,
   {{0x22fce19e,0x90c0512a,0x3c6ff1ab,0x51112076}},	//   _mangsa_, _summersl, _storico_, _białysto,
   {{0x797650f3,0x7c5052e5,0x9f6ea0a4,0xf29081df}},	//   _atendime, _कालेज_, _अहमदनगर_, _kakade_,
   {{0xa2caf0e6,0x06ba1237,0x9bb3c049,0x455d2065}},	//   _leider_, _barangsi, _शास्त्रो, _جزائرية_,
   {{0x324802b8,0x44b181bb,0x3ecf706f,0xa3993249}},	// [4b0] _ulimi_, _асфальт_, _posizion, _läser_,
   {{0x19add06a,0xf3ebf2c3,0x99233025,0x050680b7}},	//   _تجربہ_, _ikuti_, _रेंजर_, _алфабету,
   {{0xe88060fc,0xa3f461a0,0xc0f0603b,0xcfe06147}},	//   _artikulu, _vertel_, _artikull, _artikulo,
   {{0x86e6004b,0xcb61c1f4,0x4175c070,0x6395e024}},	//   _kompaniy, _भेजनी_, _تذکرہ_, _vitse_,
   {{0xae99212f,0x322ac02f,0x8212e052,0x329112aa}},	//   _وبعدين_, _мовах_, _elihle_, _albais_,
   {{0x929072e6,0xdbcc0008,0x8ef0d0a4,0x9c66b22b}},	//   _kenal_, _והעמקים_, _संकल्पना_, _birtist_,
   {{0x32fe6045,0x53d0a01f,0x00000000,0x00000000}},	//   _bergen_, _olimpisk, --, --,
   {{0x52a740f5,0xab051078,0xeac8a127,0x00000000}},	//   _byebye_, _afasegbe, _rosalía_, --,
   {{0x7c6d8154,0xd9f6c070,0x73860267,0x72489189}},	//   _shirika_, _توہین_, _siiro_, _ulama_,
   {{0xe2e6f190,0xe33f207b,0xf2c941c9,0x32a7f100}},	//   _biznesa_, _মজুমদার_, _suporte_, _klubo_,
   {{0x620e1173,0x42da5216,0x91c3c02a,0x00000000}},	//   _качан_, _butere_, _догори_, --,
   {{0x72fce04a,0xeec5c081,0xfa931017,0x00000000}},	//   _bangsa_, _словник_, _корени_, --,
   {{0x25042163,0x0c15c011,0xa7ece11c,0x33807023}},	//   _početna_, _sveriges, _pekalong, _suurus_,
   {{0x1721d136,0xc000911c,0xb26d8075,0x6307d099}},	//   _početkom_, _علیزاده_, _barod_, _boravak_,
   {{0xf30dc01b,0xd363619d,0x6dad8003,0x623ba247}},	//   _membina_, _langkah_, _bandarís, _atumatu_,
   {{0x9b6e3182,0xc2da70cb,0x00000000,0x00000000}},	//   _емоции_, _keress_, --, --,
   {{0xe38781dd,0x33ebf154,0x00000000,0x00000000}},	// [4c0] _horri_, _ukuta_, --, --,
   {{0xd3dc900d,0xe310b043,0x65ee128c,0x8e33b061}},	//   _ikawa_, _chuckle_, _produció, _reklamos_,
   {{0xc2c94177,0x89fce074,0x2bb4c0c8,0x00000000}},	//   _bellach_, _makarant, _सुन्नुहो, --,
   {{0x626df048,0x627e70de,0x4c3ea105,0xb3f4709f}},	//   _truoc_, _tunne_, _genişlən, _gestel_,
   {{0xb395903e,0xf3949068,0x4f2360db,0xc3f4027d}},	//   _misst_, _naast_, _comentan, _dostat_,
   {{0x4b28b100,0x12d8c13d,0xa20030a4,0x00000000}},	//   _транспар, _groene_, _komisi_, --,
   {{0xa2d51039,0x8ef71006,0x4c7d721f,0x663d726c}},	//   _mellett_, _कलाको_, _persuna_, _persunal_,
   {{0xfd8c21a7,0xa9d1519b,0xe954f1ab,0xf26d81ef}},	//   _geregelt_, _بفرمایید_, _известен_, _muros_,
   {{0x64eba02a,0x0341624a,0x887002e7,0x00000000}},	//   _контракт, _direkta_, _músicas_, --,
   {{0x43207154,0x0292505d,0x00000000,0x00000000}},	//   _wenye_, _matayo_, --, --,
   {{0xe4b38094,0x282e901a,0xbef6f022,0x7e006061}},	//   _הארבע_, _условиях_, _yarjejen, _bendrada,
   {{0x1f03607b,0x93659018,0x18a3c02c,0x9f3980bc}},	//   _লোকজন_, _לוקחת_, _команды_, _muenster_,
   {{0x8dc42106,0xd3737036,0x6624828c,0x6f78320f}},	//   _agricole_, _domande_, _tecnolox, _blackpan,
   {{0x2dffe04a,0xd69ba0b2,0x12fc3089,0x73207206}},	//   _perempua, _chướng_, _milions_, _zenye_,
   {{0xaaba2175,0xff321031,0x6320717f,0xfa17113b}},	//   _предизви, _国土资源部_, _yenye_, _徐州监察分局_,
   {{0x35105099,0xfd784004,0xd460d13b,0xfd0a5013}},	//   _pokušao_, _פאסאזשיר, _香艳的寻宝之旅_, _europese_,
   {{0x8ae1f008,0x22a6a1d9,0xfce88175,0xb581f187}},	// [4d0] _institut, _hobby_, _достигне_, _instituz,
   {{0x42d7c08e,0x427f509a,0x00000000,0x00000000}},	//   _kuponko_, _buenas_, --, --,
   {{0xf85cb093,0x72a64206,0x02583140,0x8517523e}},	//   _verander_, _simba_, _engleski_, _amalanny,
   {{0x327e6037,0x73b022e8,0x8683400f,0x5dab5003}},	//   _ngono_, _webstrán, _एतबार_, _minninga,
   {{0x72d9000c,0x50dd20cb,0xe2e9a179,0x022ba17d}},	//   _habere_, _ریسرچ_, _arkisto_, _vermoed_,
   {{0x6f1e311c,0x1d85c045,0xb4fb40d5,0x00000000}},	//   _شاکردوست_, _словом_, _गिलानी_, --,
   {{0xe2da70ff,0x6cd99094,0x8cf2f128,0x22bc716a}},	//   _stredu_, _החסיד_, _partener, _ध्रुव_,
   {{0xd3da20e7,0xa3c890fe,0x15ec1018,0xc0abe203}},	//   _правилни, _এলোমেলো_, _ללקוחות_, _станция_,
   {{0xee29d03e,0xc38bc2e9,0xfb25307a,0x00000000}},	//   _bygginga, _færre_, _пушкіна_, --,
   {{0xce4d9008,0xb27e912c,0x8510a19f,0xb8dfb0a0}},	//   _הייטק_, _quand_, _səlahiyy, _ryngwlad,
   {{0x6386c194,0x611ac173,0x0c7b4132,0x82d521a5}},	//   _gjorde_, _бомбы_, _برخاست_, _robocon_,
   {{0x2386a09d,0x09472175,0x33ebe0c0,0x00000000}},	//   _dobry_, _писател_, _nytta_, --,
   {{0x5290c0a2,0x2c54a147,0xdb67c20a,0x00000000}},	//   _jedan_, _gustong_, _бабеле_, --,
   {{0x22b73045,0x829020a4,0x768e61ad,0x25148126}},	//   _другому_, _dekat_, _profissi, _egyáltal,
   {{0x95bd9017,0xa1b9a018,0x1302c077,0x13875044}},	//   _министра_, _החלקה_, _lokakuu_, _cifras_,
   {{0x1b495035,0xb66cd1af,0x6d8c7204,0x427e905a}},	//   _संस्कृती, _бунга_, _točno_, _itanu_,
   {{0x7e4291c0,0x9290c0e8,0x3221b03b,0x22c02190}},	// [4e0] _breakout_, _nedan_, _diskutim, _vēlies_,
   {{0x02e0216e,0x861d1068,0x4c03d190,0xc635d1ab}},	//   _deireadh_, _개인정보보호정책_, _forumā_, _класичес,
   {{0xfa7e91cd,0xa29130aa,0xcd4ad19b,0xb2013232}},	//   _connaiss, _linkler_, _اسکنر_, _linkleri_,
   {{0x854e21bc,0xa290c212,0x62d460ac,0x2aa910c3}},	//   _лични_, _allaah_, _burdan_, _перете_,
   {{0x6299b03d,0x00000000,0x00000000,0x00000000}},	//   _アウトドア_, --, --, --,
   {{0xe70ba094,0x32d5d1a4,0xf30d1055,0x03fa6231}},	//   _ההגדה_, _razliku_, _samatar_, _struje_,
   {{0x4b7cc12b,0x1387e04f,0xf320c088,0x32009134}},	//   _jednoduc, _notre_, _medyo_, _owain_,
   {{0xc236525f,0xdfe1512f,0x12bd5035,0x2200200c}},	//   _vilja_, _ollmhór_, _माणुस_, _tekil_,
   {{0x834c20c8,0x549752ea,0xff23804c,0xe1415039}},	//   _cestovní_, _अयोग्यता_, _cemerlan, _مشاروتی_,
   {{0x984340e7,0xd27fe0a7,0xd20021a4,0x6d99c1a3}},	//   _централн, _letni_, _nekim_, _bezpośre,
   {{0x96577156,0x437c5104,0x2394d2a9,0x725ad192}},	//   _poljopri, _nabanye_, _mbese_, _skolen_,
   {{0x927e7045,0x52b470f9,0x323fd0b9,0xbc1650a2}},	//   _kunna_, _manch_, _vermaak_, _mogucnos,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc2ba504a,0x89d5d002,0x4867504d,0x652c101e}},	//   _sendiri_, _उत्पात_, _mulighed, _términos_,
   {{0xc291c2eb,0x03796147,0x00000000,0x00000000}},	//   _vrijeme_, _matanda_, --, --,
   {{0x3248d143,0x1145124a,0x33eae2ec,0x37a0e1f9}},	//   _olema_, _materyal, _centar_, _শিপলু_,
   {{0xab1820d3,0x5c5c92ed,0x527e7259,0x2627d008}},	// [4f0] _هههههههه, _बिशेष_, _gunna_, _definiti,
   {{0x1ca66036,0x0200c0de,0xf75fa02a,0x19699190}},	//   _журналис, _valige_, _дозволяє_, _autortie,
   {{0x826cc11d,0xcc1720ca,0xa25a9206,0x526dd0c8}},	//   _zalogi_, _पूर्वाञ्, _ajali_, _neboť_,
   {{0x432091e3,0x1b0b003d,0x93fa40d8,0x322540aa}},	//   _kwayo_, _アドバイス_, _patung_, _şekli_,
   {{0x98fce2ee,0xbdae00e0,0xb2f4c098,0x66c5e0fe}},	//   _levantad, _kasnasda, _emailem_, _দাবীতে_,
   {{0x6c777029,0xd25a927c,0xad57901a,0x00000000}},	//   _पेक्षा_, _djali_, _муниципа, --,
   {{0x89f1e003,0x644570a4,0x13417140,0x00000000}},	//   _endilega_, _प्रयोगशा, _spremna_, --,
   {{0x1a897087,0xc27e91c0,0x4cb72031,0x12fe7044}},	//   _üniversi, _ngano_, _您当前的位置_, _cargas_,
   {{0x32cae11d,0x139402b9,0xa2fc00fa,0x2860c215}},	//   _vendar_, _spise_, _oyiga_, _юнака_,
   {{0xd290c011,0x727ed241,0xb31730f7,0x1b1c420e}},	//   _redan_, _krene_, _functie_, _debatten_,
   {{0xb9d2e143,0xa9995077,0x62ef40b0,0xe290c008}},	//   _tallinna_, _професси, _gwefan_, _sedan_,
   {{0xb320909c,0x5288214b,0xc8da0080,0x2c7e01c0}},	//   _bwayo_, _hastalığ, _mojsejov, _bersyon_,
   {{0xb3508053,0x4bad80c6,0xf2e760b3,0x49aa3065}},	//   _profiel_, _क्यूबेक_, _putnika_, _تأكيد_,
   {{0xd29040a0,0x4bfcf1a0,0x820091dd,0x00000000}},	//   _gemau_, _vergader, _dakizu_, --,
   {{0x325bf03e,0x49eab020,0x19fd002e,0x0a906091}},	//   _skulu_, _알려드립니다_, _interiér, _comisiwn_,
   {{0xc1b1e07b,0x62da61b4,0xc27e706e,0xb2002070}},	//   _জানেন_, _bareng_, _funni_, _nekik_,
   {{0x0840c1a2,0x92d8a054,0x91452153,0xab65810b}},	// [500] _مخصوص_, _umbes_, _material, _januára_,
   {{0xc681900b,0x925a90bf,0x00000000,0x00000000}},	//   _ग्लास_, _ajolú_, --, --,
   {{0x42e111f4,0xc2d8b11d,0xa3f47192,0xb852a089}},	//   _भेजीं_, _vedeti_, _bestil_, _entrades_,
   {{0xcbd21243,0x927ed202,0x62fdf099,0xa1f8c065}},	//   _कृपया_, _bueno_, _drugu_, _متصفح_,
   {{0xcc610154,0x1a03a119,0x23683093,0x53eae1c4}},	//   _masuala_, _darajada_, _vingers_, _dritte_,
   {{0x82d8a06a,0x739a60a7,0x93519128,0x13e89020}},	//   _ember_, _podatkov_, _conform_, _태터데스크_,
   {{0x47fcb033,0xdc1ce03d,0x52d66122,0x83f40194}},	//   _只看该作者_, _サイトマップ_, _podobno_, _kostet_,
   {{0x542d60cd,0xb200f25f,0x00000000,0x00000000}},	//   _दबदबा_, _megin_, --, --,
   {{0x03f471c2,0xddff5102,0x48534089,0x63cf30b2}},	//   _nostre_, _mendenga, _empreses_, _ttxvn_,
   {{0x5386d191,0x00000000,0x00000000,0x00000000}},	//   _miere_, --, --, --,
   {{0x0200c1be,0x92cbf1a4,0x93f20088,0xd200800c}},	//   _redio_, _ljude_, _parehong_, _makine_,
   {{0x9681a1f3,0xcf5d41ce,0x5c634036,0x00000000}},	//   _क्रास_, _magasabb_, _imprese_, --,
   {{0xfc0542de,0x13949119,0x7e9880ea,0xaf7fb0b3}},	//   _chorvats, _kaasi_, _선거법위반행위_, _potrošač,
   {{0x2e50202e,0xc24db054,0x8b95a05d,0xcc5ca128}},	//   _informač, _फिरला_, _katikkir, _centrul_,
   {{0x6a7c805d,0x55a122ef,0x62f640f9,0xbfd21009}},	//   _makanisa_, _सोचते_, _prensip_, _miniatur_,
   {{0xb27e90ed,0x0290f055,0x758a01f1,0x3c7690a8}},	//   _orang_, _degan_, _registrá, _forslag_,
   {{0xc285804d,0x00000000,0x00000000,0x00000000}},	// [510] _回答は役に立ちま, --, --, --,
   {{0x5290201b,0xc386d1d8,0xbcb950a0,0x00000000}},	//   _mekah_, _diere_, _ymwadiad_, --,
   {{0xd34170e6,0xc3869206,0xe3a7b2da,0xc27e911d}},	//   _eigenen_, _ziara_, _франсуа_, _hrano_,
   {{0x2f2db0e8,0x6b35c184,0x7dc45020,0x00000000}},	//   _utrednin, _kurashis, _maximale_, --,
   {{0xa26dc136,0xa25b7205,0x8290904a,0x5e68504d}},	//   _prvoj_, _ilalim_, _lokasi_, _総合ランキング_,
   {{0xd582f088,0x1394b2e2,0x317e007b,0x7739b11c}},	//   _kategory, _fleste_, _কথাবার্ত, _سبزیجات_,
   {{0x37cc7036,0x72da619b,0xea97a0cc,0x92e79036}},	//   _пострада, _sareng_, _דאטנאביע, _gennaio_,
   {{0x47e340de,0xa38f51da,0xe26d80bc,0x9da63293}},	//   _त्रिपाठी_, _rapporti_, _karon_, _стопанск,
   {{0x53877063,0xa26da200,0xc62ed13b,0x2706e2f0}},	//   _ilaria_, _ispod_, _必须保留本网注明, _štruktúr,
   {{0x128d2113,0xe2f1e1ab,0xe394906e,0xa2ff90d3}},	//   _thaksin_, _diritti_, _abaso_, _radharc_,
   {{0x235870ff,0x997e409f,0x33f8e0ab,0xd304e16f}},	//   _potrebné_, _afrikane, _minuts_, _izbacim_,
   {{0x62d8716a,0x7d0840cc,0xc18ec07f,0x038672a3}},	//   _konec_, _באזונדער, _лимба_, _blizini_,
   {{0xe153c13b,0x05b760b2,0xf960105d,0x00000000}},	//   _企业国有产权转让, _finalsty, _abangere, --,
   {{0xe22500a2,0xf2fe7044,0x00000000,0x00000000}},	//   _svakom_, _cargos_, --, --,
   {{0x0682f008,0x2637602c,0xe9c2f091,0x581b31bb}},	//   _categori, _пластико, _categore, _стремно_,
   {{0x9290c027,0x1b7f2101,0x52fce13d,0xb386f1be}},	//   _nalaze_, _bangaren_, _dingen_, _ahaziri_,
   {{0x62007061,0x7031f2f1,0xec619076,0x072a602a}},	// [520] _meniu_, _बतकही_, _oferuje_, _приватни,
   {{0xa280c219,0x02b28040,0x6394e18d,0x8c9090de}},	//   _novinky_, _sondern_, _prisen_, _त्यों_,
   {{0x7967a004,0xd200d03e,0x9ccb904d,0x18ad3034}},	//   _מגילה_, _tveir_, _円以上国内配送料_, _малък_,
   {{0x2eead037,0x00000000,0x00000000,0x00000000}},	//   _پستون_, --, --, --,
   {{0xf648a04e,0xd2d9915b,0xedf7c050,0x00000000}},	//   _никарагу, _besef_, _филмови_, --,
   {{0x83f471db,0x26d611bd,0x653c904d,0x4f38d1c0}},	//   _vostre_, _یاسمین_, _希望小売価格_, _sovracca,
   {{0x5c50c0ca,0x2ee3e0aa,0x1e398029,0x20e7e0d1}},	//   _ट्रेड_, _programı, _penawara, _offiziel,
   {{0xd27e722b,0x185da094,0x5200e158,0x426df02f}},	//   _kunnu_, _משכיל_, _abiire_, _sezono_,
   {{0x3db8e18e,0xde237079,0x88e79293,0x9320b013}},	//   _filament_, _संग्रहाल, _надвор_, _precies_,
   {{0xe4d5e28b,0x2200f269,0x0cbaa04f,0x00000000}},	//   _गोपिका_, _tegin_, _magnifiq, --,
   {{0x26dff017,0x7ae99175,0x00000000,0x00000000}},	//   _израелск, _немаат_, --, --,
   {{0x73eae008,0xf26e51d0,0x7248d054,0x92c530b9}},	//   _center_, _nitori_, _oleme_, _heilige_,
   {{0x76e46017,0x42d9f01d,0x1f44422b,0x7c6f6174}},	//   _многобро, _gazete_, _búskapar, _carrera_,
   {{0xc9d4d2f2,0x95727004,0xa27f7051,0x02926095}},	//   _umiestne, _אַרמיי_, _kwanan_, _sarado_,
   {{0x123691e8,0x2d00707b,0x6c69e03b,0xc39591d7}},	//   _znaju_, _মিউজিক_, _titulli_, _ahssa_,
   {{0x520070d6,0x0b2720a4,0xbbfb91ae,0x5b03912c}},	//   _menit_, _विश्वकरं, _septiemb, _entretie,
   {{0xe3f47049,0x42e2d166,0xe9e870cd,0x05268193}},	// [530] _jestem_, _स्वीट_, _कोतवाली_, _završio_,
   {{0x048510de,0x23f47056,0x02d980b9,0x00000000}},	//   _शिवाला_, _bostad_, _gered_, --,
   {{0xb24890a4,0x327f90cf,0x002d70fd,0x0186927b}},	//   _alami_, _qaynar_, _фотоальб, _bakankul,
   {{0xe290319d,0x93eaf1bf,0x00000000,0x00000000}},	//   _sejak_, _pritet_, --, --,
   {{0x826c12f3,0x82908205,0xfd136153,0x9378d185}},	//   _रक्षा_, _dekada_, _consider, _kemarin_,
   {{0xf072b037,0xc047f1bc,0xc2a682f4,0x9290d0d4}},	//   _امارات_, _мислите_, _provozní_, _ideat_,
   {{0xb200321b,0x52904037,0x13796116,0x0a6fa12f}},	//   _komiti_, _lemah_, _carabta_, _prionsab,
   {{0x42e320c4,0xc7aa71fc,0x126cd065,0xbe5f0192}},	//   _peniaze_, _avstrali, _cheol_, _specielt_,
   {{0x62bd5186,0xb287f14b,0x728c3080,0xfa0fe035}},	//   _मानुस_, _hastalık, _balkón_, _manajeme,
   {{0xc2bb8034,0xec5740c9,0x526df01a,0xad78c034}},	//   _offerte_, _nastaje_, _autot_, _енергия_,
   {{0x6580e0f9,0x2f3dd143,0x097ad040,0x2c31e143}},	//   _federasy, _कृतित्व_, _enthalte, _artiklid_,
   {{0x43f9813d,0xbc673161,0x93874009,0x53f8f089}},	//   _terug_, _omkring_, _ngerti_, _algun_,
   {{0x7163a26b,0x12d85177,0x93949099,0x747d8009}},	//   _דניאל_, _coleg_, _spasa_, _interwik,
   {{0x1c53f0f3,0xd38b327e,0xe2d830a2,0x327e0143}},	//   _contato_, _først_, _kojem_, _naine_,
   {{0xbce27050,0x02a640c3,0x7435e1fd,0x9248d09c}},	//   _информир, _limba_, _функции_, _aleme_,
   {{0x74ef4045,0xf3f85142,0x0290c091,0x127ee1d9}},	//   _спортивн, _illum_, _addas_, _seinen_,
   {{0xd200c153,0x252021e4,0x7b0e7077,0x027ed092}},	// [540] _media_, _beannach, _viestike, _stenu_,
   {{0x6c7e015a,0x4e54e081,0xeb10010b,0x025b50d1}},	//   _persoon_, _економіч, _prostrie, _stellt_,
   {{0xc9f8f21d,0x326da078,0x47dfb01c,0x8f628190}},	//   _milijuna_, _aapon_, _ponašaju_, _katalogs_,
   {{0x1a152265,0x503c9013,0x3836902f,0xe1767108}},	//   _कामोत्ते, _namelijk_, _кадрах_, _प्रतिघात_,
   {{0xde0ea175,0xf2eee046,0xd29271ee,0x9b260153}},	//   _verdinha, _benfro_, _pasado_, _companie,
   {{0xb3869056,0x53eb2044,0xf290419e,0x924990dc}},	//   _snart_, _lector_, _semak_, _mesme_,
   {{0x7c50c07b,0xe3099008,0x419991a3,0xedad8003}},	//   _ছোট্ট_, _problem_, _problemy_, _bandarík,
   {{0x92484045,0xa1acc16a,0xc39ca0a9,0x075330e6}},	//   _komme_, _pondělí_, _zakašnje, _grundlag,
   {{0xe5c0b0a4,0x32d851c4,0xe2fd20a7,0x963f1134}},	//   _ब्राह्मण, _allem_, _kolikor_, _bersonol_,
   {{0x956730a2,0x3c52d143,0xb2bb805f,0x00000000}},	//   _obavezno_, _स्लेट_, _effekte_, --,
   {{0xf24802a7,0x5290e208,0x8a886221,0xd3f46037}},	//   _elimu_, _chiall_, _moderáto, _urutan_,
   {{0xe2d850a7,0x49e17070,0xb3f40089,0x0b2611bb}},	//   _poleg_, _میگزین_, _costat_, _ядром_,
   {{0x8dcfa2f5,0xc2d980b5,0x0290c090,0x489a804d}},	//   _ज़्यादा_, _tablety_, _islame_, _したがって_,
   {{0x02d8b13c,0x12255064,0xb290501b,0xa596310f}},	//   _организу, _nafkah_, _belah_, _isteriny,
   {{0x320070aa,0x0bf2d039,0xaceee079,0x18c2d039}},	//   _benim_, _kattints, _क्रमवार_, _kattintv,
   {{0x53eae15e,0xd2c6b143,0x04fb600f,0x10821094}},	//   _centrs_, _oluline_, _किसानी_, _לחבירו_,
   {{0xe43f3020,0xe394d134,0x4e463268,0xbc6e11d6}},	// [550] _대전광역시_, _asesu_, _humanida, _akaraka_,
   {{0x323a41b0,0x5631c01a,0x1f6d31d5,0xf34850d4}},	//   _विशालकाय_, _erinomai, _atịkụl_, _lineari_,
   {{0x93f4011e,0x268230c3,0x0200b044,0x52007120}},	//   _postat_, _accesori, _medida_, _tenim_,
   {{0x32ca01ec,0x25b7b0c2,0xedb510a4,0xad47b1ee}},	//   _odide_, _disposiz, _श्रीकांत_, _disposic,
   {{0xcbee10b6,0xc329e269,0x725a20a8,0x4843828c}},	//   _часом_, _राजपूतन_, _fortælle, _contidos_,
   {{0x92a13020,0xb27ed1ee,0xef47d0a6,0x00000000}},	//   _불가합니다_, _buena_, _maksimaa, --,
   {{0x27c0e018,0xc921112b,0x00000000,0x00000000}},	//   _classifi, _neobsahu, --, --,
   {{0xd47f90d4,0xdefd21ab,0xbef2c13c,0xf27ff1df}},	//   _batterij, _графични_, _хвала_, _efuna_,
   {{0x763f1091,0xe9e130d5,0xe20051b5,0xea14c2c4}},	//   _personol_, _कस्टम_, _pelik_, _forbruge,
   {{0xf2e641e8,0x6c0361cc,0x0354a271,0xabad10fe}},	//   _radnika_, _gampang_, _poderes_, _মন্ডল_,
   {{0xd3ea0058,0x59c2c089,0xcc19b229,0xc1d02065}},	//   _edite_, _divendre, _процессо, _ملايين_,
   {{0x2202619f,0xfe725243,0xd2a7106f,0x96db0065}},	//   _turizm_, _आरम्भ_, _парола_, _يااااااا,
   {{0x415ac0c9,0xd57dc020,0xf7a45045,0x37bac2c1}},	//   _prirodno, _엔터테인먼트_, _тематичн, _prirodni,
   {{0xf25a0159,0x5cd2107b,0xc3ced191,0x9200c0aa}},	//   _idile_, _বৈঠকে_, _drevo_, _haline_,
   {{0x5f2400f7,0x03869128,0xb63e1017,0x26dca129}},	//   _nederlan, _ziare_, _министри_, _मिसिर_,
   {{0x90373266,0x9f2e1175,0x22131069,0x3f06c065}},	//   _cestovan, _модифици, _tobhau_, _وعطور_,
   {{0xc6640143,0xefe7b175,0x5c7f6008,0xf2cae0d2}},	// [560] _ग्रसित_, _правата_, _january_, _rondom_,
   {{0xf2d85041,0xa1b8910b,0x443020f3,0x6386d0ab}},	//   _kolem_, _recenzií_, _processo_, _riera_,
   {{0xb3f85208,0x948641b9,0x127e0102,0x0387f175}},	//   _colum_, _सुपारी_, _asing_, _couro_,
   {{0xaaf85033,0x73eae10f,0xb4ae21ac,0x00000000}},	//   _actuelle, _gentar_, _jawatank, --,
   {{0x33ce20a2,0xdd2d10c3,0x00000000,0x00000000}},	//   _kakve_, _similare_, --, --,
   {{0x43ead254,0xa29101ec,0xedc0d03f,0x72a7f0ae}},	//   _tiotal_, _lebara_, _komisija, _klubs_,
   {{0x72e750dc,0x320070ca,0x00000000,0x00000000}},	//   _gjenden_, _denik_, --, --,
   {{0xc17730b6,0xc14752f6,0x1290201f,0x725ad194}},	//   _центр_, _desenvol, _nekas_, _kveld_,
   {{0x472280b7,0x0290c0c3,0xf9efb033,0x00000000}},	//   _анӂелику, _dolari_, _injurieu, --,
   {{0x6f5dd1a5,0x30763070,0x3d6f9208,0x99d4d07b}},	//   _vinaphon, _مذاہب_, _seòladh_, _বিভ্রান্,
   {{0x42d882f7,0x1557715d,0x2394e0d3,0x89f37179}},	//   _hehehh_, _ninjasch, _coiste_, _kansaned,
   {{0x6a7210b5,0xcbd6f13b,0x951cc1bf,0xfa89019e}},	//   _značka_, _市场参考价_, _zakonish, _perisian_,
   {{0xb2cad15b,0x029020bb,0x8394f143,0x1200c07f}},	//   _vandag_, _mekas_, _siiski_, _mediu_,
   {{0x03310065,0x00000000,0x00000000,0x00000000}},	//   _اجنبيه_, --, --, --,
   {{0x478412e0,0x53f140d4,0x926c61b1,0x295140d4}},	//   _प्रस्तुत, _esportaz, _nkoos_, _esportat,
   {{0x5f3fa2cc,0x85ff22cc,0x00000000,0x00000000}},	//   _tangeran, _विरोधात_, --, --,
   {{0x62ec20c4,0x1b65a21e,0x6878b045,0x6cd560ea}},	// [570] _rastliny_, _coolinar, _продовжу, _페이지까지_,
   {{0xd13140c3,0x12dc11d6,0x9951b179,0xcf1140da}},	//   _produsel, _achoghi_, _kiellett, _produsen,
   {{0x99b141ff,0xc0114248,0xabaa1018,0xd290711d}},	//   _producte, _producto, _architec, _cenah_,
   {{0xac03602d,0xa3eaf03e,0x00000000,0x00000000}},	//   _samping_, _leitar_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf290c25e,0x729101c0,0x12318017,0x00000000}},	//   _solari_, _babaye_, _септембр, --,
   {{0x129031f5,0x768302f8,0xb94e713b,0x82573108}},	//   _tamale_, _पोशाक_, _广州市白云山农产, _virtuaal,
   {{0x329010fc,0x2c776153,0xb27f40e9,0xeebdd1ff}},	//   _behar_, _popular_, _prenta_, _evenemen,
   {{0xf912e07a,0x00000000,0x00000000,0x00000000}},	//   _этапу_, --, --, --,
   {{0x12fd92f7,0x215f212f,0x6a3e519b,0x6200c0bd}},	//   _ehehehe_, _coinnigh_, _جزییات_, _galile_,
   {{0x07d7c2f9,0xe963d04d,0x52902102,0xc229907b}},	//   _nadaljev, _あなたにおすすめ, _bekas_, _মুহম্মদ_,
   {{0x26b85045,0xedd040bb,0xd4b90067,0xf26de037}},	//   _глобальн, _fatherna, _दिनेशदा_, _katon_,
   {{0x6c6d3137,0x62d82194,0xe25b7051,0x82907134}},	//   _porukom_, _boken_, _akalla_, _menai_,
   {{0x7877a02b,0xc195c07b,0xf2d8c1dd,0x3e2000fe}},	//   _правах_, _নীড়পাতা_, _kodea_, _সজিপ্র_,
   {{0x220031b2,0x524a7133,0x9e9ec0f3,0x226df2c1}},	//   _mejis_, _seumas_, _табла_, _istoj_,
   {{0xac53d0ca,0x7594a062,0x4e1a423a,0x03ead0c2}},	//   _विदेह_, _студенат, _सर्बिया_, _avete_,
   {{0x178ac0e7,0x94ac70c2,0xe3bfd099,0xc0d5d04d}},	// [580] _приватно, _консулта, _zatvori_, _このサイトを評価,
   {{0x2c5d606f,0x70b220de,0x91259229,0x2b82e070}},	//   _компания, _प्रजातंत, _mielestä_, _منظرنامہ_,
   {{0xa9d181b2,0x117d216f,0x438061e8,0x825ad005}},	//   _muitimed, _odrastal, _jutros_, _fellur_,
   {{0x2cf612ae,0xd2a7f144,0xfc612037,0xa37940c5}},	//   _адрес_, _kluby_, _sebutan_, _tavalla_,
   {{0x0386b0ab,0x00000000,0x00000000,0x00000000}},	//   _podria_, --, --, --,
   {{0x199cc070,0x7849e082,0xd35ae13b,0x62e00078}},	//   _رجسٹر_, _призначе, _从这里开始_, _aguntan_,
   {{0xb387f1cd,0x7db9b2f2,0x1b499108,0x75120004}},	//   _jours_, _trenčian, _रास्ट्री, _מחלוקה_,
   {{0xc387e071,0xe98081a3,0xc3200184,0x00000000}},	//   _intre_, _नियमों_, _agiye_, --,
   {{0x027f41f9,0x2adf303b,0xc141207b,0x226af1ab}},	//   _cuenta_, _komunite, _বেড়েছে_, _операция_,
   {{0xde72e2fa,0xac32525b,0x08621002,0x4694f16a}},	//   _एकत्र_, _szeptemb, _राजगद्दी_, _kadeřnic,
   {{0xa3c870a2,0xd2b58074,0x8cf7a0a6,0x327e0074}},	//   _sasvim_, _barci_, _हमशक्ल_, _raina_,
   {{0xa2018064,0x5679d02e,0xdaaa80ea,0xf2d9e070}},	//   _ceria_, _neustále_, _구체적으로_, _beteg_,
   {{0x330cb041,0x6ae43153,0x0200c0aa,0x5f243210}},	//   _upravit_, _septembe, _dedim_, _septemba,
   {{0x6fc67173,0x8a8672fb,0x225ad21b,0xb6aa0018}},	//   _istorijo, _istorijs, _uvele_, _הדרדסים_,
   {{0x4387f1cd,0x135f32a2,0x00000000,0x00000000}},	//   _cours_, _pengene_, --, --,
   {{0x52da71ab,0x23f45056,0x636cf0a9,0xa27e90bd}},	//   _essere_, _natten_, _tragovi_, _grann_,
   {{0xb2dac040,0xec0362fc,0x4387e11a,0x12da505a}},	// [590] _können_, _kampung_, _antre_, _gatete_,
   {{0x12018007,0x0b63b04d,0x825ad2fd,0x1ef6313c}},	//   _merin_, _アクセス解析_, _felles_, _настала_,
   {{0xd248426c,0x8ea2a04d,0x0c2a5065,0xe26de18f}},	//   _somma_, _最新記事一覧_, _معالجة_, _zaton_,
   {{0x9290403c,0xe281c03a,0x6a0fa080,0xef3c1094}},	//   _temat_, _possibil, _manažmen, _מלאכות_,
   {{0xd056716a,0x122b30c3,0x5e1b301e,0xa3430038}},	//   _अर्घाखाँ, _animale_, _animales_, _kitendo_,
   {{0x62903202,0xe3869120,0xb2b480f5,0xf37920d0}},	//   _dejar_, _diari_, _chicky_, _elbasan_,
   {{0x92fd60f7,0xd2bc01a0,0xf290419e,0x13d95049}},	//   _liggen_, _verdien_, _kemas_, _polaków_,
   {{0x9c1872fe,0xf2018007,0x3d3da197,0xec535021}},	//   _despois_, _kerin_, _ordinace_, _būtent_,
   {{0x4c50419c,0x4c6f110c,0xcd9f00a2,0x429630c4}},	//   _कैसेट_, _fearann_, _većina_, _funkciu_,
   {{0x44ec70b7,0xd3430063,0xebd450eb,0xdc6160a1}},	//   _контрола, _nitendo_, _генералн, _mutumba_,
   {{0x63954036,0xcb774044,0x00000000,0x00000000}},	//   _questo_, _explotac, --, --,
   {{0x2b67400f,0xf9f920c2,0xb386e0c5,0x040d70fc}},	//   _कारने_, _alessand, _koiran_, _gainditz,
   {{0x92730054,0xec0ba27e,0xc195c1e6,0x00000000}},	//   _politsei_, _egypten_, _планом_, --,
   {{0x5f4e0036,0x0045e23a,0xa2c490b9,0x00000000}},	//   _versione_, _चाइल्ड_, _skuldig_, --,
   {{0x7d23e282,0xab05a043,0x83806133,0xe0f5b0b7}},	//   _plusieur, _grignion_, _beurla_, _субститу,
   {{0x5237907b,0x8ad8d0c8,0xf249525c,0xc3eae18a}},	//   _মানিকগঞ্, _vánoční_, _poemas_, _gentur_,
   {{0x0d5d7060,0x43187069,0x3290211c,0xb2d460c5}},	// [5a0] _lọ́nà_, _hwjchim_, _cekap_, _kauden_,
   {{0x0be0e100,0x4fc2c1bd,0xc3f33047,0x00000000}},	//   _interjer, _تابوت_, _اطلاق_, --,
   {{0xe27e616d,0xfafa504c,0xe27f7024,0xda3c2173}},	//   _taong_, _pengurus, _fransa_, _сухое_,
   {{0xe2d8710f,0xefb1e0ea,0xdae4205a,0xc386d0d1}},	//   _konek_, _주절거리기_, _ingengab, _tiere_,
   {{0xef6fc151,0xb2e60158,0x939542ff,0x0fea4300}},	//   _palabras_, _adanida_, _flestu_, _dubrovač,
   {{0x528c70cc,0xb27f2048,0xe7560070,0xf20190aa}},	//   _בליץבריו, _quynh_, _ماہنامہ_, _kesin_,
   {{0x53430154,0x16b691eb,0xfecef0a7,0x0ec7e018}},	//   _vitendo_, _канікул_, _varnostn, _efficien,
   {{0x92004232,0x9f21f0db,0x23fa70aa,0xf3ea920a}},	//   _demir_, _utilizar_, _kurulu_, _odata_,
   {{0x925a00e9,0xf290509b,0x92cae08f,0x1200502b}},	//   _deild_, _kelas_, _hendes_, _kelis_,
   {{0xaa1440e2,0xe29051c5,0xd290c2a3,0xa201814b}},	//   _mahakama_, _jelas_, _sedam_, _verin_,
   {{0x52a601ec,0x128c316e,0x9cf75049,0x82fce239}},	//   _shiba_, _الصمت_, _लेखकों_, _gingen_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x92d85046,0x23957267,0x00000000,0x00000000}},	//   _dolen_, _abassa_, --, --,
   {{0x5394b301,0xf27e9088,0xa316b1d5,0xe25a0003}},	//   _često_, _laang_, _afrịka_, _heild_,
   {{0xeded8302,0x0202605a,0xa290c0a7,0xeb094303}},	//   _विद्यालय, _harimo_, _sedaj_, _composte,
   {{0x324a729f,0xf3f47077,0xe3ec20c9,0x22918185}},	//   _termos_, _lasten_, _sastavni_, _peran_,
   {{0xcc50400f,0x527e70b9,0x671da202,0x080a9045}},	// [5b0] _कैरेट_, _manne_, _situació, _стоять_,
   {{0xd27e90f7,0x425a0143,0x72005229,0x92004304}},	//   _maand_, _meile_, _pelit_, _temir_,
   {{0xc09a403c,0xe815201f,0x4f8c9143,0xc8d6c14c}},	//   _प्रयोगपृ, _sacensīb, _हक्का_, _कनपटी_,
   {{0x77c95049,0x0e70f004,0x2ee3d0ca,0xf38740a0}},	//   _dostosow, _לאָנדאָן_, _पूर्वाधा, _hyfryd_,
   {{0xa2905035,0xf2ddf099,0xec5370db,0x00000000}},	//   _gelar_, _otrovni_, _certeza_, --,
   {{0xe29160fb,0x0a15e161,0x5291a04a,0xe1ac4304}},	//   _negara_, _forbinde, _depan_, _adlandır,
   {{0x7f7390a7,0xcb92a008,0xff471120,0x882c7036}},	//   _posamezn, _אינדקסים_, _comprova, _доставка,
   {{0x449192dc,0x522580f7,0x50f390cc,0x8e2cc175}},	//   _धर्मे_, _markt_, _קאשוי_, _млада_,
   {{0x4edc6019,0x5737a0f3,0x1c34f024,0x1a93c0f3}},	//   _sociales_, _таблети_, _bannerlə, _монети_,
   {{0xab6130e1,0x72905045,0x07833077,0x920050b0}},	//   _तुमने_, _delar_, _harvinai, _delir_,
   {{0x1c0ae20e,0x72918175,0x1394d178,0xf27e001a}},	//   _kroppen_, _geral_, _aposta_, _paino_,
   {{0x8290c249,0x0b343005,0xcb1fc252,0xe3ea01a0}},	//   _ibland_, _sambands, _balaaran_, _feite_,
   {{0x3378804d,0xa2e120f9,0x262b1041,0x525a0054}},	//   _ひとりごと_, _pozitif_, _खेलहरु_, _neile_,
   {{0x924a71db,0x22919185,0x00000000,0x00000000}},	//   _termes_, _pesan_, --, --,
   {{0x73eab277,0x8d7c9020,0x3736d045,0xf25a0081}},	//   _þetta_, _블로그에서_, _stilling, _heile_,
   {{0x6507d1ff,0xfb132305,0xa295e28f,0x4928f0a3}},	//   _allemaal_, _hinanden_, _ajukari_, _institūc,
   {{0xf2014005,0xcc6f0274,0xa7737263,0x0a5b70a2}},	// [5c0] _fleiri_, _doprava_, _प्रसिद्ध, _večeras_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd2d85081,0xc3eae048,0x825b71dc,0x54eac031}},	//   _elles_, _toitim_, _chalon_, _第三十二条_,
   {{0x429190bd,0x998790de,0x090eb04d,0xa27a80aa}},	//   _resan_, _स्तम्भ_, _はじめまして_, _kaliteli_,
   {{0x9a23b0ae,0x86d10098,0x02fcf2b6,0x00000000}},	//   _darbinie, _symbolem_, _bygge_, --,
   {{0xf8c86017,0xdd23010b,0x0ea2f08a,0x00000000}},	//   _финансиј, _položiek_, _contiene_, --,
   {{0x3eaa703d,0xf422a020,0xa132a10b,0xe2318019}},	//   _この回答内容が不, _개인정보를_, _reklamné_, _primero_,
   {{0xe2007128,0x62d84057,0x731bd0ae,0xb2c5b04d}},	//   _venit_, _comel_, _otrajā_, _rusland_,
   {{0x52d990a8,0x420160f6,0x42d8e089,0x1c75c074}},	//   _olsen_, _begira_, _diners_, _manufar_,
   {{0xb0a92077,0xdc6bb184,0x6b1fc116,0x00000000}},	//   _подарить_, _burundu_, _salaysan_, --,
   {{0xe132a041,0x14867306,0x535f3154,0x00000000}},	//   _reklamní_, _तरकारी_, _pengine_, --,
   {{0x039490c3,0x7387f058,0xa200d241,0xb58160f6}},	//   _acasa_, _pouri_, _splitu_, _pentsatz,
   {{0x63c870b4,0x9278600c,0x1999d02e,0x52ee91df}},	//   _servei_, _okundu_, _neexistu, _asafa_,
   {{0x229011d6,0x9e954018,0x52ff4232,0xedb5117a}},	//   _aghaa_, _התלמידים_, _veriyor_, _stagione_,
   {{0x82a63037,0xc22670d4,0x2682c190,0x22e85087}},	//   _tambah_, _avukat_, _novembri, _mutfak_,
   {{0x0f240193,0xe2d8b0aa,0x227f7086,0x00000000}},	//   _zašto_, _nedeni_, _utanga_, --,
   {{0x7a5da080,0xe21a102e,0xf394d0c2,0xe13240cb}},	// [5d0] _takúto_, _centráln, _spese_, _وجوہات_,
   {{0xde9640a4,0xd386005a,0x23be0307,0x9bed7175}},	//   _राष्ट्रव, _nzira_, _živali_, _fevereir,
   {{0xe3ebf0b7,0x67433082,0x3980b308,0x00000000}},	//   _ajuta_, _курси_, _zaslužan_, --,
   {{0xd12d2173,0x001fd1e4,0xd10c80a2,0x07bb21bf}},	//   _тарту_, _greensto, _slučajev, _gjermani,
   {{0x22cad072,0xcc009044,0x08709044,0x6d7fb0a4}},	//   _mandag_, _básica_, _básicas_, _ज्योतिषा,
   {{0x82907199,0xa38b51e5,0xe2d87187,0x12907056}},	//   _cenas_, _würde_, _honen_, _menar_,
   {{0x9d44503d,0xc69c21ab,0xb407717a,0xb249f1e3}},	//   _最近の記事_, _достатъч, _autorizz, _udumo_,
   {{0x1c7512c7,0xe2d84190,0x6c7691f8,0xb0e8e05f}},	//   _रात्री_, _domes_, _tirsdag_, _christel,
   {{0xe531a156,0xac5b30c5,0x5f1e402a,0x2405d1da}},	//   _najčitan, _minulle_, _проектів_, _armonizz,
   {{0xc2d85309,0x127ff1a2,0x72d8418a,0x2dda61be}},	//   _eller_, _agung_, _nomer_, _adresị_,
   {{0x4546c07f,0x2ae21070,0x7366a04a,0xa3f851b2}},	//   _брашов_, _تھریڈ_, _tinggal_, _lolus_,
   {{0x2290c0a4,0xbf12e074,0x80d72018,0x29c52108}},	//   _celana_, _littatta, _וירטואלי, _matemaat,
   {{0xd7cc20bc,0x941e405a,0xc1e0a076,0xfb441025}},	//   _dysplasi, _kiganiro_, _हंगरी_, _औरपढ़े_,
   {{0x6343810b,0xdf7ab2db,0xbcdea069,0x829071ea}},	//   _členom_, _दुखदायी_, _hiavtxwv_, _denar_,
   {{0x226de1fd,0x3dcef020,0xd27f703e,0xc2fda22b}},	//   _katoa_, _베스트셀러_, _standa_, _tveimur_,
   {{0x8c5e3040,0xf8e680b7,0x5ee0f11f,0x9ba600de}},	//   _erstmal_, _арэтат_, _शास्त्रा, _अमित्र_,
   {{0x726f50a1,0xe2cbf150,0x2fa30018,0xd35bd04b}},	// [5e0] _piripiri_, _ujuda_, _director_, _pulgada_,
   {{0x76eb5181,0xedc410c3,0x794d403c,0x1ba4103a}},	//   _ランキング_, _articole_, _चित्रकूट_, _articolo_,
   {{0x67a9f06a,0x9ba4c14c,0x5c5ba069,0xe20271dd}},	//   _harmadik_, _संयुक्ता, _lubtsev_, _hasiko_,
   {{0x629071c5,0x2a57d04e,0xf0b3f0a2,0x00000000}},	//   _benar_, _каменка_, _američke_, --,
   {{0x9f2d6044,0xd49c007b,0x8cd39117,0x33cc5018}},	//   _advertin, _চিহ্নিত_, _голову_, _הפרשנויו,
   {{0x223760d1,0x9c5fd0f9,0x00000000,0x00000000}},	//   _völlig_, _septanm_, --, --,
   {{0xbc1da008,0xefd72100,0x3f9930b2,0x533b8130}},	//   _לשאול_, _svetainė, _xuất_, _могућнос,
   {{0x40075181,0xf8c5c04d,0x00000000,0x00000000}},	//   _甲信越地区_, _の検索結果_, --, --,
   {{0x7762b293,0x422571df,0x5c757269,0x00000000}},	//   _легендат, _abakwa_, _रहस्यन_, --,
   {{0x2e592033,0xb27e9089,0x02d8c175,0xf2ee0104}},	//   _推荐给朋友_, _quant_, _podem_, _isifo_,
   {{0x5d9ad117,0x2743d065,0x34a3b004,0xa71fb159}},	//   _статьи_, _chlúdach_, _רעפרעזענ, _akọtun_,
   {{0x0cb2507b,0x92fce02d,0x00000000,0x00000000}},	//   _মুরগী_, _dingin_, --, --,
   {{0x8fba9013,0x2170201c,0x5bf77004,0xe26cc1ca}},	//   _augustus_, _različit_, _מסתּמא_, _pulong_,
   {{0xd4f4b1c9,0x92ca91cf,0xc2d841d4,0x38cca0f7}},	//   _acompanh, _idade_, _comer_, _begeleid,
   {{0xe6d6012f,0x7c7e0045,0xe3e351df,0xa89551ea}},	//   _لايمكنك_, _versjon_, _umpristi_, _posvetov,
   {{0x8291d064,0xe2d85075,0xb27ef08d,0xfd2de0bd}},	//   _dewan_, _solet_, _iningi_, _rekipere_,
   {{0x8290c1a4,0xbc64d157,0xf27c9092,0x7ae301ab}},	// [5f0] _dolazi_, _pivtxwv_, _rezervác, _ristrutt,
   {{0x527e916d,0xd3eb730a,0x799e2039,0x9c23012b}},	//   _isang_, _quatre_, _البرادعی_, _poprvé_,
   {{0xb7661008,0xf2cad1d0,0x33f850dc,0x56b980e6}},	//   _ושומרת_, _adeda_, _folur_, _benachri,
   {{0x72b58008,0x7b5df18a,0x9b0150d1,0x00000000}},	//   _march_, _norwegia_, _sonstige, --,
   {{0xc27e0173,0xc291d1cc,0xece800ea,0xc213425e}},	//   _kaina_, _hewan_, _은평뉴타운_, _ftehim_,
   {{0xe181d291,0xb84a10f3,0x2d91e019,0xf5e5d1af}},	//   _सर्वे_, _фотки_, _cantidad_, _гледаат_,
   {{0x29adc11c,0x12ef7128,0x7d1fa26f,0x2387e036}},	//   _مجتبی_, _trafic_, _beroende_, _entro_,
   {{0x227ed02c,0x025b608e,0x32cae175,0x73eae202}},	//   _vuonna_, _poglej_, _vendas_, _ventas_,
   {{0x52da60fd,0xc2fcf011,0xbcd720fe,0x00000000}},	//   _barend_, _bygga_, _টপিকঃ_, --,
   {{0x5386d08b,0x3316f0f6,0x00000000,0x00000000}},	//   _mieru_, _baizik_, --, --,
   {{0x635aa008,0x69ebe0cd,0xa228c08b,0x53fa21d1}},	//   _perfect_, _मारवाडी_, _portfóli, _paquet_,
   {{0xd305a13a,0x82ca60dc,0x926d312f,0xddfd9170}},	//   _članak_, _ndodh_, _macosx_, _modelova,
   {{0xf7a80024,0x027ef126,0x92d840c4,0x62d8f1e9}},	//   _korrupsi, _akinek_, _pomer_, _vogel_,
   {{0x4f2e1017,0xb2d9a17d,0x92fce147,0xdac1119b}},	//   _мисли_, _amper_, _tingin_, _سنندج_,
   {{0x13f851d7,0x527e0074,0x5f21230b,0x8225f150}},	//   _solus_, _daina_, _diperken, _usuku_,
   {{0x996d40d7,0x1b88f072,0xc5ea1194,0x326c91a0}},	//   _visionat, _eksister, _формі_, _tekort_,
   {{0xfa1070ad,0x62905106,0x00000000,0x00000000}},	// [600] _assamble, _aflat_, --, --,
   {{0xf26dc22d,0x216c9153,0x7395e051,0x00000000}},	//   _izvor_, _activity_, _watsi_, --,
   {{0xaae84241,0xc3ff723e,0xcc01a0e9,0x58b530cb}},	//   _izloženi_, _berzina_, _flestir_, _گوجرانوا,
   {{0x02fce05e,0xf679c017,0xcc5d9082,0x00000000}},	//   _linggo_, _региону_, _sentrum_, --,
   {{0x7ed4005f,0xfbaa602c,0x1f2450c6,0x43cee1c0}},	//   _inligtin, _прикольн, _znáte_, _ativan_,
   {{0xa27ff146,0x924a7033,0x5348c035,0xd291a0a0}},	//   _grund_, _permis_, _infeksi_, _cwpan_,
   {{0x9386630c,0x9eb301cf,0xd1c93106,0x534301cf}},	//   _ahora_, _direitos_, _поате_, _direito_,
   {{0x42918215,0x9fee613b,0xdc9631bb,0xf20fd1ba}},	//   _gerai_, _国家体育总局_, _занята_, _محارم_,
   {{0xc3492142,0xc863a008,0x23160304,0x220191be}},	//   _diversi_, _ברלין_, _faizi_, _kesia_,
   {{0x3136d12f,0xdc5740b5,0x00000000,0x00000000}},	//   _مراقب_, _dostane_, --, --,
   {{0x628381be,0xfaf4c1c2,0xdfeaf1a3,0xaf6a300e}},	//   _mashini_, _estrange, _विभागों_, _ababawan,
   {{0x227f21a5,0x37ed4098,0x42ca5188,0xef2a21fd}},	//   _huynh_, _fotbalov, _melde_, _банковск,
   {{0x2d43d045,0xe2d980a2,0x4316808d,0x41ed4041}},	//   _автомобі, _pored_, _amabili_, _formulář,
   {{0xce173050,0x3177201a,0xa2926090,0x7c213036}},	//   _значи_, _месте_, _tirane_, _академия_,
   {{0x43893117,0x6140e30d,0x73ab5080,0x79fa40f7}},	//   _рождения_, _तिरंगा_, _stavieb_, _vacature,
   {{0xa27ff0f5,0xa2647232,0x92a68064,0xb0a2b08f}},	//   _trung_, _teslim_, _wahbah_, _コメント日時_,
   {{0x22eba0e9,0x1a748160,0xee5041b5,0x725ad217}},	// [610] _stendur_, _ranganna_, _pedalama, _fallet_,
   {{0x45fdb30e,0x4dc4107f,0xa248d1ad,0x2dc40004}},	//   _direcció, _ultimele_, _filmes_, _מאַשין_,
   {{0x7f3fa0a9,0x2ffa301a,0xd290302d,0x873b113b}},	//   _osiguran, _работник, _remaja_, _第三十九条_,
   {{0xbfb2c12f,0x2d1880c5,0xb24c50cd,0x4200b1f9}},	//   _ندعوك_, _нельзя_, _हिटलर_, _decir_,
   {{0x52df1003,0xbd1fc00c,0x426db00d,0x23eae044}},	//   _menning_, _beslenme_, _segiteri_, _centos_,
   {{0x3d5a4100,0xe61e3089,0x00000000,0x00000000}},	//   _раздавал, _laboraci, --, --,
   {{0x52fe611c,0x035f1052,0x00000000,0x00000000}},	//   _dirilis_, _bangase_, --, --,
   {{0xa343811d,0xd87ae0c8,0xa19c6065,0xd39480c5}},	//   _namenom_, _बर्दिया_, _فتافيت_, _saksan_,
   {{0xb22ac02b,0x1728802e,0x8e8ac070,0xf3ce20a2}},	//   _годам_, _publikov, _چودھری_, _kakva_,
   {{0x8806026b,0x7201e1be,0x425a5143,0xcc1d5050}},	//   _אינטרנט_, _retin_, _kelle_, _проектот_,
   {{0x43966053,0xf386a036,0xa394e100,0x1389509c}},	//   _eerste_, _messaggi_, _maisto_, _okuyita_,
   {{0xc2cae309,0x6225f30f,0x5ad741dd,0x0c54b0bc}},	//   _landet_, _lauku_, _partekat, _flatbed_,
   {{0xa8535310,0x829160d7,0x1f81f0f3,0x75f9a180}},	//   _dossiers_, _vegada_, _германиј, _फेलोशिप_,
   {{0x360860c5,0x12cae0dc,0x949ac0ea,0x425ad033}},	//   _normaali, _vendos_, _전자상거래등에서, _belles_,
   {{0x12906283,0xd22500a2,0x00000000,0x00000000}},	//   _tulad_, _svakoj_, --, --,
   {{0xeab150c4,0xf87e0094,0xb29080c5,0xc354a10f}},	//   _telefónu_, _קונטרס_, _mukava_, _tarekat_,
   {{0x6529011a,0x71abd13b,0xd2f420c3,0x47b39004}},	// [620] _definisy, _位读者读过此文_, _ultimul_, _גאַסט_,
   {{0x6759c09d,0x8487d2ad,0xa8ec8173,0x9b07d1af}},	//   _निर्मित_, _лидера_, _законных_, _лидери_,
   {{0x5257407b,0x9290403f,0x32d8c1d9,0xf56e1018}},	//   _আশঙ্কা_, _nemaz_, _boden_, _טוקבקים_,
   {{0x32926024,0x1f696039,0xabd1618d,0x2abac0e8}},	//   _israil_, _hatalmas_, _kundeser, _gravidit,
   {{0x7386a036,0x3c5420bb,0x52d1b009,0x00000000}},	//   _libri_, _lintawd_, _kelopak_, --,
   {{0xf3696233,0xd200f0f7,0xe3869254,0x2053d128}},	//   _imagens_, _manier_, _mhara_, _reprezin,
   {{0xd1d4b1be,0x9b7781a3,0xe387e0c4,0x5f5bb277}},	//   _elsebeth_, _podobnyc, _nitre_, _innanlan,
   {{0x0e10f311,0x4292004f,0x3a08402b,0xd3871035}},	//   _रामरक्षा_, _espace_, _буржуазн, _pabrik_,
   {{0x626e500d,0xe641c0b7,0x0485e007,0x00000000}},	//   _matora_, _атурэ_, _akirikó_, --,
   {{0xd2ca917f,0x82d9e040,0xb5a6d143,0x232071df}},	//   _idadi_, _alten_, _कसरती_, _munye_,
   {{0xa25ae047,0x7d9bd0b5,0xd249026c,0xc2024037}},	//   _buille_, _autoseda, _stampi_, _akting_,
   {{0x42da6237,0x5fe7e117,0x36a660de,0x1bebe0de}},	//   _kereta_, _пароль_, _प्रयासरत_, _मद्रासी_,
   {{0x805330c6,0x525ad0de,0xc0e3b008,0x82f0e057}},	//   _sportovn, _selles_, _מרחבי_, _berilah_,
   {{0x3b72504d,0x2b43a092,0x4c7830b9,0xa7c3d179}},	//   _地域共同研究セン, _futbalis, _verskil_, _любого_,
   {{0xc15bf031,0xd2eee192,0x39c27054,0xcc75a1b2}},	//   _月参加工作_, _kaffe_, _kindlust, _puasyog_,
   {{0x747ec0fd,0x71d2615d,0xca7d5221,0x46231312}},	//   _ринок_, _lifebuoy_, _kapacita_, _अण्णा_,
   {{0xe292617f,0x2199d130,0xb20070b9,0x19bf3218}},	// [630] _kitabu_, _манипула, _junie_, _meldinge,
   {{0x32da511d,0x3ac02122,0x37eab04d,0xad71e100}},	//   _katere_, _različne_, _クラシック_, _premjera,
   {{0x4bda5175,0x12d8c0b4,0xc2d8c153,0x725a905d}},	//   _родители_, _poden_, _model_, _adali_,
   {{0xa3f461c4,0xb3eae12c,0x00000000,0x00000000}},	//   _garten_, _ventes_, --, --,
   {{0x827d0255,0x6ff9c09d,0x235f3154,0x43869047}},	//   _materiál, _स्टेडियम_, _mengine_, _chara_,
   {{0xa20070c3,0x9758d182,0xee1070b2,0xb301f09e}},	//   _iunie_, _финансис, _thằng_, _murambi_,
   {{0xb37fc106,0x227e61df,0x2b7c90ea,0x2290c1c6}},	//   _romania_, _usona_, _필요하다고_, _sedar_,
   {{0xc2ca70f0,0xba6740ac,0x4652d1fc,0xfccaf15e}},	//   _dende_, _mütləq_, _braziliy, _spēļu_,
   {{0xa2902074,0xf1cbf0f6,0x0f35e054,0x6c75f1d7}},	//   _dukan_, _besterik_, _suurenda, _acarach_,
   {{0x127e4154,0xe26db216,0xd313a0e9,0xcc5fc01c}},	//   _namna_, _adword_, _umleið_, _sestrom_,
   {{0x62ca7143,0x3ea5b0f6,0x7f3c50f1,0x7c6822b2}},	//   _nende_, _bestalde_, _dikurnia, _cyprien_,
   {{0x24b630de,0xd202526b,0xdbf04100,0xa88a10ea}},	//   _कुंडी_, _action_, _baltarus, _민주노동당_,
   {{0x02ca7313,0x0200d0a2,0xe27e4111,0x43ea72b9}},	//   _hende_, _ranije_, _kamna_, _hente_,
   {{0xd2da01e3,0xf27e0184,0x4dd40018,0xadf0c19b}},	//   _impela_, _nyine_, _לאשכול_, _انبوه_,
   {{0x5f320314,0xbfeda004,0x53bbd070,0x424981d7}},	//   _preferan, _כסליו_, _اسٹاف_, _gorma_,
   {{0xcd9a30c5,0x82d960bb,0x1200c29c,0xbb0b0236}},	//   _скорее_, _ligers_, _pedir_, _resposte,
   {{0x42cae18d,0xd257d0fe,0x8bb27264,0x306300f3}},	// [640] _sendes_, _ইনস্টল_, _conexão_, _инфограф,
   {{0x7344b086,0xa3f47068,0x93790074,0x00000000}},	//   _mirenge_, _gasten_, _disamba_, --,
   {{0x2d80a291,0xadd100b4,0x8ba4813a,0x9292617f}},	//   _मुख्यमंत, _projecte_, _radionic, _vitabu_,
   {{0x370ac02b,0x00000000,0x00000000,0x00000000}},	//   _эсперант, --, --, --,
   {{0x0200f134,0xbb19e315,0x3c61412a,0x82d8a1ea}},	//   _megis_, _relasyon_, _gautier_, _dober_,
   {{0x414ec12f,0x42d8c164,0x31dec065,0x00000000}},	//   _agallamh_, _alder_, _agallaim, --,
   {{0xa27e70fa,0x4150e0aa,0xb7caf008,0xdbf5a018}},	//   _banne_, _hareketl, _respecti, _דוגמא_,
   {{0x23caa316,0x7307410a,0x629180b9,0x7c0dd02a}},	//   _zamanı_, _wilayah_, _veral_, _взагалі_,
   {{0x7394e11e,0x0308b031,0x9290104a,0x23f160f7}},	//   _ganska_, _股权登记日_, _tuhan_, _zaterdag_,
   {{0xe61210cc,0xdbe01181,0xf6b0b25b,0x51fe5213}},	//   _אַזעלכע_, _accepter, _kizáróla, _organach_,
   {{0x125ac068,0xc3f400a0,0x42e670b3,0xa3f8b2e8}},	//   _jullie_, _costau_, _stanova_, _pocut_,
   {{0x126c80a2,0xa26c6069,0x00000000,0x00000000}},	//   _nekome_, _xyoos_, --, --,
   {{0x29ed9056,0xcc1e904d,0x3d2d92c4,0xf378e208}},	//   _redigera_, _リストマニア_, _redigere_, _allaban_,
   {{0x538601e4,0xabe2602a,0x4eb3b036,0xb3eb0134}},	//   _gairm_, _створити_, _potrebbe_, _statws_,
   {{0x7c64907b,0xc4138007,0x13455016,0x00000000}},	//   _অপেশাদার_, _adisokan_, _sigurisë_, --,
   {{0xa1f1c031,0x71f74198,0x440080b2,0xf787a025}},	//   _订阅该问题_, _zemljišt, _nguời_, _तत्वों_,
   {{0xf34ef1ce,0x0aec326c,0x52f16008,0x89463045}},	// [650] _emberek_, _attraent, _saturday_, _сайтів_,
   {{0x5431507b,0x82d8c120,0x1c5f204d,0x19d7e07b}},	//   _আংশিক_, _podeu_, _ゲストさん_, _পাশ্চাত্,
   {{0x7200817f,0x00000000,0x00000000,0x00000000}},	//   _hekima_, --, --, --,
   {{0xb315d12a,0x2651b174,0xb2d8b268,0xe51a00ea}},	//   _burbank_, _educació, _voces_, _모르겠지만_,
   {{0x7394e17f,0x72a13144,0xc68230e1,0x1394b299}},	//   _maisha_, _pravidlá_, _इंकार_, _eneste_,
   {{0x32001235,0x92902250,0xeaea70aa,0x23eaf0ad}},	//   _muhim_, _sukan_, _sistemle, _dmitri_,
   {{0x36dcb030,0x927f1099,0xe3e782df,0xdb7b4008}},	//   _बंदिश_, _kazne_, _látni_, _demonstr,
   {{0xd27f40dc,0x5a376044,0xa4d76044,0x5b03a16e}},	//   _brenda_, _técnica_, _técnico_, _lárionad_,
   {{0x7d5ac118,0x69ef801a,0x72fd00d7,0x00000000}},	//   _номер_, _известны, _socials_, --,
   {{0xd290b1aa,0x11b03070,0x52cad068,0x990a306c}},	//   _dodaci_, _منسلک_, _handig_, _alabapad,
   {{0xf2e9003b,0x6977d317,0x430e630f,0x90d4d21e}},	//   _berisha_, _entidade, _vasaras_, _poručuju_,
   {{0xe3329069,0x8f4bf033,0x16269036,0x6201e259}},	//   _kojxwb_, _consomma, _алтернат, _netia_,
   {{0x81f3a008,0x8031a0da,0x4861b24c,0x00000000}},	//   _אריאל_, _मलाही_, _donnchad, --,
   {{0xefdf9300,0xd294e103,0xaa48800e,0x0cb200fe}},	//   _najvažni, _ज्यादातर_, _yeremiya_, _ইনস্টিটি,
   {{0xa84f808b,0x946571fd,0x829030c9,0x00000000}},	//   _mimoriad, _страхова, _rujan_, --,
   {{0x311da04e,0xc9e2c19b,0x5b6031ab,0x00000000}},	//   _проблеме_, _باشيد_, _обичам_, --,
   {{0xd27e0147,0x1354a1c4,0x4985001c,0xf29000fc}},	// [660] _aking_, _anderes_, _navikama_, _agian_,
   {{0x329090f7,0x9ad51081,0x5a4a8122,0xc50300f9}},	//   _staan_, _postadre, _katerega_, _refleksy,
   {{0x08ab6031,0x2bfb6031,0x19db6031,0x2c5b803b}},	//   _第三十一条_, _第三十三条_, _第三十七条_, _postimi_,
   {{0x284cd020,0xa29040a4,0x25c33081,0xcc5d1100}},	//   _않았습니다_, _cuman_, _огляд_, _portalo_,
   {{0x8200b0e6,0xc2248013,0x52019016,0xf2d980b6}},	//   _medien_, _pakken_, _besim_, _noreg_,
   {{0x704720ca,0x262240c4,0xb70e0008,0x5c5c21c4}},	//   _पर्याप्त_, _narodeni, _יונדאי_, _gestern_,
   {{0xf6590215,0x9206112f,0x124400ca,0xf5a39050}},	//   _настольк, _ناروتو_, _उत्तीर्ण_, _помеѓу_,
   {{0x38283318,0xc39602a3,0x3e1a2237,0x7c620276}},	//   _центра_, _srpska_, _dikemuka, _terusan_,
   {{0x5200f005,0xd27e70f5,0x2b3eb060,0x3af33037}},	//   _segir_, _gunny_, _wẹẹbu_, _عبدالمال,
   {{0x4def7039,0x929190dc,0xbcc4100a,0x85bd414d}},	//   _اجتماعات_, _kesaj_, _artikolu_, _контролн,
   {{0x84273154,0xa5ecc045,0xa3a25199,0x00000000}},	//   _matatizo_, _повернут, _telpa_, --,
   {{0x03f8e017,0x72267037,0x1eb16319,0xa39590d1}},	//   _ponuda_, _naskah_, _externas_, _passt_,
   {{0xa2918037,0x57bbe034,0x93692011,0xa30f600d}},	//   _kerak_, _останали, _bloggar_, _ukuboza_,
   {{0x82786106,0x53d520c2,0x02926208,0x65752034}},	//   _atunci_, _contatti_, _caraid_, _contatto_,
   {{0x71e2c076,0x86d81221,0x427f7057,0x92d87077}},	//   _करारा_, _univerzá, _duanya_, _monet_,
   {{0x7da6f099,0x9290b156,0x62d8c28c,0xc046716a}},	//   _ispitiva, _podaci_, _podes_, _लेखलाई_,
   {{0xb7816149,0x6395f1ec,0xc2cad16d,0x00000000}},	// [670] _व्यापारि, _asusu_, _pwede_, --,
   {{0xf27e6142,0xc225f076,0x0290f0db,0x2527c0b7}},	//   _skond_, _nauki_, _pegar_, _ведяу_,
   {{0x5201920d,0xd3963175,0x0c80c050,0xbbdbb19b}},	//   _resim_, _ивановск, _велес_, _فرآیند_,
   {{0xd2d46031,0x93eb0153,0x41ede180,0x8249731a}},	//   _jardin_, _status_, _मकबरा_, _nyampe_,
   {{0x237d42b2,0x22906116,0xd1d200b2,0xd173f215}},	//   _rusange_, _kulan_, _đôrêmon_, _бочках_,
   {{0xa3fa7008,0x44fb809d,0x0b041008,0x64b6000a}},	//   _forums_, _आडवाणी_, _ברגשות_, _kumpanij,
   {{0x7038e26c,0xb635b1ce,0x472d21a4,0x00000000}},	//   _dimensjo, _garanciá, _uostalom_, --,
   {{0xaef1b215,0x32786105,0x1069d10b,0x1eb7b13b}},	//   _paskutin, _olunan_, _prepojen, _中华人民共和国行,
   {{0x894730a2,0x2dbd4133,0xc2f19122,0xa341c1cc}},	//   _uključuj, _legalese_, _samostoj, _शशांक_,
   {{0xbfe3412f,0xe2d960b9,0xe09d4065,0xd27f709e}},	//   _مماثلة_, _engels_, _مقارنة_, _aranga_,
   {{0xd386931b,0xbbefb221,0x92ff4178,0x42d8b0d9}},	//   _whare_, _pardubic, _arribar_, _vedeli_,
   {{0x3bd2012d,0x1b973202,0x6a48f18e,0xa1f9b24b}},	//   _अनुपम_, _relación_, _lisensya_, _vanzemal,
   {{0xba828031,0x6380602c,0x086531bc,0x3ad00185}},	//   _市政府主要部门_, _verran_, _луѓето_, _keamanan_,
   {{0x7b27111c,0x5dc9b197,0x82fe500e,0x00000000}},	//   _المپیک_, _तथ्यांक_, _abahehe_, --,
   {{0x68868076,0x327ff143,0x58701008,0x42d97214}},	//   _मूवीरिव्, _juuni_, _standard, _akaebe_,
   {{0x831cb31c,0x2413d100,0xe394f241,0x00000000}},	//   _sábado_, _пожелаю_, _blisku_, --,
   {{0x0d85331d,0x5ecac10c,0xd500f1dc,0x82b4d12b}},	// [680] _permulaa, _leantain, _carmarth, _plochu_,
   {{0xb543f024,0x2db7a11c,0xd38780ee,0xf201a034}},	//   _komissiy, _دیپلمات_, _birra_, _страници_,
   {{0x425b00bb,0x92903087,0x93866033,0x57f37071}},	//   _kablig_, _numara_, _abord_, _версурил,
   {{0x523670f1,0x6290206a,0x8beda232,0x00000000}},	//   _janji_, _kukac_, _gerektir, --,
   {{0x4394e04f,0xe93fe093,0x7a473204,0xd255c035}},	//   _maison_, _verminde, _uključen, _दिशेने_,
   {{0x727f0052,0x4645f020,0x227ba149,0xa9f0916f}},	//   _phansi_, _소프트웨어_, _kalendář, _pronasla_,
   {{0x83a24015,0xa27e9206,0xe589b220,0x420061ae}},	//   _tempo_, _maana_, _pasaulē_, _julio_,
   {{0x40d33034,0xdfd83175,0xf3ea0282,0x63531276}},	//   _гласа_, _детство_, _boite_, _دهقان_,
   {{0xd34451a6,0x02ca8237,0x220060d3,0xf2262060}},	//   _recenze_, _dialami_, _troid_, _abuké_,
   {{0xb61c2134,0x269b20b7,0x83879074,0x00000000}},	//   _statudol_, _акциун_, _misra_, --,
   {{0xf27ec099,0xb320005a,0x3c2970ed,0xe2d830c2}},	//   _radno_, _ariyo_, _pembayar, _numeri_,
   {{0xd4e300fe,0x00000000,0x00000000,0x00000000}},	//   _বৈশাখ_, --, --, --,
   {{0xf27e616d,0xff61f316,0xb2ff519f,0x427ef18e}},	//   _iyong_, _çünki_, _biridir_, _tagna_,
   {{0xa1e2d0de,0x6290317b,0x8200321f,0xc875700e}},	//   _पसारे_, _kumara_, _nomini_, _abandalu,
   {{0x525ad0b9,0x2cfb8035,0x93f470dc,0x82d8801f}},	//   _beeld_, _प्रमाणे_, _rastin_, _hokeja_,
   {{0x22e7615d,0x0401f258,0x82d91092,0x00000000}},	//   _diendan_, _solution_, _mozem_, --,
   {{0x7291c20d,0x725a918f,0x3e7500cb,0x7421f31e}},	// [690] _devam_, _kwale_, _انڈونیشی, _politikk,
   {{0xd300413a,0xd3869124,0xc3a8d147,0x0fb4c117}},	//   _članci_, _gaari_, _dumating_, _платье_,
   {{0x20061008,0x347d41f4,0xb236711c,0x00000000}},	//   _מסיבות_, _निरभर_, _panji_, --,
   {{0xbcc8c0d3,0x4f1fb034,0xd2924189,0x82dab0e8}},	//   _يتعلق_, _partecip, _dewasa_, _datorer_,
   {{0xe58b40d4,0xdb90014f,0x8f641050,0x24074054}},	//   _approvaz, _muungano_, _економиј, _हरिदास_,
   {{0x7b19c07c,0x3290f1be,0x62000254,0x92388179}},	//   _знаете_, _aghara_, _agiis_, _краснода,
   {{0xb30e41c6,0x62fd0190,0x3341d11d,0xc34231cf}},	//   _peratus_, _akcijas_, _namesto_, _sucesso_,
   {{0x92901254,0x825ac0b9,0x6e869168,0x5c3870d5}},	//   _athar_, _willem_, _životne_, _अनुपालन_,
   {{0xb8dc422b,0x67e9a03d,0x837b9286,0xc287322c}},	//   _spurning, _ダイエット_, _skladom_, _funkcie_,
   {{0x8e1b705f,0x3b6c121f,0x00000000,0x00000000}},	//   _wetenska, _castagna_, --, --,
   {{0x4670831f,0x8c6a2024,0x520071ee,0x63f95019}},	//   _perjanji, _sonuncu_, _junio_, _alguna_,
   {{0xa7a90033,0x3320719b,0x62fe4310,0xabd1312b}},	//   _entrepri, _dunyo_, _petites_, _mezináro,
   {{0x6167613f,0x1908326f,0x857120ea,0x325a81b5}},	//   _tienganh_, _populära_, _결과입니다_, _tahlil_,
   {{0x1cbcd1f9,0xc29090b9,0xd2fce081,0xc3106073}},	//   _নবাগত_, _graad_, _lenger_, _marzec_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x3dc0e190,0xcce471c0,0x00000000,0x00000000}},	//   _policija, _traveloc, --, --,
   {{0x3386e246,0xcdebb1a3,0x525ad320,0x3ed830b7}},	// [6a0] _amirul_, _najbliżs, _tallet_, _аннсее_,
   {{0x6e43400d,0x36b0c0c5,0xa394e12c,0xeeb1308f}},	//   _ambasade_, _страницу_, _saison_, _danskere_,
   {{0xd9bec065,0x00000000,0x00000000,0x00000000}},	//   _تحذير_, --, --, --,
   {{0x222b2071,0xde7240de,0xba885077,0x00000000}},	//   _trimite_, _तुर्क_, _kokonais, --,
   {{0xdc74a081,0x698381ba,0x96d5704d,0xeceec045}},	//   _forumet_, _creidmhe, _月末日まで_, _америки_,
   {{0xac764171,0x831740c2,0x3045e25a,0x82912208}},	//   _futuros_, _prezzi_, _जंगलों_, _bucais_,
   {{0x321c6069,0x4fc230a9,0x97a5e321,0x72d9e170}},	//   _asthiv_, _previše_, _parroqui, _bojnice_,
   {{0x13878322,0x0fcbc045,0x00000000,0x00000000}},	//   _mazrui_, _свободу_, --, --,
   {{0xe27f7235,0x42925140,0x034052e2,0x2398001a}},	//   _maanta_, _metara_, _verdens_, _присутст,
   {{0x22020185,0x730d3064,0xfd8631bb,0x6c00b323}},	//   _posisi_, _pelacur_, _настрой_, _egestas_,
   {{0x5c4490ac,0x52a6a05d,0xfd5cd19b,0x62ef308c}},	//   _istirahə, _babbi_, _تجسمی_, _kimiyya_,
   {{0x537d407f,0x837ff01a,0x9a25b116,0x89fd4100}},	//   _departe_, _tahansa_, _shacbiga_, _pagamint,
   {{0xe8f13047,0xf664a070,0x52d8700c,0x00000000}},	//   _انتظر_, _مہنگائی_, _annem_, --,
   {{0x0cf931cc,0x841f10de,0xe0d5c03b,0x00000000}},	//   _घडामोडी_, _versioon_, _prezanto, --,
   {{0x13993002,0xb8d5c194,0x223f6080,0x1da3603b}},	//   _hästi_, _страхува, _prokurát, _jugoslla,
   {{0x767cf1e6,0xd27e9095,0x75056034,0x711af197}},	//   _проблему_, _nyang_, _acquisto_, _जन्मदिवस_,
   {{0x83100324,0x42ca0042,0x83ea001a,0xfc0740c4}},	// [6b0] _político, _noida_, _noita_, _vlastnu_,
   {{0x178ba028,0xe92880f3,0x66d3e082,0x1396725d}},	//   _termasuk_, _центар_, _студенті, _fyrsti_,
   {{0xa2d99039,0xa27ed047,0x429b2047,0x3d5570b3}},	//   _sosem_, _daonra_, _وكمان_, _pokazuju_,
   {{0x65765050,0x00000000,0x00000000,0x00000000}},	//   _publicaç, --, --, --,
   {{0x1a104250,0x33f400e8,0xa33d60c8,0x72cd71b9}},	//   _malaysia_, _kostar_, _zdravé_, _रिपब्लिक,
   {{0x2b11b12f,0xb565a0e1,0xc2e30033,0x73443003}},	//   _أمريكا_, _उद्धृत_, _famille_, _landinu_,
   {{0x8316419d,0x8300e084,0xebabd08b,0xee140020}},	//   _kembali_, _ceramah_, _fungovať_, _inderdaa,
   {{0x79b88045,0xd6488194,0xf512711d,0x1f5f41ab}},	//   _центру_, _центрі_, _aktualno_, _citazion,
   {{0xa386d155,0xa09ca07b,0x0c607047,0xdc66c17b}},	//   _chere_, _বিপুল_, _costais_, _protais_,
   {{0xd2eba082,0x8526a0fe,0x6ae42122,0x2aca20cd}},	//   _trenger_, _রায়হান_, _lastnost, _डायरिया_,
   {{0xa847d071,0xcf746185,0x767c0008,0xc9c51112}},	//   _бавария_, _प्रकाशचि, _ההשקעות_, _potestat,
   {{0xbf7d31f9,0xa6a8212f,0x346e21c5,0x43ead128}},	//   _সাংগঠনিক_, _وبحمده_, _pendidik, _aveti_,
   {{0x0ecc301a,0x2d222090,0x00000000,0x00000000}},	//   _avainsan, _pozitive_, --, --,
   {{0xbcbf20a4,0x326e1218,0x7f23800a,0xd2026090}},	//   _क्षेत्रा, _napoli_, _dilettan, _derisa_,
   {{0x7387002b,0xdd8100a1,0xa7bd6068,0xba1280a7}},	//   _svarbu_, _josephat_, _bevestig, _preberit,
   {{0x6c7bf035,0xc201e03b,0xb3f7f04d,0x1eb0615d}},	//   _शुद्धलेख, _ketij_, _質問した人_, _sacomban,
   {{0xbe62f017,0x87920008,0xc39e11ea,0x00000000}},	// [6c0] _регистру, _statisti, _izvajanj, --,
   {{0xe38690f7,0xf959e0a7,0x0168c0c3,0x72ba9298}},	//   _maart_, _zaposlit, _imaginil, _gradski_,
   {{0xa2ee9101,0xb2e0d12d,0x23cf82e9,0x00000000}},	//   _shafi_, _कोचीन_, _farve_, --,
   {{0xaae91036,0xc291e19e,0x75a9120a,0x62d5f01c}},	//   _прокурат, _letak_, _терито_, _sklopio_,
   {{0x12903189,0x32a64154,0x1eea7056,0x8ac6525c}},	//   _pemain_, _kambi_, _reaktion, _previame,
   {{0x70743220,0xf2e62027,0x3292508e,0xdbcaa238}},	//   _komentār, _pogledaj, _boljše_, _स्वीकृत_,
   {{0x828d52a6,0x00000000,0x00000000,0x00000000}},	//   _muqaawam, --, --, --,
   {{0x3301e190,0x92d92325,0x8f9a30ea,0x00000000}},	//   _parasti_, _colocar_, _지식포인트_, --,
   {{0x838601e4,0x9ad51153,0x3d051178,0x3431703a}},	//   _cairt_, _instruct, _instrucc, _successo_,
   {{0x03967326,0x020191fc,0xa2d8200c,0xe2a06222}},	//   _tussen_, _etsin_, _anket_, _hotboy_,
   {{0x8c293024,0x0225f00d,0x44b9f0c6,0x5d1ba034}},	//   _versiyas, _ibuka_, _inspiruj, _prendere_,
   {{0xd8c710ea,0x825b0091,0x00000000,0x00000000}},	//   _안녕하십니까_, _tabled_, --, --,
   {{0x027e61ca,0xc2d820f6,0xe322004d,0xa24841d2}},	//   _akong_, _mikel_, _ブログジャンル_, _cimma_,
   {{0x5d959008,0xd9d990ae,0x087980a0,0x2e3990ae}},	//   _פורטל_, _dienesta_, _chyhoedd, _dienests_,
   {{0x127ee077,0xb2da6058,0x93eae05a,0xfc38007f}},	//   _kuinka_, _teroris_, _uwitwa_, _executar,
   {{0x8bd58045,0xc38690f7,0xc343e061,0x36d3b02b}},	//   _soldatar, _kaart_, _privalom, _глядзіце_,
   {{0x0962202a,0x76165177,0x8261a12f,0x59565177}},	// [6d0] _коштів_, _poblogai, _píosa_, _poblogae,
   {{0xf251f0e7,0xe2918100,0x204c921e,0x17cf204d}},	//   _странице_, _geras_, _izbornik_, _サイト内検索_,
   {{0x8f5c3070,0x6201e185,0x22c6d031,0x1166d031}},	//   _ingatlan, _detik_, _第三十六条_, _第三十八条_,
   {{0xe2d840f9,0x7200c0bd,0x53200245,0xe2908074}},	//   _limen_, _aplike_, _iriya_, _bukata_,
   {{0xa378d19d,0x229180a4,0x32e9f09c,0x72c47004}},	//   _semakin_, _keras_, _bulijjo_, _באשיצן_,
   {{0x6248d0ae,0x8cdd007b,0xbda9d024,0x195dc173}},	//   _filmas_, _বাগেরহাট_, _stansiya, _vieninte,
   {{0x787390cf,0xb2918056,0x75230020,0x73f980ca}},	//   _istifadə_, _deras_, _선택하세요_, _korun_,
   {{0xb6652035,0x7200617f,0x2b53d02a,0x00000000}},	//   _वर्णिलेल, _kulia_, _телебаче, --,
   {{0xb201e1ea,0xd3513047,0x0fed9018,0x837b0271}},	//   _letih_, _meiriceá_, _לסייע_, _estando_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa387e0ff,0x5224e078,0x43ce912a,0x134b0070}},	//   _nitra_, _kankan_, _chavo_, _baleset_,
   {{0x9b27815a,0x3366a067,0x8962002e,0x67a58327}},	//   _johannes, _tanggal_, _podnikat, _komentov,
   {{0x163f31a6,0x7fe81025,0x92918037,0xb2918009}},	//   _komentář_, _स्थानों_, _beras_, _serat_,
   {{0x02d98013,0xf291e19b,0xa2018142,0xe290c092}},	//   _horen_, _betah_, _perit_, _pomaly_,
   {{0xefae12da,0x0290d328,0xf2674054,0xb3f8c06a}},	//   _ласка_, _mudan_, _alkoholi_, _indul_,
   {{0x72925136,0x7298c07b,0xa24a7100,0x00000000}},	//   _ostaje_, _অলাভজনক_, _formos_, --,
   {{0x86fa218a,0xb430b015,0x96405302,0x23a24034}},	// [6e0] _فرانسه_, _desconto_, _पारिश्रम, _tempi_,
   {{0x1f6fa0cc,0xc2489245,0x0d1ee020,0xc33f016a}},	//   _המדרש_, _inama_, _애니메이션_, _विजयादशम,
   {{0xe2d980e6,0x83f40113,0xf2d8c0ef,0xac39b04d}},	//   _foren_, _lostus_, _hideg_, _ショップへ_,
   {{0x898e10c3,0x2291a028,0x425a51a0,0x63ea506f}},	//   _парис_, _lepas_, _volle_, _volte_,
   {{0x6a14105a,0xaae7310b,0xc8887004,0x00000000}},	//   _bigatuma_, _videoalb, _שײַכות_, --,
   {{0x50e73053,0x680d01fd,0xa2eff00d,0xb0a3c218}},	//   _gemiddel, _ситуации_, _ngufu_, _колонки_,
   {{0x20d33218,0x7290d0f8,0xdcd6317a,0xf085f0c3}},	//   _класу_, _dudan_, _закрила_, _spectaco,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc290601b,0x534152ae,0x00c29122,0xd3fa50f8}},	//   _julai_, _оформлен, _priljubl, _lotura_,
   {{0x165d40c3,0xe8fd4175,0x14a70045,0x78733329}},	//   _постамен, _поставен, _благоуст, _प्रकारको_,
   {{0x1881632a,0xdb15e0d4,0xb2919240,0x13200086}},	//   _महाविद्य, _kompetit, _sesat_, _uriya_,
   {{0x7394b092,0x92025189,0x3860532b,0x520190a4}},	//   _mieste_, _ketiga_, _बालेश्वर_, _mesir_,
   {{0xad4960f6,0x4386d155,0x72ee00fa,0xd9a00197}},	//   _vvрvv_, _obere_, _ekifo_, _लक्ष्मीप,
   {{0x8fd23036,0x72d8501a,0xafd2f197,0xc320019b}},	//   _покупка_, _eilen_, _dostateč, _priya_,
   {{0xaaabb020,0xfc67d132,0x361f1098,0x00000000}},	//   _비밀번호를_, _شرعاً_, _अर्थतन्त, --,
   {{0xaa05a1d6,0x6265407f,0x73e5328b,0x7379b0b3}},	//   _satalait, _anunturi_, _इण्डस्ट्, _pokazao_,
   {{0x127f532c,0x071de277,0x00000000,0x00000000}},	// [6f0] _apenas_, _ærumeiða, --, --,
   {{0xa2d870c5,0x0ad010cb,0xc651313b,0xa682d32d}},	//   _ennen_, _ترغیب_, _无标题文档_, _आजकाल_,
   {{0x22480318,0x22d9a068,0x82ebc046,0x85389036}},	//   _snimi_, _kopen_, _prinder_, _настаняв,
   {{0x52d85090,0xe2d940a0,0xf14e4047,0x2acce1e6}},	//   _cilen_, _fideos_, _gaillimh_, _кондитер,
   {{0x67a260ff,0xe2d87081,0x703260c4,0x1f5500aa}},	//   _spotrebi, _innen_, _spotrebn, _kampanya,
   {{0xe20180ad,0xe2909147,0x0200d0e6,0x00000000}},	//   _verir_, _itaas_, _freie_, --,
   {{0xd2fce056,0x6485c0e1,0x232141cb,0x98a5d176}},	//   _pengar_, _सेनानी_, _inscrit_, _इच्छुक_,
   {{0xf320932e,0x06bec12f,0x52d8421c,0x427ff0b6}},	//   _ngayo_, _مصرّح_, _simen_, _grunn_,
   {{0x0c70b0c2,0x4950b2e2,0x4860b0b4,0x7d3620cb}},	//   _persone_, _personer_, _persones_, _مفہوم_,
   {{0xe2d94201,0x03a290e3,0x6c1cd100,0xdeb7c276}},	//   _videos_, _iwapo_, _участку_, _مراتب_,
   {{0x4340e0a4,0xed559158,0x92f3a21f,0x7470e2a8}},	//   _telepon_, _gbẹ̀yìn_, _artiklu_, _telepono_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc3ea02f6,0xa2d9c140,0x4602f0de,0x00000000}},	//   _noite_, _covek_, _स्वागताध, --,
   {{0x129090d4,0x62d87218,0x2e8790b5,0x225740b2}},	//   _lokali_, _annen_, _kalkulač, _chuẩn_,
   {{0xa8d8d025,0x1d9341df,0x4376301a,0x42d990c3}},	//   _माध्यमिक_, _jikelele_, _авторски, _atentie_,
   {{0x2342a153,0x2d92a034,0xa29001d7,0x436c70bc}},	//   _general_, _generale_, _grian_, _tingali_,
   {{0x73f4018d,0x00000000,0x00000000,0x00000000}},	// [700] _koster_, --, --, --,
   {{0x7c5b8099,0x9db4c071,0x6ae640fe,0x0c65b0ed}},	//   _postoji_, _аустрия_, _দোকানে_, _bertemu_,
   {{0x5290d133,0xb7a3e145,0x9879e04d,0x9b45e0ea}},	//   _rudan_, _području_, _ジャンル別_, _행정정보공개_,
   {{0xf25a6269,0x5342a11a,0x9ca1b0fe,0x72d2a154}},	//   _poole_, _jeneral_, _প্র্রোফা, _jenerali_,
   {{0x9139826c,0x2df480b7,0xeccd600c,0x525b0074}},	//   _identità_, _економис, _şeklinde_, _adalci_,
   {{0x3150813b,0xa615a094,0x2386f1bb,0x4fe030fe}},	//   _东营市蓝天塑胶有, _סודאן_, _skirti_, _প্রমুখ_,
   {{0x62902122,0x69226143,0xe2d8e106,0x1665332f}},	//   _tukaj_, _ओहिजा_, _cineva_, _कांस्य_,
   {{0x92909020,0x9f286300,0xb2485061,0xadec206c}},	//   _staat_, _također_, _filmo_, _adéyinká_,
   {{0x43f871fd,0x3c67b088,0xd3f87077,0xb2ba8038}},	//   _minun_, _sobrang_, _sinua_, _maadili_,
   {{0x82d9e0a7,0x32cad096,0xbb0cc03d,0xc394d0b9}},	//   _potem_, _prodej_, _でお届けします_, _minste_,
   {{0x837af1d7,0x527f1099,0x0b60f324,0x5c0c706c}},	//   _tamaill_, _kazna_, _permanec, _adarọ_,
   {{0xf2ad0037,0xc2d9e0c6,0x6212b11a,0x6f2bf22b}},	//   _شلوار_, _fotek_, _seche_, _sameigin,
   {{0x3212b315,0x4de7a1af,0x00000000,0x00000000}},	//   _peche_, _нивните_, --, --,
   {{0xe2efe048,0x525a5056,0x1200d15d,0xefdd0160}},	//   _ketnooi_, _kolla_, _mudim_, _máistir_,
   {{0x62c501f8,0xfaf2c047,0xa7e61094,0x00000000}},	//   _billige_, _beartait, _גילגול_, --,
   {{0x62e21299,0x93ea5120,0xc225f159,0x1d0b82de}},	//   _gjennom_, _molta_, _abuku_, _zaplatit_,
   {{0x6827a144,0xe913f043,0xc303f1ff,0x0de7a02e}},	// [710] _rodinný_, _anacletu, _bedankt_, _rodinné_,
   {{0x9201c220,0x0387917f,0x038c50eb,0xfc7de06c}},	//   _nevis_, _misri_, _формирањ, _ajosepo_,
   {{0xa382d06a,0xf683c11b,0x52d980d7,0xb8ccd015}},	//   _مشاھدہ_, _श्वास_, _hores_, _necessid,
   {{0x42f2b068,0x08f00070,0x12d8300e,0x725ad143}},	//   _archief_, _کلومیٹر_, _kimera_, _koolis_,
   {{0x4c5f012b,0x86cef072,0x5a8ca100,0x0fdd119b}},	//   _systém_, _behandli, _galeriją_, _لاریجانی_,
   {{0x82fda2e9,0xd27f802d,0x938f10c6,0x7ac740a2}},	//   _forhold_, _warna_, _cestován, _zaštite_,
   {{0x553641ab,0x00000000,0x00000000,0x00000000}},	//   _страхотн, --, --, --,
   {{0xcfdbf065,0xd200b156,0x33f8f1df,0xafe8b0ec}},	//   _múinteoi, _godini_, _ongum_, _हीरालाल_,
   {{0xee56c24b,0xda16c24b,0x265db132,0x13a250ea}},	//   _zdravlje_, _zdravlja_, _اسنوکر_, _helpt_,
   {{0xcfc4212d,0xd2ca51ec,0x9c73f0bc,0x4b0c5072}},	//   _ब्रिटेन_, _folda_, _opisina_, _presseme,
   {{0x2224e070,0xd17b6095,0x502bc032,0x00000000}},	//   _minket_, _samantal, _учете_, --,
   {{0x374232c7,0xa2d870f8,0x1224e192,0x00000000}},	//   _साहित्या, _ginen_, _linket_, --,
   {{0x248060ca,0x92ecb033,0x02cae013,0xb47f10b2}},	//   _विभाजन_, _musique_, _minder_, _truớc_,
   {{0x12a660e1,0x1306211d,0xd5430156,0x73a920b3}},	//   _osoby_, _dodatek_, _pronađit, _imovine_,
   {{0x52d8f039,0x6617903c,0x030e70f5,0x5c0b02a4}},	//   _engem_, _प्रत्याश, _secafer_, _obiteljs,
   {{0xaf28e085,0x330832a8,0xb9c5306f,0x9941119f}},	//   _devolver_, _trabaho_, _riservat, _populyar_,
   {{0xdad701f9,0x6291c220,0xe4cea2b0,0x7ef0e17c}},	// [720] _opinión_, _nevar_, _concello_, _विस्थापि,
   {{0x32d872aa,0x573140c5,0xddb42065,0xdaa0a0cb}},	//   _innes_, _страницы_, _شوفوا_, _ریٹائرڈ_,
   {{0x62365054,0xd149a330,0xa200602d,0x725a6119}},	//   _palju_, _מחיצה_, _kulit_, _loola_,
   {{0xe2001122,0xc2d8702a,0xa16480ff,0x4c60e2cc}},	//   _arhiv_, _annet_, _tvnoviny_, _lulusan_,
   {{0xa292620b,0x9d9e30c4,0x1c767042,0xab61112f}},	//   _berada_, _nainštal, _macular_, _teoranta_,
   {{0x32d9827e,0x825af041,0xa1c5513b,0x8c76b128}},	//   _vores_, _mailem_, _中华人民共和国国, _tuturor_,
   {{0x1200e0fc,0x3829e1e6,0x2ec15132,0xea02400e}},	//   _benito_, _четвер_, _الرضوان_, _ababatta_,
   {{0xa2ca6267,0x143da073,0xb2b4005a,0x00000000}},	//   _booda_, _अत्याधुन, _imico_, --,
   {{0x22d8c0f7,0x736e3304,0xff73e13b,0x32b401ab}},	//   _alleen_, _redaktə_, _编译或摘编的目的, _amico_,
   {{0x43ead13f,0x75a2e331,0xf3eae0e6,0x5386910c}},	//   _chotot_, _यावत्_, _hinter_, _opara_,
   {{0x17034185,0xe2cae0e6,0xf7a2811a,0x1362c332}},	//   _ज्ञानकोश, _kinder_, _kontribi, _drugiej_,
   {{0xc290b239,0xe26470a5,0x43877065,0x502b024a}},	//   _gedaan_, _meslek_, _tiarna_, _koleksyo,
   {{0x5f495333,0xfede2004,0x00000000,0x00000000}},	//   _existuje_, _אומזיסט_, --, --,
   {{0x7290f119,0xf20020a8,0xa3f871fd,0xa238827b}},	//   _sugan_, _arkiv_, _sinun_, _dlamini_,
   {{0xb975a0a2,0xe4769082,0x0f02c0c3,0x5f1e902a}},	//   _koristit, _процесі_, _аколо_, _основних_,
   {{0x0e69312f,0x024830e6,0x96fd70c5,0x326e6114}},	//   _سيدتي_, _kommen_, _проблемы_, _strong_,
   {{0x07f311a6,0xe68e313b,0x3ea3701f,0xf72681eb}},	// [730] _स्थानहरू_, _国家税务总局_, _studijas_, _камшот_,
   {{0x1e2c4030,0x7f7dc20a,0x4b0c2070,0x9c93319b}},	//   _बहुआयामी_, _измаил_, _لاشیں_, _قاچاق_,
   {{0x9305016e,0xd25ad1d5,0x4d8db091,0xd15011df}},	//   _béarla_, _elele_, _cwsmeria, _impendul,
   {{0x73f470aa,0xe2901119,0x76038133,0x0a16616c}},	//   _destek_, _mahad_, _chomatai, _адолесче_,
   {{0x4212b334,0xd71fb2d6,0x6060d160,0xf7ebb32b}},	//   _fecha_, _उद्देश्य, _substain, _पिचकारी_,
   {{0x30e8e0fd,0x2eb14020,0x1290c124,0xb3eae1b2}},	//   _artikkel, _단독다가구_, _helaan_, _mentsi_,
   {{0x82d8a0bd,0xe20091b2,0x03bd0018,0x8d8db091}},	//   _kiben_, _nraim_, _showing_, _gwsmeria,
   {{0x53870080,0x0a7d8032,0xf1943190,0x00000000}},	//   _modrý_, _полуврем, _komentēt, --,
   {{0x627ff061,0x13f9a136,0x519e802a,0x432af1d5}},	//   _kaune_, _poput_, _поведінк, _akpụkpọ_,
   {{0xf486c01a,0xc2ca41fc,0x726d8241,0xfa1721ab}},	//   _имени_, _hillari_, _skroz_, _бельо_,
   {{0x348a5122,0x2d32a072,0x5c6b7291,0xa39dc179}},	//   _apartmaj, _positivt_, _जिन्दा_, _касается_,
   {{0xd5a37335,0xbbdf22fc,0xa1b2f021,0x9bedf136}},	//   _kliknutí, _kementer, _поршня_, _ograniče,
   {{0xd2cad0a7,0x9386911e,0x6e8b5170,0x5d3201ca}},	//   _glede_, _spara_, _neskutoč, _coenzyme_,
   {{0x925aa089,0xd2fd911d,0x00000000,0x00000000}},	//   _poble_, _najnovej, --, --,
   {{0xa6b7d081,0x92b390fc,0xd5f7c07b,0x3d11c160}},	//   _категорі, _munduko_, _ছাড়াই_, _اختار_,
   {{0xe201802b,0x3395422e,0xe2cb80d2,0x3e6c0070}},	//   _kurie_, _fresno_, _derde_, _شیڈول_,
   {{0x92d8c188,0x400c6210,0x9f64204d,0xa6e2619b}},	// [740] _inden_, _privredn, _最新コメント_, _خودارضای,
   {{0xb875702a,0x96412066,0xb3a371c5,0x00000000}},	//   _студента, _ऑर्डर_, _ucapan_, --,
   {{0xe39d20b7,0x0290404e,0xb2d9e1c7,0xfc72b085}},	//   _критерий_, _numai_, _boten_, _ofertas_,
   {{0x93ac6164,0xd7c48336,0x9010c047,0x4d880004}},	//   _gruppe_, _चव्हाण_, _انتقل_, _פעלקער_,
   {{0x227ef0e3,0x77bfc337,0xef9e3065,0x00000000}},	//   _msingi_, _cokolvek_, _لحقوق_, --,
   {{0x126cd193,0xb3eb910b,0x6c1d311c,0xd12bb338}},	//   _pomoć_, _meste_, _nusantar, _servicio,
   {{0x32abc0a8,0xc3101055,0x4edc301a,0xa46672de}},	//   _håber_, _ogyahay_, _спорта_, _hyperinz,
   {{0xa3a24104,0x00000000,0x00000000,0x00000000}},	//   _lempi_, --, --, --,
   {{0x224891ab,0xc2d99033,0x02004106,0x00000000}},	//   _siamo_, _poser_, _lumii_, --,
   {{0x12d8c181,0x426e70b5,0x7249818f,0x42d8c175}},	//   _anden_, _oproti_, _bormi_, _boleto_,
   {{0xd39660a4,0x08c10039,0x4200d092,0x00000000}},	//   _urusan_, _viselked, _ludia_, --,
   {{0x61661004,0x920010ac,0x11525203,0x8320b202}},	//   _ליקוטי_, _vahid_, _станишев_, _efectos_,
   {{0xd2003339,0xaf6f3268,0xb75991fd,0x83f40050}},	//   _asmira_, _demandas_, _преступл, _postar_,
   {{0xe2cb9044,0x23eb9015,0x3c071045,0xb40241fd}},	//   _desde_, _deste_, _prosent_, _сексуаль,
   {{0xdef12182,0xb871206f,0x2ef5711c,0xbee31024}},	//   _остави_, _остава_, _panjenen, _valideyn,
   {{0xc2918041,0x8c601018,0x8f5010a0,0x00000000}},	//   _stran_, _המקצוע_, _ymosodia, --,
   {{0xc3eb90b6,0x719812a3,0x12907037,0x4db92147}},	// [750] _neste_, _specijal, _lunak_, _sapagkat_,
   {{0x56e6d2b2,0x5f247098,0xeb6c4236,0x00000000}},	//   _barayagw, _pište_, _terrassa_, --,
   {{0x8ae9021f,0x759b3158,0x566d319b,0x82c2806a}},	//   _intrapre, _aburumak, _گلکسی_, _mailben_,
   {{0x39cd903d,0x220180bd,0x6aff20c2,0x22ddc017}},	//   _コメントを書く_, _afrik_, _истината_, _košarkaš,
   {{0x73eae044,0x925420fe,0x00000000,0x00000000}},	//   _contos_, _টেক্সট_, --, --,
   {{0x867a1243,0x1fe9419f,0x92d8411d,0xe0719106}},	//   _डेनमार्क_, _müsbət_, _izmed_, _аменинца,
   {{0x038bb1b1,0xf9f6733a,0xbe19a017,0x1303026c}},	//   _menyuam_, _atrás_, _посетили_, _relatat_,
   {{0xa3eae039,0x8939904d,0x7376c1ab,0x332c6061}},	//   _fontos_, _タイからの投稿_, _христо_, _privatum,
   {{0xb98b40c2,0x42ca5299,0x92009254,0x2551213b}},	//   _richiest, _holde_, _craic_, _违反上述声明者_,
   {{0x63eb933b,0xcb69f02c,0x7341319b,0x00000000}},	//   _odsto_, _paremmin_, _جنجال_, --,
   {{0x02a60214,0x06d4807b,0x5da9d0b3,0x3730d00b}},	//   _ibibi_, _আক্রমণ_, _postupku_, _berlangg,
   {{0x8e272062,0x1b040250,0x00000000,0x00000000}},	//   _интереса_, _persekut, --, --,
   {{0x61db604e,0xe2cad239,0x06c4c13b,0x025a4224}},	//   _спортзал_, _goede_, _查看用户评论_, _znanosti_,
   {{0xfe3da008,0x86a88117,0x8ebb8099,0x0edec0cf}},	//   _נשלחה_, _значит_, _rukometn, _milyonla,
   {{0xf98bf07a,0x024940aa,0x9554c13b,0x43082061}},	//   _штрафу_, _eleman_, _小时内解决_, _jubiliej,
   {{0x6484b0df,0xb211804d,0x00000000,0x00000000}},	//   _रोजाना_, _おすすめ商品を見, --, --,
   {{0x9c7510a4,0xb28cf080,0xc0f02008,0xe36c7037}},	// [760] _शिक्षण_, _archív_, _הצדדים_, _ningali_,
   {{0xf2906102,0xcfa42070,0x3f46030b,0x00000000}},	//   _mulai_, _ٹویٹر_, _persemba, --,
   {{0x7386905a,0x93eae037,0x7f64d19d,0xfa70d192}},	//   _ibara_, _mentah_, _dibandin, _berlings,
   {{0xb386033c,0x32d9c024,0x9e4f5175,0x598050f8}},	//   _abiri_, _sovet_, _впечатли, _ostirale,
   {{0xb25e104b,0x4e54e106,0xf37ff04d,0x62d8c040}},	//   _huntsvil, _економич, _この質問に対する, _allein_,
   {{0xcc85a008,0x625b40a0,0x147b8090,0x2e9b8090}},	//   _רואים_, _apelio_, _sistemin_, _sistemit_,
   {{0x1c4b8134,0xb38691d6,0x626c6069,0x9290800d}},	//   _cartref_, _mbara_, _txoos_, _bihari_,
   {{0xc3f8b0fc,0x6f8a204d,0x52d8c0a5,0xa26e133d}},	//   _moduan_, _アメブロランキン, _giden_, _gepost_,
   {{0xa290906e,0xf29030de,0x3977626c,0x00000000}},	//   _aikasi_, _jumala_, _manifatt, --,
   {{0x65bd2056,0x7ae86144,0x5c7530e8,0xaa7d10a4}},	//   _erfarenh, _založený_, _minuter_, _sumatera_,
   {{0xb2a08020,0xde520190,0xe1e121a3,0xd096f19b}},	//   _생각합니다_, _bibliotē, _oprogram, _داداشی_,
   {{0xf38691be,0xeb7d60d1,0xd2cbe06e,0x1316900d}},	//   _abara_, _abonnier, _aguleri_, _abaza_,
   {{0x8f5c00d5,0x6d30c1ae,0x42d8c03d,0x93209087}},	//   _सिंगल_, _clasific, _viden_, _araya_,
   {{0xe585902b,0xf2d8a0bc,0x727f00a1,0x00000000}},	//   _плазмы_, _tobey_, _maanyi_, --,
   {{0x028d61c6,0xa63a90a4,0x638f1039,0x138780a0}},	//   _perkara_, _प्रश्नां, _rengeteg_, _gwyrdd_,
   {{0x027f417f,0xa2ca71cd,0x72d8c03d,0x98c0203d}},	//   _kwenye_, _monde_, _andet_, _続きを読む_,
   {{0xc2d830c2,0xbec72050,0x9386633e,0x00000000}},	// [770] _almeno_, _impostos_, _oboru_, --,
   {{0x0290d091,0x569a0050,0x227f4038,0x02f690a4}},	//   _ardal_, _нормално_, _mwenye_, _कोशिंबीर_,
   {{0xa2d8f072,0xb25ad1c2,0x12fe608c,0x8411a0fc}},	//   _ingen_, _millor_, _jirgin_, _gainerak,
   {{0x73f870c5,0x3c51e1b4,0x4683f02a,0xc2da10d4}},	//   _minua_, _tantara_, _січень_, _appell_,
   {{0xe02a32ae,0xf2b54128,0x6f9940ca,0xb2646014}},	//   _физическ, _precum_, _उत्तेजक_, _haulwm_,
   {{0x8290c040,0x0daee1b2,0x32e1106e,0xb386c0bd}},	//   _damals_, _tiffanie_, _ajunilo_, _florid_,
   {{0x22d8c082,0x731b933f,0xe3eb50ae,0x331f0036}},	//   _tiden_, _názor_, _lietus_, _mercato_,
   {{0x52d8c134,0x22918266,0x12ca7202,0x02004252}},	//   _fideo_, _teraz_, _donde_, _kamid_,
   {{0x4290c05d,0x72f540a2,0xec1f50dc,0x6104c340}},	//   _tulaga_, _obzirom_, _perandor, _mobiarmy_,
   {{0x12d8c299,0xb2d0602e,0x4c6a80de,0x73ea71cf}},	//   _siden_, _včera_, _चित्ते_, _fonte_,
   {{0xfd76206a,0x127f8029,0xd477e173,0xe30e4044}},	//   _پرِنٹ_, _karna_, _зарэгіст, _citados_,
   {{0x22d8f134,0xf290205e,0xd290205e,0xd3e75036}},	//   _angen_, _sukat_, _bukas_, _applicaz,
   {{0x938062cc,0xde735176,0x327f8055,0x4248d10c}},	//   _aturan_, _सशक्त_, _marna_, _chomas_,
   {{0x52d8c153,0xc3ea718c,0x0fb51062,0x8673b0ea}},	//   _video_, _konte_, _играчи_, _북구문화예술회관_,
   {{0xa2cb8099,0x4389a078,0xa2ab92df,0xac881173}},	//   _tvrdi_, _abiyamo_, _gábor_, _катэгоры,
   {{0x5f33a036,0x3a1100c6,0x00000000,0x00000000}},	//   _следните_, _nezapome, --, --,
   {{0xdfc20156,0xe200e2b2,0xd3f0b0c5,0x00000000}},	// [780] _najviše_, _kuniga_, _viestisi_, --,
   {{0xf9b050dc,0xf27e621f,0x71044065,0xb9bec033}},	//   _menjëher, _skont_, _مناقشة_, _effectue,
   {{0xfd70e237,0x57e54045,0x227e9119,0xd2b4006f}},	//   _perminta, _актуальн, _iyana_, _amici_,
   {{0x4f28e1dd,0x1a08609f,0x2316e11a,0x7f5b8102}},	//   _kontrola, _belangst, _prizon_, _pelaksan,
   {{0xa27f81d7,0xf29040de,0x00000000,0x00000000}},	//   _darna_, _urmas_, --, --,
   {{0x52d8c1a0,0xb31f129c,0x374ed01a,0xd28f11c0}},	//   _ander_, _mercado_, _крови_, _merkado_,
   {{0x627e911a,0x02009323,0x62d8c03c,0x72d802d7}},	//   _chans_, _orain_, _wideo_, _chiec_,
   {{0x3c012025,0x22a78121,0x00000000,0x00000000}},	//   _हरमोहिंद, _garbi_, --, --,
   {{0xb163403d,0xeb82b07b,0xfb27c204,0x22a7c0a2}},	//   _ペタを残す_, _পড়তে_, _nesreća_, _nesreći_,
   {{0xb649907a,0x1386d0a0,0xa4166060,0x00000000}},	//   _медаль_, _storio_, _ajorehin_, --,
   {{0x7ab1404d,0xffb5b002,0xd2cad122,0xa8f051b2}},	//   _お気に入りブログ_, _postitus_, _sledi_, _niagthau,
   {{0xfa0ba134,0x720ec061,0x003c1019,0x1b51f0a4}},	//   _asiantae, _палац_, _seleccio, _tindakan_,
   {{0x4e72500b,0xf2a78190,0x5af4e185,0x9d8b40b3}},	//   _जोक्स_, _darbi_, _investas, _kilometa,
   {{0x7e33611d,0xd291207c,0x9b1340fe,0x72ab91ce}},	//   _pridržan, _locali_, _পর্বে_, _tábor_,
   {{0xe2902083,0x7997813b,0x27590025,0xce4811ec}},	//   _tukar_, _突发公共卫生事件, _मूल्यों_, _aịsaịa_,
   {{0x42d8f045,0x0a1531df,0x4200e328,0x721470b2}},	//   _eigen_, _abrahama_, _dunida_, _hướng_,
   {{0x11d0e1a6,0xad90e1c9,0x7b0c311c,0x3292513e}},	// [790] _telefony_, _telefone_, _ناحیه_, _betala_,
   {{0x0c76c09d,0xd29021c6,0xf9696271,0xde27f07b}},	//   _यात्री_, _sukar_, _militare, _হোমপেজ_,
   {{0x1bc89025,0xd36f102b,0x00000000,0x00000000}},	//   _परपीड़न_, _adresą_, --, --,
   {{0x99f4a098,0x0204101a,0x11e59017,0x9ebb9004}},	//   _povlečen, _valikoim, _будућнос, _תּמיד_,
   {{0xb3870328,0x428e9047,0x222ac195,0x00000000}},	//   _sharci_, _aithint_, _показ_, --,
   {{0x63ea9011,0xb0bda04d,0x00000000,0x00000000}},	//   _plats_, _コメント投稿_, --, --,
   {{0xf36f20d6,0x858740f6,0xd0f5b10b,0x29bc81d5}},	//   _tingkat_, _bestelak, _najstarš, _adọnye_,
   {{0x1c025341,0x13ea5034,0xcbb5600c,0x00000000}},	//   _persoas_, _molti_, _projeler, --,
   {{0x02d8f11e,0xe2da624e,0x87d4219b,0xe201808c}},	//   _inget_, _koreya_, _بخشنامه_, _burin_,
   {{0x3ee9d1e5,0xc2907020,0x1f79d242,0x18e81008}},	//   _funktion, _vanaf_, _function, _התפרסמו_,
   {{0x027ff215,0x620250d4,0xf276814f,0x820261f5}},	//   _kauno_, _attiva_, _upinzani_, _terina_,
   {{0xf27ff190,0x92904128,0xc40e5036,0x83eca13c}},	//   _jauno_, _numar_, _residenz, _братства_,
   {{0x02901077,0x02918055,0x7db6810c,0x72d8c078}},	//   _rahaa_, _furan_, _acarsaid_, _ailera_,
   {{0x42d9a0f5,0x12027061,0x72d851c6,0xd29071dc}},	//   _gopet_, _kurios_, _filem_, _arnat_,
   {{0xf2a76060,0x28192045,0xa3ae2249,0x86f161a3}},	//   _sugbon_, _компанія_, _köpte_, _kontaktó,
   {{0x030d41ef,0xa9e3d017,0xfb6201e6,0x3fbbe011}},	//   _lugares_, _пожара_, _publiser, _fungerar_,
   {{0xf2904047,0xd297c17b,0xf24a11a3,0x48145190}},	// [7a0] _cumas_, _matariki_, _firmę_, _kolektīv,
   {{0x8201807a,0x83ea922e,0xb0d1807b,0xe36f2189}},	//   _kurio_, _fajtim_, _কাউন্সিল, _singkat_,
   {{0xc3a24089,0xe06422c7,0x368371f9,0x00000000}},	//   _temps_, _अक्षरे_, _producci, --,
   {{0x33ebe0e5,0x52e65218,0x59e47030,0x094db068}},	//   _dette_, _svenska_, _शीर्षस्थ_, _formulie,
   {{0xf2ed40c3,0x21862106,0xdaa3d0b7,0x82016008}},	//   _aprilie_, _економик, _индепенд, _region_,
   {{0x9295f20d,0x849d1154,0x78e372c6,0x82ca004f}},	//   _merkezi_, _matangaz, _prisustv, _poids_,
   {{0x52919074,0xc9481008,0xc200611c,0xf660b18f}},	//   _kusan_, _הגילאים_, _nulis_, _karkashi,
   {{0x03ea60fa,0xb686a070,0x12006033,0xe25a6143}},	//   _kooti_, _جدوجہد_, _trois_, _kooli_,
   {{0x93030057,0x348c60e7,0x43210205,0x00000000}},	//   _gelagat_, _naprednj, _maayos_, --,
   {{0x1d7ba0cc,0xdab0b020,0x2cf76061,0xdf69f1ab}},	//   _תלמיד_, _알려주세요_, _генералы_, _произвеж,
   {{0x05f93215,0x72480022,0xbadda0f6,0x82fe40c6}},	//   _ролях_, _shima_, _sustatze, _registr_,
   {{0xe359d207,0xb9d9a004,0x73869039,0xf20010bc}},	//   _разновид, _אינדרויס, _ipari_, _bahin_,
   {{0xce49f19e,0x72ecb031,0x025a1052,0x530300cb}},	//   _antaraba, _mariage_, _enhle_, _feladat_,
   {{0xc62a1050,0xd2f4e158,0x8387a1ea,0x5265d293}},	//   _организи, _ìyàwó_, _zapri_, _агенции_,
   {{0xc29190f6,0xd2bd700e,0x631d6120,0x5f9ed19b}},	//   _busan_, _liddell_, _tercera_, _محکوم_,
   {{0x94ba9194,0xe2904119,0x7b6a9082,0xad10704d}},	//   _статті_, _cumar_, _стаття_, _商品レビュ_,
   {{0x7b62111e,0x5d0210d7,0xa2002024,0xaefdb031}},	// [7b0] _publicer, _publicat_, _lakin_, _上的问答吗_,
   {{0x2873f1ef,0x3c637264,0x8dc53065,0xf7d0c100}},	//   _cancelar_, _outubro_, _طبخات_, _многа_,
   {{0x406d726c,0xb68cc0df,0x4ec8a07a,0xf4058098}},	//   _temporan, _बौछार_, _трансвес, _sdružení_,
   {{0x41cba045,0xcb1f90f1,0x86a82208,0x9e9ec1aa}},	//   _консульт, _bahagian_, _bharrach, _дакле_,
   {{0x5200201a,0xf27c3015,0x92cae188,0xd3eae18d}},	//   _takia_, _necessár, _vinder_, _vinter_,
   {{0xee9ec2da,0xa6ad9106,0x30f76342,0x0291b212}},	//   _файла_, _autentif, _तर्रार_, _jawaab_,
   {{0x4fc7c118,0x42b54202,0xdc7c8077,0x933c7157}},	//   _дизайн_, _precio_, _naisten_, _losxij_,
   {{0xe80a3034,0x0201416a,0xa641932b,0x00000000}},	//   _струва_, _rodiny_, _मण्डी_, --,
   {{0x34844020,0xbf5c214e,0x49c511da,0x8d8c0145}},	//   _주변정보는_, _magandan, _intestat, _jučer_,
   {{0xac07317b,0xe37b0233,0x2d9a40db,0x39cf4013}},	//   _tharciss, _espaço_, _velocida, _selectee,
   {{0x52d7d02c,0xdba6c070,0x00000000,0x00000000}},	//   _машину_, _سازشیں_, --, --,
   {{0xc2009031,0xa2d8f211,0x7697e343,0xd2027029}},	//   _frais_, _enger_, _शिवरायां, _karier_,
   {{0x42902074,0x4301a1a0,0xc2f7331d,0x4301017f}},	//   _hakan_, _verband_, _madinah_, _sayansi_,
   {{0x275aa223,0x2ee9e04d,0x6ae7907b,0x58412065}},	//   _संस्करण_, _ありがとう_, _উদরাজী_, _موريتاني,
   {{0x73a9718d,0xe4e4a234,0x438741f9,0x3388418e}},	//   _erfaring_, _प्रभावशा, _cuerpo_, _classnam,
   {{0xa2bc60bc,0x03a8e028,0x12e310b9,0x8c01c051}},	//   _kredito_, _dilarang_, _polisie_, _bangaror,
   {{0xc386d158,0xd0fed0a2,0x62fd625f,0x4db4e12f}},	// [7c0] _apere_, _društven, _byggja_, _saineola,
   {{0xd8f5f1af,0x00000000,0x00000000,0x00000000}},	//   _студенти, --, --, --,
   {{0xf3ea7015,0x826c20a2,0x73eae037,0xf29250bd}},	//   _conta_, _nekog_, _pinter_, _pataje_,
   {{0x23209150,0xe9870344,0x00000000,0x00000000}},	//   _isaya_, _देशमुख_, --, --,
   {{0xc2fc60a2,0xa4964158,0xe3f8703e,0x98626345}},	//   _ovoga_, _ògbufò_, _hinum_, _zapomenu,
   {{0x9c67f02d,0x3fe82029,0x52902074,0xbdfce1fd}},	//   _manusia_, _स्थानिक_, _yakan_, _ситуация_,
   {{0xd274c047,0xc7956286,0xb307102d,0x00000000}},	//   _سوالف_, _história, _majalah_, --,
   {{0xc0513100,0x5a0300a2,0x7dadb105,0x72925282}},	//   _хвост_, _pronađen, _mütəxəss, _états_,
   {{0x13f800b6,0x5290917d,0x0290d105,0xa3f8a035}},	//   _агентств, _praat_, _ordan_, _gedung_,
   {{0xce819068,0x3d0cb1b8,0xd3ea70c3,0xb290c12c}},	//   _서울특별시_, _комплект, _ponta_, _jamais_,
   {{0xe25ad06a,0xc290a328,0x1edc9178,0x0386c143}},	//   _amely_, _nabad_, _artistes_, _noored_,
   {{0x0386900b,0xa2009177,0xc2cb10a2,0x2f5d9094}},	//   _acara_, _trais_, _mozda_, _היתכן_,
   {{0x5c5b81a3,0xa2903276,0x38c2804d,0xfb6a0007}},	//   _postaci_, _najan_, _ドラマティック_, _aileesun_,
   {{0xe200b163,0xf38051e3,0xf290e005,0x7201a24b}},	//   _jedino_, _matric_, _einari_, _kupio_,
   {{0xf22551b2,0x77a3e145,0x457511a3,0x035951bf}},	//   _amekas_, _područja_, _dostarcz, _trafiku_,
   {{0x625ad0e8,0x505a1175,0x00000000,0x00000000}},	//   _gillar_, _променли, --, --,
   {{0xe7956044,0xea8c405d,0x6aa4d02a,0x89cb1232}},	// [7d0] _históric, _chairmen_, _севастоп, _belediye,
   {{0xa2d6a091,0xb2480139,0x00000000,0x00000000}},	//   _priodol_, _nzima_, --, --,
   {{0x62b4325e,0x43877175,0xd3f8f346,0x5200d0b9}},	//   _entità_, _quarto_, _sigue_, _brein_,
   {{0x329040c5,0xb053c16c,0x97b3512a,0xa290412c}},	//   _samaa_, _солиде_, _geospati, _maman_,
   {{0x16e20017,0x9290410a,0x852ef17f,0x9291b347}},	//   _резултат, _laman_, _mwendesh, _hrvata_,
   {{0xa4d65030,0x5b1fc04c,0xb003603f,0x00000000}},	//   _हाजिरी_, _kelantan_, _konsultā, --,
   {{0x627f0267,0x9471e057,0x31c5519b,0xf93212d3}},	//   _mwangu_, _hantaran_, _اضطراب_, _rasmusse,
   {{0xa200d22b,0x1ce0503d,0x02fc6347,0x73596031}},	//   _grein_, _削除用パスワ_, _svoga_, _compléme,
   {{0xed3b013b,0x42904154,0xf547e0c3,0x03806020}},	//   _国家知识产权局_, _tamaa_, _белорушь_, _sturen_,
   {{0x42ca7036,0x2312216a,0xacf7118e,0x61a8803f}},	//   _mondo_, _प्रमाणपत, _southwar, _maksimāl,
   {{0x729040d8,0xc4fec1ab,0x82b6630c,0x00000000}},	//   _jaman_, _временно_, _marcha_, --,
   {{0xfff3e11d,0x8bdd3129,0x5290f128,0xd2862208}},	//   _nepremič, _बछिया_, _rugam_, _dunkeld_,
   {{0xe4b470f8,0x2cb7b13c,0x5c8011bc,0xd3cba018}},	//   _didaktik, _границе_, _лесен_, _לפגוע_,
   {{0x02948052,0x139571dd,0x1291c024,0xd29160f7}},	//   _ofakazi_, _osasun_, _arvad_, _gegaan_,
   {{0xb290414e,0xd2004297,0xe281b038,0xa290c12a}},	//   _naman_, _namin_, _jamhuri_, _delano_,
   {{0x22fce1d6,0x4a442004,0x4ef5a07b,0xded75097}},	//   _fingal_, _טראפיק_, _আরাফাত_, _bonitetn,
   {{0x2291e0bd,0x508a2218,0x48995175,0x8723c065}},	// [7e0] _detay_, _чиновник, _ориентац, _جهازك_,
   {{0xc2caf12e,0xd2918348,0x64a7e0d7,0xf2ea5264}},	//   _pridaj_, _otras_, _organitz, _região_,
   {{0xa38660d7,0x0a8fd2cd,0x93bfe0ea,0x4201a11d}},	//   _acord_, _penipuan_, _맨마지막글_, _kupil_,
   {{0x42bfc2df,0xf2f23027,0xd2cb9266,0xb2d870cb}},	//   _شمشاد_, _putovanj, _dokonca_, _kinek_,
   {{0x06678025,0x00000000,0x00000000,0x00000000}},	//   _बेकसूर_, --, --, --,
   {{0x20d7a0cc,0xf4128295,0x1cb281a4,0x1dffd02d}},	//   _הגאון_, _sarajevo_, _sarajevu_, _ketentua,
   {{0x4290422b,0x4d41719d,0x2be231ab,0x02e950f9}},	//   _gaman_, _membantu_, _inserisc, _andidan_,
   {{0xcbddc1f7,0xa046416a,0xcc64d0cb,0xceb3b13c}},	//   _बप्पा_, _zeměděls, _اکیڈمی_, _smernice_,
   {{0x74b821cc,0x62373062,0xd7a55165,0x00000000}},	//   _विशेषतः_, _filmova_, _umoristi, --,
   {{0xb9d7a1b0,0xaa77a0d5,0xc033902a,0x4290e18a}},	//   _प्रयाग_, _प्रभाग_, _демотива, _manawa_,
   {{0x1cd7d0a9,0x4236d0a2,0x2ceed032,0x3734a0ff}},	//   _pretraži, _svojoj_, _среде_, _rosnička_,
   {{0x8290500c,0x00372117,0x0d05e008,0x37a5e089}},	//   _kalan_, _группа_, _introduc, _introdui,
   {{0x72905028,0xd3f9b1b2,0xf2fcd187,0x337fd029}},	//   _jalan_, _nique_, _blogak_, _belanda_,
   {{0x320050dc,0x1df62008,0xb3341004,0x027ef055}},	//   _dalin_, _מיליארד_, _סאציאלע_, _idinku_,
   {{0x4394600e,0x7c625098,0xb2c43035,0xd292610c}},	//   _amosi_, _rubrice_, _televisi_, _afraga_,
   {{0x5886d349,0x82a770b2,0xe9eb70fc,0x32027100}},	//   _प्रस्ताव, _muaban_, _langilee, _kurias_,
   {{0x7025318a,0xb3877084,0x359f90ed,0x9da6916f}},	// [7f0] _عوارض_, _luaran_, _pengetah, _navikava,
   {{0xfd173070,0x28b6d19b,0x00000000,0x00000000}},	//   _علاقوں_, _شرايط_, --, --,
   {{0x72005246,0x738070fc,0xc387a0bd,0x00000000}},	//   _halin_, _mauris_, _espri_, --,
   {{0x0d94515e,0xa6dea19f,0x738692a9,0xe290d128}},	//   _finanšu_, _məsuliyy, _abari_, _vreau_,
   {{0x0ff1d243,0x1ed410ae,0x16e60105,0x3c02b044}},	//   _नियुक्ति_, _palielin, _kampaniy, _básico_,
   {{0x320041be,0x59f36031,0x127ff06d,0x491e20de}},	//   _tamin_, _constitu, _jauna_, _पत्रिकाक,
   {{0xe291d088,0xe998e061,0x32903241,0x4f054230}},	//   _buwan_, _каментар, _nemamo_, _mišković_,
   {{0x1e539107,0x329050aa,0x5ea6421f,0x02ec620e}},	//   _медицина, _falan_, _interess_, _teknisk_,
   {{0x925af0a8,0x62005119,0x56bd613c,0xdc1d20ad}},	//   _nogle_, _galin_, _операциј, _kitablar,
   {{0x8a04c0d4,0x6a25a00e,0x6752505c,0x835fe221}},	//   _dibattit, _abachaga_, _सेलिब्रि, _legendy_,
   {{0x8201133c,0x83e0706a,0xfa57707b,0x00000000}},	//   _bibiri_, _héten_, _করুনঃ_, --,
   {{0x62905024,0xc33da070,0xd26c5017,0xbebb204f}},	//   _yalan_, _ہتھیار_, _belog_, _tourisme_,
   {{0x227ef086,0x826c50f5,0xd5f3a032,0x7cd7c047}},	//   _ibindi_, _tabindex_, _моменти_, _إعداد_,
   {{0x1770b34a,0xe3f8211c,0x2306b23e,0x43b67144}},	//   _क्लासीफा, _tikus_, _samalah_, _dievča_,
   {{0xe03cd03a,0xdfa4f153,0xb351d031,0xdc76732b}},	//   _recensio, _november_, _其版权属于商务部, _सिल्वर_,
   {{0x0c66b192,0x53a0c273,0x07f24098,0xd756d17c}},	//   _bestemt_, _удостове, _नजिस्क्य, _परिषद्_,

   {{0x4ffad035,0x529080de,0xa25521ee,0x927f005d}},	// [800] _परवानगी_, _tahaks_, _directam, _abangi_,
   {{0x2069802c,0x32a7818f,0x9a48d1a5,0xca3dd19b}},	//   _напомина, _harbi_, _freeship_, _مانکن_,
   {{0xe25a600f,0x230c31be,0xa200b33a,0x62a7818f}},	//   _poolt_, _nazaret_, _pedido_, _karbi_,
   {{0xbc446181,0x0200225e,0x72f42018,0xcf0a00f3}},	//   _プライバシ_, _żmien_, _באחריות_, _симптоми,
   {{0x437970ca,0x4b40b020,0x220050f6,0xf200d10c}},	//   _poradna_, _남겨주세요_, _balio_, _greis_,
   {{0x63f83206,0x53e54142,0x00000000,0x00000000}},	//   _kamusi_, _imputati_, --, --,
   {{0xd2480024,0xa2e9f0dc,0x2ead8050,0x00000000}},	//   _daimi_, _gjendet_, _комисија, --,
   {{0x348680de,0x96b11016,0x3200518b,0x125ad0de}},	//   _बाजारी_, _sigurish, _talin_, _milles_,
   {{0xa3bbb05a,0xdc00d100,0xa36c7061,0x6d70f02c}},	//   _indwara_, _maistas_, _lengvai_, _varmista,
   {{0xa320718f,0x42907154,0x838690a8,0xd57fe19e}},	//   _sanya_, _sanaa_, _vcard_, _peruntuk,
   {{0x22d8c122,0x4f239004,0x9f735282,0xaa42908f}},	//   _videl_, _דעפארטמע, _parcours_, _プラズマ処理室内,
   {{0x6290f064,0xc20190c4,0x227f401e,0x017d9018}},	//   _bahawa_, _musia_, _tienen_, _מיתוג_,
   {{0x6422503a,0xe291d18f,0x82912209,0x23ead091}},	//   _indirizz, _ruwan_, _ticari_, _doeth_,
   {{0xe68a70e7,0xb1772017,0xf3f83269,0x28c751fc}},	//   _организо, _месту_, _samuti_, _stadionu,
   {{0xdff2c170,0xb320734b,0x21cc9033,0x13f8f120}},	//   _presvedč, _tanya_, _activité_, _sigui_,
   {{0xc3f82090,0xde91312f,0xa200d065,0x7616a0d0}},	//   _sikur_, _ينبغي_, _breis_, _ballkani,
   {{0x42b4003f,0x82d8d093,0x8870105e,0x115a8082}},	// [810] _teica_, _dieet_, _pakiramd, _situasjo,
   {{0xc0741004,0x127ff067,0x1dfad0af,0x09bad1ea}},	//   _גניבות_, _hyung_, _povezave_, _povezava_,
   {{0xd3949063,0x1d5fb2a5,0x49fe417a,0x00000000}},	//   _amasi_, _במזיד_, _verament, --,
   {{0x92d8c153,0x22927133,0xa290d10c,0x00000000}},	//   _under_, _turais_, _treas_, --,
   {{0x7a9740de,0xc225706e,0x44695032,0x0e26802f}},	//   _सम्मान_, _apakan_, _пристигн, _халяву_,
   {{0x42903133,0x627f02b2,0x183b603d,0x2aa760cd}},	//   _camara_, _abandi_, _こんにちは_, _डिप्लोमा_,
   {{0x920032c3,0x1248d247,0x77ca5100,0x3d09103c}},	//   _wajib_, _asompi_, _verslini, _उपलब्धि_,
   {{0x027f41a9,0x65af3260,0x7200517f,0x4305201c}},	//   _mwenge_, _споразум, _walio_, _ostalom_,
   {{0x92d98187,0x1290724d,0xb2ec6153,0x9287c276}},	//   _diren_, _canan_, _february_, _نفرات_,
   {{0xaa083070,0xa3c1f045,0x82e95247,0x960ad042}},	//   _تصدیق_, _географі, _aganihu_, _algonqui,
   {{0x7387e190,0xe1483179,0x2249705e,0x00000000}},	//   _katru_, _kaverill, _alamin_, --,
   {{0xb387d12b,0x53eb90d9,0xff041144,0x6230506e}},	//   _dobrý_, _boste_, _chladnič, _ademola_,
   {{0x1aefb134,0x4cbd4018,0x00000000,0x00000000}},	//   _hystyrie, _disabled_, --, --,
   {{0x33eb804f,0xda226172,0x1f07006c,0xd290f039}},	//   _porte_, _kwicande, _abẹla_, _magad_,
   {{0x4deb31ab,0x4c025100,0x8f53d1bc,0x9c35a332}},	//   _странно_, _verslas_, _домашна_, _ostatnic,
   {{0x52cb5040,0xa1c7311c,0x024830e8,0xd949d1f4}},	//   _wieder_, _هاستینگ_, _kommun_, _पारसनाथ_,
   {{0x2ba4f011,0xf291f024,0xe00820cc,0xa420e0ea}},	// [820] _diskuter, _tutan_, _געגנטן_, _개인정보의_,
   {{0x5759d025,0x4dbd2119,0xb2d85090,0xf95651fd}},	//   _निर्यात_, _arrintaa, _cilet_, _студенто,
   {{0x7386d158,0x13ebf0e8,0x52cae272,0x00000000}},	//   _apero_, _sluta_, _bindur_, --,
   {{0x1f22907b,0x9637c1ab,0xc2d98232,0x00000000}},	//   _কাঁচা_, _файлове_, _giren_, --,
   {{0x4a39216c,0xa31b60a5,0x82e56171,0x5b5cb27d}},	//   _веселие_, _müzik_, _mínimo_, _jedinečn,
   {{0x92cae072,0x62eb6008,0xb2009221,0xd3178017}},	//   _findes_, _changes_, _mikiny_, _ubrzo_,
   {{0x525a5134,0xa00521af,0xad49f170,0xa726e082}},	//   _colli_, _огромна_, _filtráci, _дисциплі,
   {{0x6387009d,0x4292604e,0x6204116a,0x3b0c3036}},	//   _dobrze_, _durata_, _probíhá_, _rapprese,
   {{0x095630c3,0x2ee9d0ee,0x42b281dd,0x7320700c}},	//   _минуте_, _funksion, _munduan_, _banyo_,
   {{0x3479f057,0x527ff06e,0x7f2170ea,0x53eb9096}},	//   _diletakk, _ikuna_, _홈페이지를_, _roste_,
   {{0x1e55e0fc,0x627ff074,0x4290d34c,0x395f606c}},	//   _espainia, _shuni_, _mudar_, _afonrere,
   {{0x125b9230,0x229071c0,0xfa963166,0xa888e0e7}},	//   _posle_, _tanan_, _नर्मदा_, _фејсбук_,
   {{0x025a9053,0xb32091ca,0x23eb50b9,0x24180187}},	//   _zoals_, _maayo_, _pieter_, _nabigatz,
   {{0xf2d981e2,0xb9ef40d3,0x1200f121,0x5f5d4133}},	//   _ziren_, _استعادة_, _nahita_, _disarman,
   {{0x339b103d,0xbb7450b7,0x320072bd,0x5f6a500e}},	//   _こんばんは_, _реглемен, _sanin_, _ababaman,
   {{0x92eff05d,0x52fc70e6,0x3c716126,0x1d20c05d}},	//   _okufa_, _menge_, _المختوم_, _abasibir,
   {{0xa2d84072,0xd290a124,0x0ee3b34d,0x42fc7081}},	// [830] _timer_, _rabaa_, _महत्वाका, _lenge_,
   {{0x85be71aa,0x55040106,0xfcdf602b,0x9129f0d7}},	//   _формиран, _produsul_, _аспектах_, _formació_,
   {{0x4290a05e,0xc2d850e8,0x7eacc2f9,0x226c8298}},	//   _laban_, _filer_, _dovoljen, _sinoć_,
   {{0xf6a9024d,0x529051da,0x00000000,0x00000000}},	//   _litreach, _talab_, --, --,
   {{0x32489154,0xb2d87211,0x12fcd14a,0x6a76f100}},	//   _chama_, _ihnen_, _ndege_, _частку_,
   {{0xf630b12f,0xed86b08e,0x00000000,0x00000000}},	//   _الأبيض_, _vrednost_, --, --,
   {{0x6386d05d,0x1200a154,0x3afbc1a1,0x02da707e}},	//   _mberi_, _tabia_, _peperiks, _jeremi_,
   {{0xa35571ad,0x89b96106,0xe43aa04d,0x00000000}},	//   _cabelos_, _алеӂерил, _相棒探しから_, --,
   {{0x29243004,0xbd86c036,0xa2907199,0xf94e9163}},	//   _אָנװײַז_, _награди_, _manam_, _maglovit,
   {{0xa2cb4144,0xc290a18f,0x840490b9,0xb4c7b34e}},	//   _predaj_, _daban_, _intussen_, _buscando_,
   {{0xb485211f,0x839fc047,0x99a41117,0x923b413b}},	//   _अर्थात_, _اصدار_, _опции_, _控制面板首页_,
   {{0xe3543084,0xc201c229,0xb29021c4,0x82cb8122}},	//   _selepas_, _kuvia_, _jemand_, _morda_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe2907095,0xa249913a,0x2f5d301b,0xe5f66178}},	//   _banal_, _bismo_, _merancan, _esperanç,
   {{0x6ad07032,0x82d8526d,0x00000000,0x00000000}},	//   _инфекции_, _biler_, --, --,
   {{0x4b6121f9,0x5d8740a2,0xf24110cb,0x46a5b076}},	//   _también_, _međunaro, _منقطع_, _energety,
   {{0xcc9ec031,0xd69a5304,0xd24991eb,0x344f3004}},	// [840] _新农村建设_, _sakinlər, _eismo_, _אומשולדי,
   {{0x7202602d,0x7815107b,0x3ed78034,0x03eb8011}},	//   _terima_, _প্রখ্যাত_, _другата_, _borta_,
   {{0xb2f3019a,0x525ae133,0x84b3f05d,0xc23b21a0}},	//   _proiect_, _chille_, _abachwez, _klimaat_,
   {{0xb2fcd0a2,0xc3f99078,0x4c7361ae,0x72906209}},	//   _svega_, _sisun_, _podrás_, _aslan_,
   {{0xfee2d173,0x72907235,0x6316403a,0xe30c3057}},	//   _атаку_, _sanad_, _bambini_, _pelapis_,
   {{0x33f47089,0x31ed110b,0x1c1d81fb,0xc26ce210}},	//   _sortir_, _formulár, _רשעות_, _osnovu_,
   {{0xd56400cc,0x46cc211a,0x2c2c2108,0x00000000}},	//   _לאנדאן_, _ekspresy, _ekspress, --,
   {{0x0e3931a1,0x3e4300ad,0x42918190,0xb7f13175}},	//   _kebangsa, _almaniya, _kuram_, _скара_,
   {{0x6b280008,0xc2918208,0x22024172,0x92d8b008}},	//   _התייעץ_, _curam_, _ulwimi_, _modern_,
   {{0x0fa98126,0x2becd13f,0xa30310cb,0xa2d8e099}},	//   _تبلیغی_, _superthr, _مشرکین_, _kineza_,
   {{0xfb8d102a,0x12d870b5,0x0394704d,0xf45f20a4}},	//   _artistar, _ihned_, _件を表示していま, _अध्यात्म,
   {{0x1f612293,0x08712107,0xb6293047,0x827ee09c}},	//   _остане_, _остана_, _traidisi, _ayinza_,
   {{0x3105d1f9,0x83e2506a,0x00000000,0x00000000}},	//   _পাশাপাশি_, _természe, --, --,
   {{0x37a300bb,0xe29201e8,0x0ead8017,0x00000000}},	//   _cerulari, _otpada_, _доминира, --,
   {{0x63ac6295,0x22e8e074,0x024c81f2,0x22007083}},	//   _ukupno_, _miliyan_, _होखला_, _isnin_,
   {{0xdf7cf03c,0x03eb90d4,0x2019e17e,0xd290605e}},	//   _पुस्तकें_, _bosta_, _хиротони, _kulay_,
   {{0x9290a124,0x93eb902c,0x5286c22e,0x8291605a}},	// [850] _qaban_, _josta_, _sibhawm_, _bigari_,
   {{0xb373f10b,0xefe71118,0x32bd7208,0x48db2053}},	//   _zadajte_, _заявка_, _riddell_, _leerling,
   {{0xca1c0100,0x54d7d0ec,0xbe917018,0x84013221}},	//   _маленькі_, _वेटिकन_, _district_, _infolink,
   {{0x92fe4116,0xe44ba158,0xa248c23e,0x939da061}},	//   _weeraray_, _àdéhùn_, _salmah_, _palangoj,
   {{0x23967089,0xbeab70ab,0x00000000,0x00000000}},	//   _passen_, _dimecres_, --, --,
   {{0xc200a1d2,0x6290c058,0xf2e3209f,0x02918144}},	//   _rabin_, _madan_, _maniere_, _juraj_,
   {{0x5290c18c,0xa51090fc,0x805e615b,0xa394002a}},	//   _ladan_, _hurrengo_, _moontlik_, _reise_,
   {{0x4303a0a2,0x9067a34f,0x3d3c211c,0x65fa70fe}},	//   _pitanju_, _आकासे_, _میدهد_, _হবিগঞ্জ_,
   {{0x92a6516f,0x7201b233,0x3c773072,0x00000000}},	//   _daljini_, _devido_, _kristne_, --,
   {{0xf99970a9,0xb25520c2,0xec684065,0x23f401a0}},	//   _traže_, _direttam, _patrún_, _suster_,
   {{0x81440116,0xab399017,0x35864055,0xb94090fe}},	//   _federaal, _договоре_, _raadinay, _রংধনু_,
   {{0x82ca6214,0x7784f0a8,0x4290c051,0x5f5d301b}},	//   _koodu_, _frivilli, _kadan_, _perancan,
   {{0xe292521f,0x327ed12a,0xd2e11183,0x1ed11350}},	//   _totali_, _bennie_, _anuncio_, _anuncios_,
   {{0xd2d9e18d,0xf200c1d2,0xbefc91d5,0x5c620029}},	//   _enten_, _dadin_, _agụiyi_, _jurusan_,
   {{0x7cce12b6,0x1394e177,0x00000000,0x00000000}},	//   _tyskland_, _lansio_, --, --,
   {{0x6366d130,0x0965b07b,0xe34521c4,0xf7c710c3}},	//   _ponedelj, _অদ্ভুত_, _handelt_, _машиний_,
   {{0x107c212f,0x0087b036,0x5b1f219e,0x4da01056}},	// [860] _ملعقة_, _природат, _kemaluan_, _avancera,
   {{0x4c0521d6,0x2085e0b5,0x058fa008,0xa27e900d}},	//   _lakselv_, _komplexn, _אמצעי_, _ijana_,
   {{0x3200c074,0x52ba2351,0xf2d9119f,0x42026293}},	//   _hadin_, _ponekad_, _gizem_, _equipe_,
   {{0x6ee410b9,0x3a941056,0x7ad7c022,0xdeda90b7}},	//   _artikels_, _artikeln_, _mummunan_, _абундент,
   {{0xa12d2036,0xbaf50090,0x42caf044,0x92266119}},	//   _части_, _evropian_, _unidas_, _markan_,
   {{0x885b3070,0x5200c05b,0xe202606e,0xdc60e0f2}},	//   _ellenére_, _milioi_, _afrifa_, _puluhan_,
   {{0x77b1f0f7,0x6ec1627b,0x00000000,0x00000000}},	//   _vertrouw, _komntwan, --, --,
   {{0x926cb0c9,0x58cdd159,0xd3432065,0xf63a3259}},	//   _redova_, _adékò_, _نافذة_, _praitici,
   {{0x854d6173,0x1291c066,0x46b2e054,0xe15401f6}},	//   _візуальн, _नियोजन_, _चहेता_, _vlastito,
   {{0x5615a094,0x6d9bd199,0x12fdb018,0x00000000}},	//   _טומאה_, _fotorada, _ratings_, --,
   {{0xadc47061,0x6200a19e,0x62d830ae,0xdbf5a008}},	//   _konkursa, _habib_, _valodas_, _אובמה_,
   {{0xa344907f,0x60ddd07c,0xb5c4d07b,0x099950a2}},	//   _citeste_, _положите, _ময়মনসিংহ_, _svakodne,
   {{0x12918189,0xa7b3611a,0xec5d913b,0x439501ae}},	//   _murah_, _konstiti, _功成名就闯大都_, _clases_,
   {{0x1387719a,0xc3ea7121,0xc386e0da,0x7ea7013b}},	//   _foarte_, _kontu_, _cairan_, _掘进工作面_,
   {{0xc7541036,0x1290a16d,0x4290b04a,0xb200b177}},	//   _независи, _babae_, _macam_, _pacio_,
   {{0xe7e4b0de,0x53207185,0xf985132a,0x5201f05f}},	//   _negatiiv, _nanya_, _अभिमान_, _stuit_,
   {{0x03207064,0x82f1e11c,0x07a8200a,0xbd7e8070}},	// [870] _ianya_, _variasi_, _approssi, _kézműves_,
   {{0xf320704a,0x22b082c9,0x527ed1a9,0xe3ead05f}},	//   _hanya_, _कानुन_, _gyonna_, _toets_,
   {{0x23207088,0xcba4212a,0x4e4ff095,0xc29071c0}},	//   _kanya_, _artikulo_, _pinakama, _kanaa_,
   {{0xf2fce34b,0x533d0037,0xf6b950f7,0x53a2d04f}},	//   _sangat_, _ایلام_, _belangri, _propos_,
   {{0x32d9e02c,0xf3eba2f7,0x7b07d017,0xb271d01f}},	//   _miten_, _sixtus_, _патријар, _jānis_,
   {{0x22d9e081,0x96f9c043,0xeb6720d1,0xa203d195}},	//   _liten_, _saibnkaw, _momentan_, _процедур_,
   {{0x7201f009,0x0c6f70f8,0xd2e20297,0xaf64c1a3}},	//   _putih_, _horrela_, _spoiled_, _negatywn,
   {{0xe224003e,0x21f591d5,0xc387f054,0x8cbec061}},	//   _leika_, _afranịọs_, _lauri_, _капец_,
   {{0x1290b1dd,0x7a01801a,0xce20319b,0x92b7301a}},	//   _bidali_, _marrasku, _آلودگی_, _другими_,
   {{0x06377116,0xf6d8b0a4,0x37866077,0x4f3fe144}},	//   _barnaami, _mahasisw, _turvalli, _nakoniec_,
   {{0xac52815d,0x03407092,0x1449904d,0x258ec1e3}},	//   _denthan_, _nedeľa_, _ドを忘れた_, _isatifik,
   {{0x820040a5,0x4fe3211c,0xe347c011,0x8037d13b}},	//   _izmir_, _رایتل_, _handlar_, _在这种情况下_,
   {{0x8d38e106,0x534d913b,0xa2d9e0dc,0x00000000}},	//   _milioane_, _中央电视台_, _diten_, --,
   {{0x0495e11d,0x3273012f,0xd2d8a128,0xea2de0c5}},	//   _potrebuj, _dúnta_, _liber_, _победите,
   {{0x16dc2243,0x12498051,0xd3028352,0x00000000}},	//   _पारित_, _girma_, _izdanju_, --,
   {{0x425bf315,0xb20180dc,0xb2ac711a,0x4b6bf121}},	//   _boule_, _arrin_, _popilè_, _justizia_,
   {{0xf290c124,0xdb9b5068,0x4301e0da,0x00000000}},	// [880] _hadal_, _technisc, _garansi_, --,
   {{0xc9f341f1,0x93a2c068,0x8387f159,0xa07700b0}},	//   _prostred, _helpen_, _aburo_, _carcharo,
   {{0x5151011c,0x51a100cb,0x07f29099,0xdbd2904d}},	//   _اشتغال_, _اشتعال_, _prebaciv, _コレクション_,
   {{0x748e9241,0xdfc49025,0x63eb702e,0x00000000}},	//   _napravlj, _पॉजिटिव_, _platba_, --,
   {{0x420031e3,0xc39660c5,0xd6016063,0x32903073}},	//   _simila_, _varsin_, _atilanti, _tematu_,
   {{0x529000c3,0x3290c241,0xa3f47120,0x2e70e00f}},	//   _chiar_, _izlazi_, _partit_, _झुण्ड_,
   {{0x72d9e012,0x00000000,0x00000000,0x00000000}},	//   _intet_, --, --, --,
   {{0x6248d211,0x22b65315,0x8606b2b9,0x28bbe04d}},	//   _thema_, _mouche_, _sammenli, _キャラクタ_,
   {{0x7200c0bc,0xc625d1a3,0x62900047,0x00000000}},	//   _balita_, _pomorski, _thiar_, --,
   {{0x92919035,0x724991ae,0xcc7142d5,0xd2f741a1}},	//   _rusak_, _misma_, _मोर्चे_, _kalimah_,
   {{0x3200c267,0x72d76198,0x9b69c01a,0xb200c077}},	//   _kulima_, _navodno_, _договора_, _valita_,
   {{0x825a500f,0x2343107f,0x82d8311d,0xbc6f502e}},	//   _mille_, _сорока_, _člena_, _ostrava_,
   {{0x725a5353,0x0c36f04d,0x397ec20d,0xe25ad106}},	//   _lille_, _この質問の閲覧数_, _kelimele, _unele_,
   {{0x3e56c215,0xddbd3236,0x22d9c0dc,0x74d200fe}},	//   _проста_, _superfíc, _enver_, _নিরপেক্ষ_,
   {{0x225ac0ff,0x8290b06c,0x9486023a,0x32cbf11a}},	//   _okolie_, _kadara_, _प्रातः_, _soude_,
   {{0x0200f25f,0x622000de,0x8bdf20e8,0xd4b93035}},	//   _dagin_, _viljandi_, _semester, _प्रेमात_,
   {{0x946ee117,0x0723e01c,0x94203262,0x1290a1d1}},	// [890] _время_, _kulturom_, _उपलब्_, _tabac_,
   {{0x13ebf098,0x0c5bf03b,0x930db008,0x3df1b041}},	//   _historii_, _histori_, _ויופי_, _sledovat_,
   {{0xc57e4091,0xa200f1c0,0x3814d01f,0xe3940143}},	//   _benderfy, _nagin_, _kafejnīc, _reisi_,
   {{0x5f79f1ec,0x5b1f40ea,0xc2c9602b,0x00000000}},	//   _atapịagh, _효과적으로_, _гальштук, --,
   {{0x425ba0f5,0x047a70bb,0xd57e3259,0x36dad0b7}},	//   _amply_, _pontmain_, _reiligiú, _ачестора_,
   {{0x607c212f,0x017d90cc,0x604dc02a,0x23f400c2}},	//   _الفقه_, _עיבור_, _проте_, _nostri_,
   {{0x1ccc1037,0x3a12e1cd,0x537f8086,0xe27f7104}},	//   _ایرنا_, _inscrive, _muhanga_, _nyanga_,
   {{0x8200c088,0x7805207b,0x9824a060,0xe5a1f03b}},	//   _salita_, _জালবাজ_, _fẹ̀ẹ́_, _politikë,
   {{0x97b74098,0xe29250b2,0x1b7b319b,0x2d20c1fd}},	//   _poplatek_, _vitalk_, _اتوکد_, _известно,
   {{0x0ef150f6,0xba11f1ce,0x92d9e01a,0xf96720ca}},	//   _kaмep_, _garancia_, _siten_, _prosinec_,
   {{0x337b90c8,0x629e716e,0x48ef60ea,0xc2ba9046}},	//   _skladem_, _céard_, _각종계약서_, _academi_,
   {{0x28b6e16e,0x82122205,0x22fcc0bd,0xe91b70b2}},	//   _عرايس_, _mukha_, _malgre_, _giảm_,
   {{0x12d85276,0x3c604033,0x3348606f,0x7bf5a018}},	//   _dalem_, _lettres_, _clienti_, _גוטמן_,
   {{0xd980e119,0x93eaf02c,0x42cad03f,0x1200f106}},	//   _arrimaha_, _kiitos_, _bildes_, _schimb_,
   {{0xe2d9e354,0x8ff82020,0xa388f231,0xf695c092}},	//   _antes_, _클린중개업소_, _unutrašn, _prezentá,
   {{0x1f0d1185,0x8200d1e5,0x635f902e,0x8290d1ee}},	//   _संस्कृती_, _preis_, _recepty_, _crear_,
   {{0xc346d173,0xa290e142,0x615a9036,0xdc035271}},	// [8a0] _vandens_, _finali_, _difficil, _físico_,
   {{0x368fe091,0x561c5076,0xf2d71086,0x226cf154}},	//   _gwreiddi, _podlaski, _mirongo_, _yehova_,
   {{0xa57e4134,0xd29711c5,0x03410035,0x3c7440a0}},	//   _penderfy, _panjang_, _जाणून_, _mesurau_,
   {{0x43f8524d,0x37f68273,0xf320f00e,0x42918057}},	//   _calum_, _текстове_, _nagyo_, _izzati_,
   {{0xe291f039,0xa1e1e0cb,0xae1200d1,0xf290a1be}},	//   _mutat_, _کمزوری_, _vereinba, _dabaa_,
   {{0x9fd30099,0x32d8c04f,0x229090b9,0xfab7b01b}},	//   _postojeć, _aider_, _schatz_, _keikhlas,
   {{0x4298012e,0x42cae063,0x7386d080,0x9386a2e9}},	//   _vďaka_, _windos_, _vcera_, _bidrag_,
   {{0x32918039,0xa394000d,0x5200b355,0x822401df}},	//   _marad_, _afise_, _hacia_, _afike_,
   {{0x1591d068,0x9c626356,0x038062e1,0x92d8d119}},	//   _안녕하세요_, _escribe_, _aktris_, _sheeg_,
   {{0xebf5a008,0x12bb90b9,0xac6122c4,0x8aad619e}},	//   _עולמי_, _engelse_, _består_, _berkesan_,
   {{0x79d22282,0xe818e045,0x41e33202,0x31efb19b}},	//   _enregist, _договору_, _autoprom, _گیگابایت_,
   {{0x22d842d7,0xa77d3065,0xbe96d19b,0x8c5bc090}},	//   _gamek_, _الحزب_, _آرزوی_, _sikurse_,
   {{0x6229102c,0xa0d7c07f,0x526e4009,0xefac11ab}},	//   _показать_, _биколор_, _atribusi_, _promozio,
   {{0xc3a0103d,0xd0f9e357,0x6239302b,0xdf2d6264}},	//   _ログインして投票, _forhandl, _розум_, _através_,
   {{0x2b824068,0x33bef231,0x22d8b057,0x7394f07a}},	//   _standaar, _staviti_, _paderi_, _keisti_,
   {{0xccc9c017,0x327f4034,0x8378d074,0x7af040ea}},	//   _многим_, _utente_, _lamarin_, _구매평가를_,
   {{0x22fce067,0xc44ac173,0x7d1e213b,0xf290f02d}},	// [8b0] _banget_, _джона_, _明星大哉问_, _gagal_,
   {{0xe2d8509d,0xe2912051,0x2e99711a,0x439401c4}},	//   _dalej_, _kayan_, _kontinye_, _meist_,
   {{0xa3f8c1cc,0xc711b0de,0x77a37151,0xc387e128}},	//   _tidur_, _जबरदस्ती_, _protecci, _patru_,
   {{0x1ef1e0de,0x5b91e025,0x7290c1e2,0x928a40a4}},	//   _विश्वामि, _zamieszc, _delako_, _पर्यटणस्,
   {{0xf2efd044,0x53940143,0x42d88252,0xcd403065}},	//   _galicia_, _neist_, _arkeen_, _انتهت_,
   {{0x017d90cc,0x52d8c161,0x6381a07b,0xe30d207f}},	//   _חילוק_, _sider_, _দাঁড়িয়, _sambata_,
   {{0xac764358,0x9348d122,0x6290f0ef,0xbe47e252}},	//   _estudos_, _katerih_, _magam_, _farabada,
   {{0xed8df2a3,0xd2911209,0x385f20bb,0x27c961a3}},	//   _odgovara, _yazan_, _missnoob_, _postanow,
   {{0xf2ca717d,0xae96b1d4,0x02911295,0x0a861158}},	//   _einde_, _bastante_, _kazao_, _adanikan_,
   {{0x529122bd,0x02ca7146,0xa91b70b2,0x42e5c020}},	//   _bayan_, _finde_, _hoàn_, _통신판매업_,
   {{0x0310706a,0xbd96a143,0x1bdf828a,0xd3930070}},	//   _hiszen_, _tallinna, _ruhenger, _سینکڑوں_,
   {{0xac0480c4,0xc7c4b062,0xfaee112c,0xf933e19b}},	//   _uhasili_, _околност, _quotidie, _زارعی_,
   {{0xe052812b,0xa2eeb200,0x723181be,0x64b84098}},	//   _poznámka_, _štimac_, _akomako_, _एभरेष्ट_,
   {{0x841dd11c,0x4bee1100,0x3d182234,0xadd102bf}},	//   _سالگی_, _каток_, _कारबाही_, _एकाएक_,
   {{0x421340aa,0xfa4480b7,0x33a2a04d,0x86514065}},	//   _şehir_, _алэтурь_, _ご利用案内_, _العثور_,
   {{0x01682008,0x7e55d173,0x27274241,0xa1dc10fd}},	//   _כתוצאה_, _думаем_, _poslodav, _клубу_,
   {{0xb202617a,0x00000000,0x00000000,0x00000000}},	// [8c0] _aprile_, --, --, --,
   {{0x62d98038,0xfaed00bc,0x4c09e118,0xe431f0fe}},	//   _gazeti_, _carleton_, _propria_, _জড়িত_,
   {{0x98372071,0xc9d9a1dd,0xe290c154,0x8227b061}},	//   _паралел_, _esperime, _silaha_, _крайняя_,
   {{0x1e18e03f,0xf206e08f,0x00000000,0x00000000}},	//   _galerija, _クリックで拡大_, --, --,
   {{0x929b408b,0x1c23a094,0x5289c1bd,0x82904048}},	//   _izbový_, _קראון_, _سقراط_, _mimax_,
   {{0x12918359,0x80492036,0xd21240b2,0x08c8904d}},	//   _aurat_, _периода_, _bumha_, _と投票しています_,
   {{0x92b4700c,0x126c20c5,0x26f76030,0x4291819e}},	//   _bence_, _alkoi_, _दयावान_, _surau_,
   {{0xb291c002,0x32a71222,0x825af1b1,0x431c61d7}},	//   _arvan_, _cacbon_, _yogli_, _anabarr_,
   {{0x821c00e6,0x8a142040,0x7e542036,0xb70540fe}},	//   _bisher_, _finanzie, _finanzia, _অস্বীকার_,
   {{0xa2d98041,0x8d3cd031,0xa20110ac,0xb290317f}},	//   _firem_, _发表评论于_, _fazil_, _jamani_,
   {{0xc9919091,0xd2011175,0xc25b235a,0x6e52b037}},	//   _technole, _vazio_, _ciclos_, _perbanya,
   {{0xe712f02a,0x28f291ab,0xb482f0c5,0x00000000}},	//   _форумі_, _интервют, _форумы_, --,
   {{0x3d9ca1a3,0xd26af0b7,0x78dc207c,0x00000000}},	//   _kolekcje_, _апариция_, _кутии_, --,
   {{0xc201802b,0xa291803f,0x3d5f9008,0x3468302c}},	//   _kuris_, _kuras_, _המקיף_, _планируе,
   {{0x7460720b,0x82250037,0xb20180a3,0x8ed5c082}},	//   _menerusk, _anakku_, _juris_, _kopierin,
   {{0x2290f1c5,0x02905055,0x12e31041,0x308cc100}},	//   _bahasa_, _dilay_, _policie_, _слове_,
   {{0x0361a0eb,0xc290f051,0x0dff5328,0x2aa840ea}},	// [8d0] _основу_, _mahara_, _bandhiga, _지속적으로_,
   {{0xfc7140de,0x37a6b076,0x127f7086,0xf9e850c5}},	//   _मार्गी_, _spotkani, _nyanza_, _kustannu,
   {{0x3b09012f,0xeb0b304d,0xb2d830b5,0x63f871c0}},	//   _تذكرني_, _一部例外あり_, _objem_, _tanum_,
   {{0x130da1d6,0x47a6b175,0x7237f35b,0x4f46916a}},	//   _freiburg_, _текстови_, _abuja_, _समाजशास्,
   {{0x420191d6,0x7628b153,0x5201a025,0xc46bc179}},	//   _kasie_, _navigati, _mapie_, _скидки_,
   {{0xc35880ab,0x736ce160,0x329181c5,0x1f7b41d0}},	//   _pàgina_, _margadh_, _surat_, _afẹde_,
   {{0x170e10cc,0xd51b9008,0x527ee010,0x9291214b}},	//   _אוודאי_, _ההצעה_, _mennyt_, _hayal_,
   {{0x68464085,0xa2a6c113,0x2785f03f,0xe2246184}},	//   _realizad, _coobme_, _normatīv, _bwoko_,
   {{0x9f165025,0x0299e0c1,0x417d303b,0x92914047}},	//   _शादीशुदा_, _svojím_, _parandal, _theach_,
   {{0x3291810c,0xdf2d8076,0x90dd70cb,0xd2da406a}},	//   _turas_, _serdeczn, _فیڈرل_, _motoros_,
   {{0xb20201f5,0x6925a036,0xbe232046,0x8b33c0d1}},	//   _misiri_, _главата_, _gwefanna, _gegenübe,
   {{0xa2010038,0xbae811cc,0x794c0004,0x4e38f12f}},	//   _kabisa_, _सर्वत्र_, _באזונדער_, _carachta,
   {{0xb0f62008,0x74459041,0xfc78e19f,0x1d6a4045}},	//   _הבחירות_, _गण्डकी_, _fərqli_, _показати_,
   {{0xaec7a19b,0x7319220f,0x00000000,0x00000000}},	//   _میدهند_, _dibilang_, --, --,
   {{0xe2245087,0x51c6b008,0x02c6b134,0xa202107f}},	//   _belki_, _category_, _categori_, _copiii_,
   {{0xb2903139,0x73fe506a,0x19d94008,0x02aa10a5}},	//   _zamani_, _amerikai_, _governme, _kapsamın,
   {{0x3ec211b2,0xf3eae0da,0xc755e044,0xf200c2d7}},	// [8e0] _vientian, _lintas_, _católica_, _eclick_,
   {{0x43eb530f,0xe59f100f,0x14017065,0x78a42018}},	//   _vietas_, _करुणानिध, _المؤلف_, _אנגליה_,
   {{0x827ec092,0x361f1251,0xde46e039,0x4200c18e}},	//   _fronte_, _resoluci, _karbanta, _haligi_,
   {{0x5d07b0cc,0xbb60104d,0xc7b9d1cc,0xcb14d004}},	//   _ארטאדאקס, _ショッピングカ_, _memungki, _אָרטאָדא,
   {{0x1f3f600f,0x6dc82030,0x92fe50e8,0x00000000}},	//   _ट्विस्ट_, _सत्यदेव_, _utrikes_, --,
   {{0x111b0020,0x4856419f,0x30b12035,0xc2d8b035}},	//   _개인정보취급방침_, _əslində_, _बिरुटे_, _macet_,
   {{0x92f3a004,0x10d33117,0x4ed65083,0xe7b4807b}},	//   _הרבני_, _класс_, _dilindun, _নিষেধাজ্,
   {{0xa3f8f20a,0xe2b201be,0x29ab5077,0x791b70b2}},	//   _sigur_, _abadaba_, _остальны, _toán_,
   {{0xbd9dc163,0xe2d8c35c,0x973890bc,0xe3fdc1a3}},	//   _jednosta, _galega_, _unforgiv, _jednostk,
   {{0xa9176031,0xb25a50dc,0xc2027124,0x9f6ad00f}},	//   _地方商务之窗_, _tilla_, _nasiib_, _बिंदिया_,
   {{0x93ba725b,0x63ea9214,0x4290c07e,0x6a19c080}},	//   _privát_, _anata_, _maladi_, _matúš_,
   {{0x126c50a4,0x898d4175,0x366ef13b,0xfd0d41e6}},	//   _alloh_, _популарн, _中国经典经济现代, _популяри,
   {{0x02919028,0x029101be,0xf201109d,0xf2b66025}},	//   _pusat_, _dabara_, _razie_, _marcin_,
   {{0xb2e852ad,0x4394f147,0x34ab2221,0x99585092}},	//   _poslednj, _moises_, _keramick, _posledne,
   {{0xe201b0f5,0x3200b10b,0x07c3c07b,0xc2003154}},	//   _davita_, _akcia_, _স্মরণ_, _kamili_,
   {{0xc358935d,0xb3f8219d,0x32900084,0x02fc935e}},	//   _página_, _takut_, _skian_, _klage_,
   {{0x63ea0142,0xd3687081,0x2ef0707b,0xfed78084}},	// [8f0] _uniti_, _наприкла, _মাহফিল_, _hakikatn,
   {{0x4d3921a5,0x5290c091,0xce31a09d,0x395120c5}},	//   _mobifone_, _gydag_, _प्रक्षेप, _automaat,
   {{0xa25b70f1,0xd201f0b9,0xb873c175,0x8313c1cf}},	//   _amalan_, _bruin_, _procurar_, _procura_,
   {{0xf2cae070,0x5f0ef0b2,0x02249154,0xa3ebf17d}},	//   _mondja_, _nhếch_, _kwako_, _foute_,
   {{0x8db4311c,0x5c530116,0xf65a8070,0x7edc21aa}},	//   _کوروش_, _kastaba_, _اہلسنت_, _албански_,
   {{0x0d4390cc,0x8dfcc045,0x121a91a3,0x12e772c3}},	//   _סטעיט_, _учитель_, _एकदिवसीय_, _bernama_,
   {{0x33a9214e,0x43a2c037,0xc3f8a35f,0xfee1019b}},	//   _maaaring_, _campur_, _qabul_, _جداگانه_,
   {{0xab0172bb,0x620090bb,0xc5831017,0x0291f090}},	//   _posición_, _khaim_, _москви_, _gruan_,
   {{0x9201e0bd,0xe2d8b0c3,0x339501fe,0xa312816a}},	//   _natif_, _facem_, _časem_, _křišťálo,
   {{0xf3f9117b,0xe5a3a16c,0xc34b606a,0x5a14e267}},	//   _zaburi_, _елементе_, _médiaajá, _ababuuza_,
   {{0xd7b611da,0x726ca360,0x4ceec017,0x00000000}},	//   _apprendi, _ambos_, _америку_, --,
   {{0x0526e015,0x9ca3e004,0x8681a0d5,0x12f05154}},	//   _carrinho_, _ארגינעלע_, _जयराम_, _bilioni_,
   {{0x7cc511a2,0xc2fce19d,0xa2c9c18e,0x2163804d}},	//   _اریکسون_, _tengah_, _hotlink_, _円以上ご注文頂き,
   {{0x2290e0f1,0xb27ef040,0x92f041da,0x4290c074}},	//   _hanafi_, _bringt_, _delitti_, _filato_,
   {{0x8c7cb010,0x527f4355,0x62d82018,0x03eb90c2}},	//   _tekstin_, _fuente_, _takes_, _costo_,
   {{0x9c9631bb,0x92d9c225,0x75f3a14d,0xf7ef51d3}},	//   _заняла_, _livet_, _довести_, _चहलकदमी_,
   {{0x62b352c0,0x9b32e04d,0xc0c1d0c5,0x420271ae}},	// [900] _cumarsái, _ジの先頭へ_, _основе_, _varias_,
   {{0xee0ba008,0x9637f006,0x3847f1a3,0x934d2122}},	//   _שליטה_, _reklamow, _reklamod, _katerem_,
   {{0xf200c1da,0xf224717f,0x43eb91af,0x227e6068}},	//   _validi_, _benki_, _gosto_, _avond_,
   {{0xbfeba008,0x72646006,0x148502e0,0xb852413b}},	//   _בהמשך_, _anuluj_, _स्नातक_, _中文科技期刊数据,
   {{0xee91604f,0x82b31133,0x8b8a21af,0x272e1076}},	//   _histoire_, _meadhan_, _мојот_, _zapamięt,
   {{0x584d2173,0xe3add190,0x8319c047,0x6cfd20a7}},	//   _sistemos_, _tāpat_, _إيران_, _sistemov_,
   {{0x12f0c17f,0xd39490d3,0xffeda0ca,0x127f4346}},	//   _hadithi_, _measa_, _ग्राफिक_, _siendo_,
   {{0x23eb5061,0xc3949047,0x6300931d,0xb25a5044}},	//   _vietos_, _leasa_, _separuh_, _fillo_,
   {{0xf460f039,0x627f7184,0x60afe0fd,0x0af17020}},	//   _berendez, _afande_, _контракт_, _opdracht,
   {{0x56aee04d,0x8dc380cc,0x63f470f3,0x03eb00ed}},	//   _ジのトップへ_, _מארטש_, _curtir_, _diatas_,
   {{0x6307b25d,0x6ad7300f,0xfaf5718e,0x1d60113b}},	//   _komandi_, _postitat, _moroccan_, _澄城县人民政府网,
   {{0x225ad249,0x53f84100,0xc8de825a,0x12d84018}},	//   _fyller_, _namus_, _विस्फोटक_, _names_,
   {{0xe212b0d1,0x10f3b004,0x62fd208d,0xe8563118}},	//   _suche_, _באזוך_, _ujohane_, _загуби_,
   {{0xe3eb80d7,0x33793101,0xe847a065,0xcbdd634d}},	//   _morts_, _labarin_, _اللواء_, _धनिया_,
   {{0x122b8355,0x487d804e,0x727ff1cc,0x1058112a}},	//   _siempre_, _комемора, _ujung_, _escalato,
   {{0x3faa407b,0x02c660bb,0xe387f06c,0x73eb8120}},	//   _পড়াশোনা_, _kasmoos_, _aburu_, _forts_,
   {{0x427ef1b0,0xe2e09117,0x65e95082,0xade740ea}},	// [910] _opinii_, _profiili_, _зростанн, _부동산써브의_,
   {{0x820180fc,0x02247126,0xc4ce0175,0xbf0b90a2}},	//   _saria_, _senki_, _криминал_, _premijer_,
   {{0xe20181d0,0x22d9025b,0xc273a084,0x0fbc724b}},	//   _larin_, _videó_, _peribadi_, _englesko,
   {{0x06368361,0x06c73020,0xa2d41004,0xb2504067}},	//   _vikipedi, _고객님께서_, _אנטקעגן_, _पायेंग_,
   {{0x16368361,0x87e620ca,0xb83f609a,0x135540a4}},	//   _wikipedi, _अवार्ड_, _después_, _disebut_,
   {{0x12009014,0x412a61fd,0x2afa5188,0xa475310f}},	//   _phais_, _пропусти, _branchen_, _disertak,
   {{0xa465126c,0x47a7304f,0x1e5361cd,0x03788051}},	//   _integraz, _partenai, _inscrire_, _kananan_,
   {{0x13f8418f,0x13a8e283,0xd2d84294,0xb3dc1157}},	//   _jamus_, _talagang_, _james_, _plhws_,
   {{0xe2fca056,0xd9aac045,0xe2d95006,0x00000000}},	//   _skrivet_, _годин_, _okolicy_, --,
   {{0xb7834228,0x7e76f16a,0x42918040,0xc2489007}},	//   _धारावाहि, _klikněte_, _daran_, _abamo_,
   {{0xd25a524c,0xae19e261,0xc84c11cd,0x83877116}},	//   _cille_, _selengka, _certains_, _sharaf_,
   {{0xf380600f,0x4e76607b,0x33ea90c3,0x72a05128}},	//   _korral_, _ময়মনসিং, _piata_, _fotbal_,
   {{0x13f820a7,0xf2caa002,0x02018205,0x97b4c31d}},	//   _nakup_, _विचारणीय_, _narin_, _menerang,
   {{0x320e10b7,0xfcc08117,0x00000000,0x00000000}},	//   _натал_, _одноклас, --, --,
   {{0xa201808c,0x225a5133,0xbc1d20a5,0xad0721ea}},	//   _harin_, _gille_, _kitaplar, _neprimer,
   {{0x6c34f0c3,0x42018074,0x8a535045,0x55a7119b}},	//   _descoper, _barin_, _сертифік, _شکنجه_,
   {{0xc291906e,0x32918138,0x73870056,0xb2d890a0}},	// [920] _lasan_, _caran_, _klarar_, _sbaen_,
   {{0x92b650bd,0x038aa07b,0x6ece913b,0xa2ca5082}},	//   _touche_, _আক্রান্ত_, _上海联放贸易有限, _bilde_,
   {{0xf615a004,0xee29b04d,0x43f9e1e2,0x32ca0269}},	//   _מוצאי_, _ジャンルランキン, _ditut_, _liidu_,
   {{0xb290c230,0x820181d2,0x92dab024,0x31eb104d}},	//   _nalazi_, _farin_, _fotolar_, _マタニティ_,
   {{0xb2019175,0x59d0a0b9,0x92018362,0x72918252}},	//   _assim_, _advertee, _garin_, _garan_,
   {{0xb9d2217e,0x22926209,0xf25a50dc,0x82d85081}},	//   _inregist, _burada_, _tille_, _talet_,
   {{0xc807a153,0x22027202,0x8291f12b,0xb27e907f}},	//   _מתאים_, _varios_, _zuzana_, _avand_,
   {{0x8a80d2f2,0xf290d24d,0x92918074,0x8d86b120}},	//   _tehotens, _shean_, _yaran_, _entendre_,
   {{0x2c4a2025,0x6e521057,0x59e852c1,0xbde8e0ea}},	//   _योजनाओं_, _dinafika, _postignu, _커뮤니케이션_,
   {{0xc5d3d130,0x8242e09d,0x6db6c025,0x6291813e}},	//   _елемента_, _चावला_, _रामशलाका_, _varan_,
   {{0x531731df,0x0f54013b,0x00000000,0x00000000}},	//   _kancane_, _建设项目环境影响, --, --,
   {{0xc291f0c5,0xf6dd715c,0x12ba70ef,0x8348b0fe}},	//   _ostaa_, _नीतिश_, _mondani_, _যানবাহন_,
   {{0x191320ed,0xa3f8805d,0xd5901154,0xc3f9e221}},	//   _pembangu, _yakuna_, _kupunguz, _titul_,
   {{0x63833068,0xa200e05f,0x7200119d,0x8c85b004}},	//   _자유게시판_, _geniet_, _akhir_, _מוזיי_,
   {{0xf8af41bd,0x23ea71e3,0xb291a057,0xd201a010}},	//   _استطاعت_, _zinto_, _lapan_, _lapin_,
   {{0x2201814e,0x0291818c,0x93957241,0x5340e0e6}},	//   _parin_, _paran_, _opasno_, _gelesen_,
   {{0xb29051c5,0xe25a51b8,0xc2025039,0x6cb3717f}},	// [930] _iklan_, _sille_, _attila_, _jumatatu_,
   {{0xb2b50071,0x4b2570f8,0x72e590d4,0xb50c728c}},	//   _produse_, _uniberts, _teknika_, _febreiro_,
   {{0xa52bb05a,0xde950008,0x02a2a12f,0xc4550248}},	//   _munyakaz, _products_, _بمنطقة_, _producto_,
   {{0xa291a035,0x3c554060,0xc201a18e,0x498b5220}},	//   _kapan_, _ṣugbọn_, _kapin_, _preču_,
   {{0x99e212cc,0x13f400f8,0x7bdfc0fd,0x927ee20e}},	//   _कट्टा_, _laster_, _modeller, _venner_,
   {{0xfb14c118,0x426c5126,0xe4354055,0x620df0c3}},	//   _избор_, _dolog_, _hambalyo_, _апринса_,
   {{0x0378a102,0x8394f2e2,0x4ef8e017,0x72fcd0b2}},	//   _makanan_, _priser_, _министар, _ringme_,
   {{0x926c22c6,0x227fb1aa,0xd2eff0b3,0xc2247053}},	//   _tokom_, _оставили_, _nedostaj, _denkt_,
   {{0x72919101,0xeea210bc,0x03f85185,0x42d9c0c3}},	//   _wasan_, _assurant_, _jalur_, _анений_,
   {{0x93f8c0a9,0x0a6f0098,0xf429713b,0x4ecda143}},	//   _usluga_, _véčka_, _国家烟草专卖局_, _komisjon,
   {{0xb2ca71be,0x32483109,0x637f601a,0xaae7c056}},	//   _windo_, _kommet_, _избранно, _styrelse,
   {{0x1d5d9010,0x32480264,0xac6200d8,0xa6f2717a}},	//   _популярн, _acima_, _turunan_, _интериор,
   {{0x9200c2a3,0x9c0c80ea,0x26a5d21f,0x09ca313b}},	//   _molimo_, _무이자할부_, _konformi, _国家环境保护总局_,
   {{0xedc3a0cc,0x40f3a004,0x00000000,0x00000000}},	//   _דריקט_, _דאטום_, --, --,
   {{0xf2b4d149,0x131831f5,0x8741013b,0x82fcd128}},	//   _trochu_, _paschal_, _政治交接学习教育, _alege_,
   {{0xf386e0d3,0x8300f057,0xcb8b8272,0x73967045}},	//   _foirne_, _risalah_, _familjar, _visste_,
   {{0xd3a2c0ed,0x2af76122,0x5d8df02b,0x2347c1ab}},	// [940] _hampir_, _zasebnos, _autobusa, _allerta_,
   {{0xeda8d185,0x3c5b8099,0x00000000,0x00000000}},	//   _aktivita, _sastoji_, --, --,
   {{0xf3949008,0x5b1db0ea,0xe20de071,0x825b413f}},	//   _least_, _세계적으로_, _апринс_, _dielac_,
   {{0x2d748194,0x52009024,0xa20180a0,0x46de10ea}},	//   _авторизу, _sakini_, _wario_, _워디안이나_,
   {{0x152e0008,0x9290d0e8,0xc200b038,0xee4c31e6}},	//   _לונדון_, _senare_, _madini_, _списки_,
   {{0x13a2405d,0x357391bb,0x42fa303c,0x13423036}},	//   _kumpi_, _педагога, _kuchnia_, _accesso_,
   {{0x7d2c3036,0xd386006a,0xdcdf9070,0x147720ca}},	//   _списък_, _amire_, _negatív_, _अग्नी_,
   {{0x02ca704e,0x5ddc2070,0x43ea7090,0x4f4170ef}},	//   _vinde_, _حلقوں_, _vinte_, _المحجوب_,
   {{0xa3940254,0xc2ece276,0x3b60f033,0x262eb203}},	//   _ceist_, _alkitab_, _permettr, _операция,
   {{0x5fed2031,0x92c8a19a,0x63b4b1a3,0x016920a0}},	//   _百度知道投诉吧_, _aproape_, _atrakcyj, _bresenno,
   {{0xd26c30a2,0x04c071ef,0xba207324,0xa3eb50ae}},	//   _kojoj_, _públicos_, _públicas_, _lietas_,
   {{0xf291a009,0xb5960020,0x4c1d205a,0x929191c0}},	//   _papan_, _클릭하세요_, _intambar, _kasal_,
   {{0x1fc381cd,0x026e111a,0x23a26185,0x7f653363}},	//   _modifier_, _repons_, _eropa_, _रामचन्द्,
   {{0x33f882b8,0x67134182,0x6292405e,0x6e3cd037}},	//   _nakuba_, _сексуалн, _kawawa_, _اشتون_,
   {{0x82d87122,0xed1c81c0,0x53f982d7,0xf2df1059}},	//   _danes_, _follicle_, _virut_, _whining_,
   {{0xe25a910c,0x4708a008,0x2291f2b0,0x15a72270}},	//   _ciall_, _ומולטימד, _rutas_, _झपकते_,
   {{0x325a5056,0xb2918252,0xa344b06f,0xf2018034}},	// [950] _lilla_, _garab_, _firenze_, _varie_,
   {{0xb1ed0364,0x4200b365,0xbb88e1c4,0x02f3f178}},	//   _धरहरा_, _ledige_, _aktivier, _dedicat_,
   {{0x92d8c116,0x4201a1c0,0xd25a50e8,0xa71cc12d}},	//   _kalena_, _sapin_, _gilla_, _पारदर्शी_,
   {{0xf9fb10f6,0x327ef211,0xa2d430f5,0x9213f063}},	//   _digitala_, _seiner_, _tailieu_, _afuha_,
   {{0x0200c27b,0x12919050,0xedb8a088,0x00000000}},	//   _malini_, _casal_, _pakinaba, --,
   {{0x401d10bd,0x82918039,0x927f5013,0xa968d018}},	//   _kondisyo, _darab_, _brengt_, _estimate,
   {{0xe486f1f2,0xc148834f,0x6b98d041,0xd0e3b13c}},	//   _भिखारी_, _टाइपराइट, _प्युठान_, _протесту_,
   {{0x44399175,0x73076009,0xd2fc1153,0x5ca781b8}},	//   _програма, _lambang_, _actually_, _редакция_,
   {{0xf611c126,0xc683c00f,0x07b01008,0x11dd3098}},	//   _probléma_, _रूमाल_, _המלחמה_, _aplikací_,
   {{0x1394d078,0xe16920a0,0x92e95189,0x77c8c135}},	//   _geesi_, _presenno, _artinya_, _poisteni,
   {{0x4361418a,0xf6b9a1ea,0x4e4a5366,0x00000000}},	//   _lingvoj_, _nekateri, _netačne_, --,
   {{0x224bd186,0xca168149,0x1224f11a,0x18d9e0c5}},	//   _जिलेबी_, _osobnost, _efikas_, _сервис_,
   {{0x8d42d194,0xd3a69044,0x4290d1d7,0x62b0b008}},	//   _інформац, _máxima_, _sheas_, _ואירועים_,
   {{0x18d2c171,0x125a50d4,0xcdee50bc,0x327ee056}},	//   _sobreviv, _billi_, _bridgewa, _kunnat_,
   {{0x327f4171,0xf2d912c1,0xa683a025,0xc3ebf01a}},	//   _frente_, _kazem_, _रैदास_, _nouto_,
   {{0xf0ddf224,0x9290516d,0x727eb033,0x7aa7c070}},	//   _branitel, _aklat_, _agence_, _لوڈشیڈنگ_,
   {{0x0477a050,0x51b3c0cb,0xd355001e,0xbe73f08f}},	// [960] _проекти_, _وائرس_, _recetas_, _ルアドレスを入力,
   {{0xcaaa40c5,0x326c210f,0xe8fb81dd,0xe80c7135}},	//   _компании_, _pokok_, _hamarkad, _pozitívn,
   {{0xb20061e4,0x72926087,0xf290e14e,0x8290b1c0}},	//   _chois_, _buraya_, _pinaka_, _madali_,
   {{0xf26c1077,0xa29260d7,0x34a8a068,0x00000000}},	//   _johon_, _agrada_, _maximaal_, --,
   {{0xbd9d9167,0x13e8302b,0x0b37f265,0x43874151}},	//   _महत्त्वप, _голубева_, _बर्बाद_, _acerca_,
   {{0xb3ead30f,0x02da527b,0x227ed1d7,0x8be74143}},	//   _vieta_, _intela_, _tional_, _kategoor,
   {{0x634f7014,0x884150bb,0x98c55035,0x6cbc3107}},	//   _heheheh_, _callixtu, _जवळपास_, _опасен_,
   {{0x9b65b07f,0xf977b00a,0x4845b0db,0xfc560002}},	//   _utilizar, _indirett, _utilizad, _कइलें_,
   {{0xe6818076,0x139501a4,0xe35850f5,0x084e5065}},	//   _करनाल_, _vlasti_, _webgame_, _لأجهزة_,
   {{0x1c6060bd,0x95dbc020,0x22a7f08d,0x7e29505e}},	//   _distans_, _마지막으로_, _ububi_, _manggaga,
   {{0xfee6e12a,0x582f5332,0x6290c0cf,0xb291b2cd}},	//   _machinin, _skomentu, _aydan_, _maqam_,
   {{0xc527e0c9,0x329262c1,0x585dd143,0x00000000}},	//   _potrudio_, _zgrada_, _teenistu, --,
   {{0x312d217e,0x6900b054,0x00000000,0x00000000}},	//   _парте_, _अतिरिक्त, --, --,
   {{0xc2da519e,0xd291d0f1,0x5395021f,0xd2ca50ec}},	//   _isteri_, _kawan_, _klassi_, _pildi_,
   {{0x1ecda0aa,0xdf6e1094,0x02f71098,0x252d0036}},	//   _gerektiğ, _יוליוס_, _novinek_, _composto_,
   {{0x32ca50e9,0x42d800d1,0xd2019037,0x1d7a718d}},	//   _vildi_, _spiel_, _arsip_, _kommende_,
   {{0x23ea7010,0x0b11a12f,0x14858367,0x00000000}},	// [970] _hinta_, _cásanna_, _विनाशक_, --,
   {{0xdaba5179,0xbdc39261,0xc3a8a037,0x8d11802a}},	//   _компаний_, _terimaka, _sakadang_, _юстиції_,
   {{0x95e0d10b,0x24d01008,0xd30432b1,0x1feee0cb}},	//   _literatú, _במקביל_, _porazil_, _بسلسلہ_,
   {{0x43f9903f,0xf3a1311c,0x73ea704a,0x338712f4}},	//   _visus_, _منحصر_, _minta_, _dobrou_,
   {{0xc224f2cb,0xcebac07c,0x9eb6c179,0x2e398069}},	//   _funkar_, _топло_, _профиля_, _vivncaus_,
   {{0x23f461cd,0xe291e074,0xb33d7070,0x0201e1cb}},	//   _partie_, _matan_, _دیہات_, _matin_,
   {{0x52ff50dc,0xc2786304,0x722e00b5,0x956de034}},	//   _arritur_, _chunki_, _pravidel, _часовете_,
   {{0xbafd90b2,0xf07ec036,0x326c8224,0x3efe80e6}},	//   _nghếch_, _правилно_, _tokova_, _privatsp,
   {{0x62ca7015,0xc9f660cb,0xd68e70be,0x13fc603d}},	//   _ainda_, _során_, _proffesi, _リクエスチョン_,
   {{0xe3f1503a,0x82b4e063,0x7b815089,0x3e152002}},	//   _associaz, _adicha_, _associac, _kuressaa,
   {{0x52d8a20d,0x82da51df,0x5200c18f,0x53eb00f9}},	//   _haber_, _esteri_, _dalili_, _pratik_,
   {{0xd14a7040,0xa29b0105,0x13f9a120,0x32b66091}},	//   _kostenlo, _ekspertl, _tipus_, _parcio_,
   {{0xfabdf064,0xf3ead03f,0x12cad1ea,0x356010ea}},	//   _pinjaman_, _lieto_, _spodaj_, _사람입니다_,
   {{0x0c06e0ff,0xdefdd036,0x90705007,0xc20091b1}},	//   _potreby_, _политиче, _metalelo, _khais_,
   {{0x32cbf2de,0x537380b3,0xd290e267,0x79dfe054}},	//   _soudu_, _izdanje_, _kanani_, _struktuu,
   {{0x726f108d,0xda32612d,0x7fa4c070,0x7cf2c06a}},	//   _eziningi_, _फर्जी_, _ٹوئٹر_, _فاطمہ_,
   {{0xce14a12e,0x842c5255,0x1201e14e,0xd41c51a3}},	// [980] _zamestna, _technick, _natin_, _technicz,
   {{0x02ca7086,0x92ebd160,0xd200318f,0x0c0440ac}},	//   _bindi_, _muintir_, _namiji_, _prosesi_,
   {{0xf2d99225,0x2f27712f,0xb26d8122,0x8dfbe0f5}},	//   _viser_, _لانجري_, _evrov_, _nukeviet_,
   {{0x5201e237,0x9766a0ea,0xf89aa0cb,0x79e820b5}},	//   _batin_, _마찬가지로_, _سرفراز_, _dobrodru,
   {{0x756912ae,0xf26c711e,0x6a0a00f6,0xfc37107b}},	//   _настройк, _honom_, _estatist, _সংঘটিত_,
   {{0xf34441be,0x00000000,0x00000000,0x00000000}},	//   _dabeere_, --, --, --,
   {{0xd2d9a033,0x98dbf128,0x427f7038,0xf50a924a}},	//   _favoris_, _dimensiu, _chanzo_, _sigurado_,
   {{0x7291e074,0xa58830ff,0xb25a813f,0xa2016068}},	//   _fatan_, _popradsk, _daklak_, _begint_,
   {{0x2758d0ca,0xec051070,0x82ca705a,0x00000000}},	//   _मुस्ताङ_, _گناہوں_, _zindi_, --,
   {{0xd26e1089,0x2394d0f7,0x0c751368,0xc1ca511c}},	//   _suport_, _meest_, _रात्रि_, _مراقبت_,
   {{0xa962d031,0x42e8e056,0xd2b37237,0x5650b031}},	//   _商务部网站版权与, _polisen_, _perdana_, _胶南市教育体育局_,
   {{0xa2d830dc,0xcc6a3080,0x9ae5607b,0xf3f47173}},	//   _koment_, _odvtedy_, _শ্রাবণ_, _turtas_,
   {{0x9202505d,0x83eae0c2,0xd290e075,0xd291e147}},	//   _mutima_, _contro_, _gyfan_, _katao_,
   {{0x32d8b341,0x83031133,0xc9e2f1d8,0x5754604d}},	//   _facer_, _malairt_, _portefeu, _最新から表示_,
   {{0x0d8680d7,0x527332bc,0x8291e074,0xa2d6300f}},	//   _novembre_, _många_, _watan_, _selleks_,
   {{0x020061cb,0x33f4602c,0x0d2e90fe,0x996610da}},	//   _choix_, _kertoa_, _সারাদিন_, _नविनतम_,
   {{0x7611c0b5,0xd40531f7,0x9394e164,0xa22750a2}},	// [990] _problémy_, _आनंदित_, _avisen_, _građansk,
   {{0xb2ca50f8,0x616e307b,0xcee4d036,0xfee040de}},	//   _bildu_, _গাইবান্ধ, _чувства_, _चित्रकला,
   {{0xf386d063,0xfa45c0b4,0x826c2074,0x937570fe}},	//   _emere_, _finestra_, _rokon_, _ফায়ারফক্,
   {{0x737301cd,0x213da017,0xfe6841af,0xb291d14e}},	//   _semaine_, _спортист, _дискусиј, _kawal_,
   {{0xecdf3031,0x62fc9072,0xdbf0e1a3,0x195c81b8}},	//   _欢迎批评指正_, _slags_, _internec, _списку_,
   {{0x73ead191,0xc2927276,0xc342b186,0x99cd1192}},	//   _tieto_, _busana_, _भुजंग_, _myndighe,
   {{0xe49cc100,0xe20200a4,0xb2927038,0xe91320ed}},	//   _плане_, _disini_, _miradi_, _membangu,
   {{0xc8b8907f,0xbc7f413b,0x437f805a,0x00000000}},	//   _кэутаре_, _返回黑龙江主站_, _muhanda_, --,
   {{0x91c3310b,0x9bea4063,0xae627063,0x925ad2ac}},	//   _autorské_, _achọrọ_, _agakọta_, _ciele_,
   {{0xf3eae18c,0x2eb4d122,0x72ebd190,0x4b242124}},	//   _kontan_, _samodejn, _bizness_, _munaasib,
   {{0x3da3c061,0x32d8c120,0x02026174,0x6637219a}},	//   _nemokama, _dades_, _arriba_, _татиана_,
   {{0x1ed101c9,0x0378e14e,0xbf240193,0x7265309c}},	//   _reunidos_, _malaman_, _višak_, _yerusaal,
   {{0xac7581f7,0xb25a91b1,0x03eae21c,0xa1c1731a}},	//   _सदस्या_, _ciali_, _lontan_, _terendah_,
   {{0xd3a8207f,0xd603919f,0x15953217,0xd60190b5}},	//   _privind_, _bələdiyy, _klassisk, _cyklisti,
   {{0x3d04c19b,0x42d99175,0x9c0880e7,0x00000000}},	//   _توجهی_, _esses_, _традициј, --,
   {{0xf6b36215,0x825ad0c4,0xe1bc80fe,0xb2d8e246}},	//   _pristaty, _biele_, _মেঘের_, _manema_,
   {{0x16af302b,0xab9280aa,0x363800fe,0x28bfe1ae}},	// [9a0] _рсфср_, _ingilizc, _এস্কিমো_, _enfermed,
   {{0xb27e0153,0x91cae021,0xf3ead144,0xc201e19e}},	//   _being_, _parašė_, _viete_, _katil_,
   {{0x83f4512a,0x66831369,0x024df36a,0x03f472da}},	//   _rattle_, _ब्याज_, _मनाला_, _kartus_,
   {{0x6f5940e9,0x82ea7024,0x00000000,0x00000000}},	//   _hlýtur_, _putinin_, --, --,
   {{0x3f6b2130,0x4efb2034,0xd291e18e,0xd2025034}},	//   _стране_, _страни_, _matam_, _attivo_,
   {{0xa47fe1d5,0xebdc70ea,0x3ddee04d,0xa77bb118}},	//   _ajụkarị_, _한국과학기술연구, _昭和つっても幅広, _стоката_,
   {{0x0249910a,0xff3f9037,0xfad59128,0xd332f089}},	//   _rasmi_, _pengaran, _cantitat, _baixos_,
   {{0x12e16076,0xe26c10b2,0x6200b1be,0xd355d325}},	//   _दसवीं_, _sohot_, _midian_, _confira_,
   {{0xeda811dd,0xaef7f1ab,0x67f82047,0x72e8e147}},	//   _donostia, _фирмата_, _لبرنامج_, _maliban_,
   {{0xc2c40084,0x02ca70f6,0x64a5f018,0x0c0bb010}},	//   _alawiyah_, _findu_, _clinical_, _egyptin_,
   {{0x52ca01d2,0x430f6119,0x0291d0ed,0x19f6b221}},	//   _shida_, _berbera_, _jawab_, _ustanove,
   {{0xc48510e1,0xb295c0d4,0xe2a6d36b,0x0202600c}},	//   _विधायक_, _dipartim, _osobno_, _harita_,
   {{0x32920051,0x927860ac,0xec9142cc,0x3c76c32f}},	//   _misali_, _olundu_, _श्लोक_, _मरम्मत_,
   {{0x12d4510b,0xeff1111e,0x3c1cc105,0x648140c6}},	//   _ľudia_, _miljoner_, _bazarlar, _भाषाको_,
   {{0x72925175,0x5a00e064,0xd20271a4,0x0f172348}},	//   _estava_, _kitabnya_, _desilo_, _ciudadan,
   {{0x9fc0d061,0xffdd3065,0x82b4912f,0x725ad0c3}},	//   _literatū, _العبد_, _dtaca_, _piele_,
   {{0xddcb3037,0x00000000,0x00000000,0x00000000}},	// [9b0] _اثبات_, --, --, --,
   {{0x427e01d9,0x90b52030,0xc6b2c070,0xdd87a2b1}},	//   _meine_, _दुगुना_, _تمہاری_, _objednat_,
   {{0xd290818a,0xa4a900b7,0x12fcf217,0x22d9e27c}},	//   _tukang_, _протекци, _logga_, _vitet_,
   {{0x0bf0d098,0xae72f143,0x9f4511d9,0x00000000}},	//   _mistrovs, _शुद्र_, _sonstige_, --,
   {{0x0201619d,0x026ca134,0x4351e16c,0x4ac1009d}},	//   _begitu_, _pobol_, _амендаме, _wciąż_,
   {{0x6f240193,0x9255c1f3,0x03ea7267,0x12012111}},	//   _nešto_, _विशेषः_, _bintu_, _kabiny_,
   {{0xfcc89060,0x12f2f0ac,0x365131cc,0x3dfe6176}},	//   _mìíràn_, _radiosu_, _गोंधळ_, _हार्डवेय,
   {{0x92369122,0x42d980a4,0xa3f9e173,0x87aba1dd}},	//   _imajo_, _maret_, _kitus_, _populazi,
   {{0x8ed9f061,0x3b11414c,0x00000000,0x00000000}},	//   _aplinkos_, _पाखण्ड_, --, --,
   {{0xe4dac0c0,0x42d8c17d,0x0c574099,0x526ca2c1}},	//   _можна_, _vader_, _nestaje_, _tobom_,
   {{0x726e0278,0x7201403b,0xa98b40a2,0xb41cc241}},	//   _lepota_, _mediat_, _treće_, _pregazio_,
   {{0xd792807c,0xb3eb80ca,0xb3188088,0xa3d4d14b}},	//   _интересу, _dorty_, _ganitong_, _kararı_,
   {{0x438602c0,0xcaeeb0e8,0x43451033,0x821ba0b5}},	//   _imirt_, _fastighe, _américai, _virtuáln,
   {{0xce0cc03d,0x3c528141,0x107d1175,0x12f3a1a7}},	//   _ドを入力してくだ, _bantuan_, _природен_, _beginnt_,
   {{0x7b9e40f9,0x27b8416a,0xc575335c,0xf1b5e050}},	//   _prezidan_, _položek_, _contexto_, _стандард,
   {{0x227e00d1,0x82c74037,0xe2d8c05e,0x32578039}},	//   _keine_, _ادارات_, _pader_, _nálam_,
   {{0xd3c7210b,0x438661dd,0x134bc087,0x5344a127}},	// [9c0] _hospodár, _umore_, _birkaç_, _ourense_,
   {{0xf201c0b4,0x2758e025,0xc2ea4170,0x7f2642d9}},	//   _havia_, _मुद्दों_, _marián_, _समाजमा_,
   {{0x137a8091,0x429302f9,0x026c530c,0x12489276}},	//   _allanol_, _sporočil_, _ellos_, _upami_,
   {{0x74695082,0xfb8231da,0xf047202c,0x322bb1be}},	//   _християн, _umanitar, _часовой_, _akamere_,
   {{0x12db40a2,0x42352165,0x426ca241,0x00000000}},	//   _kasnije_, _evidenti_, _sobom_, --,
   {{0x0200c091,0xf80da2ad,0xb25b936c,0x0c3f203e}},	//   _miliwn_, _командов, _misle_, _stephens,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf291f089,0xadf69082,0x9aa590ca,0x5321f177}},	//   _estan_, _ресурсів_, _विक्रेता_, _estyn_,
   {{0x23f9e0dc,0x0fb61170,0x42d9805f,0xa440f039}},	//   _ditur_, _zosilňov, _darem_, _الحرمین_,
   {{0x337c9088,0xe2911194,0xac1730cd,0xe24af106}},	//   _detalye_, _debatt_, _इंस्टीट्, _асигурар,
   {{0x5696500c,0x1c5a6165,0x651351ab,0xce35d03c}},	//   _adresini, _evitati_, _енергийн, _opracowa,
   {{0x874c01b8,0x4316d36d,0xc9f20124,0x00000000}},	//   _растения_, _trebali_, _culimada_, --,
   {{0xa386d061,0x123750d4,0x3a9660de,0x7201121b}},	//   _sporto_, _plejer_, _उम्मेद_, _kabili_,
   {{0xba83b0f7,0x62c0e1e8,0x674ed06f,0xf2d861b1}},	//   _beginnen_, _poštovan, _счетовод, _nplej_,
   {{0x23f9e0d6,0xe2d9e114,0xbf8752a3,0x03f12065}},	//   _situs_, _sites_, _mašine_, _فضفضة_,
   {{0x5bc27020,0x020dc017,0x2c7f0122,0x945e1018}},	//   _크게보기를_, _спомен_, _varstvo_, _נוסעים_,
   {{0x0c2a602e,0x12fc61aa,0x72b850f8,0xa6838180}},	// [9d0] _vlastnos, _ulogu_, _handiak_, _वनवास_,
   {{0x5290d259,0x28392036,0x2225805f,0x333f9018}},	//   _theas_, _последна_, _werke_, _המסחר_,
   {{0x7718501a,0x63f8f02d,0x5205a00a,0x42bca0f9}},	//   _контакты_, _bagus_, _marittim, _mondyal_,
   {{0xe3f0200a,0x425ad144,0x626c705d,0x63f9919e}},	//   _informaz, _biela_, _nonon_, _kasut_,
   {{0x943ed0ea,0x5d82a1aa,0x5290c205,0x29416236}},	//   _광주광역시_, _najčešće_, _kulang_, _estudiar_,
   {{0x7c01c267,0xc3ea507e,0x13f9e003,0x00000000}},	//   _vengador, _kilti_, _situr_, --,
   {{0x21c632ca,0xe290c1c0,0x42d8f03d,0xf3a3f2b7}},	//   _onemscom, _dulang_, _tages_, _mfupi_,
   {{0x227e6003,0x12d9f144,0xad9ac118,0x2f2fb0bb}},	//   _svona_, _kvality_, _статии_, _nestoria,
   {{0xc48072be,0x62d980de,0x02cae0b9,0x4e0cb0c5}},	//   _बहराइच_, _varem_, _londen_, _laadukka,
   {{0xa291f241,0x926c4035,0xb3f980e6,0x837880a4}},	//   _ostao_, _nomor_, _warum_, _tanaman_,
   {{0x7e71336e,0xb2efb277,0x37540302,0x3c6b81dd}},	//   _चित्र_, _þeirra_, _पारिवारि, _elementu_,
   {{0xf255436f,0x826cc241,0x4c55a328,0x4200c147}},	//   _विधेयक_, _vodom_, _darteed_, _huling_,
   {{0xbe72f12d,0x96374054,0xa3738144,0x3e3d20fe}},	//   _शीघ्र_, _politsei, _dodanie_, _দুইটা_,
   {{0x1317001c,0x5b0301ea,0x123c2068,0x324c202c}},	//   _stazom_, _priprava_, _normaal_, _normaali_,
   {{0x7f2521cb,0xf34351f9,0xe906e0a8,0x00000000}},	//   _utiliser_, _diseño_, _forbered, --,
   {{0xc394904b,0xf3f460c3,0x3e2da004,0xd6a3012f}},	//   _yeast_, _martie_, _השקפה_, _aistrith,
   {{0x12fd0171,0xc3940038,0xb2cae117,0xa967a018}},	// [9e0] _nocivas_, _ofisi_, _joiden_, _הגדלת_,
   {{0xc2fc6242,0xa394811c,0xcdf98265,0x4203b084}},	//   _blogs_, _langkung_, _आत्मकथा_, _nauzubil,
   {{0x29ec90d4,0x83ac70b2,0xa291f246,0xc5f2c025}},	//   _attivita_, _cmspro_, _bazara_, _चट्ठा_,
   {{0x6d5ac175,0xa3ebf058,0x4aeb9077,0x2c969025}},	//   _совет_, _foutu_, _kokonaan_, _जगहों_,
   {{0xa3192088,0xc2cae0ea,0xd7def263,0x00000000}},	//   _kabilang_, _honden_, _गायकवाड_, --,
   {{0x1303c0e6,0x62efd14f,0xeb5970d7,0x00000000}},	//   _bekannt_, _kulinda_, _muntanya_, --,
   {{0xe212b0bd,0x05bd4216,0x02d98143,0xb91e110b}},	//   _mache_, _meridiem_, _parem_, _trenčín_,
   {{0xc84d20b5,0x71c4813b,0xf3087164,0x22ca5051}},	//   _naposled, _人在草木中_, _klubben_, _wallahi_,
   {{0x8200d18a,0x4d35d021,0x94996119,0x7e186165}},	//   _kuning_, _славян_, _islamark, _irregola,
   {{0xeb72d034,0x520c82c0,0x2b74629f,0x4378818a}},	//   _стана_, _dóigh_, _esquerda_, _sanajan_,
   {{0xd3a2404b,0x93044122,0x43053149,0x587ba018}},	//   _kampo_, _pozabil_, _obrazem_, _הלבשה_,
   {{0x52e920f8,0xc10281b9,0x25982039,0x7aa41049}},	//   _hainbat_, _प्रश्_, _impressz, _जुर्माना_,
   {{0xf26c4360,0xa290c0a4,0x3cee21b8,0x00000000}},	//   _somos_, _pulang_, _груди_, --,
   {{0xa4ba0020,0x1ff100cd,0x4979f0e8,0xaf6d50ce}},	//   _중국국제전화카드_, _तेलंगाना_, _gymnasie, _insbeson,
   {{0x84fa9162,0xc20080a6,0x8365b025,0xa2490206}},	//   _गंगाधर_, _arhiiv_, _मुरैना_, _dhambi_,
   {{0x59977349,0x702e20c2,0xec932039,0x43e2b24e}},	//   _प्रशिक्ष, _condizio, _تاوان_, _enerjisi_,
   {{0x31ab7036,0x4bcb7036,0x6212b058,0x12d9e040}},	// [9f0] _commenti_, _commento_, _fache_, _datei_,
   {{0x0a074179,0xa8078173,0xc212d0c4,0x00000000}},	//   _tilantee, _круглых_, _brehu_, --,
   {{0x2291800c,0x729270cb,0xf3a2d0b6,0x4f9e11ab}},	//   _biraz_, _اشتیاق_, _drept_, _родители,
   {{0x475a3033,0xab87d370,0xe96731b2,0x025ac12a}},	//   _非煤矿生产许可证_, _ingilter, _immitate, _bellow_,
   {{0x9301206f,0x4c7d80a7,0x3c4b10d1,0xb2e3b034}},	//   _страната_, _prosimo_, _eintrag_, _regione_,
   {{0x39e321f5,0x12d83052,0x5a26d0cb,0x00000000}},	//   _minisita_, _tumelo_, _شاہراہ_, --,
   {{0x626c51c0,0x2ba7904e,0x4986107a,0x56d1d12d}},	//   _kolor_, _електора, _paskelbt, _अंकित_,
   {{0xff6bc036,0xe17d9008,0x89ded32a,0x7090b0c5}},	//   _историче, _בישול_, _न्यूजलेट, _netistä_,
   {{0x463a301a,0xb22491c0,0x63eae19d,0xf26c5174}},	//   _промышле, _atake_, _cantik_, _dolor_,
   {{0x92ca717b,0xa340407c,0x8ae61138,0x00000000}},	//   _kindi_, _offerta_, _acetonae, --,
   {{0x53ead0ae,0x6a04b1ac,0x00000000,0x00000000}},	//   _lietu_, _megabait, --, --,
   {{0xf2d8c1d6,0x634c7191,0x1177508d,0xd212b0e1}},	//   _illene_, _povedal_, _zilandel, _ruchu_,
   {{0x53320089,0xa5a3e040,0x6a10307f,0x52d9f1cf}},	//   _baixa_, _versandk, _consiliu, _estes_,
   {{0xf291f0f1,0x937110fe,0x784d80ea,0xdeb63045}},	//   _skuad_, _চুয়াডাঙ্, _들었습니다_, _системі_,
   {{0x01f7c037,0x226c7134,0xe2b40086,0x2c62d19f}},	//   _معارف_, _annog_, _igice_, _əfsanə_,
   {{0xc26c528c,0x22fc602e,0x00000000,0x00000000}},	//   _polos_, _blogy_, --, --,
   {{0x63f81024,0x8d37c037,0x78fd313b,0xba1a5174}},	// [a00] _uchun_, _معاصر_, _您所在的位置_, _descuent,
   {{0x49a96082,0xd394d0a0,0x8528402a,0xf4730205}},	//   _професій, _broses_, _футбольн, _listahan_,
   {{0xb1579194,0x569761d9,0xc389b068,0xe6d2b0de}},	//   _рамках_, _eigentli, _vergelij, _नाहिए_,
   {{0xa9c530a4,0x00000000,0x00000000,0x00000000}},	//   _kesempat, --, --, --,
   {{0xb529e18c,0xc23d50ea,0x6629e09f,0x027f0269}},	//   _navigasy, _필요합니다_, _navigasi, _omanik_,
   {{0x827ef06e,0x52259121,0x00000000,0x00000000}},	//   _aginju_, _neska_, --, --,
   {{0x9f4eb120,0x2354a0aa,0x82d9f0aa,0xf9b61144}},	//   _respecte_, _hareket_, _ister_, _predplat,
   {{0xe98b5047,0x93871016,0xb793713b,0x22927154}},	//   _modhanna_, _librat_, _国家旅游局_, _jirani_,
   {{0x0d7860b2,0xf4789035,0x90b591d3,0x9dc4e179}},	//   _giăng_, _सानिकास्, _सतगुरु_, _matkusta,
   {{0xc9e0a020,0x83d86176,0x450140ef,0xeab6f0ea}},	//   _청소년보호정책_, _सेलिब्रे, _billenty, _올려주세요_,
   {{0x538691be,0x129ad22e,0x0c738037,0x12a69119}},	//   _amara_, _faajtim_, _raksasa_, _amaba_,
   {{0xf3a7201a,0xec672117,0x00000000,0x00000000}},	//   _другой_, _другое_, --, --,
   {{0xde3d9008,0x7ef510c4,0x02fcc18b,0x9212701a}},	//   _משפחת_, _telefónn, _blogga_, _vanha_,
   {{0xdd116020,0xb37f800d,0x8f965222,0x00000000}},	//   _아파트분양권_, _mahanga_, _quần_, --,
   {{0x47572182,0xf387f128,0x937541ab,0x00000000}},	//   _метри_, _scurt_, _appuntam, --,
   {{0x6e7350e1,0x036da1a4,0x6db7a065,0x8074403f}},	//   _रुद्र_, _potencij, _اليهود_, _kalendār,
   {{0x3efc6030,0x9342013f,0x9710d0ea,0x06f780df}},	// [a10] _नजाकत_, _doremon_, _고객센터의_, _नौजवान_,
   {{0xf3ead30f,0xa2bf2037,0x43030047,0xaeb64198}},	//   _vietu_, _سمنان_, _raidió_, _gradonač,
   {{0xfbc4e117,0xf316900d,0xb2259098,0xd3869074}},	//   _очень_, _amazi_, _deska_, _amari_,
   {{0xe3ea01be,0xdc46d11c,0xa2ca0002,0x861a3047}},	//   _saiti_, _مردمی_, _saidi_, _ترانيم_,
   {{0x08b4c0ea,0xbcf2c065,0x00000000,0x00000000}},	//   _사진갤러리_, _ناعمه_, --, --,
   {{0x6f1e100c,0xa20220a7,0x2c1d2105,0xfd76319b}},	//   _kendisin, _izboljša, _tatarlar, _ترینر_,
   {{0x4f6d4220,0x3237e1df,0x1f618014,0x12f55008}},	//   _pasaules_, _ngomhla_, _xeebxeeb_, _maximum_,
   {{0x74fa5010,0x2aa2a0b2,0x6192a371,0x92911252}},	//   _программ, _techcomb, _autonómi, _sabahi_,
   {{0x130de163,0xe2d94116,0xfe15a033,0x00000000}},	//   _osobama_, _sheegi_, _premiers_, --,
   {{0x998e11c9,0x224a60a8,0xe2c5c145,0x30c3906a}},	//   _начин_, _dermed_, _primjer_, _بالمقابل_,
   {{0xa4e201f9,0x923e925b,0x99250033,0x9a350033}},	//   _মোছাঃ_, _termék_, _caractèr, _caractér,
   {{0xe3ebe023,0x6290c070,0x8557a004,0x5cc91194}},	//   _mitte_, _valami_, _מתפלל_, _трансляц,
   {{0xc0e42008,0x2200d064,0x1ee60018,0x6eb51056}},	//   _מאיימות_, _hanief_, _חיפשתם_, _konstigt_,
   {{0x72da61dd,0x306262db,0x2f72c045,0x53f8916f}},	//   _direla_, _बतासे_, _доброго_, _pljuje_,
   {{0xf3eb9011,0x5c913025,0x792120fe,0x00000000}},	//   _sista_, _मैचों_, _চট্রগ্রা, --,
   {{0x627e9104,0xb3a240a4,0x187a7050,0x229fe1cf}},	//   _zwane_, _sampe_, _затворен, _projeto_,
   {{0xa273a1ef,0x281fa0ea,0xf79100ea,0x81d05055}},	// [a20] _aínda_, _광화문연가_, _테마감상평_, _sheegnay_,
   {{0x92d911a3,0x227e6033,0x9987704d,0xcfe3a1e6}},	//   _reklamy_, _avons_, _厚生労働省_, _неможлив,
   {{0x23940112,0x49ebd2d3,0x548180da,0x00000000}},	//   _crise_, _undersøg, _प्राजु_, --,
   {{0x8fe0007b,0xe1ffe0ed,0x4c75e2f4,0x72e77070}},	//   _প্রমাণ_, _menambah_, _formátu_, _کالعدم_,
   {{0x7b06e0cb,0x4290c1df,0x00000000,0x00000000}},	//   _fórumban_, _uhlala_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x52bb1025,0x9a1f113b,0xec67a147,0xcd12301a}},	//   _kolejne_, _热门关键字_, _maaring_, _добрый_,
   {{0x3aa2702b,0x750a6045,0x3f30d221,0xa27e90da}},	//   _priklaus, _програмн, _satelitn, _teknis_,
   {{0x4a841004,0x2ad172c1,0x338741ab,0x00000000}},	//   _ארגינעל_, _normalan_, _aperto_, --,
   {{0xb290c147,0x22d9b1e8,0x02c1e078,0x00000000}},	//   _malaki_, _saveza_, _akilapa_, --,
   {{0xc20422a7,0x2efd71ed,0x119720b5,0xd3f460b9}},	//   _serikali_, _धडाका_, _koncerty_, _watter_,
   {{0x6ed5d30f,0x09f59184,0x5ee27143,0x37b5c071}},	//   _papildin, _kaminuza_, _रिक्शावा, _адеся_,
   {{0x253462ec,0x23ea203b,0xa26ca11c,0x32cf10bd}},	//   _različit, _fakti_, _bobot_, _denonse_,
   {{0xf2b40138,0x12ca003f,0x00000000,0x00000000}},	//   _trice_, _naidu_, --, --,
   {{0x03ea00fb,0xf9cfb15e,0x9cd9e02f,0xb7b5f1e2}},	//   _iaitu_, _tirdznie, _героях_, _ibarretx,
   {{0xc75de00d,0xa7b420cc,0xaa1fa0c5,0xeaeeb11e}},	//   _bizimung, _נאכנישט_, _основные_, _hastighe,
   {{0x627e71bd,0x9dfa804d,0x72da50a4,0xf57f3065}},	// [a30] _lenne_, _このレビュ_, _materi_, _أصبحت_,
   {{0x83ced335,0xaf34618e,0x92f49099,0x9342f098}},	//   _clovek_, _adironda, _nepovolj, _kulturní_,
   {{0x927ed104,0x32fc0054,0x00000000,0x00000000}},	//   _edene_, _liige_, --, --,
   {{0x0b5a812f,0x6379a185,0xd25a5056,0x2c77d0d4}},	//   _مُساهمات, _layanan_, _tills_, _entrati_,
   {{0x325a91e4,0xf224912a,0xe200c041,0x4224d09f}},	//   _chala_, _ataki_, _velice_, _reeks_,
   {{0xfc624044,0x52fd7248,0xb2026037,0x9c6270ad}},	//   _aparece_, _imagen_, _carita_, _tutulan_,
   {{0xc27e9033,0x622550e9,0x52da511d,0x327860e8}},	//   _avant_, _frekar_, _kateri_, _barnen_,
   {{0xe27e7309,0x9611f0f7,0x9fd5d09d,0xcde5804d}},	//   _denne_, _kwalitei, _prezyden, _指定しない_,
   {{0x7c67c039,0x32fe6061,0xcb03e1c4,0xee5262a7}},	//   _دربار_, _visiems_, _versende, _madaraka,
   {{0xaf01b241,0x795fe0fa,0x65b1504d,0x72d9913b}},	//   _novorođe, _atendere, _に関する質問_, _assez_,
   {{0x7daf60f9,0x727ef086,0x23ea2003,0x9290c119}},	//   _ansiklop, _iminsi_, _vakti_, _filayo_,
   {{0x8248d007,0x29d9b0d5,0x02926074,0x537a00ac}},	//   _abemi_, _सातवाहन_, _karasa_, _haradan_,
   {{0x200a8033,0x62fe720f,0x227e7045,0x10d99010}},	//   _回复此发言_, _target_, _henne_, _заболева,
   {{0xf2369295,0xaa73d221,0x2852033a,0x3237e142}},	//   _imaju_, _lokalita_, _segundos_, _animata_,
   {{0xce38301b,0xae430088,0x00000000,0x00000000}},	//   _pengajia, _kamataya, --, --,
   {{0xd394d13e,0xbec44086,0x6af090b5,0xdc68419b}},	//   _kanske_, _banyarwa, _minulost, _سودمند_,
   {{0x03ea00ed,0x951cf045,0xf032f0b5,0xf1b311bd}},	// [a40] _yaitu_, _доступни, _postaven, _ماورا_,
   {{0x6394d313,0x13dd8208,0x4290c06a,0xd2fd822b}},	//   _danske_, _borwa_, _valaki_, _borga_,
   {{0x3f6b109a,0x63210271,0x9f9fd178,0x7f01d04d}},	//   _usuarios_, _década_, _qualsevo, _スピリチュアル_,
   {{0x8e1c9086,0xaeba6044,0xf7b5d163,0xa212e1d0}},	//   _interaha, _petróleo_, _šestoric, _afihan_,
   {{0x8291f15d,0x225a017f,0x954b7039,0x327e9074}},	//   _thuan_, _asili_, _könnyű_, _kwana_,
   {{0xeba8f025,0x721c5052,0x16359372,0xe3ea702d}},	//   _स्कूलों_, _okuhle_, _económic, _pintu_,
   {{0xf2ca7068,0x3f966008,0x92fc90a2,0x82b4d1a7}},	//   _vindt_, _חובבניות_, _snage_, _manche_,
   {{0x15322002,0x22d8d0b9,0x3ffc6049,0xf485d0d5}},	//   _नब्बे_, _speel_, _अधिकारों_, _रिटायर_,
   {{0xf1013017,0x570ae132,0x13ac5099,0x2e7250cd}},	//   _свете_, _وزيراعظم_, _ukupne_, _लिफ्ट_,
   {{0x934271b2,0x163e3080,0xb20251dd,0xe2224035}},	//   _lateran_, _štiavnic, _betiko_, _नावनोंदण,
   {{0x43a230ed,0xa2cae008,0xa1c7319b,0x714e1034}},	//   _tempat_, _london_, _جاستین_, _protezio,
   {{0x1ef1213c,0x7147d045,0x32d890c4,0x0f612130}},	//   _остали_, _написав_, _pokecu_, _остале_,
   {{0xa27e900d,0xdc1e7036,0x1ae381af,0x03eae00b}},	//   _bwana_, _развитие_, _интензив, _nonton_,
   {{0x5290c203,0xd2b280fb,0x81a472be,0xc349e0c5}},	//   _milano_, _panduan_, _नागालैंड_, _parempi_,
   {{0x59d22221,0xed3ab07b,0x904990cc,0x336f60c9}},	//   _zaregist, _হেফাজতে_, _אַלײן_, _tehnički,
   {{0xf355b173,0xf2498056,0xad2f004d,0x33f400ef}},	//   _moterys_, _varmt_, _回答順に表示_, _postai_,
   {{0xbe1a7373,0x7205b184,0xe27f70a0,0x7065b082}},	// [a50] _materija, _politiki_, _sianel_, _politikk_,
   {{0xae181031,0x48b9a036,0xf2e90076,0x427fa0a2}},	//   _凡本站及其子站注, _последни_, _posiada_, _javnog_,
   {{0x3b00512f,0x3dd03034,0x68090098,0x00000000}},	//   _للإيجار_, _остров_, _आम्दानी_, --,
   {{0x23f981c5,0xdd1b41a3,0x326471cd,0x7236425f}},	//   _harus_, _katowice_, _parler_, _semja_,
   {{0xca8b30c8,0x1b1fb19e,0xf6d0f0ca,0x8c6f00d4}},	//   _sociální_, _cadangan_, _आंशिक_, _approva_,
   {{0x1d928328,0x825ad1b0,0x00000000,0x00000000}},	//   _puntland_, _mieli_, --, --,
   {{0x995f1008,0xe137d170,0x2e10e045,0x00000000}},	//   _resource, _obidvoch_, _adressea, --,
   {{0x73eb9049,0x627b712f,0x8a0400d3,0xca1ed13b}},	//   _posty_, _ginearál, _cumasait, _亿元人民币_,
   {{0x12d9e0f8,0x77e5b0d5,0x124971e2,0xa170d04d}},	//   _batek_, _अतिरेक_, _eraman_, _ビジネスラボラト,
   {{0xb3720008,0xfb7a22b4,0x22497003,0x388410ea}},	//   _related_, _presenza_, _framan_, _회원님들께서는_,
   {{0x03eb924c,0xf3f9e020,0xa21291c5,0x52249078}},	//   _aiste_, _플래닛으로_, _usaha_, _atako_,
   {{0x23eb9230,0xd12d20c5,0xdb1fc19d,0x3352513b}},	//   _biste_, _часто_, _kalangan_, _知识堂首页_,
   {{0x62027187,0x5fe7b175,0xcb83d0fc,0xcd9f7108}},	//   _musika_, _правите_, _europako_, _demokraa,
   {{0x0e36c12e,0x1202605d,0x9f0d214c,0x227292b7}},	//   _spracova, _yeriko_, _संस्कारी_, _mafisadi_,
   {{0x6945a04f,0xc0dc0004,0x951e1004,0xf24c0018}},	//   _utilisat, _ספרדים_, _עוועניו_, _ספרדית_,
   {{0xf3ea20ed,0x4efcc025,0x15742018,0x931141cb}},	//   _waktu_, _बैठकर_, _האגודה_, _piscine_,
   {{0x1d03f04d,0x2660f231,0x5970f0cb,0x570220ea}},	// [a60] _リスト作成者_, _službeni, _دیوبند_, _허브차입니다_,
   {{0x6a07000d,0xfc67c0b9,0xbf07a017,0x5c46c065}},	//   _ambasade, _kantoor_, _провери_, _وربما_,
   {{0xbeaf9037,0x53f9920f,0xb2ca71ff,0xab1fc057}},	//   _gelomban, _kasus_, _sinds_, _halangan_,
   {{0xc26cc115,0x67db712f,0xa1f8c047,0xc394d32e}},	//   _todos_, _كروشيه_, _وقالت_, _efesu_,
   {{0x8e5360ed,0x6201718f,0xab810122,0x00000000}},	//   _mencinta, _shaida_, _zanimivo_, --,
   {{0x1b09324a,0x72365003,0xd719e10b,0xd75da004}},	//   _kompyute, _selja_, _komuniká, _רבונו_,
   {{0x325ab0be,0x22ec232b,0x073bc1ea,0x00000000}},	//   _ledled_, _परवीन_, _podobneg, --,
   {{0xa5bd2037,0xa9eb915d,0xa69b20b7,0x73154045}},	//   _ditambah, _skygarde, _акциунь_, _включенн,
   {{0xbca42118,0xd2011018,0xa23651ea,0x72f4c128}},	//   _английск, _social_, _velja_, _posibil_,
   {{0x204fd1c9,0x1769a094,0x02e000e6,0x3ffed0ea}},	//   _односно_, _רחמנא_, _stunden_, _프로그래밍_,
   {{0x33eb9195,0xd755d0de,0xa2927100,0x5c29627c}},	//   _siste_, _positiiv, _vasara_, _kombetar,
   {{0x4a0a10f6,0x92d99153,0x326ce021,0x27241018}},	//   _arrakast, _cases_, _šioje_, _סטודנט_,
   {{0x22925099,0x9c612160,0x5c25f040,0x027861ea}},	//   _ostaci_, _feirste_, _verbrauc, _zurnal_,
   {{0x73ea02c0,0x627c70b9,0x0af61056,0xb8c61072}},	//   _maith_, _verskill, _leverans, _leverand,
   {{0xc2b1d036,0x17e7e099,0xdaa4b328,0xaa812006}},	//   _vendita_, _bogatstv, _ingiriis, _natomias,
   {{0x13f9a091,0xe3cef06a,0xb46ed017,0xa23b706a}},	//   _hapus_, _privit_, _храму_, _komment_,
   {{0x82d8b148,0xb40d103d,0x126e50f6,0x438771a7}},	// [a70] _andere_, _最近のトラックバ, _aktore_, _sparen_,
   {{0xd312112c,0x42921035,0xcfdd1061,0x952e903b}},	//   _membres_, _sepatu_, _medicino, _princesh,
   {{0xf25a50d4,0x00000000,0x00000000,0x00000000}},	//   _talli_, --, --, --,
   {{0x92b58134,0x9ecb80f5,0x13e78126,0xd292531e}},	//   _merch_, _thoitran, _látom_, _avtale_,
   {{0xec61600e,0x798bf0eb,0xaf63d03f,0xde8490b7}},	//   _kutunga_, _страну_, _vakances_, _алиятул_,
   {{0xdd84a146,0x71b5b191,0x126c51a1,0x9344a305}},	//   _oprettet_, _najčítan, _dilog_, _oprette_,
   {{0x7c00b0a9,0xf8d281bb,0x4eded1bb,0x425ae013}},	//   _razgovar, _добрых_, _dienomis_, _veilig_,
   {{0xcb465079,0x929200f9,0xf156303c,0xe036c302}},	//   _विद्यापी, _repare_, _aktualno, _गवाही_,
   {{0xb43f2020,0x62b52013,0xa292018c,0x9eb6c0c2}},	//   _부산광역시_, _succes_, _separe_, _профила_,
   {{0x3be741da,0x6074a107,0x13ebe2cb,0x620ec017}},	//   _direttor, _англичан, _titta_, _талас_,
   {{0xe49b203c,0x70ca407b,0x9340e254,0x72927037}},	//   _ogranicz, _মৌলভীবাজ, _ghleann_, _pusaka_,
   {{0xf0fc9035,0xa25a6070,0x00000000,0x00000000}},	//   _सुचवा_, _zsolt_, --, --,
   {{0xc932a050,0x7feb5196,0x73ead214,0x52e641dd}},	//   _реализир, _नामांकन_, _cheta_, _prentsa_,
   {{0x426d2051,0xb19c2039,0x9291f22e,0x9c99c128}},	//   _goyon_, _الملک_, _phuas_, _interviu_,
   {{0x0d62c126,0x18dcd175,0x83eb527c,0x36b730a8}},	//   _ردعمل_, _купив_, _vjeter_, _behøver_,
   {{0xab0f4015,0x452870bc,0x8e70a118,0x328ae025}},	//   _resposta_, _aplikasy, _статията_, _कॉलोनी_,
   {{0xa3860015,0xcd8a0045,0x827f0084,0x32f450dc}},	// [a80] _feira_, _allerede_, _amanah_, _pranuar_,
   {{0xe36c80c3,0x1c5740de,0xd3eb8003,0x73a2e046}},	//   _imagini_, _lastele_, _birta_, _teipio_,
   {{0x427f0047,0x93eae010,0x4f8c61a6,0x528bd100}},	//   _leanas_, _eniten_, _तस्कर_, _pakankam,
   {{0xc7a2719e,0xb2b471a1,0x0200c122,0xf7a93258}},	//   _pentadbi, _punca_, _obliki_, _appropri,
   {{0xa2b58033,0xe3f8206f,0xa941f03b,0xc2258003}},	//   _merci_, _comune_, _realitet, _merki_,
   {{0x70e48166,0xa2b4e219,0xd28d632e,0xc27e00b9}},	//   _स्वीडन_, _plochy_, _mabhuku_, _klink_,
   {{0xb46ed06f,0x5683f0cd,0x26aeb031,0xa88e2017}},	//   _време_, _प्याज_, _民族自治地方的自, _холандск,
   {{0x32d8c119,0x5bb75070,0xf777023c,0x81e3712b}},	//   _galeen_, _مداخلت_, _सत्संग_, _parfémy_,
   {{0x8feff25a,0x43bb21bd,0x12c78080,0x00000000}},	//   _व्यापार_, _اسقاط_, _pádom_, --,
   {{0xc3167273,0x5386905a,0xdfa4503d,0x41473045}},	//   _senza_, _imari_, _accepter_, _галина_,
   {{0x2b9e5249,0xfe1f804d,0xa2c1610b,0x3212b0f9}},	//   _fortsätt, _してください_, _kombinác, _rache_,
   {{0xb2fd60e9,0x59b74064,0x82130304,0x4212b374}},	//   _liggur_, _berdekat, _shahri_, _sache_,
   {{0x85b9e203,0xecc9b0e0,0x8698f04d,0xc2d8b0b3}},	//   _заболява, _hauvcaug_, _メルちゃん_, _budemo_,
   {{0x3394927b,0x0316732e,0x22b5503f,0x98c75040}},	//   _ngase_, _wenza_, _preces_, _angemeld,
   {{0x3202004e,0x12920246,0xa7b630ed,0x00000000}},	//   _masini_, _masani_, _keterang, --,
   {{0x1097d16c,0xebca9215,0x7c6730d8,0x6f3310fe}},	//   _транси_, _светлым_, _ضربات_, _ষড়যন্ত্,
   {{0xd2ce30c5,0x03ea7078,0xc255f143,0x63eb900a}},	// [a90] _нормальн, _ranti_, _होखेला_, _jista_,
   {{0xc2c3108c,0xf2c8b170,0x72027133,0x62c7513b}},	//   _kwallon_, _narocne_, _heriot_, _任何单位和个人不,
   {{0x0316001f,0xc22590da,0x00000000,0x00000000}},	//   _reizi_, _meski_, --, --,
   {{0x7e14a1fc,0xb0df9208,0xf93700fe,0xd7e721d3}},	//   _telekana, _teicneòl, _ডুপ্লিকে, _एसआरके_,
   {{0x625a909c,0x7340a0ea,0x828e115b,0x00000000}},	//   _baali_, _bekeken_, _miskien_, --,
   {{0x1eb6c1bc,0xdc754342,0xfc52e265,0xc3ac0299}},	//   _профил_, _तृप्ति_, _लादेन_, _toppen_,
   {{0xfcc7725b,0x596b903d,0xd7dbd21e,0x2248b01a}},	//   _hosszú_, _関連法人等_, _oglašava, _olemme_,
   {{0x2f96c100,0x1478227b,0x8bee102a,0xe3dcd16c}},	//   _рабства_, _isifundo_, _нашої_, _ачестор_,
   {{0xf394e013,0x044300a4,0x392cf32b,0x00000000}},	//   _mensen_, _प्रयत्ना, _परिजन_, --,
   {{0xadbb4286,0x00000000,0x00000000,0x00000000}},	//   _poznania, --, --, --,
   {{0x53ead020,0x0200c061,0x2202720d,0x325ad181}},	//   _niets_, _dydis_, _tarifi_, _niels_,
   {{0x6201a1e7,0x338690c3,0x72a630c2,0x5eac2225}},	//   _revize_, _seara_, _sembra_, _eksterne_,
   {{0x0e33a375,0x93869201,0x7af002f2,0xf5a830f8}},	//   _גרופע_, _learn_, _prirodze, _klaserak,
   {{0x86aa8020,0x3af7d04e,0xa9c511c0,0x52ca9055}},	//   _최근검색매물_, _ражения_, _vallarta_, _caadi_,
   {{0x62cad068,0x1f23910c,0x002e22ad,0x00000000}},	//   _biedt_, _achterca, _важности_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x5bd9c045,0xac69606a,0x62a6400c,0x00000000}},	// [aa0] _реклами_, _mintegy_, _pembe_, --,
   {{0xb27e906e,0x04071035,0x03f45053,0x9ce3b13b}},	//   _ilana_, _तांदूळ_, _zetten_, _国家海洋局_,
   {{0xf2d9c089,0x525ad0ae,0xe25a9322,0x404fd173}},	//   _haver_, _skolas_, _mbale_, _адносна_,
   {{0xe94840a4,0x9b348031,0xa3ea914b,0x72feb056}},	//   _वेबसमूह_, _评价已经被关闭_, _saati_, _butiker_,
   {{0x96ec7117,0x73ea9159,0xc2d9c017,0x034200aa}},	//   _абсолютн, _paati_, _savet_, _nereden_,
   {{0x02f1a07b,0xb6b3a045,0x99e6724a,0xf962c0ea}},	//   _অবরোধ_, _бензинов, _craftsme, _같은지역출신_,
   {{0x82927133,0x37ebe349,0xe1fe2376,0xf5a6302e}},	//   _obrach_, _महाकाली_, _realizác, _plastick,
   {{0x3c6100f9,0x7555f00c,0x503be069,0x7ac720eb}},	//   _otorite_, _cumhuriy, _povthawj_, _zahvalje,
   {{0x19f871a6,0x616751bd,0x4224e07a,0x52d98120}},	//   _recenzí_, _ناپسند_, _veikla_, _obres_,
   {{0x220261e7,0x18acf036,0x00000000,0x00000000}},	//   _verite_, _доставчи, --, --,
   {{0xd26cc0ff,0x8c3fc108,0x12d8d113,0x00000000}},	//   _bodov_, _चम्पारण_, _tineeg_, --,
   {{0xf7a5f092,0xc32c816c,0xee361281,0x52cf0076}},	//   _objektov, _валуриле_, _kongsika, _kolorze_,
   {{0x326dc156,0xfc66c199,0xb25a003e,0x027e6018}},	//   _novog_, _protams_, _spila_, _along_,
   {{0xf292527c,0xcdd7d175,0x907d2293,0xb2b120cd}},	//   _fetare_, _превоз_, _барса_, _काबुल_,
   {{0xbd05a047,0x3e3a105e,0xedf9c02c,0x69f0a078}},	//   _suntasac, _karanasa, _многое_, _akintola_,
   {{0x3b9e316f,0xc2d4605b,0xf316618f,0x00000000}},	//   _podnosio_, _zeuden_, _asibiti_, --,
   {{0xb5ae61bc,0x109b404d,0x3d9b21b2,0x00000000}},	// [ab0] _дозволен, _オリジナル_, _phonsava, --,
   {{0x33ebe1c4,0x691a0036,0xd908d19b,0x1028e12a}},	//   _bitte_, _последно_, _تغذيه_, _nandrolo,
   {{0xf94cf062,0xa1b3c07b,0x726cb2b7,0x03f47190}},	//   _принципу_, _একসেস_, _dodoma_, _kartes_,
   {{0x429272f9,0x97baf0a9,0xc4fb2108,0xb4a90035}},	//   _zaradi_, _nekretni, _गिरामी_, _nasional_,
   {{0x693d312f,0xa4001037,0x3b6620c4,0x83ebe020}},	//   _الآخر_, _gabungan_, _spotreba_, _witte_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x4295c1b2,0x12f450a3,0x9bffa037,0x5264611a}},	//   _majkauv_, _stundas_, _pengacar, _berlen_,
   {{0xe2fc7093,0x9c7f0068,0x280cc293,0x4cbec02b}},	//   _dinge_, _meestal_, _млеко_, _манер_,
   {{0x72d462a2,0x134921e8,0x00000000,0x00000000}},	//   _verden_, _dovesti_, --, --,
   {{0x39207030,0xfc74b1bf,0x5163e0aa,0x018b3031}},	//   _शिवजी_, _forumit_, _programl, _日时政要闻_,
   {{0x23a232c3,0xbc8100a7,0xb529d293,0x34c970fe}},	//   _simpan_, _storitev_, _реакции_, _ফিডব্যাক_,
   {{0xb9fda1e8,0xcd3da1e8,0x00000000,0x00000000}},	//   _jedinica_, _jedinice_, --, --,
   {{0x72e5e037,0xfba961ea,0x00000000,0x00000000}},	//   _تبصره_, _psihiatr, --, --,
   {{0x327f405d,0xc9ff411c,0x0f4c0004,0x00000000}},	//   _esente_, _دستبند_, _אפשטאם_, --,
   {{0x62f45035,0x799b8086,0x7d86704e,0x73567071}},	//   _standar_, _shakisha_, _necesare_, _necesar_,
   {{0x2d32712b,0xfe92302a,0x9a77c0a4,0x8c874217}},	//   _pronájem_, _порталу_, _भन्नाट_, _varukorg_,
   {{0x9f21a004,0xb7c3316a,0x43ebe045,0xa637c02a}},	// [ac0] _קדושת_, _नजोडिएको_, _sitte_, _файлів_,
   {{0x739400a0,0x2b96015d,0x000d316f,0x23eae192}},	//   _prism_, _quangcao_, _nerazjaš, _syntes_,
   {{0xb3a230ed,0xe25b7275,0x2400f048,0x22d9e008}},	//   _sampai_, _soalan_, _nguội_, _later_,
   {{0x026cc0bd,0x42926057,0xc2d9e1dc,0x82fc6377}},	//   _vodou_, _diraja_, _fater_, _onoga_,
   {{0x73f470e6,0x82279004,0xb651503e,0xc60321d3}},	//   _besten_, _יארהונדע, _skrifað_, _आबिदा_,
   {{0x263fe0ca,0xdd6e9215,0x00000000,0x00000000}},	//   _kalendář_, _асфальту_, --, --,
   {{0xa78770de,0xbaea7020,0xd7aa7020,0xf31671e3}},	//   _तस्वीर_, _bestelle, _bestelli, _benze_,
   {{0xe2f0b018,0xc75cf173,0x00000000,0x00000000}},	//   _טריילרים_, _разведку_, --, --,
   {{0xda58910b,0x7e1a701b,0xf3489041,0xed98910b}},	//   _recenzia_, _pengelua, _recenzi_, _recenzie_,
   {{0xd2d891f6,0x02d8b0c3,0x2d230071,0x23091268}},	//   _dijete_, _acces_, _calitate_, _carbono_,
   {{0x226d102e,0x239d10a7,0xe415507b,0xb37f3154}},	//   _pozor_, _nadaljnj, _উদাহরণ_, _kamanda_,
   {{0x80fe126b,0xe200d136,0x7bba7078,0xb3003100}},	//   _אוגוסט_, _veliku_, _abawọn_, _kadangi_,
   {{0xcc5d206b,0x9c1e2378,0xf3eae13f,0xb353423a}},	//   _परदेस_, _compras_, _dantri_, _बहुचर्चि,
   {{0x0e82113b,0x61c9217a,0x133cc017,0xbaa7416a}},	//   _图等稿件均为转载, _кости_, _близу_, _potrubí_,
   {{0x7262d037,0x4eab8006,0xb4c3611c,0xe8668047}},	//   _سابقه_, _zostanie_, _همواره_, _beartais_,
   {{0x57929177,0xbbd872fe,0x78387180,0x00000000}},	//   _manteisi, _símbolos_, _स्प्रिंग_, --,
   {{0x927e912a,0x537970d3,0x617ed16e,0xe2903205}},	// [ad0] _alang_, _cosanta_, _أماكن_, _nalang_,
   {{0x3b72514f,0x7386d216,0x6290d0da,0xa3966142}},	//   _biashara_, _imeri_, _pelaku_, _flussi_,
   {{0xd778d0cb,0xd2c51039,0x7bb9d0a4,0x82918084}},	//   _یونانی_, _kellene_, _व्यक्तीं, _razali_,
   {{0x93cf70e8,0x1a64125b,0xeb31119b,0xbe73300f}},	//   _gravid_, _hőmérsék, _منیجر_, _मुण्ड_,
   {{0x726de0de,0xe25a9051,0xd27e9037,0x9968f045}},	//   _fotod_, _asali_, _elang_, _pasiente,
   {{0x12ca5003,0x43785074,0x63961070,0x7e8460a7}},	//   _haldi_, _inganta_, _مہینے_, _različni,
   {{0x625a5101,0x52da5215,0xb807b07b,0x0d6e8175}},	//   _kalli_, _europos_, _সমাবেশ_, _моментал,
   {{0xe1f5516a,0xbc5b81ea,0x626dc241,0x097160a6}},	//   _ओखलढुंगा_, _postani_, _novoj_, _सांझी_,
   {{0x439481ca,0x9200305e,0xaf83730d,0x825a502c}},	//   _teksto_, _galing_, _हकीकत_, _malli_,
   {{0xe365f1c0,0x639dc037,0xa68cd288,0xc2d9e1d9}},	//   _abogado_, _penyair_, _फरमान_, _vater_,
   {{0xd2d9e258,0x52b370a2,0x128be0df,0x23a29058}},	//   _water_, _ljudima_, _अनहोनी_, _chapo_,
   {{0xf2fce2d7,0xed57c1eb,0x227e0018,0x32d4b022}},	//   _bongda_, _тайвань_, _doing_, _dokokin_,
   {{0x53ebe056,0x26f0e108,0x3ba8b096,0x8029107a}},	//   _hitta_, _परिवेश_, _न्यूनतम_, _героем_,
   {{0x72d98024,0x9230006e,0x937a5068,0x0c6990ea}},	//   _aprel_, _aramada_, _volledig_, _게시판으로_,
   {{0x02466113,0xcc3ac0c2,0xd7b66057,0x72d81113}},	//   _nîmes_, _съвсем_, _peperang, _nqhes_,
   {{0x0394605e,0xa3f9e0dc,0x5fbf218d,0xbd4631eb}},	//   _bulsa_, _patur_, _fungerer_, _крутым_,
   {{0x73564173,0x00473265,0x725be25f,0x7e4bb2d7}},	// [ae0] _moteris_, _रिजल्ट_, _litla_, _vinagame_,
   {{0xa37f300c,0x3fa02210,0x106572c4,0xb26d503c}},	//   _zamanda_, _decembar_, _danskern, _pogoda_,
   {{0xe291f0f5,0xbe29505e,0x42bca04e,0xfa7f4056}},	//   _thuat_, _panganga, _mondial_, _varandra_,
   {{0x220032cc,0x126d80a0,0xf355d033,0x5386d00e}},	//   _paling_, _goron_, _acheter_, _seera_,
   {{0x20ea219b,0x00000000,0x00000000,0x00000000}},	//   _فراوان_, --, --, --,
   {{0x327ee0b9,0x88dad173,0x330e0267,0x22da408d}},	//   _kennis_, _skirting, _ababala_, _efanele_,
   {{0xe276010b,0xfc5a726c,0xb889613b,0x00000000}},	//   _starostl, _mentali_, _您当前位置_, --,
   {{0x03ebe370,0x22908136,0x4cb7b1af,0xac2bd175}},	//   _ditta_, _nikako_, _граници_, _ставил_,
   {{0x47d8723b,0xd6c9f0a2,0x92b4733a,0x1225f045}},	//   _अधिकांश_, _uglavnom_, _nunca_, _становле,
   {{0x826d9134,0x028bd0cd,0xbd9b91fc,0xb8d4a1c0}},	//   _noson_, _कुपोषण_, _toplanma, _bulutang,
   {{0x5200304a,0x53c5c171,0x547841ae,0x0c5530a3}},	//   _saling_, _estará_, _comercio_, _meitene_,
   {{0x234172e1,0xa394708c,0x1c77f241,0x5d4bb0e2}},	//   _peserta_, _kunsa_, _unesite_, _binadamu_,
   {{0x2e46e002,0xda9a5269,0x00000000,0x00000000}},	//   _पोस्टकार, _tehnilis, --, --,
   {{0x82b47128,0xa2247039,0x4c75f2be,0x6045b1ab}},	//   _munca_, _munka_, _रिक्शा_, _soluzion,
   {{0x9c537099,0xe1c92034,0x72c37379,0x7444d00b}},	//   _postova_, _госта_, _poslova_, _terjangk,
   {{0x680d4238,0x322b0320,0x4acb037a,0x6f0b0164}},	//   _मोटरसाइक, _kommune_, _kommunen_, _kommuner_,
   {{0xe2dc10d4,0x12cb9076,0xb3ce930c,0xb22b004f}},	// [af0] _notevoli_, _schowka_, _clave_, _commune_,
   {{0xd291f1ba,0x52345008,0x52fe613a,0xf201f1ff}},	//   _thuas_, _example_, _drugoj_, _thuis_,
   {{0xc39460b4,0x8d82918d,0x6502902a,0x741d3070}},	//   _agost_, _generelt_, _generell_, _ٹارگٹ_,
   {{0x13578118,0x4316908d,0x93f40014,0xd8462094}},	//   _profilo_, _kwazo_, _hastas_, _משכילים_,
   {{0x8c72d061,0x00000000,0x00000000,0x00000000}},	//   _skirtas_, --, --, --,
   {{0x2f8141a6,0x32246078,0x09f6000e,0xbb1cc089}},	//   _पृष्ठलाई_, _iroko_, _locative, _cinquant,
   {{0xf2fc00a6,0xef6d3048,0x41b3807b,0xed1e42ae}},	//   _liiga_, _đềmới_, _বাজেট_, _поздравл,
   {{0xf6397202,0xc7d99082,0x7b471204,0x00000000}},	//   _aplicaci, _надзвича, _kolačiće_, --,
   {{0x164df04d,0xa2014299,0x8b26c182,0x6090b02c}},	//   _この商品について, _medier_, _однос_, _netissä_,
   {{0x120fc037,0x22ca70f8,0xd2fd5264,0x63ea7119}},	//   _محترم_, _handi_, _chegar_, _hanti_,
   {{0x52ca7184,0x93ea71df,0xb31671e3,0x52fc90a2}},	//   _kandi_, _kanti_, _benza_, _snaga_,
   {{0xd1e73335,0x1db3207f,0x00000000,0x00000000}},	//   _kliknutí_, _sanatate_, --, --,
   {{0x72ca7102,0x1da660c9,0xf200b097,0x3291e25e}},	//   _mandi_, _pozitiva, _budite_, _iktar_,
   {{0x62ca7003,0xc386d05d,0xb7e70054,0xdc7d6036}},	//   _landi_, _leero_, _तवारीख_, _последва,
   {{0x2224d1bf,0x55785041,0x62560035,0x9e39c132}},	//   _greke_, _poslední, _थोडेसे_, _متعصب_,
   {{0xe2e3d090,0x425ad060,0xefa04209,0xf8d9219b}},	//   _prandaj_, _abele_, _videolar_, _تمرکز_,
   {{0x32d4702b,0x1c0ca241,0x49c6f0de,0x871cf175}},	// [b00] _vardas_, _austrijs, _खींचे_, _констати,
   {{0x205130c3,0x2de5237b,0x7b211065,0x9355c0e2}},	//   _историк_, _hoặc_, _البطولة_, _profesa_,
   {{0x49f621a2,0x17aa7192,0x99f2c16e,0xcb8740d4}},	//   _توصیه_, _bestilli, _mhargaid, _camiller,
   {{0x9af6c18d,0x0510102b,0xa2d50165,0xb525502a}},	//   _oplevels, _ферму_, _apposta_, _зверненн,
   {{0x63f4715f,0xb386d1e4,0xd3a2e0e9,0x25166163}},	//   _tautas_, _storas_, _skipta_, _prozorsk,
   {{0x6c379020,0x127e712c,0x33949084,0xb291e25e}},	//   _연구회참여_, _bonne_, _kuasa_, _aktar_,
   {{0x777f7302,0x329e116f,0xbd014144,0x8e3a2055}},	//   _क्रान्ति, _krajnja_, _okuliare_, _tababara,
   {{0xa394c1a3,0x72fce37c,0x52d3d057,0x82fc711e}},	//   _polski_, _lingua_, _seronok_, _ringa_,
   {{0x92fc70a1,0x3f6951b3,0xed6f9071,0xffbec090}},	//   _singa_, _intactas_, _адмисэ_, _koalicio,
   {{0xb744e11c,0x626e616a,0x8292500d,0xe02ca24a}},	//   _جنجالی_, _metody_, _satani_, _direksyo,
   {{0x4200c17f,0x417da018,0xb3dc61a3,0x00000000}},	//   _kilimo_, _סיבוב_, _znowu_, --,
   {{0x127e6078,0x2c31a20a,0x00000000,0x00000000}},	//   _oloni_, _аспирь_, --, --,
   {{0x88731031,0x129260e6,0x025a905d,0xe8cd9271}},	//   _您想在自己的网站, _gerade_, _kaali_, _intensid,
   {{0x0f1da0ea,0x00000000,0x00000000,0x00000000}},	//   _무엇보다도_, --, --, --,
   {{0x91db3173,0x62927154,0x00000000,0x00000000}},	//   _строгая_, _barani_, --, --,
   {{0xfbe8505c,0x7c91121b,0x0badb018,0x00000000}},	//   _खजुराहो_, _igauteng_, _ביומד_, --,
   {{0xa25aa158,0xb301b099,0xb248d1bd,0x00000000}},	// [b10] _abilé_, _odabere_, _filmet_, --,
   {{0x791b7048,0x827f704a,0x1c627203,0x5b2011e7}},	//   _giáo_, _adanya_, _seguito_, _arjantin_,
   {{0x8386c37d,0x92f6c03b,0xa512f0b7,0x660bc1bb}},	//   _bedre_, _artikuj_, _универсу, _учора_,
   {{0xa2615215,0x00000000,0x00000000,0x00000000}},	//   _зверобой_, --, --, --,
   {{0x1006c004,0x2bc990cb,0x227e71d9,0x00000000}},	//   _עסטרײַך_, _ٹیوٹوریل, _sonne_, --,
   {{0x20670004,0x93eb7099,0x00000000,0x00000000}},	//   _אידעאָלא, _slatko_, --, --,
   {{0x7c37d0cf,0x2dffe0dc,0xda0d30fe,0xd26d91ef}},	//   _istifadə, _arrestua, _ভয়াবহ_, _nosos_,
   {{0x23e0025b,0xf3730202,0xa2da7106,0x361d4100}},	//   _péter_, _delante_, _corect_, _разметку_,
   {{0x43f8e05b,0x526c6069,0x925b4036,0xd7157047}},	//   _minutu_, _hnoos_, _quelli_, _meiriceá,
   {{0x326cf039,0xe3ea905d,0x42924051,0x00000000}},	//   _angol_, _abato_, _jawabi_, --,
   {{0xad292006,0x5c092214,0xaddde210,0x8975c0b2}},	//   _komputer, _komputa_, _projekat_, _musiccit,
   {{0x52d9e37e,0x239d6173,0x3d7860b2,0x27e69176}},	//   _obter_, _заменены_, _khăng_, _हेमराज_,
   {{0x7e01c03c,0x3637b047,0x966420ea,0x00000000}},	//   _rejestra, _chiclipé, _공휴일제외_, --,
   {{0xa2a6c1b4,0x6213e1c0,0x539400a0,0xeaca1065}},	//   _sumber_, _lathe_, _grist_, _ومنتديات_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x020270bd,0x1d86c13c,0xfc18e164,0x5b6b6054}},	//   _deside_, _награду_, _detaljer, _renoveer,
   {{0x8386d158,0x568cd166,0x426d10f5,0x0db75133}},	// [b20] _beere_, _फरहान_, _socola_, _ministea,
   {{0x84868025,0xc3944254,0x6e51702c,0x82fc7100}},	//   _नीलामी_, _ormsa_, _viranoma, _dingo_,
   {{0x43954116,0x727e6119,0x906da018,0xe2eb4249}},	//   _geeska_, _loona_, _מסיבה_, _avsnitt_,
   {{0xa386e047,0x9b9950d5,0x3f9b5047,0xf200e018}},	//   _cairde_, _ध्रुवीय_, _minicíoc, _senior_,
   {{0x550380c3,0xdc4771d5,0xa0f3e0c9,0x93a3f0d7}},	//   _претекст_, _akuwkwo_, _županija_, _grups_,
   {{0x526e108e,0xb22a2003,0x325be128,0x00000000}},	//   _šport_, _heimild_, _titlu_, --,
   {{0x93f470a0,0xb27ee0b6,0xab93f319,0x92c9308f}},	//   _destun_, _finner_, _dividido_, _在庫がございます_,
   {{0xfcdc902c,0x00000000,0x00000000,0x00000000}},	//   _остально, --, --, --,
   {{0x93806009,0xa9113241,0x76d130c9,0xe0f3e36d}},	//   _ukuran_, _pojavlju, _pojavlji, _županije_,
   {{0xd26c8007,0xe74731c9,0xb23f7039,0xea0b7070}},	//   _kokoro_, _милион_, _munkatár, _kilométe,
   {{0x13574368,0xdf69d100,0xa2cb0246,0x4909d03c}},	//   _ज्ञानकोष_, _komandos_, _amadou_, _makijaż_,
   {{0x33940039,0x00000000,0x00000000,0x00000000}},	//   _friss_, --, --, --,
   {{0x73954328,0x73ea9007,0xfab70036,0xb4d100a4}},	//   _meesha_, _apata_, _германия_, _मालिका_,
   {{0x0a4a719a,0x826c712c,0x8d2d4222,0x00000000}},	//   _прелимин, _sinon_, _agriviet_, --,
   {{0xcb98e268,0x00000000,0x00000000,0x00000000}},	//   _enriquec, --, --, --,
   {{0x02927283,0xd542c036,0x627a11fd,0x09c0f224}},	//   _marami_, _невероят, _трениров, _prometna_,
   {{0x06d5d031,0xe22600a4,0xf641c100,0x327f0072}},	// [b30] _与本站立场无关_, _kaskus_, _шторм_, _fransk_,
   {{0x93eae239,0x74a811aa,0xac71b164,0x52008114}},	//   _buiten_, _izuzetno_, _startet_, _taking_,
   {{0xc3954116,0x02d5616d,0x03807033,0x5345212c}},	//   _beesha_, _tatoeba_, _heures_, _pendant_,
   {{0x13960192,0x83f4712c,0x4ebac1ab,0x52a6319a}},	//   _masser_, _cartes_, _рокли_, _limbaj_,
   {{0xd91b2054,0xf681e32a,0x420080a4,0x00000000}},	//   _आदर्शवाद_, _देसाई_, _saking_, --,
   {{0xb2ca717a,0x8b03f179,0x00000000,0x00000000}},	//   _разочаро, _haastatt, --, --,
   {{0x52da5187,0x72000119,0x92fcd0af,0xf7a730b5}},	//   _artean_, _idiin_, _enega_, _integrov,
   {{0xc9c641c9,0xa7bef031,0x4be2908d,0x853b7039}},	//   _apresent, _安徽企业网络服务, _inombolo_, _افلاطون_,
   {{0x20b8c2ad,0x93f470a0,0x938dc0d8,0x1241511c}},	//   _ислам_, _testun_, _اشخاص_, _سیمبین_,
   {{0xd27e7267,0x0a967190,0x6769e041,0x00000000}},	//   _bonna_, _decembrī_, _सदस्यले_, --,
   {{0x302e1034,0x679971b8,0xb25a50b4,0xf266f17a}},	//   _produzio, _противоп, _valls_, _immobili_,
   {{0x5c66d173,0xf27e7036,0xf3090061,0x7290a19d}},	//   _centras_, _donna_, _futbolo_, _kadang_,
   {{0x72e711ff,0x6affd12f,0xf2a741f6,0x00000000}},	//   _maanden_, _cróitis_, _trebam_, --,
   {{0xd9d9007b,0x1c72a120,0x725680cd,0x43940269}},	//   _সংযুক্ত_, _ofertes_, _सुहागरात_, _naise_,
   {{0x3fe8d311,0x79cd9035,0x521391df,0x927ed299}},	//   _सोयाबीन_, _नदिचा_, _basho_, _alene_,
   {{0x039581bf,0x4d120065,0x327eb1e8,0x00000000}},	//   _kurse_, _himreoir, _njenog_, --,
   {{0xb7aa311c,0x11b4b0c5,0xe290c19e,0xe6d9f057}},	// [b40] _فرانسوی_, _varmasti_, _jumaat_, _perpuluh,
   {{0xc6cca0d3,0xacf7401d,0x45e60106,0x0c258222}},	//   _ollainni, _hastalar, _procesul_, _funstarb,
   {{0x64e22125,0x52f4602d,0x00000000,0x00000000}},	//   _अय्यर_, _dikirim_, --, --,
   {{0xc2eca0b5,0x4ee63050,0x0200a05e,0xf7b3037c}},	//   _kontroly_, _билтен_, _bading_, _titulaci,
   {{0x3ac88071,0x13869047,0xfefb334b,0x00000000}},	//   _ресурсе_, _neart_, _perjalan, --,
   {{0x1ffc302c,0x25d65128,0x129261f5,0xd3ea700a}},	//   _способ_, _probabil_, _pirato_, _santu_,
   {{0xdff8f061,0x24463031,0xb2901055,0x62ca71c6}},	//   _французс, _信息产业部_, _odhan_, _pandu_,
   {{0x702eb0d7,0x9e29505e,0x93860160,0x00000000}},	//   _moderado, _nanganga, _beirt_, --,
   {{0xb3ac6142,0x6c14f039,0x5200a0a4,0x00000000}},	//   _gruppi_, _verseny_, _gading_, --,
   {{0x82895150,0x2a5e3056,0x4df711fd,0xe22461be}},	//   _endaweni_, _engelska_, _интервью_, _broka_,
   {{0xf27e616d,0xa39472ff,0xe0382077,0xcc8011ab}},	//   _noong_, _hérna_, _обувь_, _черен_,
   {{0x9386924d,0x3a1050d8,0xee68c033,0x1647e05d}},	//   _feart_, _irlandia_, _concerna, _abahingi,
   {{0xdeaca1c9,0x1602c178,0x1c1d12f0,0xef3f00cf}},	//   _controle_, _confianç, _štandard, _kilometr_,
   {{0xfb97f25b,0x279ed07f,0x37513173,0x0ecd60b5}},	//   _regisztr, _араба_, _сваёй_, _investič,
   {{0x6d76c1a2,0x524a20a6,0x00000000,0x00000000}},	//   _برهنه_, _कामेडी_, --, --,
   {{0x12551078,0xcad2e0e6,0x883860ea,0x00000000}},	//   _ajagunnà_, _vertrete, _쇼핑몰에서_, --,
   {{0x6e7cf098,0xf26dc1cf,0x149992ad,0x9ae4a1c4}},	// [b50] _बिश्व_, _novos_, _половине_, _telefonb,
   {{0x5ce21094,0x2d55a1af,0x616d2008,0xf2469065}},	//   _הקיצור_, _планира_, _military_, _gailísis_,
   {{0xbf7d1065,0x16d35037,0xf2baf1c0,0xf737a203}},	//   _الفعاليا, _majapahi, _sleeved_, _заплата_,
   {{0x07b3615e,0xfbe741ab,0x81bc60fe,0x00000000}},	//   _situācij, _ulterior, _সোহেল_, --,
   {{0xe7c9301a,0x9c6161be,0xdb063047,0x00000000}},	//   _varsinai, _burukwa_, _clasaice, --,
   {{0x9c5a7078,0x0c859008,0xfd325055,0x3386905a}},	//   _britani_, _רוסיה_, _dayniile_, _bwari_,
   {{0xd6edb1a3,0x138dd126,0x020ec045,0x4f03d1d5}},	//   _finansow, _اشراق_, _назар_, _akụnụba_,
   {{0x4cd7a1b2,0x335e10b7,0x3c0f20ea,0x63ea902c}},	//   _catholiq, _паузе_, _오피스텔분양권_, _saatu_,
   {{0x00e5602b,0x0dad0175,0x137d8159,0x22494035}},	//   _скандаль, _quantida, _adékòmí_, _taemin_,
   {{0x3aad9123,0x1b3d9008,0x53f94070,0x00000000}},	//   _funktion_, _function_, _indult_, --,
   {{0x2854311c,0x52ebc04d,0x63a290b6,0xa387704f}},	//   _موزيک_, _kvinder_, _skapa_, _charte_,
   {{0x42cae105,0xc3940007,0x85dab082,0xac7160cd}},	//   _bundan_, _irisi_, _зазначен, _भुट्टो_,
   {{0x5eab2378,0xa34040b4,0x00000000,0x00000000}},	//   _clientes_, _defensa_, --, --,
   {{0x05eee098,0xa22b20e7,0xe2b46175,0xb33fe2de}},	//   _příští_, _promene_, _troca_, _sedací_,
   {{0xb2d9b18e,0x9248e0c9,0x23ef42a4,0x1c5f42a4}},	//   _covert_, _primio_, _obitelji_, _obitelj_,
   {{0x0e35006e,0x4dc8c02a,0xc9ec2018,0x2f925098}},	//   _adigunja, _центром_, _להאמין_, _receptů_,
   {{0xd65d407f,0xdff42008,0xf280a0a5,0x00000000}},	// [b60] _контамин, _הנחיות_, _herkese_, --,
   {{0x2f38f1f4,0x8b421144,0x00000000,0x00000000}},	//   _होशियार_, _odporuči, --, --,
   {{0x42ca9051,0x44b3f004,0x4a8d50ea,0x00000000}},	//   _ibada_, _באָבע_, _전문가들은_, --,
   {{0x47e90342,0x82ca0060,0x69f96232,0x37074050}},	//   _अदाकारी_, _abidi_, _forumumu, _instalaç,
   {{0xd3ebe03e,0x00000000,0x00000000,0x00000000}},	//   _hitti_, --, --, --,
   {{0xf300c278,0xc2d4703f,0x8da9d06a,0xa30ac2ad}},	//   _podatki_, _naudas_, _rendelés_, _открили_,
   {{0x1c9cb175,0x7291807a,0x2629e0cc,0x2d2cc076}},	//   _помогнет, _vyras_, _ליבהאָבע, _podobnie_,
   {{0x527f4267,0x30e0e002,0x12f05037,0x6bccb036}},	//   _mwenzi_, _स्वीटी_, _kelinci_, _полицият,
   {{0x94f31034,0x594ed323,0xc2881008,0x222430a2}},	//   _местопол, _publizit, _עתידיים_, _majke_,
   {{0x5c32c0aa,0x0290224b,0xe62651ba,0xf7c7d02c}},	//   _olabilir, _kamate_, _túdarás_, _saksalai,
   {{0x82926235,0x32d8e2b7,0x7198a0c3,0x00000000}},	//   _jiraan_, _maneno_, _провизор, --,
   {{0x7308724b,0xd1414037,0x03ea91be,0x6292510f}},	//   _trebalo_, _مشارکت_, _abata_, _hutang_,
   {{0x9d0060bc,0x3bca9215,0x7c32c0aa,0x627e90b2}},	//   _groundbr, _светлых_, _alabilir, _loang_,
   {{0x064922e1,0xb27e237f,0x72249099,0x73eaa0ed}},	//   _نتيجه_, _rokna_, _braka_, _sabtu_,
   {{0x63940120,0x6b69d119,0x4df4919b,0xa824615e}},	//   _crisi_, _tartanka_, _منچستر_, _grīdas_,
   {{0xd3ead0bd,0xf2ca91d0,0x72bf0037,0x00000000}},	//   _montre_, _ipade_, _امواج_, --,
   {{0x1d056061,0x829262c3,0x1213f1b2,0x0f352380}},	// [b70] _populiar, _kurang_, _nsthe_, _muassasa,
   {{0x2a0c1004,0x113bb004,0xb37fc267,0xfe6c1070}},	//   _בפירוש_, _אלזוז_, _talanta_, _پیشوا_,
   {{0x32026008,0x22ac1008,0x471541c9,0x6ed0c133}},	//   _during_, _והקריות_, _seguranç, _nàiseant,
   {{0xb4a82284,0xc5d690e4,0x03374008,0x32b4d092}},	//   _opcional_, _परिपुर्ण_, _סטטיסטיק, _preco_,
   {{0xdb09818b,0x5c63030c,0x9853030c,0x7316d1e8}},	//   _lýsingar_, _estudio_, _estudios_, _prozor_,
   {{0x1b09302b,0xb2f300ed,0xd2d21143,0x4688e05f}},	//   _kompiute, _dilihat_, _paremini_, _wonderli,
   {{0xdc5ce12d,0x4c75f144,0x5ae5125c,0x52b4d208}},	//   _नोबेल_, _napriek_, _pertence, _stocha_,
   {{0xccd1d175,0xdcbec062,0x92fcd0c5,0xc7a080b2}},	//   _особено_, _кажем_, _blogin_, _eximbank_,
   {{0xdb752140,0x03f5224b,0x4342d32b,0xa2bf3047}},	//   _tekstova_, _tekstovi_, _बंदूक_, _حمدان_,
   {{0xd4f96080,0xd20260e9,0x5cef31a7,0x02cb4122}},	//   _peňazí_, _netinu_, _hintergr, _preden_,
   {{0x33dd200e,0xaf16c12f,0x51434065,0x7f1360a0}},	//   _anywa_, _leideann, _ممارسة_, _ffotogra,
   {{0x137a1037,0xa2fc708c,0x14044098,0x00000000}},	//   _masakan_, _dinga_, _semináře_, --,
   {{0xcaf720c3,0xa3cee1fe,0x2986a07b,0xec7d7054}},	//   _наречия_, _provoz_, _মুজতবা_, _muusika_,
   {{0x32b49006,0x7394903f,0x7c01c17d,0x00000000}},	//   _praca_, _prasa_, _luister_, --,
   {{0x33ead1cd,0x227ed134,0x7290419f,0x2c762002}},	//   _contre_, _eleni_, _idman_, _सिक्सर_,
   {{0xc25ac03d,0x4401b048,0x730971a3,0x7e2ec229}},	//   _mellem_, _kilobook, _aplikacj, _поверхно,
   {{0xb9c581bb,0xd2fc9064,0x1c630134,0xaac3d2f8}},	// [b80] _сказочны, _niaga_, _astudio_, _समापन_,
   {{0x02fc705d,0xc2d12098,0x738072b4,0x77aa6213}},	//   _bingi_, _autorem_, _terras_, _partiali,
   {{0xfa08a33c,0xc984f179,0x76d1a122,0x6e53a037}},	//   _bakabona_, _tarkaste, _dobavlji, _masaraka,
   {{0x2e6de291,0x72ea000d,0x12900046,0x239670d2}},	//   _अधिकारिय, _ingingo_, _leiaf_, _passie_,
   {{0x925ad045,0x43958120,0x7b21c16c,0x00000000}},	//   _spela_, _cursa_, _атенуаря_, --,
   {{0xc3cff07f,0xd56ff338,0x2883d0ea,0x91661018}},	//   _servicii_, _servicio_, _인근지하철_, _כיסויים_,
   {{0x65aa01bc,0xbceed175,0xc62d6045,0x7eb30044}},	//   _promoçõe, _вреди_, _trondhei, _dereitos_,
   {{0x40ad507b,0xdceed0b7,0x37500065,0xa6d320d5}},	//   _ধ্বংস_, _креде_, _الطويل_, _दूषित_,
   {{0x5d1e200d,0xd3ea9106,0x0b7871e4,0x00000000}},	//   _genocide_, _spate_, _catriona_, --,
   {{0x626de174,0x0d8451ea,0x08c0c144,0x72a64052}},	//   _votos_, _izberite_, _predsedu, _qembu_,
   {{0x529251bc,0xd2009069,0xe38000a2,0xc3df204d}},	//   _citado_, _txais_, _ispred_, _この質問内容が不,
   {{0x9b4010e7,0x32240074,0x9739c106,0xc2d8c082}},	//   _енглески_, _saika_, _impotriv, _bilete_,
   {{0x8373713b,0x66534173,0xbc51e025,0x4bf4101f}},	//   _demande_, _ментальн, _यादें_, _amatpers,
   {{0xbf263020,0x9cd99330,0x00000000,0x00000000}},	//   _홈페이지에_, _תחיית_, --, --,
   {{0x526cf091,0x00000000,0x00000000,0x00000000}},	//   _digon_, --, --, --,
   {{0x02fc7143,0xee7c00de,0x00000000,0x00000000}},	//   _ringi_, _तुम्ह_, --, --,
   {{0x5c6490ab,0x621391bf,0xb10e1018,0x4ead90d6}},	// [b90] _octubre_, _basha_, _מופצות_, _lintasme_,
   {{0x226ce131,0xaf4c404d,0x0767f12b,0x226cd32e}},	//   _infos_, _ウェブライタ_, _podložky_, _ndlovu_,
   {{0x927ff0a4,0x96981008,0xa769119b,0x14641276}},	//   _jeung_, _מעצבים_, _گذاشتم_, _ائتلاف_,
   {{0x52925299,0x08645050,0x42da51dd,0x640d2065}},	//   _betale_, _универзи, _ostean_, _النحو_,
   {{0x9263f007,0x929dd1ea,0xf39572d7,0xd237803e}},	//   _abdulsal, _svojega_, _trasua_, _verja_,
   {{0x72da40f5,0xb30fe00b,0x4394d018,0x47360018}},	//   _fullbox_, _menatap_, _guest_, _פיננסים_,
   {{0xb27e0258,0xe9b1f241,0x62da5121,0x4256c025}},	//   _point_, _dvadeset, _astean_, _अनदेखी_,
   {{0x214ec216,0x684a1061,0xe200d039,0x1c779013}},	//   _sisterho, _сотка_, _ideig_, _kwestie_,
   {{0xf395417a,0x23866011,0x33a3a06f,0x7764711f}},	//   _questa_, _stora_, _mappa_, _अस्तित्व,
   {{0xb09f204d,0x00000000,0x00000000,0x00000000}},	//   _イベント会場_, --, --, --,
   {{0x05e19031,0x74074039,0x1be3604a,0x1e47e128}},	//   _网站或个人转载使, _feliratk, _sementar, _требуе_,
   {{0xb2d56143,0x125b221b,0xdaf56077,0x52cae056}},	//   _euroopa_, _eccles_, _euroopan_, _handla_,
   {{0x52b571b2,0x35add036,0xa2f3c02c,0x92927239}},	//   _deacon_, _работата_, _lukijat_, _straat_,
   {{0x568ee177,0xd5f4a381,0x037ec0b7,0xed50e0e1}},	//   _ceredigi, _zamestná, _абордязэ_, _वेस्टइंड,
   {{0x73f460c5,0xf87d202b,0xb5d9d13c,0x127f7047}},	//   _kautta_, _кампанія_, _анализе_, _amanna_,
   {{0x9bab41a2,0x5d6de034,0xa3ea322e,0xbf2981da}},	//   _فرکانس_, _поддържа, _namtha_, _fratella,
   {{0x89f29036,0xa394230f,0x3c67d0c5,0x00000000}},	// [ba0] _великобр, _jūras_, _minusta_, --,
   {{0xa39580bc,0x6f242116,0x58bc2018,0xe847d1ab}},	//   _kurso_, _mustaqba, _מפגשים_, _развива_,
   {{0x5c4b11b4,0x22bb80a5,0xa5b602d7,0x64f91160}},	//   _sunting_, _nedenle_, _keangnam_, _موبايلي_,
   {{0xb2ab1068,0xa2d8b26d,0x9f23931d,0xc9b8e25d}},	//   _vandaag_, _videre_, _menentan, _handbolt,
   {{0x5679d118,0x18cb613b,0xdc70a018,0xd27e0033}},	//   _региона_, _北京新发地_, _outside_, _soins_,
   {{0x103fc105,0x92c5100f,0xbc6161e2,0xe25b60e9}},	//   _sistemin, _selline_, _dituela_, _reglum_,
   {{0x34c1f19d,0x92027052,0x0614913b,0x595cb188}},	//   _memberik, _sesine_, _经络锻炼法_, _naalakke,
   {{0x027e51ce,0x915b9107,0x8396623d,0x02ca900e}},	//   _volna_, _консумир, _persoa_, _abadu_,
   {{0xd0270070,0x6afa60ea,0xf26d107e,0x00000000}},	//   _باغیوں_, _이르기까지_, _dizon_, --,
   {{0xd34550ff,0x4e59501a,0x0e5000f7,0x89f65002}},	//   _nosenie_, _минималь, _vakantie_, _नागेन्द्,
   {{0x2395837e,0x52df11c4,0x12d4220b,0x2c4ec282}},	//   _curso_, _sonntag_, _maqdis_, _cheveux_,
   {{0x27cad1ab,0x3395f119,0x5292513d,0x62f520cf}},	//   _consigli, _muuse_, _totaal_, _ittiham_,
   {{0xac605144,0x622c111c,0xb7e0d382,0x12a6d383}},	//   _augusta_, _سیکلت_, _बिमर्श_, _osobnu_,
   {{0xc29c4069,0x323fe0ea,0x00000000,0x00000000}},	//   _txujlub_, _모집합니다_, --, --,
   {{0x3387f1be,0x55785092,0x429090a2,0x875c113b}},	//   _amuru_, _posledný, _najave_, _政府信息公开_,
   {{0x5317d0a9,0x63942143,0x427e60a4,0x0d29e173}},	//   _ljubavi_, _saksa_, _yoona_, _песнях_,
   {{0x422470bd,0x475a032a,0x1224222b,0xceb410a3}},	// [bb0] _manke_, _पिक्सेल_, _pakka_, _vardarbī,
   {{0xe3bb3037,0xc2da509e,0x52de413c,0x33860245}},	//   _اسباب_, _mateka_, _нормално, _ngira_,
   {{0x62e5e187,0xffe80035,0xaf3ca16c,0x9605a07a}},	//   _gainera_, _अर्थातच_, _колорату, _буклет_,
   {{0x8838f1ab,0x8d7860b2,0x3efc6054,0x7649a14d}},	//   _проектир, _phăng_, _युवकन_, _тендера_,
   {{0x7386007f,0x2ed040d3,0x0bb59111,0xf083b091}},	//   _stiri_, _cúiseann, _नियुक्ति, _derbynio,
   {{0x2c062008,0x2d60311c,0x950a6128,0x00000000}},	//   _השגויים_, _ماهیانه_, _momentul_, --,
   {{0x944ee02e,0x724941ae,0x00000000,0x00000000}},	//   _souvisej, _premio_, --, --,
   {{0xaf96b055,0x15319025,0x00000000,0x00000000}},	//   _wardheer_, _चम्बल_, --, --,
   {{0x6fcbc045,0xd2ff4081,0x5166e031,0x52c6e031}},	//   _свобода_, _skriver_, _第二十八条_, _第二十六条_,
   {{0x52da5154,0xdc75e05e,0x06a2a003,0xe06260d5}},	//   _wateja_, _sekular_, _tilfinni, _पारसी_,
   {{0xffa5b113,0x33eba02b,0xd3869102,0x417ec02f}},	//   _koomtxoo, _tapti_, _utara_, _дамбы_,
   {{0x8292703e,0x63860086,0xfc3080b9,0xf9d8a00c}},	//   _gerast_, _agira_, _spesifis, _inceleme,
   {{0x152b7070,0xaa4da0d4,0xec9361f3,0xd5fda0b5}},	//   _لڑکیوں_, _alleanza_, _निरोग_, _potenciá,
   {{0xb38070ab,0x22a6d144,0x1af6c070,0xa2ff7113}},	//   _terres_, _osobou_, _böngésző, _sibhlub_,
   {{0x2212e0c5,0x8212d35b,0x63877047,0x4224707a}},	//   _siihen_, _shehu_, _bearta_, _sunku_,
   {{0x317e01b8,0x40c7c0b7,0x1f6dd069,0x8053c19b}},	//   _положени, _физиче_, _toobfaab_, _تاکسی_,
   {{0xc224209c,0x0e923062,0x0b04f0c5,0x5be78208}},	// [bc0] _makko_, _потребу_, _viestist, _alpenhor,
   {{0x025b1124,0x2a05c0c3,0xb2420038,0xa26c70cb}},	//   _shalay_, _ближний_, _nyumbani_, _finom_,
   {{0x03eb8054,0x6960d05c,0x1ddc2070,0x7b9161a3}},	//   _tartu_, _फिटनेस_, _فلموں_, _materiał_,
   {{0x82da7109,0x87a11021,0x00000000,0x00000000}},	//   _årene_, _suaugusi, --, --,
   {{0x2248c195,0x23dd0082,0x00000000,0x00000000}},	//   _kommer_, _протягом_, --, --,
   {{0x5e54e1ab,0x79aa20e7,0x03947135,0x00000000}},	//   _икономич, _којих_, _séria_, --,
   {{0x85f32228,0xe804f293,0x63121114,0x3cbdd003}},	//   _अतिथि_, _австрали, _members_, _formaður_,
   {{0xac650181,0xb9f600cb,0xfb1af0d9,0xb39420c5}},	//   _最近のコメント_, _japán_, _preprost, _jakso_,
   {{0xbeffc19f,0x628cd065,0x00000000,0x00000000}},	//   _forumçu_, _كلامك_, --, --,
   {{0x62b55011,0x53a3f16d,0x62ff611c,0xc27ed02a}},	//   _precis_, _tsupa_, _pesisir_, _poeng_,
   {{0x12914091,0x00000000,0x00000000,0x00000000}},	//   _bedair_, --, --, --,
   {{0xac5300b5,0xb6e60065,0x00000000,0x00000000}},	//   _dostala_, _ههههههه_, --, --,
   {{0x7d85d194,0xb39600d1,0xb96e503b,0xec613241}},	//   _словами_, _wasser_, _aksident, _prirode_,
   {{0x653241bb,0xc1c400cc,0x4ec4313f,0x284a20f3}},	//   _нейтраль, _מאנהעטן_, _tienphon, _паралелн,
   {{0xf4d6a06b,0x02861008,0x8383915d,0xa2b66384}},	//   _नगरिया_, _רשלנות_, _petrotim, _marche_,
   {{0xf1bc507b,0x00000000,0x00000000,0x00000000}},	//   _হোটেল_, --, --, --,
   {{0xcf116108,0x00000000,0x00000000,0x00000000}},	// [bd0] _suitseta, --, --, --,
   {{0xaf938354,0x237a7074,0x2c138025,0xd36bd003}},	//   _vendedor_, _matakan_, _औरब्लॉग्, _byrjað_,
   {{0x138781cb,0x6b315065,0x00000000,0x00000000}},	//   _terre_, _الشديد_, --, --,
   {{0x2394012f,0xf9061020,0xf9c7c100,0x7200c0af}},	//   _naisc_, _부탁드립니다_, _багата_, _avdio_,
   {{0x52b46144,0x339500ff,0x2202603e,0x71a7206a}},	//   _troch_, _vlasov_, _skrifa_, _ہڑتال_,
   {{0x9b97400d,0xa837e020,0x826ce080,0x134c20b5}},	//   _komisiyo_, _하겠습니다_, _omnoho_, _dostupný_,
   {{0x72904193,0x03fad045,0x00000000,0x00000000}},	//   _odmah_, _старший_, --, --,
   {{0x895cc136,0x826ce385,0xdecdd03f,0x92f00154}},	//   _iskorist, _ponovo_, _oktobris_, _mshindi_,
   {{0xd76e3175,0x2993704d,0x00000000,0x00000000}},	//   _подготве, _ソフトウェア_, --, --,
   {{0x4396026d,0x63a3f0d4,0x22eb6089,0x40f5316a}},	//   _passer_, _grupp_, _plantes_, _अप्रील_,
   {{0xdeb820cc,0xa71dc1f7,0xf2914091,0x920251ea}},	//   _פעברואר_, _भद्दा_, _pedair_, _prvič_,
   {{0xac75e111,0xc7b710a8,0x62cae246,0x77cb7136}},	//   _कास्की_, _forsikri, _kundin_, _vlasteli,
   {{0x0380635a,0x3cde10cc,0xbe9650ae,0x3c22219a}},	//   _letras_, _צופרידן_, _čempionā, _înregist,
   {{0x1b87c106,0x8e404270,0xc2a7803b,0x29c71025}},	//   _библио_, _प्रशस्ति_, _serbe_, _प्रोमीता_,
   {{0xfda2c034,0xf224202c,0x82432130,0x6a123061}},	//   _контрол_, _pakko_, _мудрости_, _istoriją_,
   {{0x0f5c70a4,0x52b12080,0x89dfb039,0x02ea7141}},	//   _प्रगत_, _musieť_, _hangulat, _latihan_,
   {{0xe165404b,0x43eb71f9,0x7333e0f5,0x00000000}},	// [be0] _motorway_, _cuatro_, _matxa_, --,
   {{0xcc49633a,0x06e8b036,0xffb96044,0xff65a056}},	//   _título_, _гарантир, _títulos_, _betalnin,
   {{0x11983062,0xd592416f,0x00000000,0x00000000}},	//   _потребна_, _dvostruk, --, --,
   {{0xa3d5b1da,0x034200aa,0x6943507b,0x3081909d}},	//   _trattati_, _gereken_, _পুরনো_, _opubliko,
   {{0x03ce9136,0x726de0dc,0xac12b154,0x00c95065}},	//   _glavu_, _fotot_, _utaratib, _وبعدها_,
   {{0x0396608c,0x52d9006e,0x88895273,0x85a0c07b}},	//   _agusta_, _bibere_, _застрахо, _পাবলিক_,
   {{0x07b33044,0xf224e15f,0xd5933044,0x4876e076}},	//   _próximos_, _bankas_, _próximas_, _gimnazju,
   {{0xd35f3274,0xc34271e2,0x1d0dd033,0xd55c3386}},	//   _funguje_, _batekin_, _populair, _prašume_,
   {{0xdff45041,0x02bb7142,0x00000000,0x00000000}},	//   _नुवाकोट_, _komunità_, --, --,
   {{0x73869259,0x625ac225,0xc320d2a8,0x6efbb098}},	//   _fearr_, _mellom_, _ideya_, _prevence_,
   {{0xd69b2106,0x5bee301a,0x5c51d035,0xe7296352}},	//   _акциуне_, _таком_, _tentara_, _maslinov,
   {{0x9da791ac,0x13869128,0x52d91133,0x52442024}},	//   _kerosaka, _afara_, _aicese_, _mömin_,
   {{0x33a3f18b,0x127e614e,0xcf33e380,0x80574070}},	//   _kaupa_, _anong_, _persatua, _feladato,
   {{0x649cd270,0xfc267031,0xdf6d11d5,0xa27ee10c}},	//   _रश्मि_, _加入收藏夹_, _ahụhụ_, _ainnir_,
   {{0x225a9038,0xdf90212f,0xa87d217b,0xa265b00c}},	//   _mbali_, _تنفيذ_, _artichau, _maalesef_,
   {{0xeee65076,0x32015037,0xc3eb7037,0xdb5971cc}},	//   _मास्टरमा, _daging_, _muatan_, _nantinya_,
   {{0x0b765202,0x4417509f,0xcb6c026b,0x32c65128}},	// [bf0] _publicac, _politiek, _communic, _publice_,
   {{0x956db387,0xe38702ff,0x2387312b,0xf2cab013}},	//   _formació, _þarna_, _staré_, _hadden_,
   {{0x52da002a,0xceace017,0xec3101a3,0xe2fcf26f}},	//   _årets_, _користит, _osobowyc, _ligga_,
   {{0x3732402e,0x625a909c,0x1358e02e,0x00000000}},	//   _informov, _abali_, _letenky_, --,
   {{0x237961f5,0xa386d256,0xe3eb0084,0x94d1c03c}},	//   _kitanda_, _atera_, _umatku_, _पालिका_,
   {{0x9f22e2d7,0x96bcd13b,0xa394f225,0xc2258037}},	//   _vietinba, _见习魔法师_, _spiser_, _murka_,
   {{0x827e9081,0x725b701b,0x16869388,0x5341402a}},	//   _blant_, _jualan_, _गोराई_, _studier_,
   {{0x423f9008,0x12fc9097,0x42483299,0xfdbc9097}},	//   _במשקל_, _ostaviti_, _gammel_, _ostavite_,
   {{0x336ce16c,0x52d59295,0x53cf511d,0xe2b4913f}},	//   _виктория_, _odnosno_, _prevoz_, _trach_,
   {{0x83ebf02b,0xe2da60f8,0xd2a781a1,0x9394003f}},	//   _gauti_, _sarean_, _herba_, _gaisa_,
   {{0xd097e130,0x2237819d,0xdd0812d7,0xb7aa3144}},	//   _времена_, _kerja_, _vietstoc, _anatómia,
   {{0xb2fc700f,0x489dd031,0x53090120,0xa680e0be}},	//   _mingi_, _中国人民银行_, _treball_, _ieuencti,
   {{0x45d0a03f,0x2c07212f,0xc200c042,0x522422b6}},	//   _augustā_, _malartú_, _salive_, _pakke_,
   {{0x8f891175,0x9ab150ff,0xac28e174,0x1498e0f6}},	//   _детали_, _telefón_, _establec, _establez,
   {{0xe98e1034,0x72243136,0x34f6413b,0x6b3c20fe}},	//   _мария_, _bajke_, _一年赚一生工资_, _কীবোর্ড_,
   {{0x92d9e089,0x038781e2,0x42000004,0x4394c0b0}},	//   _actes_, _gerra_, _עמעצער_, _ymosod_,

   {{0xe200c02b,0x154a42ad,0x20dd219b,0xc06c81ab}},	// [c00] _galite_, _половини_, _تیشرت_, _налягане_,
   {{0x2637803c,0x83eb8119,0xe531e143,0x00000000}},	//   _प्रतीक्ष, _harti_, _कम्बल_, --,
   {{0x21cc90c2,0xb47360da,0x6d6d00f3,0xd6dfa036}},	//   _attività_, _साधनपेटी_, _бактерии_, _descrizi,
   {{0x2200c11a,0x31442008,0x1c379218,0xdf483008}},	//   _kalite_, _בטוויטר_, _району_, _possible_,
   {{0x672ba031,0x92cb812c,0xd3eb804e,0x43574244}},	//   _经销假冒伪劣商品, _mardi_, _marti_, _beredar_,
   {{0xda0aa380,0x318621ab,0x3bca9140,0x00000000}},	//   _manakala_, _икономик, _preminuo_, --,
   {{0x034061a9,0xfaf460cb,0x7276917f,0x00000000}},	//   _bagenda_, _ترقیاتی_, _mbinguni_, --,
   {{0x2ae7a14d,0x8b9511ab,0x224892b8,0x32d762c1}},	//   _медицине_, _столицат, _omama_, _govorio_,
   {{0x425d20ea,0xa204c26c,0x8f432082,0xb2fc010c}},	//   _자연스럽게_, _kapitali_, _досвід_, _uaigh_,
   {{0x603b90bb,0xc2cad32e,0xb2914036,0x031b230f}},	//   _hautxawj_, _nceda_, _creare_, _novadā_,
   {{0x6200c039,0x9d8c70eb,0x480d501a,0x50a3f15e}},	//   _addig_, _počeo_, _понедель, _datubāzē_,
   {{0xf349e21f,0x43ebf14a,0x940ef259,0x00000000}},	//   _esterni_, _sauti_, _teorainn_, --,
   {{0xe3db70eb,0x4e920144,0xf775332b,0x00000000}},	//   _početak_, _poškoden, _इन्सान_, --,
   {{0xe2bf804d,0x00000000,0x00000000,0x00000000}},	//   _ザ操作端末_, --, --, --,
   {{0x04b5b0a7,0x92008224,0xc4c3a09f,0x52b471d1}},	//   _zdravnik, _linić_, _verbruik, _tanca_,
   {{0xc23b812a,0x41ce5045,0x6035b1d9,0xbdffc008}},	//   _fremont_, _положенн, _seitenan, _understa,
   {{0x239541fd,0x88095020,0xc394d0f8,0x8d8f5232}},	// [c10] _viesti_, _삼성패밀리세이브_, _prest_, _belediye_,
   {{0x852f317f,0x5651503e,0x12918205,0x5da781b7}},	//   _mwandish, _skrifaði_, _kayang_, _motosika,
   {{0x7ac490cb,0x0315101b,0x00000000,0x00000000}},	//   _ارتکاب_, _kencing_, --, --,
   {{0xcfef6108,0x39b96017,0xb177401a,0xc2b401e7}},	//   _एकमात्र_, _материја, _kalastel, _chich_,
   {{0x5e4380d8,0xac3390cc,0x740b7142,0xa68d6025}},	//   _madaniya, _זאליס_, _immigraz, _भड़ास_,
   {{0x05049031,0x6bc130ea,0x5899b032,0x5c57f04d}},	//   _除权除息日_, _세금계산서_, _моментов_, _強い味方が必要_,
   {{0xa9022020,0x0290f0f5,0xd2ee50ad,0x14fda0ea}},	//   _저작권침해_, _fshare_, _verilib_, _상품입니다_,
   {{0xc1880190,0x00000000,0x00000000,0x00000000}},	//   _restorān, --, --, --,
   {{0xa39591cd,0xb2fc0215,0x8c34e0ea,0x4006c050}},	//   _aussi_, _taigi_, _민주주의법학연구, _енергија_,
   {{0x9b11b0d8,0x1fea71cc,0x9adb007b,0x92cae0f7}},	//   _امريکا_, _अर्थजगत_, _কলকাতা_, _landen_,
   {{0xcc5381d4,0x720e10c5,0x0386d216,0x00000000}},	//   _sentido_, _начал_, _chorom_, --,
   {{0x3248f106,0xf2249119,0x327f92c1,0x22d8f177}},	//   _primul_, _saaka_, _bosne_, _amgen_,
   {{0x0f950223,0xa2f00108,0x73878003,0x00000000}},	//   _अज्ञात_, _वक्री_, _verri_, --,
   {{0xc344b170,0xeea3829c,0x69e5004d,0x384c9175}},	//   _stredne_, _vendidos_, _テクノロジ_, _поставув,
   {{0xe320032e,0x26228287,0x0676b0ef,0xf27c60e6}},	//   _eliya_, _organizá, _دانشور_, _herstell,
   {{0xa4019058,0x8d0b20f8,0x4d9781a3,0x8682d067}},	//   _ameriken_, _horretar, _motoryza, _अहवाल_,
   {{0x9969e06a,0xa3866091,0xd4d1c12d,0x6e0cb16a}},	// [c20] _مظاہرہ_, _stori_, _डिजिटल_, _vlastně_,
   {{0xc66f61a3,0x9d6f3065,0xd34c20b5,0x2386d09f}},	//   _pozdrawi, _أحكام_, _dostupné_, _sterf_,
   {{0xa3945119,0x42cb5043,0x15a9f13b,0x7dbf9036}},	//   _balse_, _dogdig_, _大兴少年宫_, _областта_,
   {{0xf2cfd0c8,0x627ed168,0xe7fa41d6,0x5ad9c08f}},	//   _dokonce_, _poena_, _anabigag, _トラックバックの_,
   {{0xe39450b9,0x186d217a,0x00000000,0x00000000}},	//   _valse_, _биология_, --, --,
   {{0x67566185,0x32ca507f,0xe2b40116,0x72cbf03f}},	//   _प्रमाणात_, _conditii_, _dhici_, _naudu_,
   {{0xd2b400f5,0x9c51d1c6,0xbde6f0d8,0x00000000}},	//   _thich_, _tentera_, _prajurit_, --,
   {{0x938662f6,0xb023910b,0x038d2070,0x4b4961d5}},	//   _agora_, _pondelok_, _اشیاء_, _aịkọn_,
   {{0xf200612c,0x3aebc10f,0x3ed6a025,0x42cbf143}},	//   _avoir_, _golongan_, _लैपटॉप_, _kaudu_,
   {{0xcfea4025,0xbba481a7,0x00000000,0x00000000}},	//   _पुरालेख_, _lediglic, --, --,
   {{0x11703020,0xce734389,0xf37970e6,0x6bf1e1ac}},	//   _책임한계와_, _विप्र_, _angaben_, _berterus,
   {{0x07aad117,0x32360013,0x024830b6,0x50b7e179}},	//   _любви_, _vrije_, _gammal_, _парень_,
   {{0xa27e6119,0xd2f462aa,0x9a60f004,0xa751838a}},	//   _gooni_, _airneis_, _אָננעמען_, _विकिपिडि,
   {{0x13413065,0x5cf0b065,0x123601ea,0x7fa5113b}},	//   _أنحاء_, _البصرة_, _trije_, _网络文化经营许可,
   {{0x02b4d177,0x39f8f060,0x01e020c3,0x36e8c24a}},	//   _drech_, _ainidena_, _бэтая_, _emicrani,
   {{0xdc7661d6,0x22f53241,0x787380f9,0x00000000}},	//   _agirisi_, _turizam_, _disponib_, --,
   {{0xf3f82007,0x22b4d134,0xc9675025,0x54769082}},	// [c30] _lekun_, _frech_, _वाहनों_, _процесу_,
   {{0x852951bb,0x21661094,0x5da9d076,0x7ae58217}},	//   _брутальн, _חידושי_, _zapomnia, _spelaren_,
   {{0x92da507f,0xb98590ff,0x02b5320d,0xac6f5007}},	//   _altele_, _polievka_, _kendine_, _ajurawa_,
   {{0xb2a7c036,0xec7c81c4,0xc197c229,0xf30d2037}},	//   _района_, _meisten_, _районе_, _pembawa_,
   {{0x038690f4,0x2386d216,0xc26370bf,0x00000000}},	//   _atari_, _etere_, _adebísí_, --,
   {{0x1b09f267,0x73f46147,0x00000000,0x00000000}},	//   _abaprote, _martsa_, --, --,
   {{0x9591408e,0xa20091cb,0x82a6d05d,0x02a600f6}},	//   _prispevk, _avait_, _ntebe_, _uribe_,
   {{0xf486b363,0x3aca31b8,0x02d872b6,0x8e0f310c}},	//   _प्रायः_, _китайски, _emnet_, _aimeirea,
   {{0xb528621f,0x82da50a7,0x2c05f03b,0x00000000}},	//   _libertà_, _katero_, _personi_, --,
   {{0xd23601f6,0x6158a082,0x4248002b,0xc91af0b2}},	//   _prije_, _оголошен, _seimo_, _chịu_,
   {{0x8549b108,0x7c78e147,0x0413f1d7,0x104e4246}},	//   _स्पेशली_, _patuloy_, _ceistean_, _ahlussun,
   {{0x72f0a278,0x3383c07b,0x7225802c,0x29fd2106}},	//   _delovanj, _নিয়োগ_, _turku_, _duminica_,
   {{0x026d81dd,0x10a47004,0x00000000,0x00000000}},	//   _kirol_, _לאַגער_, --, --,
   {{0x59b7300a,0x0f24f0c3,0x11792376,0x00000000}},	//   _bandiera_, _админист_, _španiels, --,
   {{0x65417065,0x402ec1ab,0x3d0310d7,0x227f71df}},	//   _المؤتمر_, _tradizio, _explicat_, _ilanga_,
   {{0x12d88157,0x56d5a119,0x2687d23a,0xf453938b}},	//   _heheeh_, _faransii, _खुराक_, _अनौपचारि,
   {{0x8337c034,0xad341018,0x3053c175,0xcb7fe099}},	// [c40] _николай_, _באיטליה_, _ромите_, _dopunska_,
   {{0x71fc90c3,0xb2a69150,0x65a9b04d,0x2fc7b065}},	//   _порядков, _ngaba_, _よろしくお願いし, _ولكنها_,
   {{0x4387f0ab,0xd292710c,0xafbd113b,0x00000000}},	//   _veure_, _òrain_, _年中国经济现代化, --,
   {{0x938690b2,0x81dc7004,0x4c9810b4,0xdff00062}},	//   _muare_, _ספּאָרט_, _objectiu_, _чешки_,
   {{0x18dcd0b7,0x00000000,0x00000000,0x00000000}},	//   _аузит_, --, --, --,
   {{0xba0530aa,0x9200904f,0x7ff700c4,0x6d839173}},	//   _saklıdır_, _avais_, _smokovec_, _войнах_,
   {{0xe97a219b,0xf5c1e1e4,0x536b4116,0x00000000}},	//   _شقایق_, _artaigil_, _gargaar_, --,
   {{0x6477a082,0x226c20bd,0x00000000,0x00000000}},	//   _проекту_, _lakou_, --, --,
   {{0x62d82053,0x11f1a1a2,0x1c5b9088,0xc1cc6190}},	//   _weken_, _ریمیکس_, _katulad_, _finansēj,
   {{0xc2fe72d7,0xd3ead247,0x8200d02b,0x8fe8a0ca}},	//   _exciter_, _protin_, _kelias_, _सीताराम_,
   {{0x5429a119,0x12f460e9,0x73877100,0x03eae108}},	//   _inkastoo_, _hvenær_, _tvarka_, _kontot_,
   {{0x35cac1a5,0x238691d6,0xdceff056,0xe5c8d1df}},	//   _canbannh, _agara_, _ansvarig_, _intaneth,
   {{0x8a11f189,0xd2d8312b,0x2cf2822b,0xb758038c}},	//   _pemberit, _nejen_, _myndband_, _विस्वास_,
   {{0x17a7510b,0x67d800a2,0x00000000,0x00000000}},	//   _opatreni, _događaj_, --, --,
   {{0xe2da51dd,0x927e122b,0x73eb8192,0xd1660094}},	//   _batean_, _einstakl, _marts_, _עירובין_,
   {{0x0aa830ea,0x4017d062,0x00000000,0x00000000}},	//   _전체적으로_, _наводно_, --, --,
   {{0x993bd166,0x736f1076,0x4b005065,0x4cc520b7}},	// [c50] _सिद्धांत_, _akceptuj, _للايجار_, _активитэ,
   {{0x32d8205f,0x8c07532f,0x203fb03b,0x5290b0aa}},	//   _teken_, _कामसूत्र_, _historin, _bedava_,
   {{0x0867a25b,0x92add039,0xe11a1008,0xf75a1008}},	//   _április_, _الشان_, _לדיוור_, _לכיוון_,
   {{0x02b2f06a,0x57a4313b,0xa8cc2143,0xb9dc20a3}},	//   _rendben_, _胶南市乡镇及街道, _klientid, _klientie,
   {{0x225a6144,0xb2cb7316,0xdb9401cb,0x0e72213b}},	//   _spolu_, _aradan_, _similair, _遵守中华人民共和,
   {{0x425a607f,0x837900c4,0x60e97166,0x4c5c72d7}},	//   _acolo_, _zdravia_, _अधीक्षक_, _vietbao_,
   {{0x42bde111,0x9394711a,0x8ca222ba,0xcfde1004}},	//   _prodám_, _panse_, _יקותיאל_, _לובלין_,
   {{0x3c67d11c,0xd257025b,0xcd2c7025,0xe1e5b03b}},	//   _ارزان_, _múlva_, _ponownie_, _politikë_,
   {{0x296481fd,0x2c6fc121,0x589a20ea,0x62e0c034}},	//   _известно_, _loturak_, _포토갤러리_, _tecnico_,
   {{0x21257020,0x4816f215,0xa1271082,0x4f648045}},	//   _사업자등록번호_, _pareigūn, _заходи_, _utdannin,
   {{0xa248c033,0xc2002024,0x9ac4804d,0xd354a061}},	//   _sommes_, _ilkin_, _質問をみる_, _didelis_,
   {{0x1340126c,0x8863a008,0x030300cb,0x42d84058}},	//   _tabella_, _טרייד_, _valamit_, _demen_,
   {{0xc3eb9190,0xa2d9a118,0xb60fa0da,0x73fa709e}},	//   _pastu_, _invece_, _श्रावणात, _rusumo_,
   {{0x498b0163,0xdd47b041,0x3b17b128,0xc21e0008}},	//   _znači_, _dispozic, _dispozit, _שופינג_,
   {{0xe2d841ff,0xec7690b9,0x99436033,0x23d8b0fe}},	//   _nemen_, _verslag_, _imprimer_, _বিএডিসি_,
   {{0x62fcd086,0xdeb9d013,0xa316d245,0x00000000}},	//   _nzego_, _situatie_, _ageze_, --,
   {{0x82d84323,0xac6f709e,0x22cae0f8,0xcf25b0f7}},	// [c60] _hemen_, _afurika_, _handia_, _telefoon,
   {{0xb1e1a0ff,0x4201430e,0x02d921df,0xe0537068}},	//   _niektoré_, _medios_, _inceku_, _consumen,
   {{0xc3f46259,0x12fc908d,0x670fb259,0x3218b050}},	//   _curtha_, _izaga_, _institiú, _потребни_,
   {{0x69e240cd,0xc8606124,0xeaf85040,0x643fe0c3}},	//   _पट्टी_, _banaadir_, _aktuelle, _ефектив_,
   {{0xf2d830c4,0x247c30aa,0xe5bae098,0x00000000}},	//   _odmena_, _genellik, _přičemž_, --,
   {{0x4303a2a8,0x00000000,0x00000000,0x00000000}},	//   _magamit_, --, --, --,
   {{0x49cc11ce,0x5be75089,0xa81dd07b,0xc387e03e}},	//   _rendelke, _assessor, _বগুড়া_, _betra_,
   {{0x0386d24a,0xc3f47035,0x00000000,0x00000000}},	//   _peoria_, _sastra_, --, --,
   {{0xab56d083,0xd27e01df,0xbac71193,0x42027148}},	//   _sentiasa_, _unina_, _prilično_, _risico_,
   {{0xfc6bd036,0xdff5438d,0x727ed1df,0xa225224a}},	//   _означава_, _proteína, _mnene_, _hickey_,
   {{0x432f51fc,0xaaf230d9,0xf2078160,0x6069b12b}},	//   _təyin_, _priredit, _priontái, _podprsen,
   {{0x2dc41008,0x5386d1a3,0xd2495002,0x29dfa124}},	//   _באפריל_, _ofert_, _olemas_, _booliska_,
   {{0xa2d8525b,0xa3eb8008,0xe2927037,0x82d821be}},	//   _jelen_, _parts_, _ibrani_, _bekee_,
   {{0x42d850f7,0x525c60c2,0x95a391aa,0xe2d4630c}},	//   _delen_, _località_, _победу_, _verdad_,
   {{0x63877219,0x4387e03e,0x5dc530d8,0xc1de6047}},	//   _zdarma_, _betri_, _suriname_, _chinntiú_,
   {{0x27db2270,0x54fbd096,0x5b5a7090,0xd349f0c4}},	//   _टीआरपी_, _कैलाली_, _mendimin_, _stretli_,
   {{0xb2908084,0x434370ea,0xa3fa70fc,0x00000000}},	// [c70] _baharu_, _머니투데이_, _kasuan_, --,
   {{0x240ef031,0xc27f10ff,0x4cd6c173,0xc2cae246}},	//   _比上年增长_, _mozno_, _забрала_, _sandan_,
   {{0x6000d220,0xd90e20cc,0x92cae1ac,0x6c2d5205}},	//   _informāc, _וואלוטע_, _pandan_, _espiritu_,
   {{0xb24802ff,0x670dc130,0x6301836d,0xf26d918b}},	//   _heima_, _кадра_, _trebate_, _vandamál,
   {{0x93411039,0x026c211e,0xa25bf17f,0x143ec1bb}},	//   _انوار_, _bakom_, _kauli_, _тайне_,
   {{0xe6cca2c0,0xc26dd1d2,0x00000000,0x00000000}},	//   _polainni, _ciwon_, --, --,
   {{0xa2d1a144,0x18683132,0xc9f5b06a,0x00000000}},	//   _človek_, _حيثيت_, _kevés_, --,
   {{0x88480087,0x2a31512d,0x7c6831d4,0xb9483319}},	//   _ağustos_, _सब्जी_, _escrito_, _escritor_,
   {{0x72d8500c,0x92fcd0b0,0xc23fe12b,0x00000000}},	//   _gelen_, _blogio_, _elektrár, --,
   {{0x1a7212ae,0x727ed0c4,0x69aac20a,0xc6e6c175}},	//   _акции_, _ikonku_, _комис_, _публикат,
   {{0xc24862c8,0xa3eb90ae,0x7394714e,0x896601a6}},	//   _veoma_, _pasts_, _bansa_, _जीवनको_,
   {{0x6200c126,0xbe6dc100,0x3d8a71bc,0xa302c007}},	//   _pedig_, _заменена_, _вицепрем, _akinkanj,
   {{0x647550fb,0xc388000a,0x23657215,0x328380ee}},	//   _disediak, _bulgarij, _mergina_, _nishani_,
   {{0xeae1f276,0x17fc10b7,0x0bea0036,0xe2e8e0aa}},	//   _pahlawan_, _алягэ_, _incontro_, _bilinen_,
   {{0xb290402c,0xad8040d5,0x62d840b9,0xd3e0220a}},	//   _ilman_, _सुस्वागत, _hemel_, _медалион_,
   {{0xb926c182,0xb3875277,0x11a4d140,0x12fc7003}},	//   _причини_, _áfram_, _nikolić_, _gangi_,
   {{0x8ec18047,0x438ff154,0x32f081f5,0x8263c154}},	// [c80] _bronntan, _wanyama_, _abaingi_, _katoliki_,
   {{0x152d627b,0x945e7144,0x16250035,0xd2b36022}},	//   _ezintath, _prievidz, _प्राजक्त, _saudiya_,
   {{0xc2fc71f5,0x78d31030,0x8dd6c091,0x3d8aa05d}},	//   _bangi_, _विंटर_, _gwahania, _abamaaka,
   {{0x7ad3b13b,0x53f45056,0x126e01a3,0x00000000}},	//   _正在载入用户签名, _mitten_, _europy_, --,
   {{0x8292730a,0x93949143,0x0915e1a7,0x27ae4065}},	//   _durant_, _kaasa_, _verbindu, _مكافحة_,
   {{0xa36401df,0xf26c211d,0x62926031,0x821c5052}},	//   _amagama_, _takoj_, _autant_, _omuhle_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x953602ba,0x89786118,0x02c4112c,0xc87880cd}},	//   _מברסלב_, _amminist, _vendredi_, _दर्दनाक_,
   {{0x9213216a,0x82a6338e,0x630cb0d3,0xdc48d15c}},	//   _archiv_, _membro_, _cosaint_, _वैमनस्य_,
   {{0x5c6f7155,0x0b094089,0x4bffe227,0x5a474154}},	//   _aburula_, _comparte, _ofensivo_, _karemera_,
   {{0x03eb8008,0xccd340d2,0x72055154,0x00000000}},	//   _party_, _verkeerd_, _mahitaji_, --,
   {{0xd23dd017,0xc26dd1cc,0x42e0612b,0xfe4b1119}},	//   _празника_, _siwon_, _jednoho_, _barakaca,
   {{0xa2f4c11d,0xa300e04c,0x12d8009f,0x425ac068}},	//   _napisal_, _pegawai_, _twiet_, _vallen_,
   {{0xdfea41f4,0xe570619b,0xe12d10e7,0xbb2a31d6}},	//   _बरदाश्त_, _میهمان_, _сајта_, _anabatab,
   {{0x37a3f03d,0x2d021071,0x72c43275,0x47c79049}},	//   _チェックリスト_, _declarat_, _menerusi_, _समूहों_,
   {{0x622670da,0x626cb044,0x2ea14045,0x00000000}},	//   _parkir_, _ricos_, _fullsten, --,
   {{0xc2fc7038,0xb2df430b,0xf39d10b3,0x3320412a}},	// [c90] _rangi_, _melebihi_, _izdavanj, _emmys_,
   {{0x52d870e6,0x57ab11c7,0x0dc4c034,0x02f4c018}},	//   _denen_, _ketrampi, _capitale_, _capital_,
   {{0x527e6222,0x4aea70e6,0xee392021,0x2f399018}},	//   _giong_, _erstelle, _нацыянал, _תקציר_,
   {{0x4386d086,0xfb8ac107,0x5349f00a,0x4225901c}},	//   _agera_, _помош_, _insetti_, _muski_,
   {{0x235660e8,0x93ea8090,0x9c6ef38f,0x00000000}},	//   _arbetar_, _faktin_, _imorgon_, --,
   {{0x0bb27186,0x04692050,0x827f0184,0x00000000}},	//   _म्युनिसि, _conforto_, _afandi_, --,
   {{0x627e6069,0x0facb085,0x1cf81008,0xd94cb153}},	//   _xiong_, _favorito, _מתאימה_, _favorite,
   {{0xbc89f1d6,0xc20b637b,0xc2fd129e,0x1c0ac02c}},	//   _akapịbag, _vườn_, _pomidor_, _позже_,
   {{0x593b9128,0x03966134,0x725ad096,0x89a3e02e}},	//   _asemenea_, _berson_, _oceli_, _rodinnéh,
   {{0x32905075,0xf2a71092,0x42cf1045,0x00000000}},	//   _allan_, _stavebné_, _annonse_, --,
   {{0x02b490f5,0x93ea8194,0x027f7086,0x01843088}},	//   _khach_, _viktig_, _nyange_, _kinakail,
   {{0x368ce108,0x6212d0ca,0x22489128,0x027e0119}},	//   _बैताल_, _tenhle_, _seama_, _miino_,
   {{0xb38690ed,0x00000000,0x00000000,0x00000000}},	//   _suara_, --, --, --,
   {{0x6abe825e,0xac47b2aa,0xe1e29175,0x8c601091}},	//   _provvist, _hunchbac, _властите_, _cynradd_,
   {{0xea158360,0x026f127b,0x0a17c231,0xeb1ff31d}},	//   _automáti, _eminingi_, _inicijat, _penafian_,
   {{0x440f2133,0x92a6005e,0xb394d153,0x722ad215}},	//   _fearainn_, _tribo_, _press_, _позах_,
   {{0x6e73e1f0,0x32fc705d,0x2290d214,0xd0d09065}},	// [ca0] _बौद्ध_, _mangu_, _manase_, _للنساء_,
   {{0x726e502c,0xb6d2b076,0xfbed31ea,0xc2da7160}},	//   _kotona_, _यूजिक_, _rezervir, _nasedo_,
   {{0xaffd9071,0x27f4d020,0x5422405d,0x185140fe}},	//   _военкома, _사업계획서_, _ababiito_, _পারভেজ_,
   {{0x02f4a1e8,0x60e620cb,0xb270b056,0x00000000}},	//   _velikoj_, _باشندوں_, _områden_, --,
   {{0xb2018282,0xb4fac035,0x7585c05a,0xc9c7d182}},	//   _avril_, _खादाडी_, _ipererez, _прилеп_,
   {{0xca222100,0x5429223e,0x023660aa,0x03166038}},	//   _строй_, _himpitan_, _proje_, _ngozi_,
   {{0x1bd80390,0xa94cc068,0x696b4068,0xb7014183}},	//   _अमेरिकन_, _favoriet, _groninge, _américa_,
   {{0xf26c3102,0x00000000,0x00000000,0x00000000}},	//   _tolong_, --, --, --,
   {{0xe3966114,0x72fc91be,0x7a15e0e6,0xdc6de10c}},	//   _person_, _taagi_, _verbunde, _llorona_,
   {{0x2ff90302,0x9304f110,0xf8d8f175,0xffd5416f}},	//   _अर्थात्_, _whooping_, _помогнат_, _upozoren,
   {{0x5200b036,0xc8e692be,0x5280e008,0xd356b391}},	//   _ordine_, _न्यूयार्, _variety_, _obtener_,
   {{0xf7ac0251,0xe27ed134,0x52d87089,0x7e07d13c}},	//   _colectiv, _poeni_, _tenen_, _правна_,
   {{0xf1852293,0x82026061,0xdf19f0b3,0x7639005f}},	//   _огромен_, _turite_, _navijača_, _besighei,
   {{0x33fa7392,0xef272208,0x163e8025,0x42cab124}},	//   _poruku_, _agartasa, _आईएएनएस_, _aaddan_,
   {{0x775662ed,0xe5362021,0x13ea6047,0x52e68124}},	//   _प्रमाणित_, _ілюстрац, _scoth_, _arintan_,
   {{0x629ec1ab,0x143350fe,0xb292408d,0x32d8721b}},	//   _финал_, _লিখিত_, _ncwadi_, _denel_,
   {{0xd529d393,0x12fc726d,0x58d391b2,0x020c9036}},	// [cb0] _obasanjo_, _langt_, _attrativ, _комбинир,
   {{0xd202f29a,0xbaf862aa,0x0c7450cd,0xc2ebc347}},	//   _siromašn, _ierusale, _वैष्णव_, _mobitel_,
   {{0x62d8720d,0xe869a175,0xb25ab055,0x100ff0cb}},	//   _genel_, _книгата_, _fadlan_, _ٹوئنٹی_,
   {{0x3181807b,0x5439c2b0,0x22bbf008,0x57535035}},	//   _মুরুব্বী_, _traballo_, _powered_, _युटिलिटि,
   {{0x8bb9e020,0xd22b3143,0x9a093070,0x93329017}},	//   _스팸블로그로_, _esimene_, _درجنوں_, _културна_,
   {{0x0394e0a2,0x726cc056,0x2eb441a6,0x00000000}},	//   _zaista_, _sidor_, _posunout_, --,
   {{0xe27e915d,0xe9de32b5,0xd2a691c0,0xff839035}},	//   _giang_, _contenid, _grabe_, _एक्का_,
   {{0x116dc221,0xd36c7154,0x6047005c,0x00000000}},	//   _monitory_, _bungeni_, _रॉयल्स_, --,
   {{0xa386d07f,0x726c11b2,0x10604061,0x7c5851a0}},	//   _oferi_, _ibhom_, _prisimin, _kritiek_,
   {{0x227e7195,0x82a7d100,0xf2d8a202,0x299330cb}},	//   _finne_, _работай_, _deben_, _سپیکر_,
   {{0x32366117,0xa2fc7154,0x1a310070,0x32925154}},	//   _sulje_, _tangu_, _قیصرانی_, _butare_,
   {{0xd2bb61bf,0x1dfb603b,0xa386903f,0xd2484011}},	//   _komente_, _komentet_, _starp_, _hemma_,
   {{0x427e7054,0xd59a7007,0x52a6c074,0x8f58430c}},	//   _hinne_, _abawọle_, _lambar_, _propieda,
   {{0x0a30313b,0x4069415b,0x63ea01e7,0x7df8e0cd}},	//   _的所有文字_, _kampioen, _imite_, _उन्मूलन_,
   {{0x82d4d0fb,0xf28ad021,0x8bd8a0b7,0xc0c7c13c}},	//   _memohon_, _мінет_, _транснис, _физике_,
   {{0x524bf1cc,0x0e5f404d,0xbc56a034,0xb6e0f13b}},	//   _कुठेही_, _この記事へのトラ, _partire_, _多种方式看新闻_,
   {{0xdc6090fa,0x6295e247,0xf3958394,0x5c50c19b}},	// [cc0] _nnyumba_, _abukari_, _darse_, _زنگنه_,
   {{0xc2710024,0x569641ea,0x536641ea,0xeb0951df}},	//   _deputatl, _spremeni, _spremenj, _colporte,
   {{0x52f91017,0x0354a1d4,0x3395c069,0xb2249055}},	//   _потребно_, _podemos_, _huvsi_, _shaki_,
   {{0x6c36e037,0x33eb019e,0x884371bb,0x00000000}},	//   _تعامل_, _amatur_, _portalas_, --,
   {{0x42d9710c,0x00000000,0x00000000,0x00000000}},	//   _ghaelg_, --, --, --,
   {{0xa204104d,0xf224c116,0x81260018,0x32a6d044}},	//   _住所又は居所_, _aadka_, _ניצחון_, _probas_,
   {{0xc6d111ff,0x439660a4,0xa3ced156,0x037b3205}},	//   _probleem_, _persen_, _čovek_, _papaano_,
   {{0x6944b18d,0x968d82be,0xf344a21b,0x63415034}},	//   _herunder_, _परवाह_, _wetende_, _potenza_,
   {{0x63f47395,0xb20111be,0xf3806087,0xca46f0b7}},	//   _postao_, _lezie_, _olursa_, _алеӂеря_,
   {{0xd31690ca,0xd9858066,0x52da60b9,0xa71fb149}},	//   _praze_, _टाईम्स_, _morele_, _pěstován,
   {{0x6b2b70ad,0x326d81df,0x11120396,0x52bb7068}},	//   _komandas, _inyoka_, _družina_, _komende_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x0dfae118,0x06aa4008,0xa4864108,0x726de01a}},	//   _осъществ, _פסיכומטר, _सुधारे_, _antoi_,
   {{0x047c00d3,0xb24891df,0x89a68106,0xa39540f8}},	//   _cartlann_, _kwami_, _прусия_, _tresna_,
   {{0x9c7170de,0x73ce611d,0x3647009f,0xe213f155}},	//   _डाक्टर_, _znova_, _verklari, _ahuhu_,
   {{0xff460076,0xb7a2e0ea,0xcaeb8164,0x666440de}},	//   _zakresie_, _테마스토리_, _bestemme, _viljandi,
   {{0x1fa2206e,0x625bf1be,0x876c309d,0x67e1f099}},	// [cd0] _iṣowo_, _obula_, _wyjątkow, _pripremi,
   {{0x1f15f22c,0x02a740ac,0x6313d047,0x00000000}},	//   _sledovan, _məclisin_, _saibhir_, --,
   {{0xdd3bd0a4,0x6ef1a201,0x00000000,0x00000000}},	//   _व्यक्तीच, _marketin, --, --,
   {{0xbfeb40ca,0x62cbf0bf,0x826d80a0,0xf187a004}},	//   _विभाजित_, _abuda_, _sirol_, _אָנערקענ,
   {{0xd2027154,0x5202600e,0x4d4710ea,0xeb2120cb}},	//   _aprili_, _kiriko_, _전문가서비스_, _keretébe,
   {{0xee8f6347,0x92d4630a,0x5e7cb0de,0x739401e3}},	//   _promijen, _perdre_, _बाक्स_, _uyise_,
   {{0x82d8c149,0xeb6310f5,0x901a1031,0x7307f277}},	//   _leden_, _doreamon_, _服务已开通_, _endaði_,
   {{0x2df02070,0xa95a6100,0x053150a2,0xab41d13a}},	//   _ونڈوز_, _намаганн, _pročitat, _katoličk,
   {{0x7ae52342,0x00000000,0x00000000,0x00000000}},	//   _कृष्णदेव_, --, --, --,
   {{0xe280b1a6,0x728c111c,0xa772c13c,0xb15b7068}},	//   _diskuse_, _آلوما_, _свега_, _originel,
   {{0x52bb6015,0xb4b2600f,0xa22ac100,0x9c2a5034}},	//   _somente_, _पिंडी_, _богам_, _compless,
   {{0x02484070,0x16992117,0xb2e860c4,0x00000000}},	//   _semmi_, _профилак, _sofinka_, --,
   {{0x51f62035,0xf3a2e09f,0x12d8a124,0xa27f41c6}},	//   _टोमॅटो_, _egipte_, _hebel_, _agensi_,
   {{0x8292402d,0x5ee86031,0xd84a12da,0xcb614065}},	//   _datang_, _城乡规划法_, _горка_, _جلابيات_,
   {{0xb8475397,0x525ae0f8,0x027f5190,0xb26c705e}},	//   _duplicad, _mailan_, _sienas_, _manok_,
   {{0x8e3251b2,0xa31960eb,0xdb1fc208,0x00000000}},	//   _amelikas_, _христово, _ammannan_, --,
   {{0xa2d8c20d,0x217da004,0x563ce1b2,0x425a90b5}},	// [ce0] _neden_, _פיגור_, _arianism_, _obaly_,
   {{0x327f502f,0x85ee3003,0xd2f450a2,0x1d85b00f}},	//   _vienas_, _landslið, _zapošlja, _बायोग्रा,
   {{0x727ff153,0x12e560cb,0x22f22003,0xe48d50ea}},	//   _found_, _اعتکاف_, _ákveðið_, _인테리어소품_,
   {{0x7b7340e4,0x352f41e1,0x4fdb60ea,0x00000000}},	//   _अप्रकाशि, _disposto_, _소비자보호에_, --,
   {{0xc2cae06e,0x52009133,0xc20260aa,0x2e0bc0da}},	//   _dandan_, _amais_, _suriye_, _खरोखरच_,
   {{0xe290a177,0x6032f02e,0xc3567387,0x5f943021}},	//   _alban_, _nastaven, _acceder_, _плоская_,
   {{0x9386e113,0x52ea7241,0x620090a0,0x9292703f}},	//   _leiria_, _poginuo_, _blaid_, _atrast_,
   {{0x23f8512c,0x9db141ee,0xbc7f5233,0x7096919b}},	//   _celui_, _lenguaje_, _versão_, _پاشایی_,
   {{0x37158004,0x1e761004,0x5a15d100,0xb3172018}},	//   _שושנת_, _מספריהם_, _куплена_, _planning_,
   {{0x9e1bc202,0xa9dbc089,0x737fd055,0x00000000}},	//   _pregunta, _pregunte, _kulanka_, --,
   {{0x3c604024,0x6c723018,0x12d772d7,0x9201b0ae}},	//   _abdulla_, _stories_, _autopro_, _diviem_,
   {{0xf2f50190,0x7200a04b,0x627ed2d7,0x527940fe}},	//   _pavisam_, _ambit_, _mieng_, _নীড়পাতা_,
   {{0x97f27144,0xd3bab11c,0x696ca2c0,0x1e84302a}},	//   _možnosť_, _هرمزگان_, _eilimint, _власне_,
   {{0xa96c50c3,0xb9d8f099,0xeefbd13c,0xf7414018}},	//   _societat, _izložba_, _ствари_, _ואביזרים_,
   {{0xe3877081,0x3d94a0cb,0x5c61614f,0x00000000}},	//   _starta_, _keresett_, _matunda_, --,
   {{0x2b4c220d,0x926c205e,0xd27f8022,0xd26c1119}},	//   _numarası_, _takot_, _borno_, _kahor_,
   {{0xf27f711a,0x269b2062,0x5759f143,0x00000000}},	// [cf0] _chanje_, _активне_, _भिक्षुक_, --,
   {{0x96823092,0xd342a047,0x02926037,0xf7b5b0b3}},	//   _decembri, _inneall_, _marang_, _najstari,
   {{0xb3eb8221,0x22eef21b,0x906cf031,0x47e3d02c}},	//   _karty_, _phantsi_, _第三十四条_, _универса,
   {{0xf6c3a0ad,0x7a03a042,0x2402e106,0xbc433239}},	//   _portalı_, _paralyze, _стема_, _netwerk_,
   {{0x422ab0c6,0x73eb71dd,0x53f870f6,0x926e7347}},	//   _někdo_, _esaten_, _menua_, _europi_,
   {{0xbd81506a,0x5395f02c,0x0c76c054,0x00000000}},	//   _hallotta, _kuusi_, _नृत्यं_, --,
   {{0x42009134,0xa32090bf,0x4abca017,0x37cbf0da}},	//   _plaid_, _alaye_, _министар_, _लोकमान्य_,
   {{0xf27f5061,0xf3169052,0x02d8c1ea,0x026c3039}},	//   _dienos_, _ngazo_, _teden_, _lajos_,
   {{0x80e64025,0x83052037,0xdf6900cd,0xf202619b}},	//   _आईबीएन_, _mataram_, _लाभदायक_, _jaring_,
   {{0x22fc700c,0x2200b08c,0xe2d8c0f7,0x185d907f}},	//   _hangi_, _addini_, _reden_, _минерале_,
   {{0x5fc39153,0x6dd6e01a,0xe26dc2c6,0x9aaa72a5}},	//   _register_, _perjanta, _nivou_, _מדרבנן_,
   {{0x1807c070,0x3248003e,0xe2fce0dc,0x00000000}},	//   _لکھتے_, _heimi_, _mungon_, --,
   {{0x72fc705d,0x43fec21f,0xe2905091,0x083e101a}},	//   _mangi_, _kwalifik, _allai_, _диски_,
   {{0x62fc709c,0x22fce089,0x9f0711eb,0xd681612c}},	//   _langi_, _origen_, _маразм_, _calendri,
   {{0xeb6cb0c3,0x18674303,0x1f128190,0x63ced092}},	//   _министру_, _solicitu, _organizā, _slovan_,
   {{0x529262c3,0x22027141,0x7c5370c9,0xbc115090}},	//   _barang_, _masing_, _sastava_, _sarandë_,
   {{0xa3b75017,0x93f8f090,0x00000000,0x00000000}},	// [d00] _zatvora_, _punuar_, --, --,
   {{0x126c9250,0xfd2c911a,0xcaa9c2be,0x616c90b5}},	//   _aktiviti_, _aktivite_, _रामलीला_, _aktivity_,
   {{0xd2cf9144,0x127ed069,0x42c4a018,0x00000000}},	//   _kancelár, _xieng_, _england_, --,
   {{0xf27ed1b2,0x13035043,0x5fb3d07f,0x3c6ba070}},	//   _vieng_, _nyablab_, _антилеӂи, _magukat_,
   {{0xb290703c,0x420b004b,0xad6bb1d3,0x08fd7035}},	//   _ponad_, _emphysem, _प्रभुजी_, _urbanind,
   {{0xae72223c,0x02027147,0x00000000,0x00000000}},	//   _तुच्छ_, _kasing_, --, --,
   {{0xd2dd2122,0x00000000,0x00000000,0x00000000}},	//   _katerimi_, --, --, --,
   {{0xac74d34e,0xe3869153,0xa19d9117,0x4c34d173}},	//   _minutos_, _start_, _наиболее_, _цяпер_,
   {{0xb200d0b9,0xb27e7108,0x92d8f045,0x0386007e}},	//   _klein_, _sinna_, _legen_, _asire_,
   {{0x3373c01f,0x33294082,0xbc3a30b4,0xf3f47091}},	//   _nekustam, _запропон, _elaborac, _ofsted_,
   {{0xb3ce612b,0xbc7380b3,0x72ab10f2,0x05b8c2de}},	//   _znovu_, _emisija_, _kandang_, _bankovní,
   {{0xe27e718b,0x5adb80e6,0x32cae091,0xc354a171}},	//   _vinna_, _bestimmt, _ganddo_, _modelos_,
   {{0x0386b1db,0x0b7aa19f,0x32a781d8,0xabdd6049}},	//   _sucre_, _uğrunda_, _verby_, _दतिया_,
   {{0xd27ed0f5,0x828d7074,0x087fb073,0xeee82117}},	//   _tieng_, _turkiya_, _शब्दयोग_, _метров_,
   {{0xa35e9063,0x678530ca,0xb122d276,0x00000000}},	//   _trafiki_, _आह्वान_, _مدافع_, --,
   {{0x3292605e,0x925ca11c,0x87e60398,0xb27ed15d}},	//   _parang_, _اتوبوس_, _अनार्य_, _rieng_,
   {{0x03646025,0x10d7709d,0xaf7ab041,0xde85816b}},	// [d10] _ग्रैंड_, _motocykl, _upozorně, _दिव्यदृष,
   {{0x9386d1f5,0xe38691d7,0x972c2399,0xe4edf03c}},	//   _ngeri_, _fuara_, _responsá, _मध्या_,
   {{0xc25b417a,0x52db9071,0xcdf2c1eb,0xe2ab1147}},	//   _quello_, _контакту, _джорджа_, _bandang_,
   {{0xe394e055,0x12cfd062,0x326de1e7,0x00000000}},	//   _amisom_, _takodje_, _ditou_, --,
   {{0xd39580aa,0x21332092,0x9386d1cf,0x510a801a}},	//   _varsa_, _kvalitné_, _quero_, _означает_,
   {{0x4c9e12d0,0xf2fe4044,0x93f472b1,0xcf57417b}},	//   _תוויות_, _motivos_, _postel_, _damascen,
   {{0x52ff514b,0x1d8761ab,0x00000000,0x00000000}},	//   _verilir_, _inserire_, --, --,
   {{0xc3a8a2c3,0x4c55b13d,0x3ecba19d,0x00000000}},	//   _sekarang_, _afstand_, _menyampa, --,
   {{0x753a9024,0xfd027089,0xa290e0e6,0x3eb04276}},	//   _agentliy, _qualitat_, _hinaus_, _البلاغه_,
   {{0xe2f041a9,0xd349e00a,0x0a9040c5,0x62d66210}},	//   _poliisi_, _diretti_, _poliisin_, _redovno_,
   {{0x831691e2,0xbd687004,0x7e1882d8,0x09aac179}},	//   _arazo_, _דערזען_, _posetila, _логин_,
   {{0xbf71f037,0x92d8c122,0xf83e5065,0x037a0074}},	//   _perancis_, _telesa_, _القحطاني_, _jiragen_,
   {{0x5dc6d19b,0xc238202c,0x22fc31b1,0x00000000}},	//   _ناوبری_, _блондинк, _ualicas_, --,
   {{0x23ead0d3,0x32927102,0xeb31919b,0x00000000}},	//   _contae_, _pasang_, _سمینار_, --,
   {{0x2956006a,0x00000000,0x00000000,0x00000000}},	//   _ٹورنامنٹ_, --, --, --,
   {{0x527f501e,0xddbd50bd,0x1c5592d7,0x8e974279}},	//   _tienes_, _kapasite_, _wattpad_, _systemet_,
   {{0x4b0cc03d,0xe7d0c0a4,0x23f45068,0x5263c11d}},	// [d20] _友達に紹介_, _lingkung, _zitten_, _evropski_,
   {{0xceee0175,0xc94890cd,0x00000000,0x00000000}},	//   _компании, _जालस्थल_, --, --,
   {{0x325620e7,0x0e46b271,0x00000000,0x00000000}},	//   _становни, _modalida, --, --,
   {{0xe2e3d2aa,0x22d85076,0x8b50502c,0xc26e11ea}},	//   _lehrbuch_, _celem_, _postissa_, _kuponi_,
   {{0xa2cae0e6,0x039461e3,0x27937054,0x5e643019}},	//   _findet_, _nkosi_, _kultuuri, _públicam,
   {{0x129040b9,0xbe67f173,0x37e5503e,0xdb0270a0}},	//   _almal_, _шахматы_, _samstarf, _lawrlwyt,
   {{0x375fa143,0xac51c16f,0x82d8c27f,0x02fcc2b4}},	//   _विद्याक_, _spotova_, _selesa_, _blogue_,
   {{0x90c7603d,0xd27ee055,0xf20180b9,0xd26c514e}},	//   _一覧を見る_, _diinta_, _berig_, _halos_,
   {{0xb3f45077,0x637b71b3,0xb26c435d,0x9aeb7008}},	//   _sitten_, _intacto_, _vamos_, _instrume,
   {{0x3b0410cc,0x2a8bb081,0xbbb79070,0xeed741a3}},	//   _נאכאמאל_, _trenings, _کیلنڈر_, _delikatn,
   {{0x6fe940de,0x826fa1e3,0x9aec00f8,0xd073907e}},	//   _संचालित_, _amaningi_, _kolektib, _sweatsho,
   {{0x73169015,0xc2fe6171,0x2b6841b7,0x069d30ea}},	//   _prazo_, _visitas_, _palestin_, _해피선데이_,
   {{0x6291b086,0x52d85070,0x7234a060,0xfda74141}},	//   _ndwara_, _velem_, _ajumose_, _kelihata,
   {{0x83946086,0x73f86058,0x53234134,0xfb8fe213}},	//   _cyose_, _gwoup_, _mercher_, _glengarr,
   {{0xded080b2,0x78d4b132,0xcba9300c,0x00000000}},	//   _cuối_, _انحطاط_, _markalar, --,
   {{0x1ae6316a,0xffdfb008,0x5a1b4080,0x00000000}},	//   _यद्यपि_, _מצאתי_, _absolútn, --,
   {{0xec09b11d,0x12d84232,0x32b58268,0x726c5042}},	// [d30] _podpora_, _demek_, _barco_, _balos_,
   {{0x827e3053,0x932070aa,0x00000000,0x00000000}},	//   _bijna_, _konya_, --, --,
   {{0xe387e32e,0x5eb7b126,0x068a115e,0x993320cb}},	//   _petru_, _البلاغ_, _akadēmij, _شافعی_,
   {{0x211b511c,0xcaea700c,0x5a28d19b,0x86b120cd}},	//   _سرپرست_, _destekle, _نتايج_, _डकैती_,
   {{0x73946245,0xbb593136,0x05793136,0xb3b31017}},	//   _byose_, _iskustva_, _iskustvo_, _културни_,
   {{0xcc66d387,0xc395807a,0x52d4600c,0x2a6c303e}},	//   _centros_, _garso_, _birden_, _heimilis,
   {{0x3200e158,0x0387b213,0x59c62018,0x00000000}},	//   _abiiko_, _lawrie_, _ריאליטי_, --,
   {{0x9150a076,0x3291f064,0x77b0a076,0x4395f1a7}},	//   _podstawo, _aduan_, _podstawi, _hause_,
   {{0xf2d850c4,0xc26c3089,0x7c741004,0xe6b84076}},	//   _celej_, _rajoy_, _באריכטן_, _raportuj_,
   {{0xce741004,0x0d1a024d,0x2b15808b,0x00000000}},	//   _חנוכּה_, _cudromac, _bielizeň_, --,
   {{0x2e4c4113,0xa386023f,0xbc70d1b9,0xffc8b05c}},	//   _haaaaaaa, _daire_, _हेक्टर_, _समलैंगिक_,
   {{0x426cd08e,0x2bebe386,0x4b97706a,0x83f4712e}},	//   _pomoč_, _komentir, _ماہرین_, _dostal_,
   {{0xc38601cb,0x0dd40008,0x7c74a13b,0x7d2601e6}},	//   _faire_, _האשכול_, _查看评论信息_, _редакції_,
   {{0xbc47c215,0xf20030a2,0xa6e7c062,0xb2e7c1b8}},	//   _разгон_, _kojim_, _разлог_, _разное_,
   {{0x129101f5,0x1ff4709d,0x527f6089,0x00000000}},	//   _embala_, _ब्राजील_, _signes_, --,
   {{0xa248d065,0x05c7711d,0xbc1d7140,0x03878090}},	//   _seomra_, _oblačila_, _doprinos, _kurre_,
   {{0x8c068219,0x7f6ea0b2,0xa696207b,0x309320fe}},	// [d40] _dopravy_, _giềng_, _বরগুনা_, _শিমুল_,
   {{0x9fd99036,0x00000000,0x00000000,0x00000000}},	//   _принтира, --, --, --,
   {{0x62f20144,0xd8a3c218,0x03eb818e,0x00000000}},	//   _nasleduj, _команду_, _payton_, --,
   {{0x137c6044,0x1b78e189,0x77a612d7,0xa2d4d060}},	//   _alcalde_, _berusaha_, _vietgiai, _aimokan_,
   {{0x71773100,0x6e075208,0x32b69050,0x8291b0bd}},	//   _белта_, _meadhana, _планирањ, _lavant_,
   {{0x02f7631a,0x0f24c0da,0x00000000,0x00000000}},	//   _menikah_, _जवळजवळ_, --, --,
   {{0xdd66c0e7,0x231c70fe,0x7743d01a,0x92e9f07a}},	//   _критику_, _বলিউড_, _новинки_, _француза,
   {{0xa9dff0cb,0x2a37607b,0xa40dc065,0xa2497122}},	//   _augusztu, _চালিয়ে_, _الضحك_, _znamke_,
   {{0x2f45d2a4,0x12980018,0x227e91ab,0x83c410fe}},	//   _najljepš, _הגירסה_, _siano_, _ব্যতিক্র,
   {{0x154d8080,0xe27f8316,0xc54e0035,0xd23660a2}},	//   _prevádzk, _biznes_, _कुठेतरी_, _broja_,
   {{0xe33c4020,0xd30ca05e,0x35ab007b,0x4d11d037}},	//   _사람들에게_, _madalas_, _উন্মুক্ত_, _اخراج_,
   {{0x9c2c801a,0xb290e163,0xdf16213b,0x00000000}},	//   _полицейс, _sinaju_, _买卖通档案_, --,
   {{0x62a6c16d,0xa7bc51f8,0x42ee6134,0xb5059008}},	//   _tomboy_, _forretni, _economi_, _טורבו_,
   {{0xa36bb070,0xffd952ac,0xad76319b,0x3ffa4291}},	//   _بھرپور_, _dostatoč, _هرچند_, _बिरादरी_,
   {{0x22ab1185,0x5e62d1ee,0x322591c0,0x627ec055}},	//   _bandung_, _descarga, _pasko_, _cidna_,
   {{0xdccda175,0xd08e1330,0x35fa7031,0x8290a0d3}},	//   _читатели_, _פוסקים_, _劳动和社会保障部_, _tobac_,
   {{0x42f62133,0xd378b051,0x3af3604f,0x82da7008}},	// [d50] _briseadh_, _kokarin_, _consulte, _direct_,
   {{0x027f50a3,0xbb4fd2d1,0xacf97030,0x2b541008}},	//   _dienas_, _premijer, _अभिमानी_, _הרישוי_,
   {{0x7cc1712f,0x69a69031,0x62ad3071,0xa26cc1df}},	//   _اليدوية_, _尊重网上道德_, _сигур_, _kolose_,
   {{0xe27e71e0,0xd380108e,0x4c9250d5,0xbf69b24b}},	//   _rinne_, _naprej_, _संभोग_, _nezavisn,
   {{0x7291225b,0xe8c6305a,0xf98110cb,0xf27ec39a}},	//   _olyan_, _abaturag, _مرتکب_, _endnu_,
   {{0xa2005105,0x5248510a,0xea5d212f,0x7d30a06e}},	//   _illik_, _helmi_, _tapúla_, _akinyele_,
   {{0xad8911ea,0x82bbd0b9,0x2c6e112f,0x00000000}},	//   _primerja, _geheime_, _buartha_, --,
   {{0x56410193,0x834520cb,0x727f91e8,0xc200c1dd}},	//   _zanimlji, _mindent_, _bosni_, _polita_,
   {{0x27fea031,0xb2c4a18d,0x742cf39b,0x3f128190}},	//   _的所有作品_, _normalt_, _बीरबल_, _organizē,
   {{0x62d811bf,0xcbb47144,0xe35152f5,0xaf5891b8}},	//   _behet_, _reagovať_, _हथेली_, _проголос,
   {{0x71fa303d,0x5f640013,0x43f9603b,0x5248f19b}},	//   _詳細はこちら_, _belastin, _sigurt_, _dekorasi_,
   {{0x87e0205c,0xe2e880b5,0x2c610189,0x00000000}},	//   _फेवरेट_, _podniku_, _berusia_, --,
   {{0xe2cad070,0xd366a037,0xb3340018,0x2f0ef222}},	//   _mindig_, _tunggal_, _באריאל_, _chạnh_,
   {{0x923171df,0x00000000,0x00000000,0x00000000}},	//   _thumela_, --, --, --,
   {{0xbb2dc19b,0xac5322be,0x2cec41eb,0x529261e8}},	//   _tambahan_, _पैकेज_, _колыбель, _zgrade_,
   {{0x9f3f4088,0x0eb45190,0xe034506a,0x85a1d035}},	//   _kristiya, _receptes_, _receptek_, _सरबते_,
   {{0xc5a8c24b,0xa20030a2,0x2af4c239,0x0386b0c3}},	// [d60] _preporuk, _kojih_, _hieronde, _andrei_,
   {{0x23860247,0x52f7407b,0xa354a008,0xe38691e2}},	//   _oriri_, _কখনোই_, _effects_, _ugari_,
   {{0xc39460d3,0xbc6a21c0,0x81123191,0x02a83276}},	//   _phost_, _darrell_, _pravdepo, _متوقف_,
   {{0x327ed03f,0x251650da,0xbb8e5018,0x27a351bc}},	//   _piena_, _शब्दात_, _אסיאתיות_, _внатрешн,
   {{0xd2eb406e,0x1fb230ef,0xcac03017,0x6e1b6074}},	//   _mahidol_, _مدفون_, _обично_, _danganta,
   {{0x927ed100,0xdf6ea048,0x31c37097,0x62b64007}},	//   _viena_, _kiểng_, _nastavak_, _adadale_,
   {{0x92fc909c,0xb2cae0d3,0x127f00e9,0x00000000}},	//   _mbaga_, _maidin_, _standi_, --,
   {{0x3f0ef37b,0x0aaf30ea,0xec78228c,0xa34ce025}},	//   _thạnh_, _정상적으로_, _persoal_, _साइंस_,
   {{0xb074703d,0xf3dc9110,0xe2fc61a9,0xa2b6735d}},	//   _redaktio, _obawa_, _mbogo_, _marcas_,
   {{0x561ee27b,0xd2905055,0x88d63004,0xbccc0037}},	//   _njengesi, _kulankii_, _סבֿיבֿה_, _ایلنا_,
   {{0x4290716e,0xe8d0517c,0xb22590de,0x126cc03a}},	//   _ionad_, _पश्चात_, _raske_, _colore_,
   {{0x1840d047,0xd3eb7119,0xc26d8070,0xcf162061}},	//   _بخصوص_, _haatan_, _piros_, _застой_,
   {{0x9225918c,0x42fdf10c,0x13b0a037,0xaa34104d}},	//   _paske_, _diugh_, _القاعده_, _マンション_,
   {{0x62bf0039,0xda77006c,0xf0f6f175,0x32805076}},	//   _اموات_, _adegbola_, _единство_, _brakuje_,
   {{0xa5ee2341,0x53f8c00b,0x7f20e0b5,0x4e3941c9}},	//   _condició, _solusi_, _zateplen, _esportes_,
   {{0xeb3690a9,0xf290206e,0xc7e7e23c,0x3582f10d}},	//   _isključi, _lokan_, _सिगरेट_, _प्रदेशाध,
   {{0x6d8ac194,0xf761c117,0x7564212f,0x130761a2}},	// [d70] _ввести_, _вверх_, _thiomáin, _tembang_,
   {{0xc395410b,0x5d0ea056,0x1b6390c6,0x8c001018}},	//   _miesto_, _otroligt_, _एकजना_, _שמישהו_,
   {{0x68645034,0xe8d96020,0x7fe801a3,0xf3f470e8}},	//   _универси, _해외부동산_, _विचारों_, _listan_,
   {{0x226d9173,0x727ee117,0x17556122,0xc2d8f17e}},	//   _visos_, _toinen_, _učinkovi, _legea_,
   {{0x427e7054,0xada6c1af,0x6d1ae0fe,0x00000000}},	//   _linna_, _планинат, _মালয়েশিয়, --,
   {{0x880800e0,0xdeab9011,0xe5187118,0x1e390165}},	//   _dabqhuas_, _rekommen, _картинка, _separata,
   {{0x0201c247,0x5349f099,0x12bf1065,0x69bc81d5}},	//   _devid_, _spremni_, _دمياط_, _apịnye_,
   {{0x4dbe113f,0x8e327185,0x5e7c109d,0x2d1c10b7}},	//   _hdvietna, _kualitas_, _मौर्य_, _алфел_,
   {{0xf7cba318,0xb27e00bc,0xc84740d7,0x86d21025}},	//   _skupštin, _niini_, _captures_, _श॑शित_,
   {{0x02cae053,0x1d8970f1,0x4df4202a,0xab9cc249}},	//   _zonder_, _seumpama, _екскурсі, _lantmäte,
   {{0x937b01df,0x527862b7,0x00000000,0x00000000}},	//   _intando_, _ubunge_, --, --,
   {{0x91456008,0xdeb56280,0xf26da0db,0xe62d8160}},	//   _especial, _especies_, _tipos_, _sainchei,
   {{0x601f30a7,0x4a59802b,0x731110b7,0xfd0760ea}},	//   _najboljš, _nereikia_, _абсолв_, _쇼음악중심_,
   {{0xf24750da,0x93169044,0xf310509d,0xe27e7081}},	//   _जंगलं_, _praza_, _pracuje_, _finna_,
   {{0x79da8047,0x9e41e142,0xb80a200d,0xfffa2143}},	//   _upalenia_, _garantit_, _electrog, _elektroo,
   {{0x92efc0c7,0xe2005041,0x3291407a,0x3e1070b2}},	//   _familja_, _kolik_, _vidaus_, _trắng_,
   {{0x7c7cd215,0xdbddd39c,0x6200106c,0x8fae1175}},	// [d80] _вылет_, _बतिया_, _rohin_, _новогоди,
   {{0x026c80d4,0x21862082,0x92cae15a,0x9236908b}},	//   _iskola_, _економік, _sonder_, _traja_,
   {{0xd3177037,0x82a64055,0xa3b26033,0x33074276}},	//   _penyanyi_, _dambe_, _marque_, _dilatih_,
   {{0xc5a1016e,0x904511ca,0xcc01c033,0xa2904074}},	//   _الاضحى_, _estudyan, _laisser_, _komai_,
   {{0x320270bb,0x83ac1126,0xc8c84005,0x63a82025}},	//   _assise_, _éppen_, _flutning, _युटिलिटी,
   {{0x3696712c,0xf5628020,0x223660a2,0x137920a4}},	//   _accessoi, _때문입니다_, _broju_, _lebaran_,
   {{0xd2558144,0x63ea009c,0x00000000,0x00000000}},	//   _problémo, _emiti_, --, --,
   {{0xa386d0c2,0x63869063,0x8d99d1aa,0x00000000}},	//   _storia_, _agaru_, _победила_, --,
   {{0xcc5c507b,0x93ee0036,0x31695077,0xceb0a0db}},	//   _তীব্র_, _dettagli_, _itsensä_, _diversas_,
   {{0xe68b8041,0x8eb0e07e,0x2864e056,0x00000000}},	//   _kancelář_, _tolerans_, _reinfeld, --,
   {{0x5378512f,0x7c1410fc,0xe202618e,0x72cea35e}},	//   _مواليد_, _segurtas, _purine_, _utrolig_,
   {{0xa716704d,0x727ed100,0x720050c6,0xdb6de0ea}},	//   _固定リンク_, _vieno_, _tolik_, _우리나라의_,
   {{0xf9624239,0x23ead047,0x2248d020,0x9fc3d1fd}},	//   _retourne, _moltar_, _neemt_, _подарки_,
   {{0x9a063031,0xb3f8222b,0xee472324,0x8cf2831b}},	//   _下一篇文章_, _tekur_, _localida, _bridgend_,
   {{0x9f52b0a9,0xc9503016,0x7b803346,0x7c5bf070}},	//   _držač_, _negociat, _negociac, _tartani_,
   {{0x0f2c11a7,0x298ec071,0x62e8e1fc,0x0379e1a3}},	//   _allerdin, _паник_, _polisin_, _telewizj,
   {{0x72902078,0x39c6e049,0x5fec6092,0x00000000}},	// [d90] _tokan_, _कराची_, _dobrovoľ, --,
   {{0x127ed100,0xf9aa1057,0x030c3147,0x3a34304d}},	//   _pieno_, _mendakwa_, _malakas_, _ミッション_,
   {{0xd25ad078,0x02490091,0x1290407e,0xe26cc061}},	//   _emele_, _dramor_, _moman_, _mados_,
   {{0x346520d4,0xab03f020,0x13171267,0xff3a200c}},	//   _referenz, _일반적으로_, _buzzi_, _profilin,
   {{0xe34981da,0xa2d8a23f,0x9863c034,0xd290a12f}},	//   _aspetti_, _bebek_, _покажи_, _albam_,
   {{0x1290909f,0x826cc01f,0x45f20153,0x9c3430cb}},	//   _plaas_, _gados_, _permissi, _آرڈیننس_,
   {{0xc24981b5,0xd3860208,0x4c5fc148,0x52a3528c}},	//   _terma_, _nairn_, _systeem_, _procedem,
   {{0xe2d980a4,0xb83e1017,0x279310c3,0xa5879070}},	//   _keren_, _битка_, _софией_, _horoszkó,
   {{0x1200403e,0x9507d0ea,0x12843174,0xf29040f9}},	//   _komin_, _helemaal_, _archivo_, _koman_,
   {{0x1e70f0ca,0x1055c0ae,0x72d980e6,0xf6c4104d}},	//   _चित्त_, _sagatavo, _deren_, _おすすめ度_,
   {{0x526cc1a2,0xa2004051,0xb195c100,0x5b27d069}},	//   _dados_, _domin_, _членам_, _nawbbbbb,
   {{0x2386d122,0x284b003d,0xc290013f,0xc386d1e2}},	//   _skoraj_, _sommerhu, _uniad_, _ageri_,
   {{0xd587702e,0x13a2c13b,0x21703054,0xce41f0f8}},	//   _autorský, _propre_, _एहीसे_, _zalantza,
   {{0x137b0175,0x1655d045,0x62ceb170,0x0225f100}},	//   _citando_, _рейтингу_, _moravčík_, _lauko_,
   {{0x4589e18c,0xff39e098,0xd3f84037,0x6a7de163}},	//   _televizy, _televizn, _semut_, _oprašta_,
   {{0xe26ce18f,0xf30c20b9,0x52d980ca,0x62840004}},	//   _manoma_, _onlangs_, _beren_, _קאנגרעס_,
   {{0xf2d991c6,0xbebcf2c0,0xaaf52134,0x0200d12c}},	// [da0] _lesen_, _chosaint_, _astudiae, _plein_,
   {{0xd27ed036,0x398b40eb,0xc2251252,0x82e3021c}},	//   _viene_, _uveče_, _saakay_, _delivre_,
   {{0x92d840d7,0x13043088,0xf0b4c19b,0x0f81800f}},	//   _temes_, _marahil_, _انیشتین_, _मक्की_,
   {{0xd962739d,0xb27ed1ae,0xcc00b1b2,0xf2489205}},	//   _व्यवस्था, _tiene_, _ameskas_, _itama_,
   {{0x727e0114,0xc04ec0b7,0x00000000,0x00000000}},	//   _china_, _афлэрий_, --, --,
   {{0x8557d13c,0xf2d84190,0x626d10b5,0xe04b518c}},	//   _приказ_, _zemes_, _sobotu_, _reprezan,
   {{0x917fe11c,0x026e70c9,0xe0e8f192,0x2b1c727d}},	//   _روشهای_, _parovi_, _oprindel, _označené_,
   {{0x2b95724e,0xc8eed065,0x00000000,0x00000000}},	//   _sevindir, _تصحيح_, --, --,
   {{0xa3782047,0x9200c013,0xb290d24d,0x659941b8}},	//   _بينما_, _nodig_, _solais_, _настроен,
   {{0x8c18e0c2,0x92d980aa,0xcf393025,0xe2d8c144}},	//   _caratter, _veren_, _बेटियों_, _sedem_,
   {{0x7d89402a,0x12005051,0x03a2906c,0x12d99190}},	//   _харчуван, _kolin_, _adapa_, _nesen_,
   {{0xd601312f,0x298a819f,0xbdb1809e,0x5646a0ea}},	//   _هندسة_, _müraciət_, _intambwe_, _터치스크린에_,
   {{0x6d44f25a,0x7c17d045,0xd68b20fc,0x4f07110b}},	//   _अतिरिक्त_, _правил_, _lizentzi, _dispozíc,
   {{0x72d981cd,0x0c536125,0xee351248,0xaeb0b178}},	//   _prendre_, _मैसेज_, _millones_, _dissabte_,
   {{0x034980d4,0xe2c4a12f,0x3394612e,0x92d89177}},	//   _esperti_, _aisling_, _akosi_, _afael_,
   {{0x62cad26d,0xd6920073,0x927e01df,0x9a8fc1c5}},	//   _mindre_, _statysty, _thina_, _demikian_,
   {{0x0d6f31cb,0x99e93043,0xd27f010c,0x604d10b5}},	// [db0] _commenta, _mainidea_, _chanas_, _mikrovln,
   {{0x541bc194,0xa872c2ad,0x98e2c130,0x633d1098}},	//   _скільки_, _могући_, _могуће_, _dolarů_,
   {{0xb2a6d256,0x00000000,0x00000000,0x00000000}},	//   _greba_, --, --, --,
   {{0x53f462d4,0x7af3c136,0x5273c136,0x511b519b}},	//   _portal_, _napravit, _napravil, _پرسرعت_,
   {{0x0386e18f,0xdddc3065,0x4498e1d6,0x00000000}},	//   _afirka_, _الضوء_, _databeez, --,
   {{0x77e2719f,0x04d1a03c,0xf16671ab,0x348190ec}},	//   _respubli, _प्रतापगढ, _футболис, _नानाजी_,
   {{0x8ecf91a4,0x53dcb006,0x42903050,0x650551cf}},	//   _socijaln, _kosmetyk, _lojas_, _enquanto_,
   {{0x13ead071,0x826de061,0xfb2f80c3,0x6527a117}},	//   _dintre_, _kitos_, _историче_, _кажется_,
   {{0x926c8230,0xb236707e,0x00000000,0x00000000}},	//   _uskoro_, _danje_, --, --,
   {{0x2256f290,0x5a93c175,0xe3f8d008,0x82d8526d}},	//   _मानेला_, _можеби_, _groups_, _deler_,
   {{0xb24890f1,0x8ed5b078,0xf2bb81aa,0xd344b05a}},	//   _utama_, _merindin, _nedelje_, _murenge_,
   {{0x03f8c0a9,0x33bdc163,0x8d6000cb,0x79a5e27d}},	//   _odluka_, _drevnih_, _قادیانی_, _široký_,
   {{0x0378830b,0x5bdd907b,0x5c28c12f,0x8c77a1c4}},	//   _kenalan_, _ব্যথা_, _سيدنا_, _versand_,
   {{0x33167245,0x32d991b4,0x22d8d1e1,0x724a7087}},	//   _hanze_, _pesen_, _idiomas_, _vermek_,
   {{0xbe2bd32b,0xdb99007c,0xae416082,0x5823119b}},	//   _बर्बादी_, _заплатит, _relativt_, _رطوبت_,
   {{0xe68c70ca,0x92905165,0x16e8b017,0xb201403e}},	//   _बिहान_, _allat_, _карактер, _fleira_,
   {{0x84d770cc,0x011090b5,0x026de03f,0x038770e9}},	// [dc0] _ענציקלאפ, _techniky_, _citos_, _starfa_,
   {{0x031d72cd,0xa869515e,0xcb822034,0x75eda190}},	//   _percuma_, _procedūr, _късно_, _personām_,
   {{0x0da2b04b,0xb2902051,0x9e8381d6,0xa386b13f}},	//   _terraced_, _dokar_, _akawanye_, _androi_,
   {{0x03a63118,0xf163319b,0x341910c3,0xecd3b07a}},	//   _хиляди_, _بامزه_, _престижи, _сценах_,
   {{0x626da18a,0x7d22e175,0x32f23017,0xc9fb6039}},	//   _navigasi_, _pagsegur, _letovanj, _ellentét,
   {{0x275fa0cd,0x0a6b4221,0xbc242070,0x12b2e046}},	//   _विख्यात_, _domény_, _کروڑوں_, _atodlen_,
   {{0x0ea740dc,0xf366a05e,0x5615e187,0x00000000}},	//   _mysliman, _hinggil_, _balorazi, --,
   {{0xb23600f7,0x946e2031,0xf122d0a9,0x6347f002}},	//   _prijs_, _国家税务总局关于, _privatno, _venemaa_,
   {{0x47e760a4,0x6f39720b,0x023f706a,0x23a20060}},	//   _स्वरूप_, _terutama, _kalkulát, _adipo_,
   {{0x227e9340,0x3264710b,0x17f33002,0xd2fe62bc}},	//   _khang_, _poslal_, _त्रिशंकु_, _morgon_,
   {{0x7c48139e,0x4507b017,0x62d9f09f,0x8af9f013}},	//   _अधिनियम_, _кредита_, _dienste_, _diensten_,
   {{0xb200b0a2,0xd2979008,0x40ebb21b,0xce07d045}},	//   _jedini_, _התקנת_, _olunabil, _символи_,
   {{0x72fcc020,0xc200d035,0x42a69245,0x31e9b013}},	//   _hoogte_, _miliar_, _asaba_, _assortim,
   {{0xd27ea0a2,0xa118f031,0x6c89b192,0x5e721167}},	//   _jednog_, _您的汇款已收到_, _samtidig_, _वृद्ध_,
   {{0x1642f03d,0xacb7b14d,0xe0944031,0x02907003}},	//   _最近の記事一覧_, _границу_, _互联网上网服务营, _konan_,
   {{0x42d9602d,0xc386d008,0xa34fb20e,0xed8fb217}},	//   _segera_, _sports_, _kraftig_, _kraftigt_,
   {{0xfb77a021,0x10e0c117,0xdc6270a9,0xd3877175}},	// [dd0] _органы_, _снова_, _preuzeo_, _quarta_,
   {{0xa905a1dd,0x631d9004,0xa394e120,0x00000000}},	//   _eztabaid, _פינחס_, _consum_, --,
   {{0x6c499045,0xc39491d6,0x99d070f8,0xd2f040a1}},	//   _ремонту_, _akasi_, _telebist, _malinzi_,
   {{0x22005136,0xa2d8c140,0xa7bbe050,0xaa33e13b}},	//   _molim_, _jelena_, _останати, _请作者在两周内速,
   {{0x34652142,0x09c52153,0x83076037,0x1ff761a2}},	//   _internaz, _internat, _kembang_, _بازسازی_,
   {{0x127b42ac,0x7290522b,0x9200503e,0x727ed100}},	//   _komentár, _allar_, _allir_, _diena_,
   {{0x41fe1153,0x3ece1033,0x626da070,0x50fc303c}},	//   _environm, _environn, _napot_, _szerokoś,
   {{0xeb369099,0x038710cc,0xd278617f,0x3044b02c}},	//   _zaključa, _נייַעס_, _mbunge_, _вконтакт,
   {{0xc2d87089,0x6fe3d070,0x4a1470a1,0x7a6bc179}},	//   _gener_, _لاپتہ_, _okwagala_, _свежие_,
   {{0xee2c81cc,0x33ac6090,0x4d0b20aa,0xd2005134}},	//   _pengemba, _trupin_, _metrekar, _ellir_,
   {{0x72eaa1d7,0xf2fcd038,0x61ef712b,0x315da120}},	//   _daniell_, _mbegu_, _brigády_, _actuacio,
   {{0x9032005d,0x00000000,0x00000000,0x00000000}},	//   _abatagen, --, --, --,
   {{0xfbf38120,0x441311af,0x72e21108,0x752980b9}},	//   _celebrac, _посета_, _valitud_, _koninkry,
   {{0x6320a09d,0xf20041c4,0x7329e232,0x00000000}},	//   _podczas_, _somit_, _psikoloj, --,
   {{0x927b4032,0xc2904133,0x72018069,0xf29260f8}},	//   _comentár, _comas_, _hnyiab_, _estatu_,
   {{0xd2caf12e,0x2646e060,0x369512dd,0x1c3e31af}},	//   _pridal_, _ṣàtúnṣe_, _oddeleni, _затворен_,
   {{0xf32062a9,0x630d21fc,0xd2011099,0xbd15302a}},	// [de0] _aloys_, _balalar_, _odbili_, _футболу_,
   {{0x2d0931fd,0x28a92282,0x00000000,0x00000000}},	//   _конце_, _stratégi, --, --,
   {{0xfae30002,0xd897112f,0xb48821a3,0x9319a25b}},	//   _postimee, _قريبا_, _gwarancj, _nemcsak_,
   {{0x72d870a4,0x0055c148,0xcd8bd204,0x44dbe229}},	//   _bener_, _verantwo, _nogometa, _останови,
   {{0x1eb0909e,0x420181be,0x00abe02c,0x00000000}},	//   _umurenge_, _deziri_, _станции_, --,
   {{0x5eac21c0,0x79e6f01a,0x1f26f01a,0x1c00309e}},	//   _cysteine_, _harrastu, _harrasta, _uhagarar,
   {{0xe3dd80a0,0x323f902e,0xf9d9e055,0x514c0018}},	//   _glywed_, _čokoládo, _muslimka_, _והצפון_,
   {{0x92d87248,0xedb6e208,0x6716c0a4,0x6fc35143}},	//   _tener_, _barrachd_, _गर्दी_, _horoskoo,
   {{0xe9ec51e2,0x82ba81f8,0x82ea702c,0x4b5530ac}},	//   _donostia_, _kodeord_, _entinen_, _normalar,
   {{0x9aaee353,0x23f8a061,0x525b00de,0x260260c2}},	//   _forvente, _nebus_, _avalik_, _bellissi,
   {{0x5378a19e,0xb9ae015e,0x2248f0c3,0x00000000}},	//   _bekalan_, _privātum, _primar_, --,
   {{0x0395f074,0xb27ed01a,0xaa0ff031,0xde3980a4}},	//   _hausa_, _pieni_, _没收违法所得_, _penasara,
   {{0xc24990b3,0x3395f03f,0xe26d1144,0x00000000}},	//   _pesme_, _kausa_, _bazos_, --,
   {{0xe24830d4,0xf929411c,0x127ed100,0x3c891017}},	//   _nemmen_, _آلومینیو, _vieni_, _различит,
   {{0x89a7907b,0x7739c1db,0x1f33e05a,0x00000000}},	//   _বগুড়া_, _esportiv, _akarenga, --,
   {{0xd29051b5,0xf27ed0d4,0xda1620c9,0x615e0005}},	//   _solat_, _tieni_, _zadataka_, _morgunbl,
   {{0x3c694098,0xc2904183,0x92b961be,0x45c81045}},	// [df0] _kultury_, _tomar_, _adreesị_, _благодій,
   {{0x03860158,0xe2d85048,0x02eca1df,0xc2a6004b}},	//   _naira_, _telex_, _korinte_, _naiba_,
   {{0xa73350b5,0x9a3240fe,0xa20200c2,0x00000000}},	//   _absolvov, _ভিজিটর_, _capire_, --,
   {{0x7c6bc103,0x00000000,0x00000000,0x00000000}},	//   _चित्रण_, --, --, --,
   {{0x17b3b0de,0x92a6012a,0x827e61e3,0xd409e263}},	//   _प्रधानम्_, _kaiba_, _izono_, _बाबासाहे,
   {{0x7a7f0020,0xd387519b,0x3d06029d,0xb6b6d00f}},	//   _입주가능일_, _باردار_, _aparecer, _कठौती_,
   {{0x925b739f,0xa7f951ab,0xc290c1a3,0xc5103116}},	//   _maalin_, _протести, _podaj_, _boosaaso_,
   {{0xc5a7907b,0xabdd339c,0x52da70b9,0x5373a0a2}},	//   _ভৌগলিক_, _बढ़िया_, _bereik_, _domaće_,
   {{0xcfc23070,0xf2d9c008,0x8c07b190,0x13c581ab}},	//   _ناموں_, _level_, _personu_, _турнира_,
   {{0x9481c0de,0x4a3de1b9,0xb27e7143,0xd27b40b5}},	//   _बाबाजी_, _मज्जा_, _kinni_, _momentál,
   {{0x739fc047,0xa1c531a3,0x9c76402d,0x627ef03e}},	//   _إصدار_, _sklepach_, _ditulis_, _erindi_,
   {{0x7c1ad0de,0xd27e7005,0xf2ba7147,0xb373c09e}},	//   _चुनौती_, _minni_, _sandali_, _ruhande_,
   {{0x2fc42004,0x1386c174,0x726df346,0xb2009069}},	//   _מנהיגים_, _madre_, _estos_, _hlais_,
   {{0xd2d8c039,0x98fe40ea,0x59e790bf,0x00000000}},	//   _elleni_, _프로그램을_, _adegboye, --,
   {{0x9be9023b,0xc29050d3,0xac868031,0xa248c0b9}},	//   _अमेरिकी_, _solas_, _中签号公布_, _jammer_,
   {{0x2387f2e1,0xd5f87311,0x6c1bf057,0xc1c47018}},	//   _putra_, _रातोरात_, _didaftar, _האנציקלו,
   {{0x03160150,0x5fe510ad,0x13f860bb,0x00000000}},	// [e00] _usizo_, _dostları, _lulug_, --,
   {{0xb25a9099,0xb27ed220,0x329073a0,0xa108c128}},	//   _imala_, _dienu_, _ionas_, _asistenţ,
   {{0x226c10d1,0x46d740d9,0x75b1a008,0xd9620052}},	//   _schon_, _sporočil, _בדואר_, _igenerat,
   {{0x19e53085,0x6248c126,0xd318d057,0xb38780dc}},	//   _resultad, _filmek_, _gemilang_, _burri_,
   {{0x994e8179,0x4318f144,0xf52d5047,0xaf77b0da}},	//   _mielipit, _zavrieť_, _daonlath, _होईपर्यं,
   {{0x4249717f,0x4f16416e,0x527f000e,0x4ad8602c}},	//   _kwamba_, _راسلنا_, _erangi_, _основной_,
   {{0xe491607b,0x6e2fa173,0x7be3319b,0xd02e0046}},	//   _এন্ড্রয়, _autorius_, _دامپزشکی_, _arbenigo,
   {{0xf2bf6087,0x9386a19b,0x26213025,0xb200f08b}},	//   _yardım_, _پایدار_, _logowani, _meniny_,
   {{0x2e726389,0xb59bd3a1,0x0312b00c,0x428c8013}},	//   _इंद्र_, _dibutuhk, _serbest_, _klikken_,
   {{0x6200a136,0xe3436273,0xc27ed01f,0xc2836070}},	//   _dobio_, _livello_, _ikonas_, _miskolc_,
   {{0x9f1161ef,0x325a9074,0x1b1e506f,0xe1316271}},	//   _contrata, _amala_, _понеделн, _contrato,
   {{0xf329c0ea,0x972e40e8,0x92eb1061,0x674cc170}},	//   _개인정보관리책임, _exklusiv, _turizmo_, _poziadav,
   {{0xb2909068,0x427f0034,0x00000000,0x00000000}},	//   _klaar_, _grandi_, --, --,
   {{0xa2d9e24f,0xc8de5036,0x15d2f070,0x700a00eb}},	//   _veten_, _приказки_, _újdonság, _викимеди,
   {{0x826d10ab,0xb2d9e0ea,0x72ca015e,0x3ace2025}},	//   _escola_, _weten_, _veida_, _चेयरमैन_,
   {{0x9394d090,0xd2da6008,0x15c1a105,0x82011214}},	//   _pjese_, _thread_, _sevirəm_, _dozie_,
   {{0xa27ed148,0xf6b8d100,0x73f40217,0x6274319b}},	// [e10] _dient_, _разраста, _testar_, _توسلی_,
   {{0xd27ed15f,0x2c7d6175,0x8d0210ea,0x00000000}},	//   _vienu_, _последна, _알고싶어요_, --,
   {{0x3290a119,0xffc7902f,0x9c6a1229,0x12fca154}},	//   _toban_, _ранняя_, _helmikuu_, _harakati_,
   {{0x84a44080,0xa1b99008,0xb290710c,0xe355a047}},	//   _neobmedz, _מחלקת_, _annad_, _referer_,
   {{0x62d8b202,0x03559221,0xcc13f017,0x6b9cf2b2}},	//   _veces_, _plastové_, _културно_, _nyandiko_,
   {{0xe5183021,0x45a08035,0x00000000,0x00000000}},	//   _славянск, _वाढते_, --, --,
   {{0x1d3f604e,0xf3f8805d,0x32cae037,0x3200a122}},	//   _juridice_, _kukuwa_, _gandum_, _dobil_,
   {{0xa37960a2,0xac5bf007,0x127ef143,0x00000000}},	//   _pitanja_, _abuteni_, _prindi_, --,
   {{0x03f87134,0xae96a153,0x42732117,0xc136a098}},	//   _munud_, _students_, _tänne_, _studenty_,
   {{0x3734003d,0xea8ff0b3,0xa2927208,0x029190f5}},	//   _お役立ち度_, _odličan_, _parant_, _sosad_,
   {{0x23167074,0xd200c1fd,0x4290722b,0x00bfc0cf}},	//   _manzo_, _kodin_, _konar_, _elementl,
   {{0xf86d2047,0xb386d0d2,0x00000000,0x00000000}},	//   _scriosad, _ouers_, --, --,
   {{0xd29070b4,0x427eb192,0xdf571215,0xe2d80018}},	//   _donar_, _odense_, _merginos_, _tried_,
   {{0x9290b018,0x87c74278,0xba07412e,0x29459039}},	//   _local_, _pripravi, _pripravu, _pillanat,
   {{0x489fa045,0xf4b111e3,0x3c1da2d0,0x925ad104}},	//   _компанії_, _umnyango_, _משכון_, _amele_,
   {{0x6cfa61aa,0x2ff1f1d0,0x96cec00c,0x441d21e2}},	//   _придружи, _adúláwò_, _bulabili, _horietak,
   {{0x2386906e,0xbe466271,0xc7bde0ae,0x4d4e5154}},	// [e20] _taara_, _finalida, _patiesīb, _taratibu_,
   {{0xa200c333,0xf26e1044,0x927e901a,0x8290c055}},	//   _hodin_, _época_, _ihana_, _hodan_,
   {{0x975be06b,0xd3648190,0xd29072c0,0x00000000}},	//   _मुस्कान_, _atkritum, _sonas_, --,
   {{0x126e61dd,0xf54a9036,0x0c637147,0x020131ca}},	//   _kirola_, _обстанов, _patungo_, _moxie_,
   {{0x5b611037,0xb3ead015,0x7c75f349,0xea38013b}},	//   _kesenian_, _voltar_, _मुक्तक_, _国家邮政局_,
   {{0x425b0154,0xa2014061,0xb2ca0215,0x00000000}},	//   _maalum_, _sveiki_, _leido_, --,
   {{0x02cf810b,0x22499035,0xc3c08070,0x52cbb031}},	//   _podobne_, _resmi_, _رینجرز_, _对最佳答案的评论_,
   {{0x8a06d031,0x9378d00c,0x020261da,0x00000000}},	//   _上一篇文章_, _tamamen_, _ferita_, --,
   {{0x2396602b,0xd290311d,0xd3b26044,0xa2d8c1c4}},	//   _verslo_, _pomaga_, _parque_, _jeder_,
   {{0x0eae11ac,0x69dc4048,0x8983d0c3,0x92907054}},	//   _syarikat_, _bikervie, _модерне_, _annab_,
   {{0x438770b3,0x9c193092,0x3292600d,0x526cd05d}},	//   _udario_, _polovicu_, _batatu_, _abanyazi_,
   {{0x72d801ee,0x66e9704d,0x1b94d025,0x201230cb}},	//   _quien_, _プレゼント_, _wrzesień_, _سپاہی_,
   {{0x1eead11c,0xff53d293,0x0eee704d,0x80fa1076}},	//   _خسروی_, _домашно_, _すべて表示_, _amerykań,
   {{0x6038525d,0xf08ae02b,0xb347b264,0x409e804d}},	//   _vestmann, _psicholo, _madeira_, _ポイント獲得_,
   {{0x1b7bf028,0xbc56b1f6,0x1b962107,0x92c6b1e8}},	//   _bangunan_, _postove_, _научни_, _poslove_,
   {{0xe93f3077,0xb5ef3077,0xcf8f3077,0xb2df306a}},	//   _kommentt, _kommenti, _kommento, _kommentj,
   {{0x4503d126,0x9397408f,0xc9f74056,0x96c7402a}},	// [e30] _خارجہ_, _samarbej, _samarbet, _samarbei,
   {{0x127e0177,0x146f4037,0x93f9e0bb,0xf202603b}},	//   _maint_, _استعداد_, _metub_, _burime_,
   {{0xb9f2b011,0x13860101,0xdfc5c1af,0x00000000}},	//   _startsid, _shiri_, _идеја_, --,
   {{0xb3ea0394,0x847da01a,0x1c6c307f,0x00000000}},	//   _xeito_, _животные_, _forumul_, --,
   {{0x1c6ba09c,0x52ca002f,0x007170bb,0x2adf50d1}},	//   _kitundu_, _veido_, _norapamo, _eintrage,
   {{0x66276086,0x49676086,0x52911099,0x12026061}},	//   _minisiti, _minisite, _mozak_, _turime_,
   {{0x8a9bb316,0x0a0f61f6,0x1e4f6163,0x200610cc}},	//   _jurnalis, _stranica_, _stranice_, _כינעזער_,
   {{0x42012059,0x8035a208,0x731000ef,0x00000000}},	//   _orbitz_, _santayan, _észak_, --,
   {{0x427ef034,0x3ed4e173,0xd2ef803c,0x82f0f0b2}},	//   _quindi_, _socialin, _पदार्थों_, _giaitri_,
   {{0xa9dcc03c,0x12eb01ab,0xd3eae0c3,0x023640a4}},	//   _zabezpie, _diritto_, _suntem_, _namja_,
   {{0x22d7c109,0xb18e50dc,0xdf21000b,0x2290c0d9}},	//   _spiller_, _parasysh_, _kesulita, _dodal_,
   {{0x8290a185,0x00000000,0x00000000,0x00000000}},	//   _sobat_, --, --, --,
   {{0x125a8219,0xf386426c,0xb69872d7,0x00000000}},	//   _okolí_, _kamra_, _careerli, --,
   {{0xe27e62d7,0x8afd803b,0xd2fca0a0,0x636d8190}},	//   _phong_, _intervis, _wariant_, _intervij,
   {{0xda4d4065,0xa41a008b,0xfe1541e4,0x3ed6511d}},	//   _متّصلاً_, _prezeraj, _aigeanna, _jezikovn,
   {{0x02d8f134,0xf201e012,0xc2a64022,0x125ac0f8}},	//   _neges_, _altid_, _lamba_, _nullam_,
   {{0xa7b87073,0x8af870c3,0x2c73a15b,0x83ea30e8}},	// [e40] _regulami, _regulame, _sterker_, _rejta_,
   {{0xb7dab065,0x76bc2065,0x803903a2,0x00000000}},	//   _وعندما_, _لتحميل_, _profesyo, --,
   {{0xcc22f080,0x5aba0062,0x2a5050bf,0x00000000}},	//   _skupiny_, _proverit, _agbède_, --,
   {{0xc067211c,0xc2f3a094,0x526c302c,0x85649190}},	//   _رفسنجانی_, _דרבנן_, _samoin_, _informē_,
   {{0xf378b246,0x7290a2ec,0x52247025,0x740d03a3}},	//   _lokacin_, _dobar_, _rynku_, _francouz,
   {{0xa2a6406e,0xf6cf9206,0x5fe0c0fe,0x0f264002}},	//   _jamba_, _kubadili, _নাজমুল_, _perekonn,
   {{0xa3ea900e,0x5340e2fa,0x72a670f5,0x7b678143}},	//   _amatu_, _ग्रूप_, _banbe_, _अइसने_,
   {{0x42902163,0x78d7d0c3,0x0ac882ad,0xef7f8018}},	//   _nikad_, _низация_, _ресурса_, _נמשכת_,
   {{0x139cc03d,0x62ca00f7,0x55b68194,0xc829419f}},	//   _回答した人_, _beide_, _партії_, _sərbəst_,
   {{0x98bb1225,0x29da51e2,0xf3869055,0xd25ad11d}},	//   _minutter_, _ekologia_, _saaro_, _imela_,
   {{0x51111092,0xb2cb7158,0x51a310c4,0x8cd86203}},	//   _projekty_, _ibadan_, _svadobné_, _служител,
   {{0x12489102,0x49f94098,0xb79da0c2,0x00000000}},	//   _agama_, _externí_, _costruzi, --,
   {{0xb25a00de,0x611700ae,0x8e511084,0x3b764047}},	//   _teile_, _publicēt, _kezalima, _sealadac,
   {{0x7290d1e4,0x031ab13b,0xa2d98232,0x8ff3a0b5}},	//   _sleat_, _按作者搜索_, _yerel_, _netradič,
   {{0x7290a1d7,0x7a899175,0xa26d8098,0x00000000}},	//   _tobar_, _продажба, _parou_, --,
   {{0x32fe618b,0x530da0f9,0x116af090,0x72915075}},	//   _morgun_, _lavalas_, _respekto, _enfawr_,
   {{0xd522703c,0x9387f19c,0x53eb7037,0xc26c6069}},	// [e50] _प्रतिबंध, _suure_, _obatan_, _npoos_,
   {{0x02c36239,0x437a63a4,0xbe29c175,0x00000000}},	//   _stellen_, _zadarmo_, _немало_, --,
   {{0x442b211c,0x4eb3225c,0xdefdd065,0x00000000}},	//   _مسنجر_, _aspectos_, _الشغل_, --,
   {{0x0b88002e,0xaa88310c,0x1290323e,0x7c5af128}},	//   _nemocnic, _schottis, _anjal_, _alaturi_,
   {{0x7207926b,0x2386d216,0x51434065,0xd3f821b7}},	//   _רעננה_, _esere_, _لمعرفة_, _rukun_,
   {{0xa321a1c0,0xe477a02c,0x00000000,0x00000000}},	//   _kopya_, _проекте_, --, --,
   {{0xe2362194,0x62a69070,0x00000000,0x00000000}},	//   _mykje_, _csaba_, --, --,
   {{0xc3ea01c4,0xf290f0a2,0x0290c061,0x203c5017}},	//   _seite_, _mogao_, _kodas_, _користећ,
   {{0x725a012f,0xe3a2906c,0x326de1c0,0x0a577128}},	//   _peile_, _adapo_, _batok_, _biserica_,
   {{0xc3fc5039,0xa4f8f081,0x2d43a1af,0xa9ff0286}},	//   _aktuális_, _наступни, _можност_, _poznania_,
   {{0x9c80c061,0xc2025327,0xbd19f098,0x53f4618d}},	//   _немец_, _fotiek_, _dekorace_, _hurtig_,
   {{0x42025199,0x4200c134,0x7749119b,0x904da17f}},	//   _notiek_, _nodir_, _صبحانه_, _matumain,
   {{0x3f12e03d,0x00000000,0x00000000,0x00000000}},	//   _studeren, --, --, --,
   {{0x13ea5199,0x5c76c102,0x6e9a607c,0x98acd04d}},	//   _zelta_, _operasi_, _силиконо, _最新の日記_,
   {{0x225ad1d5,0x12cae10f,0x926df3a5,0x129030d4}},	//   _emeli_, _hendak_, _estou_, _armati_,
   {{0x931320d2,0x5060400f,0x00000000,0x00000000}},	//   _probeer_, _kristiin, --, --,
   {{0xc291c0a9,0xceb860b9,0xbe2d902b,0x03966366}},	// [e60] _novac_, _januarie_, _японец_, _turska_,
   {{0x435e2042,0x3ccdb0c5,0xa5c07133,0x00000000}},	//   _lungsod_, _последне, _ionadail_, --,
   {{0x9342c28c,0x22d9a090,0xc2447065,0xef21c1db}},	//   _facendo_, _jepet_, _grafaicí_, _millorar_,
   {{0x9290c175,0xc2d8e0d1,0x237a0009,0x00000000}},	//   _todas_, _offen_, _seratan_, --,
   {{0x0ee2900b,0xb4e8b062,0xf027a0cc,0x73f400a4}},	//   _महत्त्वा, _планиран, _נעבעך_, _justru_,
   {{0xbea150d4,0xafe89025,0x526da06a,0x92d920c3}},	//   _fallimen, _हज़ारों_, _napos_, _printre_,
   {{0x123a2122,0x8104807b,0xf35f5025,0x00000000}},	//   _primeru_, _কাছাকাছি_, _kolejny_, --,
   {{0xd290f0b9,0x22025304,0xcb9c2160,0x53544056}},	//   _nogal_, _imtina_, _digiteac, _arbetet_,
   {{0xf3ac50bd,0xd2d8113f,0xd3ea53a6,0xadbf3102}},	//   _souple_, _nghen_, _velta_, _semangat_,
   {{0xc25a5134,0x770d3173,0x7ae6707b,0xb2c551df}},	//   _wella_, _жанры_, _ঈদগাঁও_, _ingelosi_,
   {{0xa1deb0fd,0x706d6045,0xe2d8f1d9,0xd3eae089}},	//   _понеділо, _kompetan, _spielt_, _contes_,
   {{0x8eb6c0c5,0xa27e900d,0x5d33b26d,0x52d8f116}},	//   _профиль_, _azana_, _menneske_, _laheyd_,
   {{0x52bf11a2,0x90edb01a,0x00000000,0x00000000}},	//   _املاک_, _monipuol, --, --,
   {{0x024a71db,0xe98d9094,0xc943a02f,0x5792f19b}},	//   _formes_, _וישלח_, _ансамбле, _اصحابی_,
   {{0x824a71c2,0xf2d94190,0xd200b0a7,0x1b5a718f}},	//   _normes_, _rudens_, _nuditi_, _dandalin_,
   {{0xd38b825b,0xa2787047,0x29d080a0,0xb7951374}},	//   _három_, _karnar_, _ieithydd, _testberi,
   {{0x6201507e,0x93ce91ad,0x9741e0e7,0x92ee905d}},	// [e70] _defini_, _chave_, _основне_, _abanaki_,
   {{0xcc3960a4,0x7290c24e,0xcbc7d045,0x7ea49222}},	//   _प्रयत्न_, _onlara_, _продажу_, _giftcode_,
   {{0xcdbc1008,0x1316605d,0x23eb0002,0xe52fa203}},	//   _בלייזר_, _akoze_, _alates_, _prossimo_,
   {{0x8e8a50de,0x33eb40b7,0xe31741c0,0x00984004}},	//   _विपत्ति_, _pretul_, _namatay_, _אטמאספער,
   {{0x29edc18e,0xe20cb0a2,0x4c0811cd,0x4316700d}},	//   _disulfid, _uživo_, _fourniss, _manza_,
   {{0xc42cf00f,0x43f831a1,0xa43c60fe,0x32d9821e}},	//   _मेंबर_, _sujud_, _হানিফ_, _cerek_,
   {{0xd2fce19e,0xc8f4502a,0x12d86134,0x9e35e05e}},	//   _tangan_, _телефонн, _droed_, _karaniwa,
   {{0x13ea003e,0x8f3503a7,0x66b500ac,0xd2ca0269}},	//   _leita_, _reportar_, _reportaj_, _leida_,
   {{0x83a2226b,0x183ce04d,0x839520b2,0x6e7d51cc}},	//   _simple_, _産学官連携リンク, _đcsvn_, _मिक्स_,
   {{0x6637a142,0xd274126b,0x3367a153,0x62feb0ad}},	//   _programm_, _כניקראו_, _program_, _intihar_,
   {{0xd3bbc047,0x234a1075,0x4c7eb065,0xcfcd1126}},	//   _فستان_, _telerau_, _taistil_, _المعز_,
   {{0xaae5113b,0x366ff16f,0x00000000,0x00000000}},	//   _由工商行政管理部, _voljenom_, --, --,
   {{0x7c50c12f,0xc3a23064,0xe25a501a,0xb26da297}},	//   _عندنا_, _tempoh_, _kello_, _tapos_,
   {{0x12e3d0bd,0x727c1062,0x037c81f5,0x4bfbe034}},	//   _avantaj_, _играч_, _kitaawe_, _dimentic,
   {{0x86bc6143,0x625a003e,0xe27f7346,0x42c94208}},	//   _सत्तर_, _deila_, _blanco_, _tulloch_,
   {{0x527e006e,0x93874024,0xfdbf90c4,0x60d1f04e}},	//   _laini_, _enerji_, _rajecké_, _instituţ,
   {{0xd15c7039,0xa3ea03a8,0xa96740f8,0x00000000}},	// [e80] _speciáli, _feita_, _kalitate, --,
   {{0x32a6212c,0x215c7096,0x6c6e8055,0x92d8c0e2}},	//   _membre_, _speciáln, _hiiraan_, _kuleta_,
   {{0xd653d302,0x6d0cd02f,0x125bf0de,0xa2d83056}},	//   _उपाधि_, _выйду_, _लिमिटेशन_, _numera_,
   {{0x49d0d165,0xbf980004,0x9a9f10e7,0x5e9e30e6}},	//   _interatt, _צענזור_, _адресе_, _gestellt_,
   {{0xbf2a7134,0xb2c8a16f,0x00000000,0x00000000}},	//   _dystiola, _oproste_, --, --,
   {{0xa290500c,0xe26ce159,0x22c9f02e,0x92e021e3}},	//   _kolay_, _abiola_, _nakonec_, _efanayo_,
   {{0x826c9099,0xf4806166,0xb3869247,0x02901179}},	//   _školi_, _ब्राउन_, _maara_, _onhan_,
   {{0x6c7c8031,0xb236d122,0x42486326,0x00000000}},	//   _贴子相关图片_, _svojem_, _drome_, --,
   {{0x34d663a9,0x437fd119,0x2fb40041,0x82d8e031}},	//   _देखिये_, _dalalka_, _říjen_, _effet_,
   {{0x53869155,0x63ea9373,0x7afa7143,0x21c7919a}},	//   _gaara_, _imati_, _tingimus, _фидель_,
   {{0x82480245,0x00000000,0x00000000,0x00000000}},	//   _arimo_, --, --, --,
   {{0xb290002c,0x7386c310,0x0dda9122,0x13ce70ab}},	//   _liian_, _cadre_, _soglašat, _canvi_,
   {{0xb7b860f7,0xe3ea7019,0xa2ca7175,0xd387f1b8}},	//   _natuurli, _venta_, _venda_, _suuri_,
   {{0x92d83109,0x6e38207f,0x2290e133,0x80d33017}},	//   _igjen_, _localita, _winans_, _гласи_,
   {{0x468333aa,0x82d80048,0x6a6e0105,0x5413d017}},	//   _विशाल_, _trien_, _fotosess, _повезао_,
   {{0x015b108e,0xcafb1144,0x52c51002,0x60778004}},	//   _podrobno, _podrobne, _milline_, _מערבֿ_,
   {{0xf3f87087,0x42f76170,0x1428d17f,0xa201b1a0}},	// [e90] _bunun_, _pezinok_, _jumatano_, _rivier_,
   {{0x4cfde077,0x30a621af,0x4ab04111,0x030d4025}},	//   _последни, _ексклузи, _tradiční_, _posiadaj,
   {{0xf4e0211c,0xe9b8426c,0x00000000,0x00000000}},	//   _بلامانع_, _tendenza_, --, --,
   {{0xb27fe0a2,0x9c1720b2,0x148db122,0xd36570bc}},	//   _bitno_, _catphcm_, _kirurgij, _virgina_,
   {{0xcecf70c8,0x553cb170,0x00000000,0x00000000}},	//   _sociální, _polyfunk, --, --,
   {{0x026ca219,0x00000000,0x00000000,0x00000000}},	//   _školy_, --, --, --,
   {{0x9b8ac082,0xf2ca00de,0xfdc0e2c1,0x4970e381}},	//   _зобов_, _veidi_, _policaja, _policajt,
   {{0xc2916100,0x54d743ab,0x4fb8c021,0x49d0c02c}},	//   _negali_, _मामिला_, _збоку_, _tekemist,
   {{0x127ed033,0x9f03b0a4,0x00000000,0x00000000}},	//   _liens_, _निर्मिती_, --, --,
   {{0x13004122,0xee994092,0x03f45075,0x6873c3ac}},	//   _članki_, _uvítací_, _gutted_, _anonymou,
   {{0x8484117c,0x53f86119,0xdd18318e,0x56f6832f}},	//   _आँखामा_, _kulul_, _glasswar, _राजवंश_,
   {{0x724800c2,0x99b160e6,0xa3a20024,0x227ea23e}},	//   _primo_, _mindeste, _klipi_, _lajnah_,
   {{0xeeee719a,0xe2001179,0x526dc07a,0x268d73ad}},	//   _dezvolta, _mihin_, _kavos_, _बिकास_,
   {{0x1b58421f,0x1299618a,0x973e1068,0x72d990b9}},	//   _sentenza_, _paragraf_, _volledig, _resep_,
   {{0x23ea0086,0x5f9f816a,0x1809b13b,0x00000000}},	//   _ifite_, _रक्तदान_, _查看该公司所有供, --,
   {{0x495be21e,0x7b4150d5,0x13957038,0x1200e1da}},	//   _znanstve, _रामगोपाल_, _ghasia_, _muniti_,
   {{0x80b0906a,0x6ab9004d,0xc27ed12c,0x53ea9054}},	// [ea0] _digitáli, _陽気なギャングが, _vient_, _teata_,
   {{0x32362218,0x7a9d61b2,0x62d8c068,0x23f47182}},	//   _ikkje_, _albigens, _kamers_, _listum_,
   {{0xcae5d03c,0xa25a51cb,0x2303010f,0xdc1e1120}},	//   _उद्यान_, _belle_, _pelawat_, _comptes_,
   {{0xecd73037,0x910ff04d,0x03874068,0x00000000}},	//   _اعمال_, _個人情報保護方針_, _overal_, --,
   {{0xf20090a2,0xc26e6133,0xe84fd0a0,0xf895d207}},	//   _kojima_, _baroda_, _etholiad, _странств,
   {{0xbc7f217a,0x1ee320e4,0xc3f90061,0x0668f036}},	//   _possono_, _निष्प्रा, _nebuvo_, _присъств,
   {{0x62fcf16e,0x4d9d61fd,0xb386605a,0xed8c7278}},	//   _éigin_, _sunnunta, _akora_, _točke_,
   {{0x47853066,0x927ed1a0,0x87f851be,0x00000000}},	//   _आस्वाद_, _diens_, _chawapụt, --,
   {{0x2265d034,0xe78881eb,0x249df04d,0x19b732c1}},	//   _агенция_, _калейдос, _ルディングス_, _studenat,
   {{0xd0b0902e,0x92003250,0xa3f8d0b9,0x2b6bf233}},	//   _digitáln, _enjin_, _steun_, _gostaria_,
   {{0x87ffb108,0x568a51dd,0xf4b5c1bf,0x7a3cd1eb}},	//   _ब्रह्मान, _federazi, _parashik, _чужое_,
   {{0xb2e310aa,0xd2e962f9,0xb315a069,0x32cae0b9}},	//   _halinde_, _kariera_, _pebcaug_, _wandel_,
   {{0xd2003063,0x429071d7,0x9f486153,0x57b6510a}},	//   _injin_, _annam_, _response_, _seseteng,
   {{0x26b52351,0x851e20ea,0x435ef033,0xb25b2033}},	//   _milanovi, _수령일로부터_, _recevez_, _inclus_,
   {{0x34297099,0xf43b204d,0x3d897140,0x00000000}},	//   _opravdao_, _ルマガジン_, _školovan, --,
   {{0x82c3e341,0xaad0301f,0x00000000,0x00000000}},	//   _gallego_, _konkursā_, --, --,
   {{0xda55e1e8,0x818230da,0xecfed1f5,0xec0ed00e}},	// [eb0] _učenika_, _आचेवर_, _abatakir, _abatakis,
   {{0xc25a5108,0xd98ba03d,0xf3f460e6,0xd394e33d}},	//   _selle_, _ルアドレス_, _wetter_, _meisje_,
   {{0x0c05f1da,0x17a3e041,0x81fa90c9,0xc3169063}},	//   _tessuti_, _निशानहरु_, _trenucim, _ahazi_,
   {{0xce18506c,0x5213400c,0x00000000,0x00000000}},	//   _adódo_, _şehit_, --, --,
   {{0x6a08e0cb,0x1e9ec215,0xf99d2060,0x63ea003e}},	//   _تصنیف_, _файле_, _ọ̀rọ̀_, _neitt_,
   {{0x03f251f8,0xe3ea0184,0xeff0b0f9,0x1f2470a2}},	//   _levering_, _ufite_, _diskisyo, _našeg_,
   {{0xa3866214,0x225e20f8,0xc7a20018,0xab6db197}},	//   _choro_, _kontseil, _וקנבסים_, _kosmetic,
   {{0xb27ed190,0xc7fcc1bb,0x8202618c,0x2c1c229d}},	//   _viens_, _флага_, _dirije_, _realizou_,
   {{0x838781bf,0xdd81203b,0xd378600e,0x876960ca}},	//   _marre_, _publikua, _bagamba_, _राज्यको_,
   {{0xde9a0020,0xe290206e,0x66d871b1,0x838601ec}},	//   _브라우저로_, _nikan_, _ceebtoom_, _ikiri_,
   {{0x113c110b,0xb2ca015e,0xe1987004,0x72595382}},	//   _posledné_, _veidu_, _טײַערע_, _त्रिभुवन_,
   {{0xc27b60f1,0xd3f401d1,0x3b26006e,0xc93c2279}},	//   _persekol, _festes_, _agabageb, _sommerfe,
   {{0xa3ea72f2,0x92d9e24f,0x92d4733d,0x12cad122}},	//   _tento_, _vetem_, _verder_, _prodam_,
   {{0x7640702c,0x02b6b1ad,0x9d3c6265,0xfc5c2054}},	//   _sosiaali, _verdade_, _ब्वॉय_, _बेमेल_,
   {{0x513c11a6,0xc9da803a,0xe25a00fd,0x97af80b7}},	//   _poslední_, _preferit, _heilt_, _апаратул,
   {{0xebe40087,0x09edb087,0xaacb70b6,0xe0b1d1ec}},	//   _videolar, _peygambe, _sommaren_, _amerịka_,
   {{0xf316101f,0xa2ef923e,0xb2a7800c,0xd386c047}},	// [ec0] _nedaudz_, _nisfu_, _darbe_, _madra_,
   {{0xc3958003,0x6394e07f,0xe25a9134,0xbfab3065}},	//   _fyrst_, _exista_, _deall_, _وأنتم_,
   {{0xd3869074,0x5001e0ae,0xd2b4e1ae,0xd2a78123}},	//   _shari_, _fotogrāf, _inicio_, _farbe_,
   {{0x93f8d0dc,0x2ebdd0c3,0x53ca6070,0x0d0b20c3}},	//   _kaluar_, _evenimen, _پوزیشن_, _intrebar,
   {{0xb9d22130,0x689420c4,0x2061208e,0xcd3ea041}},	//   _neregist, _prevodov, _enostavn, _navigace_,
   {{0xdc6f1133,0x0db7407b,0x4813a008,0xc290217f}},	//   _clarion_, _মেহেরপুর_, _קראתי_, _kikao_,
   {{0x92ca720d,0xb29030f9,0x7278603e,0x00000000}},	//   _bende_, _kijan_, _stunda_, --,
   {{0x23869216,0x629191a1,0x43ea7127,0x00000000}},	//   _okara_, _rosak_, _xente_, --,
   {{0x23ea704f,0x93051039,0x727e012f,0x7eb0b0af}},	//   _vente_, _رومان_, _caint_, _težave_,
   {{0xc26de056,0xc75ec149,0x62af0099,0x00000000}},	//   _dator_, _चार्ल्स_, _dosadašn, --,
   {{0x172721a2,0x02a690f4,0x43869063,0x52cb3111}},	//   _عروسی_, _akaba_, _akara_, _mladé_,
   {{0xf20270a4,0x9fd85098,0xabe2e04d,0xbb2a400e}},	//   _berisi_, _odstraně, _が参考になった_, _ababodab,
   {{0xdb0c10cc,0x49d221ff,0x7e96307a,0x8303408d}},	//   _אלימלך_, _geregist, _čempiona, _labantu_,
   {{0xb25a909c,0x00000000,0x00000000,0x00000000}},	//   _kwali_, --, --, --,
   {{0x32fdf2a9,0x030e4246,0x025a50a6,0x00000000}},	//   _mbuga_, _maganar_, _kella_, --,
   {{0x2432b07b,0xd3f470d7,0x53a8e102,0x2a36907b}},	//   _জিনিস_, _instal_, _belakang_, _পিসিতে_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ed0] --, --, --, --,
   {{0x0e7ab03d,0xa7e1a0ea,0x625ad1ea,0x33f9815b}},	//   _チェックリストに, _판매자에게_, _imeli_, _gerus_,
   {{0x829110b4,0x52903138,0x4ceb9018,0x913c1092}},	//   _encara_, _almain_, _להסיר_, _posledná_,
   {{0x33f860bd,0x6e139179,0x00000000,0x00000000}},	//   _atout_, _ollenkaa, --, --,
   {{0x32d98070,0xf27e905d,0x00000000,0x00000000}},	//   _keres_, _asani_, --, --,
   {{0x9fab3041,0x22d9803d,0x00000000,0x00000000}},	//   _nemovito, _jeres_, --, --,
   {{0xc2d980e5,0xa303408d,0xf29020ad,0x124922d7}},	//   _deres_, _nabantu_, _inkar_, _hocmai_,
   {{0x4290c22b,0xeea2f08d,0xb862d078,0x00000000}},	//   _undan_, _uhulumen, _akintund, --,
   {{0xe2004024,0x522900f3,0x00000000,0x00000000}},	//   _kimin_, _размислу, --, --,
   {{0xb290c02c,0x00000000,0x00000000,0x00000000}},	//   _ollaan_, --, --, --,
   {{0x135bd086,0xae5272c1,0x9c6e01d6,0x82ca519e}},	//   _kongera_, _ostavlja, _azaraya_, _felda_,
   {{0x22ca520d,0x23dce084,0xaf72302c,0x2197a008}},	//   _geldi_, _haiwan_, _вокруг_, _לתואר_,
   {{0x52d99183,0x52d9e19e,0x2600e0de,0x626e00b7}},	//   _meses_, _tetek_, _शायदे_, _napoca_,
   {{0x427a12a7,0x730c2264,0x0c22e081,0xe201a0ca}},	//   _karibuni_, _poderá_, _ініціати, _kopii_,
   {{0xf25a514b,0x00000000,0x00000000,0x00000000}},	//   _belli_, --, --, --,
   {{0x02fce06e,0xf85ca26d,0xbc0f81ec,0xe4a940ea}},	//   _gangan_, _detaljer_, _agamnihu_, _통신판매업신고_,
   {{0xe2498153,0x03f98028,0x358b9175,0xa225f1be}},	// [ee0] _terms_, _terus_, _достигну, _akuko_,
   {{0x0c5bf017,0x93b39143,0x82d6f0c4,0x0dff703b}},	//   _ekstovi_, _प्रबुद्ध, _nemohol_, _rezervua,
   {{0xd291820e,0x9cb26007,0x00000000,0x00000000}},	//   _foran_, _alaarẹ_, --, --,
   {{0x0c77b05d,0x00000000,0x00000000,0x00000000}},	//   _abasese_, --, --, --,
   {{0xf27e9039,0x2252f188,0x0cc2d070,0x00eec0a0}},	//   _arany_, _bestyrel, _ہلاکتیں_, _amlinell,
   {{0x627e0380,0x32b201e3,0xf2005037,0xd5b2004d}},	//   _sains_, _abadala_, _lilin_, _詳しくはこちら_,
   {{0x2290e021,0xbd9c60bb,0xc2b670d7,0x0c7fa333}},	//   _šiame_, _ameliska, _mercat_, _tabulky_,
   {{0xfc00b100,0xf4b00064,0x325a906e,0x43f10144}},	//   _miestas_, _diharamk, _adalu_, _poštovné,
   {{0x12d9e1ea,0x738fd11c,0x3d0a307b,0xd98811d9}},	//   _petek_, _senyawa_, _নরসিংদী_, _richtige,
   {{0x938aa005,0x2d3c8175,0x00000000,0x00000000}},	//   _aðrir_, _новинарс, --, --,
   {{0x39f31062,0xa2d991c0,0x0c56a090,0x4f4da2a5}},	//   _инвестит, _beses_, _vertete_, _היברו_,
   {{0xf26e51ab,0xb2d98271,0xbc41f13b,0xc2d8d045}},	//   _motore_, _seres_, _县级以上人民政府, _huden_,
   {{0xa291e153,0x23f8202d,0x32d99082,0xf149f14d}},	//   _total_, _hukum_, _leser_, _цариград,
   {{0x0d1b23ae,0x0c69323d,0x02e8a276,0x23ab10c9}},	//   _गुणवत्ता_, _emprego_, _lukisan_, _upravnog_,
   {{0x64d52129,0x83ea0047,0xf22aa0c6,0x327ed1c4}},	//   _साहित्_, _leith_, _někde_, _abend_,
   {{0xd47511c1,0x1c631175,0x58531175,0x32f0f047}},	//   _अपरिहार्, _assunto_, _assuntos_, _eisiach_,
   {{0x10f3b008,0x86a1f08d,0x00000000,0x00000000}},	// [ef0] _לאהוב_, _amathath, --, --,
   {{0xc2ca703e,0x07bbb008,0xc290e29f,0xdf641018}},	//   _henda_, _לפועל_, _finais_, _וריכוז_,
   {{0x0b57f191,0x72e25035,0x02908077,0x2a0c20b7}},	//   _kultúra_, _जाणीव_, _alkaen_, _raspunsu,
   {{0x6200503b,0x125a927b,0xc9f61070,0x8d46c050}},	//   _cilin_, _kwalo_, _توسیع_, _интервју_,
   {{0xd29070c0,0x965e1017,0x42d9a03b,0x00000000}},	//   _innan_, _фирме_, _neper_, --,
   {{0xcb79d215,0x853170ea,0x818691df,0xf74e70ea}},	//   _легенды_, _불가능합니다_, _nakakhul, _국가보안법_,
   {{0x9ae070c2,0x799ad263,0xd3160184,0xfc394089}},	//   _contenut, _सदस्यनाम_, _myiza_, _inscripc,
   {{0x3e06c0cb,0x429043af,0xa743e0a4,0x000c108f}},	//   _mindenna, _siman_, _नवनिर्मा, _お問い合せ_,
   {{0xf290c1c0,0xaabf2149,0x928c2222,0xcfbda092}},	//   _andam_, _slavnost, _rơixuống_, _poplatko,
   {{0x21f7c0cb,0x347d9253,0xb665e176,0x00000000}},	//   _معترف_, _प्रभा_, _आवासीय_, --,
   {{0x9c645154,0x626470a2,0x93ea71c0,0x57cd00fe}},	//   _wabunge_, _mislio_, _benta_, _চক্রবর্ত,
   {{0xe2d9b0af,0x6837e0ea,0xec2590a1,0x73993069}},	//   _seveda_, _되겠습니다_, _astagfir, _samxusa_,
   {{0x72ca70f6,0x5ed961ee,0x379140d3,0xe13592bc}},	//   _denda_, _noticias_, _صلاحيات_, _sundsval,
   {{0xdd80d0a4,0x57891107,0x00000000,0x00000000}},	//   _माध्यमात, _месото_, --, --,
   {{0x1307d19e,0x79e6f02c,0x00000000,0x00000000}},	//   _sarawak_, _verrattu, --, --,
   {{0x23ead17d,0x73a2c2bc,0x93ea00de,0x00000000}},	//   _groter_, _kompis_, _leiti_, --,
   {{0xdbd83166,0xd2a1a130,0x28533082,0x2e333017}},	// [f00] _श्रीमद्_, _менталит, _площа_, _плоча_,
   {{0x82cad071,0xbfe970ca,0x7b19301a,0xbdbe41c0}},	//   _produs_, _संभावित_, _tamperee, _catalase_,
   {{0xd583a232,0x129dc0cb,0x327e017f,0x9667f02b}},	//   _fenerbah, _مشائخ_, _mbinu_, _pastebėj,
   {{0x90b8711c,0x27e7e0d5,0x850c813b,0x16b92045}},	//   _ماجراجوی, _देखरेख_, _胶南市农业机械管, _системам,
   {{0xf075d0ae,0x068dc12d,0x468c91ed,0x1a6fc3b0}},	//   _materiāl, _निवास_, _बोलाव_, _आर्काइवक_,
   {{0x87de91da,0x121c4212,0xe63b513b,0x8643a004}},	//   _kumpanni, _jowhar_, _小仓优子性感泳装, _סאדאם_,
   {{0x62909116,0xc969b0c5,0xc665a102,0x861830d3}},	//   _inaan_, _ajankoht, _peristiw, _saighdiú,
   {{0x2eb99215,0xd3c75098,0x564b80b3,0x2e55319b}},	//   _анонсы_, _hospodář, _njihovom_, _زودتر_,
   {{0xf28710d3,0x4f39e1b7,0x00000000,0x00000000}},	//   _أفلام_, _memulaka, --, --,
   {{0xc3940268,0x1b60b030,0xafe952f1,0xe9e3f100}},	//   _aviso_, _सोहनी_, _सासाराम_, _валютных_,
   {{0x62905316,0xa2890013,0x23cef0c5,0x03f820a5}},	//   _onlar_, _appartem, _olivat_, _hukuk_,
   {{0xc4c0735c,0x62007047,0xa2d9a090,0x03f8d2cc}},	//   _público_, _inniu_, _teper_, _judul_,
   {{0x324971e4,0x4172127d,0xdd321128,0x00000000}},	//   _agamsa_, _miliardy_, _miliarde_, --,
   {{0x829190a2,0x52b4e119,0x2c52a025,0x06368193}},	//   _posao_, _dhicin_, _ड्रइङ_, _završila_,
   {{0x12da50d4,0x9237e03c,0x82a7f0aa,0x00000000}},	//   _poteri_, _chomika_, _grubu_, --,
   {{0x02b3e264,0x87e7a3b1,0x22918160,0xa2f1f024}},	//   _produto_, _बाथरूम_, _foras_, _tarixli_,
   {{0x5ee9b0cc,0xd27e9088,0xf68ca2af,0x2dbe4114}},	// [f10] _בחדרי_, _ibang_, _प्राय_, _database_,
   {{0x3394f1df,0xe71f1045,0x1386e18f,0x823781b8}},	//   _kristu_, _спортсме, _shirya_, _sarja_,
   {{0x42918183,0x72d370b9,0x53a2d143,0x2394e12f}},	//   _horas_, _jehovah_, _hoopis_, _briste_,
   {{0xf478721b,0x670cd050,0x1e4ef1df,0x00000000}},	//   _lemfundo_, _divergên, _tshabala, --,
   {{0x538690d3,0x1249f09c,0xbc689128,0xa20191b2}},	//   _bharr_, _atuma_, _acordul_, _losis_,
   {{0xd25ad17f,0x0291810c,0xfc93e1cc,0xf6ae3024}},	//   _kweli_, _doras_, _स्कोर_, _britaniy,
   {{0xb3f8f08c,0x5e5a300e,0x00000000,0x00000000}},	//   _bugun_, _ababataa, --, --,
   {{0xc38f1092,0x5b4200d1,0x62d9a1a0,0x00000000}},	//   _obstaráv, _mädchen_, _peper_, --,
   {{0xd756a0cb,0x9291019d,0x00000000,0x00000000}},	//   _طاقتور_, _dibawa_, --, --,
   {{0xa2d820b9,0x47e4814c,0x0aaeb004,0x00000000}},	//   _erken_, _कामरूप_, _דובראַוו, --,
   {{0xd301e07f,0xb501e099,0x12b400c3,0x934a0231}},	//   _detalii_, _protekao_, _adica_, _izmedju_,
   {{0xd200c153,0xc69b1177,0x3448a293,0x00000000}},	//   _india_, _daleithi, _критикув, --,
   {{0x0307e084,0xa2018120,0xa16e5039,0x00000000}},	//   _jugalah_, _morir_, _استفادہ_, --,
   {{0x62d9e190,0xf2030190,0x48b99130,0xf2d801db}},	//   _sezonas_, _automašī, _последњи_, _trieu_,
   {{0x32d9617b,0xb4843176,0xf2fce04a,0xa2ef5177}},	//   _ingeri_, _इजरायल_, _bangun_, _hoffwn_,
   {{0x0feda0cc,0x630b70a7,0x729b72a3,0xad5b7241}},	//   _מסביר_, _najbolj_, _najbolji_, _najbolju_,
   {{0x4cc480e9,0x00000000,0x00000000,0x00000000}},	// [f20] _hamingju_, --, --, --,
   {{0xc2f230a7,0x5fa46153,0x4200710c,0x9fee9096}},	//   _potovanj, _december_, _innis_, _चुनावमा_,
   {{0x69df50b4,0x00000000,0x00000000,0x00000000}},	//   _contingu, --, --, --,
   {{0xbc765201,0xb290713e,0x938071d7,0x1c7610ac}},	//   _results_, _annat_, _thuras_, _fikrini_,
   {{0x2248901b,0x528b612b,0x6200c01a,0xc2fe6051}},	//   _suami_, _pomocí_, _tulisi_, _kabilar_,
   {{0xbae96093,0x41772100,0x89ed9126,0xe362902c}},	//   _gasteboe, _нешта_, _rendelés, _одноврем,
   {{0xfdbc4381,0xfb93b08f,0x1ce40018,0x00000000}},	//   _označte_, _その他のタグ_, _קרמיקה_, --,
   {{0x425a4064,0x1358405d,0x02d9f1fd,0x00000000}},	//   _semlm_, _abagabe_, _etten_, --,
   {{0x42fc0115,0x5278219a,0x82007177,0x92da634c}},	//   _amigo_, _anunţ_, _cinio_, _parede_,
   {{0x5876820d,0x0115a082,0x786cf0b9,0x7df940a4}},	//   _olabilir_, _власност, _minstens_, _अनुमोदन_,
   {{0xf8a1703d,0xf2919202,0xfc26e013,0x24fd9175}},	//   _お気に入り_, _cosas_, _verbeter, _законите_,
   {{0xf874807a,0xa3f8e1e2,0xd27ee0de,0xaefe2018}},	//   _курсах_, _genuen_, _tunnen_, _רוטשילד_,
   {{0x7248d1d5,0x520271d8,0xac09312a,0xe2d80222}},	//   _abụchagh, _musiek_, _lampara_, _triet_,
   {{0xa2d922d7,0x98c7c04d,0x1b479025,0xd5eab20d}},	//   _luyen_, _知恵袋に投稿され, _लिक्खाड़_, _amacıyla_,
   {{0x32ca70f6,0x094e3296,0x835d105e,0x52cad002}},	//   _kendu_, _escolare, _tanging_, _reede_,
   {{0xc8e8a04d,0xdc5a718f,0x4e8f4279,0x62d831b8}},	//   _選択してください_, _tuntubi_, _kommunen, _arjen_,
   {{0xd86a904f,0xaea38077,0x62907153,0x1316d069}},	// [f30] _politiqu, _значител, _final_, _moozoo_,
   {{0x83878171,0x34047020,0x6f40f020,0x6fb971a2}},	//   _carro_, _전체매물정보_, _인도네시아_, _فوتسال_,
   {{0xa3f9e061,0x86cb801a,0xf197c0c5,0x3c9d802c}},	//   _metus_, _samanlai, _наконец_, _последов,
   {{0x6c59e1dd,0xd2d9c0b4,0x72cb018d,0x3b9e1008}},	//   _besteak_, _seves_, _grader_, _קומדיה_,
   {{0xd25ae003,0x22d922d7,0x92d90217,0xa212b09a}},	//   _heilsa_, _duyen_, _arbeta_, _coche_,
   {{0xd9daa2cc,0x2623a043,0x0200b05d,0x830cd091}},	//   _ternyata_, _daimntaw, _endiga_, _anhapus_,
   {{0x426e6178,0x00000000,0x00000000,0x00000000}},	//   _aprova_, --, --, --,
   {{0x95e2f1ee,0x0a7e02b2,0xf29272aa,0x02007128}},	//   _categorí, _byandits, _dorais_, _minim_,
   {{0xf9ffa041,0xc2cb4144,0x00000000,0x00000000}},	//   _moderní_, _predam_, --, --,
   {{0x9290718b,0xb5e2f177,0x00000000,0x00000000}},	//   _annar_, _categorï, --, --,
   {{0x03ea702d,0x328c4173,0x5200e27b,0xb7929112}},	//   _tentu_, _niekada_, _nonina_, _contrasi,
   {{0x12004037,0xf2e7706e,0x53204154,0x00000000}},	//   _kimia_, _adunola_, _kimya_, --,
   {{0x92e8e0a4,0x62d8d1b2,0xd9ab10fd,0x6eb9615b}},	//   _tulisan_, _ntees_, _оксана_, _navorsin,
   {{0x32480136,0x4d93d2db,0x4233c179,0xb200c02d}},	//   _naime_, _लोकोक्ति, _hyppää_, _kuliah_,
   {{0x8053c035,0xe290c105,0x02d9e194,0x331a807b}},	//   _presiden, _ondan_, _heter_, _সিকিউরিট,
   {{0xb301c076,0x5d3d3041,0xab98035c,0x727d3098}},	//   _ज़िम्मेद, _aplikace_, _ficheiro_, _aplikaci_,
   {{0x7387f068,0xa1b9e100,0xd2d280d4,0x43b99017}},	// [f40] _buurt_, _молодёжь_, _illegali_, _zatvoru_,
   {{0x9202009d,0xff3a0061,0x224a6222,0x00000000}},	//   _lipiec_, _profesin, _bcumnw_, --,
   {{0xe2fcc3b2,0x227e600d,0x038602a9,0xe38cd1ab}},	//   _google_, _mbona_, _akiri_, _шумен_,
   {{0x355c9045,0xf5a97194,0x62d922d7,0xf2d9812f}},	//   _постанов, _радянськ, _xuyen_, _dtreo_,
   {{0x91c930c3,0x36e8d0a2,0xc326513b,0xa27e70a0}},	//   _болта_, _istraživ, _图片和音视频稿件_, _rannu_,
   {{0x5cce40ea,0x00000000,0x00000000,0x00000000}},	//   _이메일주소_, --, --, --,
   {{0x1f3e8116,0xf465325e,0xb7e60004,0x927f12a3}},	//   _baarlama, _osservaz, _ליצנות_, _kaznu_,
   {{0x527e600d,0x9730d11c,0x53271037,0x2e39d07f}},	//   _abona_, _ویتامین_, _صاحبان_, _рэзбой_,
   {{0x16d1a166,0xb2919089,0x237fd055,0xbef2e056}},	//   _रितिक_, _posar_, _filayaa_, _beskrivn,
   {{0x97597389,0x438691d6,0x160340c3,0xbc619076}},	//   _साक्ष्य_, _ikari_, _тестамен, _ofercie_,
   {{0x229071ce,0x32915154,0x1a572021,0x519d504d}},	//   _annak_, _ingawa_, _іншых_, _名様にプレゼント_,
   {{0x3aed40d4,0x02486208,0x8d561018,0x182c1018}},	//   _introdot, _droma_, _בינתיים_, _להישאר_,
   {{0xa3fc1008,0x725ad022,0x32eab0db,0x1481c13b}},	//   _להפסיק_, _bullar_, _eventos_, _劳动的财政贡献率,
   {{0x62fe423d,0x7386b07f,0x4315807a,0x02f181ab}},	//   _artigos_, _oferte_, _ансамблі_, _инсталир,
   {{0xe25ad1be,0x4d35a062,0xf2904037,0xd9a0c05d}},	//   _meela_, _планете_, _timah_, _abakozie,
   {{0xa2d9e0f7,0x62da600d,0x73d510d4,0x026e727c}},	//   _beter_, _gereza_, _protetti_, _kosove_,
   {{0xf23780e8,0x4ff82020,0xc291c015,0x6c1db008}},	// [f50] _varje_, _담당중개업소_, _novas_, _כשהוא_,
   {{0x3fd68154,0xe6c5019b,0x725ad119,0x622670e8}},	//   _changamo, _نويسد_, _geela_, _risken_,
   {{0xb202009d,0x825af18c,0xe27f40a2,0x00000000}},	//   _musisz_, _regle_, _krenuo_, --,
   {{0xf53fe1aa,0xd290b1e3,0x925af1db,0xcf39727d}},	//   _адресу_, _indaba_, _segle_, _finanční,
   {{0x2c755079,0x025a9038,0x8e4a0037,0x2c0691a3}},	//   _दोस्ती_, _awali_, _peradaba, _imprezy_,
   {{0x620070d3,0x4c2c0208,0xa27e61df,0xb502b036}},	//   _minic_, _theangac, _ubona_, _ingresso_,
   {{0xc08a4082,0xf3f9e18b,0x1248d28a,0x825a5370}},	//   _кримінал, _setur_, _igomba_, _kelli_,
   {{0x82da63b3,0x0a1461dd,0xd3193065,0x00000000}},	//   _parece_, _pribatut, _شيئاً_, --,
   {{0x72b52044,0xa229a014,0x427e6191,0x62def08b}},	//   _índice_, _kuamuag_, _uplne_, _autorov_,
   {{0x127f02e9,0x330c30ae,0x7b29d264,0x72d92018}},	//   _blandt_, _izlases_, _justiça_, _accept_,
   {{0xe20ec1c9,0xae05919e,0x52d8c1a0,0xd9b3a16a}},	//   _намаз_, _kenderaa, _namens_, _nesprávn,
   {{0x771341ed,0xca0d60db,0x0200519b,0x8135a0f8}},	//   _जर्दा_, _computad, _silih_, _mendebal,
   {{0x9711403c,0xd2005102,0x34a30105,0xbb18105e}},	//   _गर्दन_, _pilih_, _futbolçu, _kabataan_,
   {{0x5396606a,0xb2a661b4,0x22d96013,0x00000000}},	//   _persze_, _nyoba_, _ergens_, --,
   {{0x2ece509d,0x6f3b0037,0xd9ec5174,0xad444194}},	//   _कार्यवाह, _keluraha, _colombia_, _унікальн,
   {{0x96e94029,0xc3f9e074,0x32d9e201,0xc7240018}},	//   _इतिहासाच, _petur_, _often_, _סטנדרט_,
   {{0x3b8b9295,0xce530009,0x3b6ac0b9,0x632070ef}},	// [f60] _ministar, _pelatiha, _pretoria_, _annyi_,
   {{0x935d40a4,0x92fce1c0,0x0b02c0ac,0x3c615105}},	//   _सल्ला_, _hangin_, _konfrans, _postlar_,
   {{0xedb79021,0xc2fce074,0x00000000,0x00000000}},	//   _законы_, _kangin_, --, --,
   {{0x9845b044,0xc25a3039,0x00000000,0x00000000}},	//   _utilidad, _állam_, --, --,
   {{0xc33d211c,0x325a9038,0xc3eb006e,0xd9f7a086}},	//   _میراث_, _swali_, _abetí_, _bibiliya_,
   {{0x2f1d608e,0xc5327017,0x25abf004,0xc224d26f}},	//   _nakupova, _септемба, _עקאָנאָמ, _ifokus_,
   {{0x1315b240,0x74293037,0x627ed12f,0xd48552cc}},	//   _memberi_, _campuran_, _daonna_, _शेजारी_,
   {{0x4290c051,0xe212b154,0x0c64323e,0xd29030d4}},	//   _gidan_, _kocha_, _bintulu_, _rumani_,
   {{0x027e914e,0xa431507b,0xc2787061,0x1c586353}},	//   _upang_, _আপনিও_, _kaunas_, _faktisk_,
   {{0x2f993048,0x307cb07b,0xedb2d0f2,0x01df803c}},	//   _nhất_, _ফটোশপ_, _keingina, _poinform,
   {{0x429040fb,0x52d9e1f8,0x2a73b1bb,0xb6faf039}},	//   _limau_, _aften_, _публічна_, _افزائی_,
   {{0xe27e900d,0xc38c2017,0x238e9203,0x12cb5089}},	//   _abana_, _путем_, _consigli_, _quedar_,
   {{0x6e68c3b4,0x1f20c223,0xbc6321a3,0xd1dc1094}},	//   _adiciona, _स्वीकृति_, _dostęp_, _סלוצקי_,
   {{0x1201f0d2,0x7200a247,0x34e3407b,0xd248d184}},	//   _sluit_, _bibie_, _ইকবাল_, _ugomba_,
   {{0xa9093166,0x1230705a,0x513c110b,0x9ae891dd}},	//   _विवेकानं, _nyamara_, _posledný_, _datorren_,
   {{0xbd0d7099,0x7200f22b,0xe34fd0f8,0x5290f03e}},	//   _najmanje_, _engin_, _direnak_, _engan_,
   {{0x9db43037,0xf3eb3044,0xcc1d300c,0x83a342ff}},	// [f70] _موضوع_, _texto_, _kurallar, _sleppa_,
   {{0x7290c1dd,0x2291d1d8,0x20f4404d,0xe387f224}},	//   _zidan_, _sowat_, _そういえば_, _istre_,
   {{0xb200f04a,0x67bca040,0x4291e0dc,0x00000000}},	//   _ingin_, _angezeig, _votat_, --,
   {{0x035fa254,0x77a1f15a,0x131c119b,0xb9d0c0c3}},	//   _airgead_, _omstandi, _ضیغمی_, _векий_,
   {{0x2b98e283,0x3c5280f8,0x0481b2be,0x11216241}},	//   _pilipino_, _kontuan_, _पिताजी_, _raspolož,
   {{0x72a7c036,0x07d7c173,0x3273b0e9,0xc201007f}},	//   _такова_, _тэкст_, _mínir_, _mobila_,
   {{0x325a0034,0x22903154,0x7367b0d1,0xf30d8086}},	//   _utile_, _kamati_, _langsam_, _kwibuka_,
   {{0x8943813d,0x6200c158,0x53ead0de,0x53d4019f}},	//   _mailadre, _fidio_, _rootsi_, _yuxarı_,
   {{0xae37b0fc,0x0499308a,0x5599303b,0x125a0036}},	//   _bidalita, _personaj, _personaz, _stile_,
   {{0xe27ee047,0x90c7a1bc,0x0290c081,0xcf30012f}},	//   _pointe_, _рамките_, _sidan_, _الزفاف_,
   {{0x72ca701d,0x938691ba,0xd37381a6,0x527ef142}},	//   _kendi_, _thart_, _redakce_, _magni_,
   {{0x801e2173,0x7a0c107b,0x5f06c107,0x3200f02d}},	//   _komentuo, _সুখবর_, _кратка_, _angin_,
   {{0xe200c01d,0xc75831f7,0xab7bf05e,0xa810f11c}},	//   _indir_, _मिष्ठान_, _pangalan_, _جایگزین_,
   {{0x039461d6,0x604dc017,0x82ca70f9,0x73f40044}},	//   _idosa_, _врата_, _lendi_, _destas_,
   {{0x6b1d112f,0x43ea9047,0x7200c002,0x62fcd044}},	//   _الفجر_, _leath_, _andis_, _únicos_,
   {{0x427bc221,0xa2a78101,0x00000000,0x00000000}},	//   _objednáv, _garba_, --, --,
   {{0x33f8f276,0x00000000,0x00000000,0x00000000}},	// [f80] _puguh_, --, --, --,
   {{0xf3ead1d7,0xa89ea06a,0x372ba02a,0x00000000}},	//   _cultur_, _katalógu, _столиці_, --,
   {{0x7fd52006,0x82139144,0x1273b277,0xef0ce0fe}},	//   _materiał, _najnovši, _sínar_, _ব্লজব_,
   {{0x9d97601a,0x4bdde03c,0x07a6c082,0x5752c08d}},	//   _applikaa, _बलिया_, _handling, _ezinjeng,
   {{0x72a78220,0x987602d0,0x4942701a,0xbeb32346}},	//   _darba_, _משניות_, _sellaise, _derechos_,
   {{0x0e1ed0a4,0xee2e0057,0x00000000,0x00000000}},	//   _व्यक्तिप, _bergamba, --, --,
   {{0x3dd9319e,0x92a7808b,0x9773913b,0xc7e3d036}},	//   _berkenaa, _farba_, _并不意味着赞同其, _позиция_,
   {{0xeb0a4128,0x49912163,0xa290f044,0xe200c23e}},	//   _persoane, _klijenta_, _ligan_, _aidil_,
   {{0xd369c03e,0xc38751bd,0x00000000,0x00000000}},	//   _tenglar_, _پاسداری_, --, --,
   {{0xe2903138,0xd5d2f017,0x00000000,0x00000000}},	//   _comann_, _железниц, --, --,
   {{0x52927221,0xf2d820a1,0x027f818b,0x0c774192}},	//   _strach_, _emmere_, _barni_, _websted_,
   {{0x632091cc,0x1d561008,0x929070a2,0xec7d501a}},	//   _biaya_, _זיכרון_, _iznad_, _miesten_,
   {{0x3aefd080,0x68d2d0da,0x0605a02b,0x00000000}},	//   _opíšte_, _पहाटे_, _буклеты_, --,
   {{0x92d97080,0x3a03304d,0x00000000,0x00000000}},	//   _videá_, _このブログの読者_, --, --,
   {{0x92c7c27e,0xca0510da,0x8a376044,0xd4d76044}},	//   _sådan_, _चिन्हावर_, _técnicas_, _técnicos_,
   {{0x645b7100,0x72901106,0x235d111c,0x00000000}},	//   _установа, _mihai_, _nanging_, --,
   {{0x6ccc102a,0xb290327d,0x00550175,0x00000000}},	// [f90] _служб_, _nijak_, _passagen, --,
   {{0xd3eb8064,0x6898a25a,0xf685204e,0x6a11f034}},	//   _serta_, _न्यूजीलै, _аурите_, _garanzia_,
   {{0x62cb8035,0x8197c14d,0x2290c0ed,0x72d85177}},	//   _perda_, _законе_, _indah_, _caled_,
   {{0x02d981dd,0x1f5991b2,0x329070bb,0x4387a0ef}},	//   _euren_, _bliajyob_, _vinai_, _napra_,
   {{0x8730d0cb,0x03eb802a,0x00000000,0x00000000}},	//   _عیسائی_, _verta_, --, --,
   {{0xe2bd1215,0x9387e0f0,0x82015246,0x00000000}},	//   _спроба_, _catro_, _ingiza_, --,
   {{0x42249193,0xc3cef13e,0xbe83d1b8,0xaf5d6102}},	//   _ovako_, _blivit_, _подарок_, _sepanjan,
   {{0x43878060,0x33eb0084,0xf2cb0084,0x95b9212f}},	//   _abiyamọ_, _khatam_, _khadam_, _ballstát_,
   {{0xd291b03f,0x62fc9283,0x22905009,0xf290f02d}},	//   _novada_, _umaga_, _kilat_, _ingat_,
   {{0x53787154,0xeaf7c062,0x00000000,0x00000000}},	//   _angalia_, _памети_, --, --,
   {{0xb2d9f01a,0x346a90bf,0x6321a0c4,0x8841c171}},	//   _ettei_, _akademio_, _dopyt_, _últimas_,
   {{0xa2d84073,0x1395403a,0x43f0c00a,0xa2b41192}},	//   _numer_, _queste_, _minoranz, _sundhed_,
   {{0x2d04c12f,0x3a116133,0x8f7a5222,0x6343c130}},	//   _زوجها_, _thuairme, _chồng_, _повода_,
   {{0xfb038195,0xa5ba3031,0x527f8276,0xecaa0199}},	//   _телекана, _月加入中国共产党_, _warni_, _asociāci,
   {{0x2c21a375,0xf30b911c,0x1292700e,0x25a0b125}},	//   _גדליה_, _یکدیگر_, _merali_, _सोचती_,
   {{0x7f39a008,0x5254e1bd,0x9224e1d6,0xb200c190}},	//   _תקציב_, _főleg_, _adikwa_, _paliek_,
   {{0x4fef80a4,0x62b66089,0x22cb5332,0x707d3293}},	// [fa0] _विमानतळ_, _cercle_, _kredyt_, _шанси_,
   {{0x03f821c5,0x5ad681af,0x4290312a,0x42bb50ac}},	//   _cukup_, _листата_, _himaya_, _həcmi_,
   {{0xa248002b,0xa617401a,0x5e59101b,0xf74e0111}},	//   _kaimo_, _englanni, _berbinca, _rodičovs,
   {{0xdb3b9017,0xe8b1d1f6,0x2225409f,0x27cb902a}},	//   _складу_, _predsjed, _hoekom_, _складі_,
   {{0x51778013,0xbb6440d1,0x6387e3b5,0xe2da700c}},	//   _behandel, _arbeiten_, _patro_, _mesela_,
   {{0x33f880a1,0x1f3360bd,0xb332d18e,0x22d7c1ee}},	//   _yakuwa_, _konsista, _flexo_, _laboral_,
   {{0x92d9e153,0x429081a4,0xf486d002,0x82b4f029}},	//   _after_, _nikada_, _त्राहि_, _आत्मविश्,
   {{0xb30cc209,0x12da10a0,0x628c2136,0x806172b9}},	//   _siyaset_, _popeth_, _njihovu_, _praktisk_,
   {{0x5b1ed031,0x3b8de0d4,0xc13a31fd,0x84eb60e9}},	//   _点击此处查看原文_, _fornitur, _mennessä_, _gestabók_,
   {{0xa3ea6038,0x4200520d,0x822490a2,0xd686b210}},	//   _mtoto_, _bilim_, _svako_, _prodavni,
   {{0xd2d9e27e,0x5be9a16e,0x73538006,0x70d560a4}},	//   _efter_, _جرينتش_, _produkcj, _bergerak_,
   {{0xf387e07f,0x42d8d1dd,0xe3f860a4,0xb3f9810f}},	//   _catre_, _ordea_, _mulus_, _nurul_,
   {{0xf2d981f8,0x3dd7a102,0x2200f252,0x00000000}},	//   _turen_, _perhatia, _digil_, --,
   {{0xffcd312f,0x2e38720d,0x02a2623b,0x7e91e041}},	//   _البعض_, _galatasa, _उच्चस्तर, _editovat_,
   {{0x720071c6,0x829040f1,0xe00521af,0x84cb91ab}},	//   _minit_, _jimak_, _огромни_, _контрапр,
   {{0xa2d82148,0xf507b0c5,0xf2a63185,0x37d0c017}},	//   _maken_, _средств_, _tombol_, _многи_,
   {{0x53eb91f1,0x7c7040ff,0xe2909038,0x80d040c4}},	// [fb0] _mesto_, _vlastne_, _askari_, _vlastnej_,
   {{0xd23510c7,0xf45510c2,0xb3eb8036,0x44a1b00c}},	//   _prodotti_, _prodotto_, _certo_, _firması_,
   {{0x217cc068,0x2bdf81b3,0x3e59104c,0x0359f2eb}},	//   _해피캠퍼스_, _coreógra, _perbinca, _razdoblj,
   {{0xf2d6f0c4,0x62918025,0x59678070,0xc96740a6}},	//   _pomohol_, _coraz_, _tekintet, _हरिनाम_,
   {{0x30b0112b,0x42b40086,0xce4f012a,0xb2b4e314}},	//   _minimáln, _kwica_, _makalala, _afiche_,
   {{0x02786150,0xe4b5a05d,0xfa19813b,0xe4b2800a}},	//   _umuntu_, _kutandik, _点击查看更多_, _legalizz,
   {{0xf5c7108a,0x97798031,0xaa739204,0x33eb9229}},	//   _তেহরান_, _青岛市公安局_, _slično_, _kesto_,
   {{0xd2926116,0x52009328,0x334212c1,0x41dc102a}},	//   _intaas_, _jijiga_, _poseban_, _клуби_,
   {{0xf3eb7133,0x7c7ea0bc,0xf25a0018,0x43dc91be}},	//   _leatsa_, _opisyal_, _build_, _amawo_,
   {{0xdc603232,0xd2005102,0xe37b2248,0x00000000}},	//   _amatör_, _milik_, _horario_, --,
   {{0xa9e64136,0x96d601dd,0x78bae0ea,0xb2d64136}},	//   _otvorena_, _desberdi, _동영상갤러리_, _otvoren_,
   {{0x63eb91e8,0x9290f25d,0x00000000,0x00000000}},	//   _nesto_, _engar_, --, --,
   {{0x226e607f,0xb3ea9203,0xd26fb0ed,0xc57140ea}},	//   _parola_, _stata_, _pengalam, _공간입니다_,
   {{0x373e00c5,0x6e39504f,0x9a0ab2d7,0xc27ed0a0}},	//   _подготов, _localisa, _banbient, _ffonio_,
   {{0x62d99221,0xdb0c0237,0x9a42f011,0xb2b2f0e6}},	//   _musel_, _keistime, _bilderna_, _bildern_,
   {{0xf200c1ec,0x5378d0a4,0xb48663b6,0x4045f0b2}},	//   _midia_, _lumayan_, _गंगाजी_, _kilobook_,
   {{0x83eb834c,0x725a0031,0x4386d159,0xf041a2c1}},	// [fc0] _perto_, _huile_, _akero_, _okruženj,
   {{0xc5bbf0b7,0xef4d0179,0x8f03e025,0x83f96245}},	//   _акчепте_, _omistaja, _मुफ़्त_, _kugura_,
   {{0x73ef61cc,0xf726d025,0x3290b0a1,0xb8f8b0f8}},	//   _जन्मकुंड, _काफ़ी_, _endala_, _askatasu,
   {{0xa290e366,0x7c615024,0x42d750ca,0xf2ed7018}},	//   _dinara_, _dostlar_, _třech_, _approach_,
   {{0x62272020,0x223dd069,0xe07a413c,0x93870161}},	//   _전원주택펜션_, _huamhoj_, _временск, _svarer_,
   {{0x7248d379,0xd201124e,0x127e9089,0xa2deb1ea}},	//   _prema_, _sizin_, _abans_, _kuponov_,
   {{0xc03fb0b9,0x229ee099,0x343ee099,0xa200518a}},	//   _vertalin, _slobodni_, _slobodno_, _milih_,
   {{0x220051c6,0xab2e40ca,0xe20260de,0x8baf1108}},	//   _bilik_, _poradens, _aprill_, _षडयंत्र_,
   {{0xa2fde061,0x22dfa33d,0x7f5d40e1,0x32005009}},	//   _muzikos_, _maandag_, _दूंगा_, _cilik_,
   {{0x430f3230,0x52d811c0,0x127ff0b2,0x92495089}},	//   _roditelj, _kahel_, _phung_, _premis_,
   {{0xed03504d,0x0d314065,0x675ba070,0xbe3b10da}},	//   _最終更新日_, _رووووووو, _ہتھیاروں_, _kesadara,
   {{0x7294227b,0x5db71183,0xddb41002,0x6f5d4125}},	//   _israyeli_, _habilida, _munitsip, _दूँगा_,
   {{0x3ef4d01a,0x42d8a07a,0xad444065,0x42007133}},	//   _становит, _vadovas_, _وخلفيات_, _ainim_,
   {{0x527ff2d7,0xe38730dc,0x67ed410b,0x42d8307f}},	//   _thung_, _milionë_, _futbalov, _nimeni_,
   {{0xf1e1a0a4,0x508d9114,0x03009004,0xc2cb81c0}},	//   _ठाकरे_, _השיער_, _ראטעווען_, _berde_,
   {{0xe38ce07a,0x43ac705f,0x00000000,0x00000000}},	//   _музея_, _respek_, --, --,
   {{0x5e9230e7,0xa741d082,0x00000000,0x00000000}},	// [fd0] _портала_, _основні_, --, --,
   {{0x4ea2f0da,0x53f82159,0x7c68316c,0x4987e3ad}},	//   _parlemen, _takun_, _петрика_, _तालमेल_,
   {{0x327f7118,0xe31692a9,0x50da5045,0xa2905102}},	//   _quanto_, _akazi_, _написанн, _nilai_,
   {{0x62484056,0xa4ee1194,0x52da714d,0x70f3a263}},	//   _samma_, _підготов, _meseca_, _भागवत_,
   {{0x7e9f00de,0xe3f84037,0xc54a703d,0x02d820c0}},	//   _विशेषज्ञ_, _lamun_, _アクセサリ_, _saken_,
   {{0xd5fa6243,0xab0030fe,0x4201c0c2,0x00000000}},	//   _पुरोहित_, _পিয়াল_, _invio_, --,
   {{0x625ad06e,0x238a9130,0x1067b063,0xa200b21b}},	//   _meeli_, _француск, _akwarado, _indima_,
   {{0x729001d7,0x00000000,0x00000000,0x00000000}},	//   _chiad_, --, --, --,
   {{0xf5ac1071,0x42b440ef,0x323451ec,0x33a45018}},	//   _глума_, _vendég_, _amamihe_, _ההצטרפות_,
   {{0x830e01c0,0x930370d1,0x03b6202a,0xd27f709e}},	//   _sapatos_, _gemacht_, _значення_, _asanga_,
   {{0x1290a028,0x0201c31c,0x7cd230fe,0xbe31c014}},	//   _sedang_, _envio_, _ভাইকে_, _vimlicas_,
   {{0x3e6c2126,0xe2912037,0x6a12b1b6,0xdf2d5008}},	//   _فیروز_, _anyar_, _izaberit, _conferen,
   {{0x575fe3b7,0xc08da008,0xd9f7b16a,0x83f400dc}},	//   _विस्फोट_, _לבדוק_, _vydavate, _rastet_,
   {{0xc2ea0084,0xff3890f5,0xaf202047,0x93eb51e3}},	//   _beriman_, _kienthuc_, _موبايلات_, _upetru_,
   {{0xc2d840e6,0x42ea824a,0x4bc43191,0xa93592cc}},	//   _namen_, _helical_, _dekoráci, _एक्स्प्ल,
   {{0x01b3c12f,0x33eae142,0x00000000,0x00000000}},	//   _شاغرة_, _editja_, --, --,
   {{0x8c3aa036,0xa26e4147,0x439403b8,0x00000000}},	// [fe0] _историят, _nitong_, _ovisi_, --,
   {{0xedff5250,0x2c7581f3,0x856d622c,0xa2d42260}},	//   _rundinga, _सदस्यो_, _samosprá, _večernje_,
   {{0x7611804b,0x24d5b1f3,0xde72c1a6,0x5bdfc23f}},	//   _kritikal_, _काशिका_, _रिक्त_, _nedenler,
   {{0x5cc1712f,0xe290a110,0x6e7c10c6,0x7c639266}},	//   _النجوم_, _hajati_, _मूख्य_, _milujem_,
   {{0x92907041,0x7df16024,0x615ba031,0xb3f0b0bd}},	//   _jinak_, _hindista, _添加到收藏夹_, _maketing_,
   {{0x402e1153,0x3ac3b076,0x2a3cd0b7,0xcc57427d}},	//   _conditio, _बागपत_, _бужор_, _postele_,
   {{0x992070c8,0x8de073b9,0x72d8d2b9,0x525a90de}},	//   _mobilní_, _mobilné_, _ordet_, _sealt_,
   {{0xc84c7004,0xd784f161,0x00000000,0x00000000}},	//   _ספֿרים_, _privatli, --, --,
   {{0x0297e0e2,0xaae8a18c,0xee4f8241,0x62e8e0bd}},	//   _marafiki_, _retounen_, _malograđ, _filipin_,
   {{0x419580ae,0x12480052,0x0a1440f7,0xf25b00f6}},	//   _rezultāt, _isimo_, _vakantie, _aralar_,
   {{0x5c1d6128,0x03eb904f,0xe387e314,0x5e1d5065}},	//   _complet_, _reste_, _fatra_, _وقضايا_,
   {{0x1795a042,0xbf3b90d6,0x8378e037,0x322540ca}},	//   _centerpi, _kerusaka, _kalawan_, _čekat_,
   {{0xe3eb904e,0xd5e940aa,0x5c1fc056,0x00000000}},	//   _peste_, _yabancı_, _slipper_, --,
   {{0x428750c6,0x6c75626f,0x82ada080,0xe314b12a}},	//   _miliony_, _därmed_, _zohnať_, _lambeth_,
   {{0xd23cd020,0x9d9df0c5,0x01c930b7,0xbc5ac128}},	//   _환영합니다_, _maananta, _тоате_, _preturi_,
   {{0x4dc051da,0x227f7184,0xdebf4173,0x92927268}},	//   _intitola, _usanga_, _bendrovė, _árabe_,
   {{0x4278701a,0x50e3b018,0xd37a02c3,0xdc67b05e}},	// [ff0] _kaunis_, _הרחבה_, _gerakan_, _libreng_,
   {{0x97db52f8,0x1ae97122,0x5a8ca0e6,0x0851113b}},	//   _प्रकृति_, _sprememb, _optionen_, _衣锦荣归回乡路_,
   {{0xd386d214,0x817db008,0x7489f1ab,0x2dad80e9}},	//   _ejere_, _ליווי_, _опасност_, _landspít,
   {{0x95f3a273,0xce9c1094,0xd2926191,0x32fcd100}},	//   _момента_, _והארות_, _porada_, _blogas_,
   {{0x3e7380a4,0xc9f6111c,0xc1dea140,0x6394609e}},	//   _दृश्य_, _توزیع_, _povratak_, _bwose_,
   {{0x22d843ba,0xec5be00a,0x825af1ab,0x79dc7082}},	//   _tamen_, _partiti_, _negli_, _кіровогр,
   {{0x360680de,0x13207154,0xaa58a0db,0x00000000}},	//   _चाँदी_, _ninyi_, _pergunta_, --,
   {{0x5828e0b2,0x52d760b3,0x7ffaa19b,0x00000000}},	//   _liệu_, _osvojio_, _پرفروش_, --,
   {{0x53f84074,0x12d841ff,0x32a6204f,0xbc1cc1e3}},	//   _samun_, _samen_, _semble_, _yobukris,
   {{0x63ea9024,0xf5d15006,0x9290e00d,0x57e770e1}},	//   _teatr_, _produktó, _munani_, _लेटर्स_,
   {{0x5fcca2e2,0x12901070,0x126401b2,0x32002037}},	//   _artikler_, _alkalomm, _heslis_, _mikir_,
   {{0x0378e18e,0x82d96056,0x42fce2cc,0x6814c008}},	//   _bulanan_, _dagens_, _minggu_, _specific_,
   {{0x63f8a19e,0x52d8d0bb,0xb200709d,0x73eb8285}},	//   _kubur_, _nrees_, _linii_, _merta_,
   {{0x9be4121b,0xf26630b7,0x00000000,0x00000000}},	//   _safesear, _ансамблу_, --, --,
   {{0x191f30d3,0x5248017f,0x020e11ab,0x9386d0bf}},	//   _aistriúc, _daima_, _масаж_, _ajere_,
   {{0xf379618f,0x9200e21b,0x00000000,0x00000000}},	//   _faransa_, _kunini_, --, --,

  };
  // table_hash = 57ce-808c, unused_entries = 1306 (7.97%)

static const uint32 kDeltaOctaChrome0122SizeOne = 955;  // One-langprob count
static const uint32 kDeltaOctaChrome0122IndSize = 955;  // Largest subscript
static const uint32 kDeltaOctaChrome0122Ind[kDeltaOctaChrome0122IndSize] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001324, 0x00000e1c,   // -- --  bh.un.un_900 is.un.un_800
  0x0000240f, 0x00000e0f, 0x00000924, 0x00004a2d,   // yi.un.un_600 is.un.un_600  pl.un.un_900 yo.un.un_A00
  0x00000115, 0x00002124, 0x00002a2d, 0x00001c03,   // iw.un.un_700 jw.un.un_900  mt.un.un_A00 id.un.un_300
  0x00001b42, 0x00005542, 0x0000642d, 0x0000132d,   // tr.un.un_C00 rw.un.un_C00  lg.un.un_A00 et.un.un_A00
  // [0010]
  0x0000042d, 0x00000c24, 0x08000235, 0x00000342,   // fi.un.un_A00 sv.un.un_900  da.no.un_A90 nl.un.un_C00
  0x00006e24, 0x19000a36, 0x00002037, 0x00001742,   // hmn.un.un_900 pt.gl.un_AA0  sq.un.un_B00 sr.un.un_C00
  0x0000010f, 0x00000b24, 0x00000442, 0x00001e01,   // iw.un.un_600 es.un.un_900  fi.un.un_C00 ms.un.un_200
  0x1700160e, 0x00001b2d, 0x19000b1b, 0x00000f15,   // hr.sr.un_550 tr.un.un_A00  es.gl.un_770 lv.un.un_700
  // [0020]
  0x00000315, 0x00001001, 0x0000520f, 0x0000130a,   // ko.un.un_700 lt.un.un_200  ha.un.un_600 et.un.un_500
  0x00003142, 0x0000090f, 0x13000902, 0x16001709,   // az.un.un_C00 hi.un.un_600  hi.bh.un_220 sr.hr.un_440
  0x1c001e09, 0x00001c37, 0x00000815, 0x00001015,   // ms.id.un_440 mr.un.un_B00  no.un.un_700 lt.un.un_700
  0x00000415, 0x1e001c36, 0x2d000d23, 0x00001006,   // ru.un.un_700 id.ms.un_AA0  cs.sk.un_880 lt.un.un_400
  // [0030]
  0x09001309, 0x00000515, 0x00000a37, 0x0000051c,   // bh.hi.un_440 zh.un.un_700  pt.un.un_B00 fr.un.un_800
  0x0000071c, 0x00001c15, 0x00000742, 0x00002142,   // bg.un.un_800 id.un.un_700  it.un.un_C00 fa.un.un_C00
  0x0000281c, 0x00001242, 0x0000072d, 0x0000201c,   // sw.un.un_800 ur.un.un_C00  it.un.un_A00 sq.un.un_800
  0x00000942, 0x0000021c, 0x00000e42, 0x00000f42,   // pl.un.un_C00 ja.un.un_800  is.un.un_C00 lv.un.un_C00
  // [0040]
  0x00000624, 0x00000d1c, 0x00006b0a, 0x00006e2d,   // de.un.un_900 cs.un.un_800  ceb.un.un_500 hmn.un.un_A00
  0x00001942, 0x00000842, 0x00001f0f, 0x00001842,   // gl.un.un_C00 uk.un.un_C00  cy.un.un_600 ga.un.un_C00
  0x00002b0f, 0x0000092d, 0x1e001c2c, 0x00006b15,   // vi.un.un_600 hi.un.un_A00  id.ms.un_990 ceb.un.un_700
  0x00001e03, 0x00000215, 0x00001137, 0x00000524,   // ms.un.un_300 ja.un.un_700  ro.un.un_B00 fr.un.un_900
  // [0050]
  0x00000a1c, 0x0000521c, 0x00003524, 0x00000301,   // pt.un.un_800 ha.un.un_800  zu.un.un_900 nl.un.un_200
  0x00001315, 0x00003b15, 0x00000c42, 0x1c001e14,   // et.un.un_700 so.un.un_700  sv.un.un_C00 ms.id.un_660
  0x0000532d, 0x00006b03, 0x00005515, 0x00002501,   // ht.un.un_A00 ceb.un.un_300  rw.un.un_700 eu.un.un_200
  0x1c000912, 0x00006442, 0x00001a42, 0x00003f24,   // hi.mr.un_640 lg.un.un_C00  tl.un.un_C00 af.un.un_900
  // [0060]
  0x00004a24, 0x0000101c, 0x00001737, 0x0000682d,   // yo.un.un_900 lt.un.un_800  sr.un.un_B00 ig.un.un_A00
  0x1c001e02, 0x0000180f, 0x09001c13, 0x00001c0a,   // ms.id.un_220 ar.un.un_600  mr.hi.un_650 mr.un.un_500
  0x0000031c, 0x00006e01, 0x0000121c, 0x09001314,   // ko.un.un_800 hmn.un.un_200  ur.un.un_800 bh.hi.un_660
  0x00004a0a, 0x00000f0a, 0x00004a42, 0x00000706,   // yo.un.un_500 lv.un.un_500  yo.un.un_C00 bg.un.un_400
  // [0070]
  0x00001215, 0x0000112d, 0x08000236, 0x00000937,   // ur.un.un_700 ro.un.un_A00  da.no.un_AA0 pl.un.un_B00
  0x00005242, 0x00001f24, 0x00000915, 0x00000424,   // ha.un.un_C00 cy.un.un_900  pl.un.un_700 fi.un.un_900
  0x00004a37, 0x09001c1b, 0x0000100f, 0x00000b15,   // yo.un.un_B00 mr.hi.un_770  be.un.un_600 bn.un.un_700
  0x00000703, 0x1c000d22, 0x0000530f, 0x00001124,   // bg.un.un_300 ne.mr.un_870  ht.un.un_600 ro.un.un_900
  // [0080]
  0x0d002d02, 0x00000824, 0x0000081c, 0x1c001e22,   // sk.cs.un_220 uk.un.un_900  uk.un.un_800 ms.id.un_870
  0x1c001e1b, 0x0b000a2c, 0x0000551c, 0x00001b01,   // ms.id.un_770 pt.es.un_990  rw.un.un_800 tr.un.un_200
  0x00001a24, 0x00002342, 0x00000b1c, 0x00002d0f,   // tl.un.un_900 ca.un.un_C00  es.un.un_800 sk.un.un_600
  0x0000522d, 0x00003515, 0x00002901, 0x0000020f,   // ha.un.un_A00 zu.un.un_700  sl.un.un_200 ja.un.un_600
  // [0090]
  0x00002015, 0x00001f1c, 0x00002d15, 0x00003f2d,   // sq.un.un_700 cy.un.un_800  sk.un.un_700 af.un.un_A00
  0x0000240a, 0x00001a37, 0x00000d06, 0x16001722,   // yi.un.un_500 tl.un.un_B00  cs.un.un_400 sr.hr.un_870
  0x00000d15, 0x17001636, 0x19000b02, 0x1e001c07,   // cs.un.un_700 hr.sr.un_AA0  es.gl.un_220 id.ms.un_420
  0x00006415, 0x00000901, 0x0000550f, 0x00003f1c,   // lg.un.un_700 hi.un.un_200  rw.un.un_600 af.un.un_800
  // [00a0]
  0x00001f15, 0x0000641c, 0x00003242, 0x00000f37,   // cy.un.un_700 lg.un.un_800  bs.un.un_C00 lv.un.un_B00
  0x00001c42, 0x00001b0f, 0x00001301, 0x00002924,   // mr.un.un_C00 tr.un.un_600  et.un.un_200 sl.un.un_900
  0x08000202, 0x17001602, 0x00001b1c, 0x00002301,   // da.no.un_220 hr.sr.un_220  tr.un.un_800 ca.un.un_200
  0x00003115, 0x00003137, 0x00000f24, 0x0000290f,   // az.un.un_700 az.un.un_B00  lv.un.un_900 sl.un.un_600
  // [00b0]
  0x00001f2d, 0x1600172b, 0x00002b0a, 0x1600171b,   // cy.un.un_A00 sr.hr.un_980  vi.un.un_500 sr.hr.un_770
  0x0000232d, 0x2d000d1b, 0x00000806, 0x0000110f,   // ca.un.un_A00 cs.sk.un_770  uk.un.un_400 ro.un.un_600
  0x1e001c0d, 0x00003f42, 0x19000a07, 0x00006e37,   // id.ms.un_540 af.un.un_C00  pt.gl.un_420 hmn.un.un_B00
  0x00006b24, 0x00005342, 0x00001f01, 0x00004a06,   // ceb.un.un_900 ht.un.un_C00  cy.un.un_200 yo.un.un_400
  // [00c0]
  0x0000080a, 0x00002d0a, 0x00000724, 0x00001142,   // no.un.un_500 sk.un.un_500  it.un.un_900 ro.un.un_C00
  0x0d002d14, 0x0000041c, 0x00000d0f, 0x00002a06,   // sk.cs.un_660 fi.un.un_800  ne.un.un_600 mt.un.un_400
  0x00000d0a, 0x17001614, 0x00000d42, 0x0000120f,   // cs.un.un_500 hr.sr.un_660  cs.un.un_C00 ur.un.un_600
  0x00002415, 0x0d00090e, 0x00000601, 0x0000310f,   // yi.un.un_700 hi.ne.un_550  de.un.un_200 az.un.un_600
  // [00d0]
  0x0000200a, 0x00000615, 0x00003f01, 0x0000181c,   // sq.un.un_500 de.un.un_700  af.un.un_200 ga.un.un_800
  0x00002a42, 0x1c00090e, 0x00001c24, 0x00002324,   // mt.un.un_C00 hi.mr.un_550  mr.un.un_900 ca.un.un_900
  0x0000212d, 0x00002937, 0x00001c0f, 0x0b000a23,   // jw.un.un_A00 sl.un.un_B00  id.un.un_600 pt.es.un_880
  0x00002042, 0x0900132b, 0x00001342, 0x13000912,   // sq.un.un_C00 bh.hi.un_980  bh.un.un_C00 hi.bh.un_640
  // [00e0]
  0x00006e0a, 0x00000903, 0x00002837, 0x00002801,   // hmn.un.un_500 hi.un.un_300  sw.un.un_B00 sw.un.un_200
  0x1c001323, 0x0200080e, 0x00000642, 0x0000171c,   // bh.mr.un_880 no.da.un_550  de.un.un_C00 sr.un.un_800
  0x00000c1c, 0x00000e15, 0x0000030f, 0x00001703,   // sv.un.un_800 is.un.un_700  ko.un.un_600 sr.un.un_300
  0x00001303, 0x1e001c02, 0x00002006, 0x00001237,   // bh.un.un_300 id.ms.un_220  sq.un.un_400 hu.un.un_B00
  // [00f0]
  0x0b00192a, 0x1c001e23, 0x1e001c35, 0x00000a2d,   // gl.es.un_970 ms.id.un_880  id.ms.un_A90 pt.un.un_A00
  0x00005506, 0x00002b42, 0x00002542, 0x00000324,   // rw.un.un_400 vi.un.un_C00  eu.un.un_C00 nl.un.un_900
  0x0000251c, 0x00005315, 0x0000640f, 0x1c001e2c,   // eu.un.un_800 ht.un.un_700  lg.un.un_600 ms.id.un_990
  0x00002524, 0x0000080f, 0x00000b0f, 0x0d002d1b,   // eu.un.un_900 uk.un.un_600  bn.un.un_600 sk.cs.un_770
  // [0100]
  0x00001042, 0x00005224, 0x1e001c23, 0x0d00092c,   // be.un.un_C00 ha.un.un_900  id.ms.un_880 hi.ne.un_990
  0x0000352d, 0x0000311c, 0x00001115, 0x00000a0f,   // zu.un.un_A00 az.un.un_800  ro.un.un_700 mk.un.un_600
  0x00001337, 0x02000802, 0x00001e06, 0x00002d1c,   // et.un.un_B00 no.da.un_220  ms.un.un_400 sk.un.un_800
  0x00002742, 0x1c000936, 0x1600172a, 0x1c001e34,   // gd.un.un_C00 hi.mr.un_AA0  sr.hr.un_970 ms.id.un_A80
  // [0110]
  0x0000640a, 0x00000d03, 0x0000191c, 0x00006e0f,   // lg.un.un_500 cs.un.un_300  gl.un.un_800 hmn.un.un_600
  0x00000142, 0x0b000a09, 0x00003b1c, 0x00000401,   // en.un.un_C00 pt.es.un_440  so.un.un_800 fi.un.un_200
  0x00000701, 0x00003b42, 0x00005324, 0x09001c1a,   // bg.un.un_200 so.un.un_C00  ht.un.un_900 mr.hi.un_760
  0x00002115, 0x00002942, 0x00000c2d, 0x0d001c1b,   // jw.un.un_700 sl.un.un_C00  sv.un.un_A00 mr.ne.un_770
  // [0120]
  0x0000231c, 0x00002537, 0x0000291c, 0x00000606,   // ca.un.un_800 eu.un.un_B00  sl.un.un_800 de.un.un_400
  0x00003b0f, 0x13000909, 0x00001224, 0x0b001902,   // so.un.un_600 hi.bh.un_440  hu.un.un_900 gl.es.un_220
  0x0000111c, 0x09001323, 0x00006b2d, 0x2d000d02,   // ro.un.un_800 bh.hi.un_880  ceb.un.un_A00 cs.sk.un_220
  0x00000542, 0x0d000914, 0x0d002d23, 0x00001815,   // fr.un.un_C00 hi.ne.un_660  sk.cs.un_880 ga.un.un_700
  // [0130]
  0x00001724, 0x00000506, 0x00001206, 0x0000271c,   // sr.un.un_900 fr.un.un_400  ur.un.un_400 gd.un.un_800
  0x00001f42, 0x00002d37, 0x17001623, 0x0000162d,   // cy.un.un_C00 sk.un.un_B00  hr.sr.un_880 hr.un.un_A00
  0x00002715, 0x00002806, 0x17001635, 0x0000050f,   // gd.un.un_700 sw.un.un_400  hr.sr.un_A90 zh.un.un_600
  0x00001715, 0x00000306, 0x00000c37, 0x00002b37,   // sr.un.un_700 nl.un.un_400  sv.un.un_B00 vi.un.un_B00
  // [0140]
  0x16001736, 0x1e001c1b, 0x00002a24, 0x0000131c,   // sr.hr.un_AA0 id.ms.un_770  mt.un.un_900 et.un.un_800
  0x00002d42, 0x32001602, 0x0000022d, 0x00001a1c,   // sk.un.un_C00 hr.bs.un_220  da.un.un_A00 tl.un.un_800
  0x00000337, 0x00000d37, 0x00002803, 0x00001b37,   // nl.un.un_B00 cs.un.un_B00  sw.un.un_300 tr.un.un_B00
  0x09001308, 0x0000170f, 0x00001a2d, 0x0000280f,   // bh.hi.un_430 sr.un.un_600  tl.un.un_A00 sw.un.un_600
  // [0150]
  0x00003501, 0x19000b05, 0x00006b0f, 0x0000011c,   // zu.un.un_200 es.gl.un_330  ceb.un.un_600 en.un.un_800
  0x00002842, 0x00006806, 0x16001702, 0x00006e03,   // sw.un.un_C00 ig.un.un_400  sr.hr.un_220 hmn.un.un_300
  0x00004a1c, 0x00004a0f, 0x00003f06, 0x00003f15,   // yo.un.un_800 yo.un.un_600  af.un.un_400 af.un.un_700
  0x09001302, 0x00002b24, 0x00000f01, 0x00000f03,   // bh.hi.un_220 vi.un.un_900  lv.un.un_200 lv.un.un_300
  // [0160]
  0x00001837, 0x08000205, 0x09001c02, 0x1700162c,   // ga.un.un_B00 da.no.un_330  mr.hi.un_220 hr.sr.un_990
  0x0200081b, 0x00002a0f, 0x1c000914, 0x09000d2c,   // no.da.un_770 mt.un.un_600  hi.mr.un_660 ne.hi.un_990
  0x16001734, 0x00003237, 0x00000d01, 0x1c000902,   // sr.hr.un_A80 bs.un.un_B00  ne.un.un_200 hi.mr.un_220
  0x0000110a, 0x00001a01, 0x00001801, 0x17001609,   // ro.un.un_500 tl.un.un_200  ar.un.un_200 hr.sr.un_440
  // [0170]
  0x0d002d0e, 0x0b000a36, 0x00003506, 0x00001024,   // sk.cs.un_550 pt.es.un_AA0  zu.un.un_400 be.un.un_900
  0x00000b42, 0x00000a42, 0x09000d13, 0x00001f37,   // es.un.un_C00 pt.un.un_C00  ne.hi.un_650 cy.un.un_B00
  0x00002315, 0x0000040f, 0x00000737, 0x00005537,   // ca.un.un_700 ru.un.un_600  bg.un.un_B00 rw.un.un_B00
  0x09000d14, 0x00003f03, 0x00001103, 0x00002815,   // ne.hi.un_660 af.un.un_300  ro.un.un_300 sw.un.un_700
  // [0180]
  0x1c000909, 0x00000224, 0x00000a06, 0x0a000b36,   // hi.mr.un_440 ja.un.un_900  mk.un.un_400 es.pt.un_AA0
  0x00005524, 0x00001c1c, 0x1c001309, 0x0000252d,   // rw.un.un_900 mr.un.un_800  bh.mr.un_440 eu.un.un_A00
  0x00000237, 0x1e001c04, 0x0000211c, 0x00000e2d,   // da.un.un_B00 id.ms.un_320  jw.un.un_800 is.un.un_A00
  0x0000531c, 0x08000223, 0x00006b37, 0x00005215,   // ht.un.un_800 da.no.un_880  ceb.un.un_B00 ha.un.un_700
  // [0190]
  0x00000f1c, 0x00002d01, 0x00000242, 0x17001605,   // lv.un.un_800 sk.un.un_200  da.un.un_C00 hr.sr.un_330
  0x00000801, 0x0000082d, 0x1c000923, 0x00000d2d,   // uk.un.un_200 uk.un.un_A00  hi.mr.un_880 ne.un.un_A00
  0x17001622, 0x00000f0f, 0x00001101, 0x0000210f,   // hr.sr.un_870 lv.un.un_600  ro.un.un_200 jw.un.un_600
  0x00001306, 0x1e001c05, 0x00001e42, 0x00003101,   // et.un.un_400 id.ms.un_330  ms.un.un_C00 az.un.un_200
  // [01a0]
  0x00003f37, 0x00001e15, 0x00002101, 0x0000091c,   // af.un.un_B00 ms.un.un_700  fa.un.un_200 pl.un.un_800
  0x16003223, 0x00002b15, 0x00000d24, 0x00000637,   // bs.hr.un_880 vi.un.un_700  ne.un.un_900 de.un.un_B00
  0x3200172c, 0x00006401, 0x00001701, 0x00000715,   // sr.bs.un_990 lg.un.un_200  sr.un.un_200 it.un.un_700
  0x00001e0f, 0x19000a23, 0x19000b23, 0x00000a15,   // ms.un.un_600 pt.gl.un_880  es.gl.un_880 mk.un.un_700
  // [01b0]
  0x00000906, 0x00006e15, 0x00006e42, 0x0b000a1b,   // pl.un.un_400 hmn.un.un_700  hmn.un.un_C00 pt.es.un_770
  0x00002106, 0x00001e2d, 0x16001721, 0x00001e37,   // jw.un.un_400 ms.un.un_A00  sr.hr.un_860 ms.un.un_B00
  0x00000403, 0x1c000d14, 0x00001806, 0x00001037,   // ru.un.un_300 ne.mr.un_660  ga.un.un_400 be.un.un_B00
  0x00000a01, 0x0000120a, 0x00006842, 0x00002024,   // mk.un.un_200 ur.un.un_500  ig.un.un_C00 sq.un.un_900
  // [01c0]
  0x00006b42, 0x1c000d0e, 0x00002306, 0x1c000d35,   // ceb.un.un_C00 ne.mr.un_550  ca.un.un_400 ne.mr.un_A90
  0x0000061c, 0x1e001c09, 0x00001e1c, 0x0000210a,   // de.un.un_800 id.ms.un_440  ms.un.un_800 jw.un.un_500
  0x0d001c12, 0x00000a24, 0x00006b01, 0x00000537,   // mr.ne.un_640 mk.un.un_900  ceb.un.un_200 fr.un.un_B00
  0x00001c01, 0x0000052d, 0x0000122d, 0x19000a2c,   // id.un.un_200 fr.un.un_A00  hu.un.un_A00 pt.gl.un_990
  // [01d0]
  0x00004a15, 0x0000230f, 0x00005201, 0x0900130c,   // yo.un.un_700 ca.un.un_600  ha.un.un_200 bh.hi.un_530
  0x0a000b23, 0x00006801, 0x00006837, 0x0000272d,   // es.pt.un_880 ig.un.un_200  ig.un.un_B00 gd.un.un_A00
  0x00003f0f, 0x0000060f, 0x00002a37, 0x00002303,   // af.un.un_600 de.un.un_600  mt.un.un_B00 ca.un.un_300
  0x00001f0a, 0x00002515, 0x1c000d19, 0x00003542,   // cy.un.un_500 eu.un.un_700  ne.mr.un_750 zu.un.un_C00
  // [01e0]
  0x00001803, 0x0000192d, 0x0000250f, 0x0000351c,   // ga.un.un_300 gl.un.un_A00  eu.un.un_600 zu.un.un_800
  0x00002737, 0x0000060a, 0x00000837, 0x00005337,   // gd.un.un_B00 de.un.un_500  uk.un.un_B00 ht.un.un_B00
  0x16003236, 0x00002001, 0x00002915, 0x0000100a,   // bs.hr.un_AA0 sq.un.un_200  sl.un.un_700 be.un.un_500
  0x00006815, 0x1c001336, 0x19000b36, 0x0a001923,   // ig.un.un_700 bh.mr.un_AA0  es.gl.un_AA0 gl.pt.un_880
  // [01f0]
  0x09000d36, 0x00002d24, 0x09001313, 0x09001335,   // ne.hi.un_AA0 sk.un.un_900  bh.hi.un_650 bh.hi.un_A90
  0x0900130e, 0x00006424, 0x32001636, 0x09001336,   // bh.hi.un_550 lg.un.un_900  hr.bs.un_AA0 bh.hi.un_AA0
  0x0800022c, 0x00000b01, 0x0b000a22, 0x00002437,   // da.no.un_990 es.un.un_200  pt.es.un_870 yi.un.un_B00
  0x0000312d, 0x00000437, 0x2d000d13, 0x0000032d,   // az.un.un_A00 fi.un.un_B00  cs.sk.un_650 nl.un.un_A00
  // [0200]
  0x17001604, 0x00000124, 0x19000b2c, 0x0000070f,   // hr.sr.un_320 en.un.un_900  es.gl.un_990 bg.un.un_600
  0x00001601, 0x00001a15, 0x00002824, 0x00000a0a,   // hr.un.un_200 tl.un.un_700  sw.un.un_900 mk.un.un_500
  0x00002724, 0x00001b03, 0x00001106, 0x1c001e05,   // gd.un.un_900 tr.un.un_300  ro.un.un_400 ms.id.un_330
  0x0d002d35, 0x00001b24, 0x08000209, 0x00001c2d,   // sk.cs.un_A90 tr.un.un_900  da.no.un_440 id.un.un_A00
  // [0210]
  0x32001723, 0x0000062d, 0x00003b01, 0x00002706,   // sr.bs.un_880 de.un.un_A00  so.un.un_200 gd.un.un_400
  0x0000681c, 0x0000102d, 0x0000680f, 0x00000c15,   // ig.un.un_800 lt.un.un_A00  ig.un.un_600 sv.un.un_700
  0x00000803, 0x2d000d05, 0x00005306, 0x00003537,   // uk.un.un_300 cs.sk.un_330  ht.un.un_400 zu.un.un_B00
  0x0000530a, 0x32001623, 0x00001642, 0x00002a1c,   // ht.un.un_500 hr.bs.un_880  hr.un.un_C00 mt.un.un_800
  // [0220]
  0x00000f2d, 0x2d000d36, 0x00002b06, 0x09000d08,   // lv.un.un_A00 cs.sk.un_AA0  vi.un.un_400 ne.hi.un_430
  0x0000161c, 0x02000805, 0x1000062c, 0x0a000b2c,   // hr.un.un_800 no.da.un_330  de.lt.un_990 es.pt.un_990
  0x09001304, 0x0000040a, 0x32001635, 0x00000e24,   // bh.hi.un_320 fi.un.un_500  hr.bs.un_A90 is.un.un_900
  0x0d002d1a, 0x16001707, 0x00006e1c, 0x00001a0a,   // sk.cs.un_760 sr.hr.un_420  hmn.un.un_800 tl.un.un_500
  // [0230]
  0x1600172c, 0x16003222, 0x00001b15, 0x19000a1b,   // sr.hr.un_990 bs.hr.un_870  tr.un.un_700 pt.gl.un_770
  0x09000d02, 0x00003b2d, 0x00002337, 0x1c001e35,   // ne.hi.un_220 so.un.un_A00  ca.un.un_B00 ms.id.un_A90
  0x09000d04, 0x00000303, 0x0d000909, 0x09000d23,   // ne.hi.un_320 nl.un.un_300  hi.ne.un_440 ne.hi.un_880
  0x1c000913, 0x00001901, 0x1c001e0e, 0x00001b0a,   // hi.mr.un_650 gl.un.un_200  ms.id.un_550 tr.un.un_500
  // [0240]
  0x1c001e07, 0x1700161b, 0x00000106, 0x0d000902,   // ms.id.un_420 hr.sr.un_770  en.un.un_400 hi.ne.un_220
  0x1e001c34, 0x00005501, 0x00005237, 0x00006824,   // id.ms.un_A80 rw.un.un_200  ha.un.un_B00 ig.un.un_900
  0x19000b34, 0x00000c01, 0x00006b1c, 0x16001735,   // es.gl.un_A80 sv.un.un_200  ceb.un.un_800 sr.hr.un_A90
  0x00002703, 0x0000270f, 0x00003103, 0x0000202d,   // gd.un.un_300 gd.un.un_600  az.un.un_300 sq.un.un_A00
  // [0250]
  0x00001e24, 0x0b001935, 0x00003b37, 0x1c000d02,   // ms.un.un_900 gl.es.un_A90  so.un.un_B00 ne.mr.un_220
  0x00002701, 0x2d000d2c, 0x00002503, 0x0a001904,   // gd.un.un_200 cs.sk.un_990  eu.un.un_300 gl.pt.un_320
  0x00000103, 0x0000182d, 0x0d00091b, 0x00001201,   // en.un.un_300 ga.un.un_A00  hi.ne.un_770 hu.un.un_200
  0x0a001935, 0x00000e37, 0x00002a01, 0x00000e06,   // gl.pt.un_A90 is.un.un_B00  mt.un.un_200 is.un.un_400
  // [0260]
  0x0000170a, 0x1e001c2b, 0x1c000934, 0x09001c14,   // sr.un.un_500 id.ms.un_980  hi.mr.un_A80 mr.hi.un_660
  0x19000a02, 0x0d000913, 0x00002d06, 0x00006437,   // pt.gl.un_220 hi.ne.un_650  sk.un.un_400 lg.un.un_B00
  0x0a001936, 0x0000130f, 0x0a000b22, 0x00000101,   // gl.pt.un_AA0 et.un.un_600  es.pt.un_870 en.un.un_200
  0x00002a15, 0x02000823, 0x19000a09, 0x00000c0f,   // mt.un.un_700 no.da.un_880  pt.gl.un_440 sv.un.un_600
  // [0270]
  0x0900130d, 0x0a00191b, 0x00002003, 0x0000070a,   // bh.hi.un_540 gl.pt.un_770  sq.un.un_300 bg.un.un_500
  0x2d000d09, 0x00001e0a, 0x00002137, 0x00000e01,   // cs.sk.un_440 ms.un.un_500  jw.un.un_B00 is.un.un_200
  0x00002903, 0x0800021b, 0x0000250a, 0x0000350f,   // sl.un.un_300 da.no.un_770  eu.un.un_500 zu.un.un_600
  0x0000200f, 0x2d000d14, 0x00000201, 0x1c001e2a,   // sq.un.un_600 cs.sk.un_660  da.un.un_200 ms.id.un_970
  // [0280]
  0x0b001922, 0x1c001e13, 0x00000501, 0x00001a0f,   // gl.es.un_870 ms.id.un_650  fr.un.un_200 tl.un.un_600
  0x0b000a2a, 0x1c001e19, 0x00002d03, 0x0d002d21,   // pt.es.un_970 ms.id.un_750  sk.un.un_300 sk.cs.un_860
  0x1300091b, 0x0a000b08, 0x0000550a, 0x1c001335,   // hi.bh.un_770 es.pt.un_430  rw.un.un_500 bh.mr.un_A90
  0x00001924, 0x0a000b34, 0x09000d0e, 0x0000680a,   // gl.un.un_900 es.pt.un_A80  ne.hi.un_550 ig.un.un_500
  // [0290]
  0x1c001314, 0x13000936, 0x0900183f, 0x00000a03,   // bh.mr.un_660 hi.bh.un_AA0  ga.pl.un_B90 mk.un.un_300
  0x0000010a, 0x1600322c, 0x0a001934, 0x00001a06,   // iw.un.un_500 bs.hr.un_990  gl.pt.un_A80 tl.un.un_400
  0x16001705, 0x02000809, 0x00001637, 0x02000834,   // sr.hr.un_330 no.da.un_440  hr.un.un_B00 no.da.un_A80
  0x0b000a35, 0x0a00191a, 0x0000310a, 0x0a001908,   // pt.es.un_A90 gl.pt.un_760  az.un.un_500 gl.pt.un_430
  // [02a0]
  0x00001906, 0x0b00191b, 0x02000836, 0x16001723,   // gl.un.un_400 gl.es.un_770  no.da.un_AA0 sr.hr.un_880
  0x3200162c, 0x00002406, 0x00003b0a, 0x0000282d,   // hr.bs.un_990 yi.un.un_400  so.un.un_500 sw.un.un_A00
  0x00006b06, 0x00005503, 0x0000270a, 0x1600171a,   // ceb.un.un_400 rw.un.un_300  gd.un.un_500 sr.hr.un_760
  0x00002d2d, 0x0000172d, 0x00000406, 0x09000d1a,   // sk.un.un_A00 sr.un.un_A00  fi.un.un_400 ne.hi.un_760
  // [02b0]
  0x0b00192c, 0x2d000d34, 0x0000552d, 0x3200170e,   // gl.es.un_990 cs.sk.un_A80  rw.un.un_A00 sr.bs.un_550
  0x00001937, 0x00000b2d, 0x08000204, 0x0000280a,   // gl.un.un_B00 es.un.un_A00  da.no.un_320 sw.un.un_500
  0x00003503, 0x08000208, 0x00002401, 0x19000b04,   // zu.un.un_300 da.no.un_430  yi.un.un_200 es.gl.un_320
  0x00000c06, 0x00005206, 0x13000914, 0x0d00091a,   // sv.un.un_400 ha.un.un_400  hi.bh.un_660 hi.ne.un_760
  // [02c0]
  0x00001824, 0x1600321b, 0x09000d2a, 0x1e001c08,   // ga.un.un_900 bs.hr.un_770  ne.hi.un_970 id.ms.un_430
  0x0000020a, 0x2d000d21, 0x32001736, 0x0d001c14,   // da.un.un_500 cs.sk.un_860  sr.bs.un_AA0 mr.ne.un_660
  0x32001705, 0x13000d21, 0x00006803, 0x00000c0a,   // sr.bs.un_330 ne.bh.un_860  ig.un.un_300 sv.un.un_500
  0x00001c06, 0x1c001e36, 0x32001605, 0x32001709,   // id.un.un_400 ms.id.un_AA0  hr.bs.un_330 sr.bs.un_440
  // [02d0]
  0x0000242d, 0x16001708, 0x0800020e, 0x08000234,   // yi.un.un_A00 sr.hr.un_430  da.no.un_550 da.no.un_A80
  0x00001515, 0x1c00092c, 0x13000d05, 0x00002b2d,   // un.un.un_700 hi.mr.un_990  ne.bh.un_330 vi.un.un_A00
  0x3200171a, 0x09000d21, 0x00001003, 0x0d00130e,   // sr.bs.un_760 ne.hi.un_860  be.un.un_300 bh.ne.un_550
  0x1c001321, 0x0d002d2b, 0x2d000d19, 0x00001203,   // bh.mr.un_860 sk.cs.un_980  cs.sk.un_750 hu.un.un_300
  // [02e0]
  0x09000d05, 0x00002103, 0x0200082c, 0x0a000b2b,   // ne.hi.un_330 fa.un.un_300  no.da.un_990 es.pt.un_980
  0x1300092c, 0x1300091a, 0x1e001c0c, 0x19000a21,   // hi.bh.un_990 hi.bh.un_760  id.ms.un_530 pt.gl.un_860
  0x0d002d36, 0x00000203, 0x0d001309, 0x32001609,   // sk.cs.un_AA0 da.un.un_300  bh.ne.un_440 hr.bs.un_440
  0x1600322b, 0x13000d2c, 0x0b000a14, 0x13000919,   // bs.hr.un_980 ne.bh.un_990  pt.es.un_660 hi.bh.un_750
  // [02f0]
  0x0d002d12, 0x09001312, 0x0d002d2c, 0x09001307,   // sk.cs.un_640 bh.hi.un_640  sk.cs.un_990 bh.hi.un_420
  0x2d000d1a, 0x13000923, 0x19000a05, 0x00006e06,   // cs.sk.un_760 hi.bh.un_880  pt.gl.un_330 hmn.un.un_400
  0x0d000905, 0x0000292d, 0x13001c1b, 0x32001735,   // hi.ne.un_330 sl.un.un_A00  mr.bh.un_770 sr.bs.un_A90
  0x1c001e08, 0x02000813, 0x0a001914, 0x00000e0a,   // ms.id.un_430 no.da.un_650  gl.pt.un_660 is.un.un_500
  // [0300]
  0x00001603, 0x291617a0, 0x09000d1b, 0x0b001936,   // hr.un.un_300 sr.hr.sl_322  ne.hi.un_770 gl.es.un_AA0
  0x00003124, 0x0800022a, 0x13000d04, 0x0000290a,   // az.un.un_900 da.no.un_970  ne.bh.un_320 sl.un.un_500
  0x16001719, 0x02000814, 0x0000230a, 0x1c001e04,   // sr.hr.un_750 no.da.un_660  ca.un.un_500 ms.id.un_320
  0x19000b09, 0x13000913, 0x19000b0e, 0x00000f06,   // es.gl.un_440 hi.bh.un_650  es.gl.un_550 lv.un.un_400
  // [0310]
  0x00000503, 0x1c001302, 0x09001c12, 0x0800020c,   // fr.un.un_300 bh.mr.un_220  mr.hi.un_640 da.no.un_530
  0x00005301, 0x00005303, 0x00003106, 0x0a00192a,   // ht.un.un_200 ht.un.un_300  az.un.un_400 gl.pt.un_970
  0x00001706, 0x0a001921, 0x1e001c21, 0x00001f06,   // sr.un.un_400 gl.pt.un_860  id.ms.un_860 cy.un.un_400
  0x0b000a04, 0x1c001e1a, 0x0200081a, 0x1c001e0c,   // pt.es.un_320 ms.id.un_760  no.da.un_760 ms.id.un_530
  // [0320]
  0x02000835, 0x0b001904, 0x00006406, 0x00002506,   // no.da.un_A90 gl.es.un_320  lg.un.un_400 eu.un.un_400
  0x0a001922, 0x0b000a34, 0x00003f0a, 0x0d002d22,   // gl.pt.un_870 pt.es.un_A80  af.un.un_500 sk.cs.un_870
  0x00003b24, 0x09000d2b, 0x09001c04, 0x1300090e,   // so.un.un_900 ne.hi.un_980  mr.hi.un_320 hi.bh.un_550
  0x0b000a0c, 0x0d001c35, 0x0000350a, 0x0d000912,   // pt.es.un_530 mr.ne.un_A90  zu.un.un_500 hi.ne.un_640
  // [0330]
  0x00002424, 0x09000d07, 0x0000090a, 0x2d000d04,   // yi.un.un_900 ne.hi.un_420  pl.un.un_500 cs.sk.un_320
  0x0a000b07, 0x0d002d05, 0x09001c19, 0x0d002d09,   // es.pt.un_420 sk.cs.un_330  mr.hi.un_750 sk.cs.un_440
  0x19000b2b, 0x0d002d34, 0x0b000a05, 0x3200172a,   // es.gl.un_980 sk.cs.un_A80  pt.es.un_330 sr.bs.un_970
  0x00006403, 0x0000030a, 0x2d000d0e, 0x2d000d08,   // lg.un.un_300 nl.un.un_500  cs.sk.un_550 cs.sk.un_430
  // [0340]
  0x00002b1c, 0x0b001934, 0x0900131b, 0x09001c21,   // vi.un.un_800 gl.es.un_A80  bh.hi.un_770 mr.hi.un_860
  0x09001c23, 0x2d000d07, 0x19000b35, 0x3200161b,   // mr.hi.un_880 cs.sk.un_420  es.gl.un_A90 hr.bs.un_770
  0x19000b14, 0x1c000d1b, 0x09001c07, 0x1e001c0e,   // es.gl.un_660 ne.mr.un_770  mr.hi.un_420 id.ms.un_550
  0x19000a34, 0x0d000936, 0x0a000b04, 0x0d001314,   // pt.gl.un_A80 hi.ne.un_AA0  es.pt.un_320 bh.ne.un_660
  // [0350]
  0x19000b2a, 0x17001634, 0x1700161a, 0x0800020d,   // es.gl.un_970 hr.sr.un_A80  hr.sr.un_760 da.no.un_540
  0x0a000b09, 0x19000b08, 0x19000b07, 0x08000213,   // es.pt.un_440 es.gl.un_430  es.gl.un_420 da.no.un_650
  0x0a001902, 0x1e1c1bd9, 0x0a001905, 0x00005203,   // gl.pt.un_220 tr.id.ms_B87  gl.pt.un_330 ha.un.un_300
  0x0a00192c, 0x0b000a02, 0x02000808, 0x1c001e2b,   // gl.pt.un_990 pt.es.un_220  no.da.un_430 ms.id.un_980
  // [0360]
  0x0a000b02, 0x00001542, 0x0000520a, 0x09000d19,   // es.pt.un_220 un.un.un_C00  ha.un.un_500 ne.hi.un_750
  0x0d001323, 0x00000206, 0x3200171b, 0x09001322,   // bh.ne.un_880 da.un.un_400  sr.bs.un_770 bh.hi.un_870
  0x0d000923, 0x0d000904, 0x13001c14, 0x32001621,   // hi.ne.un_880 hi.ne.un_320  mr.bh.un_660 hr.bs.un_860
  0x16001714, 0x32001614, 0x09001c05, 0x0d000919,   // sr.hr.un_660 hr.bs.un_660  mr.hi.un_330 hi.ne.un_750
  // [0370]
  0x00002a03, 0x0b001905, 0x00000b03, 0x1700162b,   // mt.un.un_300 gl.es.un_330  es.un.un_300 hr.sr.un_980
  0x00000603, 0x0000241c, 0x0d002d13, 0x16003205,   // de.un.un_300 yi.un.un_800  sk.cs.un_650 bs.hr.un_330
  0x0b000a08, 0x16003235, 0x0200082b, 0x00002b01,   // pt.es.un_430 bs.hr.un_A90  no.da.un_980 vi.un.un_200
  0x00001915, 0x08000207, 0x0a00192b, 0x00002a0a,   // gl.un.un_700 da.no.un_420  gl.pt.un_980 mt.un.un_500
  // [0380]
  0x1c001e21, 0x0d002d19, 0x13000d14, 0x3200162a,   // ms.id.un_860 sk.cs.un_750  ne.bh.un_660 hr.bs.un_970
  0x0000050a, 0x1600170d, 0x00001624, 0x0b00192b,   // fr.un.un_500 sr.hr.un_540  hr.un.un_900 gl.es.un_980
  0x1c001334, 0x09001319, 0x1c000d23, 0x1c000d13,   // bh.mr.un_A80 bh.hi.un_750  ne.mr.un_880 ne.mr.un_650
  0x0d00130d, 0x0a001909, 0x19000a35, 0x00000c03,   // bh.ne.un_540 gl.pt.un_440  pt.gl.un_A90 sv.un.un_300
  // [0390]
  0x0d001c1a, 0x19000b21, 0x00001606, 0x00004a01,   // mr.ne.un_760 es.gl.un_860  hr.un.un_400 yo.un.un_200
  0x0b001923, 0x1600320d, 0x00002906, 0x0a000b1b,   // gl.es.un_880 bs.hr.un_540  sl.un.un_400 es.pt.un_770
  0x1c00131b, 0x19000a22, 0x08000214, 0x13000904,   // bh.mr.un_770 pt.gl.un_870  da.no.un_660 hi.bh.un_320
  0x0900132c, 0x1c000d08, 0x1c00091b, 0x00003b03,   // bh.hi.un_990 ne.mr.un_430  hi.mr.un_770 so.un.un_300
  // [03a0]
  0x0000180a, 0x1e001c1a, 0x00001b06, 0x2d000d35,   // ga.un.un_500 id.ms.un_760  tr.un.un_400 cs.sk.un_A90
  0x0d002d0d, 0x19000a14, 0x00000e03, 0x0a000b2a,   // sk.cs.un_540 pt.gl.un_660  is.un.un_300 es.pt.un_970
  0x19000a08, 0x13000934, 0x09001c09, 0x13000d23,   // pt.gl.un_430 hi.bh.un_A80  mr.hi.un_440 ne.bh.un_880
  0x0000012d, 0x13000d1b, 0x1c000904, 0x00003b06,   // en.un.un_A00 ne.bh.un_770  hi.mr.un_320 so.un.un_400
  // [03b0] --- double_langprob_start=03bb ---
  0x0d00131b, 0x1c000905, 0x00001524, 0x0a000b0d,   // bh.ne.un_770 hi.mr.un_330  un.un.un_900 es.pt.un_540
  0x19000a0e, 0x2d000d2b, 0x0d001312, 0x09001305,   // pt.gl.un_550 cs.sk.un_980  bh.ne.un_640 bh.hi.un_330
  0x32001604, 0x0d002d07, 0x0000190a,               // hr.bs.un_320 sk.cs.un_420  gl.un.un_500
                                                    //
  };

//  COMPILE_ASSERT(955 <= 4096, k_indirectbits_too_small);

extern const CLD2TableSummary kDeltaOcta_obj = {
  kDeltaOctaChrome0122,
  kDeltaOctaChrome0122Ind,
  kDeltaOctaChrome0122SizeOne,
  kDeltaOctaChrome0122Size,
  kDeltaOctaChrome0122KeyMask,
  kDeltaOctaChrome0122BuildDate,
  kDeltaOctaChrome0122RecognizedLangScripts,
};

static const uint32 kDeltaOctaChrome0122_2Size = 0;    // Bucket count
static const uint32 kDeltaOctaChrome0122_2KeyMask = 0xffffffff;    // Mask hash key

static const IndirectProbBucket4 kDeltaOctaChrome0122_2[kDeltaOctaChrome0122_2Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
  };
  // table_hash = ffff-ffff, unused_entries = 0 (0.00%)

static const uint32 kDeltaOctaChrome0122_2SizeOne = 2;  // One-langprob count
static const uint32 kDeltaOctaChrome0122_2IndSize = 2;  // Largest subscript
static const uint32 kDeltaOctaChrome0122_2Ind[kDeltaOctaChrome0122_2IndSize] = {
  // [0000] --- double_langprob_start=0002 ---
  0x00000000, 0x00000000,                           // -- --
                                                    //
  };

extern const CLD2TableSummary kDeltaOcta_obj2 = {
  kDeltaOctaChrome0122_2,
  kDeltaOctaChrome0122_2Ind,
  kDeltaOctaChrome0122_2SizeOne,
  kDeltaOctaChrome0122_2Size,
  kDeltaOctaChrome0122_2KeyMask,
  kDeltaOctaChrome0122BuildDate,
  kDeltaOctaChrome0122RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
