; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -enable-shrink-wrap=true -ifcvt-fn-start=1 -ifcvt-fn-stop=0 -mtriple=armv7-apple-ios \
; RUN:      | FileCheck %s --check-prefix=ARM-ENABLE
; RUN: llc %s -o - -enable-shrink-wrap=false -ifcvt-fn-start=1 -ifcvt-fn-stop=0 -mtriple=armv7-apple-ios \
; RUN:      | FileCheck %s --check-prefix=ARM-DISABLE
; RUN: llc %s -o - -enable-shrink-wrap=true -ifcvt-fn-start=1 -ifcvt-fn-stop=0 -mtriple=thumbv7-apple-ios \
; RUN:      | FileCheck %s --check-prefix=THUMB-ENABLE
; RUN: llc %s -o - -enable-shrink-wrap=false -ifcvt-fn-start=1 -ifcvt-fn-stop=0 -mtriple=thumbv7-apple-ios \
; RUN:      | FileCheck %s --check-prefix=THUMB-DISABLE

;
; Note: Lots of tests use inline asm instead of regular calls.
; This allows to have a better control on what the allocation will do.
; Otherwise, we may have spill right in the entry block, defeating
; shrink-wrapping. Moreover, some of the inline asm statements (nop)
; are here to ensure that the related paths do not end up as critical
; edges.
; Also disable the late if-converter as it makes harder to reason on
; the diffs.

; Initial motivating example: Simple diamond with a call just on one side.
; foo:
;
; Compare the arguments and jump to exit.
; No prologue needed.
; cmp r0, r1
; bge [[EXIT_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; push {r7, lr}
; mov r7, sp
;;
; Compare the arguments and jump to exit.
; After the prologue is set.
; sub sp
; cmp r0, r1
; bge [[EXIT_LABEL:LBB[0-9_]+]]
;
; Store %a in the alloca.
; push {r0}
; str r0, [sp, #-4]
; str r0, [sp]
; Set the alloca address in the second argument.
; mov r1, sp
; Set the first argument to zero.
; mov{{s?}} r0, #0
; bl{{x?}} _doSomething
;
; With shrink-wrapping, epilogue is just after the call.
; mov sp, r7
; add sp, #4
; pop{{(\.w)?}} {r7, lr}
;
; [[EXIT_LABEL]]:
;
; Without shrink-wrapping, epilogue is in the exit block.
; Epilogue code. (What we pop does not matter.)
; mov sp, r7
; add sp,
; pop {r7, pc}
;
; bx lr
define i32 @foo(i32 %a, i32 %b) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: foo:
; ARM-ENABLE:       @ %bb.0:
; ARM-ENABLE-NEXT:    cmp r0, r1
; ARM-ENABLE-NEXT:    bge LBB0_2
; ARM-ENABLE-NEXT:  @ %bb.1: @ %true
; ARM-ENABLE-NEXT:    push {r7, lr}
; ARM-ENABLE-NEXT:    mov r7, sp
; ARM-ENABLE-NEXT:    push {r0}
; ARM-ENABLE-NEXT:    mov r1, sp
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    bl _doSomething
; ARM-ENABLE-NEXT:    mov sp, r7
; ARM-ENABLE-NEXT:    pop {r7, lr}
; ARM-ENABLE-NEXT:  LBB0_2: @ %false
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: foo:
; ARM-DISABLE:       @ %bb.0:
; ARM-DISABLE-NEXT:    push {r7, lr}
; ARM-DISABLE-NEXT:    mov r7, sp
; ARM-DISABLE-NEXT:    sub sp, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, r1
; ARM-DISABLE-NEXT:    bge LBB0_2
; ARM-DISABLE-NEXT:  @ %bb.1: @ %true
; ARM-DISABLE-NEXT:    str r0, [sp]
; ARM-DISABLE-NEXT:    mov r1, sp
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    bl _doSomething
; ARM-DISABLE-NEXT:  LBB0_2: @ %false
; ARM-DISABLE-NEXT:    mov sp, r7
; ARM-DISABLE-NEXT:    pop {r7, pc}
;
; THUMB-ENABLE-LABEL: foo:
; THUMB-ENABLE:       @ %bb.0:
; THUMB-ENABLE-NEXT:    cmp r0, r1
; THUMB-ENABLE-NEXT:    bge LBB0_2
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %true
; THUMB-ENABLE-NEXT:    push {r7, lr}
; THUMB-ENABLE-NEXT:    mov r7, sp
; THUMB-ENABLE-NEXT:    str r0, [sp, #-4]!
; THUMB-ENABLE-NEXT:    mov r1, sp
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    bl _doSomething
; THUMB-ENABLE-NEXT:    add sp, #4
; THUMB-ENABLE-NEXT:    pop.w {r7, lr}
; THUMB-ENABLE-NEXT:  LBB0_2: @ %false
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: foo:
; THUMB-DISABLE:       @ %bb.0:
; THUMB-DISABLE-NEXT:    push {r7, lr}
; THUMB-DISABLE-NEXT:    mov r7, sp
; THUMB-DISABLE-NEXT:    sub sp, #4
; THUMB-DISABLE-NEXT:    cmp r0, r1
; THUMB-DISABLE-NEXT:    bge LBB0_2
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %true
; THUMB-DISABLE-NEXT:    str r0, [sp]
; THUMB-DISABLE-NEXT:    mov r1, sp
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    bl _doSomething
; THUMB-DISABLE-NEXT:  LBB0_2: @ %false
; THUMB-DISABLE-NEXT:    add sp, #4
; THUMB-DISABLE-NEXT:    pop {r7, pc}
  %tmp = alloca i32, align 4
  %tmp2 = icmp slt i32 %a, %b
  br i1 %tmp2, label %true, label %false

true:
  store i32 %a, i32* %tmp, align 4
  %tmp4 = call i32 @doSomething(i32 0, i32* %tmp)
  br label %false

false:
  %tmp.0 = phi i32 [ %tmp4, %true ], [ %a, %0 ]
  ret i32 %tmp.0
}

; Function Attrs: optsize
declare i32 @doSomething(i32, i32*)


; Check that we do not perform the restore inside the loop whereas the save
; is outside.
; freqSaveAndRestoreOutsideLoop:
;
; Shrink-wrapping allows to skip the prologue in the else case.
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; Make sure we save the CSR used in the inline asm: r4.
; push {r4, r7, lr}
; add r7, sp, #4
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; SUM is in r0 because it is coalesced with the second
; argument on the else path.
; mov{{s?}} [[SUM:r0]], #0
; mov{{s?}} [[IV:r[0-9]+]], #10
;
; Next BB.
; [[LOOP:LBB[0-9_]+]]: @ %for.body
; mov{{(\.w)?}} [[TMP:r[0-9]+]], #1
; add [[SUM]], [[TMP]], [[SUM]]
; add [[SUM]], [[TMP]]
; subs [[IV]], [[IV]], #1
; subs [[IV]], #1
; bne [[LOOP]]
;
; Next BB.
; SUM << 3.
; lsl{{s?}} [[SUM]], [[SUM]], #3
; pop {r4, r7, pc}
;
; Duplicated epilogue.
; pop {r4, r7, pc}
;
; [[ELSE_LABEL]]: @ %if.else
; Shift second argument by one and store into returned register.
; lsl{{s?}} r0, r1, #1
; pop {r4, r7, pc}
;
; bx lr
define i32 @freqSaveAndRestoreOutsideLoop(i32 %cond, i32 %N) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: freqSaveAndRestoreOutsideLoop:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    beq LBB1_4
; ARM-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    mov r1, #10
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:  LBB1_2: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r2, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    add r0, r2, r0
; ARM-ENABLE-NEXT:    subs r1, r1, #1
; ARM-ENABLE-NEXT:    bne LBB1_2
; ARM-ENABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-ENABLE-NEXT:    lsl r0, r0, #3
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-NEXT:  LBB1_4: @ %if.else
; ARM-ENABLE-NEXT:    lsl r0, r1, #1
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: freqSaveAndRestoreOutsideLoop:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    beq LBB1_4
; ARM-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    mov r1, #10
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:  LBB1_2: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r2, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    add r0, r2, r0
; ARM-DISABLE-NEXT:    subs r1, r1, #1
; ARM-DISABLE-NEXT:    bne LBB1_2
; ARM-DISABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-DISABLE-NEXT:    lsl r0, r0, #3
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:  LBB1_4: @ %if.else
; ARM-DISABLE-NEXT:    lsl r0, r1, #1
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-ENABLE-LABEL: freqSaveAndRestoreOutsideLoop:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbz r0, LBB1_4
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    movs r1, #10
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:  LBB1_2: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r2, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    add r0, r2
; THUMB-ENABLE-NEXT:    subs r1, #1
; THUMB-ENABLE-NEXT:    bne LBB1_2
; THUMB-ENABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-ENABLE-NEXT:    lsls r0, r0, #3
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
; THUMB-ENABLE-NEXT:  LBB1_4: @ %if.else
; THUMB-ENABLE-NEXT:    lsls r0, r1, #1
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: freqSaveAndRestoreOutsideLoop:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    cbz r0, LBB1_4
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    movs r1, #10
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:  LBB1_2: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r2, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    add r0, r2
; THUMB-DISABLE-NEXT:    subs r1, #1
; THUMB-DISABLE-NEXT:    bne LBB1_2
; THUMB-DISABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-DISABLE-NEXT:    lsls r0, r0, #3
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:  LBB1_4: @ %if.else
; THUMB-DISABLE-NEXT:    lsls r0, r1, #1
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %if.else, label %for.preheader

for.preheader:
  tail call void asm "nop", ""()
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %i.05 = phi i32 [ %inc, %for.body ], [ 0, %for.preheader ]
  %sum.04 = phi i32 [ %add, %for.body ], [ 0, %for.preheader ]
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.04
  %inc = add nuw nsw i32 %i.05, 1
  %exitcond = icmp eq i32 %inc, 10
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  %shl = shl i32 %add, 3
  br label %if.end

if.else:                                          ; preds = %entry
  %mul = shl nsw i32 %N, 1
  br label %if.end

if.end:                                           ; preds = %if.else, %for.end
  %sum.1 = phi i32 [ %shl, %for.end ], [ %mul, %if.else ]
  ret i32 %sum.1
}

declare i32 @something(...)

; Check that we do not perform the shrink-wrapping inside the loop even
; though that would be legal. The cost model must prevent that.
; freqSaveAndRestoreOutsideLoop2:
; Prologue code.
; Make sure we save the CSR used in the inline asm: r4.
; push {r4
; mov{{s?}} [[SUM:r0]], #0
; mov{{s?}} [[IV:r[0-9]+]], #10
; nop
; Next BB.
; [[LOOP_LABEL:LBB[0-9_]+]]: @ %for.body
; mov{{(\.w)?}} [[TMP:r[0-9]+]], #1
; add [[SUM]], [[TMP]], [[SUM]]
; add [[SUM]], [[TMP]]
; subs [[IV]], [[IV]], #1
; subs [[IV]], #1
; bne [[LOOP_LABEL]]
; Next BB.
; @ %for.exit
; nop
; pop {r4
define i32 @freqSaveAndRestoreOutsideLoop2(i32 %cond) "frame-pointer"="all" {
; ARM-LABEL: freqSaveAndRestoreOutsideLoop2:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    push {r4, r7, lr}
; ARM-NEXT:    add r7, sp, #4
; ARM-NEXT:    mov r0, #0
; ARM-NEXT:    mov r1, #10
; ARM-NEXT:    @ InlineAsm Start
; ARM-NEXT:    nop
; ARM-NEXT:    @ InlineAsm End
; ARM-NEXT:  LBB2_1: @ %for.body
; ARM-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-NEXT:    @ InlineAsm Start
; ARM-NEXT:    mov r2, #1
; ARM-NEXT:    @ InlineAsm End
; ARM-NEXT:    add r0, r2, r0
; ARM-NEXT:    subs r1, r1, #1
; ARM-NEXT:    bne LBB2_1
; ARM-NEXT:  @ %bb.2: @ %for.exit
; ARM-NEXT:    @ InlineAsm Start
; ARM-NEXT:    nop
; ARM-NEXT:    @ InlineAsm End
; ARM-NEXT:    pop {r4, r7, pc}
;
; THUMB-LABEL: freqSaveAndRestoreOutsideLoop2:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    push {r4, r7, lr}
; THUMB-NEXT:    add r7, sp, #4
; THUMB-NEXT:    movs r0, #0
; THUMB-NEXT:    movs r1, #10
; THUMB-NEXT:    @ InlineAsm Start
; THUMB-NEXT:    nop
; THUMB-NEXT:    @ InlineAsm End
; THUMB-NEXT:  LBB2_1: @ %for.body
; THUMB-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-NEXT:    @ InlineAsm Start
; THUMB-NEXT:    mov.w r2, #1
; THUMB-NEXT:    @ InlineAsm End
; THUMB-NEXT:    add r0, r2
; THUMB-NEXT:    subs r1, #1
; THUMB-NEXT:    bne LBB2_1
; THUMB-NEXT:  @ %bb.2: @ %for.exit
; THUMB-NEXT:    @ InlineAsm Start
; THUMB-NEXT:    nop
; THUMB-NEXT:    @ InlineAsm End
; THUMB-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-LABEL: freqSaveAndRestoreOutsideLoop2:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    mov r1, #10
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:  LBB2_1: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r2, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    add r0, r2, r0
; ARM-ENABLE-NEXT:    subs r1, r1, #1
; ARM-ENABLE-NEXT:    bne LBB2_1
; ARM-ENABLE-NEXT:  @ %bb.2: @ %for.exit
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
;
; ARM-DISABLE-LABEL: freqSaveAndRestoreOutsideLoop2:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    mov r1, #10
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:  LBB2_1: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r2, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    add r0, r2, r0
; ARM-DISABLE-NEXT:    subs r1, r1, #1
; ARM-DISABLE-NEXT:    bne LBB2_1
; ARM-DISABLE-NEXT:  @ %bb.2: @ %for.exit
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-ENABLE-LABEL: freqSaveAndRestoreOutsideLoop2:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    movs r1, #10
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:  LBB2_1: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r2, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    add r0, r2
; THUMB-ENABLE-NEXT:    subs r1, #1
; THUMB-ENABLE-NEXT:    bne LBB2_1
; THUMB-ENABLE-NEXT:  @ %bb.2: @ %for.exit
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-DISABLE-LABEL: freqSaveAndRestoreOutsideLoop2:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    movs r1, #10
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:  LBB2_1: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r2, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    add r0, r2
; THUMB-DISABLE-NEXT:    subs r1, #1
; THUMB-DISABLE-NEXT:    bne LBB2_1
; THUMB-DISABLE-NEXT:  @ %bb.2: @ %for.exit
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
entry:
  br label %for.preheader

for.preheader:
  tail call void asm "nop", ""()
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.04 = phi i32 [ 0, %for.preheader ], [ %inc, %for.body ]
  %sum.03 = phi i32 [ 0, %for.preheader ], [ %add, %for.body ]
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.03
  %inc = add nuw nsw i32 %i.04, 1
  %exitcond = icmp eq i32 %inc, 10
  br i1 %exitcond, label %for.exit, label %for.body

for.exit:
  tail call void asm "nop", ""()
  br label %for.end

for.end:                                          ; preds = %for.body
  ret i32 %add
}

; Check with a more complex case that we do not have save within the loop and
; restore outside.
; loopInfoSaveOutsideLoop:
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; Make sure we save the CSR used in the inline asm: r4.
; push {r4, r7, lr}
; add r7, sp, #4
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; SUM is in r0 because it is coalesced with the second
; argument on the else path.
; mov{{s?}} [[SUM:r0]], #0
; mov{{s?}} [[IV:r[0-9]+]], #10
;
; Next BB.
; [[LOOP:LBB[0-9_]+]]: @ %for.body
; mov{{(\.w)?}} [[TMP:r[0-9]+]], #1
; add [[SUM]], [[TMP]], [[SUM]]
; add [[SUM]], [[TMP]]
; subs [[IV]], [[IV]], #1
; subs [[IV]], #1
; bne [[LOOP]]
;
; Next BB.
; SUM << 3.
; lsl{{s?}} [[SUM]], [[SUM]], #3
; pop {r4, r7, pc}
;
; Duplicated epilogue.
; pop {r4, r7, pc}
;
; [[ELSE_LABEL]]: @ %if.else
; Shift second argument by one and store into returned register.
; lsl{{s?}} r0, r1, #1
; pop {r4, r7, pc}
;
; bx lr
define i32 @loopInfoSaveOutsideLoop(i32 %cond, i32 %N) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: loopInfoSaveOutsideLoop:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    beq LBB3_4
; ARM-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    mov r1, #10
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:  LBB3_2: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r2, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    add r0, r2, r0
; ARM-ENABLE-NEXT:    subs r1, r1, #1
; ARM-ENABLE-NEXT:    bne LBB3_2
; ARM-ENABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-ENABLE-NEXT:    lsl r0, r0, #3
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-NEXT:  LBB3_4: @ %if.else
; ARM-ENABLE-NEXT:    lsl r0, r1, #1
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: loopInfoSaveOutsideLoop:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    beq LBB3_4
; ARM-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    mov r1, #10
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:  LBB3_2: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r2, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    add r0, r2, r0
; ARM-DISABLE-NEXT:    subs r1, r1, #1
; ARM-DISABLE-NEXT:    bne LBB3_2
; ARM-DISABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-DISABLE-NEXT:    lsl r0, r0, #3
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:  LBB3_4: @ %if.else
; ARM-DISABLE-NEXT:    lsl r0, r1, #1
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-ENABLE-LABEL: loopInfoSaveOutsideLoop:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbz r0, LBB3_4
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    movs r1, #10
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:  LBB3_2: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r2, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    add r0, r2
; THUMB-ENABLE-NEXT:    subs r1, #1
; THUMB-ENABLE-NEXT:    bne LBB3_2
; THUMB-ENABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-ENABLE-NEXT:    lsls r0, r0, #3
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
; THUMB-ENABLE-NEXT:  LBB3_4: @ %if.else
; THUMB-ENABLE-NEXT:    lsls r0, r1, #1
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: loopInfoSaveOutsideLoop:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    cbz r0, LBB3_4
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    movs r1, #10
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:  LBB3_2: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r2, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    add r0, r2
; THUMB-DISABLE-NEXT:    subs r1, #1
; THUMB-DISABLE-NEXT:    bne LBB3_2
; THUMB-DISABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-DISABLE-NEXT:    lsls r0, r0, #3
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:  LBB3_4: @ %if.else
; THUMB-DISABLE-NEXT:    lsls r0, r1, #1
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %if.else, label %for.preheader

for.preheader:
  tail call void asm "nop", ""()
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %i.05 = phi i32 [ %inc, %for.body ], [ 0, %for.preheader ]
  %sum.04 = phi i32 [ %add, %for.body ], [ 0, %for.preheader ]
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.04
  %inc = add nuw nsw i32 %i.05, 1
  %exitcond = icmp eq i32 %inc, 10
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  tail call void asm "nop", "~{r4}"()
  %shl = shl i32 %add, 3
  br label %if.end

if.else:                                          ; preds = %entry
  %mul = shl nsw i32 %N, 1
  br label %if.end

if.end:                                           ; preds = %if.else, %for.end
  %sum.1 = phi i32 [ %shl, %for.end ], [ %mul, %if.else ]
  ret i32 %sum.1
}

declare void @somethingElse(...)

; Check with a more complex case that we do not have restore within the loop and
; save outside.
; loopInfoRestoreOutsideLoop:
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; Make sure we save the CSR used in the inline asm: r4.
; push {r4, r7, lr}
; add r7, sp, #4
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; SUM is in r0 because it is coalesced with the second
; argument on the else path.
; mov{{s?}} [[SUM:r0]], #0
; mov{{s?}} [[IV:r[0-9]+]], #10
;
; Next BB.
; [[LOOP:LBB[0-9_]+]]: @ %for.body
; mov{{(\.w)?}} [[TMP:r[0-9]+]], #1
; add [[SUM]], [[TMP]], [[SUM]]
; add [[SUM]], [[TMP]]
; subs [[IV]], [[IV]], #1
; subs [[IV]], #1
; bne [[LOOP]]
;
; Next BB.
; SUM << 3.
; lsl{{s?}} [[SUM]], [[SUM]], #3
; pop {r4, r7, pc}
;
; Duplicated epilogue.
; pop {r4, r7, pc}
;
; [[ELSE_LABEL]]: @ %if.else
; Shift second argument by one and store into returned register.
; lsl{{s?}} r0, r1, #1
; pop {r4, r7, pc}
;
; bx lr
define i32 @loopInfoRestoreOutsideLoop(i32 %cond, i32 %N) "frame-pointer"="all" nounwind {
; ARM-ENABLE-LABEL: loopInfoRestoreOutsideLoop:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    beq LBB4_4
; ARM-ENABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    mov r1, #10
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:  LBB4_2: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r2, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    add r0, r2, r0
; ARM-ENABLE-NEXT:    subs r1, r1, #1
; ARM-ENABLE-NEXT:    bne LBB4_2
; ARM-ENABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-ENABLE-NEXT:    lsl r0, r0, #3
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-NEXT:  LBB4_4: @ %if.else
; ARM-ENABLE-NEXT:    lsl r0, r1, #1
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: loopInfoRestoreOutsideLoop:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    beq LBB4_4
; ARM-DISABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    mov r1, #10
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:  LBB4_2: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r2, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    add r0, r2, r0
; ARM-DISABLE-NEXT:    subs r1, r1, #1
; ARM-DISABLE-NEXT:    bne LBB4_2
; ARM-DISABLE-NEXT:  @ %bb.3: @ %for.end
; ARM-DISABLE-NEXT:    lsl r0, r0, #3
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:  LBB4_4: @ %if.else
; ARM-DISABLE-NEXT:    lsl r0, r1, #1
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-ENABLE-LABEL: loopInfoRestoreOutsideLoop:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbz r0, LBB4_4
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    movs r1, #10
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:  LBB4_2: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r2, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    add r0, r2
; THUMB-ENABLE-NEXT:    subs r1, #1
; THUMB-ENABLE-NEXT:    bne LBB4_2
; THUMB-ENABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-ENABLE-NEXT:    lsls r0, r0, #3
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
; THUMB-ENABLE-NEXT:  LBB4_4: @ %if.else
; THUMB-ENABLE-NEXT:    lsls r0, r1, #1
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: loopInfoRestoreOutsideLoop:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    cbz r0, LBB4_4
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    movs r1, #10
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:  LBB4_2: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r2, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    add r0, r2
; THUMB-DISABLE-NEXT:    subs r1, #1
; THUMB-DISABLE-NEXT:    bne LBB4_2
; THUMB-DISABLE-NEXT:  @ %bb.3: @ %for.end
; THUMB-DISABLE-NEXT:    lsls r0, r0, #3
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:  LBB4_4: @ %if.else
; THUMB-DISABLE-NEXT:    lsls r0, r1, #1
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %if.else, label %if.then

if.then:                                          ; preds = %entry
  tail call void asm "nop", "~{r4}"()
  br label %for.body

for.body:                                         ; preds = %for.body, %if.then
  %i.05 = phi i32 [ 0, %if.then ], [ %inc, %for.body ]
  %sum.04 = phi i32 [ 0, %if.then ], [ %add, %for.body ]
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.04
  %inc = add nuw nsw i32 %i.05, 1
  %exitcond = icmp eq i32 %inc, 10
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  %shl = shl i32 %add, 3
  br label %if.end

if.else:                                          ; preds = %entry
  %mul = shl nsw i32 %N, 1
  br label %if.end

if.end:                                           ; preds = %if.else, %for.end
  %sum.1 = phi i32 [ %shl, %for.end ], [ %mul, %if.else ]
  ret i32 %sum.1
}

; Check that we handle function with no frame information correctly.
; emptyFrame:
; @ %entry
; mov{{s?}} r0, #0
; bx lr
define i32 @emptyFrame() {
; ARM-LABEL: emptyFrame:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    mov r0, #0
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: emptyFrame:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r0, #0
; THUMB-NEXT:    bx lr
; ARM-ENABLE-LABEL: emptyFrame:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: emptyFrame:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    bx lr
;
; THUMB-ENABLE-LABEL: emptyFrame:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: emptyFrame:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    bx lr
entry:
  ret i32 0
}

; Check that we handle inline asm correctly.
; inlineAsm:
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; Make sure we save the CSR used in the inline asm: r4.
; push {r4, r7, lr}
; add r7, sp, #4
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; mov{{s?}} [[IV:r[0-9]+]], #10
;
; Next BB.
; [[LOOP:LBB[0-9_]+]]: @ %for.body
; subs [[IV]], [[IV]], #1
; subs [[IV]], #1
; add{{(\.w)?}} r4, r4, #1
; bne [[LOOP]]
;
; Next BB.
; mov{{s?}} r0, #0
;
; Duplicated epilogue.
; pop {r4, r7, pc}
;
; [[ELSE_LABEL]]: @ %if.else
; Shift second argument by one and store into returned register.
; lsl{{s?}} r0, r1, #1
; pop {r4, r7, pc}
;
; bx lr
define i32 @inlineAsm(i32 %cond, i32 %N) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: inlineAsm:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    beq LBB6_4
; ARM-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    mov r0, #10
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:  LBB6_2: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    subs r0, r0, #1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    add r4, r4, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    bne LBB6_2
; ARM-ENABLE-NEXT:  @ %bb.3: @ %for.exit
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    nop
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-NEXT:  LBB6_4: @ %if.else
; ARM-ENABLE-NEXT:    lsl r0, r1, #1
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: inlineAsm:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    beq LBB6_4
; ARM-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; ARM-DISABLE-NEXT:    mov r0, #10
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:  LBB6_2: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    subs r0, r0, #1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    add r4, r4, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    bne LBB6_2
; ARM-DISABLE-NEXT:  @ %bb.3: @ %for.exit
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    nop
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:  LBB6_4: @ %if.else
; ARM-DISABLE-NEXT:    lsl r0, r1, #1
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
;
; THUMB-ENABLE-LABEL: inlineAsm:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbz r0, LBB6_4
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    movs r0, #10
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:  LBB6_2: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    subs r0, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    add.w r4, r4, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    bne LBB6_2
; THUMB-ENABLE-NEXT:  @ %bb.3: @ %for.exit
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    nop
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
; THUMB-ENABLE-NEXT:  LBB6_4: @ %if.else
; THUMB-ENABLE-NEXT:    lsls r0, r1, #1
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: inlineAsm:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    cbz r0, LBB6_4
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %for.preheader
; THUMB-DISABLE-NEXT:    movs r0, #10
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:  LBB6_2: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    subs r0, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    add.w r4, r4, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    bne LBB6_2
; THUMB-DISABLE-NEXT:  @ %bb.3: @ %for.exit
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    nop
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:  LBB6_4: @ %if.else
; THUMB-DISABLE-NEXT:    lsls r0, r1, #1
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %if.else, label %for.preheader

for.preheader:
  tail call void asm "nop", ""()
  br label %for.body

for.body:                                         ; preds = %entry, %for.body
  %i.03 = phi i32 [ %inc, %for.body ], [ 0, %for.preheader ]
  tail call void asm sideeffect "add r4, #1", "~{r4}"()
  %inc = add nuw nsw i32 %i.03, 1
  %exitcond = icmp eq i32 %inc, 10
  br i1 %exitcond, label %for.exit, label %for.body

for.exit:
  tail call void asm "nop", ""()
  br label %if.end

if.else:                                          ; preds = %entry
  %mul = shl nsw i32 %N, 1
  br label %if.end

if.end:                                           ; preds = %for.body, %if.else
  %sum.0 = phi i32 [ %mul, %if.else ], [ 0, %for.exit ]
  ret i32 %sum.0
}

; Check that we handle calls to variadic functions correctly.
; callVariadicFunc:
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Prologue code.
; push {r7, lr}
; mov r7, sp
; sub sp, {{(sp, )?}}#12
;
; cmp r0, #0
; beq [[ELSE_LABEL:LBB[0-9_]+]]
; cbz r0, [[ELSE_LABEL:LBB[0-9_]+]]
;
; Setup of the varags.
; mov r0, r1
; mov r2, r1
; mov r3, r1
; str r1, [sp]
; str r1, [sp, #4]
; strd r1, r1, [sp]
; str r1, [sp, #8]
; bl{{x?}} _someVariadicFunc
; lsl{{s?}} r0, r0, #3
; mov sp, r7
; add sp, #12
; pop {r7, pc}
;
; [[ELSE_LABEL]]: @ %if.else
; Shift second argument by one and store into returned register.
; lsl{{s?}} r0, r1, #1
;
; Epilogue code.
; bx lr
;
; mov sp, r7
; add sp, #12
; pop {r7, pc}
define i32 @callVariadicFunc(i32 %cond, i32 %N) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: callVariadicFunc:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    beq LBB7_2
; ARM-ENABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-ENABLE-NEXT:    push {r7, lr}
; ARM-ENABLE-NEXT:    mov r7, sp
; ARM-ENABLE-NEXT:    sub sp, sp, #12
; ARM-ENABLE-NEXT:    mov r0, r1
; ARM-ENABLE-NEXT:    mov r2, r1
; ARM-ENABLE-NEXT:    mov r3, r1
; ARM-ENABLE-NEXT:    str r1, [sp]
; ARM-ENABLE-NEXT:    str r1, [sp, #4]
; ARM-ENABLE-NEXT:    str r1, [sp, #8]
; ARM-ENABLE-NEXT:    bl _someVariadicFunc
; ARM-ENABLE-NEXT:    lsl r0, r0, #3
; ARM-ENABLE-NEXT:    mov sp, r7
; ARM-ENABLE-NEXT:    pop {r7, pc}
; ARM-ENABLE-NEXT:  LBB7_2: @ %if.else
; ARM-ENABLE-NEXT:    lsl r0, r1, #1
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: callVariadicFunc:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r7, lr}
; ARM-DISABLE-NEXT:    mov r7, sp
; ARM-DISABLE-NEXT:    sub sp, sp, #12
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    beq LBB7_2
; ARM-DISABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-DISABLE-NEXT:    mov r0, r1
; ARM-DISABLE-NEXT:    mov r2, r1
; ARM-DISABLE-NEXT:    mov r3, r1
; ARM-DISABLE-NEXT:    str r1, [sp]
; ARM-DISABLE-NEXT:    str r1, [sp, #4]
; ARM-DISABLE-NEXT:    str r1, [sp, #8]
; ARM-DISABLE-NEXT:    bl _someVariadicFunc
; ARM-DISABLE-NEXT:    lsl r0, r0, #3
; ARM-DISABLE-NEXT:    mov sp, r7
; ARM-DISABLE-NEXT:    pop {r7, pc}
; ARM-DISABLE-NEXT:  LBB7_2: @ %if.else
; ARM-DISABLE-NEXT:    lsl r0, r1, #1
; ARM-DISABLE-NEXT:    mov sp, r7
; ARM-DISABLE-NEXT:    pop {r7, pc}
;
; THUMB-ENABLE-LABEL: callVariadicFunc:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbz r0, LBB7_2
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-ENABLE-NEXT:    push {r7, lr}
; THUMB-ENABLE-NEXT:    mov r7, sp
; THUMB-ENABLE-NEXT:    sub sp, #12
; THUMB-ENABLE-NEXT:    mov r0, r1
; THUMB-ENABLE-NEXT:    mov r2, r1
; THUMB-ENABLE-NEXT:    mov r3, r1
; THUMB-ENABLE-NEXT:    strd r1, r1, [sp]
; THUMB-ENABLE-NEXT:    str r1, [sp, #8]
; THUMB-ENABLE-NEXT:    bl _someVariadicFunc
; THUMB-ENABLE-NEXT:    lsls r0, r0, #3
; THUMB-ENABLE-NEXT:    add sp, #12
; THUMB-ENABLE-NEXT:    pop {r7, pc}
; THUMB-ENABLE-NEXT:  LBB7_2: @ %if.else
; THUMB-ENABLE-NEXT:    lsls r0, r1, #1
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: callVariadicFunc:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r7, lr}
; THUMB-DISABLE-NEXT:    mov r7, sp
; THUMB-DISABLE-NEXT:    sub sp, #12
; THUMB-DISABLE-NEXT:    cbz r0, LBB7_2
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-DISABLE-NEXT:    mov r0, r1
; THUMB-DISABLE-NEXT:    mov r2, r1
; THUMB-DISABLE-NEXT:    mov r3, r1
; THUMB-DISABLE-NEXT:    strd r1, r1, [sp]
; THUMB-DISABLE-NEXT:    str r1, [sp, #8]
; THUMB-DISABLE-NEXT:    bl _someVariadicFunc
; THUMB-DISABLE-NEXT:    lsls r0, r0, #3
; THUMB-DISABLE-NEXT:    add sp, #12
; THUMB-DISABLE-NEXT:    pop {r7, pc}
; THUMB-DISABLE-NEXT:  LBB7_2: @ %if.else
; THUMB-DISABLE-NEXT:    lsls r0, r1, #1
; THUMB-DISABLE-NEXT:    add sp, #12
; THUMB-DISABLE-NEXT:    pop {r7, pc}
entry:
  %tobool = icmp eq i32 %cond, 0
  br i1 %tobool, label %if.else, label %if.then

if.then:                                          ; preds = %entry
  %call = tail call i32 (i32, ...) @someVariadicFunc(i32 %N, i32 %N, i32 %N, i32 %N, i32 %N, i32 %N, i32 %N)
  %shl = shl i32 %call, 3
  br label %if.end

if.else:                                          ; preds = %entry
  %mul = shl nsw i32 %N, 1
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %sum.0 = phi i32 [ %shl, %if.then ], [ %mul, %if.else ]
  ret i32 %sum.0
}

declare i32 @someVariadicFunc(i32, ...)

; Make sure we do not insert unreachable code after noreturn function.
; Although this is not incorrect to insert such code, it is useless
; and it hurts the binary size.
;
; noreturn:
; push
; cmp r0, #0
; cmp r0, #0
; bne [[ABORT:LBB[0-9_]+]]
; bne [[ABORT:LBB[0-9_]+]]
; cbnz r0,  [[ABORT:LBB[0-9_]+]]
; cbnz r0,  [[ABORT:LBB[0-9_]+]]

;
; mov{{s?}} r0, #42
;
; bx lr
;
; pop
;;
; [[ABORT]]: @ %if.abort
;
; push
;
; bl{{x?}} _abort
; pop
define i32 @noreturn(i8 signext %bad_thing) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: noreturn:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    bne LBB8_2
; ARM-ENABLE-NEXT:  @ %bb.1: @ %if.end
; ARM-ENABLE-NEXT:    mov r0, #42
; ARM-ENABLE-NEXT:    bx lr
; ARM-ENABLE-NEXT:  LBB8_2: @ %if.abort
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r0, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    bl _abort
;
; ARM-DISABLE-LABEL: noreturn:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    bne LBB8_2
; ARM-DISABLE-NEXT:  @ %bb.1: @ %if.end
; ARM-DISABLE-NEXT:    mov r0, #42
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:  LBB8_2: @ %if.abort
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r0, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    bl _abort
;
; THUMB-ENABLE-LABEL: noreturn:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    cbnz r0, LBB8_2
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %if.end
; THUMB-ENABLE-NEXT:    movs r0, #42
; THUMB-ENABLE-NEXT:    bx lr
; THUMB-ENABLE-NEXT:  LBB8_2: @ %if.abort
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r0, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    bl _abort
;
; THUMB-DISABLE-LABEL: noreturn:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    cbnz r0, LBB8_2
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %if.end
; THUMB-DISABLE-NEXT:    movs r0, #42
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:  LBB8_2: @ %if.abort
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r0, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    bl _abort
entry:
  %tobool = icmp eq i8 %bad_thing, 0
  br i1 %tobool, label %if.end, label %if.abort

if.abort:
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  tail call void @abort() #0
  unreachable

if.end:
  ret i32 42
}

declare void @abort() #0

attributes #0 = { noreturn nounwind }

; Make sure that we handle infinite loops properly When checking that the Save
; and Restore blocks are control flow equivalent, the loop searches for the
; immediate (post) dominator for the (restore) save blocks. When either the Save
; or Restore block is located in an infinite loop the only immediate (post)
; dominator is itself. In this case, we cannot perform shrink wrapping, but we
; should return gracefully and continue compilation.
; The only condition for this test is the compilation finishes correctly.
; infiniteloop
; pop
define void @infiniteloop() "frame-pointer"="all" {
; ARM-LABEL: infiniteloop:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    push {r4, r5, r7, lr}
; ARM-NEXT:    add r7, sp, #8
; ARM-NEXT:    mov r0, #0
; ARM-NEXT:    cmp r0, #0
; ARM-NEXT:    bne LBB9_3
; ARM-NEXT:  @ %bb.1: @ %if.then
; ARM-NEXT:    sub r1, sp, #16
; ARM-NEXT:    mov sp, r1
; ARM-NEXT:  LBB9_2: @ %for.body
; ARM-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-NEXT:    @ InlineAsm Start
; ARM-NEXT:    mov r2, #1
; ARM-NEXT:    @ InlineAsm End
; ARM-NEXT:    add r0, r2, r0
; ARM-NEXT:    str r0, [r1]
; ARM-NEXT:    b LBB9_2
; ARM-NEXT:  LBB9_3: @ %if.end
; ARM-NEXT:    sub sp, r7, #8
; ARM-NEXT:    pop {r4, r5, r7, pc}
;
; THUMB-LABEL: infiniteloop:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    push {r4, r5, r7, lr}
; THUMB-NEXT:    add r7, sp, #8
; THUMB-NEXT:    movs r0, #0
; THUMB-NEXT:    cbnz r0, LBB9_3
; THUMB-NEXT:  @ %bb.1: @ %if.then
; THUMB-NEXT:    sub.w r0, sp, #16
; THUMB-NEXT:    mov sp, r0
; THUMB-NEXT:    movs r1, #0
; THUMB-NEXT:  LBB9_2: @ %for.body
; THUMB-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-NEXT:    @ InlineAsm Start
; THUMB-NEXT:    mov.w r2, #1
; THUMB-NEXT:    @ InlineAsm End
; THUMB-NEXT:    add r1, r2
; THUMB-NEXT:    str r1, [r0]
; THUMB-NEXT:    b LBB9_2
; THUMB-NEXT:  LBB9_3: @ %if.end
; THUMB-NEXT:    sub.w r4, r7, #8
; THUMB-NEXT:    mov sp, r4
; THUMB-NEXT:    pop {r4, r5, r7, pc}
; ARM-ENABLE-LABEL: infiniteloop:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    push {r4, r5, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #8
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    bne LBB9_3
; ARM-ENABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-ENABLE-NEXT:    sub r1, sp, #16
; ARM-ENABLE-NEXT:    mov sp, r1
; ARM-ENABLE-NEXT:  LBB9_2: @ %for.body
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    @ InlineAsm Start
; ARM-ENABLE-NEXT:    mov r2, #1
; ARM-ENABLE-NEXT:    @ InlineAsm End
; ARM-ENABLE-NEXT:    add r0, r2, r0
; ARM-ENABLE-NEXT:    str r0, [r1]
; ARM-ENABLE-NEXT:    b LBB9_2
; ARM-ENABLE-NEXT:  LBB9_3: @ %if.end
; ARM-ENABLE-NEXT:    sub sp, r7, #8
; ARM-ENABLE-NEXT:    pop {r4, r5, r7, pc}
;
; ARM-DISABLE-LABEL: infiniteloop:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    push {r4, r5, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #8
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    bne LBB9_3
; ARM-DISABLE-NEXT:  @ %bb.1: @ %if.then
; ARM-DISABLE-NEXT:    sub r1, sp, #16
; ARM-DISABLE-NEXT:    mov sp, r1
; ARM-DISABLE-NEXT:  LBB9_2: @ %for.body
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    @ InlineAsm Start
; ARM-DISABLE-NEXT:    mov r2, #1
; ARM-DISABLE-NEXT:    @ InlineAsm End
; ARM-DISABLE-NEXT:    add r0, r2, r0
; ARM-DISABLE-NEXT:    str r0, [r1]
; ARM-DISABLE-NEXT:    b LBB9_2
; ARM-DISABLE-NEXT:  LBB9_3: @ %if.end
; ARM-DISABLE-NEXT:    sub sp, r7, #8
; ARM-DISABLE-NEXT:    pop {r4, r5, r7, pc}
;
; THUMB-ENABLE-LABEL: infiniteloop:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    push {r4, r5, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #8
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    cbnz r0, LBB9_3
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-ENABLE-NEXT:    sub.w r0, sp, #16
; THUMB-ENABLE-NEXT:    mov sp, r0
; THUMB-ENABLE-NEXT:    movs r1, #0
; THUMB-ENABLE-NEXT:  LBB9_2: @ %for.body
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    @ InlineAsm Start
; THUMB-ENABLE-NEXT:    mov.w r2, #1
; THUMB-ENABLE-NEXT:    @ InlineAsm End
; THUMB-ENABLE-NEXT:    add r1, r2
; THUMB-ENABLE-NEXT:    str r1, [r0]
; THUMB-ENABLE-NEXT:    b LBB9_2
; THUMB-ENABLE-NEXT:  LBB9_3: @ %if.end
; THUMB-ENABLE-NEXT:    sub.w r4, r7, #8
; THUMB-ENABLE-NEXT:    mov sp, r4
; THUMB-ENABLE-NEXT:    pop {r4, r5, r7, pc}
;
; THUMB-DISABLE-LABEL: infiniteloop:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    push {r4, r5, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #8
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    cbnz r0, LBB9_3
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %if.then
; THUMB-DISABLE-NEXT:    sub.w r0, sp, #16
; THUMB-DISABLE-NEXT:    mov sp, r0
; THUMB-DISABLE-NEXT:    movs r1, #0
; THUMB-DISABLE-NEXT:  LBB9_2: @ %for.body
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    @ InlineAsm Start
; THUMB-DISABLE-NEXT:    mov.w r2, #1
; THUMB-DISABLE-NEXT:    @ InlineAsm End
; THUMB-DISABLE-NEXT:    add r1, r2
; THUMB-DISABLE-NEXT:    str r1, [r0]
; THUMB-DISABLE-NEXT:    b LBB9_2
; THUMB-DISABLE-NEXT:  LBB9_3: @ %if.end
; THUMB-DISABLE-NEXT:    sub.w r4, r7, #8
; THUMB-DISABLE-NEXT:    mov sp, r4
; THUMB-DISABLE-NEXT:    pop {r4, r5, r7, pc}
entry:
  br i1 undef, label %if.then, label %if.end

if.then:
  %ptr = alloca i32, i32 4
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %sum.03 = phi i32 [ 0, %if.then ], [ %add, %for.body ]
  %call = tail call i32 asm sideeffect "mov $0, #1", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.03
  store i32 %add, i32* %ptr
  br label %for.body

if.end:
  ret void
}

; Another infinite loop test this time with a body bigger than just one block.
; infiniteloop2
; pop
define void @infiniteloop2() "frame-pointer"="all" {
entry:
  br i1 undef, label %if.then, label %if.end

if.then:
  %ptr = alloca i32, i32 4
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %sum.03 = phi i32 [ 0, %if.then ], [ %add, %body1 ], [ 1, %body2]
  %call = tail call i32 asm "mov $0, #0", "=r,~{r4}"()
  %add = add nsw i32 %call, %sum.03
  store i32 %add, i32* %ptr
  br i1 undef, label %body1, label %body2

body1:
  tail call void asm sideeffect "nop", "~{r4}"()
  br label %for.body

body2:
  tail call void asm sideeffect "nop", "~{r4}"()
  br label %for.body

if.end:
  ret void
}

; Another infinite loop test this time with two nested infinite loop.
; infiniteloop3
; bx lr
define void @infiniteloop3() "frame-pointer"="all" {
; ARM-LABEL: infiniteloop3:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    mov r0, #0
; ARM-NEXT:    cmp r0, #0
; ARM-NEXT:    bne LBB11_5
; ARM-NEXT:  @ %bb.1: @ %loop2a.preheader
; ARM-NEXT:    mov r1, #0
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:    b LBB11_3
; ARM-NEXT:  LBB11_2: @ %loop2b
; ARM-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; ARM-NEXT:    str r1, [r2]
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    mov r1, r3
; ARM-NEXT:  LBB11_3: @ %loop1
; ARM-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-NEXT:    ldr r3, [r0]
; ARM-NEXT:    cmp r0, #0
; ARM-NEXT:    bne LBB11_2
; ARM-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    mov r1, r3
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:    b LBB11_3
; ARM-NEXT:  LBB11_5: @ %end
; ARM-NEXT:    bx lr
;
; THUMB-LABEL: infiniteloop3:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    movs r0, #0
; THUMB-NEXT:    cbnz r0, LBB11_5
; THUMB-NEXT:  @ %bb.1: @ %loop2a.preheader
; THUMB-NEXT:    movs r0, #0
; THUMB-NEXT:    movs r1, #0
; THUMB-NEXT:    mov r2, r0
; THUMB-NEXT:    b LBB11_3
; THUMB-NEXT:  LBB11_2: @ %loop2b
; THUMB-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; THUMB-NEXT:    str r1, [r2]
; THUMB-NEXT:    mov r2, r1
; THUMB-NEXT:    mov r1, r3
; THUMB-NEXT:  LBB11_3: @ %loop1
; THUMB-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-NEXT:    ldr r3, [r0]
; THUMB-NEXT:    cmp r0, #0
; THUMB-NEXT:    bne LBB11_2
; THUMB-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; THUMB-NEXT:    mov r0, r1
; THUMB-NEXT:    mov r1, r3
; THUMB-NEXT:    mov r2, r0
; THUMB-NEXT:    b LBB11_3
; THUMB-NEXT:  LBB11_5: @ %end
; THUMB-NEXT:    bx lr
; ARM-ENABLE-LABEL: infiniteloop3:
; ARM-ENABLE:       @ %bb.0: @ %entry
; ARM-ENABLE-NEXT:    mov r0, #0
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    bne LBB11_5
; ARM-ENABLE-NEXT:  @ %bb.1: @ %loop2a.preheader
; ARM-ENABLE-NEXT:    mov r1, #0
; ARM-ENABLE-NEXT:    mov r2, r0
; ARM-ENABLE-NEXT:    b LBB11_3
; ARM-ENABLE-NEXT:  LBB11_2: @ %loop2b
; ARM-ENABLE-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; ARM-ENABLE-NEXT:    str r1, [r2]
; ARM-ENABLE-NEXT:    mov r2, r1
; ARM-ENABLE-NEXT:    mov r1, r3
; ARM-ENABLE-NEXT:  LBB11_3: @ %loop1
; ARM-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-ENABLE-NEXT:    ldr r3, [r0]
; ARM-ENABLE-NEXT:    cmp r0, #0
; ARM-ENABLE-NEXT:    bne LBB11_2
; ARM-ENABLE-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; ARM-ENABLE-NEXT:    mov r0, r1
; ARM-ENABLE-NEXT:    mov r1, r3
; ARM-ENABLE-NEXT:    mov r2, r0
; ARM-ENABLE-NEXT:    b LBB11_3
; ARM-ENABLE-NEXT:  LBB11_5: @ %end
; ARM-ENABLE-NEXT:    bx lr
;
; ARM-DISABLE-LABEL: infiniteloop3:
; ARM-DISABLE:       @ %bb.0: @ %entry
; ARM-DISABLE-NEXT:    mov r0, #0
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    bne LBB11_5
; ARM-DISABLE-NEXT:  @ %bb.1: @ %loop2a.preheader
; ARM-DISABLE-NEXT:    mov r1, #0
; ARM-DISABLE-NEXT:    mov r2, r0
; ARM-DISABLE-NEXT:    b LBB11_3
; ARM-DISABLE-NEXT:  LBB11_2: @ %loop2b
; ARM-DISABLE-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; ARM-DISABLE-NEXT:    str r1, [r2]
; ARM-DISABLE-NEXT:    mov r2, r1
; ARM-DISABLE-NEXT:    mov r1, r3
; ARM-DISABLE-NEXT:  LBB11_3: @ %loop1
; ARM-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-DISABLE-NEXT:    ldr r3, [r0]
; ARM-DISABLE-NEXT:    cmp r0, #0
; ARM-DISABLE-NEXT:    bne LBB11_2
; ARM-DISABLE-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; ARM-DISABLE-NEXT:    mov r0, r1
; ARM-DISABLE-NEXT:    mov r1, r3
; ARM-DISABLE-NEXT:    mov r2, r0
; ARM-DISABLE-NEXT:    b LBB11_3
; ARM-DISABLE-NEXT:  LBB11_5: @ %end
; ARM-DISABLE-NEXT:    bx lr
;
; THUMB-ENABLE-LABEL: infiniteloop3:
; THUMB-ENABLE:       @ %bb.0: @ %entry
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    cbnz r0, LBB11_5
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %loop2a.preheader
; THUMB-ENABLE-NEXT:    movs r0, #0
; THUMB-ENABLE-NEXT:    movs r1, #0
; THUMB-ENABLE-NEXT:    mov r2, r0
; THUMB-ENABLE-NEXT:    b LBB11_3
; THUMB-ENABLE-NEXT:  LBB11_2: @ %loop2b
; THUMB-ENABLE-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; THUMB-ENABLE-NEXT:    str r1, [r2]
; THUMB-ENABLE-NEXT:    mov r2, r1
; THUMB-ENABLE-NEXT:    mov r1, r3
; THUMB-ENABLE-NEXT:  LBB11_3: @ %loop1
; THUMB-ENABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-ENABLE-NEXT:    ldr r3, [r0]
; THUMB-ENABLE-NEXT:    cmp r0, #0
; THUMB-ENABLE-NEXT:    bne LBB11_2
; THUMB-ENABLE-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; THUMB-ENABLE-NEXT:    mov r0, r1
; THUMB-ENABLE-NEXT:    mov r1, r3
; THUMB-ENABLE-NEXT:    mov r2, r0
; THUMB-ENABLE-NEXT:    b LBB11_3
; THUMB-ENABLE-NEXT:  LBB11_5: @ %end
; THUMB-ENABLE-NEXT:    bx lr
;
; THUMB-DISABLE-LABEL: infiniteloop3:
; THUMB-DISABLE:       @ %bb.0: @ %entry
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    cbnz r0, LBB11_5
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %loop2a.preheader
; THUMB-DISABLE-NEXT:    movs r0, #0
; THUMB-DISABLE-NEXT:    movs r1, #0
; THUMB-DISABLE-NEXT:    mov r2, r0
; THUMB-DISABLE-NEXT:    b LBB11_3
; THUMB-DISABLE-NEXT:  LBB11_2: @ %loop2b
; THUMB-DISABLE-NEXT:    @ in Loop: Header=BB11_3 Depth=1
; THUMB-DISABLE-NEXT:    str r1, [r2]
; THUMB-DISABLE-NEXT:    mov r2, r1
; THUMB-DISABLE-NEXT:    mov r1, r3
; THUMB-DISABLE-NEXT:  LBB11_3: @ %loop1
; THUMB-DISABLE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-DISABLE-NEXT:    ldr r3, [r0]
; THUMB-DISABLE-NEXT:    cmp r0, #0
; THUMB-DISABLE-NEXT:    bne LBB11_2
; THUMB-DISABLE-NEXT:  @ %bb.4: @ in Loop: Header=BB11_3 Depth=1
; THUMB-DISABLE-NEXT:    mov r0, r1
; THUMB-DISABLE-NEXT:    mov r1, r3
; THUMB-DISABLE-NEXT:    mov r2, r0
; THUMB-DISABLE-NEXT:    b LBB11_3
; THUMB-DISABLE-NEXT:  LBB11_5: @ %end
; THUMB-DISABLE-NEXT:    bx lr
entry:
  br i1 undef, label %loop2a, label %body

body:                                             ; preds = %entry
  br i1 undef, label %loop2a, label %end

loop1:                                            ; preds = %loop2a, %loop2b
  %var.phi = phi i32* [ %next.phi, %loop2b ], [ %var, %loop2a ]
  %next.phi = phi i32* [ %next.load, %loop2b ], [ %next.var, %loop2a ]
  %0 = icmp eq i32* %var, null
  %next.load = load i32*, i32** undef
  br i1 %0, label %loop2a, label %loop2b

loop2a:                                           ; preds = %loop1, %body, %entry
  %var = phi i32* [ null, %body ], [ null, %entry ], [ %next.phi, %loop1 ]
  %next.var = phi i32* [ undef, %body ], [ null, %entry ], [ %next.load, %loop1 ]
  br label %loop1

loop2b:                                           ; preds = %loop1
  %gep1 = bitcast i32* %var.phi to i32*
  %next.ptr = bitcast i32* %gep1 to i32**
  store i32* %next.phi, i32** %next.ptr
  br label %loop1

end:
  ret void
}

; Function Attrs: nounwind readnone
declare double @llvm.pow.f64(double, double)

; This function needs to spill floating point registers to
; exercise the path where we were dereferencing the end iterator
; to access debug info location while inserting the spill code
; during PEI with shrink-wrapping enable.
; debug_info:
;
; {{tst  r2, #1|lsls r1, r2, #31}}
; beq      [[BB13:LBB[0-9_]+]]
;
; push
;
; {{tst  r2, #1|lsls r1, r2, #31}}
; beq      [[BB13:LBB[0-9_]+]]
;
; bl{{x?}} _pow
;
;
; pop
;
; [[BB13]]:
; vldr
;
; pop
;
; FIXME: This is flakey passing by finding 'bl' somewhere amongst the debug
; info (like labels named 'line_table) not because it's found a bl instruction.
;
; bl
define float @debug_info(float %gamma, float %slopeLimit, i1 %or.cond, double %tmp) "frame-pointer"="all" {
; ARM-ENABLE-LABEL: debug_info:
; ARM-ENABLE:       @ %bb.0: @ %bb
; ARM-ENABLE-NEXT:    push {r4, r7, lr}
; ARM-ENABLE-NEXT:    add r7, sp, #4
; ARM-ENABLE-NEXT:    sub r4, sp, #16
; ARM-ENABLE-NEXT:    bfc r4, #0, #4
; ARM-ENABLE-NEXT:    mov sp, r4
; ARM-ENABLE-NEXT:    tst r2, #1
; ARM-ENABLE-NEXT:    vst1.64 {d8, d9}, [r4:128]
; ARM-ENABLE-NEXT:    beq LBB12_2
; ARM-ENABLE-NEXT:  @ %bb.1: @ %bb3
; ARM-ENABLE-NEXT:    ldr r1, [r7, #8]
; ARM-ENABLE-NEXT:    vmov s16, r0
; ARM-ENABLE-NEXT:    mov r0, r3
; ARM-ENABLE-NEXT:    mov r2, r3
; ARM-ENABLE-NEXT:    vmov d9, r3, r1
; ARM-ENABLE-NEXT:    mov r3, r1
; ARM-ENABLE-NEXT:    bl _pow
; ARM-ENABLE-NEXT:    vmov.f32 s0, #1.000000e+00
; ARM-ENABLE-NEXT:    vmov.f64 d16, #1.000000e+00
; ARM-ENABLE-NEXT:    vadd.f64 d16, d9, d16
; ARM-ENABLE-NEXT:    vcmp.f32 s16, s0
; ARM-ENABLE-NEXT:    vmrs APSR_nzcv, fpscr
; ARM-ENABLE-NEXT:    vmov d17, r0, r1
; ARM-ENABLE-NEXT:    vmov.f64 d18, d9
; ARM-ENABLE-NEXT:    vadd.f64 d17, d17, d17
; ARM-ENABLE-NEXT:    vmovgt.f64 d18, d16
; ARM-ENABLE-NEXT:    vcmp.f64 d18, d9
; ARM-ENABLE-NEXT:    vmrs APSR_nzcv, fpscr
; ARM-ENABLE-NEXT:    vmovne.f64 d9, d17
; ARM-ENABLE-NEXT:    vcvt.f32.f64 s0, d9
; ARM-ENABLE-NEXT:    b LBB12_3
; ARM-ENABLE-NEXT:  LBB12_2:
; ARM-ENABLE-NEXT:    vldr s0, LCPI12_0
; ARM-ENABLE-NEXT:  LBB12_3: @ %bb13
; ARM-ENABLE-NEXT:    mov r4, sp
; ARM-ENABLE-NEXT:    vld1.64 {d8, d9}, [r4:128]
; ARM-ENABLE-NEXT:    vmov r0, s0
; ARM-ENABLE-NEXT:    sub sp, r7, #4
; ARM-ENABLE-NEXT:    pop {r4, r7, pc}
; ARM-ENABLE-NEXT:    .p2align 2
; ARM-ENABLE-NEXT:  @ %bb.4:
; ARM-ENABLE-NEXT:    .data_region
; ARM-ENABLE-NEXT:  LCPI12_0:
; ARM-ENABLE-NEXT:    .long 0x00000000 @ float 0
; ARM-ENABLE-NEXT:    .end_data_region
;
; ARM-DISABLE-LABEL: debug_info:
; ARM-DISABLE:       @ %bb.0: @ %bb
; ARM-DISABLE-NEXT:    push {r4, r7, lr}
; ARM-DISABLE-NEXT:    add r7, sp, #4
; ARM-DISABLE-NEXT:    sub r4, sp, #16
; ARM-DISABLE-NEXT:    bfc r4, #0, #4
; ARM-DISABLE-NEXT:    mov sp, r4
; ARM-DISABLE-NEXT:    tst r2, #1
; ARM-DISABLE-NEXT:    vst1.64 {d8, d9}, [r4:128]
; ARM-DISABLE-NEXT:    beq LBB12_2
; ARM-DISABLE-NEXT:  @ %bb.1: @ %bb3
; ARM-DISABLE-NEXT:    ldr r1, [r7, #8]
; ARM-DISABLE-NEXT:    vmov s16, r0
; ARM-DISABLE-NEXT:    mov r0, r3
; ARM-DISABLE-NEXT:    mov r2, r3
; ARM-DISABLE-NEXT:    vmov d9, r3, r1
; ARM-DISABLE-NEXT:    mov r3, r1
; ARM-DISABLE-NEXT:    bl _pow
; ARM-DISABLE-NEXT:    vmov.f32 s0, #1.000000e+00
; ARM-DISABLE-NEXT:    vmov.f64 d16, #1.000000e+00
; ARM-DISABLE-NEXT:    vadd.f64 d16, d9, d16
; ARM-DISABLE-NEXT:    vcmp.f32 s16, s0
; ARM-DISABLE-NEXT:    vmrs APSR_nzcv, fpscr
; ARM-DISABLE-NEXT:    vmov d17, r0, r1
; ARM-DISABLE-NEXT:    vmov.f64 d18, d9
; ARM-DISABLE-NEXT:    vadd.f64 d17, d17, d17
; ARM-DISABLE-NEXT:    vmovgt.f64 d18, d16
; ARM-DISABLE-NEXT:    vcmp.f64 d18, d9
; ARM-DISABLE-NEXT:    vmrs APSR_nzcv, fpscr
; ARM-DISABLE-NEXT:    vmovne.f64 d9, d17
; ARM-DISABLE-NEXT:    vcvt.f32.f64 s0, d9
; ARM-DISABLE-NEXT:    b LBB12_3
; ARM-DISABLE-NEXT:  LBB12_2:
; ARM-DISABLE-NEXT:    vldr s0, LCPI12_0
; ARM-DISABLE-NEXT:  LBB12_3: @ %bb13
; ARM-DISABLE-NEXT:    mov r4, sp
; ARM-DISABLE-NEXT:    vld1.64 {d8, d9}, [r4:128]
; ARM-DISABLE-NEXT:    vmov r0, s0
; ARM-DISABLE-NEXT:    sub sp, r7, #4
; ARM-DISABLE-NEXT:    pop {r4, r7, pc}
; ARM-DISABLE-NEXT:    .p2align 2
; ARM-DISABLE-NEXT:  @ %bb.4:
; ARM-DISABLE-NEXT:    .data_region
; ARM-DISABLE-NEXT:  LCPI12_0:
; ARM-DISABLE-NEXT:    .long 0x00000000 @ float 0
; ARM-DISABLE-NEXT:    .end_data_region
;
; THUMB-ENABLE-LABEL: debug_info:
; THUMB-ENABLE:       @ %bb.0: @ %bb
; THUMB-ENABLE-NEXT:    push {r4, r7, lr}
; THUMB-ENABLE-NEXT:    add r7, sp, #4
; THUMB-ENABLE-NEXT:    sub.w r4, sp, #16
; THUMB-ENABLE-NEXT:    bfc r4, #0, #4
; THUMB-ENABLE-NEXT:    mov sp, r4
; THUMB-ENABLE-NEXT:    lsls r1, r2, #31
; THUMB-ENABLE-NEXT:    vst1.64 {d8, d9}, [r4:128]
; THUMB-ENABLE-NEXT:    beq LBB12_2
; THUMB-ENABLE-NEXT:  @ %bb.1: @ %bb3
; THUMB-ENABLE-NEXT:    ldr r1, [r7, #8]
; THUMB-ENABLE-NEXT:    vmov s16, r0
; THUMB-ENABLE-NEXT:    mov r0, r3
; THUMB-ENABLE-NEXT:    mov r2, r3
; THUMB-ENABLE-NEXT:    vmov d9, r3, r1
; THUMB-ENABLE-NEXT:    mov r3, r1
; THUMB-ENABLE-NEXT:    bl _pow
; THUMB-ENABLE-NEXT:    vmov.f32 s0, #1.000000e+00
; THUMB-ENABLE-NEXT:    vmov.f64 d16, #1.000000e+00
; THUMB-ENABLE-NEXT:    vmov.f64 d18, d9
; THUMB-ENABLE-NEXT:    vcmp.f32 s16, s0
; THUMB-ENABLE-NEXT:    vadd.f64 d16, d9, d16
; THUMB-ENABLE-NEXT:    vmrs APSR_nzcv, fpscr
; THUMB-ENABLE-NEXT:    it gt
; THUMB-ENABLE-NEXT:    vmovgt.f64 d18, d16
; THUMB-ENABLE-NEXT:    vcmp.f64 d18, d9
; THUMB-ENABLE-NEXT:    vmov d17, r0, r1
; THUMB-ENABLE-NEXT:    vmrs APSR_nzcv, fpscr
; THUMB-ENABLE-NEXT:    vadd.f64 d17, d17, d17
; THUMB-ENABLE-NEXT:    it ne
; THUMB-ENABLE-NEXT:    vmovne.f64 d9, d17
; THUMB-ENABLE-NEXT:    vcvt.f32.f64 s0, d9
; THUMB-ENABLE-NEXT:    b LBB12_3
; THUMB-ENABLE-NEXT:  LBB12_2:
; THUMB-ENABLE-NEXT:    vldr s0, LCPI12_0
; THUMB-ENABLE-NEXT:  LBB12_3: @ %bb13
; THUMB-ENABLE-NEXT:    mov r4, sp
; THUMB-ENABLE-NEXT:    vld1.64 {d8, d9}, [r4:128]
; THUMB-ENABLE-NEXT:    subs r4, r7, #4
; THUMB-ENABLE-NEXT:    vmov r0, s0
; THUMB-ENABLE-NEXT:    mov sp, r4
; THUMB-ENABLE-NEXT:    pop {r4, r7, pc}
; THUMB-ENABLE-NEXT:    .p2align 2
; THUMB-ENABLE-NEXT:  @ %bb.4:
; THUMB-ENABLE-NEXT:    .data_region
; THUMB-ENABLE-NEXT:  LCPI12_0:
; THUMB-ENABLE-NEXT:    .long 0x00000000 @ float 0
; THUMB-ENABLE-NEXT:    .end_data_region
;
; THUMB-DISABLE-LABEL: debug_info:
; THUMB-DISABLE:       @ %bb.0: @ %bb
; THUMB-DISABLE-NEXT:    push {r4, r7, lr}
; THUMB-DISABLE-NEXT:    add r7, sp, #4
; THUMB-DISABLE-NEXT:    sub.w r4, sp, #16
; THUMB-DISABLE-NEXT:    bfc r4, #0, #4
; THUMB-DISABLE-NEXT:    mov sp, r4
; THUMB-DISABLE-NEXT:    lsls r1, r2, #31
; THUMB-DISABLE-NEXT:    vst1.64 {d8, d9}, [r4:128]
; THUMB-DISABLE-NEXT:    beq LBB12_2
; THUMB-DISABLE-NEXT:  @ %bb.1: @ %bb3
; THUMB-DISABLE-NEXT:    ldr r1, [r7, #8]
; THUMB-DISABLE-NEXT:    vmov s16, r0
; THUMB-DISABLE-NEXT:    mov r0, r3
; THUMB-DISABLE-NEXT:    mov r2, r3
; THUMB-DISABLE-NEXT:    vmov d9, r3, r1
; THUMB-DISABLE-NEXT:    mov r3, r1
; THUMB-DISABLE-NEXT:    bl _pow
; THUMB-DISABLE-NEXT:    vmov.f32 s0, #1.000000e+00
; THUMB-DISABLE-NEXT:    vmov.f64 d16, #1.000000e+00
; THUMB-DISABLE-NEXT:    vmov.f64 d18, d9
; THUMB-DISABLE-NEXT:    vcmp.f32 s16, s0
; THUMB-DISABLE-NEXT:    vadd.f64 d16, d9, d16
; THUMB-DISABLE-NEXT:    vmrs APSR_nzcv, fpscr
; THUMB-DISABLE-NEXT:    it gt
; THUMB-DISABLE-NEXT:    vmovgt.f64 d18, d16
; THUMB-DISABLE-NEXT:    vcmp.f64 d18, d9
; THUMB-DISABLE-NEXT:    vmov d17, r0, r1
; THUMB-DISABLE-NEXT:    vmrs APSR_nzcv, fpscr
; THUMB-DISABLE-NEXT:    vadd.f64 d17, d17, d17
; THUMB-DISABLE-NEXT:    it ne
; THUMB-DISABLE-NEXT:    vmovne.f64 d9, d17
; THUMB-DISABLE-NEXT:    vcvt.f32.f64 s0, d9
; THUMB-DISABLE-NEXT:    b LBB12_3
; THUMB-DISABLE-NEXT:  LBB12_2:
; THUMB-DISABLE-NEXT:    vldr s0, LCPI12_0
; THUMB-DISABLE-NEXT:  LBB12_3: @ %bb13
; THUMB-DISABLE-NEXT:    mov r4, sp
; THUMB-DISABLE-NEXT:    vld1.64 {d8, d9}, [r4:128]
; THUMB-DISABLE-NEXT:    subs r4, r7, #4
; THUMB-DISABLE-NEXT:    vmov r0, s0
; THUMB-DISABLE-NEXT:    mov sp, r4
; THUMB-DISABLE-NEXT:    pop {r4, r7, pc}
; THUMB-DISABLE-NEXT:    .p2align 2
; THUMB-DISABLE-NEXT:  @ %bb.4:
; THUMB-DISABLE-NEXT:    .data_region
; THUMB-DISABLE-NEXT:  LCPI12_0:
; THUMB-DISABLE-NEXT:    .long 0x00000000 @ float 0
; THUMB-DISABLE-NEXT:    .end_data_region
bb:
  br i1 %or.cond, label %bb3, label %bb13

bb3:                                              ; preds = %bb
  %tmp4 = fcmp ogt float %gamma, 1.000000e+00
  %tmp5 = fadd double 1.000000e+00, %tmp
  %tmp6 = select i1 %tmp4, double %tmp5, double %tmp
  %tmp10 = tail call double @llvm.pow.f64(double %tmp, double %tmp)
  %tmp11 = fcmp une double %tmp6, %tmp
  %tmp12 = fadd double %tmp10, %tmp10
  %cutoff.0 = select i1 %tmp11, double %tmp12, double %tmp
  %phitmp = fptrunc double %cutoff.0 to float
  br label %bb13

bb13:                                             ; preds = %bb3, %bb
  %cutoff.1 = phi float [ 0.000000e+00, %bb ], [ %phitmp, %bb3 ]
  ret float %cutoff.1
}


!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3}

!0 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !1, producer: "LLVM", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, retainedTypes: !4, globals: !2, imports: !2)
!1 = !DIFile(filename: "a.cpp", directory: "b")
!2 = !{}
!3 = !{i32 2, !"Debug Info Version", i32 3}
!4 = !{!5}
!5 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
