//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 600> bessel_yn_prime_data = {{
      {{ SC_(0.3e1), SC_(0.48770198822021484375e1), SC_(0.29708501519972432874442609586225264980095279453487) }}, 
      {{ SC_(0.3e1), SC_(0.6349340915679931640625e1), SC_(-0.024696224449710501462629183400498863527821680586339) }}, 
      {{ SC_(0.3e1), SC_(0.677385044097900390625e1), SC_(-0.12798507472726383423677638554544275695549764510857) }}, 
      {{ SC_(0.3e1), SC_(0.941909885406494140625e1), SC_(-0.066243410280370717974722487510346861657499475038741) }}, 
      {{ SC_(0.3e1), SC_(0.110517024993896484375e2), SC_(0.226607890873068245856076342155101398787735861242) }}, 
      {{ SC_(0.3e1), SC_(0.139249114990234375e2), SC_(-0.16908066477267740036269004386737437374794296404405) }}, 
      {{ SC_(0.3e1), SC_(0.15408351898193359375e2), SC_(-0.13976426541284708799365090012038551369276059918868) }}, 
      {{ SC_(0.3e1), SC_(0.27344074249267578125e2), SC_(-0.15207581571297747888485333231283834140497308882491) }}, 
      {{ SC_(0.3e1), SC_(0.273610286712646484375e2), SC_(-0.1519210870018680635152610713224897498465625949351) }}, 
      {{ SC_(0.3e1), SC_(0.316179637908935546875e2), SC_(0.058893765330339857551348010302889764995824335479609) }}, 
      {{ SC_(0.3e1), SC_(0.4073618316650390625e2), SC_(-0.086928837303893143739085237037569616565662316714289) }}, 
      {{ SC_(0.3e1), SC_(0.4175042724609375e2), SC_(0.029460629746888191941408408724635198680955117891972) }}, 
      {{ SC_(0.3e1), SC_(0.452895965576171875e2), SC_(-0.069743098494712237418038425487225304207814963137718) }}, 
      {{ SC_(0.3e1), SC_(0.45668792724609375e2), SC_(-0.099753925115669157739460992128310295715307292065023) }}, 
      {{ SC_(0.3e1), SC_(0.48443389892578125e2), SC_(0.067921667703473489237190498102371805460687285783656) }}, 
      {{ SC_(0.6e1), SC_(0.48770198822021484375e1), SC_(0.45878765063410398195047514022117535600745456721048) }}, 
      {{ SC_(0.6e1), SC_(0.6349340915679931640625e1), SC_(0.22418218548331346668384601887950338231581017161593) }}, 
      {{ SC_(0.6e1), SC_(0.677385044097900390625e1), SC_(0.22992537405176115753077734977154877584133523714429) }}, 
      {{ SC_(0.6e1), SC_(0.941909885406494140625e1), SC_(0.068812728738758316426265590204315461639641314948809) }}, 
      {{ SC_(0.6e1), SC_(0.110517024993896484375e2), SC_(-0.18560793859647973014977642931143089163783816925647) }}, 
      {{ SC_(0.6e1), SC_(0.139249114990234375e2), SC_(0.070000798608673213299405628661755953528613026320459) }}, 
      {{ SC_(0.6e1), SC_(0.15408351898193359375e2), SC_(0.19376241684387105036773317228980711041507362506569) }}, 
      {{ SC_(0.6e1), SC_(0.27344074249267578125e2), SC_(0.076304221116947638013945583135805169200458199883397) }}, 
      {{ SC_(0.6e1), SC_(0.273610286712646484375e2), SC_(0.078420037805937137991530603944111558157058065407156) }}, 
      {{ SC_(0.6e1), SC_(0.316179637908935546875e2), SC_(-0.14063268384922508425913593008296375572873690906534) }}, 
      {{ SC_(0.6e1), SC_(0.4073618316650390625e2), SC_(0.11261695236378634958215581301921273163991195797739) }}, 
      {{ SC_(0.6e1), SC_(0.4175042724609375e2), SC_(0.10373432104016062775716024256556420239538076465411) }}, 
      {{ SC_(0.6e1), SC_(0.452895965576171875e2), SC_(-0.07072525055806153568833332722732611636759962571535) }}, 
      {{ SC_(0.6e1), SC_(0.45668792724609375e2), SC_(-0.030972293751334079786007165028550614320459538159177) }}, 
      {{ SC_(0.6e1), SC_(0.48443389892578125e2), SC_(0.069727330209413742568400956942373623052437909402476) }}, 
      {{ SC_(0.9e1), SC_(0.48770198822021484375e1), SC_(13.894984273599357946670460450060714695541186697443) }}, 
      {{ SC_(0.9e1), SC_(0.6349340915679931640625e1), SC_(1.4572449732657037985034939706086264681380206748801) }}, 
      {{ SC_(0.9e1), SC_(0.677385044097900390625e1), SC_(0.86155765556755603309241698568190813419144466974822) }}, 
      {{ SC_(0.9e1), SC_(0.941909885406494140625e1), SC_(0.1710413410930036380506740824485908748201671723424) }}, 
      {{ SC_(0.9e1), SC_(0.110517024993896484375e2), SC_(0.18770721014765404279314765769479934980734954709839) }}, 
      {{ SC_(0.9e1), SC_(0.139249114990234375e2), SC_(-0.091820892987377587186051248850168538644369690211803) }}, 
      {{ SC_(0.9e1), SC_(0.15408351898193359375e2), SC_(-0.18294312664665444775238643234508987330780959872397) }}, 
      {{ SC_(0.9e1), SC_(0.27344074249267578125e2), SC_(0.030170767630507901526554062130458597407692809133846) }}, 
      {{ SC_(0.9e1), SC_(0.273610286712646484375e2), SC_(0.027836077534554534390644805689894449057578894439948) }}, 
      {{ SC_(0.9e1), SC_(0.316179637908935546875e2), SC_(0.09159509925923975526422241366990580655607016877378) }}, 
      {{ SC_(0.9e1), SC_(0.4073618316650390625e2), SC_(-0.014560595450177318431310834158190158688703590367834) }}, 
      {{ SC_(0.9e1), SC_(0.4175042724609375e2), SC_(-0.10918704677153594383481179430725373778686664762628) }}, 
      {{ SC_(0.9e1), SC_(0.452895965576171875e2), SC_(0.11618780209300140966948707898598828345386934997014) }}, 
      {{ SC_(0.9e1), SC_(0.45668792724609375e2), SC_(0.11387322886512557530969521161202802054178337768994) }}, 
      {{ SC_(0.9e1), SC_(0.48443389892578125e2), SC_(-0.11159658789970388222003965356965393759614529495583) }}, 
      {{ SC_(0.12e2), SC_(0.48770198822021484375e1), SC_(1115.7365144169632250750708637568582608695929301336) }}, 
      {{ SC_(0.12e2), SC_(0.6349340915679931640625e1), SC_(49.897386570683014367147275008906280714825402167729) }}, 
      {{ SC_(0.12e2), SC_(0.677385044097900390625e1), SC_(23.993108749436298108964764952118170194224888450664) }}, 
      {{ SC_(0.12e2), SC_(0.941909885406494140625e1), SC_(0.74509693829799785561868611377069970808153207426071) }}, 
      {{ SC_(0.12e2), SC_(0.110517024993896484375e2), SC_(0.18994283431442037729889375715209075604063979081985) }}, 
      {{ SC_(0.12e2), SC_(0.139249114990234375e2), SC_(0.16050891779589088320266596661126105201565065198727) }}, 
      {{ SC_(0.12e2), SC_(0.15408351898193359375e2), SC_(0.11173138819714695158653547881491793337469930619773) }}, 
      {{ SC_(0.12e2), SC_(0.27344074249267578125e2), SC_(-0.080561355740097365169888939187527688259466186103315) }}, 
      {{ SC_(0.12e2), SC_(0.273610286712646484375e2), SC_(-0.078703820719138679656817732451001710361631229400314) }}, 
      {{ SC_(0.12e2), SC_(0.316179637908935546875e2), SC_(-0.022574993334430950380987246627710213662579801696555) }}, 
      {{ SC_(0.12e2), SC_(0.4073618316650390625e2), SC_(-0.075879795644222713517319103314970846790130411505651) }}, 
      {{ SC_(0.12e2), SC_(0.4175042724609375e2), SC_(0.035750292714468892331813238597938647023932419120925) }}, 
      {{ SC_(0.12e2), SC_(0.452895965576171875e2), SC_(-0.061797017669492797650663465524809083071541977455965) }}, 
      {{ SC_(0.12e2), SC_(0.45668792724609375e2), SC_(-0.092640205626110700150483187470111879132310224539884) }}, 
      {{ SC_(0.12e2), SC_(0.48443389892578125e2), SC_(0.050675496197786768340935123379652737432851199053459) }}, 
      {{ SC_(0.15e2), SC_(0.48770198822021484375e1), SC_(193071.00395255740558981967707950775753268827677393) }}, 
      {{ SC_(0.15e2), SC_(0.6349340915679931640625e1), SC_(3685.3621786888678074280486263449657119766443216312) }}, 
      {{ SC_(0.15e2), SC_(0.677385044097900390625e1), SC_(1430.5428362156393546656155053653458779427929558875) }}, 
      {{ SC_(0.15e2), SC_(0.941909885406494140625e1), SC_(14.694853061314181950062405282730163593002349048433) }}, 
      {{ SC_(0.15e2), SC_(0.110517024993896484375e2), SC_(1.9644942654193013404615261696693296857637136915077) }}, 
      {{ SC_(0.15e2), SC_(0.139249114990234375e2), SC_(0.16528785033278554013130839883609228520308152056974) }}, 
      {{ SC_(0.15e2), SC_(0.15408351898193359375e2), SC_(0.12099856178243877408751029347936069347933509636106) }}, 
      {{ SC_(0.15e2), SC_(0.27344074249267578125e2), SC_(0.079691022694574032247089723670813591896281490573891) }}, 
      {{ SC_(0.15e2), SC_(0.273610286712646484375e2), SC_(0.078046249629867912651444758679935498710568705403403) }}, 
      {{ SC_(0.15e2), SC_(0.316179637908935546875e2), SC_(-0.010460519917394769425174121410913799646417387547134) }}, 
      {{ SC_(0.15e2), SC_(0.4073618316650390625e2), SC_(0.11347603407326945313629407529123089116059554399556) }}, 
      {{ SC_(0.15e2), SC_(0.4175042724609375e2), SC_(0.03317692267860009211739698386597389935196918676208) }}, 
      {{ SC_(0.15e2), SC_(0.452895965576171875e2), SC_(-0.011793953947705893245754928391862932467378103199865) }}, 
      {{ SC_(0.15e2), SC_(0.45668792724609375e2), SC_(0.028981536155469619614980839219157323334084044840107) }}, 
      {{ SC_(0.15e2), SC_(0.48443389892578125e2), SC_(0.028446048676193880517371561148424339556742967129028) }}, 
      {{ SC_(0.18e2), SC_(0.48770198822021484375e1), SC_(61489404.477273245667437498447835355562204180663089) }}, 
      {{ SC_(0.18e2), SC_(0.6349340915679931640625e1), SC_(510003.17843817904699802720469210309960596491625674) }}, 
      {{ SC_(0.18e2), SC_(0.677385044097900390625e1), SC_(160697.43596637300216193497452216016062544479253072) }}, 
      {{ SC_(0.18e2), SC_(0.941909885406494140625e1), SC_(548.39265176990747465862972116972361534193118446593) }}, 
      {{ SC_(0.18e2), SC_(0.110517024993896484375e2), SC_(41.903752779375757410402188053276499516073327778915) }}, 
      {{ SC_(0.18e2), SC_(0.139249114990234375e2), SC_(1.4298082292404496613615935878751772767157379746081) }}, 
      {{ SC_(0.18e2), SC_(0.15408351898193359375e2), SC_(0.38094854192456337919553054511829661425569727731157) }}, 
      {{ SC_(0.18e2), SC_(0.27344074249267578125e2), SC_(-0.029721010088200256399591551673655064255330581215767) }}, 
      {{ SC_(0.18e2), SC_(0.273610286712646484375e2), SC_(-0.028072703131498673594780453199513773112042321400196) }}, 
      {{ SC_(0.18e2), SC_(0.316179637908935546875e2), SC_(-0.00023901575251688605208583560833464109956416747994429) }}, 
      {{ SC_(0.18e2), SC_(0.4073618316650390625e2), SC_(-0.11839490191618530482818106654764624779374885038387) }}, 
      {{ SC_(0.18e2), SC_(0.4175042724609375e2), SC_(-0.069347614372438511573888068819635203849826313252682) }}, 
      {{ SC_(0.18e2), SC_(0.452895965576171875e2), SC_(0.059730519514700666103251443517585969183359305233517) }}, 
      {{ SC_(0.18e2), SC_(0.45668792724609375e2), SC_(0.023109881423974345171115075245556454652055923022744) }}, 
      {{ SC_(0.18e2), SC_(0.48443389892578125e2), SC_(-0.078056207456894244223013538407624819214242782788305) }}, 
      {{ SC_(0.21e2), SC_(0.48770198822021484375e1), SC_(32426551518.894051285463013148095286317045026076992) }}, 
      {{ SC_(0.21e2), SC_(0.6349340915679931640625e1), SC_(118218969.61184147928069788088763566979953965101345) }}, 
      {{ SC_(0.21e2), SC_(0.677385044097900390625e1), SC_(30357038.501635637985496998943515026355790836656393) }}, 
      {{ SC_(0.21e2), SC_(0.941909885406494140625e1), SC_(35456.563664501714282677463457898030749419225629776) }}, 
      {{ SC_(0.21e2), SC_(0.110517024993896484375e2), SC_(1567.4125644098158392861721296189576573724930738037) }}, 
      {{ SC_(0.21e2), SC_(0.139249114990234375e2), SC_(23.310752295161508394556961246244398071106143803009) }}, 
      {{ SC_(0.21e2), SC_(0.15408351898193359375e2), SC_(4.3249550054841060326583392244203824334951113536241) }}, 
      {{ SC_(0.21e2), SC_(0.27344074249267578125e2), SC_(-0.06968050648178237714673167082777474372734772445624) }}, 
      {{ SC_(0.21e2), SC_(0.273610286712646484375e2), SC_(-0.070769530360723733909096587089415158879384142866224) }}, 
      {{ SC_(0.21e2), SC_(0.316179637908935546875e2), SC_(0.051442123909106267094585391645995039863049077013) }}, 
      {{ SC_(0.21e2), SC_(0.4073618316650390625e2), SC_(0.11564820186007698778472652855905730688034142277644) }}, 
      {{ SC_(0.21e2), SC_(0.4175042724609375e2), SC_(0.077727282966915925937165527008896248637090601890297) }}, 
      {{ SC_(0.21e2), SC_(0.452895965576171875e2), SC_(-0.079122132589946330461785329196996655234318950600283) }}, 
      {{ SC_(0.21e2), SC_(0.45668792724609375e2), SC_(-0.048568903107998745819744324100936560896446872483671) }}, 
      {{ SC_(0.21e2), SC_(0.48443389892578125e2), SC_(0.097567386084824530395214852322983977335275972560591) }}, 
      {{ SC_(0.24e2), SC_(0.48770198822021484375e1), SC_(26289960802934.082608708841147700282255454538432831) }}, 
      {{ SC_(0.24e2), SC_(0.6349340915679931640625e1), SC_(42444187024.864993639906718517083937959093739819213) }}, 
      {{ SC_(0.24e2), SC_(0.677385044097900390625e1), SC_(8905165738.1617635753564077929245707945923585336582) }}, 
      {{ SC_(0.24e2), SC_(0.941909885406494140625e1), SC_(3634321.5442039460661559071457665992751570979246975) }}, 
      {{ SC_(0.24e2), SC_(0.110517024993896484375e2), SC_(94515.961244512444689922061656081899659856471090796) }}, 
      {{ SC_(0.24e2), SC_(0.139249114990234375e2), SC_(626.18301458184447852887624600335110845539610441982) }}, 
      {{ SC_(0.24e2), SC_(0.15408351898193359375e2), SC_(79.911561903902024000856092587915172800182935213878) }}, 
      {{ SC_(0.24e2), SC_(0.27344074249267578125e2), SC_(0.099454622211355675505522195073627509577222223103601) }}, 
      {{ SC_(0.24e2), SC_(0.273610286712646484375e2), SC_(0.099162302609370648487883563189979652760636886508713) }}, 
      {{ SC_(0.24e2), SC_(0.316179637908935546875e2), SC_(-0.10908680861998570652086740663868683119510177450605) }}, 
      {{ SC_(0.24e2), SC_(0.4073618316650390625e2), SC_(-0.11129543680992245949374091128651896371286644223509) }}, 
      {{ SC_(0.24e2), SC_(0.4175042724609375e2), SC_(-0.063488094293844672624986005840880912989768564883766) }}, 
      {{ SC_(0.24e2), SC_(0.452895965576171875e2), SC_(0.078126299129191161396544974669601116848381158526221) }}, 
      {{ SC_(0.24e2), SC_(0.45668792724609375e2), SC_(0.049840732061834370351470644321434031151919856919046) }}, 
      {{ SC_(0.24e2), SC_(0.48443389892578125e2), SC_(-0.10079256748662579469151151861923727959579543696994) }}, 
      {{ SC_(0.27e2), SC_(0.48770198822021484375e1), SC_(31017824262464205.958922559044949943484549490014899) }}, 
      {{ SC_(0.27e2), SC_(0.6349340915679931640625e1), SC_(22287656180663.776550451924127829416344261218622021) }}, 
      {{ SC_(0.27e2), SC_(0.677385044097900390625e1), SC_(3827294108368.0269477489175011506684599186679706028) }}, 
      {{ SC_(0.27e2), SC_(0.941909885406494140625e1), SC_(553452300.42086466143593900814779697132451520767782) }}, 
      {{ SC_(0.27e2), SC_(0.110517024993896484375e2), SC_(8566892.1158216005165229082457376277122137372641643) }}, 
      {{ SC_(0.27e2), SC_(0.139249114990234375e2), SC_(25958.533112834960868223842958165131229136881394218) }}, 
      {{ SC_(0.27e2), SC_(0.15408351898193359375e2), SC_(2309.8576016157815610381647716726001900524325387095) }}, 
      {{ SC_(0.27e2), SC_(0.27344074249267578125e2), SC_(0.08099659940919648317037232979698365838482593005533) }}, 
      {{ SC_(0.27e2), SC_(0.273610286712646484375e2), SC_(0.081046163182037289343213329934406500421020236167807) }}, 
      {{ SC_(0.27e2), SC_(0.316179637908935546875e2), SC_(0.05997017052459651429776257861064997372115830929981) }}, 
      {{ SC_(0.27e2), SC_(0.4073618316650390625e2), SC_(0.089026779236655439306747197547569837142730685735217) }}, 
      {{ SC_(0.27e2), SC_(0.4175042724609375e2), SC_(0.021438159628553820535251710024804945286350255466981) }}, 
      {{ SC_(0.27e2), SC_(0.452895965576171875e2), SC_(-0.057458660615255706893932512836671665537833151249683) }}, 
      {{ SC_(0.27e2), SC_(0.45668792724609375e2), SC_(-0.027918066346637812012925498454295026871243236870744) }}, 
      {{ SC_(0.27e2), SC_(0.48443389892578125e2), SC_(0.094852397559838420167904128907281089951412940428068) }}, 
      {{ SC_(0.3e2), SC_(0.48770198822021484375e1), SC_(51047805094444915063.333972384442857646750917105255) }}, 
      {{ SC_(0.3e2), SC_(0.6349340915679931640625e1), SC_(16383102364504657.097626404256533774954655403814735) }}, 
      {{ SC_(0.3e2), SC_(0.677385044097900390625e1), SC_(2305453816631632.4478139713758256232529472786452094) }}, 
      {{ SC_(0.3e2), SC_(0.941909885406494140625e1), SC_(119286399723.96948995243483416160315007693317901977) }}, 
      {{ SC_(0.3e2), SC_(0.110517024993896484375e2), SC_(1107948868.4390402247872007846532974135401516448132) }}, 
      {{ SC_(0.3e2), SC_(0.139249114990234375e2), SC_(1564768.8656094805647196181978525233011545246750146) }}, 
      {{ SC_(0.3e2), SC_(0.15408351898193359375e2), SC_(98282.976702067437341601339115870666184004269015844) }}, 
      {{ SC_(0.3e2), SC_(0.27344074249267578125e2), SC_(0.19426958828428270666812923273493625784124197340643) }}, 
      {{ SC_(0.3e2), SC_(0.273610286712646484375e2), SC_(0.1922870069086762100422786971721769201830182179905) }}, 
      {{ SC_(0.3e2), SC_(0.316179637908935546875e2), SC_(0.085040964411023393193600821835060363883104461261538) }}, 
      {{ SC_(0.3e2), SC_(0.4073618316650390625e2), SC_(-0.02086294150730270321392666880482032167648202293403) }}, 
      {{ SC_(0.3e2), SC_(0.4175042724609375e2), SC_(0.048501611304693111134238234911984551582655085974503) }}, 
      {{ SC_(0.3e2), SC_(0.452895965576171875e2), SC_(0.0098774343791820136743763395941918252659795932690156) }}, 
      {{ SC_(0.3e2), SC_(0.45668792724609375e2), SC_(-0.019197410220079478634724234058346009802242986327455) }}, 
      {{ SC_(0.3e2), SC_(0.48443389892578125e2), SC_(-0.074251974302542033395913173976920034281355438987303) }}, 
      {{ SC_(0.33e2), SC_(0.48770198822021484375e1), SC_(113310124431031716627385.91623741559578636226008379) }}, 
      {{ SC_(0.33e2), SC_(0.6349340915679931640625e1), SC_(16284768158670280961.604853254743947587783561845935) }}, 
      {{ SC_(0.33e2), SC_(0.677385044097900390625e1), SC_(1879579971334458550.0209315456503043018172175411525) }}, 
      {{ SC_(0.33e2), SC_(0.941909885406494140625e1), SC_(35044107725219.415933141084947955744131571076383029) }}, 
      {{ SC_(0.33e2), SC_(0.110517024993896484375e2), SC_(196454719531.31055502571353703844742324599224473623) }}, 
      {{ SC_(0.33e2), SC_(0.139249114990234375e2), SC_(131079022.88298813501066382467823552303127727679092) }}, 
      {{ SC_(0.33e2), SC_(0.15408351898193359375e2), SC_(5863205.6341090078994947632551555595618121658266577) }}, 
      {{ SC_(0.33e2), SC_(0.27344074249267578125e2), SC_(1.3242759675178380835227038550532227941618439965275) }}, 
      {{ SC_(0.33e2), SC_(0.273610286712646484375e2), SC_(1.3070821666105919146179915919703087795546279872479) }}, 
      {{ SC_(0.33e2), SC_(0.316179637908935546875e2), SC_(0.092775041898807041996549652733686199659471661637115) }}, 
      {{ SC_(0.33e2), SC_(0.4073618316650390625e2), SC_(-0.074809135843522356183357158092422716971233783348844) }}, 
      {{ SC_(0.33e2), SC_(0.4175042724609375e2), SC_(-0.096701180934889236997529237286456260917410858440076) }}, 
      {{ SC_(0.33e2), SC_(0.452895965576171875e2), SC_(0.059168520937287434505352110295139281109352732673869) }}, 
      {{ SC_(0.33e2), SC_(0.45668792724609375e2), SC_(0.077387513866829929522830987608788569701941362335678) }}, 
      {{ SC_(0.33e2), SC_(0.48443389892578125e2), SC_(0.025479086779207825088453626785298095143292950737504) }}, 
      {{ SC_(0.36e2), SC_(0.48770198822021484375e1), SC_(330048915457133176792757969.19546385390292172778597) }}, 
      {{ SC_(0.36e2), SC_(0.6349340915679931640625e1), SC_(21283101385947682361972.840132590419161428885017457) }}, 
      {{ SC_(0.36e2), SC_(0.677385044097900390625e1), SC_(2016152494766581360835.0504944450703514404854547839) }}, 
      {{ SC_(0.36e2), SC_(0.941909885406494140625e1), SC_(13617455449122061.068709501045586245491742471368046) }}, 
      {{ SC_(0.36e2), SC_(0.110517024993896484375e2), SC_(46274454905211.252127952159355719758860166499400318) }}, 
      {{ SC_(0.36e2), SC_(0.139249114990234375e2), SC_(14731989754.500661692405589251873227863072825516593) }}, 
      {{ SC_(0.36e2), SC_(0.15408351898193359375e2), SC_(472329065.6172406656655897442844993936137336820298) }}, 
      {{ SC_(0.36e2), SC_(0.27344074249267578125e2), SC_(12.787295405204896555560940160313152313443275264338) }}, 
      {{ SC_(0.36e2), SC_(0.273610286712646484375e2), SC_(12.588907409422241796189531532767810029397750718971) }}, 
      {{ SC_(0.36e2), SC_(0.316179637908935546875e2), SC_(0.44398715499310217152742945736029055864118125700699) }}, 
      {{ SC_(0.36e2), SC_(0.4073618316650390625e2), SC_(0.059771595940645434876799492212853292605241870315072) }}, 
      {{ SC_(0.36e2), SC_(0.4175042724609375e2), SC_(0.024220545303928498022831122772010841761272851374084) }}, 
      {{ SC_(0.36e2), SC_(0.452895965576171875e2), SC_(-0.092054570614800303323225793224546040095800678797729) }}, 
      {{ SC_(0.36e2), SC_(0.45668792724609375e2), SC_(-0.087461263710685434648051908910007785680384783167529) }}, 
      {{ SC_(0.36e2), SC_(0.48443389892578125e2), SC_(0.049106729103063607273231564081511781845090054115039) }}, 
      {{ SC_(0.39e2), SC_(0.48770198822021484375e1), SC_(1233144102125191868058726282714.6830526557816276367) }}, 
      {{ SC_(0.39e2), SC_(0.6349340915679931640625e1), SC_(35733094276591308750831994.91797625565199706304289) }}, 
      {{ SC_(0.39e2), SC_(0.677385044097900390625e1), SC_(2779662682018203595705190.2488317078949818104640352) }}, 
      {{ SC_(0.39e2), SC_(0.941909885406494140625e1), SC_(6828848630729733874.6283845233979310836359827708449) }}, 
      {{ SC_(0.39e2), SC_(0.110517024993896484375e2), SC_(14113135389756253.156077739699714394718999334850357) }}, 
      {{ SC_(0.39e2), SC_(0.139249114990234375e2), SC_(2159972792100.1357173196703249379848507903363330106) }}, 
      {{ SC_(0.39e2), SC_(0.15408351898193359375e2), SC_(49878586414.208299697922098228053037520564208848509) }}, 
      {{ SC_(0.39e2), SC_(0.27344074249267578125e2), SC_(172.72481992619044884818471295404381256191132921759) }}, 
      {{ SC_(0.39e2), SC_(0.273610286712646484375e2), SC_(169.61196242097930804462875200568886076262770819036) }}, 
      {{ SC_(0.39e2), SC_(0.316179637908935546875e2), SC_(3.2622994618084401364015275636183821534990803329434) }}, 
      {{ SC_(0.39e2), SC_(0.4073618316650390625e2), SC_(0.071571195500167528763973820425034029241001019664493) }}, 
      {{ SC_(0.39e2), SC_(0.4175042724609375e2), SC_(0.077639520094377453336245761486356713117488570968192) }}, 
      {{ SC_(0.39e2), SC_(0.452895965576171875e2), SC_(0.0069206374505846927493416208619676332960332679098951) }}, 
      {{ SC_(0.39e2), SC_(0.45668792724609375e2), SC_(-0.0094763994163015924174187344118500435461867666237707) }}, 
      {{ SC_(0.39e2), SC_(0.48443389892578125e2), SC_(-0.088327299286859131076769322427950834999241679006473) }}, 
      {{ SC_(0.42e2), SC_(0.48770198822021484375e1), SC_(5797280100327646006286194447016368.1421040357707697) }}, 
      {{ SC_(0.42e2), SC_(0.6349340915679931640625e1), SC_(75578601166571259232436208810.996067950581548988698) }}, 
      {{ SC_(0.42e2), SC_(0.677385044097900390625e1), SC_(4829803807658038517776138880.8750636464707289573594) }}, 
      {{ SC_(0.42e2), SC_(0.941909885406494140625e1), SC_(4329641022687304226243.9838984741548022967111467018) }}, 
      {{ SC_(0.42e2), SC_(0.110517024993896484375e2), SC_(5456026490429871545.3729944237669454258744606641489) }}, 
      {{ SC_(0.42e2), SC_(0.139249114990234375e2), SC_(403762667331377.86957440262465049860925273699263158) }}, 
      {{ SC_(0.42e2), SC_(0.15408351898193359375e2), SC_(6740433181763.7883013153961028425354387334429706028) }}, 
      {{ SC_(0.42e2), SC_(0.27344074249267578125e2), SC_(3158.6690245857765078107696571619682944747448675175) }}, 
      {{ SC_(0.42e2), SC_(0.273610286712646484375e2), SC_(3094.1963154921271936768553380051122786210511409107) }}, 
      {{ SC_(0.42e2), SC_(0.316179637908935546875e2), SC_(32.753934200718819822753904740576448091608604066055) }}, 
      {{ SC_(0.42e2), SC_(0.4073618316650390625e2), SC_(0.072739550630497079350234032861134498649735287193357) }}, 
      {{ SC_(0.42e2), SC_(0.4175042724609375e2), SC_(0.060663112127386998497369088801481071129124522975233) }}, 
      {{ SC_(0.42e2), SC_(0.452895965576171875e2), SC_(0.074473609380746711803311040389966933497838989432121) }}, 
      {{ SC_(0.42e2), SC_(0.45668792724609375e2), SC_(0.073158536052064850884139711362229851982735439619744) }}, 
      {{ SC_(0.42e2), SC_(0.48443389892578125e2), SC_(0.0062529560822924696318936561241723289563898043333544) }}, 
      {{ SC_(0.45e2), SC_(0.48770198822021484375e1), SC_(33733682510800680224442906671745094195.324494135316) }}, 
      {{ SC_(0.45e2), SC_(0.6349340915679931640625e1), SC_(198048437155168311381273880967818.22025824791036357) }}, 
      {{ SC_(0.45e2), SC_(0.677385044097900390625e1), SC_(10400456700923638671729643118843.806753044982298564) }}, 
      {{ SC_(0.45e2), SC_(0.941909885406494140625e1), SC_(3410735613885115350035572.8765307548785858388367401) }}, 
      {{ SC_(0.45e2), SC_(0.110517024993896484375e2), SC_(2626095967757200551970.6681963242828834151760822985) }}, 
      {{ SC_(0.45e2), SC_(0.139249114990234375e2), SC_(94401205462334537.050369109209833432350639718533638) }}, 
      {{ SC_(0.45e2), SC_(0.15408351898193359375e2), SC_(1142618566412157.8272585956706570352616937041979656) }}, 
      {{ SC_(0.45e2), SC_(0.27344074249267578125e2), SC_(75694.686584044680788645716511158348946476145181086) }}, 
      {{ SC_(0.45e2), SC_(0.273610286712646484375e2), SC_(73976.413466431635423703776127097751893371684622957) }}, 
      {{ SC_(0.45e2), SC_(0.316179637908935546875e2), SC_(442.20546817943409312426292528886668861618504431741) }}, 
      {{ SC_(0.45e2), SC_(0.4073618316650390625e2), SC_(0.28228421314539279160628746389504552227153533768146) }}, 
      {{ SC_(0.45e2), SC_(0.4175042724609375e2), SC_(0.16000300625233986775481590043192514396457873354516) }}, 
      {{ SC_(0.45e2), SC_(0.452895965576171875e2), SC_(0.057231962290387109238731129148921559725799147998496) }}, 
      {{ SC_(0.45e2), SC_(0.45668792724609375e2), SC_(0.058252022623339984507829779588426189048862620281189) }}, 
      {{ SC_(0.45e2), SC_(0.48443389892578125e2), SC_(0.071183141732921385630773244674279719514795336041612) }}, 
      {{ SC_(0.48e2), SC_(0.48770198822021484375e1), SC_(239522804322893748319138034551047145275789.59974224) }}, 
      {{ SC_(0.48e2), SC_(0.6349340915679931640625e1), SC_(633761731337958689992254732836509014.5498517746032) }}, 
      {{ SC_(0.48e2), SC_(0.677385044097900390625e1), SC_(27357238520963102125309576744667666.363300351401482) }}, 
      {{ SC_(0.48e2), SC_(0.941909885406494140625e1), SC_(3288814657352135263627844511.2333600813675095369837) }}, 
      {{ SC_(0.48e2), SC_(0.110517024993896484375e2), SC_(1549742039352820886974060.3190714284655739926493718) }}, 
      {{ SC_(0.48e2), SC_(0.139249114990234375e2), SC_(27161074177867080159.469660549620941382353430766586) }}, 
      {{ SC_(0.48e2), SC_(0.15408351898193359375e2), SC_(238916331621456340.65432311640997088065900397861155) }}, 
      {{ SC_(0.48e2), SC_(0.27344074249267578125e2), SC_(2314888.4958806745629333835711192432287758316461507) }}, 
      {{ SC_(0.48e2), SC_(0.273610286712646484375e2), SC_(2257224.1679332711454029660320148577090226354529857) }}, 
      {{ SC_(0.48e2), SC_(0.316179637908935546875e2), SC_(7789.7419442918626296378651092715214256586181141926) }}, 
      {{ SC_(0.48e2), SC_(0.4073618316650390625e2), SC_(1.6743462295916778715636314008207178423626071094632) }}, 
      {{ SC_(0.48e2), SC_(0.4175042724609375e2), SC_(0.84969906096968362082642019200637971882884732293335) }}, 
      {{ SC_(0.48e2), SC_(0.452895965576171875e2), SC_(0.11278671656985116240884620256968696962764469071367) }}, 
      {{ SC_(0.48e2), SC_(0.45668792724609375e2), SC_(0.095078000040189495106936435411946264505165465416578) }}, 
      {{ SC_(0.48e2), SC_(0.48443389892578125e2), SC_(0.055062921732975958664266463964777750754001901274629) }}, 
      {{ SC_(0.51e2), SC_(0.48770198822021484375e1), SC_(2049587659777558411382317923670496261583806542.493) }}, 
      {{ SC_(0.51e2), SC_(0.6349340915679931640625e1), SC_(2445662164833856435631550255588074712252.7787749918) }}, 
      {{ SC_(0.51e2), SC_(0.677385044097900390625e1), SC_(86796605852598653796484179209256273156.253707461952) }}, 
      {{ SC_(0.51e2), SC_(0.941909885406494140625e1), SC_(3831606243141839102073334951299.4701624472926032508) }}, 
      {{ SC_(0.51e2), SC_(0.110517024993896484375e2), SC_(1106493595140034197852895923.9584737671557915697202) }}, 
      {{ SC_(0.51e2), SC_(0.139249114990234375e2), SC_(9483467934688543751821.1137053292897138412310640169) }}, 
      {{ SC_(0.51e2), SC_(0.15408351898193359375e2), SC_(60738635966410164385.958394741410769406835938636865) }}, 
      {{ SC_(0.51e2), SC_(0.27344074249267578125e2), SC_(88424622.376034322983107041268281421004180860038753) }}, 
      {{ SC_(0.51e2), SC_(0.273610286712646484375e2), SC_(86031981.243325241428625701075048702697378800248637) }}, 
      {{ SC_(0.51e2), SC_(0.316179637908935546875e2), SC_(174400.37651200557082226548445824464332272001897389) }}, 
      {{ SC_(0.51e2), SC_(0.4073618316650390625e2), SC_(12.946971229042316120764442921458399845772849822588) }}, 
      {{ SC_(0.51e2), SC_(0.4175042724609375e2), SC_(5.8742140283607909770485379763421722194017038516076) }}, 
      {{ SC_(0.51e2), SC_(0.452895965576171875e2), SC_(0.53428720443828699337032810544888204576810977989968) }}, 
      {{ SC_(0.51e2), SC_(0.45668792724609375e2), SC_(0.42592959561863366613058593411801927675297445385356) }}, 
      {{ SC_(0.51e2), SC_(0.48443389892578125e2), SC_(0.098276023559531896826463662674167711540316451897657) }}, 
      {{ SC_(0.54e2), SC_(0.48770198822021484375e1), SC_(20905232114169109167897938189126912891970672725780.) }}, 
      {{ SC_(0.54e2), SC_(0.6349340915679931640625e1), SC_(11255611402596222741806443152512714449896034.95219) }}, 
      {{ SC_(0.54e2), SC_(0.677385044097900390625e1), SC_(328484211508316631140190398742844071477057.53311607) }}, 
      {{ SC_(0.54e2), SC_(0.941909885406494140625e1), SC_(5332364035387341126441890302814550.845507841895594) }}, 
      {{ SC_(0.54e2), SC_(0.110517024993896484375e2), SC_(944771189815878803007600403368.88711953482139956825) }}, 
      {{ SC_(0.54e2), SC_(0.139249114990234375e2), SC_(3969726457350851108670819.0270483967952145392521967) }}, 
      {{ SC_(0.54e2), SC_(0.15408351898193359375e2), SC_(18541154623928634844579.547640967624705965729178149) }}, 
      {{ SC_(0.54e2), SC_(0.27344074249267578125e2), SC_(4144817285.7784820213261562080665118413906287256562) }}, 
      {{ SC_(0.54e2), SC_(0.273610286712646484375e2), SC_(4023965578.8512166042035503785698368524454260668606) }}, 
      {{ SC_(0.54e2), SC_(0.316179637908935546875e2), SC_(4857254.3742754162567243110228728128894050129680029) }}, 
      {{ SC_(0.54e2), SC_(0.4073618316650390625e2), SC_(129.89939453279762160168461742626340596331738244806) }}, 
      {{ SC_(0.54e2), SC_(0.4175042724609375e2), SC_(52.754642545813458576257416292629942980318201317708) }}, 
      {{ SC_(0.54e2), SC_(0.452895965576171875e2), SC_(3.2987655306543891212696806805571326443655047812012) }}, 
      {{ SC_(0.54e2), SC_(0.45668792724609375e2), SC_(2.5329424546885397623237023579281554373385389203592) }}, 
      {{ SC_(0.54e2), SC_(0.48443389892578125e2), SC_(0.43686549121581194580641150930324084070959640013132) }}, 
      {{ SC_(0.57e2), SC_(0.48770198822021484375e1), SC_(2.5169620918755273734751531423307576059487175279655e+53) }}, 
      {{ SC_(0.57e2), SC_(0.6349340915679931640625e1), SC_(61174688555597945848882268589437960109494141523.722) }}, 
      {{ SC_(0.57e2), SC_(0.677385044097900390625e1), SC_(1468327769614117292538317982499132738351648371.0919) }}, 
      {{ SC_(0.57e2), SC_(0.941909885406494140625e1), SC_(8775550580287280317417400764353784961.2905042914466) }}, 
      {{ SC_(0.57e2), SC_(0.110517024993896484375e2), SC_(954844116271064617066023153137696.40337364841548845) }}, 
      {{ SC_(0.57e2), SC_(0.139249114990234375e2), SC_(1971019683890416712446520517.8326914674121514444488) }}, 
      {{ SC_(0.57e2), SC_(0.15408351898193359375e2), SC_(6722219396128901574730218.8067982561390314098778667) }}, 
      {{ SC_(0.57e2), SC_(0.27344074249267578125e2), SC_(234893166288.30075812707849294929137851408290558752) }}, 
      {{ SC_(0.57e2), SC_(0.273610286712646484375e2), SC_(227560854653.85630205561022254001943293553067305038) }}, 
      {{ SC_(0.57e2), SC_(0.316179637908935546875e2), SC_(165348515.80872034084037746268766135137511007672989) }}, 
      {{ SC_(0.57e2), SC_(0.4073618316650390625e2), SC_(1653.302868841762906988170344844615332445062274303) }}, 
      {{ SC_(0.57e2), SC_(0.4175042724609375e2), SC_(604.06199987707091212985973850451313161553226079994) }}, 
      {{ SC_(0.57e2), SC_(0.452895965576171875e2), SC_(26.147826903085700377751404608708294778930527661864) }}, 
      {{ SC_(0.57e2), SC_(0.45668792724609375e2), SC_(19.308053041721125835516802702079181838332215102344) }}, 
      {{ SC_(0.57e2), SC_(0.48443389892578125e2), SC_(2.5283615374731968791601022506604160830005801823799) }}, 
      {{ SC_(0.6e2), SC_(0.48770198822021484375e1), SC_(3.5460365231745721606669570215996512793241495164453e+57) }}, 
      {{ SC_(0.6e2), SC_(0.6349340915679931640625e1), SC_(3.8921264262571733782239747560313526684108210623487e+50) }}, 
      {{ SC_(0.6e2), SC_(0.677385044097900390625e1), SC_(7684237767558382594304235657570772453674248757118.3) }}, 
      {{ SC_(0.6e2), SC_(0.941909885406494140625e1), SC_(16925416951539066399686670852829412815863.412431411) }}, 
      {{ SC_(0.6e2), SC_(0.110517024993896484375e2), SC_(1131875640030290021946077924988533695.7888332928356) }}, 
      {{ SC_(0.6e2), SC_(0.139249114990234375e2), SC_(1149875928909540701676477111822.3170039080211561671) }}, 
      {{ SC_(0.6e2), SC_(0.15408351898193359375e2), SC_(2866796552399774210995844116.7096924369139910645819) }}, 
      {{ SC_(0.6e2), SC_(0.27344074249267578125e2), SC_(15891355189739.495516567349164999419111229531478334) }}, 
      {{ SC_(0.6e2), SC_(0.273610286712646484375e2), SC_(15363127336068.368075911095109876542431338831991157) }}, 
      {{ SC_(0.6e2), SC_(0.316179637908935546875e2), SC_(6779161464.8028951527640884369288557214558713468535) }}, 
      {{ SC_(0.6e2), SC_(0.4073618316650390625e2), SC_(26113.831472455968890083544404266110113626724773258) }}, 
      {{ SC_(0.6e2), SC_(0.4175042724609375e2), SC_(8623.033736775565340846565423848796418156287767396) }}, 
      {{ SC_(0.6e2), SC_(0.452895965576171875e2), SC_(262.71208466116252796487792402891053270786603888051) }}, 
      {{ SC_(0.6e2), SC_(0.45668792724609375e2), SC_(186.83227369709377348524356398249111029234112960347) }}, 
      {{ SC_(0.6e2), SC_(0.48443389892578125e2), SC_(18.589647091617037033086402220922012445990916760661) }},
      {{ SC_(-0.3e1), SC_(0.48770198822021484375e1), SC_(-0.29708501519972432874442609586225264980095279453487) }}, 
      {{ SC_(-0.3e1), SC_(0.6349340915679931640625e1), SC_(0.024696224449710501462629183400498863527821680586339) }}, 
      {{ SC_(-0.3e1), SC_(0.677385044097900390625e1), SC_(0.12798507472726383423677638554544275695549764510857) }}, 
      {{ SC_(-0.3e1), SC_(0.941909885406494140625e1), SC_(0.066243410280370717974722487510346861657499475038741) }}, 
      {{ SC_(-0.3e1), SC_(0.110517024993896484375e2), SC_(-0.226607890873068245856076342155101398787735861242) }}, 
      {{ SC_(-0.3e1), SC_(0.139249114990234375e2), SC_(0.16908066477267740036269004386737437374794296404405) }}, 
      {{ SC_(-0.3e1), SC_(0.15408351898193359375e2), SC_(0.13976426541284708799365090012038551369276059918868) }}, 
      {{ SC_(-0.3e1), SC_(0.27344074249267578125e2), SC_(0.15207581571297747888485333231283834140497308882491) }}, 
      {{ SC_(-0.3e1), SC_(0.273610286712646484375e2), SC_(0.1519210870018680635152610713224897498465625949351) }}, 
      {{ SC_(-0.3e1), SC_(0.316179637908935546875e2), SC_(-0.058893765330339857551348010302889764995824335479609) }}, 
      {{ SC_(-0.3e1), SC_(0.4073618316650390625e2), SC_(0.086928837303893143739085237037569616565662316714289) }}, 
      {{ SC_(-0.3e1), SC_(0.4175042724609375e2), SC_(-0.029460629746888191941408408724635198680955117891972) }}, 
      {{ SC_(-0.3e1), SC_(0.452895965576171875e2), SC_(0.069743098494712237418038425487225304207814963137718) }}, 
      {{ SC_(-0.3e1), SC_(0.45668792724609375e2), SC_(0.099753925115669157739460992128310295715307292065023) }}, 
      {{ SC_(-0.3e1), SC_(0.48443389892578125e2), SC_(-0.067921667703473489237190498102371805460687285783656) }}, 
      {{ SC_(-0.6e1), SC_(0.48770198822021484375e1), SC_(0.45878765063410398195047514022117535600745456721048) }}, 
      {{ SC_(-0.6e1), SC_(0.6349340915679931640625e1), SC_(0.22418218548331346668384601887950338231581017161593) }}, 
      {{ SC_(-0.6e1), SC_(0.677385044097900390625e1), SC_(0.22992537405176115753077734977154877584133523714429) }}, 
      {{ SC_(-0.6e1), SC_(0.941909885406494140625e1), SC_(0.068812728738758316426265590204315461639641314948809) }}, 
      {{ SC_(-0.6e1), SC_(0.110517024993896484375e2), SC_(-0.18560793859647973014977642931143089163783816925647) }}, 
      {{ SC_(-0.6e1), SC_(0.139249114990234375e2), SC_(0.070000798608673213299405628661755953528613026320459) }}, 
      {{ SC_(-0.6e1), SC_(0.15408351898193359375e2), SC_(0.19376241684387105036773317228980711041507362506569) }}, 
      {{ SC_(-0.6e1), SC_(0.27344074249267578125e2), SC_(0.076304221116947638013945583135805169200458199883397) }}, 
      {{ SC_(-0.6e1), SC_(0.273610286712646484375e2), SC_(0.078420037805937137991530603944111558157058065407156) }}, 
      {{ SC_(-0.6e1), SC_(0.316179637908935546875e2), SC_(-0.14063268384922508425913593008296375572873690906534) }}, 
      {{ SC_(-0.6e1), SC_(0.4073618316650390625e2), SC_(0.11261695236378634958215581301921273163991195797739) }}, 
      {{ SC_(-0.6e1), SC_(0.4175042724609375e2), SC_(0.10373432104016062775716024256556420239538076465411) }}, 
      {{ SC_(-0.6e1), SC_(0.452895965576171875e2), SC_(-0.07072525055806153568833332722732611636759962571535) }}, 
      {{ SC_(-0.6e1), SC_(0.45668792724609375e2), SC_(-0.030972293751334079786007165028550614320459538159177) }}, 
      {{ SC_(-0.6e1), SC_(0.48443389892578125e2), SC_(0.069727330209413742568400956942373623052437909402476) }}, 
      {{ SC_(-0.9e1), SC_(0.48770198822021484375e1), SC_(-13.894984273599357946670460450060714695541186697443) }}, 
      {{ SC_(-0.9e1), SC_(0.6349340915679931640625e1), SC_(-1.4572449732657037985034939706086264681380206748801) }}, 
      {{ SC_(-0.9e1), SC_(0.677385044097900390625e1), SC_(-0.86155765556755603309241698568190813419144466974822) }}, 
      {{ SC_(-0.9e1), SC_(0.941909885406494140625e1), SC_(-0.1710413410930036380506740824485908748201671723424) }}, 
      {{ SC_(-0.9e1), SC_(0.110517024993896484375e2), SC_(-0.18770721014765404279314765769479934980734954709839) }}, 
      {{ SC_(-0.9e1), SC_(0.139249114990234375e2), SC_(0.091820892987377587186051248850168538644369690211803) }}, 
      {{ SC_(-0.9e1), SC_(0.15408351898193359375e2), SC_(0.18294312664665444775238643234508987330780959872397) }}, 
      {{ SC_(-0.9e1), SC_(0.27344074249267578125e2), SC_(-0.030170767630507901526554062130458597407692809133846) }}, 
      {{ SC_(-0.9e1), SC_(0.273610286712646484375e2), SC_(-0.027836077534554534390644805689894449057578894439948) }}, 
      {{ SC_(-0.9e1), SC_(0.316179637908935546875e2), SC_(-0.09159509925923975526422241366990580655607016877378) }}, 
      {{ SC_(-0.9e1), SC_(0.4073618316650390625e2), SC_(0.014560595450177318431310834158190158688703590367834) }}, 
      {{ SC_(-0.9e1), SC_(0.4175042724609375e2), SC_(0.10918704677153594383481179430725373778686664762628) }}, 
      {{ SC_(-0.9e1), SC_(0.452895965576171875e2), SC_(-0.11618780209300140966948707898598828345386934997014) }}, 
      {{ SC_(-0.9e1), SC_(0.45668792724609375e2), SC_(-0.11387322886512557530969521161202802054178337768994) }}, 
      {{ SC_(-0.9e1), SC_(0.48443389892578125e2), SC_(0.11159658789970388222003965356965393759614529495583) }}, 
      {{ SC_(-0.12e2), SC_(0.48770198822021484375e1), SC_(1115.7365144169632250750708637568582608695929301336) }}, 
      {{ SC_(-0.12e2), SC_(0.6349340915679931640625e1), SC_(49.897386570683014367147275008906280714825402167729) }}, 
      {{ SC_(-0.12e2), SC_(0.677385044097900390625e1), SC_(23.993108749436298108964764952118170194224888450664) }}, 
      {{ SC_(-0.12e2), SC_(0.941909885406494140625e1), SC_(0.74509693829799785561868611377069970808153207426071) }}, 
      {{ SC_(-0.12e2), SC_(0.110517024993896484375e2), SC_(0.18994283431442037729889375715209075604063979081985) }}, 
      {{ SC_(-0.12e2), SC_(0.139249114990234375e2), SC_(0.16050891779589088320266596661126105201565065198727) }}, 
      {{ SC_(-0.12e2), SC_(0.15408351898193359375e2), SC_(0.11173138819714695158653547881491793337469930619773) }}, 
      {{ SC_(-0.12e2), SC_(0.27344074249267578125e2), SC_(-0.080561355740097365169888939187527688259466186103315) }}, 
      {{ SC_(-0.12e2), SC_(0.273610286712646484375e2), SC_(-0.078703820719138679656817732451001710361631229400314) }}, 
      {{ SC_(-0.12e2), SC_(0.316179637908935546875e2), SC_(-0.022574993334430950380987246627710213662579801696555) }}, 
      {{ SC_(-0.12e2), SC_(0.4073618316650390625e2), SC_(-0.075879795644222713517319103314970846790130411505651) }}, 
      {{ SC_(-0.12e2), SC_(0.4175042724609375e2), SC_(0.035750292714468892331813238597938647023932419120925) }}, 
      {{ SC_(-0.12e2), SC_(0.452895965576171875e2), SC_(-0.061797017669492797650663465524809083071541977455965) }}, 
      {{ SC_(-0.12e2), SC_(0.45668792724609375e2), SC_(-0.092640205626110700150483187470111879132310224539884) }}, 
      {{ SC_(-0.12e2), SC_(0.48443389892578125e2), SC_(0.050675496197786768340935123379652737432851199053459) }}, 
      {{ SC_(-0.15e2), SC_(0.48770198822021484375e1), SC_(-193071.00395255740558981967707950775753268827677393) }}, 
      {{ SC_(-0.15e2), SC_(0.6349340915679931640625e1), SC_(-3685.3621786888678074280486263449657119766443216312) }}, 
      {{ SC_(-0.15e2), SC_(0.677385044097900390625e1), SC_(-1430.5428362156393546656155053653458779427929558875) }}, 
      {{ SC_(-0.15e2), SC_(0.941909885406494140625e1), SC_(-14.694853061314181950062405282730163593002349048433) }}, 
      {{ SC_(-0.15e2), SC_(0.110517024993896484375e2), SC_(-1.9644942654193013404615261696693296857637136915077) }}, 
      {{ SC_(-0.15e2), SC_(0.139249114990234375e2), SC_(-0.16528785033278554013130839883609228520308152056974) }}, 
      {{ SC_(-0.15e2), SC_(0.15408351898193359375e2), SC_(-0.12099856178243877408751029347936069347933509636106) }}, 
      {{ SC_(-0.15e2), SC_(0.27344074249267578125e2), SC_(-0.079691022694574032247089723670813591896281490573891) }}, 
      {{ SC_(-0.15e2), SC_(0.273610286712646484375e2), SC_(-0.078046249629867912651444758679935498710568705403403) }}, 
      {{ SC_(-0.15e2), SC_(0.316179637908935546875e2), SC_(0.010460519917394769425174121410913799646417387547134) }}, 
      {{ SC_(-0.15e2), SC_(0.4073618316650390625e2), SC_(-0.11347603407326945313629407529123089116059554399556) }}, 
      {{ SC_(-0.15e2), SC_(0.4175042724609375e2), SC_(-0.03317692267860009211739698386597389935196918676208) }}, 
      {{ SC_(-0.15e2), SC_(0.452895965576171875e2), SC_(0.011793953947705893245754928391862932467378103199865) }}, 
      {{ SC_(-0.15e2), SC_(0.45668792724609375e2), SC_(-0.028981536155469619614980839219157323334084044840107) }}, 
      {{ SC_(-0.15e2), SC_(0.48443389892578125e2), SC_(-0.028446048676193880517371561148424339556742967129028) }}, 
      {{ SC_(-0.18e2), SC_(0.48770198822021484375e1), SC_(61489404.477273245667437498447835355562204180663089) }}, 
      {{ SC_(-0.18e2), SC_(0.6349340915679931640625e1), SC_(510003.17843817904699802720469210309960596491625674) }}, 
      {{ SC_(-0.18e2), SC_(0.677385044097900390625e1), SC_(160697.43596637300216193497452216016062544479253072) }}, 
      {{ SC_(-0.18e2), SC_(0.941909885406494140625e1), SC_(548.39265176990747465862972116972361534193118446593) }}, 
      {{ SC_(-0.18e2), SC_(0.110517024993896484375e2), SC_(41.903752779375757410402188053276499516073327778915) }}, 
      {{ SC_(-0.18e2), SC_(0.139249114990234375e2), SC_(1.4298082292404496613615935878751772767157379746081) }}, 
      {{ SC_(-0.18e2), SC_(0.15408351898193359375e2), SC_(0.38094854192456337919553054511829661425569727731157) }}, 
      {{ SC_(-0.18e2), SC_(0.27344074249267578125e2), SC_(-0.029721010088200256399591551673655064255330581215767) }}, 
      {{ SC_(-0.18e2), SC_(0.273610286712646484375e2), SC_(-0.028072703131498673594780453199513773112042321400196) }}, 
      {{ SC_(-0.18e2), SC_(0.316179637908935546875e2), SC_(-0.00023901575251688605208583560833464109956416747994429) }}, 
      {{ SC_(-0.18e2), SC_(0.4073618316650390625e2), SC_(-0.11839490191618530482818106654764624779374885038387) }}, 
      {{ SC_(-0.18e2), SC_(0.4175042724609375e2), SC_(-0.069347614372438511573888068819635203849826313252682) }}, 
      {{ SC_(-0.18e2), SC_(0.452895965576171875e2), SC_(0.059730519514700666103251443517585969183359305233517) }}, 
      {{ SC_(-0.18e2), SC_(0.45668792724609375e2), SC_(0.023109881423974345171115075245556454652055923022744) }}, 
      {{ SC_(-0.18e2), SC_(0.48443389892578125e2), SC_(-0.078056207456894244223013538407624819214242782788305) }}, 
      {{ SC_(-0.21e2), SC_(0.48770198822021484375e1), SC_(-32426551518.894051285463013148095286317045026076992) }}, 
      {{ SC_(-0.21e2), SC_(0.6349340915679931640625e1), SC_(-118218969.61184147928069788088763566979953965101345) }}, 
      {{ SC_(-0.21e2), SC_(0.677385044097900390625e1), SC_(-30357038.501635637985496998943515026355790836656393) }}, 
      {{ SC_(-0.21e2), SC_(0.941909885406494140625e1), SC_(-35456.563664501714282677463457898030749419225629776) }}, 
      {{ SC_(-0.21e2), SC_(0.110517024993896484375e2), SC_(-1567.4125644098158392861721296189576573724930738037) }}, 
      {{ SC_(-0.21e2), SC_(0.139249114990234375e2), SC_(-23.310752295161508394556961246244398071106143803009) }}, 
      {{ SC_(-0.21e2), SC_(0.15408351898193359375e2), SC_(-4.3249550054841060326583392244203824334951113536241) }}, 
      {{ SC_(-0.21e2), SC_(0.27344074249267578125e2), SC_(0.06968050648178237714673167082777474372734772445624) }}, 
      {{ SC_(-0.21e2), SC_(0.273610286712646484375e2), SC_(0.070769530360723733909096587089415158879384142866224) }}, 
      {{ SC_(-0.21e2), SC_(0.316179637908935546875e2), SC_(-0.051442123909106267094585391645995039863049077013) }}, 
      {{ SC_(-0.21e2), SC_(0.4073618316650390625e2), SC_(-0.11564820186007698778472652855905730688034142277644) }}, 
      {{ SC_(-0.21e2), SC_(0.4175042724609375e2), SC_(-0.077727282966915925937165527008896248637090601890297) }}, 
      {{ SC_(-0.21e2), SC_(0.452895965576171875e2), SC_(0.079122132589946330461785329196996655234318950600283) }}, 
      {{ SC_(-0.21e2), SC_(0.45668792724609375e2), SC_(0.048568903107998745819744324100936560896446872483671) }}, 
      {{ SC_(-0.21e2), SC_(0.48443389892578125e2), SC_(-0.097567386084824530395214852322983977335275972560591) }}, 
      {{ SC_(-0.24e2), SC_(0.48770198822021484375e1), SC_(26289960802934.082608708841147700282255454538432831) }}, 
      {{ SC_(-0.24e2), SC_(0.6349340915679931640625e1), SC_(42444187024.864993639906718517083937959093739819213) }}, 
      {{ SC_(-0.24e2), SC_(0.677385044097900390625e1), SC_(8905165738.1617635753564077929245707945923585336582) }}, 
      {{ SC_(-0.24e2), SC_(0.941909885406494140625e1), SC_(3634321.5442039460661559071457665992751570979246975) }}, 
      {{ SC_(-0.24e2), SC_(0.110517024993896484375e2), SC_(94515.961244512444689922061656081899659856471090796) }}, 
      {{ SC_(-0.24e2), SC_(0.139249114990234375e2), SC_(626.18301458184447852887624600335110845539610441982) }}, 
      {{ SC_(-0.24e2), SC_(0.15408351898193359375e2), SC_(79.911561903902024000856092587915172800182935213878) }}, 
      {{ SC_(-0.24e2), SC_(0.27344074249267578125e2), SC_(0.099454622211355675505522195073627509577222223103601) }}, 
      {{ SC_(-0.24e2), SC_(0.273610286712646484375e2), SC_(0.099162302609370648487883563189979652760636886508713) }}, 
      {{ SC_(-0.24e2), SC_(0.316179637908935546875e2), SC_(-0.10908680861998570652086740663868683119510177450605) }}, 
      {{ SC_(-0.24e2), SC_(0.4073618316650390625e2), SC_(-0.11129543680992245949374091128651896371286644223509) }}, 
      {{ SC_(-0.24e2), SC_(0.4175042724609375e2), SC_(-0.063488094293844672624986005840880912989768564883766) }}, 
      {{ SC_(-0.24e2), SC_(0.452895965576171875e2), SC_(0.078126299129191161396544974669601116848381158526221) }}, 
      {{ SC_(-0.24e2), SC_(0.45668792724609375e2), SC_(0.049840732061834370351470644321434031151919856919046) }}, 
      {{ SC_(-0.24e2), SC_(0.48443389892578125e2), SC_(-0.10079256748662579469151151861923727959579543696994) }}, 
      {{ SC_(-0.27e2), SC_(0.48770198822021484375e1), SC_(-31017824262464205.958922559044949943484549490014899) }}, 
      {{ SC_(-0.27e2), SC_(0.6349340915679931640625e1), SC_(-22287656180663.776550451924127829416344261218622021) }}, 
      {{ SC_(-0.27e2), SC_(0.677385044097900390625e1), SC_(-3827294108368.0269477489175011506684599186679706028) }}, 
      {{ SC_(-0.27e2), SC_(0.941909885406494140625e1), SC_(-553452300.42086466143593900814779697132451520767782) }}, 
      {{ SC_(-0.27e2), SC_(0.110517024993896484375e2), SC_(-8566892.1158216005165229082457376277122137372641643) }}, 
      {{ SC_(-0.27e2), SC_(0.139249114990234375e2), SC_(-25958.533112834960868223842958165131229136881394218) }}, 
      {{ SC_(-0.27e2), SC_(0.15408351898193359375e2), SC_(-2309.8576016157815610381647716726001900524325387095) }}, 
      {{ SC_(-0.27e2), SC_(0.27344074249267578125e2), SC_(-0.08099659940919648317037232979698365838482593005533) }}, 
      {{ SC_(-0.27e2), SC_(0.273610286712646484375e2), SC_(-0.081046163182037289343213329934406500421020236167807) }}, 
      {{ SC_(-0.27e2), SC_(0.316179637908935546875e2), SC_(-0.05997017052459651429776257861064997372115830929981) }}, 
      {{ SC_(-0.27e2), SC_(0.4073618316650390625e2), SC_(-0.089026779236655439306747197547569837142730685735217) }}, 
      {{ SC_(-0.27e2), SC_(0.4175042724609375e2), SC_(-0.021438159628553820535251710024804945286350255466981) }}, 
      {{ SC_(-0.27e2), SC_(0.452895965576171875e2), SC_(0.057458660615255706893932512836671665537833151249683) }}, 
      {{ SC_(-0.27e2), SC_(0.45668792724609375e2), SC_(0.027918066346637812012925498454295026871243236870744) }}, 
      {{ SC_(-0.27e2), SC_(0.48443389892578125e2), SC_(-0.094852397559838420167904128907281089951412940428068) }}, 
      {{ SC_(-0.3e2), SC_(0.48770198822021484375e1), SC_(51047805094444915063.333972384442857646750917105255) }}, 
      {{ SC_(-0.3e2), SC_(0.6349340915679931640625e1), SC_(16383102364504657.097626404256533774954655403814735) }}, 
      {{ SC_(-0.3e2), SC_(0.677385044097900390625e1), SC_(2305453816631632.4478139713758256232529472786452094) }}, 
      {{ SC_(-0.3e2), SC_(0.941909885406494140625e1), SC_(119286399723.96948995243483416160315007693317901977) }}, 
      {{ SC_(-0.3e2), SC_(0.110517024993896484375e2), SC_(1107948868.4390402247872007846532974135401516448132) }}, 
      {{ SC_(-0.3e2), SC_(0.139249114990234375e2), SC_(1564768.8656094805647196181978525233011545246750146) }}, 
      {{ SC_(-0.3e2), SC_(0.15408351898193359375e2), SC_(98282.976702067437341601339115870666184004269015844) }}, 
      {{ SC_(-0.3e2), SC_(0.27344074249267578125e2), SC_(0.19426958828428270666812923273493625784124197340643) }}, 
      {{ SC_(-0.3e2), SC_(0.273610286712646484375e2), SC_(0.1922870069086762100422786971721769201830182179905) }}, 
      {{ SC_(-0.3e2), SC_(0.316179637908935546875e2), SC_(0.085040964411023393193600821835060363883104461261538) }}, 
      {{ SC_(-0.3e2), SC_(0.4073618316650390625e2), SC_(-0.02086294150730270321392666880482032167648202293403) }}, 
      {{ SC_(-0.3e2), SC_(0.4175042724609375e2), SC_(0.048501611304693111134238234911984551582655085974503) }}, 
      {{ SC_(-0.3e2), SC_(0.452895965576171875e2), SC_(0.0098774343791820136743763395941918252659795932690156) }}, 
      {{ SC_(-0.3e2), SC_(0.45668792724609375e2), SC_(-0.019197410220079478634724234058346009802242986327455) }}, 
      {{ SC_(-0.3e2), SC_(0.48443389892578125e2), SC_(-0.074251974302542033395913173976920034281355438987303) }}, 
      {{ SC_(-0.33e2), SC_(0.48770198822021484375e1), SC_(-113310124431031716627385.91623741559578636226008379) }}, 
      {{ SC_(-0.33e2), SC_(0.6349340915679931640625e1), SC_(-16284768158670280961.604853254743947587783561845935) }}, 
      {{ SC_(-0.33e2), SC_(0.677385044097900390625e1), SC_(-1879579971334458550.0209315456503043018172175411525) }}, 
      {{ SC_(-0.33e2), SC_(0.941909885406494140625e1), SC_(-35044107725219.415933141084947955744131571076383029) }}, 
      {{ SC_(-0.33e2), SC_(0.110517024993896484375e2), SC_(-196454719531.31055502571353703844742324599224473623) }}, 
      {{ SC_(-0.33e2), SC_(0.139249114990234375e2), SC_(-131079022.88298813501066382467823552303127727679092) }}, 
      {{ SC_(-0.33e2), SC_(0.15408351898193359375e2), SC_(-5863205.6341090078994947632551555595618121658266577) }}, 
      {{ SC_(-0.33e2), SC_(0.27344074249267578125e2), SC_(-1.3242759675178380835227038550532227941618439965275) }}, 
      {{ SC_(-0.33e2), SC_(0.273610286712646484375e2), SC_(-1.3070821666105919146179915919703087795546279872479) }}, 
      {{ SC_(-0.33e2), SC_(0.316179637908935546875e2), SC_(-0.092775041898807041996549652733686199659471661637115) }}, 
      {{ SC_(-0.33e2), SC_(0.4073618316650390625e2), SC_(0.074809135843522356183357158092422716971233783348844) }}, 
      {{ SC_(-0.33e2), SC_(0.4175042724609375e2), SC_(0.096701180934889236997529237286456260917410858440076) }}, 
      {{ SC_(-0.33e2), SC_(0.452895965576171875e2), SC_(-0.059168520937287434505352110295139281109352732673869) }}, 
      {{ SC_(-0.33e2), SC_(0.45668792724609375e2), SC_(-0.077387513866829929522830987608788569701941362335678) }}, 
      {{ SC_(-0.33e2), SC_(0.48443389892578125e2), SC_(-0.025479086779207825088453626785298095143292950737504) }}, 
      {{ SC_(-0.36e2), SC_(0.48770198822021484375e1), SC_(330048915457133176792757969.19546385390292172778597) }}, 
      {{ SC_(-0.36e2), SC_(0.6349340915679931640625e1), SC_(21283101385947682361972.840132590419161428885017457) }}, 
      {{ SC_(-0.36e2), SC_(0.677385044097900390625e1), SC_(2016152494766581360835.0504944450703514404854547839) }}, 
      {{ SC_(-0.36e2), SC_(0.941909885406494140625e1), SC_(13617455449122061.068709501045586245491742471368046) }}, 
      {{ SC_(-0.36e2), SC_(0.110517024993896484375e2), SC_(46274454905211.252127952159355719758860166499400318) }}, 
      {{ SC_(-0.36e2), SC_(0.139249114990234375e2), SC_(14731989754.500661692405589251873227863072825516593) }}, 
      {{ SC_(-0.36e2), SC_(0.15408351898193359375e2), SC_(472329065.6172406656655897442844993936137336820298) }}, 
      {{ SC_(-0.36e2), SC_(0.27344074249267578125e2), SC_(12.787295405204896555560940160313152313443275264338) }}, 
      {{ SC_(-0.36e2), SC_(0.273610286712646484375e2), SC_(12.588907409422241796189531532767810029397750718971) }}, 
      {{ SC_(-0.36e2), SC_(0.316179637908935546875e2), SC_(0.44398715499310217152742945736029055864118125700699) }}, 
      {{ SC_(-0.36e2), SC_(0.4073618316650390625e2), SC_(0.059771595940645434876799492212853292605241870315072) }}, 
      {{ SC_(-0.36e2), SC_(0.4175042724609375e2), SC_(0.024220545303928498022831122772010841761272851374084) }}, 
      {{ SC_(-0.36e2), SC_(0.452895965576171875e2), SC_(-0.092054570614800303323225793224546040095800678797729) }}, 
      {{ SC_(-0.36e2), SC_(0.45668792724609375e2), SC_(-0.087461263710685434648051908910007785680384783167529) }}, 
      {{ SC_(-0.36e2), SC_(0.48443389892578125e2), SC_(0.049106729103063607273231564081511781845090054115039) }}, 
      {{ SC_(-0.39e2), SC_(0.48770198822021484375e1), SC_(-1233144102125191868058726282714.6830526557816276367) }}, 
      {{ SC_(-0.39e2), SC_(0.6349340915679931640625e1), SC_(-35733094276591308750831994.91797625565199706304289) }}, 
      {{ SC_(-0.39e2), SC_(0.677385044097900390625e1), SC_(-2779662682018203595705190.2488317078949818104640352) }}, 
      {{ SC_(-0.39e2), SC_(0.941909885406494140625e1), SC_(-6828848630729733874.6283845233979310836359827708449) }}, 
      {{ SC_(-0.39e2), SC_(0.110517024993896484375e2), SC_(-14113135389756253.156077739699714394718999334850357) }}, 
      {{ SC_(-0.39e2), SC_(0.139249114990234375e2), SC_(-2159972792100.1357173196703249379848507903363330106) }}, 
      {{ SC_(-0.39e2), SC_(0.15408351898193359375e2), SC_(-49878586414.208299697922098228053037520564208848509) }}, 
      {{ SC_(-0.39e2), SC_(0.27344074249267578125e2), SC_(-172.72481992619044884818471295404381256191132921759) }}, 
      {{ SC_(-0.39e2), SC_(0.273610286712646484375e2), SC_(-169.61196242097930804462875200568886076262770819036) }}, 
      {{ SC_(-0.39e2), SC_(0.316179637908935546875e2), SC_(-3.2622994618084401364015275636183821534990803329434) }}, 
      {{ SC_(-0.39e2), SC_(0.4073618316650390625e2), SC_(-0.071571195500167528763973820425034029241001019664493) }}, 
      {{ SC_(-0.39e2), SC_(0.4175042724609375e2), SC_(-0.077639520094377453336245761486356713117488570968192) }}, 
      {{ SC_(-0.39e2), SC_(0.452895965576171875e2), SC_(-0.0069206374505846927493416208619676332960332679098951) }}, 
      {{ SC_(-0.39e2), SC_(0.45668792724609375e2), SC_(0.0094763994163015924174187344118500435461867666237707) }}, 
      {{ SC_(-0.39e2), SC_(0.48443389892578125e2), SC_(0.088327299286859131076769322427950834999241679006473) }}, 
      {{ SC_(-0.42e2), SC_(0.48770198822021484375e1), SC_(5797280100327646006286194447016368.1421040357707697) }}, 
      {{ SC_(-0.42e2), SC_(0.6349340915679931640625e1), SC_(75578601166571259232436208810.996067950581548988698) }}, 
      {{ SC_(-0.42e2), SC_(0.677385044097900390625e1), SC_(4829803807658038517776138880.8750636464707289573594) }}, 
      {{ SC_(-0.42e2), SC_(0.941909885406494140625e1), SC_(4329641022687304226243.9838984741548022967111467018) }}, 
      {{ SC_(-0.42e2), SC_(0.110517024993896484375e2), SC_(5456026490429871545.3729944237669454258744606641489) }}, 
      {{ SC_(-0.42e2), SC_(0.139249114990234375e2), SC_(403762667331377.86957440262465049860925273699263158) }}, 
      {{ SC_(-0.42e2), SC_(0.15408351898193359375e2), SC_(6740433181763.7883013153961028425354387334429706028) }}, 
      {{ SC_(-0.42e2), SC_(0.27344074249267578125e2), SC_(3158.6690245857765078107696571619682944747448675175) }}, 
      {{ SC_(-0.42e2), SC_(0.273610286712646484375e2), SC_(3094.1963154921271936768553380051122786210511409107) }}, 
      {{ SC_(-0.42e2), SC_(0.316179637908935546875e2), SC_(32.753934200718819822753904740576448091608604066055) }}, 
      {{ SC_(-0.42e2), SC_(0.4073618316650390625e2), SC_(0.072739550630497079350234032861134498649735287193357) }}, 
      {{ SC_(-0.42e2), SC_(0.4175042724609375e2), SC_(0.060663112127386998497369088801481071129124522975233) }}, 
      {{ SC_(-0.42e2), SC_(0.452895965576171875e2), SC_(0.074473609380746711803311040389966933497838989432121) }}, 
      {{ SC_(-0.42e2), SC_(0.45668792724609375e2), SC_(0.073158536052064850884139711362229851982735439619744) }}, 
      {{ SC_(-0.42e2), SC_(0.48443389892578125e2), SC_(0.0062529560822924696318936561241723289563898043333544) }}, 
      {{ SC_(-0.45e2), SC_(0.48770198822021484375e1), SC_(-33733682510800680224442906671745094195.324494135316) }}, 
      {{ SC_(-0.45e2), SC_(0.6349340915679931640625e1), SC_(-198048437155168311381273880967818.22025824791036357) }}, 
      {{ SC_(-0.45e2), SC_(0.677385044097900390625e1), SC_(-10400456700923638671729643118843.806753044982298564) }}, 
      {{ SC_(-0.45e2), SC_(0.941909885406494140625e1), SC_(-3410735613885115350035572.8765307548785858388367401) }}, 
      {{ SC_(-0.45e2), SC_(0.110517024993896484375e2), SC_(-2626095967757200551970.6681963242828834151760822985) }}, 
      {{ SC_(-0.45e2), SC_(0.139249114990234375e2), SC_(-94401205462334537.050369109209833432350639718533638) }}, 
      {{ SC_(-0.45e2), SC_(0.15408351898193359375e2), SC_(-1142618566412157.8272585956706570352616937041979656) }}, 
      {{ SC_(-0.45e2), SC_(0.27344074249267578125e2), SC_(-75694.686584044680788645716511158348946476145181086) }}, 
      {{ SC_(-0.45e2), SC_(0.273610286712646484375e2), SC_(-73976.413466431635423703776127097751893371684622957) }}, 
      {{ SC_(-0.45e2), SC_(0.316179637908935546875e2), SC_(-442.20546817943409312426292528886668861618504431741) }}, 
      {{ SC_(-0.45e2), SC_(0.4073618316650390625e2), SC_(-0.28228421314539279160628746389504552227153533768146) }}, 
      {{ SC_(-0.45e2), SC_(0.4175042724609375e2), SC_(-0.16000300625233986775481590043192514396457873354516) }}, 
      {{ SC_(-0.45e2), SC_(0.452895965576171875e2), SC_(-0.057231962290387109238731129148921559725799147998496) }}, 
      {{ SC_(-0.45e2), SC_(0.45668792724609375e2), SC_(-0.058252022623339984507829779588426189048862620281189) }}, 
      {{ SC_(-0.45e2), SC_(0.48443389892578125e2), SC_(-0.071183141732921385630773244674279719514795336041612) }}, 
      {{ SC_(-0.48e2), SC_(0.48770198822021484375e1), SC_(239522804322893748319138034551047145275789.59974224) }}, 
      {{ SC_(-0.48e2), SC_(0.6349340915679931640625e1), SC_(633761731337958689992254732836509014.5498517746032) }}, 
      {{ SC_(-0.48e2), SC_(0.677385044097900390625e1), SC_(27357238520963102125309576744667666.363300351401482) }}, 
      {{ SC_(-0.48e2), SC_(0.941909885406494140625e1), SC_(3288814657352135263627844511.2333600813675095369837) }}, 
      {{ SC_(-0.48e2), SC_(0.110517024993896484375e2), SC_(1549742039352820886974060.3190714284655739926493718) }}, 
      {{ SC_(-0.48e2), SC_(0.139249114990234375e2), SC_(27161074177867080159.469660549620941382353430766586) }}, 
      {{ SC_(-0.48e2), SC_(0.15408351898193359375e2), SC_(238916331621456340.65432311640997088065900397861155) }}, 
      {{ SC_(-0.48e2), SC_(0.27344074249267578125e2), SC_(2314888.4958806745629333835711192432287758316461507) }}, 
      {{ SC_(-0.48e2), SC_(0.273610286712646484375e2), SC_(2257224.1679332711454029660320148577090226354529857) }}, 
      {{ SC_(-0.48e2), SC_(0.316179637908935546875e2), SC_(7789.7419442918626296378651092715214256586181141926) }}, 
      {{ SC_(-0.48e2), SC_(0.4073618316650390625e2), SC_(1.6743462295916778715636314008207178423626071094632) }}, 
      {{ SC_(-0.48e2), SC_(0.4175042724609375e2), SC_(0.84969906096968362082642019200637971882884732293335) }}, 
      {{ SC_(-0.48e2), SC_(0.452895965576171875e2), SC_(0.11278671656985116240884620256968696962764469071367) }}, 
      {{ SC_(-0.48e2), SC_(0.45668792724609375e2), SC_(0.095078000040189495106936435411946264505165465416578) }}, 
      {{ SC_(-0.48e2), SC_(0.48443389892578125e2), SC_(0.055062921732975958664266463964777750754001901274629) }}, 
      {{ SC_(-0.51e2), SC_(0.48770198822021484375e1), SC_(-2049587659777558411382317923670496261583806542.493) }}, 
      {{ SC_(-0.51e2), SC_(0.6349340915679931640625e1), SC_(-2445662164833856435631550255588074712252.7787749918) }}, 
      {{ SC_(-0.51e2), SC_(0.677385044097900390625e1), SC_(-86796605852598653796484179209256273156.253707461952) }}, 
      {{ SC_(-0.51e2), SC_(0.941909885406494140625e1), SC_(-3831606243141839102073334951299.4701624472926032508) }}, 
      {{ SC_(-0.51e2), SC_(0.110517024993896484375e2), SC_(-1106493595140034197852895923.9584737671557915697202) }}, 
      {{ SC_(-0.51e2), SC_(0.139249114990234375e2), SC_(-9483467934688543751821.1137053292897138412310640169) }}, 
      {{ SC_(-0.51e2), SC_(0.15408351898193359375e2), SC_(-60738635966410164385.958394741410769406835938636865) }}, 
      {{ SC_(-0.51e2), SC_(0.27344074249267578125e2), SC_(-88424622.376034322983107041268281421004180860038753) }}, 
      {{ SC_(-0.51e2), SC_(0.273610286712646484375e2), SC_(-86031981.243325241428625701075048702697378800248637) }}, 
      {{ SC_(-0.51e2), SC_(0.316179637908935546875e2), SC_(-174400.37651200557082226548445824464332272001897389) }}, 
      {{ SC_(-0.51e2), SC_(0.4073618316650390625e2), SC_(-12.946971229042316120764442921458399845772849822588) }}, 
      {{ SC_(-0.51e2), SC_(0.4175042724609375e2), SC_(-5.8742140283607909770485379763421722194017038516076) }}, 
      {{ SC_(-0.51e2), SC_(0.452895965576171875e2), SC_(-0.53428720443828699337032810544888204576810977989968) }}, 
      {{ SC_(-0.51e2), SC_(0.45668792724609375e2), SC_(-0.42592959561863366613058593411801927675297445385356) }}, 
      {{ SC_(-0.51e2), SC_(0.48443389892578125e2), SC_(-0.098276023559531896826463662674167711540316451897657) }}, 
      {{ SC_(-0.54e2), SC_(0.48770198822021484375e1), SC_(20905232114169109167897938189126912891970672725780.) }}, 
      {{ SC_(-0.54e2), SC_(0.6349340915679931640625e1), SC_(11255611402596222741806443152512714449896034.95219) }}, 
      {{ SC_(-0.54e2), SC_(0.677385044097900390625e1), SC_(328484211508316631140190398742844071477057.53311607) }}, 
      {{ SC_(-0.54e2), SC_(0.941909885406494140625e1), SC_(5332364035387341126441890302814550.845507841895594) }}, 
      {{ SC_(-0.54e2), SC_(0.110517024993896484375e2), SC_(944771189815878803007600403368.88711953482139956825) }}, 
      {{ SC_(-0.54e2), SC_(0.139249114990234375e2), SC_(3969726457350851108670819.0270483967952145392521967) }}, 
      {{ SC_(-0.54e2), SC_(0.15408351898193359375e2), SC_(18541154623928634844579.547640967624705965729178149) }}, 
      {{ SC_(-0.54e2), SC_(0.27344074249267578125e2), SC_(4144817285.7784820213261562080665118413906287256562) }}, 
      {{ SC_(-0.54e2), SC_(0.273610286712646484375e2), SC_(4023965578.8512166042035503785698368524454260668606) }}, 
      {{ SC_(-0.54e2), SC_(0.316179637908935546875e2), SC_(4857254.3742754162567243110228728128894050129680029) }}, 
      {{ SC_(-0.54e2), SC_(0.4073618316650390625e2), SC_(129.89939453279762160168461742626340596331738244806) }}, 
      {{ SC_(-0.54e2), SC_(0.4175042724609375e2), SC_(52.754642545813458576257416292629942980318201317708) }}, 
      {{ SC_(-0.54e2), SC_(0.452895965576171875e2), SC_(3.2987655306543891212696806805571326443655047812012) }}, 
      {{ SC_(-0.54e2), SC_(0.45668792724609375e2), SC_(2.5329424546885397623237023579281554373385389203592) }}, 
      {{ SC_(-0.54e2), SC_(0.48443389892578125e2), SC_(0.43686549121581194580641150930324084070959640013132) }}, 
      {{ SC_(-0.57e2), SC_(0.48770198822021484375e1), SC_(-2.5169620918755273734751531423307576059487175279655e+53) }}, 
      {{ SC_(-0.57e2), SC_(0.6349340915679931640625e1), SC_(-61174688555597945848882268589437960109494141523.722) }}, 
      {{ SC_(-0.57e2), SC_(0.677385044097900390625e1), SC_(-1468327769614117292538317982499132738351648371.0919) }}, 
      {{ SC_(-0.57e2), SC_(0.941909885406494140625e1), SC_(-8775550580287280317417400764353784961.2905042914466) }}, 
      {{ SC_(-0.57e2), SC_(0.110517024993896484375e2), SC_(-954844116271064617066023153137696.40337364841548845) }}, 
      {{ SC_(-0.57e2), SC_(0.139249114990234375e2), SC_(-1971019683890416712446520517.8326914674121514444488) }}, 
      {{ SC_(-0.57e2), SC_(0.15408351898193359375e2), SC_(-6722219396128901574730218.8067982561390314098778667) }}, 
      {{ SC_(-0.57e2), SC_(0.27344074249267578125e2), SC_(-234893166288.30075812707849294929137851408290558752) }}, 
      {{ SC_(-0.57e2), SC_(0.273610286712646484375e2), SC_(-227560854653.85630205561022254001943293553067305038) }}, 
      {{ SC_(-0.57e2), SC_(0.316179637908935546875e2), SC_(-165348515.80872034084037746268766135137511007672989) }}, 
      {{ SC_(-0.57e2), SC_(0.4073618316650390625e2), SC_(-1653.302868841762906988170344844615332445062274303) }}, 
      {{ SC_(-0.57e2), SC_(0.4175042724609375e2), SC_(-604.06199987707091212985973850451313161553226079994) }}, 
      {{ SC_(-0.57e2), SC_(0.452895965576171875e2), SC_(-26.147826903085700377751404608708294778930527661864) }}, 
      {{ SC_(-0.57e2), SC_(0.45668792724609375e2), SC_(-19.308053041721125835516802702079181838332215102344) }}, 
      {{ SC_(-0.57e2), SC_(0.48443389892578125e2), SC_(-2.5283615374731968791601022506604160830005801823799) }}, 
      {{ SC_(-0.6e2), SC_(0.48770198822021484375e1), SC_(3.5460365231745721606669570215996512793241495164453e+57) }}, 
      {{ SC_(-0.6e2), SC_(0.6349340915679931640625e1), SC_(3.8921264262571733782239747560313526684108210623487e+50) }}, 
      {{ SC_(-0.6e2), SC_(0.677385044097900390625e1), SC_(7684237767558382594304235657570772453674248757118.3) }}, 
      {{ SC_(-0.6e2), SC_(0.941909885406494140625e1), SC_(16925416951539066399686670852829412815863.412431411) }}, 
      {{ SC_(-0.6e2), SC_(0.110517024993896484375e2), SC_(1131875640030290021946077924988533695.7888332928356) }}, 
      {{ SC_(-0.6e2), SC_(0.139249114990234375e2), SC_(1149875928909540701676477111822.3170039080211561671) }}, 
      {{ SC_(-0.6e2), SC_(0.15408351898193359375e2), SC_(2866796552399774210995844116.7096924369139910645819) }}, 
      {{ SC_(-0.6e2), SC_(0.27344074249267578125e2), SC_(15891355189739.495516567349164999419111229531478334) }}, 
      {{ SC_(-0.6e2), SC_(0.273610286712646484375e2), SC_(15363127336068.368075911095109876542431338831991157) }}, 
      {{ SC_(-0.6e2), SC_(0.316179637908935546875e2), SC_(6779161464.8028951527640884369288557214558713468535) }}, 
      {{ SC_(-0.6e2), SC_(0.4073618316650390625e2), SC_(26113.831472455968890083544404266110113626724773258) }}, 
      {{ SC_(-0.6e2), SC_(0.4175042724609375e2), SC_(8623.033736775565340846565423848796418156287767396) }}, 
      {{ SC_(-0.6e2), SC_(0.452895965576171875e2), SC_(262.71208466116252796487792402891053270786603888051) }}, 
      {{ SC_(-0.6e2), SC_(0.45668792724609375e2), SC_(186.83227369709377348524356398249111029234112960347) }}, 
      {{ SC_(-0.6e2), SC_(0.48443389892578125e2), SC_(18.589647091617037033086402220922012445990916760661) }},
   }};
