<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="es" xml:lang="es"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Autenticacin y Autorizacin - Servidor Apache HTTP Versin 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Mdulos</a> | <a href="../mod/directives.html">Directivas</a> | <a href="http://wiki.apache.org/httpd/FAQ">Preguntas Frecuentes</a> | <a href="../glossary.html">Glosario</a> | <a href="../sitemap.html">Mapa del sitio web</a></p>
<p class="apache">Versin 2.4 del Servidor HTTP Apache</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Servidor HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentacin</a> &gt; <a href="../">Versin 2.4</a> &gt; <a href="./">How-To / Tutoriales</a></div><div id="page-content"><div id="preamble"><h1>Autenticacin y Autorizacin</h1>
<div class="toplang">
<p><span>Idiomas disponibles: </span><a href="../en/howto/auth.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/howto/auth.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/howto/auth.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/auth.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/auth.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/howto/auth.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>Autenticacin es cualquier proceso por el cul se verifica que uno es 
    quien dice ser. Autorizacin es cualquier proceso en el cul cualquiera
    est permitido a estar donde se quiera, o tener informacin la cul se
    quiera tener.
    </p>

    <p>Para informacin de control de acceso de forma genrica visite<a href="access.html">How to de Control de Acceso</a>.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#related">Mdulos y Directivas Relacionados</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduccin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#theprerequisites">Los Prerequisitos</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#gettingitworking">Conseguir que funcione</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#lettingmorethanonepersonin">Dejar que ms de una persona 
	entre</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#possibleproblems">Posibles Problemas</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#dbmdbd">Mtodo alternativo de almacenamiento de las 
	contraseas</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#multprovider">Uso de mltiples proveedores</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#beyond">Ms all de la Autorizacin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#socache">Cache de Autenticacin</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#moreinformation">Ms informacin</a></li>
</ul><h3>Consulte tambin</h3><ul class="seealso"><li><a href="#comments_section">Comentarios</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Mdulos y Directivas Relacionados</a></h2>

<p>Hay tres tipos de mdulos involucrados en los procesos de la autenticacin 
	y autorizacin. Normalmente debers escoger al menos un mdulo de cada grupo.</p>

<ul>
  <li>Modos de Autenticacin (consulte la directiva
      <code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code> )
    <ul>
      <li><code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code></li>
      <li><code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code></li>
    </ul>
  </li>
  <li>Proveedor de Autenticacin (consulte la directiva
  <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> y
  <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>)

    <ul>
      <li><code class="module"><a href="../mod/mod_authn_anon.html">mod_authn_anon</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code></li>
      <li><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code></li>
      <li><code class="module"><a href="../mod/mod_authn_socache.html">mod_authn_socache</a></code></li>
    </ul>
  </li>
  <li>Autorizacin (consulte la directiva
      <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>)
    <ul>
      <li><code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_dbd.html">mod_authz_dbd</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code></li>
      <li><code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code></li>
    </ul>
  </li>
</ul>

  <p>A parte de stos mdulos, tambin estn
  <code class="module"><a href="../mod/mod_authn_core.html">mod_authn_core</a></code> y
  <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code>. stos mdulos implementan las directivas 
  esenciales que son el centro de todos los mdulos de autenticacin.</p>

  <p>El mdulo <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code> es tanto un proveedor de 
  autenticacin como de autorizacin. El mdulo
  <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> proporciona autorizacin y control de acceso
  basado en el nombre del Host, la direccin IP o caractersticas de la propia
  peticin, pero no es parte del sistema proveedor de 
  autenticacin. Para tener compatibilidad inversa con el mod_access, 
  hay un nuevo modulo llamado <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code>.</p>

  <p>Tambin puedes mirar el how-to de <a href="access.html">Control de Acceso </a>, donde se plantean varias formas del control de acceso al servidor.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduccin</a></h2>
    <p>Si se tiene informacin en nuestra pgina web que sea informacin 
    	sensible o pensada para un grupo reducido de usuarios/personas,
    	las tcnicas que se describen en este manual, le servirn  
    	de ayuda para asegurarse de que las personas que ven esas pginas sean 
    	las personas que uno quiere.</p>

    <p>Este artculo cubre la parte "estndar" de cmo proteger partes de un 
    	sitio web que muchos usarn.</p>

    <div class="note"><h3>Nota:</h3>
    <p>Si de verdad es necesario que tus datos estn en un sitio seguro, 
    	considera usar <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>  como mtodo de autenticacin adicional a cualquier forma de autenticacin.</p>
    </div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="theprerequisites" id="theprerequisites">Los Prerequisitos</a></h2>
    <p>Las directivas que se usan en este artculo necesitaran ponerse ya sea 
    	en el fichero de configuracin principal del servidor ( tpicamente en 
    	la seccin 
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> de httpd.conf ), o
    en cada uno de los ficheros de configuraciones del propio directorio
    (los archivos <code>.htaccess</code>).</p>

    <p>Si planea usar los ficheros <code>.htaccess</code> , necesitars
    tener en la configuracin global del servidor, una configuracin que permita
    poner directivas de autenticacin en estos ficheros. Esto se hace con la
    directiva <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>, la cual especifica
    que directivas, en su caso, pueden ser puestas en cada fichero de configuracin
    por directorio.</p>

    <p>Ya que estamos hablando aqu de autenticacin, necesitars una directiva 
    	<code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code> como la siguiente:
    	</p>

    <pre class="prettyprint lang-config">AllowOverride AuthConfig</pre>


    <p>O, si solo se van a poner las directivas directamente en la configuracin
    	principal del servidor, debers tener, claro est, permisos de escritura
    	en el archivo. </p>

    <p>Y necesitars saber un poco de como est estructurado el rbol de 
    	directorios de tu servidor, para poder saber donde se encuentran algunos 
    	archivos. Esto no debera ser una tarea difcil, an as intentaremos 
    	dejarlo claro llegado el momento de comentar dicho aspecto.</p>

    <p>Tambin debers de asegurarte de que los mdulos 
    <code class="module"><a href="../mod/mod_authn_core.html">mod_authn_core</a></code> y <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code>
    han sido incorporados, o aadidos a la hora de compilar en tu binario httpd o
    cargados mediante el archivo de configuracin <code>httpd.conf</code>. Estos 
    dos mdulos proporcionan directivas bsicas y funcionalidades que son crticas
    para la configuracin y uso de autenticacin y autorizacin en el servidor web.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="gettingitworking" id="gettingitworking">Conseguir que funcione</a></h2>
    <p>Aqu est lo bsico de cmo proteger con contrasea un directorio en tu
     servidor.</p>

    <p>Primero, necesitars crear un fichero de contrasea. Dependiendo de que 
    	proveedor de autenticacin se haya elegido, se har de una forma u otra. Para empezar, 
    	usaremos un fichero de contrasea de tipo texto.</p>

    <p>Este fichero deber estar en un sitio que no se pueda tener acceso desde
     la web. Esto tambin implica que nadie pueda descargarse el fichero de 
     contraseas. Por ejemplo, si tus documentos estn guardados fuera de
     <code>/usr/local/apache/htdocs</code>, querrs poner tu archivo de contraseas en 
     <code>/usr/local/apache/passwd</code>.</p>

    <p>Para crear el fichero de contraseas, usa la utilidad 
    	<code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> que viene con Apache. Esta herramienta se 
    	encuentra en el directorio <code>/bin</code> en donde sea que se ha 
    	instalado el Apache. Si ha instalado Apache desde un paquete de terceros, 
    	puede ser que se encuentre en su ruta de ejecucin.</p>

    <p>Para crear el fichero, escribiremos:</p>

    <div class="example"><p><code>
      htpasswd -c /usr/local/apache/passwd/passwords rbowen
    </code></p></div>

    <p><code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> te preguntar por una contrasea, y despus 
    te pedir que la vuelvas a escribir para confirmarla:</p>

    <div class="example"><p><code>
      $ htpasswd -c /usr/local/apache/passwd/passwords rbowen<br />
      New password: mypassword<br />
      Re-type new password: mypassword<br />
      Adding password for user rbowen
    </code></p></div>

    <p>Si <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code> no est en tu variable de entorno "path" del 
    sistema, por supuesto debers escribir la ruta absoluta del ejecutable para 
    poder hacer que se ejecute. En una instalacin por defecto, est en:
    <code>/usr/local/apache2/bin/htpasswd</code></p>

    <p>Lo prximo que necesitas, ser configurar el servidor para que pida una 
    	contrasea y as decirle al servidor que usuarios estn autorizados a acceder.
    	Puedes hacer esto ya sea editando el fichero <code>httpd.conf</code>
    de configuracin  o usando in fichero <code>.htaccess</code>. Por ejemplo, 
    si quieres proteger el directorio
    <code>/usr/local/apache/htdocs/secret</code>, puedes usar las siguientes 
    directivas, ya sea en el fichero <code>.htaccess</code> localizado en
    following directives, either placed in the file
    <code>/usr/local/apache/htdocs/secret/.htaccess</code>, o
    en la configuracin global del servidor <code>httpd.conf</code> dentro de la
    seccin &lt;Directory  
    "/usr/local/apache/htdocs/secret"&gt; , como se muestra a continuacin:</p>

    <pre class="prettyprint lang-config">&lt;Directory "/usr/local/apache/htdocs/secret"&gt;
AuthType Basic
AuthName "Restricted Files"
# (Following line optional)
AuthBasicProvider file
AuthUserFile "/usr/local/apache/passwd/passwords"
Require user rbowen
&lt;/Directory&gt;</pre>


    <p>Vamos a explicar cada una de las directivas individualmente.
    	La directiva <code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code> selecciona el mtodo
    que se usa para autenticar al usuario. El mtodo ms comn es 
    <code>Basic</code>, y ste es el mtodo que implementa 
    <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>. Es muy importante ser consciente,
    de que la autenticacin bsica, enva las contraseas desde el cliente 
    al servidor sin cifrar.
    Este mtodo por tanto, no debe ser utilizado para proteger datos muy sensibles,
    a no ser que, este mtodo de autenticacin bsica, sea acompaado del mdulo
    <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>.
    Apache soporta otro mtodo ms de autenticacin  que es del tipo 
    <code>AuthType Digest</code>. Este mtodo, es implementado por el mdulo <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code> y con el se pretenda crear una autenticacin ms
    segura. Este ya no es el caso, ya que la conexin deber realizarse con  <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> en su lugar.
    </p>

    <p>La directiva <code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code> 
    establece el <dfn>Realm</dfn> para ser usado en la autenticacin. El 
    <dfn>Realm</dfn> tiene dos funciones principales.
    La primera, el cliente presenta a menudo esta informacin al usuario como 
    parte del cuadro de dilogo de contrasea. La segunda, que es utilizado por 
    el cliente para determinar qu contrasea enviar a para una determinada zona 
    de autenticacin.</p>

    <p>As que, por ejemple, una vez que el cliente se ha autenticado en el rea de
    los <code>"Ficheros Restringidos"</code>, entonces re-intentar automticamente
    la misma contrasea para cualquier rea en el mismo servidor que es marcado 
    con el Realm de <code>"Ficheros Restringidos"</code>
    Por lo tanto, puedes prevenir que a un usuario se le pida mas de una vez por su
    contrasea, compartiendo as varias reas restringidas el mismo Realm
    Por supuesto, por razones de seguridad, el cliente pedir siempre por una contrasea, 
    siempre y cuando el nombre del servidor cambie.
    </p>

    <p>La directiva <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> es,
    en este caso, opcional, ya que <code>file</code> es el valor por defecto
    para esta directiva. Debers usar esta directiva si estas usando otro medio
    diferente para la autenticacin, como por ejemplo
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> o <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code>.</p>

    <p>La directiva <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>
    establece el path al fichero de contraseas que acabamos de crear con el 
    comando <code class="program"><a href="../programs/htpasswd.html">htpasswd</a></code>. Si tiene un nmero muy grande de usuarios, 
    puede ser realmente lento el buscar el usuario en ese fichero de texto plano 
    para autenticar a los usuarios en cada peticin.
    Apache tambin tiene la habilidad de almacenar informacin de usuarios en 
    unos ficheros de rpido acceso a modo de base de datos.
    El mdulo <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> proporciona la directiva <code class="directive"><a href="../mod/mod_authn_dbm.html#authdbmuserfile">AuthDBMUserFile</a></code>. Estos ficheros pueden ser creados y
    manipulados con el programa <code class="program"><a href="../programs/dbmmanage.html">dbmmanage</a></code> y <code class="program"><a href="../programs/htdbm.html">htdbm</a></code>. 
    Muchos otros mtodos de autenticacin as como otras opciones, estn disponibles en 
    mdulos de terceros 
    <a href="http://modules.apache.org/">Base de datos de Mdulos disponibles</a>.</p>

    <p>Finalmente, la directiva <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>
    proporciona la parte del proceso de autorizacin estableciendo el o los
    usuarios que se les est permitido acceder a una regin del servidor.
    En la prxima seccin, discutiremos las diferentes vas de utilizar la 
    directiva <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="lettingmorethanonepersonin" id="lettingmorethanonepersonin">Dejar que ms de una persona 
	entre</a></h2>
    <p>Las directivas mencionadas arriba slo permiten a una persona 
    (especialmente con un usuario que en ej ejemplo es <code>rbowen</code>) 
    en el directorio. En la mayora de los casos, se querr permitir el acceso
    a ms de una persona. Aqu es donde la directiva 
    <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code> entra en juego.</p>

    <p>Si lo que se desea es permitir a ms de una persona el acceso, necesitars
     crear un archivo de grupo que asocie los nombres de grupos con el de personas
     para permitirles el acceso. El formato de este fichero es bastante sencillo, 
     y puedes crearlo con tu editor de texto favorito. El contenido del fichero 
     se parecer a:</p>

   <div class="example"><p><code>
     GroupName: rbowen dpitts sungo rshersey
   </code></p></div>

    <p>Bsicamente eso es la lista de miembros los cuales estn en un mismo fichero
     de grupo en una sola linea separados por espacios.</p>

    <p>Para aadir un usuario a tu fichero de contraseas existente teclee:</p>

    <div class="example"><p><code>
      htpasswd /usr/local/apache/passwd/passwords dpitts
    </code></p></div>

    <p>Te responder lo mismo que anteriormente, pero se aadir al fichero 
    	existente en vez de crear uno nuevo. (Es decir el flag <code>-c</code> ser 
    	el que haga que se genere un nuevo 
    fichero de contraseas).</p>

    <p>Ahora, tendr que modificar su fichero <code>.htaccess</code> para que sea 
    parecido a lo siguiente:</p>

    <pre class="prettyprint lang-config">AuthType Basic
AuthName "By Invitation Only"
# Optional line:
AuthBasicProvider file
AuthUserFile "/usr/local/apache/passwd/passwords"
AuthGroupFile "/usr/local/apache/passwd/groups"
Require group GroupName</pre>


    <p>Ahora, cualquiera que est listado en el grupo <code>GroupName</code>,
    y tiene una entrada en el fichero de <code>contraseas</code>, se les 
    permitir el acceso, si introducen su contrasea correctamente.</p>

    <p>Hay otra manera de dejar entrar a varios usuarios, que es menos especfica.
    En lugar de crear un archivo de grupo, slo puede utilizar la siguiente 
    directiva:</p>

    <pre class="prettyprint lang-config">Require valid-user</pre>


    <p>Usando sto en vez de la lnea <code>Require user rbowen</code>
     permitir a cualquier persona acceder, la cul aparece en el archivo de 
     contraseas, y que introduzca correctamente su contrasea. Incluso puede 
     emular el comportamiento del grupo aqu, slo manteniendo un fichero de 
     contraseas independiente para cada grupo. La ventaja de este enfoque es 
     que Apache slo tiene que comprobar un archivo, en lugar de dos. La desventaja 
     es que se tiene que mantener un montn de ficheros de contrasea de grupo, y 
     recuerde hacer referencia al fichero correcto en la directiva
    <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="possibleproblems" id="possibleproblems">Posibles Problemas</a></h2>
    <p>Debido a la forma en que se especifica la autenticacin bsica,
    su nombre de usuario y la contrasea deben ser verificados cada vez 
    que se solicita un documento desde el servidor. Esto es, incluso si&nbsp;
    se&nbsp; vuelve a cargar la misma pgina, y para cada imagen de la pgina (si
&nbsp;&nbsp;&nbsp;&nbsp;provienen de un directorio protegido). Como se puede imaginar, esto
&nbsp;&nbsp;&nbsp;&nbsp;ralentiza las cosas un poco. La cantidad que ralentiza las cosas es 
    proporcional al tamao del archivo de contraseas, porque tiene que 
    abrir ese archivo, recorrer&nbsp;lista de usuarios hasta que llega a su nombre.
    Y tiene que hacer esto cada vez que se carga una pgina.</p>

    <p>Una consecuencia de esto, es que hay un limite prctico de cuantos 
    usuarios puedes introducir en el fichero de contraseas. Este lmite
    variar dependiendo de la mquina en la que tengas el servidor,
    pero puedes notar ralentizaciones en cuanto se metan cientos de entradas,
    y por lo tanto consideraremos entonces otro mtodo de autenticacin
    en ese momento.
	</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="dbmdbd" id="dbmdbd">Mtodo alternativo de almacenamiento de las 
	contraseas</a></h2>

    <p>Debido a que el almacenamiento de las contraseas en texto plano tiene 
    	el problema mencionado anteriormente, puede que se prefiera guardar 
    	las contraseas en otro lugar como por ejemplo una base de datos.
    	</p>

    <p>Los mdulos <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> y <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> son
    dos mdulos que hacen esto posible. En vez de seleccionar la directiva de fichero
    <code><code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> </code>, en su lugar
    se puede elegir <code>dbm</code> o <code>dbd</code> como formato de almacenamiento.</p>

    <p>Para seleccionar los ficheros de tipo dbm en vez de texto plano, podremos hacer algo parecido a lo siguiente:</p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/docs/private"&gt;
    AuthName "Private"
    AuthType Basic
    AuthBasicProvider dbm
    AuthDBMUserFile "/www/passwords/passwd.dbm"
    Require valid-user
&lt;/Directory&gt;</pre>


    <p>Hay otras opciones disponibles. Consulta la documentacin de
    <code class="module"><a href="../mod/mod_authn_dbm.html">mod_authn_dbm</a></code> para ms detalles.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="multprovider" id="multprovider">Uso de mltiples proveedores</a></h2>

    <p>Con la introduccin de la nueva autenticacin basada en un proveedor y
     una arquitectura de autorizacin, ya no estaremos restringidos a un nico
     mtodo de autenticacin o autorizacin. De hecho, cualquier nmero de 
     los proveedores pueden ser mezclados y emparejados para ofrecerle 
     exactamente el esquema que se adapte a sus necesidades. 
     En el siguiente ejemplo, veremos como ambos proveedores tanto el fichero 
     como el LDAP son usados en la autenticacin:
     </p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/docs/private"&gt;
    AuthName "Private"
    AuthType Basic
    AuthBasicProvider file ldap
    AuthUserFile "/usr/local/apache/passwd/passwords"
    AuthLDAPURL ldap://ldaphost/o=yourorg
    Require valid-user
&lt;/Directory&gt;</pre>


    <p>En este ejemplo el fichero, que acta como proveedor, intentar autenticar 
    	primero al usuario. Si no puede autenticar al usuario, el proveedor del LDAP
    	ser llamado para que realice la autenticacin.
    	Esto permite al mbito de autenticacin ser amplio, si su organizacin 
    	implementa ms de un tipo de almacn de autenticacin. 
    	Otros escenarios de autenticacin y autorizacin pueden incluir la 
    	mezcla de un tipo de autenticacin con un tipo diferente de autorizacin.
    	Por ejemplo, autenticar contra un fichero de contraseas pero autorizando
    	dicho acceso mediante el directorio del LDAP.</p>

    <p>As como mltiples mtodos y proveedores de autenticacin pueden 
    	ser implementados, tambin pueden usarse mltiples formas de 
    	autorizacin.
    	En este ejemplo ambos ficheros de autorizacin de grupo as como 
    	autorizacin de grupo mediante LDAP va a ser usado:
    </p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/docs/private"&gt;
    AuthName "Private"
    AuthType Basic
    AuthBasicProvider file
    AuthUserFile "/usr/local/apache/passwd/passwords"
    AuthLDAPURL ldap://ldaphost/o=yourorg
    AuthGroupFile "/usr/local/apache/passwd/groups"
    Require group GroupName
    Require ldap-group cn=mygroup,o=yourorg
&lt;/Directory&gt;</pre>


    <p>Para llevar la autorizacin un poco ms lejos, las directivas 
    	de autorizacin de contenedores tales como
    <code class="directive"><a href="../mod/mod_authz_core.html#requireall">&lt;RequireAll&gt;</a></code>
    and
    <code class="directive"><a href="../mod/mod_authz_core.html#requireany">&lt;RequireAny&gt;</a></code>
    nos permiten aplicar una lgica de en qu orden se manejar la autorizacin dependiendo
    de la configuracin y controlada a travs de ella.
    Mire tambin <a href="../mod/mod_authz_core.html#logic">Contenedores de
    Autorizacin</a> para ejemplos de cmo pueden ser aplicados.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="beyond" id="beyond">Ms all de la Autorizacin</a></h2>

    <p>El modo en que la autorizacin puede ser aplicada es ahora mucho ms flexible
    	que us solo chequeo contra un almacn de datos (contraseas). Ordenando la 
    	lgica y escoger la forma en que la autorizacin es realizada, ahora es posible 
    </p>

    <h3><a name="authandororder" id="authandororder">Aplicando la lgica y ordenacin</a></h3>
        <p>Controlar el cmo y en qu orden se va a aplicar la autorizacin ha 
        	sido un misterio en el pasado. En Apache 2.2 un proveedor del 
        	mecanismo de autenticacin fue introducido para disociar el proceso actual
        	de autenticacin y soportar funcionalidad.
        	Uno de los beneficios secundarios fue que los proveedores de autenticacin
        	podan ser configurados y llamados en un orden especifico que no dependieran
        	en el orden de carga del propio modulo. 
        	Este proveedor de dicho mecanismo, ha sido introducido en la autorizacin
        	tambin. Lo que esto significa es que la directiva 
        	<code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> 
        	no slo especifica que mtodo de autorizacin deber ser usado, si no
        	tambin especifica el orden en que van a ser llamados. Mltiples
        	mtodos de autorizacin son llamados en el mismo orden en que la directiva
            <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> aparece en la
            configuracin.
        </p>

        <p>
        	Con la Introduccin del contenedor de directivas de autorizacin tales como
	        <code class="directive"><a href="../mod/mod_authz_core.html#requireall">&lt;RequireAll&gt;</a></code>
	        y
	        <code class="directive"><a href="../mod/mod_authz_core.html#requireany">&lt;RequireAny&gt;</a></code>,
	        La configuracin tambin tiene control sobre cundo se llaman a los mtodos
	        de autorizacin y qu criterios determinan cundo se concede el acceso.
	        Vease
	        <a href="../mod/mod_authz_core.html#logic">Contenedores de autorizacin</a>
	        Para un ejemplo de cmo pueden ser utilizados para expresar una lgica 
	        ms compleja de autorizacin.
	    </p>

        <p>
        	Por defecto todas las directivas 
        	<code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>
       		son manejadas como si estuvieran contenidas en una directiva
       		<code class="directive"><a href="../mod/mod_authz_core.html#requireany">&lt;RequireAny&gt;</a></code>.
       		En otras palabras, Si alguno de los mtodos de autorizacin 
       		especificados tiene xito, se concede la autorizacin.
       	</p>

    

    <h3><a name="reqaccessctrl" id="reqaccessctrl">Uso de los proveedores de autorizacin para 
    	el control de acceso</a></h3>

    	<p>
    		La autenticacin de nombre de usuario y contrasea es slo parte
    		de toda la historia que conlleva el proceso. Frecuentemente quiere
    		dar acceso a la gente en base a algo ms que lo que son.
    		Algo como de donde vienen.
    	</p>

        <p>
        	Los proveedores de autorizacin <code>all</code>,
        	<code>env</code>, <code>host</code> y <code>ip</code>
        	te permiten denegar o permitir el acceso basndose en otros
        	criterios como el nombre de la mquina o la IP de la mquina que
        	realiza la consulta para un documento.
        </p>

        <p>
        	El uso de estos proveedores se especifica a travs de la directiva
        	<code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>.
        	La directiva registra los proveedores de autorizacin que sern llamados
        	durante la solicitud de la fase del proceso de autorizacin. Por ejemplo:
        </p>

        <pre class="prettyprint lang-config">Require ip <var>address</var>
        </pre>


        <p>
        	Donde <var>address</var> es una direccin IP (o una direccin IP parcial) 
        	o bien:
        </p>

        <pre class="prettyprint lang-config">Require host <var>domain_name</var>
        </pre>


        <p>
        	Donde <var>domain_name</var> es el nombre completamente cualificado de un nombre 
	        de dominio (FQDN) (o un nombre parcial del dominio);
	        puede proporcionar mltiples direcciones o nombres de dominio, si se desea.
        </p>

        <p>
        	Por ejemplo, si alguien enva spam a su tabln de mensajes y desea
        	mantenerlos alejados, podra hacer lo siguiente:</p>

        <pre class="prettyprint lang-config">&lt;RequireAll&gt;
    Require all granted
    Require not ip 10.252.46.165
&lt;/RequireAll&gt;</pre>


        <p>
        	Visitantes que vengan desde esa IP no sern capaces de ver el contenido
        	que cubre esta directiva. Si, en cambio, lo que se tiene es el nombre de
        	la mquina, en vez de la direccin IP, podra usar:
        </p>

        <pre class="prettyprint lang-config">&lt;RequireAll&gt;
    Require all granted
    Require not host host.example.com
&lt;/RequireAll&gt;</pre>


        <p>
        	Y, si lo que se quiere es bloquear el acceso desde un determinado dominio
        	(bloquear el acceso desde el dominio entero), puede especificar parte 
        	de la direccin o del propio dominio a bloquear:
        </p>

        <pre class="prettyprint lang-config">&lt;RequireAll&gt;
    Require all granted
    Require not ip 192.168.205
    Require not host phishers.example.com moreidiots.example
    Require not host ke
&lt;/RequireAll&gt;</pre>


        <p>
        	Usando <code class="directive"><a href="../mod/mod_authz_core.html#requireall">&lt;RequireAll&gt;</a></code>
	        con mltiples directivas <code class="directive"><a href="../mod/mod_authz_core.html#require">&lt;Require&gt;</a></code>, cada una negada con un <code>not</code>,
	        Slo permitir el acceso, si todas las condiciones negadas son verdaderas.
	        En otras palabras, el acceso ser bloqueado, si cualquiera de las condiciones
	        negadas fallara.
        </p>

    

    <h3><a name="filesystem" id="filesystem">Compatibilidad de Control de Acceso con versiones 
    	anteriores </a></h3>

        <p>
        	Uno de los efectos secundarios de adoptar proveedores basados en 
        	mecanismos de autenticacin es que las directivas anteriores
	        <code class="directive"><a href="../mod/mod_access_compat.html#order">Order</a></code>,
	        <code class="directive"><a href="../mod/mod_access_compat.html#allow">Allow</a></code>,
	        <code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code> y
        	<code class="directive"><a href="../mod/mod_access_compat.html#satisfy">Satisfy</a></code> ya no son necesarias.
        	Sin embargo, para proporcionar compatibilidad con configuraciones antiguas,
        	estas directivas se han movido al mdulo <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code>.
        </p>

        <div class="warning"><h3>Nota:</h3>
	        <p>
	        	Las directivas proporcionadas por <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code> 
	        	han quedado obsoletas por <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>. Mezclar 
	        	directivas antiguas como
	        	<code class="directive"><a href="../mod/mod_access_compat.html#order">Order</a></code>, 
	            <code class="directive"><a href="../mod/mod_access_compat.html#allow">Allow</a></code>  
	            <code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code> con las nuevas 
	            como 
	            <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> 
	            es tcnicamente posible pero desaconsejable. El mdulo 
	            <code class="module"><a href="../mod/mod_access_compat.html">mod_access_compat</a></code> se cre para soportar configuraciones
	            que contuvieran slo directivas antiguas para facilitar la actualizacin
	            a la versin 2.4.
	            Por favor revise la documentacin de 
	            <a href="../upgrading.html">actualizacin</a> para ms informacin al
	            respecto.
	        </p>
	    </div>
	

	</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="socache" id="socache">Cache de Autenticacin</a></h2>
	<p>
		Puede haber momentos en que la autenticacin ponga una carga 
		inaceptable en el proveedor (de autenticacin) o en tu red.
		Esto suele afectar a los usuarios de <code class="module"><a href="../mod/mod_authn_dbd.html">mod_authn_dbd</a></code> 
		(u otros proveedores de terceros/personalizados).
		Para lidiar con este problema, HTTPD 2.3/2.4 introduce un nuevo proveedor
		de cach  <code class="module"><a href="../mod/mod_authn_socache.html">mod_authn_socache</a></code> para cachear las credenciales 
		y reducir la carga en el proveedor(es) original.
	</p>
    <p>
    	Esto puede ofrecer un aumento de rendimiento sustancial para algunos usuarios.
    </p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="moreinformation" id="moreinformation">Ms informacin</a></h2>

    <p>
    	Tambin debera leer la documentacin para
    	<code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code> y <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>
    	la cul contiene ms informacin de como funciona todo esto.
    	La directiva <code class="directive"><a href="../mod/mod_authn_core.html#authnprovideralias">&lt;AuthnProviderAlias&gt;</a></code> puede tambin ayudar 
	    a la hora de simplificar ciertas configuraciones de autenticacin.
	</p>

    <p>
    	Los diferentes algoritmos de cifrado que estn soportados por Apache
    	para la autenticacin se explican en
    	<a href="../misc/password_encryptions.html">Cifrado de Contraseas</a>.
    </p>

    <p>
    	Y tal vez quiera ojear la documentacin de "how to"  
    	<a href="access.html">Control de Acceso</a>  donde se mencionan temas 
    	relacionados.</p>

</div></div>
<div class="bottomlang">
<p><span>Idiomas disponibles: </span><a href="../en/howto/auth.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../es/howto/auth.html" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="../fr/howto/auth.html" hreflang="fr" rel="alternate" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/auth.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/auth.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../tr/howto/auth.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Comentarios</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/howto/auth.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Licencia bajo los trminos de <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Mdulos</a> | <a href="../mod/directives.html">Directivas</a> | <a href="http://wiki.apache.org/httpd/FAQ">Preguntas Frecuentes</a> | <a href="../glossary.html">Glosario</a> | <a href="../sitemap.html">Mapa del sitio web</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>