// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from egl.xml and egl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_egl_ext_autogen.cpp:
//   Defines the EGL Extension entry points.

#include "libGLESv2/entry_points_egl_ext_autogen.h"

#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL_autogen.h"
#include "libGLESv2/egl_ext_stubs_autogen.h"
#include "libGLESv2/global_state.h"

using namespace egl;

extern "C" {

// EGL_ANDROID_blob_cache
void EGLAPIENTRY EGL_SetBlobCacheFuncsANDROID(EGLDisplay dpy,
                                              EGLSetBlobFuncANDROID set,
                                              EGLGetBlobFuncANDROID get)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(SetBlobCacheFuncsANDROID,
              "dpy = 0x%016" PRIxPTR ", set = 0x%016" PRIxPTR ", get = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)set, (uintptr_t)get);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE_VOID(thread, SetBlobCacheFuncsANDROID, GetDisplayIfValid(dpyPacked),
                            dpyPacked, set, get);

    SetBlobCacheFuncsANDROID(thread, dpyPacked, set, get);
}

// EGL_ANDROID_create_native_client_buffer
EGLClientBuffer EGLAPIENTRY EGL_CreateNativeClientBufferANDROID(const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateNativeClientBufferANDROID, "attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreateNativeClientBufferANDROID, nullptr, EGLClientBuffer,
                       attrib_listPacked);

    return CreateNativeClientBufferANDROID(thread, attrib_listPacked);
}

// EGL_ANDROID_get_frame_timestamps
EGLBoolean EGLAPIENTRY EGL_GetCompositorTimingSupportedANDROID(EGLDisplay dpy,
                                                               EGLSurface surface,
                                                               EGLint name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetCompositorTimingSupportedANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", name = %d", (uintptr_t)dpy,
              (uintptr_t)surface, name);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked     = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked      = PackParam<Surface *>(surface);
    CompositorTiming namePacked = PackParam<CompositorTiming>(name);

    ANGLE_EGL_VALIDATE(thread, GetCompositorTimingSupportedANDROID, GetDisplayIfValid(dpyPacked),
                       EGLBoolean, dpyPacked, surfacePacked, namePacked);

    return GetCompositorTimingSupportedANDROID(thread, dpyPacked, surfacePacked, namePacked);
}

EGLBoolean EGLAPIENTRY EGL_GetCompositorTimingANDROID(EGLDisplay dpy,
                                                      EGLSurface surface,
                                                      EGLint numTimestamps,
                                                      const EGLint *names,
                                                      EGLnsecsANDROID *values)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetCompositorTimingANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR
              ", numTimestamps = %d, names = 0x%016" PRIxPTR ", values = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, numTimestamps, (uintptr_t)names,
              (uintptr_t)values);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, GetCompositorTimingANDROID, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, numTimestamps, names, values);

    return GetCompositorTimingANDROID(thread, dpyPacked, surfacePacked, numTimestamps, names,
                                      values);
}

EGLBoolean EGLAPIENTRY EGL_GetNextFrameIdANDROID(EGLDisplay dpy,
                                                 EGLSurface surface,
                                                 EGLuint64KHR *frameId)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetNextFrameIdANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", frameId = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, (uintptr_t)frameId);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, GetNextFrameIdANDROID, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, frameId);

    return GetNextFrameIdANDROID(thread, dpyPacked, surfacePacked, frameId);
}

EGLBoolean EGLAPIENTRY EGL_GetFrameTimestampSupportedANDROID(EGLDisplay dpy,
                                                             EGLSurface surface,
                                                             EGLint timestamp)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetFrameTimestampSupportedANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", timestamp = %d",
              (uintptr_t)dpy, (uintptr_t)surface, timestamp);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked   = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked    = PackParam<Surface *>(surface);
    Timestamp timestampPacked = PackParam<Timestamp>(timestamp);

    ANGLE_EGL_VALIDATE(thread, GetFrameTimestampSupportedANDROID, GetDisplayIfValid(dpyPacked),
                       EGLBoolean, dpyPacked, surfacePacked, timestampPacked);

    return GetFrameTimestampSupportedANDROID(thread, dpyPacked, surfacePacked, timestampPacked);
}

EGLBoolean EGLAPIENTRY EGL_GetFrameTimestampsANDROID(EGLDisplay dpy,
                                                     EGLSurface surface,
                                                     EGLuint64KHR frameId,
                                                     EGLint numTimestamps,
                                                     const EGLint *timestamps,
                                                     EGLnsecsANDROID *values)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetFrameTimestampsANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR
              ", frameId = %llu, numTimestamps = %d, timestamps = 0x%016" PRIxPTR
              ", values = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, static_cast<unsigned long long>(frameId),
              numTimestamps, (uintptr_t)timestamps, (uintptr_t)values);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, GetFrameTimestampsANDROID, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, frameId, numTimestamps, timestamps, values);

    return GetFrameTimestampsANDROID(thread, dpyPacked, surfacePacked, frameId, numTimestamps,
                                     timestamps, values);
}

// EGL_ANDROID_get_native_client_buffer
EGLClientBuffer EGLAPIENTRY EGL_GetNativeClientBufferANDROID(const struct AHardwareBuffer *buffer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetNativeClientBufferANDROID, "buffer = 0x%016" PRIxPTR "", (uintptr_t)buffer);

    Thread *thread = egl::GetCurrentThread();

    ANGLE_EGL_VALIDATE(thread, GetNativeClientBufferANDROID, nullptr, EGLClientBuffer, buffer);

    return GetNativeClientBufferANDROID(thread, buffer);
}

// EGL_ANDROID_native_fence_sync
EGLint EGLAPIENTRY EGL_DupNativeFenceFDANDROID(EGLDisplay dpy, EGLSyncKHR sync)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(DupNativeFenceFDANDROID, "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)sync);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, DupNativeFenceFDANDROID, GetDisplayIfValid(dpyPacked), EGLint,
                       dpyPacked, syncPacked);

    return DupNativeFenceFDANDROID(thread, dpyPacked, syncPacked);
}

// EGL_ANDROID_presentation_time
EGLBoolean EGLAPIENTRY EGL_PresentationTimeANDROID(EGLDisplay dpy,
                                                   EGLSurface surface,
                                                   EGLnsecsANDROID time)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(PresentationTimeANDROID,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", time = %llu", (uintptr_t)dpy,
              (uintptr_t)surface, static_cast<unsigned long long>(time));

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, PresentationTimeANDROID, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, time);

    return PresentationTimeANDROID(thread, dpyPacked, surfacePacked, time);
}

// EGL_ANGLE_device_creation
EGLDeviceEXT EGLAPIENTRY EGL_CreateDeviceANGLE(EGLint device_type,
                                               void *native_device,
                                               const EGLAttrib *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateDeviceANGLE,
              "device_type = %d, native_device = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR
              "",
              device_type, (uintptr_t)native_device, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    ANGLE_EGL_VALIDATE(thread, CreateDeviceANGLE, nullptr, EGLDeviceEXT, device_type, native_device,
                       attrib_list);

    return CreateDeviceANGLE(thread, device_type, native_device, attrib_list);
}

EGLBoolean EGLAPIENTRY EGL_ReleaseDeviceANGLE(EGLDeviceEXT device)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ReleaseDeviceANGLE, "device = 0x%016" PRIxPTR "", (uintptr_t)device);

    Thread *thread = egl::GetCurrentThread();

    Device *devicePacked = PackParam<Device *>(device);

    ANGLE_EGL_VALIDATE(thread, ReleaseDeviceANGLE, nullptr, EGLBoolean, devicePacked);

    return ReleaseDeviceANGLE(thread, devicePacked);
}

// EGL_ANGLE_feature_control
const char *EGLAPIENTRY EGL_QueryStringiANGLE(EGLDisplay dpy, EGLint name, EGLint index)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryStringiANGLE, "dpy = 0x%016" PRIxPTR ", name = %d, index = %d", (uintptr_t)dpy,
              name, index);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE(thread, QueryStringiANGLE, GetDisplayIfValid(dpyPacked), const char *,
                       dpyPacked, name, index);

    return QueryStringiANGLE(thread, dpyPacked, name, index);
}

EGLBoolean EGLAPIENTRY EGL_QueryDisplayAttribANGLE(EGLDisplay dpy,
                                                   EGLint attribute,
                                                   EGLAttrib *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryDisplayAttribANGLE,
              "dpy = 0x%016" PRIxPTR ", attribute = %d, value = 0x%016" PRIxPTR "", (uintptr_t)dpy,
              attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE(thread, QueryDisplayAttribANGLE, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, attribute, value);

    return QueryDisplayAttribANGLE(thread, dpyPacked, attribute, value);
}

// EGL_ANGLE_power_preference
void EGLAPIENTRY EGL_ReleaseHighPowerGPUANGLE(EGLDisplay dpy, EGLContext ctx)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ReleaseHighPowerGPUANGLE, "dpy = 0x%016" PRIxPTR ", ctx = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)ctx);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    gl::Context *ctxPacked  = PackParam<gl::Context *>(ctx);

    ANGLE_EGL_VALIDATE_VOID(thread, ReleaseHighPowerGPUANGLE, GetDisplayIfValid(dpyPacked),
                            dpyPacked, ctxPacked);

    ReleaseHighPowerGPUANGLE(thread, dpyPacked, ctxPacked);
}

void EGLAPIENTRY EGL_ReacquireHighPowerGPUANGLE(EGLDisplay dpy, EGLContext ctx)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ReacquireHighPowerGPUANGLE, "dpy = 0x%016" PRIxPTR ", ctx = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)ctx);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    gl::Context *ctxPacked  = PackParam<gl::Context *>(ctx);

    ANGLE_EGL_VALIDATE_VOID(thread, ReacquireHighPowerGPUANGLE, GetDisplayIfValid(dpyPacked),
                            dpyPacked, ctxPacked);

    ReacquireHighPowerGPUANGLE(thread, dpyPacked, ctxPacked);
}

void EGLAPIENTRY EGL_HandleGPUSwitchANGLE(EGLDisplay dpy)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(HandleGPUSwitchANGLE, "dpy = 0x%016" PRIxPTR "", (uintptr_t)dpy);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE_VOID(thread, HandleGPUSwitchANGLE, GetDisplayIfValid(dpyPacked), dpyPacked);

    HandleGPUSwitchANGLE(thread, dpyPacked);
}

// EGL_ANGLE_program_cache_control
EGLint EGLAPIENTRY EGL_ProgramCacheGetAttribANGLE(EGLDisplay dpy, EGLenum attrib)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ProgramCacheGetAttribANGLE, "dpy = 0x%016" PRIxPTR ", attrib = 0x%X", (uintptr_t)dpy,
              attrib);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE(thread, ProgramCacheGetAttribANGLE, GetDisplayIfValid(dpyPacked), EGLint,
                       dpyPacked, attrib);

    return ProgramCacheGetAttribANGLE(thread, dpyPacked, attrib);
}

void EGLAPIENTRY EGL_ProgramCacheQueryANGLE(EGLDisplay dpy,
                                            EGLint index,
                                            void *key,
                                            EGLint *keysize,
                                            void *binary,
                                            EGLint *binarysize)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ProgramCacheQueryANGLE,
              "dpy = 0x%016" PRIxPTR ", index = %d, key = 0x%016" PRIxPTR
              ", keysize = 0x%016" PRIxPTR ", binary = 0x%016" PRIxPTR
              ", binarysize = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, index, (uintptr_t)key, (uintptr_t)keysize, (uintptr_t)binary,
              (uintptr_t)binarysize);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE_VOID(thread, ProgramCacheQueryANGLE, GetDisplayIfValid(dpyPacked), dpyPacked,
                            index, key, keysize, binary, binarysize);

    ProgramCacheQueryANGLE(thread, dpyPacked, index, key, keysize, binary, binarysize);
}

void EGLAPIENTRY EGL_ProgramCachePopulateANGLE(EGLDisplay dpy,
                                               const void *key,
                                               EGLint keysize,
                                               const void *binary,
                                               EGLint binarysize)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ProgramCachePopulateANGLE,
              "dpy = 0x%016" PRIxPTR ", key = 0x%016" PRIxPTR
              ", keysize = %d, binary = 0x%016" PRIxPTR ", binarysize = %d",
              (uintptr_t)dpy, (uintptr_t)key, keysize, (uintptr_t)binary, binarysize);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE_VOID(thread, ProgramCachePopulateANGLE, GetDisplayIfValid(dpyPacked),
                            dpyPacked, key, keysize, binary, binarysize);

    ProgramCachePopulateANGLE(thread, dpyPacked, key, keysize, binary, binarysize);
}

EGLint EGLAPIENTRY EGL_ProgramCacheResizeANGLE(EGLDisplay dpy, EGLint limit, EGLint mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ProgramCacheResizeANGLE, "dpy = 0x%016" PRIxPTR ", limit = %d, mode = %d",
              (uintptr_t)dpy, limit, mode);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE(thread, ProgramCacheResizeANGLE, GetDisplayIfValid(dpyPacked), EGLint,
                       dpyPacked, limit, mode);

    return ProgramCacheResizeANGLE(thread, dpyPacked, limit, mode);
}

// EGL_ANGLE_query_surface_pointer
EGLBoolean EGLAPIENTRY EGL_QuerySurfacePointerANGLE(EGLDisplay dpy,
                                                    EGLSurface surface,
                                                    EGLint attribute,
                                                    void **value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QuerySurfacePointerANGLE,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR
              ", attribute = %d, value = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, QuerySurfacePointerANGLE, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, attribute, value);

    return QuerySurfacePointerANGLE(thread, dpyPacked, surfacePacked, attribute, value);
}

// EGL_ANGLE_stream_producer_d3d_texture
EGLBoolean EGLAPIENTRY EGL_CreateStreamProducerD3DTextureANGLE(EGLDisplay dpy,
                                                               EGLStreamKHR stream,
                                                               const EGLAttrib *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateStreamProducerD3DTextureANGLE,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR
              "",
              (uintptr_t)dpy, (uintptr_t)stream, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    Stream *streamPacked                  = PackParam<Stream *>(stream);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreateStreamProducerD3DTextureANGLE, GetDisplayIfValid(dpyPacked),
                       EGLBoolean, dpyPacked, streamPacked, attrib_listPacked);

    return CreateStreamProducerD3DTextureANGLE(thread, dpyPacked, streamPacked, attrib_listPacked);
}

EGLBoolean EGLAPIENTRY EGL_StreamPostD3DTextureANGLE(EGLDisplay dpy,
                                                     EGLStreamKHR stream,
                                                     void *texture,
                                                     const EGLAttrib *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamPostD3DTextureANGLE,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR ", texture = 0x%016" PRIxPTR
              ", attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream, (uintptr_t)texture, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    Stream *streamPacked                  = PackParam<Stream *>(stream);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, StreamPostD3DTextureANGLE, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, streamPacked, texture, attrib_listPacked);

    return StreamPostD3DTextureANGLE(thread, dpyPacked, streamPacked, texture, attrib_listPacked);
}

// EGL_ANGLE_swap_with_frame_token
EGLBoolean EGLAPIENTRY EGL_SwapBuffersWithFrameTokenANGLE(EGLDisplay dpy,
                                                          EGLSurface surface,
                                                          EGLFrameTokenANGLE frametoken)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(SwapBuffersWithFrameTokenANGLE,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", frametoken = 0x%llX",
              (uintptr_t)dpy, (uintptr_t)surface, static_cast<unsigned long long>(frametoken));

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, SwapBuffersWithFrameTokenANGLE, GetDisplayIfValid(dpyPacked),
                       EGLBoolean, dpyPacked, surfacePacked, frametoken);

    return SwapBuffersWithFrameTokenANGLE(thread, dpyPacked, surfacePacked, frametoken);
}

// EGL_ANGLE_sync_control_rate
EGLBoolean EGLAPIENTRY EGL_GetMscRateANGLE(EGLDisplay dpy,
                                           EGLSurface surface,
                                           EGLint *numerator,
                                           EGLint *denominator)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetMscRateANGLE,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", numerator = 0x%016" PRIxPTR
              ", denominator = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, (uintptr_t)numerator, (uintptr_t)denominator);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, GetMscRateANGLE, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       surfacePacked, numerator, denominator);

    return GetMscRateANGLE(thread, dpyPacked, surfacePacked, numerator, denominator);
}

// EGL_CHROMIUM_sync_control
EGLBoolean EGLAPIENTRY EGL_GetSyncValuesCHROMIUM(EGLDisplay dpy,
                                                 EGLSurface surface,
                                                 EGLuint64KHR *ust,
                                                 EGLuint64KHR *msc,
                                                 EGLuint64KHR *sbc)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetSyncValuesCHROMIUM,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", ust = 0x%016" PRIxPTR
              ", msc = 0x%016" PRIxPTR ", sbc = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)surface, (uintptr_t)ust, (uintptr_t)msc, (uintptr_t)sbc);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, GetSyncValuesCHROMIUM, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, ust, msc, sbc);

    return GetSyncValuesCHROMIUM(thread, dpyPacked, surfacePacked, ust, msc, sbc);
}

// EGL_EXT_device_query
EGLBoolean EGLAPIENTRY EGL_QueryDeviceAttribEXT(EGLDeviceEXT device,
                                                EGLint attribute,
                                                EGLAttrib *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryDeviceAttribEXT,
              "device = 0x%016" PRIxPTR ", attribute = %d, value = 0x%016" PRIxPTR "",
              (uintptr_t)device, attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    Device *devicePacked = PackParam<Device *>(device);

    ANGLE_EGL_VALIDATE(thread, QueryDeviceAttribEXT, nullptr, EGLBoolean, devicePacked, attribute,
                       value);

    return QueryDeviceAttribEXT(thread, devicePacked, attribute, value);
}

const char *EGLAPIENTRY EGL_QueryDeviceStringEXT(EGLDeviceEXT device, EGLint name)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryDeviceStringEXT, "device = 0x%016" PRIxPTR ", name = %d", (uintptr_t)device,
              name);

    Thread *thread = egl::GetCurrentThread();

    Device *devicePacked = PackParam<Device *>(device);

    ANGLE_EGL_VALIDATE(thread, QueryDeviceStringEXT, nullptr, const char *, devicePacked, name);

    return QueryDeviceStringEXT(thread, devicePacked, name);
}

EGLBoolean EGLAPIENTRY EGL_QueryDisplayAttribEXT(EGLDisplay dpy, EGLint attribute, EGLAttrib *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryDisplayAttribEXT,
              "dpy = 0x%016" PRIxPTR ", attribute = %d, value = 0x%016" PRIxPTR "", (uintptr_t)dpy,
              attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);

    ANGLE_EGL_VALIDATE(thread, QueryDisplayAttribEXT, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, attribute, value);

    return QueryDisplayAttribEXT(thread, dpyPacked, attribute, value);
}

// EGL_EXT_platform_base
EGLSurface EGLAPIENTRY EGL_CreatePlatformPixmapSurfaceEXT(EGLDisplay dpy,
                                                          EGLConfig config,
                                                          void *native_pixmap,
                                                          const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreatePlatformPixmapSurfaceEXT,
              "dpy = 0x%016" PRIxPTR ", config = 0x%016" PRIxPTR ", native_pixmap = 0x%016" PRIxPTR
              ", attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)config, (uintptr_t)native_pixmap, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    Config *configPacked                  = PackParam<Config *>(config);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreatePlatformPixmapSurfaceEXT, GetDisplayIfValid(dpyPacked),
                       EGLSurface, dpyPacked, configPacked, native_pixmap, attrib_listPacked);

    return CreatePlatformPixmapSurfaceEXT(thread, dpyPacked, configPacked, native_pixmap,
                                          attrib_listPacked);
}

EGLSurface EGLAPIENTRY EGL_CreatePlatformWindowSurfaceEXT(EGLDisplay dpy,
                                                          EGLConfig config,
                                                          void *native_window,
                                                          const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreatePlatformWindowSurfaceEXT,
              "dpy = 0x%016" PRIxPTR ", config = 0x%016" PRIxPTR ", native_window = 0x%016" PRIxPTR
              ", attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)config, (uintptr_t)native_window, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    Config *configPacked                  = PackParam<Config *>(config);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreatePlatformWindowSurfaceEXT, GetDisplayIfValid(dpyPacked),
                       EGLSurface, dpyPacked, configPacked, native_window, attrib_listPacked);

    return CreatePlatformWindowSurfaceEXT(thread, dpyPacked, configPacked, native_window,
                                          attrib_listPacked);
}

EGLDisplay EGLAPIENTRY EGL_GetPlatformDisplayEXT(EGLenum platform,
                                                 void *native_display,
                                                 const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetPlatformDisplayEXT,
              "platform = 0x%X, native_display = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR
              "",
              platform, (uintptr_t)native_display, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, GetPlatformDisplayEXT, nullptr, EGLDisplay, platform, native_display,
                       attrib_listPacked);

    return GetPlatformDisplayEXT(thread, platform, native_display, attrib_listPacked);
}

// EGL_KHR_debug
EGLint EGLAPIENTRY EGL_DebugMessageControlKHR(EGLDEBUGPROCKHR callback,
                                              const EGLAttrib *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(DebugMessageControlKHR,
              "callback = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR "", (uintptr_t)callback,
              (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, DebugMessageControlKHR, nullptr, EGLint, callback,
                       attrib_listPacked);

    return DebugMessageControlKHR(thread, callback, attrib_listPacked);
}

EGLint EGLAPIENTRY EGL_LabelObjectKHR(EGLDisplay display,
                                      EGLenum objectType,
                                      EGLObjectKHR object,
                                      EGLLabelKHR label)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(LabelObjectKHR,
              "display = 0x%016" PRIxPTR ", objectType = 0x%X, object = 0x%016" PRIxPTR
              ", label = 0x%016" PRIxPTR "",
              (uintptr_t)display, objectType, (uintptr_t)object, (uintptr_t)label);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *displayPacked = PackParam<egl::Display *>(display);
    ObjectType objectTypePacked = PackParam<ObjectType>(objectType);

    ANGLE_EGL_VALIDATE(thread, LabelObjectKHR, GetDisplayIfValid(displayPacked), EGLint,
                       displayPacked, objectTypePacked, object, label);

    return LabelObjectKHR(thread, displayPacked, objectTypePacked, object, label);
}

EGLBoolean EGLAPIENTRY EGL_QueryDebugKHR(EGLint attribute, EGLAttrib *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryDebugKHR, "attribute = %d, value = 0x%016" PRIxPTR "", attribute,
              (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    ANGLE_EGL_VALIDATE(thread, QueryDebugKHR, nullptr, EGLBoolean, attribute, value);

    return QueryDebugKHR(thread, attribute, value);
}

// EGL_KHR_fence_sync
EGLint EGLAPIENTRY EGL_ClientWaitSyncKHR(EGLDisplay dpy,
                                         EGLSyncKHR sync,
                                         EGLint flags,
                                         EGLTimeKHR timeout)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(ClientWaitSyncKHR,
              "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR ", flags = %d, timeout = %llu",
              (uintptr_t)dpy, (uintptr_t)sync, flags, static_cast<unsigned long long>(timeout));

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, ClientWaitSyncKHR, GetDisplayIfValid(dpyPacked), EGLint, dpyPacked,
                       syncPacked, flags, timeout);

    return ClientWaitSyncKHR(thread, dpyPacked, syncPacked, flags, timeout);
}

EGLSyncKHR EGLAPIENTRY EGL_CreateSyncKHR(EGLDisplay dpy, EGLenum type, const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateSyncKHR,
              "dpy = 0x%016" PRIxPTR ", type = 0x%X, attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, type, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreateSyncKHR, GetDisplayIfValid(dpyPacked), EGLSyncKHR, dpyPacked,
                       type, attrib_listPacked);

    return CreateSyncKHR(thread, dpyPacked, type, attrib_listPacked);
}

EGLBoolean EGLAPIENTRY EGL_DestroySyncKHR(EGLDisplay dpy, EGLSyncKHR sync)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(DestroySyncKHR, "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR "", (uintptr_t)dpy,
              (uintptr_t)sync);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, DestroySyncKHR, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       syncPacked);

    return DestroySyncKHR(thread, dpyPacked, syncPacked);
}

EGLBoolean EGLAPIENTRY EGL_GetSyncAttribKHR(EGLDisplay dpy,
                                            EGLSyncKHR sync,
                                            EGLint attribute,
                                            EGLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(GetSyncAttribKHR,
              "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR
              ", attribute = %d, value = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)sync, attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, GetSyncAttribKHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, syncPacked, attribute, value);

    return GetSyncAttribKHR(thread, dpyPacked, syncPacked, attribute, value);
}

// EGL_KHR_image
EGLImageKHR EGLAPIENTRY EGL_CreateImageKHR(EGLDisplay dpy,
                                           EGLContext ctx,
                                           EGLenum target,
                                           EGLClientBuffer buffer,
                                           const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateImageKHR,
              "dpy = 0x%016" PRIxPTR ", ctx = 0x%016" PRIxPTR
              ", target = 0x%X, buffer = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)ctx, target, (uintptr_t)buffer, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    gl::Context *ctxPacked                = PackParam<gl::Context *>(ctx);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreateImageKHR, GetDisplayIfValid(dpyPacked), EGLImageKHR, dpyPacked,
                       ctxPacked, target, buffer, attrib_listPacked);

    return CreateImageKHR(thread, dpyPacked, ctxPacked, target, buffer, attrib_listPacked);
}

EGLBoolean EGLAPIENTRY EGL_DestroyImageKHR(EGLDisplay dpy, EGLImageKHR image)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(DestroyImageKHR, "dpy = 0x%016" PRIxPTR ", image = 0x%016" PRIxPTR "", (uintptr_t)dpy,
              (uintptr_t)image);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Image *imagePacked      = PackParam<Image *>(image);

    ANGLE_EGL_VALIDATE(thread, DestroyImageKHR, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       imagePacked);

    return DestroyImageKHR(thread, dpyPacked, imagePacked);
}

// EGL_KHR_reusable_sync
EGLBoolean EGLAPIENTRY EGL_SignalSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(SignalSyncKHR, "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR ", mode = 0x%X",
              (uintptr_t)dpy, (uintptr_t)sync, mode);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, SignalSyncKHR, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       syncPacked, mode);

    return SignalSyncKHR(thread, dpyPacked, syncPacked, mode);
}

// ClientWaitSyncKHR is already defined.

// CreateSyncKHR is already defined.

// DestroySyncKHR is already defined.

// GetSyncAttribKHR is already defined.

// EGL_KHR_stream
EGLStreamKHR EGLAPIENTRY EGL_CreateStreamKHR(EGLDisplay dpy, const EGLint *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(CreateStreamKHR, "dpy = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, CreateStreamKHR, GetDisplayIfValid(dpyPacked), EGLStreamKHR,
                       dpyPacked, attrib_listPacked);

    return CreateStreamKHR(thread, dpyPacked, attrib_listPacked);
}

EGLBoolean EGLAPIENTRY EGL_DestroyStreamKHR(EGLDisplay dpy, EGLStreamKHR stream)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(DestroyStreamKHR, "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, DestroyStreamKHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, streamPacked);

    return DestroyStreamKHR(thread, dpyPacked, streamPacked);
}

EGLBoolean EGLAPIENTRY EGL_QueryStreamKHR(EGLDisplay dpy,
                                          EGLStreamKHR stream,
                                          EGLenum attribute,
                                          EGLint *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryStreamKHR,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR
              ", attribute = 0x%X, value = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream, attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, QueryStreamKHR, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       streamPacked, attribute, value);

    return QueryStreamKHR(thread, dpyPacked, streamPacked, attribute, value);
}

EGLBoolean EGLAPIENTRY EGL_QueryStreamu64KHR(EGLDisplay dpy,
                                             EGLStreamKHR stream,
                                             EGLenum attribute,
                                             EGLuint64KHR *value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(QueryStreamu64KHR,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR
              ", attribute = 0x%X, value = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream, attribute, (uintptr_t)value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, QueryStreamu64KHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, streamPacked, attribute, value);

    return QueryStreamu64KHR(thread, dpyPacked, streamPacked, attribute, value);
}

EGLBoolean EGLAPIENTRY EGL_StreamAttribKHR(EGLDisplay dpy,
                                           EGLStreamKHR stream,
                                           EGLenum attribute,
                                           EGLint value)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamAttribKHR,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR ", attribute = 0x%X, value = %d",
              (uintptr_t)dpy, (uintptr_t)stream, attribute, value);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, StreamAttribKHR, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       streamPacked, attribute, value);

    return StreamAttribKHR(thread, dpyPacked, streamPacked, attribute, value);
}

// EGL_KHR_stream_consumer_gltexture
EGLBoolean EGLAPIENTRY EGL_StreamConsumerAcquireKHR(EGLDisplay dpy, EGLStreamKHR stream)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamConsumerAcquireKHR, "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, StreamConsumerAcquireKHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, streamPacked);

    return StreamConsumerAcquireKHR(thread, dpyPacked, streamPacked);
}

EGLBoolean EGLAPIENTRY EGL_StreamConsumerGLTextureExternalKHR(EGLDisplay dpy, EGLStreamKHR stream)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamConsumerGLTextureExternalKHR,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR "", (uintptr_t)dpy,
              (uintptr_t)stream);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, StreamConsumerGLTextureExternalKHR, GetDisplayIfValid(dpyPacked),
                       EGLBoolean, dpyPacked, streamPacked);

    return StreamConsumerGLTextureExternalKHR(thread, dpyPacked, streamPacked);
}

EGLBoolean EGLAPIENTRY EGL_StreamConsumerReleaseKHR(EGLDisplay dpy, EGLStreamKHR stream)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamConsumerReleaseKHR, "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR "",
              (uintptr_t)dpy, (uintptr_t)stream);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Stream *streamPacked    = PackParam<Stream *>(stream);

    ANGLE_EGL_VALIDATE(thread, StreamConsumerReleaseKHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, streamPacked);

    return StreamConsumerReleaseKHR(thread, dpyPacked, streamPacked);
}

// EGL_KHR_swap_buffers_with_damage
EGLBoolean EGLAPIENTRY EGL_SwapBuffersWithDamageKHR(EGLDisplay dpy,
                                                    EGLSurface surface,
                                                    const EGLint *rects,
                                                    EGLint n_rects)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(SwapBuffersWithDamageKHR,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR ", rects = 0x%016" PRIxPTR
              ", n_rects = %d",
              (uintptr_t)dpy, (uintptr_t)surface, (uintptr_t)rects, n_rects);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, SwapBuffersWithDamageKHR, GetDisplayIfValid(dpyPacked), EGLBoolean,
                       dpyPacked, surfacePacked, rects, n_rects);

    return SwapBuffersWithDamageKHR(thread, dpyPacked, surfacePacked, rects, n_rects);
}

// EGL_KHR_wait_sync
EGLint EGLAPIENTRY EGL_WaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(WaitSyncKHR, "dpy = 0x%016" PRIxPTR ", sync = 0x%016" PRIxPTR ", flags = %d",
              (uintptr_t)dpy, (uintptr_t)sync, flags);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Sync *syncPacked        = PackParam<Sync *>(sync);

    ANGLE_EGL_VALIDATE(thread, WaitSyncKHR, GetDisplayIfValid(dpyPacked), EGLint, dpyPacked,
                       syncPacked, flags);

    return WaitSyncKHR(thread, dpyPacked, syncPacked, flags);
}

// EGL_NV_post_sub_buffer
EGLBoolean EGLAPIENTRY EGL_PostSubBufferNV(EGLDisplay dpy,
                                           EGLSurface surface,
                                           EGLint x,
                                           EGLint y,
                                           EGLint width,
                                           EGLint height)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(PostSubBufferNV,
              "dpy = 0x%016" PRIxPTR ", surface = 0x%016" PRIxPTR
              ", x = %d, y = %d, width = %d, height = %d",
              (uintptr_t)dpy, (uintptr_t)surface, x, y, width, height);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked = PackParam<egl::Display *>(dpy);
    Surface *surfacePacked  = PackParam<Surface *>(surface);

    ANGLE_EGL_VALIDATE(thread, PostSubBufferNV, GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked,
                       surfacePacked, x, y, width, height);

    return PostSubBufferNV(thread, dpyPacked, surfacePacked, x, y, width, height);
}

// EGL_NV_stream_consumer_gltexture_yuv
EGLBoolean EGLAPIENTRY EGL_StreamConsumerGLTextureExternalAttribsNV(EGLDisplay dpy,
                                                                    EGLStreamKHR stream,
                                                                    const EGLAttrib *attrib_list)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EGL_EVENT(StreamConsumerGLTextureExternalAttribsNV,
              "dpy = 0x%016" PRIxPTR ", stream = 0x%016" PRIxPTR ", attrib_list = 0x%016" PRIxPTR
              "",
              (uintptr_t)dpy, (uintptr_t)stream, (uintptr_t)attrib_list);

    Thread *thread = egl::GetCurrentThread();

    egl::Display *dpyPacked               = PackParam<egl::Display *>(dpy);
    Stream *streamPacked                  = PackParam<Stream *>(stream);
    const AttributeMap &attrib_listPacked = PackParam<const AttributeMap &>(attrib_list);

    ANGLE_EGL_VALIDATE(thread, StreamConsumerGLTextureExternalAttribsNV,
                       GetDisplayIfValid(dpyPacked), EGLBoolean, dpyPacked, streamPacked,
                       attrib_listPacked);

    return StreamConsumerGLTextureExternalAttribsNV(thread, dpyPacked, streamPacked,
                                                    attrib_listPacked);
}

}  // extern "C"
