#include <gio/gio.h>

#include "unity-webapps-indicator-model-controller.h"

typedef struct _IndicatorModelTestFixture {
  UnityWebappsIndicatorModelController *controller;
  UnityWebappsIndicatorModel *indicator_model;

  UnityWebappsInterestManager *interest_manager;
} IndicatorModelTestFixture;


static void
setup_fixture (IndicatorModelTestFixture *fixture, gconstpointer user_data)
{
  fixture->indicator_model = unity_webapps_indicator_model_new ();
  fixture->interest_manager = unity_webapps_interest_manager_new ();
  
  fixture->controller = unity_webapps_indicator_model_controller_new (fixture->indicator_model,
								      fixture->interest_manager);
  
  g_assert (unity_webapps_indicator_model_controller_get_model (fixture->controller) == fixture->indicator_model);
  g_assert (unity_webapps_indicator_model_controller_get_interest_manager (fixture->controller) == fixture->interest_manager);
}

static gchar *
print_indicator_model (IndicatorModelTestFixture *fixture)
{
  GVariant *serialized_variant;
  gchar *serialized_string;
  
  serialized_variant = unity_webapps_indicator_model_serialize (fixture->indicator_model);
  serialized_string = g_variant_print (serialized_variant, FALSE);
  
  g_variant_unref (serialized_variant);
  return serialized_string;
}

static void
assert_indicator_model_equal (IndicatorModelTestFixture *fixture, const gchar *compare_to)
{
  gchar *serialized_model;
  
  serialized_model = print_indicator_model (fixture);
  
  g_assert_cmpstr(serialized_model, ==, compare_to);

  g_free (serialized_model);
}

#define MULTI_INTEREST_TEST1_SERIALIZED "([('Bar', 1, {}), ('Foo', 2, {})],)"
#define MULTI_INTEREST_TEST1_0_SERIALIZED "([('Foo', 1, {})],)"

static void
test_multi_interest_test1 (IndicatorModelTestFixture *fixture, gconstpointer user_data)
{
  gint interest_id2;

  unity_webapps_interest_manager_add_interest(fixture->interest_manager, "1");
  interest_id2 = unity_webapps_interest_manager_add_interest(fixture->interest_manager, "2");

  unity_webapps_indicator_model_show_indicator_for_interest (fixture->indicator_model,
							     "Foo", 1);
  unity_webapps_indicator_model_show_indicator_for_interest (fixture->indicator_model,
							     "Foo", 2);
  unity_webapps_indicator_model_show_indicator_for_interest (fixture->indicator_model,
							     "Bar", 2);
  assert_indicator_model_equal (fixture, MULTI_INTEREST_TEST1_SERIALIZED);
  
  unity_webapps_interest_manager_remove_interest (fixture->interest_manager, interest_id2, FALSE);

  assert_indicator_model_equal (fixture, MULTI_INTEREST_TEST1_0_SERIALIZED);
}

static void
test_properties (IndicatorModelTestFixture *fixture, gconstpointer user_data)
{
  UnityWebappsIndicatorModel *model;
  UnityWebappsInterestManager *manager;
  
  g_object_get (fixture->controller,
		"model", &model,
		"interest-manager", &manager,
		NULL);
  
  g_assert (model == fixture->indicator_model);
  g_assert (manager == fixture->interest_manager);
}

static void
teardown_fixture (IndicatorModelTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->indicator_model));
  g_object_unref (G_OBJECT (fixture->interest_manager));
  g_object_unref (G_OBJECT (fixture->controller));
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  g_test_add("/MultiInterest/Controller/Scenario1",IndicatorModelTestFixture, NULL,
	     setup_fixture, test_multi_interest_test1, teardown_fixture);
  g_test_add("/MultiInterest/Controller/Properties",IndicatorModelTestFixture, NULL,
	     setup_fixture, test_properties, teardown_fixture);
  
  return g_test_run ();
}
